#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
/*
 * LowLatency.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/IKnobCollection.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct LowLatencyWorkload : TestWorkload {
	static constexpr auto NAME = "LowLatency";

	double testDuration;
	double maxGRVLatency;
	double maxCommitLatency;
	double checkDelay;
	PerfIntCounter operations, retries;
	bool testWrites;
	Key testKey;
	bool ok;

	LowLatencyWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), operations("Operations"), retries("Retries"), ok(true) {
		testDuration = getOption(options, "testDuration"_sr, 600.0);
		maxGRVLatency = getOption(options, "maxGRVLatency"_sr, 20.0);
		maxCommitLatency = getOption(options, "maxCommitLatency"_sr, 30.0);
		checkDelay = getOption(options, "checkDelay"_sr, 1.0);
		testWrites = getOption(options, "testWrites"_sr, true);
		testKey = getOption(options, "testKey"_sr, "testKey"_sr);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("Attrition"); }

	Future<Void> setup(Database const& cx) override {
		if (g_network->isSimulated()) {
			IKnobCollection::getMutableGlobalKnobCollection().setKnob("min_delay_cc_worst_fit_candidacy_seconds",
			                                                          KnobValueRef::create(double{ 5.0 }));
			IKnobCollection::getMutableGlobalKnobCollection().setKnob("max_delay_cc_worst_fit_candidacy_seconds",
			                                                          KnobValueRef::create(double{ 10.0 }));
		}
		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return _start(cx, this);
		return Void();
	}

																#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
template <class _startActor>
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
class _startActorState {
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
public:
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	_startActorState(Database const& cx,LowLatencyWorkload* const& self) 
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		 : cx(cx),
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		   self(self),
															#line 70 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		   testStart(now())
															#line 88 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 72 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				;
															#line 104 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			TraceEvent(SevError, "LowLatencyError").errorUnsuppressed(e);
															#line 114 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 150 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(self->checkDelay);
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		tr = Transaction(cx);
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		operationStart = now();
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		doCommit = self->testWrites && deterministicRandom()->coinflip();
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		maxLatency = doCommit ? self->maxCommitLatency : self->maxGRVLatency;
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		++self->operations;
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		;
															#line 208 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 74 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		tr = Transaction(cx);
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		operationStart = now();
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		doCommit = self->testWrites && deterministicRandom()->coinflip();
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		maxLatency = doCommit ? self->maxCommitLatency : self->maxGRVLatency;
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		++self->operations;
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		;
															#line 227 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 101 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		if (now() - operationStart > maxLatency)
															#line 311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		{
															#line 102 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			TraceEvent(SevError, "LatencyTooLarge") .detail("MaxLatency", maxLatency) .detail("ObservedLatency", now() - operationStart) .detail("IsCommit", doCommit);
															#line 106 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			self->ok = false;
															#line 317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		}
															#line 108 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		if (now() - testStart > self->testDuration)
															#line 321 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			TraceEvent("LowLatencyTransactionStart").detail("Retries", self->retries.getValue());
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 83 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			if (doCommit)
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
			{
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				TraceEvent("LowLatencyTransactionCommitStart");
															#line 86 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				tr.set(self->testKey, ""_sr);
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 90 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				TraceEvent("LowLatencyTransactionGRVStart");
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				StrictFuture<Void> __when_expr_2 = success(tr.getReadVersion());
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 373 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			TraceEvent("LowLatencyTransactionFailed").errorUnsuppressed(e);
															#line 97 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 97 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 97 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 423 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		TraceEvent("LowLatencyTransactionCommitFinish");
															#line 444 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		TraceEvent("LowLatencyTransactionCommitFinish");
															#line 453 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		TraceEvent("LowLatencyTransactionGRVFinish");
															#line 537 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		TraceEvent("LowLatencyTransactionGRVFinish");
															#line 546 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 98 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		++self->retries;
															#line 630 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 98 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
		++self->retries;
															#line 639 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	Database cx;
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	LowLatencyWorkload* self;
															#line 70 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	double testStart;
															#line 74 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	Transaction tr;
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	double operationStart;
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	bool doCommit;
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	double maxLatency;
															#line 733 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 738 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4848039039369115904UL, 14748959801377374464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	_startActor(Database const& cx,LowLatencyWorkload* const& self) 
															#line 758 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, LowLatencyWorkload* const& self ) {
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 793 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LowLatency.actor.g.cpp.py_gen"
}

#line 117 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/LowLatency.actor.cpp"

	Future<bool> check(Database const& cx) override { return ok; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		double duration = testDuration;
		m.emplace_back("Operations/sec", operations.getValue() / duration, Averaged::False);
		m.push_back(operations.getMetric());
		m.push_back(retries.getMetric());
	}
};

WorkloadFactory<LowLatencyWorkload> LowLatencyWorkloadFactory;
