#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
/*
 * IndexScan.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct IndexScanWorkload : KVWorkload {
	constexpr static auto NAME = "IndexScan";
	uint64_t rowsRead, chunks;
	int bytesPerRead, failedTransactions, scans;
	double totalTimeFetching, testDuration, transactionDuration;
	bool singleProcess, readYourWrites;

	IndexScanWorkload(WorkloadContext const& wcx)
	  : KVWorkload(wcx), rowsRead(0), chunks(0), failedTransactions(0), scans(0) {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		bytesPerRead = getOption(options, "bytesPerRead"_sr, 80000);
		transactionDuration = getOption(options, "transactionDuration"_sr, 1.0);
		singleProcess = getOption(options, "singleProcess"_sr, true);
		readYourWrites = getOption(options, "readYourWrites"_sr, true);
	}

	Future<Void> setup(Database const& cx) override {
		// this will be set up by and external force!
		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (singleProcess && clientId != 0) {
			return Void();
		}
		return _start(cx, this);
	}

	Future<bool> check(const Database&) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		if (singleProcess && clientId != 0)
			return;

		m.emplace_back("FailedTransactions", failedTransactions, Averaged::False);
		m.emplace_back("RowsRead", rowsRead, Averaged::False);
		m.emplace_back("Scans", scans, Averaged::False);
		m.emplace_back("Chunks", chunks, Averaged::False);
		m.emplace_back("TimeFetching", totalTimeFetching, Averaged::True);
		m.emplace_back("Rows/sec", totalTimeFetching == 0 ? 0 : rowsRead / totalTimeFetching, Averaged::True);
		m.emplace_back("Rows/chunk", chunks == 0 ? 0 : rowsRead / (double)chunks, Averaged::True);
	}

																#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
template <class _startActor>
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
class _startActorState {
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
public:
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	_startActorState(Database const& cx,IndexScanWorkload* const& self) 
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		 : cx(cx),
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   self(self),
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   startTime(now())
															#line 90 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 74 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			;
															#line 105 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(std::max(0.1, 1.0 - (now() - startTime)));
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		tr = Transaction(cx);
															#line 151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		try {
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.warmRange(allKeys);
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 157 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 162 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 199 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 204 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		StrictFuture<Void> __when_expr_3 = timeout(serialScans(cx, self), self->testDuration, Void());
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 395 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 400 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		StrictFuture<Void> __when_expr_3 = timeout(serialScans(cx, self), self->testDuration, Void());
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 416 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	Database cx;
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	IndexScanWorkload* self;
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	double startTime;
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	Transaction tr;
															#line 603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 608 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4919566349850063360UL, 6228770789673898240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	_startActor(Database const& cx,IndexScanWorkload* const& self) 
															#line 628 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, IndexScanWorkload* const& self ) {
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
}

#line 90 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"

																#line 668 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
// This generated class is to be used only via serialScans()
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
template <class SerialScansActor>
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
class SerialScansActorState {
															#line 674 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
public:
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	SerialScansActorState(Database const& cx,IndexScanWorkload* const& self) 
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		 : cx(cx),
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   self(self),
															#line 92 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   start(now())
															#line 685 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("serialScans", reinterpret_cast<unsigned long>(this));

	}
	~SerialScansActorState() 
	{
		fdb_probe_actor_destroy("serialScans", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 94 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
				;
															#line 701 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SerialScansActorState();
		static_cast<SerialScansActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 98 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			self->totalTimeFetching = now() - start;
															#line 99 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			return a_body1Catch1(__current_error, loopDepth);
															#line 733 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 95 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		StrictFuture<Void> __when_expr_0 = scanDatabase(cx, self);
															#line 95 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (static_cast<SerialScansActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 756 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SerialScansActor*>(this)->actor_wait_state = 1;
															#line 95 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SerialScansActor, 0, Void >*>(static_cast<SerialScansActor*>(this)));
															#line 761 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SerialScansActor*>(this)->actor_wait_state > 0) static_cast<SerialScansActor*>(this)->actor_wait_state = 0;
		static_cast<SerialScansActor*>(this)->ActorCallback< SerialScansActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SerialScansActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serialScans", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SerialScansActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serialScans", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SerialScansActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serialScans", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SerialScansActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serialScans", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SerialScansActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serialScans", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SerialScansActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serialScans", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	Database cx;
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	IndexScanWorkload* self;
															#line 92 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	double start;
															#line 859 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via serialScans()
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
class SerialScansActor final : public Actor<Void>, public ActorCallback< SerialScansActor, 0, Void >, public FastAllocated<SerialScansActor>, public SerialScansActorState<SerialScansActor> {
															#line 864 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<SerialScansActor>::operator new;
	using FastAllocated<SerialScansActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7003175533159612160UL, 1018988518407395584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SerialScansActor, 0, Void >;
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	SerialScansActor(Database const& cx,IndexScanWorkload* const& self) 
															#line 881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SerialScansActorState<SerialScansActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serialScans", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2268935035833219328UL, 8006258661346916608UL);
		ActorExecutionContextHelper __helper(static_cast<SerialScansActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serialScans");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serialScans", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SerialScansActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
[[nodiscard]] static Future<Void> serialScans( Database const& cx, IndexScanWorkload* const& self ) {
															#line 91 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	return Future<Void>(new SerialScansActor(cx, self));
															#line 913 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
}

#line 102 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"

																#line 918 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
// This generated class is to be used only via scanDatabase()
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
template <class ScanDatabaseActor>
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
class ScanDatabaseActorState {
															#line 924 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
public:
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	ScanDatabaseActorState(Database const& cx,IndexScanWorkload* const& self) 
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		 : cx(cx),
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   self(self),
															#line 104 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   startNode(deterministicRandom()->randomInt(0, self->nodeCount / 2)),
															#line 106 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   begin(firstGreaterOrEqual(self->keyForIndex(startNode))),
															#line 107 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   end(firstGreaterThan(self->keyForIndex(self->nodeCount))),
															#line 108 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   limits(GetRangeLimits::ROW_LIMIT_UNLIMITED, self->bytesPerRead),
															#line 110 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   rowsRead(),
															#line 111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   chunks(),
															#line 112 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		   startTime()
															#line 947 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("scanDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ScanDatabaseActorState() 
	{
		fdb_probe_actor_destroy("scanDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			;
															#line 962 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ScanDatabaseActorState();
		static_cast<ScanDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 140 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		self->rowsRead += rowsRead;
															#line 141 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		self->chunks += chunks;
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		self->scans++;
															#line 143 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (!static_cast<ScanDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ScanDatabaseActorState(); static_cast<ScanDatabaseActor*>(this)->destroy(); return 0; }
															#line 991 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		new (&static_cast<ScanDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ScanDatabaseActorState();
		static_cast<ScanDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 114 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 115 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (!self->readYourWrites)
															#line 1012 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		{
															#line 116 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 1016 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		}
															#line 117 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		startTime = now();
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		rowsRead = 0;
															#line 119 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		chunks = 0;
															#line 1024 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		try {
															#line 122 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			;
															#line 1028 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 1063 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			{
															#line 135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
				++self->failedTransactions;
															#line 1067 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			}
															#line 136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			if (static_cast<ScanDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1073 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ScanDatabaseActor*>(this)->actor_wait_state = 2;
															#line 136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ScanDatabaseActor, 1, Void >*>(static_cast<ScanDatabaseActor*>(this)));
															#line 1078 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr.getRange(begin, end, limits);
															#line 123 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (static_cast<ScanDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1108 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ScanDatabaseActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ScanDatabaseActor, 0, RangeResult >*>(static_cast<ScanDatabaseActor*>(this)));
															#line 1113 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult const& r,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		chunks++;
															#line 125 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		rowsRead += r.size();
															#line 126 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (!r.size() || !r.more || (now() - startTime) > self->transactionDuration)
															#line 1139 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 129 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		begin = firstGreaterThan(r[r.size() - 1].key);
															#line 1145 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult && r,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		chunks++;
															#line 125 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		rowsRead += r.size();
															#line 126 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		if (!r.size() || !r.more || (now() - startTime) > self->transactionDuration)
															#line 1158 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 129 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
		begin = firstGreaterThan(r[r.size() - 1].key);
															#line 1164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(r, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ScanDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ScanDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ScanDatabaseActor*>(this)->ActorCallback< ScanDatabaseActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ScanDatabaseActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("scanDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ScanDatabaseActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("scanDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ScanDatabaseActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("scanDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ScanDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ScanDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ScanDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ScanDatabaseActor*>(this)->ActorCallback< ScanDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ScanDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("scanDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ScanDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("scanDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ScanDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ScanDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("scanDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ScanDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("scanDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	Database cx;
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	IndexScanWorkload* self;
															#line 104 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	int startNode;
															#line 106 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	KeySelector begin;
															#line 107 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	KeySelector end;
															#line 108 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	GetRangeLimits limits;
															#line 110 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	int rowsRead;
															#line 111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	int chunks;
															#line 112 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	double startTime;
															#line 114 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1351 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
};
// This generated class is to be used only via scanDatabase()
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
class ScanDatabaseActor final : public Actor<Void>, public ActorCallback< ScanDatabaseActor, 0, RangeResult >, public ActorCallback< ScanDatabaseActor, 1, Void >, public FastAllocated<ScanDatabaseActor>, public ScanDatabaseActorState<ScanDatabaseActor> {
															#line 1356 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
public:
	using FastAllocated<ScanDatabaseActor>::operator new;
	using FastAllocated<ScanDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6056464653116164352UL, 16891874446702484736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ScanDatabaseActor, 0, RangeResult >;
friend struct ActorCallback< ScanDatabaseActor, 1, Void >;
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	ScanDatabaseActor(Database const& cx,IndexScanWorkload* const& self) 
															#line 1374 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ScanDatabaseActorState<ScanDatabaseActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("scanDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(188310651404818944UL, 2394208757025574656UL);
		ActorExecutionContextHelper __helper(static_cast<ScanDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("scanDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("scanDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ScanDatabaseActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ScanDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
[[nodiscard]] static Future<Void> scanDatabase( Database const& cx, IndexScanWorkload* const& self ) {
															#line 103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
	return Future<Void>(new ScanDatabaseActor(cx, self));
															#line 1407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/IndexScan.actor.g.cpp.py_gen"
}

#line 145 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/IndexScan.actor.cpp"
};

WorkloadFactory<IndexScanWorkload> IndexScanWorkloadFactory;
