#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
/*
 * HealthMetricsApi.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// NOTE: it might be simpler to test health metrics via something
// other than simulation. Testing equivalent to what this workload does can
// seemingly be obtained by a straight line test case that does
// the following:
// a) start a cluster
// b) do a few transactions
// c) call getHealthMetrics()
// d) ensure the returned metrics are non-zero.

// This workload can be attached to other workload to collect health information about the FDB cluster.
struct HealthMetricsApiWorkload : TestWorkload {
	// Performance Metrics
	int64_t worstStorageQueue = 0;
	int64_t worstLimitingStorageQueue = 0;
	int64_t worstStorageDurabilityLag = 0;
	int64_t worstLimitingStorageDurabilityLag = 0;
	int64_t worstTLogQueue = 0;
	int64_t detailedWorstStorageQueue = 0;
	int64_t detailedWorstStorageDurabilityLag = 0;
	int64_t detailedWorstTLogQueue = 0;
	double detailedWorstCpuUsage = 0;
	double detailedWorstDiskUsage = 0;

	// Test configuration
	double testDuration;
	double healthMetricsCheckInterval;
	double maxAllowedStaleness;
	bool sendDetailedHealthMetrics;

	// internal states
	bool healthMetricsStoppedUpdating = false;
	bool gotMetrics = false;
	static constexpr auto NAME = "HealthMetricsApi";

	HealthMetricsApiWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		healthMetricsCheckInterval = getOption(options, "healthMetricsCheckInterval"_sr, 1.0);
		sendDetailedHealthMetrics = getOption(options, "sendDetailedHealthMetrics"_sr, true);
		maxAllowedStaleness = getOption(options, "maxAllowedStaleness"_sr, 60.0);
	}

																#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
template <class _setupActor>
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class _setupActorState {
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
public:
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	_setupActorState(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		 : cx(cx),
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   self(self)
															#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			if (!self->sendDetailedHealthMetrics)
															#line 99 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
			{
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(1 + CLIENT_KNOBS->DETAILED_HEALTH_METRICS_MAX_STALENESS);
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 105 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 110 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 138 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		cx->healthMetrics.storageStats.clear();
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		cx->healthMetrics.tLogQueue.clear();
															#line 152 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		cx->healthMetrics.storageStats.clear();
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		cx->healthMetrics.tLogQueue.clear();
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Database cx;
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsApiWorkload* self;
															#line 247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12903240488073036800UL, 15119283127565766656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	_setupActor(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, HealthMetricsApiWorkload* const& self ) {
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
}

#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }
																#line 306 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
template <class _startActor>
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class _startActorState {
															#line 312 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
public:
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	_startActorState(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		 : cx(cx),
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   self(self)
															#line 321 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(healthMetricsChecker(cx, self), self->testDuration, Void());
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 338 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 343 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 366 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Database cx;
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsApiWorkload* self;
															#line 465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 470 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15894766291769948416UL, 10887433188034041344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	_startActor(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 487 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, HealthMetricsApiWorkload* const& self ) {
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 519 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
}

#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override {
		if (!gotMetrics) {
			// It's not valid to fail a sanity check of metrics which have never been received.
			// Yes, this encodes a blatant "got" vs "have" usage error.  The intent is to show
			// up on any case insensitive search for "gotmetrics".
			TraceEvent("HealthMetricsCheckPassedBecauseWeDontGotMetrics");
			return true;
		}
		if (healthMetricsStoppedUpdating) {
			TraceEvent(SevError, "HealthMetricsStoppedUpdating").log();
			return false;
		}
		bool valid = true;
		if (worstStorageQueue == 0 || worstStorageDurabilityLag == 0 || worstTLogQueue == 0) {
			valid = false;
			TraceEvent("HealthMetrics:valid_false_case1");
		}
		if (sendDetailedHealthMetrics) {
			if (detailedWorstStorageQueue == 0 || detailedWorstStorageDurabilityLag == 0 ||
			    detailedWorstTLogQueue == 0 || detailedWorstCpuUsage == 0.0 || detailedWorstDiskUsage == 0.0) {
				valid = false;
				TraceEvent("HealthMetrics:valid_false_case2");
			}
		} else {
			if (detailedWorstStorageQueue != 0 || detailedWorstStorageDurabilityLag != 0 ||
			    detailedWorstTLogQueue != 0 || detailedWorstCpuUsage != 0.0 || detailedWorstDiskUsage != 0.0) {
				valid = false;
				TraceEvent("HealthMetrics:valid_false_case3");
			}
		}
		if (!valid) {
			TraceEvent(SevError, "IncorrectHealthMetricsState")
			    .detail("WorstStorageQueue", worstStorageQueue)
			    .detail("WorstLimitingStorageQueue", worstLimitingStorageQueue)
			    .detail("WorstStorageDurabilityLag", worstStorageDurabilityLag)
			    .detail("WorstLimitingStorageDurabilityLag", worstLimitingStorageDurabilityLag)
			    .detail("WorstTLogQueue", worstTLogQueue)
			    .detail("DetailedWorstStorageQueue", detailedWorstStorageQueue)
			    .detail("DetailedWorstStorageDurabilityLag", detailedWorstStorageDurabilityLag)
			    .detail("DetailedWorstTLogQueue", detailedWorstTLogQueue)
			    .detail("DetailedWorstCpuUsage", detailedWorstCpuUsage)
			    .detail("DetailedWorstDiskUsage", detailedWorstDiskUsage)
			    .detail("SendingDetailedHealthMetrics", sendDetailedHealthMetrics);
		}
		return valid;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("WorstStorageQueue", worstStorageQueue, Averaged::True);
		m.emplace_back("DetailedWorstStorageQueue", detailedWorstStorageQueue, Averaged::True);
		m.emplace_back("WorstStorageDurabilityLag", worstStorageDurabilityLag, Averaged::True);
		m.emplace_back("DetailedWorstStorageDurabilityLag", detailedWorstStorageDurabilityLag, Averaged::True);
		m.emplace_back("WorstTLogQueue", worstTLogQueue, Averaged::True);
		m.emplace_back("DetailedWorstTLogQueue", detailedWorstTLogQueue, Averaged::True);
		m.emplace_back("DetailedWorstCpuUsage", detailedWorstCpuUsage, Averaged::True);
		m.emplace_back("DetailedWorstDiskUsage", detailedWorstDiskUsage, Averaged::True);
	}

																#line 583 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
// This generated class is to be used only via healthMetricsChecker()
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
template <class HealthMetricsCheckerActor>
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class HealthMetricsCheckerActorState {
															#line 589 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
public:
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsCheckerActorState(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		 : cx(cx),
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   self(self),
															#line 143 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   repeated(0),
															#line 144 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   healthMetrics()
															#line 602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("healthMetricsChecker", reinterpret_cast<unsigned long>(this));

	}
	~HealthMetricsCheckerActorState() 
	{
		fdb_probe_actor_destroy("healthMetricsChecker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			;
															#line 617 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMetricsCheckerActorState();
		static_cast<HealthMetricsCheckerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 146 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(self->healthMetricsCheckInterval);
															#line 146 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 649 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 1;
															#line 146 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HealthMetricsCheckerActor, 0, Void >*>(static_cast<HealthMetricsCheckerActor*>(this)));
															#line 654 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		StrictFuture<HealthMetrics> __when_expr_1 = cx->getHealthMetrics(self->sendDetailedHealthMetrics);
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 665 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 2;
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*>(static_cast<HealthMetricsCheckerActor*>(this)));
															#line 670 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		StrictFuture<HealthMetrics> __when_expr_1 = cx->getHealthMetrics(self->sendDetailedHealthMetrics);
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 681 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 2;
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*>(static_cast<HealthMetricsCheckerActor*>(this)));
															#line 686 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state > 0) static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMetricsCheckerActor*>(this)->ActorCallback< HealthMetricsCheckerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMetricsCheckerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HealthMetricsCheckerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HealthMetricsCheckerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(HealthMetrics const& newHealthMetrics,int loopDepth) 
	{
															#line 148 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (healthMetrics == newHealthMetrics)
															#line 770 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		{
															#line 149 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			if (++repeated > self->maxAllowedStaleness / self->healthMetricsCheckInterval)
															#line 774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
			{
															#line 150 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				self->healthMetricsStoppedUpdating = true;
															#line 778 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 152 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			repeated = 0;
															#line 785 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		}
															#line 153 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		healthMetrics = newHealthMetrics;
															#line 155 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstStorageQueue = std::max(self->worstStorageQueue, healthMetrics.worstStorageQueue);
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstLimitingStorageQueue = std::max(self->worstLimitingStorageQueue, healthMetrics.limitingStorageQueue);
															#line 158 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstStorageDurabilityLag = std::max(self->worstStorageDurabilityLag, healthMetrics.worstStorageDurabilityLag);
															#line 160 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstLimitingStorageDurabilityLag = std::max(self->worstLimitingStorageDurabilityLag, healthMetrics.limitingStorageDurabilityLag);
															#line 162 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstTLogQueue = std::max(self->worstTLogQueue, healthMetrics.worstTLogQueue);
															#line 164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent("HealthMetrics") .detail("WorstStorageQueue", healthMetrics.worstStorageQueue) .detail("LimitingStorageQueue", healthMetrics.limitingStorageQueue) .detail("WorstStorageDurabilityLag", healthMetrics.worstStorageDurabilityLag) .detail("LimitingStorageDurabilityLag", healthMetrics.limitingStorageDurabilityLag) .detail("WorstTLogQueue", healthMetrics.worstTLogQueue) .detail("TpsLimit", healthMetrics.tpsLimit);
															#line 172 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceStorageQueue("StorageQueue");
															#line 173 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceStorageDurabilityLag("StorageDurabilityLag");
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceCpuUsage("CpuUsage");
															#line 175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceDiskUsage("DiskUsage");
															#line 177 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		bool gotStorageStats = false;
															#line 178 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		for( const auto& ss : healthMetrics.storageStats ) {
															#line 179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			gotStorageStats = true;
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			auto storageStats = ss.second;
															#line 181 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstStorageQueue = std::max(self->detailedWorstStorageQueue, storageStats.storageQueue);
															#line 182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceStorageQueue.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.storageQueue);
															#line 183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstStorageDurabilityLag = std::max(self->detailedWorstStorageDurabilityLag, storageStats.storageDurabilityLag);
															#line 185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceStorageDurabilityLag.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.storageDurabilityLag);
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstCpuUsage = std::max(self->detailedWorstCpuUsage, storageStats.cpuUsage);
															#line 188 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceCpuUsage.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.cpuUsage);
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstDiskUsage = std::max(self->detailedWorstDiskUsage, storageStats.diskUsage);
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceDiskUsage.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.diskUsage);
															#line 833 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		}
															#line 192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceTLogQueue("TLogQueue");
															#line 193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		traceTLogQueue.setMaxEventLength(10000);
															#line 194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		bool gotTLogQueue = false;
															#line 195 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		for( const auto& ss : healthMetrics.tLogQueue ) {
															#line 196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			gotTLogQueue = true;
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstTLogQueue = std::max(self->detailedWorstTLogQueue, ss.second);
															#line 198 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceTLogQueue.detail(format("TLog-%s", ss.first.toString().c_str()), ss.second);
															#line 849 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		}
															#line 200 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (!self->gotMetrics && gotStorageStats && gotTLogQueue)
															#line 853 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		{
															#line 201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			TraceEvent("HealthMetricsGotFullResult");
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->gotMetrics = true;
															#line 859 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(HealthMetrics && newHealthMetrics,int loopDepth) 
	{
															#line 148 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (healthMetrics == newHealthMetrics)
															#line 869 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		{
															#line 149 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			if (++repeated > self->maxAllowedStaleness / self->healthMetricsCheckInterval)
															#line 873 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
			{
															#line 150 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				self->healthMetricsStoppedUpdating = true;
															#line 877 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 152 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			repeated = 0;
															#line 884 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		}
															#line 153 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		healthMetrics = newHealthMetrics;
															#line 155 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstStorageQueue = std::max(self->worstStorageQueue, healthMetrics.worstStorageQueue);
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstLimitingStorageQueue = std::max(self->worstLimitingStorageQueue, healthMetrics.limitingStorageQueue);
															#line 158 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstStorageDurabilityLag = std::max(self->worstStorageDurabilityLag, healthMetrics.worstStorageDurabilityLag);
															#line 160 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstLimitingStorageDurabilityLag = std::max(self->worstLimitingStorageDurabilityLag, healthMetrics.limitingStorageDurabilityLag);
															#line 162 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstTLogQueue = std::max(self->worstTLogQueue, healthMetrics.worstTLogQueue);
															#line 164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent("HealthMetrics") .detail("WorstStorageQueue", healthMetrics.worstStorageQueue) .detail("LimitingStorageQueue", healthMetrics.limitingStorageQueue) .detail("WorstStorageDurabilityLag", healthMetrics.worstStorageDurabilityLag) .detail("LimitingStorageDurabilityLag", healthMetrics.limitingStorageDurabilityLag) .detail("WorstTLogQueue", healthMetrics.worstTLogQueue) .detail("TpsLimit", healthMetrics.tpsLimit);
															#line 172 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceStorageQueue("StorageQueue");
															#line 173 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceStorageDurabilityLag("StorageDurabilityLag");
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceCpuUsage("CpuUsage");
															#line 175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceDiskUsage("DiskUsage");
															#line 177 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		bool gotStorageStats = false;
															#line 178 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		for( const auto& ss : healthMetrics.storageStats ) {
															#line 179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			gotStorageStats = true;
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			auto storageStats = ss.second;
															#line 181 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstStorageQueue = std::max(self->detailedWorstStorageQueue, storageStats.storageQueue);
															#line 182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceStorageQueue.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.storageQueue);
															#line 183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstStorageDurabilityLag = std::max(self->detailedWorstStorageDurabilityLag, storageStats.storageDurabilityLag);
															#line 185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceStorageDurabilityLag.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.storageDurabilityLag);
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstCpuUsage = std::max(self->detailedWorstCpuUsage, storageStats.cpuUsage);
															#line 188 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceCpuUsage.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.cpuUsage);
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstDiskUsage = std::max(self->detailedWorstDiskUsage, storageStats.diskUsage);
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceDiskUsage.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.diskUsage);
															#line 932 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		}
															#line 192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceTLogQueue("TLogQueue");
															#line 193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		traceTLogQueue.setMaxEventLength(10000);
															#line 194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		bool gotTLogQueue = false;
															#line 195 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		for( const auto& ss : healthMetrics.tLogQueue ) {
															#line 196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			gotTLogQueue = true;
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstTLogQueue = std::max(self->detailedWorstTLogQueue, ss.second);
															#line 198 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceTLogQueue.detail(format("TLog-%s", ss.first.toString().c_str()), ss.second);
															#line 948 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		}
															#line 200 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (!self->gotMetrics && gotStorageStats && gotTLogQueue)
															#line 952 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		{
															#line 201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			TraceEvent("HealthMetricsGotFullResult");
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->gotMetrics = true;
															#line 958 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(HealthMetrics const& newHealthMetrics,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(newHealthMetrics, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(HealthMetrics && newHealthMetrics,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(newHealthMetrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state > 0) static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMetricsCheckerActor*>(this)->ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*,HealthMetrics const& value) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*,HealthMetrics && value) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*,Error err) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Database cx;
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsApiWorkload* self;
															#line 143 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	int repeated;
															#line 144 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetrics healthMetrics;
															#line 1047 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
};
// This generated class is to be used only via healthMetricsChecker()
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class HealthMetricsCheckerActor final : public Actor<Void>, public ActorCallback< HealthMetricsCheckerActor, 0, Void >, public ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >, public FastAllocated<HealthMetricsCheckerActor>, public HealthMetricsCheckerActorState<HealthMetricsCheckerActor> {
															#line 1052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
public:
	using FastAllocated<HealthMetricsCheckerActor>::operator new;
	using FastAllocated<HealthMetricsCheckerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9779246004418230784UL, 6269209501196270592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HealthMetricsCheckerActor, 0, Void >;
friend struct ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >;
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsCheckerActor(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 1070 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HealthMetricsCheckerActorState<HealthMetricsCheckerActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1752804974711321856UL, 5960329134305098496UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMetricsChecker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HealthMetricsCheckerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
[[nodiscard]] static Future<Void> healthMetricsChecker( Database const& cx, HealthMetricsApiWorkload* const& self ) {
															#line 142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	return Future<Void>(new HealthMetricsCheckerActor(cx, self));
															#line 1103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp.py_gen"
}

#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
};
WorkloadFactory<HealthMetricsApiWorkload> HealthMetricsApiWorkloadFactory;
