#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
/*
 * DDMetricsExclude.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbclient/StatusClient.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct DDMetricsExcludeWorkload : TestWorkload {
	static constexpr auto NAME = "DDMetricsExclude";
	double ddDone;
	Value excludeIp;
	int excludePort;
	double peakMovingData;
	double peakInQueue;
	double peakInFlight;
	double movingDataPerSec;

	DDMetricsExcludeWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), ddDone(0.0), peakMovingData(0.0), peakInQueue(0.0), peakInFlight(0.0),
	    movingDataPerSec(0.0) {
		excludeIp = getOption(options, "excludeIp"_sr, Value("127.0.0.1"_sr));
		excludePort = getOption(options, "excludePort"_sr, 4500);
	}

	static Value getRandomValue() {
		return Standalone<StringRef>(format("Value/%080d", deterministicRandom()->randomInt(0, 10e6)));
	}

																#line 52 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
// This generated class is to be used only via getMovingDataAmount()
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
template <class GetMovingDataAmountActor>
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
class GetMovingDataAmountActorState {
															#line 58 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
public:
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	GetMovingDataAmountActorState(Database const& cx,DDMetricsExcludeWorkload* const& self) 
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		 : cx(cx),
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		   self(self)
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getMovingDataAmount", reinterpret_cast<unsigned long>(this));

	}
	~GetMovingDataAmountActorState() 
	{
		fdb_probe_actor_destroy("getMovingDataAmount", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 52 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(cx);
															#line 52 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				if (static_cast<GetMovingDataAmountActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetMovingDataAmountActor*>(this)->actor_wait_state = 1;
															#line 52 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMovingDataAmountActor, 0, StatusObject >*>(static_cast<GetMovingDataAmountActor*>(this)));
															#line 90 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMovingDataAmountActorState();
		static_cast<GetMovingDataAmountActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (!static_cast<GetMovingDataAmountActor*>(this)->SAV<double>::futures) { (void)(-1.0); this->~GetMovingDataAmountActorState(); static_cast<GetMovingDataAmountActor*>(this)->destroy(); return 0; }
															#line 119 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		new (&static_cast<GetMovingDataAmountActor*>(this)->SAV< double >::value()) double(-1.0);
		this->~GetMovingDataAmountActorState();
		static_cast<GetMovingDataAmountActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			TraceEvent("DDMetricsExcludeGetMovingDataError").error(e);
															#line 68 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 134 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(StatusObject const& statusObj,int loopDepth) 
	{
															#line 53 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 54 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		((StatusObjectReader)statusObj).get("cluster", statusObjCluster);
															#line 55 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		StatusObjectReader statusObjData;
															#line 56 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		statusObjCluster.get("data", statusObjData);
															#line 57 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (statusObjData.has("moving_data"))
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		{
															#line 58 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			StatusObjectReader movingData = statusObjData.last();
															#line 59 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			double dataInQueue, dataInFlight;
															#line 60 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			if (movingData.get("in_queue_bytes", dataInQueue) && movingData.get("in_flight_bytes", dataInFlight))
															#line 164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
			{
															#line 61 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				self->peakInQueue = std::max(self->peakInQueue, dataInQueue);
															#line 62 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				self->peakInFlight = std::max(self->peakInFlight, dataInFlight);
															#line 63 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				if (!static_cast<GetMovingDataAmountActor*>(this)->SAV<double>::futures) { (void)(dataInQueue + dataInFlight); this->~GetMovingDataAmountActorState(); static_cast<GetMovingDataAmountActor*>(this)->destroy(); return 0; }
															#line 172 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
				new (&static_cast<GetMovingDataAmountActor*>(this)->SAV< double >::value()) double(dataInQueue + dataInFlight);
				this->~GetMovingDataAmountActorState();
				static_cast<GetMovingDataAmountActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(StatusObject && statusObj,int loopDepth) 
	{
															#line 53 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 54 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		((StatusObjectReader)statusObj).get("cluster", statusObjCluster);
															#line 55 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		StatusObjectReader statusObjData;
															#line 56 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		statusObjCluster.get("data", statusObjData);
															#line 57 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (statusObjData.has("moving_data"))
															#line 195 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		{
															#line 58 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			StatusObjectReader movingData = statusObjData.last();
															#line 59 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			double dataInQueue, dataInFlight;
															#line 60 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			if (movingData.get("in_queue_bytes", dataInQueue) && movingData.get("in_flight_bytes", dataInFlight))
															#line 203 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
			{
															#line 61 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				self->peakInQueue = std::max(self->peakInQueue, dataInQueue);
															#line 62 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				self->peakInFlight = std::max(self->peakInFlight, dataInFlight);
															#line 63 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				if (!static_cast<GetMovingDataAmountActor*>(this)->SAV<double>::futures) { (void)(dataInQueue + dataInFlight); this->~GetMovingDataAmountActorState(); static_cast<GetMovingDataAmountActor*>(this)->destroy(); return 0; }
															#line 211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
				new (&static_cast<GetMovingDataAmountActor*>(this)->SAV< double >::value()) double(dataInQueue + dataInFlight);
				this->~GetMovingDataAmountActorState();
				static_cast<GetMovingDataAmountActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject const& statusObj,int loopDepth) 
	{
		loopDepth = a_body1cont2(statusObj, loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject && statusObj,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(statusObj), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMovingDataAmountActor*>(this)->actor_wait_state > 0) static_cast<GetMovingDataAmountActor*>(this)->actor_wait_state = 0;
		static_cast<GetMovingDataAmountActor*>(this)->ActorCallback< GetMovingDataAmountActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< GetMovingDataAmountActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("getMovingDataAmount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMovingDataAmountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMovingDataAmount", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMovingDataAmountActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("getMovingDataAmount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMovingDataAmountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMovingDataAmount", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMovingDataAmountActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("getMovingDataAmount", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMovingDataAmountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMovingDataAmount", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	Database cx;
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	DDMetricsExcludeWorkload* self;
															#line 314 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getMovingDataAmount()
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
class GetMovingDataAmountActor final : public Actor<double>, public ActorCallback< GetMovingDataAmountActor, 0, StatusObject >, public FastAllocated<GetMovingDataAmountActor>, public GetMovingDataAmountActorState<GetMovingDataAmountActor> {
															#line 319 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetMovingDataAmountActor>::operator new;
	using FastAllocated<GetMovingDataAmountActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11214857679538349568UL, 11038695101863326720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMovingDataAmountActor, 0, StatusObject >;
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	GetMovingDataAmountActor(Database const& cx,DDMetricsExcludeWorkload* const& self) 
															#line 336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		 : Actor<double>(),
		   GetMovingDataAmountActorState<GetMovingDataAmountActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMovingDataAmount", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(267783544415457792UL, 9106751047316103680UL);
		ActorExecutionContextHelper __helper(static_cast<GetMovingDataAmountActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMovingDataAmount");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMovingDataAmount", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMovingDataAmountActor, 0, StatusObject >*)0, actor_cancelled()); break;
		}

	}
};
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
[[nodiscard]] static Future<double> getMovingDataAmount( Database const& cx, DDMetricsExcludeWorkload* const& self ) {
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	return Future<double>(new GetMovingDataAmountActor(cx, self));
															#line 368 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
}

#line 72 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"

																#line 373 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
template <class _startActor>
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
class _startActorState {
															#line 379 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
public:
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	_startActorState(Database const& cx,DDMetricsExcludeWorkload* const& self) 
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		 : cx(cx),
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		   self(self)
															#line 388 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				excluded = std::vector<AddressExclusion>();
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				excluded.push_back(AddressExclusion(IPAddress::parse(self->excludeIp.toString()).get(), self->excludePort));
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				StrictFuture<Void> __when_expr_0 = excludeServers(cx, excluded);
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 410 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 92 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 444 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			TraceEvent("DDMetricsExcludeError").error(e);
															#line 457 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		startTime = now();
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		;
															#line 474 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		startTime = now();
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		;
															#line 485 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(2.5);
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 578 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 583 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		StrictFuture<double> __when_expr_2 = self->getMovingDataAmount(cx, self);
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 594 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, double >*>(static_cast<_startActor*>(this)));
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		StrictFuture<double> __when_expr_2 = self->getMovingDataAmount(cx, self);
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 610 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, double >*>(static_cast<_startActor*>(this)));
															#line 615 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont2(double const& movingData,int loopDepth) 
	{
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		self->peakMovingData = std::max(self->peakMovingData, movingData);
															#line 83 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		TraceEvent("DDMetricsExcludeCheck").detail("MovingData", movingData);
															#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (movingData == 0.0)
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		{
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			self->ddDone = now() - startTime;
															#line 86 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 709 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(double && movingData,int loopDepth) 
	{
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		self->peakMovingData = std::max(self->peakMovingData, movingData);
															#line 83 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		TraceEvent("DDMetricsExcludeCheck").detail("MovingData", movingData);
															#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
		if (movingData == 0.0)
															#line 727 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		{
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			self->ddDone = now() - startTime;
															#line 86 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 733 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(double const& movingData,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(movingData, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(double && movingData,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(movingData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, double >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, double >*,double const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, double >*,double && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, double >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	Database cx;
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	DDMetricsExcludeWorkload* self;
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	std::vector<AddressExclusion> excluded;
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	double startTime;
															#line 826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, double >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 831 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9279518712137943296UL, 12373818465937830656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, double >;
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	_startActor(Database const& cx,DDMetricsExcludeWorkload* const& self) 
															#line 850 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, double >*)0, actor_cancelled()); break;
		}

	}
};
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, DDMetricsExcludeWorkload* const& self ) {
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 884 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DDMetricsExclude.actor.g.cpp.py_gen"
}

#line 94 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/DDMetricsExclude.actor.cpp"

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }
	Future<bool> check(Database const& cx) override {
		movingDataPerSec = peakMovingData / ddDone;
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("peakMovingData", peakMovingData, Averaged::False);
		m.emplace_back("peakInQueue", peakInQueue, Averaged::False);
		m.emplace_back("peakInFlight", peakInFlight, Averaged::False);
		m.emplace_back("DDDuration", ddDone, Averaged::False);
		m.emplace_back("movingDataPerSec", movingDataPerSec, Averaged::False);
	}
};

WorkloadFactory<DDMetricsExcludeWorkload> DDMetricsExcludeWorkloadFactory;
