#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
/*
 * BackupCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// TODO: explain the purpose of this workload and how it different from the
// 20+ (literally) other backup/restore workloads.

// A workload which test the correctness of backup and restore process
struct BackupAndRestoreCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "BackupAndRestoreCorrectness";
	double backupAfter, restoreAfter, abortAndRestartAfter;
	double minBackupAfter;
	double backupStartAt, restoreStartAfterBackupFinished, stopDifferentialAfter;
	Key backupTag;
	int backupRangesCount, backupRangeLengthMax;
	bool differentialBackup, performRestore, agentRequest;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	std::vector<KeyRange> skippedRestoreRanges;
	Standalone<VectorRef<KeyRangeRef>> restoreRanges;
	static int backupAgentRequests;
	LockDB locked{ false };
	bool allowPauses;
	bool shareLogRange;
	bool shouldSkipRestoreRanges;
	bool defaultBackup;
	Optional<std::string> encryptionKeyFileName;

	// This workload is not compatible with RandomRangeLock workload because they will race in locked range
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	BackupAndRestoreCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		locked.set(sharedRandomNumber % 2);
		backupAfter = getOption(options, "backupAfter"_sr, 10.0);
		double minBackupAfter = getOption(options, "minBackupAfter"_sr, backupAfter);
		if (backupAfter > minBackupAfter) {
			backupAfter = deterministicRandom()->random01() * (backupAfter - minBackupAfter) + minBackupAfter;
		}
		restoreAfter = getOption(options, "restoreAfter"_sr, 35.0);
		performRestore = getOption(options, "performRestore"_sr, true);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		backupRangesCount = getOption(options, "backupRangesCount"_sr, 5);
		backupRangeLengthMax = getOption(options, "backupRangeLengthMax"_sr, 1);
		abortAndRestartAfter =
		    getOption(options,
		              "abortAndRestartAfter"_sr,
		              deterministicRandom()->random01() < 0.5
		                  ? deterministicRandom()->random01() * (restoreAfter - backupAfter) + backupAfter
		                  : 0.0);
		differentialBackup =
		    getOption(options, "differentialBackup"_sr, deterministicRandom()->random01() < 0.5 ? true : false);
		stopDifferentialAfter =
		    getOption(options,
		              "stopDifferentialAfter"_sr,
		              differentialBackup ? deterministicRandom()->random01() *
		                                           (restoreAfter - std::max(abortAndRestartAfter, backupAfter)) +
		                                       std::max(abortAndRestartAfter, backupAfter)
		                                 : 0.0);
		agentRequest = getOption(options, "simBackupAgents"_sr, true);
		allowPauses = getOption(options, "allowPauses"_sr, true);
		shareLogRange = getOption(options, "shareLogRange"_sr, false);
		defaultBackup = getOption(options, "defaultBackup"_sr, false);

		std::vector<std::string> restorePrefixesToInclude =
		    getOption(options, "restorePrefixesToInclude"_sr, std::vector<std::string>());

		shouldSkipRestoreRanges = deterministicRandom()->random01() < 0.3 ? true : false;
		if (getOption(options, "encrypted"_sr, deterministicRandom()->random01() < 0.5)) {
			encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
		}

		TraceEvent("BARW_ClientId").detail("Id", wcx.clientId);
		UID randomID = nondeterministicRandom()->randomUniqueID();
		TraceEvent("BARW_PerformRestore", randomID).detail("Value", performRestore);
		if (defaultBackup) {
			addDefaultBackupRanges(backupRanges);
		} else if (shareLogRange) {
			bool beforePrefix = sharedRandomNumber & 1;
			if (beforePrefix)
				backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef(normalKeys.begin, "\xfe\xff\xfe"_sr));
			else
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(strinc("\x00\x00\x01"_sr), normalKeys.end));
		} else if (backupRangesCount <= 0) {
			backupRanges.push_back_deep(backupRanges.arena(), normalKeys);
		} else {
			// Add backup ranges
			std::set<std::string> rangeEndpoints;
			while (rangeEndpoints.size() < backupRangesCount * 2) {
				rangeEndpoints.insert(deterministicRandom()->randomAlphaNumeric(
				    deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));
			}

			// Create ranges from the keys, in order, to prevent overlaps
			std::vector<std::string> sortedEndpoints(rangeEndpoints.begin(), rangeEndpoints.end());
			sort(sortedEndpoints.begin(), sortedEndpoints.end());
			for (auto i = sortedEndpoints.begin(); i != sortedEndpoints.end(); ++i) {
				const std::string& start = *i++;
				backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef(start, *i));

				// Track the added range
				TraceEvent("BARW_BackupCorrectnessRange", randomID).detail("RangeBegin", start).detail("RangeEnd", *i);
			}
		}

		if (performRestore && !restorePrefixesToInclude.empty() && shouldSkipRestoreRanges) {
			for (auto& range : backupRanges) {
				bool intersection = false;
				for (auto& prefix : restorePrefixesToInclude) {
					KeyRange prefixRange(KeyRangeRef(prefix, strinc(prefix)));
					if (range.intersects(prefixRange)) {
						intersection = true;
					}
					TraceEvent("BARW_PrefixSkipRangeDetails")
					    .detail("PrefixMandatory", printable(prefix))
					    .detail("BackupRange", printable(range))
					    .detail("Intersection", intersection);
				}
				// If the backup range intersects with restorePrefixesToInclude or a coin flip is true then use it as a
				// restore range as well, otherwise skip it.
				if (intersection || deterministicRandom()->coinflip()) {
					restoreRanges.push_back_deep(restoreRanges.arena(), range);
				} else {
					skippedRestoreRanges.push_back(range);
				}
			}
		} else {
			restoreRanges = backupRanges;
		}

		// If no random backup ranges intersected with restorePrefixesToInclude or won the coin flip then restoreRanges
		// will be empty, so move an item from skippedRestoreRanges to restoreRanges.
		if (restoreRanges.empty()) {
			ASSERT(!skippedRestoreRanges.empty());
			restoreRanges.push_back_deep(restoreRanges.arena(), skippedRestoreRanges.back());
			skippedRestoreRanges.pop_back();
		}

		for (auto& range : restoreRanges) {
			TraceEvent("BARW_RestoreRange", randomID)
			    .detail("RangeBegin", printable(range.begin))
			    .detail("RangeEnd", printable(range.end));
		}
		for (auto& range : skippedRestoreRanges) {
			TraceEvent("BARW_SkipRange", randomID)
			    .detail("RangeBegin", printable(range.begin))
			    .detail("RangeEnd", printable(range.end));
		}
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId != 0) {
			return Void();
		}

		return _setup(cx, this);
	}

																#line 191 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
template <class _setupActor>
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class _setupActorState {
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	_setupActorState(Database const& cx,BackupAndRestoreCorrectnessWorkload* const& self) 
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		 : cx(cx),
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   self(self)
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 221 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 191 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				for( auto r : getSystemBackupRanges() ) {
															#line 192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					self->backupRanges.push_back_deep(self->backupRanges.arena(), r);
															#line 227 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
															#line 194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				for( auto r : getSystemBackupRanges() ) {
															#line 195 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					self->restoreRanges.push_back_deep(self->restoreRanges.arena(), r);
															#line 233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
			}
															#line 199 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_setupActorState();
			static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Database cx;
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	BackupAndRestoreCorrectnessWorkload* self;
															#line 264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class _setupActor final : public Actor<Void>, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14848159283009641216UL, 14328398416982576896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	_setupActor(Database const& cx,BackupAndRestoreCorrectnessWorkload* const& self) 
															#line 285 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, BackupAndRestoreCorrectnessWorkload* const& self ) {
															#line 189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
}

#line 201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();

		TraceEvent(SevInfo, "BARW_Param").detail("Locked", locked);
		TraceEvent(SevInfo, "BARW_Param").detail("BackupAfter", backupAfter);
		TraceEvent(SevInfo, "BARW_Param").detail("RestoreAfter", restoreAfter);
		TraceEvent(SevInfo, "BARW_Param").detail("PerformRestore", performRestore);
		TraceEvent(SevInfo, "BARW_Param").detail("BackupTag", printable(backupTag).c_str());
		TraceEvent(SevInfo, "BARW_Param").detail("BackupRangesCount", backupRangesCount);
		TraceEvent(SevInfo, "BARW_Param").detail("BackupRangeLengthMax", backupRangeLengthMax);
		TraceEvent(SevInfo, "BARW_Param").detail("AbortAndRestartAfter", abortAndRestartAfter);
		TraceEvent(SevInfo, "BARW_Param").detail("DifferentialBackup", differentialBackup);
		TraceEvent(SevInfo, "BARW_Param").detail("StopDifferentialAfter", stopDifferentialAfter);
		TraceEvent(SevInfo, "BARW_Param").detail("AgentRequest", agentRequest);
		TraceEvent(SevInfo, "BARW_Param").detail("Encrypted", encryptionKeyFileName.present());

		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override {
		if (clientId != 0)
			return true;
		else
			return _check(cx, this);
	}

																#line 348 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
template <class _checkActor>
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class _checkActorState {
															#line 354 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	_checkActorState(Database const& cx,BackupAndRestoreCorrectnessWorkload* const& self) 
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		 : cx(cx),
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   self(self),
															#line 230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   tr(cx)
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			;
															#line 380 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 403 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			restoreIndex = int();
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			restoreIndex = 0;
															#line 425 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 245 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 245 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 462 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 245 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 467 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!(restoreIndex < self->skippedRestoreRanges.size()))
															#line 495 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 235 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		range = self->skippedRestoreRanges[restoreIndex];
															#line 236 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		Standalone<StringRef> restoreTag(self->backupTag.toString() + "_" + std::to_string(restoreIndex));
															#line 237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr.getRange(range, GetRangeLimits::ROW_LIMIT_UNLIMITED);
															#line 237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 507 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, RangeResult >*>(static_cast<_checkActor*>(this)));
															#line 512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!res.empty())
															#line 534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 239 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BARW_UnexpectedRangePresent").detail("Range", printable(range));
															#line 240 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 540 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreIndex++;
															#line 548 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult && res,int loopDepth) 
	{
															#line 238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!res.empty())
															#line 557 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 239 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BARW_UnexpectedRangePresent").detail("Range", printable(range));
															#line 240 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreIndex++;
															#line 571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Database cx;
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	BackupAndRestoreCorrectnessWorkload* self;
															#line 230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Transaction tr;
															#line 233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	int restoreIndex;
															#line 235 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	KeyRangeRef range;
															#line 748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, RangeResult >, public ActorCallback< _checkActor, 1, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 753 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5100824829696691968UL, 13510117585190749440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, RangeResult >;
friend struct ActorCallback< _checkActor, 1, Void >;
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	_checkActor(Database const& cx,BackupAndRestoreCorrectnessWorkload* const& self) 
															#line 771 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, BackupAndRestoreCorrectnessWorkload* const& self ) {
															#line 229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 804 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
}

#line 250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 811 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via changePaused()
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
template <class ChangePausedActor>
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class ChangePausedActorState {
															#line 817 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	ChangePausedActorState(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		 : cx(cx),
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   backupAgent(backupAgent)
															#line 826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("changePaused", reinterpret_cast<unsigned long>(this));

	}
	~ChangePausedActorState() 
	{
		fdb_probe_actor_destroy("changePaused", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 254 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			;
															#line 841 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangePausedActorState();
		static_cast<ChangePausedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_0 = backupAgent->changePause(cx, true);
															#line 255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 873 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 1;
															#line 255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 0, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 878 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 889 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 894 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30 * deterministicRandom()->random01());
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 905 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 2;
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 1, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 910 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 996 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 1001 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->changePause(cx, false);
															#line 257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1012 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 3;
															#line 257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 2, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 1017 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 1108 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(120 * deterministicRandom()->random01());
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1119 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangePausedActor*>(this)->actor_wait_state = 4;
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangePausedActor, 3, Void >*>(static_cast<ChangePausedActor*>(this)));
															#line 1124 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangePausedActor*>(this)->actor_wait_state > 0) static_cast<ChangePausedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangePausedActor*>(this)->ActorCallback< ChangePausedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangePausedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangePausedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Database cx;
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 1295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via changePaused()
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class ChangePausedActor final : public Actor<Void>, public ActorCallback< ChangePausedActor, 0, Void >, public ActorCallback< ChangePausedActor, 1, Void >, public ActorCallback< ChangePausedActor, 2, Void >, public ActorCallback< ChangePausedActor, 3, Void >, public FastAllocated<ChangePausedActor>, public ChangePausedActorState<ChangePausedActor> {
															#line 1300 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChangePausedActor>::operator new;
	using FastAllocated<ChangePausedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14388704956573746944UL, 483802151055562752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangePausedActor, 0, Void >;
friend struct ActorCallback< ChangePausedActor, 1, Void >;
friend struct ActorCallback< ChangePausedActor, 2, Void >;
friend struct ActorCallback< ChangePausedActor, 3, Void >;
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	ChangePausedActor(Database const& cx,FileBackupAgent* const& backupAgent) 
															#line 1320 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ChangePausedActorState<ChangePausedActor>(cx, backupAgent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changePaused", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5431177707453768448UL, 12966551901980677120UL);
		ActorExecutionContextHelper __helper(static_cast<ChangePausedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changePaused");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changePaused", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangePausedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangePausedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangePausedActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangePausedActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> changePaused( Database const& cx, FileBackupAgent* const& backupAgent ) {
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	return Future<Void>(new ChangePausedActor(cx, backupAgent));
															#line 1355 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
}

#line 261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"

																#line 1360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via statusLoop()
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
template <class StatusLoopActor>
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class StatusLoopActorState {
															#line 1366 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	StatusLoopActorState(Database const& cx,std::string const& tag) 
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		 : cx(cx),
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   tag(tag),
															#line 263 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   agent()
															#line 1377 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	~StatusLoopActorState() 
	{
		fdb_probe_actor_destroy("statusLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			;
															#line 1392 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusLoopActorState();
		static_cast<StatusLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<bool> __when_expr_0 = agent.checkActive(cx);
															#line 265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1424 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 1;
															#line 265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 0, bool >*>(static_cast<StatusLoopActor*>(this)));
															#line 1429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& active,int loopDepth) 
	{
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_AgentActivityCheck").detail("IsActive", active);
															#line 267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && active,int loopDepth) 
	{
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_AgentActivityCheck").detail("IsActive", active);
															#line 267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = agent.getStatus(cx, ShowErrors::True, tag);
															#line 267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1460 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 2;
															#line 267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 1, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& active,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(active, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && active,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(active), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(std::string const& status,int loopDepth) 
	{
															#line 268 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		puts(status.c_str());
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = agent.getStatusJSON(cx, tag);
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1553 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 3;
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 2, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1558 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::string && status,int loopDepth) 
	{
															#line 268 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		puts(status.c_str());
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = agent.getStatusJSON(cx, tag);
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 3;
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 2, std::string >*>(static_cast<StatusLoopActor*>(this)));
															#line 1576 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string const& status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string && status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(std::string const& statusJSON,int loopDepth) 
	{
															#line 270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		puts(statusJSON.c_str());
															#line 271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 4;
															#line 271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 3, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 1669 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && statusJSON,int loopDepth) 
	{
															#line 270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		puts(statusJSON.c_str());
															#line 271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1682 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusLoopActor*>(this)->actor_wait_state = 4;
															#line 271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusLoopActor, 3, Void >*>(static_cast<StatusLoopActor*>(this)));
															#line 1687 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string const& statusJSON,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(statusJSON, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string && statusJSON,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(statusJSON), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusLoopActor*>(this)->actor_wait_state > 0) static_cast<StatusLoopActor*>(this)->actor_wait_state = 0;
		static_cast<StatusLoopActor*>(this)->ActorCallback< StatusLoopActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusLoopActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusLoopActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Database cx;
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	std::string tag;
															#line 263 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	FileBackupAgent agent;
															#line 1860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via statusLoop()
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class StatusLoopActor final : public Actor<Void>, public ActorCallback< StatusLoopActor, 0, bool >, public ActorCallback< StatusLoopActor, 1, std::string >, public ActorCallback< StatusLoopActor, 2, std::string >, public ActorCallback< StatusLoopActor, 3, Void >, public FastAllocated<StatusLoopActor>, public StatusLoopActorState<StatusLoopActor> {
															#line 1865 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<StatusLoopActor>::operator new;
	using FastAllocated<StatusLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13785996943986881024UL, 15577449201653037568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StatusLoopActor, 0, bool >;
friend struct ActorCallback< StatusLoopActor, 1, std::string >;
friend struct ActorCallback< StatusLoopActor, 2, std::string >;
friend struct ActorCallback< StatusLoopActor, 3, Void >;
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	StatusLoopActor(Database const& cx,std::string const& tag) 
															#line 1885 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StatusLoopActorState<StatusLoopActor>(cx, tag),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1858547908313483776UL, 2242404897950274816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StatusLoopActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusLoopActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusLoopActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusLoopActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> statusLoop( Database const& cx, std::string const& tag ) {
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	return Future<Void>(new StatusLoopActor(cx, tag));
															#line 1920 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
}

#line 274 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"

																#line 1925 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via doBackup()
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
template <class DoBackupActor>
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class DoBackupActorState {
															#line 1931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	DoBackupActorState(BackupAndRestoreCorrectnessWorkload* const& self,double const& startDelay,FileBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay,Promise<Void> const& submitted) 
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		 : self(self),
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   startDelay(startDelay),
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   cx(cx),
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   tag(tag),
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   backupRanges(backupRanges),
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   stopDifferentialDelay(stopDifferentialDelay),
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   submitted(submitted),
															#line 284 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID()),
															#line 286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   stopDifferentialFuture(delay(stopDifferentialDelay))
															#line 1956 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(startDelay);
															#line 287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1973 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1978 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 289 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 2001 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 2005 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			try {
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag.toString());
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2011 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2016 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 289 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 2036 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 2040 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			try {
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag.toString());
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2046 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2051 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 303 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupSubmitBackup", randomID) .detail("Tag", printable(tag)) .detail("StopWhenDone", stopDifferentialDelay ? "False" : "True");
															#line 307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		backupContainer = "file://simfdb/backups/";
															#line 308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		status = statusLoop(cx, tag.toString());
															#line 2150 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		try {
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = backupAgent->submitBackup(cx, StringRef(backupContainer), {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 2000), tag.toString(), backupRanges, true, StopWhenDone{ !stopDifferentialDelay }, UsePartitionedLog::False, IncrementalBackupOnly::False, self->encryptionKeyFileName);
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 2156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 3;
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 2, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 298 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 2185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 299 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		submitted.send(Void());
															#line 331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (stopDifferentialDelay)
															#line 2307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			CODE_PROBE(!stopDifferentialFuture.isReady(), "Restore starts at specified time - stopDifferential not ready");
															#line 334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = stopDifferentialFuture;
															#line 334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2315 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 4;
															#line 334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 3, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2320 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 323 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2337 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 428 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitBackup", randomID).detail("Tag", printable(tag));
															#line 429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<EBackupState> __when_expr_10 = backupAgent->waitBackup(cx, tag.toString(), StopWhenDone::True);
															#line 429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2461 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont9when1(__when_expr_10.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 11;
															#line 429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 10, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2466 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 335 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 2475 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		try {
															#line 340 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 2479 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				backupTag = makeBackupTag(tag.toString());
															#line 342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", backupTag.tagName);
															#line 345 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				lastBackupContainer = Reference<IBackupContainer>();
															#line 346 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				lastBackupUID = UID();
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				StrictFuture<EBackupState> __when_expr_4 = backupAgent->waitBackup( cx, backupTag.tagName, StopWhenDone::False, &lastBackupContainer, &lastBackupUID);
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2493 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2498 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2509 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2514 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 335 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 2530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		try {
															#line 340 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 2534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				backupTag = makeBackupTag(tag.toString());
															#line 342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", backupTag.tagName);
															#line 345 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				lastBackupContainer = Reference<IBackupContainer>();
															#line 346 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				lastBackupUID = UID();
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				StrictFuture<EBackupState> __when_expr_4 = backupAgent->waitBackup( cx, backupTag.tagName, StopWhenDone::False, &lastBackupContainer, &lastBackupUID);
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2548 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont10Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2553 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2564 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2569 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont10Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 421 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 422 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2669 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 423 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2673 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont2(int loopDepth) 
	{
		loopDepth = a_body1cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 350 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitForRestorable", randomID) .detail("Tag", backupTag.tagName) .detail("Result", BackupAgentBase::getStateText(resultWait));
															#line 354 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restorable = false;
															#line 355 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (lastBackupContainer)
															#line 2699 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 356 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			fdesc = lastBackupContainer->describeBackup();
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = ready(fdesc);
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2707 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont10Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_5.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 6;
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 5, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2712 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10when1(EBackupState const& __resultWait,int loopDepth) 
	{
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		resultWait = __resultWait;
															#line 2726 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(EBackupState && __resultWait,int loopDepth) 
	{
		resultWait = std::move(__resultWait);
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 4, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 4, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
															#line 367 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_LastBackupContainer", randomID) .detail("BackupTag", printable(tag)) .detail("LastBackupContainer", lastBackupContainer ? lastBackupContainer->getURL() : "") .detail("LastBackupUID", lastBackupUID) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait)) .detail("Restorable", restorable);
															#line 375 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (resultWait == EBackupState::STATE_ABORTED)
															#line 2807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
		}
		else
		{
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (!lastBackupContainer)
															#line 2814 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 379 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				TraceEvent(SevError, "BARW_MissingBackupContainer", randomID) .detail("LastBackupUID", lastBackupUID) .detail("BackupTag", printable(tag)) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait));
															#line 383 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				printf("BackupCorrectnessMissingBackupContainer   tag: %s  status: %s\n", printable(tag).c_str(), BackupAgentBase::getStateText(resultWait));
															#line 2820 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 388 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (!restorable)
															#line 2826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				{
															#line 389 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					TraceEvent(SevError, "BARW_NotRestorable", randomID) .detail("LastBackupUID", lastBackupUID) .detail("BackupTag", printable(tag)) .detail("BackupFolder", lastBackupContainer->getURL()) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait));
															#line 394 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					printf("BackupCorrectnessNotRestorable:  tag: %s\n", printable(tag).c_str());
															#line 2832 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
			}
		}
															#line 399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (startDelay)
															#line 2838 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 400 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup2", randomID) .detail("Tag", printable(tag)) .detail("WaitStatus", BackupAgentBase::getStateText(resultWait)) .detail("LastBackupContainer", lastBackupContainer ? lastBackupContainer->getURL() : "") .detail("Restorable", restorable);
															#line 405 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_7 = backupAgent->abortBackup(cx, tag.toString());
															#line 405 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2846 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont10Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_7.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 8;
															#line 405 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 7, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2851 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 410 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = backupAgent->discontinueBackup(cx, tag);
															#line 410 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2862 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont10Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont4when2(__when_expr_8.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 9;
															#line 410 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 8, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2867 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Void const& _,int loopDepth) 
	{
															#line 359 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!fdesc.isError())
															#line 2877 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			desc = fdesc.get();
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_6 = desc.resolveVersionTimes(cx);
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2885 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2890 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Void && _,int loopDepth) 
	{
															#line 359 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!fdesc.isError())
															#line 2904 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			desc = fdesc.get();
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_6 = desc.resolveVersionTimes(cx);
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont10Catch1(actor_cancelled(), loopDepth);
															#line 2912 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2917 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont6(int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void const& _,int loopDepth) 
	{
															#line 362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		printf("BackupDescription:\n%s\n", desc.toString().c_str());
															#line 363 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restorable = desc.maxRestorableVersion.present();
															#line 3014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7(Void && _,int loopDepth) 
	{
															#line 362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		printf("BackupDescription:\n%s\n", desc.toString().c_str());
															#line 363 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restorable = desc.maxRestorableVersion.present();
															#line 3025 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont9(int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont4when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10Catch1(error, 0);
		} catch (...) {
			a_body1cont10Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 431 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		statusText = std::string();
															#line 433 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_11 = backupAgent->getStatus(cx, ShowErrors::True, tag.toString());
															#line 433 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3393 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11when1(__when_expr_11.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 12;
															#line 433 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 11, std::string >*>(static_cast<DoBackupActor*>(this)));
															#line 3398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(EBackupState const& __statusValue,int loopDepth) 
	{
															#line 429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		statusValue = __statusValue;
															#line 3407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(EBackupState && __statusValue,int loopDepth) 
	{
		statusValue = std::move(__statusValue);
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 10, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 10, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont1(std::string const& _statusText,int loopDepth) 
	{
															#line 434 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		statusText = _statusText;
															#line 437 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", BackupAgentBase::getStateText(statusValue));
															#line 442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3490 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont1(std::string && _statusText,int loopDepth) 
	{
															#line 434 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		statusText = _statusText;
															#line 437 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", BackupAgentBase::getStateText(statusValue));
															#line 442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3506 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11when1(std::string const& _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_statusText, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(std::string && _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_statusText), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 11, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 11, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	BackupAndRestoreCorrectnessWorkload* self;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	double startDelay;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Database cx;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Key tag;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	double stopDifferentialDelay;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Promise<Void> submitted;
															#line 284 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	UID randomID;
															#line 286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Future<Void> stopDifferentialFuture;
															#line 307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	std::string backupContainer;
															#line 308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Future<Void> status;
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	KeyBackedTag backupTag;
															#line 345 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 346 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	UID lastBackupUID;
															#line 347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	EBackupState resultWait;
															#line 354 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	bool restorable;
															#line 356 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Future<BackupDescription> fdesc;
															#line 360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	BackupDescription desc;
															#line 429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	EBackupState statusValue;
															#line 431 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	std::string statusText;
															#line 3631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doBackup()
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, Void >, public ActorCallback< DoBackupActor, 2, Void >, public ActorCallback< DoBackupActor, 3, Void >, public ActorCallback< DoBackupActor, 4, EBackupState >, public ActorCallback< DoBackupActor, 5, Void >, public ActorCallback< DoBackupActor, 6, Void >, public ActorCallback< DoBackupActor, 7, Void >, public ActorCallback< DoBackupActor, 8, Void >, public ActorCallback< DoBackupActor, 9, Void >, public ActorCallback< DoBackupActor, 10, EBackupState >, public ActorCallback< DoBackupActor, 11, std::string >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 3636 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14192652242248360960UL, 14360613991604811008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, Void >;
friend struct ActorCallback< DoBackupActor, 2, Void >;
friend struct ActorCallback< DoBackupActor, 3, Void >;
friend struct ActorCallback< DoBackupActor, 4, EBackupState >;
friend struct ActorCallback< DoBackupActor, 5, Void >;
friend struct ActorCallback< DoBackupActor, 6, Void >;
friend struct ActorCallback< DoBackupActor, 7, Void >;
friend struct ActorCallback< DoBackupActor, 8, Void >;
friend struct ActorCallback< DoBackupActor, 9, Void >;
friend struct ActorCallback< DoBackupActor, 10, EBackupState >;
friend struct ActorCallback< DoBackupActor, 11, std::string >;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	DoBackupActor(BackupAndRestoreCorrectnessWorkload* const& self,double const& startDelay,FileBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay,Promise<Void> const& submitted) 
															#line 3664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay, submitted),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoBackupActor, 4, EBackupState >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoBackupActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoBackupActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoBackupActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoBackupActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DoBackupActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DoBackupActor, 10, EBackupState >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< DoBackupActor, 11, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupAndRestoreCorrectnessWorkload* const& self, double const& startDelay, FileBackupAgent* const& backupAgent, Database const& cx, Key const& tag, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, double const& stopDifferentialDelay, Promise<Void> const& submitted ) {
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	return Future<Void>(new DoBackupActor(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay, submitted));
															#line 3707 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
}

#line 444 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"

	/**
	    This actor attempts to restore the database without clearing the keyspace.
	 */
																#line 3715 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via attemptDirtyRestore()
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
template <class AttemptDirtyRestoreActor>
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class AttemptDirtyRestoreActorState {
															#line 3721 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	AttemptDirtyRestoreActorState(BackupAndRestoreCorrectnessWorkload* const& self,Database const& cx,FileBackupAgent* const& backupAgent,Standalone<StringRef> const& lastBackupContainer,UID const& randomID,Optional<std::string> const& encryptionKeyFileName) 
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		 : self(self),
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   cx(cx),
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   lastBackupContainer(lastBackupContainer),
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   randomID(randomID),
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   encryptionKeyFileName(encryptionKeyFileName),
															#line 454 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   tr(cx),
															#line 455 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   rowCount(0)
															#line 3742 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("attemptDirtyRestore", reinterpret_cast<unsigned long>(this));

	}
	~AttemptDirtyRestoreActorState() 
	{
		fdb_probe_actor_destroy("attemptDirtyRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 456 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			;
															#line 3757 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AttemptDirtyRestoreActorState();
		static_cast<AttemptDirtyRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 467 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (rowCount > 0)
															#line 3780 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
			try {
															#line 469 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_2 = success(backupAgent->restore(cx, cx, self->backupTag, KeyRef(lastBackupContainer), {}, WaitForComplete::True, ::invalidVersion, Verbose::True, normalKeys, Key(), Key(), self->locked, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, encryptionKeyFileName));
															#line 469 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3787 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
				static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 3;
															#line 469 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AttemptDirtyRestoreActor, 2, Void >*>(static_cast<AttemptDirtyRestoreActor*>(this)));
															#line 3792 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 458 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(normalKeys, 1);
															#line 458 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3822 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 1;
															#line 458 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*>(static_cast<AttemptDirtyRestoreActor*>(this)));
															#line 3827 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 462 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 462 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3864 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 2;
															#line 462 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AttemptDirtyRestoreActor, 1, Void >*>(static_cast<AttemptDirtyRestoreActor*>(this)));
															#line 3869 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& existingRows,int loopDepth) 
	{
															#line 459 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		rowCount = existingRows.size();
															#line 3884 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && existingRows,int loopDepth) 
	{
															#line 459 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		rowCount = existingRows.size();
															#line 3893 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& existingRows,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(existingRows, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && existingRows,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(existingRows), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state > 0) static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<AttemptDirtyRestoreActor*>(this)->ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state > 0) static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<AttemptDirtyRestoreActor*>(this)->ActorCallback< AttemptDirtyRestoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AttemptDirtyRestoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 494 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!static_cast<AttemptDirtyRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AttemptDirtyRestoreActorState(); static_cast<AttemptDirtyRestoreActor*>(this)->destroy(); return 0; }
															#line 4064 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<AttemptDirtyRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AttemptDirtyRestoreActorState();
		static_cast<AttemptDirtyRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 488 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (e.code() != error_code_restore_destination_not_empty)
															#line 4083 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 489 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4087 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent(SevError, "BARW_RestoreAllowedOverwrittingDatabase", randomID).log();
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		ASSERT(false);
															#line 4105 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent(SevError, "BARW_RestoreAllowedOverwrittingDatabase", randomID).log();
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		ASSERT(false);
															#line 4116 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state > 0) static_cast<AttemptDirtyRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<AttemptDirtyRestoreActor*>(this)->ActorCallback< AttemptDirtyRestoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AttemptDirtyRestoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AttemptDirtyRestoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	BackupAndRestoreCorrectnessWorkload* self;
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Database cx;
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Standalone<StringRef> lastBackupContainer;
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	UID randomID;
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Optional<std::string> encryptionKeyFileName;
															#line 454 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Transaction tr;
															#line 455 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	int rowCount;
															#line 4225 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via attemptDirtyRestore()
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class AttemptDirtyRestoreActor final : public Actor<Void>, public ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >, public ActorCallback< AttemptDirtyRestoreActor, 1, Void >, public ActorCallback< AttemptDirtyRestoreActor, 2, Void >, public FastAllocated<AttemptDirtyRestoreActor>, public AttemptDirtyRestoreActorState<AttemptDirtyRestoreActor> {
															#line 4230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<AttemptDirtyRestoreActor>::operator new;
	using FastAllocated<AttemptDirtyRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6075825989034122752UL, 12210612682742345728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >;
friend struct ActorCallback< AttemptDirtyRestoreActor, 1, Void >;
friend struct ActorCallback< AttemptDirtyRestoreActor, 2, Void >;
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	AttemptDirtyRestoreActor(BackupAndRestoreCorrectnessWorkload* const& self,Database const& cx,FileBackupAgent* const& backupAgent,Standalone<StringRef> const& lastBackupContainer,UID const& randomID,Optional<std::string> const& encryptionKeyFileName) 
															#line 4249 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AttemptDirtyRestoreActorState<AttemptDirtyRestoreActor>(self, cx, backupAgent, lastBackupContainer, randomID, encryptionKeyFileName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15385393307141582336UL, 13597647653183750656UL);
		ActorExecutionContextHelper __helper(static_cast<AttemptDirtyRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("attemptDirtyRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("attemptDirtyRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AttemptDirtyRestoreActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AttemptDirtyRestoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AttemptDirtyRestoreActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> attemptDirtyRestore( BackupAndRestoreCorrectnessWorkload* const& self, Database const& cx, FileBackupAgent* const& backupAgent, Standalone<StringRef> const& lastBackupContainer, UID const& randomID, Optional<std::string> const& encryptionKeyFileName ) {
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	return Future<Void>(new AttemptDirtyRestoreActor(self, cx, backupAgent, lastBackupContainer, randomID, encryptionKeyFileName));
															#line 4283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
}

#line 496 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"

																#line 4288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via clearAndRestoreSystemKeys()
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
template <class ClearAndRestoreSystemKeysActor>
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class ClearAndRestoreSystemKeysActorState {
															#line 4294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	ClearAndRestoreSystemKeysActorState(Database const& cx,BackupAndRestoreCorrectnessWorkload* const& self,FileBackupAgent* const& backupAgent,Version const& targetVersion,Reference<IBackupContainer> const& lastBackupContainer,Standalone<VectorRef<KeyRangeRef>> const& systemRestoreRanges) 
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		 : cx(cx),
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   self(self),
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   targetVersion(targetVersion),
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   lastBackupContainer(lastBackupContainer),
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   systemRestoreRanges(systemRestoreRanges)
															#line 4311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	~ClearAndRestoreSystemKeysActorState() 
	{
		fdb_probe_actor_destroy("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 504 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& range : systemRestoreRanges) tr->clear(range); return Void(); });
															#line 504 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 1;
															#line 504 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*>(static_cast<ClearAndRestoreSystemKeysActor*>(this)));
															#line 4333 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearAndRestoreSystemKeysActorState();
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 510 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreTag = Standalone<StringRef>(self->backupTag.toString() + "_system");
															#line 511 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore is called for tag:%s\n", restoreTag.toString().c_str());
															#line 512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent->restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), systemRestoreRanges, WaitForComplete::True, targetVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName()));
															#line 512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 2;
															#line 512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*>(static_cast<ClearAndRestoreSystemKeysActor*>(this)));
															#line 4367 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 510 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreTag = Standalone<StringRef>(self->backupTag.toString() + "_system");
															#line 511 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore is called for tag:%s\n", restoreTag.toString().c_str());
															#line 512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent->restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), systemRestoreRanges, WaitForComplete::True, targetVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName()));
															#line 512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4382 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 2;
															#line 512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*>(static_cast<ClearAndRestoreSystemKeysActor*>(this)));
															#line 4387 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state > 0) static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 529 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore finished for tag:%s\n", restoreTag.toString().c_str());
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!static_cast<ClearAndRestoreSystemKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAndRestoreSystemKeysActorState(); static_cast<ClearAndRestoreSystemKeysActor*>(this)->destroy(); return 0; }
															#line 4473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<ClearAndRestoreSystemKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAndRestoreSystemKeysActorState();
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 529 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		printf("BackupCorrectness, backupAgent.restore finished for tag:%s\n", restoreTag.toString().c_str());
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!static_cast<ClearAndRestoreSystemKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAndRestoreSystemKeysActorState(); static_cast<ClearAndRestoreSystemKeysActor*>(this)->destroy(); return 0; }
															#line 4487 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<ClearAndRestoreSystemKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAndRestoreSystemKeysActorState();
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state > 0) static_cast<ClearAndRestoreSystemKeysActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAndRestoreSystemKeysActor*>(this)->ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Database cx;
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	BackupAndRestoreCorrectnessWorkload* self;
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Version targetVersion;
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> systemRestoreRanges;
															#line 510 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Standalone<StringRef> restoreTag;
															#line 4584 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearAndRestoreSystemKeys()
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class ClearAndRestoreSystemKeysActor final : public Actor<Void>, public ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >, public ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >, public FastAllocated<ClearAndRestoreSystemKeysActor>, public ClearAndRestoreSystemKeysActorState<ClearAndRestoreSystemKeysActor> {
															#line 4589 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearAndRestoreSystemKeysActor>::operator new;
	using FastAllocated<ClearAndRestoreSystemKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16543590407121988864UL, 5623284373066937856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >;
friend struct ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >;
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	ClearAndRestoreSystemKeysActor(Database const& cx,BackupAndRestoreCorrectnessWorkload* const& self,FileBackupAgent* const& backupAgent,Version const& targetVersion,Reference<IBackupContainer> const& lastBackupContainer,Standalone<VectorRef<KeyRangeRef>> const& systemRestoreRanges) 
															#line 4607 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearAndRestoreSystemKeysActorState<ClearAndRestoreSystemKeysActor>(cx, self, backupAgent, targetVersion, lastBackupContainer, systemRestoreRanges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16912799750989885184UL, 15867424326961837824UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAndRestoreSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearAndRestoreSystemKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearAndRestoreSystemKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearAndRestoreSystemKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearAndRestoreSystemKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> clearAndRestoreSystemKeys( Database const& cx, BackupAndRestoreCorrectnessWorkload* const& self, FileBackupAgent* const& backupAgent, Version const& targetVersion, Reference<IBackupContainer> const& lastBackupContainer, Standalone<VectorRef<KeyRangeRef>> const& systemRestoreRanges ) {
															#line 497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	return Future<Void>(new ClearAndRestoreSystemKeysActor(cx, self, backupAgent, targetVersion, lastBackupContainer, systemRestoreRanges));
															#line 4640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
}

#line 532 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"

																#line 4645 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
template <class _startActor>
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class _startActorState {
															#line 4651 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	_startActorState(Database const& cx,BackupAndRestoreCorrectnessWorkload* const& self) 
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		 : cx(cx),
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   self(self),
															#line 534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   backupAgent(),
															#line 535 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		   extraBackup()
															#line 4664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 536 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 536 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4681 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 536 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 4686 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 537 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_Arguments") .detail("BackupTag", printable(self->backupTag)) .detail("PerformRestore", self->performRestore) .detail("BackupAfter", self->backupAfter) .detail("RestoreAfter", self->restoreAfter) .detail("AbortAndRestartAfter", self->abortAndRestartAfter) .detail("DifferentialAfter", self->stopDifferentialAfter);
															#line 545 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		randomID = nondeterministicRandom()->randomUniqueID();
															#line 546 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (self->allowPauses && BUGGIFY)
															#line 4713 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 547 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			cp = changePaused(cx, &backupAgent);
															#line 4717 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
															#line 551 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (self->agentRequest)
															#line 4721 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 552 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			BackupAndRestoreCorrectnessWorkload::backupAgentRequests++;
															#line 4725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
															#line 555 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (self->encryptionKeyFileName.present())
															#line 4729 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 556 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 556 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4735 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 556 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 4740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 536 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		config = __config;
															#line 4754 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
		try {
															#line 560 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			startRestore = delay(self->restoreAfter);
															#line 563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(self->backupAfter);
															#line 563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4838 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 4843 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 989 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 4945 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 986 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupAndRestoreCorrectness").error(e).GetLastError();
															#line 987 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4960 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 565 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 566 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		submitted = Promise<Void>();
															#line 567 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		b = doBackup( self, 0, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter, submitted);
															#line 570 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (self->abortAndRestartAfter)
															#line 4980 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackup2", randomID) .detail("Tag", printable(self->backupTag)) .detail("AbortWait", self->abortAndRestartAfter);
															#line 574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = submitted.getFuture();
															#line 574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 4988 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4993 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 565 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 566 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		submitted = Promise<Void>();
															#line 567 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		b = doBackup( self, 0, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter, submitted);
															#line 570 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (self->abortAndRestartAfter)
															#line 5013 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackup2", randomID) .detail("Tag", printable(self->backupTag)) .detail("AbortWait", self->abortAndRestartAfter);
															#line 574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = submitted.getFuture();
															#line 574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5021 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 5026 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 585 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 5115 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		try {
															#line 589 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_4 = b;
															#line 589 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 5121 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont8Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 589 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 5126 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 575 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		b = b && doBackup(self, self->abortAndRestartAfter, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter, Promise<Void>());
															#line 5141 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 575 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		b = b && doBackup(self, self->abortAndRestartAfter, &backupAgent, cx, self->backupTag, self->backupRanges, self->stopDifferentialAfter, Promise<Void>());
															#line 5150 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 597 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupDone", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 601 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		keyBackedTag = makeBackupTag(self->backupTag.toString());
															#line 602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<UidAndAbortedFlagT> __when_expr_5 = keyBackedTag.getOrThrow(cx.getReference());
															#line 602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5240 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, UidAndAbortedFlagT >*>(static_cast<_startActor*>(this)));
															#line 5245 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 591 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (e.code() != error_code_database_locked)
															#line 5255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 592 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 5259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
															#line 593 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (self->performRestore)
															#line 5263 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 594 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 5267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
															#line 595 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
															#line 603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		logUid = uidFlag.first;
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Key> __when_expr_6 = BackupConfig(logUid).destUidValue().getD(cx.getReference());
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5393 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Key >*>(static_cast<_startActor*>(this)));
															#line 5398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
															#line 603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		logUid = uidFlag.first;
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Key> __when_expr_6 = BackupConfig(logUid).destUidValue().getD(cx.getReference());
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Key >*>(static_cast<_startActor*>(this)));
															#line 5416 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(uidFlag, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(uidFlag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11cont2(int loopDepth) 
	{
															#line 605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_7 = BackupConfig(logUid).backupContainer().getD(cx.getReference());
															#line 605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5502 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Reference<IBackupContainer> >*>(static_cast<_startActor*>(this)));
															#line 5507 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1when1(Key const& __destUidValue,int loopDepth) 
	{
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		destUidValue = __destUidValue;
															#line 5516 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Key && __destUidValue,int loopDepth) 
	{
		destUidValue = std::move(__destUidValue);
		loopDepth = a_body1cont11cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont3(int loopDepth) 
	{
															#line 609 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!self->locked && BUGGIFY)
															#line 5595 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 610 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup2", randomID).detail("Tag", printable(self->backupTag));
															#line 5599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			try {
															#line 612 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				extraBackup = backupAgent.submitBackup(cx, "file://simfdb/backups/"_sr, {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 100), self->backupTag.toString(), self->backupRanges, true, StopWhenDone::True);
															#line 5603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = a_body1cont11cont7(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont11cont3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont11cont3Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont11cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont2when1(Reference<IBackupContainer> const& __lastBackupContainer,int loopDepth) 
	{
															#line 605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		lastBackupContainer = __lastBackupContainer;
															#line 5623 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Reference<IBackupContainer> && __lastBackupContainer,int loopDepth) 
	{
		lastBackupContainer = std::move(__lastBackupContainer);
		loopDepth = a_body1cont11cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Reference<IBackupContainer> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Reference<IBackupContainer> >*,Reference<IBackupContainer> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Reference<IBackupContainer> >*,Reference<IBackupContainer> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Reference<IBackupContainer> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont4(int loopDepth) 
	{
															#line 630 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		CODE_PROBE(!startRestore.isReady(), "Restore starts at specified time");
															#line 631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = startRestore;
															#line 631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5706 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont4when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 5711 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont5(int loopDepth) 
	{
		loopDepth = a_body1cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 622 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup2Exception", randomID) .error(e) .detail("BackupTag", printable(self->backupTag));
															#line 625 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 5729 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 626 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 5733 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont8(Void const& _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (lastBackupContainer && self->performRestore)
															#line 5762 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 634 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			auto container = IBackupContainer::openContainer(lastBackupContainer->getURL(), lastBackupContainer->getProxy(), lastBackupContainer->getEncryptionKeyFileName());
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_9 = container->describeBackup();
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5770 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont8when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, BackupDescription >*>(static_cast<_startActor*>(this)));
															#line 5775 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont8(Void && _,int loopDepth) 
	{
															#line 633 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (lastBackupContainer && self->performRestore)
															#line 5789 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 634 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			auto container = IBackupContainer::openContainer(lastBackupContainer->getURL(), lastBackupContainer->getProxy(), lastBackupContainer->getEncryptionKeyFileName());
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_9 = container->describeBackup();
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont8when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, BackupDescription >*>(static_cast<_startActor*>(this)));
															#line 5802 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont9(int loopDepth) 
	{
															#line 836 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (extraBackup.isValid())
															#line 5891 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 837 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_WaitExtraBackup", randomID).detail("BackupTag", printable(self->backupTag));
															#line 5895 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			try {
															#line 839 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_19 = extraBackup;
															#line 839 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont9Catch1(actor_cancelled(), loopDepth);
															#line 5901 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont11cont9Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont11cont9when1(__when_expr_19.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 839 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, Void >*>(static_cast<_startActor*>(this)));
															#line 5906 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont11cont9Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont11cont9Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont11cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10(int loopDepth) 
	{
															#line 639 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (deterministicRandom()->random01() < 0.5)
															#line 5926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_10 = attemptDirtyRestore(self, cx, &backupAgent, StringRef(lastBackupContainer->getURL()), randomID, lastBackupContainer->getEncryptionKeyFileName());
															#line 640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 5932 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont2Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont10when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 5937 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont8when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		desc = __desc;
															#line 5951 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont8when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont11cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont10cont1(int loopDepth) 
	{
															#line 648 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_11 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& kvrange : self->backupRanges) tr->clear(kvrange); return Void(); });
															#line 648 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6032 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont2Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont10cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 648 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 6037 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont10cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont10cont3(Void const& _,int loopDepth) 
	{
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_Restore", randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->backupTag));
															#line 661 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		targetVersion = -1;
															#line 662 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (desc.maxRestorableVersion.present())
															#line 6137 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 6141 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				targetVersion = desc.minRestorableVersion.get();
															#line 6145 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 665 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (deterministicRandom()->random01() < 0.1)
															#line 6151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				{
															#line 666 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					targetVersion = desc.maxRestorableVersion.get();
															#line 6155 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 667 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					if (deterministicRandom()->random01() < 0.5)
															#line 6161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
					{
															#line 668 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
						targetVersion = (desc.minRestorableVersion.get() != desc.maxRestorableVersion.get()) ? deterministicRandom()->randomInt64(desc.minRestorableVersion.get(), desc.maxRestorableVersion.get()) : desc.maxRestorableVersion.get();
															#line 6165 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 675 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_RestoreDebug").detail("TargetVersion", targetVersion);
															#line 677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restores = std::vector<Future<Version>>();
															#line 678 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreTags = std::vector<Standalone<StringRef>>();
															#line 679 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		multipleRangesInOneTag = false;
															#line 680 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreIndex = 0;
															#line 683 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> modifiedRestoreRanges;
															#line 684 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> systemRestoreRanges;
															#line 685 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		for(int i = 0;i < self->restoreRanges.size();++i) {
															#line 686 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (!self->restoreRanges[i].intersects(getSystemBackupRanges()))
															#line 6188 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 687 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), self->restoreRanges[i]);
															#line 6192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 689 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				KeyRangeRef normalKeyRange = self->restoreRanges[i] & normalKeys;
															#line 690 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				KeyRangeRef systemKeyRange = self->restoreRanges[i] & systemKeys;
															#line 691 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (!normalKeyRange.empty())
															#line 6202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				{
															#line 692 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), normalKeyRange);
															#line 6206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
															#line 694 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (!systemKeyRange.empty())
															#line 6210 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				{
															#line 695 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					systemRestoreRanges.push_back_deep(systemRestoreRanges.arena(), systemKeyRange);
															#line 6214 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
			}
		}
															#line 699 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		self->restoreRanges = modifiedRestoreRanges;
															#line 700 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!systemRestoreRanges.empty())
															#line 6222 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_12 = clearAndRestoreSystemKeys( cx, self, &backupAgent, targetVersion, lastBackupContainer, systemRestoreRanges);
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont2Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont10cont3when1(__when_expr_12.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 6233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont10cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont3(Void && _,int loopDepth) 
	{
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_Restore", randomID) .detail("LastBackupContainer", lastBackupContainer->getURL()) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->backupTag));
															#line 661 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		targetVersion = -1;
															#line 662 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (desc.maxRestorableVersion.present())
															#line 6251 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 6255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				targetVersion = desc.minRestorableVersion.get();
															#line 6259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 665 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (deterministicRandom()->random01() < 0.1)
															#line 6265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				{
															#line 666 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					targetVersion = desc.maxRestorableVersion.get();
															#line 6269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 667 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					if (deterministicRandom()->random01() < 0.5)
															#line 6275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
					{
															#line 668 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
						targetVersion = (desc.minRestorableVersion.get() != desc.maxRestorableVersion.get()) ? deterministicRandom()->randomInt64(desc.minRestorableVersion.get(), desc.maxRestorableVersion.get()) : desc.maxRestorableVersion.get();
															#line 6279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 675 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_RestoreDebug").detail("TargetVersion", targetVersion);
															#line 677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restores = std::vector<Future<Version>>();
															#line 678 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreTags = std::vector<Standalone<StringRef>>();
															#line 679 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		multipleRangesInOneTag = false;
															#line 680 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreIndex = 0;
															#line 683 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> modifiedRestoreRanges;
															#line 684 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> systemRestoreRanges;
															#line 685 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		for(int i = 0;i < self->restoreRanges.size();++i) {
															#line 686 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (!self->restoreRanges[i].intersects(getSystemBackupRanges()))
															#line 6302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 687 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), self->restoreRanges[i]);
															#line 6306 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 689 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				KeyRangeRef normalKeyRange = self->restoreRanges[i] & normalKeys;
															#line 690 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				KeyRangeRef systemKeyRange = self->restoreRanges[i] & systemKeys;
															#line 691 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (!normalKeyRange.empty())
															#line 6316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				{
															#line 692 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					modifiedRestoreRanges.push_back_deep(modifiedRestoreRanges.arena(), normalKeyRange);
															#line 6320 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
															#line 694 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				if (!systemKeyRange.empty())
															#line 6324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				{
															#line 695 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
					systemRestoreRanges.push_back_deep(systemRestoreRanges.arena(), systemKeyRange);
															#line 6328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
				}
			}
		}
															#line 699 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		self->restoreRanges = modifiedRestoreRanges;
															#line 700 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!systemRestoreRanges.empty())
															#line 6336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_12 = clearAndRestoreSystemKeys( cx, self, &backupAgent, targetVersion, lastBackupContainer, systemRestoreRanges);
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont2Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont10cont3when1(__when_expr_12.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 6347 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont10cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont11cont10cont4(int loopDepth) 
	{
															#line 706 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (deterministicRandom()->random01() < 0.5)
															#line 6436 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 707 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			for(restoreIndex = 0;restoreIndex < self->restoreRanges.size();restoreIndex++) {
															#line 708 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				auto range = self->restoreRanges[restoreIndex];
															#line 709 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				Standalone<StringRef> restoreTag(self->backupTag.toString() + "_" + std::to_string(restoreIndex));
															#line 711 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				restoreTags.push_back(restoreTag);
															#line 712 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				printf("BackupCorrectness, restore for each range: backupAgent.restore is called for " "restoreIndex:%d tag:%s ranges:%s\n", restoreIndex, range.toString().c_str(), restoreTag.toString().c_str());
															#line 717 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				restores.push_back(backupAgent.restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), WaitForComplete::True, targetVersion, Verbose::True, range, Key(), Key(), self->locked, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName()));
															#line 6450 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 735 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			multipleRangesInOneTag = true;
															#line 736 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			Standalone<StringRef> restoreTag(self->backupTag.toString() + "_" + std::to_string(restoreIndex));
															#line 737 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			restoreTags.push_back(restoreTag);
															#line 738 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("BackupCorrectness, backupAgent.restore is called for restoreIndex:%d tag:%s\n", restoreIndex, restoreTag.toString().c_str());
															#line 741 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			restores.push_back(backupAgent.restore(cx, cx, restoreTag, KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), self->restoreRanges, WaitForComplete::True, targetVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName()));
															#line 6465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
															#line 761 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (BUGGIFY)
															#line 6469 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 762 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_13 = delay(deterministicRandom()->randomInt(0, 10));
															#line 762 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6475 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont2Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont10cont4when1(__when_expr_13.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 762 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 6480 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont10cont17(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11cont10cont17(int loopDepth) 
	{
															#line 829 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_18 = waitForAll(restores);
															#line 829 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6583 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont2Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont11cont10cont17when1(__when_expr_18.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 829 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, Void >*>(static_cast<_startActor*>(this)));
															#line 6588 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont10cont21(Void const& _,int loopDepth) 
	{
															#line 763 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (multipleRangesInOneTag)
															#line 6597 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 764 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<FileBackupAgent::ERestoreState> __when_expr_14 = backupAgent.abortRestore(cx, restoreTags[0]);
															#line 764 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont2Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont10cont21when1(__when_expr_14.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 764 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >*>(static_cast<_startActor*>(this)));
															#line 6608 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 794 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			restoreIndex = 0;
															#line 6615 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont10cont21loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont21(Void && _,int loopDepth) 
	{
															#line 763 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (multipleRangesInOneTag)
															#line 6625 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 764 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<FileBackupAgent::ERestoreState> __when_expr_14 = backupAgent.abortRestore(cx, restoreTags[0]);
															#line 764 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont2Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont10cont21when1(__when_expr_14.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 764 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >*>(static_cast<_startActor*>(this)));
															#line 6636 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 794 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			restoreIndex = 0;
															#line 6643 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11cont10cont21loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont11cont10cont21cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21cont2(FileBackupAgent::ERestoreState const& rs,int loopDepth) 
	{
															#line 767 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (rs == FileBackupAgent::ERestoreState::ABORTED)
															#line 6734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 768 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_15 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& range : self->restoreRanges) tr->clear(range); return Void(); });
															#line 768 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont2Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont11cont10cont21cont2when1(__when_expr_15.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 768 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 6745 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont10cont21cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont21cont2(FileBackupAgent::ERestoreState && rs,int loopDepth) 
	{
															#line 767 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (rs == FileBackupAgent::ERestoreState::ABORTED)
															#line 6759 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 768 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_15 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); for (auto& range : self->restoreRanges) tr->clear(range); return Void(); });
															#line 768 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 6765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont2Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont11cont10cont21cont2when1(__when_expr_15.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 768 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 6770 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont10cont21cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont21when1(FileBackupAgent::ERestoreState const& rs,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21cont2(rs, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21when1(FileBackupAgent::ERestoreState && rs,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21cont2(std::move(rs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >*,FileBackupAgent::ERestoreState const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont10cont21when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >*,FileBackupAgent::ERestoreState && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont10cont21when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont11cont10cont21cont3(int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21cont4(Void const& _,int loopDepth) 
	{
															#line 774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restores[restoreIndex] = backupAgent.restore(cx, cx, restoreTags[restoreIndex], KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), self->restoreRanges, WaitForComplete::True, ::invalidVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName());
															#line 6865 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont10cont21cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21cont4(Void && _,int loopDepth) 
	{
															#line 774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restores[restoreIndex] = backupAgent.restore(cx, cx, restoreTags[restoreIndex], KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), self->restoreRanges, WaitForComplete::True, ::invalidVersion, Verbose::True, Key(), Key(), self->locked, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName());
															#line 6874 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont10cont21cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont10cont21cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont10cont21cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont11cont10cont21cont6(int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont10cont21loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1(int loopDepth) 
	{
															#line 794 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!(restoreIndex < restores.size()))
															#line 6971 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont11cont10cont21break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<FileBackupAgent::ERestoreState> __when_expr_16 = backupAgent.abortRestore(cx, restoreTags[restoreIndex]);
															#line 795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6979 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont2Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont10cont21loopBody1when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, FileBackupAgent::ERestoreState >*>(static_cast<_startActor*>(this)));
															#line 6984 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont10cont21break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont10cont21cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1cont1(FileBackupAgent::ERestoreState const& rs,int loopDepth) 
	{
															#line 800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (rs == FileBackupAgent::ERestoreState::ABORTED)
															#line 7006 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 801 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_17 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->clear(self->restoreRanges[restoreIndex]); return Void(); });
															#line 801 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7012 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont2Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont10cont21loopBody1cont1when1(__when_expr_17.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 801 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 7017 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont10cont21loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1cont1(FileBackupAgent::ERestoreState && rs,int loopDepth) 
	{
															#line 800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (rs == FileBackupAgent::ERestoreState::ABORTED)
															#line 7031 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 801 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_17 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->clear(self->restoreRanges[restoreIndex]); return Void(); });
															#line 801 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7037 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont2Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont10cont21loopBody1cont1when1(__when_expr_17.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 801 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 7042 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont10cont21loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1when1(FileBackupAgent::ERestoreState const& rs,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21loopBody1cont1(rs, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1when1(FileBackupAgent::ERestoreState && rs,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21loopBody1cont1(std::move(rs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, FileBackupAgent::ERestoreState >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, FileBackupAgent::ERestoreState >*,FileBackupAgent::ERestoreState const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont10cont21loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, FileBackupAgent::ERestoreState >*,FileBackupAgent::ERestoreState && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont10cont21loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, FileBackupAgent::ERestoreState >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont11cont10cont21loopBody1cont3(int loopDepth) 
	{
															#line 794 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restoreIndex++;
															#line 7131 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont11cont10cont21loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restores[restoreIndex] = backupAgent.restore(cx, cx, restoreTags[restoreIndex], KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), WaitForComplete::True, ::invalidVersion, Verbose::True, self->restoreRanges[restoreIndex], Key(), Key(), self->locked, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName());
															#line 7140 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont10cont21loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		restores[restoreIndex] = backupAgent.restore(cx, cx, restoreTags[restoreIndex], KeyRef(lastBackupContainer->getURL()), lastBackupContainer->getProxy(), WaitForComplete::True, ::invalidVersion, Verbose::True, self->restoreRanges[restoreIndex], Key(), Key(), self->locked, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, lastBackupContainer->getEncryptionKeyFileName());
															#line 7149 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont10cont21loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont21loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont21loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont10cont21loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont10cont21loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _startActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont11cont10cont17cont1(Void const& _,int loopDepth) 
	{
															#line 831 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		for( auto& restore : restores ) {
															#line 832 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			ASSERT(!restore.isError());
															#line 7235 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont17cont1(Void && _,int loopDepth) 
	{
															#line 831 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		for( auto& restore : restores ) {
															#line 832 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			ASSERT(!restore.isError());
															#line 7247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont17when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont17cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10cont17when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10cont17cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont10cont17when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _startActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont10cont17when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _startActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont11cont11(int loopDepth) 
	{
															#line 858 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		backupAgentKey = uidPrefixKey(logRangesRange.begin, logUid);
															#line 859 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		backupLogValuesKey = destUidValue.withPrefix(backupLogKeys.begin);
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		backupLatestVersionsPath = destUidValue.withPrefix(backupLatestVersionsPrefix);
															#line 861 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		backupLatestVersionsKey = uidPrefixKey(backupLatestVersionsPath, logUid);
															#line 862 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		displaySystemKeys = 0;
															#line 865 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		;
															#line 7342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12(int loopDepth) 
	{
															#line 848 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_AbortBackupExtra", randomID).detail("BackupTag", printable(self->backupTag));
															#line 7351 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		try {
															#line 850 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_20 = backupAgent.abortBackup(cx, self->backupTag.toString());
															#line 850 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont12Catch1(actor_cancelled(), loopDepth);
															#line 7357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont11cont12Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont11cont12when1(__when_expr_20.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 21;
															#line 850 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< _startActor, 20, Void >*>(static_cast<_startActor*>(this)));
															#line 7362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont12Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont12Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 841 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_ExtraBackupException", randomID) .error(e) .detail("BackupTag", printable(self->backupTag));
															#line 844 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 7380 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 7384 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont11cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _startActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _startActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont11cont13cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 852 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_AbortBackupExtraException", randomID).error(e);
															#line 853 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 7509 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			{
															#line 854 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 7513 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont11cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont12cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< _startActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< _startActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont12Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont11cont12cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont1(int loopDepth) 
	{
															#line 969 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (displaySystemKeys)
															#line 7629 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 970 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_30 = TaskBucket::debugPrintRange(cx, normalKeys.end, StringRef());
															#line 970 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 7635 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1cont2Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont11cont11cont1when1(__when_expr_30.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 31;
															#line 970 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< _startActor, 30, Void >*>(static_cast<_startActor*>(this)));
															#line 7640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont11loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1(int loopDepth) 
	{
															#line 866 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 868 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_CheckLeftoverKeys", randomID).detail("BackupTag", printable(self->backupTag));
															#line 7663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		try {
															#line 874 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_CheckLeftoverTasks", randomID).detail("BackupTag", printable(self->backupTag));
															#line 875 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<int64_t> __when_expr_21 = backupAgent.getTaskCount(tr);
															#line 875 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7671 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont11cont11loopBody1when1(__when_expr_21.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 22;
															#line 875 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< _startActor, 21, int64_t >*>(static_cast<_startActor*>(this)));
															#line 7676 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont11loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 964 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_CheckException", randomID).error(e);
															#line 965 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_29 = tr->onError(e);
															#line 965 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7715 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1cont2Catch1(__when_expr_29.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont11loopBody1Catch1when1(__when_expr_29.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 30;
															#line 965 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< _startActor, 29, Void >*>(static_cast<_startActor*>(this)));
															#line 7720 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont2(int loopDepth) 
	{
															#line 876 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		waitCycles = 0;
															#line 878 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if ((taskCount) && false)
															#line 7737 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 879 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent("BARW_EndingNonzeroTaskCount", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 883 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("EndingNonZeroTasks: %ld\n", (long)taskCount);
															#line 884 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_22 = TaskBucket::debugPrintRange(cx, normalKeys.end, StringRef());
															#line 884 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7747 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont11cont11loopBody1cont2when1(__when_expr_22.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 23;
															#line 884 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< _startActor, 22, Void >*>(static_cast<_startActor*>(this)));
															#line 7752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1when1(int64_t const& __taskCount,int loopDepth) 
	{
															#line 875 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		taskCount = __taskCount;
															#line 7766 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1when1(int64_t && __taskCount,int loopDepth) 
	{
		taskCount = std::move(__taskCount);
		loopDepth = a_body1cont11cont11loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 21, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 21, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< _startActor, 21, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< _startActor, 21, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont11cont11loopBody1cont3(int loopDepth) 
	{
															#line 887 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		;
															#line 7845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11cont11loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 22, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 22, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< _startActor, 22, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< _startActor, 22, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont11cont11loopBody1cont5(int loopDepth) 
	{
															#line 906 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_25 = tr->getRange(KeyRange(KeyRangeRef(backupAgentKey, strinc(backupAgentKey))), 100);
															#line 906 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7943 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont11cont11loopBody1cont5when1(__when_expr_25.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 26;
															#line 906 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< _startActor, 25, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 7948 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont11loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 887 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!(taskCount > 0))
															#line 7964 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1cont11cont11loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 888 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		waitCycles++;
															#line 890 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_NonzeroTaskWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 894 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		printf("%.6f %-10s Wait #%4d for %lld tasks to end\n", now(), randomID.toString().c_str(), waitCycles, (long long)taskCount);
															#line 900 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_23 = delay(5.0);
															#line 900 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7978 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_23.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont11loopBody1cont3loopBody1when1(__when_expr_23.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 24;
															#line 900 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< _startActor, 23, Void >*>(static_cast<_startActor*>(this)));
															#line 7983 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont11loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 902 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_24 = store(taskCount, backupAgent.getTaskCount(tr));
															#line 903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8009 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_24.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont11loopBody1cont3loopBody1cont1when1(__when_expr_24.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 25;
															#line 903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< _startActor, 24, Void >*>(static_cast<_startActor*>(this)));
															#line 8014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 902 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_24 = store(taskCount, backupAgent.getTaskCount(tr));
															#line 903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8027 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_24.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont11loopBody1cont3loopBody1cont1when1(__when_expr_24.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 25;
															#line 903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< _startActor, 24, Void >*>(static_cast<_startActor*>(this)));
															#line 8032 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 23, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< _startActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< _startActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont11cont11loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont11loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont11loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 24, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 24, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11loopBody1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< _startActor, 24, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11loopBody1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< _startActor, 24, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont11cont11loopBody1cont6(RangeResult const& agentValues,int loopDepth) 
	{
															#line 910 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (agentValues.size() > 0)
															#line 8203 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 911 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 912 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverMutationKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 919 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			for( auto& s : agentValues ) {
															#line 920 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				TraceEvent("BARW_LeftOverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 923 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 8217 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 928 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 8224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
															#line 931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_26 = tr->get(backupLatestVersionsKey);
															#line 931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_26.getError(), loopDepth); else return a_body1cont11cont11loopBody1cont6when1(__when_expr_26.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 27;
															#line 931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< _startActor, 26, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 8235 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont6(RangeResult && agentValues,int loopDepth) 
	{
															#line 910 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (agentValues.size() > 0)
															#line 8244 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 911 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 912 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverMutationKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 919 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			for( auto& s : agentValues ) {
															#line 920 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				TraceEvent("BARW_LeftOverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 923 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 8258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 928 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 8265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
															#line 931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_26 = tr->get(backupLatestVersionsKey);
															#line 931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_26.getError(), loopDepth); else return a_body1cont11cont11loopBody1cont6when1(__when_expr_26.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 27;
															#line 931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< _startActor, 26, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 8276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont5when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont6(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont5when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont6(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 25, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 25, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< _startActor, 25, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< _startActor, 25, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont11cont11loopBody1cont7(Optional<Value> const& latestVersion,int loopDepth) 
	{
															#line 932 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (latestVersion.present())
															#line 8360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 933 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverVersionKey", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("BackupLatestVersionsKey", backupLatestVersionsKey.printable()) .detail("DestUidValue", destUidValue.printable());
															#line 8364 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 938 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("No left over backup version key\n");
															#line 8370 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
															#line 941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_27 = tr->getRange( KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8376 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_27.getError(), loopDepth); else return a_body1cont11cont11loopBody1cont7when1(__when_expr_27.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 28;
															#line 941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< _startActor, 27, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 8381 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont7(Optional<Value> && latestVersion,int loopDepth) 
	{
															#line 932 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (latestVersion.present())
															#line 8390 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 933 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverVersionKey", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("BackupLatestVersionsKey", backupLatestVersionsKey.printable()) .detail("DestUidValue", destUidValue.printable());
															#line 8394 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 938 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("No left over backup version key\n");
															#line 8400 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
															#line 941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_27 = tr->getRange( KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8406 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_27.getError(), loopDepth); else return a_body1cont11cont11loopBody1cont7when1(__when_expr_27.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 28;
															#line 941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< _startActor, 27, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 8411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont6when1(Optional<Value> const& latestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont7(latestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont6when1(Optional<Value> && latestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont7(std::move(latestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 26, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 26, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< _startActor, 26, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< _startActor, 26, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont11cont11loopBody1cont11(RangeResult const& versions,int loopDepth) 
	{
															#line 943 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!self->shareLogRange || !versions.size())
															#line 8495 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_28 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8501 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_28.getError(), loopDepth); else return a_body1cont11cont11loopBody1cont11when1(__when_expr_28.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 29;
															#line 944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< _startActor, 28, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 8506 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont11(RangeResult && versions,int loopDepth) 
	{
															#line 943 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (!self->shareLogRange || !versions.size())
															#line 8520 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_28 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8526 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont11cont11loopBody1Catch1(__when_expr_28.getError(), loopDepth); else return a_body1cont11cont11loopBody1cont11when1(__when_expr_28.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 29;
															#line 944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< _startActor, 28, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 8531 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont7when1(RangeResult const& versions,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont11(versions, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont7when1(RangeResult && versions,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont11(std::move(versions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 27, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 27, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< _startActor, 27, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< _startActor, 27, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont11cont11loopBody1cont11cont1(int loopDepth) 
	{
		return a_body1cont11cont11break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont11cont2(RangeResult const& logValues,int loopDepth) 
	{
															#line 948 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (logValues.size() > 0)
															#line 8626 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 950 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 953 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverLogKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey));
															#line 8634 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 958 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("No left over backup log keys\n");
															#line 8640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont11loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont11cont2(RangeResult && logValues,int loopDepth) 
	{
															#line 948 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (logValues.size() > 0)
															#line 8650 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 950 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftOverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 953 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftOverLogKeys", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("LeftOverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey));
															#line 8658 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 958 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			printf("No left over backup log keys\n");
															#line 8664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont11loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont11when1(RangeResult const& logValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont11cont2(logValues, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1cont11when1(RangeResult && logValues,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont11cont2(std::move(logValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 28, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 28, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont11loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< _startActor, 28, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont11loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< _startActor, 28, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont11loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1cont11cont11loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose30() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 29, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 29, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont11cont11loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< _startActor, 29, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont11cont11loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< _startActor, 29, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont11cont11cont2(int loopDepth) 
	{
															#line 973 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		TraceEvent("BARW_Complete", randomID).detail("BackupTag", printable(self->backupTag));
															#line 976 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if (self->agentRequest)
															#line 8838 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 977 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			BackupAndRestoreCorrectnessWorkload::backupAgentRequests--;
															#line 8842 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
															#line 981 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
		if ((g_simulator->backupAgents == ISimulator::BackupAgentType::BackupToFile) && (!BackupAndRestoreCorrectnessWorkload::backupAgentRequests))
															#line 8846 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		{
															#line 983 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
			g_simulator->backupAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 8850 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont11cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose31() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont11cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< _startActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont11cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< _startActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 30);

	}
	int a_body1cont11cont11cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Database cx;
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	BackupAndRestoreCorrectnessWorkload* self;
															#line 534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	FileBackupAgent backupAgent;
															#line 535 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Future<Void> extraBackup;
															#line 536 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	DatabaseConfiguration config;
															#line 545 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	UID randomID;
															#line 547 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Future<Void> cp;
															#line 560 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Future<Void> startRestore;
															#line 566 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Promise<Void> submitted;
															#line 567 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Future<Void> b;
															#line 601 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	KeyBackedTag keyBackedTag;
															#line 603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	UID logUid;
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Key destUidValue;
															#line 605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Reference<IBackupContainer> lastBackupContainer;
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	BackupDescription desc;
															#line 661 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Version targetVersion;
															#line 677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	std::vector<Future<Version>> restores;
															#line 678 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	std::vector<Standalone<StringRef>> restoreTags;
															#line 679 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	bool multipleRangesInOneTag;
															#line 680 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	int restoreIndex;
															#line 858 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Key backupAgentKey;
															#line 859 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Key backupLogValuesKey;
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Key backupLatestVersionsPath;
															#line 861 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Key backupLatestVersionsKey;
															#line 862 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	int displaySystemKeys;
															#line 866 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 875 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	int64_t taskCount;
															#line 876 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	int waitCycles;
															#line 9012 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, UidAndAbortedFlagT >, public ActorCallback< _startActor, 6, Key >, public ActorCallback< _startActor, 7, Reference<IBackupContainer> >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, BackupDescription >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, FileBackupAgent::ERestoreState >, public ActorCallback< _startActor, 17, Void >, public ActorCallback< _startActor, 18, Void >, public ActorCallback< _startActor, 19, Void >, public ActorCallback< _startActor, 20, Void >, public ActorCallback< _startActor, 21, int64_t >, public ActorCallback< _startActor, 22, Void >, public ActorCallback< _startActor, 23, Void >, public ActorCallback< _startActor, 24, Void >, public ActorCallback< _startActor, 25, RangeResult >, public ActorCallback< _startActor, 26, Optional<Value> >, public ActorCallback< _startActor, 27, RangeResult >, public ActorCallback< _startActor, 28, RangeResult >, public ActorCallback< _startActor, 29, Void >, public ActorCallback< _startActor, 30, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 9017 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5251556928936274176UL, 761933896044082176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, UidAndAbortedFlagT >;
friend struct ActorCallback< _startActor, 6, Key >;
friend struct ActorCallback< _startActor, 7, Reference<IBackupContainer> >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, BackupDescription >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, FileBackupAgent::ERestoreState >;
friend struct ActorCallback< _startActor, 17, Void >;
friend struct ActorCallback< _startActor, 18, Void >;
friend struct ActorCallback< _startActor, 19, Void >;
friend struct ActorCallback< _startActor, 20, Void >;
friend struct ActorCallback< _startActor, 21, int64_t >;
friend struct ActorCallback< _startActor, 22, Void >;
friend struct ActorCallback< _startActor, 23, Void >;
friend struct ActorCallback< _startActor, 24, Void >;
friend struct ActorCallback< _startActor, 25, RangeResult >;
friend struct ActorCallback< _startActor, 26, Optional<Value> >;
friend struct ActorCallback< _startActor, 27, RangeResult >;
friend struct ActorCallback< _startActor, 28, RangeResult >;
friend struct ActorCallback< _startActor, 29, Void >;
friend struct ActorCallback< _startActor, 30, Void >;
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	_startActor(Database const& cx,BackupAndRestoreCorrectnessWorkload* const& self) 
															#line 9064 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Key >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Reference<IBackupContainer> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, BackupDescription >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, FileBackupAgent::ERestoreState >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, FileBackupAgent::ERestoreState >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _startActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _startActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _startActor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< _startActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< _startActor, 21, int64_t >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< _startActor, 22, Void >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< _startActor, 23, Void >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< _startActor, 24, Void >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< _startActor, 25, RangeResult >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< _startActor, 26, Optional<Value> >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< _startActor, 27, RangeResult >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< _startActor, 28, RangeResult >*)0, actor_cancelled()); break;
		case 30: this->a_callback_error((ActorCallback< _startActor, 29, Void >*)0, actor_cancelled()); break;
		case 31: this->a_callback_error((ActorCallback< _startActor, 30, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupAndRestoreCorrectnessWorkload* const& self ) {
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 9126 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupCorrectness.actor.g.cpp.py_gen"
}

#line 991 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/workloads/BackupCorrectness.actor.cpp"
};

int BackupAndRestoreCorrectnessWorkload::backupAgentRequests = 0;

std::string getTestEncryptionFileName() {
	return "test_encryption_key_file";
}

WorkloadFactory<BackupAndRestoreCorrectnessWorkload> BackupAndRestoreCorrectnessWorkloadFactory;
