#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
/*
 * RestoreWorker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <ctime>
#include <climits>
#include <numeric>
#include <algorithm>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/BackupContainer.h"
#include "flow/ApiVersion.h"
#include "flow/IAsyncFile.h"
#include "fdbrpc/simulator.h"
#include "flow/genericactors.actor.h"
#include "flow/Hash3.h"
#include "flow/ActorCollection.h"
#include "fdbserver/RestoreWorker.actor.h"
#include "fdbserver/RestoreController.actor.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#include "flow/actorcompiler.h" // This must be the last #include.

class RestoreConfigFR;
struct RestoreWorkerData; // Only declare the struct exist but we cannot use its field

															#line 51 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> handlerTerminateWorkerRequest( RestoreSimpleRequest const& req, Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& workerInterf, Database const& cx );

#line 53 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 55 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> monitorWorkerLiveness( Reference<RestoreWorkerData> const& self );

#line 54 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
void handleRecruitRoleRequest(RestoreRecruitRoleRequest req,
                              Reference<RestoreWorkerData> self,
                              ActorCollection* actors,
                              Database cx);
															#line 63 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> collectRestoreWorkerInterface( Reference<RestoreWorkerData> const& self, Database const& cx, int const& min_num_workers = 2 );

#line 61 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> monitorleader( Reference<AsyncVar<RestoreWorkerInterface>> const& leader, Database const& cx, RestoreWorkerInterface const& myWorkerInterf );

#line 64 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
[[nodiscard]] Future<Void> startRestoreWorkerLeader( Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& workerInterf, Database const& cx );

#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// Remove the worker interface from restoreWorkerKey and remove its roles interfaces from their keys.
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handlerTerminateWorkerRequest()
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class HandlerTerminateWorkerRequestActor>
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class HandlerTerminateWorkerRequestActorState {
															#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	HandlerTerminateWorkerRequestActorState(RestoreSimpleRequest const& req,Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& workerInterf,Database const& cx) 
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : req(req),
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   self(self),
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   workerInterf(workerInterf),
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx)
															#line 97 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandlerTerminateWorkerRequestActorState() 
	{
		fdb_probe_actor_destroy("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); tr->clear(restoreWorkerKeyFor(workerInterf.id())); return Void(); });
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<HandlerTerminateWorkerRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 114 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandlerTerminateWorkerRequestActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*>(static_cast<HandlerTerminateWorkerRequestActor*>(this)));
															#line 119 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandlerTerminateWorkerRequestActorState();
		static_cast<HandlerTerminateWorkerRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker").detail("HandleTerminateWorkerReq", self->id());
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<HandlerTerminateWorkerRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandlerTerminateWorkerRequestActorState(); static_cast<HandlerTerminateWorkerRequestActor*>(this)->destroy(); return 0; }
															#line 144 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<HandlerTerminateWorkerRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandlerTerminateWorkerRequestActorState();
		static_cast<HandlerTerminateWorkerRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker").detail("HandleTerminateWorkerReq", self->id());
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<HandlerTerminateWorkerRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandlerTerminateWorkerRequestActorState(); static_cast<HandlerTerminateWorkerRequestActor*>(this)->destroy(); return 0; }
															#line 158 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<HandlerTerminateWorkerRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandlerTerminateWorkerRequestActorState();
		static_cast<HandlerTerminateWorkerRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandlerTerminateWorkerRequestActor*>(this)->actor_wait_state > 0) static_cast<HandlerTerminateWorkerRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandlerTerminateWorkerRequestActor*>(this)->ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandlerTerminateWorkerRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandlerTerminateWorkerRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandlerTerminateWorkerRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreSimpleRequest req;
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface workerInterf;
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 249 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handlerTerminateWorkerRequest()
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class HandlerTerminateWorkerRequestActor final : public Actor<Void>, public ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >, public FastAllocated<HandlerTerminateWorkerRequestActor>, public HandlerTerminateWorkerRequestActorState<HandlerTerminateWorkerRequestActor> {
															#line 254 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandlerTerminateWorkerRequestActor>::operator new;
	using FastAllocated<HandlerTerminateWorkerRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3471453016474889728UL, 2476587466683424000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >;
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	HandlerTerminateWorkerRequestActor(RestoreSimpleRequest const& req,Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& workerInterf,Database const& cx) 
															#line 271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandlerTerminateWorkerRequestActorState<HandlerTerminateWorkerRequestActor>(req, self, workerInterf, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10091636684208773632UL, 5530680396984554496UL);
		ActorExecutionContextHelper __helper(static_cast<HandlerTerminateWorkerRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handlerTerminateWorkerRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handlerTerminateWorkerRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandlerTerminateWorkerRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> handlerTerminateWorkerRequest( RestoreSimpleRequest const& req, Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& workerInterf, Database const& cx ) {
															#line 69 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new HandlerTerminateWorkerRequestActor(req, self, workerInterf, cx));
															#line 304 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// Assume only 1 role on a restore worker.
// Future: Multiple roles in a restore worker
void handleRecruitRoleRequest(RestoreRecruitRoleRequest req,
                              Reference<RestoreWorkerData> self,
                              ActorCollection* actors,
                              Database cx) {
	// Future: Allow multiple restore roles on a restore worker. The design should easily allow this.
	ASSERT(!self->loaderInterf.present() || !self->applierInterf.present()); // Only one role per worker for now
	// Already recruited a role
	if (self->loaderInterf.present()) {
		ASSERT(req.role == RestoreRole::Loader);
		req.reply.send(RestoreRecruitRoleReply(self->id(), RestoreRole::Loader, self->loaderInterf.get()));
		return;
	} else if (self->applierInterf.present()) {
		req.reply.send(RestoreRecruitRoleReply(self->id(), RestoreRole::Applier, self->applierInterf.get()));
		return;
	}

	if (req.role == RestoreRole::Loader) {
		ASSERT(!self->loaderInterf.present());
		self->controllerInterf = req.ci;
		self->loaderInterf = RestoreLoaderInterface();
		self->loaderInterf.get().initEndpoints();
		RestoreLoaderInterface& recruited = self->loaderInterf.get();
		DUMPTOKEN(recruited.heartbeat);
		DUMPTOKEN(recruited.updateRestoreSysInfo);
		DUMPTOKEN(recruited.initVersionBatch);
		DUMPTOKEN(recruited.loadFile);
		DUMPTOKEN(recruited.sendMutations);
		DUMPTOKEN(recruited.initVersionBatch);
		DUMPTOKEN(recruited.finishVersionBatch);
		DUMPTOKEN(recruited.collectRestoreRoleInterfaces);
		DUMPTOKEN(recruited.finishRestore);
		actors->add(restoreLoaderCore(self->loaderInterf.get(), req.nodeIndex, cx, req.ci));
		TraceEvent("FastRestoreWorker").detail("RecruitedLoaderNodeIndex", req.nodeIndex);
		req.reply.send(
		    RestoreRecruitRoleReply(self->loaderInterf.get().id(), RestoreRole::Loader, self->loaderInterf.get()));
	} else if (req.role == RestoreRole::Applier) {
		ASSERT(!self->applierInterf.present());
		self->controllerInterf = req.ci;
		self->applierInterf = RestoreApplierInterface();
		self->applierInterf.get().initEndpoints();
		RestoreApplierInterface& recruited = self->applierInterf.get();
		DUMPTOKEN(recruited.heartbeat);
		DUMPTOKEN(recruited.sendMutationVector);
		DUMPTOKEN(recruited.applyToDB);
		DUMPTOKEN(recruited.initVersionBatch);
		DUMPTOKEN(recruited.collectRestoreRoleInterfaces);
		DUMPTOKEN(recruited.finishRestore);
		actors->add(restoreApplierCore(self->applierInterf.get(), req.nodeIndex, cx));
		TraceEvent("FastRestoreWorker").detail("RecruitedApplierNodeIndex", req.nodeIndex);
		req.reply.send(
		    RestoreRecruitRoleReply(self->applierInterf.get().id(), RestoreRole::Applier, self->applierInterf.get()));
	} else {
		TraceEvent(SevError, "FastRestoreWorkerHandleRecruitRoleRequestUnknownRole").detail("Request", req.toString());
	}

	return;
}

// Read restoreWorkersKeys from DB to get each restore worker's workerInterface and set it to self->workerInterfaces;
// This is done before we assign restore roles for restore workers.
															#line 371 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via collectRestoreWorkerInterface()
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class CollectRestoreWorkerInterfaceActor>
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class CollectRestoreWorkerInterfaceActorState {
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	CollectRestoreWorkerInterfaceActorState(Reference<RestoreWorkerData> const& self,Database const& cx,int const& min_num_workers) 
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : self(self),
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx),
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   min_num_workers(min_num_workers),
															#line 148 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   tr(cx),
															#line 149 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   agents()
															#line 393 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this));

	}
	~CollectRestoreWorkerInterfaceActorState() 
	{
		fdb_probe_actor_destroy("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			;
															#line 408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CollectRestoreWorkerInterfaceActorState();
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		ASSERT(agents.size() >= min_num_workers);
															#line 181 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker").detail("CollectWorkerInterfaceNumWorkers", self->workerInterfaces.size());
															#line 183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<CollectRestoreWorkerInterfaceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CollectRestoreWorkerInterfaceActorState(); static_cast<CollectRestoreWorkerInterfaceActor*>(this)->destroy(); return 0; }
															#line 435 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<CollectRestoreWorkerInterfaceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CollectRestoreWorkerInterfaceActorState();
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 153 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			self->workerInterfaces.clear();
															#line 154 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			agents.clear();
															#line 155 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.reset();
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 157 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 158 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(restoreWorkersKeys, CLIENT_KNOBS->TOO_MANY);
															#line 158 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 467 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*>(static_cast<CollectRestoreWorkerInterfaceActor*>(this)));
															#line 472 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 509 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 3;
															#line 176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*>(static_cast<CollectRestoreWorkerInterfaceActor*>(this)));
															#line 514 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& agentValues,int loopDepth) 
	{
															#line 159 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		ASSERT(!agentValues.more);
															#line 162 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (agentValues.size() >= min_num_workers)
															#line 531 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			for( auto& it : agentValues ) {
															#line 164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				agents.push_back(BinaryReader::fromStringRef<RestoreWorkerInterface>(it.value, IncludeVersion()));
															#line 166 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				self->workerInterfaces.insert(std::make_pair(agents.back().id(), agents.back()));
															#line 539 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 170 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker") .suppressFor(10.0) .detail("NotEnoughWorkers", agentValues.size()) .detail("MinWorkers", min_num_workers);
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 549 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 2;
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*>(static_cast<CollectRestoreWorkerInterfaceActor*>(this)));
															#line 554 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && agentValues,int loopDepth) 
	{
															#line 159 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		ASSERT(!agentValues.more);
															#line 162 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (agentValues.size() >= min_num_workers)
															#line 565 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			for( auto& it : agentValues ) {
															#line 164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				agents.push_back(BinaryReader::fromStringRef<RestoreWorkerInterface>(it.value, IncludeVersion()));
															#line 166 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				self->workerInterfaces.insert(std::make_pair(agents.back().id(), agents.back()));
															#line 573 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 170 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker") .suppressFor(10.0) .detail("NotEnoughWorkers", agentValues.size()) .detail("MinWorkers", min_num_workers);
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 583 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 2;
															#line 174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*>(static_cast<CollectRestoreWorkerInterfaceActor*>(this)));
															#line 588 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreWorkerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreWorkerInterfaceActor*>(this)->ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	int min_num_workers;
															#line 148 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Transaction tr;
															#line 149 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	std::vector<RestoreWorkerInterface> agents;
															#line 865 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via collectRestoreWorkerInterface()
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class CollectRestoreWorkerInterfaceActor final : public Actor<Void>, public ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >, public ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >, public ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >, public FastAllocated<CollectRestoreWorkerInterfaceActor>, public CollectRestoreWorkerInterfaceActorState<CollectRestoreWorkerInterfaceActor> {
															#line 870 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<CollectRestoreWorkerInterfaceActor>::operator new;
	using FastAllocated<CollectRestoreWorkerInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1741548920151050752UL, 2948021186065645056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >;
friend struct ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >;
friend struct ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >;
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	CollectRestoreWorkerInterfaceActor(Reference<RestoreWorkerData> const& self,Database const& cx,int const& min_num_workers) 
															#line 889 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CollectRestoreWorkerInterfaceActorState<CollectRestoreWorkerInterfaceActor>(self, cx, min_num_workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7649045598728601600UL, 11728192798239088128UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreWorkerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("collectRestoreWorkerInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("collectRestoreWorkerInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CollectRestoreWorkerInterfaceActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CollectRestoreWorkerInterfaceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CollectRestoreWorkerInterfaceActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> collectRestoreWorkerInterface( Reference<RestoreWorkerData> const& self, Database const& cx, int const& min_num_workers ) {
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new CollectRestoreWorkerInterfaceActor(self, cx, min_num_workers));
															#line 924 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// Periodically send worker heartbeat to
															#line 930 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorWorkerLiveness()
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class MonitorWorkerLivenessActor>
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class MonitorWorkerLivenessActorState {
															#line 937 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	MonitorWorkerLivenessActorState(Reference<RestoreWorkerData> const& self) 
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : self(self)
															#line 944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this));

	}
	~MonitorWorkerLivenessActorState() 
	{
		fdb_probe_actor_destroy("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			ASSERT(!self->workerInterfaces.empty());
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			workerInterf = std::map<UID, RestoreWorkerInterface>::iterator();
															#line 191 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			;
															#line 963 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorWorkerLivenessActorState();
		static_cast<MonitorWorkerLivenessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		std::vector<std::pair<UID, RestoreSimpleRequest>> requests;
															#line 193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		for( auto& worker : self->workerInterfaces ) {
															#line 194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			requests.emplace_back(worker.first, RestoreSimpleRequest());
															#line 997 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		}
															#line 196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = sendBatchRequests(&RestoreWorkerInterface::heartbeat, self->workerInterfaces, requests);
															#line 196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1003 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 1;
															#line 196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerLivenessActor, 0, Void >*>(static_cast<MonitorWorkerLivenessActor*>(this)));
															#line 1008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(60.0);
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1019 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 2;
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerLivenessActor, 1, Void >*>(static_cast<MonitorWorkerLivenessActor*>(this)));
															#line 1024 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(60.0);
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1035 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 2;
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerLivenessActor, 1, Void >*>(static_cast<MonitorWorkerLivenessActor*>(this)));
															#line 1040 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerLivenessActor*>(this)->ActorCallback< MonitorWorkerLivenessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerLivenessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerLivenessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorWorkerLivenessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerLivenessActor*>(this)->ActorCallback< MonitorWorkerLivenessActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerLivenessActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerLivenessActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorWorkerLivenessActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	std::map<UID, RestoreWorkerInterface>::iterator workerInterf;
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorWorkerLiveness()
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class MonitorWorkerLivenessActor final : public Actor<Void>, public ActorCallback< MonitorWorkerLivenessActor, 0, Void >, public ActorCallback< MonitorWorkerLivenessActor, 1, Void >, public FastAllocated<MonitorWorkerLivenessActor>, public MonitorWorkerLivenessActorState<MonitorWorkerLivenessActor> {
															#line 1216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorWorkerLivenessActor>::operator new;
	using FastAllocated<MonitorWorkerLivenessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4079519337681507072UL, 6349892346804361216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorWorkerLivenessActor, 0, Void >;
friend struct ActorCallback< MonitorWorkerLivenessActor, 1, Void >;
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	MonitorWorkerLivenessActor(Reference<RestoreWorkerData> const& self) 
															#line 1234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorWorkerLivenessActorState<MonitorWorkerLivenessActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4274100538724903424UL, 2910315914700105216UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorWorkerLiveness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorWorkerLiveness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorWorkerLivenessActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorWorkerLivenessActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> monitorWorkerLiveness( Reference<RestoreWorkerData> const& self ) {
															#line 187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new MonitorWorkerLivenessActor(self));
															#line 1268 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 200 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// RestoreWorkerLeader is the worker that runs RestoreController role
															#line 1274 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startRestoreWorkerLeader()
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class StartRestoreWorkerLeaderActor>
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class StartRestoreWorkerLeaderActorState {
															#line 1281 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	StartRestoreWorkerLeaderActorState(Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& workerInterf,Database const& cx) 
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : self(self),
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   workerInterf(workerInterf),
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx)
															#line 1292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this));

	}
	~StartRestoreWorkerLeaderActorState() 
	{
		fdb_probe_actor_destroy("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent("FastRestoreWorker") .detail("Controller", workerInterf.id()) .detail("WaitForRestoreWorkerInterfaces", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 210 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(10.0);
															#line 210 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 1;
															#line 210 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartRestoreWorkerLeaderActorState();
		static_cast<StartRestoreWorkerLeaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker") .detail("Controller", workerInterf.id()) .detail("CollectRestoreWorkerInterfaces", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = collectRestoreWorkerInterface( self, cx, SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1343 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 2;
															#line 216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1348 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker") .detail("Controller", workerInterf.id()) .detail("CollectRestoreWorkerInterfaces", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = collectRestoreWorkerInterface( self, cx, SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 2;
															#line 216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1366 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreWorkerLeaderActor*>(this)->ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 220 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		workersFailureMonitor = monitorWorkerLiveness(self);
															#line 222 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		RestoreControllerInterface recruited;
															#line 223 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		DUMPTOKEN(recruited.samples);
															#line 225 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		self->controllerInterf = recruited;
															#line 226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = startRestoreController(self, cx) || workersFailureMonitor;
															#line 226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1460 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 3;
															#line 226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 220 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		workersFailureMonitor = monitorWorkerLiveness(self);
															#line 222 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		RestoreControllerInterface recruited;
															#line 223 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		DUMPTOKEN(recruited.samples);
															#line 225 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		self->controllerInterf = recruited;
															#line 226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = startRestoreController(self, cx) || workersFailureMonitor;
															#line 226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1484 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 3;
															#line 226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*>(static_cast<StartRestoreWorkerLeaderActor*>(this)));
															#line 1489 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreWorkerLeaderActor*>(this)->ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<StartRestoreWorkerLeaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRestoreWorkerLeaderActorState(); static_cast<StartRestoreWorkerLeaderActor*>(this)->destroy(); return 0; }
															#line 1573 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<StartRestoreWorkerLeaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartRestoreWorkerLeaderActorState();
		static_cast<StartRestoreWorkerLeaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<StartRestoreWorkerLeaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRestoreWorkerLeaderActorState(); static_cast<StartRestoreWorkerLeaderActor*>(this)->destroy(); return 0; }
															#line 1585 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<StartRestoreWorkerLeaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartRestoreWorkerLeaderActorState();
		static_cast<StartRestoreWorkerLeaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreWorkerLeaderActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreWorkerLeaderActor*>(this)->ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface workerInterf;
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 220 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Future<Void> workersFailureMonitor;
															#line 1676 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startRestoreWorkerLeader()
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class StartRestoreWorkerLeaderActor final : public Actor<Void>, public ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >, public ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >, public ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >, public FastAllocated<StartRestoreWorkerLeaderActor>, public StartRestoreWorkerLeaderActorState<StartRestoreWorkerLeaderActor> {
															#line 1681 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartRestoreWorkerLeaderActor>::operator new;
	using FastAllocated<StartRestoreWorkerLeaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9769877241267466496UL, 4844135404327090688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >;
friend struct ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >;
friend struct ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >;
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	StartRestoreWorkerLeaderActor(Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& workerInterf,Database const& cx) 
															#line 1700 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartRestoreWorkerLeaderActorState<StartRestoreWorkerLeaderActor>(self, workerInterf, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1672439484283100672UL, 10893048632981829376UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startRestoreWorkerLeader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startRestoreWorkerLeader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartRestoreWorkerLeaderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartRestoreWorkerLeaderActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartRestoreWorkerLeaderActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> startRestoreWorkerLeader( Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& workerInterf, Database const& cx ) {
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new StartRestoreWorkerLeaderActor(self, workerInterf, cx));
															#line 1735 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

															#line 1740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startRestoreWorker()
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class StartRestoreWorkerActor>
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class StartRestoreWorkerActorState {
															#line 1747 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	StartRestoreWorkerActorState(Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& interf,Database const& cx) 
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : self(self),
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   interf(interf),
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx),
															#line 232 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   lastLoopTopTime(now()),
															#line 233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   actors(false),
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   exitRole(Never())
															#line 1764 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startRestoreWorker", reinterpret_cast<unsigned long>(this));

	}
	~StartRestoreWorkerActorState() 
	{
		fdb_probe_actor_destroy("startRestoreWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 236 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			;
															#line 1779 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartRestoreWorkerActorState();
		static_cast<StartRestoreWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 274 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<StartRestoreWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRestoreWorkerActorState(); static_cast<StartRestoreWorkerActor*>(this)->destroy(); return 0; }
															#line 1802 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<StartRestoreWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartRestoreWorkerActorState();
		static_cast<StartRestoreWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		double loopTopTime = now();
															#line 238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		double elapsedTime = loopTopTime - lastLoopTopTime;
															#line 239 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (elapsedTime > 0.050)
															#line 1825 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 240 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (deterministicRandom()->random01() < 0.01)
															#line 1829 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			{
															#line 241 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				TraceEvent(SevWarn, "SlowRestoreWorkerLoopx100") .detail("NodeDesc", self->describeNode()) .detail("Elapsed", elapsedTime);
															#line 1833 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			}
		}
															#line 245 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		lastLoopTopTime = loopTopTime;
															#line 246 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "[Init]";
															#line 1840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		try {
															#line 250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			auto __when_expr_0 = interf.heartbeat.getFuture();
															#line 1844 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<RestoreSimpleRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<RestoreSimpleRequest>>::value, "invalid type");
															#line 249 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<StartRestoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1848 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 254 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			auto __when_expr_1 = interf.recruitRole.getFuture();
															#line 1852 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<RestoreRecruitRoleRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<RestoreRecruitRoleRequest>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			auto __when_expr_2 = interf.terminateWorker.getFuture();
															#line 1857 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_2), FutureStream<RestoreSimpleRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<RestoreSimpleRequest>>::value, "invalid type");
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 263 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = exitRole;
															#line 1862 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
			static_cast<StartRestoreWorkerActor*>(this)->actor_wait_state = 1;
															#line 250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*>(static_cast<StartRestoreWorkerActor*>(this)));
															#line 254 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >*>(static_cast<StartRestoreWorkerActor*>(this)));
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >*>(static_cast<StartRestoreWorkerActor*>(this)));
															#line 263 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartRestoreWorkerActor, 3, Void >*>(static_cast<StartRestoreWorkerActor*>(this)));
															#line 1873 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent(SevWarn, "FastRestoreWorkerError").errorUnsuppressed(e).detail("RequestType", requestTypeStr);
															#line 1908 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSimpleRequest const& req,int loopDepth) 
	{
															#line 251 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "heartbeat";
															#line 252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		actors.add(handleHeartbeat(req, interf.id()));
															#line 1931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSimpleRequest && req,int loopDepth) 
	{
															#line 251 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "heartbeat";
															#line 252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		actors.add(handleHeartbeat(req, interf.id()));
															#line 1942 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(RestoreRecruitRoleRequest const& req,int loopDepth) 
	{
															#line 255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "recruitRole";
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		handleRecruitRoleRequest(req, self, &actors, cx);
															#line 1953 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(RestoreRecruitRoleRequest && req,int loopDepth) 
	{
															#line 255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "recruitRole";
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		handleRecruitRoleRequest(req, self, &actors, cx);
															#line 1964 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(RestoreSimpleRequest const& req,int loopDepth) 
	{
															#line 260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "terminateWorker";
															#line 261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		exitRole = handlerTerminateWorkerRequest(req, self, interf, cx);
															#line 1975 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(RestoreSimpleRequest && req,int loopDepth) 
	{
															#line 260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		requestTypeStr = "terminateWorker";
															#line 261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		exitRole = handlerTerminateWorkerRequest(req, self, interf, cx);
															#line 1986 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorkerCoreExitRole", self->id());
															#line 1995 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
															#line 264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorkerCoreExitRole", self->id());
															#line 2004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartRestoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreWorkerActor*>(this)->ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >::remove();
		static_cast<StartRestoreWorkerActor*>(this)->ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >::remove();
		static_cast<StartRestoreWorkerActor*>(this)->ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >::remove();
		static_cast<StartRestoreWorkerActor*>(this)->ActorCallback< StartRestoreWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*,RestoreSimpleRequest const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*,RestoreSimpleRequest && value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >*,RestoreRecruitRoleRequest const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >*,RestoreRecruitRoleRequest && value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >*,RestoreSimpleRequest const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >*,RestoreSimpleRequest && value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartRestoreWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartRestoreWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface interf;
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 232 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	double lastLoopTopTime;
															#line 233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	ActorCollection actors;
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Future<Void> exitRole;
															#line 246 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	std::string requestTypeStr;
															#line 2273 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startRestoreWorker()
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class StartRestoreWorkerActor final : public Actor<Void>, public ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >, public ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >, public ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >, public ActorCallback< StartRestoreWorkerActor, 3, Void >, public FastAllocated<StartRestoreWorkerActor>, public StartRestoreWorkerActorState<StartRestoreWorkerActor> {
															#line 2278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartRestoreWorkerActor>::operator new;
	using FastAllocated<StartRestoreWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6322693634473278464UL, 128190580132099584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >;
friend struct ActorSingleCallback< StartRestoreWorkerActor, 1, RestoreRecruitRoleRequest >;
friend struct ActorSingleCallback< StartRestoreWorkerActor, 2, RestoreSimpleRequest >;
friend struct ActorCallback< StartRestoreWorkerActor, 3, Void >;
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	StartRestoreWorkerActor(Reference<RestoreWorkerData> const& self,RestoreWorkerInterface const& interf,Database const& cx) 
															#line 2298 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartRestoreWorkerActorState<StartRestoreWorkerActor>(self, interf, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startRestoreWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15207208409390668800UL, 15937872900465846272UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startRestoreWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startRestoreWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< StartRestoreWorkerActor, 0, RestoreSimpleRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> startRestoreWorker( Reference<RestoreWorkerData> const& self, RestoreWorkerInterface const& interf, Database const& cx ) {
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new StartRestoreWorkerActor(self, interf, cx));
															#line 2331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

															#line 2336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via waitOnRestoreRequests()
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class WaitOnRestoreRequestsActor>
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class WaitOnRestoreRequestsActorState {
															#line 2343 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	WaitOnRestoreRequestsActorState(Database const& cx,UID const& nodeID = UID()) 
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : cx(cx),
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   nodeID(nodeID),
															#line 278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   tr(cx),
															#line 279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   numRequests()
															#line 2356 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this));

	}
	~WaitOnRestoreRequestsActorState() 
	{
		fdb_probe_actor_destroy("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 282 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent("FastRestoreWaitOnRestoreRequest", nodeID).log();
															#line 283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			;
															#line 2373 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitOnRestoreRequestsActorState();
		static_cast<WaitOnRestoreRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 306 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<WaitOnRestoreRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitOnRestoreRequestsActorState(); static_cast<WaitOnRestoreRequestsActor*>(this)->destroy(); return 0; }
															#line 2396 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<WaitOnRestoreRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitOnRestoreRequestsActorState();
		static_cast<WaitOnRestoreRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 285 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.reset();
															#line 286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(restoreRequestTriggerKey);
															#line 288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2424 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 1;
															#line 288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2466 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 4;
															#line 302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2471 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& _numRequests,int loopDepth) 
	{
															#line 289 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		numRequests = _numRequests;
															#line 290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!numRequests.present())
															#line 2488 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 291 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			watchForRestoreRequest = tr.watch(restoreRequestTriggerKey);
															#line 292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2496 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 2;
															#line 292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2501 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreRestoreRequestTriggerKey", nodeID) .detail("TriggerKey", numRequests.get().toString());
															#line 2508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && _numRequests,int loopDepth) 
	{
															#line 289 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		numRequests = _numRequests;
															#line 290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!numRequests.present())
															#line 2520 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 291 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			watchForRestoreRequest = tr.watch(restoreRequestTriggerKey);
															#line 292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2528 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 2;
															#line 292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreRestoreRequestTriggerKey", nodeID) .detail("TriggerKey", numRequests.get().toString());
															#line 2540 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& _numRequests,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_numRequests, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && _numRequests,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_numRequests), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnRestoreRequestsActor*>(this)->ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 293 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreWaitOnRestoreRequestTriggerKey", nodeID).log();
															#line 294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchForRestoreRequest;
															#line 294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2635 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 3;
															#line 294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 293 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreWaitOnRestoreRequestTriggerKey", nodeID).log();
															#line 294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchForRestoreRequest;
															#line 294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2653 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 3;
															#line 294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*>(static_cast<WaitOnRestoreRequestsActor*>(this)));
															#line 2658 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnRestoreRequestsActor*>(this)->ActorCallback< WaitOnRestoreRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreDetectRestoreRequestTriggerKeyChanged", nodeID).log();
															#line 2742 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreDetectRestoreRequestTriggerKeyChanged", nodeID).log();
															#line 2751 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnRestoreRequestsActor*>(this)->ActorCallback< WaitOnRestoreRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<WaitOnRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<WaitOnRestoreRequestsActor*>(this)->ActorCallback< WaitOnRestoreRequestsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	UID nodeID;
															#line 278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Optional<Value> numRequests;
															#line 291 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Future<Void> watchForRestoreRequest;
															#line 2941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitOnRestoreRequests()
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class WaitOnRestoreRequestsActor final : public Actor<Void>, public ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >, public ActorCallback< WaitOnRestoreRequestsActor, 1, Void >, public ActorCallback< WaitOnRestoreRequestsActor, 2, Void >, public ActorCallback< WaitOnRestoreRequestsActor, 3, Void >, public FastAllocated<WaitOnRestoreRequestsActor>, public WaitOnRestoreRequestsActorState<WaitOnRestoreRequestsActor> {
															#line 2946 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitOnRestoreRequestsActor>::operator new;
	using FastAllocated<WaitOnRestoreRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15189848039681847040UL, 8849477228809537536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >;
friend struct ActorCallback< WaitOnRestoreRequestsActor, 1, Void >;
friend struct ActorCallback< WaitOnRestoreRequestsActor, 2, Void >;
friend struct ActorCallback< WaitOnRestoreRequestsActor, 3, Void >;
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	WaitOnRestoreRequestsActor(Database const& cx,UID const& nodeID = UID()) 
															#line 2966 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitOnRestoreRequestsActorState<WaitOnRestoreRequestsActor>(cx, nodeID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(738225061845553920UL, 4351482421154446592UL);
		ActorExecutionContextHelper __helper(static_cast<WaitOnRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitOnRestoreRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitOnRestoreRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitOnRestoreRequestsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitOnRestoreRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitOnRestoreRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitOnRestoreRequestsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] static Future<Void> waitOnRestoreRequests( Database const& cx, UID const& nodeID = UID() ) {
															#line 277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new WaitOnRestoreRequestsActor(cx, nodeID));
															#line 3002 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

// RestoreController is the leader
															#line 3008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorleader()
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class MonitorleaderActor>
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class MonitorleaderActorState {
															#line 3015 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	MonitorleaderActorState(Reference<AsyncVar<RestoreWorkerInterface>> const& leader,Database const& cx,RestoreWorkerInterface const& myWorkerInterf) 
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : leader(leader),
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   cx(cx),
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   myWorkerInterf(myWorkerInterf)
															#line 3026 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorleader", reinterpret_cast<unsigned long>(this));

	}
	~MonitorleaderActorState() 
	{
		fdb_probe_actor_destroy("monitorleader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 313 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_MONITOR_LEADER_DELAY);
															#line 313 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3043 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorleaderActor*>(this)->actor_wait_state = 1;
															#line 313 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 0, Void >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3048 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorleaderActorState();
		static_cast<MonitorleaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 314 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()).detail("MonitorLeader", "StartLeaderElection");
															#line 315 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		count = 0;
															#line 316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		leaderInterf = RestoreWorkerInterface();
															#line 317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 318 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		;
															#line 3079 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 314 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()).detail("MonitorLeader", "StartLeaderElection");
															#line 315 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		count = 0;
															#line 316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		leaderInterf = RestoreWorkerInterface();
															#line 317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 318 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		;
															#line 3096 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state > 0) static_cast<MonitorleaderActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorleaderActor*>(this)->ActorCallback< MonitorleaderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorleaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 350 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()) .detail("MonitorLeader", "FinishLeaderElection") .detail("Leader", leaderInterf.id()) .detail("IamLeader", leaderInterf == myWorkerInterf);
															#line 354 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<MonitorleaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorleaderActorState(); static_cast<MonitorleaderActor*>(this)->destroy(); return 0; }
															#line 3182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<MonitorleaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorleaderActorState();
		static_cast<MonitorleaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 320 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			count++;
															#line 321 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.reset();
															#line 322 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 323 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(restoreLeaderKey);
															#line 324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3212 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorleaderActor*>(this)->actor_wait_state = 2;
															#line 324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 1, Optional<Value> >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3217 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 345 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent(SevInfo, "FastRestoreLeaderElection").detail("ErrorCode", e.code()).detail("Error", e.what());
															#line 346 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 346 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorleaderActor*>(this)->actor_wait_state = 4;
															#line 346 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 3, Void >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> const& leaderValue,int loopDepth) 
	{
															#line 325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreLeaderElection") .detail("Round", count) .detail("LeaderExisted", leaderValue.present());
															#line 328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (leaderValue.present())
															#line 3278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 329 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			leaderInterf = BinaryReader::fromStringRef<RestoreWorkerInterface>(leaderValue.get(), IncludeVersion());
															#line 331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (leaderInterf != myWorkerInterf)
															#line 3284 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			{
															#line 332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				tr.set(restoreWorkerKeyFor(myWorkerInterf.id()), restoreWorkerInterfaceValue(myWorkerInterf));
															#line 3288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.set(restoreLeaderKey, BinaryWriter::toValue(myWorkerInterf, IncludeVersion(ProtocolVersion::withRestoreWorkerInterfaceValue())));
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			leaderInterf = myWorkerInterf;
															#line 3297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		}
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3303 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorleaderActor*>(this)->actor_wait_state = 3;
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 2, Void >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Optional<Value> && leaderValue,int loopDepth) 
	{
															#line 325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent(SevInfo, "FastRestoreLeaderElection") .detail("Round", count) .detail("LeaderExisted", leaderValue.present());
															#line 328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (leaderValue.present())
															#line 3319 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 329 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			leaderInterf = BinaryReader::fromStringRef<RestoreWorkerInterface>(leaderValue.get(), IncludeVersion());
															#line 331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (leaderInterf != myWorkerInterf)
															#line 3325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			{
															#line 332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				tr.set(restoreWorkerKeyFor(myWorkerInterf.id()), restoreWorkerInterfaceValue(myWorkerInterf));
															#line 3329 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			tr.set(restoreLeaderKey, BinaryWriter::toValue(myWorkerInterf, IncludeVersion(ProtocolVersion::withRestoreWorkerInterfaceValue())));
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			leaderInterf = myWorkerInterf;
															#line 3338 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		}
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3344 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorleaderActor*>(this)->actor_wait_state = 3;
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorleaderActor, 2, Void >*>(static_cast<MonitorleaderActor*>(this)));
															#line 3349 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& leaderValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(leaderValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && leaderValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(leaderValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state > 0) static_cast<MonitorleaderActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorleaderActor*>(this)->ActorCallback< MonitorleaderActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorleaderActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		leader->set(leaderInterf);
															#line 3433 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		leader->set(leaderInterf);
															#line 3442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state > 0) static_cast<MonitorleaderActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorleaderActor*>(this)->ActorCallback< MonitorleaderActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorleaderActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorleaderActor*>(this)->actor_wait_state > 0) static_cast<MonitorleaderActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorleaderActor*>(this)->ActorCallback< MonitorleaderActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorleaderActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorleaderActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<AsyncVar<RestoreWorkerInterface>> leader;
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface myWorkerInterf;
															#line 315 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	int count;
															#line 316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface leaderInterf;
															#line 317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 3621 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorleader()
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class MonitorleaderActor final : public Actor<Void>, public ActorCallback< MonitorleaderActor, 0, Void >, public ActorCallback< MonitorleaderActor, 1, Optional<Value> >, public ActorCallback< MonitorleaderActor, 2, Void >, public ActorCallback< MonitorleaderActor, 3, Void >, public FastAllocated<MonitorleaderActor>, public MonitorleaderActorState<MonitorleaderActor> {
															#line 3626 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorleaderActor>::operator new;
	using FastAllocated<MonitorleaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17261276601835682304UL, 10023632368686475264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorleaderActor, 0, Void >;
friend struct ActorCallback< MonitorleaderActor, 1, Optional<Value> >;
friend struct ActorCallback< MonitorleaderActor, 2, Void >;
friend struct ActorCallback< MonitorleaderActor, 3, Void >;
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	MonitorleaderActor(Reference<AsyncVar<RestoreWorkerInterface>> const& leader,Database const& cx,RestoreWorkerInterface const& myWorkerInterf) 
															#line 3646 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorleaderActorState<MonitorleaderActor>(leader, cx, myWorkerInterf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorleader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8771406609886211584UL, 5171815810999277056UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorleaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorleader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorleader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorleaderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorleaderActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorleaderActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorleaderActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> monitorleader( Reference<AsyncVar<RestoreWorkerInterface>> const& leader, Database const& cx, RestoreWorkerInterface const& myWorkerInterf ) {
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new MonitorleaderActor(leader, cx, myWorkerInterf));
															#line 3682 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 356 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

															#line 3687 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via _restoreWorker()
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class _restoreWorkerActor>
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class _restoreWorkerActorState {
															#line 3694 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	_restoreWorkerActorState(Database const& cx,LocalityData const& locality) 
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : cx(cx),
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   locality(locality),
															#line 358 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   actors(false),
															#line 359 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   myWork(Never()),
															#line 360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   leader(makeReference<AsyncVar<RestoreWorkerInterface>>()),
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   myWorkerInterf(),
															#line 362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   self(makeReference<RestoreWorkerData>())
															#line 3713 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_restoreWorker", reinterpret_cast<unsigned long>(this));

	}
	~_restoreWorkerActorState() 
	{
		fdb_probe_actor_destroy("_restoreWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 364 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWorkerInterf.initEndpoints();
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			self->workerID = myWorkerInterf.id();
															#line 369 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (g_network->isSimulated())
															#line 3732 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			{
															#line 370 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				auto addresses = g_simulator->getProcessByAddress(myWorkerInterf.address())->addresses;
															#line 372 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				g_simulator->protectedAddresses.insert(addresses.address);
															#line 373 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				if (addresses.secondaryAddress.present())
															#line 3740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
				{
															#line 374 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
					g_simulator->protectedAddresses.insert(addresses.secondaryAddress.get());
															#line 3744 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
				}
															#line 376 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				ISimulator::ProcessInfo* p = g_simulator->getProcessByAddress(myWorkerInterf.address());
															#line 377 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				TraceEvent("ProtectRestoreWorker") .detail("Address", addresses.toString()) .detail("IsReliable", p->isReliable()) .detail("ReliableInfo", p->getReliableInfo()) .backtrace();
															#line 382 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				ASSERT(p->isReliable());
															#line 3752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			}
															#line 385 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent("FastRestoreWorkerKnobs", myWorkerInterf.id()) .detail("FailureTimeout", SERVER_KNOBS->FASTRESTORE_FAILURE_TIMEOUT) .detail("HeartBeat", SERVER_KNOBS->FASTRESTORE_HEARTBEAT_INTERVAL) .detail("SamplePercentage", SERVER_KNOBS->FASTRESTORE_SAMPLING_PERCENT) .detail("NumLoaders", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS) .detail("NumAppliers", SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS) .detail("TxnBatchSize", SERVER_KNOBS->FASTRESTORE_TXN_BATCH_MAX_BYTES) .detail("VersionBatchSize", SERVER_KNOBS->FASTRESTORE_VERSIONBATCH_MAX_BYTES);
															#line 394 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitOnRestoreRequests(cx, myWorkerInterf.id());
															#line 394 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3760 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 1;
															#line 394 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 0, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_restoreWorkerActorState();
		static_cast<_restoreWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = monitorleader(leader, cx, myWorkerInterf);
															#line 396 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3790 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 2;
															#line 396 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 1, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = monitorleader(leader, cx, myWorkerInterf);
															#line 396 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3806 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 2;
															#line 396 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 1, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3811 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<_restoreWorkerActor*>(this)->ActorCallback< _restoreWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _restoreWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()).detail("LeaderElection", "WaitForLeader");
															#line 399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (leader->get() == myWorkerInterf)
															#line 3897 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 401 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWork = startRestoreWorkerLeader(self, myWorkerInterf, cx);
															#line 3901 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 404 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWork = startRestoreWorker(self, myWorkerInterf, cx);
															#line 3907 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		}
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = myWork;
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3913 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 3;
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 2, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3918 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		TraceEvent("FastRestoreWorker", myWorkerInterf.id()).detail("LeaderElection", "WaitForLeader");
															#line 399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (leader->get() == myWorkerInterf)
															#line 3929 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		{
															#line 401 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWork = startRestoreWorkerLeader(self, myWorkerInterf, cx);
															#line 3933 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		}
		else
		{
															#line 404 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			myWork = startRestoreWorker(self, myWorkerInterf, cx);
															#line 3939 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		}
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = myWork;
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3945 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 3;
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _restoreWorkerActor, 2, Void >*>(static_cast<_restoreWorkerActor*>(this)));
															#line 3950 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<_restoreWorkerActor*>(this)->ActorCallback< _restoreWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _restoreWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<_restoreWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_restoreWorkerActorState(); static_cast<_restoreWorkerActor*>(this)->destroy(); return 0; }
															#line 4034 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<_restoreWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_restoreWorkerActorState();
		static_cast<_restoreWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<_restoreWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_restoreWorkerActorState(); static_cast<_restoreWorkerActor*>(this)->destroy(); return 0; }
															#line 4046 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<_restoreWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_restoreWorkerActorState();
		static_cast<_restoreWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_restoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<_restoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<_restoreWorkerActor*>(this)->ActorCallback< _restoreWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _restoreWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _restoreWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Database cx;
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	LocalityData locality;
															#line 358 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	ActorCollection actors;
															#line 359 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Future<Void> myWork;
															#line 360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<AsyncVar<RestoreWorkerInterface>> leader;
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerInterface myWorkerInterf;
															#line 362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<RestoreWorkerData> self;
															#line 4143 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _restoreWorker()
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class _restoreWorkerActor final : public Actor<Void>, public ActorCallback< _restoreWorkerActor, 0, Void >, public ActorCallback< _restoreWorkerActor, 1, Void >, public ActorCallback< _restoreWorkerActor, 2, Void >, public FastAllocated<_restoreWorkerActor>, public _restoreWorkerActorState<_restoreWorkerActor> {
															#line 4148 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<_restoreWorkerActor>::operator new;
	using FastAllocated<_restoreWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(76903023426415104UL, 11578958380195819008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _restoreWorkerActor, 0, Void >;
friend struct ActorCallback< _restoreWorkerActor, 1, Void >;
friend struct ActorCallback< _restoreWorkerActor, 2, Void >;
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	_restoreWorkerActor(Database const& cx,LocalityData const& locality) 
															#line 4167 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _restoreWorkerActorState<_restoreWorkerActor>(cx, locality),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_restoreWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(716177972706002688UL, 17248404509278918400UL);
		ActorExecutionContextHelper __helper(static_cast<_restoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_restoreWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_restoreWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _restoreWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _restoreWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _restoreWorkerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> _restoreWorker( Database const& cx, LocalityData const& locality ) {
															#line 357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new _restoreWorkerActor(cx, locality));
															#line 4202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 410 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"

															#line 4207 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via restoreWorker()
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
template <class RestoreWorkerActor>
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class RestoreWorkerActorState {
															#line 4214 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerActorState(Reference<IClusterConnectionRecord> const& connRecord,LocalityData const& locality,std::string const& coordFolder) 
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		 : connRecord(connRecord),
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   locality(locality),
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		   coordFolder(coordFolder)
															#line 4225 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("restoreWorker", reinterpret_cast<unsigned long>(this));

	}
	~RestoreWorkerActorState() 
	{
		fdb_probe_actor_destroy("restoreWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				Database cx = Database::createDatabase(connRecord, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 416 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = reportErrors(_restoreWorker(cx, locality), "RestoreWorker");
															#line 416 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				if (static_cast<RestoreWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4245 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RestoreWorkerActor*>(this)->actor_wait_state = 1;
															#line 416 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreWorkerActor, 0, Void >*>(static_cast<RestoreWorkerActor*>(this)));
															#line 4250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreWorkerActorState();
		static_cast<RestoreWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 422 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
		if (!static_cast<RestoreWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreWorkerActorState(); static_cast<RestoreWorkerActor*>(this)->destroy(); return 0; }
															#line 4279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		new (&static_cast<RestoreWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreWorkerActorState();
		static_cast<RestoreWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			TraceEvent("FastRestoreWorker").detail("Error", e.what());
															#line 419 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreWorkerActor*>(this)->actor_wait_state > 0) static_cast<RestoreWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreWorkerActor*>(this)->ActorCallback< RestoreWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	LocalityData locality;
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	std::string coordFolder;
															#line 4410 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
};
// This generated class is to be used only via restoreWorker()
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
class RestoreWorkerActor final : public Actor<Void>, public ActorCallback< RestoreWorkerActor, 0, Void >, public FastAllocated<RestoreWorkerActor>, public RestoreWorkerActorState<RestoreWorkerActor> {
															#line 4415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreWorkerActor>::operator new;
	using FastAllocated<RestoreWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10991536108911416832UL, 3418026896213728000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreWorkerActor, 0, Void >;
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	RestoreWorkerActor(Reference<IClusterConnectionRecord> const& connRecord,LocalityData const& locality,std::string const& coordFolder) 
															#line 4432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RestoreWorkerActorState<RestoreWorkerActor>(connRecord, locality, coordFolder),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14619944290362987264UL, 9188536933563828992UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreWorkerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
[[nodiscard]] Future<Void> restoreWorker( Reference<IClusterConnectionRecord> const& connRecord, LocalityData const& locality, std::string const& coordFolder ) {
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
	return Future<Void>(new RestoreWorkerActor(connRecord, locality, coordFolder));
															#line 4465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreWorker.actor.g.cpp.py_gen"
}

#line 424 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreWorker.actor.cpp"
