#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
/*
 * RestoreApplier.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file defines the functions used by the RestoreApplier role.
// RestoreApplier role starts at restoreApplierCore actor

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/BackupContainer.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RestoreCommon.actor.h"
#include "fdbserver/RestoreUtil.h"
#include "fdbserver/RestoreRoleCommon.actor.h"
#include "fdbserver/RestoreApplier.actor.h"

#include "flow/network.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 42 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> handleSendMutationVectorRequest( RestoreSendVersionedMutationsRequest const& req, Reference<RestoreApplierData> const& self );

#line 42 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 46 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> handleApplyToDBRequest( RestoreVersionBatchRequest const& req, Reference<RestoreApplierData> const& self, Database const& cx );

#line 45 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
void handleUpdateRateRequest(RestoreUpdateRateRequest req, Reference<RestoreApplierData> self);

															#line 52 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via restoreApplierCore()
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class RestoreApplierCoreActor>
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class RestoreApplierCoreActorState {
															#line 59 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	RestoreApplierCoreActorState(RestoreApplierInterface const& applierInterf,int const& nodeIndex,Database const& cx) 
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : applierInterf(applierInterf),
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   nodeIndex(nodeIndex),
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cx(cx),
															#line 48 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   self(makeReference<RestoreApplierData>(applierInterf.id(), nodeIndex)),
															#line 49 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   actors(false),
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   exitRole(Never())
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("restoreApplierCore", reinterpret_cast<unsigned long>(this));

	}
	~RestoreApplierCoreActorState() 
	{
		fdb_probe_actor_destroy("restoreApplierCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 52 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			actors.add(updateProcessMetrics(self));
															#line 53 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			actors.add(traceProcessMetrics(self, "RestoreApplier"));
															#line 54 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			actors.add(traceRoleVersionBatchProgress(self, "RestoreApplier"));
															#line 56 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			;
															#line 97 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreApplierCoreActorState();
		static_cast<RestoreApplierCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 109 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<RestoreApplierCoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreApplierCoreActorState(); static_cast<RestoreApplierCoreActor*>(this)->destroy(); return 0; }
															#line 120 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<RestoreApplierCoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreApplierCoreActorState();
		static_cast<RestoreApplierCoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 57 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "[Init]";
															#line 139 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		try {
															#line 61 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			auto __when_expr_0 = applierInterf.heartbeat.getFuture();
															#line 143 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<RestoreSimpleRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<RestoreSimpleRequest>>::value, "invalid type");
															#line 60 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<RestoreApplierCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 65 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			auto __when_expr_1 = applierInterf.sendMutationVector.getFuture();
															#line 151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<RestoreSendVersionedMutationsRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<RestoreSendVersionedMutationsRequest>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 70 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			auto __when_expr_2 = applierInterf.applyToDB.getFuture();
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_2), FutureStream<RestoreVersionBatchRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<RestoreVersionBatchRequest>>::value, "invalid type");
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			auto __when_expr_3 = applierInterf.updateRate.getFuture();
															#line 161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_3), FutureStream<RestoreUpdateRateRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<RestoreUpdateRateRequest>>::value, "invalid type");
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			auto __when_expr_4 = applierInterf.initVersionBatch.getFuture();
															#line 166 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_4), FutureStream<RestoreVersionBatchRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<RestoreVersionBatchRequest>>::value, "invalid type");
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			auto __when_expr_5 = applierInterf.finishRestore.getFuture();
															#line 171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<RestoreFinishRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<RestoreFinishRequest>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1when6(__when_expr_5.pop(), loopDepth); };
															#line 92 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_6 = actors.getResult();
															#line 176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when7(__when_expr_6.get(), loopDepth); };
															#line 93 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_7 = exitRole;
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1when8(__when_expr_7.get(), loopDepth); };
			static_cast<RestoreApplierCoreActor*>(this)->actor_wait_state = 1;
															#line 61 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreApplierCoreActor, 0, RestoreSimpleRequest >*>(static_cast<RestoreApplierCoreActor*>(this)));
															#line 65 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreApplierCoreActor, 1, RestoreSendVersionedMutationsRequest >*>(static_cast<RestoreApplierCoreActor*>(this)));
															#line 70 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreApplierCoreActor, 2, RestoreVersionBatchRequest >*>(static_cast<RestoreApplierCoreActor*>(this)));
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreApplierCoreActor, 3, RestoreUpdateRateRequest >*>(static_cast<RestoreApplierCoreActor*>(this)));
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreApplierCoreActor, 4, RestoreVersionBatchRequest >*>(static_cast<RestoreApplierCoreActor*>(this)));
															#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< RestoreApplierCoreActor, 5, RestoreFinishRequest >*>(static_cast<RestoreApplierCoreActor*>(this)));
															#line 92 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RestoreApplierCoreActor, 6, Void >*>(static_cast<RestoreApplierCoreActor*>(this)));
															#line 93 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RestoreApplierCoreActor, 7, Void >*>(static_cast<RestoreApplierCoreActor*>(this)));
															#line 199 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 100 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			bool isError = e.code() != error_code_operation_cancelled;
															#line 101 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent(isError ? SevError : SevWarnAlways, "FastRestoreApplierError", self->id()) .errorUnsuppressed(e) .detail("RequestType", requestTypeStr);
															#line 104 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			actors.clear(false);
															#line 238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSimpleRequest const& req,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "heartbeat";
															#line 63 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.add(handleHeartbeat(req, applierInterf.id()));
															#line 261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSimpleRequest && req,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "heartbeat";
															#line 63 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.add(handleHeartbeat(req, applierInterf.id()));
															#line 272 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(RestoreSendVersionedMutationsRequest const& req,int loopDepth) 
	{
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "sendMutationVector";
															#line 68 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.add(handleSendMutationVectorRequest(req, self));
															#line 283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(RestoreSendVersionedMutationsRequest && req,int loopDepth) 
	{
															#line 67 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "sendMutationVector";
															#line 68 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.add(handleSendMutationVectorRequest(req, self));
															#line 294 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(RestoreVersionBatchRequest const& req,int loopDepth) 
	{
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "applyToDB";
															#line 72 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.add(handleApplyToDBRequest( req, self, cx));
															#line 305 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(RestoreVersionBatchRequest && req,int loopDepth) 
	{
															#line 71 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "applyToDB";
															#line 72 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.add(handleApplyToDBRequest( req, self, cx));
															#line 316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(RestoreUpdateRateRequest const& req,int loopDepth) 
	{
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "updateRate";
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		handleUpdateRateRequest(req, self);
															#line 327 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(RestoreUpdateRateRequest && req,int loopDepth) 
	{
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "updateRate";
															#line 78 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		handleUpdateRateRequest(req, self);
															#line 338 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(RestoreVersionBatchRequest const& req,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "initVersionBatch";
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.add(handleInitVersionBatchRequest(req, self));
															#line 349 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(RestoreVersionBatchRequest && req,int loopDepth) 
	{
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "initVersionBatch";
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.add(handleInitVersionBatchRequest(req, self));
															#line 360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(RestoreFinishRequest const& req,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "finishRestore";
															#line 86 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.clear(false);
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		handleFinishRestoreRequest(req, self);
															#line 88 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (req.terminate)
															#line 375 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 89 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			exitRole = Void();
															#line 379 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(RestoreFinishRequest && req,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		requestTypeStr = "finishRestore";
															#line 86 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		actors.clear(false);
															#line 87 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		handleFinishRestoreRequest(req, self);
															#line 88 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (req.terminate)
															#line 395 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 89 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			exitRole = Void();
															#line 399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("RestoreApplierCoreExitRole", self->id());
															#line 421 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when8(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("RestoreApplierCoreExitRole", self->id());
															#line 430 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreApplierCoreActor*>(this)->actor_wait_state > 0) static_cast<RestoreApplierCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreApplierCoreActor*>(this)->ActorSingleCallback< RestoreApplierCoreActor, 0, RestoreSimpleRequest >::remove();
		static_cast<RestoreApplierCoreActor*>(this)->ActorSingleCallback< RestoreApplierCoreActor, 1, RestoreSendVersionedMutationsRequest >::remove();
		static_cast<RestoreApplierCoreActor*>(this)->ActorSingleCallback< RestoreApplierCoreActor, 2, RestoreVersionBatchRequest >::remove();
		static_cast<RestoreApplierCoreActor*>(this)->ActorSingleCallback< RestoreApplierCoreActor, 3, RestoreUpdateRateRequest >::remove();
		static_cast<RestoreApplierCoreActor*>(this)->ActorSingleCallback< RestoreApplierCoreActor, 4, RestoreVersionBatchRequest >::remove();
		static_cast<RestoreApplierCoreActor*>(this)->ActorSingleCallback< RestoreApplierCoreActor, 5, RestoreFinishRequest >::remove();
		static_cast<RestoreApplierCoreActor*>(this)->ActorCallback< RestoreApplierCoreActor, 6, Void >::remove();
		static_cast<RestoreApplierCoreActor*>(this)->ActorCallback< RestoreApplierCoreActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 0, RestoreSimpleRequest >*,RestoreSimpleRequest const& value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 0, RestoreSimpleRequest >*,RestoreSimpleRequest && value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RestoreApplierCoreActor, 0, RestoreSimpleRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 1, RestoreSendVersionedMutationsRequest >*,RestoreSendVersionedMutationsRequest const& value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 1, RestoreSendVersionedMutationsRequest >*,RestoreSendVersionedMutationsRequest && value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RestoreApplierCoreActor, 1, RestoreSendVersionedMutationsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 2, RestoreVersionBatchRequest >*,RestoreVersionBatchRequest const& value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 2, RestoreVersionBatchRequest >*,RestoreVersionBatchRequest && value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< RestoreApplierCoreActor, 2, RestoreVersionBatchRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 3, RestoreUpdateRateRequest >*,RestoreUpdateRateRequest const& value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 3, RestoreUpdateRateRequest >*,RestoreUpdateRateRequest && value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< RestoreApplierCoreActor, 3, RestoreUpdateRateRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 4, RestoreVersionBatchRequest >*,RestoreVersionBatchRequest const& value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 4, RestoreVersionBatchRequest >*,RestoreVersionBatchRequest && value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< RestoreApplierCoreActor, 4, RestoreVersionBatchRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 5, RestoreFinishRequest >*,RestoreFinishRequest const& value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RestoreApplierCoreActor, 5, RestoreFinishRequest >*,RestoreFinishRequest && value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< RestoreApplierCoreActor, 5, RestoreFinishRequest >*,Error err) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RestoreApplierCoreActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RestoreApplierCoreActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RestoreApplierCoreActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RestoreApplierCoreActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RestoreApplierCoreActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RestoreApplierCoreActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	RestoreApplierInterface applierInterf;
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int nodeIndex;
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Database cx;
															#line 48 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<RestoreApplierData> self;
															#line 49 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ActorCollection actors;
															#line 50 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Future<Void> exitRole;
															#line 57 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	std::string requestTypeStr;
															#line 931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via restoreApplierCore()
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class RestoreApplierCoreActor final : public Actor<Void>, public ActorSingleCallback< RestoreApplierCoreActor, 0, RestoreSimpleRequest >, public ActorSingleCallback< RestoreApplierCoreActor, 1, RestoreSendVersionedMutationsRequest >, public ActorSingleCallback< RestoreApplierCoreActor, 2, RestoreVersionBatchRequest >, public ActorSingleCallback< RestoreApplierCoreActor, 3, RestoreUpdateRateRequest >, public ActorSingleCallback< RestoreApplierCoreActor, 4, RestoreVersionBatchRequest >, public ActorSingleCallback< RestoreApplierCoreActor, 5, RestoreFinishRequest >, public ActorCallback< RestoreApplierCoreActor, 6, Void >, public ActorCallback< RestoreApplierCoreActor, 7, Void >, public FastAllocated<RestoreApplierCoreActor>, public RestoreApplierCoreActorState<RestoreApplierCoreActor> {
															#line 936 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreApplierCoreActor>::operator new;
	using FastAllocated<RestoreApplierCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6844056509049478400UL, 12117281273029222400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RestoreApplierCoreActor, 0, RestoreSimpleRequest >;
friend struct ActorSingleCallback< RestoreApplierCoreActor, 1, RestoreSendVersionedMutationsRequest >;
friend struct ActorSingleCallback< RestoreApplierCoreActor, 2, RestoreVersionBatchRequest >;
friend struct ActorSingleCallback< RestoreApplierCoreActor, 3, RestoreUpdateRateRequest >;
friend struct ActorSingleCallback< RestoreApplierCoreActor, 4, RestoreVersionBatchRequest >;
friend struct ActorSingleCallback< RestoreApplierCoreActor, 5, RestoreFinishRequest >;
friend struct ActorCallback< RestoreApplierCoreActor, 6, Void >;
friend struct ActorCallback< RestoreApplierCoreActor, 7, Void >;
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	RestoreApplierCoreActor(RestoreApplierInterface const& applierInterf,int const& nodeIndex,Database const& cx) 
															#line 960 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RestoreApplierCoreActorState<RestoreApplierCoreActor>(applierInterf, nodeIndex, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreApplierCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14990918345305579776UL, 10819821081056009472UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreApplierCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreApplierCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreApplierCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RestoreApplierCoreActor, 0, RestoreSimpleRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] Future<Void> restoreApplierCore( RestoreApplierInterface const& applierInterf, int const& nodeIndex, Database const& cx ) {
															#line 47 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new RestoreApplierCoreActor(applierInterf, nodeIndex, cx));
															#line 993 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

// The actor may be invoked multiple times and executed async.
// No race condition as long as we do not wait or yield when operate the shared
// data. Multiple such actors can run on different fileIDs.
// Different files may contain mutations of the same commit versions, but with
// different subsequence number.
// Only one actor can process mutations from the same file.
															#line 1004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleSendMutationVectorRequest()
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class HandleSendMutationVectorRequestActor>
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class HandleSendMutationVectorRequestActorState {
															#line 1011 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	HandleSendMutationVectorRequestActorState(RestoreSendVersionedMutationsRequest const& req,Reference<RestoreApplierData> const& self) 
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : req(req),
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   self(self),
															#line 120 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchData(),
															#line 121 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   printTrace(false),
															#line 122 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   curMsgIndex(nullptr)
															#line 1026 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleSendMutationVectorRequestActorState() 
	{
		fdb_probe_actor_destroy("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (req.batchIndex <= self->finishedBatch.get())
															#line 1041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 125 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				TraceEvent(SevWarn, "FastRestoreApplierRestoreSendVersionedMutationsRequestTooLate") .detail("RequestBatchIndex", req.batchIndex) .detail("FinishedBatchIndex", self->finishedBatch.get());
															#line 128 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				req.reply.send(RestoreCommonReply(self->id(), true));
															#line 129 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT_WE_THINK(false);
															#line 130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (!static_cast<HandleSendMutationVectorRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleSendMutationVectorRequestActorState(); static_cast<HandleSendMutationVectorRequestActor*>(this)->destroy(); return 0; }
															#line 1051 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				new (&static_cast<HandleSendMutationVectorRequestActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~HandleSendMutationVectorRequestActorState();
				static_cast<HandleSendMutationVectorRequestActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 133 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			batchData = self->batch[req.batchIndex];
															#line 135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(batchData.isValid());
															#line 136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(self->finishedBatch.get() < req.batchIndex);
															#line 140 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			batchData->receiveMutationReqs += 1;
															#line 144 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			printTrace = (batchData->receiveMutationReqs % SERVER_KNOBS->FASTRESTORE_NUM_TRACE_EVENTS == 0);
															#line 145 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent(printTrace ? SevInfo : SevFRDebugInfo, "FastRestoreApplierPhaseReceiveMutations", self->id()) .detail("BatchIndex", req.batchIndex) .detail("RestoreAsset", req.asset.toString()) .detail("RestoreAssetMesssageIndex", batchData->processedFileState[req.asset].get()) .detail("Request", req.toString()) .detail("CurrentMemory", getSystemStatistics().processMemory) .detail("PreviousVersionBatchState", batchData->vbState.get()) .detail("ReceiveMutationRequests", batchData->receiveMutationReqs);
															#line 154 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = isSchedulable(self, req.batchIndex, __FUNCTION__);
															#line 154 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1073 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state = 1;
															#line 154 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleSendMutationVectorRequestActor, 0, Void >*>(static_cast<HandleSendMutationVectorRequestActor*>(this)));
															#line 1078 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleSendMutationVectorRequestActorState();
		static_cast<HandleSendMutationVectorRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		ASSERT(batchData.isValid());
															#line 157 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		ASSERT(req.batchIndex > self->finishedBatch.get());
															#line 160 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		curMsgIndex = &batchData->processedFileState[req.asset];
															#line 161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = curMsgIndex->whenAtLeast(req.msgIndex - 1);
															#line 161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1109 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state = 2;
															#line 161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >*>(static_cast<HandleSendMutationVectorRequestActor*>(this)));
															#line 1114 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		ASSERT(batchData.isValid());
															#line 157 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		ASSERT(req.batchIndex > self->finishedBatch.get());
															#line 160 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		curMsgIndex = &batchData->processedFileState[req.asset];
															#line 161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = curMsgIndex->whenAtLeast(req.msgIndex - 1);
															#line 161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1131 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state = 2;
															#line 161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >*>(static_cast<HandleSendMutationVectorRequestActor*>(this)));
															#line 1136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleSendMutationVectorRequestActor*>(this)->ActorCallback< HandleSendMutationVectorRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleSendMutationVectorRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationVectorRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleSendMutationVectorRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationVectorRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleSendMutationVectorRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationVectorRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		batchData->vbState = ApplierVersionBatchState::RECEIVE_MUTATIONS;
															#line 164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		isDuplicated = true;
															#line 165 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (curMsgIndex->get() == req.msgIndex - 1)
															#line 1224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 166 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			isDuplicated = false;
															#line 168 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for(int mIndex = 0;mIndex < req.versionedMutations.size();mIndex++) {
															#line 169 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				const VersionedMutationSerialized& versionedMutation = req.versionedMutations[mIndex];
															#line 170 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreApplierPhaseReceiveMutations", self->id()) .detail("RestoreAsset", req.asset.toString()) .detail("Version", versionedMutation.version.toString()) .detail("Index", mIndex) .detail("MutationReceived", versionedMutation.mutation.toString());
															#line 175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->receivedBytes += versionedMutation.mutation.totalSize();
															#line 176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->counters.receivedBytes += versionedMutation.mutation.totalSize();
															#line 177 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->counters.receivedWeightedBytes += versionedMutation.mutation.weightedTotalSize();
															#line 179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->counters.receivedMutations += 1;
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->counters.receivedAtomicOps += isAtomicOp((MutationRef::Type)versionedMutation.mutation.type) ? 1 : 0;
															#line 183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT_WE_THINK(req.asset.isInVersionRange(versionedMutation.version.version));
															#line 184 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT_WE_THINK(req.asset.isInKeyRange( versionedMutation.mutation));
															#line 188 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->addMutation(versionedMutation.mutation, versionedMutation.version);
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT(versionedMutation.mutation.type != MutationRef::SetVersionstampedKey && versionedMutation.mutation.type != MutationRef::SetVersionstampedValue);
															#line 1252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			curMsgIndex->set(req.msgIndex);
															#line 1256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		}
															#line 196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		req.reply.send(RestoreCommonReply(self->id(), isDuplicated));
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent(printTrace ? SevInfo : SevFRDebugInfo, "FastRestoreApplierPhaseReceiveMutationsDone", self->id()) .detail("BatchIndex", req.batchIndex) .detail("RestoreAsset", req.asset.toString()) .detail("ProcessedMessageIndex", curMsgIndex->get()) .detail("Request", req.toString());
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<HandleSendMutationVectorRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleSendMutationVectorRequestActorState(); static_cast<HandleSendMutationVectorRequestActor*>(this)->destroy(); return 0; }
															#line 1264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<HandleSendMutationVectorRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleSendMutationVectorRequestActorState();
		static_cast<HandleSendMutationVectorRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		batchData->vbState = ApplierVersionBatchState::RECEIVE_MUTATIONS;
															#line 164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		isDuplicated = true;
															#line 165 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (curMsgIndex->get() == req.msgIndex - 1)
															#line 1280 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 166 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			isDuplicated = false;
															#line 168 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for(int mIndex = 0;mIndex < req.versionedMutations.size();mIndex++) {
															#line 169 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				const VersionedMutationSerialized& versionedMutation = req.versionedMutations[mIndex];
															#line 170 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreApplierPhaseReceiveMutations", self->id()) .detail("RestoreAsset", req.asset.toString()) .detail("Version", versionedMutation.version.toString()) .detail("Index", mIndex) .detail("MutationReceived", versionedMutation.mutation.toString());
															#line 175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->receivedBytes += versionedMutation.mutation.totalSize();
															#line 176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->counters.receivedBytes += versionedMutation.mutation.totalSize();
															#line 177 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->counters.receivedWeightedBytes += versionedMutation.mutation.weightedTotalSize();
															#line 179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->counters.receivedMutations += 1;
															#line 180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->counters.receivedAtomicOps += isAtomicOp((MutationRef::Type)versionedMutation.mutation.type) ? 1 : 0;
															#line 183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT_WE_THINK(req.asset.isInVersionRange(versionedMutation.version.version));
															#line 184 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT_WE_THINK(req.asset.isInKeyRange( versionedMutation.mutation));
															#line 188 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->addMutation(versionedMutation.mutation, versionedMutation.version);
															#line 190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT(versionedMutation.mutation.type != MutationRef::SetVersionstampedKey && versionedMutation.mutation.type != MutationRef::SetVersionstampedValue);
															#line 1308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			curMsgIndex->set(req.msgIndex);
															#line 1312 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		}
															#line 196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		req.reply.send(RestoreCommonReply(self->id(), isDuplicated));
															#line 197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent(printTrace ? SevInfo : SevFRDebugInfo, "FastRestoreApplierPhaseReceiveMutationsDone", self->id()) .detail("BatchIndex", req.batchIndex) .detail("RestoreAsset", req.asset.toString()) .detail("ProcessedMessageIndex", curMsgIndex->get()) .detail("Request", req.toString());
															#line 202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<HandleSendMutationVectorRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleSendMutationVectorRequestActorState(); static_cast<HandleSendMutationVectorRequestActor*>(this)->destroy(); return 0; }
															#line 1320 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<HandleSendMutationVectorRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleSendMutationVectorRequestActorState();
		static_cast<HandleSendMutationVectorRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleSendMutationVectorRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleSendMutationVectorRequestActor*>(this)->ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationVectorRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationVectorRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationVectorRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	RestoreSendVersionedMutationsRequest req;
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<RestoreApplierData> self;
															#line 120 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ApplierBatchData> batchData;
															#line 121 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	bool printTrace;
															#line 122 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	NotifiedVersion* curMsgIndex;
															#line 164 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	bool isDuplicated;
															#line 1415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleSendMutationVectorRequest()
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class HandleSendMutationVectorRequestActor final : public Actor<Void>, public ActorCallback< HandleSendMutationVectorRequestActor, 0, Void >, public ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >, public FastAllocated<HandleSendMutationVectorRequestActor>, public HandleSendMutationVectorRequestActorState<HandleSendMutationVectorRequestActor> {
															#line 1420 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleSendMutationVectorRequestActor>::operator new;
	using FastAllocated<HandleSendMutationVectorRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15637348199069260288UL, 15554516456268531968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleSendMutationVectorRequestActor, 0, Void >;
friend struct ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >;
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	HandleSendMutationVectorRequestActor(RestoreSendVersionedMutationsRequest const& req,Reference<RestoreApplierData> const& self) 
															#line 1438 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleSendMutationVectorRequestActorState<HandleSendMutationVectorRequestActor>(req, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17708851988550603264UL, 4109837025602147584UL);
		ActorExecutionContextHelper __helper(static_cast<HandleSendMutationVectorRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleSendMutationVectorRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleSendMutationVectorRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleSendMutationVectorRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleSendMutationVectorRequestActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> handleSendMutationVectorRequest( RestoreSendVersionedMutationsRequest const& req, Reference<RestoreApplierData> const& self ) {
															#line 118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new HandleSendMutationVectorRequestActor(req, self));
															#line 1472 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 204 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

// Clear all ranges in input ranges
															#line 1478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via applyClearRangeMutations()
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class ApplyClearRangeMutationsActor>
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class ApplyClearRangeMutationsActorState {
															#line 1485 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplyClearRangeMutationsActorState(Standalone<VectorRef<KeyRangeRef>> const& ranges,double const& delayTime,Database const& cx,UID const& applierID,int const& batchIndex,ApplierBatchData::Counters* const& cc) 
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : ranges(ranges),
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   delayTime(delayTime),
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cx(cx),
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   applierID(applierID),
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchIndex(batchIndex),
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cc(cc),
															#line 212 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 213 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   retries(0),
															#line 214 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   numOps(0)
															#line 1508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("applyClearRangeMutations", reinterpret_cast<unsigned long>(this));

	}
	~ApplyClearRangeMutationsActorState() 
	{
		fdb_probe_actor_destroy("applyClearRangeMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(delayTime + deterministicRandom()->random01() * delayTime);
															#line 215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1525 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state = 1;
															#line 215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ApplyClearRangeMutationsActor, 0, Void >*>(static_cast<ApplyClearRangeMutationsActor*>(this)));
															#line 1530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ApplyClearRangeMutationsActorState();
		static_cast<ApplyClearRangeMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent(delayTime > 5 ? SevWarnAlways : SevDebug, "FastRestoreApplierClearRangeMutationsStart", applierID) .detail("BatchIndex", batchIndex) .detail("Ranges", ranges.size()) .detail("DelayTime", delayTime);
															#line 220 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_NOT_WRITE_DB)
															#line 1555 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 221 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplierClearRangeMutationsNotWriteDB", applierID) .detail("BatchIndex", batchIndex) .detail("Ranges", ranges.size());
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(!g_network->isSimulated());
															#line 225 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (!static_cast<ApplyClearRangeMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyClearRangeMutationsActorState(); static_cast<ApplyClearRangeMutationsActor*>(this)->destroy(); return 0; }
															#line 1563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			new (&static_cast<ApplyClearRangeMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ApplyClearRangeMutationsActorState();
			static_cast<ApplyClearRangeMutationsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		;
															#line 1571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent(delayTime > 5 ? SevWarnAlways : SevDebug, "FastRestoreApplierClearRangeMutationsStart", applierID) .detail("BatchIndex", batchIndex) .detail("Ranges", ranges.size()) .detail("DelayTime", delayTime);
															#line 220 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_NOT_WRITE_DB)
															#line 1582 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 221 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplierClearRangeMutationsNotWriteDB", applierID) .detail("BatchIndex", batchIndex) .detail("Ranges", ranges.size());
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(!g_network->isSimulated());
															#line 225 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (!static_cast<ApplyClearRangeMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyClearRangeMutationsActorState(); static_cast<ApplyClearRangeMutationsActor*>(this)->destroy(); return 0; }
															#line 1590 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			new (&static_cast<ApplyClearRangeMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ApplyClearRangeMutationsActorState();
			static_cast<ApplyClearRangeMutationsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		;
															#line 1598 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state > 0) static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyClearRangeMutationsActor*>(this)->ActorCallback< ApplyClearRangeMutationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyClearRangeMutationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ApplyClearRangeMutationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ApplyClearRangeMutationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<ApplyClearRangeMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyClearRangeMutationsActorState(); static_cast<ApplyClearRangeMutationsActor*>(this)->destroy(); return 0; }
															#line 1682 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<ApplyClearRangeMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ApplyClearRangeMutationsActorState();
		static_cast<ApplyClearRangeMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 232 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for( auto& range : ranges ) {
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				debugFRMutation("FastRestoreApplierApplyClearRangeMutation", 0, MutationRef(MutationRef::ClearRange, range.begin, range.end));
															#line 237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				tr->clear(range);
															#line 238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				cc->clearOps += 1;
															#line 239 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				++numOps;
															#line 240 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (numOps >= SERVER_KNOBS->FASTRESTORE_TXN_CLEAR_MAX)
															#line 1716 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 241 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					TraceEvent(SevWarn, "FastRestoreApplierClearRangeMutationsTooManyClearsInTxn") .suppressFor(5.0) .detail("Clears", numOps) .detail("Ranges", ranges.size()) .detail("Range", range.toString());
															#line 1720 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
			}
															#line 248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1727 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state = 2;
															#line 248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ApplyClearRangeMutationsActor, 1, Void >*>(static_cast<ApplyClearRangeMutationsActor*>(this)));
															#line 1732 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			retries++;
															#line 253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (retries > SERVER_KNOBS->FASTRESTORE_TXN_RETRY_MAX)
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 254 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				TraceEvent(SevWarnAlways, "RestoreApplierApplyClearRangeMutationsStuck", applierID) .error(e) .detail("BatchIndex", batchIndex) .detail("ClearRanges", ranges.size());
															#line 1773 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1779 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state = 3;
															#line 259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ApplyClearRangeMutationsActor, 2, Void >*>(static_cast<ApplyClearRangeMutationsActor*>(this)));
															#line 1784 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 249 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		cc->clearTxns += 1;
															#line 1799 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 249 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		cc->clearTxns += 1;
															#line 1808 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state > 0) static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyClearRangeMutationsActor*>(this)->ActorCallback< ApplyClearRangeMutationsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyClearRangeMutationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ApplyClearRangeMutationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ApplyClearRangeMutationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state > 0) static_cast<ApplyClearRangeMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyClearRangeMutationsActor*>(this)->ActorCallback< ApplyClearRangeMutationsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyClearRangeMutationsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ApplyClearRangeMutationsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ApplyClearRangeMutationsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double delayTime;
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Database cx;
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	UID applierID;
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int batchIndex;
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplierBatchData::Counters* cc;
															#line 212 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 213 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int retries;
															#line 214 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double numOps;
															#line 1993 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via applyClearRangeMutations()
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class ApplyClearRangeMutationsActor final : public Actor<Void>, public ActorCallback< ApplyClearRangeMutationsActor, 0, Void >, public ActorCallback< ApplyClearRangeMutationsActor, 1, Void >, public ActorCallback< ApplyClearRangeMutationsActor, 2, Void >, public FastAllocated<ApplyClearRangeMutationsActor>, public ApplyClearRangeMutationsActorState<ApplyClearRangeMutationsActor> {
															#line 1998 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<ApplyClearRangeMutationsActor>::operator new;
	using FastAllocated<ApplyClearRangeMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11362867383757151744UL, 12183024227816472064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ApplyClearRangeMutationsActor, 0, Void >;
friend struct ActorCallback< ApplyClearRangeMutationsActor, 1, Void >;
friend struct ActorCallback< ApplyClearRangeMutationsActor, 2, Void >;
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplyClearRangeMutationsActor(Standalone<VectorRef<KeyRangeRef>> const& ranges,double const& delayTime,Database const& cx,UID const& applierID,int const& batchIndex,ApplierBatchData::Counters* const& cc) 
															#line 2017 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ApplyClearRangeMutationsActorState<ApplyClearRangeMutationsActor>(ranges, delayTime, cx, applierID, batchIndex, cc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17413642343535403776UL, 2695281329119648512UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyClearRangeMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("applyClearRangeMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("applyClearRangeMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ApplyClearRangeMutationsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ApplyClearRangeMutationsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ApplyClearRangeMutationsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> applyClearRangeMutations( Standalone<VectorRef<KeyRangeRef>> const& ranges, double const& delayTime, Database const& cx, UID const& applierID, int const& batchIndex, ApplierBatchData::Counters* const& cc ) {
															#line 206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new ApplyClearRangeMutationsActor(ranges, delayTime, cx, applierID, batchIndex, cc));
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

// Get keys in incompleteStagingKeys and precompute the stagingKey which is stored in batchData->stagingKeys
															#line 2058 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAndComputeStagingKeys()
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class GetAndComputeStagingKeysActor>
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class GetAndComputeStagingKeysActorState {
															#line 2065 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	GetAndComputeStagingKeysActorState(std::map<Key, std::map<Key, StagingKey>::iterator> const& incompleteStagingKeys,double const& delayTime,Database const& cx,UID const& applierID,int const& batchIndex,ApplierBatchData::Counters* const& cc) 
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : incompleteStagingKeys(incompleteStagingKeys),
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   delayTime(delayTime),
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cx(cx),
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   applierID(applierID),
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchIndex(batchIndex),
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cc(cc),
															#line 273 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx)),
															#line 274 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   fValues(incompleteStagingKeys.size(), Never()),
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   retries(0),
															#line 276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   randomID(deterministicRandom()->randomUniqueID())
															#line 2090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this));

	}
	~GetAndComputeStagingKeysActorState() 
	{
		fdb_probe_actor_destroy("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(delayTime + deterministicRandom()->random01() * delayTime);
															#line 278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2107 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state = 1;
															#line 278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAndComputeStagingKeysActor, 0, Void >*>(static_cast<GetAndComputeStagingKeysActor*>(this)));
															#line 2112 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAndComputeStagingKeysActorState();
		static_cast<GetAndComputeStagingKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_NOT_WRITE_DB)
															#line 2135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 281 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplierGetAndComputeStagingKeysStartNotUseDB", applierID) .detail("RandomUID", randomID) .detail("BatchIndex", batchIndex) .detail("GetKeys", incompleteStagingKeys.size()) .detail("DelayTime", delayTime);
															#line 286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(!g_network->isSimulated());
															#line 287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for( auto& key : incompleteStagingKeys ) {
															#line 288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				MutationRef m(MutationRef::SetValue, key.first, "0"_sr);
															#line 289 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				key.second->second.add(m, LogMessageVersion(1));
															#line 290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				key.second->second.precomputeResult("GetAndComputeStagingKeys", applierID, batchIndex);
															#line 2149 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (!static_cast<GetAndComputeStagingKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndComputeStagingKeysActorState(); static_cast<GetAndComputeStagingKeysActor*>(this)->destroy(); return 0; }
															#line 2153 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			new (&static_cast<GetAndComputeStagingKeysActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetAndComputeStagingKeysActorState();
			static_cast<GetAndComputeStagingKeysActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplierGetAndComputeStagingKeysStart", applierID) .detail("RandomUID", randomID) .detail("BatchIndex", batchIndex) .detail("GetKeys", incompleteStagingKeys.size()) .detail("DelayTime", delayTime);
															#line 301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		;
															#line 2163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_NOT_WRITE_DB)
															#line 2172 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 281 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplierGetAndComputeStagingKeysStartNotUseDB", applierID) .detail("RandomUID", randomID) .detail("BatchIndex", batchIndex) .detail("GetKeys", incompleteStagingKeys.size()) .detail("DelayTime", delayTime);
															#line 286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(!g_network->isSimulated());
															#line 287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for( auto& key : incompleteStagingKeys ) {
															#line 288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				MutationRef m(MutationRef::SetValue, key.first, "0"_sr);
															#line 289 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				key.second->second.add(m, LogMessageVersion(1));
															#line 290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				key.second->second.precomputeResult("GetAndComputeStagingKeys", applierID, batchIndex);
															#line 2186 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (!static_cast<GetAndComputeStagingKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndComputeStagingKeysActorState(); static_cast<GetAndComputeStagingKeysActor*>(this)->destroy(); return 0; }
															#line 2190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			new (&static_cast<GetAndComputeStagingKeysActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetAndComputeStagingKeysActorState();
			static_cast<GetAndComputeStagingKeysActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplierGetAndComputeStagingKeysStart", applierID) .detail("RandomUID", randomID) .detail("BatchIndex", batchIndex) .detail("GetKeys", incompleteStagingKeys.size()) .detail("DelayTime", delayTime);
															#line 301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		;
															#line 2200 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state > 0) static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state = 0;
		static_cast<GetAndComputeStagingKeysActor*>(this)->ActorCallback< GetAndComputeStagingKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAndComputeStagingKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAndComputeStagingKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAndComputeStagingKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		ASSERT(fValues.size() == incompleteStagingKeys.size());
															#line 329 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		int i = 0;
															#line 330 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		for( auto& key : incompleteStagingKeys ) {
															#line 331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (!fValues[i].get().present())
															#line 2290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 333 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				TraceEvent(SevDebug, "FastRestoreApplierGetAndComputeStagingKeysNoBaseValueInDB", applierID) .suppressFor(5.0) .detail("BatchIndex", batchIndex) .detail("Key", key.first) .detail("IsReady", fValues[i].isReady()) .detail("PendingMutations", key.second->second.pendingMutations.size()) .detail("StagingKeyType", getTypeString(key.second->second.type));
															#line 340 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				for( auto& vm : key.second->second.pendingMutations ) {
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					TraceEvent(SevDebug, "FastRestoreApplierGetAndComputeStagingKeysNoBaseValueInDB") .detail("PendingMutationVersion", vm.first.toString()) .detail("PendingMutation", vm.second.toString());
															#line 2298 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
															#line 345 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				key.second->second.precomputeResult("GetAndComputeStagingKeysNoBaseValueInDB", applierID, batchIndex);
															#line 2302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
			else
			{
															#line 349 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				MutationRef m(MutationRef::SetValue, key.first, fValues[i].get().get());
															#line 350 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				key.second->second.add(m, LogMessageVersion(1));
															#line 351 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				key.second->second.precomputeResult("GetAndComputeStagingKeys", applierID, batchIndex);
															#line 2312 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 353 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			i++;
															#line 2316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		}
															#line 356 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplierGetAndComputeStagingKeysDone", applierID) .detail("RandomUID", randomID) .detail("BatchIndex", batchIndex) .detail("GetKeys", incompleteStagingKeys.size()) .detail("DelayTime", delayTime);
															#line 362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<GetAndComputeStagingKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndComputeStagingKeysActorState(); static_cast<GetAndComputeStagingKeysActor*>(this)->destroy(); return 0; }
															#line 2322 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<GetAndComputeStagingKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAndComputeStagingKeysActorState();
		static_cast<GetAndComputeStagingKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 303 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			int i = 0;
															#line 304 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 305 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 306 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for( auto& key : incompleteStagingKeys ) {
															#line 307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				fValues[i++] = tr->get(key.first);
															#line 308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				cc->fetchKeys += 1;
															#line 2352 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(fValues);
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2358 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state = 2;
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAndComputeStagingKeysActor, 1, Void >*>(static_cast<GetAndComputeStagingKeysActor*>(this)));
															#line 2363 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 314 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			cc->fetchTxnRetries += 1;
															#line 315 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (retries++ > incompleteStagingKeys.size())
															#line 2400 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (e.code() != error_code_actor_cancelled)
															#line 2404 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					TraceEvent(SevWarnAlways, "GetAndComputeStagingKeys", applierID) .errorUnsuppressed(e) .suppressFor(1.0) .detail("RandomUID", randomID) .detail("BatchIndex", batchIndex);
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
			}
															#line 324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state = 3;
															#line 324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetAndComputeStagingKeysActor, 2, Void >*>(static_cast<GetAndComputeStagingKeysActor*>(this)));
															#line 2420 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		cc->fetchTxns += 1;
															#line 2435 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		cc->fetchTxns += 1;
															#line 2444 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state > 0) static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state = 0;
		static_cast<GetAndComputeStagingKeysActor*>(this)->ActorCallback< GetAndComputeStagingKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAndComputeStagingKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAndComputeStagingKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAndComputeStagingKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state > 0) static_cast<GetAndComputeStagingKeysActor*>(this)->actor_wait_state = 0;
		static_cast<GetAndComputeStagingKeysActor*>(this)->ActorCallback< GetAndComputeStagingKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAndComputeStagingKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetAndComputeStagingKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetAndComputeStagingKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	std::map<Key, std::map<Key, StagingKey>::iterator> incompleteStagingKeys;
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double delayTime;
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Database cx;
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	UID applierID;
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int batchIndex;
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplierBatchData::Counters* cc;
															#line 273 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 274 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	std::vector<Future<Optional<Value>>> fValues;
															#line 275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int retries;
															#line 276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	UID randomID;
															#line 2631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAndComputeStagingKeys()
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class GetAndComputeStagingKeysActor final : public Actor<Void>, public ActorCallback< GetAndComputeStagingKeysActor, 0, Void >, public ActorCallback< GetAndComputeStagingKeysActor, 1, Void >, public ActorCallback< GetAndComputeStagingKeysActor, 2, Void >, public FastAllocated<GetAndComputeStagingKeysActor>, public GetAndComputeStagingKeysActorState<GetAndComputeStagingKeysActor> {
															#line 2636 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAndComputeStagingKeysActor>::operator new;
	using FastAllocated<GetAndComputeStagingKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2165362261702587392UL, 8382892588310363904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAndComputeStagingKeysActor, 0, Void >;
friend struct ActorCallback< GetAndComputeStagingKeysActor, 1, Void >;
friend struct ActorCallback< GetAndComputeStagingKeysActor, 2, Void >;
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	GetAndComputeStagingKeysActor(std::map<Key, std::map<Key, StagingKey>::iterator> const& incompleteStagingKeys,double const& delayTime,Database const& cx,UID const& applierID,int const& batchIndex,ApplierBatchData::Counters* const& cc) 
															#line 2655 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetAndComputeStagingKeysActorState<GetAndComputeStagingKeysActor>(incompleteStagingKeys, delayTime, cx, applierID, batchIndex, cc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5354099649968030208UL, 5909034086143852800UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndComputeStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAndComputeStagingKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAndComputeStagingKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAndComputeStagingKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAndComputeStagingKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetAndComputeStagingKeysActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> getAndComputeStagingKeys( std::map<Key, std::map<Key, StagingKey>::iterator> const& incompleteStagingKeys, double const& delayTime, Database const& cx, UID const& applierID, int const& batchIndex, ApplierBatchData::Counters* const& cc ) {
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new GetAndComputeStagingKeysActor(incompleteStagingKeys, delayTime, cx, applierID, batchIndex, cc));
															#line 2690 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 364 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

															#line 2695 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via precomputeMutationsResult()
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class PrecomputeMutationsResultActor>
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class PrecomputeMutationsResultActorState {
															#line 2702 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	PrecomputeMutationsResultActorState(Reference<ApplierBatchData> const& batchData,UID const& applierID,int64_t const& batchIndex,Database const& cx) 
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : batchData(batchData),
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   applierID(applierID),
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchIndex(batchIndex),
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cx(cx)
															#line 2715 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("precomputeMutationsResult", reinterpret_cast<unsigned long>(this));

	}
	~PrecomputeMutationsResultActorState() 
	{
		fdb_probe_actor_destroy("precomputeMutationsResult", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 370 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResultStart", applierID) .detail("BatchIndex", batchIndex) .detail("Step", "Applying clear range mutations to DB") .detail("ClearRanges", batchData->stagingKeyRanges.size());
															#line 374 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			fClearRanges = std::vector<Future<Void>>();
															#line 375 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			Standalone<VectorRef<KeyRangeRef>> clearRanges;
															#line 376 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			double curTxnSize = 0;
															#line 2736 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				double delayTime = 0;
															#line 379 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				for( auto& rangeMutation : batchData->stagingKeyRanges ) {
															#line 380 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					KeyRangeRef range(rangeMutation.mutation.param1, rangeMutation.mutation.param2);
															#line 381 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					debugFRMutation("FastRestoreApplierPrecomputeMutationsResultClearRange", rangeMutation.version.version, MutationRef(MutationRef::ClearRange, range.begin, range.end));
															#line 384 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					clearRanges.push_back_deep(clearRanges.arena(), range);
															#line 385 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					curTxnSize += range.expectedSize();
															#line 386 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					if (curTxnSize >= SERVER_KNOBS->FASTRESTORE_TXN_BATCH_MAX_BYTES)
															#line 2752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
					{
															#line 387 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						fClearRanges.push_back( applyClearRangeMutations(clearRanges, delayTime, cx, applierID, batchIndex, &batchData->counters));
															#line 389 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						delayTime += SERVER_KNOBS->FASTRESTORE_TXN_EXTRA_DELAY;
															#line 390 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						clearRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 391 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						curTxnSize = 0;
															#line 2762 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
					}
				}
															#line 394 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (curTxnSize > 0)
															#line 2767 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 395 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					fClearRanges.push_back( applyClearRangeMutations(clearRanges, delayTime, cx, applierID, batchIndex, &batchData->counters));
															#line 2771 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
			}
															#line 401 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResult", applierID) .detail("BatchIndex", batchIndex) .detail("Step", "Applying clear range mutations to staging keys") .detail("ClearRanges", batchData->stagingKeyRanges.size()) .detail("FutureClearRanges", fClearRanges.size());
															#line 406 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for( auto& rangeMutation : batchData->stagingKeyRanges ) {
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT(rangeMutation.mutation.param1 <= rangeMutation.mutation.param2);
															#line 408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				std::map<Key, StagingKey>::iterator lb = batchData->stagingKeys.lower_bound(rangeMutation.mutation.param1);
															#line 409 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				std::map<Key, StagingKey>::iterator ub = batchData->stagingKeys.lower_bound(rangeMutation.mutation.param2);
															#line 410 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				for(;lb != ub;) {
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					if (lb->first >= rangeMutation.mutation.param2)
															#line 2788 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
					{
															#line 412 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						TraceEvent(SevError, "FastRestoreApplerPhasePrecomputeMutationsResultIncorrectUpperBound") .detail("Key", lb->first) .detail("ClearRangeUpperBound", rangeMutation.mutation.param2) .detail("UsedUpperBound", ub->first);
															#line 2792 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
					}
															#line 419 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					MutationRef clearKey(MutationRef::ClearRange, lb->first, lb->first);
															#line 420 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					lb->second.add(clearKey, rangeMutation.version);
															#line 421 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					lb++;
															#line 2800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
			}
															#line 424 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResult", applierID) .detail("BatchIndex", batchIndex) .detail("Step", "Wait on applying clear range mutations to DB") .detail("FutureClearRanges", fClearRanges.size());
															#line 429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(fClearRanges);
															#line 429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2809 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state = 1;
															#line 429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrecomputeMutationsResultActor, 0, Void >*>(static_cast<PrecomputeMutationsResultActor*>(this)));
															#line 2814 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrecomputeMutationsResultActorState();
		static_cast<PrecomputeMutationsResultActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 430 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResult", applierID) .detail("BatchIndex", batchIndex) .detail("Step", "Getting and computing staging keys") .detail("StagingKeys", batchData->stagingKeys.size());
															#line 436 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		std::vector<Future<Void>> fGetAndComputeKeys;
															#line 437 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		std::map<Key, std::map<Key, StagingKey>::iterator> incompleteStagingKeys;
															#line 438 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		std::map<Key, StagingKey>::iterator stagingKeyIter = batchData->stagingKeys.begin();
															#line 439 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		int numKeysInBatch = 0;
															#line 440 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		int numGetTxns = 0;
															#line 2847 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			double delayTime = 0;
															#line 443 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for(;stagingKeyIter != batchData->stagingKeys.end();stagingKeyIter++) {
															#line 444 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (!stagingKeyIter->second.hasBaseValue())
															#line 2855 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 445 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					incompleteStagingKeys.emplace(stagingKeyIter->first, stagingKeyIter);
															#line 446 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					numKeysInBatch++;
															#line 2861 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (numKeysInBatch == SERVER_KNOBS->FASTRESTORE_APPLIER_FETCH_KEYS_SIZE)
															#line 2865 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 449 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					fGetAndComputeKeys.push_back(getAndComputeStagingKeys( incompleteStagingKeys, delayTime, cx, applierID, batchIndex, &batchData->counters));
															#line 451 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					numGetTxns++;
															#line 452 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					delayTime += SERVER_KNOBS->FASTRESTORE_TXN_EXTRA_DELAY;
															#line 453 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					numKeysInBatch = 0;
															#line 454 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					incompleteStagingKeys.clear();
															#line 2877 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
			}
															#line 457 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (numKeysInBatch > 0)
															#line 2882 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 458 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				numGetTxns++;
															#line 459 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				fGetAndComputeKeys.push_back(getAndComputeStagingKeys( incompleteStagingKeys, delayTime, cx, applierID, batchIndex, &batchData->counters));
															#line 2888 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
		}
															#line 464 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResult", applierID) .detail("BatchIndex", batchIndex) .detail("Step", "Compute the other staging keys") .detail("StagingKeys", batchData->stagingKeys.size()) .detail("GetStagingKeyBatchTxns", numGetTxns);
															#line 470 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		for(stagingKeyIter = batchData->stagingKeys.begin();stagingKeyIter != batchData->stagingKeys.end();stagingKeyIter++) {
															#line 472 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (stagingKeyIter->second.hasBaseValue())
															#line 2897 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				stagingKeyIter->second.precomputeResult("HasBaseValue", applierID, batchIndex);
															#line 2901 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
		}
															#line 477 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplierGetAndComputeStagingKeysWaitOn", applierID).log();
															#line 478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(fGetAndComputeKeys);
															#line 478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2910 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state = 2;
															#line 478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrecomputeMutationsResultActor, 1, Void >*>(static_cast<PrecomputeMutationsResultActor*>(this)));
															#line 2915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 430 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResult", applierID) .detail("BatchIndex", batchIndex) .detail("Step", "Getting and computing staging keys") .detail("StagingKeys", batchData->stagingKeys.size());
															#line 436 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		std::vector<Future<Void>> fGetAndComputeKeys;
															#line 437 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		std::map<Key, std::map<Key, StagingKey>::iterator> incompleteStagingKeys;
															#line 438 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		std::map<Key, StagingKey>::iterator stagingKeyIter = batchData->stagingKeys.begin();
															#line 439 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		int numKeysInBatch = 0;
															#line 440 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		int numGetTxns = 0;
															#line 2934 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			double delayTime = 0;
															#line 443 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for(;stagingKeyIter != batchData->stagingKeys.end();stagingKeyIter++) {
															#line 444 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (!stagingKeyIter->second.hasBaseValue())
															#line 2942 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 445 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					incompleteStagingKeys.emplace(stagingKeyIter->first, stagingKeyIter);
															#line 446 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					numKeysInBatch++;
															#line 2948 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
															#line 448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (numKeysInBatch == SERVER_KNOBS->FASTRESTORE_APPLIER_FETCH_KEYS_SIZE)
															#line 2952 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 449 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					fGetAndComputeKeys.push_back(getAndComputeStagingKeys( incompleteStagingKeys, delayTime, cx, applierID, batchIndex, &batchData->counters));
															#line 451 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					numGetTxns++;
															#line 452 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					delayTime += SERVER_KNOBS->FASTRESTORE_TXN_EXTRA_DELAY;
															#line 453 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					numKeysInBatch = 0;
															#line 454 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					incompleteStagingKeys.clear();
															#line 2964 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
			}
															#line 457 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (numKeysInBatch > 0)
															#line 2969 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 458 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				numGetTxns++;
															#line 459 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				fGetAndComputeKeys.push_back(getAndComputeStagingKeys( incompleteStagingKeys, delayTime, cx, applierID, batchIndex, &batchData->counters));
															#line 2975 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
		}
															#line 464 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResult", applierID) .detail("BatchIndex", batchIndex) .detail("Step", "Compute the other staging keys") .detail("StagingKeys", batchData->stagingKeys.size()) .detail("GetStagingKeyBatchTxns", numGetTxns);
															#line 470 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		for(stagingKeyIter = batchData->stagingKeys.begin();stagingKeyIter != batchData->stagingKeys.end();stagingKeyIter++) {
															#line 472 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (stagingKeyIter->second.hasBaseValue())
															#line 2984 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				stagingKeyIter->second.precomputeResult("HasBaseValue", applierID, batchIndex);
															#line 2988 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
		}
															#line 477 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplierGetAndComputeStagingKeysWaitOn", applierID).log();
															#line 478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(fGetAndComputeKeys);
															#line 478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2997 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state = 2;
															#line 478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrecomputeMutationsResultActor, 1, Void >*>(static_cast<PrecomputeMutationsResultActor*>(this)));
															#line 3002 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state > 0) static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state = 0;
		static_cast<PrecomputeMutationsResultActor*>(this)->ActorCallback< PrecomputeMutationsResultActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrecomputeMutationsResultActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrecomputeMutationsResultActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrecomputeMutationsResultActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrecomputeMutationsResultActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrecomputeMutationsResultActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrecomputeMutationsResultActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 481 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		ASSERT_WE_THINK(batchData->allKeysPrecomputed());
															#line 483 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResultDone", applierID).detail("BatchIndex", batchIndex);
															#line 485 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<PrecomputeMutationsResultActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrecomputeMutationsResultActorState(); static_cast<PrecomputeMutationsResultActor*>(this)->destroy(); return 0; }
															#line 3090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<PrecomputeMutationsResultActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrecomputeMutationsResultActorState();
		static_cast<PrecomputeMutationsResultActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 481 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		ASSERT_WE_THINK(batchData->allKeysPrecomputed());
															#line 483 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplerPhasePrecomputeMutationsResultDone", applierID).detail("BatchIndex", batchIndex);
															#line 485 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<PrecomputeMutationsResultActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrecomputeMutationsResultActorState(); static_cast<PrecomputeMutationsResultActor*>(this)->destroy(); return 0; }
															#line 3106 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<PrecomputeMutationsResultActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrecomputeMutationsResultActorState();
		static_cast<PrecomputeMutationsResultActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state > 0) static_cast<PrecomputeMutationsResultActor*>(this)->actor_wait_state = 0;
		static_cast<PrecomputeMutationsResultActor*>(this)->ActorCallback< PrecomputeMutationsResultActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrecomputeMutationsResultActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrecomputeMutationsResultActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrecomputeMutationsResultActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrecomputeMutationsResultActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrecomputeMutationsResultActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrecomputeMutationsResultActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ApplierBatchData> batchData;
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	UID applierID;
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int64_t batchIndex;
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Database cx;
															#line 374 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	std::vector<Future<Void>> fClearRanges;
															#line 3199 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via precomputeMutationsResult()
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class PrecomputeMutationsResultActor final : public Actor<Void>, public ActorCallback< PrecomputeMutationsResultActor, 0, Void >, public ActorCallback< PrecomputeMutationsResultActor, 1, Void >, public FastAllocated<PrecomputeMutationsResultActor>, public PrecomputeMutationsResultActorState<PrecomputeMutationsResultActor> {
															#line 3204 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrecomputeMutationsResultActor>::operator new;
	using FastAllocated<PrecomputeMutationsResultActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18087528222965168128UL, 13575105501996635392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrecomputeMutationsResultActor, 0, Void >;
friend struct ActorCallback< PrecomputeMutationsResultActor, 1, Void >;
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	PrecomputeMutationsResultActor(Reference<ApplierBatchData> const& batchData,UID const& applierID,int64_t const& batchIndex,Database const& cx) 
															#line 3222 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrecomputeMutationsResultActorState<PrecomputeMutationsResultActor>(batchData, applierID, batchIndex, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5904790662851794432UL, 10118444089774414080UL);
		ActorExecutionContextHelper __helper(static_cast<PrecomputeMutationsResultActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("precomputeMutationsResult");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("precomputeMutationsResult", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrecomputeMutationsResultActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrecomputeMutationsResultActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> precomputeMutationsResult( Reference<ApplierBatchData> const& batchData, UID const& applierID, int64_t const& batchIndex, Database const& cx ) {
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new PrecomputeMutationsResultActor(batchData, applierID, batchIndex, cx));
															#line 3256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 487 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

bool okToReleaseTxns(double targetMB, double applyingDataBytes) {
	return applyingDataBytes < targetMB * 1024 * 1024;
}

															#line 3265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via shouldReleaseTransaction()
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class ShouldReleaseTransactionActor>
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class ShouldReleaseTransactionActorState {
															#line 3272 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ShouldReleaseTransactionActorState(double* const& targetMB,double* const& applyingDataBytes,AsyncTrigger* const& releaseTxns) 
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : targetMB(targetMB),
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   applyingDataBytes(applyingDataBytes),
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   releaseTxns(releaseTxns)
															#line 3283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ShouldReleaseTransactionActorState() 
	{
		fdb_probe_actor_destroy("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 495 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			;
															#line 3298 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShouldReleaseTransactionActorState();
		static_cast<ShouldReleaseTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 504 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<ShouldReleaseTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShouldReleaseTransactionActorState(); static_cast<ShouldReleaseTransactionActor*>(this)->destroy(); return 0; }
															#line 3321 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<ShouldReleaseTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShouldReleaseTransactionActorState();
		static_cast<ShouldReleaseTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 496 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (okToReleaseTxns(*targetMB, *applyingDataBytes))
															#line 3340 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 499 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = releaseTxns->onTrigger();
															#line 499 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3350 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state = 1;
															#line 499 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShouldReleaseTransactionActor, 0, Void >*>(static_cast<ShouldReleaseTransactionActor*>(this)));
															#line 3355 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.0);
															#line 500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3386 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state = 2;
															#line 500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShouldReleaseTransactionActor, 1, Void >*>(static_cast<ShouldReleaseTransactionActor*>(this)));
															#line 3391 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.0);
															#line 500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3402 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state = 2;
															#line 500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShouldReleaseTransactionActor, 1, Void >*>(static_cast<ShouldReleaseTransactionActor*>(this)));
															#line 3407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state > 0) static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ShouldReleaseTransactionActor*>(this)->ActorCallback< ShouldReleaseTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShouldReleaseTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShouldReleaseTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShouldReleaseTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShouldReleaseTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShouldReleaseTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShouldReleaseTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state > 0) static_cast<ShouldReleaseTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ShouldReleaseTransactionActor*>(this)->ActorCallback< ShouldReleaseTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShouldReleaseTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShouldReleaseTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShouldReleaseTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShouldReleaseTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShouldReleaseTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShouldReleaseTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double* targetMB;
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double* applyingDataBytes;
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	AsyncTrigger* releaseTxns;
															#line 3580 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via shouldReleaseTransaction()
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class ShouldReleaseTransactionActor final : public Actor<Void>, public ActorCallback< ShouldReleaseTransactionActor, 0, Void >, public ActorCallback< ShouldReleaseTransactionActor, 1, Void >, public FastAllocated<ShouldReleaseTransactionActor>, public ShouldReleaseTransactionActorState<ShouldReleaseTransactionActor> {
															#line 3585 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<ShouldReleaseTransactionActor>::operator new;
	using FastAllocated<ShouldReleaseTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9097159415587955200UL, 5276049572952206080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShouldReleaseTransactionActor, 0, Void >;
friend struct ActorCallback< ShouldReleaseTransactionActor, 1, Void >;
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ShouldReleaseTransactionActor(double* const& targetMB,double* const& applyingDataBytes,AsyncTrigger* const& releaseTxns) 
															#line 3603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ShouldReleaseTransactionActorState<ShouldReleaseTransactionActor>(targetMB, applyingDataBytes, releaseTxns),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11590061187208828160UL, 9395397214748175872UL);
		ActorExecutionContextHelper __helper(static_cast<ShouldReleaseTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shouldReleaseTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shouldReleaseTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShouldReleaseTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ShouldReleaseTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> shouldReleaseTransaction( double* const& targetMB, double* const& applyingDataBytes, AsyncTrigger* const& releaseTxns ) {
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new ShouldReleaseTransactionActor(targetMB, applyingDataBytes, releaseTxns));
															#line 3637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 506 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

// Apply mutations in batchData->stagingKeys [begin, end).
															#line 3643 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via applyStagingKeysBatch()
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class ApplyStagingKeysBatchActor>
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class ApplyStagingKeysBatchActorState {
															#line 3650 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplyStagingKeysBatchActorState(std::map<Key, StagingKey>::iterator const& begin,std::map<Key, StagingKey>::iterator const& end,Database const& cx,UID const& applierID,ApplierBatchData::Counters* const& cc,double* const& appliedBytes,double* const& applyingDataBytes,double* const& targetMB,AsyncTrigger* const& releaseTxnTrigger) 
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : begin(begin),
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   end(end),
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cx(cx),
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   applierID(applierID),
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cc(cc),
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   appliedBytes(appliedBytes),
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   applyingDataBytes(applyingDataBytes),
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   targetMB(targetMB),
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   releaseTxnTrigger(releaseTxnTrigger)
															#line 3673 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this));

	}
	~ApplyStagingKeysBatchActorState() 
	{
		fdb_probe_actor_destroy("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 517 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (SERVER_KNOBS->FASTRESTORE_NOT_WRITE_DB)
															#line 3688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 518 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				TraceEvent("FastRestoreApplierPhaseApplyStagingKeysBatchSkipped", applierID).detail("Begin", begin->first);
															#line 519 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				ASSERT(!g_network->isSimulated());
															#line 520 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (!static_cast<ApplyStagingKeysBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyStagingKeysBatchActorState(); static_cast<ApplyStagingKeysBatchActor*>(this)->destroy(); return 0; }
															#line 3696 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				new (&static_cast<ApplyStagingKeysBatchActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ApplyStagingKeysBatchActorState();
				static_cast<ApplyStagingKeysBatchActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 522 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = shouldReleaseTransaction(targetMB, applyingDataBytes, releaseTxnTrigger);
															#line 522 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3706 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state = 1;
															#line 522 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ApplyStagingKeysBatchActor, 0, Void >*>(static_cast<ApplyStagingKeysBatchActor*>(this)));
															#line 3711 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ApplyStagingKeysBatchActorState();
		static_cast<ApplyStagingKeysBatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 524 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 525 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		sets = 0;
															#line 526 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		clears = 0;
															#line 527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		endKey = begin->first;
															#line 528 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		txnSize = 0;
															#line 529 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		txnSizeUsed = 0;
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent(SevFRDebugInfo, "FastRestoreApplierPhaseApplyStagingKeysBatch", applierID).detail("Begin", begin->first);
															#line 531 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		;
															#line 3748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 524 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 525 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		sets = 0;
															#line 526 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		clears = 0;
															#line 527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		endKey = begin->first;
															#line 528 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		txnSize = 0;
															#line 529 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		txnSizeUsed = 0;
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent(SevFRDebugInfo, "FastRestoreApplierPhaseApplyStagingKeysBatch", applierID).detail("Begin", begin->first);
															#line 531 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		;
															#line 3771 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state > 0) static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyStagingKeysBatchActor*>(this)->ActorCallback< ApplyStagingKeysBatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyStagingKeysBatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ApplyStagingKeysBatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ApplyStagingKeysBatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 595 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<ApplyStagingKeysBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyStagingKeysBatchActorState(); static_cast<ApplyStagingKeysBatchActor*>(this)->destroy(); return 0; }
															#line 3855 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<ApplyStagingKeysBatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ApplyStagingKeysBatchActorState();
		static_cast<ApplyStagingKeysBatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			txnSize = 0;
															#line 534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			txnSizeUsed = 0;
															#line 535 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 536 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 537 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			std::map<Key, StagingKey>::iterator iter = begin;
															#line 538 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for(;iter != end;) {
															#line 539 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (iter->second.type == MutationRef::SetValue)
															#line 3887 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 540 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					tr->set(iter->second.key, iter->second.val);
															#line 541 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					txnSize += iter->second.totalSize();
															#line 542 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					cc->appliedMutations += 1;
															#line 543 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					TraceEvent(SevFRMutationInfo, "FastRestoreApplierPhaseApplyStagingKeysBatch", applierID) .detail("SetKey", iter->second.key);
															#line 545 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					sets++;
															#line 3899 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
				else
				{
															#line 546 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					if (iter->second.type == MutationRef::ClearRange)
															#line 3905 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
					{
															#line 547 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						if (iter->second.key != iter->second.val)
															#line 3909 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
						{
															#line 548 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
							TraceEvent(SevError, "FastRestoreApplierPhaseApplyStagingKeysBatchClearTooMuchData", applierID) .detail("KeyBegin", iter->second.key) .detail("KeyEnd", iter->second.val) .detail("Version", iter->second.version.version) .detail("SubVersion", iter->second.version.sub);
															#line 3913 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
						}
															#line 554 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						tr->clear(singleKeyRange(iter->second.key));
															#line 555 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						txnSize += iter->second.totalSize();
															#line 556 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						cc->appliedMutations += 1;
															#line 557 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						TraceEvent(SevFRMutationInfo, "FastRestoreApplierPhaseApplyStagingKeysBatch", applierID) .detail("ClearKey", iter->second.key);
															#line 559 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						clears++;
															#line 3925 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
					}
					else
					{
															#line 561 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
						ASSERT(false);
															#line 3931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
					}
				}
															#line 563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				endKey = iter != end ? iter->first : endKey;
															#line 564 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				iter++;
															#line 565 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (sets > 10000000 || clears > 10000000)
															#line 3940 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 566 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					TraceEvent(SevError, "FastRestoreApplierPhaseApplyStagingKeysBatchInfiniteLoop", applierID) .detail("Begin", begin->first) .detail("Sets", sets) .detail("Clears", clears);
															#line 3944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
			}
															#line 572 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent(SevFRDebugInfo, "FastRestoreApplierPhaseApplyStagingKeysBatchPrecommit", applierID) .detail("Begin", begin->first) .detail("End", endKey) .detail("Sets", sets) .detail("Clears", clears);
															#line 577 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			tr->addWriteConflictRange(KeyRangeRef(begin->first, keyAfter(endKey)));
															#line 578 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			txnSizeUsed = txnSize;
															#line 579 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			*applyingDataBytes += txnSizeUsed;
															#line 580 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 580 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3959 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state = 2;
															#line 580 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ApplyStagingKeysBatchActor, 1, Void >*>(static_cast<ApplyStagingKeysBatchActor*>(this)));
															#line 3964 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 590 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			cc->appliedTxnRetries += 1;
															#line 591 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 591 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4003 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state = 3;
															#line 591 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ApplyStagingKeysBatchActor, 2, Void >*>(static_cast<ApplyStagingKeysBatchActor*>(this)));
															#line 4008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 581 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		cc->appliedTxns += 1;
															#line 582 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		cc->appliedBytes += txnSize;
															#line 583 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		*appliedBytes += txnSize;
															#line 584 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		*applyingDataBytes -= txnSizeUsed;
															#line 585 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (okToReleaseTxns(*targetMB, *applyingDataBytes))
															#line 4031 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 586 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			releaseTxnTrigger->trigger();
															#line 4035 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		}
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 581 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		cc->appliedTxns += 1;
															#line 582 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		cc->appliedBytes += txnSize;
															#line 583 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		*appliedBytes += txnSize;
															#line 584 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		*applyingDataBytes -= txnSizeUsed;
															#line 585 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (okToReleaseTxns(*targetMB, *applyingDataBytes))
															#line 4053 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 586 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			releaseTxnTrigger->trigger();
															#line 4057 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		}
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state > 0) static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyStagingKeysBatchActor*>(this)->ActorCallback< ApplyStagingKeysBatchActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyStagingKeysBatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ApplyStagingKeysBatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ApplyStagingKeysBatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		*applyingDataBytes -= txnSizeUsed;
															#line 4142 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 592 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		*applyingDataBytes -= txnSizeUsed;
															#line 4151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state > 0) static_cast<ApplyStagingKeysBatchActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyStagingKeysBatchActor*>(this)->ActorCallback< ApplyStagingKeysBatchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyStagingKeysBatchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ApplyStagingKeysBatchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ApplyStagingKeysBatchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	std::map<Key, StagingKey>::iterator begin;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	std::map<Key, StagingKey>::iterator end;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Database cx;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	UID applierID;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplierBatchData::Counters* cc;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double* appliedBytes;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double* applyingDataBytes;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double* targetMB;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	AsyncTrigger* releaseTxnTrigger;
															#line 524 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 525 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int sets;
															#line 526 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int clears;
															#line 527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Key endKey;
															#line 528 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double txnSize;
															#line 529 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	double txnSizeUsed;
															#line 4261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via applyStagingKeysBatch()
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class ApplyStagingKeysBatchActor final : public Actor<Void>, public ActorCallback< ApplyStagingKeysBatchActor, 0, Void >, public ActorCallback< ApplyStagingKeysBatchActor, 1, Void >, public ActorCallback< ApplyStagingKeysBatchActor, 2, Void >, public FastAllocated<ApplyStagingKeysBatchActor>, public ApplyStagingKeysBatchActorState<ApplyStagingKeysBatchActor> {
															#line 4266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<ApplyStagingKeysBatchActor>::operator new;
	using FastAllocated<ApplyStagingKeysBatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16141994660724844800UL, 15992778023928015616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ApplyStagingKeysBatchActor, 0, Void >;
friend struct ActorCallback< ApplyStagingKeysBatchActor, 1, Void >;
friend struct ActorCallback< ApplyStagingKeysBatchActor, 2, Void >;
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplyStagingKeysBatchActor(std::map<Key, StagingKey>::iterator const& begin,std::map<Key, StagingKey>::iterator const& end,Database const& cx,UID const& applierID,ApplierBatchData::Counters* const& cc,double* const& appliedBytes,double* const& applyingDataBytes,double* const& targetMB,AsyncTrigger* const& releaseTxnTrigger) 
															#line 4285 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ApplyStagingKeysBatchActorState<ApplyStagingKeysBatchActor>(begin, end, cx, applierID, cc, appliedBytes, applyingDataBytes, targetMB, releaseTxnTrigger),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1006649612662365184UL, 13439636832351404800UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("applyStagingKeysBatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("applyStagingKeysBatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ApplyStagingKeysBatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ApplyStagingKeysBatchActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ApplyStagingKeysBatchActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> applyStagingKeysBatch( std::map<Key, StagingKey>::iterator const& begin, std::map<Key, StagingKey>::iterator const& end, Database const& cx, UID const& applierID, ApplierBatchData::Counters* const& cc, double* const& appliedBytes, double* const& applyingDataBytes, double* const& targetMB, AsyncTrigger* const& releaseTxnTrigger ) {
															#line 508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new ApplyStagingKeysBatchActor(begin, end, cx, applierID, cc, appliedBytes, applyingDataBytes, targetMB, releaseTxnTrigger));
															#line 4320 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 597 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

// Apply mutations in stagingKeys in batches in parallel
															#line 4326 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via applyStagingKeys()
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class ApplyStagingKeysActor>
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class ApplyStagingKeysActorState {
															#line 4333 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplyStagingKeysActorState(Reference<ApplierBatchData> const& batchData,UID const& applierID,int64_t const& batchIndex,Database const& cx) 
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : batchData(batchData),
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   applierID(applierID),
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchIndex(batchIndex),
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cx(cx)
															#line 4346 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("applyStagingKeys", reinterpret_cast<unsigned long>(this));

	}
	~ApplyStagingKeysActorState() 
	{
		fdb_probe_actor_destroy("applyStagingKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			std::map<Key, StagingKey>::iterator begin = batchData->stagingKeys.begin();
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			std::map<Key, StagingKey>::iterator cur = begin;
															#line 605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			txnBatches = 0;
															#line 606 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			double txnSize = 0;
															#line 607 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			std::vector<Future<Void>> fBatches;
															#line 608 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplerPhaseApplyStagingKeysStart", applierID) .detail("BatchIndex", batchIndex) .detail("StagingKeys", batchData->stagingKeys.size());
															#line 611 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			batchData->totalBytesToWrite = 0;
															#line 612 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			for(;cur != batchData->stagingKeys.end();) {
															#line 613 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				txnSize += cur->second.totalSize();
															#line 614 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				if (txnSize > SERVER_KNOBS->FASTRESTORE_TXN_BATCH_MAX_BYTES)
															#line 4379 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				{
															#line 615 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					fBatches.push_back(applyStagingKeysBatch(begin, cur, cx, applierID, &batchData->counters, &batchData->appliedBytes, &batchData->applyingDataBytes, &batchData->targetWriteRateMB, &batchData->releaseTxnTrigger));
															#line 624 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					batchData->totalBytesToWrite += txnSize;
															#line 625 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					begin = cur;
															#line 626 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					txnSize = 0;
															#line 627 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
					txnBatches++;
															#line 4391 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
				}
															#line 629 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				cur++;
															#line 4395 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (begin != batchData->stagingKeys.end())
															#line 4399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 632 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				fBatches.push_back(applyStagingKeysBatch(begin, cur, cx, applierID, &batchData->counters, &batchData->appliedBytes, &batchData->applyingDataBytes, &batchData->targetWriteRateMB, &batchData->releaseTxnTrigger));
															#line 641 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->totalBytesToWrite += txnSize;
															#line 642 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				txnBatches++;
															#line 4407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 645 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(fBatches);
															#line 645 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<ApplyStagingKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4413 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ApplyStagingKeysActor*>(this)->actor_wait_state = 1;
															#line 645 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ApplyStagingKeysActor, 0, Void >*>(static_cast<ApplyStagingKeysActor*>(this)));
															#line 4418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ApplyStagingKeysActorState();
		static_cast<ApplyStagingKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 647 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplerPhaseApplyStagingKeysDone", applierID) .detail("BatchIndex", batchIndex) .detail("StagingKeys", batchData->stagingKeys.size()) .detail("TransactionBatches", txnBatches) .detail("TotalBytesToWrite", batchData->totalBytesToWrite);
															#line 652 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<ApplyStagingKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyStagingKeysActorState(); static_cast<ApplyStagingKeysActor*>(this)->destroy(); return 0; }
															#line 4443 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<ApplyStagingKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ApplyStagingKeysActorState();
		static_cast<ApplyStagingKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 647 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplerPhaseApplyStagingKeysDone", applierID) .detail("BatchIndex", batchIndex) .detail("StagingKeys", batchData->stagingKeys.size()) .detail("TransactionBatches", txnBatches) .detail("TotalBytesToWrite", batchData->totalBytesToWrite);
															#line 652 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<ApplyStagingKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ApplyStagingKeysActorState(); static_cast<ApplyStagingKeysActor*>(this)->destroy(); return 0; }
															#line 4457 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<ApplyStagingKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ApplyStagingKeysActorState();
		static_cast<ApplyStagingKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ApplyStagingKeysActor*>(this)->actor_wait_state > 0) static_cast<ApplyStagingKeysActor*>(this)->actor_wait_state = 0;
		static_cast<ApplyStagingKeysActor*>(this)->ActorCallback< ApplyStagingKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ApplyStagingKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("applyStagingKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ApplyStagingKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("applyStagingKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ApplyStagingKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("applyStagingKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("applyStagingKeys", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ApplierBatchData> batchData;
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	UID applierID;
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int64_t batchIndex;
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Database cx;
															#line 605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int txnBatches;
															#line 4550 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via applyStagingKeys()
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class ApplyStagingKeysActor final : public Actor<Void>, public ActorCallback< ApplyStagingKeysActor, 0, Void >, public FastAllocated<ApplyStagingKeysActor>, public ApplyStagingKeysActorState<ApplyStagingKeysActor> {
															#line 4555 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<ApplyStagingKeysActor>::operator new;
	using FastAllocated<ApplyStagingKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16773895330515794176UL, 274663006532010752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ApplyStagingKeysActor, 0, Void >;
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	ApplyStagingKeysActor(Reference<ApplierBatchData> const& batchData,UID const& applierID,int64_t const& batchIndex,Database const& cx) 
															#line 4572 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ApplyStagingKeysActorState<ApplyStagingKeysActor>(batchData, applierID, batchIndex, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("applyStagingKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7632096617376068352UL, 6148479918481396480UL);
		ActorExecutionContextHelper __helper(static_cast<ApplyStagingKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("applyStagingKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("applyStagingKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ApplyStagingKeysActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> applyStagingKeys( Reference<ApplierBatchData> const& batchData, UID const& applierID, int64_t const& batchIndex, Database const& cx ) {
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new ApplyStagingKeysActor(batchData, applierID, batchIndex, cx));
															#line 4605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 654 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

// Write mutations to the destination DB
															#line 4611 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via writeMutationsToDB()
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class WriteMutationsToDBActor>
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class WriteMutationsToDBActorState {
															#line 4618 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	WriteMutationsToDBActorState(UID const& applierID,int64_t const& batchIndex,Reference<ApplierBatchData> const& batchData,Database const& cx) 
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : applierID(applierID),
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchIndex(batchIndex),
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchData(batchData),
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cx(cx)
															#line 4631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeMutationsToDB", reinterpret_cast<unsigned long>(this));

	}
	~WriteMutationsToDBActorState() 
	{
		fdb_probe_actor_destroy("writeMutationsToDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 660 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplierPhaseApplyTxnStart", applierID).detail("BatchIndex", batchIndex);
															#line 661 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = precomputeMutationsResult(batchData, applierID, batchIndex, cx);
															#line 661 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4650 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state = 1;
															#line 661 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteMutationsToDBActor, 0, Void >*>(static_cast<WriteMutationsToDBActor*>(this)));
															#line 4655 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteMutationsToDBActorState();
		static_cast<WriteMutationsToDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = applyStagingKeys(batchData, applierID, batchIndex, cx);
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4680 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state = 2;
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteMutationsToDBActor, 1, Void >*>(static_cast<WriteMutationsToDBActor*>(this)));
															#line 4685 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = applyStagingKeys(batchData, applierID, batchIndex, cx);
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4696 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state = 2;
															#line 663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteMutationsToDBActor, 1, Void >*>(static_cast<WriteMutationsToDBActor*>(this)));
															#line 4701 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state > 0) static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state = 0;
		static_cast<WriteMutationsToDBActor*>(this)->ActorCallback< WriteMutationsToDBActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteMutationsToDBActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationsToDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteMutationsToDBActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationsToDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteMutationsToDBActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationsToDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplierPhaseApplyTxnDone", applierID) .detail("BatchIndex", batchIndex) .detail("AppliedBytes", batchData->appliedBytes) .detail("ReceivedBytes", batchData->receivedBytes);
															#line 669 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<WriteMutationsToDBActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteMutationsToDBActorState(); static_cast<WriteMutationsToDBActor*>(this)->destroy(); return 0; }
															#line 4787 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<WriteMutationsToDBActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteMutationsToDBActorState();
		static_cast<WriteMutationsToDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplierPhaseApplyTxnDone", applierID) .detail("BatchIndex", batchIndex) .detail("AppliedBytes", batchData->appliedBytes) .detail("ReceivedBytes", batchData->receivedBytes);
															#line 669 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<WriteMutationsToDBActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteMutationsToDBActorState(); static_cast<WriteMutationsToDBActor*>(this)->destroy(); return 0; }
															#line 4801 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<WriteMutationsToDBActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteMutationsToDBActorState();
		static_cast<WriteMutationsToDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state > 0) static_cast<WriteMutationsToDBActor*>(this)->actor_wait_state = 0;
		static_cast<WriteMutationsToDBActor*>(this)->ActorCallback< WriteMutationsToDBActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteMutationsToDBActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationsToDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteMutationsToDBActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationsToDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteMutationsToDBActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationsToDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMutationsToDB", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	UID applierID;
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int64_t batchIndex;
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ApplierBatchData> batchData;
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Database cx;
															#line 4892 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeMutationsToDB()
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class WriteMutationsToDBActor final : public Actor<Void>, public ActorCallback< WriteMutationsToDBActor, 0, Void >, public ActorCallback< WriteMutationsToDBActor, 1, Void >, public FastAllocated<WriteMutationsToDBActor>, public WriteMutationsToDBActorState<WriteMutationsToDBActor> {
															#line 4897 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteMutationsToDBActor>::operator new;
	using FastAllocated<WriteMutationsToDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3349818669633561856UL, 13721813091138182656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteMutationsToDBActor, 0, Void >;
friend struct ActorCallback< WriteMutationsToDBActor, 1, Void >;
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	WriteMutationsToDBActor(UID const& applierID,int64_t const& batchIndex,Reference<ApplierBatchData> const& batchData,Database const& cx) 
															#line 4915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteMutationsToDBActorState<WriteMutationsToDBActor>(applierID, batchIndex, batchData, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeMutationsToDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2219131847359739136UL, 10931482797710368768UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMutationsToDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeMutationsToDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeMutationsToDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteMutationsToDBActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteMutationsToDBActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] Future<Void> writeMutationsToDB( UID const& applierID, int64_t const& batchIndex, Reference<ApplierBatchData> const& batchData, Database const& cx ) {
															#line 656 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new WriteMutationsToDBActor(applierID, batchIndex, batchData, cx));
															#line 4949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 671 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

void handleUpdateRateRequest(RestoreUpdateRateRequest req, Reference<RestoreApplierData> self) {
	TraceEvent ev("FastRestoreApplierUpdateRateRequest", self->id());
	ev.suppressFor(10)
	    .detail("BatchIndex", req.batchIndex)
	    .detail("FinishedBatch", self->finishedBatch.get())
	    .detail("WriteMB", req.writeMB);
	double remainingDataMB = 0;
	if (self->finishedBatch.get() == req.batchIndex - 1) { // current applying batch
		Reference<ApplierBatchData> batchData = self->batch[req.batchIndex];
		ASSERT(batchData.isValid());
		batchData->targetWriteRateMB = req.writeMB;
		remainingDataMB = batchData->totalBytesToWrite > 0
		                      ? std::max(0.0, batchData->totalBytesToWrite - batchData->appliedBytes) / 1024 / 1024
		                      : batchData->receivedBytes / 1024 / 1024;
		ev.detail("TotalBytesToWrite", batchData->totalBytesToWrite)
		    .detail("AppliedBytes", batchData->appliedBytes)
		    .detail("ReceivedBytes", batchData->receivedBytes)
		    .detail("TargetWriteRateMB", batchData->targetWriteRateMB)
		    .detail("RemainingDataMB", remainingDataMB);
	}
	req.reply.send(RestoreUpdateRateReply(self->id(), remainingDataMB));

	return;
}

															#line 4979 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via traceRate()
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class TraceRateActor>
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class TraceRateActorState {
															#line 4986 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	TraceRateActorState(const char* const& context,Reference<ApplierBatchData> const& batchData,int const& batchIndex,UID const& nodeID,NotifiedVersion* const& finishedVB,bool const& once = false) 
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : context(context),
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchData(batchData),
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   batchIndex(batchIndex),
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   nodeID(nodeID),
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   finishedVB(finishedVB),
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   once(once)
															#line 5003 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("traceRate", reinterpret_cast<unsigned long>(this));

	}
	~TraceRateActorState() 
	{
		fdb_probe_actor_destroy("traceRate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			;
															#line 5018 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceRateActorState();
		static_cast<TraceRateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 722 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<TraceRateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TraceRateActorState(); static_cast<TraceRateActor*>(this)->destroy(); return 0; }
															#line 5041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<TraceRateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TraceRateActorState();
		static_cast<TraceRateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 704 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if ((finishedVB->get() != batchIndex - 1) || !batchData.isValid())
															#line 5060 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 707 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent(context, nodeID) .suppressFor(10) .detail("BatchIndex", batchIndex) .detail("FinishedBatchIndex", finishedVB->get()) .detail("TotalDataToWriteMB", batchData->totalBytesToWrite / 1024 / 1024) .detail("AppliedBytesMB", batchData->appliedBytes / 1024 / 1024) .detail("TargetBytesMB", batchData->targetWriteRateMB) .detail("InflightBytesMB", batchData->applyingDataBytes) .detail("ReceivedBytes", batchData->receivedBytes);
															#line 716 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (once)
															#line 5068 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 719 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(5.0);
															#line 719 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (static_cast<TraceRateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5076 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TraceRateActor*>(this)->actor_wait_state = 1;
															#line 719 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceRateActor, 0, Void >*>(static_cast<TraceRateActor*>(this)));
															#line 5081 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceRateActor*>(this)->actor_wait_state > 0) static_cast<TraceRateActor*>(this)->actor_wait_state = 0;
		static_cast<TraceRateActor*>(this)->ActorCallback< TraceRateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceRateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceRateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceRateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRate", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	const char* context;
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ApplierBatchData> batchData;
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	int batchIndex;
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	UID nodeID;
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	NotifiedVersion* finishedVB;
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	bool once;
															#line 5198 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via traceRate()
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class TraceRateActor final : public Actor<Void>, public ActorCallback< TraceRateActor, 0, Void >, public FastAllocated<TraceRateActor>, public TraceRateActorState<TraceRateActor> {
															#line 5203 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<TraceRateActor>::operator new;
	using FastAllocated<TraceRateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14642600516428843264UL, 9606547743137990912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceRateActor, 0, Void >;
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	TraceRateActor(const char* const& context,Reference<ApplierBatchData> const& batchData,int const& batchIndex,UID const& nodeID,NotifiedVersion* const& finishedVB,bool const& once = false) 
															#line 5220 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TraceRateActorState<TraceRateActor>(context, batchData, batchIndex, nodeID, finishedVB, once),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceRate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(909631842143166976UL, 4744374695540775168UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceRate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceRate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceRateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> traceRate( const char* const& context, Reference<ApplierBatchData> const& batchData, int const& batchIndex, UID const& nodeID, NotifiedVersion* const& finishedVB, bool const& once = false ) {
															#line 697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new TraceRateActor(context, batchData, batchIndex, nodeID, finishedVB, once));
															#line 5253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 724 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

															#line 5258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleApplyToDBRequest()
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
template <class HandleApplyToDBRequestActor>
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class HandleApplyToDBRequestActorState {
															#line 5265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	HandleApplyToDBRequestActorState(RestoreVersionBatchRequest const& req,Reference<RestoreApplierData> const& self,Database const& cx) 
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		 : req(req),
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   self(self),
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		   cx(cx)
															#line 5276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this));

	}
	~HandleApplyToDBRequestActorState() 
	{
		fdb_probe_actor_destroy("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 728 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplierPhaseHandleApplyToDBStart", self->id()) .detail("BatchIndex", req.batchIndex) .detail("FinishedBatch", self->finishedBatch.get());
															#line 734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->finishedBatch.whenAtLeast(req.batchIndex - 1);
															#line 734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state = 1;
															#line 734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleApplyToDBRequestActor, 0, Void >*>(static_cast<HandleApplyToDBRequestActor*>(this)));
															#line 5300 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleApplyToDBRequestActorState();
		static_cast<HandleApplyToDBRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 736 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		isDuplicated = true;
															#line 737 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (self->finishedBatch.get() == req.batchIndex - 1)
															#line 5325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 739 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			batchData = self->batch[req.batchIndex];
															#line 740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(batchData.isValid());
															#line 741 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplierPhaseHandleApplyToDBRunning", self->id()) .detail("BatchIndex", req.batchIndex) .detail("FinishedBatch", self->finishedBatch.get()) .detail("HasStarted", batchData->dbApplier.present()) .detail("WroteToDBDone", batchData->dbApplier.present() ? batchData->dbApplier.get().isReady() : 0) .detail("PreviousVersionBatchState", batchData->vbState.get());
															#line 748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(batchData.isValid());
															#line 749 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (!batchData->dbApplier.present())
															#line 5337 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 750 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				isDuplicated = false;
															#line 751 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->dbApplier = Never();
															#line 752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->dbApplier = writeMutationsToDB(self->id(), req.batchIndex, batchData, cx);
															#line 753 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->vbState = ApplierVersionBatchState::WRITE_TO_DB;
															#line 754 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->rateTracer = traceRate("FastRestoreApplierTransactionRateControl", batchData, req.batchIndex, self->id(), &self->finishedBatch);
															#line 5349 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 761 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(batchData->dbApplier.present());
															#line 762 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(!batchData->dbApplier.get().isError());
															#line 765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = batchData->dbApplier.get();
															#line 765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5359 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state = 2;
															#line 765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleApplyToDBRequestActor, 1, Void >*>(static_cast<HandleApplyToDBRequestActor*>(this)));
															#line 5364 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 736 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		isDuplicated = true;
															#line 737 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (self->finishedBatch.get() == req.batchIndex - 1)
															#line 5380 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 739 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			batchData = self->batch[req.batchIndex];
															#line 740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(batchData.isValid());
															#line 741 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			TraceEvent("FastRestoreApplierPhaseHandleApplyToDBRunning", self->id()) .detail("BatchIndex", req.batchIndex) .detail("FinishedBatch", self->finishedBatch.get()) .detail("HasStarted", batchData->dbApplier.present()) .detail("WroteToDBDone", batchData->dbApplier.present() ? batchData->dbApplier.get().isReady() : 0) .detail("PreviousVersionBatchState", batchData->vbState.get());
															#line 748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(batchData.isValid());
															#line 749 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (!batchData->dbApplier.present())
															#line 5392 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 750 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				isDuplicated = false;
															#line 751 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->dbApplier = Never();
															#line 752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->dbApplier = writeMutationsToDB(self->id(), req.batchIndex, batchData, cx);
															#line 753 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->vbState = ApplierVersionBatchState::WRITE_TO_DB;
															#line 754 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				batchData->rateTracer = traceRate("FastRestoreApplierTransactionRateControl", batchData, req.batchIndex, self->id(), &self->finishedBatch);
															#line 5404 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
															#line 761 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(batchData->dbApplier.present());
															#line 762 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			ASSERT(!batchData->dbApplier.get().isError());
															#line 765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = batchData->dbApplier.get();
															#line 765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5414 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state = 2;
															#line 765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleApplyToDBRequestActor, 1, Void >*>(static_cast<HandleApplyToDBRequestActor*>(this)));
															#line 5419 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleApplyToDBRequestActor*>(this)->ActorCallback< HandleApplyToDBRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleApplyToDBRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleApplyToDBRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleApplyToDBRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleApplyToDBRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleApplyToDBRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleApplyToDBRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 786 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		req.reply.send(RestoreCommonReply(self->id(), isDuplicated));
															#line 788 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		TraceEvent("FastRestoreApplierPhaseHandleApplyToDBDone", self->id()) .detail("BatchIndex", req.batchIndex) .detail("FinishedBatch", self->finishedBatch.get()) .detail("IsDuplicated", isDuplicated);
															#line 793 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (!static_cast<HandleApplyToDBRequestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleApplyToDBRequestActorState(); static_cast<HandleApplyToDBRequestActor*>(this)->destroy(); return 0; }
															#line 5512 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		new (&static_cast<HandleApplyToDBRequestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleApplyToDBRequestActorState();
		static_cast<HandleApplyToDBRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (self->finishedBatch.get() == req.batchIndex - 1)
															#line 5524 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 770 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			batchData->rateTracer = traceRate("FastRestoreApplierTransactionRateControlDone", batchData, req.batchIndex, self->id(), &self->finishedBatch, true );
															#line 776 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			self->finishedBatch.set(req.batchIndex);
															#line 779 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			self->batch.erase(req.batchIndex);
															#line 780 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (self->delayedActors > 0)
															#line 5534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 781 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				self->checkMemory.trigger();
															#line 5538 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
		if (self->finishedBatch.get() == req.batchIndex - 1)
															#line 5549 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		{
															#line 770 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			batchData->rateTracer = traceRate("FastRestoreApplierTransactionRateControlDone", batchData, req.batchIndex, self->id(), &self->finishedBatch, true );
															#line 776 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			self->finishedBatch.set(req.batchIndex);
															#line 779 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			self->batch.erase(req.batchIndex);
															#line 780 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
			if (self->delayedActors > 0)
															#line 5559 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			{
															#line 781 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
				self->checkMemory.trigger();
															#line 5563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state > 0) static_cast<HandleApplyToDBRequestActor*>(this)->actor_wait_state = 0;
		static_cast<HandleApplyToDBRequestActor*>(this)->ActorCallback< HandleApplyToDBRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleApplyToDBRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleApplyToDBRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleApplyToDBRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleApplyToDBRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleApplyToDBRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleApplyToDBRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	RestoreVersionBatchRequest req;
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<RestoreApplierData> self;
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Database cx;
															#line 736 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	bool isDuplicated;
															#line 739 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	Reference<ApplierBatchData> batchData;
															#line 5655 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleApplyToDBRequest()
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
class HandleApplyToDBRequestActor final : public Actor<Void>, public ActorCallback< HandleApplyToDBRequestActor, 0, Void >, public ActorCallback< HandleApplyToDBRequestActor, 1, Void >, public FastAllocated<HandleApplyToDBRequestActor>, public HandleApplyToDBRequestActorState<HandleApplyToDBRequestActor> {
															#line 5660 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleApplyToDBRequestActor>::operator new;
	using FastAllocated<HandleApplyToDBRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2372856241017785088UL, 6924934371617676032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleApplyToDBRequestActor, 0, Void >;
friend struct ActorCallback< HandleApplyToDBRequestActor, 1, Void >;
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	HandleApplyToDBRequestActor(RestoreVersionBatchRequest const& req,Reference<RestoreApplierData> const& self,Database const& cx) 
															#line 5678 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleApplyToDBRequestActorState<HandleApplyToDBRequestActor>(req, self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(610560459942438400UL, 8863361429293827072UL);
		ActorExecutionContextHelper __helper(static_cast<HandleApplyToDBRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleApplyToDBRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleApplyToDBRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleApplyToDBRequestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleApplyToDBRequestActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
[[nodiscard]] static Future<Void> handleApplyToDBRequest( RestoreVersionBatchRequest const& req, Reference<RestoreApplierData> const& self, Database const& cx ) {
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"
	return Future<Void>(new HandleApplyToDBRequestActor(req, self, cx));
															#line 5712 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreApplier.actor.g.cpp.py_gen"
}

#line 795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/RestoreApplier.actor.cpp"

// Copy from WriteDuringRead.actor.cpp with small modifications
// Not all AtomicOps are handled in this function: SetVersionstampedKey, SetVersionstampedValue, and CompareAndClear
Value applyAtomicOp(Optional<StringRef> existingValue, Value value, MutationRef::Type type) {
	Arena arena;
	if (type == MutationRef::AddValue)
		return doLittleEndianAdd(existingValue, value, arena);
	else if (type == MutationRef::AppendIfFits)
		return doAppendIfFits(existingValue, value, arena);
	else if (type == MutationRef::And || type == MutationRef::AndV2)
		return doAndV2(existingValue, value, arena);
	else if (type == MutationRef::Or)
		return doOr(existingValue, value, arena);
	else if (type == MutationRef::Xor)
		return doXor(existingValue, value, arena);
	else if (type == MutationRef::Max)
		return doMax(existingValue, value, arena);
	else if (type == MutationRef::Min || type == MutationRef::MinV2)
		return doMinV2(existingValue, value, arena);
	else if (type == MutationRef::ByteMin)
		return doByteMin(existingValue, value, arena);
	else if (type == MutationRef::ByteMax)
		return doByteMax(existingValue, value, arena);
	else {
		TraceEvent(SevError, "ApplyAtomicOpUnhandledType")
		    .detail("TypeCode", (int)type)
		    .detail("TypeName", getTypeString(type));
		ASSERT(false);
	}
	return Value();
}
