#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
/*
 * ClusterController.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2026 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <iterator>
#include <map>
#include <memory>
#include <set>
#include <tuple>
#include <vector>

#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbrpc/Locality.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/ActorCollection.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/BackupInterface.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbserver/ConfigBroadcaster.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h" // copy constructors for ServerCoordinators class
#include "fdbserver/ClusterController.actor.h"
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/DBCoreState.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/LeaderElection.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemConfig.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/SingletonRoles.h"
#include "fdbserver/Status.actor.h"
#include "fdbserver/LatencyBandConfig.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbserver/RecoveryState.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/Replication.h"
#include "fdbrpc/ReplicationUtils.h"
#include "fdbrpc/sim_validation.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/Util.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getPreviousCoordinators()
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class GetPreviousCoordinatorsActor>
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActorState {
															#line 84 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActorState(ClusterControllerData* const& self) 
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(self->db.db)
															#line 93 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~GetPreviousCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 108 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 79 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 80 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 81 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(previousCoordinatorsKey);
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 152 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 85 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 181 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
															#line 83 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && previousCoordinators,int loopDepth) 
	{
															#line 83 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 208 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(previousCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(previousCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 76 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 382 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getPreviousCoordinators()
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActor final : public Actor<Optional<Value>>, public ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< GetPreviousCoordinatorsActor, 1, Void >, public FastAllocated<GetPreviousCoordinatorsActor>, public GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor> {
															#line 387 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetPreviousCoordinatorsActor>::operator new;
	using FastAllocated<GetPreviousCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3719531199071211776UL, 6410492223246081024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< GetPreviousCoordinatorsActor, 1, Void >;
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActor(ClusterControllerData* const& self) 
															#line 405 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Optional<Value>>(),
		   GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9522256357088947712UL, 3090868322878582016UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getPreviousCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getPreviousCoordinators( ClusterControllerData* const& self ) {
															#line 75 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Optional<Value>>(new GetPreviousCoordinatorsActor(self));
															#line 439 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 89 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

bool ClusterControllerData::processesInSameDC(const NetworkAddress& addr1, const NetworkAddress& addr2) const {
	return this->addr_locality.contains(addr1) && this->addr_locality.contains(addr2) &&
	       this->addr_locality.at(addr1).dcId().present() && this->addr_locality.at(addr2).dcId().present() &&
	       this->addr_locality.at(addr1).dcId().get() == this->addr_locality.at(addr2).dcId().get();
}

bool ClusterControllerData::transactionSystemContainsDegradedServers() {
	const ServerDBInfo& dbi = db.serverInfo->get();
	const Reference<ClusterRecoveryData> recoveryData = db.recoveryData;
	auto transactionWorkerInList = [&dbi, &recoveryData](const std::unordered_set<NetworkAddress>& serverList,
	                                                     bool skipSatellite,
	                                                     bool skipRemoteTLog,
	                                                     bool skipRemoteLogRouter) -> bool {
		for (const auto& server : serverList) {
			if (dbi.master.addresses().contains(server)) {
				return true;
			}

			// Getting the current log system config to check if any TLogs are degraded. recoveryData->logSystem has the
			// most up to date log system and we should use it whenever available.
			auto logSystemConfig = (recoveryData.isValid() && recoveryData->logSystem.isValid())
			                           ? recoveryData->logSystem->getLogSystemConfig()
			                           : dbi.logSystemConfig;
			for (const auto& logSet : logSystemConfig.tLogs) {
				if (skipSatellite && logSet.locality == tagLocalitySatellite) {
					continue;
				}

				if (!logSet.isLocal) {
					if (!skipRemoteTLog) {
						for (const auto& tlog : logSet.tLogs) {
							if (tlog.present() && tlog.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
					if (!skipRemoteLogRouter) {
						for (const auto& logRouter : logSet.logRouters) {
							if (logRouter.present() && logRouter.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
				} else {
					for (const auto& tlog : logSet.tLogs) {
						if (tlog.present() && tlog.interf().addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			if (SERVER_KNOBS->GRAY_FAILURE_ENABLE_TLOG_RECOVERY_MONITORING && recoveryData.isValid() &&
			    recoveryData->recoveryState < RecoveryState::ACCEPTING_COMMITS) {
				// During recovery, TLogs may not be able to pull data from previous generation TLogs due to gray
				// failures. In this case, we rely on the latest recruitment information and see if any newly recruited
				// TLogs are degraded.
				for (const auto& tlog : recoveryData->primaryRecruitment.tLogs) {
					if (tlog.addresses().contains(server)) {
						return true;
					}
				}

				if (!skipSatellite) {
					for (const auto& satelliteLog : recoveryData->primaryRecruitment.satelliteTLogs) {
						if (satelliteLog.addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			for (const auto& proxy : dbi.client.grvProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& proxy : dbi.client.commitProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& resolver : dbi.resolvers) {
				if (resolver.addresses().contains(server)) {
					return true;
				}
			}
		}
		return false;
	};

	// Check if transaction system contains degraded/disconnected servers. For satellite, we only
	// check for disconnection since the latency between prmary and satellite is across WAN and may not be very
	// stable.
	// TODO: Consider adding satellite latency degradation check and rely on
	//       SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY for accurate health signal
	return transactionWorkerInList(degradationInfo.degradedServers,
	                               /*skipSatellite=*/true,
	                               /*skipRemoteTLog=*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DEGRADATION_MONITORING),
	                               /*skipRemoteLogRouter*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DEGRADATION_MONITORING)) ||
	       transactionWorkerInList(
	           degradationInfo.disconnectedServers,
	           /*skipSatellite=*/false,
	           /*skipRemoteTLog=*/!SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DISCONNECT_MONITORING,
	           /*skipRemoteLogRouter*/ !SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DISCONNECT_MONITORING);
}

bool ClusterControllerData::remoteTransactionSystemContainsDegradedServers() {
	if (db.config.usableRegions <= 1) {
		return false;
	}

	for (const auto& excludedServer : degradationInfo.degradedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	for (const auto& excludedServer : degradationInfo.disconnectedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	return false;
}

// Recruit failed log routers in parallel
															#line 578 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via recruitFailedLogRouters()
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RecruitFailedLogRoutersActor>
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RecruitFailedLogRoutersActorState {
															#line 585 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RecruitFailedLogRoutersActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,std::vector<int> const& tagIds,int const& logSetIndex,Reference<ILogSystem> const& logSystem,LogSystemConfig const& config) 
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tagIds(tagIds),
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSetIndex(logSetIndex),
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSystem(logSystem),
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   config(config),
															#line 230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   targetDcId(db->recoveryData->remoteDcIds.size() ? db->recoveryData->remoteDcIds[0] : Optional<Key>())
															#line 604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this));

	}
	~RecruitFailedLogRoutersActorState() 
	{
		fdb_probe_actor_destroy("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			std::map<Optional<Standalone<StringRef>>, int> id_used;
															#line 235 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateKnownIds(&id_used);
															#line 237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers = cluster->getWorkersForRoleInDatacenter(targetDcId, ProcessClass::LogRouter, tagIds.size(), db->config, id_used);
															#line 240 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (workers.size() < tagIds.size())
															#line 625 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 241 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "NotEnoughWorkersForLogRouters", cluster->id) .detail("Required", tagIds.size()) .detail("Available", workers.size()) .detail("TargetDcId", targetDcId);
															#line 245 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 631 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("RecruitingLogRouters", cluster->id) .detail("Count", tagIds.size()) .detail("LogSetIndex", logSetIndex) .detail("TargetDcId", targetDcId);
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitments = std::vector<Future<ErrorOr<TLogInterface>>>();
															#line 258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < tagIds.size();i++) {
															#line 259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				InitializeLogRouterRequest req;
															#line 261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reqId = deterministicRandom()->randomUniqueID();
															#line 262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.recoveryCount = db->recoveryData->cstate.myDBState.recoveryCount;
															#line 263 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.routerTag = routerTag;
															#line 266 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.startVersion = 0;
															#line 267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.locality = config.tLogs[logSetIndex].locality;
															#line 268 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.isReplacement = true;
															#line 270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				for( auto& tLogSet : config.tLogs ) {
															#line 271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!tLogSet.isLocal && tLogSet.tLogs.size() > 0)
															#line 659 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 272 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.tLogLocalities = tLogSet.tLogLocalities;
															#line 273 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.tLogPolicy = tLogSet.tLogPolicy;
															#line 665 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
						break;
					}
				}
															#line 278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (db->recoveryData->logSystem.isValid())
															#line 671 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					auto lsConfig = db->recoveryData->logSystem->getLogSystemConfig();
															#line 280 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (lsConfig.recoveredAt.present())
															#line 677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 281 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						req.recoverAt = lsConfig.recoveredAt.get();
															#line 681 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
															#line 285 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.allowDropInSim = g_network->isSimulated() && deterministicRandom()->coinflip();
															#line 286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(req.allowDropInSim, "Log router recruitment requests dropped in simulation");
															#line 288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("RecruitingLogRouterOnWorker", cluster->id) .detail("WorkerID", workers[i].interf.id()) .detail("Tag", routerTag) .detail("TagId", tagIds[i]);
															#line 293 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				recruitments.push_back(workers[i].interf.logRouter.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY));
															#line 692 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 298 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			timeout = delay(SERVER_KNOBS->CC_RERECRUIT_LOG_ROUTER_TIMEOUT);
															#line 299 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(recruitments) || timeout;
															#line 299 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RecruitFailedLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 700 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitFailedLogRoutersActor*>(this)->actor_wait_state = 1;
															#line 299 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*>(static_cast<RecruitFailedLogRoutersActor*>(this)));
															#line 705 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitFailedLogRoutersActorState();
		static_cast<RecruitFailedLogRoutersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (timeout.isReady())
															#line 728 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "LogRoutersRecruitmentTimeout", cluster->id) .detail("TagCount", tagIds.size()) .detail("LogSetIndex", logSetIndex);
															#line 305 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 309 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < recruitments.size();i++) {
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ErrorOr<TLogInterface> result = recruitments[i].get();
															#line 311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (result.isError())
															#line 742 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 312 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "LogRouterRecruitmentFailed", cluster->id) .error(result.getError()) .detail("TagId", tagIds[i]);
															#line 315 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 318 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TLogInterface logRouterInterf = result.get();
															#line 319 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 321 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LogRouterRecruited", cluster->id) .detail("Tag", routerTag) .detail("LogRouterID", logRouterInterf.id()) .detail("WorkerID", workers[i].interf.id()) .detail("LogSetIndex", logSetIndex);
															#line 328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			logSystem->updateLogRouter(logSetIndex, tagIds[i], logRouterInterf);
															#line 758 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData->registrationTrigger.trigger();
															#line 334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("LogRoutersRecruitmentComplete", cluster->id).detail("Count", tagIds.size());
															#line 336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RecruitFailedLogRoutersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitFailedLogRoutersActorState(); static_cast<RecruitFailedLogRoutersActor*>(this)->destroy(); return 0; }
															#line 766 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitFailedLogRoutersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitFailedLogRoutersActorState();
		static_cast<RecruitFailedLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (timeout.isReady())
															#line 778 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "LogRoutersRecruitmentTimeout", cluster->id) .detail("TagCount", tagIds.size()) .detail("LogSetIndex", logSetIndex);
															#line 305 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 784 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 309 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < recruitments.size();i++) {
															#line 310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ErrorOr<TLogInterface> result = recruitments[i].get();
															#line 311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (result.isError())
															#line 792 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 312 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "LogRouterRecruitmentFailed", cluster->id) .error(result.getError()) .detail("TagId", tagIds[i]);
															#line 315 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 798 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 318 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TLogInterface logRouterInterf = result.get();
															#line 319 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag routerTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 321 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LogRouterRecruited", cluster->id) .detail("Tag", routerTag) .detail("LogRouterID", logRouterInterf.id()) .detail("WorkerID", workers[i].interf.id()) .detail("LogSetIndex", logSetIndex);
															#line 328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			logSystem->updateLogRouter(logSetIndex, tagIds[i], logRouterInterf);
															#line 808 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData->registrationTrigger.trigger();
															#line 334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("LogRoutersRecruitmentComplete", cluster->id).detail("Count", tagIds.size());
															#line 336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RecruitFailedLogRoutersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitFailedLogRoutersActorState(); static_cast<RecruitFailedLogRoutersActor*>(this)->destroy(); return 0; }
															#line 816 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitFailedLogRoutersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitFailedLogRoutersActorState();
		static_cast<RecruitFailedLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitFailedLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<RecruitFailedLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitFailedLogRoutersActor*>(this)->ActorCallback< RecruitFailedLogRoutersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<int> tagIds;
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int logSetIndex;
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	LogSystemConfig config;
															#line 230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Key> targetDcId;
															#line 237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<ErrorOr<TLogInterface>>> recruitments;
															#line 298 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> timeout;
															#line 919 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via recruitFailedLogRouters()
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RecruitFailedLogRoutersActor final : public Actor<Void>, public ActorCallback< RecruitFailedLogRoutersActor, 0, Void >, public FastAllocated<RecruitFailedLogRoutersActor>, public RecruitFailedLogRoutersActorState<RecruitFailedLogRoutersActor> {
															#line 924 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RecruitFailedLogRoutersActor>::operator new;
	using FastAllocated<RecruitFailedLogRoutersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12174561795687421952UL, 16683113606838177536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitFailedLogRoutersActor, 0, Void >;
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RecruitFailedLogRoutersActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,std::vector<int> const& tagIds,int const& logSetIndex,Reference<ILogSystem> const& logSystem,LogSystemConfig const& config) 
															#line 941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RecruitFailedLogRoutersActorState<RecruitFailedLogRoutersActor>(cluster, db, tagIds, logSetIndex, logSystem, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13500469936385790208UL, 18191486286878409728UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitFailedLogRouters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitFailedLogRouters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitFailedLogRoutersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> recruitFailedLogRouters( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, std::vector<int> const& tagIds, int const& logSetIndex, Reference<ILogSystem> const& logSystem, LogSystemConfig const& config ) {
															#line 224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RecruitFailedLogRoutersActor(cluster, db, tagIds, logSetIndex, logSystem, config));
															#line 974 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 338 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 979 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorLogRouters()
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorLogRoutersActor>
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorLogRoutersActorState {
															#line 986 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorLogRoutersActorState(Reference<ILogSystem> const& logSystem,int const& logSetIndex) 
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : logSystem(logSystem),
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSetIndex(logSetIndex),
															#line 340 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failures(),
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   config(logSystem->getLogSystemConfig()),
															#line 342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failedTagIds()
															#line 1001 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorLogRouters", reinterpret_cast<unsigned long>(this));

	}
	~MonitorLogRoutersActorState() 
	{
		fdb_probe_actor_destroy("monitorLogRouters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 344 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (logSetIndex == -1)
															#line 1016 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 345 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				this->~MonitorLogRoutersActorState();
															#line 1020 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				static_cast<MonitorLogRoutersActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 348 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT_WE_THINK(logSetIndex >= 0 && logSetIndex < config.tLogs.size());
															#line 350 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < config.tLogs[logSetIndex].logRouters.size();i++) {
															#line 351 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(config.tLogs[logSetIndex].logRouters[i].present());
															#line 352 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = config.tLogs[logSetIndex].logRouters[i];
															#line 353 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failures.push_back( waitFailureClient(worker.interf().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true, "LogRouterFailed"_sr));
															#line 1034 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures.empty())
															#line 1038 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 362 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				this->~MonitorLogRoutersActorState();
															#line 1042 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				static_cast<MonitorLogRoutersActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = quorum(failures, 1);
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1050 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorLogRoutersActor*>(this)->actor_wait_state = 1;
															#line 365 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorLogRoutersActor, 0, Void >*>(static_cast<MonitorLogRoutersActor*>(this)));
															#line 1055 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorLogRoutersActorState();
		static_cast<MonitorLogRoutersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 367 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < failures.size();i++) {
															#line 368 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures[i].isReady() || failures[i].isError())
															#line 1080 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 369 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failedTagIds.push_back(i);
															#line 1084 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 372 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorLogRoutersActor*>(this)->SAV<std::vector<int>>::futures) { (void)(failedTagIds); this->~MonitorLogRoutersActorState(); static_cast<MonitorLogRoutersActor*>(this)->destroy(); return 0; }
															#line 1089 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorLogRoutersActor*>(this)->SAV< std::vector<int> >::value()) std::vector<int>(std::move(failedTagIds)); // state_var_RVO
		this->~MonitorLogRoutersActorState();
		static_cast<MonitorLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 367 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < failures.size();i++) {
															#line 368 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures[i].isReady() || failures[i].isError())
															#line 1103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 369 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failedTagIds.push_back(i);
															#line 1107 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 372 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorLogRoutersActor*>(this)->SAV<std::vector<int>>::futures) { (void)(failedTagIds); this->~MonitorLogRoutersActorState(); static_cast<MonitorLogRoutersActor*>(this)->destroy(); return 0; }
															#line 1112 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorLogRoutersActor*>(this)->SAV< std::vector<int> >::value()) std::vector<int>(std::move(failedTagIds)); // state_var_RVO
		this->~MonitorLogRoutersActorState();
		static_cast<MonitorLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<MonitorLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorLogRoutersActor*>(this)->ActorCallback< MonitorLogRoutersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorLogRoutersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorLogRoutersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorLogRoutersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int logSetIndex;
															#line 340 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Void>> failures;
															#line 341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	LogSystemConfig config;
															#line 342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<int> failedTagIds;
															#line 1205 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorLogRouters()
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorLogRoutersActor final : public Actor<std::vector<int>>, public ActorCallback< MonitorLogRoutersActor, 0, Void >, public FastAllocated<MonitorLogRoutersActor>, public MonitorLogRoutersActorState<MonitorLogRoutersActor> {
															#line 1210 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorLogRoutersActor>::operator new;
	using FastAllocated<MonitorLogRoutersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3930783032959717376UL, 5204930328423683072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<int>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorLogRoutersActor, 0, Void >;
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorLogRoutersActor(Reference<ILogSystem> const& logSystem,int const& logSetIndex) 
															#line 1227 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<std::vector<int>>(),
		   MonitorLogRoutersActorState<MonitorLogRoutersActor>(logSystem, logSetIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorLogRouters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3981865692395027200UL, 16458587610827814912UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorLogRouters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorLogRouters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorLogRoutersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<std::vector<int>> monitorLogRouters( Reference<ILogSystem> const& logSystem, int const& logSetIndex ) {
															#line 339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<std::vector<int>>(new MonitorLogRoutersActor(logSystem, logSetIndex));
															#line 1260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 374 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// When in fully_recovered state, the cluster controller will monitor log routers
// and backup workers, and re-recruit any failed log routers or backup workers.
// This actor will be restarted in each recovery and will exit when a new recovery is detected.
															#line 1268 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorAndRecruitWorkerSet()
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorAndRecruitWorkerSetActor>
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorAndRecruitWorkerSetActorState {
															#line 1275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorAndRecruitWorkerSetActorState(ClusterControllerData* const& self,uint64_t const& recoveryCount,const char* const& workerName,std::function<Future<std::vector<int>>()> const& monitor,std::function<Future<Void>(std::vector<int>)> const& recruit) 
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   workerName(workerName),
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   monitor(monitor),
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recruit(recruit)
															#line 1290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this));

	}
	~MonitorAndRecruitWorkerSetActorState() 
	{
		fdb_probe_actor_destroy("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 383 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent((std::string(workerName) + "MonitoringStart").c_str(), self->id).detail("RecoveryCount", recoveryCount);
															#line 385 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedRecruitDelay = 1.0;
															#line 386 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitment = Never();
															#line 387 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newRecovery = self->db.serverInfo->onChange();
															#line 388 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 1313 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorAndRecruitWorkerSetActorState();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 391 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = newRecovery;
															#line 390 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1346 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 402 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<std::vector<int>> __when_expr_1 = monitor();
															#line 1350 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = recruitment;
															#line 1354 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state = 1;
															#line 391 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*>(static_cast<MonitorAndRecruitWorkerSetActor*>(this)));
															#line 402 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >*>(static_cast<MonitorAndRecruitWorkerSetActor*>(this)));
															#line 407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >*>(static_cast<MonitorAndRecruitWorkerSetActor*>(this)));
															#line 1363 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 430 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(failedRecruitDelay);
															#line 430 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1380 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state = 2;
															#line 430 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*>(static_cast<MonitorAndRecruitWorkerSetActor*>(this)));
															#line 1385 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (strcmp(workerName, "LogRouter") == 0)
															#line 1395 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "LogRouter re-recruitment failed");
															#line 1399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 420 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(strcmp(workerName, "BackupWorker") == 0);
															#line 421 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "BackupWorker re-recruitment failed");
															#line 1407 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 423 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, (std::string(workerName) + "MonitoringRecruitmentFailed").c_str(), self->id) .error(e) .detail("RecoveryCount", recoveryCount);
															#line 426 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedRecruitDelay = std::min(failedRecruitDelay * 2, 60.0);
															#line 427 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitment = Never();
															#line 1415 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.recoveryData.isValid() && self->db.recoveryData->cstate.myDBState.recoveryCount == recoveryCount)
															#line 1436 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 394 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newRecovery = self->db.serverInfo->onChange();
															#line 1440 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 397 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "MonitoringEnded").c_str(), self->id) .detail("Reason", "RecoveryChanged") .detail("RecoveryCount", recoveryCount);
															#line 400 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorAndRecruitWorkerSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorAndRecruitWorkerSetActorState(); static_cast<MonitorAndRecruitWorkerSetActor*>(this)->destroy(); return 0; }
															#line 1447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorAndRecruitWorkerSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorAndRecruitWorkerSetActorState();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.recoveryData.isValid() && self->db.recoveryData->cstate.myDBState.recoveryCount == recoveryCount)
															#line 1459 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 394 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newRecovery = self->db.serverInfo->onChange();
															#line 1463 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 397 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "MonitoringEnded").c_str(), self->id) .detail("Reason", "RecoveryChanged") .detail("RecoveryCount", recoveryCount);
															#line 400 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorAndRecruitWorkerSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorAndRecruitWorkerSetActorState(); static_cast<MonitorAndRecruitWorkerSetActor*>(this)->destroy(); return 0; }
															#line 1470 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorAndRecruitWorkerSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorAndRecruitWorkerSetActorState();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(std::vector<int> const& failedWorkers,int loopDepth) 
	{
															#line 403 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitment = recruit(failedWorkers);
															#line 404 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "FailureDetected").c_str(), self->id) .detail("FailedCount", failedWorkers.size());
															#line 1484 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(std::vector<int> && failedWorkers,int loopDepth) 
	{
															#line 403 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitment = recruit(failedWorkers);
															#line 404 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "FailureDetected").c_str(), self->id) .detail("FailedCount", failedWorkers.size());
															#line 1495 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		failedRecruitDelay = 1.0;
															#line 409 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "ReRecruitmentSuccess").c_str(), self->id) .detail("RecoveryCount", recoveryCount);
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitment = Never();
															#line 1508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		failedRecruitDelay = 1.0;
															#line 409 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent((std::string(workerName) + "ReRecruitmentSuccess").c_str(), self->id) .detail("RecoveryCount", recoveryCount);
															#line 411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitment = Never();
															#line 1521 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >::remove();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >::remove();
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >*,std::vector<int> const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >*,std::vector<int> && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndRecruitWorkerSetActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndRecruitWorkerSetActor*>(this)->ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	uint64_t recoveryCount;
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	const char* workerName;
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::function<Future<std::vector<int>>()> monitor;
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::function<Future<Void>(std::vector<int>)> recruit;
															#line 385 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double failedRecruitDelay;
															#line 386 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> recruitment;
															#line 387 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> newRecovery;
															#line 1821 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorAndRecruitWorkerSet()
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorAndRecruitWorkerSetActor final : public Actor<Void>, public ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >, public ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >, public ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >, public ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >, public FastAllocated<MonitorAndRecruitWorkerSetActor>, public MonitorAndRecruitWorkerSetActorState<MonitorAndRecruitWorkerSetActor> {
															#line 1826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorAndRecruitWorkerSetActor>::operator new;
	using FastAllocated<MonitorAndRecruitWorkerSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3021726068688521728UL, 14704947109540258048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >;
friend struct ActorCallback< MonitorAndRecruitWorkerSetActor, 1, std::vector<int> >;
friend struct ActorCallback< MonitorAndRecruitWorkerSetActor, 2, Void >;
friend struct ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >;
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorAndRecruitWorkerSetActor(ClusterControllerData* const& self,uint64_t const& recoveryCount,const char* const& workerName,std::function<Future<std::vector<int>>()> const& monitor,std::function<Future<Void>(std::vector<int>)> const& recruit) 
															#line 1846 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorAndRecruitWorkerSetActorState<MonitorAndRecruitWorkerSetActor>(self, recoveryCount, workerName, monitor, recruit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10141132090468743168UL, 3661297284784934400UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndRecruitWorkerSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorAndRecruitWorkerSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorAndRecruitWorkerSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorAndRecruitWorkerSetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorAndRecruitWorkerSetActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorAndRecruitWorkerSet( ClusterControllerData* const& self, uint64_t const& recoveryCount, const char* const& workerName, std::function<Future<std::vector<int>>()> const& monitor, std::function<Future<Void>(std::vector<int>)> const& recruit ) {
															#line 378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorAndRecruitWorkerSetActor(self, recoveryCount, workerName, monitor, recruit));
															#line 1880 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 433 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

Future<Void> monitorAndRecruitLogRouters(ClusterControllerData* self) {
	while (true) {
		// Wait until fully recovered
		while (self->db.serverInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED) {
			co_await self->db.serverInfo->onChange();
		}

		ASSERT(self->db.recoveryData.isValid());
		uint64_t recoveryCount = self->db.recoveryData->cstate.myDBState.recoveryCount;
		Reference<ILogSystem> logSystem = self->db.recoveryData->logSystem;
		LogSystemConfig config = logSystem->getLogSystemConfig();

		// Find the log set with log routers (should be remote/satellite)
		int logSetIndex = -1;
		for (int i = 0; i < config.tLogs.size(); i++) {
			if (config.tLogs[i].logRouters.size() > 0) {
				ASSERT_WE_THINK(logSetIndex == -1); // only one log set should have log routers
				logSetIndex = i;
			}
		}

		if (logSetIndex == -1) {
			TraceEvent("NoLogRoutersToMonitor", self->id).detail("RecoveryCount", recoveryCount).log();
			// Wait for recovery to change before trying again
			while (self->db.serverInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED &&
			       self->db.recoveryData.isValid() &&
			       self->db.recoveryData->cstate.myDBState.recoveryCount == recoveryCount) {
				co_await self->db.serverInfo->onChange();
			}
			continue;
		}

		TraceEvent("LogRouterMonitoringDetails", self->id)
		    .detail("LogSetIndex", logSetIndex)
		    .detail("LogRouterCount", config.tLogs[logSetIndex].logRouters.size())
		    .detail("IsLocal", config.tLogs[logSetIndex].isLocal)
		    .detail("Locality", config.tLogs[logSetIndex].locality);

		std::function<Future<std::vector<int>>()> monitor = [logSystem, logSetIndex]() {
			return monitorLogRouters(logSystem, logSetIndex);
		};
		std::function<Future<Void>(std::vector<int>)> recruit =
		    [self, logSetIndex, logSystem](std::vector<int> failedWorkers) {
			    return recruitFailedLogRouters(
			        self, &self->db, failedWorkers, logSetIndex, logSystem, logSystem->getLogSystemConfig());
		    };

		co_await monitorAndRecruitWorkerSet(self, recoveryCount, "LogRouter", monitor, recruit);
	}
}

// Monitors failures of backup workers of current generation and returns their tag IDs.
															#line 1937 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorBackupWorkers()
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorBackupWorkersActor>
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorBackupWorkersActorState {
															#line 1944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorBackupWorkersActorState(ClusterControllerData* const& self,Reference<ILogSystem> const& logSystem) 
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSystem(logSystem),
															#line 487 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failures(),
															#line 488 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failedTagIds(),
															#line 489 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   config(logSystem->getLogSystemConfig()),
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSetIndex(-1)
															#line 1961 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorBackupWorkers", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBackupWorkersActorState() 
	{
		fdb_probe_actor_destroy("monitorBackupWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 493 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < config.tLogs.size();i++) {
															#line 494 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (config.tLogs[i].isLocal && config.tLogs[i].backupWorkers.size() > 0)
															#line 1978 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 495 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					logSetIndex = i;
															#line 1982 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (logSetIndex == -1)
															#line 1988 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 502 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				this->~MonitorBackupWorkersActorState();
															#line 1992 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				static_cast<MonitorBackupWorkersActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 506 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < config.tLogs[logSetIndex].backupWorkers.size();i++) {
															#line 507 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!config.tLogs[logSetIndex].backupWorkers[i].present())
															#line 2000 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 510 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = config.tLogs[logSetIndex].backupWorkers[i];
															#line 511 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failures.push_back( waitFailureClient(worker.interf().waitFailure, SERVER_KNOBS->BACKUP_TIMEOUT, -SERVER_KNOBS->BACKUP_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true, "BackupWorkerFailed"_sr));
															#line 2008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 519 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = quorum(failures, 1);
															#line 519 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorBackupWorkersActor*>(this)->actor_wait_state = 1;
															#line 519 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupWorkersActor, 0, Void >*>(static_cast<MonitorBackupWorkersActor*>(this)));
															#line 2019 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBackupWorkersActorState();
		static_cast<MonitorBackupWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 521 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < failures.size();i++) {
															#line 522 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures[i].isReady() || failures[i].isError())
															#line 2044 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 523 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failedTagIds.push_back(i);
															#line 2048 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 526 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorBackupWorkersActor*>(this)->SAV<std::vector<int>>::futures) { (void)(failedTagIds); this->~MonitorBackupWorkersActorState(); static_cast<MonitorBackupWorkersActor*>(this)->destroy(); return 0; }
															#line 2053 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorBackupWorkersActor*>(this)->SAV< std::vector<int> >::value()) std::vector<int>(std::move(failedTagIds)); // state_var_RVO
		this->~MonitorBackupWorkersActorState();
		static_cast<MonitorBackupWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 521 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < failures.size();i++) {
															#line 522 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (failures[i].isReady() || failures[i].isError())
															#line 2067 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 523 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				failedTagIds.push_back(i);
															#line 2071 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 526 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<MonitorBackupWorkersActor*>(this)->SAV<std::vector<int>>::futures) { (void)(failedTagIds); this->~MonitorBackupWorkersActorState(); static_cast<MonitorBackupWorkersActor*>(this)->destroy(); return 0; }
															#line 2076 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<MonitorBackupWorkersActor*>(this)->SAV< std::vector<int> >::value()) std::vector<int>(std::move(failedTagIds)); // state_var_RVO
		this->~MonitorBackupWorkersActorState();
		static_cast<MonitorBackupWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupWorkersActor*>(this)->ActorCallback< MonitorBackupWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBackupWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBackupWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 487 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Void>> failures;
															#line 488 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<int> failedTagIds;
															#line 489 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	LogSystemConfig config;
															#line 492 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int logSetIndex;
															#line 2171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorBackupWorkers()
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorBackupWorkersActor final : public Actor<std::vector<int>>, public ActorCallback< MonitorBackupWorkersActor, 0, Void >, public FastAllocated<MonitorBackupWorkersActor>, public MonitorBackupWorkersActorState<MonitorBackupWorkersActor> {
															#line 2176 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorBackupWorkersActor>::operator new;
	using FastAllocated<MonitorBackupWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6807786264932604160UL, 13677276175877718272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<int>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBackupWorkersActor, 0, Void >;
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorBackupWorkersActor(ClusterControllerData* const& self,Reference<ILogSystem> const& logSystem) 
															#line 2193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<std::vector<int>>(),
		   MonitorBackupWorkersActorState<MonitorBackupWorkersActor>(self, logSystem),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBackupWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12588822841661965312UL, 1036705557587122432UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBackupWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBackupWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBackupWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<std::vector<int>> monitorBackupWorkers( ClusterControllerData* const& self, Reference<ILogSystem> const& logSystem ) {
															#line 486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<std::vector<int>>(new MonitorBackupWorkersActor(self, logSystem));
															#line 2226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 528 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// Recruit failed backup workers in parallel
															#line 2232 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via recruitFailedBackupWorkers()
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RecruitFailedBackupWorkersActor>
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RecruitFailedBackupWorkersActorState {
															#line 2239 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RecruitFailedBackupWorkersActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,std::vector<int> const& tagIds,uint64_t const& recoveryCount,Reference<ILogSystem> const& logSystem,Database const& cx) 
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tagIds(tagIds),
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   logSystem(logSystem),
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cx(cx)
															#line 2256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this));

	}
	~RecruitFailedBackupWorkersActorState() 
	{
		fdb_probe_actor_destroy("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 537 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			std::map<Optional<Standalone<StringRef>>, int> id_used;
															#line 538 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateKnownIds(&id_used);
															#line 540 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers = cluster->getWorkersForRoleInDatacenter( cluster->clusterControllerDcId, ProcessClass::Backup, tagIds.size(), db->config, id_used);
															#line 543 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (workers.size() < tagIds.size())
															#line 2277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 544 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "NotEnoughWorkersForBackupWorkers", cluster->id) .detail("Required", tagIds.size()) .detail("Available", workers.size());
															#line 547 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 551 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			backupProgress = Reference<BackupProgress>(new BackupProgress(cluster->id, logSystem->getOldEpochTagsVersionsInfo()));
															#line 553 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getBackupProgress(cx, cluster->id, backupProgress, false);
															#line 553 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2291 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state = 1;
															#line 553 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitFailedBackupWorkersActor, 0, Void >*>(static_cast<RecruitFailedBackupWorkersActor*>(this)));
															#line 2296 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitFailedBackupWorkersActorState();
		static_cast<RecruitFailedBackupWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 556 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		unfinishedBackup = backupProgress->getUnfinishedBackup();
															#line 559 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("RecruitingBackupWorkers", cluster->id) .detail("Count", tagIds.size()) .detail("RecoveryCount", db->recoveryData->cstate.myDBState.recoveryCount);
															#line 564 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitments = std::vector<Future<ErrorOr<InitializeBackupReply>>>();
															#line 565 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		logRouterTags = logSystem->getLogRouterTags();
															#line 567 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (recoveryCount < db->recoveryData->cstate.myDBState.recoveryCount)
															#line 2327 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 568 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, "RecruitBackupWorkersStaleRecovery", cluster->id) .detail("RequestedRecoveryCount", recoveryCount) .detail("CurrentRecoveryCount", db->recoveryData->cstate.myDBState.recoveryCount);
															#line 571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2333 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < tagIds.size();i++) {
															#line 575 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const int& tagId = tagIds[i];
															#line 576 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag backupTag = Tag(tagLocalityLogRouter, tagId);
															#line 578 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			InitializeBackupRequest req(deterministicRandom()->randomUniqueID());
															#line 579 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.recruitedEpoch = db->recoveryData->cstate.myDBState.recoveryCount;
															#line 580 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.backupEpoch = recoveryCount;
															#line 581 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.routerTag = backupTag;
															#line 582 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.totalTags = logRouterTags;
															#line 583 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.startVersion = 0;
															#line 584 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.isReplacement = true;
															#line 586 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("RecruitingBackupWorkerOnWorker", cluster->id) .detail("WorkerID", workers[i].interf.id()) .detail("Tag", backupTag) .detail("TagId", tagId) .detail("RecruitedEpoch", req.recruitedEpoch) .detail("BackupEpoch", req.backupEpoch) .detail("PassedRecoveryCount", recoveryCount);
															#line 594 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitments.push_back(workers[i].interf.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY));
															#line 2359 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		timeout = delay(SERVER_KNOBS->CC_RERECRUIT_BACKUP_WORKER_TIMEOUT);
															#line 600 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(recruitments) || timeout;
															#line 600 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2367 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state = 2;
															#line 600 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >*>(static_cast<RecruitFailedBackupWorkersActor*>(this)));
															#line 2372 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 556 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		unfinishedBackup = backupProgress->getUnfinishedBackup();
															#line 559 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("RecruitingBackupWorkers", cluster->id) .detail("Count", tagIds.size()) .detail("RecoveryCount", db->recoveryData->cstate.myDBState.recoveryCount);
															#line 564 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recruitments = std::vector<Future<ErrorOr<InitializeBackupReply>>>();
															#line 565 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		logRouterTags = logSystem->getLogRouterTags();
															#line 567 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (recoveryCount < db->recoveryData->cstate.myDBState.recoveryCount)
															#line 2389 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 568 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, "RecruitBackupWorkersStaleRecovery", cluster->id) .detail("RequestedRecoveryCount", recoveryCount) .detail("CurrentRecoveryCount", db->recoveryData->cstate.myDBState.recoveryCount);
															#line 571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2395 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < tagIds.size();i++) {
															#line 575 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const int& tagId = tagIds[i];
															#line 576 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag backupTag = Tag(tagLocalityLogRouter, tagId);
															#line 578 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			InitializeBackupRequest req(deterministicRandom()->randomUniqueID());
															#line 579 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.recruitedEpoch = db->recoveryData->cstate.myDBState.recoveryCount;
															#line 580 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.backupEpoch = recoveryCount;
															#line 581 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.routerTag = backupTag;
															#line 582 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.totalTags = logRouterTags;
															#line 583 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.startVersion = 0;
															#line 584 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.isReplacement = true;
															#line 586 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("RecruitingBackupWorkerOnWorker", cluster->id) .detail("WorkerID", workers[i].interf.id()) .detail("Tag", backupTag) .detail("TagId", tagId) .detail("RecruitedEpoch", req.recruitedEpoch) .detail("BackupEpoch", req.backupEpoch) .detail("PassedRecoveryCount", recoveryCount);
															#line 594 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recruitments.push_back(workers[i].interf.backup.getReplyUnlessFailedFor( req, SERVER_KNOBS->BACKUP_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY));
															#line 2421 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		timeout = delay(SERVER_KNOBS->CC_RERECRUIT_BACKUP_WORKER_TIMEOUT);
															#line 600 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(recruitments) || timeout;
															#line 600 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2429 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state = 2;
															#line 600 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >*>(static_cast<RecruitFailedBackupWorkersActor*>(this)));
															#line 2434 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitFailedBackupWorkersActor*>(this)->ActorCallback< RecruitFailedBackupWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitFailedBackupWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitFailedBackupWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitFailedBackupWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (timeout.isReady())
															#line 2518 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupWorkersRecruitmentTimeout", cluster->id) .detail("TagCount", tagIds.size()) .detail("RecoveryCount", recoveryCount);
															#line 606 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2524 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 610 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		newRecruits = std::vector<InitializeBackupReply>();
															#line 611 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < recruitments.size();i++) {
															#line 612 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ErrorOr<InitializeBackupReply> result = recruitments[i].get();
															#line 613 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (result.isError())
															#line 2534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 614 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "BackupWorkerRecruitmentFailed", cluster->id) .error(result.getError()) .detail("TagId", tagIds[i]) .detail("Epoch", recoveryCount);
															#line 618 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2540 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 621 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			InitializeBackupReply reply = result.get();
															#line 622 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag backupTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 624 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("BackupWorkerRecruited", cluster->id) .detail("Tag", backupTag) .detail("BackupWorkerID", reply.interf.id()) .detail("WorkerID", workers[i].interf.id()) .detail("Epoch", recoveryCount);
															#line 630 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newRecruits.push_back(reply);
															#line 2550 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 633 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (recoveryCount < db->recoveryData->cstate.myDBState.recoveryCount)
															#line 2554 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 634 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, "RecruitBackupWorkersStaleRecovery2", cluster->id) .detail("RequestedRecoveryCount", recoveryCount) .detail("CurrentRecoveryCount", db->recoveryData->cstate.myDBState.recoveryCount);
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2560 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 641 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		logSystem->updateBackupWorkers(tagIds, newRecruits);
															#line 644 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData->registrationTrigger.trigger();
															#line 646 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("BackupWorkersRecruitmentComplete", cluster->id).detail("Count", tagIds.size());
															#line 647 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RecruitFailedBackupWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitFailedBackupWorkersActorState(); static_cast<RecruitFailedBackupWorkersActor*>(this)->destroy(); return 0; }
															#line 2570 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitFailedBackupWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitFailedBackupWorkersActorState();
		static_cast<RecruitFailedBackupWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (timeout.isReady())
															#line 2582 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 603 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupWorkersRecruitmentTimeout", cluster->id) .detail("TagCount", tagIds.size()) .detail("RecoveryCount", recoveryCount);
															#line 606 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2588 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 610 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		newRecruits = std::vector<InitializeBackupReply>();
															#line 611 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(int i = 0;i < recruitments.size();i++) {
															#line 612 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ErrorOr<InitializeBackupReply> result = recruitments[i].get();
															#line 613 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (result.isError())
															#line 2598 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 614 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "BackupWorkerRecruitmentFailed", cluster->id) .error(result.getError()) .detail("TagId", tagIds[i]) .detail("Epoch", recoveryCount);
															#line 618 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2604 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 621 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			InitializeBackupReply reply = result.get();
															#line 622 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Tag backupTag = Tag(tagLocalityLogRouter, tagIds[i]);
															#line 624 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("BackupWorkerRecruited", cluster->id) .detail("Tag", backupTag) .detail("BackupWorkerID", reply.interf.id()) .detail("WorkerID", workers[i].interf.id()) .detail("Epoch", recoveryCount);
															#line 630 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newRecruits.push_back(reply);
															#line 2614 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 633 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (recoveryCount < db->recoveryData->cstate.myDBState.recoveryCount)
															#line 2618 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 634 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarnAlways, "RecruitBackupWorkersStaleRecovery2", cluster->id) .detail("RequestedRecoveryCount", recoveryCount) .detail("CurrentRecoveryCount", db->recoveryData->cstate.myDBState.recoveryCount);
															#line 637 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), loopDepth);
															#line 2624 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 641 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		logSystem->updateBackupWorkers(tagIds, newRecruits);
															#line 644 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData->registrationTrigger.trigger();
															#line 646 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("BackupWorkersRecruitmentComplete", cluster->id).detail("Count", tagIds.size());
															#line 647 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RecruitFailedBackupWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitFailedBackupWorkersActorState(); static_cast<RecruitFailedBackupWorkersActor*>(this)->destroy(); return 0; }
															#line 2634 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitFailedBackupWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitFailedBackupWorkersActorState();
		static_cast<RecruitFailedBackupWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state > 0) static_cast<RecruitFailedBackupWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitFailedBackupWorkersActor*>(this)->ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<int> tagIds;
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	uint64_t recoveryCount;
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ILogSystem> logSystem;
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Database cx;
															#line 540 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 551 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<BackupProgress> backupProgress;
															#line 556 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> unfinishedBackup;
															#line 564 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<ErrorOr<InitializeBackupReply>>> recruitments;
															#line 565 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int logRouterTags;
															#line 599 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> timeout;
															#line 610 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<InitializeBackupReply> newRecruits;
															#line 2743 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via recruitFailedBackupWorkers()
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RecruitFailedBackupWorkersActor final : public Actor<Void>, public ActorCallback< RecruitFailedBackupWorkersActor, 0, Void >, public ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >, public FastAllocated<RecruitFailedBackupWorkersActor>, public RecruitFailedBackupWorkersActorState<RecruitFailedBackupWorkersActor> {
															#line 2748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RecruitFailedBackupWorkersActor>::operator new;
	using FastAllocated<RecruitFailedBackupWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16529437390069953792UL, 5883056566861760256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitFailedBackupWorkersActor, 0, Void >;
friend struct ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >;
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RecruitFailedBackupWorkersActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,std::vector<int> const& tagIds,uint64_t const& recoveryCount,Reference<ILogSystem> const& logSystem,Database const& cx) 
															#line 2766 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RecruitFailedBackupWorkersActorState<RecruitFailedBackupWorkersActor>(cluster, db, tagIds, recoveryCount, logSystem, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1090735917907332352UL, 3422975624346781952UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitFailedBackupWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitFailedBackupWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitFailedBackupWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitFailedBackupWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecruitFailedBackupWorkersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> recruitFailedBackupWorkers( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, std::vector<int> const& tagIds, uint64_t const& recoveryCount, Reference<ILogSystem> const& logSystem, Database const& cx ) {
															#line 530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RecruitFailedBackupWorkersActor(cluster, db, tagIds, recoveryCount, logSystem, cx));
															#line 2800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 649 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

Future<Void> monitorAndRecruitBackupWorkers(ClusterControllerData* self) {
	while (true) {
		// Wait until fully recovered
		while (self->db.serverInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED) {
			co_await self->db.serverInfo->onChange();
		}

		ASSERT(self->db.recoveryData.isValid());
		uint64_t recoveryCount = self->db.recoveryData->cstate.myDBState.recoveryCount;
		Reference<ILogSystem> logSystem = self->db.recoveryData->logSystem;

		if (!self->db.recoveryData->configuration.backupWorkerEnabled) {
			TraceEvent("NoBackupWorkersToMonitor", self->id).detail("RecoveryCount", recoveryCount);
			logSystem->setOldestBackupEpoch(recoveryCount);

			// Wait for a new recovery
			while (self->db.serverInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED &&
			       self->db.recoveryData.isValid() &&
			       self->db.recoveryData->cstate.myDBState.recoveryCount == recoveryCount) {
				co_await self->db.serverInfo->onChange();
			}
			continue;
		}

		Database cx = openDBOnServer(self->db.serverInfo, TaskPriority::DefaultEndpoint, LockAware::True);

		std::function<Future<std::vector<int>>()> monitor = [self, logSystem]() {
			return monitorBackupWorkers(self, logSystem);
		};
		std::function<Future<Void>(std::vector<int>)> recruit =
		    [self, recoveryCount, logSystem, cx](std::vector<int> failedWorkers) {
			    return recruitFailedBackupWorkers(self, &self->db, failedWorkers, recoveryCount, logSystem, cx);
		    };

		co_await monitorAndRecruitWorkerSet(self, recoveryCount, "BackupWorker", monitor, recruit);
	}
}

															#line 2843 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterWatchDatabase()
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterWatchDatabaseActor>
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActorState {
															#line 2850 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 691 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   iMaster(),
															#line 692 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   addActor(),
															#line 693 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recoveryCore()
															#line 2867 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterWatchDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 698 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 2882 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterWatchDatabaseActorState();
		static_cast<ClusterWatchDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 699 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).log();
															#line 2912 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		try {
															#line 701 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			recoveryStart = now();
															#line 702 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			newMaster = MasterInterface();
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			collection = Future<Void>();
															#line 705 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).detail("Recruiting", "Master");
															#line 706 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = recruitNewMaster(cluster, db, std::addressof(newMaster));
															#line 706 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 1;
															#line 706 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 0, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 802 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			err = e;
															#line 803 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).errorUnsuppressed(e).detail("Master", iMaster.id());
															#line 804 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 2957 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 805 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(0.0);
															#line 805 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2963 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
				static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 5;
															#line 805 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 8, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 2968 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 708 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 710 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 711 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 713 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 714 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 715 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 716 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 717 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 718 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 719 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 720 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 721 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 722 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 723 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 724 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 726 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
															#line 727 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 728 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 730 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 736 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 741 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 742 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 753 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 754 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 758 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3042 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 708 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 710 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 711 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 713 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 714 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 715 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 716 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 717 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 718 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 719 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 720 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 721 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 722 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 723 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 724 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 726 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
															#line 727 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 728 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 730 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 736 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 741 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 742 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 753 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 754 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 758 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3105 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 789 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide)
															#line 3189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 790 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 3193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 793 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 794 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cleanupRecoveryActorCollection(db->recoveryData);
															#line 794 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 3;
															#line 794 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 6, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 759 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = recoveryCore;
															#line 758 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 760 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = traceAfter(waitFailureClient( iMaster.waitFailure, db->masterRegistrationCount ? SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME : (now() - recoveryStart) * SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY, db->masterRegistrationCount ? -SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY : SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY), "CCWDBMasterFailed") || traceAfter(db->forceMasterFailure.onTrigger(), "CCWDBForceMasterFailureTriggered");
															#line 3228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 773 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = db->serverInfo->onChange();
															#line 3232 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_4 = db->serverInfo->get().clusterInterface.notifyBackupWorkerDone.getFuture();
															#line 3236 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<BackupWorkerDoneRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<BackupWorkerDoneRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 783 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = collection;
															#line 3241 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when5(__when_expr_5.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 2;
															#line 759 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 1, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 760 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 2, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 773 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 3, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 783 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 5, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3254 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest const& req,int loopDepth) 
	{
															#line 776 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 3318 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 777 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 3322 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 779 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 780 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 781 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 3330 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest && req,int loopDepth) 
	{
															#line 776 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 3339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 777 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 3343 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 779 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 780 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 781 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 3351 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void const& _,int loopDepth) 
	{
															#line 784 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 3360 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void && _,int loopDepth) 
	{
															#line 784 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 3368 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 1, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 2, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 3, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3675 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3680 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3693 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3698 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 799 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 3784 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 799 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 3795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 808 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_9 = cleanupRecoveryActorCollection(db->recoveryData);
															#line 808 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3896 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 6;
															#line 808 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 9, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 3901 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 809 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 810 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 3999 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 811 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 4003 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 814 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 4007 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 815 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 4011 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 819 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 820 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 821 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 822 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 823 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 829 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 4029 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 830 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 831 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 4035 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 834 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 4039 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 835 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 4043 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 837 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 838 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 4051 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4057 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 4062 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 809 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 810 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 4073 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 811 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 4077 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 814 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 4081 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 815 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 4085 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 819 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 820 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 821 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 822 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 823 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 829 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 4103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 830 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 831 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 4109 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 834 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 4113 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 835 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 4117 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 837 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 838 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 4125 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4131 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 4136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 691 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface iMaster;
															#line 692 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 693 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> recoveryCore;
															#line 701 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double recoveryStart;
															#line 702 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface newMaster;
															#line 703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> collection;
															#line 736 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> spinDelay;
															#line 802 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Error err;
															#line 4325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterWatchDatabase()
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterWatchDatabaseActor, 0, Void >, public ActorCallback< ClusterWatchDatabaseActor, 1, Void >, public ActorCallback< ClusterWatchDatabaseActor, 2, Void >, public ActorCallback< ClusterWatchDatabaseActor, 3, Void >, public ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >, public ActorCallback< ClusterWatchDatabaseActor, 5, Void >, public ActorCallback< ClusterWatchDatabaseActor, 6, Void >, public ActorCallback< ClusterWatchDatabaseActor, 7, Void >, public ActorCallback< ClusterWatchDatabaseActor, 8, Void >, public ActorCallback< ClusterWatchDatabaseActor, 9, Void >, public ActorCallback< ClusterWatchDatabaseActor, 10, Void >, public FastAllocated<ClusterWatchDatabaseActor>, public ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor> {
															#line 4330 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterWatchDatabaseActor>::operator new;
	using FastAllocated<ClusterWatchDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17547320609306523648UL, 439424348028520192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterWatchDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 1, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 2, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 3, Void >;
friend struct ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 5, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 6, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 7, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 8, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 9, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 10, Void >;
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 4357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor>(cluster, db, coordinators),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15084720662247522304UL, 7134482422509323520UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterWatchDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 6, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 7, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 8, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 9, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterWatchDatabase( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, ServerCoordinators const& coordinators ) {
															#line 688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterWatchDatabaseActor(cluster, db, coordinators));
															#line 4396 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 844 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 4401 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterGetServerInfo()
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterGetServerInfoActor>
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActorState {
															#line 4408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActorState(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   knownServerInfoID(knownServerInfoID),
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   reply(reply)
															#line 4419 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	~ClusterGetServerInfoActorState() 
	{
		fdb_probe_actor_destroy("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 848 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 4434 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 856 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		reply.send(db->serverInfo->get());
															#line 857 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterGetServerInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterGetServerInfoActorState(); static_cast<ClusterGetServerInfoActor*>(this)->destroy(); return 0; }
															#line 4459 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<ClusterGetServerInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 848 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->serverInfo->get().id == knownServerInfoID))
															#line 4478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 850 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yieldedFuture(db->serverInfo->onChange());
															#line 849 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 851 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(300);
															#line 4490 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 1;
															#line 850 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 0, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 851 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 1, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 4497 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 0, Void >::remove();
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID knownServerInfoID;
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReplyPromise<ServerDBInfo> reply;
															#line 4672 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterGetServerInfo()
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActor final : public Actor<Void>, public ActorCallback< ClusterGetServerInfoActor, 0, Void >, public ActorCallback< ClusterGetServerInfoActor, 1, Void >, public FastAllocated<ClusterGetServerInfoActor>, public ClusterGetServerInfoActorState<ClusterGetServerInfoActor> {
															#line 4677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterGetServerInfoActor>::operator new;
	using FastAllocated<ClusterGetServerInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5920403104455725568UL, 12289686408255726848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterGetServerInfoActor, 0, Void >;
friend struct ActorCallback< ClusterGetServerInfoActor, 1, Void >;
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActor(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 4695 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterGetServerInfoActorState<ClusterGetServerInfoActor>(db, knownServerInfoID, reply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8722247202050210304UL, 18223546808676413184UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterGetServerInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterGetServerInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterGetServerInfo( ClusterControllerData::DBInfo* const& db, UID const& knownServerInfoID, ReplyPromise<ServerDBInfo> const& reply ) {
															#line 845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterGetServerInfoActor(db, knownServerInfoID, reply));
															#line 4728 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 859 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 4733 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clusterOpenDatabase()
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterOpenDatabaseActor>
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActorState {
															#line 4740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActorState(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 4749 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterOpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 861 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->clientStatus[req.reply.getEndpoint().getPrimaryAddress()] = std::make_pair(now(), req);
															#line 862 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (db->clientStatus.size() > 10000)
															#line 4766 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 863 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyClientStatusEntries").suppressFor(1.0);
															#line 4770 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 866 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 4774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 875 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(db->clientInfo->get());
															#line 876 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterOpenDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterOpenDatabaseActorState(); static_cast<ClusterOpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 4799 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<ClusterOpenDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 866 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->clientInfo->get().id == req.knownClientInfoID))
															#line 4818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 868 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->clientInfo->onChange();
															#line 867 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 869 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL);
															#line 4830 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 868 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 0, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 869 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 1, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 4837 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 0, Void >::remove();
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	OpenDatabaseRequest req;
															#line 5010 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterOpenDatabase()
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterOpenDatabaseActor, 0, Void >, public ActorCallback< ClusterOpenDatabaseActor, 1, Void >, public FastAllocated<ClusterOpenDatabaseActor>, public ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor> {
															#line 5015 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterOpenDatabaseActor>::operator new;
	using FastAllocated<ClusterOpenDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16629327498966774016UL, 9891775183400231424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterOpenDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterOpenDatabaseActor, 1, Void >;
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActor(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 5033 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor>(db, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4479359797486159872UL, 7876825679301567232UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterOpenDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterOpenDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterOpenDatabase( ClusterControllerData::DBInfo* const& db, OpenDatabaseRequest const& req ) {
															#line 860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterOpenDatabaseActor(db, req));
															#line 5066 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 878 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRecruitmentRequests.size(); i++) {
		Reference<RecruitWorkersInfo> info = self->outstandingRecruitmentRequests[i];
		try {
			info->rep = self->findWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingRemoteRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRemoteRecruitmentRequests.size(); i++) {
		Reference<RecruitRemoteWorkersInfo> info = self->outstandingRemoteRecruitmentRequests[i];
		try {
			info->rep = self->findRemoteWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRemoteRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRemoteRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitRemoteTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitRemoteTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingStorageRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingStorageRequests.size(); i++) {
		auto& req = self->outstandingStorageRequests[i];
		try {
			if (req.second < now()) {
				req.first.reply.sendError(timed_out());
				swapAndPop(&self->outstandingStorageRequests, i--);
			} else {
				if (!self->gotProcessClasses && !req.first.criticalRecruitment)
					throw no_more_servers();

				auto worker = self->getStorageWorker(req.first);
				RecruitStorageReply rep;
				rep.worker = worker.interf;
				rep.processClass = worker.processClass;
				req.first.reply.send(rep);
				swapAndPop(&self->outstandingStorageRequests, i--);
			}
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers) {
				TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
				    .errorUnsuppressed(e)
				    .suppressFor(1.0)
				    .detail("OutstandingReq", i)
				    .detail("IsCriticalRecruitment", req.first.criticalRecruitment);
			} else {
				TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
				throw;
			}
		}
	}
}

// Finds and returns a new process for role
WorkerDetails findNewProcessForSingleton(ClusterControllerData* self,
                                         const ProcessClass::ClusterRole role,
                                         std::map<Optional<Standalone<StringRef>>, int>& id_used) {
	// find new process in cluster for role
	WorkerDetails newWorker =
	    self->getWorkerForRoleInDatacenter(
	            self->clusterControllerDcId, role, ProcessClass::NeverAssign, self->db.config, id_used, {}, true)
	        .worker;

	// check if master's process is actually better suited for role
	if (self->onMasterIsBetter(newWorker, role)) {
		newWorker = self->id_worker[self->masterProcessId.get()].details;
	}

	// acknowledge that the pid is now potentially used by this role as well
	id_used[newWorker.interf.locality.processId()]++;

	return newWorker;
}

// Return best possible fitness for singleton. Note that lower fitness is better.
ProcessClass::Fitness findBestFitnessForSingleton(const ClusterControllerData* self,
                                                  const WorkerDetails& worker,
                                                  const ProcessClass::ClusterRole& role) {
	auto bestFitness = worker.processClass.machineClassFitness(role);
	// If the process has been marked as excluded, we take the max with ExcludeFit to ensure its fit
	// is at least as bad as ExcludeFit. This assists with successfully offboarding such processes
	// and removing them from the cluster.
	if (self->db.config.isExcludedServer(worker.interf.addresses(), worker.interf.locality)) {
		bestFitness = std::max(bestFitness, ProcessClass::ExcludeFit);
	}
	return bestFitness;
}

// Returns true iff the singleton is healthy. "Healthy" here means that
// the singleton is stable (see below) and doesn't need to be rerecruited.
// Side effects: (possibly) initiates recruitment
template <class SingletonClass>
bool isHealthySingleton(ClusterControllerData* self,
                        const WorkerDetails& newWorker,
                        const SingletonClass& singleton,
                        const ProcessClass::Fitness& bestFitness,
                        const Optional<UID> recruitingID) {
	// A singleton is stable if it exists in cluster, has not been killed off of proc and is not being recruited
	bool isStableSingleton = singleton.isPresent() &&
	                         self->id_worker.contains(singleton.getInterface().locality.processId()) &&
	                         (!recruitingID.present() || (recruitingID.get() == singleton.getInterface().id()));

	if (!isStableSingleton) {
		return false; // not healthy because unstable
	}

	auto& currWorker = self->id_worker[singleton.getInterface().locality.processId()];
	auto currFitness = currWorker.details.processClass.machineClassFitness(singleton.getClusterRole());
	if (currWorker.priorityInfo.isExcluded) {
		currFitness = ProcessClass::ExcludeFit;
	}
	// If any of the following conditions are met, we will switch the singleton's process:
	// - if the current proc is used by some non-master, non-singleton role
	// - if the current fitness is less than optimal (lower fitness is better)
	// - if currently at peak fitness but on same process as master, and the new worker is on different process
	bool shouldRerecruit =
	    self->isUsedNotMaster(currWorker.details.interf.locality.processId()) || bestFitness < currFitness ||
	    (currFitness == bestFitness && currWorker.details.interf.locality.processId() == self->masterProcessId &&
	     newWorker.interf.locality.processId() != self->masterProcessId);
	if (g_network->isSimulated() && singleton.getRole() == Role::DATA_DISTRIBUTOR &&
	    SERVER_KNOBS->CC_ENFORCE_USE_UNFIT_DD_IN_SIM) {
		// It is possible that DD location is not optimal in the simulation.
		// This can cause the simulation stuck if it always halts DD.
		// TODO(BulkLoad): this is a work around. We should figure out why DD can be repeatedly
		// terminated by CC throughout the simulation.
		shouldRerecruit = false;
	}
	if (shouldRerecruit) {
		std::string roleAbbr = singleton.getRole().abbreviation;
		TraceEvent(("CCHalt" + roleAbbr).c_str(), self->id)
		    .detail(roleAbbr + "ID", singleton.getInterface().id())
		    .detail("Excluded", currWorker.priorityInfo.isExcluded)
		    .detail("Fitness", currFitness)
		    .detail("BestFitness", bestFitness)
		    .detail("MasterProcessId", self->masterProcessId)
		    .detail("CurrentWorkerProcessId", currWorker.details.interf.locality.processId())
		    .detail("NewWorkerProcessId", newWorker.interf.locality.processId())
		    .detail("IsUsedNotMaster", self->isUsedNotMaster(currWorker.details.interf.locality.processId()));
		singleton.recruit(*self); // SIDE EFFECT: initiating recruitment
		return false; // not healthy since needed to be rerecruited
	} else {
		return true; // healthy because doesn't need to be rerecruited
	}
}

// Returns a mapping from pid->pidCount for pids
std::map<Optional<Standalone<StringRef>>, int> getColocCounts(
    const std::vector<Optional<Standalone<StringRef>>>& pids) {
	std::map<Optional<Standalone<StringRef>>, int> counts;
	for (const auto& pid : pids) {
		if (pid.present()) {
			++counts[pid];
		}
	}
	return counts;
}

// Checks if there exists a better process for each singleton (e.g. DD) compared
// to the process it is currently on.
// When adding new singletons, just follow the ratekeeper/data distributor examples.
void checkBetterSingletons(ClusterControllerData* self) {
	if (!self->masterProcessId.present() ||
	    self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS) {
		return;
	}

	// note: this map doesn't consider pids used by existing singletons
	std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();

	// We prefer spreading out other roles more than separating singletons on their own process
	// so we artificially amplify the pid count for the processes used by non-singleton roles.
	// In other words, we make the processes used for other roles less desirable to be used
	// by singletons as well.
	for (auto& it : id_used) {
		it.second *= PID_USED_AMP_FOR_NON_SINGLETON;
	}

	// Try to find a new process for each singleton.
	WorkerDetails newRKWorker = findNewProcessForSingleton(self, ProcessClass::Ratekeeper, id_used);
	WorkerDetails newDDWorker = findNewProcessForSingleton(self, ProcessClass::DataDistributor, id_used);
	WorkerDetails newCSWorker = findNewProcessForSingleton(self, ProcessClass::ConsistencyScan, id_used);

	WorkerDetails newEKPWorker;
	EncryptionAtRestMode encryptMode = self->db.config.encryptionAtRestMode;
	const bool enableKmsCommunication =
	    encryptMode.isEncryptionEnabled() || SERVER_KNOBS->ENABLE_REST_KMS_COMMUNICATION;
	if (enableKmsCommunication) {
		newEKPWorker = findNewProcessForSingleton(self, ProcessClass::EncryptKeyProxy, id_used);
	}

	// Find best possible fitnesses for each singleton.
	auto bestFitnessForRK = findBestFitnessForSingleton(self, newRKWorker, ProcessClass::Ratekeeper);
	auto bestFitnessForDD = findBestFitnessForSingleton(self, newDDWorker, ProcessClass::DataDistributor);
	auto bestFitnessForCS = findBestFitnessForSingleton(self, newCSWorker, ProcessClass::ConsistencyScan);

	ProcessClass::Fitness bestFitnessForEKP;
	if (enableKmsCommunication) {
		bestFitnessForEKP = findBestFitnessForSingleton(self, newEKPWorker, ProcessClass::EncryptKeyProxy);
	}

	auto& db = self->db.serverInfo->get();
	auto rkSingleton = RatekeeperSingleton(db.ratekeeper);
	auto ddSingleton = DataDistributorSingleton(db.distributor);
	ConsistencyScanSingleton csSingleton(db.consistencyScan);
	EncryptKeyProxySingleton ekpSingleton(db.client.encryptKeyProxy);

	// Check if the singletons are healthy.
	// side effect: try to rerecruit the singletons to more optimal processes
	bool rkHealthy = isHealthySingleton<RatekeeperSingleton>(
	    self, newRKWorker, rkSingleton, bestFitnessForRK, self->recruitingRatekeeperID);

	bool ddHealthy = isHealthySingleton<DataDistributorSingleton>(
	    self, newDDWorker, ddSingleton, bestFitnessForDD, self->recruitingDistributorID);

	bool csHealthy = isHealthySingleton<ConsistencyScanSingleton>(
	    self, newCSWorker, csSingleton, bestFitnessForCS, self->recruitingConsistencyScanID);

	bool ekpHealthy = true;
	if (enableKmsCommunication) {
		ekpHealthy = isHealthySingleton<EncryptKeyProxySingleton>(
		    self, newEKPWorker, ekpSingleton, bestFitnessForEKP, self->recruitingEncryptKeyProxyID);
	}
	// if any of the singletons are unhealthy (rerecruited or not stable), then do not
	// consider any further re-recruitments
	if (!(rkHealthy && ddHealthy && ekpHealthy && csHealthy)) {
		return;
	}

	// if we reach here, we know that the singletons are healthy so let's
	// check if we can colocate the singletons in a more optimal way
	Optional<Standalone<StringRef>> currRKProcessId = rkSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currDDProcessId = ddSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currCSProcessId = csSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> newRKProcessId = newRKWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newDDProcessId = newDDWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newCSProcessId = newCSWorker.interf.locality.processId();

	Optional<Standalone<StringRef>> currEKPProcessId, newEKPProcessId;
	if (enableKmsCommunication) {
		currEKPProcessId = ekpSingleton.getInterface().locality.processId();
		newEKPProcessId = newEKPWorker.interf.locality.processId();
	}

	std::vector<Optional<Standalone<StringRef>>> currPids = { currRKProcessId, currDDProcessId, currCSProcessId };
	std::vector<Optional<Standalone<StringRef>>> newPids = { newRKProcessId, newDDProcessId, newCSProcessId };
	if (enableKmsCommunication) {
		currPids.emplace_back(currEKPProcessId);
		newPids.emplace_back(newEKPProcessId);
	}

	auto currColocMap = getColocCounts(currPids);
	auto newColocMap = getColocCounts(newPids);

	// if the knob is disabled, the EKP coloc counts should have no affect on the coloc counts check below
	if (!enableKmsCommunication) {
		ASSERT(currColocMap[currEKPProcessId] == 0);
		ASSERT(newColocMap[newEKPProcessId] == 0);
	}

	// if the new coloc counts are collectively better (i.e. each singleton's coloc count has not increased)
	if (newColocMap[newRKProcessId] <= currColocMap[currRKProcessId] &&
	    newColocMap[newDDProcessId] <= currColocMap[currDDProcessId] &&
	    newColocMap[newEKPProcessId] <= currColocMap[currEKPProcessId] &&
	    newColocMap[newCSProcessId] <= currColocMap[currCSProcessId]) {
		// rerecruit the singleton for which we have found a better process, if any
		if (newColocMap[newRKProcessId] < currColocMap[currRKProcessId]) {
			rkSingleton.recruit(*self);
		} else if (newColocMap[newDDProcessId] < currColocMap[currDDProcessId]) {
			ddSingleton.recruit(*self);
		} else if (enableKmsCommunication && newColocMap[newEKPProcessId] < currColocMap[currEKPProcessId]) {
			ekpSingleton.recruit(*self);
		} else if (newColocMap[newCSProcessId] < currColocMap[currCSProcessId]) {
			csSingleton.recruit(*self);
		}
	}
}

															#line 5372 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRequestsActor>
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActorState {
															#line 5379 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActorState(ClusterControllerData* const& self) 
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 5386 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 1182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5404 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 1;
															#line 1182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 5409 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1208 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRequestsActorState(); static_cast<DoCheckOutstandingRequestsActor*>(this)->destroy(); return 0; }
															#line 5438 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1204 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 5451 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1205 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 5455 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5471 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 5480 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRecruitmentRequests(self);
															#line 1194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingStorageRequests(self);
															#line 1196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkBetterSingletons(self);
															#line 1198 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->checkRecoveryStalled();
															#line 1199 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->betterMasterExists())
															#line 5572 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1200 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.forceMasterFailure.trigger();
															#line 1201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("MasterRegistrationKill", self->id).detail("MasterId", self->db.serverInfo->get().master.id());
															#line 5578 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY || !self->goodRecruitmentTime.isReady()))
															#line 5595 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY)
															#line 5601 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1186 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY + 0.001 - (now() - self->lastRecruitTime));
															#line 1186 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5607 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 2;
															#line 1186 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 5612 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 1188 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->goodRecruitmentTime.isReady())
															#line 5639 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->goodRecruitmentTime;
															#line 1189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5645 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 3;
															#line 1189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 5650 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 5855 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >, public FastAllocated<DoCheckOutstandingRequestsActor>, public DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor> {
															#line 5860 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7885636558478132736UL, 14184941518428636416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >;
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActor(ClusterControllerData* const& self) 
															#line 5879 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18376869144156441344UL, 10196932547024268032UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRequests( ClusterControllerData* const& self ) {
															#line 1180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRequestsActor(self));
															#line 5914 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1210 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 5919 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRemoteRequestsActor>
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActorState {
															#line 5926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActorState(ClusterControllerData* const& self) 
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 5933 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRemoteRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1213 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 1213 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5951 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 1;
															#line 1213 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 5956 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRemoteRequestsActorState(); static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->destroy(); return 0; }
															#line 5985 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1220 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 5998 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1221 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 6002 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1214 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6018 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1214 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6027 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1218 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRemoteRecruitmentRequests(self);
															#line 6111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1214 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->goodRemoteRecruitmentTime.isReady()))
															#line 6127 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->goodRemoteRecruitmentTime;
															#line 1215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 2;
															#line 1215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 6140 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 6260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >, public FastAllocated<DoCheckOutstandingRemoteRequestsActor>, public DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor> {
															#line 6265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15336666197440474368UL, 3211707072264672512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >;
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActor(ClusterControllerData* const& self) 
															#line 6283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11202796549843407360UL, 6198894268515362560UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRemoteRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRemoteRequests( ClusterControllerData* const& self ) {
															#line 1211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRemoteRequestsActor(self));
															#line 6317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRequests(ClusterControllerData* self) {
	if (self->outstandingRemoteRequestChecker.isReady()) {
		self->outstandingRemoteRequestChecker = doCheckOutstandingRemoteRequests(self);
	}

	if (self->outstandingRequestChecker.isReady()) {
		self->outstandingRequestChecker = doCheckOutstandingRequests(self);
	}
}

															#line 6332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via rebootAndCheck()
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RebootAndCheckActor>
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActorState {
															#line 6339 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActorState(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   processID(processID)
															#line 6348 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	~RebootAndCheckActorState() 
	{
		fdb_probe_actor_destroy("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 1239 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(processID.present());
															#line 1240 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto watcher = cluster->id_worker.find(processID);
															#line 1241 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(watcher != cluster->id_worker.end());
															#line 1243 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots++;
															#line 1244 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(g_network->isSimulated() ? SERVER_KNOBS->SIM_SHUTDOWN_TIMEOUT : SERVER_KNOBS->SHUTDOWN_TIMEOUT);
															#line 1244 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6374 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 1;
															#line 1244 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RebootAndCheckActor, 0, Void >*>(static_cast<RebootAndCheckActor*>(this)));
															#line 6379 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 1248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto watcher = cluster->id_worker.find(processID);
															#line 1249 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (watcher != cluster->id_worker.end())
															#line 6406 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots--;
															#line 1251 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (watcher->second.reboots < 2)
															#line 6412 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					checkOutstandingRequests(cluster);
															#line 6416 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RebootAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RebootAndCheckActorState(); static_cast<RebootAndCheckActor*>(this)->destroy(); return 0; }
															#line 6422 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RebootAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state > 0) static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RebootAndCheckActor*>(this)->ActorCallback< RebootAndCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RebootAndCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Standalone<StringRef>> processID;
															#line 6521 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via rebootAndCheck()
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActor final : public Actor<Void>, public ActorCallback< RebootAndCheckActor, 0, Void >, public FastAllocated<RebootAndCheckActor>, public RebootAndCheckActorState<RebootAndCheckActor> {
															#line 6526 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RebootAndCheckActor>::operator new;
	using FastAllocated<RebootAndCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(670515479195480320UL, 14827440446910312192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RebootAndCheckActor, 0, Void >;
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActor(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 6543 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RebootAndCheckActorState<RebootAndCheckActor>(cluster, processID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17703883454640654592UL, 13640791943228081920UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rebootAndCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RebootAndCheckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> rebootAndCheck( ClusterControllerData* const& cluster, Optional<Standalone<StringRef>> const& processID ) {
															#line 1237 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RebootAndCheckActor(cluster, processID));
															#line 6576 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 6581 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via workerAvailabilityWatch()
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class WorkerAvailabilityWatchActor>
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActorState {
															#line 6588 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActorState(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : worker(worker),
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   startingClass(startingClass),
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cluster(cluster),
															#line 1262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failed((worker.address() == g_network->getLocalAddress()) ? Never() : waitFailureClient(worker.waitFailure, SERVER_KNOBS->WORKER_FAILURE_TIME))
															#line 6601 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	~WorkerAvailabilityWatchActorState() 
	{
		fdb_probe_actor_destroy("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateWorkerList.set( worker.locality.processId(), ProcessData(worker.locality, startingClass, worker.stableAddress(), worker.grpcAddress()));
															#line 1270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 1270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6620 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 1;
															#line 1270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 6625 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1272 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6648 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1272 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6657 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1274 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = IFailureMonitor::failureMonitor().onStateEqual( worker.storage.getEndpoint(), FailureStatus( IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable()));
															#line 1273 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6750 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = failed;
															#line 6754 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 2;
															#line 1274 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 1283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 6761 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 6776 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 1280 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 6782 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 6792 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 1280 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 6798 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1284 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 1286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 6810 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 6814 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 6818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1291 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 6822 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1293 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 1297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 1298 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 1301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 6832 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 1303 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 6838 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1304 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 6842 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 1308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 6849 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1284 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 1286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 6863 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 6867 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 6871 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1291 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 6875 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1293 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 1297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 1298 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 1301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 6885 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 1303 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 6891 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1304 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 6895 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 1308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 6902 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 1, Void >::remove();
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerInterface worker;
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ProcessClass startingClass;
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 1262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> failed;
															#line 7039 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workerAvailabilityWatch()
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActor final : public Actor<Void>, public ActorCallback< WorkerAvailabilityWatchActor, 0, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 1, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 2, Void >, public FastAllocated<WorkerAvailabilityWatchActor>, public WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor> {
															#line 7044 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkerAvailabilityWatchActor>::operator new;
	using FastAllocated<WorkerAvailabilityWatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(721714750822414592UL, 16149980233531296256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerAvailabilityWatchActor, 0, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 1, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 2, Void >;
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActor(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 7063 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor>(worker, startingClass, cluster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10692884594389689856UL, 3271400941493304320UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerAvailabilityWatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> workerAvailabilityWatch( WorkerInterface const& worker, ProcessClass const& startingClass, ClusterControllerData* const& cluster ) {
															#line 1259 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new WorkerAvailabilityWatchActor(worker, startingClass, cluster));
															#line 7097 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1313 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

struct FailureStatusInfo {
	FailureStatus status;
	double lastRequestTime;
	double penultimateRequestTime;

	FailureStatusInfo() : lastRequestTime(0), penultimateRequestTime(0) {}

	void insertRequest(double now) {
		penultimateRequestTime = lastRequestTime;
		lastRequestTime = now;
	}

	double latency(double now) const {
		return std::max(now - lastRequestTime, lastRequestTime - penultimateRequestTime);
	}
};

															#line 7119 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via requireAll()
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RequireAllActor>
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActorState {
															#line 7126 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActorState(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : in(in),
															#line 1332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   out(),
															#line 1333 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   i()
															#line 7137 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("requireAll", reinterpret_cast<unsigned long>(this));

	}
	~RequireAllActorState() 
	{
		fdb_probe_actor_destroy("requireAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			i = 0;
															#line 7152 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1340 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RequireAllActor*>(this)->SAV<std::vector<TLogInterface>>::futures) { (void)(out); this->~RequireAllActorState(); static_cast<RequireAllActor*>(this)->destroy(); return 0; }
															#line 7175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RequireAllActor*>(this)->SAV< std::vector<TLogInterface> >::value()) std::vector<TLogInterface>(std::move(out)); // state_var_RVO
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(i < in.size()))
															#line 7194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1335 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Optional<std::vector<TLogInterface>>> __when_expr_0 = in[i];
															#line 1335 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<RequireAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7202 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RequireAllActor*>(this)->actor_wait_state = 1;
															#line 1335 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*>(static_cast<RequireAllActor*>(this)));
															#line 7207 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
															#line 1336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 7229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1337 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 7233 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1338 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 1334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 7239 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
															#line 1336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 7248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1337 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 7252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1338 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 1334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 7258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequireAllActor*>(this)->actor_wait_state > 0) static_cast<RequireAllActor*>(this)->actor_wait_state = 0;
		static_cast<RequireAllActor*>(this)->ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> const& value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> && value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Optional<std::vector<TLogInterface>>>> in;
															#line 1332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<TLogInterface> out;
															#line 1333 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int i;
															#line 7344 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via requireAll()
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActor final : public Actor<std::vector<TLogInterface>>, public ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >, public FastAllocated<RequireAllActor>, public RequireAllActorState<RequireAllActor> {
															#line 7349 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RequireAllActor>::operator new;
	using FastAllocated<RequireAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16764518745598759168UL, 7852994762623878400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TLogInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >;
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActor(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 7366 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<std::vector<TLogInterface>>(),
		   RequireAllActorState<RequireAllActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16593527381228025088UL, 9468838150300793600UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("requireAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<std::vector<TLogInterface>> requireAll( std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in ) {
															#line 1331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<std::vector<TLogInterface>>(new RequireAllActor(in));
															#line 7399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

void clusterRecruitStorage(ClusterControllerData* self, RecruitStorageRequest req) {
	try {
		if (!self->gotProcessClasses && !req.criticalRecruitment)
			throw no_more_servers();
		auto worker = self->getStorageWorker(req);
		RecruitStorageReply rep;
		rep.worker = worker.interf;
		rep.processClass = worker.processClass;
		req.reply.send(rep);
	} catch (Error& e) {
		if (e.code() == error_code_no_more_servers) {
			self->outstandingStorageRequests.emplace_back(req, now() + SERVER_KNOBS->RECRUITMENT_TIMEOUT);
			TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
			    .error(e)
			    .detail("IsCriticalRecruitment", req.criticalRecruitment);
		} else {
			TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
			throw; // Any other error will bring down the cluster controller
		}
	}
}

void clusterRegisterMaster(ClusterControllerData* self, RegisterMasterRequest const& req) {
	++self->registerMasterRequests;

	TraceEvent("MasterRegistrationReceived", self->id)
	    .detail("MasterId", req.id)
	    .detail("Master", req.mi.toString())
	    .detail("Tlogs", describe(req.logSystemConfig.tLogs))
	    .detail("Resolvers", req.resolvers.size())
	    .detail("RecoveryState", (int)req.recoveryState)
	    .detail("RegistrationCount", req.registrationCount)
	    .detail("CommitProxies", req.commitProxies.size())
	    .detail("GrvProxies", req.grvProxies.size())
	    .detail("RecoveryCount", req.recoveryCount)
	    .detail("Stalled", req.recoveryStalled)
	    .detail("OldestBackupEpoch", req.logSystemConfig.oldestBackupEpoch);

	// make sure the request comes from an active database
	auto db = &self->db;
	if (db->serverInfo->get().master.id() != req.id || req.registrationCount <= db->masterRegistrationCount) {
		TraceEvent("MasterRegistrationNotFound", self->id)
		    .detail("MasterId", req.id)
		    .detail("ExistingId", db->serverInfo->get().master.id())
		    .detail("RegCount", req.registrationCount)
		    .detail("ExistingRegCount", db->masterRegistrationCount);
		return;
	}

	if (req.recoveryState == RecoveryState::FULLY_RECOVERED) {
		self->db.unfinishedRecoveries = 0;
		ASSERT(!req.logSystemConfig.oldTLogs.size());
	}

	db->masterRegistrationCount = req.registrationCount;
	db->recoveryStalled = req.recoveryStalled;
	if (req.configuration.present()) {
		db->config = req.configuration.get();

		if (req.recoveryState >= RecoveryState::ACCEPTING_COMMITS) {
			self->gotFullyRecoveredConfig = true;
			db->fullyRecoveredConfig = req.configuration.get();
			for (auto& it : self->id_worker) {
				bool isExcludedFromConfig = db->fullyRecoveredConfig.isExcludedServer(
				    it.second.details.interf.addresses(), it.second.details.interf.locality);
				if (it.second.priorityInfo.isExcluded != isExcludedFromConfig) {
					it.second.priorityInfo.isExcluded = isExcludedFromConfig;
					if (!it.second.reply.isSet()) {
						it.second.reply.send(
						    RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
					}
				}
			}
		}
	}

	bool isChanged = false;
	auto dbInfo = self->db.serverInfo->get();

	if (dbInfo.recoveryState != req.recoveryState) {
		dbInfo.recoveryState = req.recoveryState;
		isChanged = true;
	}

	if (dbInfo.priorCommittedLogServers != req.priorCommittedLogServers) {
		dbInfo.priorCommittedLogServers = req.priorCommittedLogServers;
		isChanged = true;
	}

	// Construct the client information
	if (db->clientInfo->get().commitProxies != req.commitProxies ||
	    db->clientInfo->get().grvProxies != req.grvProxies ||
	    db->clientInfo->get().clusterId != db->serverInfo->get().client.clusterId ||
	    db->clientInfo->get().clusterType != db->clusterType) {
		TraceEvent("PublishNewClientInfo", self->id)
		    .detail("Master", dbInfo.master.id())
		    .detail("GrvProxies", db->clientInfo->get().grvProxies)
		    .detail("ReqGrvProxies", req.grvProxies)
		    .detail("CommitProxies", db->clientInfo->get().commitProxies)
		    .detail("GlobalConfigHistorySize", db->clientInfo->get().history.size())
		    .detail("ReqCPs", req.commitProxies)
		    .detail("ClusterId", db->serverInfo->get().client.clusterId)
		    .detail("ClientClusterId", db->clientInfo->get().clusterId)
		    .detail("ClusterType", db->clientInfo->get().clusterType)
		    .detail("ReqClusterType", db->clusterType);
		isChanged = true;
		// TODO why construct a new one and not just copy the old one and change proxies + id?
		ClientDBInfo clientInfo;
		clientInfo.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
		clientInfo.id = deterministicRandom()->randomUniqueID();
		clientInfo.commitProxies = req.commitProxies;
		clientInfo.grvProxies = req.grvProxies;
		clientInfo.history = db->clientInfo->get().history;
		clientInfo.clusterId = db->serverInfo->get().client.clusterId;
		clientInfo.clusterType = db->clusterType;
		db->clientInfo->set(clientInfo);
		dbInfo.client = db->clientInfo->get();
	}

	if (!dbInfo.logSystemConfig.isEqual(req.logSystemConfig)) {
		isChanged = true;
		dbInfo.logSystemConfig = req.logSystemConfig;
	}

	if (dbInfo.resolvers != req.resolvers) {
		isChanged = true;
		dbInfo.resolvers = req.resolvers;
	}

	if (dbInfo.recoveryCount != req.recoveryCount) {
		isChanged = true;
		dbInfo.recoveryCount = req.recoveryCount;
	}

	if (isChanged) {
		dbInfo.id = deterministicRandom()->randomUniqueID();
		dbInfo.infoGeneration = ++self->db.dbInfoCount;
		self->db.serverInfo->set(dbInfo);
	}

	checkOutstandingRequests(self);
}

// Halts the registering (i.e. requesting) singleton if one is already in the process of being recruited
// or, halts the existing singleton in favour of the requesting one
template <class SingletonClass>
void haltRegisteringOrCurrentSingleton(ClusterControllerData* self,
                                       const WorkerInterface& worker,
                                       const SingletonClass& currSingleton,
                                       const SingletonClass& registeringSingleton,
                                       const Optional<UID> recruitingID) {
	ASSERT(currSingleton.getRole() == registeringSingleton.getRole());
	const UID registeringID = registeringSingleton.getInterface().id();
	const std::string roleName = currSingleton.getRole().roleName;
	const std::string roleAbbr = currSingleton.getRole().abbreviation;

	// halt the requesting singleton if it isn't the one currently being recruited
	if ((recruitingID.present() && recruitingID.get() != registeringID) ||
	    self->clusterControllerDcId != worker.locality.dcId()) {
		TraceEvent(("CCHaltRegistering" + roleName).c_str(), self->id)
		    .detail(roleAbbr + "ID", registeringID)
		    .detail("DcID", printable(self->clusterControllerDcId))
		    .detail("ReqDcID", printable(worker.locality.dcId()))
		    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
		registeringSingleton.halt(*self, worker.locality.processId());
	} else if (!recruitingID.present()) {
		// if not currently recruiting, then halt previous one in favour of requesting one
		TraceEvent(("CCRegister" + roleName).c_str(), self->id).detail(roleAbbr + "ID", registeringID);
		if (currSingleton.isPresent() && currSingleton.getInterface().id() != registeringID &&
		    self->id_worker.contains(currSingleton.getInterface().locality.processId())) {
			TraceEvent(("CCHaltPrevious" + roleName).c_str(), self->id)
			    .detail(roleAbbr + "ID", currSingleton.getInterface().id())
			    .detail("DcID", printable(self->clusterControllerDcId))
			    .detail("ReqDcID", printable(worker.locality.dcId()))
			    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
			currSingleton.halt(*self, currSingleton.getInterface().locality.processId());
		}
		// set the curr singleton if it doesn't exist or its different from the requesting one
		if (!currSingleton.isPresent() || currSingleton.getInterface().id() != registeringID) {
			registeringSingleton.setInterfaceToDbInfo(*self);
		}
	}
}

															#line 7588 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via registerWorker()
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RegisterWorkerActor>
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActorState {
															#line 7595 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActorState(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : req(req),
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cs(cs),
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster)
															#line 7608 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerActorState() 
	{
		fdb_probe_actor_destroy("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1531 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<std::vector<NetworkAddress>> __when_expr_0 = cs.tryResolveHostnames();
															#line 1531 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7625 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 1;
															#line 1531 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*>(static_cast<RegisterWorkerActor*>(this)));
															#line 7630 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
															#line 1533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 7655 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1536 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1541 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1542 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 7663 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1545 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1546 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1547 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1548 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1550 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1557 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1558 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 7683 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1560 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1562 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 7689 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1572 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 7697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 7703 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1585 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 7707 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1586 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 7711 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1587 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 7715 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1588 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 7719 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1591 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 7726 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1592 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 7730 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 1596 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 7738 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1597 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 7742 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1598 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 7746 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1601 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 7753 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 7757 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1608 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 7763 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1610 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 7767 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1611 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1613 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 7773 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1615 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 7777 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1617 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 7783 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1619 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 7787 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1622 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 7791 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1623 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 7795 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1627 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 7800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1628 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 7806 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1641 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1643 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 7812 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1644 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 7816 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1649 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1650 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1651 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 7824 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1652 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 7828 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
															#line 1655 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 7833 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1657 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 7837 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1659 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 7841 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1660 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 7845 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1666 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1667 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1668 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 7853 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1669 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 7859 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1670 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 7863 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1671 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 7867 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1673 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1674 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1675 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1676 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1678 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1679 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1680 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1682 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 7887 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1683 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1684 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1689 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 7897 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1691 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 7901 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1692 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1693 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 7907 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1695 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 7911 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1696 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 7915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1702 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 7919 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1704 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 7925 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1710 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 7930 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1711 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1712 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1713 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 7938 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1717 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 7942 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1718 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1719 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1720 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 7950 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1724 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.config.encryptionAtRestMode.isEncryptionEnabled() && req.encryptKeyProxyInterf.present())
															#line 7954 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = EncryptKeyProxySingleton(self->db.serverInfo->get().client.encryptKeyProxy);
															#line 1726 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = EncryptKeyProxySingleton(req.encryptKeyProxyInterf);
															#line 1727 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<EncryptKeyProxySingleton>( self, w, currSingleton, registeringSingleton, self->recruitingEncryptKeyProxyID);
															#line 7962 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1731 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 7966 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1732 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1733 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 7974 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1739 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 7978 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 7982 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1743 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 7986 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
															#line 1533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1534 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 8000 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1536 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1541 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1542 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 8008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1545 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1546 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1547 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1548 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1550 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1557 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1558 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 8028 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1560 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1562 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 8034 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1572 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 8042 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1574 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 8048 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1585 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 8052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1586 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 8056 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1587 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 8060 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1588 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 8064 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1591 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 8071 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1592 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 8075 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
		else
		{
															#line 1596 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 8083 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1597 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 8087 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1598 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 8091 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1601 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 8098 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 8102 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1608 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 8108 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1610 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 8112 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1611 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1613 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 8118 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1615 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 8122 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1617 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 8128 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1619 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 8132 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1622 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 8136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1623 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 8140 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1627 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 8145 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1628 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 8151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1641 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1643 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 8157 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1644 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 8161 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1649 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1650 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1651 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 8169 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1652 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 8173 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
			}
															#line 1655 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 8178 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1657 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 8182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1659 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 8186 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1660 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 8190 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1666 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1667 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1668 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 8198 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1669 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 8204 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1670 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 8208 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1671 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 8212 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1673 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1674 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1675 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1676 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1678 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1679 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1680 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1682 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 8232 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1683 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1684 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1689 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 8242 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1691 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 8246 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1692 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1693 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 8252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1695 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 8256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1696 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 8260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1702 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 8264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1704 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 8270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1710 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 8275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1711 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1712 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1713 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 8283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1717 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 8287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1718 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1719 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1720 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 8295 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1724 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.config.encryptionAtRestMode.isEncryptionEnabled() && req.encryptKeyProxyInterf.present())
															#line 8299 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1725 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = EncryptKeyProxySingleton(self->db.serverInfo->get().client.encryptKeyProxy);
															#line 1726 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = EncryptKeyProxySingleton(req.encryptKeyProxyInterf);
															#line 1727 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<EncryptKeyProxySingleton>( self, w, currSingleton, registeringSingleton, self->recruitingEncryptKeyProxyID);
															#line 8307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1731 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 8311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1732 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1733 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1734 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 8319 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1739 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 8323 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 8327 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1743 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 8331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(coordinatorAddresses, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(coordinatorAddresses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state > 0) static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterWorkerActor*>(this)->ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerRequest req;
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterConnectionString cs;
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster* configBroadcaster;
															#line 8422 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via registerWorker()
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActor final : public Actor<Void>, public ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >, public FastAllocated<RegisterWorkerActor>, public RegisterWorkerActorState<RegisterWorkerActor> {
															#line 8427 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RegisterWorkerActor>::operator new;
	using FastAllocated<RegisterWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8609739878901752576UL, 2630656576261510144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >;
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActor(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 8444 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RegisterWorkerActorState<RegisterWorkerActor>(req, self, cs, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14446594949420451840UL, 3262990831982615808UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> registerWorker( RegisterWorkerRequest const& req, ClusterControllerData* const& self, ClusterConnectionString const& cs, ConfigBroadcaster* const& configBroadcaster ) {
															#line 1527 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RegisterWorkerActor(req, self, cs, configBroadcaster));
															#line 8477 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1745 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

#define TIME_KEEPER_VERSION "1"_sr

															#line 8484 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperSetVersionActor>
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActorState {
															#line 8491 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActorState(ClusterControllerData* const& self) 
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1749 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx))
															#line 8500 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperSetVersionActorState() 
	{
		fdb_probe_actor_destroy("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1750 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 8515 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1763 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TimeKeeperSetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TimeKeeperSetVersionActorState(); static_cast<TimeKeeperSetVersionActor*>(this)->destroy(); return 0; }
															#line 8538 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<TimeKeeperSetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1753 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1754 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1755 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->set(timeKeeperVersionKey, TIME_KEEPER_VERSION);
															#line 1756 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 1756 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8568 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 1;
															#line 1756 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 0, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 8573 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1759 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1759 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8610 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 2;
															#line 1759 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 1, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 8615 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1749 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 8804 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActor final : public Actor<Void>, public ActorCallback< TimeKeeperSetVersionActor, 0, Void >, public ActorCallback< TimeKeeperSetVersionActor, 1, Void >, public FastAllocated<TimeKeeperSetVersionActor>, public TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor> {
															#line 8809 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TimeKeeperSetVersionActor>::operator new;
	using FastAllocated<TimeKeeperSetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2256933658278077440UL, 12084846315769200896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperSetVersionActor, 0, Void >;
friend struct ActorCallback< TimeKeeperSetVersionActor, 1, Void >;
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActor(ClusterControllerData* const& self) 
															#line 8827 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15389618584066260224UL, 624794717111917056UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeperSetVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeperSetVersion( ClusterControllerData* const& self ) {
															#line 1748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperSetVersionActor(self));
															#line 8861 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1765 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// This actor periodically gets read version and writes it to cluster with current timestamp as key. To avoid
// running out of space, it limits the max number of entries and clears old entries on each update. This mapping is
// used from backup and restore to get the version information for a timestamp.
															#line 8869 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via timeKeeper()
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperActor>
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActorState {
															#line 8876 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActorState(ClusterControllerData* const& self) 
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1770 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   versionMap(timeKeeperPrefixRange.begin)
															#line 8885 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperActorState() 
	{
		fdb_probe_actor_destroy("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1772 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperStarted").log();
															#line 1774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeKeeperSetVersion(self);
															#line 1774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8904 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 1;
															#line 1774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 0, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 8909 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperActorState();
		static_cast<TimeKeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1776 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8932 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1776 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1777 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(self->cx);
															#line 1778 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 9034 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1814 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->TIME_KEEPER_DELAY);
															#line 1814 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9045 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 5;
															#line 1814 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 4, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 9050 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1780 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			debugID = deterministicRandom()->randomUniqueID();
															#line 1781 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!g_network->isSimulated())
															#line 9069 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1785 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				tr->debugTransaction(debugID);
															#line 9073 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1787 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1788 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1789 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1791 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(timeKeeperDisableKey);
															#line 1791 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9085 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 2;
															#line 1791 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 1, Optional<Value> >*>(static_cast<TimeKeeperActor*>(this)));
															#line 9090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1810 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1810 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 9127 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 4;
															#line 1810 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 3, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 9132 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> const& disableValue,int loopDepth) 
	{
															#line 1792 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 9147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1796 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1798 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1799 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 9159 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 9163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1802 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1803 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 9169 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1804 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 9173 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 9184 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> && disableValue,int loopDepth) 
	{
															#line 1792 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 9193 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1796 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1797 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1798 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1799 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 9205 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1800 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 9209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1802 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1803 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 9215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1804 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 9219 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9225 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1807 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 9230 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> const& disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(disableValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> && disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(disableValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1770 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedMap<int64_t, Version> versionMap;
															#line 1777 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1780 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID debugID;
															#line 9579 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via timeKeeper()
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActor final : public Actor<Void>, public ActorCallback< TimeKeeperActor, 0, Void >, public ActorCallback< TimeKeeperActor, 1, Optional<Value> >, public ActorCallback< TimeKeeperActor, 2, Void >, public ActorCallback< TimeKeeperActor, 3, Void >, public ActorCallback< TimeKeeperActor, 4, Void >, public FastAllocated<TimeKeeperActor>, public TimeKeeperActorState<TimeKeeperActor> {
															#line 9584 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TimeKeeperActor>::operator new;
	using FastAllocated<TimeKeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4681284277277270016UL, 4904219886006507264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperActor, 0, Void >;
friend struct ActorCallback< TimeKeeperActor, 1, Optional<Value> >;
friend struct ActorCallback< TimeKeeperActor, 2, Void >;
friend struct ActorCallback< TimeKeeperActor, 3, Void >;
friend struct ActorCallback< TimeKeeperActor, 4, Void >;
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActor(ClusterControllerData* const& self) 
															#line 9605 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TimeKeeperActorState<TimeKeeperActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10218480498489324032UL, 15738055826982653184UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TimeKeeperActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TimeKeeperActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TimeKeeperActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeper( ClusterControllerData* const& self ) {
															#line 1769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperActor(self));
															#line 9642 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1817 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 9647 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via statusServer()
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StatusServerActor>
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActorState {
															#line 9654 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActorState(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : requests(requests),
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster),
															#line 1823 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   last_request_time(0.0),
															#line 1826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   requests_batch()
															#line 9671 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("statusServer", reinterpret_cast<unsigned long>(this));

	}
	~StatusServerActorState() 
	{
		fdb_probe_actor_destroy("statusServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1828 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 9686 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusServerActorState();
		static_cast<StatusServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1831 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto __when_expr_0 = requests;
															#line 9717 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<StatusRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<StatusRequest>>::value, "invalid type");
															#line 1831 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9721 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<StatusServerActor*>(this)->actor_wait_state = 1;
															#line 1831 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< StatusServerActor, 0, StatusRequest >*>(static_cast<StatusServerActor*>(this)));
															#line 9726 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1920 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "StatusServerError").error(e);
															#line 1921 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9750 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest const& req,int loopDepth) 
	{
															#line 1832 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1833 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1836 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1839 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9774 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 9779 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest && req,int loopDepth) 
	{
															#line 1832 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1833 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1836 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1839 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9798 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1840 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 9803 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorSingleCallback< StatusServerActor, 0, StatusRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1846 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1847 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1848 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 9891 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1851 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1854 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 9897 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1856 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 9903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1861 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1862 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1864 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1865 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1866 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 9916 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1867 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 9920 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1871 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1872 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1873 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 9929 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1874 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 9933 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1876 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1877 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 9941 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->excludedDegradedServers));
															#line 1881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9948 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 9953 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1846 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1847 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1848 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 9966 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1851 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1854 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 9972 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1856 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 9978 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1861 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1862 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1864 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1865 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1866 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 9991 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1867 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 9995 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1871 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1872 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1873 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 10004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1874 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 10008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1876 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1877 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 10016 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->excludedDegradedServers));
															#line 1881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10023 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 10028 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1895 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError() && result.getError().code() == error_code_actor_cancelled)
															#line 10112 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1896 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(result.getError(), loopDepth);
															#line 10116 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1900 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		last_request_time = now();
															#line 1902 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus = Optional<StatusReply>();
															#line 1903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 10124 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> const& __result,int loopDepth) 
	{
															#line 1881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		result = __result;
															#line 10133 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 1918 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus.reset();
															#line 10212 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1(int loopDepth) 
	{
															#line 1903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!requests_batch.empty()))
															#line 10228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1904 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError())
															#line 10234 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1905 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			requests_batch.back().reply.sendError(result.getError());
															#line 10238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1906 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (requests_batch.back().statusField.empty())
															#line 10244 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 1907 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(result.get());
															#line 10248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1909 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(requests_batch.back().statusField == "fault_tolerance");
															#line 1910 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!faultToleranceRelatedStatus.present())
															#line 10256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1911 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					faultToleranceRelatedStatus = clusterGetFaultToleranceStatus(result.get().statusStr);
															#line 10260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1913 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(faultToleranceRelatedStatus.get());
															#line 10264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 1915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.pop_back();
															#line 1916 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1916 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10273 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 4;
															#line 1916 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 3, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 10278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	FutureStream<StatusRequest> requests;
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster const* configBroadcaster;
															#line 1823 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double last_request_time;
															#line 1826 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StatusRequest> requests_batch;
															#line 1881 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ErrorOr<StatusReply> result;
															#line 1902 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<StatusReply> faultToleranceRelatedStatus;
															#line 10412 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via statusServer()
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActor final : public Actor<Void>, public ActorSingleCallback< StatusServerActor, 0, StatusRequest >, public ActorCallback< StatusServerActor, 1, Void >, public ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >, public ActorCallback< StatusServerActor, 3, Void >, public FastAllocated<StatusServerActor>, public StatusServerActorState<StatusServerActor> {
															#line 10417 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<StatusServerActor>::operator new;
	using FastAllocated<StatusServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4888580527446287360UL, 11265976822331292928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< StatusServerActor, 0, StatusRequest >;
friend struct ActorCallback< StatusServerActor, 1, Void >;
friend struct ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >;
friend struct ActorCallback< StatusServerActor, 3, Void >;
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActor(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 10437 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StatusServerActorState<StatusServerActor>(requests, self, coordinators, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7571137253636277504UL, 14171083556526699776UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< StatusServerActor, 0, StatusRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> statusServer( FutureStream<StatusRequest> const& requests, ClusterControllerData* const& self, ServerCoordinators const& coordinators, ConfigBroadcaster const* const& configBroadcaster ) {
															#line 1818 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StatusServerActor(requests, self, coordinators, configBroadcaster));
															#line 10473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 1925 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 10478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorProcessClasses()
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorProcessClassesActor>
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActorState {
															#line 10485 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActorState(ClusterControllerData* const& self) 
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1928 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   trVer(self->db.db)
															#line 10494 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	~MonitorProcessClassesActorState() 
	{
		fdb_probe_actor_destroy("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1929 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 10509 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorProcessClassesActorState();
		static_cast<MonitorProcessClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1957 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 10532 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1931 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1932 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1934 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = trVer.get(processClassVersionKey);
															#line 1934 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10555 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 1;
															#line 1934 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10560 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1953 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = trVer.onError(e);
															#line 1953 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10597 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 4;
															#line 1953 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 3, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10602 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 1936 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 10617 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1939 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1939 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10625 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1939 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10630 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 1936 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 10639 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1939 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1939 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10647 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1939 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10652 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1940 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1942 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1943 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1945 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1946 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 10746 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10752 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10757 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && processClasses,int loopDepth) 
	{
															#line 1940 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1942 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1943 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1944 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1945 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1946 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 10776 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 1949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10782 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1949 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 10787 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1950 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 10871 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1950 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 10880 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1958 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(self->db.db);
															#line 1960 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 11060 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1962 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1963 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1964 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_4 = tr.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1964 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11089 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 5;
															#line 1964 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 11094 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 2008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11131 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 8;
															#line 2008 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 7, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 11136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1965 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1967 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 11153 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1968 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1969 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1970 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1971 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1972 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 11165 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1975 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1976 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1977 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1979 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 11175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1982 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 11179 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1984 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 11185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1987 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 11189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1988 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1989 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1991 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 11197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 1992 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 11201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1998 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1999 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 2000 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 11211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2003 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 2004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 2004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11219 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 2004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 11224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult && processClasses,int loopDepth) 
	{
															#line 1965 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1967 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 11235 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 1968 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1969 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1970 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1971 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1972 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 11247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 1975 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1976 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1977 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1979 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 11257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1982 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 11261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1984 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 11267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
															#line 1987 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 11271 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 1988 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1989 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1991 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 11279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 1992 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 11283 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1998 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1999 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 2000 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 11293 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2003 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 2004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 2004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 2004 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 11306 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2005 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 2005 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11392 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 2005 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 11397 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2005 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 2005 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 2005 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 11413 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1928 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction trVer;
															#line 1958 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2003 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 11675 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorProcessClasses()
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActor final : public Actor<Void>, public ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >, public ActorCallback< MonitorProcessClassesActor, 1, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 2, Void >, public ActorCallback< MonitorProcessClassesActor, 3, Void >, public ActorCallback< MonitorProcessClassesActor, 4, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 5, Void >, public ActorCallback< MonitorProcessClassesActor, 6, Void >, public ActorCallback< MonitorProcessClassesActor, 7, Void >, public FastAllocated<MonitorProcessClassesActor>, public MonitorProcessClassesActorState<MonitorProcessClassesActor> {
															#line 11680 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorProcessClassesActor>::operator new;
	using FastAllocated<MonitorProcessClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6356345612741875712UL, 13262347567460816896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorProcessClassesActor, 1, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 2, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 3, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 4, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 5, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 6, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 7, Void >;
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActor(ClusterControllerData* const& self) 
															#line 11704 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorProcessClassesActorState<MonitorProcessClassesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11588372557279712768UL, 7971599830169234176UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorProcessClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorProcessClasses( ClusterControllerData* const& self ) {
															#line 1926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorProcessClassesActor(self));
															#line 11744 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2013 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 11749 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorServerInfoConfig()
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorServerInfoConfigActor>
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActorState {
															#line 11756 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 11763 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorServerInfoConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2015 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 11778 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorServerInfoConfigActorState();
		static_cast<MonitorServerInfoConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2016 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 2017 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 11810 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 2019 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2020 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2021 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 2023 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(latencyBandConfigKey);
															#line 2023 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11841 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 1;
															#line 2023 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11846 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2045 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 2045 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11883 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 4;
															#line 2045 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 3, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11888 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& configVal,int loopDepth) 
	{
															#line 2024 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 2025 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 11905 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2026 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 11909 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2029 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 2030 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 11915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2031 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 2032 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 2033 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 2034 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 2035 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 11927 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2038 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 2040 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 2040 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11935 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 2040 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11940 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && configVal,int loopDepth) 
	{
															#line 2024 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 2025 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 11951 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2026 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 11955 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2029 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 2030 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 11961 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2031 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 2032 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 2033 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 2034 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 2035 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 11973 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2038 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 2040 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 2040 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11981 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 2040 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 11986 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(configVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(configVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 2041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12072 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 2041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 12077 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 2041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12088 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 2041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 12093 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 2016 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2038 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> configChangeFuture;
															#line 12353 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorServerInfoConfig()
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActor final : public Actor<Void>, public ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorServerInfoConfigActor, 1, Void >, public ActorCallback< MonitorServerInfoConfigActor, 2, Void >, public ActorCallback< MonitorServerInfoConfigActor, 3, Void >, public FastAllocated<MonitorServerInfoConfigActor>, public MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor> {
															#line 12358 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorServerInfoConfigActor>::operator new;
	using FastAllocated<MonitorServerInfoConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2762985673686013696UL, 1630729165167483904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 1, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 2, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 3, Void >;
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 12378 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7361646417378993920UL, 12905750869672403968UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorServerInfoConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorServerInfoConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 2014 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorServerInfoConfigActor(db));
															#line 12414 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2050 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors storage metadata changes and updates to storage servers.
															#line 12420 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorStorageMetadata()
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorStorageMetadataActor>
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActorState {
															#line 12427 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActorState(ClusterControllerData* const& self) 
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2053 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 2055 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx)),
															#line 2056 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   servers()
															#line 12440 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	~MonitorStorageMetadataActorState() 
	{
		fdb_probe_actor_destroy("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2057 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 12455 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorStorageMetadataActorState();
		static_cast<MonitorStorageMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2059 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.clear();
															#line 2060 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 2061 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2062 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2063 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2063 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12496 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 1;
															#line 2063 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 12501 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2093 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 2093 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12525 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 5;
															#line 2093 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 4, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 12530 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2064 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 2066 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		servers.reserve(serverList.size());
															#line 2067 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto ss : serverList ) {
															#line 2068 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.push_back(StorageServerMetaInfo(decodeServerListValue(ss.value)));
															#line 12551 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2071 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(serverMetadataKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2071 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12557 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 2;
															#line 2071 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 12562 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __serverList,int loopDepth) 
	{
															#line 2063 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverList = __serverList;
															#line 12571 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __serverList,int loopDepth) 
	{
		serverList = std::move(__serverList);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2072 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverMetadata.more && serverMetadata.size() < CLIENT_KNOBS->TOO_MANY);
															#line 2073 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<UID, StorageMetadataType> idMetadata;
															#line 2074 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& sm : serverMetadata ) {
															#line 2075 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			const UID id = decodeServerMetadataKey(sm.key);
															#line 2076 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			idMetadata[id] = decodeServerMetadataValue(sm.value);
															#line 12658 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2078 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& s : servers ) {
															#line 2079 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (idMetadata.contains(s.id()))
															#line 12664 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2080 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				s.metadata = idMetadata[s.id()];
															#line 12668 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2082 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "StorageServerMetadataMissing", self->id).detail("ServerID", s.id());
															#line 12674 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 2086 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr->watch(serverMetadataChangeKey);
															#line 2087 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 2087 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12683 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 3;
															#line 2087 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 2, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 12688 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __serverMetadata,int loopDepth) 
	{
															#line 2071 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverMetadata = __serverMetadata;
															#line 12697 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __serverMetadata,int loopDepth) 
	{
		serverMetadata = std::move(__serverMetadata);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 2089 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 2090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 2090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12780 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 2090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 12785 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 2089 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 2090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 2090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12798 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 2090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 12803 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 2091 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 12887 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 2091 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 12896 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2053 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedObjectMap<UID, StorageMetadataType, decltype(IncludeVersion())> metadataMap;
															#line 2055 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2056 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StorageServerMetaInfo> servers;
															#line 2063 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverList;
															#line 2071 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverMetadata;
															#line 2086 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 13090 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorStorageMetadata()
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActor final : public Actor<Void>, public ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 2, Void >, public ActorCallback< MonitorStorageMetadataActor, 3, Void >, public ActorCallback< MonitorStorageMetadataActor, 4, Void >, public FastAllocated<MonitorStorageMetadataActor>, public MonitorStorageMetadataActorState<MonitorStorageMetadataActor> {
															#line 13095 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorStorageMetadataActor>::operator new;
	using FastAllocated<MonitorStorageMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16958124225362314752UL, 16740482330640599808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 2, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 3, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 4, Void >;
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActor(ClusterControllerData* const& self) 
															#line 13116 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorStorageMetadataActorState<MonitorStorageMetadataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8345257820642168576UL, 250769687947896832UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorStorageMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorStorageMetadata( ClusterControllerData* const& self ) {
															#line 2052 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorStorageMetadataActor(self));
															#line 13153 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2097 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors the global configuration version key for changes. When changes are
// made, the global configuration history is read and any updates are sent to
// all processes in the system by updating the ClientDBInfo object. The
// GlobalConfig actor class contains the functionality to read the latest
// history and update the processes local view.
															#line 13163 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorGlobalConfig()
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorGlobalConfigActor>
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActorState {
															#line 13170 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 13177 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorGlobalConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2104 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 13192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorGlobalConfigActorState();
		static_cast<MonitorGlobalConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2105 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 2106 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = ClientDBInfo();
															#line 2107 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 2109 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2110 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(globalConfigVersionKey);
															#line 2111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 1;
															#line 2111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 13260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2186 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 2186 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 5;
															#line 2186 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 4, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 13302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 2113 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (globalConfigVersion.present())
															#line 13317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2117 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(globalConfigHistoryKeys, CLIENT_KNOBS->TOO_MANY);
															#line 2117 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13323 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 2;
															#line 2117 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 13328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& __globalConfigVersion,int loopDepth) 
	{
															#line 2111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigVersion = __globalConfigVersion;
															#line 13342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && __globalConfigVersion,int loopDepth) 
	{
		globalConfigVersion = std::move(__globalConfigVersion);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 2181 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigFuture = tr.watch(globalConfigVersionKey);
															#line 2182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 2182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13425 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 3;
															#line 2182 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 2, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 13430 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult const& globalConfigHistory,int loopDepth) 
	{
															#line 2121 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 2122 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 2123 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 2125 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 2126 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 2127 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 13449 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 2136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 13455 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				break;
			}
															#line 2140 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 2141 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 2144 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 2146 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 2147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 2148 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 2149 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 2151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 13474 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2154 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 13478 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2166 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 13482 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2169 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 2171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 2172 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 2173 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 2174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 2175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 2178 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 13498 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult && globalConfigHistory,int loopDepth) 
	{
															#line 2121 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 2122 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 2123 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 2125 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 2126 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 2127 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 13517 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 2136 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 13523 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				break;
			}
															#line 2140 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 2141 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 2144 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 2146 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 2147 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 2148 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 2149 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 2151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 13542 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2154 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 13546 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2166 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 13550 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2169 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 2171 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 2172 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 2173 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 2174 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 2175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 2178 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 13566 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(globalConfigHistory, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(globalConfigHistory), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 2183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 2183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13652 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 2183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 13657 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 2183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 2183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13668 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 2183 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 13673 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 2105 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2106 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClientDBInfo clientInfo;
															#line 2111 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Value> globalConfigVersion;
															#line 2181 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> globalConfigFuture;
															#line 13937 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorGlobalConfig()
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActor final : public Actor<Void>, public ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >, public ActorCallback< MonitorGlobalConfigActor, 2, Void >, public ActorCallback< MonitorGlobalConfigActor, 3, Void >, public ActorCallback< MonitorGlobalConfigActor, 4, Void >, public FastAllocated<MonitorGlobalConfigActor>, public MonitorGlobalConfigActorState<MonitorGlobalConfigActor> {
															#line 13942 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorGlobalConfigActor>::operator new;
	using FastAllocated<MonitorGlobalConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2334373817202906624UL, 11628669996772239104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >;
friend struct ActorCallback< MonitorGlobalConfigActor, 2, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 3, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 4, Void >;
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 13963 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorGlobalConfigActorState<MonitorGlobalConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9619138829789891328UL, 5514350300057065984UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorGlobalConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorGlobalConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 2103 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorGlobalConfigActor(db));
															#line 14000 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2191 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14005 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updatedChangingDatacenters()
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangingDatacentersActor>
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActorState {
															#line 14012 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActorState(ClusterControllerData* const& self) 
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 14019 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangingDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14036 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 1;
															#line 2194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 14041 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangingDatacentersActorState();
		static_cast<UpdatedChangingDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2195 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 14064 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2195 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 14073 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->desiredDcIds.onChange();
															#line 2197 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->desiredDcIds.get().present())
															#line 14166 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2198 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set(std::make_pair(false, self->desiredDcIds.get()));
															#line 14170 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 2200 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 2201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->desiredDcIds.get().get());
															#line 2203 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set( std::make_pair(worker.priorityInfo.dcFitness > newFitness, self->desiredDcIds.get()));
															#line 2206 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangingDatacenter", self->id) .detail("OldFitness", worker.priorityInfo.dcFitness) .detail("NewFitness", newFitness);
															#line 2209 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.priorityInfo.dcFitness > newFitness)
															#line 14185 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2210 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				worker.priorityInfo.dcFitness = newFitness;
															#line 2211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!worker.reply.isSet())
															#line 14191 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2212 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.reply.send(RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 14195 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				}
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
			else
			{
															#line 2215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 2216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 14205 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2243 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onChange;
															#line 2243 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14218 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 3;
															#line 2243 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 14223 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2216 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 14251 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2217 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 2218 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 2219 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 14261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2222 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changingDcIds.get().second.get());
															#line 2224 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 14267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2226 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 2227 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 2228 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 14275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2229 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send( RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 14279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 2235 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 14286 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2236 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 2236 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14292 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 2;
															#line 2236 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 14297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 2238 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 14324 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 2215 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 14509 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updatedChangingDatacenters()
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangingDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangingDatacentersActor>, public UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor> {
															#line 14514 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdatedChangingDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangingDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18444871495558450176UL, 6082904731816414208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangingDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 2, Void >;
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActor(ClusterControllerData* const& self) 
															#line 14533 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7981795789287489024UL, 15976645570533241600UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangingDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangingDatacenters( ClusterControllerData* const& self ) {
															#line 2192 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangingDatacentersActor(self));
															#line 14568 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2246 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14573 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updatedChangedDatacenters()
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangedDatacentersActor>
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActorState {
															#line 14580 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActorState(ClusterControllerData* const& self) 
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   changeDelay(delay(SERVER_KNOBS->CC_CHANGE_DELAY)),
															#line 2249 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   onChange(self->changingDcIds.onChange())
															#line 14591 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangedDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 14606 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangedDatacentersActorState();
		static_cast<UpdatedChangedDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 2251 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14638 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = changeDelay;
															#line 14642 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 1;
															#line 2252 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 2256 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 14649 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 2254 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 14666 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2253 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 2254 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 14677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 2258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 2260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 2261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 14692 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 2263 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 14698 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 2265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 14706 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2268 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 2269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 14712 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 14716 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 2275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 2276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 14727 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 2258 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 2260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 2261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 14748 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2262 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 2263 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 14754 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2264 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 2265 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 14762 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2268 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 2269 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 14768 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2270 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 14772 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 2275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 2276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 14783 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 0, Void >::remove();
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1(int loopDepth) 
	{
															#line 2276 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 14887 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2277 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 2278 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 2279 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 14897 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2282 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 2285 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 14903 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2287 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 2288 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 2289 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 14911 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					{
															#line 2290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send(RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 14915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 2296 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 14922 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 2297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 14928 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1when2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 2;
															#line 2297 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 14933 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when2cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont1(int loopDepth) 
	{
															#line 2299 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 14960 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2248 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> changeDelay;
															#line 2249 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 2275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 15117 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updatedChangedDatacenters()
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangedDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangedDatacentersActor>, public UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor> {
															#line 15122 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdatedChangedDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangedDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10136396811770255104UL, 10132556442352817664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangedDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 2, Void >;
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActor(ClusterControllerData* const& self) 
															#line 15141 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2151090047836179200UL, 49094124038652928UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangedDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangedDatacenters( ClusterControllerData* const& self ) {
															#line 2247 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangedDatacentersActor(self));
															#line 15175 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15180 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateDatacenterVersionDifferenceActor>
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActorState {
															#line 15187 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActorState(ClusterControllerData* const& self) 
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2309 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   lastLogTime(0)
															#line 15196 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDatacenterVersionDifferenceActorState() 
	{
		fdb_probe_actor_destroy("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2310 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 15211 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDatacenterVersionDifferenceActorState();
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2311 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->versionDifferenceUpdated = false;
															#line 2312 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && self->db.config.usableRegions == 1)
															#line 15243 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2314 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2316 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = 0;
															#line 2318 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = 0;
															#line 2319 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = 0;
															#line 2321 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge)
															#line 15257 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2322 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 15261 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15267 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 1;
															#line 2325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 15272 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2329 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryLog = Optional<TLogInterface>();
															#line 2330 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteLog = Optional<TLogInterface>();
															#line 2331 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 15290 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& logSet : self->db.serverInfo->get().logSystemConfig.tLogs ) {
															#line 2333 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (logSet.isLocal && logSet.locality != tagLocalitySatellite)
															#line 15296 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2334 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2335 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 15302 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
						{
															#line 2336 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
							primaryLog = tLog.interf();
															#line 15306 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
							break;
						}
					}
				}
															#line 2341 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!logSet.isLocal)
															#line 15313 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				{
															#line 2342 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 2343 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 15319 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
						{
															#line 2344 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
							remoteLog = tLog.interf();
															#line 15323 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
							break;
						}
					}
				}
			}
		}
															#line 2352 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!primaryLog.present() || !remoteLog.present() || !self->db.serverInfo->get().ratekeeper.present())
															#line 15332 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2353 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange();
															#line 2353 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15338 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 2;
															#line 2353 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 15343 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 2357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->db.serverInfo->onChange();
															#line 2358 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 15446 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 2359 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryMetrics = brokenPromiseToNever(primaryLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 2361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteMetrics = brokenPromiseToNever(remoteLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 2363 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		ssVersionLagReply = brokenPromiseToNever( self->db.serverInfo->get().ratekeeper.get().getSSVersionLag.getReply(GetSSVersionLagRequest()));
															#line 2366 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = (success(primaryMetrics) && success(remoteMetrics) && success(ssVersionLagReply)) || onChange;
															#line 2366 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15563 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 3;
															#line 2366 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 15568 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2367 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 15590 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2371 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 15596 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2372 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2374 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2375 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 2376 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 2380 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 2383 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 2385 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 15612 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2386 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 15616 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2389 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 15620 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2390 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 2391 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 15626 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 2398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 2398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15633 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 2398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 15638 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2367 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 15647 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2371 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 15653 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2372 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 2374 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 2375 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 2376 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 2380 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 2383 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 2385 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 15669 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2386 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 15673 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2389 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 15677 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2390 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 2391 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 15683 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
		}
															#line 2398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 2398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15690 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 2398 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 15695 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 15779 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2399 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 15791 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2309 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	double lastLogTime;
															#line 2329 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> primaryLog;
															#line 2330 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> remoteLog;
															#line 2357 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 2359 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> primaryMetrics;
															#line 2361 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> remoteMetrics;
															#line 2363 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<GetSSVersionLagReply> ssVersionLagReply;
															#line 15890 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActor final : public Actor<Void>, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >, public FastAllocated<UpdateDatacenterVersionDifferenceActor>, public UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor> {
															#line 15895 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator new;
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17605963521886000640UL, 16391444141039833600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >;
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActor(ClusterControllerData* const& self) 
															#line 15915 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9937717957229000960UL, 3709248056524776448UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDatacenterVersionDifference");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateDatacenterVersionDifference( ClusterControllerData* const& self ) {
															#line 2308 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateDatacenterVersionDifferenceActor(self));
															#line 15951 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2405 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

// A background actor that periodically checks remote DC health, and `checkOutstandingRequests` if remote DC
// recovers.
															#line 15958 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateRemoteDCHealth()
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateRemoteDCHealthActor>
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActorState {
															#line 15965 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActorState(ClusterControllerData* const& self) 
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 15972 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRemoteDCHealthActorState() 
	{
		fdb_probe_actor_destroy("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->INITIAL_UPDATE_CROSS_DC_INFO_DELAY);
															#line 2411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15989 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 1;
															#line 2411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 15994 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRemoteDCHealthActorState();
		static_cast<UpdateRemoteDCHealthActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2413 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 2417 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 16019 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 16023 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2421 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 16027 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2413 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 2417 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 16038 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2418 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 16042 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2421 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 16046 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2422 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool oldRemoteTransactionSystemDegraded = self->remoteTransactionSystemDegraded;
															#line 2423 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteTransactionSystemDegraded = self->remoteTransactionSystemContainsDegradedServers();
															#line 2425 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (oldRemoteTransactionSystemDegraded && !self->remoteTransactionSystemDegraded)
															#line 16141 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2426 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 16145 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		}
															#line 2428 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CHECK_REMOTE_HEALTH_INTERVAL);
															#line 2428 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16151 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 2;
															#line 2428 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 16156 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 16250 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateRemoteDCHealth()
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActor final : public Actor<Void>, public ActorCallback< UpdateRemoteDCHealthActor, 0, Void >, public ActorCallback< UpdateRemoteDCHealthActor, 1, Void >, public FastAllocated<UpdateRemoteDCHealthActor>, public UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor> {
															#line 16255 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateRemoteDCHealthActor>::operator new;
	using FastAllocated<UpdateRemoteDCHealthActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12686966567676957440UL, 10324934582903309056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRemoteDCHealthActor, 0, Void >;
friend struct ActorCallback< UpdateRemoteDCHealthActor, 1, Void >;
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActor(ClusterControllerData* const& self) 
															#line 16273 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4727392956320167168UL, 13078950417560124416UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRemoteDCHealth");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateRemoteDCHealth( ClusterControllerData* const& self ) {
															#line 2408 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateRemoteDCHealthActor(self));
															#line 16307 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2431 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16312 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via doEmptyCommit()
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoEmptyCommitActor>
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActorState {
															#line 16319 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActorState(Database const& cx) 
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cx(cx),
															#line 2433 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(cx)
															#line 16328 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	~DoEmptyCommitActorState() 
	{
		fdb_probe_actor_destroy("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2434 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 16343 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2436 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2437 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2438 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.makeSelfConflicting();
															#line 2439 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 2439 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16382 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 1;
															#line 2439 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 0, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 16387 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 2442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16411 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 2;
															#line 2442 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 1, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 16416 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2440 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 16431 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2440 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 16443 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Database cx;
															#line 2433 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Transaction tr;
															#line 16617 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doEmptyCommit()
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActor final : public Actor<Void>, public ActorCallback< DoEmptyCommitActor, 0, Void >, public ActorCallback< DoEmptyCommitActor, 1, Void >, public FastAllocated<DoEmptyCommitActor>, public DoEmptyCommitActorState<DoEmptyCommitActor> {
															#line 16622 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoEmptyCommitActor>::operator new;
	using FastAllocated<DoEmptyCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16699142280730043648UL, 9346199524646213632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoEmptyCommitActor, 0, Void >;
friend struct ActorCallback< DoEmptyCommitActor, 1, Void >;
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActor(Database const& cx) 
															#line 16640 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoEmptyCommitActorState<DoEmptyCommitActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9964447062675513344UL, 11254058382217442560UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doEmptyCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doEmptyCommit( Database const& cx ) {
															#line 2432 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoEmptyCommitActor(cx));
															#line 16674 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2446 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16679 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via handleForcedRecoveries()
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleForcedRecoveriesActor>
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActorState {
															#line 16686 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 16695 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	~HandleForcedRecoveriesActorState() 
	{
		fdb_probe_actor_destroy("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2448 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 16710 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleForcedRecoveriesActorState();
		static_cast<HandleForcedRecoveriesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2449 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.forceRecovery.getFuture();
															#line 16740 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ForceRecoveryRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ForceRecoveryRequest>>::value, "invalid type");
															#line 2449 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16744 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 1;
															#line 2449 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 16749 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2450 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryStart", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("DcId", req.dcId.printable());
															#line 2453 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		fCommit = doEmptyCommit(self->cx);
															#line 2454 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = fCommit || delay(SERVER_KNOBS->FORCE_RECOVERY_CHECK_DELAY);
															#line 2454 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16764 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 2;
															#line 2454 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 1, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 16769 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest const& __req,int loopDepth) 
	{
															#line 2449 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req = __req;
															#line 16778 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2455 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 16857 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2456 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 16861 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2457 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2458 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2459 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2460 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 16871 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2462 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2463 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 16879 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16885 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 16890 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2455 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 16904 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
															#line 2456 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 16908 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			{
															#line 2457 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2458 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2459 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2460 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 16918 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2462 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2463 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 16926 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			}
															#line 2465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16932 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2465 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 16937 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2467 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryFinish", self->id).log();
															#line 2468 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.forceRecovery = false;
															#line 2469 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 17030 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 2449 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ForceRecoveryRequest req;
															#line 2453 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> fCommit;
															#line 17130 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via handleForcedRecoveries()
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActor final : public Actor<Void>, public ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >, public ActorCallback< HandleForcedRecoveriesActor, 1, Void >, public ActorCallback< HandleForcedRecoveriesActor, 2, Void >, public FastAllocated<HandleForcedRecoveriesActor>, public HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor> {
															#line 17135 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<HandleForcedRecoveriesActor>::operator new;
	using FastAllocated<HandleForcedRecoveriesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3813681747256548352UL, 3877171965101135104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 1, Void >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 2, Void >;
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 17154 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14107891886794473728UL, 6151159479286482432UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleForcedRecoveries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleForcedRecoveries( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 2447 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleForcedRecoveriesActor(self, interf));
															#line 17189 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2472 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 17194 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via triggerAuditStorage()
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TriggerAuditStorageActor>
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActorState {
															#line 17201 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req),
															#line 2474 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   auditId()
															#line 17212 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~TriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2475 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(!req.cancel);
															#line 17227 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			try {
															#line 2477 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 17231 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2505 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TriggerAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerAuditStorageActorState(); static_cast<TriggerAuditStorageActor*>(this)->destroy(); return 0; }
															#line 17260 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<TriggerAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2496 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCTriggerAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2502 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(audit_storage_failed());
															#line 17275 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2481 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageBegin", self->id) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2486 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.range, req.engineType);
															#line 2487 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2487 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 17296 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2487 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 1, UID >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 17301 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2477 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 17317 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2479 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2479 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17325 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2479 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 0, Void >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 17330 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId_,int loopDepth) 
	{
															#line 2488 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2489 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2494 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 17443 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId_,int loopDepth) 
	{
															#line 2488 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2489 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2494 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 17456 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 2474 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID auditId;
															#line 17555 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via triggerAuditStorage()
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActor final : public Actor<Void>, public ActorCallback< TriggerAuditStorageActor, 0, Void >, public ActorCallback< TriggerAuditStorageActor, 1, UID >, public FastAllocated<TriggerAuditStorageActor>, public TriggerAuditStorageActorState<TriggerAuditStorageActor> {
															#line 17560 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
	using FastAllocated<TriggerAuditStorageActor>::operator new;
	using FastAllocated<TriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17464070629720957952UL, 3700701427972154880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerAuditStorageActor, 0, Void >;
friend struct ActorCallback< TriggerAuditStorageActor, 1, UID >;
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 17578 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TriggerAuditStorageActorState<TriggerAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12747449799772827392UL, 11482104197366523904UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> triggerAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2473 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TriggerAuditStorageActor(self, req));
															#line 17612 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
}

#line 2507 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 17617 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cancelAuditStorage()
															#line 2508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class CancelAuditStorageActor>
															#line 2508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActorState {
															#line 17624 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
public:
															#line 2508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2508 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 17633 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~CancelAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2509 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.cancel);
															#line 17648 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
			try {
															#line 2511 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 17652 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2535 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<CancelAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelAuditStorageActorState(); static_cast<CancelAuditStorageActor*>(this)->destroy(); return 0; }
															#line 17681 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/build_output/fdbserver/ClusterController.actor.g.cpp.py_gen"
		new (&static_cast<CancelAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2528 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCCancelAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", req.id) .detail("AuditType", req.getType());
															#line 2532 "/codebuild/output/src1216760889/src/github.com/apple/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(cancel_au