/*
 * Package.swift
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2016-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// swift-tools-version: 6.0
import PackageDescription

let package = Package(
    name: "FoundationDB",
    platforms: [
        .macOS(.v15),
    ],
    products: [
        .library(name: "FoundationDB", targets: ["FoundationDB"]),
    ],
    targets: [
        .systemLibrary(
            name: "CFoundationDB",
            pkgConfig: "libfdb",
            providers: [
                .apt(["foundationdb-clients"]),
                .yum(["foundationdb-clients"]),
            ]
        ),
        .target(
            name: "FoundationDB",
            dependencies: ["CFoundationDB"]
        ),
        .testTarget(
            name: "FoundationDBTests",
            dependencies: ["FoundationDB"]
        ),
        .executableTarget(
            name: "StackTester",
            dependencies: ["FoundationDB"],
            path: "Tests/StackTester/Sources/StackTester"
        ),
    ]
)
