/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.MultiClientHelper;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Collection;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class BasicMultiClientIntegrationTest {
    @RegisterExtension
    public static final MultiClientHelper clientHelper = new MultiClientHelper();

    @Test
    @Tag(value="MultiClient")
    void testMultiClientWritesAndReadsData() throws Exception {
        FDB fDB = FDB.selectAPIVersion((int)630);
        fDB.options().setKnob("min_trace_severity=5");
        Collection<Database> collection = clientHelper.openDatabases(fDB);
        System.out.print("Starting tests.");
        Random random = new Random();
        for (int i = 0; i < 25; ++i) {
            for (Database database : collection) {
                String string = Integer.toString(random.nextInt(100000000));
                String string2 = Integer.toString(random.nextInt(100000000));
                database.run(transaction -> {
                    transaction.set(Tuple.from((Object[])new Object[]{string}).pack(), Tuple.from((Object[])new Object[]{string2}).pack());
                    return null;
                });
                String string3 = (String)database.run(transaction -> {
                    byte[] byArray = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string}).pack()).join();
                    return Tuple.fromBytes((byte[])byArray).getString(0);
                });
                Assertions.assertEquals((Object)string2, (Object)string3, (String)"Wrong result!");
            }
            Thread.sleep(200L);
        }
    }
}

