/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.FDBLibraryRule;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.Versionstamp;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TupleSerializationTest {
    @RegisterExtension
    static final FDBLibraryRule fdbLib = FDBLibraryRule.current();
    private static final byte FF = -1;
    static final List<Tuple> offsetAndLengthTuples = Arrays.asList(new Tuple(), Tuple.from((Object[])new Object[]{null}), Tuple.from((Object[])new Object[]{null, new byte[]{16, 102}}), Tuple.from((Object[])new Object[]{"dummy_string"}), Tuple.from((Object[])new Object[]{1066L}));

    TupleSerializationTest() {
    }

    static Collection<TupleSerialization> serializedForms() {
        return Arrays.asList(new TupleSerialization(Tuple.from((Object[])new Object[0]), new byte[0]), new TupleSerialization(Tuple.from((Object[])new Object[]{0L}), new byte[]{20}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.ZERO}), new byte[]{20}), new TupleSerialization(Tuple.from((Object[])new Object[]{1L}), new byte[]{21, 1}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.ONE}), new byte[]{21, 1}), new TupleSerialization(Tuple.from((Object[])new Object[]{-1L}), new byte[]{19, -2}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.ONE.negate()}), new byte[]{19, -2}), new TupleSerialization(Tuple.from((Object[])new Object[]{255L}), new byte[]{21, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(255L)}), new byte[]{21, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{-255L}), new byte[]{19, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(-255L)}), new byte[]{19, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{256L}), new byte[]{22, 1, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(256L)}), new byte[]{22, 1, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{-256L}), new byte[]{18, -2, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(-256L)}), new byte[]{18, -2, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{65536}), new byte[]{23, 1, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{-65536}), new byte[]{17, -2, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{Long.MAX_VALUE}), new byte[]{28, 127, -1, -1, -1, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(Long.MAX_VALUE)}), new byte[]{28, 127, -1, -1, -1, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE)}), new byte[]{28, -128, 0, 0, 0, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE)}), new byte[]{28, -1, -1, -1, -1, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.ONE.shiftLeft(64)}), new byte[]{29, 9, 1, 0, 0, 0, 0, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{-4294967295L}), new byte[]{16, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.ONE.shiftLeft(32).subtract(BigInteger.ONE).negate()}), new byte[]{16, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{-9223372036854775806L}), new byte[]{12, -128, 0, 0, 0, 0, 0, 0, 1}), new TupleSerialization(Tuple.from((Object[])new Object[]{-9223372036854775807L}), new byte[]{12, -128, 0, 0, 0, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(Long.MIN_VALUE).add(BigInteger.ONE)}), new byte[]{12, -128, 0, 0, 0, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Long.MIN_VALUE}), new byte[]{12, 127, -1, -1, -1, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(Long.MIN_VALUE)}), new byte[]{12, 127, -1, -1, -1, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.valueOf(Long.MIN_VALUE).subtract(BigInteger.ONE)}), new byte[]{12, 127, -1, -1, -1, -1, -1, -1, -2}), new TupleSerialization(Tuple.from((Object[])new Object[]{BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE).negate()}), new byte[]{12, 0, 0, 0, 0, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Float.valueOf(3.14f)}), new byte[]{32, -64, 72, -11, -61}), new TupleSerialization(Tuple.from((Object[])new Object[]{Float.valueOf(-3.14f)}), new byte[]{32, 63, -73, 10, 60}), new TupleSerialization(Tuple.from((Object[])new Object[]{3.14}), new byte[]{33, -64, 9, 30, -72, 81, -21, -123, 31}), new TupleSerialization(Tuple.from((Object[])new Object[]{-3.14}), new byte[]{33, 63, -10, -31, 71, -82, 20, 122, -32}), new TupleSerialization(Tuple.from((Object[])new Object[]{Float.valueOf(0.0f)}), new byte[]{32, -128, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Float.valueOf(-0.0f)}), new byte[]{32, 127, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{0.0}), new byte[]{33, -128, 0, 0, 0, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{-0.0}), new byte[]{33, 127, -1, -1, -1, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{Float.valueOf(Float.POSITIVE_INFINITY)}), new byte[]{32, -1, -128, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Float.valueOf(Float.NEGATIVE_INFINITY)}), new byte[]{32, 0, 127, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{Double.POSITIVE_INFINITY}), new byte[]{33, -1, -16, 0, 0, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Double.NEGATIVE_INFINITY}), new byte[]{33, 0, 15, -1, -1, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{Float.valueOf(Float.intBitsToFloat(Integer.MAX_VALUE))}), new byte[]{32, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{Double.longBitsToDouble(Long.MAX_VALUE)}), new byte[]{33, -1, -1, -1, -1, -1, -1, -1, -1}), new TupleSerialization(Tuple.from((Object[])new Object[]{Float.valueOf(Float.intBitsToFloat(-1))}), new byte[]{32, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Double.longBitsToDouble(-1L)}), new byte[]{33, 0, 0, 0, 0, 0, 0, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{new byte[0]}), new byte[]{1, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{new byte[]{1, 2, 3}}), new byte[]{1, 1, 2, 3, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{new byte[]{0, 0, 0, 4}}), new byte[]{1, 0, -1, 0, -1, 0, -1, 4, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{""}), new byte[]{2, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{"hello"}), new byte[]{2, 104, 101, 108, 108, 111, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{"\u4e2d\u6587"}), new byte[]{2, -28, -72, -83, -26, -106, -121, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{"\u03bc\u03ac\u03b8\u03b7\u03bc\u03b1"}), new byte[]{2, -50, -68, -50, -84, -50, -72, -50, -73, -50, -68, -50, -79, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{new String(new int[]{128293}, 0, 1)}), new byte[]{2, -16, -97, -108, -91, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{"\ud83d\udd25"}), new byte[]{2, -16, -97, -108, -91, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{"\ud83e\udd6f"}), new byte[]{2, -16, -97, -91, -81, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{new String(new int[]{129445}, 0, 1)}), new byte[]{2, -16, -97, -90, -91, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{"\ud83e\udda5"}), new byte[]{2, -16, -97, -90, -91, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{new String(new int[]{0x10FFFF}, 0, 1)}), new byte[]{2, -12, -113, -65, -65, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{"\udbff\udfff"}), new byte[]{2, -12, -113, -65, -65, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null})}), new byte[]{5, 0, -1, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null, "hello"})}), new byte[]{5, 0, -1, 2, 104, 101, 108, 108, 111, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Arrays.asList(null, "hello")}), new byte[]{5, 0, -1, 2, 104, 101, 108, 108, 111, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null, "hell\u0000"})}), new byte[]{5, 0, -1, 2, 104, 101, 108, 108, 0, -1, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Arrays.asList(null, "hell\u0000")}), new byte[]{5, 0, -1, 2, 104, 101, 108, 108, 0, -1, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null}), "hello"}), new byte[]{5, 0, -1, 0, 2, 104, 101, 108, 108, 111, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Tuple.from((Object[])new Object[]{null}), "hello", new byte[]{1, 0}, new byte[0]}), new byte[]{5, 0, -1, 0, 2, 104, 101, 108, 108, 111, 0, 1, 1, 0, -1, 0, 1, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{new UUID(-1168197103L, 1554098974L)}), new byte[]{48, -1, -1, -1, -1, -70, 94, -70, 17, 0, 0, 0, 0, 92, -95, -85, 30}), new TupleSerialization(Tuple.from((Object[])new Object[]{false}), new byte[]{38}), new TupleSerialization(Tuple.from((Object[])new Object[]{true}), new byte[]{39}), new TupleSerialization(Tuple.from((Object[])new Object[]{(short)12313}), new byte[]{22, 48, 25}), new TupleSerialization(Tuple.from((Object[])new Object[]{(byte)3}), new byte[]{21, 3}), new TupleSerialization(Tuple.from((Object[])new Object[]{Versionstamp.complete((byte[])new byte[]{-86, -69, -52, -35, -18, -1, 0, 1, 2, 3})}), new byte[]{51, -86, -69, -52, -35, -18, -1, 0, 1, 2, 3, 0, 0}), new TupleSerialization(Tuple.from((Object[])new Object[]{Versionstamp.complete((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (int)657)}), new byte[]{51, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 2, -111}));
    }

    @ParameterizedTest
    @MethodSource(value={"serializedForms"})
    void testSerializationPackedSize(TupleSerialization tupleSerialization) throws Exception {
        Assertions.assertEquals((int)tupleSerialization.serialization.length, (int)tupleSerialization.tuple.getPackedSize(), (String)("Incorrect packed size for tuple <" + tupleSerialization.tuple + ">"));
    }

    @ParameterizedTest
    @MethodSource(value={"serializedForms"})
    void testSerializationPacking(TupleSerialization tupleSerialization) throws Exception {
        byte[] byArray = tupleSerialization.tuple.pack();
        Assertions.assertArrayEquals((byte[])tupleSerialization.serialization, (byte[])byArray, (String)("Incorrect packing for tuple <" + tupleSerialization.tuple + ">"));
    }

    @ParameterizedTest
    @MethodSource(value={"serializedForms"})
    void testSerializationDePacking(TupleSerialization tupleSerialization) throws Exception {
        Tuple tuple = Tuple.fromItems((Iterable)Tuple.fromBytes((byte[])tupleSerialization.serialization).getItems());
        Assertions.assertEquals((Object)tupleSerialization.tuple, (Object)tuple, (String)"Incorrect tuple after unpacking and deserialization");
    }

    @Test
    void testFromBytesWithNegativeLengthFails() throws Exception {
        Tuple tuple = offsetAndLengthTuples.stream().reduce(new Tuple(), Tuple::addAll);
        byte[] byArray = tuple.pack();
        Assertions.assertThrows(IllegalArgumentException.class, () -> Tuple.fromBytes((byte[])byArray, (int)0, (int)-1));
    }

    @Test
    void testFromBytesWithTooLargeOffsetFails() throws Exception {
        Tuple tuple = offsetAndLengthTuples.stream().reduce(new Tuple(), Tuple::addAll);
        byte[] byArray = tuple.pack();
        Assertions.assertThrows(IllegalArgumentException.class, () -> Tuple.fromBytes((byte[])byArray, (int)(byArray.length + 1), (int)4));
    }

    @Test
    void testFromBytesWithTooLargeLengthFails() throws Exception {
        Tuple tuple = offsetAndLengthTuples.stream().reduce(new Tuple(), Tuple::addAll);
        byte[] byArray = tuple.pack();
        Assertions.assertThrows(IllegalArgumentException.class, () -> Tuple.fromBytes((byte[])byArray, (int)0, (int)(byArray.length + 1)));
    }

    @Test
    void testNotAbleToExceedArrayLengthInFromBytes() throws Exception {
        Tuple tuple = offsetAndLengthTuples.stream().reduce(new Tuple(), Tuple::addAll);
        byte[] byArray = tuple.pack();
        Assertions.assertThrows(IllegalArgumentException.class, () -> Tuple.fromBytes((byte[])byArray, (int)(byArray.length / 2), (int)(byArray.length / 2 + 2)));
    }

    @Test
    void testEmptyAtEndTuple() throws Exception {
        Tuple tuple = offsetAndLengthTuples.stream().reduce(new Tuple(), Tuple::addAll);
        byte[] byArray = tuple.pack();
        Tuple tuple2 = Tuple.fromBytes((byte[])byArray, (int)byArray.length, (int)0);
        Assertions.assertTrue((boolean)tuple2.isEmpty(), (String)"tuple with no bytes is not empty");
    }

    @Test
    void testFromBytesWithNegativeOffsetFails() throws Exception {
        Tuple tuple = offsetAndLengthTuples.stream().reduce(new Tuple(), Tuple::addAll);
        byte[] byArray = tuple.pack();
        Assertions.assertThrows(IllegalArgumentException.class, () -> Tuple.fromBytes((byte[])byArray, (int)-1, (int)4));
    }

    @Test
    void testUnpackedTupleMatchesSerializedTuple() throws Exception {
        Tuple tuple = offsetAndLengthTuples.stream().reduce(new Tuple(), Tuple::addAll);
        byte[] byArray = tuple.pack();
        int n = 0;
        for (Tuple tuple2 : offsetAndLengthTuples) {
            int n2 = tuple2.getPackedSize();
            Tuple tuple3 = Tuple.fromBytes((byte[])byArray, (int)n, (int)n2);
            Assertions.assertEquals((Object)tuple2, (Object)tuple3, (String)("unpacked tuple " + tuple3 + " does not match serialized tuple " + tuple2));
            n += n2;
        }
    }

    @Test
    void testUnpackedTupleMatchesCombinedTuple() throws Exception {
        List<Tuple> list = offsetAndLengthTuples;
        Tuple tuple = list.stream().reduce(new Tuple(), Tuple::addAll);
        byte[] byArray = tuple.pack();
        int n = 0;
        for (int i = 0; i < list.size() - 1; ++i) {
            Tuple tuple2 = list.get(i).addAll(list.get(i + 1));
            Tuple tuple3 = Tuple.fromBytes((byte[])byArray, (int)n, (int)tuple2.getPackedSize());
            Assertions.assertEquals((Object)tuple3, (Object)tuple2, (String)("unpacked tuple " + tuple3 + " does not match combined tuple " + tuple2));
            n += list.get(i).getPackedSize();
        }
    }

    @Test
    void testPackIntoBuffer() throws Exception {
        Tuple tuple = Tuple.from((Object[])new Object[]{"hello", Float.valueOf(3.14f), "world"});
        ByteBuffer byteBuffer = ByteBuffer.allocate("hello".length() + 2 + 4 + 1 + "world".length() + 2);
        tuple.packInto(byteBuffer);
        Assertions.assertArrayEquals((byte[])byteBuffer.array(), (byte[])tuple.pack(), (String)"buffer and tuple do not match");
        byteBuffer = ByteBuffer.allocate(tuple.getPackedSize() + 2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        tuple.packInto(byteBuffer);
        Assertions.assertArrayEquals((byte[])ByteArrayUtil.join((byte[][])new byte[][]{tuple.pack(), {0, 0}}), (byte[])byteBuffer.array(), (String)"buffer and tuple do not match");
        Assertions.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)byteBuffer.order(), (String)"byte order changed");
        byteBuffer = ByteBuffer.allocate(tuple.getPackedSize() + 2);
        byteBuffer.put((byte)1).put((byte)2);
        tuple.packInto(byteBuffer);
        Assertions.assertArrayEquals((byte[])tuple.pack(new byte[]{1, 2}), (byte[])byteBuffer.array(), (String)"buffer and tuple do not match");
        byteBuffer = ByteBuffer.allocate(tuple.getPackedSize() - 1);
        try {
            tuple.packInto(byteBuffer);
            Assertions.fail((String)"able to pack into buffer that was too small");
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        Tuple tuple2 = Tuple.fromItems((Iterable)tuple.getItems());
        byteBuffer = ByteBuffer.allocate(tuple.getPackedSize() - 1);
        try {
            tuple2.packInto(byteBuffer);
            Assertions.fail((String)"able to pack into buffer that was too small");
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        Tuple tuple3 = Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)3)});
        byteBuffer = ByteBuffer.allocate(tuple3.getPackedSize());
        try {
            tuple3.packInto(byteBuffer);
            Assertions.fail((String)"able to pack incomplete versionstamp into buffer");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)byteBuffer.arrayOffset(), (String)"offset changed after unsuccessful pack with incomplete versionstamp");
    }

    private static class TupleSerialization {
        private final Tuple tuple;
        private final byte[] serialization;

        TupleSerialization(Tuple tuple, byte[] byArray) {
            this.tuple = tuple;
            this.serialization = byArray;
        }
    }
}

