/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.LocalityUtil;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.async.CloseableAsyncIterator;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class LocalityTests {
    public static void main(String[] stringArray) {
        FDB fDB = FDB.selectAPIVersion((int)800);
        try (Database database = fDB.open(stringArray[0]);){
            try (Transaction transaction = database.createTransaction();){
                CloseableAsyncIterator closeableAsyncIterator;
                for (String string : closeableAsyncIterator = (CloseableAsyncIterator)LocalityUtil.getAddressesForKey((Transaction)transaction, (byte[])"a".getBytes()).join()) {
                    System.out.println(" @ " + string);
                }
            }
            long l = System.currentTimeMillis();
            try (CloseableAsyncIterator closeableAsyncIterator = LocalityUtil.getBoundaryKeys((Database)database, (byte[])new byte[0], (byte[])new byte[]{-1});){
                CompletableFuture completableFuture = AsyncUtil.collectRemaining((AsyncIterator)closeableAsyncIterator);
                List list = (List)completableFuture.join();
                System.out.println("Took " + (System.currentTimeMillis() - l) + "ms to get " + list.size() + " items");
                int n = 0;
                for (byte[] byArray : (List)completableFuture.join()) {
                    System.out.println(n++ + ": " + ByteArrayUtil.printable((byte[])byArray));
                }
            }
        }
    }

    private LocalityTests() {
    }
}

