#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
/*
 * ListClusters.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_LISTCLUSTERS_ACTOR_G_H)
#define METACLUSTER_LISTCLUSTERS_ACTOR_G_H
#include "metacluster/ListClusters.actor.g.h"
#elif !defined(METACLUSTER_LISTCLUSTERS_ACTOR_H)
#define METACLUSTER_LISTCLUSTERS_ACTOR_H

#include "fdbclient/TenantManagement.actor.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

															#line 40 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
// This generated class is to be used only via listClustersTransaction()
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
template <class Transaction, class ListClustersTransactionActor>
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
class ListClustersTransactionActorState {
															#line 46 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
public:
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	ListClustersTransactionActorState(Transaction const& tr,ClusterNameRef const& begin,ClusterNameRef const& end,int const& limit) 
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		 : tr(tr),
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		   begin(begin),
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		   end(end),
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		   limit(limit)
															#line 59 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
	{
		fdb_probe_actor_create("listClustersTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ListClustersTransactionActorState() 
	{
		fdb_probe_actor_destroy("listClustersTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			CODE_PROBE(true, "List clusters");
															#line 44 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 46 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			tenantModeCheck = TenantAPI::checkTenantMode(tr, ClusterType::METACLUSTER_MANAGEMENT);
															#line 48 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			clusterEntriesFuture = metadata::management::dataClusters().getRange(tr, begin, end, limit);
															#line 50 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			connectionStringFuture = metadata::management::dataClusterConnectionRecords().getRange(tr, begin, end, limit);
															#line 53 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			StrictFuture<Void> __when_expr_0 = tenantModeCheck;
															#line 53 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			if (static_cast<ListClustersTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 86 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListClustersTransactionActor*>(this)->actor_wait_state = 1;
															#line 53 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListClustersTransactionActor, 0, Void >*>(static_cast<ListClustersTransactionActor*>(this)));
															#line 91 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListClustersTransactionActorState();
		static_cast<ListClustersTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 55 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		StrictFuture<KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>>> __when_expr_1 = safeThreadFutureToFuture(clusterEntriesFuture);
															#line 55 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		if (static_cast<ListClustersTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 116 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListClustersTransactionActor*>(this)->actor_wait_state = 2;
															#line 55 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListClustersTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >*>(static_cast<ListClustersTransactionActor*>(this)));
															#line 121 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 55 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		StrictFuture<KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>>> __when_expr_1 = safeThreadFutureToFuture(clusterEntriesFuture);
															#line 55 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		if (static_cast<ListClustersTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 132 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListClustersTransactionActor*>(this)->actor_wait_state = 2;
															#line 55 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListClustersTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >*>(static_cast<ListClustersTransactionActor*>(this)));
															#line 137 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListClustersTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListClustersTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListClustersTransactionActor*>(this)->ActorCallback< ListClustersTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListClustersTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListClustersTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListClustersTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 57 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		StrictFuture<KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>>> __when_expr_2 = safeThreadFutureToFuture(connectionStringFuture);
															#line 57 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		if (static_cast<ListClustersTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 223 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ListClustersTransactionActor*>(this)->actor_wait_state = 3;
															#line 57 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ListClustersTransactionActor, 2, KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> >*>(static_cast<ListClustersTransactionActor*>(this)));
															#line 228 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> const& __clusterEntries,int loopDepth) 
	{
															#line 55 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		clusterEntries = __clusterEntries;
															#line 237 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> && __clusterEntries,int loopDepth) 
	{
		clusterEntries = std::move(__clusterEntries);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListClustersTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListClustersTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListClustersTransactionActor*>(this)->ActorCallback< ListClustersTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListClustersTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >*,KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> const& value) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListClustersTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >*,KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> && value) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListClustersTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> const& connectionStrings,int loopDepth) 
	{
															#line 60 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		ASSERT(clusterEntries.results.size() == connectionStrings.results.size());
															#line 62 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		std::map<ClusterName, DataClusterMetadata> clusters;
															#line 63 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		for(int i = 0;i < clusterEntries.results.size();++i) {
															#line 64 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			ASSERT(clusterEntries.results[i].first == connectionStrings.results[i].first);
															#line 65 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			clusters[clusterEntries.results[i].first] = DataClusterMetadata(clusterEntries.results[i].second, connectionStrings.results[i].second);
															#line 324 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		}
															#line 69 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		if (!static_cast<ListClustersTransactionActor*>(this)->SAV<std::map<ClusterName, DataClusterMetadata>>::futures) { (void)(clusters); this->~ListClustersTransactionActorState(); static_cast<ListClustersTransactionActor*>(this)->destroy(); return 0; }
															#line 328 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		new (&static_cast<ListClustersTransactionActor*>(this)->SAV< std::map<ClusterName, DataClusterMetadata> >::value()) std::map<ClusterName, DataClusterMetadata>(clusters);
		this->~ListClustersTransactionActorState();
		static_cast<ListClustersTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> && connectionStrings,int loopDepth) 
	{
															#line 60 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		ASSERT(clusterEntries.results.size() == connectionStrings.results.size());
															#line 62 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		std::map<ClusterName, DataClusterMetadata> clusters;
															#line 63 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		for(int i = 0;i < clusterEntries.results.size();++i) {
															#line 64 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			ASSERT(clusterEntries.results[i].first == connectionStrings.results[i].first);
															#line 65 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			clusters[clusterEntries.results[i].first] = DataClusterMetadata(clusterEntries.results[i].second, connectionStrings.results[i].second);
															#line 348 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		}
															#line 69 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		if (!static_cast<ListClustersTransactionActor*>(this)->SAV<std::map<ClusterName, DataClusterMetadata>>::futures) { (void)(clusters); this->~ListClustersTransactionActorState(); static_cast<ListClustersTransactionActor*>(this)->destroy(); return 0; }
															#line 352 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		new (&static_cast<ListClustersTransactionActor*>(this)->SAV< std::map<ClusterName, DataClusterMetadata> >::value()) std::map<ClusterName, DataClusterMetadata>(clusters);
		this->~ListClustersTransactionActorState();
		static_cast<ListClustersTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> const& connectionStrings,int loopDepth) 
	{
		loopDepth = a_body1cont3(connectionStrings, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> && connectionStrings,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(connectionStrings), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ListClustersTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListClustersTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListClustersTransactionActor*>(this)->ActorCallback< ListClustersTransactionActor, 2, KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListClustersTransactionActor, 2, KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> >*,KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> const& value) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ListClustersTransactionActor, 2, KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> >*,KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> && value) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ListClustersTransactionActor, 2, KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> >*,Error err) 
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	Transaction tr;
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	ClusterNameRef begin;
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	ClusterNameRef end;
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	int limit;
															#line 46 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	Future<Void> tenantModeCheck;
															#line 48 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	Future<KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>>> clusterEntriesFuture;
															#line 50 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	Future<KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>>> connectionStringFuture;
															#line 55 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> clusterEntries;
															#line 451 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
};
// This generated class is to be used only via listClustersTransaction()
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
template <class Transaction>
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
class ListClustersTransactionActor final : public Actor<std::map<ClusterName, DataClusterMetadata>>, public ActorCallback< ListClustersTransactionActor<Transaction>, 0, Void >, public ActorCallback< ListClustersTransactionActor<Transaction>, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >, public ActorCallback< ListClustersTransactionActor<Transaction>, 2, KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> >, public FastAllocated<ListClustersTransactionActor<Transaction>>, public ListClustersTransactionActorState<Transaction, ListClustersTransactionActor<Transaction>> {
															#line 458 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
public:
	using FastAllocated<ListClustersTransactionActor<Transaction>>::operator new;
	using FastAllocated<ListClustersTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6612065814744892672UL, 13974891870434347008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::map<ClusterName, DataClusterMetadata>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListClustersTransactionActor<Transaction>, 0, Void >;
friend struct ActorCallback< ListClustersTransactionActor<Transaction>, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >;
friend struct ActorCallback< ListClustersTransactionActor<Transaction>, 2, KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> >;
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	ListClustersTransactionActor(Transaction const& tr,ClusterNameRef const& begin,ClusterNameRef const& end,int const& limit) 
															#line 477 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		 : Actor<std::map<ClusterName, DataClusterMetadata>>(),
		   ListClustersTransactionActorState<Transaction, ListClustersTransactionActor<Transaction>>(tr, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listClustersTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1089897321477677056UL, 11705082013572663040UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listClustersTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listClustersTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListClustersTransactionActor<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListClustersTransactionActor<Transaction>, 1, KeyBackedRangeResult<std::pair<ClusterName, DataClusterEntry>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ListClustersTransactionActor<Transaction>, 2, KeyBackedRangeResult<std::pair<ClusterName, ClusterConnectionString>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
template <class Transaction>
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
[[nodiscard]] Future<std::map<ClusterName, DataClusterMetadata>> listClustersTransaction( Transaction const& tr, ClusterNameRef const& begin, ClusterNameRef const& end, int const& limit ) {
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	return Future<std::map<ClusterName, DataClusterMetadata>>(new ListClustersTransactionActor<Transaction>(tr, begin, end, limit));
															#line 513 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
}

#line 71 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"

															#line 518 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
// This generated class is to be used only via listClusters()
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
template <class DB, class ListClustersActor>
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
class ListClustersActorState {
															#line 524 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
public:
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	ListClustersActorState(Reference<DB> const& db,ClusterName const& begin,ClusterName const& end,int const& limit) 
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		 : db(db),
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		   begin(begin),
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		   end(end),
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		   limit(limit),
															#line 77 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		   tr(db->createTransaction())
															#line 539 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
	{
		fdb_probe_actor_create("listClusters", reinterpret_cast<unsigned long>(this));

	}
	~ListClustersActorState() 
	{
		fdb_probe_actor_destroy("listClusters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			;
															#line 554 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 81 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 82 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			StrictFuture<std::map<ClusterName, DataClusterMetadata>> __when_expr_0 = listClustersTransaction(tr, begin, end, limit);
															#line 82 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			if (static_cast<ListClustersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 589 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListClustersActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListClustersActor, 0, std::map<ClusterName, DataClusterMetadata> >*>(static_cast<ListClustersActor*>(this)));
															#line 594 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 86 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 86 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			if (static_cast<ListClustersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 618 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ListClustersActor*>(this)->actor_wait_state = 2;
															#line 86 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListClustersActor, 1, Void >*>(static_cast<ListClustersActor*>(this)));
															#line 623 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::map<ClusterName, DataClusterMetadata> const& clusters,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		if (!static_cast<ListClustersActor*>(this)->SAV<std::map<ClusterName, DataClusterMetadata>>::futures) { (void)(clusters); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 638 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		new (&static_cast<ListClustersActor*>(this)->SAV< std::map<ClusterName, DataClusterMetadata> >::value()) std::map<ClusterName, DataClusterMetadata>(clusters);
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::map<ClusterName, DataClusterMetadata> && clusters,int loopDepth) 
	{
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
		if (!static_cast<ListClustersActor*>(this)->SAV<std::map<ClusterName, DataClusterMetadata>>::futures) { (void)(clusters); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 650 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		new (&static_cast<ListClustersActor*>(this)->SAV< std::map<ClusterName, DataClusterMetadata> >::value()) std::map<ClusterName, DataClusterMetadata>(clusters);
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::map<ClusterName, DataClusterMetadata> const& clusters,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(clusters, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::map<ClusterName, DataClusterMetadata> && clusters,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(clusters), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListClustersActor*>(this)->actor_wait_state > 0) static_cast<ListClustersActor*>(this)->actor_wait_state = 0;
		static_cast<ListClustersActor*>(this)->ActorCallback< ListClustersActor, 0, std::map<ClusterName, DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 0, std::map<ClusterName, DataClusterMetadata> >*,std::map<ClusterName, DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 0, std::map<ClusterName, DataClusterMetadata> >*,std::map<ClusterName, DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListClustersActor, 0, std::map<ClusterName, DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListClustersActor*>(this)->actor_wait_state > 0) static_cast<ListClustersActor*>(this)->actor_wait_state = 0;
		static_cast<ListClustersActor*>(this)->ActorCallback< ListClustersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListClustersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	Reference<DB> db;
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	ClusterName begin;
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	ClusterName end;
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	int limit;
															#line 77 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 830 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
};
// This generated class is to be used only via listClusters()
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
template <class DB>
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
class ListClustersActor final : public Actor<std::map<ClusterName, DataClusterMetadata>>, public ActorCallback< ListClustersActor<DB>, 0, std::map<ClusterName, DataClusterMetadata> >, public ActorCallback< ListClustersActor<DB>, 1, Void >, public FastAllocated<ListClustersActor<DB>>, public ListClustersActorState<DB, ListClustersActor<DB>> {
															#line 837 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
public:
	using FastAllocated<ListClustersActor<DB>>::operator new;
	using FastAllocated<ListClustersActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17058450196282195456UL, 1109692509503867904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::map<ClusterName, DataClusterMetadata>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListClustersActor<DB>, 0, std::map<ClusterName, DataClusterMetadata> >;
friend struct ActorCallback< ListClustersActor<DB>, 1, Void >;
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	ListClustersActor(Reference<DB> const& db,ClusterName const& begin,ClusterName const& end,int const& limit) 
															#line 855 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
		 : Actor<std::map<ClusterName, DataClusterMetadata>>(),
		   ListClustersActorState<DB, ListClustersActor<DB>>(db, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2037707045627374080UL, 7691457401409661952UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listClusters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListClustersActor<DB>, 0, std::map<ClusterName, DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListClustersActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
template <class DB>
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
[[nodiscard]] Future<std::map<ClusterName, DataClusterMetadata>> listClusters( Reference<DB> const& db, ClusterName const& begin, ClusterName const& end, int const& limit ) {
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"
	return Future<std::map<ClusterName, DataClusterMetadata>>(new ListClustersActor<DB>(db, begin, end, limit));
															#line 890 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListClusters.actor.g.h"
}

#line 90 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListClusters.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif