#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
/*
 * TenantEntryCacheWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/TenantManagement.actor.h"

#include "fdbclient/Knobs.h"
#include "fdbclient/TenantEntryCache.actor.h"
#include "fdbrpc/TenantName.h"
#include "fdbserver/workloads/workloads.actor.h"

#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
TenantEntryCachePayload<int64_t> createPayload(const TenantMapEntry& entry) {
	TenantEntryCachePayload<int64_t> payload;
	payload.entry = entry;
	payload.payload = entry.id;

	return payload;
}
} // namespace

struct TenantEntryCacheWorkload : TestWorkload {
	static constexpr auto NAME = "TenantEntryCache";

	const TenantName tenantNamePrefix = "tenant_entry_cache_workload_"_sr;
	TenantName localTenantNamePrefix;
	int maxTenants;
	int clientId;

	TenantEntryCacheWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		clientId = wcx.clientId;
		maxTenants = std::max(3, std::min<int>(1e8 - 1, getOption(options, "maxTenants"_sr, 1000)));
		localTenantNamePrefix = format("%stenant_%d_", tenantNamePrefix.toString().c_str(), clientId);
	}
	~TenantEntryCacheWorkload() {}

	static void compareTenants(Optional<TenantEntryCachePayload<int64_t>> left, TenantMapEntry& right) {
		ASSERT(left.present());
		ASSERT_EQ(left.get().entry.id, right.id);
		ASSERT_EQ(left.get().entry.prefix.compare(right.prefix), 0);
		ASSERT_EQ(left.get().payload, right.id);
	}

																#line 70 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via compareContents()
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class CompareContentsActor>
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class CompareContentsActorState {
															#line 76 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	CompareContentsActorState(std::vector<TenantMapEntry>* const& tenants,Reference<TenantEntryCache<int64_t>> const& cache) 
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : tenants(tenants),
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   cache(cache),
															#line 70 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   i()
															#line 87 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("compareContents", reinterpret_cast<unsigned long>(this));

	}
	~CompareContentsActorState() 
	{
		fdb_probe_actor_destroy("compareContents", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			i = 0;
															#line 102 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CompareContentsActorState();
		static_cast<CompareContentsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 81 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<CompareContentsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompareContentsActorState(); static_cast<CompareContentsActor*>(this)->destroy(); return 0; }
															#line 125 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<CompareContentsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CompareContentsActorState();
		static_cast<CompareContentsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 71 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!(i < tenants->size()))
															#line 144 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 72 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 150 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
															#line 73 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_0 = cache->getById(tenants->at(i).id);
															#line 73 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<CompareContentsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 156 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CompareContentsActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CompareContentsActor, 0, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<CompareContentsActor*>(this)));
															#line 161 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 76 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getByName(tenants->at(i).tenantName);
															#line 76 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<CompareContentsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 170 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<CompareContentsActor*>(this)->actor_wait_state = 2;
															#line 76 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CompareContentsActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<CompareContentsActor*>(this)));
															#line 175 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 71 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		i++;
															#line 198 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<TenantEntryCachePayload<int64_t>> const& e,int loopDepth) 
	{
															#line 74 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(e, tenants->at(i));
															#line 207 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<TenantEntryCachePayload<int64_t>> && e,int loopDepth) 
	{
															#line 74 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(e, tenants->at(i));
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<TenantEntryCachePayload<int64_t>> const& e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(e, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<TenantEntryCachePayload<int64_t>> && e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CompareContentsActor*>(this)->actor_wait_state > 0) static_cast<CompareContentsActor*>(this)->actor_wait_state = 0;
		static_cast<CompareContentsActor*>(this)->ActorCallback< CompareContentsActor, 0, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< CompareContentsActor, 0, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("compareContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareContents", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CompareContentsActor, 0, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("compareContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareContents", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CompareContentsActor, 0, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("compareContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompareContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareContents", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Optional<TenantEntryCachePayload<int64_t>> const& e,int loopDepth) 
	{
															#line 77 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(e, tenants->at(i));
															#line 300 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Optional<TenantEntryCachePayload<int64_t>> && e,int loopDepth) 
	{
															#line 77 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(e, tenants->at(i));
															#line 309 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<TenantEntryCachePayload<int64_t>> const& e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(e, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<TenantEntryCachePayload<int64_t>> && e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CompareContentsActor*>(this)->actor_wait_state > 0) static_cast<CompareContentsActor*>(this)->actor_wait_state = 0;
		static_cast<CompareContentsActor*>(this)->ActorCallback< CompareContentsActor, 1, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< CompareContentsActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("compareContents", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareContents", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CompareContentsActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("compareContents", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompareContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareContents", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CompareContentsActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("compareContents", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompareContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compareContents", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	std::vector<TenantMapEntry>* tenants;
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 70 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	int i;
															#line 395 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via compareContents()
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class CompareContentsActor final : public Actor<Void>, public ActorCallback< CompareContentsActor, 0, Optional<TenantEntryCachePayload<int64_t>> >, public ActorCallback< CompareContentsActor, 1, Optional<TenantEntryCachePayload<int64_t>> >, public FastAllocated<CompareContentsActor>, public CompareContentsActorState<CompareContentsActor> {
															#line 400 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<CompareContentsActor>::operator new;
	using FastAllocated<CompareContentsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12794823127643093760UL, 9891548338360953344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CompareContentsActor, 0, Optional<TenantEntryCachePayload<int64_t>> >;
friend struct ActorCallback< CompareContentsActor, 1, Optional<TenantEntryCachePayload<int64_t>> >;
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	CompareContentsActor(std::vector<TenantMapEntry>* const& tenants,Reference<TenantEntryCache<int64_t>> const& cache) 
															#line 418 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CompareContentsActorState<CompareContentsActor>(tenants, cache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("compareContents", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2341562709353293824UL, 5141541566288777216UL);
		ActorExecutionContextHelper __helper(static_cast<CompareContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("compareContents");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("compareContents", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CompareContentsActor, 0, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CompareContentsActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> compareContents( std::vector<TenantMapEntry>* const& tenants, Reference<TenantEntryCache<int64_t>> const& cache ) {
															#line 68 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new CompareContentsActor(tenants, cache));
															#line 451 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 83 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 456 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via testTenantNotFound()
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TestTenantNotFoundActor>
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestTenantNotFoundActorState {
															#line 462 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestTenantNotFoundActorState(Database const& cx,TenantEntryCacheRefreshMode const& refreshMode) 
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx),
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   refreshMode(refreshMode),
															#line 85 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   cache(makeReference<TenantEntryCache<int64_t>>( cx, deterministicRandom()->randomUniqueID(), createPayload, refreshMode))
															#line 473 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testTenantNotFound", reinterpret_cast<unsigned long>(this));

	}
	~TestTenantNotFoundActorState() 
	{
		fdb_probe_actor_destroy("testTenantNotFound", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			TraceEvent("TenantNotFoundStart");
															#line 89 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cache->init();
															#line 89 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 492 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state = 1;
															#line 89 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestTenantNotFoundActor, 0, Void >*>(static_cast<TestTenantNotFoundActor*>(this)));
															#line 497 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestTenantNotFoundActorState();
		static_cast<TestTenantNotFoundActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 93 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		dummy = TenantMapEntry(std::numeric_limits<int64_t>::max(), "name"_sr);
															#line 94 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getById(dummy.id);
															#line 94 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 526 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantNotFoundActor*>(this)));
															#line 531 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 93 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		dummy = TenantMapEntry(std::numeric_limits<int64_t>::max(), "name"_sr);
															#line 94 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getById(dummy.id);
															#line 94 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 546 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantNotFoundActor*>(this)));
															#line 551 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state > 0) static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantNotFoundActor*>(this)->ActorCallback< TestTenantNotFoundActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantNotFoundActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestTenantNotFoundActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestTenantNotFoundActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<TenantEntryCachePayload<int64_t>> const& value,int loopDepth) 
	{
															#line 95 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!value.present());
															#line 97 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_2 = cache->getByPrefix(dummy.prefix);
															#line 97 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 639 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state = 3;
															#line 97 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantNotFoundActor*>(this)));
															#line 644 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantEntryCachePayload<int64_t>> && value,int loopDepth) 
	{
															#line 95 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!value.present());
															#line 97 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_2 = cache->getByPrefix(dummy.prefix);
															#line 97 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 657 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state = 3;
															#line 97 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantNotFoundActor*>(this)));
															#line 662 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantEntryCachePayload<int64_t>> const& value,int loopDepth) 
	{
		loopDepth = a_body1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantEntryCachePayload<int64_t>> && value,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state > 0) static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantNotFoundActor*>(this)->ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Optional<TenantEntryCachePayload<int64_t>> const& value1,int loopDepth) 
	{
															#line 98 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!value1.present());
															#line 100 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TenantNotFoundEnd");
															#line 101 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestTenantNotFoundActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestTenantNotFoundActorState(); static_cast<TestTenantNotFoundActor*>(this)->destroy(); return 0; }
															#line 750 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestTenantNotFoundActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestTenantNotFoundActorState();
		static_cast<TestTenantNotFoundActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<TenantEntryCachePayload<int64_t>> && value1,int loopDepth) 
	{
															#line 98 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!value1.present());
															#line 100 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TenantNotFoundEnd");
															#line 101 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestTenantNotFoundActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestTenantNotFoundActorState(); static_cast<TestTenantNotFoundActor*>(this)->destroy(); return 0; }
															#line 766 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestTenantNotFoundActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestTenantNotFoundActorState();
		static_cast<TestTenantNotFoundActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<TenantEntryCachePayload<int64_t>> const& value1,int loopDepth) 
	{
		loopDepth = a_body1cont3(value1, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<TenantEntryCachePayload<int64_t>> && value1,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(value1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state > 0) static_cast<TestTenantNotFoundActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantNotFoundActor*>(this)->ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryCacheRefreshMode refreshMode;
															#line 85 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 93 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantMapEntry dummy;
															#line 857 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via testTenantNotFound()
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestTenantNotFoundActor final : public Actor<Void>, public ActorCallback< TestTenantNotFoundActor, 0, Void >, public ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >, public ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >, public FastAllocated<TestTenantNotFoundActor>, public TestTenantNotFoundActorState<TestTenantNotFoundActor> {
															#line 862 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TestTenantNotFoundActor>::operator new;
	using FastAllocated<TestTenantNotFoundActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4459835444159891200UL, 6244452180615636480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestTenantNotFoundActor, 0, Void >;
friend struct ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >;
friend struct ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >;
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestTenantNotFoundActor(Database const& cx,TenantEntryCacheRefreshMode const& refreshMode) 
															#line 881 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestTenantNotFoundActorState<TestTenantNotFoundActor>(cx, refreshMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testTenantNotFound", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16173222042462584576UL, 17407539553679283456UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantNotFoundActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testTenantNotFound");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testTenantNotFound", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestTenantNotFoundActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestTenantNotFoundActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestTenantNotFoundActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testTenantNotFound( Database const& cx, TenantEntryCacheRefreshMode const& refreshMode ) {
															#line 84 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TestTenantNotFoundActor(cx, refreshMode));
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 103 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 920 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via testCreateTenantsAndLookup()
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TestCreateTenantsAndLookupActor>
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCreateTenantsAndLookupActorState {
															#line 926 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCreateTenantsAndLookupActorState(Database const& cx,TenantEntryCacheWorkload* const& self,std::vector<TenantMapEntry>* const& tenantList,TenantEntryCacheRefreshMode const& refreshMode) 
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx),
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   self(self),
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   tenantList(tenantList),
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   refreshMode(refreshMode),
															#line 108 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   cache(makeReference<TenantEntryCache<int64_t>>( cx, deterministicRandom()->randomUniqueID(), createPayload, refreshMode)),
															#line 110 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   nTenants(deterministicRandom()->randomInt(5, self->maxTenants))
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this));

	}
	~TestCreateTenantsAndLookupActorState() 
	{
		fdb_probe_actor_destroy("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			TraceEvent("CreateTenantsAndLookupStart");
															#line 114 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cache->init();
															#line 114 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state = 1;
															#line 114 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCreateTenantsAndLookupActor, 0, Void >*>(static_cast<TestCreateTenantsAndLookupActor*>(this)));
															#line 967 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCreateTenantsAndLookupActorState();
		static_cast<TestCreateTenantsAndLookupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 117 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 119 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantList->clear();
															#line 120 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		i = 0;
															#line 121 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantNames = std::unordered_set<TenantName>();
															#line 122 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		;
															#line 1000 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 117 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 119 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantList->clear();
															#line 120 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		i = 0;
															#line 121 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantNames = std::unordered_set<TenantName>();
															#line 122 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		;
															#line 1019 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state > 0) static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state = 0;
		static_cast<TestCreateTenantsAndLookupActor*>(this)->ActorCallback< TestCreateTenantsAndLookupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCreateTenantsAndLookupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCreateTenantsAndLookupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCreateTenantsAndLookupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 137 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = compareContents(tenantList, cache);
															#line 137 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1105 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state = 3;
															#line 137 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCreateTenantsAndLookupActor, 2, Void >*>(static_cast<TestCreateTenantsAndLookupActor*>(this)));
															#line 1110 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 122 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!(i < nTenants))
															#line 1126 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 123 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		name = TenantName(format("%s%08d", self->localTenantNamePrefix.toString().c_str(), deterministicRandom()->randomInt(0, self->maxTenants)));
															#line 126 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (tenantNames.find(name) != tenantNames.end())
															#line 1134 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
			return a_body1cont1loopHead1(loopDepth); // continue
		}
															#line 130 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = TenantAPI::createTenant(cx.getReference(), name);
															#line 130 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1142 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state = 2;
															#line 130 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCreateTenantsAndLookupActor, 1, Optional<TenantMapEntry> >*>(static_cast<TestCreateTenantsAndLookupActor*>(this)));
															#line 1147 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 132 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantList->emplace_back(entry.get());
															#line 133 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantNames.emplace(name);
															#line 134 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		i++;
															#line 1175 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 132 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantList->emplace_back(entry.get());
															#line 133 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantNames.emplace(name);
															#line 134 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		i++;
															#line 1190 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state > 0) static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state = 0;
		static_cast<TestCreateTenantsAndLookupActor*>(this)->ActorCallback< TestCreateTenantsAndLookupActor, 1, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TestCreateTenantsAndLookupActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCreateTenantsAndLookupActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCreateTenantsAndLookupActor, 1, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("CreateTenantsAndLookupEnd");
															#line 140 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCreateTenantsAndLookupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCreateTenantsAndLookupActorState(); static_cast<TestCreateTenantsAndLookupActor*>(this)->destroy(); return 0; }
															#line 1276 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCreateTenantsAndLookupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCreateTenantsAndLookupActorState();
		static_cast<TestCreateTenantsAndLookupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("CreateTenantsAndLookupEnd");
															#line 140 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCreateTenantsAndLookupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCreateTenantsAndLookupActorState(); static_cast<TestCreateTenantsAndLookupActor*>(this)->destroy(); return 0; }
															#line 1290 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCreateTenantsAndLookupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCreateTenantsAndLookupActorState();
		static_cast<TestCreateTenantsAndLookupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state > 0) static_cast<TestCreateTenantsAndLookupActor*>(this)->actor_wait_state = 0;
		static_cast<TestCreateTenantsAndLookupActor*>(this)->ActorCallback< TestCreateTenantsAndLookupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCreateTenantsAndLookupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestCreateTenantsAndLookupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestCreateTenantsAndLookupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryCacheWorkload* self;
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	std::vector<TenantMapEntry>* tenantList;
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryCacheRefreshMode refreshMode;
															#line 108 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 110 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	int nTenants;
															#line 120 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	int i;
															#line 121 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	std::unordered_set<TenantName> tenantNames;
															#line 123 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantName name;
															#line 1391 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via testCreateTenantsAndLookup()
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCreateTenantsAndLookupActor final : public Actor<Void>, public ActorCallback< TestCreateTenantsAndLookupActor, 0, Void >, public ActorCallback< TestCreateTenantsAndLookupActor, 1, Optional<TenantMapEntry> >, public ActorCallback< TestCreateTenantsAndLookupActor, 2, Void >, public FastAllocated<TestCreateTenantsAndLookupActor>, public TestCreateTenantsAndLookupActorState<TestCreateTenantsAndLookupActor> {
															#line 1396 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TestCreateTenantsAndLookupActor>::operator new;
	using FastAllocated<TestCreateTenantsAndLookupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4632587646626241792UL, 17938923356418059264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCreateTenantsAndLookupActor, 0, Void >;
friend struct ActorCallback< TestCreateTenantsAndLookupActor, 1, Optional<TenantMapEntry> >;
friend struct ActorCallback< TestCreateTenantsAndLookupActor, 2, Void >;
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCreateTenantsAndLookupActor(Database const& cx,TenantEntryCacheWorkload* const& self,std::vector<TenantMapEntry>* const& tenantList,TenantEntryCacheRefreshMode const& refreshMode) 
															#line 1415 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestCreateTenantsAndLookupActorState<TestCreateTenantsAndLookupActor>(cx, self, tenantList, refreshMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13953195131434055424UL, 6170085815384360192UL);
		ActorExecutionContextHelper __helper(static_cast<TestCreateTenantsAndLookupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCreateTenantsAndLookup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCreateTenantsAndLookup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCreateTenantsAndLookupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCreateTenantsAndLookupActor, 1, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestCreateTenantsAndLookupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testCreateTenantsAndLookup( Database const& cx, TenantEntryCacheWorkload* const& self, std::vector<TenantMapEntry>* const& tenantList, TenantEntryCacheRefreshMode const& refreshMode ) {
															#line 104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TestCreateTenantsAndLookupActor(cx, self, tenantList, refreshMode));
															#line 1449 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 142 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 1454 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via testTenantInsert()
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TestTenantInsertActor>
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestTenantInsertActorState {
															#line 1460 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestTenantInsertActorState(Database const& cx,TenantEntryCacheWorkload* const& self,std::vector<TenantMapEntry>* const& tenantList,TenantEntryCacheRefreshMode const& refreshMode) 
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx),
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   self(self),
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   tenantList(tenantList),
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   refreshMode(refreshMode),
															#line 147 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   cache(makeReference<TenantEntryCache<int64_t>>( cx, deterministicRandom()->randomUniqueID(), createPayload, refreshMode))
															#line 1475 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testTenantInsert", reinterpret_cast<unsigned long>(this));

	}
	~TestTenantInsertActorState() 
	{
		fdb_probe_actor_destroy("testTenantInsert", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			ASSERT(!tenantList->empty() && tenantList->size() >= 2);
															#line 152 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			TraceEvent("TestTenantInsertStart");
															#line 154 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cache->init();
															#line 154 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1496 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 1;
															#line 154 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 0, Void >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1501 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestTenantInsertActorState();
		static_cast<TestTenantInsertActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 157 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 159 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p = tenantList->at(0);
															#line 160 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = Optional<TenantEntryCachePayload<int64_t>>();
															#line 163 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p.tenantName = TenantName(format("%s%08d", self->localTenantNamePrefix.toString().c_str(), deterministicRandom()->randomInt(self->maxTenants + 100, self->maxTenants + 200)));
															#line 167 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		cache->put(p);
															#line 168 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getByName(p.tenantName);
															#line 168 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1538 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 2;
															#line 168 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1543 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 157 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 159 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p = tenantList->at(0);
															#line 160 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = Optional<TenantEntryCachePayload<int64_t>>();
															#line 163 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p.tenantName = TenantName(format("%s%08d", self->localTenantNamePrefix.toString().c_str(), deterministicRandom()->randomInt(self->maxTenants + 100, self->maxTenants + 200)));
															#line 167 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		cache->put(p);
															#line 168 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getByName(p.tenantName);
															#line 168 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1566 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 2;
															#line 168 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1571 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state > 0) static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantInsertActor*>(this)->ActorCallback< TestTenantInsertActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestTenantInsertActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<TenantEntryCachePayload<int64_t>> const& e,int loopDepth) 
	{
															#line 169 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = e;
															#line 170 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(entry, p);
															#line 173 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p.id = p.id + deterministicRandom()->randomInt(self->maxTenants + 500, self->maxTenants + 700);
															#line 174 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		cache->put(p);
															#line 175 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_2 = cache->getById(p.id);
															#line 175 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1665 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 3;
															#line 175 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1670 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantEntryCachePayload<int64_t>> && e,int loopDepth) 
	{
															#line 169 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = e;
															#line 170 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(entry, p);
															#line 173 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p.id = p.id + deterministicRandom()->randomInt(self->maxTenants + 500, self->maxTenants + 700);
															#line 174 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		cache->put(p);
															#line 175 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_2 = cache->getById(p.id);
															#line 175 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1689 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 3;
															#line 175 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantEntryCachePayload<int64_t>> const& e,int loopDepth) 
	{
		loopDepth = a_body1cont2(e, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantEntryCachePayload<int64_t>> && e,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state > 0) static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantInsertActor*>(this)->ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Optional<TenantEntryCachePayload<int64_t>> const& e1,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = e1;
															#line 177 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(entry, p);
															#line 178 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(p.tenantName.compare(entry.get().entry.tenantName), 0);
															#line 181 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p1 = tenantList->back();
															#line 182 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantList->pop_back();
															#line 183 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = TenantAPI::deleteTenant(cx.getReference(), p1.tenantName);
															#line 183 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1790 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 4;
															#line 183 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 3, Void >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1795 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<TenantEntryCachePayload<int64_t>> && e1,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = e1;
															#line 177 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(entry, p);
															#line 178 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(p.tenantName.compare(entry.get().entry.tenantName), 0);
															#line 181 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p1 = tenantList->back();
															#line 182 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		tenantList->pop_back();
															#line 183 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = TenantAPI::deleteTenant(cx.getReference(), p1.tenantName);
															#line 183 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1816 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 4;
															#line 183 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 3, Void >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1821 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<TenantEntryCachePayload<int64_t>> const& e1,int loopDepth) 
	{
		loopDepth = a_body1cont3(e1, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<TenantEntryCachePayload<int64_t>> && e1,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(e1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state > 0) static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantInsertActor*>(this)->ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p.tenantName = p1.tenantName;
															#line 185 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		cache->put(p);
															#line 186 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_4 = cache->getById(p.id);
															#line 186 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1911 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 5;
															#line 186 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1916 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		p.tenantName = p1.tenantName;
															#line 185 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		cache->put(p);
															#line 186 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_4 = cache->getById(p.id);
															#line 186 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1931 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 5;
															#line 186 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestTenantInsertActor*>(this)));
															#line 1936 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state > 0) static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantInsertActor*>(this)->ActorCallback< TestTenantInsertActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestTenantInsertActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Optional<TenantEntryCachePayload<int64_t>> const& e2,int loopDepth) 
	{
															#line 187 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = e2;
															#line 188 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(entry, p);
															#line 189 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(p1.tenantName.compare(entry.get().entry.tenantName), 0);
															#line 191 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestTenantInsertEnd");
															#line 192 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestTenantInsertActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestTenantInsertActorState(); static_cast<TestTenantInsertActor*>(this)->destroy(); return 0; }
															#line 2028 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestTenantInsertActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestTenantInsertActorState();
		static_cast<TestTenantInsertActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Optional<TenantEntryCachePayload<int64_t>> && e2,int loopDepth) 
	{
															#line 187 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = e2;
															#line 188 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(entry, p);
															#line 189 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(p1.tenantName.compare(entry.get().entry.tenantName), 0);
															#line 191 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestTenantInsertEnd");
															#line 192 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestTenantInsertActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestTenantInsertActorState(); static_cast<TestTenantInsertActor*>(this)->destroy(); return 0; }
															#line 2048 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestTenantInsertActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestTenantInsertActorState();
		static_cast<TestTenantInsertActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Optional<TenantEntryCachePayload<int64_t>> const& e2,int loopDepth) 
	{
		loopDepth = a_body1cont5(e2, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<TenantEntryCachePayload<int64_t>> && e2,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(e2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestTenantInsertActor*>(this)->actor_wait_state > 0) static_cast<TestTenantInsertActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantInsertActor*>(this)->ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryCacheWorkload* self;
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	std::vector<TenantMapEntry>* tenantList;
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryCacheRefreshMode refreshMode;
															#line 147 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 159 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantMapEntry p;
															#line 160 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Optional<TenantEntryCachePayload<int64_t>> entry;
															#line 181 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantMapEntry p1;
															#line 2147 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via testTenantInsert()
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestTenantInsertActor final : public Actor<Void>, public ActorCallback< TestTenantInsertActor, 0, Void >, public ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >, public ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >, public ActorCallback< TestTenantInsertActor, 3, Void >, public ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >, public FastAllocated<TestTenantInsertActor>, public TestTenantInsertActorState<TestTenantInsertActor> {
															#line 2152 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TestTenantInsertActor>::operator new;
	using FastAllocated<TestTenantInsertActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10412756807618547456UL, 13245196390754947072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestTenantInsertActor, 0, Void >;
friend struct ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >;
friend struct ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >;
friend struct ActorCallback< TestTenantInsertActor, 3, Void >;
friend struct ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >;
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestTenantInsertActor(Database const& cx,TenantEntryCacheWorkload* const& self,std::vector<TenantMapEntry>* const& tenantList,TenantEntryCacheRefreshMode const& refreshMode) 
															#line 2173 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestTenantInsertActorState<TestTenantInsertActor>(cx, self, tenantList, refreshMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testTenantInsert", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12593318674750576640UL, 2204692226134158080UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantInsertActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testTenantInsert");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testTenantInsert", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestTenantInsertActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestTenantInsertActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestTenantInsertActor, 2, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestTenantInsertActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestTenantInsertActor, 4, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testTenantInsert( Database const& cx, TenantEntryCacheWorkload* const& self, std::vector<TenantMapEntry>* const& tenantList, TenantEntryCacheRefreshMode const& refreshMode ) {
															#line 143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TestTenantInsertActor(cx, self, tenantList, refreshMode));
															#line 2209 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 194 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 2214 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via testCacheReload()
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TestCacheReloadActor>
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCacheReloadActorState {
															#line 2220 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCacheReloadActorState(Database const& cx,std::vector<TenantMapEntry>* const& tenantList,TenantEntryCacheRefreshMode const& refreshMode) 
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx),
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   tenantList(tenantList),
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   refreshMode(refreshMode),
															#line 198 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   cache(makeReference<TenantEntryCache<int64_t>>( cx, deterministicRandom()->randomUniqueID(), createPayload, refreshMode))
															#line 2233 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testCacheReload", reinterpret_cast<unsigned long>(this));

	}
	~TestCacheReloadActorState() 
	{
		fdb_probe_actor_destroy("testCacheReload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 201 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			ASSERT(!tenantList->empty());
															#line 203 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			TraceEvent("CacheReloadStart");
															#line 205 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cache->init();
															#line 205 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TestCacheReloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCacheReloadActor*>(this)->actor_wait_state = 1;
															#line 205 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCacheReloadActor, 0, Void >*>(static_cast<TestCacheReloadActor*>(this)));
															#line 2259 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCacheReloadActorState();
		static_cast<TestCacheReloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 208 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 210 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = compareContents(tenantList, cache);
															#line 210 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheReloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2288 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCacheReloadActor*>(this)->actor_wait_state = 2;
															#line 210 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCacheReloadActor, 1, Void >*>(static_cast<TestCacheReloadActor*>(this)));
															#line 2293 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 208 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 210 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = compareContents(tenantList, cache);
															#line 210 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheReloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2308 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCacheReloadActor*>(this)->actor_wait_state = 2;
															#line 210 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCacheReloadActor, 1, Void >*>(static_cast<TestCacheReloadActor*>(this)));
															#line 2313 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCacheReloadActor*>(this)->actor_wait_state > 0) static_cast<TestCacheReloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheReloadActor*>(this)->ActorCallback< TestCacheReloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheReloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCacheReload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheReloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheReload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCacheReloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCacheReload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheReloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheReload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCacheReloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheReload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheReloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheReload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 212 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("CacheReloadEnd");
															#line 213 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCacheReloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCacheReloadActorState(); static_cast<TestCacheReloadActor*>(this)->destroy(); return 0; }
															#line 2399 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCacheReloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCacheReloadActorState();
		static_cast<TestCacheReloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 212 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("CacheReloadEnd");
															#line 213 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCacheReloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCacheReloadActorState(); static_cast<TestCacheReloadActor*>(this)->destroy(); return 0; }
															#line 2413 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCacheReloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCacheReloadActorState();
		static_cast<TestCacheReloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCacheReloadActor*>(this)->actor_wait_state > 0) static_cast<TestCacheReloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheReloadActor*>(this)->ActorCallback< TestCacheReloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheReloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCacheReload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheReloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheReload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCacheReloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCacheReload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheReloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheReload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCacheReloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheReload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheReloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheReload", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	std::vector<TenantMapEntry>* tenantList;
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryCacheRefreshMode refreshMode;
															#line 198 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 2504 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via testCacheReload()
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCacheReloadActor final : public Actor<Void>, public ActorCallback< TestCacheReloadActor, 0, Void >, public ActorCallback< TestCacheReloadActor, 1, Void >, public FastAllocated<TestCacheReloadActor>, public TestCacheReloadActorState<TestCacheReloadActor> {
															#line 2509 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TestCacheReloadActor>::operator new;
	using FastAllocated<TestCacheReloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17149093882832257280UL, 16718976537301190400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCacheReloadActor, 0, Void >;
friend struct ActorCallback< TestCacheReloadActor, 1, Void >;
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCacheReloadActor(Database const& cx,std::vector<TenantMapEntry>* const& tenantList,TenantEntryCacheRefreshMode const& refreshMode) 
															#line 2527 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestCacheReloadActorState<TestCacheReloadActor>(cx, tenantList, refreshMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCacheReload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9986227423055594496UL, 3058233226399034624UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheReloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCacheReload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCacheReload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCacheReloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCacheReloadActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testCacheReload( Database const& cx, std::vector<TenantMapEntry>* const& tenantList, TenantEntryCacheRefreshMode const& refreshMode ) {
															#line 195 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TestCacheReloadActor(cx, tenantList, refreshMode));
															#line 2560 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 215 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 2565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via testTenantCacheDefaultFunc()
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TestTenantCacheDefaultFuncActor>
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestTenantCacheDefaultFuncActorState {
															#line 2571 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestTenantCacheDefaultFuncActorState(Database const& cx) 
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx)
															#line 2578 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this));

	}
	~TestTenantCacheDefaultFuncActorState() 
	{
		fdb_probe_actor_destroy("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 217 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0.0);
															#line 217 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TestTenantCacheDefaultFuncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2595 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestTenantCacheDefaultFuncActor*>(this)->actor_wait_state = 1;
															#line 217 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestTenantCacheDefaultFuncActor, 0, Void >*>(static_cast<TestTenantCacheDefaultFuncActor*>(this)));
															#line 2600 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestTenantCacheDefaultFuncActorState();
		static_cast<TestTenantCacheDefaultFuncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 218 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestTenantCacheDefaultFuncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestTenantCacheDefaultFuncActorState(); static_cast<TestTenantCacheDefaultFuncActor*>(this)->destroy(); return 0; }
															#line 2623 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestTenantCacheDefaultFuncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestTenantCacheDefaultFuncActorState();
		static_cast<TestTenantCacheDefaultFuncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 218 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestTenantCacheDefaultFuncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestTenantCacheDefaultFuncActorState(); static_cast<TestTenantCacheDefaultFuncActor*>(this)->destroy(); return 0; }
															#line 2635 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestTenantCacheDefaultFuncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestTenantCacheDefaultFuncActorState();
		static_cast<TestTenantCacheDefaultFuncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestTenantCacheDefaultFuncActor*>(this)->actor_wait_state > 0) static_cast<TestTenantCacheDefaultFuncActor*>(this)->actor_wait_state = 0;
		static_cast<TestTenantCacheDefaultFuncActor*>(this)->ActorCallback< TestTenantCacheDefaultFuncActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestTenantCacheDefaultFuncActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantCacheDefaultFuncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestTenantCacheDefaultFuncActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantCacheDefaultFuncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestTenantCacheDefaultFuncActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantCacheDefaultFuncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 2720 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via testTenantCacheDefaultFunc()
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestTenantCacheDefaultFuncActor final : public Actor<Void>, public ActorCallback< TestTenantCacheDefaultFuncActor, 0, Void >, public FastAllocated<TestTenantCacheDefaultFuncActor>, public TestTenantCacheDefaultFuncActorState<TestTenantCacheDefaultFuncActor> {
															#line 2725 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TestTenantCacheDefaultFuncActor>::operator new;
	using FastAllocated<TestTenantCacheDefaultFuncActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17218659715689270272UL, 4568912396365083136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestTenantCacheDefaultFuncActor, 0, Void >;
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestTenantCacheDefaultFuncActor(Database const& cx) 
															#line 2742 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestTenantCacheDefaultFuncActorState<TestTenantCacheDefaultFuncActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17853290744098797568UL, 15991000305187144960UL);
		ActorExecutionContextHelper __helper(static_cast<TestTenantCacheDefaultFuncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testTenantCacheDefaultFunc");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testTenantCacheDefaultFunc", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestTenantCacheDefaultFuncActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testTenantCacheDefaultFunc( Database const& cx ) {
															#line 216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TestTenantCacheDefaultFuncActor(cx));
															#line 2774 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 220 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 2779 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via testCacheRefresh()
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TestCacheRefreshActor>
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCacheRefreshActorState {
															#line 2785 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCacheRefreshActorState(Database const& cx) 
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx),
															#line 222 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   cache(makeReference<TenantEntryCache<int64_t>>(cx, createPayload))
															#line 2794 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testCacheRefresh", reinterpret_cast<unsigned long>(this));

	}
	~TestCacheRefreshActorState() 
	{
		fdb_probe_actor_destroy("testCacheRefresh", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 224 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			TraceEvent("TestCacheRefreshStart");
															#line 226 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cache->init();
															#line 226 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TestCacheRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2813 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCacheRefreshActor*>(this)->actor_wait_state = 1;
															#line 226 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCacheRefreshActor, 0, Void >*>(static_cast<TestCacheRefreshActor*>(this)));
															#line 2818 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCacheRefreshActorState();
		static_cast<TestCacheRefreshActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 228 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 229 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 234 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		startTime = now();
															#line 235 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		waitUntill = startTime + 300;
															#line 236 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		;
															#line 2849 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 228 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 229 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 234 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		startTime = now();
															#line 235 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		waitUntill = startTime + 300;
															#line 236 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		;
															#line 2866 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCacheRefreshActor*>(this)->actor_wait_state > 0) static_cast<TestCacheRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheRefreshActor*>(this)->ActorCallback< TestCacheRefreshActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheRefreshActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCacheRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCacheRefreshActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCacheRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCacheRefreshActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 250 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestCacheRefreshEnd").detail("ElapsedTotal", now() - startTime);
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCacheRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCacheRefreshActorState(); static_cast<TestCacheRefreshActor*>(this)->destroy(); return 0; }
															#line 2952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCacheRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCacheRefreshActorState();
		static_cast<TestCacheRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 238 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (cache->numCacheRefreshes() >= 2)
															#line 2971 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 242 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (now() > waitUntill)
															#line 2977 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
															#line 243 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 2981 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		}
															#line 246 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestCacheRefreshWait").detail("Elapsed", now() - startTime);
															#line 247 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(CLIENT_KNOBS->TENANT_ENTRY_CACHE_LIST_REFRESH_INTERVAL);
															#line 247 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2989 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCacheRefreshActor*>(this)->actor_wait_state = 2;
															#line 247 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCacheRefreshActor, 1, Void >*>(static_cast<TestCacheRefreshActor*>(this)));
															#line 2994 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCacheRefreshActor*>(this)->actor_wait_state > 0) static_cast<TestCacheRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheRefreshActor*>(this)->ActorCallback< TestCacheRefreshActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheRefreshActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCacheRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCacheRefreshActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCacheRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCacheRefreshActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 222 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 234 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	int64_t startTime;
															#line 235 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	int64_t waitUntill;
															#line 3107 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via testCacheRefresh()
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCacheRefreshActor final : public Actor<Void>, public ActorCallback< TestCacheRefreshActor, 0, Void >, public ActorCallback< TestCacheRefreshActor, 1, Void >, public FastAllocated<TestCacheRefreshActor>, public TestCacheRefreshActorState<TestCacheRefreshActor> {
															#line 3112 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TestCacheRefreshActor>::operator new;
	using FastAllocated<TestCacheRefreshActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2269474802704113920UL, 980549546120361984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCacheRefreshActor, 0, Void >;
friend struct ActorCallback< TestCacheRefreshActor, 1, Void >;
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCacheRefreshActor(Database const& cx) 
															#line 3130 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestCacheRefreshActorState<TestCacheRefreshActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCacheRefresh", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(174030818816163584UL, 17892734777626022656UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCacheRefresh");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCacheRefresh", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCacheRefreshActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCacheRefreshActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testCacheRefresh( Database const& cx ) {
															#line 221 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TestCacheRefreshActor(cx));
															#line 3163 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 253 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 3168 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via testCacheTenantsDisabled()
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TestCacheTenantsDisabledActor>
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCacheTenantsDisabledActorState {
															#line 3174 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCacheTenantsDisabledActorState(Database const& cx) 
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx)
															#line 3181 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this));

	}
	~TestCacheTenantsDisabledActorState() 
	{
		fdb_probe_actor_destroy("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 255 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			ASSERT(cx->clientInfo->get().tenantMode == TenantMode::DISABLED);
															#line 256 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			cache = makeReference<TenantEntryCache<int64_t>>( cx, deterministicRandom()->randomUniqueID(), createPayload, TenantEntryCacheRefreshMode::NONE);
															#line 259 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			TraceEvent("TestCacheTenantDisabledStart");
															#line 261 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cache->init();
															#line 261 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3204 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state = 1;
															#line 261 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCacheTenantsDisabledActor, 0, Void >*>(static_cast<TestCacheTenantsDisabledActor*>(this)));
															#line 3209 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCacheTenantsDisabledActorState();
		static_cast<TestCacheTenantsDisabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 264 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 266 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getById(12);
															#line 266 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3238 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestCacheTenantsDisabledActor*>(this)));
															#line 3243 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 264 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 266 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getById(12);
															#line 266 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3258 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestCacheTenantsDisabledActor*>(this)));
															#line 3263 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state > 0) static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheTenantsDisabledActor*>(this)->ActorCallback< TestCacheTenantsDisabledActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheTenantsDisabledActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheTenantsDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCacheTenantsDisabledActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheTenantsDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCacheTenantsDisabledActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheTenantsDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<TenantEntryCachePayload<int64_t>> const& entry,int loopDepth) 
	{
															#line 267 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!entry.present());
															#line 268 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numCacheRefreshes(), 1);
															#line 270 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestCacheTenantDisabledEnd");
															#line 271 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCacheTenantsDisabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCacheTenantsDisabledActorState(); static_cast<TestCacheTenantsDisabledActor*>(this)->destroy(); return 0; }
															#line 3353 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCacheTenantsDisabledActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCacheTenantsDisabledActorState();
		static_cast<TestCacheTenantsDisabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantEntryCachePayload<int64_t>> && entry,int loopDepth) 
	{
															#line 267 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!entry.present());
															#line 268 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numCacheRefreshes(), 1);
															#line 270 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestCacheTenantDisabledEnd");
															#line 271 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCacheTenantsDisabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCacheTenantsDisabledActorState(); static_cast<TestCacheTenantsDisabledActor*>(this)->destroy(); return 0; }
															#line 3371 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCacheTenantsDisabledActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCacheTenantsDisabledActorState();
		static_cast<TestCacheTenantsDisabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantEntryCachePayload<int64_t>> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantEntryCachePayload<int64_t>> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state > 0) static_cast<TestCacheTenantsDisabledActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheTenantsDisabledActor*>(this)->ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheTenantsDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheTenantsDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheTenantsDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 256 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 3458 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via testCacheTenantsDisabled()
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCacheTenantsDisabledActor final : public Actor<Void>, public ActorCallback< TestCacheTenantsDisabledActor, 0, Void >, public ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >, public FastAllocated<TestCacheTenantsDisabledActor>, public TestCacheTenantsDisabledActorState<TestCacheTenantsDisabledActor> {
															#line 3463 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TestCacheTenantsDisabledActor>::operator new;
	using FastAllocated<TestCacheTenantsDisabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8219554931492843008UL, 1195322693023716352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCacheTenantsDisabledActor, 0, Void >;
friend struct ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >;
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCacheTenantsDisabledActor(Database const& cx) 
															#line 3481 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestCacheTenantsDisabledActorState<TestCacheTenantsDisabledActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1002515870188129280UL, 7468949098412706816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheTenantsDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCacheTenantsDisabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCacheTenantsDisabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCacheTenantsDisabledActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCacheTenantsDisabledActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testCacheTenantsDisabled( Database const& cx ) {
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TestCacheTenantsDisabledActor(cx));
															#line 3514 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 273 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 3519 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via tenantEntryRemove()
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TenantEntryRemoveActor>
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TenantEntryRemoveActorState {
															#line 3525 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryRemoveActorState(Database const& cx,std::vector<TenantMapEntry>* const& tenantList) 
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx),
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   tenantList(tenantList),
															#line 275 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   cache(makeReference<TenantEntryCache<int64_t>>( cx, deterministicRandom()->randomUniqueID(), createPayload, TenantEntryCacheRefreshMode::NONE))
															#line 3536 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantEntryRemove", reinterpret_cast<unsigned long>(this));

	}
	~TenantEntryRemoveActorState() 
	{
		fdb_probe_actor_destroy("tenantEntryRemove", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 278 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cache->init();
															#line 278 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3553 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 1;
															#line 278 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 0, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3558 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantEntryRemoveActorState();
		static_cast<TenantEntryRemoveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!tenantList->empty());
															#line 283 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		idx = deterministicRandom()->randomInt(0, tenantList->size());
															#line 284 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getByName(tenantList->at(idx).tenantName);
															#line 284 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3587 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 2;
															#line 284 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3592 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!tenantList->empty());
															#line 283 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		idx = deterministicRandom()->randomInt(0, tenantList->size());
															#line 284 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_1 = cache->getByName(tenantList->at(idx).tenantName);
															#line 284 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3607 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 2;
															#line 284 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3612 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<TenantEntryCachePayload<int64_t>> const& entry,int loopDepth) 
	{
															#line 285 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 287 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestTenantEntryRemoveStart") .detail("Id", tenantList->at(idx).id) .detail("Name", tenantList->at(idx).tenantName) .detail("Prefix", tenantList->at(idx).prefix);
															#line 292 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = TenantAPI::deleteTenant(cx.getReference(), tenantList->at(idx).tenantName);
															#line 292 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3702 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 3;
															#line 292 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 2, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantEntryCachePayload<int64_t>> && entry,int loopDepth) 
	{
															#line 285 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 287 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestTenantEntryRemoveStart") .detail("Id", tenantList->at(idx).id) .detail("Name", tenantList->at(idx).tenantName) .detail("Prefix", tenantList->at(idx).prefix);
															#line 292 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = TenantAPI::deleteTenant(cx.getReference(), tenantList->at(idx).tenantName);
															#line 292 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3722 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 3;
															#line 292 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 2, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3727 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantEntryCachePayload<int64_t>> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantEntryCachePayload<int64_t>> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 3811 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
															#line 295 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = cache->removeEntryById(tenantList->at(idx).id);
															#line 295 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3817 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 4;
															#line 295 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 3, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3822 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 296 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 3829 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			{
															#line 297 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_4 = cache->removeEntryByPrefix(tenantList->at(idx).prefix);
															#line 297 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3835 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when2(__when_expr_4.get(), loopDepth); };
				static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 5;
															#line 297 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 4, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3840 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 299 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_5 = cache->removeEntryByName(tenantList->at(idx).tenantName);
															#line 299 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3849 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3when3(__when_expr_5.get(), loopDepth); };
				static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 6;
															#line 299 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 5, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3854 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 294 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 3865 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
															#line 295 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = cache->removeEntryById(tenantList->at(idx).id);
															#line 295 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3871 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 4;
															#line 295 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 3, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3876 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 296 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 3883 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			{
															#line 297 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_4 = cache->removeEntryByPrefix(tenantList->at(idx).prefix);
															#line 297 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3889 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when2(__when_expr_4.get(), loopDepth); };
				static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 5;
															#line 297 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 4, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3894 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 299 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_5 = cache->removeEntryByName(tenantList->at(idx).tenantName);
															#line 299 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3903 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3when3(__when_expr_5.get(), loopDepth); };
				static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 6;
															#line 299 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 5, Void >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 3908 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 302 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_6 = cache->getById(tenantList->at(idx).id);
															#line 302 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3996 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont4when1(__when_expr_6.get(), loopDepth); };
		static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 7;
															#line 302 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 6, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 4001 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 303 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!e.present());
															#line 304 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_7 = cache->getByPrefix(tenantList->at(idx).prefix);
															#line 304 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4281 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 8;
															#line 304 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 7, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 4286 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Optional<TenantEntryCachePayload<int64_t>> const& __e,int loopDepth) 
	{
															#line 302 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		e = __e;
															#line 4295 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<TenantEntryCachePayload<int64_t>> && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 6, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 6, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 6, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 6, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 305 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!e1.present());
															#line 306 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_8 = cache->getByName(tenantList->at(idx).tenantName);
															#line 306 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4378 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 9;
															#line 306 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 8, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 4383 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Optional<TenantEntryCachePayload<int64_t>> const& __e1,int loopDepth) 
	{
															#line 304 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		e1 = __e1;
															#line 4392 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Optional<TenantEntryCachePayload<int64_t>> && __e1,int loopDepth) 
	{
		e1 = std::move(__e1);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 7, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 7, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 7, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 7, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 307 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!e2.present());
															#line 310 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		cache->removeEntryByName(tenantList->at(idx).tenantName);
															#line 311 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_9 = cache->getById(tenantList->at(idx).id);
															#line 311 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4477 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 10;
															#line 311 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TenantEntryRemoveActor, 9, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TenantEntryRemoveActor*>(this)));
															#line 4482 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Optional<TenantEntryCachePayload<int64_t>> const& __e2,int loopDepth) 
	{
															#line 306 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		e2 = __e2;
															#line 4491 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Optional<TenantEntryCachePayload<int64_t>> && __e2,int loopDepth) 
	{
		e2 = std::move(__e2);
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 8, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 8, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 8, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 8, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont2(Optional<TenantEntryCachePayload<int64_t>> const& e3,int loopDepth) 
	{
															#line 312 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!e3.present());
															#line 314 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TenantEntryRemoveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TenantEntryRemoveActorState(); static_cast<TenantEntryRemoveActor*>(this)->destroy(); return 0; }
															#line 4572 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TenantEntryRemoveActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TenantEntryRemoveActorState();
		static_cast<TenantEntryRemoveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2(Optional<TenantEntryCachePayload<int64_t>> && e3,int loopDepth) 
	{
															#line 312 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!e3.present());
															#line 314 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TenantEntryRemoveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TenantEntryRemoveActorState(); static_cast<TenantEntryRemoveActor*>(this)->destroy(); return 0; }
															#line 4586 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TenantEntryRemoveActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TenantEntryRemoveActorState();
		static_cast<TenantEntryRemoveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Optional<TenantEntryCachePayload<int64_t>> const& e3,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(e3, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Optional<TenantEntryCachePayload<int64_t>> && e3,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(e3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state > 0) static_cast<TenantEntryRemoveActor*>(this)->actor_wait_state = 0;
		static_cast<TenantEntryRemoveActor*>(this)->ActorCallback< TenantEntryRemoveActor, 9, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 9, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TenantEntryRemoveActor, 9, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TenantEntryRemoveActor, 9, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	std::vector<TenantMapEntry>* tenantList;
															#line 275 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 283 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	int idx;
															#line 302 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Optional<TenantEntryCachePayload<int64_t>> e;
															#line 304 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Optional<TenantEntryCachePayload<int64_t>> e1;
															#line 306 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Optional<TenantEntryCachePayload<int64_t>> e2;
															#line 4683 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via tenantEntryRemove()
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TenantEntryRemoveActor final : public Actor<Void>, public ActorCallback< TenantEntryRemoveActor, 0, Void >, public ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >, public ActorCallback< TenantEntryRemoveActor, 2, Void >, public ActorCallback< TenantEntryRemoveActor, 3, Void >, public ActorCallback< TenantEntryRemoveActor, 4, Void >, public ActorCallback< TenantEntryRemoveActor, 5, Void >, public ActorCallback< TenantEntryRemoveActor, 6, Optional<TenantEntryCachePayload<int64_t>> >, public ActorCallback< TenantEntryRemoveActor, 7, Optional<TenantEntryCachePayload<int64_t>> >, public ActorCallback< TenantEntryRemoveActor, 8, Optional<TenantEntryCachePayload<int64_t>> >, public ActorCallback< TenantEntryRemoveActor, 9, Optional<TenantEntryCachePayload<int64_t>> >, public FastAllocated<TenantEntryRemoveActor>, public TenantEntryRemoveActorState<TenantEntryRemoveActor> {
															#line 4688 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TenantEntryRemoveActor>::operator new;
	using FastAllocated<TenantEntryRemoveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13568626175250065152UL, 9300582674018251776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantEntryRemoveActor, 0, Void >;
friend struct ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >;
friend struct ActorCallback< TenantEntryRemoveActor, 2, Void >;
friend struct ActorCallback< TenantEntryRemoveActor, 3, Void >;
friend struct ActorCallback< TenantEntryRemoveActor, 4, Void >;
friend struct ActorCallback< TenantEntryRemoveActor, 5, Void >;
friend struct ActorCallback< TenantEntryRemoveActor, 6, Optional<TenantEntryCachePayload<int64_t>> >;
friend struct ActorCallback< TenantEntryRemoveActor, 7, Optional<TenantEntryCachePayload<int64_t>> >;
friend struct ActorCallback< TenantEntryRemoveActor, 8, Optional<TenantEntryCachePayload<int64_t>> >;
friend struct ActorCallback< TenantEntryRemoveActor, 9, Optional<TenantEntryCachePayload<int64_t>> >;
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryRemoveActor(Database const& cx,std::vector<TenantMapEntry>* const& tenantList) 
															#line 4714 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TenantEntryRemoveActorState<TenantEntryRemoveActor>(cx, tenantList),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantEntryRemove", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17717343731958703360UL, 15583944715382393856UL);
		ActorExecutionContextHelper __helper(static_cast<TenantEntryRemoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantEntryRemove");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantEntryRemove", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 1, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 6, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 7, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 8, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TenantEntryRemoveActor, 9, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> tenantEntryRemove( Database const& cx, std::vector<TenantMapEntry>* const& tenantList ) {
															#line 274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TenantEntryRemoveActor(cx, tenantList));
															#line 4755 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 316 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

																#line 4760 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via testCacheWatchRefresh()
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class TestCacheWatchRefreshActor>
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCacheWatchRefreshActorState {
															#line 4766 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCacheWatchRefreshActorState(Database const& cx) 
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx),
															#line 318 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   cache(makeReference<TenantEntryCache<int64_t>>( cx, deterministicRandom()->randomUniqueID(), createPayload, TenantEntryCacheRefreshMode::WATCH))
															#line 4775 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this));

	}
	~TestCacheWatchRefreshActorState() 
	{
		fdb_probe_actor_destroy("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 320 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cache->init(true);
															#line 320 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4792 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 1;
															#line 320 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCacheWatchRefreshActor, 0, Void >*>(static_cast<TestCacheWatchRefreshActor*>(this)));
															#line 4797 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCacheWatchRefreshActorState();
		static_cast<TestCacheWatchRefreshActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 323 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 326 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		name = "TenantEntryCache_WatchRefresh"_sr;
															#line 327 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = TenantAPI::createTenant(cx.getReference(), name);
															#line 327 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 2;
															#line 327 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >*>(static_cast<TestCacheWatchRefreshActor*>(this)));
															#line 4833 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 322 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_EQ(cache->numRefreshByInit(), 1);
															#line 323 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT_GE(cache->numCacheRefreshes(), 1);
															#line 326 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		name = "TenantEntryCache_WatchRefresh"_sr;
															#line 327 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = TenantAPI::createTenant(cx.getReference(), name);
															#line 327 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4850 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 2;
															#line 327 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >*>(static_cast<TestCacheWatchRefreshActor*>(this)));
															#line 4855 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state > 0) static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheWatchRefreshActor*>(this)->ActorCallback< TestCacheWatchRefreshActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheWatchRefreshActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCacheWatchRefreshActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCacheWatchRefreshActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 328 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 330 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		startTime = now();
															#line 331 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		waitUntill = startTime + 300;
															#line 332 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		;
															#line 4945 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> const& __entry,int loopDepth) 
	{
															#line 327 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		entry = __entry;
															#line 4954 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> && __entry,int loopDepth) 
	{
		entry = std::move(__entry);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state > 0) static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheWatchRefreshActor*>(this)->ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 344 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Optional<TenantEntryCachePayload<int64_t>>> __when_expr_3 = cache->getByName(name);
															#line 344 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5035 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 4;
															#line 344 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestCacheWatchRefreshActor, 3, Optional<TenantEntryCachePayload<int64_t>> >*>(static_cast<TestCacheWatchRefreshActor*>(this)));
															#line 5040 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 333 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (cache->numWatchRefreshes() >= 1)
															#line 5056 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 337 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (now() > waitUntill)
															#line 5062 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
															#line 338 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 5066 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		}
															#line 341 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		TraceEvent("TestCacheRefreshWait").detail("Elapsed", now() - startTime);
															#line 342 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->TENANT_ENTRY_CACHE_LIST_REFRESH_INTERVAL);
															#line 342 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5074 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 3;
															#line 342 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCacheWatchRefreshActor, 2, Void >*>(static_cast<TestCacheWatchRefreshActor*>(this)));
															#line 5079 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state > 0) static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheWatchRefreshActor*>(this)->ActorCallback< TestCacheWatchRefreshActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheWatchRefreshActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestCacheWatchRefreshActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestCacheWatchRefreshActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Optional<TenantEntryCachePayload<int64_t>> const& payload,int loopDepth) 
	{
															#line 345 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(payload.present());
															#line 346 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(payload, entry.get());
															#line 347 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCacheWatchRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCacheWatchRefreshActorState(); static_cast<TestCacheWatchRefreshActor*>(this)->destroy(); return 0; }
															#line 5192 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCacheWatchRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCacheWatchRefreshActorState();
		static_cast<TestCacheWatchRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<TenantEntryCachePayload<int64_t>> && payload,int loopDepth) 
	{
															#line 345 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(payload.present());
															#line 346 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		compareTenants(payload, entry.get());
															#line 347 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<TestCacheWatchRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCacheWatchRefreshActorState(); static_cast<TestCacheWatchRefreshActor*>(this)->destroy(); return 0; }
															#line 5208 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<TestCacheWatchRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCacheWatchRefreshActorState();
		static_cast<TestCacheWatchRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Optional<TenantEntryCachePayload<int64_t>> const& payload,int loopDepth) 
	{
		loopDepth = a_body1cont4(payload, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<TenantEntryCachePayload<int64_t>> && payload,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(payload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state > 0) static_cast<TestCacheWatchRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<TestCacheWatchRefreshActor*>(this)->ActorCallback< TestCacheWatchRefreshActor, 3, Optional<TenantEntryCachePayload<int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestCacheWatchRefreshActor, 3, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> const& value) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestCacheWatchRefreshActor, 3, Optional<TenantEntryCachePayload<int64_t>> >*,Optional<TenantEntryCachePayload<int64_t>> && value) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestCacheWatchRefreshActor, 3, Optional<TenantEntryCachePayload<int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 318 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Reference<TenantEntryCache<int64_t>> cache;
															#line 326 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantName name;
															#line 327 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Optional<TenantMapEntry> entry;
															#line 330 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	int64_t startTime;
															#line 331 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	int64_t waitUntill;
															#line 5303 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via testCacheWatchRefresh()
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class TestCacheWatchRefreshActor final : public Actor<Void>, public ActorCallback< TestCacheWatchRefreshActor, 0, Void >, public ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >, public ActorCallback< TestCacheWatchRefreshActor, 2, Void >, public ActorCallback< TestCacheWatchRefreshActor, 3, Optional<TenantEntryCachePayload<int64_t>> >, public FastAllocated<TestCacheWatchRefreshActor>, public TestCacheWatchRefreshActorState<TestCacheWatchRefreshActor> {
															#line 5308 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<TestCacheWatchRefreshActor>::operator new;
	using FastAllocated<TestCacheWatchRefreshActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13560037636278952960UL, 15671842665312589056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCacheWatchRefreshActor, 0, Void >;
friend struct ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >;
friend struct ActorCallback< TestCacheWatchRefreshActor, 2, Void >;
friend struct ActorCallback< TestCacheWatchRefreshActor, 3, Optional<TenantEntryCachePayload<int64_t>> >;
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TestCacheWatchRefreshActor(Database const& cx) 
															#line 5328 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestCacheWatchRefreshActorState<TestCacheWatchRefreshActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2378761038451535616UL, 4589612708188651264UL);
		ActorExecutionContextHelper __helper(static_cast<TestCacheWatchRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCacheWatchRefresh");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCacheWatchRefresh", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCacheWatchRefreshActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCacheWatchRefreshActor, 1, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestCacheWatchRefreshActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestCacheWatchRefreshActor, 3, Optional<TenantEntryCachePayload<int64_t>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testCacheWatchRefresh( Database const& cx ) {
															#line 317 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new TestCacheWatchRefreshActor(cx));
															#line 5363 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 349 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0 && g_network->isSimulated() && BUGGIFY) {
			IKnobCollection::getMutableGlobalKnobCollection().setKnob("tenant_entry_cache_list_refresh_interval",
			                                                          KnobValueRef::create(int{ 2 }));
		}

		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			return _start(cx, this);
		}
		return Void();
	}

																#line 5384 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
template <class _startActor>
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class _startActorState {
															#line 5390 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	_startActorState(Database const& cx,TenantEntryCacheWorkload* const& self) 
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		 : cx(cx),
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   self(self),
															#line 367 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   tenantList(),
															#line 368 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		   refreshMode()
															#line 5403 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 369 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 5418 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			{
															#line 370 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				refreshMode = TenantEntryCacheRefreshMode::PERIODIC_TASK;
															#line 5422 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			}
			else
			{
															#line 372 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
				refreshMode = TenantEntryCacheRefreshMode::WATCH;
															#line 5428 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			}
															#line 375 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			tr = Transaction(cx);
															#line 376 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			configuration = DatabaseConfiguration();
															#line 377 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			;
															#line 5436 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 391 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (configuration.tenantMode == TenantMode::DISABLED)
															#line 5459 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		{
															#line 392 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = testCacheTenantsDisabled(cx);
															#line 392 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5465 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 392 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 5470 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 394 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = testTenantNotFound(cx, refreshMode);
															#line 394 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5479 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when2(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 394 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 5484 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 379 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 380 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 381 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 382 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(configKeys, CLIENT_KNOBS->TOO_MANY);
															#line 382 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5510 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 382 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 5515 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 387 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 387 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5552 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 387 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 5557 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& results,int loopDepth) 
	{
															#line 383 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 384 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		configuration.fromKeyValues((VectorRef<KeyValueRef>)results);
															#line 5574 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && results,int loopDepth) 
	{
															#line 383 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 384 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		configuration.fromKeyValues((VectorRef<KeyValueRef>)results);
															#line 5585 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 403 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5756 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 395 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testCreateTenantsAndLookup(cx, self, &tenantList, refreshMode);
															#line 395 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5857 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 395 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 5862 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 395 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testCreateTenantsAndLookup(cx, self, &tenantList, refreshMode);
															#line 395 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5873 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 395 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 5878 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = testTenantInsert(cx, self, &tenantList, refreshMode);
															#line 396 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5964 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 396 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 5969 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = testTenantInsert(cx, self, &tenantList, refreshMode);
															#line 396 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5980 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 396 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 5985 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 397 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tenantEntryRemove(cx, &tenantList);
															#line 397 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6071 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 397 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 6076 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 397 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tenantEntryRemove(cx, &tenantList);
															#line 397 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6087 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 397 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 6092 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 398 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_7 = testTenantCacheDefaultFunc(cx);
															#line 398 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6178 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 398 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 6183 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 398 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_7 = testTenantCacheDefaultFunc(cx);
															#line 398 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6194 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 398 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 6199 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_8 = testCacheRefresh(cx);
															#line 399 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6285 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 399 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 6290 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 399 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_8 = testCacheRefresh(cx);
															#line 399 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6301 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 399 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 6306 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = testCacheWatchRefresh(cx);
															#line 400 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6392 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 400 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 6397 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_9 = testCacheWatchRefresh(cx);
															#line 400 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6408 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 400 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 6413 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Database cx;
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryCacheWorkload* self;
															#line 367 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	std::vector<TenantMapEntry> tenantList;
															#line 368 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	TenantEntryCacheRefreshMode refreshMode;
															#line 375 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	Transaction tr;
															#line 376 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	DatabaseConfiguration configuration;
															#line 6592 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, RangeResult >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 6597 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13288682797985230848UL, 7378157674826668800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, RangeResult >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	_startActor(Database const& cx,TenantEntryCacheWorkload* const& self) 
															#line 6623 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, TenantEntryCacheWorkload* const& self ) {
															#line 366 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 6664 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TenantEntryCacheWorkload.actor.g.cpp"
}

#line 405 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbserver/workloads/TenantEntryCacheWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<TenantEntryCacheWorkload> TenantEntryCacheWorkloadFactory;