#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
/*
 * dsltest.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <iostream>
#include <algorithm>
#include "flow/FastRef.h"
#undef ERROR
#include "fdbrpc/simulator.h"
#include "fdbrpc/ActorFuzz.h"
#include "flow/DeterministicRandom.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

void* allocateLargePages(int total);

bool testFuzzActor(Future<int> (*actor)(FutureStream<int> const&, PromiseStream<int> const&, Future<Void> const&),
                   const char* desc,
                   std::vector<int> const& expectedOutput) {
	// Run the test 5 times with different "timing"
	int i, outCount;
	bool ok = true;
	for (int trial = 0; trial < 5; trial++) {
		PromiseStream<int> in, out;
		Promise<Void> err;
		int before = deterministicRandom()->randomInt(0, 4);
		int errorBefore = before + deterministicRandom()->randomInt(0, 4);
		// printf("\t\tTrial #%d: %d, %d\n", trial, before, errorBefore);
		if (errorBefore <= before)
			err.sendError(operation_failed());
		for (i = 0; i < before; i++) {
			in.send((i + 1) * 1000);
		}
		Future<int> ret = (*actor)(in.getFuture(), out, err.getFuture());
		while (i < 1000000 && !ret.isReady()) {
			i++;
			if (errorBefore == i)
				err.sendError(operation_failed());
			in.send(i * 1000);
		}
		if (ret.isReady()) {
			if (ret.isError())
				out.send(ret.getError().code());
			else
				out.send(ret.get());
		} else {
			printf("\tERROR: %s did not return after consuming %d input values\n", desc, i);
			if (trial)
				printf("\t\tResult was inconsistent between runs!  (Trial %d)\n", trial);
			ok = false;
			// return false;
		}

		outCount = -1;
		while (out.getFuture().isReady()) {
			int o = out.getFuture().pop();
			outCount++;
			if (outCount < expectedOutput.size() && expectedOutput[outCount] != o) {
				printf("\tERROR: %s output #%d incorrect: %d != expected %d\n",
				       desc,
				       outCount,
				       o,
				       expectedOutput[outCount]);
				if (trial)
					printf("\t\tResult was inconsistent between runs!\n");
				ok = false;
				// return false;
			}
		}
		if (outCount + 1 != expectedOutput.size()) {
			printf(
			    "\tERROR: %s output length incorrect: %d != expected %zu\n", desc, outCount + 1, expectedOutput.size());
			if (trial)
				printf("\t\tResult was inconsistent between runs!\n");
			ok = false;
			// return false;
		}

		// We might have put in values that weren't actually consumed...
		while (in.getFuture().isReady()) {
			in.getFuture().pop();
			i--;
		}
	}
	// printf("\t%s: OK, %d input values -> %d output values\n", desc, i, outCount);
	return ok;
}

#if 0
void memoryTest2() {
	const int Size = 2000 << 20;
	const int Reads = 4 << 20;
	const int MaxThreads = 4;

	char* block = new char[Size];
	memset(block, 0, Size);

	char** random = new char*[ Reads * MaxThreads ];
	random[0] = block;
	for(int i=1; i<Reads*MaxThreads; ) {
		char *s = &block[ deterministicRandom()->randomInt(0, Size) ];
		random[i++] = s;
		/*for(int j=0; j<10 && i<Reads*MaxThreads; j++,i++) {
			random[i] = s + deterministicRandom()->randomInt(0, 4096);
			if (random[i] >= block+Size) random[i] -= Size;
		}*/
	}

	for(int threads=1; threads<=MaxThreads; threads++) {
		double tstart = timer();

		std::vector<ThreadFuture<Void>> done;
		for(int t=0; t<threads; t++) {
			char** r = random + Reads*t;
			done.push_back(
				inThread<Void>( [r,Reads] () -> Void {
					for(int i=0; i<Reads; i++)
						if ( *r[i] )
							std::cout << "Does not happen" << std::endl;
					return Void();
				}));
		}
		waitForAll(done).getBlocking();
		double duration = timer() - tstart;

		std::cout << format("%d threads: %f sec, %0.2fM/sec", threads, duration, Reads*threads/1e6/duration) << std::endl;
	}
}
#endif

enum { MaxTraversalsPerThread = 64 };

void showNumaStatus();
void* numaAllocate(size_t size);

#if 0
void memoryTest() {
	//memoryTest2();
	//return;

	showNumaStatus();

	const int N = 128<<20;	// 128 = 1GB
	const int N2 = 8<<20;
	std::cout << "Preparing memory test with " << N / 1e6 * sizeof(void*) << " MB" << std::endl;
	void **x;
	if (0) {
		std::cout << "  NUMA large pages" << std::endl;
		x = (void**)numaAllocate(size_t(N)*sizeof(void*));
	} else if (1) {
		std::cout << "  Normal pages" << std::endl;
		x = new void*[ N ];
		printf("  at %p\n", x);
	} else {
		std::cout << "  Large pages" << std::endl;
		x = (void**)allocate(N*sizeof(void*), true);
	}
	memset(x, 0, ((int64_t)N) * sizeof(void*));

	showNumaStatus();

	if (1) {
		std::cout <<"  Random permutation" << std::endl;
		// Random cyclic permutation
		for(int i=0; i<N; i++)
			x[i] = &x[i];
		// Sattolo's algorithm
		for(int n = N-1; n >= 1; n--) {
			int k = deterministicRandom()->randomInt(0, n);  //random.IRandomX(0, n-1);
			std::swap( x[k], x[n] );
		}
	} else {
		std::cout <<"  Sequential permutation" << std::endl;
		// Sequential
		for(int i=0; i<N-1; i++)
			x[i] = &x[i+1];
		x[N-1] = &x[0];
	}
	void **p = x;
	for(int i=0; i<N; i++) {
		p = (void**)*p;
		if (p == x) {
			std::cout << "Cycle " << i << std::endl;
			if (i != N-1) terminate();
		}
	}

	const int MT = 16;
	for(int TraversalsPerThread = 1; TraversalsPerThread <= MaxTraversalsPerThread; TraversalsPerThread *= 2)
	{
		const int PseudoThreads = MT * TraversalsPerThread;
		void **starts[MT*MaxTraversalsPerThread];
		for(int t=0; t<PseudoThreads; t++) {
			starts[t] = &x[ N/PseudoThreads * t ];
			//starts[t] = &x[ deterministicRandom()->randomInt(0,N) ];
		}
		for(int T=1; T<=MT; T+=T) {
			double start = timer();
			std::vector< Future<double> > done;
			for(int t=0; t<T; t++) {
				void*** start = starts + t*TraversalsPerThread;
				done.push_back(
					inThread<double>( [start,N2,TraversalsPerThread] () -> double {
						void **p[MaxTraversalsPerThread];
						for(int j=0; j<TraversalsPerThread; j++)
							p[j] = start[j];
						for(int i=0; i<N2; i++)
							for(int j=0; j<TraversalsPerThread; j++) {
								p[j] = (void**)*p[j];
								if (TraversalsPerThread > 1)
									_mm_prefetch( (const char*)p[j], _MM_HINT_T0 );
							}
						for(int j=0; j<TraversalsPerThread; j++)
							if (p[j] == p[(j+1)%TraversalsPerThread])
								std::cout << "N";
						return timer();
					}));
			}
			double firstEnd = 1e30;
			for(int t=0; t<T; t++) {
				done[t].getBlocking();
				firstEnd = std::min(firstEnd, done[t].get());
			}
			double end = timer();
			printf("  %2dx%2d traversals: %5.3fs, %6.1f M/sec, %4.1f%%\n", T, (int)TraversalsPerThread, end-start,
				N2 / 1e6 * (T*TraversalsPerThread) / (end-start),
				(firstEnd-start)/(end-start)*100.0);
		}
	}

	//delete[] x;	// TODO: Free large pages
}
#endif

															#line 253 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via addN()
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <int N, class X, class AddNActor>
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class AddNActorState {
															#line 260 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	AddNActorState(Future<X> const& in) 
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : in(in)
															#line 267 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("addN", reinterpret_cast<unsigned long>(this));

	}
	~AddNActorState() 
	{
		fdb_probe_actor_destroy("addN", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<X> __when_expr_0 = in;
															#line 253 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<AddNActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 284 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddNActor*>(this)->actor_wait_state = 1;
															#line 253 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddNActor, 0, X >*>(static_cast<AddNActor*>(this)));
															#line 289 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddNActorState();
		static_cast<AddNActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(X const& i,int loopDepth) 
	{
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<AddNActor*>(this)->SAV<X>::futures) { (void)(i + N); this->~AddNActorState(); static_cast<AddNActor*>(this)->destroy(); return 0; }
															#line 312 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<AddNActor*>(this)->SAV< X >::value()) X(i + N);
		this->~AddNActorState();
		static_cast<AddNActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(X && i,int loopDepth) 
	{
															#line 254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<AddNActor*>(this)->SAV<X>::futures) { (void)(i + N); this->~AddNActorState(); static_cast<AddNActor*>(this)->destroy(); return 0; }
															#line 324 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<AddNActor*>(this)->SAV< X >::value()) X(i + N);
		this->~AddNActorState();
		static_cast<AddNActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(X const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(X && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddNActor*>(this)->actor_wait_state > 0) static_cast<AddNActor*>(this)->actor_wait_state = 0;
		static_cast<AddNActor*>(this)->ActorCallback< AddNActor, 0, X >::remove();

	}
	void a_callback_fire(ActorCallback< AddNActor, 0, X >*,X const& value) 
	{
		fdb_probe_actor_enter("addN", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddNActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addN", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddNActor, 0, X >*,X && value) 
	{
		fdb_probe_actor_enter("addN", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddNActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addN", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddNActor, 0, X >*,Error err) 
	{
		fdb_probe_actor_enter("addN", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddNActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addN", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<X> in;
															#line 409 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via addN()
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <int N, class X>
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class AddNActor final : public Actor<X>, public ActorCallback< AddNActor<N, X>, 0, X >, public FastAllocated<AddNActor<N, X>>, public AddNActorState<N, X, AddNActor<N, X>> {
															#line 416 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<AddNActor<N, X>>::operator new;
	using FastAllocated<AddNActor<N, X>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15064233915219271424UL, 3959011479537613056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<X>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddNActor<N, X>, 0, X >;
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	AddNActor(Future<X> const& in) 
															#line 433 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<X>(),
		   AddNActorState<N, X, AddNActor<N, X>>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addN", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1435848765005305600UL, 2470854859034748416UL);
		ActorExecutionContextHelper __helper(static_cast<AddNActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addN");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addN", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddNActor<N, X>, 0, X >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <int N, class X>
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<X> addN( Future<X> const& in ) {
															#line 251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<X>(new AddNActor<N, X>(in));
															#line 468 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 256 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 473 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via switchTest()
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class A, class B, class SwitchTestActor>
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class SwitchTestActorState {
															#line 480 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	SwitchTestActorState(FutureStream<A> const& as,Future<B> const& oneb) 
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : as(as),
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   oneb(oneb)
															#line 489 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("switchTest", reinterpret_cast<unsigned long>(this));

	}
	~SwitchTestActorState() 
	{
		fdb_probe_actor_destroy("switchTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 259 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 504 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SwitchTestActorState();
		static_cast<SwitchTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 268 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		for(;;) {
															#line 269 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			std::cout << "Done!" << std::endl;
															#line 270 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<SwitchTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchTestActorState(); static_cast<SwitchTestActor*>(this)->destroy(); return 0; }
															#line 531 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<SwitchTestActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SwitchTestActorState();
			static_cast<SwitchTestActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 260 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		auto __when_expr_0 = as;
															#line 551 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<A>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<A>>::value, "invalid type");
															#line 259 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<SwitchTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 555 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 263 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		StrictFuture<B> __when_expr_1 = oneb;
															#line 559 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<SwitchTestActor*>(this)->actor_wait_state = 1;
															#line 260 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< SwitchTestActor, 0, A >*>(static_cast<SwitchTestActor*>(this)));
															#line 263 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SwitchTestActor, 1, B >*>(static_cast<SwitchTestActor*>(this)));
															#line 566 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(A const& a,int loopDepth) 
	{
															#line 261 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		std::cout << "A " << a << std::endl;
															#line 594 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(A && a,int loopDepth) 
	{
															#line 261 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		std::cout << "A " << a << std::endl;
															#line 603 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(B const& b,int loopDepth) 
	{
															#line 264 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		std::cout << "B " << b << std::endl;
															#line 612 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(B && b,int loopDepth) 
	{
															#line 264 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		std::cout << "B " << b << std::endl;
															#line 621 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SwitchTestActor*>(this)->actor_wait_state > 0) static_cast<SwitchTestActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchTestActor*>(this)->ActorSingleCallback< SwitchTestActor, 0, A >::remove();
		static_cast<SwitchTestActor*>(this)->ActorCallback< SwitchTestActor, 1, B >::remove();

	}
	void a_callback_fire(ActorSingleCallback< SwitchTestActor, 0, A >*,A const& value) 
	{
		fdb_probe_actor_enter("switchTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< SwitchTestActor, 0, A >*,A && value) 
	{
		fdb_probe_actor_enter("switchTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< SwitchTestActor, 0, A >*,Error err) 
	{
		fdb_probe_actor_enter("switchTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SwitchTestActor, 1, B >*,B const& value) 
	{
		fdb_probe_actor_enter("switchTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SwitchTestActor, 1, B >*,B && value) 
	{
		fdb_probe_actor_enter("switchTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SwitchTestActor, 1, B >*,Error err) 
	{
		fdb_probe_actor_enter("switchTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchTest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	FutureStream<A> as;
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<B> oneb;
															#line 751 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via switchTest()
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class A, class B>
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class SwitchTestActor final : public Actor<Void>, public ActorSingleCallback< SwitchTestActor<A, B>, 0, A >, public ActorCallback< SwitchTestActor<A, B>, 1, B >, public FastAllocated<SwitchTestActor<A, B>>, public SwitchTestActorState<A, B, SwitchTestActor<A, B>> {
															#line 758 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<SwitchTestActor<A, B>>::operator new;
	using FastAllocated<SwitchTestActor<A, B>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13983584448394889216UL, 13458503668549053952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< SwitchTestActor<A, B>, 0, A >;
friend struct ActorCallback< SwitchTestActor<A, B>, 1, B >;
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	SwitchTestActor(FutureStream<A> const& as,Future<B> const& oneb) 
															#line 776 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   SwitchTestActorState<A, B, SwitchTestActor<A, B>>(as, oneb),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("switchTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15803442214888456704UL, 3224439254595557632UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("switchTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("switchTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< SwitchTestActor<A, B>, 0, A >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class A, class B>
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> switchTest( FutureStream<A> const& as, Future<B> const& oneb ) {
															#line 257 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new SwitchTestActor<A, B>(as, oneb));
															#line 811 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 273 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

class TestBuffer : public ReferenceCounted<TestBuffer> {
public:
	static TestBuffer* create(int length) {
#if defined(__INTEL_COMPILER)
		return new TestBuffer(length);
#else
		auto b = (TestBuffer*)new int[(length + 7) / 4];
		new (b) TestBuffer(length);
		return b;
#endif
	}
#if !defined(__INTEL_COMPILER)
	void operator delete(void* buf) {
		std::cout << "Freeing buffer" << std::endl;
		delete[] (int*)buf;
	}
#endif

	int size() const { return length; }
	uint8_t* begin() { return data; }
	uint8_t* end() { return data + length; }
	const uint8_t* begin() const { return data; }
	const uint8_t* end() const { return data + length; }

private:
	TestBuffer(int length) noexcept : length(length) {}
	int length;
	uint8_t data[1];
};

int fastKeyCount = 0;

class FastKey : public FastAllocated<FastKey>, public ReferenceCounted<FastKey> {
public:
	FastKey() : length(0) {}
	FastKey(char* b, int length) : length(length) {
		ASSERT(length <= sizeof(data));
		memcpy(data, b, length);
	}
	~FastKey() { fastKeyCount++; }
	int size() const { return length; }
	uint8_t* begin() { return data; }
	uint8_t* end() { return data + length; }
	const uint8_t* begin() const { return data; }
	const uint8_t* end() const { return data + length; }

private:
	int length;
	uint8_t data[252];
};

struct TestB : FastAllocated<TestB> {
	char x[65];
};

void fastAllocTest() {
	double t;

	std::vector<void*> d;
	for (int i = 0; i < 1000000; i++) {
		d.push_back(FastAllocator<64>::allocate());
		int r = deterministicRandom()->randomInt(0, 1000000);
		if (r < d.size()) {
			FastAllocator<64>::release(d[r]);
			d[r] = d.back();
			d.pop_back();
		}
	}
	std::sort(d.begin(), d.end());
	if (std::unique(d.begin(), d.end()) != d.end())
		std::cout << "Pointer returned twice!?" << std::endl;

	for (int i = 0; i < 2; i++) {
		void* p = FastAllocator<64>::allocate();
		void* q = FastAllocator<64>::allocate();
		std::cout << (intptr_t)p << " " << (intptr_t)q << std::endl;
		FastAllocator<64>::release(p);
		FastAllocator<64>::release(q);
	}

	t = timer();
	for (int i = 0; i < 1000000; i++)
		(void)FastAllocator<64>::allocate();
	t = timer() - t;
	std::cout << "Allocations: " << (1 / t) << "M/sec" << std::endl;

	t = timer();
	for (int i = 0; i < 1000000; i++)
		FastAllocator<64>::release(FastAllocator<64>::allocate());
	t = timer() - t;
	std::cout << "Allocate/Release pairs: " << (1 / t) << "M/sec" << std::endl;

	t = timer();
	void* pp[100];
	for (int i = 0; i < 10000; i++) {
		for (int j = 0; j < 100; j++)
			pp[j] = FastAllocator<64>::allocate();
		for (int j = 0; j < 100; j++)
			FastAllocator<64>::release(pp[j]);
	}
	t = timer() - t;
	std::cout << "Allocate/Release interleaved(100): " << (1 / t) << "M/sec" << std::endl;

	t = timer();
	for (int i = 0; i < 1000000; i++)
		delete new TestB;
	t = timer() - t;
	std::cout << "Allocate/Release TestB pairs: " << (1 / t) << "M/sec" << std::endl;

#if FLOW_THREAD_SAFE
	t = timer();
	std::vector<Future<bool>> results;
	for (int i = 0; i < 4; i++)
		results.push_back(inThread<bool>([]() -> bool {
			TestB* pp[100];
			for (int i = 0; i < 10000; i++) {
				for (int j = 0; j < 100; j++)
					pp[j] = new TestB;
				for (int j = 0; j < 100; j++)
					delete pp[j];
			}
			return true;
		}));
	waitForAll(results).getBlocking();
	t = timer() - t;
	std::cout << "Threaded Allocate/Release TestB interleaved (100): " << results.size() << " x " << (1 / t) << "M/sec"
	          << std::endl;
#endif

	volatile int32_t v = 0;

	t = timer();
	for (int i = 0; i < 10000000; i++)
		interlockedIncrement(&v);
	t = timer() - t;
	std::cout << "interlocked increment: " << 10.0 / t << "M/sec " << v << std::endl;

	v = 5;
	t = timer();
	for (int i = 0; i < 10000000; i++) {
		interlockedCompareExchange(&v, 5, 5);
	}
	t = timer() - t;
	std::cout << "1 state machine: " << 10.0 / t << "M/sec " << v << std::endl;

	v = 0;
	t = timer();
	for (int i = 0; i < 10000000; i++)
		v++;
	t = timer() - t;
	std::cout << "volatile increment: " << 10.0 / t << "M/sec " << v << std::endl;

	{
		Reference<TestBuffer> b(TestBuffer::create(1000));
		memcpy(b->begin(), "Hello, world!", 14);

		t = timer();
		for (int i = 0; i < 10000000; i++) {
			Reference<TestBuffer> r = std::move(b);
			b = std::move(r);
		}
		t = timer() - t;
		std::cout << "move Reference<Buffer>: " << 10.0 / t << "M/sec " << std::endl;

		t = timer();
		for (int i = 0; i < 10000000; i++) {
			Reference<TestBuffer> r = b;
		}
		t = timer() - t;
		std::cout << "copy (1) Reference<Buffer>: " << 10.0 / t << "M/sec " << std::endl;

		Reference<TestBuffer> c = b;
		t = timer();
		for (int i = 0; i < 10000000; i++) {
			Reference<TestBuffer> r = b;
		}
		t = timer() - t;
		std::cout << "copy (2) Reference<Buffer>: " << 10.0 / t << "M/sec " << std::endl;

		std::cout << (const char*)b->begin() << std::endl;
	}
	t = timer();
	for (int i = 0; i < 10000000; i++) {
		delete new FastKey;
	}
	t = timer() - t;
	std::cout << "delete new FastKey: " << 10.0 / t << "M/sec " << fastKeyCount << std::endl;

	t = timer();
	for (int i = 0; i < 10000000; i++) {
		Reference<FastKey> r(new FastKey);
	}
	t = timer() - t;
	std::cout << "new Reference<FastKey>: " << 10.0 / t << "M/sec " << fastKeyCount << std::endl;
}

template <class PromiseT>
Future<Void> threadSafetySender(std::vector<PromiseT>& v, Event& start, Event& ready, int iterations) {
	for (int i = 0; i < iterations; i++) {
		start.block();
		if (v.size() == 0)
			return Void();
		for (int i = 0; i < v.size(); i++)
			v[i].send(Void());
		ready.set();
	}
	return Void();
}

															#line 1025 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via threadSafetyWaiter()
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ThreadSafetyWaiterActor>
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ThreadSafetyWaiterActorState {
															#line 1032 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ThreadSafetyWaiterActorState(Future<Void> const& f,int32_t* const& count) 
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : f(f),
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   count(count)
															#line 1041 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("threadSafetyWaiter", reinterpret_cast<unsigned long>(this));

	}
	~ThreadSafetyWaiterActorState() 
	{
		fdb_probe_actor_destroy("threadSafetyWaiter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 484 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 484 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1058 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			static_cast<ThreadSafetyWaiterActor*>(this)->actor_wait_state = 1;
															#line 484 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThreadSafetyWaiterActor, 0, Void >*>(static_cast<ThreadSafetyWaiterActor*>(this)));
															#line 1062 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ThreadSafetyWaiterActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		interlockedIncrement(count);
															#line 1084 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		interlockedIncrement(count);
															#line 1093 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThreadSafetyWaiterActor*>(this)->actor_wait_state > 0) static_cast<ThreadSafetyWaiterActor*>(this)->actor_wait_state = 0;
		static_cast<ThreadSafetyWaiterActor*>(this)->ActorCallback< ThreadSafetyWaiterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThreadSafetyWaiterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThreadSafetyWaiterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThreadSafetyWaiterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThreadSafetyWaiterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThreadSafetyWaiterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThreadSafetyWaiterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		delete static_cast<ThreadSafetyWaiterActor*>(this);
															#line 1177 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<Void> f;
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int32_t* count;
															#line 1186 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via threadSafetyWaiter()
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ThreadSafetyWaiterActor final : public Actor<void>, public ActorCallback< ThreadSafetyWaiterActor, 0, Void >, public FastAllocated<ThreadSafetyWaiterActor>, public ThreadSafetyWaiterActorState<ThreadSafetyWaiterActor> {
															#line 1191 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ThreadSafetyWaiterActor>::operator new;
	using FastAllocated<ThreadSafetyWaiterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15131683634961014784UL, 8769298927102336512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< ThreadSafetyWaiterActor, 0, Void >;
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ThreadSafetyWaiterActor(Future<Void> const& f,int32_t* const& count) 
															#line 1208 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<void>(),
		   ThreadSafetyWaiterActorState<ThreadSafetyWaiterActor>(f, count),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16827526791222020096UL, 1156095043395891968UL);
		ActorExecutionContextHelper __helper(static_cast<ThreadSafetyWaiterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("threadSafetyWaiter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
void threadSafetyWaiter( Future<Void> const& f, int32_t* const& count ) {
															#line 483 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	new ThreadSafetyWaiterActor(f, count);
															#line 1232 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 1236 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via threadSafetyWaiter()
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ThreadSafetyWaiterActor1>
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ThreadSafetyWaiterActor1State {
															#line 1243 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ThreadSafetyWaiterActor1State(FutureStream<Void> const& f,int const& n,int32_t* const& count) 
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : f(f),
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   n(n),
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   count(count)
															#line 1254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("threadSafetyWaiter", reinterpret_cast<unsigned long>(this));

	}
	~ThreadSafetyWaiterActor1State() 
	{
		fdb_probe_actor_destroy("threadSafetyWaiter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 488 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 1269 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ThreadSafetyWaiterActor1*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 488 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!(n--))
															#line 1304 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 489 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		auto __when_expr_0 = f;
															#line 1310 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Void>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Void>>::value, "invalid type");
															#line 489 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 1314 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_cast<ThreadSafetyWaiterActor1*>(this)->actor_wait_state = 1;
															#line 489 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ThreadSafetyWaiterActor1, 0, Void >*>(static_cast<ThreadSafetyWaiterActor1*>(this)));
															#line 1318 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 490 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		interlockedIncrement(count);
															#line 1340 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 490 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		interlockedIncrement(count);
															#line 1349 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThreadSafetyWaiterActor1*>(this)->actor_wait_state > 0) static_cast<ThreadSafetyWaiterActor1*>(this)->actor_wait_state = 0;
		static_cast<ThreadSafetyWaiterActor1*>(this)->ActorSingleCallback< ThreadSafetyWaiterActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ThreadSafetyWaiterActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThreadSafetyWaiterActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ThreadSafetyWaiterActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThreadSafetyWaiterActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ThreadSafetyWaiterActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThreadSafetyWaiterActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		delete static_cast<ThreadSafetyWaiterActor1*>(this);
															#line 1433 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	FutureStream<Void> f;
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int n;
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int32_t* count;
															#line 1444 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via threadSafetyWaiter()
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ThreadSafetyWaiterActor1 final : public Actor<void>, public ActorSingleCallback< ThreadSafetyWaiterActor1, 0, Void >, public FastAllocated<ThreadSafetyWaiterActor1>, public ThreadSafetyWaiterActor1State<ThreadSafetyWaiterActor1> {
															#line 1449 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ThreadSafetyWaiterActor1>::operator new;
	using FastAllocated<ThreadSafetyWaiterActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15131683634961014784UL, 8769298927102336512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ThreadSafetyWaiterActor1, 0, Void >;
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ThreadSafetyWaiterActor1(FutureStream<Void> const& f,int const& n,int32_t* const& count) 
															#line 1466 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<void>(),
		   ThreadSafetyWaiterActor1State<ThreadSafetyWaiterActor1>(f, n, count),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6398332711858098944UL, 10299461065221792000UL);
		ActorExecutionContextHelper __helper(static_cast<ThreadSafetyWaiterActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("threadSafetyWaiter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("threadSafetyWaiter", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
void threadSafetyWaiter( FutureStream<Void> const& f, int const& n, int32_t* const& count ) {
															#line 487 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	new ThreadSafetyWaiterActor1(f, n, count);
															#line 1490 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 493 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

#if 0
void threadSafetyTest() {
	double t = timer();

	int N = 10000, V = 100;

	std::vector<Promise<Void>> v;
	Event start, ready;
	Future<Void> sender = inThread<Void>( [&] { return threadSafetySender( v, start, ready, N ); } );

	for(int i=0; i<N; i++) {
		v.clear();
		for (int j = 0; j < V; j++)
			v.push_back(Promise<Void>());
		std::vector<Future<Void>> f( v.size() );
		for(int i=0; i<v.size(); i++)
			f[i] = v[i].getFuture();
		std::random_shuffle( f.begin(), f.end() );

		start.set();
		int32_t count = 0;
		for(int i=0; i<f.size(); i++)
			threadSafetyWaiter( f[i], &count );
		ready.block();

		if (count != V)
			std::cout << "Thread safety error: " << count << std::endl;
	}

	t = timer()-t;
	std::cout << "Thread safety test (2t): " << (V*N/1e6/t) << "M/sec" << std::endl;
}

void threadSafetyTest2() {
	double t = timer();

	int N = 1000, V = 100;

	// std::vector<PromiseStream<Void>> streams( 100 );
	std::vector<PromiseStream<Void>> streams;
	for (int i = 0; i < 100; i++)
		streams.push_back(PromiseStream<Void>());
	std::vector<PromiseStream<Void>> v;
	Event start, ready;
	Future<Void> sender = inThread<Void>( [&] { return threadSafetySender( v, start, ready, N ); } );

	for(int i=0; i<N; i++) {
		std::vector<int> counts( streams.size() );
		v.clear();
		for(int k=0; k<V; k++) {
			int i = deterministicRandom()->randomInt(0, (int)streams.size());
			counts[i]++;
			v.push_back( streams[i] );
		}

		start.set();
		int32_t count = 0;
		for(int i=0; i<streams.size(); i++)
			threadSafetyWaiter( streams[i].getFuture(), counts[i], &count );
		ready.block();

		if (count != V)
			std::cout << "Thread safety error: " << count << std::endl;
	}

	t = timer()-t;
	std::cout << "Thread safety test 2 (2t): " << (V*N/1e6/t) << "M/sec" << std::endl;
}

volatile int32_t cancelled = 0, returned = 0;

															#line 1566 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via returnCancelRacer()
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ReturnCancelRacerActor>
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ReturnCancelRacerActorState {
															#line 1573 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ReturnCancelRacerActorState(Future<Void> const& f) 
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : f(f)
															#line 1580 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("returnCancelRacer", reinterpret_cast<unsigned long>(this));

	}
	~ReturnCancelRacerActorState() 
	{
		fdb_probe_actor_destroy("returnCancelRacer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 567 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				StrictFuture<Void> __when_expr_0 = f;
															#line 567 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				if (static_cast<ReturnCancelRacerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1598 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReturnCancelRacerActor*>(this)->actor_wait_state = 1;
															#line 567 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReturnCancelRacerActor, 0, Void >*>(static_cast<ReturnCancelRacerActor*>(this)));
															#line 1603 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReturnCancelRacerActorState();
		static_cast<ReturnCancelRacerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 572 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		interlockedIncrement( &returned );
															#line 573 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<ReturnCancelRacerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReturnCancelRacerActorState(); static_cast<ReturnCancelRacerActor*>(this)->destroy(); return 0; }
															#line 1634 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<ReturnCancelRacerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReturnCancelRacerActorState();
		static_cast<ReturnCancelRacerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 569 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			interlockedIncrement( &cancelled );
															#line 570 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			return a_body1Catch1(__current_error, loopDepth);
															#line 1649 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReturnCancelRacerActor*>(this)->actor_wait_state > 0) static_cast<ReturnCancelRacerActor*>(this)->actor_wait_state = 0;
		static_cast<ReturnCancelRacerActor*>(this)->ActorCallback< ReturnCancelRacerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReturnCancelRacerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("returnCancelRacer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnCancelRacerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnCancelRacer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReturnCancelRacerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("returnCancelRacer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnCancelRacerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnCancelRacer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReturnCancelRacerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("returnCancelRacer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnCancelRacerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnCancelRacer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<Void> f;
															#line 1761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via returnCancelRacer()
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ReturnCancelRacerActor final : public Actor<Void>, public ActorCallback< ReturnCancelRacerActor, 0, Void >, public FastAllocated<ReturnCancelRacerActor>, public ReturnCancelRacerActorState<ReturnCancelRacerActor> {
															#line 1766 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ReturnCancelRacerActor>::operator new;
	using FastAllocated<ReturnCancelRacerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9381914040025034752UL, 10142761103719985920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReturnCancelRacerActor, 0, Void >;
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ReturnCancelRacerActor(Future<Void> const& f) 
															#line 1783 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   ReturnCancelRacerActorState<ReturnCancelRacerActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("returnCancelRacer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5487656696528910592UL, 16603793646020625408UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnCancelRacerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("returnCancelRacer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("returnCancelRacer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReturnCancelRacerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> returnCancelRacer( Future<Void> const& f ) {
															#line 565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new ReturnCancelRacerActor(f));
															#line 1816 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 575 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

void returnCancelRaceTest() {
	int N = 100, M = 100;
	for(int i=0; i<N; i++) {
		std::vector< Promise<Void> > promises;
		std::vector< Future<Void> > futures;
		for(int i=0; i < M; i++) {
			promises.push_back( Promise<Void>() );
			futures.push_back( returnCancelRacer( promises.back().getFuture() ) );
		}
		std::random_shuffle( futures.begin(), futures.end() );

		// FIXME: Doesn't work as written with auto-reset
		// events. Probably not particularly racy as written. Test may
		// FAIL or PASS at whim.

		Event ev1, ev2;
		ThreadFuture<Void> b = inThread<Void>( [&] ()->Void {
			ev1.block();
			for(int i=0; i<promises.size(); i++)
				futures[i] = Future<Void>();
			return Void();
		} );
		ThreadFuture<Void> a = inThread<Void>([&]()->Void {
			ev2.block();
			for(int i=0; i<promises.size(); i++) {
				promises[i].send(Void());
				for( volatile int32_t dummy = 0; dummy < 10; dummy ++ );
			}
			return Void();
		} );
		ev1.set(); ev2.set();
		a.getBlocking();
		b.getBlocking();
	}

	bool ok = cancelled && returned && cancelled+returned == N*M;
	printf("ReturnCancelRaceTest: %s\n", ok ? "PASS" : "FAIL");
	printf("  %d cancelled, %d returned\n", cancelled, returned);
}
#endif

															#line 1862 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via chooseTest()
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ChooseTestActor>
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ChooseTestActorState {
															#line 1869 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ChooseTestActorState(Future<int> const& a,Future<int> const& b) 
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : a(a),
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   b(b)
															#line 1878 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("chooseTest", reinterpret_cast<unsigned long>(this));

	}
	~ChooseTestActorState() 
	{
		fdb_probe_actor_destroy("chooseTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 619 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<int> __when_expr_0 = a;
															#line 618 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<ChooseTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1895 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 622 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<int> __when_expr_1 = b;
															#line 1899 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ChooseTestActor*>(this)->actor_wait_state = 1;
															#line 619 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChooseTestActor, 0, int >*>(static_cast<ChooseTestActor*>(this)));
															#line 622 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChooseTestActor, 1, int >*>(static_cast<ChooseTestActor*>(this)));
															#line 1906 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChooseTestActorState();
		static_cast<ChooseTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& A,int loopDepth) 
	{
															#line 620 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<ChooseTestActor*>(this)->SAV<int>::futures) { (void)(A); this->~ChooseTestActorState(); static_cast<ChooseTestActor*>(this)->destroy(); return 0; }
															#line 1929 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<ChooseTestActor*>(this)->SAV< int >::value()) int(A);
		this->~ChooseTestActorState();
		static_cast<ChooseTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int && A,int loopDepth) 
	{
															#line 620 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<ChooseTestActor*>(this)->SAV<int>::futures) { (void)(A); this->~ChooseTestActorState(); static_cast<ChooseTestActor*>(this)->destroy(); return 0; }
															#line 1941 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<ChooseTestActor*>(this)->SAV< int >::value()) int(A);
		this->~ChooseTestActorState();
		static_cast<ChooseTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(int const& B,int loopDepth) 
	{
															#line 623 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<ChooseTestActor*>(this)->SAV<int>::futures) { (void)(B); this->~ChooseTestActorState(); static_cast<ChooseTestActor*>(this)->destroy(); return 0; }
															#line 1953 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<ChooseTestActor*>(this)->SAV< int >::value()) int(B);
		this->~ChooseTestActorState();
		static_cast<ChooseTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(int && B,int loopDepth) 
	{
															#line 623 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<ChooseTestActor*>(this)->SAV<int>::futures) { (void)(B); this->~ChooseTestActorState(); static_cast<ChooseTestActor*>(this)->destroy(); return 0; }
															#line 1965 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<ChooseTestActor*>(this)->SAV< int >::value()) int(B);
		this->~ChooseTestActorState();
		static_cast<ChooseTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChooseTestActor*>(this)->actor_wait_state > 0) static_cast<ChooseTestActor*>(this)->actor_wait_state = 0;
		static_cast<ChooseTestActor*>(this)->ActorCallback< ChooseTestActor, 0, int >::remove();
		static_cast<ChooseTestActor*>(this)->ActorCallback< ChooseTestActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< ChooseTestActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("chooseTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTestActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("chooseTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChooseTestActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTestActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("chooseTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChooseTestActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("chooseTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChooseTestActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> a;
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> b;
															#line 2098 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via chooseTest()
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ChooseTestActor final : public Actor<int>, public ActorCallback< ChooseTestActor, 0, int >, public ActorCallback< ChooseTestActor, 1, int >, public FastAllocated<ChooseTestActor>, public ChooseTestActorState<ChooseTestActor> {
															#line 2103 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ChooseTestActor>::operator new;
	using FastAllocated<ChooseTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17801605133329215488UL, 7650776241446542592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChooseTestActor, 0, int >;
friend struct ActorCallback< ChooseTestActor, 1, int >;
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ChooseTestActor(Future<int> const& a,Future<int> const& b) 
															#line 2121 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<int>(),
		   ChooseTestActorState<ChooseTestActor>(a, b),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chooseTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7786956580723553280UL, 2513088330377171456UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chooseTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chooseTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChooseTestActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<int> chooseTest( Future<int> const& a, Future<int> const& b ) {
															#line 617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<int>(new ChooseTestActor(a, b));
															#line 2154 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 627 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

void showArena(ArenaBlock* a, ArenaBlock* parent) {
	printf("ArenaBlock %p (<-%p): %d bytes, %d refs\n", a, parent, a->size(), a->debugGetReferenceCount());
	if (!a->isTiny()) {
		int o = a->nextBlockOffset;
		while (o) {
			ArenaBlockRef* r = (ArenaBlockRef*)((char*)a->getData() + o);

			// If alignedBuffer is valid then print its pointer and size, else recurse
			if (r->aligned4kBufferSize != 0) {
				printf("AlignedBuffer %p (<-%p) %u bytes\n", r->aligned4kBuffer, a, r->aligned4kBufferSize);
			} else {
				showArena(r->next, a);
			}

			o = r->nextBlockOffset;
		}
	}
}

void arenaTest() {
	BinaryWriter wr(AssumeVersion(g_network->protocolVersion()));
	{
		Arena arena;
		VectorRef<StringRef> test;
		test.push_back(arena, StringRef(arena, "Hello"_sr));
		test.push_back(arena, StringRef(arena, ", "_sr));
		test.push_back(arena, StringRef(arena, "World!"_sr));

		for (auto i = test.begin(); i != test.end(); ++i)
			for (auto j = i->begin(); j != i->end(); ++j)
				std::cout << *j;
		std::cout << std::endl;

		wr << test;
	}
	{
		Arena arena2;
		VectorRef<StringRef> test2;
		BinaryReader reader(wr.getData(), wr.getLength(), AssumeVersion(g_network->protocolVersion()));
		reader >> test2 >> arena2;

		for (auto i = test2.begin(); i != test2.end(); ++i)
			for (auto j = i->begin(); j != i->end(); ++j)
				std::cout << *j;
		std::cout << std::endl;
	}

	double t = timer();
	for (int i = 0; i < 100; i++) {
		Arena ar;
		for (int i = 0; i < 10000000; i++)
			new (ar) char[10];
	}
	printf("100 x 10M x 10B allocated+freed from Arenas: %f sec\n", timer() - t);

	// printf("100M x 8bytes allocations: %d bytes used\n", 0);//ar.getSize());
	// showArena( ar.impl.getPtr(), 0 );
};

															#line 2218 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via testStream()
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class TestStreamActor>
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class TestStreamActorState {
															#line 2225 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	TestStreamActorState(FutureStream<int> const& xs) 
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : xs(xs)
															#line 2232 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("testStream", reinterpret_cast<unsigned long>(this));

	}
	~TestStreamActorState() 
	{
		fdb_probe_actor_destroy("testStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 688 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 2247 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TestStreamActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 689 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		auto __when_expr_0 = xs;
															#line 2276 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<int>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<int>>::value, "invalid type");
															#line 689 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 2280 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_cast<TestStreamActor*>(this)->actor_wait_state = 1;
															#line 689 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TestStreamActor, 0, int >*>(static_cast<TestStreamActor*>(this)));
															#line 2284 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int const& x,int loopDepth) 
	{
															#line 690 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		std::cout << x << std::endl;
															#line 2293 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int && x,int loopDepth) 
	{
															#line 690 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		std::cout << x << std::endl;
															#line 2302 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestStreamActor*>(this)->actor_wait_state > 0) static_cast<TestStreamActor*>(this)->actor_wait_state = 0;
		static_cast<TestStreamActor*>(this)->ActorSingleCallback< TestStreamActor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TestStreamActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("testStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TestStreamActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("testStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TestStreamActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("testStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testStream", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	FutureStream<int> xs;
															#line 2384 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via testStream()
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class TestStreamActor final : public Actor<void>, public ActorSingleCallback< TestStreamActor, 0, int >, public FastAllocated<TestStreamActor>, public TestStreamActorState<TestStreamActor> {
															#line 2389 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<TestStreamActor>::operator new;
	using FastAllocated<TestStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15314550873488640256UL, 3173928444795508992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TestStreamActor, 0, int >;
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	TestStreamActor(FutureStream<int> const& xs) 
															#line 2406 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<void>(),
		   TestStreamActorState<TestStreamActor>(xs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4143573248119644672UL, 1951084671140863744UL);
		ActorExecutionContextHelper __helper(static_cast<TestStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testStream", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
void testStream( FutureStream<int> const& xs ) {
															#line 687 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	new TestStreamActor(xs);
															#line 2430 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 693 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 2435 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest1()
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest1Actor>
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest1ActorState {
															#line 2442 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest1ActorState(bool const& b) 
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : b(b)
															#line 2449 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest1", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest1ActorState() 
	{
		fdb_probe_actor_destroy("actorTest1", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 695 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("1");
															#line 696 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (b)
															#line 2466 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			{
															#line 697 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				return a_body1Catch1(future_version(), loopDepth);
															#line 2470 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			}
															#line 698 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest1Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ActorTest1ActorState(); static_cast<ActorTest1Actor*>(this)->destroy(); return 0; }
															#line 2474 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest1Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ActorTest1ActorState();
			static_cast<ActorTest1Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest1ActorState();
		static_cast<ActorTest1Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool b;
															#line 2498 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest1()
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest1Actor final : public Actor<Void>, public FastAllocated<ActorTest1Actor>, public ActorTest1ActorState<ActorTest1Actor> {
															#line 2503 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest1Actor>::operator new;
	using FastAllocated<ActorTest1Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8937863503652176384UL, 9014436556385327360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest1Actor(bool const& b) 
															#line 2519 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   ActorTest1ActorState<ActorTest1Actor>(b),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest1", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4666759851126299136UL, 5463917722805028864UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest1");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest1", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> actorTest1( bool const& b ) {
															#line 694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new ActorTest1Actor(b));
															#line 2551 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 700 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 2556 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest2()
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest2Actor>
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest2ActorState {
															#line 2563 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest2ActorState(bool const& b) 
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : b(b)
															#line 2570 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest2", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest2ActorState() 
	{
		fdb_probe_actor_destroy("actorTest2", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 702 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("2");
															#line 703 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (b)
															#line 2587 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			{
															#line 704 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				return a_body1Catch1(future_version(), loopDepth);
															#line 2591 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ActorTest2Actor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		delete static_cast<ActorTest2Actor*>(this);
															#line 2614 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool b;
															#line 2621 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest2()
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest2Actor final : public Actor<void>, public FastAllocated<ActorTest2Actor>, public ActorTest2ActorState<ActorTest2Actor> {
															#line 2626 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest2Actor>::operator new;
	using FastAllocated<ActorTest2Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3653733984453824768UL, 4365425985956160768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest2Actor(bool const& b) 
															#line 2642 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<void>(),
		   ActorTest2ActorState<ActorTest2Actor>(b),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest2", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16541482017326021888UL, 23509077537914624UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest2");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest2", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
void actorTest2( bool const& b ) {
															#line 701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	new ActorTest2Actor(b);
															#line 2666 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 706 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 2671 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest3()
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest3Actor>
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest3ActorState {
															#line 2678 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest3ActorState(bool const& b) 
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : b(b)
															#line 2685 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest3", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest3ActorState() 
	{
		fdb_probe_actor_destroy("actorTest3", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 709 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				if (b)
															#line 2701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				{
															#line 710 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
					return a_body1Catch2(future_version(), loopDepth);
															#line 2705 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				}
				loopDepth = a_body1cont4(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest3ActorState();
		static_cast<ActorTest3Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 715 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		printf("\nactorTest3 failed\n");
															#line 716 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<ActorTest3Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ActorTest3ActorState(); static_cast<ActorTest3Actor*>(this)->destroy(); return 0; }
															#line 2737 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<ActorTest3Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ActorTest3ActorState();
		static_cast<ActorTest3Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 712 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("3");
															#line 713 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest3Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ActorTest3ActorState(); static_cast<ActorTest3Actor*>(this)->destroy(); return 0; }
															#line 2752 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest3Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ActorTest3ActorState();
			static_cast<ActorTest3Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool b;
															#line 2781 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest3()
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest3Actor final : public Actor<Void>, public FastAllocated<ActorTest3Actor>, public ActorTest3ActorState<ActorTest3Actor> {
															#line 2786 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest3Actor>::operator new;
	using FastAllocated<ActorTest3Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3188144994106314240UL, 13249472614006307072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest3Actor(bool const& b) 
															#line 2802 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   ActorTest3ActorState<ActorTest3Actor>(b),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest3", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13370643516453166080UL, 622047692135718144UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest3");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest3", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> actorTest3( bool const& b ) {
															#line 707 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new ActorTest3Actor(b));
															#line 2834 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 718 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 2839 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest4()
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest4Actor>
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest4ActorState {
															#line 2846 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest4ActorState(bool const& b) 
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : b(b),
															#line 720 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   tstart(now())
															#line 2855 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest4", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest4ActorState() 
	{
		fdb_probe_actor_destroy("actorTest4", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 722 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				if (b)
															#line 2871 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				{
															#line 723 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
					return a_body1Catch2(operation_failed(), loopDepth);
															#line 2875 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				}
				loopDepth = a_body1cont4(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest4ActorState();
		static_cast<ActorTest4Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 727 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (now() < tstart + 1)
															#line 2905 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 728 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("actorTest4 failed");
															#line 2909 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		}
		else
		{
															#line 730 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("4");
															#line 2915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		}
															#line 731 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<ActorTest4Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ActorTest4ActorState(); static_cast<ActorTest4Actor*>(this)->destroy(); return 0; }
															#line 2919 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<ActorTest4Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ActorTest4ActorState();
		static_cast<ActorTest4Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 725 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(1);
															#line 725 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<ActorTest4Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2934 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_0.get(), loopDepth); };
			static_cast<ActorTest4Actor*>(this)->actor_wait_state = 1;
															#line 725 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ActorTest4Actor, 0, Void >*>(static_cast<ActorTest4Actor*>(this)));
															#line 2939 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ActorTest4Actor*>(this)->actor_wait_state > 0) static_cast<ActorTest4Actor*>(this)->actor_wait_state = 0;
		static_cast<ActorTest4Actor*>(this)->ActorCallback< ActorTest4Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ActorTest4Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("actorTest4", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest4", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ActorTest4Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("actorTest4", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest4", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ActorTest4Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("actorTest4", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest4", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool b;
															#line 720 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	double tstart;
															#line 3054 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest4()
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest4Actor final : public Actor<Void>, public ActorCallback< ActorTest4Actor, 0, Void >, public FastAllocated<ActorTest4Actor>, public ActorTest4ActorState<ActorTest4Actor> {
															#line 3059 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest4Actor>::operator new;
	using FastAllocated<ActorTest4Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15646398585347375616UL, 2508056900041398272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ActorTest4Actor, 0, Void >;
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest4Actor(bool const& b) 
															#line 3076 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   ActorTest4ActorState<ActorTest4Actor>(b),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest4", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14371554454093051648UL, 4614117162761973504UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest4");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest4", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ActorTest4Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> actorTest4( bool const& b ) {
															#line 719 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new ActorTest4Actor(b));
															#line 3109 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 733 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 3114 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest5()
															#line 734 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest5Actor>
															#line 734 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest5ActorState {
															#line 3121 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 734 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest5ActorState() 
															#line 734 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 735 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : caught(false)
															#line 3128 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest5", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest5ActorState() 
	{
		fdb_probe_actor_destroy("actorTest5", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 737 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 3143 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest5ActorState();
		static_cast<ActorTest5Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 738 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		;
															#line 3173 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 739 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		inloop = false;
															#line 740 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (caught)
															#line 3191 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 741 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("5");
															#line 742 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest5Actor*>(this)->SAV<bool>::futures) { (void)(true); this->~ActorTest5ActorState(); static_cast<ActorTest5Actor*>(this)->destroy(); return 0; }
															#line 3197 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest5Actor*>(this)->SAV< bool >::value()) bool(true);
			this->~ActorTest5ActorState();
			static_cast<ActorTest5Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		try {
															#line 745 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			for(;;) {
															#line 746 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				if (inloop)
															#line 3208 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				{
															#line 747 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
					printf("\nactorTest5 failed\n");
															#line 748 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
					if (!static_cast<ActorTest5Actor*>(this)->SAV<bool>::futures) { (void)(false); this->~ActorTest5ActorState(); static_cast<ActorTest5Actor*>(this)->destroy(); return 0; }
															#line 3214 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
					new (&static_cast<ActorTest5Actor*>(this)->SAV< bool >::value()) bool(false);
					this->~ActorTest5ActorState();
					static_cast<ActorTest5Actor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 750 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				inloop = true;
															#line 751 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				if (1)
															#line 3224 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				{
															#line 752 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
					return a_body1loopBody1loopBody1Catch1(operation_failed(), loopDepth);
															#line 3228 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 755 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			caught = true;
															#line 3251 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
															#line 735 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool caught;
															#line 739 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool inloop;
															#line 3266 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest5()
															#line 734 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest5Actor final : public Actor<bool>, public FastAllocated<ActorTest5Actor>, public ActorTest5ActorState<ActorTest5Actor> {
															#line 3271 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest5Actor>::operator new;
	using FastAllocated<ActorTest5Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14976498003163627264UL, 17968596178590949120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 734 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest5Actor() 
															#line 3287 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<bool>(),
		   ActorTest5ActorState<ActorTest5Actor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest5", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8347299956294268416UL, 12400593117457675520UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest5");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest5", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 734 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<bool> actorTest5(  ) {
															#line 734 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<bool>(new ActorTest5Actor());
															#line 3319 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 760 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 3324 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest6()
															#line 761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest6Actor>
															#line 761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest6ActorState {
															#line 3331 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest6ActorState() 
															#line 761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 762 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : caught(false)
															#line 3338 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest6", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest6ActorState() 
	{
		fdb_probe_actor_destroy("actorTest6", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 763 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 3353 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest6ActorState();
		static_cast<ActorTest6Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 764 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (caught)
															#line 3383 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 765 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("6");
															#line 766 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest6Actor*>(this)->SAV<bool>::futures) { (void)(true); this->~ActorTest6ActorState(); static_cast<ActorTest6Actor*>(this)->destroy(); return 0; }
															#line 3389 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest6Actor*>(this)->SAV< bool >::value()) bool(true);
			this->~ActorTest6ActorState();
			static_cast<ActorTest6Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		try {
															#line 769 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (1)
															#line 3398 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			{
															#line 770 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 3402 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 772 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			caught = true;
															#line 3425 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 762 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool caught;
															#line 3451 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest6()
															#line 761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest6Actor final : public Actor<bool>, public FastAllocated<ActorTest6Actor>, public ActorTest6ActorState<ActorTest6Actor> {
															#line 3456 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest6Actor>::operator new;
	using FastAllocated<ActorTest6Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12803761580498225408UL, 13402686409067856896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest6Actor() 
															#line 3472 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<bool>(),
		   ActorTest6ActorState<ActorTest6Actor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest6", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5459404283537435904UL, 15208454806453981952UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest6Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest6");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest6", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<bool> actorTest6(  ) {
															#line 761 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<bool>(new ActorTest6Actor());
															#line 3504 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 776 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 3509 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest7()
															#line 777 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest7Actor>
															#line 777 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest7ActorState {
															#line 3516 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 777 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest7ActorState() 
															#line 777 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	{
															#line 3522 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		fdb_probe_actor_create("actorTest7", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest7ActorState() 
	{
		fdb_probe_actor_destroy("actorTest7", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 779 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				for(;;) {
															#line 780 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
					for(;;) {
															#line 781 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
						if (1)
															#line 3541 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
						{
															#line 782 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
							return a_body1Catch2(operation_failed(), loopDepth);
															#line 3545 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
						}
															#line 783 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
						if (1)
															#line 3549 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
						{
															#line 784 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
							printf("actorTest7 failed (1)\n");
															#line 785 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
							if (!static_cast<ActorTest7Actor*>(this)->SAV<bool>::futures) { (void)(false); this->~ActorTest7ActorState(); static_cast<ActorTest7Actor*>(this)->destroy(); return 0; }
															#line 3555 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
							new (&static_cast<ActorTest7Actor*>(this)->SAV< bool >::value()) bool(false);
							this->~ActorTest7ActorState();
							static_cast<ActorTest7Actor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 787 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
						if (0)
															#line 3563 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
						{
							break;
						}
					}
															#line 790 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
					if (1)
															#line 3570 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
					{
															#line 791 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
						printf("actorTest7 failed (2)\n");
															#line 792 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
						if (!static_cast<ActorTest7Actor*>(this)->SAV<bool>::futures) { (void)(false); this->~ActorTest7ActorState(); static_cast<ActorTest7Actor*>(this)->destroy(); return 0; }
															#line 3576 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
						new (&static_cast<ActorTest7Actor*>(this)->SAV< bool >::value()) bool(false);
						this->~ActorTest7ActorState();
						static_cast<ActorTest7Actor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest7ActorState();
		static_cast<ActorTest7Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 796 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("7");
															#line 797 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest7Actor*>(this)->SAV<bool>::futures) { (void)(true); this->~ActorTest7ActorState(); static_cast<ActorTest7Actor*>(this)->destroy(); return 0; }
															#line 3613 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest7Actor*>(this)->SAV< bool >::value()) bool(true);
			this->~ActorTest7ActorState();
			static_cast<ActorTest7Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
};
// This generated class is to be used only via actorTest7()
															#line 777 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest7Actor final : public Actor<bool>, public FastAllocated<ActorTest7Actor>, public ActorTest7ActorState<ActorTest7Actor> {
															#line 3631 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest7Actor>::operator new;
	using FastAllocated<ActorTest7Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15396719606277857536UL, 5978923936595898112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 777 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest7Actor() 
															#line 3647 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<bool>(),
		   ActorTest7ActorState<ActorTest7Actor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest7", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13641829686873673216UL, 12210830000457384960UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest7Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest7");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest7", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 777 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<bool> actorTest7(  ) {
															#line 777 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<bool>(new ActorTest7Actor());
															#line 3679 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 800 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 3684 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest8()
															#line 801 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest8Actor>
															#line 801 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest8ActorState {
															#line 3691 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 801 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest8ActorState() 
															#line 801 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 802 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : caught(false),
															#line 803 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   set(true)
															#line 3700 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest8", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest8ActorState() 
	{
		fdb_probe_actor_destroy("actorTest8", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 805 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 3715 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest8ActorState();
		static_cast<ActorTest8Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 806 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		inloop = false;
															#line 807 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (caught)
															#line 3747 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 808 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("8");
															#line 809 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest8Actor*>(this)->SAV<bool>::futures) { (void)(true); this->~ActorTest8ActorState(); static_cast<ActorTest8Actor*>(this)->destroy(); return 0; }
															#line 3753 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest8Actor*>(this)->SAV< bool >::value()) bool(true);
			this->~ActorTest8ActorState();
			static_cast<ActorTest8Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		try {
															#line 812 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 3762 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 823 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			caught = true;
															#line 3784 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 813 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (inloop)
															#line 3806 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 814 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("\nactorTest8 failed\n");
															#line 815 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest8Actor*>(this)->SAV<bool>::futures) { (void)(false); this->~ActorTest8ActorState(); static_cast<ActorTest8Actor*>(this)->destroy(); return 0; }
															#line 3812 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest8Actor*>(this)->SAV< bool >::value()) bool(false);
			this->~ActorTest8ActorState();
			static_cast<ActorTest8Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 817 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(set);
															#line 817 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<ActorTest8Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3822 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ActorTest8Actor*>(this)->actor_wait_state = 1;
															#line 817 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ActorTest8Actor, 0, Void >*>(static_cast<ActorTest8Actor*>(this)));
															#line 3827 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 818 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		inloop = true;
															#line 819 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (1)
															#line 3838 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 820 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), std::max(0, loopDepth - 1));
															#line 3842 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 818 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		inloop = true;
															#line 819 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (1)
															#line 3854 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 820 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), std::max(0, loopDepth - 1));
															#line 3858 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ActorTest8Actor*>(this)->actor_wait_state > 0) static_cast<ActorTest8Actor*>(this)->actor_wait_state = 0;
		static_cast<ActorTest8Actor*>(this)->ActorCallback< ActorTest8Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ActorTest8Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("actorTest8", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest8Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest8", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ActorTest8Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("actorTest8", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest8Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest8", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ActorTest8Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("actorTest8", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest8Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest8", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 802 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool caught;
															#line 803 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<bool> set;
															#line 806 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	bool inloop;
															#line 3945 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest8()
															#line 801 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest8Actor final : public Actor<bool>, public ActorCallback< ActorTest8Actor, 0, Void >, public FastAllocated<ActorTest8Actor>, public ActorTest8ActorState<ActorTest8Actor> {
															#line 3950 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest8Actor>::operator new;
	using FastAllocated<ActorTest8Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15506046090813841920UL, 17609865083663404288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ActorTest8Actor, 0, Void >;
															#line 801 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest8Actor() 
															#line 3967 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<bool>(),
		   ActorTest8ActorState<ActorTest8Actor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest8", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7431478974831588096UL, 5879368019483484160UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest8Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest8");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest8", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ActorTest8Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 801 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<bool> actorTest8(  ) {
															#line 801 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<bool>(new ActorTest8Actor());
															#line 4000 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 827 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 4005 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest9A()
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest9AActor>
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest9AActorState {
															#line 4012 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest9AActorState(Future<Void> const& setAfterCalling) 
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : setAfterCalling(setAfterCalling),
															#line 829 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   count(0)
															#line 4021 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest9A", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest9AActorState() 
	{
		fdb_probe_actor_destroy("actorTest9A", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 830 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 4036 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest9AActorState();
		static_cast<ActorTest9AActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 831 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (count == 4)
															#line 4066 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 832 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("9");
															#line 833 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest9AActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ActorTest9AActorState(); static_cast<ActorTest9AActor*>(this)->destroy(); return 0; }
															#line 4072 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest9AActor*>(this)->SAV< bool >::value()) bool(true);
			this->~ActorTest9AActorState();
			static_cast<ActorTest9AActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 835 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (count && count != 4)
															#line 4080 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 836 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			printf("\nactorTest9 failed\n");
															#line 837 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<ActorTest9AActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ActorTest9AActorState(); static_cast<ActorTest9AActor*>(this)->destroy(); return 0; }
															#line 4086 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<ActorTest9AActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ActorTest9AActorState();
			static_cast<ActorTest9AActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 839 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		;
															#line 4094 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 840 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		;
															#line 4116 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 854 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		count++;
															#line 4138 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 841 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = setAfterCalling;
															#line 841 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<ActorTest9AActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 4156 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ActorTest9AActor*>(this)->actor_wait_state = 1;
															#line 841 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ActorTest9AActor, 0, Void >*>(static_cast<ActorTest9AActor*>(this)));
															#line 4161 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 842 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		;
															#line 4183 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 842 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		;
															#line 4192 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ActorTest9AActor*>(this)->actor_wait_state > 0) static_cast<ActorTest9AActor*>(this)->actor_wait_state = 0;
		static_cast<ActorTest9AActor*>(this)->ActorCallback< ActorTest9AActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ActorTest9AActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("actorTest9A", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest9AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest9A", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ActorTest9AActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("actorTest9A", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest9AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest9A", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ActorTest9AActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("actorTest9A", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest9AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest9A", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 851 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		count++;
															#line 4276 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 843 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		for(;;) {
															#line 844 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			count++;
															#line 4294 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			break;
		}
															#line 847 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = Future<Void>(Void());
															#line 847 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<ActorTest9AActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 4));
															#line 4301 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 4)); else return a_body1loopBody1loopBody1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ActorTest9AActor*>(this)->actor_wait_state = 2;
															#line 847 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ActorTest9AActor, 1, Void >*>(static_cast<ActorTest9AActor*>(this)));
															#line 4306 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 848 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		count++;
															#line 4328 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return a_body1loopBody1loopBody1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 848 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		count++;
															#line 4337 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		return a_body1loopBody1loopBody1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ActorTest9AActor*>(this)->actor_wait_state > 0) static_cast<ActorTest9AActor*>(this)->actor_wait_state = 0;
		static_cast<ActorTest9AActor*>(this)->ActorCallback< ActorTest9AActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ActorTest9AActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("actorTest9A", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest9AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest9A", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ActorTest9AActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("actorTest9A", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest9AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest9A", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ActorTest9AActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("actorTest9A", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest9AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest9A", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<Void> setAfterCalling;
															#line 829 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int count;
															#line 4421 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest9A()
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest9AActor final : public Actor<bool>, public ActorCallback< ActorTest9AActor, 0, Void >, public ActorCallback< ActorTest9AActor, 1, Void >, public FastAllocated<ActorTest9AActor>, public ActorTest9AActorState<ActorTest9AActor> {
															#line 4426 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest9AActor>::operator new;
	using FastAllocated<ActorTest9AActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(814664237312141312UL, 15609670888161167872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ActorTest9AActor, 0, Void >;
friend struct ActorCallback< ActorTest9AActor, 1, Void >;
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest9AActor(Future<Void> const& setAfterCalling) 
															#line 4444 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<bool>(),
		   ActorTest9AActorState<ActorTest9AActor>(setAfterCalling),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest9A", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3674854128885717248UL, 17053302825869389056UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest9AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest9A");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest9A", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ActorTest9AActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ActorTest9AActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<bool> actorTest9A( Future<Void> const& setAfterCalling ) {
															#line 828 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<bool>(new ActorTest9AActor(setAfterCalling));
															#line 4478 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 860 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

Future<bool> actorTest9() {
	Promise<Void> p;
	Future<bool> f = actorTest9A(p.getFuture());
	p.send(Void());
	return f;
}

															#line 4490 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via actorTest10A()
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class ActorTest10AActor>
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest10AActorState {
															#line 4497 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest10AActorState(FutureStream<int> const& inputStream,Future<Void> const& go) 
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : inputStream(inputStream),
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   go(go),
															#line 869 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   i()
															#line 4508 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("actorTest10A", reinterpret_cast<unsigned long>(this));

	}
	~ActorTest10AActorState() 
	{
		fdb_probe_actor_destroy("actorTest10A", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 870 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			i = 0;
															#line 4523 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ActorTest10AActorState();
		static_cast<ActorTest10AActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 875 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<ActorTest10AActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ActorTest10AActorState(); static_cast<ActorTest10AActor*>(this)->destroy(); return 0; }
															#line 4546 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<ActorTest10AActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ActorTest10AActorState();
		static_cast<ActorTest10AActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 870 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!(i < 5))
															#line 4565 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 871 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = go;
															#line 871 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<ActorTest10AActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4573 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ActorTest10AActor*>(this)->actor_wait_state = 1;
															#line 871 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ActorTest10AActor, 0, Void >*>(static_cast<ActorTest10AActor*>(this)));
															#line 4578 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 872 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		auto __when_expr_1 = inputStream;
															#line 4600 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<int>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<int>>::value, "invalid type");
															#line 872 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<ActorTest10AActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4604 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<ActorTest10AActor*>(this)->actor_wait_state = 2;
															#line 872 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ActorTest10AActor, 1, int >*>(static_cast<ActorTest10AActor*>(this)));
															#line 4609 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 872 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		auto __when_expr_1 = inputStream;
															#line 4618 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<int>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<int>>::value, "invalid type");
															#line 872 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<ActorTest10AActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4622 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<ActorTest10AActor*>(this)->actor_wait_state = 2;
															#line 872 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ActorTest10AActor, 1, int >*>(static_cast<ActorTest10AActor*>(this)));
															#line 4627 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ActorTest10AActor*>(this)->actor_wait_state > 0) static_cast<ActorTest10AActor*>(this)->actor_wait_state = 0;
		static_cast<ActorTest10AActor*>(this)->ActorCallback< ActorTest10AActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ActorTest10AActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("actorTest10A", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest10AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest10A", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ActorTest10AActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("actorTest10A", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest10AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest10A", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ActorTest10AActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("actorTest10A", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest10AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest10A", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int const& input,int loopDepth) 
	{
															#line 873 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		(void)input;
															#line 870 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		i++;
															#line 4713 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int && input,int loopDepth) 
	{
															#line 873 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		(void)input;
															#line 870 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		i++;
															#line 4724 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(int const& input,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(input, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(int && input,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(input), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ActorTest10AActor*>(this)->actor_wait_state > 0) static_cast<ActorTest10AActor*>(this)->actor_wait_state = 0;
		static_cast<ActorTest10AActor*>(this)->ActorSingleCallback< ActorTest10AActor, 1, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ActorTest10AActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("actorTest10A", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest10AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest10A", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ActorTest10AActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("actorTest10A", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest10AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest10A", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ActorTest10AActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("actorTest10A", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest10AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("actorTest10A", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	FutureStream<int> inputStream;
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<Void> go;
															#line 869 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int i;
															#line 4810 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via actorTest10A()
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class ActorTest10AActor final : public Actor<Void>, public ActorCallback< ActorTest10AActor, 0, Void >, public ActorSingleCallback< ActorTest10AActor, 1, int >, public FastAllocated<ActorTest10AActor>, public ActorTest10AActorState<ActorTest10AActor> {
															#line 4815 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<ActorTest10AActor>::operator new;
	using FastAllocated<ActorTest10AActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9067207942797462272UL, 10800654349983502848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ActorTest10AActor, 0, Void >;
friend struct ActorSingleCallback< ActorTest10AActor, 1, int >;
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	ActorTest10AActor(FutureStream<int> const& inputStream,Future<Void> const& go) 
															#line 4833 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   ActorTest10AActorState<ActorTest10AActor>(inputStream, go),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("actorTest10A", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6339698144805581056UL, 17701944282279624192UL);
		ActorExecutionContextHelper __helper(static_cast<ActorTest10AActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("actorTest10A");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("actorTest10A", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ActorTest10AActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< ActorTest10AActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> actorTest10A( FutureStream<int> const& inputStream, Future<Void> const& go ) {
															#line 868 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new ActorTest10AActor(inputStream, go));
															#line 4867 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 877 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

void actorTest10() {
	PromiseStream<int> ins;
	Promise<Void> go;
	for (int x = 0; x < 2; x++)
		ins.send(x);
	Future<Void> a = actorTest10A(ins.getFuture(), go.getFuture());
	go.send(Void());
	for (int x = 0; x < 3; x++)
		ins.send(x);
	if (!a.isReady())
		printf("\nactorTest10 failed\n");
	else
		printf("10");
}

															#line 4887 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via cancellable()
															#line 893 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class CancellableActor>
															#line 893 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class CancellableActorState {
															#line 4894 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 893 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	CancellableActorState() 
															#line 893 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	{
															#line 4900 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		fdb_probe_actor_create("cancellable", reinterpret_cast<unsigned long>(this));

	}
	~CancellableActorState() 
	{
		fdb_probe_actor_destroy("cancellable", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 894 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Never();
															#line 894 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<CancellableActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4916 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CancellableActor*>(this)->actor_wait_state = 1;
															#line 894 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancellableActor, 0, Void >*>(static_cast<CancellableActor*>(this)));
															#line 4921 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancellableActorState();
		static_cast<CancellableActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 895 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<CancellableActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancellableActorState(); static_cast<CancellableActor*>(this)->destroy(); return 0; }
															#line 4944 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<CancellableActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancellableActorState();
		static_cast<CancellableActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 895 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<CancellableActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancellableActorState(); static_cast<CancellableActor*>(this)->destroy(); return 0; }
															#line 4956 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<CancellableActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancellableActorState();
		static_cast<CancellableActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancellableActor*>(this)->actor_wait_state > 0) static_cast<CancellableActor*>(this)->actor_wait_state = 0;
		static_cast<CancellableActor*>(this)->ActorCallback< CancellableActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancellableActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancellableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancellableActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancellableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancellableActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancellable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancellableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellable", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via cancellable()
															#line 893 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class CancellableActor final : public Actor<Void>, public ActorCallback< CancellableActor, 0, Void >, public FastAllocated<CancellableActor>, public CancellableActorState<CancellableActor> {
															#line 5043 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<CancellableActor>::operator new;
	using FastAllocated<CancellableActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1644500019889532160UL, 2174213338306649856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancellableActor, 0, Void >;
															#line 893 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	CancellableActor() 
															#line 5060 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   CancellableActorState<CancellableActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancellable", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13566371608694764544UL, 13461087147810138112UL);
		ActorExecutionContextHelper __helper(static_cast<CancellableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancellable");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancellable", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancellableActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 893 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> cancellable(  ) {
															#line 893 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new CancellableActor());
															#line 5093 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 897 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 5098 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via simple()
															#line 898 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class SimpleActor>
															#line 898 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class SimpleActorState {
															#line 5105 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 898 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	SimpleActorState() 
															#line 898 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	{
															#line 5111 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		fdb_probe_actor_create("simple", reinterpret_cast<unsigned long>(this));

	}
	~SimpleActorState() 
	{
		fdb_probe_actor_destroy("simple", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 899 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<SimpleActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimpleActorState(); static_cast<SimpleActor*>(this)->destroy(); return 0; }
															#line 5125 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<SimpleActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SimpleActorState();
			static_cast<SimpleActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimpleActorState();
		static_cast<SimpleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via simple()
															#line 898 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class SimpleActor final : public Actor<Void>, public FastAllocated<SimpleActor>, public SimpleActorState<SimpleActor> {
															#line 5151 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<SimpleActor>::operator new;
	using FastAllocated<SimpleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2948273732781515520UL, 3481938189227812608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 898 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	SimpleActor() 
															#line 5167 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   SimpleActorState<SimpleActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simple", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10233844508279185920UL, 6056239788128730112UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simple");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simple", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 898 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> simple(  ) {
															#line 898 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new SimpleActor());
															#line 5199 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 901 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 5204 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via simpleWait()
															#line 902 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class SimpleWaitActor>
															#line 902 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class SimpleWaitActorState {
															#line 5211 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 902 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	SimpleWaitActorState() 
															#line 902 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	{
															#line 5217 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		fdb_probe_actor_create("simpleWait", reinterpret_cast<unsigned long>(this));

	}
	~SimpleWaitActorState() 
	{
		fdb_probe_actor_destroy("simpleWait", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 903 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 903 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<SimpleWaitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5233 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SimpleWaitActor*>(this)->actor_wait_state = 1;
															#line 903 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimpleWaitActor, 0, Void >*>(static_cast<SimpleWaitActor*>(this)));
															#line 5238 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimpleWaitActorState();
		static_cast<SimpleWaitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 904 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<SimpleWaitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimpleWaitActorState(); static_cast<SimpleWaitActor*>(this)->destroy(); return 0; }
															#line 5261 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<SimpleWaitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimpleWaitActorState();
		static_cast<SimpleWaitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 904 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<SimpleWaitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SimpleWaitActorState(); static_cast<SimpleWaitActor*>(this)->destroy(); return 0; }
															#line 5273 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<SimpleWaitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SimpleWaitActorState();
		static_cast<SimpleWaitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimpleWaitActor*>(this)->actor_wait_state > 0) static_cast<SimpleWaitActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleWaitActor*>(this)->ActorCallback< SimpleWaitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleWaitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleWait", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleWait", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimpleWaitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleWait", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleWait", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimpleWaitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleWait", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleWait", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via simpleWait()
															#line 902 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class SimpleWaitActor final : public Actor<Void>, public ActorCallback< SimpleWaitActor, 0, Void >, public FastAllocated<SimpleWaitActor>, public SimpleWaitActorState<SimpleWaitActor> {
															#line 5360 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<SimpleWaitActor>::operator new;
	using FastAllocated<SimpleWaitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13139763846365030656UL, 749302029909441792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimpleWaitActor, 0, Void >;
															#line 902 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	SimpleWaitActor() 
															#line 5377 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   SimpleWaitActorState<SimpleWaitActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simpleWait", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10881781354848222720UL, 14794945536923669248UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleWaitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simpleWait");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simpleWait", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimpleWaitActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 902 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> simpleWait(  ) {
															#line 902 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new SimpleWaitActor());
															#line 5410 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 906 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 5415 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via simpleRet()
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class SimpleRetActor>
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class SimpleRetActorState {
															#line 5422 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	SimpleRetActorState(Future<int> const& x) 
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : x(x)
															#line 5429 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("simpleRet", reinterpret_cast<unsigned long>(this));

	}
	~SimpleRetActorState() 
	{
		fdb_probe_actor_destroy("simpleRet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 908 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<int> __when_expr_0 = x;
															#line 908 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<SimpleRetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5446 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SimpleRetActor*>(this)->actor_wait_state = 1;
															#line 908 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimpleRetActor, 0, int >*>(static_cast<SimpleRetActor*>(this)));
															#line 5451 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimpleRetActorState();
		static_cast<SimpleRetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 909 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<SimpleRetActor*>(this)->SAV<int>::futures) { (void)(i); this->~SimpleRetActorState(); static_cast<SimpleRetActor*>(this)->destroy(); return 0; }
															#line 5474 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<SimpleRetActor*>(this)->SAV< int >::value()) int(i);
		this->~SimpleRetActorState();
		static_cast<SimpleRetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 909 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<SimpleRetActor*>(this)->SAV<int>::futures) { (void)(i); this->~SimpleRetActorState(); static_cast<SimpleRetActor*>(this)->destroy(); return 0; }
															#line 5486 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<SimpleRetActor*>(this)->SAV< int >::value()) int(i);
		this->~SimpleRetActorState();
		static_cast<SimpleRetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimpleRetActor*>(this)->actor_wait_state > 0) static_cast<SimpleRetActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleRetActor*>(this)->ActorCallback< SimpleRetActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleRetActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("simpleRet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleRetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleRet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimpleRetActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("simpleRet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleRetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleRet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimpleRetActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("simpleRet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleRetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleRet", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> x;
															#line 5571 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via simpleRet()
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class SimpleRetActor final : public Actor<int>, public ActorCallback< SimpleRetActor, 0, int >, public FastAllocated<SimpleRetActor>, public SimpleRetActorState<SimpleRetActor> {
															#line 5576 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<SimpleRetActor>::operator new;
	using FastAllocated<SimpleRetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6031829095452239872UL, 10602210108943840000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimpleRetActor, 0, int >;
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	SimpleRetActor(Future<int> const& x) 
															#line 5593 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<int>(),
		   SimpleRetActorState<SimpleRetActor>(x),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simpleRet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12755120914463842048UL, 5765962273219773952UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleRetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simpleRet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simpleRet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimpleRetActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<int> simpleRet( Future<int> const& x ) {
															#line 907 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<int>(new SimpleRetActor(x));
															#line 5626 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 911 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

template <int i>
Future<int> chain(Future<int> const& x);

															#line 5634 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via achain()
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <int i, class AchainActor>
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class AchainActorState {
															#line 5641 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	AchainActorState(Future<int> const& x) 
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : x(x)
															#line 5648 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("achain", reinterpret_cast<unsigned long>(this));

	}
	~AchainActorState() 
	{
		fdb_probe_actor_destroy("achain", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 917 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<int> __when_expr_0 = chain<i>(x);
															#line 917 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<AchainActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5665 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AchainActor*>(this)->actor_wait_state = 1;
															#line 917 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AchainActor, 0, int >*>(static_cast<AchainActor*>(this)));
															#line 5670 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AchainActorState();
		static_cast<AchainActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& k,int loopDepth) 
	{
															#line 918 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<AchainActor*>(this)->SAV<int>::futures) { (void)(k + 1); this->~AchainActorState(); static_cast<AchainActor*>(this)->destroy(); return 0; }
															#line 5693 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<AchainActor*>(this)->SAV< int >::value()) int(k + 1);
		this->~AchainActorState();
		static_cast<AchainActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && k,int loopDepth) 
	{
															#line 918 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<AchainActor*>(this)->SAV<int>::futures) { (void)(k + 1); this->~AchainActorState(); static_cast<AchainActor*>(this)->destroy(); return 0; }
															#line 5705 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<AchainActor*>(this)->SAV< int >::value()) int(k + 1);
		this->~AchainActorState();
		static_cast<AchainActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& k,int loopDepth) 
	{
		loopDepth = a_body1cont1(k, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && k,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(k), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AchainActor*>(this)->actor_wait_state > 0) static_cast<AchainActor*>(this)->actor_wait_state = 0;
		static_cast<AchainActor*>(this)->ActorCallback< AchainActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< AchainActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("achain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AchainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("achain", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AchainActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("achain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AchainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("achain", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AchainActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("achain", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AchainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("achain", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> x;
															#line 5790 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via achain()
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <int i>
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class AchainActor final : public Actor<int>, public ActorCallback< AchainActor<i>, 0, int >, public FastAllocated<AchainActor<i>>, public AchainActorState<i, AchainActor<i>> {
															#line 5797 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<AchainActor<i>>::operator new;
	using FastAllocated<AchainActor<i>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17912353206768352256UL, 16838813636432040704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AchainActor<i>, 0, int >;
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	AchainActor(Future<int> const& x) 
															#line 5814 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<int>(),
		   AchainActorState<i, AchainActor<i>>(x),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("achain", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4646537136460875776UL, 13353521392127316736UL);
		ActorExecutionContextHelper __helper(static_cast<AchainActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("achain");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("achain", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AchainActor<i>, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <int i>
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<int> achain( Future<int> const& x ) {
															#line 915 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<int>(new AchainActor<i>(x));
															#line 5849 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 920 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

template <int i>
Future<int> chain(Future<int> const& x) {
	return achain<i - 1>(x);
}

template <>
Future<int> chain<0>(Future<int> const& x) {
	return x;
}

															#line 5864 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
Future<int> chain2( Future<int> const& x, int const& i );

#line 932 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 5869 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via chain2()
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class Chain2Actor>
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class Chain2ActorState {
															#line 5876 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Chain2ActorState(Future<int> const& x,int const& i) 
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : x(x),
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   i(i)
															#line 5885 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("chain2", reinterpret_cast<unsigned long>(this));

	}
	~Chain2ActorState() 
	{
		fdb_probe_actor_destroy("chain2", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 934 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (i > 1)
															#line 5900 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			{
															#line 935 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				StrictFuture<int> __when_expr_0 = chain2(x, i - 1);
															#line 935 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				if (static_cast<Chain2Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5906 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<Chain2Actor*>(this)->actor_wait_state = 1;
															#line 935 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Chain2Actor, 0, int >*>(static_cast<Chain2Actor*>(this)));
															#line 5911 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 938 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				StrictFuture<int> __when_expr_1 = x;
															#line 938 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				if (static_cast<Chain2Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5920 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<Chain2Actor*>(this)->actor_wait_state = 2;
															#line 938 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Chain2Actor, 1, int >*>(static_cast<Chain2Actor*>(this)));
															#line 5925 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Chain2ActorState();
		static_cast<Chain2Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int const& k,int loopDepth) 
	{
															#line 936 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<Chain2Actor*>(this)->SAV<int>::futures) { (void)(k + 1); this->~Chain2ActorState(); static_cast<Chain2Actor*>(this)->destroy(); return 0; }
															#line 5949 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<Chain2Actor*>(this)->SAV< int >::value()) int(k + 1);
		this->~Chain2ActorState();
		static_cast<Chain2Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int && k,int loopDepth) 
	{
															#line 936 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<Chain2Actor*>(this)->SAV<int>::futures) { (void)(k + 1); this->~Chain2ActorState(); static_cast<Chain2Actor*>(this)->destroy(); return 0; }
															#line 5961 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<Chain2Actor*>(this)->SAV< int >::value()) int(k + 1);
		this->~Chain2ActorState();
		static_cast<Chain2Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& k,int loopDepth) 
	{
		loopDepth = a_body1cont2(k, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && k,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(k), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Chain2Actor*>(this)->actor_wait_state > 0) static_cast<Chain2Actor*>(this)->actor_wait_state = 0;
		static_cast<Chain2Actor*>(this)->ActorCallback< Chain2Actor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< Chain2Actor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("chain2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Chain2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chain2", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Chain2Actor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("chain2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Chain2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chain2", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Chain2Actor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("chain2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Chain2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chain2", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int const& k,int loopDepth) 
	{
															#line 939 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<Chain2Actor*>(this)->SAV<int>::futures) { (void)(k + i); this->~Chain2ActorState(); static_cast<Chain2Actor*>(this)->destroy(); return 0; }
															#line 6048 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<Chain2Actor*>(this)->SAV< int >::value()) int(k + i);
		this->~Chain2ActorState();
		static_cast<Chain2Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int && k,int loopDepth) 
	{
															#line 939 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<Chain2Actor*>(this)->SAV<int>::futures) { (void)(k + i); this->~Chain2ActorState(); static_cast<Chain2Actor*>(this)->destroy(); return 0; }
															#line 6060 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<Chain2Actor*>(this)->SAV< int >::value()) int(k + i);
		this->~Chain2ActorState();
		static_cast<Chain2Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(int const& k,int loopDepth) 
	{
		loopDepth = a_body1cont4(k, loopDepth);

		return loopDepth;
	}
	int a_body1when2(int && k,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(k), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Chain2Actor*>(this)->actor_wait_state > 0) static_cast<Chain2Actor*>(this)->actor_wait_state = 0;
		static_cast<Chain2Actor*>(this)->ActorCallback< Chain2Actor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< Chain2Actor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("chain2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Chain2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chain2", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Chain2Actor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("chain2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Chain2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chain2", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Chain2Actor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("chain2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Chain2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chain2", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> x;
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int i;
															#line 6147 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via chain2()
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class Chain2Actor final : public Actor<int>, public ActorCallback< Chain2Actor, 0, int >, public ActorCallback< Chain2Actor, 1, int >, public FastAllocated<Chain2Actor>, public Chain2ActorState<Chain2Actor> {
															#line 6152 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<Chain2Actor>::operator new;
	using FastAllocated<Chain2Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16241176034351523072UL, 18322182113532839168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Chain2Actor, 0, int >;
friend struct ActorCallback< Chain2Actor, 1, int >;
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Chain2Actor(Future<int> const& x,int const& i) 
															#line 6170 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<int>(),
		   Chain2ActorState<Chain2Actor>(x, i),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chain2", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2659838949444770816UL, 2182515763123206656UL);
		ActorExecutionContextHelper __helper(static_cast<Chain2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chain2");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chain2", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Chain2Actor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Chain2Actor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<int> chain2( Future<int> const& x, int const& i ) {
															#line 933 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<int>(new Chain2Actor(x, i));
															#line 6204 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 942 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 6209 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via cancellable2()
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class Cancellable2Actor>
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class Cancellable2ActorState {
															#line 6216 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Cancellable2ActorState() 
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	{
															#line 6222 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		fdb_probe_actor_create("cancellable2", reinterpret_cast<unsigned long>(this));

	}
	~Cancellable2ActorState() 
	{
		fdb_probe_actor_destroy("cancellable2", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 945 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Never();
															#line 945 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				if (static_cast<Cancellable2Actor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6239 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<Cancellable2Actor*>(this)->actor_wait_state = 1;
															#line 945 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Cancellable2Actor, 0, Void >*>(static_cast<Cancellable2Actor*>(this)));
															#line 6244 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Cancellable2ActorState();
		static_cast<Cancellable2Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 948 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6274 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 946 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<Cancellable2Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Cancellable2ActorState(); static_cast<Cancellable2Actor*>(this)->destroy(); return 0; }
															#line 6288 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<Cancellable2Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Cancellable2ActorState();
		static_cast<Cancellable2Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 946 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<Cancellable2Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Cancellable2ActorState(); static_cast<Cancellable2Actor*>(this)->destroy(); return 0; }
															#line 6300 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<Cancellable2Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Cancellable2ActorState();
		static_cast<Cancellable2Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Cancellable2Actor*>(this)->actor_wait_state > 0) static_cast<Cancellable2Actor*>(this)->actor_wait_state = 0;
		static_cast<Cancellable2Actor*>(this)->ActorCallback< Cancellable2Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Cancellable2Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancellable2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Cancellable2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellable2", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Cancellable2Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancellable2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Cancellable2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellable2", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Cancellable2Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancellable2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Cancellable2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancellable2", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via cancellable2()
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class Cancellable2Actor final : public Actor<Void>, public ActorCallback< Cancellable2Actor, 0, Void >, public FastAllocated<Cancellable2Actor>, public Cancellable2ActorState<Cancellable2Actor> {
															#line 6387 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<Cancellable2Actor>::operator new;
	using FastAllocated<Cancellable2Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3607730067246461440UL, 11026172708094677504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Cancellable2Actor, 0, Void >;
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Cancellable2Actor() 
															#line 6404 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   Cancellable2ActorState<Cancellable2Actor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancellable2", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15198981290843479040UL, 9371186724872581888UL);
		ActorExecutionContextHelper __helper(static_cast<Cancellable2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancellable2");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancellable2", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Cancellable2Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> cancellable2(  ) {
															#line 943 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new Cancellable2Actor());
															#line 6437 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 951 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 6442 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via introLoadValueFromDisk()
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class IntroLoadValueFromDiskActor>
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class IntroLoadValueFromDiskActorState {
															#line 6449 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	IntroLoadValueFromDiskActorState(Future<std::string> const& filename) 
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : filename(filename)
															#line 6456 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this));

	}
	~IntroLoadValueFromDiskActorState() 
	{
		fdb_probe_actor_destroy("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 953 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<std::string> __when_expr_0 = filename;
															#line 953 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<IntroLoadValueFromDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6473 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IntroLoadValueFromDiskActor*>(this)->actor_wait_state = 1;
															#line 953 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IntroLoadValueFromDiskActor, 0, std::string >*>(static_cast<IntroLoadValueFromDiskActor*>(this)));
															#line 6478 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IntroLoadValueFromDiskActorState();
		static_cast<IntroLoadValueFromDiskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::string const& file,int loopDepth) 
	{
															#line 955 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (file == "/dev/threes")
															#line 6501 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 956 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<IntroLoadValueFromDiskActor*>(this)->SAV<int>::futures) { (void)(3); this->~IntroLoadValueFromDiskActorState(); static_cast<IntroLoadValueFromDiskActor*>(this)->destroy(); return 0; }
															#line 6505 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<IntroLoadValueFromDiskActor*>(this)->SAV< int >::value()) int(3);
			this->~IntroLoadValueFromDiskActorState();
			static_cast<IntroLoadValueFromDiskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 958 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			ASSERT(false);
															#line 6515 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		}
															#line 959 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<IntroLoadValueFromDiskActor*>(this)->SAV<int>::futures) { (void)(0); this->~IntroLoadValueFromDiskActorState(); static_cast<IntroLoadValueFromDiskActor*>(this)->destroy(); return 0; }
															#line 6519 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<IntroLoadValueFromDiskActor*>(this)->SAV< int >::value()) int(0);
		this->~IntroLoadValueFromDiskActorState();
		static_cast<IntroLoadValueFromDiskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::string && file,int loopDepth) 
	{
															#line 955 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (file == "/dev/threes")
															#line 6531 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
															#line 956 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (!static_cast<IntroLoadValueFromDiskActor*>(this)->SAV<int>::futures) { (void)(3); this->~IntroLoadValueFromDiskActorState(); static_cast<IntroLoadValueFromDiskActor*>(this)->destroy(); return 0; }
															#line 6535 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			new (&static_cast<IntroLoadValueFromDiskActor*>(this)->SAV< int >::value()) int(3);
			this->~IntroLoadValueFromDiskActorState();
			static_cast<IntroLoadValueFromDiskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 958 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			ASSERT(false);
															#line 6545 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		}
															#line 959 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<IntroLoadValueFromDiskActor*>(this)->SAV<int>::futures) { (void)(0); this->~IntroLoadValueFromDiskActorState(); static_cast<IntroLoadValueFromDiskActor*>(this)->destroy(); return 0; }
															#line 6549 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<IntroLoadValueFromDiskActor*>(this)->SAV< int >::value()) int(0);
		this->~IntroLoadValueFromDiskActorState();
		static_cast<IntroLoadValueFromDiskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& file,int loopDepth) 
	{
		loopDepth = a_body1cont1(file, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && file,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(file), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IntroLoadValueFromDiskActor*>(this)->actor_wait_state > 0) static_cast<IntroLoadValueFromDiskActor*>(this)->actor_wait_state = 0;
		static_cast<IntroLoadValueFromDiskActor*>(this)->ActorCallback< IntroLoadValueFromDiskActor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< IntroLoadValueFromDiskActor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroLoadValueFromDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IntroLoadValueFromDiskActor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroLoadValueFromDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IntroLoadValueFromDiskActor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IntroLoadValueFromDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<std::string> filename;
															#line 6634 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via introLoadValueFromDisk()
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class IntroLoadValueFromDiskActor final : public Actor<int>, public ActorCallback< IntroLoadValueFromDiskActor, 0, std::string >, public FastAllocated<IntroLoadValueFromDiskActor>, public IntroLoadValueFromDiskActorState<IntroLoadValueFromDiskActor> {
															#line 6639 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<IntroLoadValueFromDiskActor>::operator new;
	using FastAllocated<IntroLoadValueFromDiskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16305808437592271872UL, 12653092289555119616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IntroLoadValueFromDiskActor, 0, std::string >;
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	IntroLoadValueFromDiskActor(Future<std::string> const& filename) 
															#line 6656 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<int>(),
		   IntroLoadValueFromDiskActorState<IntroLoadValueFromDiskActor>(filename),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1405973662929500416UL, 14416808571673938176UL);
		ActorExecutionContextHelper __helper(static_cast<IntroLoadValueFromDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("introLoadValueFromDisk");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("introLoadValueFromDisk", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IntroLoadValueFromDiskActor, 0, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<int> introLoadValueFromDisk( Future<std::string> const& filename ) {
															#line 952 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<int>(new IntroLoadValueFromDiskActor(filename));
															#line 6689 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 961 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 6694 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via introAdd()
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class IntroAddActor>
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class IntroAddActorState {
															#line 6701 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	IntroAddActorState(Future<int> const& a,Future<int> const& b) 
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : a(a),
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   b(b)
															#line 6710 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("introAdd", reinterpret_cast<unsigned long>(this));

	}
	~IntroAddActorState() 
	{
		fdb_probe_actor_destroy("introAdd", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 963 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<int> __when_expr_0 = a;
															#line 963 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<IntroAddActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6727 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IntroAddActor*>(this)->actor_wait_state = 1;
															#line 963 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IntroAddActor, 0, int >*>(static_cast<IntroAddActor*>(this)));
															#line 6732 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IntroAddActorState();
		static_cast<IntroAddActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 964 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		StrictFuture<int> __when_expr_1 = b;
															#line 964 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<IntroAddActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6757 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<IntroAddActor*>(this)->actor_wait_state = 2;
															#line 964 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IntroAddActor, 1, int >*>(static_cast<IntroAddActor*>(this)));
															#line 6762 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& __x,int loopDepth) 
	{
															#line 963 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		x = __x;
															#line 6771 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && __x,int loopDepth) 
	{
		x = std::move(__x);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IntroAddActor*>(this)->actor_wait_state > 0) static_cast<IntroAddActor*>(this)->actor_wait_state = 0;
		static_cast<IntroAddActor*>(this)->ActorCallback< IntroAddActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< IntroAddActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("introAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IntroAddActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("introAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IntroAddActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("introAdd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAdd", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int const& y,int loopDepth) 
	{
															#line 965 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<IntroAddActor*>(this)->SAV<int>::futures) { (void)(x + y); this->~IntroAddActorState(); static_cast<IntroAddActor*>(this)->destroy(); return 0; }
															#line 6850 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<IntroAddActor*>(this)->SAV< int >::value()) int(x + y);
		this->~IntroAddActorState();
		static_cast<IntroAddActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int && y,int loopDepth) 
	{
															#line 965 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<IntroAddActor*>(this)->SAV<int>::futures) { (void)(x + y); this->~IntroAddActorState(); static_cast<IntroAddActor*>(this)->destroy(); return 0; }
															#line 6862 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<IntroAddActor*>(this)->SAV< int >::value()) int(x + y);
		this->~IntroAddActorState();
		static_cast<IntroAddActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& y,int loopDepth) 
	{
		loopDepth = a_body1cont2(y, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && y,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(y), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IntroAddActor*>(this)->actor_wait_state > 0) static_cast<IntroAddActor*>(this)->actor_wait_state = 0;
		static_cast<IntroAddActor*>(this)->ActorCallback< IntroAddActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< IntroAddActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("introAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAdd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IntroAddActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("introAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAdd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IntroAddActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("introAdd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAdd", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> a;
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> b;
															#line 963 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int x;
															#line 6951 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via introAdd()
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class IntroAddActor final : public Actor<int>, public ActorCallback< IntroAddActor, 0, int >, public ActorCallback< IntroAddActor, 1, int >, public FastAllocated<IntroAddActor>, public IntroAddActorState<IntroAddActor> {
															#line 6956 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<IntroAddActor>::operator new;
	using FastAllocated<IntroAddActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5694527599867667968UL, 3165273909471530496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IntroAddActor, 0, int >;
friend struct ActorCallback< IntroAddActor, 1, int >;
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	IntroAddActor(Future<int> const& a,Future<int> const& b) 
															#line 6974 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<int>(),
		   IntroAddActorState<IntroAddActor>(a, b),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("introAdd", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16584940421202335744UL, 2181709521947502848UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("introAdd");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("introAdd", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IntroAddActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IntroAddActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<int> introAdd( Future<int> const& a, Future<int> const& b ) {
															#line 962 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<int>(new IntroAddActor(a, b));
															#line 7008 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 967 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 7013 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via introFirst()
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class IntroFirstActor>
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class IntroFirstActorState {
															#line 7020 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	IntroFirstActorState(Future<int> const& a,Future<int> const& b) 
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : a(a),
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   b(b)
															#line 7029 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("introFirst", reinterpret_cast<unsigned long>(this));

	}
	~IntroFirstActorState() 
	{
		fdb_probe_actor_destroy("introFirst", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 970 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<int> __when_expr_0 = a;
															#line 969 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			if (static_cast<IntroFirstActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7046 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 973 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			StrictFuture<int> __when_expr_1 = b;
															#line 7050 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<IntroFirstActor*>(this)->actor_wait_state = 1;
															#line 970 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IntroFirstActor, 0, int >*>(static_cast<IntroFirstActor*>(this)));
															#line 973 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IntroFirstActor, 1, int >*>(static_cast<IntroFirstActor*>(this)));
															#line 7057 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IntroFirstActorState();
		static_cast<IntroFirstActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& x,int loopDepth) 
	{
															#line 971 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<IntroFirstActor*>(this)->SAV<int>::futures) { (void)(x); this->~IntroFirstActorState(); static_cast<IntroFirstActor*>(this)->destroy(); return 0; }
															#line 7080 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<IntroFirstActor*>(this)->SAV< int >::value()) int(x);
		this->~IntroFirstActorState();
		static_cast<IntroFirstActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int && x,int loopDepth) 
	{
															#line 971 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<IntroFirstActor*>(this)->SAV<int>::futures) { (void)(x); this->~IntroFirstActorState(); static_cast<IntroFirstActor*>(this)->destroy(); return 0; }
															#line 7092 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<IntroFirstActor*>(this)->SAV< int >::value()) int(x);
		this->~IntroFirstActorState();
		static_cast<IntroFirstActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(int const& x,int loopDepth) 
	{
															#line 974 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<IntroFirstActor*>(this)->SAV<int>::futures) { (void)(x); this->~IntroFirstActorState(); static_cast<IntroFirstActor*>(this)->destroy(); return 0; }
															#line 7104 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<IntroFirstActor*>(this)->SAV< int >::value()) int(x);
		this->~IntroFirstActorState();
		static_cast<IntroFirstActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(int && x,int loopDepth) 
	{
															#line 974 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<IntroFirstActor*>(this)->SAV<int>::futures) { (void)(x); this->~IntroFirstActorState(); static_cast<IntroFirstActor*>(this)->destroy(); return 0; }
															#line 7116 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<IntroFirstActor*>(this)->SAV< int >::value()) int(x);
		this->~IntroFirstActorState();
		static_cast<IntroFirstActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IntroFirstActor*>(this)->actor_wait_state > 0) static_cast<IntroFirstActor*>(this)->actor_wait_state = 0;
		static_cast<IntroFirstActor*>(this)->ActorCallback< IntroFirstActor, 0, int >::remove();
		static_cast<IntroFirstActor*>(this)->ActorCallback< IntroFirstActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< IntroFirstActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("introFirst", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IntroFirstActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("introFirst", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IntroFirstActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("introFirst", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IntroFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introFirst", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IntroFirstActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("introFirst", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introFirst", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IntroFirstActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("introFirst", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introFirst", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IntroFirstActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("introFirst", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IntroFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introFirst", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> a;
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	Future<int> b;
															#line 7249 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via introFirst()
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class IntroFirstActor final : public Actor<int>, public ActorCallback< IntroFirstActor, 0, int >, public ActorCallback< IntroFirstActor, 1, int >, public FastAllocated<IntroFirstActor>, public IntroFirstActorState<IntroFirstActor> {
															#line 7254 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<IntroFirstActor>::operator new;
	using FastAllocated<IntroFirstActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17860356181103486464UL, 6962127935284589312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IntroFirstActor, 0, int >;
friend struct ActorCallback< IntroFirstActor, 1, int >;
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	IntroFirstActor(Future<int> const& a,Future<int> const& b) 
															#line 7272 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<int>(),
		   IntroFirstActorState<IntroFirstActor>(a, b),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("introFirst", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18009655842323775488UL, 14988105110048362496UL);
		ActorExecutionContextHelper __helper(static_cast<IntroFirstActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("introFirst");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("introFirst", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IntroFirstActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<int> introFirst( Future<int> const& a, Future<int> const& b ) {
															#line 968 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<int>(new IntroFirstActor(a, b));
															#line 7305 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 978 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

struct AddReply {
	int sum;
	AddReply() {}
	AddReply(int x) : sum(x) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, sum);
	}
};

struct AddRequest {
	int a, b;
	Promise<AddReply> reply; // Self-addressed envelope

	AddRequest() {}
	AddRequest(int a, int b) : a(a), b(b) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, a, b, reply);
	}
};

															#line 7334 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via introAddServer()
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class IntroAddServerActor>
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class IntroAddServerActorState {
															#line 7341 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	IntroAddServerActorState(PromiseStream<AddRequest> const& add) 
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : add(add)
															#line 7348 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("introAddServer", reinterpret_cast<unsigned long>(this));

	}
	~IntroAddServerActorState() 
	{
		fdb_probe_actor_destroy("introAddServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1004 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 7363 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<IntroAddServerActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1005 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		auto __when_expr_0 = add.getFuture();
															#line 7392 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<AddRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<AddRequest>>::value, "invalid type");
															#line 1004 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 7396 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_cast<IntroAddServerActor*>(this)->actor_wait_state = 1;
															#line 1005 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< IntroAddServerActor, 0, AddRequest >*>(static_cast<IntroAddServerActor*>(this)));
															#line 7400 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(AddRequest const& req,int loopDepth) 
	{
															#line 1006 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		printf("%d + %d = %d\n", req.a, req.b, req.a + req.b);
															#line 1007 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		req.reply.send(req.a + req.b);
															#line 7417 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(AddRequest && req,int loopDepth) 
	{
															#line 1006 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		printf("%d + %d = %d\n", req.a, req.b, req.a + req.b);
															#line 1007 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		req.reply.send(req.a + req.b);
															#line 7428 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IntroAddServerActor*>(this)->actor_wait_state > 0) static_cast<IntroAddServerActor*>(this)->actor_wait_state = 0;
		static_cast<IntroAddServerActor*>(this)->ActorSingleCallback< IntroAddServerActor, 0, AddRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< IntroAddServerActor, 0, AddRequest >*,AddRequest const& value) 
	{
		fdb_probe_actor_enter("introAddServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAddServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< IntroAddServerActor, 0, AddRequest >*,AddRequest && value) 
	{
		fdb_probe_actor_enter("introAddServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAddServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< IntroAddServerActor, 0, AddRequest >*,Error err) 
	{
		fdb_probe_actor_enter("introAddServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("introAddServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	PromiseStream<AddRequest> add;
															#line 7498 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via introAddServer()
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class IntroAddServerActor final : public Actor<void>, public ActorSingleCallback< IntroAddServerActor, 0, AddRequest >, public FastAllocated<IntroAddServerActor>, public IntroAddServerActorState<IntroAddServerActor> {
															#line 7503 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<IntroAddServerActor>::operator new;
	using FastAllocated<IntroAddServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14450683933095741440UL, 14794733434111416320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorSingleCallback< IntroAddServerActor, 0, AddRequest >;
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	IntroAddServerActor(PromiseStream<AddRequest> const& add) 
															#line 7520 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<void>(),
		   IntroAddServerActorState<IntroAddServerActor>(add),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("introAddServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13927205048274779904UL, 2955244404977796608UL);
		ActorExecutionContextHelper __helper(static_cast<IntroAddServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("introAddServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("introAddServer", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
void introAddServer( PromiseStream<AddRequest> const& add ) {
															#line 1003 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	new IntroAddServerActor(add);
															#line 7544 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 1011 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

void introPromiseFuture() {
	Promise<int> myPromise;

	Future<int> myFuture = myPromise.getFuture();

	myPromise.send(12345);

	ASSERT(myFuture.isReady() && myFuture.get() == 12345);
}

void introActor() {
	Future<int> f = introLoadValueFromDisk(std::string("/dev/threes"));
	ASSERT(f.get() == 3);

	Promise<int> a, b;
	Future<int> sum = introAdd(a.getFuture(), b.getFuture());
	b.send(3);
	ASSERT(!sum.isReady());
	a.send(2);
	ASSERT(sum.get() == 5);

	Promise<int> c, d;
	Future<int> first = introFirst(c.getFuture(), d.getFuture());
	ASSERT(!first.isReady());
	// d.send(100);
	d.sendError(operation_failed());
	ASSERT(first.isError() && first.getError().code() == error_code_operation_failed);
	// ASSERT( first.getBlocking() == 100 );

	PromiseStream<AddRequest> addInterface;
	introAddServer(addInterface);

	Future<AddReply> reply = addInterface.getReply(AddRequest(5, 2));
	ASSERT(reply.get().sum == 7);

	printf("OK\n");
}

template <int N>
void chainTest() {
	auto startt = timer();
	for (int i = 0; i < 100000; i++) {
		Promise<int> p;
		Future<int> f = chain<N>(p.getFuture());
		p.send(i);
		ASSERT(f.get() == i + N);
	}
	auto endt = timer();
	printf("chain<%d>: %0.3f M/sec\n", N, 0.1 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 100000; i++) {
		Promise<int> p;
		Future<int> f = chain2(p.getFuture(), N);
		p.send(i);
		ASSERT(f.get() == i + N);
	}
	endt = timer();
	printf("chain2<%d>: %0.3f M/sec\n", N, 0.1 / (endt - startt));
}

															#line 7610 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via cycle()
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class CycleActor>
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class CycleActorState {
															#line 7617 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	CycleActorState(FutureStream<Void> const& in,PromiseStream<Void> const& out,int* const& ptotal) 
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : in(in),
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   out(out),
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   ptotal(ptotal)
															#line 7628 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("cycle", reinterpret_cast<unsigned long>(this));

	}
	~CycleActorState() 
	{
		fdb_probe_actor_destroy("cycle", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1074 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 7643 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<CycleActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1075 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		auto __when_expr_0 = in;
															#line 7672 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Void>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Void>>::value, "invalid type");
															#line 1075 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 7676 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_cast<CycleActor*>(this)->actor_wait_state = 1;
															#line 1075 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< CycleActor, 0, Void >*>(static_cast<CycleActor*>(this)));
															#line 7680 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1076 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		(*ptotal)++;
															#line 1077 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		out.send(Void());
															#line 7691 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1076 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		(*ptotal)++;
															#line 1077 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		out.send(Void());
															#line 7702 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CycleActor*>(this)->actor_wait_state > 0) static_cast<CycleActor*>(this)->actor_wait_state = 0;
		static_cast<CycleActor*>(this)->ActorSingleCallback< CycleActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CycleActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycle", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< CycleActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycle", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< CycleActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycle", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	FutureStream<Void> in;
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	PromiseStream<Void> out;
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int* ptotal;
															#line 7788 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via cycle()
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class CycleActor final : public Actor<void>, public ActorSingleCallback< CycleActor, 0, Void >, public FastAllocated<CycleActor>, public CycleActorState<CycleActor> {
															#line 7793 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<CycleActor>::operator new;
	using FastAllocated<CycleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11246897764330203136UL, 9489102953734743296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorSingleCallback< CycleActor, 0, Void >;
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	CycleActor(FutureStream<Void> const& in,PromiseStream<Void> const& out,int* const& ptotal) 
															#line 7810 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<void>(),
		   CycleActorState<CycleActor>(in, out, ptotal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cycle", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3524674519803450624UL, 13786780731853308928UL);
		ActorExecutionContextHelper __helper(static_cast<CycleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cycle");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cycle", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
void cycle( FutureStream<Void> const& in, PromiseStream<Void> const& out, int* const& ptotal ) {
															#line 1073 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	new CycleActor(in, out, ptotal);
															#line 7834 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 1080 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

															#line 7839 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
namespace {
// This generated class is to be used only via cycleTime()
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
template <class CycleTimeActor>
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class CycleTimeActorState {
															#line 7846 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	CycleTimeActorState(int const& nodes,int const& times) 
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		 : nodes(nodes),
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   times(times),
															#line 1082 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   n(nodes),
															#line 1083 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		   total(0)
															#line 7859 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
	{
		fdb_probe_actor_create("cycleTime", reinterpret_cast<unsigned long>(this));

	}
	~CycleTimeActorState() 
	{
		fdb_probe_actor_destroy("cycleTime", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1086 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			for(int i = 1;i < nodes;i++) {
															#line 1087 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
				cycle(n[i].getFuture(), n[(i + 1) % nodes], &total);
															#line 7876 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			}
															#line 1089 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			startT = timer();
															#line 1090 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			n[1].send(Void());
															#line 1091 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
			;
															#line 7884 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CycleTimeActorState();
		static_cast<CycleTimeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1098 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		printf("Ring test: %d nodes, %d total ops, %.3f seconds\n", nodes, total, timer() - startT);
															#line 1099 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!static_cast<CycleTimeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CycleTimeActorState(); static_cast<CycleTimeActor*>(this)->destroy(); return 0; }
															#line 7909 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		new (&static_cast<CycleTimeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CycleTimeActorState();
		static_cast<CycleTimeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1092 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		auto __when_expr_0 = n[0].getFuture();
															#line 7928 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Void>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Void>>::value, "invalid type");
															#line 1092 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (static_cast<CycleTimeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7932 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<CycleTimeActor*>(this)->actor_wait_state = 1;
															#line 1092 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< CycleTimeActor, 0, Void >*>(static_cast<CycleTimeActor*>(this)));
															#line 7937 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1093 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!--times)
															#line 7959 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1095 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		n[1].send(Void());
															#line 7965 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1093 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		if (!--times)
															#line 7974 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1095 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
		n[1].send(Void());
															#line 7980 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CycleTimeActor*>(this)->actor_wait_state > 0) static_cast<CycleTimeActor*>(this)->actor_wait_state = 0;
		static_cast<CycleTimeActor*>(this)->ActorSingleCallback< CycleTimeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CycleTimeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cycleTime", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleTime", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< CycleTimeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cycleTime", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CycleTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleTime", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< CycleTimeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cycleTime", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CycleTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cycleTime", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int nodes;
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int times;
															#line 1082 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	std::vector<PromiseStream<Void>> n;
															#line 1083 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	int total;
															#line 1089 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	double startT;
															#line 8070 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
};
// This generated class is to be used only via cycleTime()
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
class CycleTimeActor final : public Actor<Void>, public ActorSingleCallback< CycleTimeActor, 0, Void >, public FastAllocated<CycleTimeActor>, public CycleTimeActorState<CycleTimeActor> {
															#line 8075 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
public:
	using FastAllocated<CycleTimeActor>::operator new;
	using FastAllocated<CycleTimeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15641986334963123968UL, 3331692441894272000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< CycleTimeActor, 0, Void >;
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	CycleTimeActor(int const& nodes,int const& times) 
															#line 8092 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
		 : Actor<Void>(),
		   CycleTimeActorState<CycleTimeActor>(nodes, times),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cycleTime", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16615777019435961856UL, 17334597702700534784UL);
		ActorExecutionContextHelper __helper(static_cast<CycleTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cycleTime");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cycleTime", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< CycleTimeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
Future<Void> cycleTime( int const& nodes, int const& times ) {
															#line 1081 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"
	return Future<Void>(new CycleTimeActor(nodes, times));
															#line 8125 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbrpc/dsltest.actor.g.cpp"
}

#line 1101 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbrpc/dsltest.actor.cpp"

void sleeptest() {
#ifdef __linux__
	int times[] = { 0, 100, 500, 1000, 5000, 100000, 500000, 1000000 };
	for (int j = 0; j < 8; j++) {
		double b = timer();
		int n = std::min(100, 4000000 / (1 + times[j]));
		for (int i = 0; i < n; i++) {
			timespec ts;
			ts.tv_sec = times[j] / 1000000;
			ts.tv_nsec = (times[j] % 1000000) * 1000;
			clock_nanosleep(CLOCK_MONOTONIC, 0, &ts, nullptr);
			// nanosleep(&ts, nullptr);
		}
		double t = timer() - b;
		printf("Sleep test (%dus x %d): %0.1f\n", times[j], n, double(t) / n * 1e6);
	}
#endif
}

void asyncMapTest() {
	Future<Void> c;

	{
		AsyncMap<int, int> m1;
		m1.set(10, 1);
		ASSERT(m1.get(10) == 1);
		ASSERT(m1.get(20) == 0);
		Future<Void> a = m1.onChange(10);
		Future<Void> b = m1.onChange(20);
		c = m1.onChange(30);
		ASSERT(!a.isReady() && !b.isReady());
		m1.set(10, 0);
		ASSERT(a.isReady() && !a.isError() && !b.isReady() && m1.get(10) == 0);
		m1.set(20, 5);
		ASSERT(b.isReady() && !b.isError() && m1.get(20) == 5);

		a = m1.onChange(10);
		b = m1.onChange(20);
		m1.triggerRange(15, 25);
		ASSERT(!a.isReady() && b.isReady() && !b.isError() && m1.get(20) == 5);
	}
	ASSERT(c.isReady() && c.isError() && c.getError().code() == error_code_broken_promise);

	printf("AsyncMap: OK\n");

	double startt;
	AsyncMap<int, int> m2;
	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		m2.set(5, 0);
		m2.set(5, 1);
	}
	printf("  set(not present/present): %0.1fM/sec\n", 2.0 / (timer() - startt));
	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		m2.set(5, 1);
		m2.set(5, 2);
	}
	printf("  set(present/present): %0.1fM/sec\n", 2.0 / (timer() - startt));
	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		m2.set(5, 1);
	}
	printf("  set(no change): %0.1fM/sec\n", 1.0 / (timer() - startt));

	m2.set(5, 5);
	startt = timer();
	for (int i = 0; i < 1000000; i++)
		m2.onChange(5);
	printf("  onChange(present, cancelled): %0.1fM/sec\n", 1.0 / (timer() - startt));
	startt = timer();
	for (int i = 0; i < 1000000; i++)
		m2.onChange(10);
	printf("  onChange(not present, cancelled): %0.1fM/sec\n", 1.0 / (timer() - startt));
	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		auto f = m2.onChange(10);
		m2.set(10, 1);
		m2.set(10, 0);
	}
	printf("  onChange(not present, set): %0.1fM/sec\n", 1.0 / (timer() - startt));
	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		auto f = m2.onChange(5);
		m2.set(5, i + 1);
	}
	printf("  onChange(present, set): %0.1fM/sec\n", 1.0 / (timer() - startt));
}

extern void net2_test();

void dsltest() {
	double startt, endt;

	setThreadLocalDeterministicRandomSeed(40);

	asyncMapTest();

	net2_test();
	// sleeptest();

	Future<Void> ctf = cycleTime(1000, 1000);
	ctf.get();

	introPromiseFuture();
	introActor();
	// return;

	printf("Actor control flow tests: ");
	actorTest1(true);
	actorTest2(true);
	actorTest3(true);
	// if (g_network == g_simulator)
	// g_simulator->run( actorTest4(true) );
	actorTest5();
	actorTest6();
	actorTest7();
	actorTest8();
	actorTest9();
	actorTest10();

	printf("\n");

	printf("Running actor fuzz tests:\n");
	// Only include this test outside of Windows because of MSVC compiler bug
#ifndef WIN32
	auto afResults = actorFuzzTests();
#else
	std::pair<int, int> afResults(0, 0);
#endif
	printf("Actor fuzz tests: %d/%d passed\n", afResults.first, afResults.second);
	startt = timer();
	for (int i = 0; i < 1000000; i++)
		deterministicRandom()->random01();
	endt = timer();
	printf("Random01: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		Promise<Void>();
	endt = timer();
	printf("Promises: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		Promise<Void>().send(Void());
	endt = timer();
	printf("Promises (with send): %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		Promise<Void> p;
		Future<Void> f = p.getFuture();
		p.send(Void());
		f.get();
	}
	endt = timer();
	printf("Promise/Future/send roundtrip: %0.2f M/sec\n", 1.0 / (endt - startt));

	Promise<Void> p;

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		p.getFuture();
	endt = timer();
	printf("Futures: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		PromiseStream<Void>();
	endt = timer();
	printf("PromiseStreams: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		PromiseStream<Void>().send(Void());
	endt = timer();
	printf("PromiseStreams (with send): %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		PromiseStream<Void> p;
		FutureStream<Void> f = p.getFuture();
		p.send(Void());
		f.pop();
	}
	endt = timer();
	printf("PromiseStream/FutureStream/send/popBlocking roundtrip: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	{
		PromiseStream<int> ps;
		for (int i = 0; i < 1000000; i++) {
			ps.send(i);
		}
	}
	endt = timer();
	printf("PromiseStream queued send: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		cancellable();
	endt = timer();
	printf("Cancellations: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		cancellable2();
	endt = timer();
	printf("Cancellations with catch: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		simple();
	endt = timer();
	printf("Actor creation: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++)
		simpleWait();
	endt = timer();
	printf("With trivial wait: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		Promise<int> p;
		Future<int> f = simpleRet(p.getFuture());
		p.send(i);
		ASSERT(f.get() == i);
	}
	endt = timer();
	printf("Bounce int through actor: %0.2f M/sec\n", 1.0 / (endt - startt));

	startt = timer();
	for (int i = 0; i < 1000000; i++) {
		Promise<int> p;
		Future<int> f = simpleRet(p.getFuture());
		Future<int> g = simpleRet(p.getFuture());
		p.send(i);
		ASSERT(f.get() == i);
		ASSERT(g.get() == i);
	}
	endt = timer();
	printf("Bounce int through two actors in parallel: %0.2f M/sec\n", 1.0 / (endt - startt));

	/*chainTest<1>();
	chainTest<4>();
	chainTest<16>();
	chainTest<64>();

	startt = timer();
	for(int i=0; i<1000000; i++)
	    try {
	        throw success();
	    } catch (Error&) {
	    }
	endt = timer();
	printf("C++ exception: %0.2f M/sec\n", 1.0/(endt-startt));*/

	arenaTest();

	{
		Promise<int> a, b;
		Future<int> c = chooseTest(a.getFuture(), b.getFuture());
		a.send(1);
		b.send(2);
		std::cout << "c=" << c.get() << std::endl;
	}

	{
		Promise<double> i;
		Future<double> d = addN<20>(i.getFuture());
		i.send(1.1);
		std::cout << d.get() << std::endl;
	}

	{
		Promise<double> i;
		i.sendError(operation_failed());
		Future<double> d = addN<20>(i.getFuture());
		if (d.isError() && d.getError().code() == error_code_operation_failed)
			std::cout << "Error transmitted OK" << std::endl;
		else
			std::cout << "Error not transmitted!" << std::endl;
	}

	/*{
	    int na = Actor::allActors.size();
	    PromiseStream<int> t;
	    testStream(t.getFuture());
	    if (Actor::allActors.size() != na+1)
	        std::cout << "Actor not created!" << std::endl;
	    t = PromiseStream<int>();
	    if (Actor::allActors.size() != na)
	        std::cout << "Actor not cleaned up!" << std::endl;
	}*/

	PromiseStream<int> as;
	Promise<double> bs;
	as.send(4);
	Future<Void> sT = switchTest(as.getFuture(), bs.getFuture());
	as.send(5);
	// sT = move(Future<Void>());
	as.send(6);
	bs.send(10.1);
	as.send(7);

	fastAllocTest();

#if FLOW_THREAD_SAFE
	returnCancelRaceTest();
	threadSafetyTest();
	threadSafetyTest2();
#else
	printf("Thread safety disabled.\n");
#endif
}

/*ACTOR Future<Void> pingServer( FutureStream<Promise<bool>> requests, int rate ) {
    state int count = 0;
    loop {
        Promise<bool> req = waitNext( requests );
        req.send( (++count)%rate != 0 );
    }
}

ACTOR Future<int> ping( PromiseStream<Promise<bool>> server ) {
    state int count = 0;
    loop {
        bool result = wait( server.getReply<bool>() );

        count++;
        if (!result)
            break;
    }
    return count;
}

void pingtest() {
    double start = timer();
    PromiseStream<Promise<bool>> serverInterface;
    Future<Void> pS = pingServer( serverInterface.getFuture(), 5000000 );
    Future<int> count = ping( serverInterface );
    double end = timer();
    std::cout << count.get() << " pings completed in " << (end-start) << " sec" << std::endl;
}*/

void copyTest() {
	double start, elapsed;

	Arena arena;
	StringRef s(new (arena) uint8_t[10 << 20], 10 << 20);

	{
		start = timer();
		for (int i = 0; i < 100; i++) {
			StringRef k = s;
			(void)k;
		}
		elapsed = timer() - start;

		printf("StringRef->StringRef: %fs/GB\n", elapsed);
	}

	{
		start = timer();
		for (int i = 0; i < 100; i++)
			Standalone<StringRef> a = s;
		elapsed = timer() - start;

		printf("StringRef->Standalone: %fs/GB\n", elapsed);
	}

	{
		Standalone<StringRef> sa = s;
		start = timer();
		for (int i = 0; i < 100; i++)
			Standalone<StringRef> a = sa;
		elapsed = timer() - start;

		printf("Standalone->Standalone: %fs/GB\n", elapsed);
	}

	{
		Standalone<StringRef> sa = s, sb;
		start = timer();
		for (int i = 0; i < 50; i++) {
			sb = std::move(sa);
			sa = std::move(sb);
		}
		elapsed = timer() - start;
		printf("move(Standalone)->Standalone: %fs/GB\n", elapsed);
	}
}

/*ACTOR void badTest( FutureStream<int> is ) {
    state PromiseStream<int> js;

    loop choose {
        when( int j = waitNext( js.getFuture() ) ) {
            std::cout << "J" << j << std::endl;
        }
        when( int i = waitNext( is ) ) {
            std::cout << "I" << i << std::endl;
            js.send( i );
            std::cout << "-I" << i << std::endl;
        }
    }
}

void dsltest() {
    PromiseStream<int> is;
    badTest( is.getFuture() );
    is.send(1);
    is.send(2);
    is.send(3);
    throw not_implemented();
}
void pingtest() {}*/
