#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
/*
 * CacheRangeCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 37 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
// This generated class is to be used only via cacheRangeCommandActor()
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
template <class CacheRangeCommandActorActor>
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
class CacheRangeCommandActorActorState {
															#line 43 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
public:
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
	CacheRangeCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
		 : db(db),
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
		   tokens(tokens)
															#line 52 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~CacheRangeCommandActorActorState() 
	{
		fdb_probe_actor_destroy("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 36 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
			if (tokens.size() != 4)
															#line 67 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
			{
															#line 37 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 38 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
				if (!static_cast<CacheRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CacheRangeCommandActorActorState(); static_cast<CacheRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 73 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
				new (&static_cast<CacheRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CacheRangeCommandActorActorState();
				static_cast<CacheRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 40 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
				cacheRange = KeyRangeRef(tokens[2], tokens[3]);
															#line 41 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
				if (tokencmp(tokens[1], "set"))
															#line 85 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
				{
															#line 42 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
					StrictFuture<Void> __when_expr_0 = ManagementAPI::addCachedRange(db, cacheRange);
															#line 42 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
					if (static_cast<CacheRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 91 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CacheRangeCommandActorActor*>(this)->actor_wait_state = 1;
															#line 42 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CacheRangeCommandActorActor, 0, Void >*>(static_cast<CacheRangeCommandActorActor*>(this)));
															#line 96 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 43 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
					if (tokencmp(tokens[1], "clear"))
															#line 103 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
					{
															#line 44 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
						StrictFuture<Void> __when_expr_1 = ManagementAPI::removeCachedRange(db, cacheRange);
															#line 44 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
						if (static_cast<CacheRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 109 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<CacheRangeCommandActorActor*>(this)->actor_wait_state = 2;
															#line 44 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CacheRangeCommandActorActor, 1, Void >*>(static_cast<CacheRangeCommandActorActor*>(this)));
															#line 114 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 46 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 47 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
						if (!static_cast<CacheRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CacheRangeCommandActorActorState(); static_cast<CacheRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 123 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
						new (&static_cast<CacheRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~CacheRangeCommandActorActorState();
						static_cast<CacheRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CacheRangeCommandActorActorState();
		static_cast<CacheRangeCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 50 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
		if (!static_cast<CacheRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CacheRangeCommandActorActorState(); static_cast<CacheRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 152 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
		new (&static_cast<CacheRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CacheRangeCommandActorActorState();
		static_cast<CacheRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CacheRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<CacheRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<CacheRangeCommandActorActor*>(this)->ActorCallback< CacheRangeCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CacheRangeCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CacheRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CacheRangeCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CacheRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CacheRangeCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CacheRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CacheRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<CacheRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<CacheRangeCommandActorActor*>(this)->ActorCallback< CacheRangeCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CacheRangeCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CacheRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CacheRangeCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CacheRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CacheRangeCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CacheRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 40 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
	KeyRangeRef cacheRange;
															#line 352 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
};
// This generated class is to be used only via cacheRangeCommandActor()
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
class CacheRangeCommandActorActor final : public Actor<bool>, public ActorCallback< CacheRangeCommandActorActor, 0, Void >, public ActorCallback< CacheRangeCommandActorActor, 1, Void >, public FastAllocated<CacheRangeCommandActorActor>, public CacheRangeCommandActorActorState<CacheRangeCommandActorActor> {
															#line 357 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
public:
	using FastAllocated<CacheRangeCommandActorActor>::operator new;
	using FastAllocated<CacheRangeCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8669347370783401728UL, 17344350277897205248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CacheRangeCommandActorActor, 0, Void >;
friend struct ActorCallback< CacheRangeCommandActorActor, 1, Void >;
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
	CacheRangeCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 375 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
		 : Actor<bool>(),
		   CacheRangeCommandActorActorState<CacheRangeCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7874281198565369856UL, 16129143881087435264UL);
		ActorExecutionContextHelper __helper(static_cast<CacheRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cacheRangeCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cacheRangeCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CacheRangeCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CacheRangeCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
[[nodiscard]] Future<bool> cacheRangeCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 35 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"
	return Future<bool>(new CacheRangeCommandActorActor(db, tokens));
															#line 408 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/build_output/fdbcli/CacheRangeCommand.actor.g.cpp"
}

#line 52 "/codebuild/output/src3112615453/src/github.com/apple/foundationdb/fdbcli/CacheRangeCommand.actor.cpp"

CommandFactory cacheRangeFactory(
    "cache_range",
    CommandHelp(
        "cache_range <set|clear> <BEGINKEY> <ENDKEY>",
        "Mark a key range to add to or remove from storage caches.",
        "Use the storage caches to assist in balancing hot read shards. Set the appropriate ranges when experiencing "
        "heavy load, and clear them when they are no longer necessary."));

} // namespace fdb_cli
