#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
/*
 * BackupAndRestoreValidation.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Simplified backup and restore workload specifically for restore validation testing
// This avoids the complexity of BackupAndRestoreCorrectness which is used by many tests

// Completion marker key to signal that restore is fully done
const KeyRef restoreValidationCompletionKey = "\xff\x02/restoreValidationComplete"_sr;
struct BackupAndRestoreValidationWorkload : TestWorkload {
	static constexpr auto NAME = "BackupAndRestoreValidation";
	double backupAfter, restoreAfter;
	Key backupTag;
	Key addPrefix; // Prefix to add during restore (e.g., \xff\x02/rlog/)

	BackupAndRestoreValidationWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupAfter = getOption(options, "backupAfter"_sr, 10.0);
		restoreAfter = getOption(options, "restoreAfter"_sr, 30.0);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		addPrefix = unprintable(getOption(options, "addPrefix"_sr, ""_sr).toString());

		TraceEvent("BARV_Init")
		    .detail("BackupAfter", backupAfter)
		    .detail("RestoreAfter", restoreAfter)
		    .detail("AddPrefix", printable(addPrefix));
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 67 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
// This generated class is to be used only via doBackup()
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
template <class DoBackupActor>
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
class DoBackupActorState {
															#line 73 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
public:
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	DoBackupActorState(BackupAndRestoreValidationWorkload* const& self,FileBackupAgent* const& backupAgent,Database const& cx) 
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		 : self(self),
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   backupAgent(backupAgent),
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   cx(cx),
															#line 68 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   backupContainer("file://simfdb/backups/"),
															#line 69 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   backupRanges()
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			backupRanges.push_back_deep(backupRanges.arena(), normalKeys);
															#line 74 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			TraceEvent("BARV_SubmitBackup").detail("Tag", printable(self->backupTag)).detail("Container", backupContainer);
															#line 105 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			try {
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent->submitBackup(cx, StringRef(backupContainer), {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 100), self->backupTag.toString(), backupRanges, true, StopWhenDone{ true });
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 116 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 93 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_WaitBackup").detail("Tag", printable(self->backupTag));
															#line 94 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<EBackupState> __when_expr_1 = backupAgent->waitBackup(cx, self->backupTag.toString(), StopWhenDone::True);
															#line 94 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 149 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 94 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 154 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			TraceEvent("BARV_SubmitBackupException").error(e);
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 166 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			{
															#line 89 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 170 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 97 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_BackupComplete") .detail("Tag", printable(self->backupTag)) .detail("Status", BackupAgentBase::getStateText(statusValue));
															#line 101 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 288 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState const& __statusValue,int loopDepth) 
	{
															#line 94 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		statusValue = __statusValue;
															#line 300 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState && __statusValue,int loopDepth) 
	{
		statusValue = std::move(__statusValue);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	BackupAndRestoreValidationWorkload* self;
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Database cx;
															#line 68 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	std::string backupContainer;
															#line 69 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 94 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	EBackupState statusValue;
															#line 387 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doBackup()
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, EBackupState >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 392 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7476982244455206144UL, 17988230037379397376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, EBackupState >;
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	DoBackupActor(BackupAndRestoreValidationWorkload* const& self,FileBackupAgent* const& backupAgent,Database const& cx) 
															#line 410 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, backupAgent, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, EBackupState >*)0, actor_cancelled()); break;
		}

	}
};
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupAndRestoreValidationWorkload* const& self, FileBackupAgent* const& backupAgent, Database const& cx ) {
															#line 65 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	return Future<Void>(new DoBackupActor(self, backupAgent, cx));
															#line 443 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
}

#line 103 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"

																#line 448 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
// This generated class is to be used only via doRestore()
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
template <class DoRestoreActor>
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
class DoRestoreActorState {
															#line 454 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
public:
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	DoRestoreActorState(BackupAndRestoreValidationWorkload* const& self,FileBackupAgent* const& backupAgent,Database const& cx,Reference<IBackupContainer> const& backupContainer) 
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		 : self(self),
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   backupAgent(backupAgent),
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   cx(cx),
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   backupContainer(backupContainer),
															#line 108 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   restoreRanges()
															#line 469 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doRestore", reinterpret_cast<unsigned long>(this));

	}
	~DoRestoreActorState() 
	{
		fdb_probe_actor_destroy("doRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			restoreRanges.push_back_deep(restoreRanges.arena(), normalKeys);
															#line 113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			restoreTag = Standalone<StringRef>(self->backupTag.toString() + "_restore");
															#line 115 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			TraceEvent("BARV_StartRestore") .detail("Tag", printable(restoreTag)) .detail("Container", backupContainer->getURL()) .detail("AddPrefix", printable(self->addPrefix));
															#line 123 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(backupAgent->restore(cx, cx, restoreTag, KeyRef(backupContainer->getURL()), backupContainer->getProxy(), restoreRanges, WaitForComplete::True, ::invalidVersion, Verbose::True, self->addPrefix, Key(), LockDB{ false }, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, backupContainer->getEncryptionKeyFileName()));
															#line 123 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			if (static_cast<DoRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 492 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoRestoreActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoRestoreActor, 0, Void >*>(static_cast<DoRestoreActor*>(this)));
															#line 497 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoRestoreActorState();
		static_cast<DoRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 141 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_RestoreComplete") .detail("Tag", printable(restoreTag)) .detail("AddPrefix", printable(self->addPrefix));
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 524 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoRestoreActor*>(this)->actor_wait_state = 2;
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoRestoreActor, 1, Void >*>(static_cast<DoRestoreActor*>(this)));
															#line 529 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 141 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_RestoreComplete") .detail("Tag", printable(restoreTag)) .detail("AddPrefix", printable(self->addPrefix));
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 542 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoRestoreActor*>(this)->actor_wait_state = 2;
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoRestoreActor, 1, Void >*>(static_cast<DoRestoreActor*>(this)));
															#line 547 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state > 0) static_cast<DoRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<DoRestoreActor*>(this)->ActorCallback< DoRestoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoRestoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_RestoreDataStabilizationWait").detail("WaitTime", 5.0);
															#line 151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		completionMarker = restoreValidationCompletionKey;
															#line 152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		markTr = Transaction(cx);
															#line 153 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		;
															#line 637 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 148 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_RestoreDataStabilizationWait").detail("WaitTime", 5.0);
															#line 151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		completionMarker = restoreValidationCompletionKey;
															#line 152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		markTr = Transaction(cx);
															#line 153 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		;
															#line 652 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state > 0) static_cast<DoRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<DoRestoreActor*>(this)->ActorCallback< DoRestoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoRestoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 167 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_4 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); tr->clear(databaseLockedKey); return Void(); });
															#line 167 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 738 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<DoRestoreActor*>(this)->actor_wait_state = 5;
															#line 167 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoRestoreActor, 4, Void >*>(static_cast<DoRestoreActor*>(this)));
															#line 743 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			markTr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 156 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			markTr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			markTr.set(completionMarker, "1"_sr);
															#line 158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			StrictFuture<Void> __when_expr_2 = markTr.commit();
															#line 158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			if (static_cast<DoRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 768 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoRestoreActor*>(this)->actor_wait_state = 3;
															#line 158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoRestoreActor, 2, Void >*>(static_cast<DoRestoreActor*>(this)));
															#line 773 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			StrictFuture<Void> __when_expr_3 = markTr.onError(e);
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			if (static_cast<DoRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 810 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoRestoreActor*>(this)->actor_wait_state = 4;
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoRestoreActor, 3, Void >*>(static_cast<DoRestoreActor*>(this)));
															#line 815 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_RestoreCompletionMarkerSet").detail("MarkerKey", printable(completionMarker));
															#line 830 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_RestoreCompletionMarkerSet").detail("MarkerKey", printable(completionMarker));
															#line 839 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state > 0) static_cast<DoRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<DoRestoreActor*>(this)->ActorCallback< DoRestoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoRestoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state > 0) static_cast<DoRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<DoRestoreActor*>(this)->ActorCallback< DoRestoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoRestoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_DatabaseUnlocked").detail("Tag", printable(restoreTag));
															#line 176 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (!static_cast<DoRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoRestoreActorState(); static_cast<DoRestoreActor*>(this)->destroy(); return 0; }
															#line 1012 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		new (&static_cast<DoRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoRestoreActorState();
		static_cast<DoRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_DatabaseUnlocked").detail("Tag", printable(restoreTag));
															#line 176 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (!static_cast<DoRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoRestoreActorState(); static_cast<DoRestoreActor*>(this)->destroy(); return 0; }
															#line 1026 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		new (&static_cast<DoRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoRestoreActorState();
		static_cast<DoRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoRestoreActor*>(this)->actor_wait_state > 0) static_cast<DoRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<DoRestoreActor*>(this)->ActorCallback< DoRestoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoRestoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoRestoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	BackupAndRestoreValidationWorkload* self;
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Database cx;
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Reference<IBackupContainer> backupContainer;
															#line 108 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> restoreRanges;
															#line 113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Standalone<StringRef> restoreTag;
															#line 151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Key completionMarker;
															#line 152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Transaction markTr;
															#line 1125 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doRestore()
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
class DoRestoreActor final : public Actor<Void>, public ActorCallback< DoRestoreActor, 0, Void >, public ActorCallback< DoRestoreActor, 1, Void >, public ActorCallback< DoRestoreActor, 2, Void >, public ActorCallback< DoRestoreActor, 3, Void >, public ActorCallback< DoRestoreActor, 4, Void >, public FastAllocated<DoRestoreActor>, public DoRestoreActorState<DoRestoreActor> {
															#line 1130 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoRestoreActor>::operator new;
	using FastAllocated<DoRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2256484338007661568UL, 15905657158514881024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoRestoreActor, 0, Void >;
friend struct ActorCallback< DoRestoreActor, 1, Void >;
friend struct ActorCallback< DoRestoreActor, 2, Void >;
friend struct ActorCallback< DoRestoreActor, 3, Void >;
friend struct ActorCallback< DoRestoreActor, 4, Void >;
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	DoRestoreActor(BackupAndRestoreValidationWorkload* const& self,FileBackupAgent* const& backupAgent,Database const& cx,Reference<IBackupContainer> const& backupContainer) 
															#line 1151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoRestoreActorState<DoRestoreActor>(self, backupAgent, cx, backupContainer),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13842767227687580928UL, 16676647617737226496UL);
		ActorExecutionContextHelper __helper(static_cast<DoRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoRestoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoRestoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoRestoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoRestoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoRestoreActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
[[nodiscard]] static Future<Void> doRestore( BackupAndRestoreValidationWorkload* const& self, FileBackupAgent* const& backupAgent, Database const& cx, Reference<IBackupContainer> const& backupContainer ) {
															#line 104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	return Future<Void>(new DoRestoreActor(self, backupAgent, cx, backupContainer));
															#line 1187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
}

#line 178 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"

																#line 1192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
template <class _startActor>
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
class _startActorState {
															#line 1198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
public:
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	_startActorState(Database const& cx,BackupAndRestoreValidationWorkload* const& self) 
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		 : cx(cx),
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		   self(self)
															#line 1207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 181 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			if (self->clientId != 0)
															#line 1222 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			{
															#line 182 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1226 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 185 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			backupAgent = FileBackupAgent();
															#line 186 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			randomID = nondeterministicRandom()->randomUniqueID();
															#line 187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			retryCount = 0;
															#line 189 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			;
															#line 1240 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1263 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->backupAfter);
															#line 192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1285 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
			if (e.code() == error_code_grv_proxy_memory_limit_exceeded || e.code() == error_code_commit_proxy_memory_limit_exceeded || e.code() == error_code_database_locked || e.code() == error_code_transaction_too_old || e.code() == error_code_future_version)
															#line 1325 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			{
															#line 225 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				retryCount++;
															#line 226 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				double backoff = std::min(1.0, 0.1 * retryCount);
															#line 227 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				TraceEvent(SevWarn, "BARV_RetryableError", randomID) .error(e) .detail("RetryCount", retryCount) .detail("BackoffSeconds", backoff);
															#line 231 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				StrictFuture<Void> __when_expr_6 = delay(backoff);
															#line 231 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1337 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 231 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1342 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 237 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				TraceEvent(SevError, "BARV_Error", randomID).error(e).detail("RetryCount", retryCount);
															#line 238 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1351 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_StartBackup", randomID) .detail("Tag", printable(self->backupTag)) .detail("RetryCount", retryCount);
															#line 198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_1 = doBackup(self, &backupAgent, cx);
															#line 198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1370 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1375 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_StartBackup", randomID) .detail("Tag", printable(self->backupTag)) .detail("RetryCount", retryCount);
															#line 198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_1 = doBackup(self, &backupAgent, cx);
															#line 198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1388 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1393 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		keyBackedTag = makeBackupTag(self->backupTag.toString());
															#line 202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<UidAndAbortedFlagT> __when_expr_2 = keyBackedTag.getOrThrow(cx.getReference());
															#line 202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1481 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, UidAndAbortedFlagT >*>(static_cast<_startActor*>(this)));
															#line 1486 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		keyBackedTag = makeBackupTag(self->backupTag.toString());
															#line 202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<UidAndAbortedFlagT> __when_expr_2 = keyBackedTag.getOrThrow(cx.getReference());
															#line 202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1499 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, UidAndAbortedFlagT >*>(static_cast<_startActor*>(this)));
															#line 1504 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		logUid = uidFlag.first;
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_3 = BackupConfig(logUid).backupContainer().getD(cx.getReference());
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1592 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Reference<IBackupContainer> >*>(static_cast<_startActor*>(this)));
															#line 1597 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		logUid = uidFlag.first;
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_3 = BackupConfig(logUid).backupContainer().getD(cx.getReference());
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1610 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Reference<IBackupContainer> >*>(static_cast<_startActor*>(this)));
															#line 1615 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(UidAndAbortedFlagT const& uidFlag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(uidFlag, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(UidAndAbortedFlagT && uidFlag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(uidFlag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(self->restoreAfter - self->backupAfter);
															#line 208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1701 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1706 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Reference<IBackupContainer> const& __backupContainer,int loopDepth) 
	{
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		backupContainer = __backupContainer;
															#line 1715 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Reference<IBackupContainer> && __backupContainer,int loopDepth) 
	{
		backupContainer = std::move(__backupContainer);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Reference<IBackupContainer> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Reference<IBackupContainer> >*,Reference<IBackupContainer> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Reference<IBackupContainer> >*,Reference<IBackupContainer> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Reference<IBackupContainer> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_StartRestore", randomID) .detail("Tag", printable(self->backupTag)) .detail("Container", backupContainer->getURL());
															#line 214 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_5 = doRestore(self, &backupAgent, cx, backupContainer);
															#line 214 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1798 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 214 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_StartRestore", randomID) .detail("Tag", printable(self->backupTag)) .detail("Container", backupContainer->getURL());
															#line 214 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		StrictFuture<Void> __when_expr_5 = doRestore(self, &backupAgent, cx, backupContainer);
															#line 214 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1816 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 214 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1821 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_Complete", randomID).detail("Tag", printable(self->backupTag));
															#line 1905 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		TraceEvent("BARV_Complete", randomID).detail("Tag", printable(self->backupTag));
															#line 1914 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		self->backupAfter = 0.0;
															#line 234 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		self->restoreAfter = self->restoreAfter - self->backupAfter;
															#line 2006 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		self->backupAfter = 0.0;
															#line 234 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
		self->restoreAfter = self->restoreAfter - self->backupAfter;
															#line 2017 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Database cx;
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	BackupAndRestoreValidationWorkload* self;
															#line 185 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	FileBackupAgent backupAgent;
															#line 186 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	UID randomID;
															#line 187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	int retryCount;
															#line 201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	KeyBackedTag keyBackedTag;
															#line 203 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	UID logUid;
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	Reference<IBackupContainer> backupContainer;
															#line 2113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, UidAndAbortedFlagT >, public ActorCallback< _startActor, 3, Reference<IBackupContainer> >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2118 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13325985897348932352UL, 17891118275513609728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, UidAndAbortedFlagT >;
friend struct ActorCallback< _startActor, 3, Reference<IBackupContainer> >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	_startActor(Database const& cx,BackupAndRestoreValidationWorkload* const& self) 
															#line 2141 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Reference<IBackupContainer> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupAndRestoreValidationWorkload* const& self ) {
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 2179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupAndRestoreValidation.actor.g.cpp.py_gen"
}

#line 245 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/BackupAndRestoreValidation.actor.cpp"
};

WorkloadFactory<BackupAndRestoreValidationWorkload> BackupAndRestoreValidationWorkloadFactory;
