#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
/*
 * AsyncFileCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>

#include "fmt/format.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ActorCollection.h"
#include "flow/IRandom.h"
#include "flow/SystemMonitor.h"
#include "fdbserver/workloads/AsyncFile.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// An enumeration representing the type of operation to be performed in a correctness test operation
enum OperationType { READ, WRITE, SYNC, REOPEN, TRUNCATE };

// Stores information about an operation that is executed on the file
struct OperationInfo {
	Reference<AsyncFileBuffer> data;

	uint64_t offset;
	uint64_t length;

	bool flushOperations;
	OperationType operation;
	int index;
};

struct AsyncFileCorrectnessWorkload : public AsyncFileWorkload {
	static constexpr auto NAME = "AsyncFileCorrectness";
	// Maximum number of bytes operated on by a file operation
	int maxOperationSize;

	// The number of simultaneous outstanding operations on a file
	int numSimultaneousOperations;

	// The futures for asynchronous IO operations
	std::vector<Future<OperationInfo>> operations;

	// Our in memory representation of what the file should be
	Reference<AsyncFileBuffer> memoryFile;

	// A vector holding a lock for each byte in the file. 0xFFFFFFFF means that the byte is being written, any other
	// number means that it is being read that many times
	std::vector<uint32_t> fileLock;

	// A mask designating whether each byte in the file has been explicitly written (bytes which weren't explicitly
	// written have no guarantees about content)
	std::vector<unsigned char> fileValidityMask;

	// Whether or not the correctness test succeeds
	bool success;

	// The targeted size of the file (the actual file can be anywhere in size from 1 byte to 2 * targetFileSize)
	int64_t targetFileSize;

	double averageCpuUtilization;
	PerfIntCounter numOperations;

	AsyncFileCorrectnessWorkload(WorkloadContext const& wcx)
	  : AsyncFileWorkload(wcx), memoryFile(nullptr), success(true), numOperations("Num Operations") {
		maxOperationSize = getOption(options, "maxOperationSize"_sr, 4096);
		numSimultaneousOperations = getOption(options, "numSimultaneousOperations"_sr, 10);
		targetFileSize = getOption(options, "targetFileSize"_sr, (uint64_t)163840);

		if (unbufferedIO)
			maxOperationSize = std::max(_PAGE_SIZE, maxOperationSize);

		if (maxOperationSize * numSimultaneousOperations > targetFileSize * 0.25) {
			targetFileSize *= (int)ceil((maxOperationSize * numSimultaneousOperations * 4.0) / targetFileSize);
			fmt::print(
			    "Target file size is insufficient to support {0} simultaneous operations of size {1}; changing to "
			    "{2}\n",
			    numSimultaneousOperations,
			    maxOperationSize,
			    targetFileSize);
		}
	}

	~AsyncFileCorrectnessWorkload() override {}

	Future<Void> setup(Database const& cx) override {
		if (enabled)
			return _setup(this);

		return Void();
	}

																#line 108 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
template <class _setupActor>
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
class _setupActorState {
															#line 114 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
public:
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	_setupActorState(AsyncFileCorrectnessWorkload* const& self) 
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		 : self(self)
															#line 121 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 108 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->memoryFile = self->allocateBuffer(self->targetFileSize);
															#line 109 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->fileLock.resize(self->targetFileSize, 0);
															#line 110 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->fileValidityMask.resize(self->targetFileSize, 0);
															#line 111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->fileSize = 0;
															#line 114 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->openFile(self, IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE, 0666, self->fileSize, true);
															#line 114 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 114 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 186 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	AsyncFileCorrectnessWorkload* self;
															#line 271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 276 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3598449664924412416UL, 3016197228270880256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	_setupActor(AsyncFileCorrectnessWorkload* const& self) 
															#line 293 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _setup( AsyncFileCorrectnessWorkload* const& self ) {
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	return Future<Void>(new _setupActor(self));
															#line 325 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
}

#line 118 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"

	// Updates the memory buffer, locks, and validity mask to a new file size
	void updateMemoryBuffer(int64_t newFileSize) {
		int64_t oldBufferSize = std::max(fileSize, targetFileSize);
		int64_t newBufferSize = std::max(newFileSize, targetFileSize);

		if (oldBufferSize != newBufferSize) {
			Reference<AsyncFileBuffer> newFile = allocateBuffer(newBufferSize);
			memcpy(newFile->buffer, memoryFile->buffer, std::min(newBufferSize, oldBufferSize));

			if (newBufferSize > oldBufferSize)
				memset(&newFile->buffer[oldBufferSize], 0, newBufferSize - oldBufferSize);

			memoryFile = newFile;

			fileLock.resize(newBufferSize, 0);
			fileValidityMask.resize(newBufferSize, 0xFF);
		}

		fileSize = newFileSize;
	}

	Future<Void> start(Database const& cx) override {
		if (enabled)
			return _start(this);

		return Void();
	}

																#line 358 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
template <class _startActor>
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
class _startActorState {
															#line 364 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
public:
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	_startActorState(AsyncFileCorrectnessWorkload* const& self) 
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		 : self(self),
															#line 148 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		   statState()
															#line 373 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 149 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			customSystemMonitor("AsyncFile Metrics", &statState);
															#line 151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(self->runCorrectnessTest(self), self->testDuration, Void());
															#line 151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 392 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 397 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		SystemStatistics stats = customSystemMonitor("AsyncFile Metrics", &statState);
															#line 154 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->averageCpuUtilization = stats.processCPUSeconds / stats.elapsed;
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeout(waitForAll(self->operations), 10, Void());
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 426 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 431 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		SystemStatistics stats = customSystemMonitor("AsyncFile Metrics", &statState);
															#line 154 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->averageCpuUtilization = stats.processCPUSeconds / stats.elapsed;
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeout(waitForAll(self->operations), 10, Void());
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 446 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 451 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 535 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 547 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	AsyncFileCorrectnessWorkload* self;
															#line 148 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	StatisticsState statState;
															#line 634 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 639 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5028043445724771840UL, 7850985418779280896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	_startActor(AsyncFileCorrectnessWorkload* const& self) 
															#line 657 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _start( AsyncFileCorrectnessWorkload* const& self ) {
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	return Future<Void>(new _startActor(self));
															#line 690 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
}

#line 161 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"

																#line 695 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via runCorrectnessTest()
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
template <class RunCorrectnessTestActor>
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
class RunCorrectnessTestActorState {
															#line 701 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
public:
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	RunCorrectnessTestActorState(AsyncFileCorrectnessWorkload* const& self) 
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		 : self(self),
															#line 163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		   postponedOperations(),
															#line 164 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		   validOperations(0)
															#line 712 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runCorrectnessTest", reinterpret_cast<unsigned long>(this));

	}
	~RunCorrectnessTestActorState() 
	{
		fdb_probe_actor_destroy("runCorrectnessTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			;
															#line 727 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunCorrectnessTestActorState();
		static_cast<RunCorrectnessTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 167 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0);
															#line 167 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 759 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state = 1;
															#line 167 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunCorrectnessTestActor, 0, Void >*>(static_cast<RunCorrectnessTestActor*>(this)));
															#line 764 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		for(;self->operations.size() < self->numSimultaneousOperations && postponedOperations.size() == 0;) {
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->operations.push_back( self->processOperation(self, self->generateOperation(self->operations.size(), false)));
															#line 173 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			validOperations++;
															#line 777 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
															#line 177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<OperationInfo> __when_expr_1 = waitForFirst(self->operations);
															#line 177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 783 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state = 2;
															#line 177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >*>(static_cast<RunCorrectnessTestActor*>(this)));
															#line 788 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		for(;self->operations.size() < self->numSimultaneousOperations && postponedOperations.size() == 0;) {
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->operations.push_back( self->processOperation(self, self->generateOperation(self->operations.size(), false)));
															#line 173 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			validOperations++;
															#line 801 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
															#line 177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<OperationInfo> __when_expr_1 = waitForFirst(self->operations);
															#line 177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 807 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state = 2;
															#line 177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >*>(static_cast<RunCorrectnessTestActor*>(this)));
															#line 812 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state > 0) static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunCorrectnessTestActor*>(this)->ActorCallback< RunCorrectnessTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCorrectnessTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunCorrectnessTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunCorrectnessTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(OperationInfo const& info,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (info.operation == READ)
															#line 896 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 181 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			int start = 0;
															#line 182 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			bool isValid = true;
															#line 183 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			int length = std::min(info.length, self->fileLock.size() - info.offset);
															#line 186 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			for(int i = 0;i < length;i++) {
															#line 187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				bool currentValid = self->fileValidityMask[i] > 0;
															#line 188 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				if (start == 0)
															#line 910 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
				{
															#line 189 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					isValid = currentValid;
															#line 914 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 190 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					if (isValid != currentValid || i == length - 1)
															#line 920 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
					{
															#line 193 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						if (isValid && memcmp(&self->fileValidityMask[info.offset + start], &info.data->buffer[start], i - start))
															#line 924 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
						{
															#line 196 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							printf("Read returned incorrect results at %" PRIu64 " of length %" PRIu64 "\n", info.offset, info.length);
															#line 200 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							self->success = false;
															#line 201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							if (!static_cast<RunCorrectnessTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCorrectnessTestActorState(); static_cast<RunCorrectnessTestActor*>(this)->destroy(); return 0; }
															#line 932 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							new (&static_cast<RunCorrectnessTestActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~RunCorrectnessTestActorState();
							static_cast<RunCorrectnessTestActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
						else
						{
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							if (!isValid)
															#line 942 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							{
															#line 205 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
								memcpy( &self->memoryFile->buffer[info.offset + start], &info.data->buffer[start], i - start);
															#line 207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
								memset(&self->fileValidityMask[info.offset + start], 0xFF, i - start);
															#line 948 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							}
						}
															#line 210 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						start = i;
															#line 953 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
					}
				}
															#line 213 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				isValid = currentValid;
															#line 958 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
															#line 217 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			int lockEnd = std::min(info.offset + info.length, (uint64_t)self->fileLock.size());
															#line 218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (lockEnd > self->fileSize)
															#line 964 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 219 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				lockEnd = self->fileLock.size();
															#line 968 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
															#line 221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			for(int i = info.offset;i < lockEnd;i++) {
															#line 222 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				self->fileLock[i]--;
															#line 974 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 226 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (info.operation == WRITE)
															#line 981 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 227 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				memset(&self->fileLock[info.offset], 0, info.length * sizeof(uint32_t));
															#line 985 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
		}
															#line 230 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (postponedOperations.size() == 0)
															#line 990 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 232 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			OperationInfo newOperation = self->generateOperation(info.index);
															#line 235 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (newOperation.flushOperations)
															#line 996 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 236 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				postponedOperations.push_back(newOperation);
															#line 1000 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				self->operations[info.index] = self->processOperation(self, newOperation);
															#line 1006 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
		}
															#line 243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (postponedOperations.size() > 0)
															#line 1011 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 244 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->operations[info.index] = Never();
															#line 245 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			validOperations--;
															#line 1017 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
															#line 249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		;
															#line 1021 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(OperationInfo && info,int loopDepth) 
	{
															#line 180 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (info.operation == READ)
															#line 1030 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 181 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			int start = 0;
															#line 182 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			bool isValid = true;
															#line 183 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			int length = std::min(info.length, self->fileLock.size() - info.offset);
															#line 186 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			for(int i = 0;i < length;i++) {
															#line 187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				bool currentValid = self->fileValidityMask[i] > 0;
															#line 188 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				if (start == 0)
															#line 1044 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
				{
															#line 189 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					isValid = currentValid;
															#line 1048 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
				}
				else
				{
															#line 190 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					if (isValid != currentValid || i == length - 1)
															#line 1054 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
					{
															#line 193 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						if (isValid && memcmp(&self->fileValidityMask[info.offset + start], &info.data->buffer[start], i - start))
															#line 1058 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
						{
															#line 196 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							printf("Read returned incorrect results at %" PRIu64 " of length %" PRIu64 "\n", info.offset, info.length);
															#line 200 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							self->success = false;
															#line 201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							if (!static_cast<RunCorrectnessTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCorrectnessTestActorState(); static_cast<RunCorrectnessTestActor*>(this)->destroy(); return 0; }
															#line 1066 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							new (&static_cast<RunCorrectnessTestActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~RunCorrectnessTestActorState();
							static_cast<RunCorrectnessTestActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
						else
						{
															#line 204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							if (!isValid)
															#line 1076 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							{
															#line 205 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
								memcpy( &self->memoryFile->buffer[info.offset + start], &info.data->buffer[start], i - start);
															#line 207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
								memset(&self->fileValidityMask[info.offset + start], 0xFF, i - start);
															#line 1082 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							}
						}
															#line 210 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						start = i;
															#line 1087 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
					}
				}
															#line 213 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				isValid = currentValid;
															#line 1092 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
															#line 217 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			int lockEnd = std::min(info.offset + info.length, (uint64_t)self->fileLock.size());
															#line 218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (lockEnd > self->fileSize)
															#line 1098 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 219 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				lockEnd = self->fileLock.size();
															#line 1102 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
															#line 221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			for(int i = info.offset;i < lockEnd;i++) {
															#line 222 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				self->fileLock[i]--;
															#line 1108 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 226 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (info.operation == WRITE)
															#line 1115 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 227 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				memset(&self->fileLock[info.offset], 0, info.length * sizeof(uint32_t));
															#line 1119 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
		}
															#line 230 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (postponedOperations.size() == 0)
															#line 1124 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 232 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			OperationInfo newOperation = self->generateOperation(info.index);
															#line 235 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (newOperation.flushOperations)
															#line 1130 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 236 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				postponedOperations.push_back(newOperation);
															#line 1134 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
			else
			{
															#line 239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				self->operations[info.index] = self->processOperation(self, newOperation);
															#line 1140 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
		}
															#line 243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (postponedOperations.size() > 0)
															#line 1145 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 244 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->operations[info.index] = Never();
															#line 245 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			validOperations--;
															#line 1151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
															#line 249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		;
															#line 1155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(OperationInfo const& info,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(info, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(OperationInfo && info,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(info), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state > 0) static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunCorrectnessTestActor*>(this)->ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >*,OperationInfo const& value) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >*,OperationInfo && value) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (!(validOperations == 0 && postponedOperations.size() > 0))
															#line 1252 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 250 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->operations.clear();
															#line 251 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->operations.push_back(self->processOperation(self, postponedOperations.front()));
															#line 252 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<OperationInfo> __when_expr_2 = self->operations.front();
															#line 252 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1264 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state = 3;
															#line 252 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunCorrectnessTestActor, 2, OperationInfo >*>(static_cast<RunCorrectnessTestActor*>(this)));
															#line 1269 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(OperationInfo const& info,int loopDepth) 
	{
															#line 253 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		postponedOperations.erase(postponedOperations.begin());
															#line 254 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->operations.clear();
															#line 1293 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(OperationInfo && info,int loopDepth) 
	{
															#line 253 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		postponedOperations.erase(postponedOperations.begin());
															#line 254 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->operations.clear();
															#line 1304 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(OperationInfo const& info,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(info, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(OperationInfo && info,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(info), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state > 0) static_cast<RunCorrectnessTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunCorrectnessTestActor*>(this)->ActorCallback< RunCorrectnessTestActor, 2, OperationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< RunCorrectnessTestActor, 2, OperationInfo >*,OperationInfo const& value) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunCorrectnessTestActor, 2, OperationInfo >*,OperationInfo && value) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunCorrectnessTestActor, 2, OperationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	AsyncFileCorrectnessWorkload* self;
															#line 163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	std::vector<OperationInfo> postponedOperations;
															#line 164 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	int validOperations;
															#line 1390 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runCorrectnessTest()
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
class RunCorrectnessTestActor final : public Actor<Void>, public ActorCallback< RunCorrectnessTestActor, 0, Void >, public ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >, public ActorCallback< RunCorrectnessTestActor, 2, OperationInfo >, public FastAllocated<RunCorrectnessTestActor>, public RunCorrectnessTestActorState<RunCorrectnessTestActor> {
															#line 1395 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunCorrectnessTestActor>::operator new;
	using FastAllocated<RunCorrectnessTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7702279921054193664UL, 12214469556049977344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunCorrectnessTestActor, 0, Void >;
friend struct ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >;
friend struct ActorCallback< RunCorrectnessTestActor, 2, OperationInfo >;
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	RunCorrectnessTestActor(AsyncFileCorrectnessWorkload* const& self) 
															#line 1414 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunCorrectnessTestActorState<RunCorrectnessTestActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runCorrectnessTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8275645927228638464UL, 15758022618296860928UL);
		ActorExecutionContextHelper __helper(static_cast<RunCorrectnessTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runCorrectnessTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runCorrectnessTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunCorrectnessTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunCorrectnessTestActor, 1, OperationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunCorrectnessTestActor, 2, OperationInfo >*)0, actor_cancelled()); break;
		}

	}
};
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
[[nodiscard]] Future<Void> runCorrectnessTest( AsyncFileCorrectnessWorkload* const& self ) {
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	return Future<Void>(new RunCorrectnessTestActor(self));
															#line 1448 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
}

#line 258 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"

	// Generates a random operation
	OperationInfo generateOperation(int index, bool allowFlushingOperations = true) {
		OperationInfo info;

		do {
			info.flushOperations = false;

			// Cumulative density function for the different operations
			int cdfArray[] = { 0, 1000, 2000, 2100, 2101, 2102 };
			std::vector<int> cdf = std::vector<int>(cdfArray, cdfArray + 6);

			// Choose a random operation type (READ, WRITE, SYNC, REOPEN, TRUNCATE).
			int random = deterministicRandom()->randomInt(0, cdf.back());
			for (int i = 0; i < cdf.size() - 1; i++) {
				if (cdf[i] <= random && random < cdf[i + 1]) {
					info.operation = (OperationType)i;
					break;
				}
			}

			if (info.operation == READ || info.operation == WRITE) {
				int64_t maxOffset;

				// Reads should not exceed the extent of written data
				if (info.operation == READ) {
					maxOffset = fileSize - 1;
					if (maxOffset < 0)
						info.operation = WRITE;
					// Only allow reads once the file has gotten large enough (to prevent blocking on locks)
					if (maxOffset < targetFileSize / 2)
						info.operation = WRITE;
				}

				// Writes can be up to the target file size or the current file size (the current file size could be
				// larger than the target as a result of a truncate)
				if (info.operation == WRITE)
					maxOffset = std::max(fileSize, targetFileSize) - 1;

				// Choose a random offset and length, retrying if that section is already locked
				do {
					// Generate random length and offset
					if (unbufferedIO) {
						info.length =
						    deterministicRandom()->randomInt(1, maxOperationSize / _PAGE_SIZE + 1) * _PAGE_SIZE;
						info.offset =
						    (int64_t)(deterministicRandom()->random01() * maxOffset / _PAGE_SIZE) * _PAGE_SIZE;
					} else {
						info.length = deterministicRandom()->randomInt(1, maxOperationSize);
						info.offset = (int64_t)(deterministicRandom()->random01() * maxOffset);
					}

				} while (checkFileLocked(info.operation, info.offset, info.length));

				// If the operation is a read, increment the read count for each byte
				if (info.operation == READ) {
					// If the read extends past the end of the file, then we have to lock all bytes beyond the end of
					// the file This is so that we can accurately determine if the read count is correct
					int lockEnd = std::min(info.offset + info.length, (uint64_t)fileLock.size());
					if (lockEnd > fileSize)
						lockEnd = fileLock.size();

					for (int i = info.offset; i < lockEnd; i++)
						fileLock[i]++;
				}

				// If the operation is a write, set the write lock for each byte
				else if (info.operation == WRITE) {
					// Don't write past the end of the file
					info.length = std::min(info.length, std::max(targetFileSize, fileSize) - info.offset);
					memset(&fileLock[info.offset], 0xFF, info.length * sizeof(uint32_t));
				}
			} else if (info.operation == REOPEN)
				info.flushOperations = true;
			else if (info.operation == TRUNCATE) {
				info.flushOperations = true;

				// Choose a random length to truncate to
				if (unbufferedIO)
					info.offset =
					    (int64_t)(deterministicRandom()->random01() * (2 * targetFileSize) / _PAGE_SIZE) * _PAGE_SIZE;
				else
					info.offset = (int64_t)(deterministicRandom()->random01() * (2 * targetFileSize));
			}

		} while (!allowFlushingOperations && info.flushOperations);

		info.index = index;
		return info;
	}

	// Checks if a file is already locked for a given set of bytes.  The file is locked if it is being written
	// (fileLock[i] = 0xFFFFFFFF) or if we are trying to perform a write and the read count is nonzero (fileLock[i] !=
	// 0)
	bool checkFileLocked(int operation, int offset, int length) const {
		for (int i = offset; i < offset + length && i < fileLock.size(); i++)
			if (fileLock[i] == 0xFFFFFFFF || (fileLock[i] != 0 && operation == WRITE))
				return true;

		return false;
	}

	// Performs an operation on a file and the memory representation of that file
																#line 1555 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
// This generated class is to be used only via processOperation()
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
template <class ProcessOperationActor>
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
class ProcessOperationActorState {
															#line 1561 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
public:
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	ProcessOperationActorState(AsyncFileCorrectnessWorkload* const& self,OperationInfo const& info) 
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		 : self(self),
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		   info(info)
															#line 1570 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processOperation", reinterpret_cast<unsigned long>(this));

	}
	~ProcessOperationActorState() 
	{
		fdb_probe_actor_destroy("processOperation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 362 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (info.operation == READ)
															#line 1585 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				info.data = self->allocateBuffer(info.length);
															#line 367 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				StrictFuture<int> __when_expr_0 = uncancellable( holdWhile(self->fileHandle, holdWhile(info, self->fileHandle->file->read(info.data->buffer, info.length, info.offset))));
															#line 367 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1593 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ProcessOperationActor*>(this)->actor_wait_state = 1;
															#line 367 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 0, int >*>(static_cast<ProcessOperationActor*>(this)));
															#line 1598 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 377 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				if (info.operation == WRITE)
															#line 1605 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
				{
															#line 378 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					info.data = self->allocateBuffer(info.length);
															#line 379 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					deterministicRandom()->randomBytes(reinterpret_cast<uint8_t*>(info.data->buffer), info.length);
															#line 380 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					memcpy(&self->memoryFile->buffer[info.offset], info.data->buffer, info.length);
															#line 381 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					memset(&self->fileValidityMask[info.offset], 0xFF, info.length);
															#line 385 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_1 = uncancellable(holdWhile( self->fileHandle, holdWhile(info, self->fileHandle->file->write(info.data->buffer, info.length, info.offset))));
															#line 385 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1619 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<ProcessOperationActor*>(this)->actor_wait_state = 2;
															#line 385 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 1, Void >*>(static_cast<ProcessOperationActor*>(this)));
															#line 1624 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 391 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
					if (info.operation == SYNC)
															#line 1631 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
					{
															#line 392 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						info.data = Reference<AsyncFileBuffer>(nullptr);
															#line 393 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						StrictFuture<Void> __when_expr_2 = self->fileHandle->file->sync();
															#line 393 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1639 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
						static_cast<ProcessOperationActor*>(this)->actor_wait_state = 3;
															#line 393 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 2, Void >*>(static_cast<ProcessOperationActor*>(this)));
															#line 1644 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					else
					{
															#line 394 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
						if (info.operation == REOPEN)
															#line 1651 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
						{
															#line 396 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							StrictFuture<Void> __when_expr_3 = self->openFile(self, IAsyncFile::OPEN_READWRITE, 0666, 0, false);
															#line 396 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1657 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when4(__when_expr_3.get(), loopDepth); };
							static_cast<ProcessOperationActor*>(this)->actor_wait_state = 4;
															#line 396 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 3, Void >*>(static_cast<ProcessOperationActor*>(this)));
															#line 1662 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							loopDepth = 0;
						}
						else
						{
															#line 410 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
							if (info.operation == TRUNCATE)
															#line 1669 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
							{
															#line 413 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
								StrictFuture<Void> __when_expr_5 = uncancellable(holdWhile(self->fileHandle, self->fileHandle->file->truncate(info.offset)));
															#line 413 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
								if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1675 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
								if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when5(__when_expr_5.get(), loopDepth); };
								static_cast<ProcessOperationActor*>(this)->actor_wait_state = 6;
															#line 413 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
								__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 5, Void >*>(static_cast<ProcessOperationActor*>(this)));
															#line 1680 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
								loopDepth = 0;
							}
							else
							{
								loopDepth = a_body1cont12(loopDepth);
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessOperationActorState();
		static_cast<ProcessOperationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 424 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		++self->numOperations;
															#line 425 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (!static_cast<ProcessOperationActor*>(this)->SAV<OperationInfo>::futures) { (void)(info); this->~ProcessOperationActorState(); static_cast<ProcessOperationActor*>(this)->destroy(); return 0; }
															#line 1714 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		new (&static_cast<ProcessOperationActor*>(this)->SAV< OperationInfo >::value()) OperationInfo(std::move(info)); // state_var_RVO
		this->~ProcessOperationActorState();
		static_cast<ProcessOperationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int const& numRead,int loopDepth) 
	{
															#line 371 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (numRead != std::min(info.length, self->fileSize - info.offset))
															#line 1726 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			printf("Read reported incorrect number of bytes at %" PRIu64 " of length %" PRIu64 "\n", info.offset, info.length);
															#line 375 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->success = false;
															#line 1732 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int && numRead,int loopDepth) 
	{
															#line 371 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (numRead != std::min(info.length, self->fileSize - info.offset))
															#line 1742 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			printf("Read reported incorrect number of bytes at %" PRIu64 " of length %" PRIu64 "\n", info.offset, info.length);
															#line 375 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->success = false;
															#line 1748 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& numRead,int loopDepth) 
	{
		loopDepth = a_body1cont2(numRead, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && numRead,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(numRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state > 0) static_cast<ProcessOperationActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessOperationActor*>(this)->ActorCallback< ProcessOperationActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessOperationActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 390 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->fileSize = std::max((int64_t)(info.offset + info.length), self->fileSize);
															#line 1839 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 390 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->fileSize = std::max((int64_t)(info.offset + info.length), self->fileSize);
															#line 1848 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state > 0) static_cast<ProcessOperationActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessOperationActor*>(this)->ActorCallback< ProcessOperationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessOperationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state > 0) static_cast<ProcessOperationActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessOperationActor*>(this)->ActorCallback< ProcessOperationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProcessOperationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 397 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<int64_t> __when_expr_4 = self->fileHandle->file->size();
															#line 397 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2033 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<ProcessOperationActor*>(this)->actor_wait_state = 5;
															#line 397 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 4, int64_t >*>(static_cast<ProcessOperationActor*>(this)));
															#line 2038 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 397 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<int64_t> __when_expr_4 = self->fileHandle->file->size();
															#line 397 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2049 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<ProcessOperationActor*>(this)->actor_wait_state = 5;
															#line 397 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 4, int64_t >*>(static_cast<ProcessOperationActor*>(this)));
															#line 2054 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state > 0) static_cast<ProcessOperationActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessOperationActor*>(this)->ActorCallback< ProcessOperationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ProcessOperationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont1(int64_t const& fileSize,int loopDepth) 
	{
															#line 398 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		int64_t fileSizeChange = fileSize - self->fileSize;
															#line 399 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (fileSizeChange >= _PAGE_SIZE)
															#line 2140 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 400 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			fmt::print("Reopened file increased in size by {0} bytes (at most {1} allowed)\n", fileSizeChange, _PAGE_SIZE - 1);
															#line 403 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->success = false;
															#line 2146 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 404 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (fileSizeChange < 0)
															#line 2152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 405 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				fmt::print("Reopened file decreased in size by {} bytes\n", -fileSizeChange);
															#line 406 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				self->success = false;
															#line 2158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
		}
															#line 409 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->updateMemoryBuffer(fileSize);
															#line 2163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1(int64_t && fileSize,int loopDepth) 
	{
															#line 398 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		int64_t fileSizeChange = fileSize - self->fileSize;
															#line 399 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (fileSizeChange >= _PAGE_SIZE)
															#line 2174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 400 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			fmt::print("Reopened file increased in size by {0} bytes (at most {1} allowed)\n", fileSizeChange, _PAGE_SIZE - 1);
															#line 403 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->success = false;
															#line 2180 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
		else
		{
															#line 404 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			if (fileSizeChange < 0)
															#line 2186 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			{
															#line 405 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				fmt::print("Reopened file decreased in size by {} bytes\n", -fileSizeChange);
															#line 406 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
				self->success = false;
															#line 2192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
			}
		}
															#line 409 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->updateMemoryBuffer(fileSize);
															#line 2197 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state > 0) static_cast<ProcessOperationActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessOperationActor*>(this)->ActorCallback< ProcessOperationActor, 4, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 4, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 4, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ProcessOperationActor, 4, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 415 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<int64_t> __when_expr_6 = self->fileHandle->file->size();
															#line 415 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2289 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont13when1(__when_expr_6.get(), loopDepth); };
		static_cast<ProcessOperationActor*>(this)->actor_wait_state = 7;
															#line 415 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 6, int64_t >*>(static_cast<ProcessOperationActor*>(this)));
															#line 2294 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 415 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		StrictFuture<int64_t> __when_expr_6 = self->fileHandle->file->size();
															#line 415 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2305 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont13when1(__when_expr_6.get(), loopDepth); };
		static_cast<ProcessOperationActor*>(this)->actor_wait_state = 7;
															#line 415 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ProcessOperationActor, 6, int64_t >*>(static_cast<ProcessOperationActor*>(this)));
															#line 2310 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state > 0) static_cast<ProcessOperationActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessOperationActor*>(this)->ActorCallback< ProcessOperationActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ProcessOperationActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont13cont1(int64_t const& fileSize,int loopDepth) 
	{
															#line 416 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (fileSize != info.offset)
															#line 2394 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 417 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			printf("Incorrect file size reported after truncate\n");
															#line 418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->success = false;
															#line 2400 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
															#line 421 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->updateMemoryBuffer(fileSize);
															#line 2404 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1(int64_t && fileSize,int loopDepth) 
	{
															#line 416 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		if (fileSize != info.offset)
															#line 2413 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		{
															#line 417 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			printf("Incorrect file size reported after truncate\n");
															#line 418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
			self->success = false;
															#line 2419 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		}
															#line 421 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
		self->updateMemoryBuffer(fileSize);
															#line 2423 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ProcessOperationActor*>(this)->actor_wait_state > 0) static_cast<ProcessOperationActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessOperationActor*>(this)->ActorCallback< ProcessOperationActor, 6, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 6, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ProcessOperationActor, 6, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ProcessOperationActor, 6, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	AsyncFileCorrectnessWorkload* self;
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	OperationInfo info;
															#line 2507 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processOperation()
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
class ProcessOperationActor final : public Actor<OperationInfo>, public ActorCallback< ProcessOperationActor, 0, int >, public ActorCallback< ProcessOperationActor, 1, Void >, public ActorCallback< ProcessOperationActor, 2, Void >, public ActorCallback< ProcessOperationActor, 3, Void >, public ActorCallback< ProcessOperationActor, 4, int64_t >, public ActorCallback< ProcessOperationActor, 5, Void >, public ActorCallback< ProcessOperationActor, 6, int64_t >, public FastAllocated<ProcessOperationActor>, public ProcessOperationActorState<ProcessOperationActor> {
															#line 2512 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessOperationActor>::operator new;
	using FastAllocated<ProcessOperationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2525407463780840704UL, 5547012529994966016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<OperationInfo>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessOperationActor, 0, int >;
friend struct ActorCallback< ProcessOperationActor, 1, Void >;
friend struct ActorCallback< ProcessOperationActor, 2, Void >;
friend struct ActorCallback< ProcessOperationActor, 3, Void >;
friend struct ActorCallback< ProcessOperationActor, 4, int64_t >;
friend struct ActorCallback< ProcessOperationActor, 5, Void >;
friend struct ActorCallback< ProcessOperationActor, 6, int64_t >;
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	ProcessOperationActor(AsyncFileCorrectnessWorkload* const& self,OperationInfo const& info) 
															#line 2535 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
		 : Actor<OperationInfo>(),
		   ProcessOperationActorState<ProcessOperationActor>(self, info),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processOperation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16858648674708670720UL, 3908604917363416320UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessOperationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processOperation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processOperation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessOperationActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessOperationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProcessOperationActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ProcessOperationActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ProcessOperationActor, 4, int64_t >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ProcessOperationActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ProcessOperationActor, 6, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
[[nodiscard]] Future<OperationInfo> processOperation( AsyncFileCorrectnessWorkload* const& self, OperationInfo const& info ) {
															#line 361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"
	return Future<OperationInfo>(new ProcessOperationActor(self, info));
															#line 2573 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AsyncFileCorrectness.actor.g.cpp.py_gen"
}

#line 427 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/workloads/AsyncFileCorrectness.actor.cpp"

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		if (enabled) {
			m.emplace_back("Number of Operations Performed", numOperations.getValue(), Averaged::False);
			m.emplace_back("Average CPU Utilization (Percentage)", averageCpuUtilization * 100, Averaged::False);
		}
	}
};

WorkloadFactory<AsyncFileCorrectnessWorkload> AsyncFileCorrectnessWorkloadFactory;
