#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
/*
 * DDTeamCollection.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <climits>

#include "fdbclient/SystemData.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/DDTeamCollection.h"
#include "fdbserver/ExclusionTracker.actor.h"
#include "fdbserver/DataDistributionTeam.h"
#include "fdbserver/Knobs.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/network.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

// Helper function for STL containers, with flow-friendly error handling
template <class MapContainer, class K>
auto get(MapContainer& m, K const& k) -> decltype(m.at(k)) {
	auto it = m.find(k);
	ASSERT(it != m.end());
	return it->second;
}

} // namespace

namespace data_distribution {
int EligibilityCounter::fromGetTeamRequest(GetTeamRequest const& req) {
	// equivalent to bit set operation
	return req.preferLowerDiskUtil * EligibilityCounter::LOW_DISK_UTIL +
	       // When preferLowerReadUtil, CPU stat is for admittance to eligible pool, and ReadLoad is for sorting inside
	       // the pool.
	       req.preferLowerReadUtil * EligibilityCounter::LOW_CPU;
}

void EligibilityCounter::increase(Type type) {
	type_count[type]++;
}

void EligibilityCounter::reset(Type type) {
	type_count[type] = 0;
}

int EligibilityCounter::getCount(int combinedType) const {
	unsigned minCount = std::numeric_limits<unsigned>::max();
	for (auto& [t, c] : type_count) {
		if ((combinedType & t) > 0 && minCount > c) {
			minCount = c;
		}
	}
	return minCount;
}

} // namespace data_distribution

class DDTeamCollectionImpl {
																#line 79 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via checkAndRemoveInvalidLocalityAddr()
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class CheckAndRemoveInvalidLocalityAddrActor>
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class CheckAndRemoveInvalidLocalityAddrActorState {
															#line 85 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	CheckAndRemoveInvalidLocalityAddrActorState(DDTeamCollection* const& self) 
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 78 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   start(now()),
															#line 79 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   hasCorrectedLocality(false)
															#line 96 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this));

	}
	~CheckAndRemoveInvalidLocalityAddrActorState() 
	{
		fdb_probe_actor_destroy("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 81 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAndRemoveInvalidLocalityAddrActorState();
		static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 138 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckAndRemoveInvalidLocalityAddrActorState(); static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->destroy(); return 0; }
															#line 134 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckAndRemoveInvalidLocalityAddrActorState();
		static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 83 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->DD_CHECK_INVALID_LOCALITY_DELAY, TaskPriority::DataDistribution);
															#line 83 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 156 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 0, Void >*>(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)));
															#line 161 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("CheckAndRemoveInvalidLocalityAddrRetry", self->distributorId).detail("Error", e.what());
															#line 196 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_1 = self->db->getWorkers();
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 213 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state = 2;
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >*>(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)));
															#line 218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_1 = self->db->getWorkers();
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 229 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state = 2;
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >*>(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)));
															#line 234 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state > 0) static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 89 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		existingAddrs = std::set<AddressExclusion>();
															#line 90 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 91 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			const ProcessData& workerData = workers[i];
															#line 92 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			AddressExclusion addr(workerData.address.ip, workerData.address.port);
															#line 93 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			existingAddrs.insert(addr);
															#line 94 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->invalidLocalityAddr.contains(addr) && self->isValidLocality(self->configuration.storagePolicy, workerData.locality))
															#line 328 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 97 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->invalidLocalityAddr.erase(addr);
															#line 98 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				hasCorrectedLocality = true;
															#line 99 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("InvalidLocalityCorrected").detail("Addr", addr.toString());
															#line 336 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 103 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield(TaskPriority::DataDistribution);
															#line 103 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 343 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state = 3;
															#line 103 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 2, Void >*>(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)));
															#line 348 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<ProcessData> const& __workers,int loopDepth) 
	{
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		workers = __workers;
															#line 357 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<ProcessData> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state > 0) static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for(auto addr = self->invalidLocalityAddr.begin();addr != self->invalidLocalityAddr.end();) {
															#line 107 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!existingAddrs.contains(*addr))
															#line 438 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 109 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				addr = self->invalidLocalityAddr.erase(addr);
															#line 110 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				hasCorrectedLocality = true;
															#line 111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("InvalidLocalityNoLongerExists").detail("Addr", addr->toString());
															#line 446 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				++addr;
															#line 452 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 117 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (hasCorrectedLocality)
															#line 457 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 119 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->restartRecruiting.trigger();
															#line 120 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			hasCorrectedLocality = false;
															#line 463 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 123 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (self->invalidLocalityAddr.empty())
															#line 467 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 127 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (now() - start > 300)
															#line 473 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 129 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "PersistentInvalidLocality") .detail("Addresses", self->invalidLocalityAddr.size());
															#line 131 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			start = now();
															#line 479 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for(auto addr = self->invalidLocalityAddr.begin();addr != self->invalidLocalityAddr.end();) {
															#line 107 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!existingAddrs.contains(*addr))
															#line 491 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 109 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				addr = self->invalidLocalityAddr.erase(addr);
															#line 110 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				hasCorrectedLocality = true;
															#line 111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("InvalidLocalityNoLongerExists").detail("Addr", addr->toString());
															#line 499 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				++addr;
															#line 505 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 117 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (hasCorrectedLocality)
															#line 510 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 119 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->restartRecruiting.trigger();
															#line 120 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			hasCorrectedLocality = false;
															#line 516 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 123 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (self->invalidLocalityAddr.empty())
															#line 520 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 127 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (now() - start > 300)
															#line 526 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 129 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "PersistentInvalidLocality") .detail("Addresses", self->invalidLocalityAddr.size());
															#line 131 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			start = now();
															#line 532 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state > 0) static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 78 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	double start;
															#line 79 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool hasCorrectedLocality;
															#line 88 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<ProcessData> workers;
															#line 89 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::set<AddressExclusion> existingAddrs;
															#line 636 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkAndRemoveInvalidLocalityAddr()
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class CheckAndRemoveInvalidLocalityAddrActor final : public Actor<Void>, public ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 0, Void >, public ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >, public ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 2, Void >, public FastAllocated<CheckAndRemoveInvalidLocalityAddrActor>, public CheckAndRemoveInvalidLocalityAddrActorState<CheckAndRemoveInvalidLocalityAddrActor> {
															#line 641 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckAndRemoveInvalidLocalityAddrActor>::operator new;
	using FastAllocated<CheckAndRemoveInvalidLocalityAddrActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10037565439799667712UL, 8158537061955932416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 0, Void >;
friend struct ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >;
friend struct ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 2, Void >;
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	CheckAndRemoveInvalidLocalityAddrActor(DDTeamCollection* const& self) 
															#line 660 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckAndRemoveInvalidLocalityAddrActorState<CheckAndRemoveInvalidLocalityAddrActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4953211407936348416UL, 17716354172561099008UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveInvalidLocalityAddrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAndRemoveInvalidLocalityAddr");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAndRemoveInvalidLocalityAddr", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 1, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckAndRemoveInvalidLocalityAddrActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> checkAndRemoveInvalidLocalityAddr( DDTeamCollection* const& self ) {
															#line 77 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new CheckAndRemoveInvalidLocalityAddrActor(self));
															#line 694 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 140 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

public:
																#line 700 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via logOnCompletion()
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class LogOnCompletionActor>
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class LogOnCompletionActorState {
															#line 706 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	LogOnCompletionActorState(DDTeamCollection* const& self,Future<Void> const& signal) 
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   signal(signal)
															#line 715 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("logOnCompletion", reinterpret_cast<unsigned long>(this));

	}
	~LogOnCompletionActorState() 
	{
		fdb_probe_actor_destroy("logOnCompletion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = signal;
															#line 143 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<LogOnCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 732 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LogOnCompletionActor*>(this)->actor_wait_state = 1;
															#line 143 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogOnCompletionActor, 0, Void >*>(static_cast<LogOnCompletionActor*>(this)));
															#line 737 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogOnCompletionActorState();
		static_cast<LogOnCompletionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 144 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->LOG_ON_COMPLETION_DELAY, TaskPriority::DataDistribution);
															#line 144 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<LogOnCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 762 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogOnCompletionActor*>(this)->actor_wait_state = 2;
															#line 144 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogOnCompletionActor, 1, Void >*>(static_cast<LogOnCompletionActor*>(this)));
															#line 767 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 144 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->LOG_ON_COMPLETION_DELAY, TaskPriority::DataDistribution);
															#line 144 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<LogOnCompletionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 778 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LogOnCompletionActor*>(this)->actor_wait_state = 2;
															#line 144 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LogOnCompletionActor, 1, Void >*>(static_cast<LogOnCompletionActor*>(this)));
															#line 783 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogOnCompletionActor*>(this)->actor_wait_state > 0) static_cast<LogOnCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<LogOnCompletionActor*>(this)->ActorCallback< LogOnCompletionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogOnCompletionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logOnCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogOnCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logOnCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogOnCompletionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logOnCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogOnCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logOnCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogOnCompletionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logOnCompletion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogOnCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logOnCompletion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->primary || self->configuration.usableRegions == 1)
															#line 867 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("DDTrackerStarting", self->distributorId) .detail("State", "Active") .trackLatest(self->ddTrackerStartingEventHolder->trackingKey);
															#line 871 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<LogOnCompletionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogOnCompletionActorState(); static_cast<LogOnCompletionActor*>(this)->destroy(); return 0; }
															#line 875 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<LogOnCompletionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogOnCompletionActorState();
		static_cast<LogOnCompletionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 146 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->primary || self->configuration.usableRegions == 1)
															#line 887 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("DDTrackerStarting", self->distributorId) .detail("State", "Active") .trackLatest(self->ddTrackerStartingEventHolder->trackingKey);
															#line 891 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<LogOnCompletionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogOnCompletionActorState(); static_cast<LogOnCompletionActor*>(this)->destroy(); return 0; }
															#line 895 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<LogOnCompletionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogOnCompletionActorState();
		static_cast<LogOnCompletionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LogOnCompletionActor*>(this)->actor_wait_state > 0) static_cast<LogOnCompletionActor*>(this)->actor_wait_state = 0;
		static_cast<LogOnCompletionActor*>(this)->ActorCallback< LogOnCompletionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogOnCompletionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logOnCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogOnCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logOnCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LogOnCompletionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logOnCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogOnCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logOnCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LogOnCompletionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logOnCompletion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogOnCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logOnCompletion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> signal;
															#line 982 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via logOnCompletion()
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class LogOnCompletionActor final : public Actor<Void>, public ActorCallback< LogOnCompletionActor, 0, Void >, public ActorCallback< LogOnCompletionActor, 1, Void >, public FastAllocated<LogOnCompletionActor>, public LogOnCompletionActorState<LogOnCompletionActor> {
															#line 987 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<LogOnCompletionActor>::operator new;
	using FastAllocated<LogOnCompletionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6440945541892213760UL, 8319782791875350016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogOnCompletionActor, 0, Void >;
friend struct ActorCallback< LogOnCompletionActor, 1, Void >;
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	LogOnCompletionActor(DDTeamCollection* const& self,Future<Void> const& signal) 
															#line 1005 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LogOnCompletionActorState<LogOnCompletionActor>(self, signal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logOnCompletion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11128075462218484992UL, 3363230868736052736UL);
		ActorExecutionContextHelper __helper(static_cast<LogOnCompletionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logOnCompletion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logOnCompletion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogOnCompletionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LogOnCompletionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> logOnCompletion( DDTeamCollection* const& self, Future<Void> const& signal ) {
															#line 142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new LogOnCompletionActor(self, signal));
															#line 1038 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 154 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 1043 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via interruptableBuildTeams()
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class InterruptableBuildTeamsActor>
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class InterruptableBuildTeamsActorState {
															#line 1049 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	InterruptableBuildTeamsActorState(DDTeamCollection* const& self) 
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self)
															#line 1056 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("interruptableBuildTeams", reinterpret_cast<unsigned long>(this));

	}
	~InterruptableBuildTeamsActorState() 
	{
		fdb_probe_actor_destroy("interruptableBuildTeams", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!self->addSubsetComplete.isSet())
															#line 1071 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_0 = addSubsetOfEmergencyTeams(self);
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (static_cast<InterruptableBuildTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1077 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<InterruptableBuildTeamsActor*>(this)->actor_wait_state = 1;
															#line 157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InterruptableBuildTeamsActor, 0, Void >*>(static_cast<InterruptableBuildTeamsActor*>(this)));
															#line 1082 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InterruptableBuildTeamsActorState();
		static_cast<InterruptableBuildTeamsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 161 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 1110 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->addSubsetComplete.send(Void());
															#line 1119 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->addSubsetComplete.send(Void());
															#line 1128 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InterruptableBuildTeamsActor*>(this)->actor_wait_state > 0) static_cast<InterruptableBuildTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<InterruptableBuildTeamsActor*>(this)->ActorCallback< InterruptableBuildTeamsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InterruptableBuildTeamsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InterruptableBuildTeamsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InterruptableBuildTeamsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->buildTeams();
															#line 162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<InterruptableBuildTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 166 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->restartTeamBuilder.onTrigger();
															#line 1225 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<InterruptableBuildTeamsActor*>(this)->actor_wait_state = 2;
															#line 163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InterruptableBuildTeamsActor, 1, Void >*>(static_cast<InterruptableBuildTeamsActor*>(this)));
															#line 166 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< InterruptableBuildTeamsActor, 2, Void >*>(static_cast<InterruptableBuildTeamsActor*>(this)));
															#line 1232 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<InterruptableBuildTeamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InterruptableBuildTeamsActorState(); static_cast<InterruptableBuildTeamsActor*>(this)->destroy(); return 0; }
															#line 1247 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<InterruptableBuildTeamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InterruptableBuildTeamsActorState();
		static_cast<InterruptableBuildTeamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<InterruptableBuildTeamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InterruptableBuildTeamsActorState(); static_cast<InterruptableBuildTeamsActor*>(this)->destroy(); return 0; }
															#line 1259 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<InterruptableBuildTeamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InterruptableBuildTeamsActorState();
		static_cast<InterruptableBuildTeamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InterruptableBuildTeamsActor*>(this)->actor_wait_state > 0) static_cast<InterruptableBuildTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<InterruptableBuildTeamsActor*>(this)->ActorCallback< InterruptableBuildTeamsActor, 1, Void >::remove();
		static_cast<InterruptableBuildTeamsActor*>(this)->ActorCallback< InterruptableBuildTeamsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InterruptableBuildTeamsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InterruptableBuildTeamsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InterruptableBuildTeamsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InterruptableBuildTeamsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< InterruptableBuildTeamsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< InterruptableBuildTeamsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 1402 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via interruptableBuildTeams()
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class InterruptableBuildTeamsActor final : public Actor<Void>, public ActorCallback< InterruptableBuildTeamsActor, 0, Void >, public ActorCallback< InterruptableBuildTeamsActor, 1, Void >, public ActorCallback< InterruptableBuildTeamsActor, 2, Void >, public FastAllocated<InterruptableBuildTeamsActor>, public InterruptableBuildTeamsActorState<InterruptableBuildTeamsActor> {
															#line 1407 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<InterruptableBuildTeamsActor>::operator new;
	using FastAllocated<InterruptableBuildTeamsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(181372094051880448UL, 4058285626314169600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InterruptableBuildTeamsActor, 0, Void >;
friend struct ActorCallback< InterruptableBuildTeamsActor, 1, Void >;
friend struct ActorCallback< InterruptableBuildTeamsActor, 2, Void >;
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	InterruptableBuildTeamsActor(DDTeamCollection* const& self) 
															#line 1426 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   InterruptableBuildTeamsActorState<InterruptableBuildTeamsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11095166840214407424UL, 8718892669379080704UL);
		ActorExecutionContextHelper __helper(static_cast<InterruptableBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("interruptableBuildTeams");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("interruptableBuildTeams", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InterruptableBuildTeamsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InterruptableBuildTeamsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> interruptableBuildTeams( DDTeamCollection* const& self ) {
															#line 155 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new InterruptableBuildTeamsActor(self));
															#line 1459 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 170 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 1464 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via checkBuildTeams()
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class CheckBuildTeamsActor>
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class CheckBuildTeamsActorState {
															#line 1470 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	CheckBuildTeamsActorState(DDTeamCollection* const& self) 
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self)
															#line 1477 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkBuildTeams", reinterpret_cast<unsigned long>(this));

	}
	~CheckBuildTeamsActorState() 
	{
		fdb_probe_actor_destroy("checkBuildTeams", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 172 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->checkTeamDelay;
															#line 172 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1494 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state = 1;
															#line 172 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckBuildTeamsActor, 0, Void >*>(static_cast<CheckBuildTeamsActor*>(this)));
															#line 1499 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckBuildTeamsActorState();
		static_cast<CheckBuildTeamsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 1522 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 1531 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state > 0) static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBuildTeamsActor*>(this)->ActorCallback< CheckBuildTeamsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBuildTeamsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckBuildTeamsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckBuildTeamsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 176 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (self->doBuildTeams && self->readyToStart.isReady())
															#line 1615 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->doBuildTeams = false;
															#line 178 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->teamBuilder = self->interruptableBuildTeams();
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->teamBuilder;
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1625 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state = 3;
															#line 179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckBuildTeamsActor, 2, Void >*>(static_cast<CheckBuildTeamsActor*>(this)));
															#line 1630 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 173 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!(!self->teamBuilder.isReady()))
															#line 1651 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->teamBuilder;
															#line 174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state = 2;
															#line 174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckBuildTeamsActor, 1, Void >*>(static_cast<CheckBuildTeamsActor*>(this)));
															#line 1664 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state > 0) static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBuildTeamsActor*>(this)->ActorCallback< CheckBuildTeamsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBuildTeamsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckBuildTeamsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckBuildTeamsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 182 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<CheckBuildTeamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckBuildTeamsActorState(); static_cast<CheckBuildTeamsActor*>(this)->destroy(); return 0; }
															#line 1773 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<CheckBuildTeamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckBuildTeamsActorState();
		static_cast<CheckBuildTeamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state > 0) static_cast<CheckBuildTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckBuildTeamsActor*>(this)->ActorCallback< CheckBuildTeamsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckBuildTeamsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckBuildTeamsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckBuildTeamsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 1870 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkBuildTeams()
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class CheckBuildTeamsActor final : public Actor<Void>, public ActorCallback< CheckBuildTeamsActor, 0, Void >, public ActorCallback< CheckBuildTeamsActor, 1, Void >, public ActorCallback< CheckBuildTeamsActor, 2, Void >, public FastAllocated<CheckBuildTeamsActor>, public CheckBuildTeamsActorState<CheckBuildTeamsActor> {
															#line 1875 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckBuildTeamsActor>::operator new;
	using FastAllocated<CheckBuildTeamsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16524184677250096896UL, 10685597769705162752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckBuildTeamsActor, 0, Void >;
friend struct ActorCallback< CheckBuildTeamsActor, 1, Void >;
friend struct ActorCallback< CheckBuildTeamsActor, 2, Void >;
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	CheckBuildTeamsActor(DDTeamCollection* const& self) 
															#line 1894 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckBuildTeamsActorState<CheckBuildTeamsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkBuildTeams", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1299362509659700992UL, 2151155817677193216UL);
		ActorExecutionContextHelper __helper(static_cast<CheckBuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkBuildTeams");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkBuildTeams", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckBuildTeamsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckBuildTeamsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckBuildTeamsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> checkBuildTeams( DDTeamCollection* const& self ) {
															#line 171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new CheckBuildTeamsActor(self));
															#line 1928 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 184 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

	// Find the team with the exact storage servers as req.src.
	static void getTeamByServers(DDTeamCollection* self, GetTeamRequest req) {
		const std::string servers = TCTeamInfo::serversToString(req.src);
		Optional<Reference<IDataDistributionTeam>> res;
		for (const auto& team : self->teams) {
			if (team->getServerIDsStr() == servers) {
				res = team;
				break;
			}
		}
		req.reply.send(std::make_pair(res, false));
	}

	// Random selection for load balance
																#line 1947 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via getTeamForBulkLoad()
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class GetTeamForBulkLoadActor>
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class GetTeamForBulkLoadActorState {
															#line 1953 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	GetTeamForBulkLoadActorState(DDTeamCollection* const& self,GetTeamRequest const& req) 
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   req(req)
															#line 1962 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this));

	}
	~GetTeamForBulkLoadActorState() 
	{
		fdb_probe_actor_destroy("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadEngineTaskGetTeamReqReceived", self->distributorId) .detail("TCReady", self->readyToStart.isReady()) .detail("TeamBuilderValid", self->teamBuilder.isValid()) .detail("TeamBuilderReady", self->teamBuilder.isValid() ? self->teamBuilder.isReady() : false) .detail("SrcIds", describe(req.src)) .detail("Primary", self->isPrimary()) .detail("TeamSize", self->teams.size());
															#line 208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->checkBuildTeams();
															#line 208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (static_cast<GetTeamForBulkLoadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1982 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetTeamForBulkLoadActor*>(this)->actor_wait_state = 1;
															#line 208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTeamForBulkLoadActor, 0, Void >*>(static_cast<GetTeamForBulkLoadActor*>(this)));
															#line 1987 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTeamForBulkLoadActorState();
		static_cast<GetTeamForBulkLoadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 327 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (e.code() != error_code_actor_cancelled && req.reply.canBeSet())
															#line 2017 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 328 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				req.reply.sendError(e);
															#line 2021 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 329 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2025 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 210 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadEngineTaskGetTeamCheckBuildTeamDone", self->distributorId) .detail("TCReady", self->readyToStart.isReady()) .detail("TeamBuilderValid", self->teamBuilder.isValid()) .detail("TeamBuilderReady", self->teamBuilder.isValid() ? self->teamBuilder.isReady() : false) .detail("SrcIds", describe(req.src)) .detail("Primary", self->isPrimary()) .detail("TeamSize", self->teams.size());
															#line 218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->primary && !self->readyToStart.isReady())
															#line 2041 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 222 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto team = self->findTeamFromServers(req.completeSources, false);
															#line 223 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "DDBulkLoadEngineTaskGetTeamRemoteDCNotReady", self->distributorId) .suppressFor(1.0) .detail("Primary", self->primary) .detail("Team", team.present() ? describe(team.get()->getServerIDs()) : "");
															#line 227 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.reply.send(std::make_pair(team, true));
															#line 228 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!static_cast<GetTeamForBulkLoadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamForBulkLoadActorState(); static_cast<GetTeamForBulkLoadActor*>(this)->destroy(); return 0; }
															#line 2051 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			new (&static_cast<GetTeamForBulkLoadActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetTeamForBulkLoadActorState();
			static_cast<GetTeamForBulkLoadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 231 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->updateTeamPivotValues();
															#line 234 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		std::vector<Reference<TCTeamInfo>> validTeams;
															#line 235 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int unhealthyTeamCount = 0;
															#line 236 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int notEligibileTeamCount = 0;
															#line 237 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int duplicatedCount = 0;
															#line 238 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& dest : self->teams ) {
															#line 239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!dest->isHealthy())
															#line 2071 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 240 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				unhealthyTeamCount++;
															#line 2075 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				continue;
			}
															#line 248 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!g_network->isSimulated() || deterministicRandom()->random01() < 0.5)
															#line 2080 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bool anyDestServerHaveLowDiskUtil = dest->getEligibilityCount(data_distribution::EligibilityCounter::LOW_DISK_UTIL) > 0;
															#line 251 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!anyDestServerHaveLowDiskUtil)
															#line 2086 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 252 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					notEligibileTeamCount++;
															#line 2090 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					continue;
				}
			}
															#line 256 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bool ok = true;
															#line 257 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( const auto& srcId : req.src ) {
															#line 258 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				std::vector<UID> serverIds = dest->getServerIDs();
															#line 259 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for( const auto& serverId : serverIds ) {
															#line 260 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (serverId == srcId)
															#line 2104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 261 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						ok = false;
															#line 2108 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						break;
					}
				}
															#line 265 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!ok)
															#line 2114 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
					break;
				}
			}
															#line 269 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!ok)
															#line 2121 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 270 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				duplicatedCount++;
															#line 2125 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				continue;
			}
															#line 273 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			validTeams.push_back(dest);
															#line 2130 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 277 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		std::vector<Reference<TCTeamInfo>> candidateTeams;
															#line 278 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (validTeams.size() <= SERVER_KNOBS->DD_BULKLOAD_POWER_OF_D_RATIO)
															#line 2136 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 279 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			candidateTeams = validTeams;
															#line 2140 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 281 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			deterministicRandom()->randomShuffle(validTeams);
															#line 282 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			candidateTeams = std::vector<Reference<TCTeamInfo>>( validTeams.begin(), validTeams.begin() + std::floor(validTeams.size() / SERVER_KNOBS->DD_BULKLOAD_POWER_OF_D_RATIO));
															#line 2148 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 287 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		Optional<Reference<IDataDistributionTeam>> res;
															#line 288 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int minOngoingBulkLoadTaskCount = std::numeric_limits<int>::max();
															#line 289 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for(int i = 0;i < candidateTeams.size();i++) {
															#line 290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int ongoingBulkLoadTaskCount = -1;
															#line 291 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( const auto& ssid : candidateTeams[i]->getServerIDs() ) {
															#line 292 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ongoingBulkLoadTaskCount = std::max(ongoingBulkLoadTaskCount, self->bulkLoadTaskCollection->busyMap.getTaskCount(ssid));
															#line 2162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 295 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!res.present() || ongoingBulkLoadTaskCount < minOngoingBulkLoadTaskCount)
															#line 2166 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 296 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				minOngoingBulkLoadTaskCount = ongoingBulkLoadTaskCount;
															#line 297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				res = candidateTeams[i];
															#line 2172 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 301 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (res.present())
															#line 2177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 302 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadEngineTaskGetTeamReply", self->distributorId) .detail("TCReady", self->readyToStart.isReady()) .detail("SrcIds", describe(req.src)) .detail("Primary", self->isPrimary()) .detail("TeamSize", self->teams.size()) .detail("ValidTeamSize", validTeams.size()) .detail("UnhealthyTeamCount", unhealthyTeamCount) .detail("DuplicatedCount", duplicatedCount) .detail("NotEligibileTeamCount", notEligibileTeamCount) .detail("DestIds", describe(res.get()->getServerIDs())) .detail("DestTeam", res.get()->getTeamID());
															#line 2181 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 314 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarnAlways, "DDBulkLoadEngineTaskGetTeamFailedToFindValidTeam", self->distributorId) .detail("TCReady", self->readyToStart.isReady()) .detail("SrcIds", describe(req.src)) .detail("Primary", self->isPrimary()) .detail("TeamSize", self->teams.size()) .detail("ValidTeamSize", validTeams.size()) .detail("UnhealthyTeamCount", unhealthyTeamCount) .detail("DuplicatedCount", duplicatedCount) .detail("NotEligibileTeamCount", notEligibileTeamCount);
															#line 2187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 324 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		req.reply.send(std::make_pair(res, false));
															#line 325 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<GetTeamForBulkLoadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamForBulkLoadActorState(); static_cast<GetTeamForBulkLoadActor*>(this)->destroy(); return 0; }
															#line 2193 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<GetTeamForBulkLoadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTeamForBulkLoadActorState();
		static_cast<GetTeamForBulkLoadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 210 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadEngineTaskGetTeamCheckBuildTeamDone", self->distributorId) .detail("TCReady", self->readyToStart.isReady()) .detail("TeamBuilderValid", self->teamBuilder.isValid()) .detail("TeamBuilderReady", self->teamBuilder.isValid() ? self->teamBuilder.isReady() : false) .detail("SrcIds", describe(req.src)) .detail("Primary", self->isPrimary()) .detail("TeamSize", self->teams.size());
															#line 218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->primary && !self->readyToStart.isReady())
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 222 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto team = self->findTeamFromServers(req.completeSources, false);
															#line 223 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "DDBulkLoadEngineTaskGetTeamRemoteDCNotReady", self->distributorId) .suppressFor(1.0) .detail("Primary", self->primary) .detail("Team", team.present() ? describe(team.get()->getServerIDs()) : "");
															#line 227 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.reply.send(std::make_pair(team, true));
															#line 228 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!static_cast<GetTeamForBulkLoadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamForBulkLoadActorState(); static_cast<GetTeamForBulkLoadActor*>(this)->destroy(); return 0; }
															#line 2217 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			new (&static_cast<GetTeamForBulkLoadActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetTeamForBulkLoadActorState();
			static_cast<GetTeamForBulkLoadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 231 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->updateTeamPivotValues();
															#line 234 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		std::vector<Reference<TCTeamInfo>> validTeams;
															#line 235 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int unhealthyTeamCount = 0;
															#line 236 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int notEligibileTeamCount = 0;
															#line 237 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int duplicatedCount = 0;
															#line 238 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& dest : self->teams ) {
															#line 239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!dest->isHealthy())
															#line 2237 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 240 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				unhealthyTeamCount++;
															#line 2241 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				continue;
			}
															#line 248 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!g_network->isSimulated() || deterministicRandom()->random01() < 0.5)
															#line 2246 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bool anyDestServerHaveLowDiskUtil = dest->getEligibilityCount(data_distribution::EligibilityCounter::LOW_DISK_UTIL) > 0;
															#line 251 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!anyDestServerHaveLowDiskUtil)
															#line 2252 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 252 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					notEligibileTeamCount++;
															#line 2256 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					continue;
				}
			}
															#line 256 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bool ok = true;
															#line 257 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( const auto& srcId : req.src ) {
															#line 258 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				std::vector<UID> serverIds = dest->getServerIDs();
															#line 259 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for( const auto& serverId : serverIds ) {
															#line 260 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (serverId == srcId)
															#line 2270 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 261 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						ok = false;
															#line 2274 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						break;
					}
				}
															#line 265 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!ok)
															#line 2280 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
					break;
				}
			}
															#line 269 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!ok)
															#line 2287 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 270 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				duplicatedCount++;
															#line 2291 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				continue;
			}
															#line 273 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			validTeams.push_back(dest);
															#line 2296 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 277 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		std::vector<Reference<TCTeamInfo>> candidateTeams;
															#line 278 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (validTeams.size() <= SERVER_KNOBS->DD_BULKLOAD_POWER_OF_D_RATIO)
															#line 2302 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 279 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			candidateTeams = validTeams;
															#line 2306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 281 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			deterministicRandom()->randomShuffle(validTeams);
															#line 282 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			candidateTeams = std::vector<Reference<TCTeamInfo>>( validTeams.begin(), validTeams.begin() + std::floor(validTeams.size() / SERVER_KNOBS->DD_BULKLOAD_POWER_OF_D_RATIO));
															#line 2314 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 287 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		Optional<Reference<IDataDistributionTeam>> res;
															#line 288 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int minOngoingBulkLoadTaskCount = std::numeric_limits<int>::max();
															#line 289 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for(int i = 0;i < candidateTeams.size();i++) {
															#line 290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int ongoingBulkLoadTaskCount = -1;
															#line 291 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( const auto& ssid : candidateTeams[i]->getServerIDs() ) {
															#line 292 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ongoingBulkLoadTaskCount = std::max(ongoingBulkLoadTaskCount, self->bulkLoadTaskCollection->busyMap.getTaskCount(ssid));
															#line 2328 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 295 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!res.present() || ongoingBulkLoadTaskCount < minOngoingBulkLoadTaskCount)
															#line 2332 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 296 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				minOngoingBulkLoadTaskCount = ongoingBulkLoadTaskCount;
															#line 297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				res = candidateTeams[i];
															#line 2338 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 301 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (res.present())
															#line 2343 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 302 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(bulkLoadVerboseEventSev(), "DDBulkLoadEngineTaskGetTeamReply", self->distributorId) .detail("TCReady", self->readyToStart.isReady()) .detail("SrcIds", describe(req.src)) .detail("Primary", self->isPrimary()) .detail("TeamSize", self->teams.size()) .detail("ValidTeamSize", validTeams.size()) .detail("UnhealthyTeamCount", unhealthyTeamCount) .detail("DuplicatedCount", duplicatedCount) .detail("NotEligibileTeamCount", notEligibileTeamCount) .detail("DestIds", describe(res.get()->getServerIDs())) .detail("DestTeam", res.get()->getTeamID());
															#line 2347 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 314 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarnAlways, "DDBulkLoadEngineTaskGetTeamFailedToFindValidTeam", self->distributorId) .detail("TCReady", self->readyToStart.isReady()) .detail("SrcIds", describe(req.src)) .detail("Primary", self->isPrimary()) .detail("TeamSize", self->teams.size()) .detail("ValidTeamSize", validTeams.size()) .detail("UnhealthyTeamCount", unhealthyTeamCount) .detail("DuplicatedCount", duplicatedCount) .detail("NotEligibileTeamCount", notEligibileTeamCount);
															#line 2353 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 324 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		req.reply.send(std::make_pair(res, false));
															#line 325 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<GetTeamForBulkLoadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamForBulkLoadActorState(); static_cast<GetTeamForBulkLoadActor*>(this)->destroy(); return 0; }
															#line 2359 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<GetTeamForBulkLoadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTeamForBulkLoadActorState();
		static_cast<GetTeamForBulkLoadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTeamForBulkLoadActor*>(this)->actor_wait_state > 0) static_cast<GetTeamForBulkLoadActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamForBulkLoadActor*>(this)->ActorCallback< GetTeamForBulkLoadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamForBulkLoadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamForBulkLoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTeamForBulkLoadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamForBulkLoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTeamForBulkLoadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamForBulkLoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	GetTeamRequest req;
															#line 2446 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getTeamForBulkLoad()
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class GetTeamForBulkLoadActor final : public Actor<Void>, public ActorCallback< GetTeamForBulkLoadActor, 0, Void >, public FastAllocated<GetTeamForBulkLoadActor>, public GetTeamForBulkLoadActorState<GetTeamForBulkLoadActor> {
															#line 2451 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetTeamForBulkLoadActor>::operator new;
	using FastAllocated<GetTeamForBulkLoadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5431163142656456192UL, 12441885354622094336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTeamForBulkLoadActor, 0, Void >;
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	GetTeamForBulkLoadActor(DDTeamCollection* const& self,GetTeamRequest const& req) 
															#line 2468 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetTeamForBulkLoadActorState<GetTeamForBulkLoadActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17673631661895417344UL, 10674754054094038784UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamForBulkLoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTeamForBulkLoad");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTeamForBulkLoad", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTeamForBulkLoadActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> getTeamForBulkLoad( DDTeamCollection* const& self, GetTeamRequest const& req ) {
															#line 199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new GetTeamForBulkLoadActor(self, req));
															#line 2500 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 332 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

	// Return a threshold of team queue size which guarantees at least DD_LONG_STORAGE_QUEUE_TEAM_MAJORITY_PERCENTILE
	// portion of teams that have longer storage queues
	// A team storage queue size is defined as the longest storage queue size among all SSes of the team
	static int64_t calculateTeamStorageQueueThreshold(const std::vector<Reference<TCTeamInfo>>& teams) {
		if (teams.size() == 0) {
			return std::numeric_limits<int64_t>::max(); // disable this funcationality
		}
		std::vector<int64_t> queueLengthList;
		for (const auto& team : teams) {
			Optional<int64_t> storageQueueSize = team->getLongestStorageQueueSize();
			if (!storageQueueSize.present()) {
				// This team may have an unhealthy SS, so avoid selecting it
				queueLengthList.push_back(std::numeric_limits<int64_t>::max());
			} else {
				queueLengthList.push_back(storageQueueSize.get());
			}
		}
		double percentile = std::max(0.0, std::min(SERVER_KNOBS->DD_LONG_STORAGE_QUEUE_TEAM_MAJORITY_PERCENTILE, 1.0));
		int position = (queueLengthList.size() - 1) * (1 - percentile);
		std::nth_element(queueLengthList.begin(), queueLengthList.begin() + position, queueLengthList.end());
		int64_t threshold = queueLengthList[position];
		TraceEvent(SevInfo, "StorageQueueAwareGotThreshold").suppressFor(5.0).detail("Threshold", threshold);
		return threshold;
	}

	// Returns the overall best team that matches the requirement from `req`. When preferWithinShardLimit is true, it
	// also tries to select a team whose existing shard is less than SERVER_KNOBS->DESIRED_MAX_SHARDS_PER_TEAM.
	static Optional<Reference<IDataDistributionTeam>> getBestTeam(DDTeamCollection* self,
	                                                              const GetTeamRequest& req,
	                                                              bool preferWithinShardLimit,
	                                                              int& numSkippedSSFailedGetQueueLength,
	                                                              int& numSkippedSSQueueTooLong,
	                                                              Optional<int64_t> storageQueueThreshold) {
		ASSERT(!req.storageQueueAware || storageQueueThreshold.present());
		auto& startIndex = req.preferLowerDiskUtil ? self->lowestUtilizationTeam : self->highestUtilizationTeam;
		if (startIndex >= self->teams.size()) {
			startIndex = 0;
		}
		Optional<Reference<IDataDistributionTeam>> bestOption;
		int64_t bestLoadBytes = 0;
		bool wigglingBestOption = false; // best option contains server in paused wiggle state
		int bestIndex = startIndex;
		for (int i = 0; i < self->teams.size(); i++) {
			int currentIndex = (startIndex + i) % self->teams.size();
			if (self->teams[currentIndex]->isHealthy()) {
				int eligibilityType = data_distribution::EligibilityCounter::fromGetTeamRequest(req);
				if (eligibilityType != data_distribution::EligibilityCounter::NONE &&
				    self->teams[currentIndex]->getEligibilityCount(eligibilityType) <= 0) {
					continue;
				}

				int64_t loadBytes = self->teams[currentIndex]->getLoadBytes(true, req.inflightPenalty);
				if (req.storageQueueAware) {
					Optional<int64_t> storageQueueSize = self->teams[currentIndex]->getLongestStorageQueueSize();
					if (!storageQueueSize.present()) {
						numSkippedSSFailedGetQueueLength++;
						continue; // this team may have an unhealthy SS, skip
					} else if (storageQueueSize.get() > storageQueueThreshold.get()) {
						numSkippedSSQueueTooLong++;
						continue; // this team has a SS with a too long storage queue, skip
					}
				}

				auto team = ShardsAffectedByTeamFailure::Team(self->teams[currentIndex]->getServerIDs(), self->primary);
				if ((!req.teamMustHaveShards || self->shardsAffectedByTeamFailure->hasShards(team)) &&
				    // sort conditions
				    (!bestOption.present() ||
				     req.lessCompare(bestOption.get(), self->teams[currentIndex], bestLoadBytes, loadBytes))) {

					// bestOption doesn't contain wiggling SS while current team does. Don't replace bestOption
					// in this case
					if (bestOption.present() && !wigglingBestOption &&
					    self->teams[currentIndex]->hasWigglePausedServer()) {
						continue;
					}

					if (SERVER_KNOBS->ENFORCE_SHARD_COUNT_PER_TEAM && preferWithinShardLimit &&
					    self->shardsAffectedByTeamFailure->getNumberOfShards(team) >
					        SERVER_KNOBS->DESIRED_MAX_SHARDS_PER_TEAM) {
						continue;
					}

					bestLoadBytes = loadBytes;
					bestOption = self->teams[currentIndex];
					bestIndex = currentIndex;
					wigglingBestOption = self->teams[bestIndex]->hasWigglePausedServer();
				}
			}
		}
		startIndex = bestIndex;
		return bestOption;
	}

	// Returns the best team from `candidates` that matches the requirement from `req`. When preferWithinShardLimit is
	// true, it also tries to select a team whose existing team is less than SERVER_KNOBS->DESIRED_MAX_SHARDS_PER_TEAM.
	// Do not check storage queue size since getTeam has checked the size when selecting the input candidates
	static Optional<Reference<IDataDistributionTeam>> getBestTeamFromCandidates(
	    DDTeamCollection* self,
	    const GetTeamRequest& req,
	    const std::vector<Reference<TCTeamInfo>>& candidates,
	    bool preferWithinShardLimit,
	    int& numSkippedSSFailedGetQueueLength,
	    int& numSkippedSSQueueTooLong) {
		Optional<Reference<IDataDistributionTeam>> bestOption;
		int64_t bestLoadBytes = 0;
		bool wigglingBestOption = false; // best option contains server in paused wiggle state
		for (int i = 0; i < candidates.size(); i++) {
			int64_t loadBytes = candidates[i]->getLoadBytes(true, req.inflightPenalty);
			if (!bestOption.present() || req.lessCompare(bestOption.get(), candidates[i], bestLoadBytes, loadBytes)) {

				// bestOption doesn't contain wiggling SS while current team does. Don't replace bestOption
				// in this case
				if (bestOption.present() && !wigglingBestOption && candidates[i]->hasWigglePausedServer()) {
					continue;
				}

				if (SERVER_KNOBS->ENFORCE_SHARD_COUNT_PER_TEAM && preferWithinShardLimit &&
				    self->shardsAffectedByTeamFailure->getNumberOfShards(ShardsAffectedByTeamFailure::Team(
				        candidates[i]->getServerIDs(), self->primary)) > SERVER_KNOBS->DESIRED_MAX_SHARDS_PER_TEAM) {
					continue;
				}

				bestLoadBytes = loadBytes;
				bestOption = candidates[i];
				wigglingBestOption = candidates[i]->hasWigglePausedServer();
			}
		}
		return bestOption;
	}

	// SOMEDAY: Make bestTeam better about deciding to leave a shard where it is (e.g. in PRIORITY_TEAM_HEALTHY case)
	//		    use keys, src, dest, metrics, priority, system load, etc.. to decide...
																#line 2637 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via getTeam()
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class GetTeamActor>
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class GetTeamActorState {
															#line 2643 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	GetTeamActorState(DDTeamCollection* const& self,GetTeamRequest const& req) 
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   req(req)
															#line 2652 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getTeam", reinterpret_cast<unsigned long>(this));

	}
	~GetTeamActorState() 
	{
		fdb_probe_actor_destroy("getTeam", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 467 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->checkBuildTeams();
															#line 467 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (static_cast<GetTeamActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2670 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetTeamActor*>(this)->actor_wait_state = 1;
															#line 467 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTeamActor, 0, Void >*>(static_cast<GetTeamActor*>(this)));
															#line 2675 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTeamActorState();
		static_cast<GetTeamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 706 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (e.code() != error_code_actor_cancelled && req.reply.canBeSet())
															#line 2705 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 707 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				req.reply.sendError(e);
															#line 2709 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 708 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->primary && !self->readyToStart.isReady())
															#line 2727 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 473 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto team = self->findTeamFromServers(req.completeSources, false);
															#line 474 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("GetTeamNotReady", self->distributorId) .suppressFor(1.0) .detail("Primary", self->primary) .detail("Team", team.present() ? describe(team.get()->getServerIDs()) : "");
															#line 478 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.reply.send(std::make_pair(team, true));
															#line 479 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 2737 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetTeamActorState();
			static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 483 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->updateTeamPivotValues();
															#line 485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool foundSrc = false;
															#line 486 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& id : req.src ) {
															#line 487 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->server_info.contains(id))
															#line 2751 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 488 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				foundSrc = true;
															#line 2755 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				break;
			}
		}
															#line 502 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->teams.size())
															#line 2761 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 503 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.reply.send(std::make_pair(Optional<Reference<IDataDistributionTeam>>(), foundSrc));
															#line 504 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 2767 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetTeamActorState();
			static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 507 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		Optional<Reference<IDataDistributionTeam>> bestOption;
															#line 508 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		numSkippedSSFailedGetQueueLength = 0;
															#line 509 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		numSkippedSSQueueTooLong = 0;
															#line 511 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (ddLargeTeamEnabled() && req.keys.present())
															#line 2781 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 512 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int customReplicas = self->configuration.storageTeamSize;
															#line 513 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( auto it : self->userRangeConfig->intersectingRanges(req.keys->begin, req.keys->end) ) {
															#line 514 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				customReplicas = std::max(customReplicas, it->value().replicationFactor.orDefault(0));
															#line 2789 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 516 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (customReplicas > self->configuration.storageTeamSize)
															#line 2793 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 517 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				auto newTeam = self->buildLargeTeam(customReplicas);
															#line 518 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				auto& firstFailureTime = self->firstLargeTeamFailure[customReplicas];
															#line 519 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (newTeam)
															#line 2801 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 520 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (newTeam->size() < customReplicas)
															#line 2805 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 521 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (!firstFailureTime.present())
															#line 2809 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 522 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							firstFailureTime = now();
															#line 2813 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						}
															#line 524 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (now() - firstFailureTime.get() < SERVER_KNOBS->DD_LARGE_TEAM_DELAY)
															#line 2817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 525 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							req.reply.send(std::make_pair(Optional<Reference<IDataDistributionTeam>>(), foundSrc));
															#line 526 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 2823 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~GetTeamActorState();
							static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 528 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						self->underReplication.insert(req.keys.get(), true);
															#line 2831 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
					else
					{
															#line 530 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						firstFailureTime = Optional<double>();
															#line 2837 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
															#line 532 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("ReplicatingToLargeTeam", self->distributorId) .detail("Team", newTeam->getDesc()) .detail("Healthy", newTeam->isHealthy()) .detail("DesiredReplicas", customReplicas) .detail("UnderReplicated", newTeam->size() < customReplicas);
															#line 537 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					req.reply.send(std::make_pair(newTeam, foundSrc));
															#line 538 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 2845 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetTeamActorState();
					static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 540 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!firstFailureTime.present())
															#line 2855 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 541 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						firstFailureTime = now();
															#line 2859 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
															#line 543 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (now() - firstFailureTime.get() < SERVER_KNOBS->DD_LARGE_TEAM_DELAY)
															#line 2863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 544 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						req.reply.send(std::make_pair(Optional<Reference<IDataDistributionTeam>>(), foundSrc));
															#line 545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 2869 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~GetTeamActorState();
						static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 547 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent(SevWarnAlways, "LargeTeamNotFound", self->distributorId) .suppressFor(1.0) .detail("Replicas", customReplicas) .detail("StorageTeamSize", self->configuration.storageTeamSize) .detail("LargeTeamDiff", now() - firstFailureTime.get());
															#line 552 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->underReplication.insert(req.keys.get(), true);
															#line 2879 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 558 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (req.teamSelect == TeamSelect::WANT_COMPLETE_SRCS)
															#line 2885 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 559 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto healthyTeam = self->findTeamFromServers(req.completeSources, true);
															#line 560 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (healthyTeam.present())
															#line 2891 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 561 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				req.reply.send(std::make_pair(healthyTeam, foundSrc));
															#line 562 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 2897 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetTeamActorState();
				static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 566 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		Optional<int64_t> storageQueueThreshold;
															#line 567 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (req.storageQueueAware)
															#line 2908 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 568 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			storageQueueThreshold = calculateTeamStorageQueueThreshold(self->teams);
															#line 2912 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 570 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (req.teamSelect == TeamSelect::WANT_TRUE_BEST || req.wantTrueBestIfMoveout)
															#line 2916 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(!bestOption.present());
															#line 572 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (SERVER_KNOBS->ENFORCE_SHARD_COUNT_PER_TEAM && req.preferWithinShardLimit)
															#line 2922 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 573 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bestOption = getBestTeam(self, req, true, numSkippedSSFailedGetQueueLength, numSkippedSSQueueTooLong, storageQueueThreshold);
															#line 579 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!bestOption.present())
															#line 2928 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 581 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("GetBestTeamPreferWithinShardLimitFailed").log();
															#line 2932 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 584 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!bestOption.present())
															#line 2937 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 585 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bestOption = getBestTeam(self, req, false, numSkippedSSFailedGetQueueLength, numSkippedSSQueueTooLong, storageQueueThreshold);
															#line 2941 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 593 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(!bestOption.present());
															#line 594 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			std::vector<Reference<TCTeamInfo>> randomTeams;
															#line 595 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int nTries = 0;
															#line 596 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for(;randomTeams.size() < SERVER_KNOBS->BEST_TEAM_OPTION_COUNT && nTries < SERVER_KNOBS->BEST_TEAM_MAX_TEAM_TRIES;) {
															#line 599 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				Reference<TCTeamInfo> dest = deterministicRandom()->randomChoice(self->teams);
															#line 601 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bool ok = dest->isHealthy();
															#line 602 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (ok)
															#line 2960 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 603 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					int eligibilityType = data_distribution::EligibilityCounter::fromGetTeamRequest(req);
															#line 604 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ok = eligibilityType == data_distribution::EligibilityCounter::NONE || dest->getEligibilityCount(eligibilityType) > 0;
															#line 2966 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 608 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for(int i = 0;ok && i < randomTeams.size();i++) {
															#line 609 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (randomTeams[i]->getServerIDs() == dest->getServerIDs())
															#line 2972 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 611 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						ok = false;
															#line 2976 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						break;
					}
				}
															#line 616 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ok = ok && (!req.teamMustHaveShards || self->shardsAffectedByTeamFailure->hasShards( ShardsAffectedByTeamFailure::Team(dest->getServerIDs(), self->primary)));
															#line 620 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (req.storageQueueAware)
															#line 2984 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 621 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					Optional<int64_t> storageQueueSize = dest->getLongestStorageQueueSize();
															#line 622 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!storageQueueSize.present())
															#line 2990 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 623 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						numSkippedSSFailedGetQueueLength++;
															#line 624 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						ok = false;
															#line 2996 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
					else
					{
															#line 625 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (storageQueueSize.get() > storageQueueThreshold.get())
															#line 3002 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 626 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							numSkippedSSQueueTooLong++;
															#line 627 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							ok = false;
															#line 3008 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						}
					}
				}
															#line 631 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (ok)
															#line 3014 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 632 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					randomTeams.push_back(dest);
															#line 3018 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
				else
				{
															#line 634 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					nTries++;
															#line 3024 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 638 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (randomTeams.empty() && !self->zeroHealthyTeams->get())
															#line 3029 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 639 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->bestTeamKeepStuckCount++;
															#line 3033 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 641 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->bestTeamKeepStuckCount = 0;
															#line 3039 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 644 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!randomTeams.empty())
															#line 3043 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 645 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (SERVER_KNOBS->ENFORCE_SHARD_COUNT_PER_TEAM && req.preferWithinShardLimit)
															#line 3047 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 646 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					bestOption = getBestTeamFromCandidates(self, req, randomTeams, true, numSkippedSSFailedGetQueueLength, numSkippedSSQueueTooLong);
															#line 652 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!bestOption.present())
															#line 3053 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 654 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						TraceEvent("GetBestTeamFromCandidatesPreferWithinShardLimitFailed").log();
															#line 3057 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
															#line 658 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!bestOption.present())
															#line 3062 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					bestOption = getBestTeamFromCandidates(self, req, randomTeams, false, numSkippedSSFailedGetQueueLength, numSkippedSSQueueTooLong);
															#line 3066 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 672 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!bestOption.present() && self->zeroHealthyTeams->get())
															#line 3072 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 674 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto healthyTeam = self->findTeamFromServers(req.completeSources, false);
															#line 675 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (healthyTeam.present())
															#line 3078 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 676 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				req.reply.send(std::make_pair(healthyTeam, foundSrc));
															#line 677 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3084 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetTeamActorState();
				static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 680 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (g_network->isSimulated() && !bestOption.present())
															#line 3093 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 681 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevDebug, "GetTeamReturnEmpty") .detail("Request", req.getDesc()) .detail("HealthyTeams", self->healthyTeamCount) .detail("PivotCPU", self->teamPivots.pivotCPU) .detail("PivotDiskSpace", self->teamPivots.pivotAvailableSpaceRatio) .detail("StorageQueueAware", req.storageQueueAware) .detail("NumSkippedSSFailedGetQueueLength", numSkippedSSFailedGetQueueLength) .detail("NumSkippedSSQueueTooLong", numSkippedSSQueueTooLong);
															#line 3097 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 692 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!bestOption.present() && (req.storageQueueAware || req.wantTrueBestIfMoveout))
															#line 3101 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 694 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.storageQueueAware = false;
															#line 695 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.wantTrueBestIfMoveout = false;
															#line 696 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "GetTeamRetry", self->distributorId) .detail("OldStorageQueueAware", req.storageQueueAware) .detail("OldWantTrueBestIfMoveout", req.wantTrueBestIfMoveout);
															#line 699 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_1 = getTeam(self, req);
															#line 699 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<GetTeamActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetTeamActor*>(this)->actor_wait_state = 2;
															#line 699 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamActor, 1, Void >*>(static_cast<GetTeamActor*>(this)));
															#line 3118 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 701 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.reply.send(std::make_pair(bestOption, foundSrc));
															#line 3125 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->primary && !self->readyToStart.isReady())
															#line 3135 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 473 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto team = self->findTeamFromServers(req.completeSources, false);
															#line 474 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("GetTeamNotReady", self->distributorId) .suppressFor(1.0) .detail("Primary", self->primary) .detail("Team", team.present() ? describe(team.get()->getServerIDs()) : "");
															#line 478 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.reply.send(std::make_pair(team, true));
															#line 479 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3145 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetTeamActorState();
			static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 483 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->updateTeamPivotValues();
															#line 485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool foundSrc = false;
															#line 486 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& id : req.src ) {
															#line 487 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->server_info.contains(id))
															#line 3159 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 488 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				foundSrc = true;
															#line 3163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				break;
			}
		}
															#line 502 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->teams.size())
															#line 3169 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 503 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.reply.send(std::make_pair(Optional<Reference<IDataDistributionTeam>>(), foundSrc));
															#line 504 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3175 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetTeamActorState();
			static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 507 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		Optional<Reference<IDataDistributionTeam>> bestOption;
															#line 508 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		numSkippedSSFailedGetQueueLength = 0;
															#line 509 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		numSkippedSSQueueTooLong = 0;
															#line 511 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (ddLargeTeamEnabled() && req.keys.present())
															#line 3189 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 512 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int customReplicas = self->configuration.storageTeamSize;
															#line 513 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( auto it : self->userRangeConfig->intersectingRanges(req.keys->begin, req.keys->end) ) {
															#line 514 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				customReplicas = std::max(customReplicas, it->value().replicationFactor.orDefault(0));
															#line 3197 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 516 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (customReplicas > self->configuration.storageTeamSize)
															#line 3201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 517 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				auto newTeam = self->buildLargeTeam(customReplicas);
															#line 518 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				auto& firstFailureTime = self->firstLargeTeamFailure[customReplicas];
															#line 519 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (newTeam)
															#line 3209 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 520 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (newTeam->size() < customReplicas)
															#line 3213 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 521 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (!firstFailureTime.present())
															#line 3217 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 522 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							firstFailureTime = now();
															#line 3221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						}
															#line 524 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (now() - firstFailureTime.get() < SERVER_KNOBS->DD_LARGE_TEAM_DELAY)
															#line 3225 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 525 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							req.reply.send(std::make_pair(Optional<Reference<IDataDistributionTeam>>(), foundSrc));
															#line 526 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3231 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~GetTeamActorState();
							static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 528 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						self->underReplication.insert(req.keys.get(), true);
															#line 3239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
					else
					{
															#line 530 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						firstFailureTime = Optional<double>();
															#line 3245 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
															#line 532 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("ReplicatingToLargeTeam", self->distributorId) .detail("Team", newTeam->getDesc()) .detail("Healthy", newTeam->isHealthy()) .detail("DesiredReplicas", customReplicas) .detail("UnderReplicated", newTeam->size() < customReplicas);
															#line 537 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					req.reply.send(std::make_pair(newTeam, foundSrc));
															#line 538 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3253 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetTeamActorState();
					static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 540 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!firstFailureTime.present())
															#line 3263 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 541 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						firstFailureTime = now();
															#line 3267 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
															#line 543 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (now() - firstFailureTime.get() < SERVER_KNOBS->DD_LARGE_TEAM_DELAY)
															#line 3271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 544 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						req.reply.send(std::make_pair(Optional<Reference<IDataDistributionTeam>>(), foundSrc));
															#line 545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3277 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~GetTeamActorState();
						static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 547 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent(SevWarnAlways, "LargeTeamNotFound", self->distributorId) .suppressFor(1.0) .detail("Replicas", customReplicas) .detail("StorageTeamSize", self->configuration.storageTeamSize) .detail("LargeTeamDiff", now() - firstFailureTime.get());
															#line 552 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->underReplication.insert(req.keys.get(), true);
															#line 3287 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 558 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (req.teamSelect == TeamSelect::WANT_COMPLETE_SRCS)
															#line 3293 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 559 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto healthyTeam = self->findTeamFromServers(req.completeSources, true);
															#line 560 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (healthyTeam.present())
															#line 3299 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 561 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				req.reply.send(std::make_pair(healthyTeam, foundSrc));
															#line 562 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3305 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetTeamActorState();
				static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 566 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		Optional<int64_t> storageQueueThreshold;
															#line 567 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (req.storageQueueAware)
															#line 3316 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 568 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			storageQueueThreshold = calculateTeamStorageQueueThreshold(self->teams);
															#line 3320 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 570 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (req.teamSelect == TeamSelect::WANT_TRUE_BEST || req.wantTrueBestIfMoveout)
															#line 3324 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(!bestOption.present());
															#line 572 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (SERVER_KNOBS->ENFORCE_SHARD_COUNT_PER_TEAM && req.preferWithinShardLimit)
															#line 3330 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 573 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bestOption = getBestTeam(self, req, true, numSkippedSSFailedGetQueueLength, numSkippedSSQueueTooLong, storageQueueThreshold);
															#line 579 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!bestOption.present())
															#line 3336 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 581 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("GetBestTeamPreferWithinShardLimitFailed").log();
															#line 3340 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 584 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!bestOption.present())
															#line 3345 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 585 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bestOption = getBestTeam(self, req, false, numSkippedSSFailedGetQueueLength, numSkippedSSQueueTooLong, storageQueueThreshold);
															#line 3349 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 593 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(!bestOption.present());
															#line 594 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			std::vector<Reference<TCTeamInfo>> randomTeams;
															#line 595 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int nTries = 0;
															#line 596 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for(;randomTeams.size() < SERVER_KNOBS->BEST_TEAM_OPTION_COUNT && nTries < SERVER_KNOBS->BEST_TEAM_MAX_TEAM_TRIES;) {
															#line 599 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				Reference<TCTeamInfo> dest = deterministicRandom()->randomChoice(self->teams);
															#line 601 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bool ok = dest->isHealthy();
															#line 602 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (ok)
															#line 3368 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 603 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					int eligibilityType = data_distribution::EligibilityCounter::fromGetTeamRequest(req);
															#line 604 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ok = eligibilityType == data_distribution::EligibilityCounter::NONE || dest->getEligibilityCount(eligibilityType) > 0;
															#line 3374 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 608 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for(int i = 0;ok && i < randomTeams.size();i++) {
															#line 609 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (randomTeams[i]->getServerIDs() == dest->getServerIDs())
															#line 3380 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 611 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						ok = false;
															#line 3384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						break;
					}
				}
															#line 616 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ok = ok && (!req.teamMustHaveShards || self->shardsAffectedByTeamFailure->hasShards( ShardsAffectedByTeamFailure::Team(dest->getServerIDs(), self->primary)));
															#line 620 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (req.storageQueueAware)
															#line 3392 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 621 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					Optional<int64_t> storageQueueSize = dest->getLongestStorageQueueSize();
															#line 622 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!storageQueueSize.present())
															#line 3398 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 623 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						numSkippedSSFailedGetQueueLength++;
															#line 624 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						ok = false;
															#line 3404 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
					else
					{
															#line 625 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (storageQueueSize.get() > storageQueueThreshold.get())
															#line 3410 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 626 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							numSkippedSSQueueTooLong++;
															#line 627 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							ok = false;
															#line 3416 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						}
					}
				}
															#line 631 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (ok)
															#line 3422 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 632 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					randomTeams.push_back(dest);
															#line 3426 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
				else
				{
															#line 634 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					nTries++;
															#line 3432 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 638 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (randomTeams.empty() && !self->zeroHealthyTeams->get())
															#line 3437 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 639 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->bestTeamKeepStuckCount++;
															#line 3441 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 641 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->bestTeamKeepStuckCount = 0;
															#line 3447 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 644 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!randomTeams.empty())
															#line 3451 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 645 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (SERVER_KNOBS->ENFORCE_SHARD_COUNT_PER_TEAM && req.preferWithinShardLimit)
															#line 3455 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 646 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					bestOption = getBestTeamFromCandidates(self, req, randomTeams, true, numSkippedSSFailedGetQueueLength, numSkippedSSQueueTooLong);
															#line 652 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!bestOption.present())
															#line 3461 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 654 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						TraceEvent("GetBestTeamFromCandidatesPreferWithinShardLimitFailed").log();
															#line 3465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
															#line 658 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!bestOption.present())
															#line 3470 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					bestOption = getBestTeamFromCandidates(self, req, randomTeams, false, numSkippedSSFailedGetQueueLength, numSkippedSSQueueTooLong);
															#line 3474 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 672 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!bestOption.present() && self->zeroHealthyTeams->get())
															#line 3480 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 674 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto healthyTeam = self->findTeamFromServers(req.completeSources, false);
															#line 675 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (healthyTeam.present())
															#line 3486 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 676 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				req.reply.send(std::make_pair(healthyTeam, foundSrc));
															#line 677 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3492 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetTeamActorState();
				static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 680 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (g_network->isSimulated() && !bestOption.present())
															#line 3501 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 681 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevDebug, "GetTeamReturnEmpty") .detail("Request", req.getDesc()) .detail("HealthyTeams", self->healthyTeamCount) .detail("PivotCPU", self->teamPivots.pivotCPU) .detail("PivotDiskSpace", self->teamPivots.pivotAvailableSpaceRatio) .detail("StorageQueueAware", req.storageQueueAware) .detail("NumSkippedSSFailedGetQueueLength", numSkippedSSFailedGetQueueLength) .detail("NumSkippedSSQueueTooLong", numSkippedSSQueueTooLong);
															#line 3505 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 692 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!bestOption.present() && (req.storageQueueAware || req.wantTrueBestIfMoveout))
															#line 3509 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 694 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.storageQueueAware = false;
															#line 695 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.wantTrueBestIfMoveout = false;
															#line 696 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "GetTeamRetry", self->distributorId) .detail("OldStorageQueueAware", req.storageQueueAware) .detail("OldWantTrueBestIfMoveout", req.wantTrueBestIfMoveout);
															#line 699 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_1 = getTeam(self, req);
															#line 699 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<GetTeamActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3521 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetTeamActor*>(this)->actor_wait_state = 2;
															#line 699 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamActor, 1, Void >*>(static_cast<GetTeamActor*>(this)));
															#line 3526 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 701 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			req.reply.send(std::make_pair(bestOption, foundSrc));
															#line 3533 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTeamActor*>(this)->actor_wait_state > 0) static_cast<GetTeamActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamActor*>(this)->ActorCallback< GetTeamActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTeam", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeam", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTeamActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTeam", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeam", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTeamActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTeam", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeam", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 704 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<GetTeamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTeamActorState(); static_cast<GetTeamActor*>(this)->destroy(); return 0; }
															#line 3618 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<GetTeamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTeamActorState();
		static_cast<GetTeamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont46(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont46(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont46(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont46(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTeamActor*>(this)->actor_wait_state > 0) static_cast<GetTeamActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamActor*>(this)->ActorCallback< GetTeamActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTeam", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeam", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTeamActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTeam", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeam", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTeamActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTeam", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeam", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	GetTeamRequest req;
															#line 508 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int numSkippedSSFailedGetQueueLength;
															#line 509 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int numSkippedSSQueueTooLong;
															#line 3721 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getTeam()
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class GetTeamActor final : public Actor<Void>, public ActorCallback< GetTeamActor, 0, Void >, public ActorCallback< GetTeamActor, 1, Void >, public FastAllocated<GetTeamActor>, public GetTeamActorState<GetTeamActor> {
															#line 3726 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetTeamActor>::operator new;
	using FastAllocated<GetTeamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6016749561669458688UL, 11860644352011855104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTeamActor, 0, Void >;
friend struct ActorCallback< GetTeamActor, 1, Void >;
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	GetTeamActor(DDTeamCollection* const& self,GetTeamRequest const& req) 
															#line 3744 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetTeamActorState<GetTeamActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTeam", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17234857594562323456UL, 17800042652668376320UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTeam");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTeam", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTeamActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTeamActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> getTeam( DDTeamCollection* const& self, GetTeamRequest const& req ) {
															#line 465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new GetTeamActor(self, req));
															#line 3777 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 711 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

	// FIXME: describe purpose
																#line 3783 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via addSubsetOfEmergencyTeams()
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class AddSubsetOfEmergencyTeamsActor>
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class AddSubsetOfEmergencyTeamsActorState {
															#line 3789 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	AddSubsetOfEmergencyTeamsActorState(DDTeamCollection* const& self) 
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 714 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   idx(0),
															#line 715 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   servers(),
															#line 716 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   serverIds(),
															#line 717 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   tempSet(Reference<LocalitySet>(new LocalityMap<UID>())),
															#line 718 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   tempMap((LocalityMap<UID>*)tempSet.getPtr()),
															#line 719 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   largeOrBadTeams(self->badTeams)
															#line 3808 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this));

	}
	~AddSubsetOfEmergencyTeamsActorState() 
	{
		fdb_probe_actor_destroy("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 720 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			largeOrBadTeams.insert(largeOrBadTeams.end(), self->largeTeams.begin(), self->largeTeams.end());
															#line 722 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 3825 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddSubsetOfEmergencyTeamsActorState();
		static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 798 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->traceTeamCollectionInfo();
															#line 800 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddSubsetOfEmergencyTeamsActorState(); static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->destroy(); return 0; }
															#line 3850 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddSubsetOfEmergencyTeamsActorState();
		static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 722 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!(idx < largeOrBadTeams.size()))
															#line 3869 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 723 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		servers.clear();
															#line 724 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& server : largeOrBadTeams[idx]->getServers() ) {
															#line 725 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (server->isInDesiredDC() && !self->server_status.get(server->getId()).isUnhealthy())
															#line 3879 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 726 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				servers.push_back(server);
															#line 3883 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 734 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (servers.size() >= self->configuration.storageTeamSize)
															#line 3888 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 735 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bool foundTeam = false;
															#line 736 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for(int j = 0;j < servers.size() - self->configuration.storageTeamSize + 1 && !foundTeam;j++) {
															#line 737 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				auto const& serverTeams = servers[j]->getTeams();
															#line 738 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for(int k = 0;k < serverTeams.size();k++) {
															#line 739 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					auto& testTeam = serverTeams[k]->getServerIDs();
															#line 740 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					bool allInTeam = true;
															#line 741 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					for(int l = 0;l < testTeam.size();l++) {
															#line 742 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						bool foundServer = false;
															#line 743 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						for( auto it : servers ) {
															#line 744 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (it->getId() == testTeam[l])
															#line 3910 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							{
															#line 745 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								foundServer = true;
															#line 3914 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
								break;
							}
						}
															#line 749 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (!foundServer)
															#line 3920 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 750 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							allInTeam = false;
															#line 3924 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							break;
						}
					}
															#line 754 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (allInTeam)
															#line 3930 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 755 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						foundTeam = true;
															#line 3934 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						break;
					}
				}
			}
															#line 760 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!foundTeam)
															#line 3941 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 761 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (self->satisfiesPolicy(servers))
															#line 3945 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 762 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (servers.size() == self->configuration.storageTeamSize || self->satisfiesPolicy(servers, self->configuration.storageTeamSize))
															#line 3949 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 764 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						servers.resize(self->configuration.storageTeamSize);
															#line 765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						self->addTeam(servers, IsInitialTeam::True);
															#line 3955 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
					else
					{
															#line 767 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						tempSet->clear();
															#line 768 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						for( auto it : servers ) {
															#line 769 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							tempMap->add(it->getLastKnownInterface().locality, &it->getId());
															#line 3965 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						}
															#line 772 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						std::vector<LocalityEntry> resultEntries, forcedEntries;
															#line 773 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						bool result = tempSet->selectReplicas( self->configuration.storagePolicy, forcedEntries, resultEntries);
															#line 775 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						ASSERT(result && resultEntries.size() == self->configuration.storageTeamSize);
															#line 777 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						serverIds.clear();
															#line 778 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						for( auto& it : resultEntries ) {
															#line 779 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							serverIds.push_back(*tempMap->getObject(it));
															#line 3979 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						}
															#line 781 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						std::sort(serverIds.begin(), serverIds.end());
															#line 782 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						self->addTeam(serverIds.begin(), serverIds.end(), IsInitialTeam::True);
															#line 3985 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 785 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					serverIds.clear();
															#line 786 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					for( auto it : servers ) {
															#line 787 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						serverIds.push_back(it->getId());
															#line 3996 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
															#line 789 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent(SevWarnAlways, "CannotAddSubset", self->distributorId) .detail("Servers", describe(serverIds));
															#line 4000 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 794 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 794 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4008 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->actor_wait_state = 1;
															#line 794 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddSubsetOfEmergencyTeamsActor, 0, Void >*>(static_cast<AddSubsetOfEmergencyTeamsActor*>(this)));
															#line 4013 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 722 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		idx++;
															#line 4035 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 722 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		idx++;
															#line 4044 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->actor_wait_state > 0) static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->ActorCallback< AddSubsetOfEmergencyTeamsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddSubsetOfEmergencyTeamsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddSubsetOfEmergencyTeamsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddSubsetOfEmergencyTeamsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 714 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int idx;
															#line 715 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<Reference<TCServerInfo>> servers;
															#line 716 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<UID> serverIds;
															#line 717 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Reference<LocalitySet> tempSet;
															#line 718 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	LocalityMap<UID>* tempMap;
															#line 719 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<Reference<TCTeamInfo>> largeOrBadTeams;
															#line 4138 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addSubsetOfEmergencyTeams()
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class AddSubsetOfEmergencyTeamsActor final : public Actor<Void>, public ActorCallback< AddSubsetOfEmergencyTeamsActor, 0, Void >, public FastAllocated<AddSubsetOfEmergencyTeamsActor>, public AddSubsetOfEmergencyTeamsActorState<AddSubsetOfEmergencyTeamsActor> {
															#line 4143 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddSubsetOfEmergencyTeamsActor>::operator new;
	using FastAllocated<AddSubsetOfEmergencyTeamsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6097976155010397952UL, 7705473742883220992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddSubsetOfEmergencyTeamsActor, 0, Void >;
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	AddSubsetOfEmergencyTeamsActor(DDTeamCollection* const& self) 
															#line 4160 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AddSubsetOfEmergencyTeamsActorState<AddSubsetOfEmergencyTeamsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16540020893932235008UL, 8411911611803313152UL);
		ActorExecutionContextHelper __helper(static_cast<AddSubsetOfEmergencyTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addSubsetOfEmergencyTeams");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addSubsetOfEmergencyTeams", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddSubsetOfEmergencyTeamsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> addSubsetOfEmergencyTeams( DDTeamCollection* const& self ) {
															#line 713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new AddSubsetOfEmergencyTeamsActor(self));
															#line 4192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 802 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 4197 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via init()
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class InitActor>
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class InitActorState {
															#line 4203 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	InitActorState(DDTeamCollection* const& self,Reference<InitialDataDistribution> const& initTeams,const DDEnabledState* const& ddEnabledState) 
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   initTeams(initTeams),
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   ddEnabledState(ddEnabledState)
															#line 4214 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("init", reinterpret_cast<unsigned long>(this));

	}
	~InitActorState() 
	{
		fdb_probe_actor_destroy("init", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 807 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->userRangeConfig = initTeams->userRangeConfig;
															#line 808 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->healthyZone.set(initTeams->initHealthyZoneValue);
															#line 811 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( auto& [server, procClass] : initTeams->allServers ) {
															#line 812 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (self->shouldHandleServer(server))
															#line 4235 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 813 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!self->isValidLocality(self->configuration.storagePolicy, server.locality))
															#line 4239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 814 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						TraceEvent(SevWarnAlways, "MissingLocality") .detail("Server", server.uniqueID) .detail("Locality", server.locality.toString());
															#line 817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						auto addr = server.stableAddress();
															#line 818 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						self->invalidLocalityAddr.insert(AddressExclusion(addr.ip, addr.port));
															#line 819 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (self->checkInvalidLocalities.isReady())
															#line 4249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 820 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							self->checkInvalidLocalities = checkAndRemoveInvalidLocalityAddr(self);
															#line 821 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							self->addActor.send(self->checkInvalidLocalities);
															#line 4255 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						}
					}
															#line 824 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->addServer(server, procClass, self->serverTrackerErrorOut, 0, *ddEnabledState);
															#line 4260 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 828 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			teamIter = self->primary ? initTeams->primaryTeams.begin() : initTeams->remoteTeams.begin();
															#line 830 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			teamIterEnd = self->primary ? initTeams->primaryTeams.end() : initTeams->remoteTeams.end();
															#line 832 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 4269 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitActorState();
		static_cast<InitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 837 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<InitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitActorState(); static_cast<InitActor*>(this)->destroy(); return 0; }
															#line 4292 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<InitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitActorState();
		static_cast<InitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 832 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!(teamIter != teamIterEnd))
															#line 4311 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 833 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->addTeam(teamIter->begin(), teamIter->end(), IsInitialTeam::True);
															#line 834 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 834 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<InitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4321 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<InitActor*>(this)->actor_wait_state = 1;
															#line 834 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitActor, 0, Void >*>(static_cast<InitActor*>(this)));
															#line 4326 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 832 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		++teamIter;
															#line 4348 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 832 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		++teamIter;
															#line 4357 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitActor*>(this)->actor_wait_state > 0) static_cast<InitActor*>(this)->actor_wait_state = 0;
		static_cast<InitActor*>(this)->ActorCallback< InitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("init", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("init", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("init", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("init", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("init", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("init", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Reference<InitialDataDistribution> initTeams;
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 828 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::set<std::vector<UID>>::iterator teamIter;
															#line 830 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::set<std::vector<UID>>::iterator teamIterEnd;
															#line 4447 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via init()
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class InitActor final : public Actor<Void>, public ActorCallback< InitActor, 0, Void >, public FastAllocated<InitActor>, public InitActorState<InitActor> {
															#line 4452 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<InitActor>::operator new;
	using FastAllocated<InitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3080050457840113664UL, 17930098368332441600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitActor, 0, Void >;
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	InitActor(DDTeamCollection* const& self,Reference<InitialDataDistribution> const& initTeams,const DDEnabledState* const& ddEnabledState) 
															#line 4469 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   InitActorState<InitActor>(self, initTeams, ddEnabledState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("init", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1770802396446596864UL, 4776746127134105600UL);
		ActorExecutionContextHelper __helper(static_cast<InitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("init");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("init", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> init( DDTeamCollection* const& self, Reference<InitialDataDistribution> const& initTeams, const DDEnabledState* const& ddEnabledState ) {
															#line 803 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new InitActor(self, initTeams, ddEnabledState));
															#line 4501 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 839 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 4506 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via buildTeams()
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class BuildTeamsActor>
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class BuildTeamsActorState {
															#line 4512 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	BuildTeamsActorState(DDTeamCollection* const& self) 
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 841 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   desiredTeams(),
															#line 842 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   serverCount(0),
															#line 843 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   machines()
															#line 4525 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("buildTeams", reinterpret_cast<unsigned long>(this));

	}
	~BuildTeamsActorState() 
	{
		fdb_probe_actor_destroy("buildTeams", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 846 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, g_network->getCurrentTask());
															#line 846 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<BuildTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4542 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BuildTeamsActor*>(this)->actor_wait_state = 1;
															#line 846 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BuildTeamsActor, 0, Void >*>(static_cast<BuildTeamsActor*>(this)));
															#line 4547 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BuildTeamsActorState();
		static_cast<BuildTeamsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 849 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 4570 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 849 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 4579 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BuildTeamsActor*>(this)->actor_wait_state > 0) static_cast<BuildTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<BuildTeamsActor*>(this)->ActorCallback< BuildTeamsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BuildTeamsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BuildTeamsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BuildTeamsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 858 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& [serverID, server] : self->server_info ) {
															#line 859 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!self->server_status.get(serverID).isUnhealthy())
															#line 4665 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 860 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				++serverCount;
															#line 861 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				LocalityData const& serverLocation = server->getLastKnownInterface().locality;
															#line 862 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				machines.insert(serverLocation.zoneId());
															#line 4673 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 866 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int uniqueMachines = machines.size();
															#line 867 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("BuildTeams", self->distributorId) .detail("ServerCount", self->server_info.size()) .detail("UniqueMachines", uniqueMachines) .detail("Primary", self->primary) .detail("StorageTeamSize", self->configuration.storageTeamSize);
															#line 873 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (uniqueMachines >= self->configuration.storageTeamSize)
															#line 4682 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 874 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			desiredTeams = SERVER_KNOBS->DESIRED_TEAMS_PER_SERVER * serverCount;
															#line 875 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int maxTeams = SERVER_KNOBS->MAX_TEAMS_PER_SERVER * serverCount;
															#line 878 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int teamCount = 0;
															#line 879 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int totalTeamCount = 0;
															#line 880 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int wigglingTeams = 0;
															#line 881 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for(int i = 0;i < self->teams.size();++i) {
															#line 882 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!self->teams[i]->isWrongConfiguration())
															#line 4698 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 883 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (self->teams[i]->isHealthy())
															#line 4702 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 884 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						teamCount++;
															#line 4706 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
															#line 886 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					totalTeamCount++;
															#line 4710 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 888 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (self->teams[i]->getPriority() == SERVER_KNOBS->PRIORITY_PERPETUAL_STORAGE_WIGGLE)
															#line 4714 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 889 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					wigglingTeams++;
															#line 4718 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 895 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			teamsToBuild = int();
															#line 896 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			teamsToBuild = std::max(0, std::min(desiredTeams - teamCount, maxTeams - totalTeamCount));
															#line 898 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (teamCount == 0 && teamsToBuild == 0 && SERVER_KNOBS->DD_BUILD_EXTRA_TEAMS_OVERRIDE > 0)
															#line 4727 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 900 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent(SevWarnAlways, "BuildServerTeamsHaveTooManyUnhealthyTeams") .detail("Hint", "Build teams may stuck and prevent DD from relocating data") .detail("BuildExtraServerTeamsOverride", SERVER_KNOBS->DD_BUILD_EXTRA_TEAMS_OVERRIDE);
															#line 903 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				teamsToBuild = SERVER_KNOBS->DD_BUILD_EXTRA_TEAMS_OVERRIDE;
															#line 4733 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 906 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("BuildTeamsBegin", self->distributorId) .detail("Primary", self->isPrimary()) .detail("TeamsToBuild", teamsToBuild) .detail("DesiredTeams", desiredTeams) .detail("MaxTeams", maxTeams) .detail("BadServerTeams", self->badTeams.size()) .detail("PerpetualWigglingTeams", wigglingTeams) .detail("UniqueMachines", uniqueMachines) .detail("TeamSize", self->configuration.storageTeamSize) .detail("Servers", self->server_info.size()) .detail("HealthyServers", serverCount) .detail("CurrentTrackedServerTeams", self->teams.size()) .detail("HealthyTeamCount", teamCount) .detail("TotalTeamCount", totalTeamCount) .detail("MachineTeamCount", self->machineTeams.size()) .detail("MachineCount", self->machine_info.size()) .detail("DesiredTeamsPerServer", SERVER_KNOBS->DESIRED_TEAMS_PER_SERVER);
															#line 924 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->lastBuildTeamsFailed = false;
															#line 925 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (teamsToBuild > 0 || self->notEnoughTeamsForAServer())
															#line 4741 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 926 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				builtTeams = std::vector<std::vector<UID>>();
															#line 931 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				int addedTeams = self->addTeamsBestOf(teamsToBuild, desiredTeams, maxTeams);
															#line 933 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (addedTeams <= 0 && self->teams.size() == 0)
															#line 4749 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 934 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent(SevWarn, "NoTeamAfterBuildTeam", self->distributorId) .detail("ServerTeamNum", self->teams.size()) .detail("Debug", "Check information below");
															#line 938 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->traceAllInfo();
															#line 4755 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 941 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				int totalHealthyMachineCount = self->calculateHealthyMachineCount();
															#line 943 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				int desiredMachineTeams = SERVER_KNOBS->DESIRED_TEAMS_PER_SERVER * totalHealthyMachineCount;
															#line 944 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				int maxMachineTeams = SERVER_KNOBS->MAX_TEAMS_PER_SERVER * totalHealthyMachineCount;
															#line 945 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				int healthyMachineTeamCount = self->getHealthyMachineTeamCount();
															#line 947 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				auto [minTeamsOnServer, maxTeamsOnServer] = self->calculateMinMaxServerTeamsOnServer();
															#line 948 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				auto [minMachineTeamsOnMachine, maxMachineTeamsOnMachine] = self->calculateMinMaxMachineTeamsOnMachine();
															#line 951 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("TeamCollectionInfo", self->distributorId) .detail("Primary", self->primary) .detail("AddedTeams", 0) .detail("TeamsToBuild", teamsToBuild) .detail("CurrentServerTeams", self->teams.size()) .detail("Servers", self->server_info.size()) .detail("HealthyServers", serverCount) .detail("DesiredTeams", desiredTeams) .detail("MaxTeams", maxTeams) .detail("StorageTeamSize", self->configuration.storageTeamSize) .detail("CurrentMachineTeams", self->machineTeams.size()) .detail("CurrentHealthyMachineTeams", healthyMachineTeamCount) .detail("DesiredMachineTeams", desiredMachineTeams) .detail("MaxMachineTeams", maxMachineTeams) .detail("TotalHealthyMachines", totalHealthyMachineCount) .detail("MinTeamsOnServer", minTeamsOnServer) .detail("MaxTeamsOnServer", maxTeamsOnServer) .detail("MinMachineTeamsOnMachine", maxMachineTeamsOnMachine) .detail("MaxMachineTeamsOnMachine", minMachineTeamsOnMachine) .detail("DoBuildTeams", self->doBuildTeams) .trackLatest(self->teamCollectionInfoEventHolder->trackingKey);
															#line 4774 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 976 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->lastBuildTeamsFailed = true;
															#line 977 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarnAlways, "BuildTeamsLastBuildTeamsFailed", self->distributorId) .detail("Reason", "Do not have enough unique machines") .detail("Primary", self->primary) .detail("UniqueMachines", uniqueMachines) .detail("Replication", self->configuration.storageTeamSize);
															#line 4783 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 984 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->evaluateTeamQuality();
															#line 988 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0, TaskPriority::DataDistributionLaunch);
															#line 988 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<BuildTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4791 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<BuildTeamsActor*>(this)->actor_wait_state = 3;
															#line 988 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BuildTeamsActor, 3, Void >*>(static_cast<BuildTeamsActor*>(this)));
															#line 4796 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 849 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!(self->pauseWiggle && !self->pauseWiggle->get() && self->waitUntilRecruited.get()))
															#line 4812 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->waitUntilRecruited.onChange() || self->pauseWiggle->onChange();
															#line 850 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<BuildTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4820 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 852 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY, g_network->getCurrentTask());
															#line 4824 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<BuildTeamsActor*>(this)->actor_wait_state = 2;
															#line 851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BuildTeamsActor, 1, Void >*>(static_cast<BuildTeamsActor*>(this)));
															#line 852 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BuildTeamsActor, 2, Void >*>(static_cast<BuildTeamsActor*>(this)));
															#line 4831 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BuildTeamsActor*>(this)->actor_wait_state > 0) static_cast<BuildTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<BuildTeamsActor*>(this)->ActorCallback< BuildTeamsActor, 1, Void >::remove();
		static_cast<BuildTeamsActor*>(this)->ActorCallback< BuildTeamsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BuildTeamsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BuildTeamsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BuildTeamsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BuildTeamsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BuildTeamsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BuildTeamsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 990 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<BuildTeamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BuildTeamsActorState(); static_cast<BuildTeamsActor*>(this)->destroy(); return 0; }
															#line 5004 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<BuildTeamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BuildTeamsActorState();
		static_cast<BuildTeamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 990 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<BuildTeamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BuildTeamsActorState(); static_cast<BuildTeamsActor*>(this)->destroy(); return 0; }
															#line 5016 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<BuildTeamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BuildTeamsActorState();
		static_cast<BuildTeamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BuildTeamsActor*>(this)->actor_wait_state > 0) static_cast<BuildTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<BuildTeamsActor*>(this)->ActorCallback< BuildTeamsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BuildTeamsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BuildTeamsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BuildTeamsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 841 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int desiredTeams;
															#line 842 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int serverCount;
															#line 843 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::set<Optional<Standalone<StringRef>>> machines;
															#line 895 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int teamsToBuild;
															#line 926 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<std::vector<UID>> builtTeams;
															#line 5111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via buildTeams()
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class BuildTeamsActor final : public Actor<Void>, public ActorCallback< BuildTeamsActor, 0, Void >, public ActorCallback< BuildTeamsActor, 1, Void >, public ActorCallback< BuildTeamsActor, 2, Void >, public ActorCallback< BuildTeamsActor, 3, Void >, public FastAllocated<BuildTeamsActor>, public BuildTeamsActorState<BuildTeamsActor> {
															#line 5116 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<BuildTeamsActor>::operator new;
	using FastAllocated<BuildTeamsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10484471668131910144UL, 2648420236765083136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BuildTeamsActor, 0, Void >;
friend struct ActorCallback< BuildTeamsActor, 1, Void >;
friend struct ActorCallback< BuildTeamsActor, 2, Void >;
friend struct ActorCallback< BuildTeamsActor, 3, Void >;
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	BuildTeamsActor(DDTeamCollection* const& self) 
															#line 5136 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BuildTeamsActorState<BuildTeamsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("buildTeams", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15270091788571443456UL, 10430716928193191680UL);
		ActorExecutionContextHelper __helper(static_cast<BuildTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("buildTeams");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("buildTeams", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BuildTeamsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BuildTeamsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BuildTeamsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> buildTeams( DDTeamCollection* const& self ) {
															#line 840 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new BuildTeamsActor(self));
															#line 5170 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 992 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

	// Track a team and issue RelocateShards when the level of degradation changes
	// A badTeam can be unhealthy or just a redundantTeam removed by machineTeamRemover() or serverTeamRemover()
																#line 5177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via teamTracker()
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class TeamTrackerActor>
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class TeamTrackerActorState {
															#line 5183 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	TeamTrackerActorState(DDTeamCollection* const& self,Reference<TCTeamInfo> const& team,IsBadTeam const& badTeam,IsRedundantTeam const& redundantTeam) 
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   team(team),
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   badTeam(badTeam),
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   redundantTeam(redundantTeam),
															#line 999 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastServersLeft(team->size()),
															#line 1000 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastAnyUndesired(false),
															#line 1001 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastAnyWigglingServer(false),
															#line 1002 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   logTeamEvents(g_network->isSimulated() || !badTeam || team->size() <= self->configuration.storageTeamSize),
															#line 1004 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastReady(false),
															#line 1005 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastHealthy(),
															#line 1006 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastOptimal(),
															#line 1007 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastWrongConfiguration(team->isWrongConfiguration()),
															#line 1008 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   trackHealthyTeam(team->size() == self->configuration.storageTeamSize),
															#line 1009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastZeroHealthy(self->zeroHealthyTeams->get()),
															#line 1010 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   firstCheck(true),
															#line 1012 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   zeroServerLeftLogger()
															#line 5220 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("teamTracker", reinterpret_cast<unsigned long>(this));

	}
	~TeamTrackerActorState() 
	{
		fdb_probe_actor_destroy("teamTracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1014 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (logTeamEvents)
															#line 5235 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1015 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("ServerTeamTrackerStarting", self->distributorId) .detail("Reason", "Initial wait complete (sc)") .detail("ServerTeam", team->getDesc());
															#line 5239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1019 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->priority_teams[team->getPriority()]++;
															#line 5243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			try {
															#line 1022 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				;
															#line 5247 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TeamTrackerActorState();
		static_cast<TeamTrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1326 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (logTeamEvents)
															#line 5277 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1327 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("TeamTrackerStopping", self->distributorId) .errorUnsuppressed(e) .detail("ServerPrimary", self->primary) .detail("Team", team->getDesc()) .detail("Priority", team->getPriority());
															#line 5281 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1333 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->priority_teams[team->getPriority()]--;
															#line 1334 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (trackHealthyTeam)
															#line 5287 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1335 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (team->isHealthy())
															#line 5291 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1336 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->healthyTeamCount--;
															#line 1337 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ASSERT_GE(self->healthyTeamCount, 0);
															#line 1339 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (self->healthyTeamCount == 0)
															#line 5299 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1340 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						TraceEvent(SevWarn, "ZeroTeamsHealthySignalling", self->distributorId) .detail("ServerPrimary", self->primary) .detail("SignallingServerTeam", team->getDesc());
															#line 1343 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						self->zeroHealthyTeams->set(true);
															#line 5305 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
															#line 1346 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (lastOptimal)
															#line 5310 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1347 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->optimalTeamCount--;
															#line 1348 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ASSERT_GE(self->optimalTeamCount, 0);
															#line 1349 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->zeroOptimalTeams.set(self->optimalTeamCount == 0);
															#line 5318 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 1352 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1023 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (logTeamEvents)
															#line 5344 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1024 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("ServerTeamHealthChangeDetected", self->distributorId) .detail("ServerTeam", team->getDesc()) .detail("Primary", self->primary) .detail("IsReady", self->initialFailureReactionDelay.isReady());
															#line 1028 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->traceTeamCollectionInfo();
															#line 5350 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1032 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		change = std::vector<Future<Void>>();
															#line 1033 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool anyUndesired = false;
															#line 1034 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool anyWrongConfiguration = false;
															#line 1035 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool anyWigglingServer = false;
															#line 1036 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		const bool ignoreSSFailures = !badTeam && self->healthyZone.get().present() && (self->healthyZone.get().get() == ignoreSSFailuresZoneString);
															#line 1038 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int serversLeft = 0, serverUndesired = 0, serverWrongConf = 0, serverWiggling = 0;
															#line 1040 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const UID& uid : team->getServerIDs() ) {
															#line 1041 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			change.push_back(self->server_status.onChange(uid));
															#line 1042 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			auto& status = self->server_status.get(uid);
															#line 1043 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!status.isFailed || ignoreSSFailures)
															#line 5372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1044 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				serversLeft++;
															#line 5376 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1046 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (status.isUndesired)
															#line 5380 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1047 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				anyUndesired = true;
															#line 1048 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				serverUndesired++;
															#line 5386 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1050 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (status.isWrongConfiguration)
															#line 5390 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1051 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				anyWrongConfiguration = true;
															#line 1052 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				serverWrongConf++;
															#line 5396 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1054 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (status.isWiggling)
															#line 5400 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1055 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				anyWigglingServer = true;
															#line 1056 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				serverWiggling++;
															#line 5406 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 1060 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (serversLeft == 0)
															#line 5411 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1061 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			logTeamEvents = true;
															#line 5415 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1065 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (ignoreSSFailures)
															#line 5419 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1066 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT_WE_THINK(serversLeft == team->size());
															#line 5423 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1069 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->initialFailureReactionDelay.isReady())
															#line 5427 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1070 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			change.push_back(self->initialFailureReactionDelay);
															#line 5431 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1072 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		change.push_back(self->zeroHealthyTeams->onChange());
															#line 1074 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool healthy = !badTeam && !anyUndesired && serversLeft == team->size();
															#line 1075 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		team->setHealthy(healthy);
															#line 1076 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool optimal = team->isOptimal() && healthy;
															#line 1077 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool containsFailed = self->teamContainsFailedServer(team);
															#line 1078 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool recheck = !healthy && (lastReady != self->initialFailureReactionDelay.isReady() || (lastZeroHealthy && !self->zeroHealthyTeams->get()) || containsFailed);
															#line 1081 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent(SevVerbose, "TeamHealthChangeDetected", self->distributorId) .detail("Team", team->getDesc()) .detail("ServersLeft", serversLeft) .detail("LastServersLeft", lastServersLeft) .detail("AnyUndesired", anyUndesired) .detail("LastAnyUndesired", lastAnyUndesired) .detail("AnyWrongConfiguration", anyWrongConfiguration) .detail("LastWrongConfiguration", lastWrongConfiguration) .detail("ContainsWigglingServer", anyWigglingServer) .detail("Recheck", recheck) .detail("BadTeam", badTeam) .detail("LastZeroHealthy", lastZeroHealthy) .detail("ZeroHealthyTeam", self->zeroHealthyTeams->get());
															#line 1095 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		lastReady = self->initialFailureReactionDelay.isReady();
															#line 1096 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		lastZeroHealthy = self->zeroHealthyTeams->get();
															#line 1098 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (firstCheck && trackHealthyTeam)
															#line 5453 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1099 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			firstCheck = false;
															#line 1100 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (healthy)
															#line 5459 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1101 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->healthyTeamCount++;
															#line 1102 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->zeroHealthyTeams->set(false);
															#line 5465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			lastHealthy = healthy;
															#line 1106 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (optimal)
															#line 5471 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1107 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->optimalTeamCount++;
															#line 1108 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->zeroOptimalTeams.set(false);
															#line 5477 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1110 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			lastOptimal = optimal;
															#line 5481 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (serversLeft != lastServersLeft || anyUndesired != lastAnyUndesired || anyWrongConfiguration != lastWrongConfiguration || anyWigglingServer != lastAnyWigglingServer || recheck)
															#line 5485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1116 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (logTeamEvents)
															#line 5489 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1117 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("ServerTeamHealthChanged", self->distributorId) .detail("ServerTeam", team->getDesc()) .detail("ServersLeft", serversLeft) .detail("LastServersLeft", lastServersLeft) .detail("ContainsUndesiredServer", anyUndesired) .detail("ContainsWigglingServer", anyWigglingServer) .detail("HealthyTeamsCount", self->healthyTeamCount) .detail("IsWrongConfiguration", anyWrongConfiguration);
															#line 5493 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1127 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			team->setWrongConfiguration(anyWrongConfiguration);
															#line 1129 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (trackHealthyTeam)
															#line 5499 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1130 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (optimal != lastOptimal)
															#line 5503 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1131 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					lastOptimal = optimal;
															#line 1132 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->optimalTeamCount += optimal ? 1 : -1;
															#line 1134 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ASSERT_GE(self->optimalTeamCount, 0);
															#line 1135 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->zeroOptimalTeams.set(self->optimalTeamCount == 0);
															#line 5513 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1138 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (lastHealthy != healthy)
															#line 5517 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1139 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					lastHealthy = healthy;
															#line 1141 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->healthyTeamCount += healthy ? 1 : -1;
															#line 1143 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ASSERT_GE(self->healthyTeamCount, 0);
															#line 1144 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->zeroHealthyTeams->set(self->healthyTeamCount == 0);
															#line 1146 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (self->healthyTeamCount == 0)
															#line 5529 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						TraceEvent(SevWarn, "ZeroServerTeamsHealthySignalling", self->distributorId) .detail("SignallingTeam", team->getDesc()) .detail("Primary", self->primary);
															#line 5533 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
															#line 1152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (logTeamEvents)
															#line 5537 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1153 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						TraceEvent("ServerTeamHealthDifference", self->distributorId) .detail("ServerTeam", team->getDesc()) .detail("LastOptimal", lastOptimal) .detail("LastHealthy", lastHealthy) .detail("Optimal", optimal) .detail("OptimalTeamCount", self->optimalTeamCount);
															#line 5541 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			lastServersLeft = serversLeft;
															#line 1164 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			lastAnyUndesired = anyUndesired;
															#line 1165 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			lastWrongConfiguration = anyWrongConfiguration;
															#line 1166 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			lastAnyWigglingServer = anyWigglingServer;
															#line 1168 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			lastPriority = team->getPriority();
															#line 1169 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (team->size() == 0)
															#line 5557 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1170 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				team->setPriority(SERVER_KNOBS->PRIORITY_POPULATE_REGION);
															#line 5561 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (serversLeft < team->size())
															#line 5567 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1172 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (serversLeft == 0)
															#line 5571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1173 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						team->setPriority(SERVER_KNOBS->PRIORITY_TEAM_0_LEFT);
															#line 5575 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (serversLeft == 1)
															#line 5581 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 1175 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							team->setPriority(SERVER_KNOBS->PRIORITY_TEAM_1_LEFT);
															#line 5585 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						}
						else
						{
															#line 1176 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (serversLeft == 2)
															#line 5591 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							{
															#line 1177 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								team->setPriority(SERVER_KNOBS->PRIORITY_TEAM_2_LEFT);
															#line 5595 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							}
							else
							{
															#line 1179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								team->setPriority(SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY);
															#line 5601 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							}
						}
					}
				}
				else
				{
															#line 1180 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (!badTeam && anyWigglingServer && serverWiggling == serverWrongConf && serverWiggling == serverUndesired)
															#line 5610 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1183 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						team->setPriority(SERVER_KNOBS->PRIORITY_PERPETUAL_STORAGE_WIGGLE);
															#line 5614 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1185 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (badTeam || anyWrongConfiguration)
															#line 5620 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 1186 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (redundantTeam)
															#line 5624 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							{
															#line 1187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								team->setPriority(SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT);
															#line 5628 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							}
							else
							{
															#line 1189 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								team->setPriority(SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY);
															#line 5634 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							}
						}
						else
						{
															#line 1191 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (anyUndesired)
															#line 5641 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							{
															#line 1192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								team->setPriority(SERVER_KNOBS->PRIORITY_TEAM_CONTAINS_UNDESIRED_SERVER);
															#line 5645 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							}
							else
							{
															#line 1194 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								team->setPriority(SERVER_KNOBS->PRIORITY_TEAM_HEALTHY);
															#line 5651 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							}
						}
					}
				}
			}
															#line 1197 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (lastPriority != team->getPriority())
															#line 5659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->priority_teams[lastPriority]--;
															#line 1199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->priority_teams[team->getPriority()]++;
															#line 1200 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (lastPriority == SERVER_KNOBS->PRIORITY_TEAM_0_LEFT && team->getPriority() < SERVER_KNOBS->PRIORITY_TEAM_0_LEFT)
															#line 5667 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					zeroServerLeftLogger = Void();
															#line 5671 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1204 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (logTeamEvents)
															#line 5675 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1205 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					int dataLoss = team->getPriority() == SERVER_KNOBS->PRIORITY_TEAM_0_LEFT;
															#line 1206 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					Severity severity = dataLoss ? SevWarnAlways : SevInfo;
															#line 1207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent(severity, "ServerTeamPriorityChange", self->distributorId) .detail("Priority", team->getPriority()) .detail("Info", team->getDesc()) .detail("ZeroHealthyServerTeams", self->zeroHealthyTeams->get()) .detail("Hint", severity == SevWarnAlways ? "No replicas remain of some data" : "The priority of this team changed");
															#line 1214 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (team->getPriority() == SERVER_KNOBS->PRIORITY_TEAM_0_LEFT)
															#line 5685 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1216 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						zeroServerLeftLogger = zeroServerLeftLoggerActor(self, team);
															#line 5689 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			lastZeroHealthy = self->zeroHealthyTeams ->get();
															#line 1223 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if ((self->initialFailureReactionDelay.isReady() && !self->zeroHealthyTeams->get()) || containsFailed)
															#line 5697 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1226 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				std::vector<KeyRange> shards = self->shardsAffectedByTeamFailure->getShardsFor( ShardsAffectedByTeamFailure::Team(team->getServerIDs(), self->primary));
															#line 1229 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent(SevVerbose, "ServerTeamRelocatingShards", self->distributorId) .detail("Info", team->getDesc()) .detail("TeamID", team->getTeamID()) .detail("Shards", shards.size());
															#line 1234 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for(int i = 0;i < shards.size();i++) {
															#line 1237 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					int maxPriority = containsFailed ? SERVER_KNOBS->PRIORITY_TEAM_FAILED : team->getPriority();
															#line 1240 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (maxPriority < SERVER_KNOBS->PRIORITY_TEAM_FAILED)
															#line 5709 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1241 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						std::pair<std::vector<ShardsAffectedByTeamFailure::Team>, std::vector<ShardsAffectedByTeamFailure::Team>> teams = self->shardsAffectedByTeamFailure->getTeamsForFirstShard(shards[i]);
															#line 1244 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						for(int j = 0;j < teams.first.size() + teams.second.size();j++) {
															#line 1246 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							auto& t = j < teams.first.size() ? teams.first[j] : teams.second[j - teams.first.size()];
															#line 1248 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (!t.servers.size())
															#line 5719 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							{
															#line 1249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								maxPriority = std::max(maxPriority, SERVER_KNOBS->PRIORITY_POPULATE_REGION);
															#line 5723 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
								break;
							}
															#line 1253 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							auto tc = self->teamCollections[t.primary ? 0 : 1];
															#line 1254 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (tc == nullptr)
															#line 5730 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							{
															#line 1261 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								return a_body1Catch2(dd_cancelled(), std::max(0, loopDepth - 1));
															#line 5734 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							}
															#line 1263 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							ASSERT_EQ(tc->primary, t.primary);
															#line 1265 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							if (tc->server_info.contains(t.servers[0]))
															#line 5740 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							{
															#line 1266 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								auto& info = tc->server_info[t.servers[0]];
															#line 1268 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								bool found = false;
															#line 1269 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								for(int k = 0;k < info->getTeams().size();k++) {
															#line 1270 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
									if (info->getTeams()[k]->getServerIDs() == t.servers)
															#line 5750 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
									{
															#line 1271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
										maxPriority = std::max(maxPriority, info->getTeams()[k]->getPriority());
															#line 1272 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
										found = true;
															#line 5756 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
										break;
									}
								}
															#line 1280 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								if (!found)
															#line 5762 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
								{
															#line 1284 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
									maxPriority = std::max<int>(maxPriority, redundantTeam ? SERVER_KNOBS->PRIORITY_TEAM_REDUNDANT : SERVER_KNOBS->PRIORITY_TEAM_UNHEALTHY);
															#line 5766 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
								}
							}
							else
							{
															#line 1290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
								CODE_PROBE(true, "A removed server is still associated with a team in " "ShardsAffectedByTeamFailure");
															#line 5773 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							}
						}
					}
															#line 1297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					RelocateShard rs( shards[i], maxPriority, RelocateReason::OTHER, deterministicRandom()->randomUniqueID());
															#line 1300 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->output.send(rs);
															#line 1301 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("SendRelocateToDDQueue", self->distributorId) .suppressFor(1.0) .detail("TraceId", rs.traceId) .detail("ServerPrimary", self->primary) .detail("ServerTeam", team->getDesc()) .detail("KeyBegin", rs.keys.begin) .detail("KeyEnd", rs.keys.end) .detail("Priority", rs.priority) .detail("ServerTeamFailedMachines", team->size() - serversLeft) .detail("ServerTeamOKMachines", serversLeft);
															#line 5783 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1313 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (logTeamEvents)
															#line 5790 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1314 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("ServerTeamHealthNotReady", self->distributorId) .detail("HealthyServerTeamCount", self->healthyTeamCount) .detail("ServerTeamID", team->getTeamID());
															#line 5794 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1322 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = quorum(change, 1);
															#line 1322 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<TeamTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5802 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TeamTrackerActor*>(this)->actor_wait_state = 1;
															#line 1322 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TeamTrackerActor, 0, Void >*>(static_cast<TeamTrackerActor*>(this)));
															#line 5807 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 1323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<TeamTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5818 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TeamTrackerActor*>(this)->actor_wait_state = 2;
															#line 1323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TeamTrackerActor, 1, Void >*>(static_cast<TeamTrackerActor*>(this)));
															#line 5823 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 1323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<TeamTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5834 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TeamTrackerActor*>(this)->actor_wait_state = 2;
															#line 1323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TeamTrackerActor, 1, Void >*>(static_cast<TeamTrackerActor*>(this)));
															#line 5839 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TeamTrackerActor*>(this)->actor_wait_state > 0) static_cast<TeamTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TeamTrackerActor*>(this)->ActorCallback< TeamTrackerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TeamTrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("teamTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeamTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teamTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TeamTrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("teamTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeamTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teamTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TeamTrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("teamTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TeamTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teamTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont56(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont56(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont56(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont56(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TeamTrackerActor*>(this)->actor_wait_state > 0) static_cast<TeamTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TeamTrackerActor*>(this)->ActorCallback< TeamTrackerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TeamTrackerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("teamTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeamTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teamTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TeamTrackerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("teamTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeamTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teamTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TeamTrackerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("teamTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TeamTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teamTracker", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Reference<TCTeamInfo> team;
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	IsBadTeam badTeam;
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	IsRedundantTeam redundantTeam;
															#line 999 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int lastServersLeft;
															#line 1000 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool lastAnyUndesired;
															#line 1001 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool lastAnyWigglingServer;
															#line 1002 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool logTeamEvents;
															#line 1004 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool lastReady;
															#line 1005 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool lastHealthy;
															#line 1006 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool lastOptimal;
															#line 1007 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool lastWrongConfiguration;
															#line 1008 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool trackHealthyTeam;
															#line 1009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool lastZeroHealthy;
															#line 1010 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool firstCheck;
															#line 1012 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> zeroServerLeftLogger;
															#line 1032 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<Future<Void>> change;
															#line 1168 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int lastPriority;
															#line 6042 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via teamTracker()
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class TeamTrackerActor final : public Actor<Void>, public ActorCallback< TeamTrackerActor, 0, Void >, public ActorCallback< TeamTrackerActor, 1, Void >, public FastAllocated<TeamTrackerActor>, public TeamTrackerActorState<TeamTrackerActor> {
															#line 6047 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<TeamTrackerActor>::operator new;
	using FastAllocated<TeamTrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5517712987387703552UL, 1434616797029952512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TeamTrackerActor, 0, Void >;
friend struct ActorCallback< TeamTrackerActor, 1, Void >;
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	TeamTrackerActor(DDTeamCollection* const& self,Reference<TCTeamInfo> const& team,IsBadTeam const& badTeam,IsRedundantTeam const& redundantTeam) 
															#line 6065 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TeamTrackerActorState<TeamTrackerActor>(self, team, badTeam, redundantTeam),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("teamTracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13815155235040130816UL, 14418641208538112000UL);
		ActorExecutionContextHelper __helper(static_cast<TeamTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("teamTracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("teamTracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TeamTrackerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TeamTrackerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> teamTracker( DDTeamCollection* const& self, Reference<TCTeamInfo> const& team, IsBadTeam const& badTeam, IsRedundantTeam const& redundantTeam ) {
															#line 995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new TeamTrackerActor(self, team, badTeam, redundantTeam));
															#line 6098 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 1355 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 6103 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via storageServerTracker()
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class StorageServerTrackerActor>
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class StorageServerTrackerActorState {
															#line 6109 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	StorageServerTrackerActorState(DDTeamCollection* const& self,TCServerInfo* const& server,Promise<Void> const& errorOut,Version const& addedVersion,const DDEnabledState* const& ddEnabledState,bool const& isTss) 
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   server(server),
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   errorOut(errorOut),
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   addedVersion(addedVersion),
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   ddEnabledState(ddEnabledState),
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   isTss(isTss),
															#line 1363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   failureTracker(),
															#line 1364 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   status(server->getLastKnownInterface().locality),
															#line 1365 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   lastIsUnhealthy(false),
															#line 1366 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   metricsTracker(server->serverMetricsPolling(self->db)),
															#line 1368 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   interfaceChanged(server->onInterfaceChanged),
															#line 1369 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   hasWrongDC(!self->isCorrectDC(*server)),
															#line 1370 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   hasInvalidLocality(!self->isValidLocality(self->configuration.storagePolicy, server->getLastKnownInterface().locality)),
															#line 1372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   targetTeamNumPerServer((SERVER_KNOBS->DESIRED_TEAMS_PER_SERVER * (self->configuration.storageTeamSize + 1)) / 2),
															#line 1374 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   storageMetadataTracker(self->updateStorageMetadata(server))
															#line 6144 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("storageServerTracker", reinterpret_cast<unsigned long>(this));

	}
	~StorageServerTrackerActorState() 
	{
		fdb_probe_actor_destroy("storageServerTracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1376 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				;
															#line 6160 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageServerTrackerActorState();
		static_cast<StorageServerTrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1751 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			err = e;
															#line 1752 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("StorageServerTrackerCancelled", self->distributorId) .errorUnsuppressed(e) .suppressFor(1.0) .detail("Primary", self->primary) .detail("Server", server->getId());
															#line 1757 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (e.code() != error_code_actor_cancelled && errorOut.canBeSet())
															#line 6194 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1758 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				errorOut.sendError(e);
															#line 1759 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_12 = delay(0);
															#line 1759 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_12.get(), loopDepth); };
				static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 5;
															#line 1759 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 12, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 6207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1Catch2cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1377 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		status.isUndesired = (!self->disableFailingLaggingServers.get() && server->ssVersionTooFarBehind.get());
															#line 1378 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		status.isWrongConfiguration = false;
															#line 1379 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		status.isWiggling = false;
															#line 1380 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		hasWrongDC = !self->isCorrectDC(*server);
															#line 1381 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		hasInvalidLocality = !self->isValidLocality(self->configuration.storagePolicy, server->getLastKnownInterface().locality);
															#line 1387 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		otherChanges = std::vector<Future<Void>>();
															#line 1388 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		std::vector<Promise<Void>> wakeUpTrackers;
															#line 1389 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& i : self->server_and_tss_info ) {
															#line 1390 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->db->isMocked())
															#line 6250 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 1392 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (i.second.getPtr() != server && i.second->getLastKnownInterface().address() == server->getLastKnownInterface().address())
															#line 6256 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1394 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				auto& statusInfo = self->server_status.get(i.first);
															#line 1395 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("SameAddress", self->distributorId) .detail("Failed", statusInfo.isFailed) .detail("Undesired", statusInfo.isUndesired) .detail("Server", server->getId()) .detail("OtherServer", i.second->getId()) .detail("Address", server->getLastKnownInterface().address()) .detail("NumShards", self->shardsAffectedByTeamFailure->getNumberOfShards(server->getId())) .detail("OtherNumShards", self->shardsAffectedByTeamFailure->getNumberOfShards(i.second->getId())) .detail("OtherHealthy", !self->server_status.get(i.second->getId()).isUnhealthy());
															#line 1406 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				otherChanges.push_back(self->server_status.onChange(i.second->getId()));
															#line 1407 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!self->server_status.get(i.second->getId()).isUnhealthy())
															#line 6266 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1408 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (self->shardsAffectedByTeamFailure->getNumberOfShards(i.second->getId()) >= self->shardsAffectedByTeamFailure->getNumberOfShards(server->getId()))
															#line 6270 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1410 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						TraceEvent(SevWarn, "UndesiredStorageServer", self->distributorId) .detail("Server", server->getId()) .detail("Address", server->getLastKnownInterface().address()) .detail("OtherServer", i.second->getId()) .detail("NumShards", self->shardsAffectedByTeamFailure->getNumberOfShards(server->getId())) .detail("OtherNumShards", self->shardsAffectedByTeamFailure->getNumberOfShards(i.second->getId()));
															#line 1419 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						status.isUndesired = true;
															#line 6276 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1421 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						wakeUpTrackers.push_back(i.second->wakeUpTracker);
															#line 6282 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 1426 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto& p : wakeUpTrackers ) {
															#line 1427 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!p.isSet())
															#line 6291 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1428 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				p.send(Void());
															#line 6295 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 1431 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (server->getLastKnownClass().machineClassFitness(ProcessClass::Storage) > ProcessClass::UnsetFit)
															#line 6300 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1435 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->optimalTeamCount > 0)
															#line 6304 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1436 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent(SevWarn, "UndesiredStorageServer", self->distributorId) .detail("Server", server->getId()) .detail("OptimalTeamCount", self->optimalTeamCount) .detail("Fitness", server->getLastKnownClass().machineClassFitness(ProcessClass::Storage));
															#line 1440 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				status.isUndesired = true;
															#line 6310 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1442 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			otherChanges.push_back(self->zeroOptimalTeams.onChange());
															#line 6314 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1447 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (hasWrongDC || hasInvalidLocality)
															#line 6318 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1448 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "UndesiredDCOrLocality", self->distributorId) .detail("Server", server->getId()) .detail("WrongDC", hasWrongDC) .detail("InvalidLocality", hasInvalidLocality);
															#line 1452 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			status.isUndesired = true;
															#line 1453 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			status.isWrongConfiguration = true;
															#line 6326 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1455 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (server->wrongStoreTypeToRemove.get())
															#line 6330 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1456 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "WrongStoreTypeToRemove", self->distributorId) .detail("Server", server->getId()) .detail("StoreType", "?");
															#line 1459 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			status.isUndesired = true;
															#line 1460 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			status.isWrongConfiguration = true;
															#line 6338 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		auto invalidWiggleServer = [](const AddressExclusion& addr, const DDTeamCollection* tc, const TCServerInfo* server) { return !tc->wigglingId.present() || server->getId() != tc->wigglingId.get(); };
															#line 1470 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		NetworkAddress a = server->getLastKnownInterface().address();
															#line 1471 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		AddressExclusion worstAddr(a.ip, a.port);
															#line 1472 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		DDTeamCollection::Status worstStatus = self->excludedServers.get(worstAddr);
															#line 1474 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (worstStatus == DDTeamCollection::Status::WIGGLING && invalidWiggleServer(worstAddr, self, server))
															#line 6350 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1475 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevInfo, "InvalidWiggleServer", self->distributorId) .detail("Address", worstAddr.toString()) .detail("ServerId", server->getId()) .detail("WigglingId", self->wigglingId.present() ? self->wigglingId.get().toString() : "");
															#line 1479 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			worstStatus = DDTeamCollection::Status::NONE;
															#line 6356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1481 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		otherChanges.push_back(self->excludedServers.onChange(worstAddr));
															#line 1484 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for(int i = 0;i < 3;i++) {
															#line 1485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (i > 0 && !server->getLastKnownInterface().secondaryAddress().present())
															#line 6364 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
				break;
			}
															#line 1488 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			AddressExclusion testAddr;
															#line 1489 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (i == 0)
															#line 6372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1490 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				testAddr = AddressExclusion(a.ip);
															#line 6376 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1491 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (i == 1)
															#line 6382 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1492 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					testAddr = AddressExclusion(server->getLastKnownInterface().secondaryAddress().get().ip, server->getLastKnownInterface().secondaryAddress().get().port);
															#line 6386 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1494 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (i == 2)
															#line 6392 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 1495 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						testAddr = AddressExclusion(server->getLastKnownInterface().secondaryAddress().get().ip);
															#line 6396 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1496 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			DDTeamCollection::Status testStatus = self->excludedServers.get(testAddr);
															#line 1498 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (testStatus == DDTeamCollection::Status::WIGGLING && invalidWiggleServer(testAddr, self, server))
															#line 6404 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1500 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent(SevInfo, "InvalidWiggleServer", self->distributorId) .detail("Address", worstAddr.toString()) .detail("ServerId", server->getId()) .detail("WigglingId", self->wigglingId.present() ? self->wigglingId.get().toString() : "");
															#line 1504 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				testStatus = DDTeamCollection::Status::NONE;
															#line 6410 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1507 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (testStatus > worstStatus)
															#line 6414 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1508 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				worstStatus = testStatus;
															#line 1509 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				worstAddr = testAddr;
															#line 6420 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1511 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			otherChanges.push_back(self->excludedServers.onChange(testAddr));
															#line 6424 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1514 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (worstStatus != DDTeamCollection::Status::NONE)
															#line 6428 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1515 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "UndesiredStorageServer", self->distributorId) .detail("Server", server->getId()) .detail("Excluded", worstAddr.toString());
															#line 1518 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			status.isUndesired = true;
															#line 1519 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			status.isWrongConfiguration = true;
															#line 1521 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (worstStatus == DDTeamCollection::Status::WIGGLING && !isTss)
															#line 6438 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1522 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				status.isWiggling = true;
															#line 1523 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("PerpetualStorageWiggleSS", self->distributorId) .detail("Primary", self->primary) .detail("Server", server->getId()) .detail("ProcessId", server->getLastKnownInterface().locality.processId()) .detail("Address", worstAddr.toString());
															#line 6444 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1cont24(loopDepth);
			}
			else
			{
															#line 1528 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (worstStatus == DDTeamCollection::Status::FAILED && !isTss)
															#line 6451 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1529 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent(SevWarn, "FailedServerRemoveKeys", self->distributorId) .detail("Server", server->getId()) .detail("Excluded", worstAddr.toString());
															#line 1532 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					StrictFuture<Void> __when_expr_0 = delay(0.0);
															#line 1532 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6459 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
					static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 1;
															#line 1532 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 0, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 6464 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1cont26(loopDepth);
				}
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1543 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		failureTracker = storageServerFailureTracker(self, server, &status, addedVersion);
															#line 1545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (hasWrongDC || hasInvalidLocality || server->wrongStoreTypeToRemove.get())
															#line 6486 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1546 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->restartRecruiting.trigger();
															#line 6490 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1549 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (lastIsUnhealthy && !status.isUnhealthy() && !isTss && (server->getTeams().size() < targetTeamNumPerServer || self->lastBuildTeamsFailed))
															#line 6494 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1551 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->doBuildTeams = true;
															#line 1552 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->restartTeamBuilder .trigger();
															#line 6500 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1555 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		lastIsUnhealthy = status.isUnhealthy();
															#line 1557 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		recordTeamCollectionInfo = false;
															#line 1559 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = failureTracker || server->onTSSPairRemoved || server->killTss.getFuture();
															#line 1558 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6510 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 1587 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<std::pair<StorageServerInterface, ProcessClass>> __when_expr_3 = interfaceChanged;
															#line 6514 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
															#line 1706 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_4 = otherChanges.empty() ? Never() : quorum(otherChanges, 1);
															#line 6518 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when3(__when_expr_4.get(), loopDepth); };
															#line 1709 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_5 = server->wrongStoreTypeToRemove.onChange();
															#line 6522 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when4(__when_expr_5.get(), loopDepth); };
															#line 1716 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_6 = server->wakeUpTracker.getFuture();
															#line 6526 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when5(__when_expr_6.get(), loopDepth); };
															#line 1719 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_7 = storageMetadataTracker;
															#line 6530 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when6(__when_expr_7.get(), loopDepth); };
															#line 1720 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_8 = server->ssVersionTooFarBehind.onChange();
															#line 6534 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when7(__when_expr_8.get(), loopDepth); };
															#line 1721 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->disableFailingLaggingServers.onChange();
															#line 6538 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when8(__when_expr_9.get(), loopDepth); };
															#line 1722 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_10 = server->longStorageQueue.onChange();
															#line 6542 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when9(__when_expr_10.get(), loopDepth); };
		static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 3;
															#line 1559 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 2, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 1587 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 3, std::pair<StorageServerInterface, ProcessClass> >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 1706 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 4, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 1709 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 5, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 1716 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 6, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 1719 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 7, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 1720 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 8, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 1721 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 9, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 1722 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 10, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 6563 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont24(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont26(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont27(Void const& _,int loopDepth) 
	{
															#line 1533 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 6584 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont27loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont27(Void && _,int loopDepth) 
	{
															#line 1533 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 6593 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont27loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont27(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont27(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state > 0) static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont27cont1(int loopDepth) 
	{
															#line 1536 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (self->removeFailedServer.canBeSet())
															#line 6677 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1537 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->removeFailedServer.send(server->getId());
															#line 6681 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1539 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		return a_body1Catch2(movekeys_conflict(), std::max(0, loopDepth - 1));
															#line 6685 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1cont27loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont27loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont27loopBody1(int loopDepth) 
	{
															#line 1533 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!(!ddEnabledState->isEnabled()))
															#line 6700 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont27break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1534 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 1534 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6708 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont27loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 2;
															#line 1534 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 1, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 6713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont27break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont27cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont27loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont27loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont27loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont27loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont27loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont27loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont27loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont27loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state > 0) static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont27loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont27loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont28(int loopDepth) 
	{
															#line 1746 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (recordTeamCollectionInfo)
															#line 6822 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1747 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->traceTeamCollectionInfo();
															#line 6826 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1561 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("StatusMapChange", self->distributorId) .detail("ServerID", server->getId()) .detail("Status", "Removing");
															#line 1565 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (server->updated.canBeSet())
															#line 6838 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1566 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			server->updated.send(Void());
															#line 6842 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1570 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		storageMetadataTracker.cancel();
															#line 1571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->db->removeStorageServer( server->getId(), server->getLastKnownInterface().tssPairID, self->lock, ddEnabledState);
															#line 1571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6850 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1when1(__when_expr_11.get(), loopDepth); };
		static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 4;
															#line 1571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 11, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 6855 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 1561 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("StatusMapChange", self->distributorId) .detail("ServerID", server->getId()) .detail("Status", "Removing");
															#line 1565 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (server->updated.canBeSet())
															#line 6866 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1566 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			server->updated.send(Void());
															#line 6870 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1570 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		storageMetadataTracker.cancel();
															#line 1571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_11 = self->db->removeStorageServer( server->getId(), server->getLastKnownInterface().tssPairID, self->lock, ddEnabledState);
															#line 1571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6878 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch2(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1when1(__when_expr_11.get(), loopDepth); };
		static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 4;
															#line 1571 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< StorageServerTrackerActor, 11, Void >*>(static_cast<StorageServerTrackerActor*>(this)));
															#line 6883 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(std::pair<StorageServerInterface, ProcessClass> const& newInterface,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		auto const& lastKnownInterface = server->getLastKnownInterface();
															#line 1589 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool restartRecruiting = newInterface.first.waitFailure.getEndpoint().getPrimaryAddress() != lastKnownInterface.waitFailure.getEndpoint().getPrimaryAddress();
															#line 1591 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool localityChanged = lastKnownInterface.locality != newInterface.first.locality;
															#line 1592 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool machineLocalityChanged = lastKnownInterface.locality.zoneId().get() != newInterface.first.locality.zoneId().get();
															#line 1594 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("StorageServerInterfaceChanged", self->distributorId) .detail("ServerID", server->getId()) .detail("NewWaitFailureToken", newInterface.first.waitFailure.getEndpoint().token) .detail("OldWaitFailureToken", lastKnownInterface.waitFailure.getEndpoint().token) .detail("LocalityChanged", localityChanged) .detail("MachineLocalityChanged", machineLocalityChanged);
															#line 1601 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		server->updateLastKnown(newInterface.first, newInterface.second);
															#line 1602 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (localityChanged && !isTss)
															#line 6904 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1603 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			CODE_PROBE(true, "Server locality changed");
															#line 1607 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (machineLocalityChanged)
															#line 6910 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1609 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				Reference<TCMachineInfo> machine = server->machine;
															#line 1610 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ASSERT_GE(machine->serversOnMachine.size(), 1);
															#line 1611 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (machine->serversOnMachine.size() == 1)
															#line 6918 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1614 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->removeMachine(machine);
															#line 1615 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					server->machine = Reference<TCMachineInfo>();
															#line 6924 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1619 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					int serverIndex = -1;
															#line 1620 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					for(int i = 0;i < machine->serversOnMachine.size();++i) {
															#line 1621 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (machine->serversOnMachine[i].getPtr() == server)
															#line 6934 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 1624 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							serverIndex = i;
															#line 1625 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							machine->serversOnMachine[i] = machine->serversOnMachine.back();
															#line 1626 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							machine->serversOnMachine.pop_back();
															#line 6942 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							break;
						}
					}
															#line 1630 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ASSERT(serverIndex != -1);
															#line 6948 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1638 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				Reference<TCMachineInfo> destMachine = self->checkAndCreateMachine(self->server_info[server->getId()]);
															#line 1640 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ASSERT(destMachine.isValid());
															#line 6954 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1645 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			std::vector<Reference<TCTeamInfo>> newBadTeams;
															#line 1646 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( auto& serverTeam : server->getTeams() ) {
															#line 1647 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!self->satisfiesPolicy(serverTeam->getServers()))
															#line 6962 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1648 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					newBadTeams.push_back(serverTeam);
															#line 6966 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					continue;
				}
															#line 1651 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (machineLocalityChanged)
															#line 6971 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1652 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					Reference<TCMachineTeamInfo> machineTeam = self->checkAndCreateMachineTeam(serverTeam);
															#line 1654 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ASSERT(machineTeam.isValid());
															#line 1655 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					serverTeam->machineTeam = machineTeam;
															#line 6979 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 1659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			server->updateInDesiredDC(self->includedDCs);
															#line 1660 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->resetLocalitySet();
															#line 1662 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bool addedNewBadTeam = false;
															#line 1663 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( auto it : newBadTeams ) {
															#line 1664 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (self->removeTeam(it))
															#line 6992 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1665 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->addTeam(it->getServers(), IsInitialTeam::True);
															#line 1666 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					addedNewBadTeam = true;
															#line 6998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 1669 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (addedNewBadTeam && self->badTeamRemover.isReady())
															#line 7003 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1672 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				CODE_PROBE(true, "Server locality change created bad teams", probe::decoration::rare);
															#line 1673 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->doBuildTeams = true;
															#line 1674 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->badTeamRemover = removeBadTeams(self);
															#line 1675 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->addActor.send(self->badTeamRemover);
															#line 1678 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				recordTeamCollectionInfo = true;
															#line 7015 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1682 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->doBuildTeams = true;
															#line 7019 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1685 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		interfaceChanged = server->onInterfaceChanged;
															#line 1688 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		status = ServerStatus(status.isFailed, status.isUndesired, status.isWiggling, server->getLastKnownInterface().locality);
															#line 1694 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		recordTeamCollectionInfo = true;
															#line 1697 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		storageMetadataTracker = self->updateStorageMetadata(server);
															#line 1698 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		hasWrongDC = !self->isCorrectDC(*server);
															#line 1699 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		hasInvalidLocality = !self->isValidLocality(self->configuration.storagePolicy, server->getLastKnownInterface().locality);
															#line 1701 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->restartTeamBuilder.trigger();
															#line 1703 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (restartRecruiting)
															#line 7037 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1704 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->restartRecruiting.trigger();
															#line 7041 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(std::pair<StorageServerInterface, ProcessClass> && newInterface,int loopDepth) 
	{
															#line 1588 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		auto const& lastKnownInterface = server->getLastKnownInterface();
															#line 1589 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool restartRecruiting = newInterface.first.waitFailure.getEndpoint().getPrimaryAddress() != lastKnownInterface.waitFailure.getEndpoint().getPrimaryAddress();
															#line 1591 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool localityChanged = lastKnownInterface.locality != newInterface.first.locality;
															#line 1592 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool machineLocalityChanged = lastKnownInterface.locality.zoneId().get() != newInterface.first.locality.zoneId().get();
															#line 1594 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("StorageServerInterfaceChanged", self->distributorId) .detail("ServerID", server->getId()) .detail("NewWaitFailureToken", newInterface.first.waitFailure.getEndpoint().token) .detail("OldWaitFailureToken", lastKnownInterface.waitFailure.getEndpoint().token) .detail("LocalityChanged", localityChanged) .detail("MachineLocalityChanged", machineLocalityChanged);
															#line 1601 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		server->updateLastKnown(newInterface.first, newInterface.second);
															#line 1602 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (localityChanged && !isTss)
															#line 7063 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1603 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			CODE_PROBE(true, "Server locality changed");
															#line 1607 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (machineLocalityChanged)
															#line 7069 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1609 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				Reference<TCMachineInfo> machine = server->machine;
															#line 1610 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ASSERT_GE(machine->serversOnMachine.size(), 1);
															#line 1611 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (machine->serversOnMachine.size() == 1)
															#line 7077 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1614 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->removeMachine(machine);
															#line 1615 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					server->machine = Reference<TCMachineInfo>();
															#line 7083 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1619 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					int serverIndex = -1;
															#line 1620 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					for(int i = 0;i < machine->serversOnMachine.size();++i) {
															#line 1621 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						if (machine->serversOnMachine[i].getPtr() == server)
															#line 7093 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
						{
															#line 1624 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							serverIndex = i;
															#line 1625 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							machine->serversOnMachine[i] = machine->serversOnMachine.back();
															#line 1626 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
							machine->serversOnMachine.pop_back();
															#line 7101 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
							break;
						}
					}
															#line 1630 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ASSERT(serverIndex != -1);
															#line 7107 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1638 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				Reference<TCMachineInfo> destMachine = self->checkAndCreateMachine(self->server_info[server->getId()]);
															#line 1640 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ASSERT(destMachine.isValid());
															#line 7113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1645 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			std::vector<Reference<TCTeamInfo>> newBadTeams;
															#line 1646 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( auto& serverTeam : server->getTeams() ) {
															#line 1647 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!self->satisfiesPolicy(serverTeam->getServers()))
															#line 7121 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1648 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					newBadTeams.push_back(serverTeam);
															#line 7125 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					continue;
				}
															#line 1651 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (machineLocalityChanged)
															#line 7130 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1652 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					Reference<TCMachineTeamInfo> machineTeam = self->checkAndCreateMachineTeam(serverTeam);
															#line 1654 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					ASSERT(machineTeam.isValid());
															#line 1655 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					serverTeam->machineTeam = machineTeam;
															#line 7138 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 1659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			server->updateInDesiredDC(self->includedDCs);
															#line 1660 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->resetLocalitySet();
															#line 1662 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bool addedNewBadTeam = false;
															#line 1663 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( auto it : newBadTeams ) {
															#line 1664 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (self->removeTeam(it))
															#line 7151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1665 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->addTeam(it->getServers(), IsInitialTeam::True);
															#line 1666 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					addedNewBadTeam = true;
															#line 7157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
															#line 1669 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (addedNewBadTeam && self->badTeamRemover.isReady())
															#line 7162 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1672 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				CODE_PROBE(true, "Server locality change created bad teams", probe::decoration::rare);
															#line 1673 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->doBuildTeams = true;
															#line 1674 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->badTeamRemover = removeBadTeams(self);
															#line 1675 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->addActor.send(self->badTeamRemover);
															#line 1678 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				recordTeamCollectionInfo = true;
															#line 7174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1682 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->doBuildTeams = true;
															#line 7178 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1685 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		interfaceChanged = server->onInterfaceChanged;
															#line 1688 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		status = ServerStatus(status.isFailed, status.isUndesired, status.isWiggling, server->getLastKnownInterface().locality);
															#line 1694 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		recordTeamCollectionInfo = true;
															#line 1697 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		storageMetadataTracker = self->updateStorageMetadata(server);
															#line 1698 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		hasWrongDC = !self->isCorrectDC(*server);
															#line 1699 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		hasInvalidLocality = !self->isValidLocality(self->configuration.storagePolicy, server->getLastKnownInterface().locality);
															#line 1701 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->restartTeamBuilder.trigger();
															#line 1703 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (restartRecruiting)
															#line 7196 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1704 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->restartRecruiting.trigger();
															#line 7200 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
															#line 1707 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("SameAddressChangedStatus", self->distributorId).detail("ServerID", server->getId());
															#line 7210 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void && _,int loopDepth) 
	{
															#line 1707 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("SameAddressChangedStatus", self->distributorId).detail("ServerID", server->getId());
															#line 7219 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void const& _,int loopDepth) 
	{
															#line 1710 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("UndesiredStorageServerTriggered", self->distributorId) .detail("Server", server->getId()) .detail("StoreType", server->getStoreType()) .detail("ConfigStoreType", self->configuration.storageServerStoreType) .detail("WrongStoreTypeRemoved", server->wrongStoreTypeToRemove.get());
															#line 7228 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void && _,int loopDepth) 
	{
															#line 1710 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("UndesiredStorageServerTriggered", self->distributorId) .detail("Server", server->getId()) .detail("StoreType", server->getStoreType()) .detail("ConfigStoreType", self->configuration.storageServerStoreType) .detail("WrongStoreTypeRemoved", server->wrongStoreTypeToRemove.get());
															#line 7237 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when5(Void const& _,int loopDepth) 
	{
															#line 1717 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		server->wakeUpTracker = Promise<Void>();
															#line 7246 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when5(Void && _,int loopDepth) 
	{
															#line 1717 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		server->wakeUpTracker = Promise<Void>();
															#line 7255 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when9(Void const& _,int loopDepth) 
	{
															#line 1723 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int64_t threshold = calculateTeamStorageQueueThreshold(self->teams);
															#line 1726 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (server->longStorageQueue.get() < threshold)
															#line 7302 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1727 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevInfo, "TriggerStorageQueueRebalanceIgnored", self->distributorId) .detail("SSID", server->getId());
															#line 7306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1730 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevInfo, "TriggerStorageQueueRebalance", self->distributorId) .detail("SSID", server->getId());
															#line 1732 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			std::vector<ShardsAffectedByTeamFailure::Team> teams;
															#line 1733 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( const auto& team : server->getTeams() ) {
															#line 1734 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				std::vector<UID> servers;
															#line 1735 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for( const auto& server : team->getServers() ) {
															#line 1736 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					servers.push_back(server->getId());
															#line 7322 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1738 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				teams.push_back(ShardsAffectedByTeamFailure::Team(servers, self->primary));
															#line 7326 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1740 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->triggerStorageQueueRebalance.send( RebalanceStorageQueueRequest(server->getId(), teams, self->primary));
															#line 7330 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when9(Void && _,int loopDepth) 
	{
															#line 1723 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int64_t threshold = calculateTeamStorageQueueThreshold(self->teams);
															#line 1726 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (server->longStorageQueue.get() < threshold)
															#line 7342 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1727 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevInfo, "TriggerStorageQueueRebalanceIgnored", self->distributorId) .detail("SSID", server->getId());
															#line 7346 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1730 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevInfo, "TriggerStorageQueueRebalance", self->distributorId) .detail("SSID", server->getId());
															#line 1732 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			std::vector<ShardsAffectedByTeamFailure::Team> teams;
															#line 1733 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for( const auto& team : server->getTeams() ) {
															#line 1734 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				std::vector<UID> servers;
															#line 1735 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for( const auto& server : team->getServers() ) {
															#line 1736 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					servers.push_back(server->getId());
															#line 7362 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1738 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				teams.push_back(ShardsAffectedByTeamFailure::Team(servers, self->primary));
															#line 7366 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 1740 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->triggerStorageQueueRebalance.send( RebalanceStorageQueueRequest(server->getId(), teams, self->primary));
															#line 7370 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state > 0) static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 2, Void >::remove();
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 3, std::pair<StorageServerInterface, ProcessClass> >::remove();
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 4, Void >::remove();
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 5, Void >::remove();
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 6, Void >::remove();
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 7, Void >::remove();
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 8, Void >::remove();
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 9, Void >::remove();
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 10, Void >::remove();

	}
	int a_body1loopBody1cont1when1cont1(Void const& _,int loopDepth) 
	{
															#line 1574 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("StatusMapChange", self->distributorId) .detail("ServerID", server->getId()) .detail("Status", "Removed");
															#line 1579 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		server->removed.send(Void());
															#line 1580 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (isTss)
															#line 7398 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1581 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->removedTSS.send(server->getId());
															#line 7402 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1583 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->removedServers.send(server->getId());
															#line 7408 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1585 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<StorageServerTrackerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerTrackerActorState(); static_cast<StorageServerTrackerActor*>(this)->destroy(); return 0; }
															#line 7412 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<StorageServerTrackerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StorageServerTrackerActorState();
		static_cast<StorageServerTrackerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1cont1(Void && _,int loopDepth) 
	{
															#line 1574 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("StatusMapChange", self->distributorId) .detail("ServerID", server->getId()) .detail("Status", "Removed");
															#line 1579 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		server->removed.send(Void());
															#line 1580 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (isTss)
															#line 7428 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1581 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->removedTSS.send(server->getId());
															#line 7432 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1583 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->removedServers.send(server->getId());
															#line 7438 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1585 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<StorageServerTrackerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerTrackerActorState(); static_cast<StorageServerTrackerActor*>(this)->destroy(); return 0; }
															#line 7442 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<StorageServerTrackerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StorageServerTrackerActorState();
		static_cast<StorageServerTrackerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state > 0) static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 3, std::pair<StorageServerInterface, ProcessClass> >*,std::pair<StorageServerInterface, ProcessClass> const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 3, std::pair<StorageServerInterface, ProcessClass> >*,std::pair<StorageServerInterface, ProcessClass> && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 3, std::pair<StorageServerInterface, ProcessClass> >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 1761 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 8042 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1Catch2cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StorageServerTrackerActor*>(this)->actor_wait_state > 0) static_cast<StorageServerTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerTrackerActor*>(this)->ActorCallback< StorageServerTrackerActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< StorageServerTrackerActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< StorageServerTrackerActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	TCServerInfo* server;
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Promise<Void> errorOut;
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Version addedVersion;
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	const DDEnabledState* ddEnabledState;
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool isTss;
															#line 1363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> failureTracker;
															#line 1364 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ServerStatus status;
															#line 1365 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool lastIsUnhealthy;
															#line 1366 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> metricsTracker;
															#line 1368 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<std::pair<StorageServerInterface, ProcessClass>> interfaceChanged;
															#line 1369 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool hasWrongDC;
															#line 1370 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool hasInvalidLocality;
															#line 1372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int targetTeamNumPerServer;
															#line 1374 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> storageMetadataTracker;
															#line 1387 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<Future<Void>> otherChanges;
															#line 1557 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool recordTeamCollectionInfo;
															#line 1751 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Error err;
															#line 8169 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via storageServerTracker()
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class StorageServerTrackerActor final : public Actor<Void>, public ActorCallback< StorageServerTrackerActor, 0, Void >, public ActorCallback< StorageServerTrackerActor, 1, Void >, public ActorCallback< StorageServerTrackerActor, 2, Void >, public ActorCallback< StorageServerTrackerActor, 11, Void >, public ActorCallback< StorageServerTrackerActor, 3, std::pair<StorageServerInterface, ProcessClass> >, public ActorCallback< StorageServerTrackerActor, 4, Void >, public ActorCallback< StorageServerTrackerActor, 5, Void >, public ActorCallback< StorageServerTrackerActor, 6, Void >, public ActorCallback< StorageServerTrackerActor, 7, Void >, public ActorCallback< StorageServerTrackerActor, 8, Void >, public ActorCallback< StorageServerTrackerActor, 9, Void >, public ActorCallback< StorageServerTrackerActor, 10, Void >, public ActorCallback< StorageServerTrackerActor, 12, Void >, public FastAllocated<StorageServerTrackerActor>, public StorageServerTrackerActorState<StorageServerTrackerActor> {
															#line 8174 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<StorageServerTrackerActor>::operator new;
	using FastAllocated<StorageServerTrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10795523283453960448UL, 4821804422182419200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageServerTrackerActor, 0, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 1, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 2, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 11, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 3, std::pair<StorageServerInterface, ProcessClass> >;
friend struct ActorCallback< StorageServerTrackerActor, 4, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 5, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 6, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 7, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 8, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 9, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 10, Void >;
friend struct ActorCallback< StorageServerTrackerActor, 12, Void >;
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	StorageServerTrackerActor(DDTeamCollection* const& self,TCServerInfo* const& server,Promise<Void> const& errorOut,Version const& addedVersion,const DDEnabledState* const& ddEnabledState,bool const& isTss) 
															#line 8203 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StorageServerTrackerActorState<StorageServerTrackerActor>(self, server, errorOut, addedVersion, ddEnabledState, isTss),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageServerTracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14083169789508288256UL, 12082945592317255168UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageServerTracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageServerTracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageServerTrackerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StorageServerTrackerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StorageServerTrackerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StorageServerTrackerActor, 11, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StorageServerTrackerActor, 12, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> storageServerTracker( DDTeamCollection* const& self, TCServerInfo* const& server, Promise<Void> const& errorOut, Version const& addedVersion, const DDEnabledState* const& ddEnabledState, bool const& isTss ) {
															#line 1356 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new StorageServerTrackerActor(self, server, errorOut, addedVersion, ddEnabledState, isTss));
															#line 8239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 1764 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 8244 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via removeWrongStoreType()
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class RemoveWrongStoreTypeActor>
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class RemoveWrongStoreTypeActorState {
															#line 8250 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	RemoveWrongStoreTypeActorState(DDTeamCollection* const& self) 
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self)
															#line 8257 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("removeWrongStoreType", reinterpret_cast<unsigned long>(this));

	}
	~RemoveWrongStoreTypeActorState() 
	{
		fdb_probe_actor_destroy("removeWrongStoreType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1767 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->DD_REMOVE_STORE_ENGINE_DELAY);
															#line 1767 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<RemoveWrongStoreTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8274 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RemoveWrongStoreTypeActor*>(this)->actor_wait_state = 1;
															#line 1767 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveWrongStoreTypeActor, 0, Void >*>(static_cast<RemoveWrongStoreTypeActor*>(this)));
															#line 8279 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveWrongStoreTypeActorState();
		static_cast<RemoveWrongStoreTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1769 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		fisServerRemoved = Never();
															#line 1771 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("WrongStoreTypeRemoverStart", self->distributorId).detail("Servers", self->server_info.size());
															#line 1772 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 8306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1769 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		fisServerRemoved = Never();
															#line 1771 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("WrongStoreTypeRemoverStart", self->distributorId).detail("Servers", self->server_info.size());
															#line 1772 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 8319 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveWrongStoreTypeActor*>(this)->actor_wait_state > 0) static_cast<RemoveWrongStoreTypeActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveWrongStoreTypeActor*>(this)->ActorCallback< RemoveWrongStoreTypeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveWrongStoreTypeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveWrongStoreTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveWrongStoreTypeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveWrongStoreTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveWrongStoreTypeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveWrongStoreTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1812 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<RemoveWrongStoreTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveWrongStoreTypeActorState(); static_cast<RemoveWrongStoreTypeActor*>(this)->destroy(); return 0; }
															#line 8403 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<RemoveWrongStoreTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveWrongStoreTypeActorState();
		static_cast<RemoveWrongStoreTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1776 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->waitUntilHealthy();
															#line 1776 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<RemoveWrongStoreTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8424 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RemoveWrongStoreTypeActor*>(this)->actor_wait_state = 2;
															#line 1776 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoveWrongStoreTypeActor, 1, Void >*>(static_cast<RemoveWrongStoreTypeActor*>(this)));
															#line 8429 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1778 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool foundSSToRemove = false;
															#line 1780 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto& server : self->server_info ) {
															#line 1783 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!(server.second->isCorrectStoreType(self->configuration.storageServerStoreType) || server.second->isCorrectStoreType(self->configuration.perpetualStoreType)) && !server.second->wrongStoreTypeToRemove.get())
															#line 8455 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1789 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (self->configuration.storageMigrationType == StorageMigrationType::AGGRESSIVE)
															#line 8459 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1791 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					server.second->wrongStoreTypeToRemove.set(true);
															#line 8463 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1794 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				foundSSToRemove = true;
															#line 1795 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("WrongStoreTypeRemover", self->distributorId) .detail("Server", server.first) .detail("StoreType", server.second->getStoreType()) .detail("ConfiguredStoreType", self->configuration.storageServerStoreType) .detail("RemovingNow", self->configuration.storageMigrationType == StorageMigrationType::AGGRESSIVE);
															#line 8469 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 1807 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!foundSSToRemove || self->configuration.storageMigrationType != StorageMigrationType::AGGRESSIVE)
															#line 8474 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1778 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool foundSSToRemove = false;
															#line 1780 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto& server : self->server_info ) {
															#line 1783 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!(server.second->isCorrectStoreType(self->configuration.storageServerStoreType) || server.second->isCorrectStoreType(self->configuration.perpetualStoreType)) && !server.second->wrongStoreTypeToRemove.get())
															#line 8490 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1789 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (self->configuration.storageMigrationType == StorageMigrationType::AGGRESSIVE)
															#line 8494 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1791 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					server.second->wrongStoreTypeToRemove.set(true);
															#line 8498 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1794 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				foundSSToRemove = true;
															#line 1795 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("WrongStoreTypeRemover", self->distributorId) .detail("Server", server.first) .detail("StoreType", server.second->getStoreType()) .detail("ConfiguredStoreType", self->configuration.storageServerStoreType) .detail("RemovingNow", self->configuration.storageMigrationType == StorageMigrationType::AGGRESSIVE);
															#line 8504 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 1807 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!foundSSToRemove || self->configuration.storageMigrationType != StorageMigrationType::AGGRESSIVE)
															#line 8509 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RemoveWrongStoreTypeActor*>(this)->actor_wait_state > 0) static_cast<RemoveWrongStoreTypeActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveWrongStoreTypeActor*>(this)->ActorCallback< RemoveWrongStoreTypeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveWrongStoreTypeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveWrongStoreTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RemoveWrongStoreTypeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveWrongStoreTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RemoveWrongStoreTypeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveWrongStoreTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeWrongStoreType", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 1769 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> fisServerRemoved;
															#line 8596 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via removeWrongStoreType()
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class RemoveWrongStoreTypeActor final : public Actor<Void>, public ActorCallback< RemoveWrongStoreTypeActor, 0, Void >, public ActorCallback< RemoveWrongStoreTypeActor, 1, Void >, public FastAllocated<RemoveWrongStoreTypeActor>, public RemoveWrongStoreTypeActorState<RemoveWrongStoreTypeActor> {
															#line 8601 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<RemoveWrongStoreTypeActor>::operator new;
	using FastAllocated<RemoveWrongStoreTypeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17867069091056276480UL, 2190174470198614272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveWrongStoreTypeActor, 0, Void >;
friend struct ActorCallback< RemoveWrongStoreTypeActor, 1, Void >;
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	RemoveWrongStoreTypeActor(DDTeamCollection* const& self) 
															#line 8619 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RemoveWrongStoreTypeActorState<RemoveWrongStoreTypeActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeWrongStoreType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16981108997096476928UL, 3202902181171184640UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveWrongStoreTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeWrongStoreType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeWrongStoreType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveWrongStoreTypeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RemoveWrongStoreTypeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> removeWrongStoreType( DDTeamCollection* const& self ) {
															#line 1765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new RemoveWrongStoreTypeActor(self));
															#line 8652 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 1814 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

	// NOTE: this actor returns when the cluster is healthy and stable (no server is expected to be removed in a period)
	// processingWiggle and processingUnhealthy indicate that some servers are going to be removed.
																#line 8659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via waitUntilHealthy()
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class WaitUntilHealthyActor>
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class WaitUntilHealthyActorState {
															#line 8665 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	WaitUntilHealthyActorState(DDTeamCollection const* const& self,double const& extraDelay,WaitWiggle const& waitWiggle) 
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   extraDelay(extraDelay),
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   waitWiggle(waitWiggle),
															#line 1818 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   waitCount(0)
															#line 8678 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitUntilHealthy", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilHealthyActorState() 
	{
		fdb_probe_actor_destroy("waitUntilHealthy", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1819 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 8693 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilHealthyActorState();
		static_cast<WaitUntilHealthyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1820 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 8723 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1833 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->DD_STALL_CHECK_DELAY, TaskPriority::Low);
															#line 1833 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8734 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state = 2;
															#line 1833 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilHealthyActor, 1, Void >*>(static_cast<WaitUntilHealthyActor*>(this)));
															#line 8739 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1820 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!(self->zeroHealthyTeams->get() || self->processingUnhealthy->get() || (waitWiggle && self->processingWiggle->get())))
															#line 8755 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1824 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("WaitUntilHealthyStalled", self->distributorId) .detail("Primary", self->primary) .detail("ZeroHealthy", self->zeroHealthyTeams->get()) .detail("ProcessingUnhealthy", self->processingUnhealthy->get()) .detail("ProcessingPerpetualWiggle", self->processingWiggle->get());
															#line 1829 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->zeroHealthyTeams->onChange() || self->processingUnhealthy->onChange() || self->processingWiggle->onChange();
															#line 1829 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8765 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state = 1;
															#line 1829 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilHealthyActor, 0, Void >*>(static_cast<WaitUntilHealthyActor*>(this)));
															#line 8770 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1831 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		waitCount = 0;
															#line 8792 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1831 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		waitCount = 0;
															#line 8801 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilHealthyActor*>(this)->ActorCallback< WaitUntilHealthyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilHealthyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilHealthyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilHealthyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1837 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->zeroHealthyTeams->get() && !self->processingUnhealthy->get() && (!waitWiggle || !self->processingWiggle->get()))
															#line 8885 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1839 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (extraDelay <= 0.01 || waitCount >= 1)
															#line 8889 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1842 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!static_cast<WaitUntilHealthyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitUntilHealthyActorState(); static_cast<WaitUntilHealthyActor*>(this)->destroy(); return 0; }
															#line 8893 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				new (&static_cast<WaitUntilHealthyActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitUntilHealthyActorState();
				static_cast<WaitUntilHealthyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1844 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(extraDelay, TaskPriority::Low);
															#line 1844 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8905 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state = 3;
															#line 1844 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilHealthyActor, 2, Void >*>(static_cast<WaitUntilHealthyActor*>(this)));
															#line 8910 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1837 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->zeroHealthyTeams->get() && !self->processingUnhealthy->get() && (!waitWiggle || !self->processingWiggle->get()))
															#line 8925 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1839 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (extraDelay <= 0.01 || waitCount >= 1)
															#line 8929 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1842 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!static_cast<WaitUntilHealthyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitUntilHealthyActorState(); static_cast<WaitUntilHealthyActor*>(this)->destroy(); return 0; }
															#line 8933 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				new (&static_cast<WaitUntilHealthyActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WaitUntilHealthyActorState();
				static_cast<WaitUntilHealthyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1844 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(extraDelay, TaskPriority::Low);
															#line 1844 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8945 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state = 3;
															#line 1844 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilHealthyActor, 2, Void >*>(static_cast<WaitUntilHealthyActor*>(this)));
															#line 8950 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilHealthyActor*>(this)->ActorCallback< WaitUntilHealthyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilHealthyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilHealthyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilHealthyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1845 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		waitCount++;
															#line 9052 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1845 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		waitCount++;
															#line 9061 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilHealthyActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilHealthyActor*>(this)->ActorCallback< WaitUntilHealthyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilHealthyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitUntilHealthyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitUntilHealthyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection const* self;
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	double extraDelay;
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	WaitWiggle waitWiggle;
															#line 1818 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int waitCount;
															#line 9149 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitUntilHealthy()
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class WaitUntilHealthyActor final : public Actor<Void>, public ActorCallback< WaitUntilHealthyActor, 0, Void >, public ActorCallback< WaitUntilHealthyActor, 1, Void >, public ActorCallback< WaitUntilHealthyActor, 2, Void >, public FastAllocated<WaitUntilHealthyActor>, public WaitUntilHealthyActorState<WaitUntilHealthyActor> {
															#line 9154 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitUntilHealthyActor>::operator new;
	using FastAllocated<WaitUntilHealthyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6954959468086083072UL, 13775744406110261760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilHealthyActor, 0, Void >;
friend struct ActorCallback< WaitUntilHealthyActor, 1, Void >;
friend struct ActorCallback< WaitUntilHealthyActor, 2, Void >;
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	WaitUntilHealthyActor(DDTeamCollection const* const& self,double const& extraDelay,WaitWiggle const& waitWiggle) 
															#line 9173 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitUntilHealthyActorState<WaitUntilHealthyActor>(self, extraDelay, waitWiggle),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilHealthy", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11564919900425009920UL, 16402329109865050624UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilHealthyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilHealthy");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilHealthy", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilHealthyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilHealthyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitUntilHealthyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> waitUntilHealthy( DDTeamCollection const* const& self, double const& extraDelay, WaitWiggle const& waitWiggle ) {
															#line 1817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new WaitUntilHealthyActor(self, extraDelay, waitWiggle));
															#line 9207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 1850 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 9212 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via removeBadTeams()
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class RemoveBadTeamsActor>
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class RemoveBadTeamsActorState {
															#line 9218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	RemoveBadTeamsActorState(DDTeamCollection* const& self) 
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self)
															#line 9225 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("removeBadTeams", reinterpret_cast<unsigned long>(this));

	}
	~RemoveBadTeamsActorState() 
	{
		fdb_probe_actor_destroy("removeBadTeams", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1852 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->initialFailureReactionDelay;
															#line 1852 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9242 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state = 1;
															#line 1852 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveBadTeamsActor, 0, Void >*>(static_cast<RemoveBadTeamsActor*>(this)));
															#line 9247 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveBadTeamsActorState();
		static_cast<RemoveBadTeamsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1853 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->waitUntilHealthy();
															#line 1853 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9272 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state = 2;
															#line 1853 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoveBadTeamsActor, 1, Void >*>(static_cast<RemoveBadTeamsActor*>(this)));
															#line 9277 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1853 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->waitUntilHealthy();
															#line 1853 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9288 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state = 2;
															#line 1853 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoveBadTeamsActor, 1, Void >*>(static_cast<RemoveBadTeamsActor*>(this)));
															#line 9293 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state > 0) static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveBadTeamsActor*>(this)->ActorCallback< RemoveBadTeamsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveBadTeamsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveBadTeamsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveBadTeamsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1854 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->addSubsetComplete.getFuture();
															#line 1854 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9379 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state = 3;
															#line 1854 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RemoveBadTeamsActor, 2, Void >*>(static_cast<RemoveBadTeamsActor*>(this)));
															#line 9384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1854 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->addSubsetComplete.getFuture();
															#line 1854 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9395 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state = 3;
															#line 1854 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RemoveBadTeamsActor, 2, Void >*>(static_cast<RemoveBadTeamsActor*>(this)));
															#line 9400 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state > 0) static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveBadTeamsActor*>(this)->ActorCallback< RemoveBadTeamsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveBadTeamsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RemoveBadTeamsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RemoveBadTeamsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1855 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("DDRemovingBadServerTeams", self->distributorId).detail("Primary", self->primary);
															#line 1856 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto it : self->badTeams ) {
															#line 1857 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			it->tracker.cancel();
															#line 9488 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1859 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->badTeams.clear();
															#line 1860 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<RemoveBadTeamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveBadTeamsActorState(); static_cast<RemoveBadTeamsActor*>(this)->destroy(); return 0; }
															#line 9494 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<RemoveBadTeamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveBadTeamsActorState();
		static_cast<RemoveBadTeamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1855 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("DDRemovingBadServerTeams", self->distributorId).detail("Primary", self->primary);
															#line 1856 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto it : self->badTeams ) {
															#line 1857 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			it->tracker.cancel();
															#line 9510 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1859 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->badTeams.clear();
															#line 1860 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<RemoveBadTeamsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveBadTeamsActorState(); static_cast<RemoveBadTeamsActor*>(this)->destroy(); return 0; }
															#line 9516 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<RemoveBadTeamsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveBadTeamsActorState();
		static_cast<RemoveBadTeamsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state > 0) static_cast<RemoveBadTeamsActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveBadTeamsActor*>(this)->ActorCallback< RemoveBadTeamsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveBadTeamsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RemoveBadTeamsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RemoveBadTeamsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 9601 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via removeBadTeams()
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class RemoveBadTeamsActor final : public Actor<Void>, public ActorCallback< RemoveBadTeamsActor, 0, Void >, public ActorCallback< RemoveBadTeamsActor, 1, Void >, public ActorCallback< RemoveBadTeamsActor, 2, Void >, public FastAllocated<RemoveBadTeamsActor>, public RemoveBadTeamsActorState<RemoveBadTeamsActor> {
															#line 9606 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<RemoveBadTeamsActor>::operator new;
	using FastAllocated<RemoveBadTeamsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5535031393090047744UL, 11296885836559253248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveBadTeamsActor, 0, Void >;
friend struct ActorCallback< RemoveBadTeamsActor, 1, Void >;
friend struct ActorCallback< RemoveBadTeamsActor, 2, Void >;
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	RemoveBadTeamsActor(DDTeamCollection* const& self) 
															#line 9625 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RemoveBadTeamsActorState<RemoveBadTeamsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeBadTeams", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2015241711745658624UL, 3639192233712149760UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveBadTeamsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeBadTeams");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeBadTeams", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveBadTeamsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RemoveBadTeamsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RemoveBadTeamsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> removeBadTeams( DDTeamCollection* const& self ) {
															#line 1851 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new RemoveBadTeamsActor(self));
															#line 9659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 1862 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 9664 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via zeroServerLeftLoggerActor()
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class ZeroServerLeftLoggerActorActor>
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class ZeroServerLeftLoggerActorActorState {
															#line 9670 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ZeroServerLeftLoggerActorActorState(DDTeamCollection* const& self,Reference<TCTeamInfo> const& team) 
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   team(team)
															#line 9679 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this));

	}
	~ZeroServerLeftLoggerActorActorState() 
	{
		fdb_probe_actor_destroy("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1864 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->DD_TEAM_ZERO_SERVER_LEFT_LOG_DELAY);
															#line 1864 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9696 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state = 1;
															#line 1864 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ZeroServerLeftLoggerActorActor, 0, Void >*>(static_cast<ZeroServerLeftLoggerActorActor*>(this)));
															#line 9701 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ZeroServerLeftLoggerActorActorState();
		static_cast<ZeroServerLeftLoggerActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1865 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		shards = self->shardsAffectedByTeamFailure->getShardsFor( ShardsAffectedByTeamFailure::Team(team->getServerIDs(), self->primary));
															#line 1867 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		sizes = std::vector<Future<StorageMetrics>>();
															#line 1868 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		sizes.reserve(shards.size());
															#line 1870 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto const& shard : shards ) {
															#line 1871 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			sizes.emplace_back(brokenPromiseToNever(self->getShardMetrics.getReply(GetMetricsRequest(shard))));
															#line 1872 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarnAlways, "DDShardLost", self->distributorId) .detail("ServerTeamID", team->getTeamID()) .detail("ShardBegin", shard.begin) .detail("ShardEnd", shard.end);
															#line 9734 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1878 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(sizes);
															#line 1878 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9740 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state = 2;
															#line 1878 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >*>(static_cast<ZeroServerLeftLoggerActorActor*>(this)));
															#line 9745 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1865 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		shards = self->shardsAffectedByTeamFailure->getShardsFor( ShardsAffectedByTeamFailure::Team(team->getServerIDs(), self->primary));
															#line 1867 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		sizes = std::vector<Future<StorageMetrics>>();
															#line 1868 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		sizes.reserve(shards.size());
															#line 1870 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto const& shard : shards ) {
															#line 1871 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			sizes.emplace_back(brokenPromiseToNever(self->getShardMetrics.getReply(GetMetricsRequest(shard))));
															#line 1872 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarnAlways, "DDShardLost", self->distributorId) .detail("ServerTeamID", team->getTeamID()) .detail("ShardBegin", shard.begin) .detail("ShardEnd", shard.end);
															#line 9764 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1878 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(sizes);
															#line 1878 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9770 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state = 2;
															#line 1878 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >*>(static_cast<ZeroServerLeftLoggerActorActor*>(this)));
															#line 9775 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state > 0) static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state = 0;
		static_cast<ZeroServerLeftLoggerActorActor*>(this)->ActorCallback< ZeroServerLeftLoggerActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZeroServerLeftLoggerActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroServerLeftLoggerActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ZeroServerLeftLoggerActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroServerLeftLoggerActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ZeroServerLeftLoggerActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroServerLeftLoggerActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1880 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int64_t bytesLost = 0;
															#line 1881 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto const& size : sizes ) {
															#line 1882 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bytesLost += size.get().bytes;
															#line 9863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1885 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent(SevWarnAlways, "DDZeroServerLeftInTeam", self->distributorId) .detail("Team", team->getDesc()) .detail("TotalBytesLost", bytesLost);
															#line 1889 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<ZeroServerLeftLoggerActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZeroServerLeftLoggerActorActorState(); static_cast<ZeroServerLeftLoggerActorActor*>(this)->destroy(); return 0; }
															#line 9869 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<ZeroServerLeftLoggerActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZeroServerLeftLoggerActorActorState();
		static_cast<ZeroServerLeftLoggerActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1880 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int64_t bytesLost = 0;
															#line 1881 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( auto const& size : sizes ) {
															#line 1882 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bytesLost += size.get().bytes;
															#line 9885 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1885 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent(SevWarnAlways, "DDZeroServerLeftInTeam", self->distributorId) .detail("Team", team->getDesc()) .detail("TotalBytesLost", bytesLost);
															#line 1889 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<ZeroServerLeftLoggerActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZeroServerLeftLoggerActorActorState(); static_cast<ZeroServerLeftLoggerActorActor*>(this)->destroy(); return 0; }
															#line 9891 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<ZeroServerLeftLoggerActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZeroServerLeftLoggerActorActorState();
		static_cast<ZeroServerLeftLoggerActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state > 0) static_cast<ZeroServerLeftLoggerActorActor*>(this)->actor_wait_state = 0;
		static_cast<ZeroServerLeftLoggerActorActor*>(this)->ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroServerLeftLoggerActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroServerLeftLoggerActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroServerLeftLoggerActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Reference<TCTeamInfo> team;
															#line 1865 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<KeyRange> shards;
															#line 1867 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	std::vector<Future<StorageMetrics>> sizes;
															#line 9982 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via zeroServerLeftLoggerActor()
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class ZeroServerLeftLoggerActorActor final : public Actor<Void>, public ActorCallback< ZeroServerLeftLoggerActorActor, 0, Void >, public ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >, public FastAllocated<ZeroServerLeftLoggerActorActor>, public ZeroServerLeftLoggerActorActorState<ZeroServerLeftLoggerActorActor> {
															#line 9987 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<ZeroServerLeftLoggerActorActor>::operator new;
	using FastAllocated<ZeroServerLeftLoggerActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7608448697793403648UL, 5192484171911179264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ZeroServerLeftLoggerActorActor, 0, Void >;
friend struct ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >;
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ZeroServerLeftLoggerActorActor(DDTeamCollection* const& self,Reference<TCTeamInfo> const& team) 
															#line 10005 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ZeroServerLeftLoggerActorActorState<ZeroServerLeftLoggerActorActor>(self, team),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4839474665937811200UL, 3262121190892970496UL);
		ActorExecutionContextHelper __helper(static_cast<ZeroServerLeftLoggerActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("zeroServerLeftLoggerActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("zeroServerLeftLoggerActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ZeroServerLeftLoggerActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ZeroServerLeftLoggerActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> zeroServerLeftLoggerActor( DDTeamCollection* const& self, Reference<TCTeamInfo> const& team ) {
															#line 1863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new ZeroServerLeftLoggerActorActor(self, team));
															#line 10038 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 1891 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 10043 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via storageServerFailureTracker()
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class StorageServerFailureTrackerActor>
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class StorageServerFailureTrackerActorState {
															#line 10049 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	StorageServerFailureTrackerActorState(DDTeamCollection* const& self,TCServerInfo* const& server,ServerStatus* const& status,Version const& addedVersion) 
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   server(server),
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   status(status),
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   addedVersion(addedVersion),
															#line 1896 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   interf(server->getLastKnownInterface())
															#line 10064 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("storageServerFailureTracker", reinterpret_cast<unsigned long>(this));

	}
	~StorageServerFailureTrackerActorState() 
	{
		fdb_probe_actor_destroy("storageServerFailureTracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1897 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 10079 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageServerFailureTrackerActorState();
		static_cast<StorageServerFailureTrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1995 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<StorageServerFailureTrackerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerFailureTrackerActorState(); static_cast<StorageServerFailureTrackerActor*>(this)->destroy(); return 0; }
															#line 10102 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<StorageServerFailureTrackerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StorageServerFailureTrackerActorState();
		static_cast<StorageServerFailureTrackerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1898 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		inHealthyZone = false;
															#line 1899 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (self->healthyZone.get().present())
															#line 10123 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1900 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (interf.locality.zoneId() == self->healthyZone.get())
															#line 10127 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1901 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				status->isFailed = false;
															#line 1902 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				inHealthyZone = true;
															#line 10133 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1903 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (self->healthyZone.get().get() == ignoreSSFailuresZoneString)
															#line 10139 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1905 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					status->isFailed = false;
															#line 1906 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					inHealthyZone = true;
															#line 1907 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("SSFailureTracker", self->distributorId) .suppressFor(1.0) .detail("IgnoredFailure", "BeforeChooseWhen") .detail("ServerID", interf.id()) .detail("Status", status->toString());
															#line 10147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1915 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!interf.isTss())
															#line 10153 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1916 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->server_status.get(interf.id()).initialized)
															#line 10157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1917 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bool unhealthy = self->server_status.get(interf.id()).isUnhealthy();
															#line 1918 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (unhealthy && !status->isUnhealthy())
															#line 10163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1919 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("StorageServerBecomeHealthy", self->distributorId) .detail("ServerID", interf.id()) .detail("ServerIpAddress", interf.address());
															#line 1922 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->unhealthyServers--;
															#line 10169 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
															#line 1924 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!unhealthy && status->isUnhealthy())
															#line 10173 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1925 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent(SevWarn, "StorageServerUnhealthy", self->distributorId) .detail("ServerID", interf.id()) .detail("ServerIpAddress", interf.address());
															#line 1928 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->unhealthyServers++;
															#line 10179 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 1930 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (status->isUnhealthy())
															#line 10186 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1931 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent(SevWarn, "StorageServerUnhealthy", self->distributorId) .detail("ServerID", interf.id()) .detail("ServerIpAddress", interf.address());
															#line 1934 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->unhealthyServers++;
															#line 10192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1938 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->server_status.set(interf.id(), *status);
															#line 1939 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (status->isFailed)
															#line 10200 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1940 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("RestartRecruiting", self->distributorId) .detail("FailedServerID", interf.id()) .detail("IsTSS", interf.isTss());
															#line 1943 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->restartRecruiting.trigger();
															#line 10206 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1946 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		Future<Void> healthChanged = Never();
															#line 1947 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (status->isFailed)
															#line 10212 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1948 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(!inHealthyZone);
															#line 1949 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			healthChanged = IFailureMonitor::failureMonitor().onStateEqual(interf.waitFailure.getEndpoint(), FailureStatus(false));
															#line 10218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 1951 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!inHealthyZone)
															#line 10224 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1952 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				healthChanged = waitFailureClientStrict(interf.waitFailure, SERVER_KNOBS->DATA_DISTRIBUTION_FAILURE_REACTION_TIME, TaskPriority::DataDistribution);
															#line 10228 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 1957 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = healthChanged;
															#line 1956 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<StorageServerFailureTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10235 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1988 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = status->isUnhealthy() ? self->waitForAllDataRemoved(interf.id(), addedVersion) : Never();
															#line 10239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 1991 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->healthyZone.onChange();
															#line 10243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<StorageServerFailureTrackerActor*>(this)->actor_wait_state = 1;
															#line 1957 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageServerFailureTrackerActor, 0, Void >*>(static_cast<StorageServerFailureTrackerActor*>(this)));
															#line 1988 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerFailureTrackerActor, 1, Void >*>(static_cast<StorageServerFailureTrackerActor*>(this)));
															#line 1991 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StorageServerFailureTrackerActor, 2, Void >*>(static_cast<StorageServerFailureTrackerActor*>(this)));
															#line 10252 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1958 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		status->isFailed = !status->isFailed;
															#line 1959 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (status->isFailed && self->healthyZone.get().present())
															#line 10282 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1960 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->healthyZone.get().get() == ignoreSSFailuresZoneString)
															#line 10286 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1962 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("SSFailureTracker", self->distributorId) .detail("IgnoredFailure", "InsideChooseWhen") .detail("ServerID", interf.id()) .detail("Status", status->toString());
															#line 1966 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				status->isFailed = false;
															#line 10292 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1967 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (SERVER_KNOBS->DD_REMOVE_MAINTENANCE_ON_FAILURE && self->clearHealthyZoneFuture.isReady())
															#line 10298 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1969 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->clearHealthyZoneFuture = clearHealthyZone(self->dbContext());
															#line 1970 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("MaintenanceZoneCleared", self->distributorId).log();
															#line 1971 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->healthyZone.set(Optional<Key>());
															#line 10306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1974 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!status->isUnhealthy())
															#line 10312 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1978 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->doBuildTeams = true;
															#line 10316 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1981 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent(SevDebug, "StatusMapChange", self->distributorId) .detail("ServerID", interf.id()) .detail("Status", status->toString()) .detail( "Available", IFailureMonitor::failureMonitor().getState(interf.waitFailure.getEndpoint()).isAvailable());
															#line 10320 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1958 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		status->isFailed = !status->isFailed;
															#line 1959 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (status->isFailed && self->healthyZone.get().present())
															#line 10331 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1960 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->healthyZone.get().get() == ignoreSSFailuresZoneString)
															#line 10335 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 1962 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("SSFailureTracker", self->distributorId) .detail("IgnoredFailure", "InsideChooseWhen") .detail("ServerID", interf.id()) .detail("Status", status->toString());
															#line 1966 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				status->isFailed = false;
															#line 10341 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1967 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (SERVER_KNOBS->DD_REMOVE_MAINTENANCE_ON_FAILURE && self->clearHealthyZoneFuture.isReady())
															#line 10347 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 1969 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->clearHealthyZoneFuture = clearHealthyZone(self->dbContext());
															#line 1970 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					TraceEvent("MaintenanceZoneCleared", self->distributorId).log();
															#line 1971 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->healthyZone.set(Optional<Key>());
															#line 10355 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1974 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!status->isUnhealthy())
															#line 10361 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 1978 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->doBuildTeams = true;
															#line 10365 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 1981 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent(SevDebug, "StatusMapChange", self->distributorId) .detail("ServerID", interf.id()) .detail("Status", status->toString()) .detail( "Available", IFailureMonitor::failureMonitor().getState(interf.waitFailure.getEndpoint()).isAvailable());
															#line 10369 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageServerFailureTrackerActor*>(this)->actor_wait_state > 0) static_cast<StorageServerFailureTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerFailureTrackerActor*>(this)->ActorCallback< StorageServerFailureTrackerActor, 0, Void >::remove();
		static_cast<StorageServerFailureTrackerActor*>(this)->ActorCallback< StorageServerFailureTrackerActor, 1, Void >::remove();
		static_cast<StorageServerFailureTrackerActor*>(this)->ActorCallback< StorageServerFailureTrackerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerFailureTrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageServerFailureTrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageServerFailureTrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageServerFailureTrackerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageServerFailureTrackerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StorageServerFailureTrackerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageServerFailureTrackerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StorageServerFailureTrackerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StorageServerFailureTrackerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	TCServerInfo* server;
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ServerStatus* status;
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Version addedVersion;
															#line 1896 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	StorageServerInterface interf;
															#line 1898 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool inHealthyZone;
															#line 10589 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via storageServerFailureTracker()
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class StorageServerFailureTrackerActor final : public Actor<Void>, public ActorCallback< StorageServerFailureTrackerActor, 0, Void >, public ActorCallback< StorageServerFailureTrackerActor, 1, Void >, public ActorCallback< StorageServerFailureTrackerActor, 2, Void >, public FastAllocated<StorageServerFailureTrackerActor>, public StorageServerFailureTrackerActorState<StorageServerFailureTrackerActor> {
															#line 10594 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<StorageServerFailureTrackerActor>::operator new;
	using FastAllocated<StorageServerFailureTrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12698278908852616448UL, 10218843878901261568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageServerFailureTrackerActor, 0, Void >;
friend struct ActorCallback< StorageServerFailureTrackerActor, 1, Void >;
friend struct ActorCallback< StorageServerFailureTrackerActor, 2, Void >;
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	StorageServerFailureTrackerActor(DDTeamCollection* const& self,TCServerInfo* const& server,ServerStatus* const& status,Version const& addedVersion) 
															#line 10613 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StorageServerFailureTrackerActorState<StorageServerFailureTrackerActor>(self, server, status, addedVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10582269401735443968UL, 10882155093196166144UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerFailureTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageServerFailureTracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageServerFailureTracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageServerFailureTrackerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> storageServerFailureTracker( DDTeamCollection* const& self, TCServerInfo* const& server, ServerStatus* const& status, Version const& addedVersion ) {
															#line 1892 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new StorageServerFailureTrackerActor(self, server, status, addedVersion));
															#line 10645 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 1997 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 10650 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via machineTeamRemover()
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class MachineTeamRemoverActor>
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class MachineTeamRemoverActorState {
															#line 10656 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	MachineTeamRemoverActorState(DDTeamCollection* const& self) 
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 1999 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   numMachineTeamRemoved(0)
															#line 10665 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("machineTeamRemover", reinterpret_cast<unsigned long>(this));

	}
	~MachineTeamRemoverActorState() 
	{
		fdb_probe_actor_destroy("machineTeamRemover", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2000 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 10680 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MachineTeamRemoverActorState();
		static_cast<MachineTeamRemoverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2002 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->TR_FLAG_DISABLE_MACHINE_TEAM_REMOVER)
															#line 10710 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2003 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!static_cast<MachineTeamRemoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MachineTeamRemoverActorState(); static_cast<MachineTeamRemoverActor*>(this)->destroy(); return 0; }
															#line 10714 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			new (&static_cast<MachineTeamRemoverActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MachineTeamRemoverActorState();
			static_cast<MachineTeamRemoverActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2007 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->TR_REMOVE_MACHINE_TEAM_DELAY, TaskPriority::DataDistribution);
															#line 2007 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10724 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 1;
															#line 2007 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MachineTeamRemoverActor, 0, Void >*>(static_cast<MachineTeamRemoverActor*>(this)));
															#line 10729 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->waitUntilHealthy(SERVER_KNOBS->TR_REMOVE_SERVER_TEAM_EXTRA_DELAY);
															#line 2009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10740 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 2;
															#line 2009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MachineTeamRemoverActor, 1, Void >*>(static_cast<MachineTeamRemoverActor*>(this)));
															#line 10745 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->waitUntilHealthy(SERVER_KNOBS->TR_REMOVE_SERVER_TEAM_EXTRA_DELAY);
															#line 2009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10756 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 2;
															#line 2009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MachineTeamRemoverActor, 1, Void >*>(static_cast<MachineTeamRemoverActor*>(this)));
															#line 10761 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<MachineTeamRemoverActor*>(this)->ActorCallback< MachineTeamRemoverActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineTeamRemoverActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MachineTeamRemoverActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MachineTeamRemoverActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2013 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->badTeamRemover;
															#line 2013 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10847 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 3;
															#line 2013 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MachineTeamRemoverActor, 2, Void >*>(static_cast<MachineTeamRemoverActor*>(this)));
															#line 10852 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2013 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->badTeamRemover;
															#line 2013 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10863 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 3;
															#line 2013 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MachineTeamRemoverActor, 2, Void >*>(static_cast<MachineTeamRemoverActor*>(this)));
															#line 10868 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<MachineTeamRemoverActor*>(this)->ActorCallback< MachineTeamRemoverActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineTeamRemoverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MachineTeamRemoverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MachineTeamRemoverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 2015 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->TR_LOW_SPACE_PIVOT_DELAY_SEC > 0 && self->teamPivots.pivotAvailableSpaceRatio < SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO)
															#line 10952 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2017 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "MachineTeamRemoverDelayedForLowSpacePivot", self->distributorId) .detail("IsPrimary", self->primary) .detail("CurrentSpacePivot", self->teamPivots.pivotAvailableSpaceRatio) .detail("TargetSpacePivot", SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO);
															#line 2021 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->TR_LOW_SPACE_PIVOT_DELAY_SEC);
															#line 2021 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10960 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 4;
															#line 2021 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MachineTeamRemoverActor, 3, Void >*>(static_cast<MachineTeamRemoverActor*>(this)));
															#line 10965 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 2015 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->TR_LOW_SPACE_PIVOT_DELAY_SEC > 0 && self->teamPivots.pivotAvailableSpaceRatio < SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO)
															#line 10979 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2017 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "MachineTeamRemoverDelayedForLowSpacePivot", self->distributorId) .detail("IsPrimary", self->primary) .detail("CurrentSpacePivot", self->teamPivots.pivotAvailableSpaceRatio) .detail("TargetSpacePivot", SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO);
															#line 2021 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->TR_LOW_SPACE_PIVOT_DELAY_SEC);
															#line 2021 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10987 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 4;
															#line 2021 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MachineTeamRemoverActor, 3, Void >*>(static_cast<MachineTeamRemoverActor*>(this)));
															#line 10992 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<MachineTeamRemoverActor*>(this)->ActorCallback< MachineTeamRemoverActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineTeamRemoverActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MachineTeamRemoverActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MachineTeamRemoverActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 2025 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		healthyMachineCount = self->calculateHealthyMachineCount();
															#line 2028 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (healthyMachineCount != self->machine_info.size())
															#line 11083 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 2033 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int desiredMachineTeams = SERVER_KNOBS->DESIRED_TEAMS_PER_SERVER * healthyMachineCount;
															#line 2034 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int totalMTCount = self->machineTeams.size();
															#line 2037 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		std::pair<Reference<TCMachineTeamInfo>, int> foundMTInfo = SERVER_KNOBS->TR_FLAG_REMOVE_MT_WITH_MOST_TEAMS ? self->getMachineTeamWithMostMachineTeams() : self->getMachineTeamWithLeastProcessTeams();
															#line 2041 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (totalMTCount > desiredMachineTeams && foundMTInfo.first.isValid())
															#line 11095 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2042 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			Reference<TCMachineTeamInfo> mt = foundMTInfo.first;
															#line 2043 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int minNumProcessTeams = foundMTInfo.second;
															#line 2044 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(mt.isValid());
															#line 2048 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			Reference<TCTeamInfo> team;
															#line 2049 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int teamIndex = 0;
															#line 2050 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			for(teamIndex = 0;teamIndex < mt->getServerTeams().size();++teamIndex) {
															#line 2051 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				team = mt->getServerTeams()[teamIndex];
															#line 2052 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ASSERT(team->machineTeam->getMachineIDs() == mt->getMachineIDs());
															#line 2055 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				for( auto& s : team->getServers() ) {
															#line 2056 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (s->getTeams().size() == 0)
															#line 11117 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					{
															#line 2057 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						TraceEvent(SevError, "MachineTeamRemoverTooAggressive", self->distributorId) .detail("Server", s->getId()) .detail("ServerTeam", team->getDesc());
															#line 2060 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
						self->traceAllInfo(true);
															#line 11123 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					}
				}
															#line 2065 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				bool foundTeam = self->removeTeam(team);
															#line 2066 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				ASSERT(foundTeam);
															#line 2069 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				--teamIndex;
															#line 2070 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->addTeam(team->getServers(), IsInitialTeam::True, IsRedundantTeam::True);
															#line 2071 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				CODE_PROBE(true, "Removed machine team");
															#line 11136 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 2074 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->doBuildTeams = true;
															#line 2076 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->badTeamRemover.isReady())
															#line 11142 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2077 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->badTeamRemover = removeBadTeams(self);
															#line 2078 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->addActor.send(self->badTeamRemover);
															#line 11148 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 2081 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("MachineTeamRemover", self->distributorId) .detail("MachineTeamIDToRemove", mt->id().shortString()) .detail("MachineTeamToRemove", mt->getMachineIDsStr()) .detail("NumProcessTeamsOnTheMachineTeam", minNumProcessTeams) .detail("CurrentMachineTeams", self->machineTeams.size()) .detail("DesiredMachineTeams", desiredMachineTeams);
															#line 2089 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bool foundRemovedMachineTeam = self->removeMachineTeam(mt);
															#line 2093 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(foundRemovedMachineTeam);
															#line 2094 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			numMachineTeamRemoved++;
															#line 11158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2096 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (numMachineTeamRemoved > 0)
															#line 11164 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2098 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("MachineTeamRemoverDone", self->distributorId) .detail("HealthyMachines", healthyMachineCount) .detail("CurrentMachineTeams", self->machineTeams.size()) .detail("DesiredMachineTeams", desiredMachineTeams) .detail("NumMachineTeamsRemoved", numMachineTeamRemoved);
															#line 2104 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->traceTeamCollectionInfo();
															#line 2105 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				numMachineTeamRemoved = 0;
															#line 11172 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<MachineTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<MachineTeamRemoverActor*>(this)->ActorCallback< MachineTeamRemoverActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MachineTeamRemoverActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MachineTeamRemoverActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MachineTeamRemoverActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 1999 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int numMachineTeamRemoved;
															#line 2025 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int healthyMachineCount;
															#line 11272 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via machineTeamRemover()
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class MachineTeamRemoverActor final : public Actor<Void>, public ActorCallback< MachineTeamRemoverActor, 0, Void >, public ActorCallback< MachineTeamRemoverActor, 1, Void >, public ActorCallback< MachineTeamRemoverActor, 2, Void >, public ActorCallback< MachineTeamRemoverActor, 3, Void >, public FastAllocated<MachineTeamRemoverActor>, public MachineTeamRemoverActorState<MachineTeamRemoverActor> {
															#line 11277 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<MachineTeamRemoverActor>::operator new;
	using FastAllocated<MachineTeamRemoverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6583840897595832064UL, 17422918490397493248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MachineTeamRemoverActor, 0, Void >;
friend struct ActorCallback< MachineTeamRemoverActor, 1, Void >;
friend struct ActorCallback< MachineTeamRemoverActor, 2, Void >;
friend struct ActorCallback< MachineTeamRemoverActor, 3, Void >;
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	MachineTeamRemoverActor(DDTeamCollection* const& self) 
															#line 11297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MachineTeamRemoverActorState<MachineTeamRemoverActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("machineTeamRemover", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14672550405997928704UL, 15602855616480260096UL);
		ActorExecutionContextHelper __helper(static_cast<MachineTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("machineTeamRemover");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("machineTeamRemover", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MachineTeamRemoverActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MachineTeamRemoverActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MachineTeamRemoverActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MachineTeamRemoverActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> machineTeamRemover( DDTeamCollection* const& self ) {
															#line 1998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new MachineTeamRemoverActor(self));
															#line 11332 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2110 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 11337 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via serverTeamRemover()
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class ServerTeamRemoverActor>
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class ServerTeamRemoverActorState {
															#line 11343 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ServerTeamRemoverActorState(DDTeamCollection* const& self) 
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 2112 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   numServerTeamRemoved(0)
															#line 11352 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("serverTeamRemover", reinterpret_cast<unsigned long>(this));

	}
	~ServerTeamRemoverActorState() 
	{
		fdb_probe_actor_destroy("serverTeamRemover", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2113 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 11367 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerTeamRemoverActorState();
		static_cast<ServerTeamRemoverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2115 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->TR_FLAG_DISABLE_SERVER_TEAM_REMOVER)
															#line 11397 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2116 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!static_cast<ServerTeamRemoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerTeamRemoverActorState(); static_cast<ServerTeamRemoverActor*>(this)->destroy(); return 0; }
															#line 11401 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			new (&static_cast<ServerTeamRemoverActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ServerTeamRemoverActorState();
			static_cast<ServerTeamRemoverActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2119 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		double removeServerTeamDelay = SERVER_KNOBS->TR_REMOVE_SERVER_TEAM_DELAY;
															#line 2120 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (g_network->isSimulated())
															#line 11411 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2123 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			removeServerTeamDelay = removeServerTeamDelay / 100;
															#line 11415 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2126 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(removeServerTeamDelay, TaskPriority::DataDistribution);
															#line 2126 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11421 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 1;
															#line 2126 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServerTeamRemoverActor, 0, Void >*>(static_cast<ServerTeamRemoverActor*>(this)));
															#line 11426 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2128 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->PERPETUAL_WIGGLE_DISABLE_REMOVER && self->pauseWiggle)
															#line 11435 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2129 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 11439 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
															#line 2133 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->waitUntilHealthy(SERVER_KNOBS->TR_REMOVE_SERVER_TEAM_EXTRA_DELAY);
															#line 2133 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11448 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 3;
															#line 2133 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServerTeamRemoverActor, 2, Void >*>(static_cast<ServerTeamRemoverActor*>(this)));
															#line 11453 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2128 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->PERPETUAL_WIGGLE_DISABLE_REMOVER && self->pauseWiggle)
															#line 11463 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2129 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 11467 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
															#line 2133 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->waitUntilHealthy(SERVER_KNOBS->TR_REMOVE_SERVER_TEAM_EXTRA_DELAY);
															#line 2133 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11476 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 3;
															#line 2133 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServerTeamRemoverActor, 2, Void >*>(static_cast<ServerTeamRemoverActor*>(this)));
															#line 11481 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<ServerTeamRemoverActor*>(this)->ActorCallback< ServerTeamRemoverActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServerTeamRemoverActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 2137 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->badTeamRemover;
															#line 2137 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11568 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 4;
															#line 2137 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ServerTeamRemoverActor, 3, Void >*>(static_cast<ServerTeamRemoverActor*>(this)));
															#line 11573 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2129 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!(!self->pauseWiggle->get()))
															#line 11595 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2130 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->pauseWiggle->onChange();
															#line 2130 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11603 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 2;
															#line 2130 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServerTeamRemoverActor, 1, Void >*>(static_cast<ServerTeamRemoverActor*>(this)));
															#line 11608 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<ServerTeamRemoverActor*>(this)->ActorCallback< ServerTeamRemoverActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServerTeamRemoverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<ServerTeamRemoverActor*>(this)->ActorCallback< ServerTeamRemoverActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ServerTeamRemoverActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 2139 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->TR_LOW_SPACE_PIVOT_DELAY_SEC > 0 && self->teamPivots.pivotAvailableSpaceRatio < SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO)
															#line 11804 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2141 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "ServerTeamRemoverDelayedForLowSpacePivot", self->distributorId) .detail("IsPrimary", self->primary) .detail("CurrentSpacePivot", self->teamPivots.pivotAvailableSpaceRatio) .detail("TargetSpacePivot", SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO);
															#line 2145 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->TR_LOW_SPACE_PIVOT_DELAY_SEC);
															#line 2145 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11812 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
			static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 5;
															#line 2145 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ServerTeamRemoverActor, 4, Void >*>(static_cast<ServerTeamRemoverActor*>(this)));
															#line 11817 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 2139 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->TR_LOW_SPACE_PIVOT_DELAY_SEC > 0 && self->teamPivots.pivotAvailableSpaceRatio < SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO)
															#line 11831 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2141 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(SevWarn, "ServerTeamRemoverDelayedForLowSpacePivot", self->distributorId) .detail("IsPrimary", self->primary) .detail("CurrentSpacePivot", self->teamPivots.pivotAvailableSpaceRatio) .detail("TargetSpacePivot", SERVER_KNOBS->TARGET_AVAILABLE_SPACE_RATIO);
															#line 2145 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->TR_LOW_SPACE_PIVOT_DELAY_SEC);
															#line 2145 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11839 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
			static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 5;
															#line 2145 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ServerTeamRemoverActor, 4, Void >*>(static_cast<ServerTeamRemoverActor*>(this)));
															#line 11844 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<ServerTeamRemoverActor*>(this)->ActorCallback< ServerTeamRemoverActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ServerTeamRemoverActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
															#line 2151 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int desiredServerTeams = SERVER_KNOBS->DESIRED_TEAMS_PER_SERVER * self->server_info.size();
															#line 2152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int totalSTCount = self->teams.size();
															#line 2154 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		std::pair<Reference<TCTeamInfo>, int> foundSTInfo = self->getServerTeamWithMostProcessTeams();
															#line 2156 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (totalSTCount > desiredServerTeams * (1 + SERVER_KNOBS->TR_REDUNDANT_TEAM_PERCENTAGE_THRESHOLD) && foundSTInfo.first.isValid())
															#line 11939 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(foundSTInfo.first.isValid());
															#line 2159 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			Reference<TCTeamInfo> st = foundSTInfo.first;
															#line 2160 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			int maxNumProcessTeams = foundSTInfo.second;
															#line 2161 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(st.isValid());
															#line 2163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			bool foundTeam = self->removeTeam(st);
															#line 2164 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(foundTeam);
															#line 2165 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->addTeam(st->getServers(), IsInitialTeam::True, IsRedundantTeam::True);
															#line 2166 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			CODE_PROBE(true, "Marked team as a bad team");
															#line 2168 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->doBuildTeams = true;
															#line 2170 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->badTeamRemover.isReady())
															#line 11961 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2171 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->badTeamRemover = removeBadTeams(self);
															#line 2172 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->addActor.send(self->badTeamRemover);
															#line 11967 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 2175 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("ServerTeamRemover", self->distributorId) .detail("ServerTeamToRemove", st->getServerIDsStr()) .detail("ServerTeamID", st->getTeamID()) .detail("NumProcessTeamsOnTheServerTeam", maxNumProcessTeams) .detail("CurrentServerTeams", totalSTCount) .detail("DesiredServerTeams", desiredServerTeams) .detail("Primary", self->primary);
															#line 2183 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			numServerTeamRemoved++;
															#line 11973 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2185 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (numServerTeamRemoved > 0)
															#line 11979 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent("ServerTeamRemoverDone", self->distributorId) .detail("CurrentServerTeams", self->teams.size()) .detail("DesiredServerTeams", desiredServerTeams) .detail("NumServerTeamRemoved", numServerTeamRemoved) .detail("Primary", self->primary);
															#line 2192 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->traceTeamCollectionInfo();
															#line 2193 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				numServerTeamRemoved = 0;
															#line 11987 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state > 0) static_cast<ServerTeamRemoverActor*>(this)->actor_wait_state = 0;
		static_cast<ServerTeamRemoverActor*>(this)->ActorCallback< ServerTeamRemoverActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ServerTeamRemoverActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ServerTeamRemoverActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 2112 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int numServerTeamRemoved;
															#line 12085 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via serverTeamRemover()
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class ServerTeamRemoverActor final : public Actor<Void>, public ActorCallback< ServerTeamRemoverActor, 0, Void >, public ActorCallback< ServerTeamRemoverActor, 1, Void >, public ActorCallback< ServerTeamRemoverActor, 2, Void >, public ActorCallback< ServerTeamRemoverActor, 3, Void >, public ActorCallback< ServerTeamRemoverActor, 4, Void >, public FastAllocated<ServerTeamRemoverActor>, public ServerTeamRemoverActorState<ServerTeamRemoverActor> {
															#line 12090 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<ServerTeamRemoverActor>::operator new;
	using FastAllocated<ServerTeamRemoverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4613565874518706944UL, 17460896624330693632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServerTeamRemoverActor, 0, Void >;
friend struct ActorCallback< ServerTeamRemoverActor, 1, Void >;
friend struct ActorCallback< ServerTeamRemoverActor, 2, Void >;
friend struct ActorCallback< ServerTeamRemoverActor, 3, Void >;
friend struct ActorCallback< ServerTeamRemoverActor, 4, Void >;
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ServerTeamRemoverActor(DDTeamCollection* const& self) 
															#line 12111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ServerTeamRemoverActorState<ServerTeamRemoverActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serverTeamRemover", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15494514635976119296UL, 13126504078864137984UL);
		ActorExecutionContextHelper __helper(static_cast<ServerTeamRemoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serverTeamRemover");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serverTeamRemover", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServerTeamRemoverActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServerTeamRemoverActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ServerTeamRemoverActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ServerTeamRemoverActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ServerTeamRemoverActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> serverTeamRemover( DDTeamCollection* const& self ) {
															#line 2111 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new ServerTeamRemoverActor(self));
															#line 12147 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2198 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 12152 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via fixUnderReplicationLoop()
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class FixUnderReplicationLoopActor>
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class FixUnderReplicationLoopActorState {
															#line 12158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	FixUnderReplicationLoopActorState(DDTeamCollection* const& self) 
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self)
															#line 12165 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this));

	}
	~FixUnderReplicationLoopActorState() 
	{
		fdb_probe_actor_destroy("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2200 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 12180 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FixUnderReplicationLoopActorState();
		static_cast<FixUnderReplicationLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->DD_FIX_WRONG_REPLICAS_DELAY);
															#line 2201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<FixUnderReplicationLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12212 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FixUnderReplicationLoopActor*>(this)->actor_wait_state = 1;
															#line 2201 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FixUnderReplicationLoopActor, 0, Void >*>(static_cast<FixUnderReplicationLoopActor*>(this)));
															#line 12217 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->cleanupLargeTeams();
															#line 2203 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->fixUnderReplication();
															#line 12228 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->cleanupLargeTeams();
															#line 2203 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->fixUnderReplication();
															#line 12239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FixUnderReplicationLoopActor*>(this)->actor_wait_state > 0) static_cast<FixUnderReplicationLoopActor*>(this)->actor_wait_state = 0;
		static_cast<FixUnderReplicationLoopActor*>(this)->ActorCallback< FixUnderReplicationLoopActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FixUnderReplicationLoopActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FixUnderReplicationLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FixUnderReplicationLoopActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FixUnderReplicationLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FixUnderReplicationLoopActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FixUnderReplicationLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 12321 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via fixUnderReplicationLoop()
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class FixUnderReplicationLoopActor final : public Actor<Void>, public ActorCallback< FixUnderReplicationLoopActor, 0, Void >, public FastAllocated<FixUnderReplicationLoopActor>, public FixUnderReplicationLoopActorState<FixUnderReplicationLoopActor> {
															#line 12326 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<FixUnderReplicationLoopActor>::operator new;
	using FastAllocated<FixUnderReplicationLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6665256740052344832UL, 13137068308158232064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FixUnderReplicationLoopActor, 0, Void >;
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	FixUnderReplicationLoopActor(DDTeamCollection* const& self) 
															#line 12343 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   FixUnderReplicationLoopActorState<FixUnderReplicationLoopActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4154624735730565376UL, 7078271522505833728UL);
		ActorExecutionContextHelper __helper(static_cast<FixUnderReplicationLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fixUnderReplicationLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fixUnderReplicationLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FixUnderReplicationLoopActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> fixUnderReplicationLoop( DDTeamCollection* const& self ) {
															#line 2199 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new FixUnderReplicationLoopActor(self));
															#line 12375 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2206 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 12380 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via trackExcludedServers()
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class TrackExcludedServersActor>
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class TrackExcludedServersActorState {
															#line 12386 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	TrackExcludedServersActorState(DDTeamCollection* const& self) 
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 2208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   exclusionTracker(self->dbContext())
															#line 12395 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("trackExcludedServers", reinterpret_cast<unsigned long>(this));

	}
	~TrackExcludedServersActorState() 
	{
		fdb_probe_actor_destroy("trackExcludedServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2209 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 12410 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackExcludedServersActorState();
		static_cast<TrackExcludedServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2211 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = exclusionTracker.changed.onTrigger();
															#line 2211 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<TrackExcludedServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12442 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TrackExcludedServersActor*>(this)->actor_wait_state = 1;
															#line 2211 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackExcludedServersActor, 0, Void >*>(static_cast<TrackExcludedServersActor*>(this)));
															#line 12447 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2216 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		auto old = self->excludedServers.getKeys();
															#line 2217 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& o : old ) {
															#line 2218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!exclusionTracker.excluded.contains(o) && !exclusionTracker.failed.contains(o) && !(self->excludedServers.count(o) && self->excludedServers.get(o) == DDTeamCollection::Status::WIGGLING))
															#line 12460 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->excludedServers.set(o, DDTeamCollection::Status::NONE);
															#line 12464 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 2224 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& n : exclusionTracker.excluded ) {
															#line 2225 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!exclusionTracker.failed.contains(n))
															#line 12471 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2226 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->excludedServers.set(n, DDTeamCollection::Status::EXCLUDED);
															#line 12475 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 2230 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& f : exclusionTracker.failed ) {
															#line 2231 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->excludedServers.set(f, DDTeamCollection::Status::FAILED);
															#line 12482 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2234 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("DDExcludedServersChanged", self->distributorId) .detail("AddressesExcluded", exclusionTracker.excluded.size()) .detail("AddressesFailed", exclusionTracker.failed.size()) .detail("Primary", self->isPrimary());
															#line 2239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->restartRecruiting.trigger();
															#line 12488 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2216 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		auto old = self->excludedServers.getKeys();
															#line 2217 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& o : old ) {
															#line 2218 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!exclusionTracker.excluded.contains(o) && !exclusionTracker.failed.contains(o) && !(self->excludedServers.count(o) && self->excludedServers.get(o) == DDTeamCollection::Status::WIGGLING))
															#line 12501 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->excludedServers.set(o, DDTeamCollection::Status::NONE);
															#line 12505 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 2224 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& n : exclusionTracker.excluded ) {
															#line 2225 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (!exclusionTracker.failed.contains(n))
															#line 12512 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2226 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->excludedServers.set(n, DDTeamCollection::Status::EXCLUDED);
															#line 12516 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
		}
															#line 2230 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		for( const auto& f : exclusionTracker.failed ) {
															#line 2231 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->excludedServers.set(f, DDTeamCollection::Status::FAILED);
															#line 12523 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2234 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("DDExcludedServersChanged", self->distributorId) .detail("AddressesExcluded", exclusionTracker.excluded.size()) .detail("AddressesFailed", exclusionTracker.failed.size()) .detail("Primary", self->isPrimary());
															#line 2239 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->restartRecruiting.trigger();
															#line 12529 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackExcludedServersActor*>(this)->actor_wait_state > 0) static_cast<TrackExcludedServersActor*>(this)->actor_wait_state = 0;
		static_cast<TrackExcludedServersActor*>(this)->ActorCallback< TrackExcludedServersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackExcludedServersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackExcludedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackExcludedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackExcludedServersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackExcludedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackExcludedServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackExcludedServersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackExcludedServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackExcludedServers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 2208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ExclusionTracker exclusionTracker;
															#line 12613 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via trackExcludedServers()
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class TrackExcludedServersActor final : public Actor<Void>, public ActorCallback< TrackExcludedServersActor, 0, Void >, public FastAllocated<TrackExcludedServersActor>, public TrackExcludedServersActorState<TrackExcludedServersActor> {
															#line 12618 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<TrackExcludedServersActor>::operator new;
	using FastAllocated<TrackExcludedServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(885425331918812672UL, 16509132433308620288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackExcludedServersActor, 0, Void >;
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	TrackExcludedServersActor(DDTeamCollection* const& self) 
															#line 12635 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TrackExcludedServersActorState<TrackExcludedServersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackExcludedServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12934818911478356992UL, 3065279160655865600UL);
		ActorExecutionContextHelper __helper(static_cast<TrackExcludedServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackExcludedServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackExcludedServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackExcludedServersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> trackExcludedServers( DDTeamCollection* const& self ) {
															#line 2207 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new TrackExcludedServersActor(self));
															#line 12667 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2242 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 12672 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via updateNextWigglingStorageID()
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class UpdateNextWigglingStorageIDActor>
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class UpdateNextWigglingStorageIDActorState {
															#line 12678 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	UpdateNextWigglingStorageIDActorState(DDTeamCollection* const& self) 
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 2244 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   wiggleState(),
															#line 2245 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   metadataMap(wiggleState.wigglingStorageServer(PrimaryRegion(self->primary)))
															#line 12689 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this));

	}
	~UpdateNextWigglingStorageIDActorState() 
	{
		fdb_probe_actor_destroy("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2248 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<UID> __when_expr_0 = self->getNextWigglingServerID();
															#line 2248 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12706 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state = 1;
															#line 2248 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateNextWigglingStorageIDActor, 0, UID >*>(static_cast<UpdateNextWigglingStorageIDActor*>(this)));
															#line 12711 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateNextWigglingStorageIDActorState();
		static_cast<UpdateNextWigglingStorageIDActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		value = StorageWiggleValue(nextId);
															#line 2250 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(self->dbContext()));
															#line 2251 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 12738 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID const& __nextId,int loopDepth) 
	{
															#line 2248 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		nextId = __nextId;
															#line 12747 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID && __nextId,int loopDepth) 
	{
		nextId = std::move(__nextId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state > 0) static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNextWigglingStorageIDActor*>(this)->ActorCallback< UpdateNextWigglingStorageIDActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNextWigglingStorageIDActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateNextWigglingStorageIDActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateNextWigglingStorageIDActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2263 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->nextWiggleInfo.send(value);
															#line 2264 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent(SevDebug, "PerpetualStorageWiggleNextID", self->distributorId) .detail("Primary", self->primary) .detail("WriteID", nextId);
															#line 2268 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<UpdateNextWigglingStorageIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateNextWigglingStorageIDActorState(); static_cast<UpdateNextWigglingStorageIDActor*>(this)->destroy(); return 0; }
															#line 12830 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<UpdateNextWigglingStorageIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateNextWigglingStorageIDActorState();
		static_cast<UpdateNextWigglingStorageIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2254 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2255 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			metadataMap.set(tr, nextId, value);
															#line 2256 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 2256 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12856 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state = 2;
															#line 2256 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateNextWigglingStorageIDActor, 1, Void >*>(static_cast<UpdateNextWigglingStorageIDActor*>(this)));
															#line 12861 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2259 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 2259 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12898 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state = 3;
															#line 2259 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateNextWigglingStorageIDActor, 2, Void >*>(static_cast<UpdateNextWigglingStorageIDActor*>(this)));
															#line 12903 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state > 0) static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNextWigglingStorageIDActor*>(this)->ActorCallback< UpdateNextWigglingStorageIDActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNextWigglingStorageIDActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateNextWigglingStorageIDActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateNextWigglingStorageIDActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state > 0) static_cast<UpdateNextWigglingStorageIDActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNextWigglingStorageIDActor*>(this)->ActorCallback< UpdateNextWigglingStorageIDActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNextWigglingStorageIDActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateNextWigglingStorageIDActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateNextWigglingStorageIDActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 2244 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	StorageWiggleData wiggleState;
															#line 2245 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	KeyBackedObjectMap<UID, StorageWiggleValue, decltype(IncludeVersion())> metadataMap;
															#line 2248 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	UID nextId;
															#line 2249 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	StorageWiggleValue value;
															#line 2250 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 13100 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateNextWigglingStorageID()
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class UpdateNextWigglingStorageIDActor final : public Actor<Void>, public ActorCallback< UpdateNextWigglingStorageIDActor, 0, UID >, public ActorCallback< UpdateNextWigglingStorageIDActor, 1, Void >, public ActorCallback< UpdateNextWigglingStorageIDActor, 2, Void >, public FastAllocated<UpdateNextWigglingStorageIDActor>, public UpdateNextWigglingStorageIDActorState<UpdateNextWigglingStorageIDActor> {
															#line 13105 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateNextWigglingStorageIDActor>::operator new;
	using FastAllocated<UpdateNextWigglingStorageIDActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1079884756307942656UL, 1992759670589720320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateNextWigglingStorageIDActor, 0, UID >;
friend struct ActorCallback< UpdateNextWigglingStorageIDActor, 1, Void >;
friend struct ActorCallback< UpdateNextWigglingStorageIDActor, 2, Void >;
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	UpdateNextWigglingStorageIDActor(DDTeamCollection* const& self) 
															#line 13124 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateNextWigglingStorageIDActorState<UpdateNextWigglingStorageIDActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11258546088197827072UL, 15626919859300213504UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNextWigglingStorageIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateNextWigglingStorageID");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateNextWigglingStorageID", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateNextWigglingStorageIDActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateNextWigglingStorageIDActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateNextWigglingStorageIDActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> updateNextWigglingStorageID( DDTeamCollection* const& self ) {
															#line 2243 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new UpdateNextWigglingStorageIDActor(self));
															#line 13158 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2270 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 13163 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via waitPerpetualWiggleDelay()
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class WaitPerpetualWiggleDelayActor>
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class WaitPerpetualWiggleDelayActorState {
															#line 13169 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	WaitPerpetualWiggleDelayActorState(DDTeamCollection* const& self) 
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self)
															#line 13176 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this));

	}
	~WaitPerpetualWiggleDelayActorState() 
	{
		fdb_probe_actor_destroy("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2272 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (g_network->isSimulated() && g_simulator->isConsistencyChecked)
															#line 13191 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2275 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(300);
															#line 2275 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13197 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 1;
															#line 2275 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitPerpetualWiggleDelayActor, 0, Void >*>(static_cast<WaitPerpetualWiggleDelayActor*>(this)));
															#line 13202 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 2277 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY <= 60.0)
															#line 13209 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 2278 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY);
															#line 2278 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13215 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 2;
															#line 2278 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitPerpetualWiggleDelayActor, 1, Void >*>(static_cast<WaitPerpetualWiggleDelayActor*>(this)));
															#line 13220 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont4(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitPerpetualWiggleDelayActorState();
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2281 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		nextDelay = 60.0;
															#line 2282 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 13251 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2276 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitPerpetualWiggleDelayActorState(); static_cast<WaitPerpetualWiggleDelayActor*>(this)->destroy(); return 0; }
															#line 13260 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitPerpetualWiggleDelayActorState();
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2276 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitPerpetualWiggleDelayActorState(); static_cast<WaitPerpetualWiggleDelayActor*>(this)->destroy(); return 0; }
															#line 13272 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitPerpetualWiggleDelayActorState();
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state > 0) static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 0;
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->ActorCallback< WaitPerpetualWiggleDelayActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitPerpetualWiggleDelayActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 2279 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitPerpetualWiggleDelayActorState(); static_cast<WaitPerpetualWiggleDelayActor*>(this)->destroy(); return 0; }
															#line 13365 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitPerpetualWiggleDelayActorState();
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 2279 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitPerpetualWiggleDelayActorState(); static_cast<WaitPerpetualWiggleDelayActor*>(this)->destroy(); return 0; }
															#line 13377 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitPerpetualWiggleDelayActorState();
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state > 0) static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 0;
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->ActorCallback< WaitPerpetualWiggleDelayActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitPerpetualWiggleDelayActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2283 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(nextDelay);
															#line 2283 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13473 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 3;
															#line 2283 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitPerpetualWiggleDelayActor, 2, Void >*>(static_cast<WaitPerpetualWiggleDelayActor*>(this)));
															#line 13478 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2285 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<double> __when_expr_3 = self->storageWiggler->wiggleData.addPerpetualWiggleDelay( self->dbContext().getReference(), PrimaryRegion(self->primary), nextDelay);
															#line 2285 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13489 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 4;
															#line 2285 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >*>(static_cast<WaitPerpetualWiggleDelayActor*>(this)));
															#line 13494 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2285 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<double> __when_expr_3 = self->storageWiggler->wiggleData.addPerpetualWiggleDelay( self->dbContext().getReference(), PrimaryRegion(self->primary), nextDelay);
															#line 2285 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13505 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 4;
															#line 2285 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >*>(static_cast<WaitPerpetualWiggleDelayActor*>(this)));
															#line 13510 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state > 0) static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 0;
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->ActorCallback< WaitPerpetualWiggleDelayActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitPerpetualWiggleDelayActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont2(double const& totalDelay,int loopDepth) 
	{
															#line 2287 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		nextDelay = std::min(SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY - totalDelay, 60.0);
															#line 2289 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (totalDelay >= SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY)
															#line 13596 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->storageWiggler->wiggleData.clearPerpetualWiggleDelay(self->dbContext().getReference(), PrimaryRegion(self->primary));
															#line 2290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13602 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 5;
															#line 2290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >*>(static_cast<WaitPerpetualWiggleDelayActor*>(this)));
															#line 13607 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(double && totalDelay,int loopDepth) 
	{
															#line 2287 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		nextDelay = std::min(SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY - totalDelay, 60.0);
															#line 2289 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (totalDelay >= SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY)
															#line 13623 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->storageWiggler->wiggleData.clearPerpetualWiggleDelay(self->dbContext().getReference(), PrimaryRegion(self->primary));
															#line 2290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13629 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 5;
															#line 2290 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >*>(static_cast<WaitPerpetualWiggleDelayActor*>(this)));
															#line 13634 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(double const& totalDelay,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(totalDelay, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(double && totalDelay,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(totalDelay), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state > 0) static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 0;
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >::remove();

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >*,double const& value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >*,double && value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >*,Error err) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 2292 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitPerpetualWiggleDelayActorState(); static_cast<WaitPerpetualWiggleDelayActor*>(this)->destroy(); return 0; }
															#line 13729 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitPerpetualWiggleDelayActorState();
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 2292 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitPerpetualWiggleDelayActorState(); static_cast<WaitPerpetualWiggleDelayActor*>(this)->destroy(); return 0; }
															#line 13741 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<WaitPerpetualWiggleDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitPerpetualWiggleDelayActorState();
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state > 0) static_cast<WaitPerpetualWiggleDelayActor*>(this)->actor_wait_state = 0;
		static_cast<WaitPerpetualWiggleDelayActor*>(this)->ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 2281 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	double nextDelay;
															#line 13828 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via waitPerpetualWiggleDelay()
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class WaitPerpetualWiggleDelayActor final : public Actor<Void>, public ActorCallback< WaitPerpetualWiggleDelayActor, 0, Void >, public ActorCallback< WaitPerpetualWiggleDelayActor, 1, Void >, public ActorCallback< WaitPerpetualWiggleDelayActor, 2, Void >, public ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >, public ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >, public FastAllocated<WaitPerpetualWiggleDelayActor>, public WaitPerpetualWiggleDelayActorState<WaitPerpetualWiggleDelayActor> {
															#line 13833 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<WaitPerpetualWiggleDelayActor>::operator new;
	using FastAllocated<WaitPerpetualWiggleDelayActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5351874078277605632UL, 16030779669093656832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitPerpetualWiggleDelayActor, 0, Void >;
friend struct ActorCallback< WaitPerpetualWiggleDelayActor, 1, Void >;
friend struct ActorCallback< WaitPerpetualWiggleDelayActor, 2, Void >;
friend struct ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >;
friend struct ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >;
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	WaitPerpetualWiggleDelayActor(DDTeamCollection* const& self) 
															#line 13854 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WaitPerpetualWiggleDelayActorState<WaitPerpetualWiggleDelayActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17842392533900182272UL, 17165844113426380288UL);
		ActorExecutionContextHelper __helper(static_cast<WaitPerpetualWiggleDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitPerpetualWiggleDelay");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitPerpetualWiggleDelay", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitPerpetualWiggleDelayActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitPerpetualWiggleDelayActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitPerpetualWiggleDelayActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitPerpetualWiggleDelayActor, 3, double >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WaitPerpetualWiggleDelayActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> waitPerpetualWiggleDelay( DDTeamCollection* const& self ) {
															#line 2271 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new WaitPerpetualWiggleDelayActor(self));
															#line 13890 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2296 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 13895 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via perpetualStorageWiggleRest()
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class PerpetualStorageWiggleRestActor>
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class PerpetualStorageWiggleRestActorState {
															#line 13901 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	PerpetualStorageWiggleRestActorState(DDTeamCollection* const& self) 
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 2298 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   takeRest(true),
															#line 2299 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   avgShardBytes()
															#line 13912 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this));

	}
	~PerpetualStorageWiggleRestActorState() 
	{
		fdb_probe_actor_destroy("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2300 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 13927 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerpetualStorageWiggleRestActorState();
		static_cast<PerpetualStorageWiggleRestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2360 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<PerpetualStorageWiggleRestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerpetualStorageWiggleRestActorState(); static_cast<PerpetualStorageWiggleRestActor*>(this)->destroy(); return 0; }
															#line 13950 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<PerpetualStorageWiggleRestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerpetualStorageWiggleRestActorState();
		static_cast<PerpetualStorageWiggleRestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2300 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!(takeRest))
															#line 13969 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2302 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitPerpetualWiggleDelay(self);
															#line 2302 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13977 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state = 1;
															#line 2302 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWiggleRestActor, 0, Void >*>(static_cast<PerpetualStorageWiggleRestActor*>(this)));
															#line 13982 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2304 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		avgShardBytes.reset();
															#line 2305 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->getAverageShardBytes.send(avgShardBytes);
															#line 2306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = avgShardBytes.getFuture();
															#line 2306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14010 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state = 2;
															#line 2306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >*>(static_cast<PerpetualStorageWiggleRestActor*>(this)));
															#line 14015 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2304 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		avgShardBytes.reset();
															#line 2305 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->getAverageShardBytes.send(avgShardBytes);
															#line 2306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = avgShardBytes.getFuture();
															#line 2306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14030 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state = 2;
															#line 2306 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >*>(static_cast<PerpetualStorageWiggleRestActor*>(this)));
															#line 14035 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWiggleRestActor*>(this)->ActorCallback< PerpetualStorageWiggleRestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleRestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleRestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleRestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleRestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWiggleRestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleRestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int64_t const& avgBytes,int loopDepth) 
	{
															#line 2307 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		double ratio;
															#line 2308 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool imbalance, noMinAvailSpace;
															#line 2309 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int numSSToBeLoadBytesBalanced;
															#line 2311 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->PW_MAX_SS_LESSTHAN_MIN_BYTES_BALANCE_RATIO)
															#line 14125 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2319 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			numSSToBeLoadBytesBalanced = self->numSSToBeLoadBytesBalanced(avgBytes * SERVER_KNOBS->PERPETUAL_WIGGLE_SMALL_LOAD_RATIO);
															#line 2321 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			imbalance = numSSToBeLoadBytesBalanced > SERVER_KNOBS->PW_MAX_SS_LESSTHAN_MIN_BYTES_BALANCE_RATIO;
															#line 14131 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ratio = self->loadBytesBalanceRatio(avgBytes * SERVER_KNOBS->PERPETUAL_WIGGLE_SMALL_LOAD_RATIO);
															#line 2324 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			imbalance = ratio < SERVER_KNOBS->PERPETUAL_WIGGLE_MIN_BYTES_BALANCE_RATIO;
															#line 14139 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2326 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		CODE_PROBE(imbalance, "Perpetual Wiggle pause because cluster is imbalance.");
															#line 2328 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		noMinAvailSpace = !self->allServersHaveMinAvailableSpace(SERVER_KNOBS->PERPETUAL_WIGGLE_MIN_AVAILABLE_SPACE_RATIO);
															#line 2332 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		takeRest = self->server_info.size() <= self->configuration.storageTeamSize || self->machine_info.size() < self->configuration.storageTeamSize || imbalance || noMinAvailSpace;
															#line 2335 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->PERPETUAL_WIGGLE_PAUSE_AFTER_TSS_TARGET_MET && self->configuration.storageMigrationType == StorageMigrationType::DEFAULT)
															#line 14149 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2337 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			takeRest = takeRest || (self->getTargetTSSInDC() > 0 && self->reachTSSPairTarget());
															#line 14153 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2341 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (takeRest)
															#line 14157 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2342 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->storageWiggler->setWiggleState(StorageWiggler::PAUSE);
															#line 2343 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			Severity sev = self->configuration.storageMigrationType == StorageMigrationType::GRADUAL ? SevWarn : SevInfo;
															#line 2345 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(sev, "PerpetualStorageWiggleSleep", self->distributorId) .suppressFor(SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY * 4) .detail("Primary", self->primary) .detail("ImbalanceFactor", SERVER_KNOBS->PW_MAX_SS_LESSTHAN_MIN_BYTES_BALANCE_RATIO ? numSSToBeLoadBytesBalanced : ratio) .detail("ServerSize", self->server_info.size()) .detail("MachineSize", self->machine_info.size()) .detail("StorageTeamSize", self->configuration.storageTeamSize) .detail("TargetTSSInDC", self->getTargetTSSInDC()) .detail("ReachTSSPairTarget", self->reachTSSPairTarget()) .detail("NoMinAvailableSpace", noMinAvailSpace) .detail("MigrationType", self->configuration.storageMigrationType.toString());
															#line 14165 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int64_t && avgBytes,int loopDepth) 
	{
															#line 2307 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		double ratio;
															#line 2308 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		bool imbalance, noMinAvailSpace;
															#line 2309 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		int numSSToBeLoadBytesBalanced;
															#line 2311 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->PW_MAX_SS_LESSTHAN_MIN_BYTES_BALANCE_RATIO)
															#line 14181 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2319 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			numSSToBeLoadBytesBalanced = self->numSSToBeLoadBytesBalanced(avgBytes * SERVER_KNOBS->PERPETUAL_WIGGLE_SMALL_LOAD_RATIO);
															#line 2321 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			imbalance = numSSToBeLoadBytesBalanced > SERVER_KNOBS->PW_MAX_SS_LESSTHAN_MIN_BYTES_BALANCE_RATIO;
															#line 14187 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2323 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ratio = self->loadBytesBalanceRatio(avgBytes * SERVER_KNOBS->PERPETUAL_WIGGLE_SMALL_LOAD_RATIO);
															#line 2324 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			imbalance = ratio < SERVER_KNOBS->PERPETUAL_WIGGLE_MIN_BYTES_BALANCE_RATIO;
															#line 14195 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2326 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		CODE_PROBE(imbalance, "Perpetual Wiggle pause because cluster is imbalance.");
															#line 2328 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		noMinAvailSpace = !self->allServersHaveMinAvailableSpace(SERVER_KNOBS->PERPETUAL_WIGGLE_MIN_AVAILABLE_SPACE_RATIO);
															#line 2332 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		takeRest = self->server_info.size() <= self->configuration.storageTeamSize || self->machine_info.size() < self->configuration.storageTeamSize || imbalance || noMinAvailSpace;
															#line 2335 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (SERVER_KNOBS->PERPETUAL_WIGGLE_PAUSE_AFTER_TSS_TARGET_MET && self->configuration.storageMigrationType == StorageMigrationType::DEFAULT)
															#line 14205 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2337 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			takeRest = takeRest || (self->getTargetTSSInDC() > 0 && self->reachTSSPairTarget());
															#line 14209 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2341 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (takeRest)
															#line 14213 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2342 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->storageWiggler->setWiggleState(StorageWiggler::PAUSE);
															#line 2343 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			Severity sev = self->configuration.storageMigrationType == StorageMigrationType::GRADUAL ? SevWarn : SevInfo;
															#line 2345 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent(sev, "PerpetualStorageWiggleSleep", self->distributorId) .suppressFor(SERVER_KNOBS->PERPETUAL_WIGGLE_DELAY * 4) .detail("Primary", self->primary) .detail("ImbalanceFactor", SERVER_KNOBS->PW_MAX_SS_LESSTHAN_MIN_BYTES_BALANCE_RATIO ? numSSToBeLoadBytesBalanced : ratio) .detail("ServerSize", self->server_info.size()) .detail("MachineSize", self->machine_info.size()) .detail("StorageTeamSize", self->configuration.storageTeamSize) .detail("TargetTSSInDC", self->getTargetTSSInDC()) .detail("ReachTSSPairTarget", self->reachTSSPairTarget()) .detail("NoMinAvailableSpace", noMinAvailSpace) .detail("MigrationType", self->configuration.storageMigrationType.toString());
															#line 14221 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(int64_t const& avgBytes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(avgBytes, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(int64_t && avgBytes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(avgBytes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWiggleRestActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWiggleRestActor*>(this)->ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleRestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleRestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleRestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 2298 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	bool takeRest;
															#line 2299 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Promise<int64_t> avgShardBytes;
															#line 14308 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via perpetualStorageWiggleRest()
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class PerpetualStorageWiggleRestActor final : public Actor<Void>, public ActorCallback< PerpetualStorageWiggleRestActor, 0, Void >, public ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >, public FastAllocated<PerpetualStorageWiggleRestActor>, public PerpetualStorageWiggleRestActorState<PerpetualStorageWiggleRestActor> {
															#line 14313 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<PerpetualStorageWiggleRestActor>::operator new;
	using FastAllocated<PerpetualStorageWiggleRestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1419974253338387968UL, 14733437095315588096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerpetualStorageWiggleRestActor, 0, Void >;
friend struct ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >;
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	PerpetualStorageWiggleRestActor(DDTeamCollection* const& self) 
															#line 14331 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PerpetualStorageWiggleRestActorState<PerpetualStorageWiggleRestActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7494931994395429120UL, 6677810870802017024UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleRestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("perpetualStorageWiggleRest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("perpetualStorageWiggleRest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerpetualStorageWiggleRestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerpetualStorageWiggleRestActor, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> perpetualStorageWiggleRest( DDTeamCollection* const& self ) {
															#line 2297 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new PerpetualStorageWiggleRestActor(self));
															#line 14364 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2362 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 14369 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via perpetualStorageWiggleIterator()
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class PerpetualStorageWiggleIteratorActor>
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class PerpetualStorageWiggleIteratorActorState {
															#line 14375 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	PerpetualStorageWiggleIteratorActorState(DDTeamCollection* const& teamCollection,AsyncVar<bool>* const& stopSignal,FutureStream<Void> const& finishStorageWiggleSignal) 
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : teamCollection(teamCollection),
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   stopSignal(stopSignal),
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   finishStorageWiggleSignal(finishStorageWiggleSignal)
															#line 14386 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this));

	}
	~PerpetualStorageWiggleIteratorActorState() 
	{
		fdb_probe_actor_destroy("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2366 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 14401 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerpetualStorageWiggleIteratorActorState();
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2381 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<PerpetualStorageWiggleIteratorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerpetualStorageWiggleIteratorActorState(); static_cast<PerpetualStorageWiggleIteratorActor*>(this)->destroy(); return 0; }
															#line 14424 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<PerpetualStorageWiggleIteratorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerpetualStorageWiggleIteratorActorState();
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2368 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = stopSignal->onChange();
															#line 2367 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14445 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2369 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		auto __when_expr_1 = finishStorageWiggleSignal;
															#line 14449 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<Void>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<Void>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state = 1;
															#line 2368 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWiggleIteratorActor, 0, Void >*>(static_cast<PerpetualStorageWiggleIteratorActor*>(this)));
															#line 2369 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< PerpetualStorageWiggleIteratorActor, 1, Void >*>(static_cast<PerpetualStorageWiggleIteratorActor*>(this)));
															#line 14457 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2376 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (stopSignal->get())
															#line 14479 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = perpetualStorageWiggleRest(teamCollection);
															#line 2372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14505 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state = 2;
															#line 2372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >*>(static_cast<PerpetualStorageWiggleIteratorActor*>(this)));
															#line 14510 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = perpetualStorageWiggleRest(teamCollection);
															#line 2372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14521 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state = 2;
															#line 2372 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >*>(static_cast<PerpetualStorageWiggleIteratorActor*>(this)));
															#line 14526 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->ActorCallback< PerpetualStorageWiggleIteratorActor, 0, Void >::remove();
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->ActorSingleCallback< PerpetualStorageWiggleIteratorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleIteratorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleIteratorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWiggleIteratorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
															#line 2373 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_3 = updateNextWigglingStorageID(teamCollection);
															#line 2373 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14601 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state = 3;
															#line 2373 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >*>(static_cast<PerpetualStorageWiggleIteratorActor*>(this)));
															#line 14606 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Void && _,int loopDepth) 
	{
															#line 2373 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_3 = updateNextWigglingStorageID(teamCollection);
															#line 2373 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14617 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state = 3;
															#line 2373 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >*>(static_cast<PerpetualStorageWiggleIteratorActor*>(this)));
															#line 14622 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when2cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWiggleIteratorActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWiggleIteratorActor*>(this)->ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< PerpetualStorageWiggleIteratorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< PerpetualStorageWiggleIteratorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< PerpetualStorageWiggleIteratorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* teamCollection;
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	AsyncVar<bool>* stopSignal;
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	FutureStream<Void> finishStorageWiggleSignal;
															#line 14852 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via perpetualStorageWiggleIterator()
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class PerpetualStorageWiggleIteratorActor final : public Actor<Void>, public ActorCallback< PerpetualStorageWiggleIteratorActor, 0, Void >, public ActorSingleCallback< PerpetualStorageWiggleIteratorActor, 1, Void >, public ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >, public ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >, public FastAllocated<PerpetualStorageWiggleIteratorActor>, public PerpetualStorageWiggleIteratorActorState<PerpetualStorageWiggleIteratorActor> {
															#line 14857 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<PerpetualStorageWiggleIteratorActor>::operator new;
	using FastAllocated<PerpetualStorageWiggleIteratorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14955868272966791168UL, 18275547108117087488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerpetualStorageWiggleIteratorActor, 0, Void >;
friend struct ActorSingleCallback< PerpetualStorageWiggleIteratorActor, 1, Void >;
friend struct ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >;
friend struct ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >;
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	PerpetualStorageWiggleIteratorActor(DDTeamCollection* const& teamCollection,AsyncVar<bool>* const& stopSignal,FutureStream<Void> const& finishStorageWiggleSignal) 
															#line 14877 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PerpetualStorageWiggleIteratorActorState<PerpetualStorageWiggleIteratorActor>(teamCollection, stopSignal, finishStorageWiggleSignal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18064972708219917824UL, 2271723782523643904UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWiggleIteratorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("perpetualStorageWiggleIterator");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("perpetualStorageWiggleIterator", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerpetualStorageWiggleIteratorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerpetualStorageWiggleIteratorActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PerpetualStorageWiggleIteratorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> perpetualStorageWiggleIterator( DDTeamCollection* const& teamCollection, AsyncVar<bool>* const& stopSignal, FutureStream<Void> const& finishStorageWiggleSignal ) {
															#line 2363 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new PerpetualStorageWiggleIteratorActor(teamCollection, stopSignal, finishStorageWiggleSignal));
															#line 14911 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2383 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 14916 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via clusterHealthCheckForPerpetualWiggle()
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class ClusterHealthCheckForPerpetualWiggleActor>
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class ClusterHealthCheckForPerpetualWiggleActorState {
															#line 14922 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ClusterHealthCheckForPerpetualWiggleActorState(DDTeamCollection* const& self,int* const& extraTeamCount) 
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   extraTeamCount(extraTeamCount),
															#line 2385 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   pausePenalty(1)
															#line 14933 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this));

	}
	~ClusterHealthCheckForPerpetualWiggleActorState() 
	{
		fdb_probe_actor_destroy("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2386 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 14948 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterHealthCheckForPerpetualWiggleActorState();
		static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2387 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		Promise<int> countp;
															#line 2388 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->getUnhealthyRelocationCount.send(countp);
															#line 2389 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<int> __when_expr_0 = countp.getFuture();
															#line 2389 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14984 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state = 1;
															#line 2389 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 0, int >*>(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)));
															#line 14989 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int const& count,int loopDepth) 
	{
															#line 2394 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (count >= SERVER_KNOBS->DD_STORAGE_WIGGLE_PAUSE_THRESHOLD || self->healthyTeamCount <= *extraTeamCount || self->bestTeamKeepStuckCount > SERVER_KNOBS->DD_STORAGE_WIGGLE_STUCK_THRESHOLD)
															#line 14998 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2398 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if ((self->healthyTeamCount <= *extraTeamCount || self->bestTeamKeepStuckCount > SERVER_KNOBS->DD_STORAGE_WIGGLE_PAUSE_THRESHOLD) && !self->pauseWiggle->get())
															#line 15002 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2401 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				*extraTeamCount = std::min(*extraTeamCount + pausePenalty, (int)self->teams.size());
															#line 2402 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				pausePenalty = std::min(pausePenalty * 2, (int)self->teams.size());
															#line 15008 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 2404 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->pauseWiggle->set(true);
															#line 2405 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("PerpetualWigglePausedDueToClusterHealth") .detail("UnhealthyRelocation", count) .detail("HealthyTeamCount", self->healthyTeamCount) .detail("BestTeamStuckCount", self->bestTeamKeepStuckCount) .detail("PausePenalty", pausePenalty) .detail("Primary", self->primary);
															#line 15014 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2412 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->pauseWiggle->set(false);
															#line 15020 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2414 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CHECK_TEAM_DELAY, TaskPriority::DataDistributionLow);
															#line 2414 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15026 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state = 2;
															#line 2414 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >*>(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)));
															#line 15031 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int && count,int loopDepth) 
	{
															#line 2394 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (count >= SERVER_KNOBS->DD_STORAGE_WIGGLE_PAUSE_THRESHOLD || self->healthyTeamCount <= *extraTeamCount || self->bestTeamKeepStuckCount > SERVER_KNOBS->DD_STORAGE_WIGGLE_STUCK_THRESHOLD)
															#line 15040 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2398 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if ((self->healthyTeamCount <= *extraTeamCount || self->bestTeamKeepStuckCount > SERVER_KNOBS->DD_STORAGE_WIGGLE_PAUSE_THRESHOLD) && !self->pauseWiggle->get())
															#line 15044 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2401 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				*extraTeamCount = std::min(*extraTeamCount + pausePenalty, (int)self->teams.size());
															#line 2402 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				pausePenalty = std::min(pausePenalty * 2, (int)self->teams.size());
															#line 15050 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			}
															#line 2404 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->pauseWiggle->set(true);
															#line 2405 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("PerpetualWigglePausedDueToClusterHealth") .detail("UnhealthyRelocation", count) .detail("HealthyTeamCount", self->healthyTeamCount) .detail("BestTeamStuckCount", self->bestTeamKeepStuckCount) .detail("PausePenalty", pausePenalty) .detail("Primary", self->primary);
															#line 15056 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2412 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->pauseWiggle->set(false);
															#line 15062 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2414 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CHECK_TEAM_DELAY, TaskPriority::DataDistributionLow);
															#line 2414 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15068 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state = 2;
															#line 2414 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >*>(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)));
															#line 15073 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& count,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(count, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && count,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(count), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state > 0) static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state > 0) static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int* extraTeamCount;
															#line 2385 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int pausePenalty;
															#line 15246 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clusterHealthCheckForPerpetualWiggle()
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class ClusterHealthCheckForPerpetualWiggleActor final : public Actor<Void>, public ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 0, int >, public ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >, public FastAllocated<ClusterHealthCheckForPerpetualWiggleActor>, public ClusterHealthCheckForPerpetualWiggleActorState<ClusterHealthCheckForPerpetualWiggleActor> {
															#line 15251 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClusterHealthCheckForPerpetualWiggleActor>::operator new;
	using FastAllocated<ClusterHealthCheckForPerpetualWiggleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16712427071683096320UL, 15684153493874793728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 0, int >;
friend struct ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >;
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	ClusterHealthCheckForPerpetualWiggleActor(DDTeamCollection* const& self,int* const& extraTeamCount) 
															#line 15269 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClusterHealthCheckForPerpetualWiggleActorState<ClusterHealthCheckForPerpetualWiggleActor>(self, extraTeamCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3614488950133705728UL, 15646604018089550848UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterHealthCheckForPerpetualWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterHealthCheckForPerpetualWiggle");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterHealthCheckForPerpetualWiggle", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterHealthCheckForPerpetualWiggleActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> clusterHealthCheckForPerpetualWiggle( DDTeamCollection* const& self, int* const& extraTeamCount ) {
															#line 2384 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new ClusterHealthCheckForPerpetualWiggleActor(self, extraTeamCount));
															#line 15302 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2417 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

																#line 15307 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via perpetualStorageWiggler()
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class PerpetualStorageWigglerActor>
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class PerpetualStorageWigglerActorState {
															#line 15313 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	PerpetualStorageWigglerActorState(DDTeamCollection* const& self,AsyncVar<bool>* const& stopSignal,PromiseStream<Void> const& finishStorageWiggleSignal) 
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   stopSignal(stopSignal),
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   finishStorageWiggleSignal(finishStorageWiggleSignal),
															#line 2421 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   wiggleState(),
															#line 2422 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   metadataMap(wiggleState.wigglingStorageServer(PrimaryRegion(self->primary))),
															#line 2425 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   nextFuture(Never()),
															#line 2426 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   moveFinishFuture(Never()),
															#line 2427 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   extraTeamCount(0),
															#line 2428 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   ddQueueCheck(clusterHealthCheckForPerpetualWiggle(self, &extraTeamCount)),
															#line 2429 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   nextStream(self->nextWiggleInfo.getFuture())
															#line 15338 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this));

	}
	~PerpetualStorageWigglerActorState() 
	{
		fdb_probe_actor_destroy("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2431 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = readStorageWiggleMap(self);
															#line 2431 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15355 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 1;
															#line 2431 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 0, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 15360 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PerpetualStorageWigglerActorState();
		static_cast<PerpetualStorageWigglerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2433 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->wigglingId.present())
															#line 15383 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2435 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			nextFuture = waitAndForward(nextStream);
															#line 2436 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			finishStorageWiggleSignal.send(Void());
															#line 15389 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2439 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 15393 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2433 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!self->wigglingId.present())
															#line 15402 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2435 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			nextFuture = waitAndForward(nextStream);
															#line 2436 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			finishStorageWiggleSignal.send(Void());
															#line 15408 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2439 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 15412 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2513 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (self->wigglingId.present())
															#line 15496 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2514 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->includeStorageServersForWiggle();
															#line 2515 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			TraceEvent("PerpetualStorageWiggleExitingPause", self->distributorId) .detail("Primary", self->primary) .detail("ServerId", self->wigglingId.get());
															#line 2518 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->wigglingId.reset();
															#line 15504 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2521 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (!static_cast<PerpetualStorageWigglerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PerpetualStorageWigglerActorState(); static_cast<PerpetualStorageWigglerActor*>(this)->destroy(); return 0; }
															#line 15508 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		new (&static_cast<PerpetualStorageWigglerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PerpetualStorageWigglerActorState();
		static_cast<PerpetualStorageWigglerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2440 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		pauseChanged = self->pauseWiggle->onChange();
															#line 2441 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		stopChanged = stopSignal->onChange();
															#line 2442 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (self->wigglingId.present())
															#line 15531 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2443 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			id = self->wigglingId.get();
															#line 2444 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (self->pauseWiggle->get())
															#line 15537 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2445 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				CODE_PROBE(true, "paused because cluster is unhealthy");
															#line 2446 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				moveFinishFuture = Never();
															#line 2447 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->includeStorageServersForWiggle();
															#line 2448 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				self->storageWiggler->setWiggleState(StorageWiggler::PAUSE);
															#line 2449 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				TraceEvent(self->configuration.storageMigrationType == StorageMigrationType::AGGRESSIVE ? SevInfo : SevWarn, "PerpetualStorageWigglePause", self->distributorId) .detail("Primary", self->primary) .detail("ServerId", id) .detail("BestTeamKeepStuckCount", self->bestTeamKeepStuckCount) .detail("ExtraHealthyTeamCount", extraTeamCount) .detail("HealthyTeamCount", self->healthyTeamCount);
															#line 15549 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = a_body1cont1loopBody1cont2(loopDepth);
			}
			else
			{
															#line 2460 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_1 = self->waitUntilHealthy();
															#line 2459 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15558 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2472 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				StrictFuture<Void> __when_expr_2 = pauseChanged;
															#line 15562 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
				static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 2;
															#line 2460 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 1, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 2472 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 2, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 15569 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2480 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<StorageWiggleValue> __when_expr_4 = nextFuture;
															#line 2479 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15599 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
															#line 2487 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_5 = moveFinishFuture;
															#line 15603 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when2(__when_expr_5.get(), loopDepth); };
															#line 2505 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_6 = ddQueueCheck || pauseChanged || stopChanged;
															#line 15607 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when3(__when_expr_6.get(), loopDepth); };
		static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 4;
															#line 2480 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 4, StorageWiggleValue >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 2487 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 5, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 2505 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 6, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 15616 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2461 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		CODE_PROBE(true, "start wiggling");
															#line 2462 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->storageWiggler->startWiggle();
															#line 2462 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15641 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 3;
															#line 2462 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 3, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 15646 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2461 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		CODE_PROBE(true, "start wiggling");
															#line 2462 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->storageWiggler->startWiggle();
															#line 2462 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15659 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 3;
															#line 2462 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 3, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 15664 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 1, Void >::remove();
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 2, Void >::remove();

	}
	int a_body1cont1loopBody1when1cont1(Void const& _,int loopDepth) 
	{
															#line 2463 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		auto fv = self->excludeStorageServersForWiggle(id);
															#line 2464 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		moveFinishFuture = fv;
															#line 2465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->storageWiggler->setWiggleState(StorageWiggler::RUN);
															#line 2466 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("PerpetualStorageWiggleStart", self->distributorId) .detail("Primary", self->primary) .detail("ServerId", id) .detail("ExtraHealthyTeamCount", extraTeamCount) .detail("HealthyTeamCount", self->healthyTeamCount);
															#line 15698 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1cont1(Void && _,int loopDepth) 
	{
															#line 2463 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		auto fv = self->excludeStorageServersForWiggle(id);
															#line 2464 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		moveFinishFuture = fv;
															#line 2465 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->storageWiggler->setWiggleState(StorageWiggler::RUN);
															#line 2466 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("PerpetualStorageWiggleStart", self->distributorId) .detail("Primary", self->primary) .detail("ServerId", id) .detail("ExtraHealthyTeamCount", extraTeamCount) .detail("HealthyTeamCount", self->healthyTeamCount);
															#line 15713 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 2508 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (stopSignal->get())
															#line 15911 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(StorageWiggleValue const& value,int loopDepth) 
	{
															#line 2481 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		ASSERT(!self->wigglingId.present());
															#line 2482 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		nextFuture = Never();
															#line 2483 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->wigglingId = value.id;
															#line 2485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_7 = delayJittered(5.0, TaskPriority::DataDistributionLow);
															#line 2485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15931 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1when1(__when_expr_7.get(), loopDepth); };
		static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 5;
															#line 2485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 7, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 15936 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(StorageWiggleValue && value,int loopDepth) 
	{
															#line 2481 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		ASSERT(!self->wigglingId.present());
															#line 2482 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		nextFuture = Never();
															#line 2483 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->wigglingId = value.id;
															#line 2485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_7 = delayJittered(5.0, TaskPriority::DataDistributionLow);
															#line 2485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15953 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1when1(__when_expr_7.get(), loopDepth); };
		static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 5;
															#line 2485 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 7, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 15958 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
															#line 2488 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		ASSERT(self->wigglingId.present());
															#line 2489 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->waitUntilRecruited.set(true);
															#line 2490 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->restartTeamBuilder.trigger();
															#line 2492 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		moveFinishFuture = Never();
															#line 2493 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->includeStorageServersForWiggle();
															#line 2494 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("PerpetualStorageWiggleFinish", self->distributorId) .detail("Primary", self->primary) .detail("ServerId", self->wigglingId.get());
															#line 2498 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_8 = self->eraseStorageWiggleMap(&metadataMap, self->wigglingId.get()) && self->storageWiggler->finishWiggle();
															#line 2498 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15981 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when2when1(__when_expr_8.get(), loopDepth); };
		static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 6;
															#line 2498 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 8, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 15986 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(Void && _,int loopDepth) 
	{
															#line 2488 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		ASSERT(self->wigglingId.present());
															#line 2489 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->waitUntilRecruited.set(true);
															#line 2490 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->restartTeamBuilder.trigger();
															#line 2492 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		moveFinishFuture = Never();
															#line 2493 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->includeStorageServersForWiggle();
															#line 2494 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		TraceEvent("PerpetualStorageWiggleFinish", self->distributorId) .detail("Primary", self->primary) .detail("ServerId", self->wigglingId.get());
															#line 2498 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_8 = self->eraseStorageWiggleMap(&metadataMap, self->wigglingId.get()) && self->storageWiggler->finishWiggle();
															#line 2498 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16009 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when2when1(__when_expr_8.get(), loopDepth); };
		static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 6;
															#line 2498 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< PerpetualStorageWigglerActor, 8, Void >*>(static_cast<PerpetualStorageWigglerActor*>(this)));
															#line 16014 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 4, StorageWiggleValue >::remove();
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 5, Void >::remove();
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 6, Void >::remove();

	}
	int a_body1cont1loopBody1cont1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 4, StorageWiggleValue >*,StorageWiggleValue const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 4, StorageWiggleValue >*,StorageWiggleValue && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 4, StorageWiggleValue >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont1when2cont1(Void const& _,int loopDepth) 
	{
															#line 2500 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->wigglingId.reset();
															#line 2501 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		nextFuture = waitAndForward(nextStream);
															#line 2502 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		finishStorageWiggleSignal.send(Void());
															#line 2503 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		extraTeamCount = std::max(0, extraTeamCount - 1);
															#line 16193 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2cont1(Void && _,int loopDepth) 
	{
															#line 2500 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		self->wigglingId.reset();
															#line 2501 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		nextFuture = waitAndForward(nextStream);
															#line 2502 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		finishStorageWiggleSignal.send(Void());
															#line 2503 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		extraTeamCount = std::max(0, extraTeamCount - 1);
															#line 16208 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state > 0) static_cast<PerpetualStorageWigglerActor*>(this)->actor_wait_state = 0;
		static_cast<PerpetualStorageWigglerActor*>(this)->ActorCallback< PerpetualStorageWigglerActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< PerpetualStorageWigglerActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< PerpetualStorageWigglerActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	DDTeamCollection* self;
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	AsyncVar<bool>* stopSignal;
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	PromiseStream<Void> finishStorageWiggleSignal;
															#line 2421 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	StorageWiggleData wiggleState;
															#line 2422 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	KeyBackedObjectMap<UID, StorageWiggleValue, decltype(IncludeVersion())> metadataMap;
															#line 2425 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<StorageWiggleValue> nextFuture;
															#line 2426 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> moveFinishFuture;
															#line 2427 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	int extraTeamCount;
															#line 2428 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> ddQueueCheck;
															#line 2429 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	FutureStream<StorageWiggleValue> nextStream;
															#line 2440 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> pauseChanged;
															#line 2441 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	Future<Void> stopChanged;
															#line 2443 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	UID id;
															#line 16428 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
};
// This generated class is to be used only via perpetualStorageWiggler()
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class PerpetualStorageWigglerActor final : public Actor<Void>, public ActorCallback< PerpetualStorageWigglerActor, 0, Void >, public ActorCallback< PerpetualStorageWigglerActor, 1, Void >, public ActorCallback< PerpetualStorageWigglerActor, 3, Void >, public ActorCallback< PerpetualStorageWigglerActor, 2, Void >, public ActorCallback< PerpetualStorageWigglerActor, 4, StorageWiggleValue >, public ActorCallback< PerpetualStorageWigglerActor, 7, Void >, public ActorCallback< PerpetualStorageWigglerActor, 5, Void >, public ActorCallback< PerpetualStorageWigglerActor, 8, Void >, public ActorCallback< PerpetualStorageWigglerActor, 6, Void >, public FastAllocated<PerpetualStorageWigglerActor>, public PerpetualStorageWigglerActorState<PerpetualStorageWigglerActor> {
															#line 16433 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
	using FastAllocated<PerpetualStorageWigglerActor>::operator new;
	using FastAllocated<PerpetualStorageWigglerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11819730504005343488UL, 1206825992638416384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PerpetualStorageWigglerActor, 0, Void >;
friend struct ActorCallback< PerpetualStorageWigglerActor, 1, Void >;
friend struct ActorCallback< PerpetualStorageWigglerActor, 3, Void >;
friend struct ActorCallback< PerpetualStorageWigglerActor, 2, Void >;
friend struct ActorCallback< PerpetualStorageWigglerActor, 4, StorageWiggleValue >;
friend struct ActorCallback< PerpetualStorageWigglerActor, 7, Void >;
friend struct ActorCallback< PerpetualStorageWigglerActor, 5, Void >;
friend struct ActorCallback< PerpetualStorageWigglerActor, 8, Void >;
friend struct ActorCallback< PerpetualStorageWigglerActor, 6, Void >;
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	PerpetualStorageWigglerActor(DDTeamCollection* const& self,AsyncVar<bool>* const& stopSignal,PromiseStream<Void> const& finishStorageWiggleSignal) 
															#line 16458 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PerpetualStorageWigglerActorState<PerpetualStorageWigglerActor>(self, stopSignal, finishStorageWiggleSignal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10283777814344840192UL, 10450434614853846016UL);
		ActorExecutionContextHelper __helper(static_cast<PerpetualStorageWigglerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("perpetualStorageWiggler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("perpetualStorageWiggler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PerpetualStorageWigglerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PerpetualStorageWigglerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PerpetualStorageWigglerActor, 3, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PerpetualStorageWigglerActor, 4, StorageWiggleValue >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PerpetualStorageWigglerActor, 7, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< PerpetualStorageWigglerActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
[[nodiscard]] static Future<Void> perpetualStorageWiggler( DDTeamCollection* const& self, AsyncVar<bool>* const& stopSignal, PromiseStream<Void> const& finishStorageWiggleSignal ) {
															#line 2418 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	return Future<Void>(new PerpetualStorageWigglerActor(self, stopSignal, finishStorageWiggleSignal));
															#line 16495 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
}

#line 2523 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"

	// This coroutine sets a watch to monitor the value change of `perpetualStorageWiggleKey` which is controlled by
	// command `configure perpetual_storage_wiggle=$value` if the value is 1, this actor start 2 actors,
	// `perpetualStorageWiggleIterator` and `perpetualStorageWiggler`. Otherwise, it sends stop signal to them.
																#line 16503 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
// This generated class is to be used only via monitorPerpetualStorageWiggle()
															#line 2527 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
template <class MonitorPerpetualStorageWiggleActor>
															#line 2527 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
class MonitorPerpetualStorageWiggleActorState {
															#line 16509 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
public:
															#line 2527 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
	MonitorPerpetualStorageWiggleActorState(DDTeamCollection* const& self) 
															#line 2527 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
															#line 2527 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		 : self(self),
															#line 2528 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   speed(0),
															#line 2529 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   finishStorageWiggleSignal(),
															#line 2530 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		   collection()
															#line 16522 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorPerpetualStorageWiggle", reinterpret_cast<unsigned long>(this));

	}
	~MonitorPerpetualStorageWiggleActorState() 
	{
		fdb_probe_actor_destroy("monitorPerpetualStorageWiggle", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2531 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->pauseWiggle = makeReference<AsyncVar<bool>>(true);
															#line 2532 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			ASSERT(self->storageWiggler->isStopped());
															#line 2534 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			;
															#line 16541 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorPerpetualStorageWiggleActorState();
		static_cast<MonitorPerpetualStorageWiggleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2535 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		tr = ReadYourWritesTransaction(self->dbContext());
															#line 2536 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		;
															#line 16573 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 2538 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2539 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Optional<Standalone<StringRef>>> __when_expr_0 = tr.get(perpetualStorageWiggleKey);
															#line 2539 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16600 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state = 1;
															#line 2539 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorPerpetualStorageWiggleActor, 0, Optional<Standalone<StringRef>> >*>(static_cast<MonitorPerpetualStorageWiggleActor*>(this)));
															#line 16605 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2568 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 2568 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 16642 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state = 7;
															#line 2568 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorPerpetualStorageWiggleActor, 6, Void >*>(static_cast<MonitorPerpetualStorageWiggleActor*>(this)));
															#line 16647 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Standalone<StringRef>> const& value,int loopDepth) 
	{
															#line 2541 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (value.present())
															#line 16662 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2542 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			speed = std::stoi(value.get().toString());
															#line 16666 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2544 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		watchFuture = tr.watch(perpetualStorageWiggleKey);
															#line 2545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 2545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16674 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state = 2;
															#line 2545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorPerpetualStorageWiggleActor, 1, Void >*>(static_cast<MonitorPerpetualStorageWiggleActor*>(this)));
															#line 16679 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Standalone<StringRef>> && value,int loopDepth) 
	{
															#line 2541 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (value.present())
															#line 16688 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2542 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			speed = std::stoi(value.get().toString());
															#line 16692 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		}
															#line 2544 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		watchFuture = tr.watch(perpetualStorageWiggleKey);
															#line 2545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 2545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16700 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state = 2;
															#line 2545 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorPerpetualStorageWiggleActor, 1, Void >*>(static_cast<MonitorPerpetualStorageWiggleActor*>(this)));
															#line 16705 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Standalone<StringRef>> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Standalone<StringRef>> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state > 0) static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorPerpetualStorageWiggleActor*>(this)->ActorCallback< MonitorPerpetualStorageWiggleActor, 0, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorPerpetualStorageWiggleActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("monitorPerpetualStorageWiggle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorPerpetualStorageWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorPerpetualStorageWiggle", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorPerpetualStorageWiggleActor, 0, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("monitorPerpetualStorageWiggle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorPerpetualStorageWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorPerpetualStorageWiggle", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorPerpetualStorageWiggleActor, 0, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorPerpetualStorageWiggle", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorPerpetualStorageWiggleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorPerpetualStorageWiggle", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 2547 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		ASSERT(speed == 1 || speed == 0);
															#line 2548 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (speed == 1 && self->storageWiggler->isStopped())
															#line 16791 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
		{
															#line 2549 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			self->storageWiggler->setStopSignal(false);
															#line 2550 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->storageWiggler->restoreStats();
															#line 2550 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16799 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state = 3;
															#line 2550 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorPerpetualStorageWiggleActor, 2, Void >*>(static_cast<MonitorPerpetualStorageWiggleActor*>(this)));
															#line 16804 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 2556 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
			if (speed == 0)
															#line 16811 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
			{
															#line 2557 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
				if (!self->storageWiggler->isStopped())
															#line 16815 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
				{
															#line 2558 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					self->storageWiggler->setStopSignal(true);
															#line 2559 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					StrictFuture<Void> __when_expr_3 = collection.signalAndReset();
															#line 2559 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					if (static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16823 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when2(__when_expr_3.get(), loopDepth); };
					static_cast<MonitorPerpetualStorageWiggleActor*>(this)->actor_wait_state = 4;
															#line 2559 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorPerpetualStorageWiggleActor, 3, Void >*>(static_cast<MonitorPerpetualStorageWiggleActor*>(this)));
															#line 16828 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/build_output/fdbserver/DDTeamCollection.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1loopBody1cont9(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 2547 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		ASSERT(speed == 1 || speed == 0);
															#line 2548 "/codebuild/output/src2404251899/src/github.com/apple/foundationdb/fdbserver/DDTeamCollection.actor.cpp"
		if (speed == 1 && self->storageWiggler->isStopped