/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.util.Comparator;
import sun.misc.Unsafe;

abstract class FastByteComparisons {
    private static final int UNSIGNED_MASK = 255;

    FastByteComparisons() {
    }

    public static int compareTo(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return LexicographicalComparerHolder.BEST_COMPARER.compareTo(byArray, n, n2, byArray2, n3, n4);
    }

    public static Comparator<byte[]> comparator() {
        return LexicographicalComparerHolder.getBestComparer();
    }

    static Comparer<byte[]> lexicographicalComparerJavaImpl() {
        return LexicographicalComparerHolder.PureJavaComparer.INSTANCE;
    }

    static Comparer<byte[]> lexicographicalComparerUnsafeImpl() {
        return LexicographicalComparerHolder.UnsafeComparer.INSTANCE;
    }

    private static class LexicographicalComparerHolder {
        static final String UNSAFE_COMPARER_NAME = LexicographicalComparerHolder.class.getName() + "$UnsafeComparer";
        static final Comparer<byte[]> BEST_COMPARER = LexicographicalComparerHolder.getBestComparer();

        private LexicographicalComparerHolder() {
        }

        static Comparer<byte[]> getBestComparer() {
            boolean bl;
            String string = System.getProperty("os.arch");
            boolean bl2 = bl = string.equals("i386") || string.equals("x86") || string.equals("amd64") || string.equals("x86_64");
            if (!bl) {
                return FastByteComparisons.lexicographicalComparerJavaImpl();
            }
            try {
                Class<?> clazz = Class.forName(UNSAFE_COMPARER_NAME);
                Comparer comparer = (Comparer)clazz.getEnumConstants()[0];
                return comparer;
            }
            catch (Throwable throwable) {
                return FastByteComparisons.lexicographicalComparerJavaImpl();
            }
        }

        static enum UnsafeComparer implements Comparer<byte[]>
        {
            INSTANCE;

            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;
            static final boolean LITTLE_ENDIAN;

            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                return this.compareTo(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
            }

            @Override
            public int compareTo(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
                int n5;
                if (byArray == byArray2 && n == n3 && n2 == n4) {
                    return 0;
                }
                int n6 = Math.min(n2, n4);
                int n7 = n6 & 0xFFFFFFF8;
                long l = n + BYTE_ARRAY_BASE_OFFSET;
                long l2 = n3 + BYTE_ARRAY_BASE_OFFSET;
                for (n5 = 0; n5 < n7; n5 += 8) {
                    long l3;
                    long l4 = theUnsafe.getLong(byArray, l + (long)n5);
                    if (l4 == (l3 = theUnsafe.getLong(byArray2, l2 + (long)n5))) continue;
                    if (!LITTLE_ENDIAN) {
                        return l4 + Long.MIN_VALUE < l3 + Long.MIN_VALUE ? -1 : 1;
                    }
                    int n8 = Long.numberOfTrailingZeros(l4 ^ l3) & 0xFFFFFFF8;
                    return (int)(l4 >>> n8 & 0xFFL) - (int)(l3 >>> n8 & 0xFFL);
                }
                while (n5 < n6) {
                    int n9 = byArray[n + n5] & 0xFF;
                    int n10 = byArray2[n3 + n5] & 0xFF;
                    if (n9 != n10) {
                        return n9 - n10;
                    }
                    ++n5;
                }
                return n2 - n4;
            }

            static {
                theUnsafe = (Unsafe)AccessController.doPrivileged(() -> {
                    try {
                        Field field = Unsafe.class.getDeclaredField("theUnsafe");
                        field.setAccessible(true);
                        return field.get(null);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new Error();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error();
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
                LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
            }
        }

        static enum PureJavaComparer implements Comparer<byte[]>
        {
            INSTANCE;


            @Override
            public int compareTo(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
                if (byArray == byArray2 && n == n3 && n2 == n4) {
                    return 0;
                }
                int n5 = n + n2;
                int n6 = n3 + n4;
                int n7 = n;
                for (int i = n3; n7 < n5 && i < n6; ++n7, ++i) {
                    int n8 = byArray[n7] & 0xFF;
                    int n9 = byArray2[i] & 0xFF;
                    if (n8 == n9) continue;
                    return n8 - n9;
                }
                return n2 - n4;
            }

            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                return this.compareTo(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
            }
        }
    }

    static interface Comparer<T>
    extends Comparator<T> {
        public int compareTo(T var1, int var2, int var3, T var4, int var5, int var6);
    }
}

