#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
/*
 * GetTenantGroup.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_GETTENANTGROUP_ACTOR_G_H)
#define METACLUSTER_GETTENANTGROUP_ACTOR_G_H
#include "metacluster/GetTenantGroup.actor.g.h"
#elif !defined(METACLUSTER_GETTENANTGROUP_ACTOR_H)
#define METACLUSTER_GETTENANTGROUP_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

template <class Transaction>
Future<Optional<MetaclusterTenantGroupEntry>> tryGetTenantGroupTransaction(Transaction tr, TenantGroupName name) {
	CODE_PROBE(true, "Try get tenant group");
	tr->setOption(FDBTransactionOptions::RAW_ACCESS);
	return metadata::management::tenantMetadata().tenantGroupMap.get(tr, name);
}

															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
// This generated class is to be used only via tryGetTenantGroup()
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
template <class DB, class TryGetTenantGroupActor>
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
class TryGetTenantGroupActorState {
															#line 53 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
public:
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
	TryGetTenantGroupActorState(Reference<DB> const& db,TenantGroupName const& name) 
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
		 : db(db),
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
		   name(name),
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
		   tr(db->createTransaction())
															#line 64 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
	{
		fdb_probe_actor_create("tryGetTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	~TryGetTenantGroupActorState() 
	{
		fdb_probe_actor_destroy("tryGetTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			;
															#line 79 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetTenantGroupActorState();
		static_cast<TryGetTenantGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 51 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 52 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 53 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			StrictFuture<Optional<MetaclusterTenantGroupEntry>> __when_expr_0 = tryGetTenantGroupTransaction(tr, name);
															#line 53 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			if (static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 116 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state = 1;
															#line 53 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantGroupActor, 0, Optional<MetaclusterTenantGroupEntry> >*>(static_cast<TryGetTenantGroupActor*>(this)));
															#line 121 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			if (static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 145 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state = 2;
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantGroupActor, 1, Void >*>(static_cast<TryGetTenantGroupActor*>(this)));
															#line 150 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<MetaclusterTenantGroupEntry> const& entry,int loopDepth) 
	{
															#line 54 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
		if (!static_cast<TryGetTenantGroupActor*>(this)->SAV<Optional<MetaclusterTenantGroupEntry>>::futures) { (void)(entry); this->~TryGetTenantGroupActorState(); static_cast<TryGetTenantGroupActor*>(this)->destroy(); return 0; }
															#line 165 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
		new (&static_cast<TryGetTenantGroupActor*>(this)->SAV< Optional<MetaclusterTenantGroupEntry> >::value()) Optional<MetaclusterTenantGroupEntry>(entry);
		this->~TryGetTenantGroupActorState();
		static_cast<TryGetTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<MetaclusterTenantGroupEntry> && entry,int loopDepth) 
	{
															#line 54 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
		if (!static_cast<TryGetTenantGroupActor*>(this)->SAV<Optional<MetaclusterTenantGroupEntry>>::futures) { (void)(entry); this->~TryGetTenantGroupActorState(); static_cast<TryGetTenantGroupActor*>(this)->destroy(); return 0; }
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
		new (&static_cast<TryGetTenantGroupActor*>(this)->SAV< Optional<MetaclusterTenantGroupEntry> >::value()) Optional<MetaclusterTenantGroupEntry>(entry);
		this->~TryGetTenantGroupActorState();
		static_cast<TryGetTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterTenantGroupEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterTenantGroupEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantGroupActor*>(this)->ActorCallback< TryGetTenantGroupActor, 0, Optional<MetaclusterTenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantGroupActor, 0, Optional<MetaclusterTenantGroupEntry> >*,Optional<MetaclusterTenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetTenantGroupActor, 0, Optional<MetaclusterTenantGroupEntry> >*,Optional<MetaclusterTenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetTenantGroupActor, 0, Optional<MetaclusterTenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantGroupActor*>(this)->ActorCallback< TryGetTenantGroupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantGroupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetTenantGroupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetTenantGroupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
	Reference<DB> db;
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
	TenantGroupName name;
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 353 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
};
// This generated class is to be used only via tryGetTenantGroup()
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
template <class DB>
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
class TryGetTenantGroupActor final : public Actor<Optional<MetaclusterTenantGroupEntry>>, public ActorCallback< TryGetTenantGroupActor<DB>, 0, Optional<MetaclusterTenantGroupEntry> >, public ActorCallback< TryGetTenantGroupActor<DB>, 1, Void >, public FastAllocated<TryGetTenantGroupActor<DB>>, public TryGetTenantGroupActorState<DB, TryGetTenantGroupActor<DB>> {
															#line 360 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
public:
	using FastAllocated<TryGetTenantGroupActor<DB>>::operator new;
	using FastAllocated<TryGetTenantGroupActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17594371686778700288UL, 5614783379486864128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<MetaclusterTenantGroupEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetTenantGroupActor<DB>, 0, Optional<MetaclusterTenantGroupEntry> >;
friend struct ActorCallback< TryGetTenantGroupActor<DB>, 1, Void >;
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
	TryGetTenantGroupActor(Reference<DB> const& db,TenantGroupName const& name) 
															#line 378 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
		 : Actor<Optional<MetaclusterTenantGroupEntry>>(),
		   TryGetTenantGroupActorState<DB, TryGetTenantGroupActor<DB>>(db, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9003815954795149312UL, 16597353401135093248UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetTenantGroup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetTenantGroupActor<DB>, 0, Optional<MetaclusterTenantGroupEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetTenantGroupActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
template <class DB>
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
[[nodiscard]] Future<Optional<MetaclusterTenantGroupEntry>> tryGetTenantGroup( Reference<DB> const& db, TenantGroupName const& name ) {
															#line 45 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"
	return Future<Optional<MetaclusterTenantGroupEntry>>(new TryGetTenantGroupActor<DB>(db, name));
															#line 413 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/GetTenantGroup.actor.g.h"
}

#line 60 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/include/metacluster/GetTenantGroup.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif