#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
/*
 * MetaclusterUtil.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"

#include "metacluster/CreateMetacluster.actor.h"
#include "metacluster/MetaclusterUtil.actor.h"
#include "metacluster/RegisterCluster.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster::util {

std::pair<ClusterUsage, ClusterUsage> metaclusterCapacity(std::map<ClusterName, DataClusterMetadata> const& clusters) {
	ClusterUsage tenantGroupCapacity;
	ClusterUsage tenantGroupsAllocated;
	for (auto cluster : clusters) {
		tenantGroupCapacity.numTenantGroups +=
		    std::max(cluster.second.entry.capacity.numTenantGroups, cluster.second.entry.allocated.numTenantGroups);
		tenantGroupsAllocated.numTenantGroups += cluster.second.entry.allocated.numTenantGroups;
	}
	return { tenantGroupCapacity, tenantGroupsAllocated };
}

															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
// This generated class is to be used only via openDatabase()
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
template <class OpenDatabaseActor>
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
class OpenDatabaseActorState {
															#line 55 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
public:
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	OpenDatabaseActorState(ClusterConnectionString const& connectionString) 
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		 : connectionString(connectionString)
															#line 62 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("openDatabase", reinterpret_cast<unsigned long>(this));

	}
	~OpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("openDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 48 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			if (g_network->isSimulated())
															#line 77 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			{
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				Reference<IClusterConnectionRecord> clusterFile = makeReference<ClusterConnectionMemoryRecord>(connectionString);
															#line 51 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				Database nativeDb = Database::createDatabase(clusterFile, ApiVersion::LATEST_VERSION);
															#line 52 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				StrictFuture<Reference<IDatabase>> __when_expr_0 = unsafeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(nativeDb));
															#line 52 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 87 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 52 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 92 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 57 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				if (!static_cast<OpenDatabaseActor*>(this)->SAV<Reference<IDatabase>>::futures) { (void)(MultiVersionApi::api->createDatabaseFromConnectionString(connectionString.toString().c_str())); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 99 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
				new (&static_cast<OpenDatabaseActor*>(this)->SAV< Reference<IDatabase> >::value()) Reference<IDatabase>(MultiVersionApi::api->createDatabaseFromConnectionString(connectionString.toString().c_str()));
				this->~OpenDatabaseActorState();
				static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IDatabase> const& threadSafeDb,int loopDepth) 
	{
															#line 54 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		MultiVersionApi::api->selectApiVersion(ApiVersion::LATEST_VERSION);
															#line 55 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (!static_cast<OpenDatabaseActor*>(this)->SAV<Reference<IDatabase>>::futures) { (void)(MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeDb)); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 128 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		new (&static_cast<OpenDatabaseActor*>(this)->SAV< Reference<IDatabase> >::value()) Reference<IDatabase>(MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeDb));
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IDatabase> && threadSafeDb,int loopDepth) 
	{
															#line 54 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		MultiVersionApi::api->selectApiVersion(ApiVersion::LATEST_VERSION);
															#line 55 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (!static_cast<OpenDatabaseActor*>(this)->SAV<Reference<IDatabase>>::futures) { (void)(MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeDb)); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 142 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		new (&static_cast<OpenDatabaseActor*>(this)->SAV< Reference<IDatabase> >::value()) Reference<IDatabase>(MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeDb));
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& threadSafeDb,int loopDepth) 
	{
		loopDepth = a_body1cont2(threadSafeDb, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && threadSafeDb,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(threadSafeDb), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<OpenDatabaseActor*>(this)->ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	ClusterConnectionString connectionString;
															#line 227 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
};
// This generated class is to be used only via openDatabase()
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
class OpenDatabaseActor final : public Actor<Reference<IDatabase>>, public ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >, public FastAllocated<OpenDatabaseActor>, public OpenDatabaseActorState<OpenDatabaseActor> {
															#line 232 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
public:
	using FastAllocated<OpenDatabaseActor>::operator new;
	using FastAllocated<OpenDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6979135158342132992UL, 12083676356926735360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<IDatabase>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >;
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	OpenDatabaseActor(ClusterConnectionString const& connectionString) 
															#line 249 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		 : Actor<Reference<IDatabase>>(),
		   OpenDatabaseActorState<OpenDatabaseActor>(connectionString),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17000073936038550016UL, 17255821604456520192UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("openDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OpenDatabaseActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
[[nodiscard]] Future<Reference<IDatabase>> openDatabase( ClusterConnectionString const& connectionString ) {
															#line 47 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	return Future<Reference<IDatabase>>(new OpenDatabaseActor(connectionString));
															#line 281 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
}

#line 60 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"

															#line 286 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
// This generated class is to be used only via createSimulatedMetacluster()
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
template <class CreateSimulatedMetaclusterActor>
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
class CreateSimulatedMetaclusterActorState {
															#line 292 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
public:
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	CreateSimulatedMetaclusterActorState(Database const& db,Optional<int64_t> const& tenantIdPrefix,Optional<DataClusterEntry> const& dataClusterConfig,SkipMetaclusterCreation const& skipMetaclusterCreation) 
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		 : db(db),
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		   tenantIdPrefix(tenantIdPrefix),
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		   dataClusterConfig(dataClusterConfig),
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		   skipMetaclusterCreation(skipMetaclusterCreation)
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this));

	}
	~CreateSimulatedMetaclusterActorState() 
	{
		fdb_probe_actor_destroy("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 65 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 66 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			simMetacluster = SimulatedMetacluster();
															#line 68 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			StrictFuture<Reference<IDatabase>> __when_expr_0 = unsafeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(db));
															#line 68 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 326 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 1;
															#line 68 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateSimulatedMetaclusterActor, 0, Reference<IDatabase> >*>(static_cast<CreateSimulatedMetaclusterActor*>(this)));
															#line 331 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateSimulatedMetaclusterActorState();
		static_cast<CreateSimulatedMetaclusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> const& threadSafeHandle,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		MultiVersionApi::api->selectApiVersion(db->apiVersion.version());
															#line 72 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		simMetacluster.managementDb = MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeHandle);
															#line 74 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (!skipMetaclusterCreation)
															#line 358 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		{
															#line 75 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			if (!tenantIdPrefix.present())
															#line 362 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			{
															#line 76 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				tenantIdPrefix = deterministicRandom()->randomInt(TenantAPI::TENANT_ID_PREFIX_MIN_VALUE, TenantAPI::TENANT_ID_PREFIX_MAX_VALUE + 1);
															#line 366 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			}
															#line 79 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(createMetacluster(db.getReference(), "management_cluster"_sr, tenantIdPrefix.get(), false));
															#line 79 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 372 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 79 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >*>(static_cast<CreateSimulatedMetaclusterActor*>(this)));
															#line 377 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> && threadSafeHandle,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		MultiVersionApi::api->selectApiVersion(db->apiVersion.version());
															#line 72 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		simMetacluster.managementDb = MultiVersionDatabase::debugCreateFromExistingDatabase(threadSafeHandle);
															#line 74 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (!skipMetaclusterCreation)
															#line 395 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		{
															#line 75 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			if (!tenantIdPrefix.present())
															#line 399 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			{
															#line 76 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
				tenantIdPrefix = deterministicRandom()->randomInt(TenantAPI::TENANT_ID_PREFIX_MIN_VALUE, TenantAPI::TENANT_ID_PREFIX_MAX_VALUE + 1);
															#line 403 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			}
															#line 79 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(createMetacluster(db.getReference(), "management_cluster"_sr, tenantIdPrefix.get(), false));
															#line 79 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 409 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 79 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >*>(static_cast<CreateSimulatedMetaclusterActor*>(this)));
															#line 414 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& threadSafeHandle,int loopDepth) 
	{
		loopDepth = a_body1cont1(threadSafeHandle, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && threadSafeHandle,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(threadSafeHandle), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateSimulatedMetaclusterActor*>(this)->ActorCallback< CreateSimulatedMetaclusterActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateSimulatedMetaclusterActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateSimulatedMetaclusterActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateSimulatedMetaclusterActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 82 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		metacluster::DataClusterEntry entry;
															#line 83 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		entry.capacity.numTenantGroups = 1e9;
															#line 85 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		clusterIndex = int();
															#line 86 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		clusterIndex = 0;
															#line 509 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateSimulatedMetaclusterActor*>(this)->ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 107 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (!static_cast<CreateSimulatedMetaclusterActor*>(this)->SAV<SimulatedMetacluster>::futures) { (void)(simMetacluster); this->~CreateSimulatedMetaclusterActorState(); static_cast<CreateSimulatedMetaclusterActor*>(this)->destroy(); return 0; }
															#line 605 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		new (&static_cast<CreateSimulatedMetaclusterActor*>(this)->SAV< SimulatedMetacluster >::value()) SimulatedMetacluster(std::move(simMetacluster)); // state_var_RVO
		this->~CreateSimulatedMetaclusterActorState();
		static_cast<CreateSimulatedMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 86 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (!(clusterIndex < g_simulator->extraDatabases.size()))
															#line 624 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 87 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		clusterName = ClusterNameRef(fmt::format("data_cluster_{}", clusterIndex));
															#line 89 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		simMetacluster.dataDbs[clusterName] = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[clusterIndex], db->defaultTenant);
															#line 92 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (dataClusterConfig.present())
															#line 634 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		{
															#line 93 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			StrictFuture<Void> __when_expr_2 = metacluster::registerCluster(simMetacluster.managementDb, clusterName, g_simulator->extraDatabases[clusterIndex], dataClusterConfig.get());
															#line 93 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 640 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 93 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateSimulatedMetaclusterActor, 2, Void >*>(static_cast<CreateSimulatedMetaclusterActor*>(this)));
															#line 645 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 86 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		++clusterIndex;
															#line 672 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		StrictFuture<Void> __when_expr_3 = runRYWTransactionVoid(simMetacluster.dataDbs[clusterName], [](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return success(tr->get("\xff"_sr)); });
															#line 99 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 683 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 4;
															#line 99 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >*>(static_cast<CreateSimulatedMetaclusterActor*>(this)));
															#line 688 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		StrictFuture<Void> __when_expr_3 = runRYWTransactionVoid(simMetacluster.dataDbs[clusterName], [](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return success(tr->get("\xff"_sr)); });
															#line 99 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 699 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 4;
															#line 99 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >*>(static_cast<CreateSimulatedMetaclusterActor*>(this)));
															#line 704 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateSimulatedMetaclusterActor*>(this)->ActorCallback< CreateSimulatedMetaclusterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateSimulatedMetaclusterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateSimulatedMetaclusterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateSimulatedMetaclusterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateSimulatedMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateSimulatedMetaclusterActor*>(this)->ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	Database db;
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	Optional<int64_t> tenantIdPrefix;
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	Optional<DataClusterEntry> dataClusterConfig;
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	SkipMetaclusterCreation skipMetaclusterCreation;
															#line 66 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	SimulatedMetacluster simMetacluster;
															#line 85 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	int clusterIndex;
															#line 87 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	ClusterName clusterName;
															#line 885 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
};
// This generated class is to be used only via createSimulatedMetacluster()
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
class CreateSimulatedMetaclusterActor final : public Actor<SimulatedMetacluster>, public ActorCallback< CreateSimulatedMetaclusterActor, 0, Reference<IDatabase> >, public ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >, public ActorCallback< CreateSimulatedMetaclusterActor, 2, Void >, public ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >, public FastAllocated<CreateSimulatedMetaclusterActor>, public CreateSimulatedMetaclusterActorState<CreateSimulatedMetaclusterActor> {
															#line 890 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
public:
	using FastAllocated<CreateSimulatedMetaclusterActor>::operator new;
	using FastAllocated<CreateSimulatedMetaclusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17600634591491675136UL, 7622541164098169344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<SimulatedMetacluster>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateSimulatedMetaclusterActor, 0, Reference<IDatabase> >;
friend struct ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >;
friend struct ActorCallback< CreateSimulatedMetaclusterActor, 2, Void >;
friend struct ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >;
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	CreateSimulatedMetaclusterActor(Database const& db,Optional<int64_t> const& tenantIdPrefix,Optional<DataClusterEntry> const& dataClusterConfig,SkipMetaclusterCreation const& skipMetaclusterCreation) 
															#line 910 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
		 : Actor<SimulatedMetacluster>(),
		   CreateSimulatedMetaclusterActorState<CreateSimulatedMetaclusterActor>(db, tenantIdPrefix, dataClusterConfig, skipMetaclusterCreation),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3279345212169916928UL, 1135923848158936064UL);
		ActorExecutionContextHelper __helper(static_cast<CreateSimulatedMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createSimulatedMetacluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createSimulatedMetacluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateSimulatedMetaclusterActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateSimulatedMetaclusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateSimulatedMetaclusterActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateSimulatedMetaclusterActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
[[nodiscard]] Future<SimulatedMetacluster> createSimulatedMetacluster( Database const& db, Optional<int64_t> const& tenantIdPrefix, Optional<DataClusterEntry> const& dataClusterConfig, SkipMetaclusterCreation const& skipMetaclusterCreation ) {
															#line 61 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"
	return Future<SimulatedMetacluster>(new CreateSimulatedMetaclusterActor(db, tenantIdPrefix, dataClusterConfig, skipMetaclusterCreation));
															#line 945 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/metacluster/MetaclusterUtil.actor.g.cpp"
}

#line 109 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/metacluster/MetaclusterUtil.actor.cpp"

}; // namespace metacluster::util