#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
/*
 * MetricLogging.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "flow/TDMetric.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct MetricLoggingWorkload : TestWorkload {
	static constexpr auto NAME = "MetricLogging";
	int actorCount, metricCount;
	double testDuration;
	bool testBool, enabled;

	std::vector<Future<Void>> clients;
	PerfIntCounter changes;
	std::vector<BoolMetricHandle> boolMetrics;
	std::vector<Int64MetricHandle> int64Metrics;

	MetricLoggingWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), changes("Changes") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		actorCount = getOption(options, "actorCount"_sr, 1);
		metricCount = getOption(options, "metricCount"_sr, 1);
		testBool = getOption(options, "testBool"_sr, true);
		enabled = getOption(options, "enabled"_sr, true);

		for (int i = 0; i < metricCount; i++) {
			if (testBool) {
				boolMetrics.push_back(BoolMetricHandle("TestBool"_sr, format("%d", i)));
			} else {
				int64Metrics.push_back(Int64MetricHandle("TestInt"_sr, format("%d", i)));
			}
		}
	}

	Future<Void> setup(Database const& cx) override { return _setup(this, cx); }

																#line 58 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
template <class _setupActor>
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
class _setupActorState {
															#line 64 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
public:
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	_setupActorState(MetricLoggingWorkload* const& self,Database const& cx) 
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		 : self(self),
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		   cx(cx)
															#line 73 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 57 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(2.0);
															#line 57 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 90 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 57 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 95 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 58 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		for(int i = 0;i < self->metricCount;i++) {
															#line 59 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
			if (self->testBool)
															#line 120 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			{
															#line 60 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
				self->boolMetrics[i]->setConfig(true);
															#line 124 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			}
			else
			{
															#line 62 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
				self->int64Metrics[i]->setConfig(true);
															#line 130 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			}
		}
															#line 65 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 135 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 58 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		for(int i = 0;i < self->metricCount;i++) {
															#line 59 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
			if (self->testBool)
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			{
															#line 60 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
				self->boolMetrics[i]->setConfig(true);
															#line 153 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			}
			else
			{
															#line 62 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
				self->int64Metrics[i]->setConfig(true);
															#line 159 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			}
		}
															#line 65 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 164 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	MetricLoggingWorkload* self;
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	Database cx;
															#line 251 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 256 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(204098769280783360UL, 4568348011897059584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	_setupActor(MetricLoggingWorkload* const& self,Database const& cx) 
															#line 273 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
[[nodiscard]] Future<Void> _setup( MetricLoggingWorkload* const& self, Database const& cx ) {
															#line 56 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
}

#line 67 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"

	Future<Void> start(Database const& cx) override {
		for (int c = 0; c < actorCount; c++)
			clients.push_back(timeout(MetricLoggingClient(cx, this, clientId, c), testDuration, Void()));
		return waitForAll(clients);
	}

	Future<bool> check(Database const& cx) override {
		clients.clear();
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(changes.getMetric());
		m.emplace_back("Changes/sec", changes.getValue() / testDuration, Averaged::False);
	}

																#line 326 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
// This generated class is to be used only via MetricLoggingClient()
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
template <class MetricLoggingClientActor>
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
class MetricLoggingClientActorState {
															#line 332 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
public:
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	MetricLoggingClientActorState(Database const& cx,MetricLoggingWorkload* const& self,int const& clientId,int const& actorId) 
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		 : cx(cx),
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		   self(self),
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		   clientId(clientId),
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		   actorId(actorId),
															#line 85 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		   writer(Unversioned())
															#line 347 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
	{
		fdb_probe_actor_create("MetricLoggingClient", reinterpret_cast<unsigned long>(this));

	}
	~MetricLoggingClientActorState() 
	{
		fdb_probe_actor_destroy("MetricLoggingClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 86 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
			;
															#line 362 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetricLoggingClientActorState();
		static_cast<MetricLoggingClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 87 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		for(int i = 0;i < 100;i++) {
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
			if (self->testBool)
															#line 394 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			{
															#line 89 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
				self->boolMetrics[self->changes.getValue() % self->metricCount]->toggle();
															#line 398 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			}
			else
			{
															#line 91 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
				self->int64Metrics[self->changes.getValue() % self->metricCount] = (self->changes.getValue());
															#line 404 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
			}
															#line 93 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
			++self->changes;
															#line 408 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
		}
															#line 95 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 95 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		if (static_cast<MetricLoggingClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 414 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MetricLoggingClientActor*>(this)->actor_wait_state = 1;
															#line 95 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetricLoggingClientActor, 0, Void >*>(static_cast<MetricLoggingClientActor*>(this)));
															#line 419 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetricLoggingClientActor*>(this)->actor_wait_state > 0) static_cast<MetricLoggingClientActor*>(this)->actor_wait_state = 0;
		static_cast<MetricLoggingClientActor*>(this)->ActorCallback< MetricLoggingClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetricLoggingClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("MetricLoggingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricLoggingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MetricLoggingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetricLoggingClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("MetricLoggingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricLoggingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MetricLoggingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetricLoggingClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("MetricLoggingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetricLoggingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("MetricLoggingClient", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	Database cx;
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	MetricLoggingWorkload* self;
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	int clientId;
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	int actorId;
															#line 85 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	BinaryWriter writer;
															#line 521 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
};
// This generated class is to be used only via MetricLoggingClient()
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
class MetricLoggingClientActor final : public Actor<Void>, public ActorCallback< MetricLoggingClientActor, 0, Void >, public FastAllocated<MetricLoggingClientActor>, public MetricLoggingClientActorState<MetricLoggingClientActor> {
															#line 526 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
public:
	using FastAllocated<MetricLoggingClientActor>::operator new;
	using FastAllocated<MetricLoggingClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10741615607119059200UL, 5595335429215461376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetricLoggingClientActor, 0, Void >;
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	MetricLoggingClientActor(Database const& cx,MetricLoggingWorkload* const& self,int const& clientId,int const& actorId) 
															#line 543 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
		 : Actor<Void>(),
		   MetricLoggingClientActorState<MetricLoggingClientActor>(cx, self, clientId, actorId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("MetricLoggingClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2625198011588454656UL, 15662737101651321600UL);
		ActorExecutionContextHelper __helper(static_cast<MetricLoggingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("MetricLoggingClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("MetricLoggingClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetricLoggingClientActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
[[nodiscard]] Future<Void> MetricLoggingClient( Database const& cx, MetricLoggingWorkload* const& self, int const& clientId, int const& actorId ) {
															#line 84 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
	return Future<Void>(new MetricLoggingClientActor(cx, self, clientId, actorId));
															#line 575 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetricLogging.actor.g.cpp"
}

#line 98 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/workloads/MetricLogging.actor.cpp"
};

WorkloadFactory<MetricLoggingWorkload> MetricLoggingWorkloadFactory;
