#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
/*
 * AsyncFile.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(WORKLOADS_ASYNCFILE_ACTOR_G_H)
#define WORKLOADS_ASYNCFILE_ACTOR_G_H
#include "fdbserver/workloads/AsyncFile.actor.g.h"
#elif !defined(WORKLOADS_ASYNCFILE_ACTOR_H)
#define WORKLOADS_ASYNCFILE_ACTOR_H

#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IAsyncFile.h"
#include "flow/actorcompiler.h" // This must be the last #include.

class RandomByteGenerator {
private:
	char* b1;
	int BUF_SIZE;

public:
	RandomByteGenerator();
	~RandomByteGenerator();
	void writeRandomBytesToBuffer(void* buf, int bytes);
};

struct AsyncFileBuffer : public ReferenceCounted<AsyncFileBuffer> {
	AsyncFileBuffer(size_t size, bool aligned);
	virtual ~AsyncFileBuffer();

	unsigned char* buffer;
	bool aligned;
};

struct AsyncFileHandle : public ReferenceCounted<AsyncFileHandle> {
	AsyncFileHandle(Reference<IAsyncFile> file, std::string path, bool temporary);
	virtual ~AsyncFileHandle();

	Reference<IAsyncFile> file;
	std::string path;
	bool temporary;
};

struct AsyncFileWorkload : TestWorkload {
	static const int _PAGE_SIZE;

	// If true, then the underlying AsyncFile will be assumed to be performing unbuffered IO, which requires special
	// alignments
	bool unbufferedIO;
	bool uncachedIO;
	bool fillRandom;
	bool enabled;
	double testDuration;

	Reference<AsyncFileHandle> fileHandle;
	int64_t fileSize;

	std::string path;

	AsyncFileWorkload(WorkloadContext const&);
	~AsyncFileWorkload() override {}

	// Allocates a buffer of a given size.  If necessary, the buffer will be aligned to 4K
	Reference<AsyncFileBuffer> allocateBuffer(size_t size);

	Future<bool> check(Database const& cx) override;

	// Opens a file for AsyncFile operations.  If the path is empty, then creates a file and fills it with random data
																#line 90 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
// This generated class is to be used only via openFile()
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
template <class OpenFileActor>
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
class OpenFileActorState {
															#line 96 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
public:
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	OpenFileActorState(AsyncFileWorkload* const& self,int64_t const& flags,int64_t const& mode,uint64_t const& size,bool const& fillFile = false) 
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		 : self(self),
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		   flags(flags),
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		   mode(mode),
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		   size(size),
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		   fillFile(fillFile),
															#line 93 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		   rbg()
															#line 113 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
	{
		fdb_probe_actor_create("openFile", reinterpret_cast<unsigned long>(this));

	}
	~OpenFileActorState() 
	{
		fdb_probe_actor_destroy("openFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			if (self->fileHandle.getPtr() != nullptr)
															#line 128 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			{
															#line 96 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
				self->fileHandle->file = Reference<IAsyncFile>(nullptr);
															#line 97 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
				StrictFuture<Void> __when_expr_0 = delay(0.1);
															#line 97 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
				if (static_cast<OpenFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 136 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<OpenFileActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OpenFileActor, 0, Void >*>(static_cast<OpenFileActor*>(this)));
															#line 141 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OpenFileActorState();
		static_cast<OpenFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 100 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		fileCreated = self->path.length() == 0;
															#line 101 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (fileCreated)
															#line 171 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
															#line 102 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			self->path = "asyncfile." + deterministicRandom()->randomUniqueID().toString();
															#line 103 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			flags &= ~IAsyncFile::OPEN_READONLY;
															#line 104 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			flags |= IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE;
															#line 179 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		}
		else
		{
															#line 105 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			if (fillFile)
															#line 185 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			{
															#line 106 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
				flags &= ~IAsyncFile::OPEN_READONLY;
															#line 107 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
				flags |= IAsyncFile::OPEN_READWRITE;
															#line 191 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			}
		}
															#line 110 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (self->unbufferedIO)
															#line 196 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
															#line 111 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			flags |= IAsyncFile::OPEN_UNBUFFERED;
															#line 200 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		}
															#line 112 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (self->uncachedIO)
															#line 204 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
															#line 113 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			flags |= IAsyncFile::OPEN_UNCACHED;
															#line 208 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		}
		try {
															#line 116 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open(self->path, flags, 0666);
															#line 116 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			if (static_cast<OpenFileActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 215 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<OpenFileActor*>(this)->actor_wait_state = 2;
															#line 116 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OpenFileActor, 1, Reference<IAsyncFile> >*>(static_cast<OpenFileActor*>(this)));
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OpenFileActor*>(this)->actor_wait_state > 0) static_cast<OpenFileActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFileActor*>(this)->ActorCallback< OpenFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OpenFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (!static_cast<OpenFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OpenFileActorState(); static_cast<OpenFileActor*>(this)->destroy(); return 0; }
															#line 322 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		new (&static_cast<OpenFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OpenFileActorState();
		static_cast<OpenFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& error,int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			TraceEvent(SevError, "TestFailure").detail("Reason", "Could not open file");
															#line 146 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			return a_body1Catch1(error, loopDepth);
															#line 337 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 117 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (self->fileHandle.getPtr() == nullptr)
															#line 351 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
															#line 118 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			self->fileHandle = makeReference<AsyncFileHandle>(file, self->path, fileCreated);
															#line 355 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		}
		else
		{
															#line 120 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			self->fileHandle->file = file;
															#line 361 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		}
															#line 122 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (fileCreated || fillFile)
															#line 365 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			StrictFuture<int64_t> __when_expr_2 = file->size();
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			if (static_cast<OpenFileActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 371 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont9when1(__when_expr_2.get(), loopDepth); };
			static_cast<OpenFileActor*>(this)->actor_wait_state = 3;
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OpenFileActor, 2, int64_t >*>(static_cast<OpenFileActor*>(this)));
															#line 376 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 116 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		file = __file;
															#line 390 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OpenFileActor*>(this)->actor_wait_state > 0) static_cast<OpenFileActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFileActor*>(this)->ActorCallback< OpenFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OpenFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 124 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		newSize = (size + _PAGE_SIZE - 1) & ~(int64_t(_PAGE_SIZE - 1));
															#line 126 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (!fileCreated)
															#line 477 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
															#line 127 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			StrictFuture<Void> __when_expr_3 = file->truncate(newSize);
															#line 127 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			if (static_cast<OpenFileActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 483 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont13when1(__when_expr_3.get(), loopDepth); };
			static_cast<OpenFileActor*>(this)->actor_wait_state = 4;
															#line 127 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< OpenFileActor, 3, Void >*>(static_cast<OpenFileActor*>(this)));
															#line 488 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9when1(int64_t const& __oldSize,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		oldSize = __oldSize;
															#line 502 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(int64_t && __oldSize,int loopDepth) 
	{
		oldSize = std::move(__oldSize);
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<OpenFileActor*>(this)->actor_wait_state > 0) static_cast<OpenFileActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFileActor*>(this)->ActorCallback< OpenFileActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OpenFileActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont13cont1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		chunkSize = 4 << 16;
															#line 130 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		data = self->allocateBuffer(chunkSize);
															#line 131 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		i = int64_t();
															#line 132 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		lastWrite = Void();
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		i = oldSize & ~(chunkSize - 1);
															#line 589 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		loopDepth = a_body1cont13cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<OpenFileActor*>(this)->actor_wait_state > 0) static_cast<OpenFileActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFileActor*>(this)->ActorCallback< OpenFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< OpenFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13cont3(int loopDepth) 
	{
															#line 142 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		StrictFuture<Void> __when_expr_5 = lastWrite;
															#line 142 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (static_cast<OpenFileActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 687 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont13cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<OpenFileActor*>(this)->actor_wait_state = 6;
															#line 142 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< OpenFileActor, 5, Void >*>(static_cast<OpenFileActor*>(this)));
															#line 692 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1(int loopDepth) 
	{
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (!(i < newSize))
															#line 708 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
			return a_body1cont13cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 134 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (i >> 30 != (i + (chunkSize)) >> 30)
															#line 714 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
															#line 135 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			printf("Building test file: %d GB\n", int((i + (chunkSize)) >> 30));
															#line 718 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		}
															#line 136 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (self->fillRandom)
															#line 722 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		{
															#line 137 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
			rbg.writeRandomBytesToBuffer(data->buffer, chunkSize);
															#line 726 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		}
															#line 138 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		auto w = lastWrite;
															#line 139 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		lastWrite = file->write(data->buffer, chunkSize, i);
															#line 140 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		StrictFuture<Void> __when_expr_4 = w;
															#line 140 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		if (static_cast<OpenFileActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 736 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13cont1loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<OpenFileActor*>(this)->actor_wait_state = 5;
															#line 140 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< OpenFileActor, 4, Void >*>(static_cast<OpenFileActor*>(this)));
															#line 741 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		i += chunkSize;
															#line 763 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		if (loopDepth == 0) return a_body1cont13cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
		i += chunkSize;
															#line 772 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		if (loopDepth == 0) return a_body1cont13cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<OpenFileActor*>(this)->actor_wait_state > 0) static_cast<OpenFileActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFileActor*>(this)->ActorCallback< OpenFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< OpenFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont13cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<OpenFileActor*>(this)->actor_wait_state > 0) static_cast<OpenFileActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFileActor*>(this)->ActorCallback< OpenFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont13cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< OpenFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont13cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< OpenFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	AsyncFileWorkload* self;
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	int64_t flags;
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	int64_t mode;
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	uint64_t size;
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	bool fillFile;
															#line 93 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	RandomByteGenerator rbg;
															#line 100 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	bool fileCreated;
															#line 116 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	Reference<IAsyncFile> file;
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	int64_t oldSize;
															#line 124 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	int64_t newSize;
															#line 129 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	int chunkSize;
															#line 130 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	Reference<AsyncFileBuffer> data;
															#line 131 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	int64_t i;
															#line 132 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	Future<Void> lastWrite;
															#line 980 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
};
// This generated class is to be used only via openFile()
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
class OpenFileActor final : public Actor<Void>, public ActorCallback< OpenFileActor, 0, Void >, public ActorCallback< OpenFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< OpenFileActor, 2, int64_t >, public ActorCallback< OpenFileActor, 3, Void >, public ActorCallback< OpenFileActor, 4, Void >, public ActorCallback< OpenFileActor, 5, Void >, public FastAllocated<OpenFileActor>, public OpenFileActorState<OpenFileActor> {
															#line 985 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
public:
	using FastAllocated<OpenFileActor>::operator new;
	using FastAllocated<OpenFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(478745314720995584UL, 13725889825537308160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OpenFileActor, 0, Void >;
friend struct ActorCallback< OpenFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< OpenFileActor, 2, int64_t >;
friend struct ActorCallback< OpenFileActor, 3, Void >;
friend struct ActorCallback< OpenFileActor, 4, Void >;
friend struct ActorCallback< OpenFileActor, 5, Void >;
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	OpenFileActor(AsyncFileWorkload* const& self,int64_t const& flags,int64_t const& mode,uint64_t const& size,bool const& fillFile = false) 
															#line 1007 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
		 : Actor<Void>(),
		   OpenFileActorState<OpenFileActor>(self, flags, mode, size, fillFile),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("openFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16579432253503421440UL, 8133905898635695872UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("openFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("openFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OpenFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OpenFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< OpenFileActor, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< OpenFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< OpenFileActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< OpenFileActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
[[nodiscard]] Future<Void> openFile( AsyncFileWorkload* const& self, int64_t const& flags, int64_t const& mode, uint64_t const& size, bool const& fillFile = false ) {
															#line 88 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
	return Future<Void>(new OpenFileActor(self, flags, mode, size, fillFile));
															#line 1044 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/AsyncFile.actor.g.h"
}

#line 151 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/AsyncFile.actor.h"
};

#include "flow/unactorcompiler.h"
#endif
