#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
/*
 * Coordination.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>

#include "fdbclient/ConfigTransactionInterface.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/ConfigNode.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/OnDemandStore.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/Status.actor.h"
#include "flow/ActorCollection.h"
#include "flow/ProtocolVersion.h"
#include "flow/UnitTest.h"
#include "flow/IndexedSet.h"
#include "fdbclient/MonitorLeader.h"
#include "flow/network.h"

#include "flow/actorcompiler.h" // This must be the last #include.

// This module implements coordinationServer() and the interfaces in CoordinationInterface.h

namespace {

const std::string fileCoordinatorPrefix = "coordination-";

class LivenessChecker {
	double threshold;
	AsyncVar<double> lastTime;
																#line 51 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
// This generated class is to be used only via checkStuck()
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class CheckStuckActor>
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class CheckStuckActorState {
															#line 57 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	CheckStuckActorState(LivenessChecker const* const& self) 
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : self(self)
															#line 64 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("checkStuck", reinterpret_cast<unsigned long>(this));

	}
	~CheckStuckActorState() 
	{
		fdb_probe_actor_destroy("checkStuck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 50 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			;
															#line 79 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckStuckActorState();
		static_cast<CheckStuckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 52 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayUntil(self->lastTime.get() + self->threshold);
															#line 51 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<CheckStuckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 111 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 55 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->lastTime.onChange();
															#line 115 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<CheckStuckActor*>(this)->actor_wait_state = 1;
															#line 52 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckStuckActor, 0, Void >*>(static_cast<CheckStuckActor*>(this)));
															#line 55 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckStuckActor, 1, Void >*>(static_cast<CheckStuckActor*>(this)));
															#line 122 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 53 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<CheckStuckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckStuckActorState(); static_cast<CheckStuckActor*>(this)->destroy(); return 0; }
															#line 137 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<CheckStuckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckStuckActorState();
		static_cast<CheckStuckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 53 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<CheckStuckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckStuckActorState(); static_cast<CheckStuckActor*>(this)->destroy(); return 0; }
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<CheckStuckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckStuckActorState();
		static_cast<CheckStuckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckStuckActor*>(this)->actor_wait_state > 0) static_cast<CheckStuckActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStuckActor*>(this)->ActorCallback< CheckStuckActor, 0, Void >::remove();
		static_cast<CheckStuckActor*>(this)->ActorCallback< CheckStuckActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStuckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkStuck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStuckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStuck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckStuckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkStuck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStuckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStuck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckStuckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkStuck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStuckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStuck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckStuckActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkStuck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStuckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStuck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckStuckActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkStuck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStuckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStuck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckStuckActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkStuck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStuckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStuck", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LivenessChecker const* self;
															#line 292 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via checkStuck()
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class CheckStuckActor final : public Actor<Void>, public ActorCallback< CheckStuckActor, 0, Void >, public ActorCallback< CheckStuckActor, 1, Void >, public FastAllocated<CheckStuckActor>, public CheckStuckActorState<CheckStuckActor> {
															#line 297 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<CheckStuckActor>::operator new;
	using FastAllocated<CheckStuckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6678581195532365568UL, 3478683460152281088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckStuckActor, 0, Void >;
friend struct ActorCallback< CheckStuckActor, 1, Void >;
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	CheckStuckActor(LivenessChecker const* const& self) 
															#line 315 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   CheckStuckActorState<CheckStuckActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkStuck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4028040831608131328UL, 902977986269445120UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStuckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkStuck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkStuck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckStuckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] static Future<Void> checkStuck( LivenessChecker const* const& self ) {
															#line 49 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new CheckStuckActor(self));
															#line 347 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 59 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

public:
	explicit LivenessChecker(double threshold) : threshold(threshold), lastTime(now()) {}

	void confirmLiveness() { lastTime.set(now()); }

	Future<Void> checkStuck() const { return checkStuck(this); }
};

} // namespace

struct GenerationRegVal {
	UniqueGeneration readGen, writeGen;
	Optional<Value> val;

	// To change this serialization, ProtocolVersion::GenerationRegVal must be updated, and downgrades need to be
	// considered
	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, readGen, writeGen, val);
	}
};

GenerationRegInterface::GenerationRegInterface(NetworkAddress const& remote)
  : read(Endpoint::wellKnown({ remote }, WLTOKEN_GENERATIONREG_READ)),
    write(Endpoint::wellKnown({ remote }, WLTOKEN_GENERATIONREG_WRITE)) {}

GenerationRegInterface::GenerationRegInterface(INetwork* local) {
	read.makeWellKnownEndpoint(WLTOKEN_GENERATIONREG_READ, TaskPriority::Coordination);
	write.makeWellKnownEndpoint(WLTOKEN_GENERATIONREG_WRITE, TaskPriority::Coordination);
}

LeaderElectionRegInterface::LeaderElectionRegInterface(NetworkAddress const& remote)
  : ClientLeaderRegInterface(remote), candidacy(Endpoint::wellKnown({ remote }, WLTOKEN_LEADERELECTIONREG_CANDIDACY)),
    electionResult(Endpoint::wellKnown({ remote }, WLTOKEN_LEADERELECTIONREG_ELECTIONRESULT)),
    leaderHeartbeat(Endpoint::wellKnown({ remote }, WLTOKEN_LEADERELECTIONREG_LEADERHEARTBEAT)),
    forward(Endpoint::wellKnown({ remote }, WLTOKEN_LEADERELECTIONREG_FORWARD)) {}

LeaderElectionRegInterface::LeaderElectionRegInterface(INetwork* local) : ClientLeaderRegInterface(local) {
	candidacy.makeWellKnownEndpoint(WLTOKEN_LEADERELECTIONREG_CANDIDACY, TaskPriority::Coordination);
	electionResult.makeWellKnownEndpoint(WLTOKEN_LEADERELECTIONREG_ELECTIONRESULT, TaskPriority::Coordination);
	leaderHeartbeat.makeWellKnownEndpoint(WLTOKEN_LEADERELECTIONREG_LEADERHEARTBEAT, TaskPriority::Coordination);
	forward.makeWellKnownEndpoint(WLTOKEN_LEADERELECTIONREG_FORWARD, TaskPriority::Coordination);
}

ServerCoordinators::ServerCoordinators(Reference<IClusterConnectionRecord> ccr, ConfigDBType configDBType)
  : ClientCoordinators(ccr) {
	ClusterConnectionString cs = ccr->getConnectionString();
	for (auto h : cs.hostnames) {
		leaderElectionServers.emplace_back(h);
		stateServers.emplace_back(h);
		if (configDBType != ConfigDBType::DISABLED) {
			configServers.emplace_back(h);
		}
	}
	for (auto s : cs.coords) {
		leaderElectionServers.emplace_back(s);
		stateServers.emplace_back(s);
		if (configDBType != ConfigDBType::DISABLED) {
			configServers.emplace_back(s);
		}
	}
}

															#line 415 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
namespace {
// This generated class is to be used only via localGenerationReg()
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class LocalGenerationRegActor>
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class LocalGenerationRegActorState {
															#line 422 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LocalGenerationRegActorState(GenerationRegInterface const& interf,OnDemandStore* const& pstore) 
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : interf(interf),
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   pstore(pstore),
															#line 124 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   v(),
															#line 125 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   store(*pstore)
															#line 435 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("localGenerationReg", reinterpret_cast<unsigned long>(this));

	}
	~LocalGenerationRegActorState() 
	{
		fdb_probe_actor_destroy("localGenerationReg", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			;
															#line 450 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LocalGenerationRegActorState();
		static_cast<LocalGenerationRegActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 128 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_0 = interf.read.getFuture();
															#line 480 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GenerationRegReadRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GenerationRegReadRequest>>::value, "invalid type");
															#line 127 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 484 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 147 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_1 = interf.write.getFuture();
															#line 488 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GenerationRegWriteRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GenerationRegWriteRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< LocalGenerationRegActor, 0, GenerationRegReadRequest >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 147 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< LocalGenerationRegActor, 1, GenerationRegWriteRequest >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 496 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GenerationRegReadRequest const& _req,int loopDepth) 
	{
															#line 129 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		TraceEvent("GenerationRegReadRequest") .detail("From", _req.reply.getEndpoint().getPrimaryAddress()) .detail("K", _req.key);
															#line 132 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req = _req;
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = store->readValue(req.key);
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_2.get(), loopDepth); };
		static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 2;
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 522 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(GenerationRegReadRequest && _req,int loopDepth) 
	{
															#line 129 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		TraceEvent("GenerationRegReadRequest") .detail("From", _req.reply.getEndpoint().getPrimaryAddress()) .detail("K", _req.key);
															#line 132 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req = _req;
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = store->readValue(req.key);
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 537 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_2.get(), loopDepth); };
		static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 2;
															#line 133 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 542 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GenerationRegWriteRequest const& _wrq,int loopDepth) 
	{
															#line 148 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		wrq = _wrq;
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_4 = store->readValue(wrq.kv.key);
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 555 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 4;
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 560 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GenerationRegWriteRequest && _wrq,int loopDepth) 
	{
															#line 148 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		wrq = _wrq;
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_4 = store->readValue(wrq.kv.key);
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 573 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 4;
															#line 149 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 578 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state > 0) static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 0;
		static_cast<LocalGenerationRegActor*>(this)->ActorSingleCallback< LocalGenerationRegActor, 0, GenerationRegReadRequest >::remove();
		static_cast<LocalGenerationRegActor*>(this)->ActorSingleCallback< LocalGenerationRegActor, 1, GenerationRegWriteRequest >::remove();

	}
	int a_body1loopBody1when1cont1(Optional<Value> const& rawV,int loopDepth) 
	{
															#line 134 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		v = rawV.present() ? BinaryReader::fromStringRef<GenerationRegVal>(rawV.get(), IncludeVersion()) : GenerationRegVal();
															#line 136 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		TraceEvent("GenerationRegReadReply") .detail("RVSize", rawV.present() ? rawV.get().size() : -1) .detail("VWG", v.writeGen.generation);
															#line 139 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (v.readGen < req.gen)
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 140 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			v.readGen = req.gen;
															#line 141 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			store->set(KeyValueRef( req.key, BinaryWriter::toValue(v, IncludeVersion(ProtocolVersion::withGenerationRegVal()))));
															#line 143 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_3 = store->commit();
															#line 143 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 608 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 3;
															#line 143 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LocalGenerationRegActor, 3, Void >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 613 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(Optional<Value> && rawV,int loopDepth) 
	{
															#line 134 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		v = rawV.present() ? BinaryReader::fromStringRef<GenerationRegVal>(rawV.get(), IncludeVersion()) : GenerationRegVal();
															#line 136 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		TraceEvent("GenerationRegReadReply") .detail("RVSize", rawV.present() ? rawV.get().size() : -1) .detail("VWG", v.writeGen.generation);
															#line 139 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (v.readGen < req.gen)
															#line 631 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 140 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			v.readGen = req.gen;
															#line 141 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			store->set(KeyValueRef( req.key, BinaryWriter::toValue(v, IncludeVersion(ProtocolVersion::withGenerationRegVal()))));
															#line 143 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_3 = store->commit();
															#line 143 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 641 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 3;
															#line 143 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LocalGenerationRegActor, 3, Void >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 646 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Optional<Value> const& rawV,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(rawV, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Optional<Value> && rawV,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(rawV), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state > 0) static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 0;
		static_cast<LocalGenerationRegActor*>(this)->ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when1cont2(int loopDepth) 
	{
															#line 145 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req.reply.send(GenerationRegReadReply(v.val, v.writeGen, v.readGen));
															#line 735 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state > 0) static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 0;
		static_cast<LocalGenerationRegActor*>(this)->ActorCallback< LocalGenerationRegActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LocalGenerationRegActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LocalGenerationRegActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LocalGenerationRegActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< LocalGenerationRegActor, 0, GenerationRegReadRequest >*,GenerationRegReadRequest const& value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< LocalGenerationRegActor, 0, GenerationRegReadRequest >*,GenerationRegReadRequest && value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< LocalGenerationRegActor, 0, GenerationRegReadRequest >*,Error err) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Optional<Value> const& rawV,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		v = rawV.present() ? BinaryReader::fromStringRef<GenerationRegVal>(rawV.get(), IncludeVersion()) : GenerationRegVal();
															#line 152 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (v.readGen <= wrq.gen && v.writeGen < wrq.gen)
															#line 890 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 153 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			v.writeGen = wrq.gen;
															#line 154 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			v.val = wrq.kv.value;
															#line 155 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			store->set(KeyValueRef( wrq.kv.key, BinaryWriter::toValue(v, IncludeVersion(ProtocolVersion::withGenerationRegVal()))));
															#line 157 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_5 = store->commit();
															#line 157 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 902 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2cont1when1(__when_expr_5.get(), loopDepth); };
			static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 5;
															#line 157 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< LocalGenerationRegActor, 5, Void >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 907 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 165 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			TraceEvent("GenerationRegWriteFail") .detail("From", wrq.reply.getEndpoint().getPrimaryAddress()) .detail("Key", wrq.kv.key) .detail("ReqGen", wrq.gen.generation) .detail("ReadGen", v.readGen.generation) .detail("WriteGen", v.writeGen.generation);
															#line 171 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			wrq.reply.send(std::max(v.readGen, v.writeGen));
															#line 916 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = a_body1loopBody1when2cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Optional<Value> && rawV,int loopDepth) 
	{
															#line 150 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		v = rawV.present() ? BinaryReader::fromStringRef<GenerationRegVal>(rawV.get(), IncludeVersion()) : GenerationRegVal();
															#line 152 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (v.readGen <= wrq.gen && v.writeGen < wrq.gen)
															#line 928 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 153 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			v.writeGen = wrq.gen;
															#line 154 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			v.val = wrq.kv.value;
															#line 155 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			store->set(KeyValueRef( wrq.kv.key, BinaryWriter::toValue(v, IncludeVersion(ProtocolVersion::withGenerationRegVal()))));
															#line 157 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_5 = store->commit();
															#line 157 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 940 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2cont1when1(__when_expr_5.get(), loopDepth); };
			static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 5;
															#line 157 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< LocalGenerationRegActor, 5, Void >*>(static_cast<LocalGenerationRegActor*>(this)));
															#line 945 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 165 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			TraceEvent("GenerationRegWriteFail") .detail("From", wrq.reply.getEndpoint().getPrimaryAddress()) .detail("Key", wrq.kv.key) .detail("ReqGen", wrq.gen.generation) .detail("ReadGen", v.readGen.generation) .detail("WriteGen", v.writeGen.generation);
															#line 171 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			wrq.reply.send(std::max(v.readGen, v.writeGen));
															#line 954 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = a_body1loopBody1when2cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Optional<Value> const& rawV,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(rawV, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Optional<Value> && rawV,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(rawV), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state > 0) static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 0;
		static_cast<LocalGenerationRegActor*>(this)->ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1when2cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont3(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		TraceEvent("GenerationRegWrote") .detail("From", wrq.reply.getEndpoint().getPrimaryAddress()) .detail("Key", wrq.kv.key) .detail("ReqGen", wrq.gen.generation) .detail("Returning", v.writeGen.generation);
															#line 163 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		wrq.reply.send(v.writeGen);
															#line 1047 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1when2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont3(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		TraceEvent("GenerationRegWrote") .detail("From", wrq.reply.getEndpoint().getPrimaryAddress()) .detail("Key", wrq.kv.key) .detail("ReqGen", wrq.gen.generation) .detail("Returning", v.writeGen.generation);
															#line 163 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		wrq.reply.send(v.writeGen);
															#line 1058 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1when2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LocalGenerationRegActor*>(this)->actor_wait_state > 0) static_cast<LocalGenerationRegActor*>(this)->actor_wait_state = 0;
		static_cast<LocalGenerationRegActor*>(this)->ActorCallback< LocalGenerationRegActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LocalGenerationRegActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when2cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< LocalGenerationRegActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when2cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< LocalGenerationRegActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< LocalGenerationRegActor, 1, GenerationRegWriteRequest >*,GenerationRegWriteRequest const& value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< LocalGenerationRegActor, 1, GenerationRegWriteRequest >*,GenerationRegWriteRequest && value) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< LocalGenerationRegActor, 1, GenerationRegWriteRequest >*,Error err) 
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	GenerationRegInterface interf;
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OnDemandStore* pstore;
															#line 124 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	GenerationRegVal v;
															#line 125 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OnDemandStore& store;
															#line 132 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	GenerationRegReadRequest req;
															#line 148 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	GenerationRegWriteRequest wrq;
															#line 1207 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via localGenerationReg()
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class LocalGenerationRegActor final : public Actor<Void>, public ActorSingleCallback< LocalGenerationRegActor, 0, GenerationRegReadRequest >, public ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >, public ActorCallback< LocalGenerationRegActor, 3, Void >, public ActorSingleCallback< LocalGenerationRegActor, 1, GenerationRegWriteRequest >, public ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >, public ActorCallback< LocalGenerationRegActor, 5, Void >, public FastAllocated<LocalGenerationRegActor>, public LocalGenerationRegActorState<LocalGenerationRegActor> {
															#line 1212 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<LocalGenerationRegActor>::operator new;
	using FastAllocated<LocalGenerationRegActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9013689221867511296UL, 4304834122075723008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< LocalGenerationRegActor, 0, GenerationRegReadRequest >;
friend struct ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >;
friend struct ActorCallback< LocalGenerationRegActor, 3, Void >;
friend struct ActorSingleCallback< LocalGenerationRegActor, 1, GenerationRegWriteRequest >;
friend struct ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >;
friend struct ActorCallback< LocalGenerationRegActor, 5, Void >;
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LocalGenerationRegActor(GenerationRegInterface const& interf,OnDemandStore* const& pstore) 
															#line 1234 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   LocalGenerationRegActorState<LocalGenerationRegActor>(interf, pstore),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("localGenerationReg", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13112094312192083200UL, 16518822150729096192UL);
		ActorExecutionContextHelper __helper(static_cast<LocalGenerationRegActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("localGenerationReg");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("localGenerationReg", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< LocalGenerationRegActor, 0, GenerationRegReadRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LocalGenerationRegActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LocalGenerationRegActor, 3, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LocalGenerationRegActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LocalGenerationRegActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] Future<Void> localGenerationReg( GenerationRegInterface const& interf, OnDemandStore* const& pstore ) {
															#line 123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new LocalGenerationRegActor(interf, pstore));
															#line 1271 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 176 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

															#line 1276 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase177()
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class FlowTestCase177Actor>
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class FlowTestCase177ActorState {
															#line 1283 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	FlowTestCase177ActorState(UnitTestParameters const& params) 
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : params(params),
															#line 178 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   reg(),
															#line 179 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   store(params.getDataDir(), deterministicRandom()->randomUniqueID(), fileCoordinatorPrefix),
															#line 180 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   actor(localGenerationReg(reg, &store)),
															#line 181 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   the_key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(0, 10))),
															#line 183 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   firstGen(0, deterministicRandom()->randomUniqueID())
															#line 1300 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase177", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase177ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase177", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 186 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				StrictFuture<GenerationRegReadReply> __when_expr_0 = reg.read.getReply(GenerationRegReadRequest(the_key, firstGen));
															#line 186 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (static_cast<FlowTestCase177Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1318 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase177Actor*>(this)->actor_wait_state = 1;
															#line 186 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase177Actor, 0, GenerationRegReadReply >*>(static_cast<FlowTestCase177Actor*>(this)));
															#line 1323 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase177ActorState();
		static_cast<FlowTestCase177Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 195 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<UniqueGeneration> __when_expr_1 = reg.write.getReply(GenerationRegWriteRequest(KeyValueRef(the_key, "Value1"_sr), firstGen));
															#line 195 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<FlowTestCase177Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1350 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase177Actor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase177Actor, 1, UniqueGeneration >*>(static_cast<FlowTestCase177Actor*>(this)));
															#line 1355 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(GenerationRegReadReply const& r,int loopDepth) 
	{
															#line 189 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(!r.value.present());
															#line 190 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.gen == UniqueGeneration());
															#line 191 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.rgen == firstGen);
															#line 1369 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(GenerationRegReadReply && r,int loopDepth) 
	{
															#line 189 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(!r.value.present());
															#line 190 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.gen == UniqueGeneration());
															#line 191 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.rgen == firstGen);
															#line 1382 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(GenerationRegReadReply const& r,int loopDepth) 
	{
		loopDepth = a_body1cont2(r, loopDepth);

		return loopDepth;
	}
	int a_body1when1(GenerationRegReadReply && r,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase177Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase177Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase177Actor*>(this)->ActorCallback< FlowTestCase177Actor, 0, GenerationRegReadReply >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase177Actor, 0, GenerationRegReadReply >*,GenerationRegReadReply const& value) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase177Actor, 0, GenerationRegReadReply >*,GenerationRegReadReply && value) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase177Actor, 0, GenerationRegReadReply >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		{
															#line 202 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<GenerationRegReadReply> __when_expr_2 = reg.read.getReply(GenerationRegReadRequest(the_key, UniqueGeneration()));
															#line 202 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<FlowTestCase177Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1469 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<FlowTestCase177Actor*>(this)->actor_wait_state = 3;
															#line 202 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase177Actor, 2, GenerationRegReadReply >*>(static_cast<FlowTestCase177Actor*>(this)));
															#line 1474 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont5(UniqueGeneration const& g,int loopDepth) 
	{
															#line 198 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(g == firstGen);
															#line 1484 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(UniqueGeneration && g,int loopDepth) 
	{
															#line 198 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(g == firstGen);
															#line 1493 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(UniqueGeneration const& g,int loopDepth) 
	{
		loopDepth = a_body1cont5(g, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(UniqueGeneration && g,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(g), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase177Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase177Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase177Actor*>(this)->ActorCallback< FlowTestCase177Actor, 1, UniqueGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase177Actor, 1, UniqueGeneration >*,UniqueGeneration const& value) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase177Actor, 1, UniqueGeneration >*,UniqueGeneration && value) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase177Actor, 1, UniqueGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 217 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<FlowTestCase177Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase177ActorState(); static_cast<FlowTestCase177Actor*>(this)->destroy(); return 0; }
															#line 1577 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<FlowTestCase177Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase177ActorState();
		static_cast<FlowTestCase177Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(GenerationRegReadReply const& r,int loopDepth) 
	{
															#line 205 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.value == "Value1"_sr);
															#line 206 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.gen == firstGen);
															#line 208 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.rgen == firstGen);
															#line 211 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.gen >= firstGen);
															#line 213 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.rgen >= firstGen);
															#line 215 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(!actor.isReady());
															#line 1599 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(GenerationRegReadReply && r,int loopDepth) 
	{
															#line 205 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.value == "Value1"_sr);
															#line 206 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.gen == firstGen);
															#line 208 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.rgen == firstGen);
															#line 211 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.gen >= firstGen);
															#line 213 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(r.rgen >= firstGen);
															#line 215 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(!actor.isReady());
															#line 1618 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(GenerationRegReadReply const& r,int loopDepth) 
	{
		loopDepth = a_body1cont8(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(GenerationRegReadReply && r,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase177Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase177Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase177Actor*>(this)->ActorCallback< FlowTestCase177Actor, 2, GenerationRegReadReply >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase177Actor, 2, GenerationRegReadReply >*,GenerationRegReadReply const& value) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase177Actor, 2, GenerationRegReadReply >*,GenerationRegReadReply && value) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase177Actor, 2, GenerationRegReadReply >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	UnitTestParameters params;
															#line 178 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	GenerationRegInterface reg;
															#line 179 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OnDemandStore store;
															#line 180 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> actor;
															#line 181 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Key the_key;
															#line 183 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	UniqueGeneration firstGen;
															#line 1710 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase177()
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class FlowTestCase177Actor final : public Actor<Void>, public ActorCallback< FlowTestCase177Actor, 0, GenerationRegReadReply >, public ActorCallback< FlowTestCase177Actor, 1, UniqueGeneration >, public ActorCallback< FlowTestCase177Actor, 2, GenerationRegReadReply >, public FastAllocated<FlowTestCase177Actor>, public FlowTestCase177ActorState<FlowTestCase177Actor> {
															#line 1715 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase177Actor>::operator new;
	using FastAllocated<FlowTestCase177Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5947091132091668736UL, 16583818647001459968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase177Actor, 0, GenerationRegReadReply >;
friend struct ActorCallback< FlowTestCase177Actor, 1, UniqueGeneration >;
friend struct ActorCallback< FlowTestCase177Actor, 2, GenerationRegReadReply >;
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	FlowTestCase177Actor(UnitTestParameters const& params) 
															#line 1734 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase177ActorState<FlowTestCase177Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase177", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12161038856850439424UL, 9966130361397784064UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase177Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase177");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase177", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase177Actor, 0, GenerationRegReadReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase177Actor, 1, UniqueGeneration >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase177Actor, 2, GenerationRegReadReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
static Future<Void> flowTestCase177( UnitTestParameters const& params ) {
															#line 177 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new FlowTestCase177Actor(params));
															#line 1769 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase177, "/fdbserver/Coordination/localGenerationReg/simple")

#line 219 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

															#line 1775 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
namespace {
// This generated class is to be used only via openDatabase()
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class OpenDatabaseActor>
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class OpenDatabaseActorState {
															#line 1782 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OpenDatabaseActorState(ClientData* const& db,int* const& clientCount,Reference<AsyncVar<bool>> const& hasConnectedClients,OpenDatabaseCoordRequest const& req,Future<Void> const& checkStuck) 
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : db(db),
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   clientCount(clientCount),
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   hasConnectedClients(hasConnectedClients),
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   req(req),
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   checkStuck(checkStuck),
															#line 225 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   replyContents(),
															#line 226 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   clientInfoOnChange(db->clientInfo->onChange())
															#line 1801 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("openDatabase", reinterpret_cast<unsigned long>(this));

	}
	~OpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("openDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 228 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			++(*clientCount);
															#line 229 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			hasConnectedClients->set(true);
															#line 231 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (req.supportedVersions.size() > 0 && !req.internal)
															#line 1820 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 232 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				db->clientStatusInfoMap[req.reply.getEndpoint().getPrimaryAddress()] = ClientStatusInfo(req.traceLogGroup, req.supportedVersions, req.issues);
															#line 1824 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 236 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			;
															#line 1828 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 257 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (req.supportedVersions.size() > 0 && !req.internal)
															#line 1851 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 258 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			db->clientStatusInfoMap.erase(req.reply.getEndpoint().getPrimaryAddress());
															#line 1855 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 261 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (replyContents.present())
															#line 1859 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 262 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(replyContents.get());
															#line 1863 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 264 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.sendError(replyContents.getError());
															#line 1869 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 267 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (--(*clientCount) == 0)
															#line 1873 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 268 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			hasConnectedClients->set(false);
															#line 1877 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 271 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<OpenDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 1881 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<OpenDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 236 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!(!db->clientInfo->get().read().id.isValid() || (db->clientInfo->get().read().id == req.knownClientInfoID && !db->clientInfo->get().read().forward.present())))
															#line 1900 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 239 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_0 = checkStuck;
															#line 238 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1908 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 243 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yieldedFuture(clientInfoOnChange);
															#line 1912 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 247 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delayJittered(SERVER_KNOBS->CLIENT_REGISTER_INTERVAL);
															#line 1916 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 239 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 0, Void >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 243 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 1, Void >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 247 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 2, Void >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 1925 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 240 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		replyContents = failed_to_progress();
															#line 1953 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 240 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		replyContents = failed_to_progress();
															#line 1962 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 244 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		clientInfoOnChange = db->clientInfo->onChange();
															#line 245 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		replyContents = db->clientInfo->get();
															#line 1973 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 244 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		clientInfoOnChange = db->clientInfo->onChange();
															#line 245 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		replyContents = db->clientInfo->get();
															#line 1984 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (db->clientInfo->get().read().id.isValid())
															#line 1993 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 249 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			replyContents = db->clientInfo->get();
															#line 1997 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (db->clientInfo->get().read().id.isValid())
															#line 2007 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 249 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			replyContents = db->clientInfo->get();
															#line 2011 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<OpenDatabaseActor*>(this)->ActorCallback< OpenDatabaseActor, 0, Void >::remove();
		static_cast<OpenDatabaseActor*>(this)->ActorCallback< OpenDatabaseActor, 1, Void >::remove();
		static_cast<OpenDatabaseActor*>(this)->ActorCallback< OpenDatabaseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OpenDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OpenDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OpenDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ClientData* db;
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	int* clientCount;
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Reference<AsyncVar<bool>> hasConnectedClients;
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OpenDatabaseCoordRequest req;
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> checkStuck;
															#line 225 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ErrorOr<CachedSerialization<ClientDBInfo>> replyContents;
															#line 226 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> clientInfoOnChange;
															#line 2210 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via openDatabase()
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class OpenDatabaseActor final : public Actor<Void>, public ActorCallback< OpenDatabaseActor, 0, Void >, public ActorCallback< OpenDatabaseActor, 1, Void >, public ActorCallback< OpenDatabaseActor, 2, Void >, public FastAllocated<OpenDatabaseActor>, public OpenDatabaseActorState<OpenDatabaseActor> {
															#line 2215 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<OpenDatabaseActor>::operator new;
	using FastAllocated<OpenDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(170356154821703168UL, 999261368193845760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OpenDatabaseActor, 0, Void >;
friend struct ActorCallback< OpenDatabaseActor, 1, Void >;
friend struct ActorCallback< OpenDatabaseActor, 2, Void >;
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OpenDatabaseActor(ClientData* const& db,int* const& clientCount,Reference<AsyncVar<bool>> const& hasConnectedClients,OpenDatabaseCoordRequest const& req,Future<Void> const& checkStuck) 
															#line 2234 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   OpenDatabaseActorState<OpenDatabaseActor>(db, clientCount, hasConnectedClients, req, checkStuck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17000073936038550016UL, 17255821604456520192UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("openDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OpenDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] Future<Void> openDatabase( ClientData* const& db, int* const& clientCount, Reference<AsyncVar<bool>> const& hasConnectedClients, OpenDatabaseCoordRequest const& req, Future<Void> const& checkStuck ) {
															#line 220 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new OpenDatabaseActor(db, clientCount, hasConnectedClients, req, checkStuck));
															#line 2267 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 273 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

															#line 2272 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
namespace {
// This generated class is to be used only via remoteMonitorLeader()
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class RemoteMonitorLeaderActor>
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class RemoteMonitorLeaderActorState {
															#line 2279 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	RemoteMonitorLeaderActorState(int* const& clientCount,Reference<AsyncVar<bool>> const& hasConnectedClients,Reference<AsyncVar<Optional<LeaderInfo>>> const& currentElectedLeader,ElectionResultRequest const& req) 
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : clientCount(clientCount),
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   hasConnectedClients(hasConnectedClients),
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   currentElectedLeader(currentElectedLeader),
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   req(req),
															#line 278 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   currentElectedLeaderOnChange(currentElectedLeader->onChange())
															#line 2294 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("remoteMonitorLeader", reinterpret_cast<unsigned long>(this));

	}
	~RemoteMonitorLeaderActorState() 
	{
		fdb_probe_actor_destroy("remoteMonitorLeader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			++(*clientCount);
															#line 280 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			hasConnectedClients->set(true);
															#line 282 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			;
															#line 2313 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoteMonitorLeaderActorState();
		static_cast<RemoteMonitorLeaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 293 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req.reply.send(currentElectedLeader->get());
															#line 295 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (--(*clientCount) == 0)
															#line 2338 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 296 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			hasConnectedClients->set(false);
															#line 2342 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 299 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<RemoteMonitorLeaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoteMonitorLeaderActorState(); static_cast<RemoteMonitorLeaderActor*>(this)->destroy(); return 0; }
															#line 2346 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<RemoteMonitorLeaderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoteMonitorLeaderActorState();
		static_cast<RemoteMonitorLeaderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 282 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!(!currentElectedLeader->get().present() || req.knownLeader == currentElectedLeader->get().get().changeID))
															#line 2365 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 284 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yieldedFuture(currentElectedLeaderOnChange);
															#line 283 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<RemoteMonitorLeaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2373 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 287 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->CLIENT_REGISTER_INTERVAL);
															#line 2377 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<RemoteMonitorLeaderActor*>(this)->actor_wait_state = 1;
															#line 284 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoteMonitorLeaderActor, 0, Void >*>(static_cast<RemoteMonitorLeaderActor*>(this)));
															#line 287 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoteMonitorLeaderActor, 1, Void >*>(static_cast<RemoteMonitorLeaderActor*>(this)));
															#line 2384 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 285 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		currentElectedLeaderOnChange = currentElectedLeader->onChange();
															#line 2412 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 285 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		currentElectedLeaderOnChange = currentElectedLeader->onChange();
															#line 2421 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoteMonitorLeaderActor*>(this)->actor_wait_state > 0) static_cast<RemoteMonitorLeaderActor*>(this)->actor_wait_state = 0;
		static_cast<RemoteMonitorLeaderActor*>(this)->ActorCallback< RemoteMonitorLeaderActor, 0, Void >::remove();
		static_cast<RemoteMonitorLeaderActor*>(this)->ActorCallback< RemoteMonitorLeaderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoteMonitorLeaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoteMonitorLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoteMonitorLeaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoteMonitorLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoteMonitorLeaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoteMonitorLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoteMonitorLeaderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoteMonitorLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RemoteMonitorLeaderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoteMonitorLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RemoteMonitorLeaderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoteMonitorLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	int* clientCount;
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Reference<AsyncVar<bool>> hasConnectedClients;
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Reference<AsyncVar<Optional<LeaderInfo>>> currentElectedLeader;
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ElectionResultRequest req;
															#line 278 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> currentElectedLeaderOnChange;
															#line 2569 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via remoteMonitorLeader()
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class RemoteMonitorLeaderActor final : public Actor<Void>, public ActorCallback< RemoteMonitorLeaderActor, 0, Void >, public ActorCallback< RemoteMonitorLeaderActor, 1, Void >, public FastAllocated<RemoteMonitorLeaderActor>, public RemoteMonitorLeaderActorState<RemoteMonitorLeaderActor> {
															#line 2574 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<RemoteMonitorLeaderActor>::operator new;
	using FastAllocated<RemoteMonitorLeaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12346322804784129792UL, 436351278825491456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoteMonitorLeaderActor, 0, Void >;
friend struct ActorCallback< RemoteMonitorLeaderActor, 1, Void >;
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	RemoteMonitorLeaderActor(int* const& clientCount,Reference<AsyncVar<bool>> const& hasConnectedClients,Reference<AsyncVar<Optional<LeaderInfo>>> const& currentElectedLeader,ElectionResultRequest const& req) 
															#line 2592 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   RemoteMonitorLeaderActorState<RemoteMonitorLeaderActor>(clientCount, hasConnectedClients, currentElectedLeader, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(900814209496947200UL, 17022826691203772928UL);
		ActorExecutionContextHelper __helper(static_cast<RemoteMonitorLeaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("remoteMonitorLeader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("remoteMonitorLeader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoteMonitorLeaderActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] Future<Void> remoteMonitorLeader( int* const& clientCount, Reference<AsyncVar<bool>> const& hasConnectedClients, Reference<AsyncVar<Optional<LeaderInfo>>> const& currentElectedLeader, ElectionResultRequest const& req ) {
															#line 274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new RemoteMonitorLeaderActor(clientCount, hasConnectedClients, currentElectedLeader, req));
															#line 2625 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 301 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

// This actor implements a *single* leader-election register (essentially, it ignores
// the .key member of each request).  It returns any time the leader election is in the
// default state, so that only active registers consume memory.
															#line 2633 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
namespace {
// This generated class is to be used only via leaderRegister()
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class LeaderRegisterActor>
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class LeaderRegisterActorState {
															#line 2640 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderRegisterActorState(LeaderElectionRegInterface const& interf,Key const& key) 
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : interf(interf),
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   key(key),
															#line 306 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   availableCandidates(),
															#line 307 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   availableLeaders(),
															#line 308 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   currentNominee(),
															#line 309 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   notify(),
															#line 310 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   nextInterval(),
															#line 311 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   candidateDelay(SERVER_KNOBS->CANDIDATE_MIN_DELAY),
															#line 312 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   leaderIntervalCount(0),
															#line 313 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   notifyCheck(delay(SERVER_KNOBS->NOTIFICATION_FULL_CLEAR_TIME / SERVER_KNOBS->MIN_NOTIFICATIONS)),
															#line 315 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   clientData(),
															#line 316 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   clientCount(0),
															#line 317 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   hasConnectedClients(makeReference<AsyncVar<bool>>(false)),
															#line 318 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   actors(false),
															#line 319 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   leaderMon(),
															#line 320 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   leaderInterface(),
															#line 321 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   currentElectedLeader(makeReference<AsyncVar<Optional<LeaderInfo>>>()),
															#line 323 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   canConnectToLeader(SERVER_KNOBS->COORDINATOR_LEADER_CONNECTION_TIMEOUT),
															#line 324 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   hasConnectedClientsOnChange(hasConnectedClients->onChange())
															#line 2683 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("leaderRegister", reinterpret_cast<unsigned long>(this));

	}
	~LeaderRegisterActorState() 
	{
		fdb_probe_actor_destroy("leaderRegister", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 326 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			;
															#line 2698 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LeaderRegisterActorState();
		static_cast<LeaderRegisterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 327 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_0 = interf.openDatabase.getFuture();
															#line 2728 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<OpenDatabaseCoordRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<OpenDatabaseCoordRequest>>::value, "invalid type");
															#line 326 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<LeaderRegisterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2732 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 341 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_1 = interf.electionResult.getFuture();
															#line 2736 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ElectionResultRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ElectionResultRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 353 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_2 = interf.getLeader.getFuture();
															#line 2741 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<GetLeaderRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<GetLeaderRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 368 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_3 = interf.candidacy.getFuture();
															#line 2746 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<CandidacyRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<CandidacyRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 386 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_4 = interf.leaderHeartbeat.getFuture();
															#line 2751 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<LeaderHeartbeatRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<LeaderHeartbeatRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
															#line 399 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_5 = interf.forward.getFuture();
															#line 2756 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<ForwardRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<ForwardRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.pop(), loopDepth); };
															#line 416 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_6 = nextInterval.isValid() ? nextInterval : Never();
															#line 2761 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when7(__when_expr_6.get(), loopDepth); };
															#line 475 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_7 = notifyCheck;
															#line 2765 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when8(__when_expr_7.get(), loopDepth); };
															#line 483 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_8 = hasConnectedClientsOnChange;
															#line 2769 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when9(__when_expr_8.get(), loopDepth); };
															#line 490 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_9 = actors.getResult();
															#line 2773 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when10(__when_expr_9.get(), loopDepth); };
		static_cast<LeaderRegisterActor*>(this)->actor_wait_state = 1;
															#line 327 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderRegisterActor, 0, OpenDatabaseCoordRequest >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 341 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderRegisterActor, 1, ElectionResultRequest >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 353 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderRegisterActor, 2, GetLeaderRequest >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 368 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderRegisterActor, 3, CandidacyRequest >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 386 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderRegisterActor, 4, LeaderHeartbeatRequest >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 399 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderRegisterActor, 5, ForwardRequest >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 416 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< LeaderRegisterActor, 6, Void >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 475 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< LeaderRegisterActor, 7, Void >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 483 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< LeaderRegisterActor, 8, Void >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 490 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< LeaderRegisterActor, 9, Void >*>(static_cast<LeaderRegisterActor*>(this)));
															#line 2796 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(OpenDatabaseCoordRequest const& req,int loopDepth) 
	{
															#line 328 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (clientData.clientInfo->get().read().id.isValid() && clientData.clientInfo->get().read().id != req.knownClientInfoID && !clientData.clientInfo->get().read().forward.present())
															#line 2811 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(clientData.clientInfo->get());
															#line 2815 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 333 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!leaderMon.isValid())
															#line 2821 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 334 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				leaderMon = monitorLeaderAndGetClientInfo( req.clusterKey, req.hostnames, req.coordinators, &clientData, currentElectedLeader);
															#line 2825 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 337 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			actors.add( openDatabase(&clientData, &clientCount, hasConnectedClients, req, canConnectToLeader.checkStuck()));
															#line 2829 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(OpenDatabaseCoordRequest && req,int loopDepth) 
	{
															#line 328 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (clientData.clientInfo->get().read().id.isValid() && clientData.clientInfo->get().read().id != req.knownClientInfoID && !clientData.clientInfo->get().read().forward.present())
															#line 2839 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(clientData.clientInfo->get());
															#line 2843 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 333 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!leaderMon.isValid())
															#line 2849 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 334 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				leaderMon = monitorLeaderAndGetClientInfo( req.clusterKey, req.hostnames, req.coordinators, &clientData, currentElectedLeader);
															#line 2853 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 337 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			actors.add( openDatabase(&clientData, &clientCount, hasConnectedClients, req, canConnectToLeader.checkStuck()));
															#line 2857 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ElectionResultRequest const& req,int loopDepth) 
	{
															#line 342 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (currentElectedLeader->get().present() && req.knownLeader != currentElectedLeader->get().get().changeID)
															#line 2867 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 344 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(currentElectedLeader->get());
															#line 2871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 346 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!leaderMon.isValid())
															#line 2877 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 347 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				leaderMon = monitorLeaderAndGetClientInfo( req.key, req.hostnames, req.coordinators, &clientData, currentElectedLeader);
															#line 2881 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 350 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			actors.add(remoteMonitorLeader(&clientCount, hasConnectedClients, currentElectedLeader, req));
															#line 2885 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ElectionResultRequest && req,int loopDepth) 
	{
															#line 342 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (currentElectedLeader->get().present() && req.knownLeader != currentElectedLeader->get().get().changeID)
															#line 2895 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 344 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(currentElectedLeader->get());
															#line 2899 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 346 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!leaderMon.isValid())
															#line 2905 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 347 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				leaderMon = monitorLeaderAndGetClientInfo( req.key, req.hostnames, req.coordinators, &clientData, currentElectedLeader);
															#line 2909 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 350 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			actors.add(remoteMonitorLeader(&clientCount, hasConnectedClients, currentElectedLeader, req));
															#line 2913 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetLeaderRequest const& req,int loopDepth) 
	{
															#line 354 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (currentNominee.present() && currentNominee.get().changeID != req.knownLeader)
															#line 2923 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 355 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(currentNominee.get());
															#line 2927 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 357 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify.push_back(req.reply);
															#line 358 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (notify.size() > SERVER_KNOBS->MAX_NOTIFICATIONS)
															#line 2935 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 359 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyNotifications").detail("Amount", notify.size());
															#line 360 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				for(uint32_t i = 0;i < notify.size();i++) {
															#line 361 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					notify[i].send(currentNominee.get());
															#line 2943 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
															#line 362 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				notify.clear();
															#line 2947 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 363 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (!nextInterval.isValid())
															#line 2953 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 364 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					nextInterval = delay(0);
															#line 2957 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetLeaderRequest && req,int loopDepth) 
	{
															#line 354 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (currentNominee.present() && currentNominee.get().changeID != req.knownLeader)
															#line 2969 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 355 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(currentNominee.get());
															#line 2973 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 357 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify.push_back(req.reply);
															#line 358 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (notify.size() > SERVER_KNOBS->MAX_NOTIFICATIONS)
															#line 2981 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 359 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyNotifications").detail("Amount", notify.size());
															#line 360 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				for(uint32_t i = 0;i < notify.size();i++) {
															#line 361 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					notify[i].send(currentNominee.get());
															#line 2989 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
															#line 362 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				notify.clear();
															#line 2993 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 363 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (!nextInterval.isValid())
															#line 2999 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 364 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					nextInterval = delay(0);
															#line 3003 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(CandidacyRequest const& req,int loopDepth) 
	{
															#line 369 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!nextInterval.isValid())
															#line 3015 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 370 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			nextInterval = delay(0);
															#line 3019 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 372 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		availableCandidates.erase(LeaderInfo(req.prevChangeID));
															#line 373 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		availableCandidates.insert(req.myInfo);
															#line 374 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (currentNominee.present() && currentNominee.get().changeID != req.knownLeader)
															#line 3027 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 375 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(currentNominee.get());
															#line 3031 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 377 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify.push_back(req.reply);
															#line 378 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (notify.size() > SERVER_KNOBS->MAX_NOTIFICATIONS)
															#line 3039 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 379 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyNotifications").detail("Amount", notify.size());
															#line 380 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				for(uint32_t i = 0;i < notify.size();i++) {
															#line 381 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					notify[i].send(currentNominee.get());
															#line 3047 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
															#line 382 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				notify.clear();
															#line 3051 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(CandidacyRequest && req,int loopDepth) 
	{
															#line 369 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!nextInterval.isValid())
															#line 3062 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 370 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			nextInterval = delay(0);
															#line 3066 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 372 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		availableCandidates.erase(LeaderInfo(req.prevChangeID));
															#line 373 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		availableCandidates.insert(req.myInfo);
															#line 374 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (currentNominee.present() && currentNominee.get().changeID != req.knownLeader)
															#line 3074 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 375 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(currentNominee.get());
															#line 3078 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 377 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify.push_back(req.reply);
															#line 378 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (notify.size() > SERVER_KNOBS->MAX_NOTIFICATIONS)
															#line 3086 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 379 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyNotifications").detail("Amount", notify.size());
															#line 380 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				for(uint32_t i = 0;i < notify.size();i++) {
															#line 381 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					notify[i].send(currentNominee.get());
															#line 3094 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
															#line 382 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				notify.clear();
															#line 3098 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(LeaderHeartbeatRequest const& req,int loopDepth) 
	{
															#line 387 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!nextInterval.isValid())
															#line 3109 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 388 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			nextInterval = delay(0);
															#line 3113 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 391 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		availableLeaders.erase(LeaderInfo(req.prevChangeID));
															#line 392 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		availableLeaders.insert(req.myInfo);
															#line 393 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		bool const isCurrentLeader = currentNominee.present() && currentNominee.get().equalInternalId(req.myInfo);
															#line 394 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (isCurrentLeader)
															#line 3123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 395 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			canConnectToLeader.confirmLiveness();
															#line 3127 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 397 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req.reply.send(LeaderHeartbeatReply{ isCurrentLeader });
															#line 3131 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(LeaderHeartbeatRequest && req,int loopDepth) 
	{
															#line 387 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!nextInterval.isValid())
															#line 3140 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 388 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			nextInterval = delay(0);
															#line 3144 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 391 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		availableLeaders.erase(LeaderInfo(req.prevChangeID));
															#line 392 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		availableLeaders.insert(req.myInfo);
															#line 393 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		bool const isCurrentLeader = currentNominee.present() && currentNominee.get().equalInternalId(req.myInfo);
															#line 394 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (isCurrentLeader)
															#line 3154 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 395 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			canConnectToLeader.confirmLiveness();
															#line 3158 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 397 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req.reply.send(LeaderHeartbeatReply{ isCurrentLeader });
															#line 3162 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(ForwardRequest const& req,int loopDepth) 
	{
															#line 400 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		LeaderInfo newInfo;
															#line 401 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		newInfo.forward = true;
															#line 402 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		newInfo.serializedInfo = req.conn.toString();
															#line 403 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		for(unsigned int i = 0;i < notify.size();i++) {
															#line 404 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify[i].send(newInfo);
															#line 3179 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 405 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		notify.clear();
															#line 406 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ClientDBInfo outInfo;
															#line 407 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		outInfo.id = deterministicRandom()->randomUniqueID();
															#line 408 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		outInfo.forward = req.conn.toString();
															#line 409 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		clientData.clientInfo->set(CachedSerialization<ClientDBInfo>(outInfo));
															#line 410 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req.reply.send(Void());
															#line 411 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!hasConnectedClients->get())
															#line 3195 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 412 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!static_cast<LeaderRegisterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LeaderRegisterActorState(); static_cast<LeaderRegisterActor*>(this)->destroy(); return 0; }
															#line 3199 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			new (&static_cast<LeaderRegisterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LeaderRegisterActorState();
			static_cast<LeaderRegisterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 414 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		nextInterval = Future<Void>();
															#line 3207 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(ForwardRequest && req,int loopDepth) 
	{
															#line 400 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		LeaderInfo newInfo;
															#line 401 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		newInfo.forward = true;
															#line 402 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		newInfo.serializedInfo = req.conn.toString();
															#line 403 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		for(unsigned int i = 0;i < notify.size();i++) {
															#line 404 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify[i].send(newInfo);
															#line 3224 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 405 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		notify.clear();
															#line 406 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ClientDBInfo outInfo;
															#line 407 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		outInfo.id = deterministicRandom()->randomUniqueID();
															#line 408 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		outInfo.forward = req.conn.toString();
															#line 409 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		clientData.clientInfo->set(CachedSerialization<ClientDBInfo>(outInfo));
															#line 410 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req.reply.send(Void());
															#line 411 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!hasConnectedClients->get())
															#line 3240 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 412 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!static_cast<LeaderRegisterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LeaderRegisterActorState(); static_cast<LeaderRegisterActor*>(this)->destroy(); return 0; }
															#line 3244 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			new (&static_cast<LeaderRegisterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LeaderRegisterActorState();
			static_cast<LeaderRegisterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 414 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		nextInterval = Future<Void>();
															#line 3252 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void const& _,int loopDepth) 
	{
															#line 417 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!availableLeaders.size() && !availableCandidates.size() && !notify.size() && !currentNominee.present())
															#line 3261 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 420 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			TraceEvent("EndingLeaderNomination") .detail("Key", key) .detail("HasConnectedClients", hasConnectedClients->get());
															#line 423 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!hasConnectedClients->get())
															#line 3267 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 424 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (!static_cast<LeaderRegisterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LeaderRegisterActorState(); static_cast<LeaderRegisterActor*>(this)->destroy(); return 0; }
															#line 3271 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				new (&static_cast<LeaderRegisterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~LeaderRegisterActorState();
				static_cast<LeaderRegisterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 426 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				nextInterval = Future<Void>();
															#line 3281 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		else
		{
															#line 429 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			Optional<LeaderInfo> nextNominee;
															#line 430 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (availableCandidates.size() && (!availableLeaders.size() || availableLeaders.begin()->leaderChangeRequired(*availableCandidates.begin())))
															#line 3290 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 433 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				nextNominee = *availableCandidates.begin();
															#line 3294 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 434 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (availableLeaders.size())
															#line 3300 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 435 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					nextNominee = *availableLeaders.begin();
															#line 3304 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
			}
															#line 442 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!currentNominee.present() || !nextNominee.present() || !currentNominee.get().equalInternalId(nextNominee.get()) || nextNominee.get() > currentNominee.get() || (currentNominee.get().getPriorityInfo().dcFitness == ClusterControllerPriorityInfo::FitnessUnknown && nextNominee.get().getPriorityInfo().dcFitness == ClusterControllerPriorityInfo::FitnessRemote))
															#line 3309 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 448 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent("NominatingLeader") .detail("NextNominee", nextNominee.present() ? nextNominee.get().changeID : UID()) .detail("CurrentNominee", currentNominee.present() ? currentNominee.get().changeID : UID()) .detail("Key", printable(key));
															#line 452 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				for(unsigned int i = 0;i < notify.size();i++) {
															#line 453 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					notify[i].send(nextNominee);
															#line 3317 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
															#line 454 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				notify.clear();
															#line 3321 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 457 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			currentNominee = nextNominee;
															#line 459 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (availableLeaders.size())
															#line 3327 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 460 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				nextInterval = delay(SERVER_KNOBS->POLLING_FREQUENCY);
															#line 461 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (leaderIntervalCount++ > 5)
															#line 3333 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 462 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					candidateDelay = SERVER_KNOBS->CANDIDATE_MIN_DELAY;
															#line 3337 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
			}
			else
			{
															#line 465 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				nextInterval = delay(candidateDelay);
															#line 466 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				candidateDelay = std::min(SERVER_KNOBS->CANDIDATE_MAX_DELAY, candidateDelay * SERVER_KNOBS->CANDIDATE_GROWTH_RATE);
															#line 468 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				leaderIntervalCount = 0;
															#line 3348 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 471 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			availableLeaders.clear();
															#line 472 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			availableCandidates.clear();
															#line 3354 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void && _,int loopDepth) 
	{
															#line 417 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!availableLeaders.size() && !availableCandidates.size() && !notify.size() && !currentNominee.present())
															#line 3364 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 420 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			TraceEvent("EndingLeaderNomination") .detail("Key", key) .detail("HasConnectedClients", hasConnectedClients->get());
															#line 423 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!hasConnectedClients->get())
															#line 3370 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 424 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (!static_cast<LeaderRegisterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LeaderRegisterActorState(); static_cast<LeaderRegisterActor*>(this)->destroy(); return 0; }
															#line 3374 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				new (&static_cast<LeaderRegisterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~LeaderRegisterActorState();
				static_cast<LeaderRegisterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 426 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				nextInterval = Future<Void>();
															#line 3384 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		else
		{
															#line 429 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			Optional<LeaderInfo> nextNominee;
															#line 430 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (availableCandidates.size() && (!availableLeaders.size() || availableLeaders.begin()->leaderChangeRequired(*availableCandidates.begin())))
															#line 3393 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 433 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				nextNominee = *availableCandidates.begin();
															#line 3397 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 434 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (availableLeaders.size())
															#line 3403 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 435 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					nextNominee = *availableLeaders.begin();
															#line 3407 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
			}
															#line 442 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!currentNominee.present() || !nextNominee.present() || !currentNominee.get().equalInternalId(nextNominee.get()) || nextNominee.get() > currentNominee.get() || (currentNominee.get().getPriorityInfo().dcFitness == ClusterControllerPriorityInfo::FitnessUnknown && nextNominee.get().getPriorityInfo().dcFitness == ClusterControllerPriorityInfo::FitnessRemote))
															#line 3412 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 448 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent("NominatingLeader") .detail("NextNominee", nextNominee.present() ? nextNominee.get().changeID : UID()) .detail("CurrentNominee", currentNominee.present() ? currentNominee.get().changeID : UID()) .detail("Key", printable(key));
															#line 452 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				for(unsigned int i = 0;i < notify.size();i++) {
															#line 453 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					notify[i].send(nextNominee);
															#line 3420 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
															#line 454 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				notify.clear();
															#line 3424 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 457 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			currentNominee = nextNominee;
															#line 459 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (availableLeaders.size())
															#line 3430 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 460 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				nextInterval = delay(SERVER_KNOBS->POLLING_FREQUENCY);
															#line 461 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (leaderIntervalCount++ > 5)
															#line 3436 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 462 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					candidateDelay = SERVER_KNOBS->CANDIDATE_MIN_DELAY;
															#line 3440 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
			}
			else
			{
															#line 465 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				nextInterval = delay(candidateDelay);
															#line 466 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				candidateDelay = std::min(SERVER_KNOBS->CANDIDATE_MAX_DELAY, candidateDelay * SERVER_KNOBS->CANDIDATE_GROWTH_RATE);
															#line 468 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				leaderIntervalCount = 0;
															#line 3451 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 471 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			availableLeaders.clear();
															#line 472 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			availableCandidates.clear();
															#line 3457 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void const& _,int loopDepth) 
	{
															#line 476 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		notifyCheck = delay(SERVER_KNOBS->NOTIFICATION_FULL_CLEAR_TIME / std::max<double>(SERVER_KNOBS->MIN_NOTIFICATIONS, notify.size()));
															#line 478 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!notify.empty() && currentNominee.present())
															#line 3469 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 479 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify.front().send(currentNominee.get());
															#line 480 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify.pop_front();
															#line 3475 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void && _,int loopDepth) 
	{
															#line 476 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		notifyCheck = delay(SERVER_KNOBS->NOTIFICATION_FULL_CLEAR_TIME / std::max<double>(SERVER_KNOBS->MIN_NOTIFICATIONS, notify.size()));
															#line 478 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!notify.empty() && currentNominee.present())
															#line 3487 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 479 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify.front().send(currentNominee.get());
															#line 480 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			notify.pop_front();
															#line 3493 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(Void const& _,int loopDepth) 
	{
															#line 484 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		hasConnectedClientsOnChange = hasConnectedClients->onChange();
															#line 485 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!hasConnectedClients->get() && !nextInterval.isValid())
															#line 3505 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 486 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			TraceEvent("LeaderRegisterUnneeded").detail("Key", key);
															#line 487 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!static_cast<LeaderRegisterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LeaderRegisterActorState(); static_cast<LeaderRegisterActor*>(this)->destroy(); return 0; }
															#line 3511 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			new (&static_cast<LeaderRegisterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LeaderRegisterActorState();
			static_cast<LeaderRegisterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(Void && _,int loopDepth) 
	{
															#line 484 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		hasConnectedClientsOnChange = hasConnectedClients->onChange();
															#line 485 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!hasConnectedClients->get() && !nextInterval.isValid())
															#line 3527 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 486 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			TraceEvent("LeaderRegisterUnneeded").detail("Key", key);
															#line 487 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!static_cast<LeaderRegisterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LeaderRegisterActorState(); static_cast<LeaderRegisterActor*>(this)->destroy(); return 0; }
															#line 3533 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			new (&static_cast<LeaderRegisterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LeaderRegisterActorState();
			static_cast<LeaderRegisterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LeaderRegisterActor*>(this)->actor_wait_state > 0) static_cast<LeaderRegisterActor*>(this)->actor_wait_state = 0;
		static_cast<LeaderRegisterActor*>(this)->ActorSingleCallback< LeaderRegisterActor, 0, OpenDatabaseCoordRequest >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorSingleCallback< LeaderRegisterActor, 1, ElectionResultRequest >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorSingleCallback< LeaderRegisterActor, 2, GetLeaderRequest >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorSingleCallback< LeaderRegisterActor, 3, CandidacyRequest >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorSingleCallback< LeaderRegisterActor, 4, LeaderHeartbeatRequest >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorSingleCallback< LeaderRegisterActor, 5, ForwardRequest >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorCallback< LeaderRegisterActor, 6, Void >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorCallback< LeaderRegisterActor, 7, Void >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorCallback< LeaderRegisterActor, 8, Void >::remove();
		static_cast<LeaderRegisterActor*>(this)->ActorCallback< LeaderRegisterActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 0, OpenDatabaseCoordRequest >*,OpenDatabaseCoordRequest const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 0, OpenDatabaseCoordRequest >*,OpenDatabaseCoordRequest && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< LeaderRegisterActor, 0, OpenDatabaseCoordRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 1, ElectionResultRequest >*,ElectionResultRequest const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 1, ElectionResultRequest >*,ElectionResultRequest && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< LeaderRegisterActor, 1, ElectionResultRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 2, GetLeaderRequest >*,GetLeaderRequest const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 2, GetLeaderRequest >*,GetLeaderRequest && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< LeaderRegisterActor, 2, GetLeaderRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 3, CandidacyRequest >*,CandidacyRequest const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 3, CandidacyRequest >*,CandidacyRequest && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< LeaderRegisterActor, 3, CandidacyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 4, LeaderHeartbeatRequest >*,LeaderHeartbeatRequest const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 4, LeaderHeartbeatRequest >*,LeaderHeartbeatRequest && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< LeaderRegisterActor, 4, LeaderHeartbeatRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 5, ForwardRequest >*,ForwardRequest const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< LeaderRegisterActor, 5, ForwardRequest >*,ForwardRequest && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< LeaderRegisterActor, 5, ForwardRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< LeaderRegisterActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< LeaderRegisterActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< LeaderRegisterActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< LeaderRegisterActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< LeaderRegisterActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< LeaderRegisterActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< LeaderRegisterActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< LeaderRegisterActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< LeaderRegisterActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< LeaderRegisterActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< LeaderRegisterActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< LeaderRegisterActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderElectionRegInterface interf;
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Key key;
															#line 306 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	std::set<LeaderInfo> availableCandidates;
															#line 307 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	std::set<LeaderInfo> availableLeaders;
															#line 308 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Optional<LeaderInfo> currentNominee;
															#line 309 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Deque<ReplyPromise<Optional<LeaderInfo>>> notify;
															#line 310 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> nextInterval;
															#line 311 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	double candidateDelay;
															#line 312 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	int leaderIntervalCount;
															#line 313 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> notifyCheck;
															#line 315 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ClientData clientData;
															#line 316 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	int clientCount;
															#line 317 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Reference<AsyncVar<bool>> hasConnectedClients;
															#line 318 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ActorCollection actors;
															#line 319 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> leaderMon;
															#line 320 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	AsyncVar<Value> leaderInterface;
															#line 321 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Reference<AsyncVar<Optional<LeaderInfo>>> currentElectedLeader;
															#line 323 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LivenessChecker canConnectToLeader;
															#line 324 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> hasConnectedClientsOnChange;
															#line 4178 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via leaderRegister()
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class LeaderRegisterActor final : public Actor<Void>, public ActorSingleCallback< LeaderRegisterActor, 0, OpenDatabaseCoordRequest >, public ActorSingleCallback< LeaderRegisterActor, 1, ElectionResultRequest >, public ActorSingleCallback< LeaderRegisterActor, 2, GetLeaderRequest >, public ActorSingleCallback< LeaderRegisterActor, 3, CandidacyRequest >, public ActorSingleCallback< LeaderRegisterActor, 4, LeaderHeartbeatRequest >, public ActorSingleCallback< LeaderRegisterActor, 5, ForwardRequest >, public ActorCallback< LeaderRegisterActor, 6, Void >, public ActorCallback< LeaderRegisterActor, 7, Void >, public ActorCallback< LeaderRegisterActor, 8, Void >, public ActorCallback< LeaderRegisterActor, 9, Void >, public FastAllocated<LeaderRegisterActor>, public LeaderRegisterActorState<LeaderRegisterActor> {
															#line 4183 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<LeaderRegisterActor>::operator new;
	using FastAllocated<LeaderRegisterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17925611775893327872UL, 8597852907301536512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< LeaderRegisterActor, 0, OpenDatabaseCoordRequest >;
friend struct ActorSingleCallback< LeaderRegisterActor, 1, ElectionResultRequest >;
friend struct ActorSingleCallback< LeaderRegisterActor, 2, GetLeaderRequest >;
friend struct ActorSingleCallback< LeaderRegisterActor, 3, CandidacyRequest >;
friend struct ActorSingleCallback< LeaderRegisterActor, 4, LeaderHeartbeatRequest >;
friend struct ActorSingleCallback< LeaderRegisterActor, 5, ForwardRequest >;
friend struct ActorCallback< LeaderRegisterActor, 6, Void >;
friend struct ActorCallback< LeaderRegisterActor, 7, Void >;
friend struct ActorCallback< LeaderRegisterActor, 8, Void >;
friend struct ActorCallback< LeaderRegisterActor, 9, Void >;
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderRegisterActor(LeaderElectionRegInterface const& interf,Key const& key) 
															#line 4209 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   LeaderRegisterActorState<LeaderRegisterActor>(interf, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("leaderRegister", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5678098225837274112UL, 14972473042649600768UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderRegisterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("leaderRegister");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("leaderRegister", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< LeaderRegisterActor, 0, OpenDatabaseCoordRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] Future<Void> leaderRegister( LeaderElectionRegInterface const& interf, Key const& key ) {
															#line 305 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new LeaderRegisterActor(interf, key));
															#line 4242 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 493 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

// Generation register values are stored without prefixing in the coordinated state, but always begin with an
// alphanumeric character (they are always derived from a ClusterConnectionString key). Forwarding values are stored in
// this range:
const KeyRangeRef fwdKeys("\xff"
                          "fwd"_sr,
                          "\xff"
                          "fwe"_sr);

// The time when forwarding was last set is stored in this range:
const KeyRangeRef fwdTimeKeys("\xff"
                              "fwdTime"_sr,
                              "\xff"
                              "fwdTimf"_sr);
struct LeaderRegisterCollection {
	// SOMEDAY: Factor this into a generic tool?  Extend ActorCollection to support removal actions?  What?
	ActorCollection actors;
	Map<Key, LeaderElectionRegInterface> registerInterfaces;
	Map<Key, LeaderInfo> forward;
	OnDemandStore* pStore;
	Map<Key, double> forwardStartTime;

	LeaderRegisterCollection(OnDemandStore* pStore) : actors(false), pStore(pStore) {}

																#line 4270 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
// This generated class is to be used only via init()
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class InitActor>
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class InitActorState {
															#line 4276 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	InitActorState(LeaderRegisterCollection* const& self) 
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : self(self)
															#line 4283 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("init", reinterpret_cast<unsigned long>(this));

	}
	~InitActorState() 
	{
		fdb_probe_actor_destroy("init", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 518 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!self->pStore->exists())
															#line 4298 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 519 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (!static_cast<InitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitActorState(); static_cast<InitActor*>(this)->destroy(); return 0; }
															#line 4302 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				new (&static_cast<InitActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~InitActorState();
				static_cast<InitActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 520 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			OnDemandStore& store = *self->pStore;
															#line 521 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			forwardingInfoF = store->readRange(fwdKeys);
															#line 522 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			forwardingTimeF = store->readRange(fwdTimeKeys);
															#line 523 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(forwardingInfoF) && success(forwardingTimeF);
															#line 523 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<InitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4318 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitActor*>(this)->actor_wait_state = 1;
															#line 523 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitActor, 0, Void >*>(static_cast<InitActor*>(this)));
															#line 4323 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitActorState();
		static_cast<InitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 524 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Standalone<RangeResultRef> forwardingInfo = forwardingInfoF.get();
															#line 525 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Standalone<RangeResultRef> forwardingTime = forwardingTimeF.get();
															#line 526 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		for(int i = 0;i < forwardingInfo.size();i++) {
															#line 527 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			LeaderInfo forwardInfo;
															#line 528 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			forwardInfo.forward = true;
															#line 529 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			forwardInfo.serializedInfo = forwardingInfo[i].value;
															#line 530 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			self->forward[forwardingInfo[i].key.removePrefix(fwdKeys.begin)] = forwardInfo;
															#line 4358 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 532 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		for(int i = 0;i < forwardingTime.size();i++) {
															#line 533 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			double time = BinaryReader::fromStringRef<double>(forwardingTime[i].value, Unversioned());
															#line 534 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			self->forwardStartTime[forwardingTime[i].key.removePrefix(fwdTimeKeys.begin)] = time;
															#line 4366 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 536 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<InitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitActorState(); static_cast<InitActor*>(this)->destroy(); return 0; }
															#line 4370 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<InitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitActorState();
		static_cast<InitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 524 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Standalone<RangeResultRef> forwardingInfo = forwardingInfoF.get();
															#line 525 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Standalone<RangeResultRef> forwardingTime = forwardingTimeF.get();
															#line 526 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		for(int i = 0;i < forwardingInfo.size();i++) {
															#line 527 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			LeaderInfo forwardInfo;
															#line 528 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			forwardInfo.forward = true;
															#line 529 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			forwardInfo.serializedInfo = forwardingInfo[i].value;
															#line 530 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			self->forward[forwardingInfo[i].key.removePrefix(fwdKeys.begin)] = forwardInfo;
															#line 4394 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 532 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		for(int i = 0;i < forwardingTime.size();i++) {
															#line 533 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			double time = BinaryReader::fromStringRef<double>(forwardingTime[i].value, Unversioned());
															#line 534 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			self->forwardStartTime[forwardingTime[i].key.removePrefix(fwdTimeKeys.begin)] = time;
															#line 4402 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 536 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<InitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitActorState(); static_cast<InitActor*>(this)->destroy(); return 0; }
															#line 4406 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<InitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitActorState();
		static_cast<InitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitActor*>(this)->actor_wait_state > 0) static_cast<InitActor*>(this)->actor_wait_state = 0;
		static_cast<InitActor*>(this)->ActorCallback< InitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("init", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("init", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("init", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("init", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("init", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("init", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderRegisterCollection* self;
															#line 521 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Standalone<RangeResultRef>> forwardingInfoF;
															#line 522 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Standalone<RangeResultRef>> forwardingTimeF;
															#line 4495 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via init()
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class InitActor final : public Actor<Void>, public ActorCallback< InitActor, 0, Void >, public FastAllocated<InitActor>, public InitActorState<InitActor> {
															#line 4500 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<InitActor>::operator new;
	using FastAllocated<InitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11752806568906448128UL, 17458698283994484992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitActor, 0, Void >;
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	InitActor(LeaderRegisterCollection* const& self) 
															#line 4517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   InitActorState<InitActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("init", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1770802396446596864UL, 4776746127134105600UL);
		ActorExecutionContextHelper __helper(static_cast<InitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("init");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("init", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] static Future<Void> init( LeaderRegisterCollection* const& self ) {
															#line 517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new InitActor(self));
															#line 4549 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 538 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

	Future<Void> onError() const { return actors.getResult(); }

	// Check if the this coordinator is no longer the leader, and the new one was stored in the "forward" keyspace.
	// If the "forward" keyspace was set some time ago (as configured by knob), log an error to indicate the client is
	// using a very old cluster file.
	Optional<LeaderInfo> getForward(KeyRef key) {
		auto i = forward.find(key);
		auto t = forwardStartTime.find(key);
		if (i == forward.end())
			return Optional<LeaderInfo>();
		if (t != forwardStartTime.end()) {
			double forwardTime = t->value;
			if (now() - forwardTime > SERVER_KNOBS->FORWARD_REQUEST_TOO_OLD) {
				TraceEvent(SevWarnAlways, "AccessOldForward")
				    .detail("ForwardSetSecondsAgo", now() - forwardTime)
				    .detail("ForwardClusterKey", key);
			}
		}
		return i->value;
	}

	// When the lead coordinator changes, store the new connection ID in the "fwd" keyspace.
	// If a request arrives using an old connection id, resend it to the new coordinator using the stored connection id.
	// Store when this change took place in the fwdTime keyspace.
																#line 4578 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
// This generated class is to be used only via setForward()
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class SetForwardActor>
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class SetForwardActorState {
															#line 4584 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	SetForwardActorState(LeaderRegisterCollection* const& self,KeyRef const& key,ClusterConnectionString const& conn,ForwardRequest const& req,UID const& id) 
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : self(self),
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   key(key),
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   conn(conn),
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   req(req),
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   id(id)
															#line 4599 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("setForward", reinterpret_cast<unsigned long>(this));

	}
	~SetForwardActorState() 
	{
		fdb_probe_actor_destroy("setForward", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 568 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			double forwardTime = now();
															#line 569 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			LeaderInfo forwardInfo;
															#line 570 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			forwardInfo.forward = true;
															#line 571 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			forwardInfo.serializedInfo = conn.toString();
															#line 572 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			self->forward[key] = forwardInfo;
															#line 573 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			self->forwardStartTime[key] = forwardTime;
															#line 574 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			OnDemandStore& store = *self->pStore;
															#line 575 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			store->set(KeyValueRef(key.withPrefix(fwdKeys.begin), conn.toString()));
															#line 576 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			store->set(KeyValueRef(key.withPrefix(fwdTimeKeys.begin), BinaryWriter::toValue(forwardTime, Unversioned())));
															#line 577 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store->commit();
															#line 577 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<SetForwardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4634 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetForwardActor*>(this)->actor_wait_state = 1;
															#line 577 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetForwardActor, 0, Void >*>(static_cast<SetForwardActor*>(this)));
															#line 4639 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetForwardActorState();
		static_cast<SetForwardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		self->getInterface(req.key, id).forward.send(req);
															#line 580 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<SetForwardActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetForwardActorState(); static_cast<SetForwardActor*>(this)->destroy(); return 0; }
															#line 4664 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<SetForwardActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetForwardActorState();
		static_cast<SetForwardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		self->getInterface(req.key, id).forward.send(req);
															#line 580 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<SetForwardActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetForwardActorState(); static_cast<SetForwardActor*>(this)->destroy(); return 0; }
															#line 4678 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<SetForwardActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetForwardActorState();
		static_cast<SetForwardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetForwardActor*>(this)->actor_wait_state > 0) static_cast<SetForwardActor*>(this)->actor_wait_state = 0;
		static_cast<SetForwardActor*>(this)->ActorCallback< SetForwardActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetForwardActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetForwardActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setForward", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetForwardActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setForward", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setForward", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderRegisterCollection* self;
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	KeyRef key;
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ClusterConnectionString conn;
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ForwardRequest req;
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	UID id;
															#line 4771 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via setForward()
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class SetForwardActor final : public Actor<Void>, public ActorCallback< SetForwardActor, 0, Void >, public FastAllocated<SetForwardActor>, public SetForwardActorState<SetForwardActor> {
															#line 4776 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<SetForwardActor>::operator new;
	using FastAllocated<SetForwardActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(352927363949328640UL, 12576546235711887104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetForwardActor, 0, Void >;
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	SetForwardActor(LeaderRegisterCollection* const& self,KeyRef const& key,ClusterConnectionString const& conn,ForwardRequest const& req,UID const& id) 
															#line 4793 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   SetForwardActorState<SetForwardActor>(self, key, conn, req, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setForward", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8144933337234422016UL, 17313695872668979968UL);
		ActorExecutionContextHelper __helper(static_cast<SetForwardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setForward");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setForward", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetForwardActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] static Future<Void> setForward( LeaderRegisterCollection* const& self, KeyRef const& key, ClusterConnectionString const& conn, ForwardRequest const& req, UID const& id ) {
															#line 563 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new SetForwardActor(self, key, conn, req, id));
															#line 4825 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 582 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

	LeaderElectionRegInterface& getInterface(KeyRef key, UID id) {
		auto i = registerInterfaces.find(key);
		if (i == registerInterfaces.end()) {
			Key k = key;
			Future<Void> a = wrap(this, k, leaderRegister(registerInterfaces[k], k), id);
			if (a.isError())
				throw a.getError();
			ASSERT(!a.isReady());
			actors.add(a);
			i = registerInterfaces.find(key);
		}
		ASSERT(i != registerInterfaces.end());
		return i->value;
	}

																#line 4845 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
// This generated class is to be used only via wrap()
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class WrapActor>
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class WrapActorState {
															#line 4851 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	WrapActorState(LeaderRegisterCollection* const& self,Key const& key,Future<Void> const& actor,UID const& id) 
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : self(self),
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   key(key),
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   actor(actor),
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   id(id),
															#line 599 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   e()
															#line 4866 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("wrap", reinterpret_cast<unsigned long>(this));

	}
	~WrapActorState() 
	{
		fdb_probe_actor_destroy("wrap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 602 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				startRole(Role::COORDINATOR, id, UID());
															#line 603 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				StrictFuture<Void> __when_expr_0 = actor || traceRole(Role::COORDINATOR, id);
															#line 603 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (static_cast<WrapActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4886 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WrapActor*>(this)->actor_wait_state = 1;
															#line 603 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WrapActor, 0, Void >*>(static_cast<WrapActor*>(this)));
															#line 4891 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WrapActorState();
		static_cast<WrapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 611 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		self->registerInterfaces.erase(key);
															#line 612 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (e.code() != invalid_error_code)
															#line 4922 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 613 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4926 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
															#line 614 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<WrapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WrapActorState(); static_cast<WrapActor*>(this)->destroy(); return 0; }
															#line 4930 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<WrapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WrapActorState();
		static_cast<WrapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& err,int loopDepth=0) 
	{
		try {
															#line 606 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			endRole(Role::COORDINATOR, id, err.what(), err.code() == error_code_actor_cancelled, err);
															#line 607 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (err.code() == error_code_actor_cancelled)
															#line 4945 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 608 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				return a_body1Catch1(err, loopDepth);
															#line 4949 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 609 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			e = err;
															#line 4953 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 604 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		endRole(Role::COORDINATOR, id, "Coordinator changed");
															#line 4968 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 604 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		endRole(Role::COORDINATOR, id, "Coordinator changed");
															#line 4977 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WrapActor*>(this)->actor_wait_state > 0) static_cast<WrapActor*>(this)->actor_wait_state = 0;
		static_cast<WrapActor*>(this)->ActorCallback< WrapActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WrapActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("wrap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WrapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("wrap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WrapActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("wrap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WrapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("wrap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WrapActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("wrap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WrapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("wrap", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderRegisterCollection* self;
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Key key;
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> actor;
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	UID id;
															#line 599 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Error e;
															#line 5080 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via wrap()
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class WrapActor final : public Actor<Void>, public ActorCallback< WrapActor, 0, Void >, public FastAllocated<WrapActor>, public WrapActorState<WrapActor> {
															#line 5085 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<WrapActor>::operator new;
	using FastAllocated<WrapActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13705299373803128064UL, 14678800183074104576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WrapActor, 0, Void >;
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	WrapActor(LeaderRegisterCollection* const& self,Key const& key,Future<Void> const& actor,UID const& id) 
															#line 5102 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   WrapActorState<WrapActor>(self, key, actor, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("wrap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16342296387488062976UL, 13835047407696654848UL);
		ActorExecutionContextHelper __helper(static_cast<WrapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("wrap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("wrap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WrapActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] static Future<Void> wrap( LeaderRegisterCollection* const& self, Key const& key, Future<Void> const& actor, UID const& id ) {
															#line 598 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new WrapActor(self, key, actor, id));
															#line 5134 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 616 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
};

// extract the prefix descriptor from cluster id
StringRef getClusterDescriptor(Key key) {
	StringRef str = key.contents();
	return str.eat(":");
}

// leaderServer multiplexes multiple leaderRegisters onto a single LeaderElectionRegInterface,
// creating and destroying them on demand.
															#line 5148 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
namespace {
// This generated class is to be used only via leaderServer()
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class LeaderServerActor>
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class LeaderServerActorState {
															#line 5155 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderServerActorState(LeaderElectionRegInterface const& interf,OnDemandStore* const& pStore,UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : interf(interf),
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   pStore(pStore),
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   id(id),
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   ccr(ccr),
															#line 630 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   regs(pStore),
															#line 631 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   forwarders(false)
															#line 5172 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("leaderServer", reinterpret_cast<unsigned long>(this));

	}
	~LeaderServerActorState() 
	{
		fdb_probe_actor_destroy("leaderServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 633 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_0 = LeaderRegisterCollection::init(&regs);
															#line 633 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<LeaderServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5189 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LeaderServerActor*>(this)->actor_wait_state = 1;
															#line 633 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LeaderServerActor, 0, Void >*>(static_cast<LeaderServerActor*>(this)));
															#line 5194 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LeaderServerActorState();
		static_cast<LeaderServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 635 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		;
															#line 5217 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 635 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		;
															#line 5226 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LeaderServerActor*>(this)->actor_wait_state > 0) static_cast<LeaderServerActor*>(this)->actor_wait_state = 0;
		static_cast<LeaderServerActor*>(this)->ActorCallback< LeaderServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LeaderServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LeaderServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LeaderServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 636 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_1 = interf.checkDescriptorMutable.getFuture();
															#line 5317 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<CheckDescriptorMutableRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<CheckDescriptorMutableRequest>>::value, "invalid type");
															#line 635 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<LeaderServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5321 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 642 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_2 = interf.openDatabase.getFuture();
															#line 5325 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<OpenDatabaseCoordRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<OpenDatabaseCoordRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.pop(), loopDepth); };
															#line 664 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_3 = interf.electionResult.getFuture();
															#line 5330 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ElectionResultRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ElectionResultRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.pop(), loopDepth); };
															#line 683 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_4 = interf.getLeader.getFuture();
															#line 5335 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<GetLeaderRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<GetLeaderRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 701 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_5 = interf.candidacy.getFuture();
															#line 5340 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<CandidacyRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<CandidacyRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when5(__when_expr_5.pop(), loopDepth); };
															#line 718 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_6 = interf.leaderHeartbeat.getFuture();
															#line 5345 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<LeaderHeartbeatRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<LeaderHeartbeatRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when6(__when_expr_6.pop(), loopDepth); };
															#line 735 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		auto __when_expr_7 = interf.forward.getFuture();
															#line 5350 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_7), FutureStream<ForwardRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<ForwardRequest>>::value, "invalid type");
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when7(__when_expr_7.pop(), loopDepth); };
															#line 753 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_8 = forwarders.getResult();
															#line 5355 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when8(__when_expr_8.get(), loopDepth); };
		static_cast<LeaderServerActor*>(this)->actor_wait_state = 2;
															#line 636 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderServerActor, 1, CheckDescriptorMutableRequest >*>(static_cast<LeaderServerActor*>(this)));
															#line 642 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderServerActor, 2, OpenDatabaseCoordRequest >*>(static_cast<LeaderServerActor*>(this)));
															#line 664 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderServerActor, 3, ElectionResultRequest >*>(static_cast<LeaderServerActor*>(this)));
															#line 683 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderServerActor, 4, GetLeaderRequest >*>(static_cast<LeaderServerActor*>(this)));
															#line 701 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderServerActor, 5, CandidacyRequest >*>(static_cast<LeaderServerActor*>(this)));
															#line 718 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderServerActor, 6, LeaderHeartbeatRequest >*>(static_cast<LeaderServerActor*>(this)));
															#line 735 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< LeaderServerActor, 7, ForwardRequest >*>(static_cast<LeaderServerActor*>(this)));
															#line 753 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< LeaderServerActor, 8, Void >*>(static_cast<LeaderServerActor*>(this)));
															#line 5374 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(CheckDescriptorMutableRequest const& req,int loopDepth) 
	{
															#line 639 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		CheckDescriptorMutableReply rep(SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT);
															#line 640 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req.reply.send(rep);
															#line 5391 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(CheckDescriptorMutableRequest && req,int loopDepth) 
	{
															#line 639 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		CheckDescriptorMutableReply rep(SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT);
															#line 640 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		req.reply.send(rep);
															#line 5402 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(OpenDatabaseCoordRequest const& req,int loopDepth) 
	{
															#line 643 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.clusterKey);
															#line 644 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5413 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 645 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			ClientDBInfo info;
															#line 646 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			info.id = deterministicRandom()->randomUniqueID();
															#line 647 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			info.forward = forward.get().serializedInfo;
															#line 648 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(CachedSerialization<ClientDBInfo>(info));
															#line 5423 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 650 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 651 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.clusterKey).compare(clusterName))
															#line 5431 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 653 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "OpenDatabaseCoordRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.clusterKey) .detail("IncomingCoordinators", describeList(req.coordinators, req.coordinators.size()));
															#line 658 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5437 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 660 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.clusterKey, id).openDatabase.send(req);
															#line 5443 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(OpenDatabaseCoordRequest && req,int loopDepth) 
	{
															#line 643 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.clusterKey);
															#line 644 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5456 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 645 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			ClientDBInfo info;
															#line 646 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			info.id = deterministicRandom()->randomUniqueID();
															#line 647 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			info.forward = forward.get().serializedInfo;
															#line 648 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(CachedSerialization<ClientDBInfo>(info));
															#line 5466 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 650 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 651 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.clusterKey).compare(clusterName))
															#line 5474 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 653 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "OpenDatabaseCoordRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.clusterKey) .detail("IncomingCoordinators", describeList(req.coordinators, req.coordinators.size()));
															#line 658 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5480 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 660 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.clusterKey, id).openDatabase.send(req);
															#line 5486 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(ElectionResultRequest const& req,int loopDepth) 
	{
															#line 665 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 666 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5499 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 667 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(forward.get());
															#line 5503 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 669 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 670 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5511 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 671 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "ElectionResultRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key) .detail("ClusterKey", ccr->getConnectionString().clusterKey()) .detail("IncomingCoordinators", describeList(req.coordinators, req.coordinators.size()));
															#line 677 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5517 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 679 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.key, id).electionResult.send(req);
															#line 5523 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(ElectionResultRequest && req,int loopDepth) 
	{
															#line 665 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 666 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5536 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 667 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(forward.get());
															#line 5540 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 669 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 670 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5548 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 671 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "ElectionResultRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key) .detail("ClusterKey", ccr->getConnectionString().clusterKey()) .detail("IncomingCoordinators", describeList(req.coordinators, req.coordinators.size()));
															#line 677 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5554 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 679 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.key, id).electionResult.send(req);
															#line 5560 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when4(GetLeaderRequest const& req,int loopDepth) 
	{
															#line 684 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 685 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5573 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 686 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(forward.get());
															#line 5577 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 688 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 689 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5585 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 690 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "GetLeaderRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key) .detail("ClusterKey", ccr->getConnectionString().clusterKey());
															#line 695 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5591 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 697 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.key, id).getLeader.send(req);
															#line 5597 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when4(GetLeaderRequest && req,int loopDepth) 
	{
															#line 684 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 685 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5610 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 686 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(forward.get());
															#line 5614 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 688 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 689 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5622 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 690 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "GetLeaderRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key) .detail("ClusterKey", ccr->getConnectionString().clusterKey());
															#line 695 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5628 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 697 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.key, id).getLeader.send(req);
															#line 5634 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when5(CandidacyRequest const& req,int loopDepth) 
	{
															#line 702 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 703 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5647 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 704 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(forward.get());
															#line 5651 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 706 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 707 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5659 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 708 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "CandidacyRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key);
															#line 712 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5665 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 714 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.key, id).candidacy.send(req);
															#line 5671 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when5(CandidacyRequest && req,int loopDepth) 
	{
															#line 702 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 703 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5684 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 704 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(forward.get());
															#line 5688 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 706 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 707 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5696 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 708 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "CandidacyRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key);
															#line 712 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5702 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 714 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.key, id).candidacy.send(req);
															#line 5708 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when6(LeaderHeartbeatRequest const& req,int loopDepth) 
	{
															#line 719 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 720 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5721 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 721 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(LeaderHeartbeatReply{ false });
															#line 5725 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 723 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 724 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5733 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 725 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "LeaderHeartbeatRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key);
															#line 729 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5739 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 731 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.key, id).leaderHeartbeat.send(req);
															#line 5745 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when6(LeaderHeartbeatRequest && req,int loopDepth) 
	{
															#line 719 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 720 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5758 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 721 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(LeaderHeartbeatReply{ false });
															#line 5762 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 723 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 724 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5770 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 725 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "LeaderHeartbeatRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key);
															#line 729 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5776 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 731 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				regs.getInterface(req.key, id).leaderHeartbeat.send(req);
															#line 5782 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when7(ForwardRequest const& req,int loopDepth) 
	{
															#line 736 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 737 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5795 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 738 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(Void());
															#line 5799 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 740 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 741 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5807 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 742 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "ForwardRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key);
															#line 746 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5813 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 748 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				forwarders.add(LeaderRegisterCollection::setForward( &regs, req.key, ClusterConnectionString(req.conn.toString()), req, id));
															#line 5819 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when7(ForwardRequest && req,int loopDepth) 
	{
															#line 736 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		Optional<LeaderInfo> forward = regs.getForward(req.key);
															#line 737 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (forward.present())
															#line 5832 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 738 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			req.reply.send(Void());
															#line 5836 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		}
		else
		{
															#line 740 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StringRef clusterName = ccr->getConnectionString().clusterKeyName();
															#line 741 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT && getClusterDescriptor(req.key).compare(clusterName))
															#line 5844 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 742 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				TraceEvent(SevWarn, "CCRMismatch") .detail("RequestType", "ForwardRequest") .detail("LocalCS", ccr->getConnectionString().toString()) .detail("IncomingClusterKey", req.key);
															#line 746 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				req.reply.sendError(wrong_connection_file());
															#line 5850 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 748 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				forwarders.add(LeaderRegisterCollection::setForward( &regs, req.key, ClusterConnectionString(req.conn.toString()), req, id));
															#line 5856 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when8(Void const& _,int loopDepth) 
	{
															#line 754 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(false);
															#line 755 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5869 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1when8(Void && _,int loopDepth) 
	{
															#line 754 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(false);
															#line 755 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5879 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LeaderServerActor*>(this)->actor_wait_state > 0) static_cast<LeaderServerActor*>(this)->actor_wait_state = 0;
		static_cast<LeaderServerActor*>(this)->ActorSingleCallback< LeaderServerActor, 1, CheckDescriptorMutableRequest >::remove();
		static_cast<LeaderServerActor*>(this)->ActorSingleCallback< LeaderServerActor, 2, OpenDatabaseCoordRequest >::remove();
		static_cast<LeaderServerActor*>(this)->ActorSingleCallback< LeaderServerActor, 3, ElectionResultRequest >::remove();
		static_cast<LeaderServerActor*>(this)->ActorSingleCallback< LeaderServerActor, 4, GetLeaderRequest >::remove();
		static_cast<LeaderServerActor*>(this)->ActorSingleCallback< LeaderServerActor, 5, CandidacyRequest >::remove();
		static_cast<LeaderServerActor*>(this)->ActorSingleCallback< LeaderServerActor, 6, LeaderHeartbeatRequest >::remove();
		static_cast<LeaderServerActor*>(this)->ActorSingleCallback< LeaderServerActor, 7, ForwardRequest >::remove();
		static_cast<LeaderServerActor*>(this)->ActorCallback< LeaderServerActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 1, CheckDescriptorMutableRequest >*,CheckDescriptorMutableRequest const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 1, CheckDescriptorMutableRequest >*,CheckDescriptorMutableRequest && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< LeaderServerActor, 1, CheckDescriptorMutableRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 2, OpenDatabaseCoordRequest >*,OpenDatabaseCoordRequest const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 2, OpenDatabaseCoordRequest >*,OpenDatabaseCoordRequest && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< LeaderServerActor, 2, OpenDatabaseCoordRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 3, ElectionResultRequest >*,ElectionResultRequest const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 3, ElectionResultRequest >*,ElectionResultRequest && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< LeaderServerActor, 3, ElectionResultRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 4, GetLeaderRequest >*,GetLeaderRequest const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 4, GetLeaderRequest >*,GetLeaderRequest && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< LeaderServerActor, 4, GetLeaderRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 5, CandidacyRequest >*,CandidacyRequest const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 5, CandidacyRequest >*,CandidacyRequest && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< LeaderServerActor, 5, CandidacyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 6, LeaderHeartbeatRequest >*,LeaderHeartbeatRequest const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 6, LeaderHeartbeatRequest >*,LeaderHeartbeatRequest && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< LeaderServerActor, 6, LeaderHeartbeatRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 7, ForwardRequest >*,ForwardRequest const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< LeaderServerActor, 7, ForwardRequest >*,ForwardRequest && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< LeaderServerActor, 7, ForwardRequest >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< LeaderServerActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< LeaderServerActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< LeaderServerActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderElectionRegInterface interf;
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OnDemandStore* pStore;
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	UID id;
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 630 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderRegisterCollection regs;
															#line 631 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ActorCollection forwarders;
															#line 6364 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via leaderServer()
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class LeaderServerActor final : public Actor<Void>, public ActorCallback< LeaderServerActor, 0, Void >, public ActorSingleCallback< LeaderServerActor, 1, CheckDescriptorMutableRequest >, public ActorSingleCallback< LeaderServerActor, 2, OpenDatabaseCoordRequest >, public ActorSingleCallback< LeaderServerActor, 3, ElectionResultRequest >, public ActorSingleCallback< LeaderServerActor, 4, GetLeaderRequest >, public ActorSingleCallback< LeaderServerActor, 5, CandidacyRequest >, public ActorSingleCallback< LeaderServerActor, 6, LeaderHeartbeatRequest >, public ActorSingleCallback< LeaderServerActor, 7, ForwardRequest >, public ActorCallback< LeaderServerActor, 8, Void >, public FastAllocated<LeaderServerActor>, public LeaderServerActorState<LeaderServerActor> {
															#line 6369 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<LeaderServerActor>::operator new;
	using FastAllocated<LeaderServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9489491826007123968UL, 7771290082745774848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LeaderServerActor, 0, Void >;
friend struct ActorSingleCallback< LeaderServerActor, 1, CheckDescriptorMutableRequest >;
friend struct ActorSingleCallback< LeaderServerActor, 2, OpenDatabaseCoordRequest >;
friend struct ActorSingleCallback< LeaderServerActor, 3, ElectionResultRequest >;
friend struct ActorSingleCallback< LeaderServerActor, 4, GetLeaderRequest >;
friend struct ActorSingleCallback< LeaderServerActor, 5, CandidacyRequest >;
friend struct ActorSingleCallback< LeaderServerActor, 6, LeaderHeartbeatRequest >;
friend struct ActorSingleCallback< LeaderServerActor, 7, ForwardRequest >;
friend struct ActorCallback< LeaderServerActor, 8, Void >;
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderServerActor(LeaderElectionRegInterface const& interf,OnDemandStore* const& pStore,UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 6394 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   LeaderServerActorState<LeaderServerActor>(interf, pStore, id, ccr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("leaderServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10938813590635730944UL, 18000802891038051584UL);
		ActorExecutionContextHelper __helper(static_cast<LeaderServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("leaderServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("leaderServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LeaderServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< LeaderServerActor, 1, CheckDescriptorMutableRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] Future<Void> leaderServer( LeaderElectionRegInterface const& interf, OnDemandStore* const& pStore, UID const& id, Reference<IClusterConnectionRecord> const& ccr ) {
															#line 626 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new LeaderServerActor(interf, pStore, id, ccr));
															#line 6428 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 759 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

															#line 6433 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
namespace {
// This generated class is to be used only via coordinationServer()
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class CoordinationServerActor>
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class CoordinationServerActorState {
															#line 6440 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	CoordinationServerActorState(std::string const& dataFolder,Reference<IClusterConnectionRecord> const& ccr,Reference<ConfigNode> const& configNode,ConfigBroadcastInterface const& cbi) 
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : dataFolder(dataFolder),
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   ccr(ccr),
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   configNode(configNode),
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   cbi(cbi),
															#line 764 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   myID(deterministicRandom()->randomUniqueID()),
															#line 765 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   myLeaderInterface(g_network),
															#line 766 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   myInterface(g_network),
															#line 767 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   store(dataFolder, myID, fileCoordinatorPrefix),
															#line 768 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   configTransactionInterface(),
															#line 769 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   configFollowerInterface(),
															#line 770 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   configDatabaseServer(Never())
															#line 6467 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("coordinationServer", reinterpret_cast<unsigned long>(this));

	}
	~CoordinationServerActorState() 
	{
		fdb_probe_actor_destroy("coordinationServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 771 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			TraceEvent("CoordinationServer", myID) .detail("MyInterfaceAddr", myInterface.read.getEndpoint().getPrimaryAddress()) .detail("Folder", dataFolder) .detail("ConfigNodeValid", configNode.isValid());
															#line 779 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			bool configNodeValid = configNode.isValid();
															#line 780 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (!configNodeValid)
															#line 6486 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 781 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				configNode = makeReference<ConfigNode>(dataFolder);
															#line 6490 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
															#line 783 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			configTransactionInterface.setupWellKnownEndpoints();
															#line 784 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			configFollowerInterface.setupWellKnownEndpoints();
															#line 785 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (configNodeValid)
															#line 6498 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 786 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				configDatabaseServer = brokenPromiseToNever(configNode->serve(cbi, configTransactionInterface, configFollowerInterface));
															#line 6502 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			else
			{
															#line 789 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				configDatabaseServer = brokenPromiseToNever(configNode->serveDisabled(configTransactionInterface, configFollowerInterface));
															#line 6508 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			}
			try {
															#line 794 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				StrictFuture<Void> __when_expr_0 = localGenerationReg(myInterface, &store) || leaderServer(myLeaderInterface, &store, myID, ccr) || store.getError() || configDatabaseServer;
															#line 794 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (static_cast<CoordinationServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6515 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CoordinationServerActor*>(this)->actor_wait_state = 1;
															#line 794 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinationServerActor, 0, Void >*>(static_cast<CoordinationServerActor*>(this)));
															#line 6520 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinationServerActorState();
		static_cast<CoordinationServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 798 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			err = e;
															#line 799 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			TraceEvent("CoordinationServerError", myID).errorUnsuppressed(e);
															#line 829 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (g_network->isSimulated() && g_simulator->speedUpSimulation && e.code() == error_code_file_not_found)
															#line 6554 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 830 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				fs = std::vector<Future<Reference<IAsyncFile>>>();
															#line 831 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				fs.reserve(2);
															#line 832 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				for(int i = 0;i < 2;++i) {
															#line 833 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					std::string file = joinPath(dataFolder, format("%s%d.fdq", fileCoordinatorPrefix.c_str(), i));
															#line 834 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					fs.push_back( IAsyncFileSystem::filesystem()->open(file, IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_UNBUFFERED | IAsyncFile::OPEN_LOCK, 0));
															#line 6566 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
															#line 840 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				StrictFuture<Void> __when_expr_1 = waitForAllReady(fs);
															#line 840 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (static_cast<CoordinationServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6572 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
				static_cast<CoordinationServerActor*>(this)->actor_wait_state = 2;
															#line 840 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CoordinationServerActor, 1, Void >*>(static_cast<CoordinationServerActor*>(this)));
															#line 6577 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1Catch2cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 796 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		return a_body1Catch2(internal_error(), loopDepth);
															#line 6597 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 796 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		return a_body1Catch2(internal_error(), loopDepth);
															#line 6605 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinationServerActor*>(this)->actor_wait_state > 0) static_cast<CoordinationServerActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinationServerActor*>(this)->ActorCallback< CoordinationServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinationServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinationServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinationServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 867 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 6688 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2cont2(Void const& _,int loopDepth) 
	{
															#line 844 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(((fs[0].isError() && fs[0].getError().code() == error_code_file_not_found) || (fs[1].isError() && fs[1].getError().code() == error_code_file_not_found)) && fs[0].isError() != fs[1].isError());
															#line 848 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		TraceEvent(SevWarnAlways, "CoordinatorDiskQueueInconsistentState") .detail("File0Missing", fs[0].isError()) .detail("File1Missing", fs[1].isError());
															#line 855 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (fs[0].isError())
															#line 6700 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 856 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			ASSERT(fs[0].getError().code() == error_code_file_not_found);
															#line 857 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_2 = IAsyncFileSystem::filesystem()->deleteFile(joinPath(dataFolder, fileCoordinatorPrefix + "1.fdq"), true);
															#line 857 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<CoordinationServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6708 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1Catch2cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CoordinationServerActor*>(this)->actor_wait_state = 3;
															#line 857 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CoordinationServerActor, 2, Void >*>(static_cast<CoordinationServerActor*>(this)));
															#line 6713 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1Catch2cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont2(Void && _,int loopDepth) 
	{
															#line 844 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		ASSERT(((fs[0].isError() && fs[0].getError().code() == error_code_file_not_found) || (fs[1].isError() && fs[1].getError().code() == error_code_file_not_found)) && fs[0].isError() != fs[1].isError());
															#line 848 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		TraceEvent(SevWarnAlways, "CoordinatorDiskQueueInconsistentState") .detail("File0Missing", fs[0].isError()) .detail("File1Missing", fs[1].isError());
															#line 855 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (fs[0].isError())
															#line 6731 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 856 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			ASSERT(fs[0].getError().code() == error_code_file_not_found);
															#line 857 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_2 = IAsyncFileSystem::filesystem()->deleteFile(joinPath(dataFolder, fileCoordinatorPrefix + "1.fdq"), true);
															#line 857 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<CoordinationServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6739 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1Catch2cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CoordinationServerActor*>(this)->actor_wait_state = 3;
															#line 857 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CoordinationServerActor, 2, Void >*>(static_cast<CoordinationServerActor*>(this)));
															#line 6744 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1Catch2cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CoordinationServerActor*>(this)->actor_wait_state > 0) static_cast<CoordinationServerActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinationServerActor*>(this)->ActorCallback< CoordinationServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinationServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CoordinationServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CoordinationServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1Catch2cont4(int loopDepth) 
	{
															#line 860 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (fs[1].isError())
															#line 6833 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		{
															#line 861 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			ASSERT(fs[1].getError().code() == error_code_file_not_found);
															#line 862 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<Void> __when_expr_3 = IAsyncFileSystem::filesystem()->deleteFile(joinPath(dataFolder, fileCoordinatorPrefix + "0.fdq"), true);
															#line 862 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<CoordinationServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6841 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1Catch2cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CoordinationServerActor*>(this)->actor_wait_state = 4;
															#line 862 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CoordinationServerActor, 3, Void >*>(static_cast<CoordinationServerActor*>(this)));
															#line 6846 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1Catch2cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CoordinationServerActor*>(this)->actor_wait_state > 0) static_cast<CoordinationServerActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinationServerActor*>(this)->ActorCallback< CoordinationServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinationServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CoordinationServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CoordinationServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1Catch2cont6(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont6(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont6(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CoordinationServerActor*>(this)->actor_wait_state > 0) static_cast<CoordinationServerActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinationServerActor*>(this)->ActorCallback< CoordinationServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinationServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CoordinationServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CoordinationServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	std::string dataFolder;
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Reference<ConfigNode> configNode;
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ConfigBroadcastInterface cbi;
															#line 764 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	UID myID;
															#line 765 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	LeaderElectionRegInterface myLeaderInterface;
															#line 766 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	GenerationRegInterface myInterface;
															#line 767 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OnDemandStore store;
															#line 768 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ConfigTransactionInterface configTransactionInterface;
															#line 769 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ConfigFollowerInterface configFollowerInterface;
															#line 770 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Future<Void> configDatabaseServer;
															#line 798 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	Error err;
															#line 830 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	std::vector<Future<Reference<IAsyncFile>>> fs;
															#line 7062 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via coordinationServer()
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class CoordinationServerActor final : public Actor<Void>, public ActorCallback< CoordinationServerActor, 0, Void >, public ActorCallback< CoordinationServerActor, 1, Void >, public ActorCallback< CoordinationServerActor, 2, Void >, public ActorCallback< CoordinationServerActor, 3, Void >, public FastAllocated<CoordinationServerActor>, public CoordinationServerActorState<CoordinationServerActor> {
															#line 7067 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<CoordinationServerActor>::operator new;
	using FastAllocated<CoordinationServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10257115514099564800UL, 3415856316121989888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinationServerActor, 0, Void >;
friend struct ActorCallback< CoordinationServerActor, 1, Void >;
friend struct ActorCallback< CoordinationServerActor, 2, Void >;
friend struct ActorCallback< CoordinationServerActor, 3, Void >;
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	CoordinationServerActor(std::string const& dataFolder,Reference<IClusterConnectionRecord> const& ccr,Reference<ConfigNode> const& configNode,ConfigBroadcastInterface const& cbi) 
															#line 7087 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   CoordinationServerActorState<CoordinationServerActor>(dataFolder, ccr, configNode, cbi),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("coordinationServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16290917586549725184UL, 12229568422328648704UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("coordinationServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("coordinationServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinationServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CoordinationServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CoordinationServerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CoordinationServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] Future<Void> coordinationServer( std::string const& dataFolder, Reference<IClusterConnectionRecord> const& ccr, Reference<ConfigNode> const& configNode, ConfigBroadcastInterface const& cbi ) {
															#line 760 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new CoordinationServerActor(dataFolder, ccr, configNode, cbi));
															#line 7123 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 870 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

															#line 7128 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
namespace {
// This generated class is to be used only via changeClusterDescription()
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
template <class ChangeClusterDescriptionActor>
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class ChangeClusterDescriptionActorState {
															#line 7135 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ChangeClusterDescriptionActorState(std::string const& datafolder,KeyRef const& newClusterKey,KeyRef const& oldClusterKey) 
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		 : datafolder(datafolder),
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   newClusterKey(newClusterKey),
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   oldClusterKey(oldClusterKey),
															#line 872 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   myID(deterministicRandom()->randomUniqueID()),
															#line 873 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		   store(datafolder, myID, fileCoordinatorPrefix)
															#line 7150 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
	{
		fdb_probe_actor_create("changeClusterDescription", reinterpret_cast<unsigned long>(this));

	}
	~ChangeClusterDescriptionActorState() 
	{
		fdb_probe_actor_destroy("changeClusterDescription", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 874 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = store->readRange(allKeys);
															#line 874 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7167 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state = 1;
															#line 874 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeClusterDescriptionActor, 0, RangeResult >*>(static_cast<ChangeClusterDescriptionActor*>(this)));
															#line 7172 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeClusterDescriptionActorState();
		static_cast<ChangeClusterDescriptionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 887 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		for( auto& [key, value] : res ) {
															#line 888 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (key.startsWith(fwdKeys.begin))
															#line 7197 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 889 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (key.removePrefix(fwdKeys.begin) == oldClusterKey)
															#line 7201 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 890 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					store->clear(singleKeyRange(key));
															#line 891 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					store->set(KeyValueRef(newClusterKey.withPrefix(fwdKeys.begin), value));
															#line 7207 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
				else
				{
															#line 892 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					if (value.startsWith(oldClusterKey))
															#line 7213 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
					{
															#line 893 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						store->set(KeyValueRef(key, value.removePrefix(oldClusterKey).withPrefix(newClusterKey)));
															#line 7217 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 895 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (key.startsWith(fwdTimeKeys.begin) && key.removePrefix(fwdTimeKeys.begin) == oldClusterKey)
															#line 7225 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 896 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					store->clear(singleKeyRange(key));
															#line 897 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					store->set(KeyValueRef(newClusterKey.withPrefix(fwdTimeKeys.begin), value));
															#line 7231 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
				else
				{
															#line 898 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					if (key == oldClusterKey)
															#line 7237 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
					{
															#line 899 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						store->clear(singleKeyRange(key));
															#line 900 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						store->set(KeyValueRef(newClusterKey, value));
															#line 7243 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
					}
					else
					{
															#line 903 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						GenerationRegVal regVal = BinaryReader::fromStringRef<GenerationRegVal>(value, IncludeVersion());
															#line 904 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						if (regVal.val.present())
															#line 7251 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
						{
															#line 905 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
							Optional<Value> newVal = updateCCSInMovableValue(regVal.val.get(), oldClusterKey, newClusterKey);
															#line 906 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
							if (newVal.present())
															#line 7257 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
							{
															#line 907 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
								regVal.val = newVal.get();
															#line 908 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
								store->set(KeyValueRef( key, BinaryWriter::toValue(regVal, IncludeVersion(ProtocolVersion::withGenerationRegVal()))));
															#line 7263 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
							}
						}
					}
				}
			}
		}
															#line 914 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store->commit();
															#line 914 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7274 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state = 2;
															#line 914 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeClusterDescriptionActor, 1, Void >*>(static_cast<ChangeClusterDescriptionActor*>(this)));
															#line 7279 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && res,int loopDepth) 
	{
															#line 887 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		for( auto& [key, value] : res ) {
															#line 888 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
			if (key.startsWith(fwdKeys.begin))
															#line 7290 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
			{
															#line 889 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (key.removePrefix(fwdKeys.begin) == oldClusterKey)
															#line 7294 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 890 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					store->clear(singleKeyRange(key));
															#line 891 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					store->set(KeyValueRef(newClusterKey.withPrefix(fwdKeys.begin), value));
															#line 7300 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
				else
				{
															#line 892 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					if (value.startsWith(oldClusterKey))
															#line 7306 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
					{
															#line 893 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						store->set(KeyValueRef(key, value.removePrefix(oldClusterKey).withPrefix(newClusterKey)));
															#line 7310 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
					}
				}
			}
			else
			{
															#line 895 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
				if (key.startsWith(fwdTimeKeys.begin) && key.removePrefix(fwdTimeKeys.begin) == oldClusterKey)
															#line 7318 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				{
															#line 896 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					store->clear(singleKeyRange(key));
															#line 897 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					store->set(KeyValueRef(newClusterKey.withPrefix(fwdTimeKeys.begin), value));
															#line 7324 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
				}
				else
				{
															#line 898 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
					if (key == oldClusterKey)
															#line 7330 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
					{
															#line 899 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						store->clear(singleKeyRange(key));
															#line 900 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						store->set(KeyValueRef(newClusterKey, value));
															#line 7336 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
					}
					else
					{
															#line 903 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						GenerationRegVal regVal = BinaryReader::fromStringRef<GenerationRegVal>(value, IncludeVersion());
															#line 904 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
						if (regVal.val.present())
															#line 7344 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
						{
															#line 905 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
							Optional<Value> newVal = updateCCSInMovableValue(regVal.val.get(), oldClusterKey, newClusterKey);
															#line 906 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
							if (newVal.present())
															#line 7350 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
							{
															#line 907 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
								regVal.val = newVal.get();
															#line 908 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
								store->set(KeyValueRef( key, BinaryWriter::toValue(regVal, IncludeVersion(ProtocolVersion::withGenerationRegVal()))));
															#line 7356 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
							}
						}
					}
				}
			}
		}
															#line 914 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store->commit();
															#line 914 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7367 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state = 2;
															#line 914 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeClusterDescriptionActor, 1, Void >*>(static_cast<ChangeClusterDescriptionActor*>(this)));
															#line 7372 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state > 0) static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeClusterDescriptionActor*>(this)->ActorCallback< ChangeClusterDescriptionActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeClusterDescriptionActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("changeClusterDescription", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterDescriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterDescription", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeClusterDescriptionActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("changeClusterDescription", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterDescriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterDescription", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeClusterDescriptionActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("changeClusterDescription", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterDescriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterDescription", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 915 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<ChangeClusterDescriptionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeClusterDescriptionActorState(); static_cast<ChangeClusterDescriptionActor*>(this)->destroy(); return 0; }
															#line 7456 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<ChangeClusterDescriptionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeClusterDescriptionActorState();
		static_cast<ChangeClusterDescriptionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 915 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
		if (!static_cast<ChangeClusterDescriptionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeClusterDescriptionActorState(); static_cast<ChangeClusterDescriptionActor*>(this)->destroy(); return 0; }
															#line 7468 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		new (&static_cast<ChangeClusterDescriptionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeClusterDescriptionActorState();
		static_cast<ChangeClusterDescriptionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state > 0) static_cast<ChangeClusterDescriptionActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeClusterDescriptionActor*>(this)->ActorCallback< ChangeClusterDescriptionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeClusterDescriptionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeClusterDescription", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterDescriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterDescription", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeClusterDescriptionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeClusterDescription", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterDescriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterDescription", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeClusterDescriptionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeClusterDescription", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterDescriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterDescription", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	std::string datafolder;
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	KeyRef newClusterKey;
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	KeyRef oldClusterKey;
															#line 872 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	UID myID;
															#line 873 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	OnDemandStore store;
															#line 7561 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
};
// This generated class is to be used only via changeClusterDescription()
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
class ChangeClusterDescriptionActor final : public Actor<Void>, public ActorCallback< ChangeClusterDescriptionActor, 0, RangeResult >, public ActorCallback< ChangeClusterDescriptionActor, 1, Void >, public FastAllocated<ChangeClusterDescriptionActor>, public ChangeClusterDescriptionActorState<ChangeClusterDescriptionActor> {
															#line 7566 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
public:
	using FastAllocated<ChangeClusterDescriptionActor>::operator new;
	using FastAllocated<ChangeClusterDescriptionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5923550233292401920UL, 3265460029397129984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeClusterDescriptionActor, 0, RangeResult >;
friend struct ActorCallback< ChangeClusterDescriptionActor, 1, Void >;
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	ChangeClusterDescriptionActor(std::string const& datafolder,KeyRef const& newClusterKey,KeyRef const& oldClusterKey) 
															#line 7584 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeClusterDescriptionActorState<ChangeClusterDescriptionActor>(datafolder, newClusterKey, oldClusterKey),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeClusterDescription", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1105982381061044480UL, 12468919842049966336UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterDescriptionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeClusterDescription");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeClusterDescription", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeClusterDescriptionActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeClusterDescriptionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
[[nodiscard]] Future<Void> changeClusterDescription( std::string const& datafolder, KeyRef const& newClusterKey, KeyRef const& oldClusterKey ) {
															#line 871 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"
	return Future<Void>(new ChangeClusterDescriptionActor(datafolder, newClusterKey, oldClusterKey));
															#line 7618 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/build_output/fdbserver/Coordination.actor.g.cpp"
}

#line 917 "/codebuild/output/src2070832675/src/github.com/apple/foundationdb/fdbserver/Coordination.actor.cpp"

Future<Void> coordChangeClusterKey(std::string dataFolder, KeyRef newClusterKey, KeyRef oldClusterKey) {
	TraceEvent(SevInfo, "CoordChangeClusterKey")
	    .detail("DataFolder", dataFolder)
	    .detail("NewClusterKey", newClusterKey)
	    .detail("OldClusterKey", oldClusterKey);
	std::string absDataFolder = abspath(dataFolder);
	std::vector<std::string> returnList = platform::listDirectories(absDataFolder);
	std::vector<Future<Void>> futures;
	for (const auto& dirEntry : returnList) {
		if (dirEntry == "." || dirEntry == "..") {
			continue;
		}
		std::string processDir = dataFolder + "/" + dirEntry;
		TraceEvent(SevInfo, "UpdatingCoordDataForProcess").detail("ProcessDataDir", processDir);
		std::vector<std::string> returnFiles = platform::listFiles(processDir, "");
		bool isCoord = false;
		for (const auto& fileEntry : returnFiles) {
			if (fileEntry.rfind(fileCoordinatorPrefix, 0) == 0) {
				isCoord = true;
			}
		}
		if (!isCoord)
			continue;
		futures.push_back(changeClusterDescription(processDir, newClusterKey, oldClusterKey));
	}
	return waitForAll(futures);
}
