/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.FDB;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.test.DirectoryOperation;
import com.apple.foundationdb.test.Instruction;
import com.apple.foundationdb.test.StackUtils;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

class DirectoryUtil {
    static CompletableFuture<List<Tuple>> popTuples(Instruction instruction, int n) {
        return new TuplePopper(instruction, n).pop();
    }

    static CompletableFuture<Tuple> popTuple(Instruction instruction) {
        return DirectoryUtil.popTuples(instruction, 1).thenApply(list -> (Tuple)list.get(0));
    }

    static CompletableFuture<List<List<String>>> popPaths(Instruction instruction, int n) {
        return DirectoryUtil.popTuples(instruction, n).thenApplyAsync(list -> {
            ArrayList arrayList = new ArrayList(list.size());
            for (Tuple tuple : list) {
                ArrayList<String> arrayList2 = new ArrayList<String>(tuple.size());
                for (int i = 0; i < tuple.size(); ++i) {
                    arrayList2.add(tuple.getString(i));
                }
                arrayList.add(arrayList2);
            }
            return arrayList;
        }, (Executor)FDB.DEFAULT_EXECUTOR);
    }

    static CompletableFuture<List<String>> popPath(Instruction instruction) {
        return DirectoryUtil.popPaths(instruction, 1).thenApply(list -> (List)list.get(0));
    }

    static void pushError(Instruction instruction, Throwable throwable, List<Object> list) {
        instruction.push("DIRECTORY_ERROR".getBytes());
        DirectoryOperation directoryOperation = DirectoryOperation.valueOf(instruction.op);
        if (directoryOperation.createsDirectory) {
            list.add(null);
        }
    }

    private DirectoryUtil() {
    }

    private static class TuplePopper {
        private Instruction inst;
        private int num;
        private List<Tuple> tuples = new ArrayList<Tuple>();

        TuplePopper(Instruction instruction, int n) {
            this.inst = instruction;
            this.num = n;
        }

        CompletableFuture<List<Tuple>> pop() {
            return AsyncUtil.whileTrue(() -> {
                if (this.num-- == 0) {
                    return AsyncUtil.READY_FALSE;
                }
                return ((CompletableFuture)this.inst.popParam().thenComposeAsync(object -> this.inst.popParams(StackUtils.getInt(object)), (Executor)FDB.DEFAULT_EXECUTOR)).thenApplyAsync(list -> {
                    this.tuples.add(Tuple.fromItems((Iterable)list));
                    return this.num > 0;
                }, (Executor)FDB.DEFAULT_EXECUTOR);
            }).thenApply(void_ -> this.tuples);
        }
    }
}

