#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
/*
 * ConfigureTenant.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_CONFIGURETENANT_ACTOR_G_H)
#define METACLUSTER_CONFIGURETENANT_ACTOR_G_H
#include "metacluster/ConfigureTenant.actor.g.h"
#elif !defined(METACLUSTER_CONFIGURETENANT_ACTOR_H)
#define METACLUSTER_CONFIGURETENANT_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/GetTenant.actor.h"
#include "metacluster/MetaclusterInternal.actor.h"
#include "metacluster/MetaclusterOperationContext.actor.h"
#include "metacluster/MetaclusterTypes.h"
#include "metacluster/UpdateTenantGroups.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

namespace internal {
template <class DB>
struct ConfigureTenantImpl {
	MetaclusterOperationContext<DB> ctx;

	// Initialization parameters
	TenantName tenantName;
	std::map<Standalone<StringRef>, Optional<Value>> configurationParameters;
	IgnoreCapacityLimit ignoreCapacityLimit = IgnoreCapacityLimit::False;
	Optional<TenantAPI::TenantLockState> lockState;
	Optional<UID> lockId;

	// Parameters set in updateManagementCluster
	MetaclusterTenantMapEntry updatedEntry;

	ConfigureTenantImpl(Reference<DB> managementDb,
	                    TenantName tenantName,
	                    std::map<Standalone<StringRef>, Optional<Value>> configurationParameters,
	                    IgnoreCapacityLimit ignoreCapacityLimit)
	  : ctx(managementDb), tenantName(tenantName), configurationParameters(configurationParameters),
	    ignoreCapacityLimit(ignoreCapacityLimit) {}

	ConfigureTenantImpl(Reference<DB> managementDb,
	                    TenantName tenantName,
	                    TenantAPI::TenantLockState lockState,
	                    UID lockId)
	  : ctx(managementDb), tenantName(tenantName), lockState(lockState), lockId(lockId) {}

	// This verifies that the tenant group can be changed, and if so it updates all of the tenant group data
	// structures. It does not update the TenantMapEntry stored in the tenant map.
																#line 74 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via updateTenantGroup()
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class UpdateTenantGroupActor>
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class UpdateTenantGroupActorState {
															#line 80 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	UpdateTenantGroupActorState(ConfigureTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr,MetaclusterTenantMapEntry const& tenantEntry,Optional<TenantGroupName> const& desiredGroup) 
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : self(self),
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   tr(tr),
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   tenantEntry(tenantEntry),
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   desiredGroup(desiredGroup),
															#line 77 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   entryWithUpdatedGroup(tenantEntry)
															#line 95 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("updateTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	~UpdateTenantGroupActorState() 
	{
		fdb_probe_actor_destroy("updateTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			entryWithUpdatedGroup.tenantGroup = desiredGroup;
															#line 80 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (tenantEntry.tenantGroup == desiredGroup)
															#line 112 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			{
															#line 81 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				CODE_PROBE(true, "Update tenant group to same group");
															#line 82 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				if (!static_cast<UpdateTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantGroupActorState(); static_cast<UpdateTenantGroupActor*>(this)->destroy(); return 0; }
															#line 118 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
				new (&static_cast<UpdateTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~UpdateTenantGroupActorState();
				static_cast<UpdateTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				if (!desiredGroup.present())
															#line 128 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
				{
															#line 87 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					if (!self->ctx.dataClusterMetadata.get().entry.hasCapacity() && !self->ignoreCapacityLimit)
															#line 132 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
					{
															#line 88 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
						CODE_PROBE(true, "Remove tenant group failed due to capacity limits");
															#line 89 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
						return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 138 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
					}
															#line 92 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					CODE_PROBE(true, "Remove tenant group");
															#line 93 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					StrictFuture<Void> __when_expr_0 = internal::managementClusterRemoveTenantFromGroup( tr, tenantEntry, &self->ctx.dataClusterMetadata.get());
															#line 93 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					if (static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state = 1;
															#line 93 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateTenantGroupActor, 0, Void >*>(static_cast<UpdateTenantGroupActor*>(this)));
															#line 151 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateTenantGroupActorState();
		static_cast<UpdateTenantGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 103 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		StrictFuture<Optional<MetaclusterTenantGroupEntry>> __when_expr_1 = metadata::management::tenantMetadata().tenantGroupMap.get(tr, desiredGroup.get());
															#line 103 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 182 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state = 2;
															#line 103 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateTenantGroupActor, 1, Optional<MetaclusterTenantGroupEntry> >*>(static_cast<UpdateTenantGroupActor*>(this)));
															#line 187 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		internal::managementClusterAddTenantToGroup(tr, entryWithUpdatedGroup, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists::False, self->ignoreCapacityLimit);
															#line 100 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantGroupActorState(); static_cast<UpdateTenantGroupActor*>(this)->destroy(); return 0; }
															#line 204 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateTenantGroupActorState();
		static_cast<UpdateTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		internal::managementClusterAddTenantToGroup(tr, entryWithUpdatedGroup, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists::False, self->ignoreCapacityLimit);
															#line 100 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantGroupActorState(); static_cast<UpdateTenantGroupActor*>(this)->destroy(); return 0; }
															#line 218 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateTenantGroupActorState();
		static_cast<UpdateTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateTenantGroupActor*>(this)->ActorCallback< UpdateTenantGroupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateTenantGroupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateTenantGroupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateTenantGroupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 107 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!tenantGroupEntry.present())
															#line 305 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 108 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (!self->ctx.dataClusterMetadata.get().entry.hasCapacity() && !self->ignoreCapacityLimit)
															#line 309 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			{
															#line 109 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				CODE_PROBE(true, "Set tenant group to new group failed due to capacity limits");
															#line 110 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 315 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			}
															#line 113 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(true, "Set tenant group to new group");
															#line 114 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Void> __when_expr_2 = internal::managementClusterRemoveTenantFromGroup( tr, tenantEntry, &self->ctx.dataClusterMetadata.get());
															#line 114 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 323 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont7when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state = 3;
															#line 114 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateTenantGroupActor, 2, Void >*>(static_cast<UpdateTenantGroupActor*>(this)));
															#line 328 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 125 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (tenantGroupEntry.get().assignedCluster == tenantEntry.assignedCluster)
															#line 335 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			{
															#line 126 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				CODE_PROBE(true, "Move tenant between groups on same cluster");
															#line 127 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				StrictFuture<Void> __when_expr_3 = internal::managementClusterRemoveTenantFromGroup( tr, tenantEntry, &self->ctx.dataClusterMetadata.get());
															#line 127 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				if (static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 343 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when2(__when_expr_3.get(), loopDepth); };
				static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state = 4;
															#line 127 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateTenantGroupActor, 3, Void >*>(static_cast<UpdateTenantGroupActor*>(this)));
															#line 348 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 139 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				CODE_PROBE(true, "Move tenant groups on different cluster failed");
															#line 140 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				TraceEvent("TenantGroupChangeToDifferentCluster") .detail("Tenant", self->tenantName) .detail("OriginalGroup", tenantEntry.tenantGroup) .detail("DesiredGroup", desiredGroup) .detail("TenantAssignedCluster", tenantEntry.assignedCluster) .detail("DesiredGroupAssignedCluster", tenantGroupEntry.get().assignedCluster);
															#line 147 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				return a_body1Catch1(invalid_tenant_configuration(), loopDepth);
															#line 359 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			}
		}

		return loopDepth;
	}
	int a_body1cont1when1(Optional<MetaclusterTenantGroupEntry> const& __tenantGroupEntry,int loopDepth) 
	{
															#line 103 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		tenantGroupEntry = __tenantGroupEntry;
															#line 369 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<MetaclusterTenantGroupEntry> && __tenantGroupEntry,int loopDepth) 
	{
		tenantGroupEntry = std::move(__tenantGroupEntry);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateTenantGroupActor*>(this)->ActorCallback< UpdateTenantGroupActor, 1, Optional<MetaclusterTenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateTenantGroupActor, 1, Optional<MetaclusterTenantGroupEntry> >*,Optional<MetaclusterTenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateTenantGroupActor, 1, Optional<MetaclusterTenantGroupEntry> >*,Optional<MetaclusterTenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateTenantGroupActor, 1, Optional<MetaclusterTenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		internal::managementClusterAddTenantToGroup(tr, entryWithUpdatedGroup, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists::False, self->ignoreCapacityLimit);
															#line 121 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantGroupActorState(); static_cast<UpdateTenantGroupActor*>(this)->destroy(); return 0; }
															#line 450 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateTenantGroupActorState();
		static_cast<UpdateTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		internal::managementClusterAddTenantToGroup(tr, entryWithUpdatedGroup, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists::False, self->ignoreCapacityLimit);
															#line 121 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantGroupActorState(); static_cast<UpdateTenantGroupActor*>(this)->destroy(); return 0; }
															#line 464 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateTenantGroupActorState();
		static_cast<UpdateTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateTenantGroupActor*>(this)->ActorCallback< UpdateTenantGroupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateTenantGroupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateTenantGroupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateTenantGroupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		internal::managementClusterAddTenantToGroup(tr, entryWithUpdatedGroup, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists::True, self->ignoreCapacityLimit);
															#line 134 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantGroupActorState(); static_cast<UpdateTenantGroupActor*>(this)->destroy(); return 0; }
															#line 553 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateTenantGroupActorState();
		static_cast<UpdateTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		internal::managementClusterAddTenantToGroup(tr, entryWithUpdatedGroup, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists::True, self->ignoreCapacityLimit);
															#line 134 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateTenantGroupActorState(); static_cast<UpdateTenantGroupActor*>(this)->destroy(); return 0; }
															#line 567 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateTenantGroupActorState();
		static_cast<UpdateTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<UpdateTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateTenantGroupActor*>(this)->ActorCallback< UpdateTenantGroupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateTenantGroupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateTenantGroupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateTenantGroupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ConfigureTenantImpl* self;
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	MetaclusterTenantMapEntry tenantEntry;
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Optional<TenantGroupName> desiredGroup;
															#line 77 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	MetaclusterTenantMapEntry entryWithUpdatedGroup;
															#line 103 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Optional<MetaclusterTenantGroupEntry> tenantGroupEntry;
															#line 662 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via updateTenantGroup()
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class UpdateTenantGroupActor final : public Actor<Void>, public ActorCallback< UpdateTenantGroupActor, 0, Void >, public ActorCallback< UpdateTenantGroupActor, 1, Optional<MetaclusterTenantGroupEntry> >, public ActorCallback< UpdateTenantGroupActor, 2, Void >, public ActorCallback< UpdateTenantGroupActor, 3, Void >, public FastAllocated<UpdateTenantGroupActor>, public UpdateTenantGroupActorState<UpdateTenantGroupActor> {
															#line 667 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<UpdateTenantGroupActor>::operator new;
	using FastAllocated<UpdateTenantGroupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15774593970722744064UL, 12902900960190114304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateTenantGroupActor, 0, Void >;
friend struct ActorCallback< UpdateTenantGroupActor, 1, Optional<MetaclusterTenantGroupEntry> >;
friend struct ActorCallback< UpdateTenantGroupActor, 2, Void >;
friend struct ActorCallback< UpdateTenantGroupActor, 3, Void >;
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	UpdateTenantGroupActor(ConfigureTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr,MetaclusterTenantMapEntry const& tenantEntry,Optional<TenantGroupName> const& desiredGroup) 
															#line 687 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<Void>(),
		   UpdateTenantGroupActorState<UpdateTenantGroupActor>(self, tr, tenantEntry, desiredGroup),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateTenantGroup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3604400526074040064UL, 3333443116514339072UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateTenantGroup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateTenantGroup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateTenantGroupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateTenantGroupActor, 1, Optional<MetaclusterTenantGroupEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateTenantGroupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateTenantGroupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] static Future<Void> updateTenantGroup( ConfigureTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr, MetaclusterTenantMapEntry const& tenantEntry, Optional<TenantGroupName> const& desiredGroup ) {
															#line 72 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<Void>(new UpdateTenantGroupActor(self, tr, tenantEntry, desiredGroup));
															#line 722 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 150 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"

	// Updates the configuration in the management cluster and marks it as being in the UPDATING_CONFIGURATION state
																#line 728 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via updateManagementCluster()
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class UpdateManagementClusterActor>
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class UpdateManagementClusterActorState {
															#line 734 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	UpdateManagementClusterActorState(ConfigureTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : self(self),
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   tr(tr)
															#line 743 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("updateManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~UpdateManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("updateManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 154 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, self->tenantName);
															#line 154 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 760 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 154 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<UpdateManagementClusterActor*>(this)));
															#line 765 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateManagementClusterActorState();
		static_cast<UpdateManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!tenantEntry.present())
															#line 788 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 157 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(true, "Configure non-existent tenant");
															#line 158 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 794 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		}
															#line 161 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (tenantEntry.get().tenantState != TenantState::READY && tenantEntry.get().tenantState != TenantState::UPDATING_CONFIGURATION)
															#line 798 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 163 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(true, "Configure tenant in invalid state");
															#line 164 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			return a_body1Catch1(invalid_tenant_state(), loopDepth);
															#line 804 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		}
															#line 167 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		StrictFuture<Void> __when_expr_1 = self->ctx.setCluster(tr, tenantEntry.get().assignedCluster);
															#line 167 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 810 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 167 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateManagementClusterActor, 1, Void >*>(static_cast<UpdateManagementClusterActor*>(this)));
															#line 815 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& __tenantEntry,int loopDepth) 
	{
															#line 154 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		tenantEntry = __tenantEntry;
															#line 824 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateManagementClusterActor*>(this)->ActorCallback< UpdateManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		self->updatedEntry = tenantEntry.get();
															#line 170 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		self->updatedEntry.tenantState = TenantState::UPDATING_CONFIGURATION;
															#line 172 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		ASSERT_EQ(self->lockState.present(), self->lockId.present());
															#line 173 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		ASSERT_NE(self->lockState.present(), self->configurationParameters.size() > 0);
															#line 175 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		configItr = std::map<Standalone<StringRef>, Optional<Value>>::iterator();
															#line 176 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		configItr = self->configurationParameters.begin();
															#line 913 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 169 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		self->updatedEntry = tenantEntry.get();
															#line 170 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		self->updatedEntry.tenantState = TenantState::UPDATING_CONFIGURATION;
															#line 172 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		ASSERT_EQ(self->lockState.present(), self->lockId.present());
															#line 173 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		ASSERT_NE(self->lockState.present(), self->configurationParameters.size() > 0);
															#line 175 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		configItr = std::map<Standalone<StringRef>, Optional<Value>>::iterator();
															#line 176 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		configItr = self->configurationParameters.begin();
															#line 932 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateManagementClusterActor*>(this)->ActorCallback< UpdateManagementClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateManagementClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateManagementClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateManagementClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 193 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (self->lockState.present())
															#line 1016 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 194 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			TenantAPI::checkLockState(tenantEntry.get(), self->lockState.get(), self->lockId.get());
															#line 195 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(self->updatedEntry.tenantLockState == TenantAPI::TenantLockState::LOCKED, "Lock tenant");
															#line 196 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(self->updatedEntry.tenantLockState == TenantAPI::TenantLockState::READ_ONLY, "Read-only lock tenant");
															#line 198 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(self->updatedEntry.tenantLockState == TenantAPI::TenantLockState::UNLOCKED, "Unlock tenant");
															#line 200 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			self->updatedEntry.tenantLockState = self->lockState.get();
															#line 201 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (self->updatedEntry.tenantLockState == TenantAPI::TenantLockState::UNLOCKED)
															#line 1030 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			{
															#line 202 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				self->updatedEntry.tenantLockId = {};
															#line 1034 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			}
			else
			{
															#line 204 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				self->updatedEntry.tenantLockId = self->lockId.get();
															#line 1040 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			}
		}
															#line 208 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (self->updatedEntry.matchesConfiguration(tenantEntry.get()) && tenantEntry.get().tenantState == TenantState::READY)
															#line 1045 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 210 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(true, "Noop configure tenant");
															#line 211 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (!static_cast<UpdateManagementClusterActor*>(this)->SAV<bool>::futures) { (void)(false); this->~UpdateManagementClusterActorState(); static_cast<UpdateManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1051 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			new (&static_cast<UpdateManagementClusterActor*>(this)->SAV< bool >::value()) bool(false);
			this->~UpdateManagementClusterActorState();
			static_cast<UpdateManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 214 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		++self->updatedEntry.configurationSequenceNum;
															#line 215 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		ASSERT_EQ(self->updatedEntry.tenantLockState != TenantAPI::TenantLockState::UNLOCKED, self->updatedEntry.tenantLockId.present());
															#line 217 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		metadata::management::tenantMetadata().tenantMap.set(tr, self->updatedEntry.id, self->updatedEntry);
															#line 218 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 220 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateManagementClusterActor*>(this)->SAV<bool>::futures) { (void)(true); this->~UpdateManagementClusterActorState(); static_cast<UpdateManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1067 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateManagementClusterActor*>(this)->SAV< bool >::value()) bool(true);
		this->~UpdateManagementClusterActorState();
		static_cast<UpdateManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 176 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!(configItr != self->configurationParameters.end()))
															#line 1086 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 178 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (configItr->first == "tenant_group"_sr)
															#line 1092 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 179 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Void> __when_expr_2 = updateTenantGroup(self, tr, self->updatedEntry, configItr->second);
															#line 179 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1098 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state = 3;
															#line 179 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateManagementClusterActor, 2, Void >*>(static_cast<UpdateManagementClusterActor*>(this)));
															#line 1103 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 180 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (configItr->first == "assigned_cluster"_sr && configItr->second != tenantEntry.get().assignedCluster)
															#line 1110 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			{
															#line 182 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				auto& newClusterName = configItr->second;
															#line 183 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				TraceEvent(SevWarn, "CannotChangeAssignedCluster") .detail("TenantName", tenantEntry.get().tenantName) .detail("OriginalAssignedCluster", tenantEntry.get().assignedCluster) .detail("NewAssignedCluster", newClusterName);
															#line 187 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				CODE_PROBE(true, "Attempt to change assigned cluster");
															#line 188 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				return a_body1Catch1(invalid_tenant_configuration(), std::max(0, loopDepth - 1));
															#line 1120 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			}
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 190 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		self->updatedEntry.configure(configItr->first, configItr->second);
															#line 176 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		++configItr;
															#line 1146 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<UpdateManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateManagementClusterActor*>(this)->ActorCallback< UpdateManagementClusterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateManagementClusterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateManagementClusterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateManagementClusterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ConfigureTenantImpl* self;
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 154 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Optional<MetaclusterTenantMapEntry> tenantEntry;
															#line 175 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	std::map<Standalone<StringRef>, Optional<Value>>::iterator configItr;
															#line 1246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via updateManagementCluster()
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class UpdateManagementClusterActor final : public Actor<bool>, public ActorCallback< UpdateManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >, public ActorCallback< UpdateManagementClusterActor, 1, Void >, public ActorCallback< UpdateManagementClusterActor, 2, Void >, public FastAllocated<UpdateManagementClusterActor>, public UpdateManagementClusterActorState<UpdateManagementClusterActor> {
															#line 1251 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<UpdateManagementClusterActor>::operator new;
	using FastAllocated<UpdateManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5240662128962460928UL, 4088766725121525248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >;
friend struct ActorCallback< UpdateManagementClusterActor, 1, Void >;
friend struct ActorCallback< UpdateManagementClusterActor, 2, Void >;
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	UpdateManagementClusterActor(ConfigureTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1270 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<bool>(),
		   UpdateManagementClusterActorState<UpdateManagementClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17834329513570881792UL, 15512391617613087488UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateManagementClusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateManagementClusterActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] static Future<bool> updateManagementCluster( ConfigureTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<bool>(new UpdateManagementClusterActor(self, tr));
															#line 1304 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 222 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"

	// Updates the configuration in the data cluster
																#line 1310 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via updateDataCluster()
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class UpdateDataClusterActor>
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class UpdateDataClusterActorState {
															#line 1316 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	UpdateDataClusterActorState(ConfigureTenantImpl* const& self,Reference<ITransaction> const& tr) 
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : self(self),
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   tr(tr)
															#line 1325 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("updateDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDataClusterActorState() 
	{
		fdb_probe_actor_destroy("updateDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 225 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = TenantAPI::tryGetTenantTransaction(tr, self->updatedEntry.id);
															#line 225 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<UpdateDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1342 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateDataClusterActor*>(this)->actor_wait_state = 1;
															#line 225 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDataClusterActor, 0, Optional<TenantMapEntry> >*>(static_cast<UpdateDataClusterActor*>(this)));
															#line 1347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDataClusterActorState();
		static_cast<UpdateDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 228 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!tenantEntry.present() || tenantEntry.get().configurationSequenceNum >= self->updatedEntry.configurationSequenceNum)
															#line 1370 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 231 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(!tenantEntry.present(), "Tenant removed while configuring on data cluster");
															#line 232 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(tenantEntry.present(), "Tenant configuration already applied on data cluster");
															#line 233 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (!static_cast<UpdateDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterActorState(); static_cast<UpdateDataClusterActor*>(this)->destroy(); return 0; }
															#line 1378 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			new (&static_cast<UpdateDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateDataClusterActorState();
			static_cast<UpdateDataClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 236 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (self->updatedEntry.toTenantMapEntry() == tenantEntry.get())
															#line 1386 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 238 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (!static_cast<UpdateDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterActorState(); static_cast<UpdateDataClusterActor*>(this)->destroy(); return 0; }
															#line 1390 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			new (&static_cast<UpdateDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UpdateDataClusterActorState();
			static_cast<UpdateDataClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 241 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		StrictFuture<Void> __when_expr_1 = TenantAPI::configureTenantTransaction(tr, tenantEntry.get(), self->updatedEntry.toTenantMapEntry());
															#line 241 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (static_cast<UpdateDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1400 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateDataClusterActor*>(this)->actor_wait_state = 2;
															#line 241 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDataClusterActor, 1, Void >*>(static_cast<UpdateDataClusterActor*>(this)));
															#line 1405 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& __tenantEntry,int loopDepth) 
	{
															#line 225 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		tenantEntry = __tenantEntry;
															#line 1414 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDataClusterActor*>(this)->actor_wait_state > 0) static_cast<UpdateDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDataClusterActor*>(this)->ActorCallback< UpdateDataClusterActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDataClusterActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterActorState(); static_cast<UpdateDataClusterActor*>(this)->destroy(); return 0; }
															#line 1493 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateDataClusterActorState();
		static_cast<UpdateDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 242 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<UpdateDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterActorState(); static_cast<UpdateDataClusterActor*>(this)->destroy(); return 0; }
															#line 1505 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<UpdateDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateDataClusterActorState();
		static_cast<UpdateDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateDataClusterActor*>(this)->actor_wait_state > 0) static_cast<UpdateDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDataClusterActor*>(this)->ActorCallback< UpdateDataClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateDataClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ConfigureTenantImpl* self;
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Reference<ITransaction> tr;
															#line 225 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Optional<TenantMapEntry> tenantEntry;
															#line 1594 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via updateDataCluster()
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class UpdateDataClusterActor final : public Actor<Void>, public ActorCallback< UpdateDataClusterActor, 0, Optional<TenantMapEntry> >, public ActorCallback< UpdateDataClusterActor, 1, Void >, public FastAllocated<UpdateDataClusterActor>, public UpdateDataClusterActorState<UpdateDataClusterActor> {
															#line 1599 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<UpdateDataClusterActor>::operator new;
	using FastAllocated<UpdateDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5133102362701133312UL, 3811089808964430848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDataClusterActor, 0, Optional<TenantMapEntry> >;
friend struct ActorCallback< UpdateDataClusterActor, 1, Void >;
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	UpdateDataClusterActor(ConfigureTenantImpl* const& self,Reference<ITransaction> const& tr) 
															#line 1617 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<Void>(),
		   UpdateDataClusterActorState<UpdateDataClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2197521157004316928UL, 13725143648043971840UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDataClusterActor, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateDataClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] static Future<Void> updateDataCluster( ConfigureTenantImpl* const& self, Reference<ITransaction> const& tr ) {
															#line 224 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<Void>(new UpdateDataClusterActor(self, tr));
															#line 1650 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 244 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"

	// Updates the tenant state in the management cluster to READY
																#line 1656 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via markManagementTenantAsReady()
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class MarkManagementTenantAsReadyActor>
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class MarkManagementTenantAsReadyActorState {
															#line 1662 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	MarkManagementTenantAsReadyActorState(ConfigureTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : self(self),
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   tr(tr)
															#line 1671 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this));

	}
	~MarkManagementTenantAsReadyActorState() 
	{
		fdb_probe_actor_destroy("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 248 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, self->updatedEntry.id);
															#line 248 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<MarkManagementTenantAsReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1688 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkManagementTenantAsReadyActor*>(this)->actor_wait_state = 1;
															#line 248 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<MarkManagementTenantAsReadyActor*>(this)));
															#line 1693 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkManagementTenantAsReadyActorState();
		static_cast<MarkManagementTenantAsReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 251 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!tenantEntry.present() || (tenantEntry.get().tenantState != TenantState::UPDATING_CONFIGURATION) || tenantEntry.get().configurationSequenceNum > self->updatedEntry.configurationSequenceNum)
															#line 1716 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 253 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(!tenantEntry.present(), "Tenant removed while configuring on management cluster");
															#line 254 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(tenantEntry.present(), "Tenant configuration already applied on management cluster");
															#line 255 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (!static_cast<MarkManagementTenantAsReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkManagementTenantAsReadyActorState(); static_cast<MarkManagementTenantAsReadyActor*>(this)->destroy(); return 0; }
															#line 1724 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			new (&static_cast<MarkManagementTenantAsReadyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MarkManagementTenantAsReadyActorState();
			static_cast<MarkManagementTenantAsReadyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 258 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		tenantEntry.get().tenantState = TenantState::READY;
															#line 259 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		metadata::management::tenantMetadata().tenantMap.set(tr, tenantEntry.get().id, tenantEntry.get());
															#line 260 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 261 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<MarkManagementTenantAsReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkManagementTenantAsReadyActorState(); static_cast<MarkManagementTenantAsReadyActor*>(this)->destroy(); return 0; }
															#line 1738 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<MarkManagementTenantAsReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkManagementTenantAsReadyActorState();
		static_cast<MarkManagementTenantAsReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& __tenantEntry,int loopDepth) 
	{
															#line 248 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		tenantEntry = __tenantEntry;
															#line 1750 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkManagementTenantAsReadyActor*>(this)->actor_wait_state > 0) static_cast<MarkManagementTenantAsReadyActor*>(this)->actor_wait_state = 0;
		static_cast<MarkManagementTenantAsReadyActor*>(this)->ActorCallback< MarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< MarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkManagementTenantAsReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkManagementTenantAsReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkManagementTenantAsReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ConfigureTenantImpl* self;
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 248 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Optional<MetaclusterTenantMapEntry> tenantEntry;
															#line 1831 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via markManagementTenantAsReady()
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class MarkManagementTenantAsReadyActor final : public Actor<Void>, public ActorCallback< MarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >, public FastAllocated<MarkManagementTenantAsReadyActor>, public MarkManagementTenantAsReadyActorState<MarkManagementTenantAsReadyActor> {
															#line 1836 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<MarkManagementTenantAsReadyActor>::operator new;
	using FastAllocated<MarkManagementTenantAsReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3373361384350527232UL, 8678491781402048000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >;
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	MarkManagementTenantAsReadyActor(ConfigureTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1853 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<Void>(),
		   MarkManagementTenantAsReadyActorState<MarkManagementTenantAsReadyActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9962225427787402752UL, 9224751761776315648UL);
		ActorExecutionContextHelper __helper(static_cast<MarkManagementTenantAsReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markManagementTenantAsReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markManagementTenantAsReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] static Future<Void> markManagementTenantAsReady( ConfigureTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<Void>(new MarkManagementTenantAsReadyActor(self, tr));
															#line 1885 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 263 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"

																#line 1890 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via forceMarkManagementTenantAsReady()
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class ForceMarkManagementTenantAsReadyActor>
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class ForceMarkManagementTenantAsReadyActorState {
															#line 1896 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ForceMarkManagementTenantAsReadyActorState(ConfigureTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : self(self),
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   tr(tr)
															#line 1905 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this));

	}
	~ForceMarkManagementTenantAsReadyActorState() 
	{
		fdb_probe_actor_destroy("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 266 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, self->tenantName);
															#line 266 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1922 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->actor_wait_state = 1;
															#line 266 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForceMarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<ForceMarkManagementTenantAsReadyActor*>(this)));
															#line 1927 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForceMarkManagementTenantAsReadyActorState();
		static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 268 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!tenantEntry.present())
															#line 1950 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 269 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			CODE_PROBE(true, "Configure tenant state for non-existent tenant", probe::decoration::rare);
															#line 270 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 1956 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		}
															#line 273 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (tenantEntry.get().tenantState == metacluster::TenantState::READY)
															#line 1960 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 276 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (!static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForceMarkManagementTenantAsReadyActorState(); static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->destroy(); return 0; }
															#line 1964 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			new (&static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ForceMarkManagementTenantAsReadyActorState();
			static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 277 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (tenantEntry.get().tenantState != metacluster::TenantState::ERROR)
															#line 1974 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			{
															#line 278 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				TraceEvent(SevError, "TenantStateNotError") .detail("Tenant", self->tenantName) .detail("State", tenantEntry.get().tenantState);
															#line 281 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				return a_body1Catch1(invalid_tenant_state(), loopDepth);
															#line 1980 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			}
		}
															#line 283 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		self->updatedEntry = tenantEntry.get();
															#line 284 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		self->updatedEntry.tenantState = metacluster::TenantState::READY;
															#line 285 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		metadata::management::tenantMetadata().tenantMap.set(tr, self->updatedEntry.id, self->updatedEntry);
															#line 286 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 288 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForceMarkManagementTenantAsReadyActorState(); static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->destroy(); return 0; }
															#line 1993 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForceMarkManagementTenantAsReadyActorState();
		static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& __tenantEntry,int loopDepth) 
	{
															#line 266 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		tenantEntry = __tenantEntry;
															#line 2005 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->actor_wait_state > 0) static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->actor_wait_state = 0;
		static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->ActorCallback< ForceMarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< ForceMarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForceMarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForceMarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ConfigureTenantImpl* self;
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 266 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Optional<MetaclusterTenantMapEntry> tenantEntry;
															#line 2086 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via forceMarkManagementTenantAsReady()
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class ForceMarkManagementTenantAsReadyActor final : public Actor<Void>, public ActorCallback< ForceMarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >, public FastAllocated<ForceMarkManagementTenantAsReadyActor>, public ForceMarkManagementTenantAsReadyActorState<ForceMarkManagementTenantAsReadyActor> {
															#line 2091 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<ForceMarkManagementTenantAsReadyActor>::operator new;
	using FastAllocated<ForceMarkManagementTenantAsReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10679431528844026112UL, 14697586838483827456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForceMarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >;
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ForceMarkManagementTenantAsReadyActor(ConfigureTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 2108 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<Void>(),
		   ForceMarkManagementTenantAsReadyActorState<ForceMarkManagementTenantAsReadyActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11199421093871181824UL, 10105561806147165696UL);
		ActorExecutionContextHelper __helper(static_cast<ForceMarkManagementTenantAsReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forceMarkManagementTenantAsReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forceMarkManagementTenantAsReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForceMarkManagementTenantAsReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] static Future<Void> forceMarkManagementTenantAsReady( ConfigureTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<Void>(new ForceMarkManagementTenantAsReadyActor(self, tr));
															#line 2140 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 290 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"

																#line 2145 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via run()
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class RunActor>
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class RunActorState {
															#line 2151 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	RunActorState(ConfigureTenantImpl* const& self) 
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : self(self),
															#line 294 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   parameters(self->configurationParameters)
															#line 2160 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 295 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			RangeForbody1Iterator0 = std::begin(parameters);
															#line 2175 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 310 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		StrictFuture<bool> __when_expr_1 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return updateManagementCluster(self, tr); });
															#line 310 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2200 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 310 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, bool >*>(static_cast<RunActor*>(this)));
															#line 2205 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 295 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!(RangeForbody1Iterator0 != std::end(parameters)))
															#line 2221 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 295 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		const auto& [configKey, configValue] = *RangeForbody1Iterator0;
															#line 2227 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 296 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (configKey == "tenant_state"_sr)
															#line 2231 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			{
															#line 297 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
				if (self->configurationParameters.size() > 1)
															#line 2235 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
				{
															#line 298 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					CODE_PROBE(true, "SettingTenantStateWithOtherConfigs", probe::decoration::rare);
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					TraceEvent(SevError, "ConfigureTenantStateWithOtherProperties").detail("Tenant", self->tenantName);
															#line 300 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					return a_body1Catch1(invalid_tenant_configuration(), std::max(0, loopDepth - 1));
															#line 2243 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
				}
				else
				{
															#line 302 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					StrictFuture<Void> __when_expr_0 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return forceMarkManagementTenantAsReady(self, tr); });
															#line 302 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2251 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
					static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 302 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 2256 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 295 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		++RangeForbody1Iterator0;
															#line 2285 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 2300 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 2312 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(bool const& configUpdated,int loopDepth) 
	{
															#line 313 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (configUpdated)
															#line 2399 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 314 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Void> __when_expr_2 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return updateDataCluster(self, tr); });
															#line 314 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2405 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 314 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 2410 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool && configUpdated,int loopDepth) 
	{
															#line 313 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (configUpdated)
															#line 2424 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		{
															#line 314 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Void> __when_expr_2 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return updateDataCluster(self, tr); });
															#line 314 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2430 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 314 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 2435 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(bool const& configUpdated,int loopDepth) 
	{
		loopDepth = a_body1cont2(configUpdated, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && configUpdated,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(configUpdated), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 321 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 2524 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 316 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		StrictFuture<Void> __when_expr_3 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return markManagementTenantAsReady(self, tr); });
															#line 316 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2538 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 4;
															#line 316 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunActor, 3, Void >*>(static_cast<RunActor*>(this)));
															#line 2543 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 316 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		StrictFuture<Void> __when_expr_3 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return markManagementTenantAsReady(self, tr); });
															#line 316 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2554 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 4;
															#line 316 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunActor, 3, Void >*>(static_cast<RunActor*>(this)));
															#line 2559 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ConfigureTenantImpl* self;
															#line 294 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	std::map<Standalone<StringRef>, Optional<Value>> parameters;
															#line 295 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	decltype(std::begin(std::declval<std::map<Standalone<StringRef>, Optional<Value>>>())) RangeForbody1Iterator0;
															#line 2732 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via run()
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorCallback< RunActor, 1, bool >, public ActorCallback< RunActor, 2, Void >, public ActorCallback< RunActor, 3, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 2737 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7994808165966798592UL, 9559459467584092416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorCallback< RunActor, 1, bool >;
friend struct ActorCallback< RunActor, 2, Void >;
friend struct ActorCallback< RunActor, 3, Void >;
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	RunActor(ConfigureTenantImpl* const& self) 
															#line 2757 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] static Future<Void> run( ConfigureTenantImpl* const& self ) {
															#line 291 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<Void>(new RunActor(self));
															#line 2792 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 323 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Future<Void> run() { return run(this); }
};
} // namespace internal

															#line 2800 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via configureTenant()
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB, class ConfigureTenantActor>
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class ConfigureTenantActorState {
															#line 2806 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ConfigureTenantActorState(Reference<DB> const& db,TenantName const& name,std::map<Standalone<StringRef>, Optional<Value>> const& configurationParameters,IgnoreCapacityLimit const& ignoreCapacityLimit) 
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : db(db),
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   name(name),
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   configurationParameters(configurationParameters),
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   ignoreCapacityLimit(ignoreCapacityLimit),
															#line 332 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   impl(db, name, configurationParameters, ignoreCapacityLimit)
															#line 2821 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureTenantActorState() 
	{
		fdb_probe_actor_destroy("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 333 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 333 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2838 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 1;
															#line 333 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 0, Void >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 2843 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 2866 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 2878 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Reference<DB> db;
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	TenantName name;
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	std::map<Standalone<StringRef>, Optional<Value>> configurationParameters;
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	IgnoreCapacityLimit ignoreCapacityLimit;
															#line 332 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	internal::ConfigureTenantImpl<DB> impl;
															#line 2971 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via configureTenant()
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB>
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class ConfigureTenantActor final : public Actor<Void>, public ActorCallback< ConfigureTenantActor<DB>, 0, Void >, public FastAllocated<ConfigureTenantActor<DB>>, public ConfigureTenantActorState<DB, ConfigureTenantActor<DB>> {
															#line 2978 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<ConfigureTenantActor<DB>>::operator new;
	using FastAllocated<ConfigureTenantActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10841923675320472320UL, 587645444864322816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureTenantActor<DB>, 0, Void >;
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ConfigureTenantActor(Reference<DB> const& db,TenantName const& name,std::map<Standalone<StringRef>, Optional<Value>> const& configurationParameters,IgnoreCapacityLimit const& ignoreCapacityLimit) 
															#line 2995 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<Void>(),
		   ConfigureTenantActorState<DB, ConfigureTenantActor<DB>>(db, name, configurationParameters, ignoreCapacityLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7048885742222706688UL, 1739664772098993408UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureTenantActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB>
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] Future<Void> configureTenant( Reference<DB> const& db, TenantName const& name, std::map<Standalone<StringRef>, Optional<Value>> const& configurationParameters, IgnoreCapacityLimit const& ignoreCapacityLimit ) {
															#line 327 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<Void>(new ConfigureTenantActor<DB>(db, name, configurationParameters, ignoreCapacityLimit));
															#line 3029 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 336 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"

															#line 3034 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via changeTenantLockState()
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB, class ChangeTenantLockStateActor>
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class ChangeTenantLockStateActorState {
															#line 3040 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ChangeTenantLockStateActorState(Reference<DB> const& db,TenantName const& name,TenantAPI::TenantLockState const& lockState,UID const& lockId) 
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : db(db),
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   name(name),
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   lockState(lockState),
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   lockId(lockId),
															#line 342 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   impl(db, name, lockState, lockId)
															#line 3055 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("changeTenantLockState", reinterpret_cast<unsigned long>(this));

	}
	~ChangeTenantLockStateActorState() 
	{
		fdb_probe_actor_destroy("changeTenantLockState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 343 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 343 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<ChangeTenantLockStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3072 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeTenantLockStateActor*>(this)->actor_wait_state = 1;
															#line 343 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeTenantLockStateActor, 0, Void >*>(static_cast<ChangeTenantLockStateActor*>(this)));
															#line 3077 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeTenantLockStateActorState();
		static_cast<ChangeTenantLockStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 344 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<ChangeTenantLockStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeTenantLockStateActorState(); static_cast<ChangeTenantLockStateActor*>(this)->destroy(); return 0; }
															#line 3100 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<ChangeTenantLockStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeTenantLockStateActorState();
		static_cast<ChangeTenantLockStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 344 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<ChangeTenantLockStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeTenantLockStateActorState(); static_cast<ChangeTenantLockStateActor*>(this)->destroy(); return 0; }
															#line 3112 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<ChangeTenantLockStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeTenantLockStateActorState();
		static_cast<ChangeTenantLockStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeTenantLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeTenantLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeTenantLockStateActor*>(this)->ActorCallback< ChangeTenantLockStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeTenantLockStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeTenantLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeTenantLockStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeTenantLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeTenantLockStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeTenantLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantLockState", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Reference<DB> db;
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	TenantName name;
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	TenantAPI::TenantLockState lockState;
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	UID lockId;
															#line 342 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	internal::ConfigureTenantImpl<DB> impl;
															#line 3205 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via changeTenantLockState()
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB>
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class ChangeTenantLockStateActor final : public Actor<Void>, public ActorCallback< ChangeTenantLockStateActor<DB>, 0, Void >, public FastAllocated<ChangeTenantLockStateActor<DB>>, public ChangeTenantLockStateActorState<DB, ChangeTenantLockStateActor<DB>> {
															#line 3212 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<ChangeTenantLockStateActor<DB>>::operator new;
	using FastAllocated<ChangeTenantLockStateActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10392809136218900736UL, 6660577798746413824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeTenantLockStateActor<DB>, 0, Void >;
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ChangeTenantLockStateActor(Reference<DB> const& db,TenantName const& name,TenantAPI::TenantLockState const& lockState,UID const& lockId) 
															#line 3229 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<Void>(),
		   ChangeTenantLockStateActorState<DB, ChangeTenantLockStateActor<DB>>(db, name, lockState, lockId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeTenantLockState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14204955068219423232UL, 17390801140610740736UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeTenantLockState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeTenantLockState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeTenantLockStateActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB>
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] Future<Void> changeTenantLockState( Reference<DB> const& db, TenantName const& name, TenantAPI::TenantLockState const& lockState, UID const& lockId ) {
															#line 337 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<Void>(new ChangeTenantLockStateActor<DB>(db, name, lockState, lockId));
															#line 3263 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 346 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"

															#line 3268 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
// This generated class is to be used only via resetTenantStateToReady()
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB, class ResetTenantStateToReadyActor>
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class ResetTenantStateToReadyActorState {
															#line 3274 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ResetTenantStateToReadyActorState(Reference<DB> const& db,TenantName const& name) 
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		 : db(db),
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   name(name),
															#line 349 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		   impl(db, name, std::map<Standalone<StringRef>, Optional<Value>>{ { "tenant_state"_sr, metacluster::tenantStateToString(metacluster::TenantState::READY) } }, IgnoreCapacityLimit::False)
															#line 3285 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
	{
		fdb_probe_actor_create("resetTenantStateToReady", reinterpret_cast<unsigned long>(this));

	}
	~ResetTenantStateToReadyActorState() 
	{
		fdb_probe_actor_destroy("resetTenantStateToReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 355 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 355 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			if (static_cast<ResetTenantStateToReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3302 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResetTenantStateToReadyActor*>(this)->actor_wait_state = 1;
															#line 355 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResetTenantStateToReadyActor, 0, Void >*>(static_cast<ResetTenantStateToReadyActor*>(this)));
															#line 3307 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResetTenantStateToReadyActorState();
		static_cast<ResetTenantStateToReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 356 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<ResetTenantStateToReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetTenantStateToReadyActorState(); static_cast<ResetTenantStateToReadyActor*>(this)->destroy(); return 0; }
															#line 3330 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<ResetTenantStateToReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetTenantStateToReadyActorState();
		static_cast<ResetTenantStateToReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 356 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
		if (!static_cast<ResetTenantStateToReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetTenantStateToReadyActorState(); static_cast<ResetTenantStateToReadyActor*>(this)->destroy(); return 0; }
															#line 3342 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		new (&static_cast<ResetTenantStateToReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetTenantStateToReadyActorState();
		static_cast<ResetTenantStateToReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResetTenantStateToReadyActor*>(this)->actor_wait_state > 0) static_cast<ResetTenantStateToReadyActor*>(this)->actor_wait_state = 0;
		static_cast<ResetTenantStateToReadyActor*>(this)->ActorCallback< ResetTenantStateToReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetTenantStateToReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetTenantStateToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetTenantStateToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetTenantStateToReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetTenantStateToReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetTenantStateToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetTenantStateToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetTenantStateToReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResetTenantStateToReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetTenantStateToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetTenantStateToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetTenantStateToReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	Reference<DB> db;
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	TenantName name;
															#line 349 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	internal::ConfigureTenantImpl<DB> impl;
															#line 3431 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
};
// This generated class is to be used only via resetTenantStateToReady()
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB>
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
class ResetTenantStateToReadyActor final : public Actor<Void>, public ActorCallback< ResetTenantStateToReadyActor<DB>, 0, Void >, public FastAllocated<ResetTenantStateToReadyActor<DB>>, public ResetTenantStateToReadyActorState<DB, ResetTenantStateToReadyActor<DB>> {
															#line 3438 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
public:
	using FastAllocated<ResetTenantStateToReadyActor<DB>>::operator new;
	using FastAllocated<ResetTenantStateToReadyActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4524032431733762560UL, 10840527702795820800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResetTenantStateToReadyActor<DB>, 0, Void >;
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	ResetTenantStateToReadyActor(Reference<DB> const& db,TenantName const& name) 
															#line 3455 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
		 : Actor<Void>(),
		   ResetTenantStateToReadyActorState<DB, ResetTenantStateToReadyActor<DB>>(db, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resetTenantStateToReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18081578551775412480UL, 1170345153099315200UL);
		ActorExecutionContextHelper __helper(static_cast<ResetTenantStateToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resetTenantStateToReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resetTenantStateToReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResetTenantStateToReadyActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
template <class DB>
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
[[nodiscard]] Future<Void> resetTenantStateToReady( Reference<DB> const& db, TenantName const& name ) {
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"
	return Future<Void>(new ResetTenantStateToReadyActor<DB>(db, name));
															#line 3489 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ConfigureTenant.actor.g.h"
}

#line 358 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/metacluster/include/metacluster/ConfigureTenant.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif