#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
/*
 * AutomaticIdempotencyWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
struct ValueType {
	static constexpr FileIdentifier file_identifier = 9556754;

	Value idempotencyId;
	int64_t createdTime;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, idempotencyId, createdTime);
	}
};
} // namespace

// This tests launches a bunch of transactions with idempotency ids (so they should be idempotent automatically). Each
// transaction sets a version stamped key, and then we check that the right number of transactions were committed.
// If a transaction commits multiple times or doesn't commit, that probably indicates a problem with
// `determineCommitStatus` in NativeAPI.
struct AutomaticIdempotencyWorkload : TestWorkload {
	static constexpr auto NAME = "AutomaticIdempotencyCorrectness";
	int64_t numTransactions;
	Key keyPrefix;
	int64_t minMinAgeSeconds;
	double automaticPercentage;
	constexpr static double slop = 2.0;
	double pollingInterval;
	bool disableAutomaticIdempotency = false;

	bool ok = true;

	struct SharedConfiguration {
		bool disableAutomaticIdempotency = false;

		Tuple pack() const { return Tuple::makeTuple(disableAutomaticIdempotency); }

		static SharedConfiguration unpack(Tuple const& tuple) {
			SharedConfiguration config;
			config.disableAutomaticIdempotency = tuple.getBool(0);
			return config;
		}
	};

	KeyBackedProperty<SharedConfiguration, TupleCodec<SharedConfiguration>, false> sharedConfigProperty;
	SharedConfiguration sharedConfig;

	AutomaticIdempotencyWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), sharedConfigProperty("/testConfig"_sr) {
		numTransactions = getOption(options, "numTransactions"_sr, 500);
		keyPrefix = KeyRef(getOption(options, "keyPrefix"_sr, "/autoIdempotency/"_sr));
		minMinAgeSeconds = getOption(options, "minMinAgeSeconds"_sr, 15);
		automaticPercentage = getOption(options, "automaticPercentage"_sr, 0.1);
		pollingInterval = getOption(options, "pollingInterval"_sr, 5.0);

		// Disable use of automatic idempotency most of the time so we do more extensive cleanup validation
		if (clientId == 0 && deterministicRandom()->random01() < 0.9) {
			sharedConfig.disableAutomaticIdempotency = true;
		}
	}

																#line 88 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class _setupActor>
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class _setupActorState {
															#line 94 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	_setupActorState(AutomaticIdempotencyWorkload* const& self,Database const& cx) 
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   cx(cx)
															#line 103 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (self->clientId == 0)
															#line 118 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			{
															#line 88 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->sharedConfigProperty.set(cx.getReference(), self->sharedConfig);
															#line 88 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 124 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 88 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 129 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 90 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				;
															#line 136 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 100 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (self->sharedConfig.disableAutomaticIdempotency)
															#line 160 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 101 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			self->automaticPercentage = 0;
															#line 164 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 104 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 168 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Optional<SharedConfiguration>> __when_expr_1 = self->sharedConfigProperty.get(cx.getReference());
															#line 91 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 282 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 91 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Optional<SharedConfiguration> >*>(static_cast<_setupActor*>(this)));
															#line 287 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<SharedConfiguration> const& sharedConfig,int loopDepth) 
	{
															#line 92 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (sharedConfig.present())
															#line 309 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 93 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			self->sharedConfig = sharedConfig.get();
															#line 313 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 96 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 96 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 320 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 96 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 325 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<SharedConfiguration> && sharedConfig,int loopDepth) 
	{
															#line 92 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (sharedConfig.present())
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 93 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			self->sharedConfig = sharedConfig.get();
															#line 338 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 96 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 96 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 345 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 96 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 350 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<SharedConfiguration> const& sharedConfig,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(sharedConfig, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<SharedConfiguration> && sharedConfig,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(sharedConfig), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Optional<SharedConfiguration> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Optional<SharedConfiguration> >*,Optional<SharedConfiguration> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Optional<SharedConfiguration> >*,Optional<SharedConfiguration> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Optional<SharedConfiguration> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Database cx;
															#line 521 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Optional<SharedConfiguration> >, public ActorCallback< _setupActor, 2, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 526 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8845351780135022848UL, 13282561397270670336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Optional<SharedConfiguration> >;
friend struct ActorCallback< _setupActor, 2, Void >;
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	_setupActor(AutomaticIdempotencyWorkload* const& self,Database const& cx) 
															#line 545 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Optional<SharedConfiguration> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( AutomaticIdempotencyWorkload* const& self, Database const& cx ) {
															#line 86 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 579 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 106 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

	Future<Void> setup(Database const& cx) override { return _setup(this, cx); }

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

																#line 588 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class _startActor>
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class _startActorState {
															#line 594 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	_startActorState(AutomaticIdempotencyWorkload* const& self,Database const& cx) 
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   cx(cx),
															#line 112 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   i(0)
															#line 605 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			;
															#line 620 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 138 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 643 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!(i < self->numTransactions))
															#line 662 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 115 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		int length = deterministicRandom()->coinflip() ? 16 : deterministicRandom()->randomInt(17, 256);
															#line 116 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		idempotencyId = makeString(length);
															#line 117 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(idempotencyId), length);
															#line 118 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		TraceEvent("IdempotencyIdWorkloadTransaction").detail("Id", idempotencyId);
															#line 119 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = runRYWTransaction( cx, [self = self, idempotencyId = idempotencyId](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::IDEMPOTENCY_ID, idempotencyId); if (deterministicRandom()->random01() < self->automaticPercentage) { tr->setOption(FDBTransactionOptions::AUTOMATIC_IDEMPOTENCY); } uint32_t index = self->keyPrefix.size(); Value suffix = makeString(14); memset(mutateString(suffix), 0, 10); memcpy(mutateString(suffix) + 10, &index, 4); tr->atomicOp(self->keyPrefix.withSuffix(suffix), ObjectWriter::toValue(ValueType{ idempotencyId, int64_t(now()) }, Unversioned()), MutationRef::SetVersionstampedKey); return Future<Void>(Void()); });
															#line 119 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 678 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 119 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 683 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		++i;
															#line 705 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		++i;
															#line 714 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Database cx;
															#line 112 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	int i;
															#line 116 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Value idempotencyId;
															#line 802 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 807 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18111021548209294336UL, 15677974240077172480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	_startActor(AutomaticIdempotencyWorkload* const& self,Database const& cx) 
															#line 824 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( AutomaticIdempotencyWorkload* const& self, Database const& cx ) {
															#line 111 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 856 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 140 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override {
		if (clientId != 0) {
			return true;
		}
		return testAll(this, cx);
	}

																#line 868 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via testAll()
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class TestAllActor>
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class TestAllActorState {
															#line 874 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	TestAllActorState(AutomaticIdempotencyWorkload* const& self,Database const& db) 
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   db(db)
															#line 883 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testAll", reinterpret_cast<unsigned long>(this));

	}
	~TestAllActorState() 
	{
		fdb_probe_actor_destroy("testAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 149 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(db, [=](Reference<ReadYourWritesTransaction> tr) { return logIdempotencyIds(self, tr); });
															#line 149 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<TestAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 900 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAllActor*>(this)->actor_wait_state = 1;
															#line 149 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAllActor, 0, Void >*>(static_cast<TestAllActor*>(this)));
															#line 905 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAllActorState();
		static_cast<TestAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransaction(db, [=](Reference<ReadYourWritesTransaction> tr) { return testIdempotency(self, tr); });
															#line 151 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 930 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAllActor*>(this)->actor_wait_state = 2;
															#line 151 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAllActor, 1, Void >*>(static_cast<TestAllActor*>(this)));
															#line 935 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransaction(db, [=](Reference<ReadYourWritesTransaction> tr) { return testIdempotency(self, tr); });
															#line 151 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 946 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestAllActor*>(this)->actor_wait_state = 2;
															#line 151 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAllActor, 1, Void >*>(static_cast<TestAllActor*>(this)));
															#line 951 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAllActor*>(this)->actor_wait_state > 0) static_cast<TestAllActor*>(this)->actor_wait_state = 0;
		static_cast<TestAllActor*>(this)->ActorCallback< TestAllActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAllActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAllActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAllActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = testCleaner(self, db);
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1037 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAllActor*>(this)->actor_wait_state = 3;
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAllActor, 2, Void >*>(static_cast<TestAllActor*>(this)));
															#line 1042 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = testCleaner(self, db);
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1053 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAllActor*>(this)->actor_wait_state = 3;
															#line 152 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAllActor, 2, Void >*>(static_cast<TestAllActor*>(this)));
															#line 1058 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAllActor*>(this)->actor_wait_state > 0) static_cast<TestAllActor*>(this)->actor_wait_state = 0;
		static_cast<TestAllActor*>(this)->ActorCallback< TestAllActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAllActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAllActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAllActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<TestAllActor*>(this)->SAV<bool>::futures) { (void)(self->ok); this->~TestAllActorState(); static_cast<TestAllActor*>(this)->destroy(); return 0; }
															#line 1142 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<TestAllActor*>(this)->SAV< bool >::value()) bool(self->ok);
		this->~TestAllActorState();
		static_cast<TestAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<TestAllActor*>(this)->SAV<bool>::futures) { (void)(self->ok); this->~TestAllActorState(); static_cast<TestAllActor*>(this)->destroy(); return 0; }
															#line 1154 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<TestAllActor*>(this)->SAV< bool >::value()) bool(self->ok);
		this->~TestAllActorState();
		static_cast<TestAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAllActor*>(this)->actor_wait_state > 0) static_cast<TestAllActor*>(this)->actor_wait_state = 0;
		static_cast<TestAllActor*>(this)->ActorCallback< TestAllActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAllActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAllActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAllActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Database db;
															#line 1241 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via testAll()
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class TestAllActor final : public Actor<bool>, public ActorCallback< TestAllActor, 0, Void >, public ActorCallback< TestAllActor, 1, Void >, public ActorCallback< TestAllActor, 2, Void >, public FastAllocated<TestAllActor>, public TestAllActorState<TestAllActor> {
															#line 1246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<TestAllActor>::operator new;
	using FastAllocated<TestAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12398934471527963648UL, 239819689320898816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAllActor, 0, Void >;
friend struct ActorCallback< TestAllActor, 1, Void >;
friend struct ActorCallback< TestAllActor, 2, Void >;
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	TestAllActor(AutomaticIdempotencyWorkload* const& self,Database const& db) 
															#line 1265 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   TestAllActorState<TestAllActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3253476871931972096UL, 13052758622285074432UL);
		ActorExecutionContextHelper __helper(static_cast<TestAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAllActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAllActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAllActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<bool> testAll( AutomaticIdempotencyWorkload* const& self, Database const& db ) {
															#line 148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<bool>(new TestAllActor(self, db));
															#line 1299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 155 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

																#line 1304 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via logIdempotencyIds()
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class LogIdempotencyIdsActor>
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class LogIdempotencyIdsActorState {
															#line 1310 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	LogIdempotencyIdsActorState(AutomaticIdempotencyWorkload* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   tr(tr)
															#line 1319 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("logIdempotencyIds", reinterpret_cast<unsigned long>(this));

	}
	~LogIdempotencyIdsActorState() 
	{
		fdb_probe_actor_destroy("logIdempotencyIds", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 158 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 159 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(idempotencyIdKeys, CLIENT_KNOBS->TOO_MANY);
															#line 159 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<LogIdempotencyIdsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1338 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LogIdempotencyIdsActor*>(this)->actor_wait_state = 1;
															#line 159 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogIdempotencyIdsActor, 0, RangeResult >*>(static_cast<LogIdempotencyIdsActor*>(this)));
															#line 1343 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogIdempotencyIdsActorState();
		static_cast<LogIdempotencyIdsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(!result.more);
															#line 161 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& [k, v] : result ) {
															#line 162 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			Version commitVersion;
															#line 163 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			uint8_t highOrderBatchIndex;
															#line 164 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			decodeIdempotencyKey(k, commitVersion, highOrderBatchIndex);
															#line 165 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			BinaryReader valReader(v, IncludeVersion());
															#line 166 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			int64_t timestamp;
															#line 167 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			valReader >> timestamp;
															#line 168 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			for(;!valReader.empty();) {
															#line 169 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				uint8_t length;
															#line 170 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				valReader >> length;
															#line 171 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				StringRef id{ reinterpret_cast<const uint8_t*>(valReader.readBytes(length)), length };
															#line 172 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				uint8_t lowOrderBatchIndex;
															#line 173 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				valReader >> lowOrderBatchIndex;
															#line 174 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				TraceEvent("IdempotencyIdWorkloadIdCommitted") .detail("CommitVersion", commitVersion) .detail("HighOrderBatchIndex", highOrderBatchIndex) .detail("Id", id);
															#line 1394 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			}
		}
															#line 180 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<LogIdempotencyIdsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogIdempotencyIdsActorState(); static_cast<LogIdempotencyIdsActor*>(this)->destroy(); return 0; }
															#line 1399 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<LogIdempotencyIdsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogIdempotencyIdsActorState();
		static_cast<LogIdempotencyIdsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(!result.more);
															#line 161 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& [k, v] : result ) {
															#line 162 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			Version commitVersion;
															#line 163 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			uint8_t highOrderBatchIndex;
															#line 164 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			decodeIdempotencyKey(k, commitVersion, highOrderBatchIndex);
															#line 165 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			BinaryReader valReader(v, IncludeVersion());
															#line 166 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			int64_t timestamp;
															#line 167 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			valReader >> timestamp;
															#line 168 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			for(;!valReader.empty();) {
															#line 169 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				uint8_t length;
															#line 170 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				valReader >> length;
															#line 171 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				StringRef id{ reinterpret_cast<const uint8_t*>(valReader.readBytes(length)), length };
															#line 172 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				uint8_t lowOrderBatchIndex;
															#line 173 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				valReader >> lowOrderBatchIndex;
															#line 174 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				TraceEvent("IdempotencyIdWorkloadIdCommitted") .detail("CommitVersion", commitVersion) .detail("HighOrderBatchIndex", highOrderBatchIndex) .detail("Id", id);
															#line 1439 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			}
		}
															#line 180 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<LogIdempotencyIdsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LogIdempotencyIdsActorState(); static_cast<LogIdempotencyIdsActor*>(this)->destroy(); return 0; }
															#line 1444 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<LogIdempotencyIdsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LogIdempotencyIdsActorState();
		static_cast<LogIdempotencyIdsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogIdempotencyIdsActor*>(this)->actor_wait_state > 0) static_cast<LogIdempotencyIdsActor*>(this)->actor_wait_state = 0;
		static_cast<LogIdempotencyIdsActor*>(this)->ActorCallback< LogIdempotencyIdsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LogIdempotencyIdsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("logIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogIdempotencyIdsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("logIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogIdempotencyIdsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("logIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logIdempotencyIds", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1531 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via logIdempotencyIds()
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class LogIdempotencyIdsActor final : public Actor<Void>, public ActorCallback< LogIdempotencyIdsActor, 0, RangeResult >, public FastAllocated<LogIdempotencyIdsActor>, public LogIdempotencyIdsActorState<LogIdempotencyIdsActor> {
															#line 1536 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<LogIdempotencyIdsActor>::operator new;
	using FastAllocated<LogIdempotencyIdsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13026360257148705024UL, 14042224138149164544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogIdempotencyIdsActor, 0, RangeResult >;
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	LogIdempotencyIdsActor(AutomaticIdempotencyWorkload* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 1553 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   LogIdempotencyIdsActorState<LogIdempotencyIdsActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logIdempotencyIds", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12855991817872722944UL, 16029718502867472384UL);
		ActorExecutionContextHelper __helper(static_cast<LogIdempotencyIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logIdempotencyIds");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logIdempotencyIds", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogIdempotencyIdsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> logIdempotencyIds( AutomaticIdempotencyWorkload* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<Void>(new LogIdempotencyIdsActor(self, tr));
															#line 1585 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 182 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

	// Check that each transaction committed exactly once.
																#line 1591 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via testIdempotency()
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class TestIdempotencyActor>
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class TestIdempotencyActorState {
															#line 1597 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	TestIdempotencyActorState(AutomaticIdempotencyWorkload* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   tr(tr)
															#line 1606 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testIdempotency", reinterpret_cast<unsigned long>(this));

	}
	~TestIdempotencyActorState() 
	{
		fdb_probe_actor_destroy("testIdempotency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 186 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(prefixRange(self->keyPrefix), CLIENT_KNOBS->TOO_MANY);
															#line 186 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<TestIdempotencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1623 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestIdempotencyActor*>(this)->actor_wait_state = 1;
															#line 186 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestIdempotencyActor, 0, RangeResult >*>(static_cast<TestIdempotencyActor*>(this)));
															#line 1628 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestIdempotencyActorState();
		static_cast<TestIdempotencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 187 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(!result.more);
															#line 188 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		std::unordered_set<Value> ids;
															#line 190 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& [k, v] : result ) {
															#line 191 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			ids.emplace(v);
															#line 1657 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 193 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& [k, rawValue] : result ) {
															#line 194 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			auto v = ObjectReader::fromStringRef<ValueType>(rawValue, Unversioned());
															#line 195 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			BinaryReader reader(k, Unversioned());
															#line 196 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			reader.readBytes(self->keyPrefix.size());
															#line 197 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			Version commitVersion;
															#line 198 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			reader >> commitVersion;
															#line 199 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			commitVersion = bigEndian64(commitVersion);
															#line 200 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			uint8_t highOrderBatchIndex;
															#line 201 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			reader >> highOrderBatchIndex;
															#line 202 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			TraceEvent("IdempotencyIdWorkloadTransactionCommitted") .detail("CommitVersion", commitVersion) .detail("HighOrderBatchIndex", highOrderBatchIndex) .detail("Key", k) .detail("Id", v.idempotencyId) .detail("CreatedTime", v.createdTime);
															#line 1679 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 209 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (ids.size() != self->clientCount * self->numTransactions)
															#line 1683 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 210 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			self->ok = false;
															#line 1687 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 212 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT_EQ(ids.size(), self->clientCount * self->numTransactions);
															#line 213 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<TestIdempotencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestIdempotencyActorState(); static_cast<TestIdempotencyActor*>(this)->destroy(); return 0; }
															#line 1693 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<TestIdempotencyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestIdempotencyActorState();
		static_cast<TestIdempotencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 187 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(!result.more);
															#line 188 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		std::unordered_set<Value> ids;
															#line 190 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& [k, v] : result ) {
															#line 191 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			ids.emplace(v);
															#line 1711 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 193 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& [k, rawValue] : result ) {
															#line 194 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			auto v = ObjectReader::fromStringRef<ValueType>(rawValue, Unversioned());
															#line 195 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			BinaryReader reader(k, Unversioned());
															#line 196 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			reader.readBytes(self->keyPrefix.size());
															#line 197 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			Version commitVersion;
															#line 198 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			reader >> commitVersion;
															#line 199 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			commitVersion = bigEndian64(commitVersion);
															#line 200 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			uint8_t highOrderBatchIndex;
															#line 201 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			reader >> highOrderBatchIndex;
															#line 202 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			TraceEvent("IdempotencyIdWorkloadTransactionCommitted") .detail("CommitVersion", commitVersion) .detail("HighOrderBatchIndex", highOrderBatchIndex) .detail("Key", k) .detail("Id", v.idempotencyId) .detail("CreatedTime", v.createdTime);
															#line 1733 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 209 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (ids.size() != self->clientCount * self->numTransactions)
															#line 1737 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 210 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			self->ok = false;
															#line 1741 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 212 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT_EQ(ids.size(), self->clientCount * self->numTransactions);
															#line 213 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<TestIdempotencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestIdempotencyActorState(); static_cast<TestIdempotencyActor*>(this)->destroy(); return 0; }
															#line 1747 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<TestIdempotencyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestIdempotencyActorState();
		static_cast<TestIdempotencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestIdempotencyActor*>(this)->actor_wait_state > 0) static_cast<TestIdempotencyActor*>(this)->actor_wait_state = 0;
		static_cast<TestIdempotencyActor*>(this)->ActorCallback< TestIdempotencyActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestIdempotencyActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testIdempotency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIdempotencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIdempotency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestIdempotencyActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testIdempotency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIdempotencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIdempotency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestIdempotencyActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testIdempotency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIdempotencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIdempotency", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1834 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via testIdempotency()
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class TestIdempotencyActor final : public Actor<Void>, public ActorCallback< TestIdempotencyActor, 0, RangeResult >, public FastAllocated<TestIdempotencyActor>, public TestIdempotencyActorState<TestIdempotencyActor> {
															#line 1839 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<TestIdempotencyActor>::operator new;
	using FastAllocated<TestIdempotencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5883078605002580224UL, 14202524467704103168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestIdempotencyActor, 0, RangeResult >;
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	TestIdempotencyActor(AutomaticIdempotencyWorkload* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 1856 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestIdempotencyActorState<TestIdempotencyActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testIdempotency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10175669610314313984UL, 3759044371381939712UL);
		ActorExecutionContextHelper __helper(static_cast<TestIdempotencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testIdempotency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testIdempotency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestIdempotencyActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testIdempotency( AutomaticIdempotencyWorkload* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 184 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<Void>(new TestIdempotencyActor(self, tr));
															#line 1888 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 215 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

	std::vector<Key> idempotencyKeyValueToTestKeys(KeyValueRef kv, Version* commitVersion, int64_t* timestamp) {
		uint8_t highOrderBatchIndex;
		decodeIdempotencyKey(kv.key, *commitVersion, highOrderBatchIndex);

		BinaryReader valReader(kv.value.begin(), kv.value.size(), IncludeVersion());
		valReader >> *timestamp;

		std::vector<Key> keys;
		while (!valReader.empty()) {
			uint8_t length;
			valReader >> length;
			StringRef id{ reinterpret_cast<const uint8_t*>(valReader.readBytes(length)), length };
			uint8_t lowOrderBatchIndex;
			valReader >> lowOrderBatchIndex;

			// Recover the key written in the transaction associated with this idempotency id
			BinaryWriter keyWriter(Unversioned());
			keyWriter.serializeBytes(keyPrefix);
			keyWriter.serializeBinaryItem(bigEndian64(*commitVersion));
			keyWriter.serializeBinaryItem(highOrderBatchIndex);
			keyWriter.serializeBinaryItem(lowOrderBatchIndex);

			keys.push_back(keyWriter.toValue());
		}

		ASSERT(!keys.empty());
		return keys;
	}

	// Returns the largest gap between createdTime and the idempotency timestamp
																#line 1923 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via getMaxTimestampDelta()
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class GetMaxTimestampDeltaActor>
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class GetMaxTimestampDeltaActorState {
															#line 1929 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	GetMaxTimestampDeltaActorState(AutomaticIdempotencyWorkload* const& self,Database const& db,int64_t const& numCreatedTimes) 
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   db(db),
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   numCreatedTimes(numCreatedTimes),
															#line 249 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   timestamps(),
															#line 250 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   keys()
															#line 1944 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this));

	}
	~GetMaxTimestampDeltaActorState() 
	{
		fdb_probe_actor_destroy("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 252 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = runRYWTransaction(db, [](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return tr->getRange(idempotencyIdKeys, CLIENT_KNOBS->TOO_MANY); });
															#line 252 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1961 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state = 1;
															#line 252 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMaxTimestampDeltaActor, 0, RangeResult >*>(static_cast<GetMaxTimestampDeltaActor*>(this)));
															#line 1966 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMaxTimestampDeltaActorState();
		static_cast<GetMaxTimestampDeltaActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 257 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(!result.more);
															#line 259 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& kv : result ) {
															#line 260 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			Version commitVersion;
															#line 261 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			int64_t timestamp;
															#line 262 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			std::vector<Key> decodedKeys = self->idempotencyKeyValueToTestKeys(kv, &commitVersion, &timestamp);
															#line 263 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			for( auto const& key : decodedKeys ) {
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				timestamps.push_back(timestamp);
															#line 265 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				keys.push_back(key);
															#line 2003 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			}
		}
															#line 269 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		tr = ReadYourWritesTransaction(db);
															#line 270 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		;
															#line 2010 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 257 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(!result.more);
															#line 259 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& kv : result ) {
															#line 260 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			Version commitVersion;
															#line 261 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			int64_t timestamp;
															#line 262 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			std::vector<Key> decodedKeys = self->idempotencyKeyValueToTestKeys(kv, &commitVersion, &timestamp);
															#line 263 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			for( auto const& key : decodedKeys ) {
															#line 264 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				timestamps.push_back(timestamp);
															#line 265 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				keys.push_back(key);
															#line 2033 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			}
		}
															#line 269 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		tr = ReadYourWritesTransaction(db);
															#line 270 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		;
															#line 2040 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state > 0) static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxTimestampDeltaActor*>(this)->ActorCallback< GetMaxTimestampDeltaActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxTimestampDeltaActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMaxTimestampDeltaActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMaxTimestampDeltaActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 272 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			futures = std::vector<Future<Optional<Value>>>();
															#line 274 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			for( auto const& key : keys ) {
															#line 275 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				futures.push_back(tr.get(key));
															#line 2136 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			}
															#line 278 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 278 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2142 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state = 2;
															#line 278 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetMaxTimestampDeltaActor, 1, Void >*>(static_cast<GetMaxTimestampDeltaActor*>(this)));
															#line 2147 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 294 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 294 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2171 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state = 3;
															#line 294 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetMaxTimestampDeltaActor, 2, Void >*>(static_cast<GetMaxTimestampDeltaActor*>(this)));
															#line 2176 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		int64_t maxCreatedTimeDelta = 0;
															#line 281 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for(int i = 0;i < futures.size();++i) {
															#line 282 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			auto entry = futures[i].get();
															#line 283 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			ASSERT(entry.present());
															#line 284 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			auto e = ObjectReader::fromStringRef<ValueType>(entry.get(), Unversioned());
															#line 285 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			maxCreatedTimeDelta = std::max(timestamps[i] - e.createdTime, maxCreatedTimeDelta);
															#line 2201 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 288 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (self->automaticPercentage == 0)
															#line 2205 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 289 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			ASSERT_EQ(futures.size(), numCreatedTimes);
															#line 2209 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 292 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<GetMaxTimestampDeltaActor*>(this)->SAV<int64_t>::futures) { (void)(maxCreatedTimeDelta); this->~GetMaxTimestampDeltaActorState(); static_cast<GetMaxTimestampDeltaActor*>(this)->destroy(); return 0; }
															#line 2213 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<GetMaxTimestampDeltaActor*>(this)->SAV< int64_t >::value()) int64_t(maxCreatedTimeDelta);
		this->~GetMaxTimestampDeltaActorState();
		static_cast<GetMaxTimestampDeltaActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		int64_t maxCreatedTimeDelta = 0;
															#line 281 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for(int i = 0;i < futures.size();++i) {
															#line 282 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			auto entry = futures[i].get();
															#line 283 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			ASSERT(entry.present());
															#line 284 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			auto e = ObjectReader::fromStringRef<ValueType>(entry.get(), Unversioned());
															#line 285 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			maxCreatedTimeDelta = std::max(timestamps[i] - e.createdTime, maxCreatedTimeDelta);
															#line 2235 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 288 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (self->automaticPercentage == 0)
															#line 2239 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 289 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			ASSERT_EQ(futures.size(), numCreatedTimes);
															#line 2243 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 292 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<GetMaxTimestampDeltaActor*>(this)->SAV<int64_t>::futures) { (void)(maxCreatedTimeDelta); this->~GetMaxTimestampDeltaActorState(); static_cast<GetMaxTimestampDeltaActor*>(this)->destroy(); return 0; }
															#line 2247 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<GetMaxTimestampDeltaActor*>(this)->SAV< int64_t >::value()) int64_t(maxCreatedTimeDelta);
		this->~GetMaxTimestampDeltaActorState();
		static_cast<GetMaxTimestampDeltaActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state > 0) static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxTimestampDeltaActor*>(this)->ActorCallback< GetMaxTimestampDeltaActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxTimestampDeltaActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetMaxTimestampDeltaActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetMaxTimestampDeltaActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state > 0) static_cast<GetMaxTimestampDeltaActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxTimestampDeltaActor*>(this)->ActorCallback< GetMaxTimestampDeltaActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxTimestampDeltaActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetMaxTimestampDeltaActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetMaxTimestampDeltaActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Database db;
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	int64_t numCreatedTimes;
															#line 249 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	std::vector<int64_t> timestamps;
															#line 250 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	std::vector<Key> keys;
															#line 269 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 272 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	std::vector<Future<Optional<Value>>> futures;
															#line 2431 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via getMaxTimestampDelta()
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class GetMaxTimestampDeltaActor final : public Actor<int64_t>, public ActorCallback< GetMaxTimestampDeltaActor, 0, RangeResult >, public ActorCallback< GetMaxTimestampDeltaActor, 1, Void >, public ActorCallback< GetMaxTimestampDeltaActor, 2, Void >, public FastAllocated<GetMaxTimestampDeltaActor>, public GetMaxTimestampDeltaActorState<GetMaxTimestampDeltaActor> {
															#line 2436 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<GetMaxTimestampDeltaActor>::operator new;
	using FastAllocated<GetMaxTimestampDeltaActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15574035040861084416UL, 7786133411761539072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMaxTimestampDeltaActor, 0, RangeResult >;
friend struct ActorCallback< GetMaxTimestampDeltaActor, 1, Void >;
friend struct ActorCallback< GetMaxTimestampDeltaActor, 2, Void >;
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	GetMaxTimestampDeltaActor(AutomaticIdempotencyWorkload* const& self,Database const& db,int64_t const& numCreatedTimes) 
															#line 2455 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetMaxTimestampDeltaActorState<GetMaxTimestampDeltaActor>(self, db, numCreatedTimes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14571920656117007360UL, 11206226770156957440UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxTimestampDeltaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMaxTimestampDelta");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMaxTimestampDelta", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMaxTimestampDeltaActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetMaxTimestampDeltaActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetMaxTimestampDeltaActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<int64_t> getMaxTimestampDelta( AutomaticIdempotencyWorkload* const& self, Database const& db, int64_t const& numCreatedTimes ) {
															#line 246 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<int64_t>(new GetMaxTimestampDeltaActor(self, db, numCreatedTimes));
															#line 2489 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 298 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

																#line 2494 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via getOldestCreatedTime()
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class GetOldestCreatedTimeActor>
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class GetOldestCreatedTimeActorState {
															#line 2500 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	GetOldestCreatedTimeActorState(AutomaticIdempotencyWorkload* const& self,Database const& db) 
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   db(db),
															#line 300 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   tr(db),
															#line 301 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   key(),
															#line 302 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   commitVersion()
															#line 2515 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getOldestCreatedTime", reinterpret_cast<unsigned long>(this));

	}
	~GetOldestCreatedTimeActorState() 
	{
		fdb_probe_actor_destroy("getOldestCreatedTime", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 304 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = runRYWTransaction(db, [](Reference<ReadYourWritesTransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return tr->getRange(idempotencyIdKeys, 1); });
															#line 304 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<GetOldestCreatedTimeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2532 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetOldestCreatedTimeActor*>(this)->actor_wait_state = 1;
															#line 304 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetOldestCreatedTimeActor, 0, RangeResult >*>(static_cast<GetOldestCreatedTimeActor*>(this)));
															#line 2537 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetOldestCreatedTimeActorState();
		static_cast<GetOldestCreatedTimeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 309 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (result.empty())
															#line 2560 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 310 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			TraceEvent("AutomaticIdempotencyNoIdsLeft").log();
															#line 311 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (!static_cast<GetOldestCreatedTimeActor*>(this)->SAV<int64_t>::futures) { (void)(-1); this->~GetOldestCreatedTimeActorState(); static_cast<GetOldestCreatedTimeActor*>(this)->destroy(); return 0; }
															#line 2566 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			new (&static_cast<GetOldestCreatedTimeActor*>(this)->SAV< int64_t >::value()) int64_t(-1);
			this->~GetOldestCreatedTimeActorState();
			static_cast<GetOldestCreatedTimeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 314 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		int64_t timestamp;
															#line 315 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		key = self->idempotencyKeyValueToTestKeys(result[0], &commitVersion, &timestamp)[0];
															#line 319 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = runRYWTransaction(db, [key = key](Reference<ReadYourWritesTransaction> tr) { return tr->get(key); });
															#line 319 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<GetOldestCreatedTimeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2580 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetOldestCreatedTimeActor*>(this)->actor_wait_state = 2;
															#line 319 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetOldestCreatedTimeActor, 1, Optional<Value> >*>(static_cast<GetOldestCreatedTimeActor*>(this)));
															#line 2585 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __result,int loopDepth) 
	{
															#line 304 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		result = __result;
															#line 2594 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetOldestCreatedTimeActor*>(this)->actor_wait_state > 0) static_cast<GetOldestCreatedTimeActor*>(this)->actor_wait_state = 0;
		static_cast<GetOldestCreatedTimeActor*>(this)->ActorCallback< GetOldestCreatedTimeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetOldestCreatedTimeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOldestCreatedTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetOldestCreatedTimeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOldestCreatedTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetOldestCreatedTimeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOldestCreatedTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& entry,int loopDepth) 
	{
															#line 322 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!entry.present())
															#line 2673 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 323 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			TraceEvent(SevError, "AutomaticIdempotencyKeyMissing") .detail("Key", key) .detail("CommitVersion", commitVersion) .detail("ReadVersion", tr.getReadVersion().get());
															#line 2677 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 328 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 330 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		auto e = ObjectReader::fromStringRef<ValueType>(entry.get(), Unversioned());
															#line 331 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<GetOldestCreatedTimeActor*>(this)->SAV<int64_t>::futures) { (void)(e.createdTime); this->~GetOldestCreatedTimeActorState(); static_cast<GetOldestCreatedTimeActor*>(this)->destroy(); return 0; }
															#line 2685 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<GetOldestCreatedTimeActor*>(this)->SAV< int64_t >::value()) int64_t(e.createdTime);
		this->~GetOldestCreatedTimeActorState();
		static_cast<GetOldestCreatedTimeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && entry,int loopDepth) 
	{
															#line 322 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!entry.present())
															#line 2697 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 323 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			TraceEvent(SevError, "AutomaticIdempotencyKeyMissing") .detail("Key", key) .detail("CommitVersion", commitVersion) .detail("ReadVersion", tr.getReadVersion().get());
															#line 2701 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 328 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 330 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		auto e = ObjectReader::fromStringRef<ValueType>(entry.get(), Unversioned());
															#line 331 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<GetOldestCreatedTimeActor*>(this)->SAV<int64_t>::futures) { (void)(e.createdTime); this->~GetOldestCreatedTimeActorState(); static_cast<GetOldestCreatedTimeActor*>(this)->destroy(); return 0; }
															#line 2709 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<GetOldestCreatedTimeActor*>(this)->SAV< int64_t >::value()) int64_t(e.createdTime);
		this->~GetOldestCreatedTimeActorState();
		static_cast<GetOldestCreatedTimeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetOldestCreatedTimeActor*>(this)->actor_wait_state > 0) static_cast<GetOldestCreatedTimeActor*>(this)->actor_wait_state = 0;
		static_cast<GetOldestCreatedTimeActor*>(this)->ActorCallback< GetOldestCreatedTimeActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetOldestCreatedTimeActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOldestCreatedTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetOldestCreatedTimeActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetOldestCreatedTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetOldestCreatedTimeActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetOldestCreatedTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Database db;
															#line 300 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 301 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Key key;
															#line 302 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Version commitVersion;
															#line 304 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	RangeResult result;
															#line 2804 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via getOldestCreatedTime()
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class GetOldestCreatedTimeActor final : public Actor<int64_t>, public ActorCallback< GetOldestCreatedTimeActor, 0, RangeResult >, public ActorCallback< GetOldestCreatedTimeActor, 1, Optional<Value> >, public FastAllocated<GetOldestCreatedTimeActor>, public GetOldestCreatedTimeActorState<GetOldestCreatedTimeActor> {
															#line 2809 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<GetOldestCreatedTimeActor>::operator new;
	using FastAllocated<GetOldestCreatedTimeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12726761708521637376UL, 15615102770304969984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetOldestCreatedTimeActor, 0, RangeResult >;
friend struct ActorCallback< GetOldestCreatedTimeActor, 1, Optional<Value> >;
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	GetOldestCreatedTimeActor(AutomaticIdempotencyWorkload* const& self,Database const& db) 
															#line 2827 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetOldestCreatedTimeActorState<GetOldestCreatedTimeActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10843464030634448896UL, 10573813053060498944UL);
		ActorExecutionContextHelper __helper(static_cast<GetOldestCreatedTimeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getOldestCreatedTime");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getOldestCreatedTime", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetOldestCreatedTimeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetOldestCreatedTimeActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<int64_t> getOldestCreatedTime( AutomaticIdempotencyWorkload* const& self, Database const& db ) {
															#line 299 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<int64_t>(new GetOldestCreatedTimeActor(self, db));
															#line 2860 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 333 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

																#line 2865 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via testCleanerOneIteration()
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class TestCleanerOneIterationActor>
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class TestCleanerOneIterationActorState {
															#line 2871 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	TestCleanerOneIterationActorState(AutomaticIdempotencyWorkload* const& self,Database const& db,ActorCollection* const& actors,int64_t const& minAgeSeconds,int64_t const& maxTimestampDelta,const std::vector<int64_t>* const& createdTimes) 
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   db(db),
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   actors(actors),
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   minAgeSeconds(minAgeSeconds),
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   maxTimestampDelta(maxTimestampDelta),
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   createdTimes(createdTimes),
															#line 340 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   cleaner(recurringAsync( [db = db, minAgeSeconds = minAgeSeconds]() { return cleanIdempotencyIds(db, minAgeSeconds); }, self->pollingInterval, true, self->pollingInterval)),
															#line 346 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   oldestCreatedTime(),
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   successes(0)
															#line 2894 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testCleanerOneIteration", reinterpret_cast<unsigned long>(this));

	}
	~TestCleanerOneIterationActorState() 
	{
		fdb_probe_actor_destroy("testCleanerOneIteration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 348 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			actors->add(cleaner);
															#line 349 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			;
															#line 2911 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCleanerOneIterationActorState();
		static_cast<TestCleanerOneIterationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 403 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		cleaner.cancel();
															#line 404 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<TestCleanerOneIterationActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TestCleanerOneIterationActorState(); static_cast<TestCleanerOneIterationActor*>(this)->destroy(); return 0; }
															#line 2936 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<TestCleanerOneIterationActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TestCleanerOneIterationActorState();
		static_cast<TestCleanerOneIterationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 351 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = store(oldestCreatedTime, getOldestCreatedTime(self, db));
															#line 351 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2957 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state = 1;
															#line 351 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCleanerOneIterationActor, 0, Void >*>(static_cast<TestCleanerOneIterationActor*>(this)));
															#line 2962 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 352 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (oldestCreatedTime == -1)
															#line 2984 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 353 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (!static_cast<TestCleanerOneIterationActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TestCleanerOneIterationActorState(); static_cast<TestCleanerOneIterationActor*>(this)->destroy(); return 0; }
															#line 2988 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			new (&static_cast<TestCleanerOneIterationActor*>(this)->SAV< bool >::value()) bool(true);
			this->~TestCleanerOneIterationActorState();
			static_cast<TestCleanerOneIterationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 363 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		int64_t initialOldestCreatedTime = oldestCreatedTime;
															#line 364 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		auto iter = std::lower_bound(createdTimes->begin(), createdTimes->end(), oldestCreatedTime - maxTimestampDelta);
															#line 366 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (iter != createdTimes->begin())
															#line 3000 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 367 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			--iter;
															#line 368 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			oldestCreatedTime = *iter + 1;
															#line 3006 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 370 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		auto maxActualAge = int64_t(now()) - oldestCreatedTime;
															#line 371 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (maxActualAge > minAgeSeconds * self->slop)
															#line 3012 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 372 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			CODE_PROBE(true, "Idempotency cleaner more to clean");
															#line 373 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			TraceEvent("AutomaticIdempotencyCleanerMoreToClean") .detail("MaxActualAge", maxActualAge) .detail("MinAgePolicy", minAgeSeconds);
															#line 376 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			successes = 0;
															#line 3020 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
		else
		{
															#line 378 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (maxActualAge < minAgeSeconds / self->slop)
															#line 3026 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			{
															#line 379 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				bool ok = self->automaticPercentage == 0;
															#line 380 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				TraceEvent(ok ? SevInfo : SevError, "AutomaticIdempotencyCleanedTooMuch") .detail("MaxActualAge", maxActualAge) .detail("MinAgePolicy", minAgeSeconds) .detail("InitialOldestCreatedTime", initialOldestCreatedTime) .detail("OldestCreatedTime", oldestCreatedTime) .detail("MaxTimestampDelta", maxTimestampDelta);
															#line 386 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				if (!ok)
															#line 3034 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				{
															#line 387 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
					self->ok = false;
															#line 3038 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				}
															#line 389 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				ASSERT(ok);
															#line 390 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				successes = 0;
															#line 3044 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 392 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				++successes;
															#line 393 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				TraceEvent("AutomaticIdempotencyCleanerSuccess") .detail("MaxActualAge", maxActualAge) .detail("MinAgePolicy", minAgeSeconds) .detail("Successes", successes);
															#line 397 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				if (successes >= 10)
															#line 3054 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				{
					return a_body1break1(loopDepth==0?0:loopDepth-1); // break
				}
			}
		}
															#line 401 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->pollingInterval);
															#line 401 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3064 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state = 2;
															#line 401 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCleanerOneIterationActor, 1, Void >*>(static_cast<TestCleanerOneIterationActor*>(this)));
															#line 3069 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 352 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (oldestCreatedTime == -1)
															#line 3078 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 353 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (!static_cast<TestCleanerOneIterationActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TestCleanerOneIterationActorState(); static_cast<TestCleanerOneIterationActor*>(this)->destroy(); return 0; }
															#line 3082 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			new (&static_cast<TestCleanerOneIterationActor*>(this)->SAV< bool >::value()) bool(true);
			this->~TestCleanerOneIterationActorState();
			static_cast<TestCleanerOneIterationActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 363 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		int64_t initialOldestCreatedTime = oldestCreatedTime;
															#line 364 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		auto iter = std::lower_bound(createdTimes->begin(), createdTimes->end(), oldestCreatedTime - maxTimestampDelta);
															#line 366 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (iter != createdTimes->begin())
															#line 3094 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 367 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			--iter;
															#line 368 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			oldestCreatedTime = *iter + 1;
															#line 3100 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 370 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		auto maxActualAge = int64_t(now()) - oldestCreatedTime;
															#line 371 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (maxActualAge > minAgeSeconds * self->slop)
															#line 3106 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
															#line 372 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			CODE_PROBE(true, "Idempotency cleaner more to clean");
															#line 373 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			TraceEvent("AutomaticIdempotencyCleanerMoreToClean") .detail("MaxActualAge", maxActualAge) .detail("MinAgePolicy", minAgeSeconds);
															#line 376 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			successes = 0;
															#line 3114 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
		else
		{
															#line 378 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (maxActualAge < minAgeSeconds / self->slop)
															#line 3120 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			{
															#line 379 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				bool ok = self->automaticPercentage == 0;
															#line 380 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				TraceEvent(ok ? SevInfo : SevError, "AutomaticIdempotencyCleanedTooMuch") .detail("MaxActualAge", maxActualAge) .detail("MinAgePolicy", minAgeSeconds) .detail("InitialOldestCreatedTime", initialOldestCreatedTime) .detail("OldestCreatedTime", oldestCreatedTime) .detail("MaxTimestampDelta", maxTimestampDelta);
															#line 386 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				if (!ok)
															#line 3128 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				{
															#line 387 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
					self->ok = false;
															#line 3132 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				}
															#line 389 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				ASSERT(ok);
															#line 390 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				successes = 0;
															#line 3138 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 392 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				++successes;
															#line 393 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				TraceEvent("AutomaticIdempotencyCleanerSuccess") .detail("MaxActualAge", maxActualAge) .detail("MinAgePolicy", minAgeSeconds) .detail("Successes", successes);
															#line 397 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
				if (successes >= 10)
															#line 3148 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
				{
					return a_body1break1(loopDepth==0?0:loopDepth-1); // break
				}
			}
		}
															#line 401 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(self->pollingInterval);
															#line 401 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3158 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state = 2;
															#line 401 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCleanerOneIterationActor, 1, Void >*>(static_cast<TestCleanerOneIterationActor*>(this)));
															#line 3163 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state > 0) static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state = 0;
		static_cast<TestCleanerOneIterationActor*>(this)->ActorCallback< TestCleanerOneIterationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCleanerOneIterationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerOneIterationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCleanerOneIterationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerOneIterationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCleanerOneIterationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerOneIterationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state > 0) static_cast<TestCleanerOneIterationActor*>(this)->actor_wait_state = 0;
		static_cast<TestCleanerOneIterationActor*>(this)->ActorCallback< TestCleanerOneIterationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCleanerOneIterationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerOneIterationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCleanerOneIterationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerOneIterationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCleanerOneIterationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerOneIterationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Database db;
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	ActorCollection* actors;
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	int64_t minAgeSeconds;
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	int64_t maxTimestampDelta;
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	const std::vector<int64_t>* createdTimes;
															#line 340 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Future<Void> cleaner;
															#line 346 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	int64_t oldestCreatedTime;
															#line 347 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	int64_t successes;
															#line 3348 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via testCleanerOneIteration()
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class TestCleanerOneIterationActor final : public Actor<bool>, public ActorCallback< TestCleanerOneIterationActor, 0, Void >, public ActorCallback< TestCleanerOneIterationActor, 1, Void >, public FastAllocated<TestCleanerOneIterationActor>, public TestCleanerOneIterationActorState<TestCleanerOneIterationActor> {
															#line 3353 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<TestCleanerOneIterationActor>::operator new;
	using FastAllocated<TestCleanerOneIterationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8280032468530944512UL, 11677162184591073024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCleanerOneIterationActor, 0, Void >;
friend struct ActorCallback< TestCleanerOneIterationActor, 1, Void >;
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	TestCleanerOneIterationActor(AutomaticIdempotencyWorkload* const& self,Database const& db,ActorCollection* const& actors,int64_t const& minAgeSeconds,int64_t const& maxTimestampDelta,const std::vector<int64_t>* const& createdTimes) 
															#line 3371 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   TestCleanerOneIterationActorState<TestCleanerOneIterationActor>(self, db, actors, minAgeSeconds, maxTimestampDelta, createdTimes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15660575591259535872UL, 7836406157685935872UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerOneIterationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCleanerOneIteration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCleanerOneIteration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCleanerOneIterationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCleanerOneIterationActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<bool> testCleanerOneIteration( AutomaticIdempotencyWorkload* const& self, Database const& db, ActorCollection* const& actors, int64_t const& minAgeSeconds, int64_t const& maxTimestampDelta, const std::vector<int64_t>* const& createdTimes ) {
															#line 334 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<bool>(new TestCleanerOneIterationActor(self, db, actors, minAgeSeconds, maxTimestampDelta, createdTimes));
															#line 3404 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 406 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

																#line 3409 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via getCreatedTimes()
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class GetCreatedTimesActor>
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class GetCreatedTimesActorState {
															#line 3415 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	GetCreatedTimesActorState(AutomaticIdempotencyWorkload* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   tr(tr)
															#line 3424 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getCreatedTimes", reinterpret_cast<unsigned long>(this));

	}
	~GetCreatedTimesActorState() 
	{
		fdb_probe_actor_destroy("getCreatedTimes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 409 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(prefixRange(self->keyPrefix), CLIENT_KNOBS->TOO_MANY);
															#line 409 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<GetCreatedTimesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3441 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCreatedTimesActor*>(this)->actor_wait_state = 1;
															#line 409 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCreatedTimesActor, 0, RangeResult >*>(static_cast<GetCreatedTimesActor*>(this)));
															#line 3446 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCreatedTimesActorState();
		static_cast<GetCreatedTimesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 410 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(!result.more);
															#line 411 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		std::vector<int64_t> createdTimes;
															#line 412 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& [k, v] : result ) {
															#line 413 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			auto e = ObjectReader::fromStringRef<ValueType>(v, Unversioned());
															#line 414 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			createdTimes.emplace_back(e.createdTime);
															#line 3477 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 416 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		std::sort(createdTimes.begin(), createdTimes.end());
															#line 417 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<GetCreatedTimesActor*>(this)->SAV<std::vector<int64_t>>::futures) { (void)(createdTimes); this->~GetCreatedTimesActorState(); static_cast<GetCreatedTimesActor*>(this)->destroy(); return 0; }
															#line 3483 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<GetCreatedTimesActor*>(this)->SAV< std::vector<int64_t> >::value()) std::vector<int64_t>(createdTimes);
		this->~GetCreatedTimesActorState();
		static_cast<GetCreatedTimesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 410 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(!result.more);
															#line 411 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		std::vector<int64_t> createdTimes;
															#line 412 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		for( const auto& [k, v] : result ) {
															#line 413 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			auto e = ObjectReader::fromStringRef<ValueType>(v, Unversioned());
															#line 414 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			createdTimes.emplace_back(e.createdTime);
															#line 3503 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		}
															#line 416 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		std::sort(createdTimes.begin(), createdTimes.end());
															#line 417 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<GetCreatedTimesActor*>(this)->SAV<std::vector<int64_t>>::futures) { (void)(createdTimes); this->~GetCreatedTimesActorState(); static_cast<GetCreatedTimesActor*>(this)->destroy(); return 0; }
															#line 3509 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<GetCreatedTimesActor*>(this)->SAV< std::vector<int64_t> >::value()) std::vector<int64_t>(createdTimes);
		this->~GetCreatedTimesActorState();
		static_cast<GetCreatedTimesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCreatedTimesActor*>(this)->actor_wait_state > 0) static_cast<GetCreatedTimesActor*>(this)->actor_wait_state = 0;
		static_cast<GetCreatedTimesActor*>(this)->ActorCallback< GetCreatedTimesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetCreatedTimesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getCreatedTimes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCreatedTimesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCreatedTimes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCreatedTimesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getCreatedTimes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCreatedTimesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCreatedTimes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCreatedTimesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getCreatedTimes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCreatedTimesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCreatedTimes", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 3596 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via getCreatedTimes()
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class GetCreatedTimesActor final : public Actor<std::vector<int64_t>>, public ActorCallback< GetCreatedTimesActor, 0, RangeResult >, public FastAllocated<GetCreatedTimesActor>, public GetCreatedTimesActorState<GetCreatedTimesActor> {
															#line 3601 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<GetCreatedTimesActor>::operator new;
	using FastAllocated<GetCreatedTimesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2178781405446410240UL, 7556607401386007040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<int64_t>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCreatedTimesActor, 0, RangeResult >;
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	GetCreatedTimesActor(AutomaticIdempotencyWorkload* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 3618 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<std::vector<int64_t>>(),
		   GetCreatedTimesActorState<GetCreatedTimesActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCreatedTimes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16740946015256982528UL, 10004443983458374912UL);
		ActorExecutionContextHelper __helper(static_cast<GetCreatedTimesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCreatedTimes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCreatedTimes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCreatedTimesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<std::vector<int64_t>> getCreatedTimes( AutomaticIdempotencyWorkload* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 407 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<std::vector<int64_t>>(new GetCreatedTimesActor(self, tr));
															#line 3650 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 419 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

	// Check that min age is respected. Also test that we can tolerate concurrent cleaners.
																#line 3656 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
// This generated class is to be used only via testCleaner()
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
template <class TestCleanerActor>
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class TestCleanerActorState {
															#line 3662 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	TestCleanerActorState(AutomaticIdempotencyWorkload* const& self,Database const& db) 
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		 : self(self),
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   db(db),
															#line 422 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   actors(),
															#line 423 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   minAgeSeconds(),
															#line 424 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		   createdTimes()
															#line 3677 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testCleaner", reinterpret_cast<unsigned long>(this));

	}
	~TestCleanerActorState() 
	{
		fdb_probe_actor_destroy("testCleaner", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 427 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(minAgeSeconds, fmap([](int64_t t) { return int64_t(now()) - t; }, getOldestCreatedTime(self, db))) && store(createdTimes, runRYWTransaction(db, [self = self](Reference<ReadYourWritesTransaction> tr) { return getCreatedTimes(self, tr); }));
															#line 427 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			if (static_cast<TestCleanerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3694 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCleanerActor*>(this)->actor_wait_state = 1;
															#line 427 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCleanerActor, 0, Void >*>(static_cast<TestCleanerActor*>(this)));
															#line 3699 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCleanerActorState();
		static_cast<TestCleanerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 432 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getMaxTimestampDelta(self, db, createdTimes.size());
															#line 432 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestCleanerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3724 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCleanerActor*>(this)->actor_wait_state = 2;
															#line 432 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCleanerActor, 1, int64_t >*>(static_cast<TestCleanerActor*>(this)));
															#line 3729 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 432 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getMaxTimestampDelta(self, db, createdTimes.size());
															#line 432 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestCleanerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3740 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCleanerActor*>(this)->actor_wait_state = 2;
															#line 432 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCleanerActor, 1, int64_t >*>(static_cast<TestCleanerActor*>(this)));
															#line 3745 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCleanerActor*>(this)->actor_wait_state > 0) static_cast<TestCleanerActor*>(this)->actor_wait_state = 0;
		static_cast<TestCleanerActor*>(this)->ActorCallback< TestCleanerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCleanerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCleanerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCleanerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 436 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		;
															#line 3829 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& __maxTimestampDelta,int loopDepth) 
	{
															#line 432 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		maxTimestampDelta = __maxTimestampDelta;
															#line 3838 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && __maxTimestampDelta,int loopDepth) 
	{
		maxTimestampDelta = std::move(__maxTimestampDelta);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCleanerActor*>(this)->actor_wait_state > 0) static_cast<TestCleanerActor*>(this)->actor_wait_state = 0;
		static_cast<TestCleanerActor*>(this)->ActorCallback< TestCleanerActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< TestCleanerActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCleanerActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCleanerActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 453 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (!static_cast<TestCleanerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCleanerActorState(); static_cast<TestCleanerActor*>(this)->destroy(); return 0; }
															#line 3917 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		new (&static_cast<TestCleanerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCleanerActorState();
		static_cast<TestCleanerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 437 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		minAgeSeconds *= 1 / (self->slop * 2);
															#line 438 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (minAgeSeconds < self->minMinAgeSeconds)
															#line 3938 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 442 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = testCleanerOneIteration(self, db, &actors, minAgeSeconds, maxTimestampDelta, &createdTimes);
															#line 441 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (static_cast<TestCleanerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3946 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 448 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = actors.getResult();
															#line 3950 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_3.get(), loopDepth); };
		static_cast<TestCleanerActor*>(this)->actor_wait_state = 3;
															#line 442 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCleanerActor, 2, bool >*>(static_cast<TestCleanerActor*>(this)));
															#line 448 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestCleanerActor, 3, Void >*>(static_cast<TestCleanerActor*>(this)));
															#line 3957 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(bool const& done,int loopDepth) 
	{
															#line 444 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (done)
															#line 3985 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(bool && done,int loopDepth) 
	{
															#line 444 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		if (done)
															#line 3997 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 449 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(false);
															#line 4009 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
															#line 449 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
		ASSERT(false);
															#line 4018 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestCleanerActor*>(this)->actor_wait_state > 0) static_cast<TestCleanerActor*>(this)->actor_wait_state = 0;
		static_cast<TestCleanerActor*>(this)->ActorCallback< TestCleanerActor, 2, bool >::remove();
		static_cast<TestCleanerActor*>(this)->ActorCallback< TestCleanerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCleanerActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestCleanerActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestCleanerActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestCleanerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestCleanerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestCleanerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	AutomaticIdempotencyWorkload* self;
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	Database db;
															#line 422 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	ActorCollection actors;
															#line 423 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	int64_t minAgeSeconds;
															#line 424 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	std::vector<int64_t> createdTimes;
															#line 432 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	int64_t maxTimestampDelta;
															#line 4156 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via testCleaner()
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
class TestCleanerActor final : public Actor<Void>, public ActorCallback< TestCleanerActor, 0, Void >, public ActorCallback< TestCleanerActor, 1, int64_t >, public ActorCallback< TestCleanerActor, 2, bool >, public ActorCallback< TestCleanerActor, 3, Void >, public FastAllocated<TestCleanerActor>, public TestCleanerActorState<TestCleanerActor> {
															#line 4161 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
public:
	using FastAllocated<TestCleanerActor>::operator new;
	using FastAllocated<TestCleanerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16515181712114293504UL, 10282984942838549248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCleanerActor, 0, Void >;
friend struct ActorCallback< TestCleanerActor, 1, int64_t >;
friend struct ActorCallback< TestCleanerActor, 2, bool >;
friend struct ActorCallback< TestCleanerActor, 3, Void >;
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	TestCleanerActor(AutomaticIdempotencyWorkload* const& self,Database const& db) 
															#line 4181 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestCleanerActorState<TestCleanerActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCleaner", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1952939035577142272UL, 5971297323741295872UL);
		ActorExecutionContextHelper __helper(static_cast<TestCleanerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCleaner");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCleaner", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCleanerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCleanerActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestCleanerActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testCleaner( AutomaticIdempotencyWorkload* const& self, Database const& db ) {
															#line 421 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"
	return Future<Void>(new TestCleanerActor(self, db));
															#line 4215 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.g.cpp"
}

#line 455 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/workloads/AutomaticIdempotencyWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<AutomaticIdempotencyWorkload> AutomaticIdempotencyWorkloadFactory;
