#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
/*
 * RoleLineage.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#include "flow/flow.h"
#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_ROLE_LINEAGE_ACTOR_G_H)
#define FDBSERVER_ROLE_LINEAGE_ACTOR_G_H
#include "fdbserver/RoleLineage.actor.g.h"
#elif !defined(FDBSERVER_ROLE_LINEAGE_ACTOR_H)
#define FDBSERVER_ROLE_LINEAGE_ACTOR_H

#include "flow/singleton.h"
#include "fdbrpc/Locality.h"
#include "fdbclient/ActorLineageProfiler.h"
#include "fdbserver/WorkerInterface.actor.h"

#include <string_view>
#include <msgpack.hpp>
#include <any>
#include "flow/actorcompiler.h" // This must be the last include

struct RoleLineage : LineageProperties<RoleLineage> {
	static std::string_view name;
	ProcessClass::ClusterRole role = ProcessClass::NoRole;

	bool isSet(ProcessClass::ClusterRole RoleLineage::* member) const { return this->*member != ProcessClass::NoRole; }
};

struct RoleLineageCollector : IALPCollector<RoleLineage> {
	RoleLineageCollector() : IALPCollector() {}
	std::optional<std::any> collect(ActorLineage* lineage) override {
		auto res = lineage->get(&RoleLineage::role);
		if (res.has_value()) {
			return Role::get(res.value()).abbreviation;
		} else {
			return std::optional<std::any>();
		}
	}
};

// creates a new root and sets the role lineage
															#line 61 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
namespace {
// This generated class is to be used only via runInRole()
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
template <class Fun, class RunInRoleActor>
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
class RunInRoleActorState {
															#line 68 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
public:
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
	RunInRoleActorState(Fun const& fun,ProcessClass::ClusterRole const& role) 
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
		 : fun(fun),
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
		   role(role)
															#line 77 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
	{
		fdb_probe_actor_create("runInRole", reinterpret_cast<unsigned long>(this));

	}
	~RunInRoleActorState() 
	{
		fdb_probe_actor_destroy("runInRole", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
			getCurrentLineage()->makeRoot();
															#line 62 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
			getCurrentLineage()->modify(&RoleLineage::role) = role;
															#line 63 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
			StrictFuture<decltype(std::declval<Fun>()())> __when_expr_0 = fun();
															#line 63 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
			if (static_cast<RunInRoleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 98 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunInRoleActor*>(this)->actor_wait_state = 1;
															#line 63 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunInRoleActor, 0, decltype(std::declval<Fun>()()) >*>(static_cast<RunInRoleActor*>(this)));
															#line 103 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunInRoleActorState();
		static_cast<RunInRoleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(decltype(std::declval<Fun>()()) const& res,int loopDepth) 
	{
															#line 64 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
		if (!static_cast<RunInRoleActor*>(this)->SAV<decltype(std::declval<Fun>()())>::futures) { (void)(res); this->~RunInRoleActorState(); static_cast<RunInRoleActor*>(this)->destroy(); return 0; }
															#line 126 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
		new (&static_cast<RunInRoleActor*>(this)->SAV< decltype(std::declval<Fun>()()) >::value()) decltype(std::declval<Fun>()())(res);
		this->~RunInRoleActorState();
		static_cast<RunInRoleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(decltype(std::declval<Fun>()()) && res,int loopDepth) 
	{
															#line 64 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
		if (!static_cast<RunInRoleActor*>(this)->SAV<decltype(std::declval<Fun>()())>::futures) { (void)(res); this->~RunInRoleActorState(); static_cast<RunInRoleActor*>(this)->destroy(); return 0; }
															#line 138 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
		new (&static_cast<RunInRoleActor*>(this)->SAV< decltype(std::declval<Fun>()()) >::value()) decltype(std::declval<Fun>()())(res);
		this->~RunInRoleActorState();
		static_cast<RunInRoleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(decltype(std::declval<Fun>()()) const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(decltype(std::declval<Fun>()()) && res,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunInRoleActor*>(this)->actor_wait_state > 0) static_cast<RunInRoleActor*>(this)->actor_wait_state = 0;
		static_cast<RunInRoleActor*>(this)->ActorCallback< RunInRoleActor, 0, decltype(std::declval<Fun>()()) >::remove();

	}
	void a_callback_fire(ActorCallback< RunInRoleActor, 0, decltype(std::declval<Fun>()()) >*,decltype(std::declval<Fun>()()) const& value) 
	{
		fdb_probe_actor_enter("runInRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunInRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runInRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunInRoleActor, 0, decltype(std::declval<Fun>()()) >*,decltype(std::declval<Fun>()()) && value) 
	{
		fdb_probe_actor_enter("runInRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunInRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runInRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunInRoleActor, 0, decltype(std::declval<Fun>()()) >*,Error err) 
	{
		fdb_probe_actor_enter("runInRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunInRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runInRole", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
	Fun fun;
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
	ProcessClass::ClusterRole role;
															#line 225 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
};
// This generated class is to be used only via runInRole()
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
template <class Fun>
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
class RunInRoleActor final : public Actor<decltype(std::declval<Fun>()())>, public ActorCallback< RunInRoleActor<Fun>, 0, decltype(std::declval<Fun>()()) >, public FastAllocated<RunInRoleActor<Fun>>, public RunInRoleActorState<Fun, RunInRoleActor<Fun>> {
															#line 232 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
public:
	using FastAllocated<RunInRoleActor<Fun>>::operator new;
	using FastAllocated<RunInRoleActor<Fun>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3422685128752886016UL, 4572291612705639936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<Fun>()())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunInRoleActor<Fun>, 0, decltype(std::declval<Fun>()()) >;
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
	RunInRoleActor(Fun const& fun,ProcessClass::ClusterRole const& role) 
															#line 249 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
		 : Actor<decltype(std::declval<Fun>()())>(),
		   RunInRoleActorState<Fun, RunInRoleActor<Fun>>(fun, role),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runInRole", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3363338755953952000UL, 4082706667536254976UL);
		ActorExecutionContextHelper __helper(static_cast<RunInRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runInRole");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runInRole", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunInRoleActor<Fun>, 0, decltype(std::declval<Fun>()()) >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
template <class Fun>
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
[[nodiscard]] Future<decltype(std::declval<Fun>()())> runInRole( Fun const& fun, ProcessClass::ClusterRole const& role ) {
															#line 59 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"
	return Future<decltype(std::declval<Fun>()())>(new RunInRoleActor<Fun>(fun, role));
															#line 284 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RoleLineage.actor.g.h"
}

#line 66 "/codebuild/output/src1580915050/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RoleLineage.actor.h"

#include "flow/unactorcompiler.h"

#endif
