#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
/*
 * RenameTenant.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_RENAMETENANT_ACTOR_G_H)
#define METACLUSTER_RENAMETENANT_ACTOR_G_H
#include "metacluster/RenameTenant.actor.g.h"
#elif !defined(METACLUSTER_RENAMETENANT_ACTOR_H)
#define METACLUSTER_RENAMETENANT_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterOperationContext.actor.h"
#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

namespace internal {
template <class DB>
struct RenameTenantImpl {
	MetaclusterOperationContext<DB> ctx;

	// Initialization parameters
	TenantName oldName;
	TenantName newName;

	// Parameters set in markTenantsInRenamingState
	int64_t tenantId = -1;
	int64_t configurationSequenceNum = -1;

	RenameTenantImpl(Reference<DB> managementDb, TenantName oldName, TenantName newName)
	  : ctx(managementDb), oldName(oldName), newName(newName) {}

																#line 57 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
// This generated class is to be used only via markTenantsInRenamingState()
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
template <class MarkTenantsInRenamingStateActor>
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class MarkTenantsInRenamingStateActorState {
															#line 63 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	MarkTenantsInRenamingStateActorState(RenameTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		 : self(self),
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		   tr(tr),
															#line 57 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		   tenantEntry(),
															#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		   newNameId()
															#line 76 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
	{
		fdb_probe_actor_create("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this));

	}
	~MarkTenantsInRenamingStateActorState() 
	{
		fdb_probe_actor_destroy("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = store(tenantEntry, getTenantTransaction(tr, self->oldName)) && store(newNameId, metadata::management::tenantMetadata().tenantNameIndex.get(tr, self->newName));
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state = 1;
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkTenantsInRenamingStateActor, 0, Void >*>(static_cast<MarkTenantsInRenamingStateActor*>(this)));
															#line 98 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkTenantsInRenamingStateActorState();
		static_cast<MarkTenantsInRenamingStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (self->tenantId != -1 && tenantEntry.id != self->tenantId)
															#line 121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster rename old tenant ID mismatch");
															#line 65 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 68 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		self->tenantId = tenantEntry.id;
															#line 71 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (tenantEntry.tenantState == TenantState::REMOVING)
															#line 133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster rename candidates marked for deletion");
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 76 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (newNameId.present() && (newNameId.get() != self->tenantId || self->oldName == self->newName))
															#line 143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster rename new name already exists");
															#line 78 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		StrictFuture<Void> __when_expr_1 = self->ctx.setCluster(tr, tenantEntry.assignedCluster);
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state = 2;
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >*>(static_cast<MarkTenantsInRenamingStateActor*>(this)));
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (self->tenantId != -1 && tenantEntry.id != self->tenantId)
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster rename old tenant ID mismatch");
															#line 65 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 68 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		self->tenantId = tenantEntry.id;
															#line 71 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (tenantEntry.tenantState == TenantState::REMOVING)
															#line 181 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster rename candidates marked for deletion");
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 76 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (newNameId.present() && (newNameId.get() != self->tenantId || self->oldName == self->newName))
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster rename new name already exists");
															#line 78 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		StrictFuture<Void> __when_expr_1 = self->ctx.setCluster(tr, tenantEntry.assignedCluster);
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state = 2;
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >*>(static_cast<MarkTenantsInRenamingStateActor*>(this)));
															#line 208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantsInRenamingStateActor*>(this)->ActorCallback< MarkTenantsInRenamingStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantsInRenamingStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkTenantsInRenamingStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkTenantsInRenamingStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (tenantEntry.tenantState == TenantState::RENAMING)
															#line 292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 84 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (tenantEntry.tenantName != self->oldName)
															#line 296 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			{
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				CODE_PROBE(true, "Renaming a tenant that is currently the destination of another rename");
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			}
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (tenantEntry.renameDestination.get() != self->newName)
															#line 306 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			{
															#line 89 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				CODE_PROBE(true, "Metacluster concurrent rename with different name");
															#line 90 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 312 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			}
			else
			{
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				CODE_PROBE(true, "Metacluster rename retry in progress");
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				self->configurationSequenceNum = tenantEntry.configurationSequenceNum;
															#line 94 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				if (!static_cast<MarkTenantsInRenamingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantsInRenamingStateActorState(); static_cast<MarkTenantsInRenamingStateActor*>(this)->destroy(); return 0; }
															#line 322 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
				new (&static_cast<MarkTenantsInRenamingStateActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MarkTenantsInRenamingStateActorState();
				static_cast<MarkTenantsInRenamingStateActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 98 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (tenantEntry.tenantState != TenantState::READY)
															#line 331 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 99 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster unable to proceed with rename operation");
															#line 100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(invalid_tenant_state(), loopDepth);
															#line 337 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		self->configurationSequenceNum = tenantEntry.configurationSequenceNum + 1;
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		StrictFuture<int64_t> __when_expr_2 = metadata::management::clusterTenantCount().getD(tr, tenantEntry.assignedCluster, Snapshot::False, 0);
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 345 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state = 3;
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >*>(static_cast<MarkTenantsInRenamingStateActor*>(this)));
															#line 350 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (tenantEntry.tenantState == TenantState::RENAMING)
															#line 359 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 84 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (tenantEntry.tenantName != self->oldName)
															#line 363 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			{
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				CODE_PROBE(true, "Renaming a tenant that is currently the destination of another rename");
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 369 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			}
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (tenantEntry.renameDestination.get() != self->newName)
															#line 373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			{
															#line 89 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				CODE_PROBE(true, "Metacluster concurrent rename with different name");
															#line 90 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			}
			else
			{
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				CODE_PROBE(true, "Metacluster rename retry in progress");
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				self->configurationSequenceNum = tenantEntry.configurationSequenceNum;
															#line 94 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				if (!static_cast<MarkTenantsInRenamingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantsInRenamingStateActorState(); static_cast<MarkTenantsInRenamingStateActor*>(this)->destroy(); return 0; }
															#line 389 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
				new (&static_cast<MarkTenantsInRenamingStateActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MarkTenantsInRenamingStateActorState();
				static_cast<MarkTenantsInRenamingStateActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 98 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (tenantEntry.tenantState != TenantState::READY)
															#line 398 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 99 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster unable to proceed with rename operation");
															#line 100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(invalid_tenant_state(), loopDepth);
															#line 404 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		self->configurationSequenceNum = tenantEntry.configurationSequenceNum + 1;
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		StrictFuture<int64_t> __when_expr_2 = metadata::management::clusterTenantCount().getD(tr, tenantEntry.assignedCluster, Snapshot::False, 0);
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 412 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state = 3;
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >*>(static_cast<MarkTenantsInRenamingStateActor*>(this)));
															#line 417 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantsInRenamingStateActor*>(this)->ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int64_t const& clusterTenantCount,int loopDepth) 
	{
															#line 109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (clusterTenantCount + 1 > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER)
															#line 501 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Rename failed due to cluster capacity limit");
															#line 111 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 507 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 114 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		MetaclusterTenantMapEntry updatedEntry = tenantEntry;
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		updatedEntry.tenantState = TenantState::RENAMING;
															#line 116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		updatedEntry.renameDestination = self->newName;
															#line 117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		updatedEntry.configurationSequenceNum = self->configurationSequenceNum;
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		metadata::management::tenantMetadata().tenantMap.set(tr, self->tenantId, updatedEntry);
															#line 120 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		metadata::management::tenantMetadata().tenantNameIndex.set(tr, self->newName, self->tenantId);
															#line 121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		metadata::management::clusterTenantIndex().insert( tr, Tuple::makeTuple(updatedEntry.assignedCluster, self->newName, TenantInfo::INVALID_TENANT));
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<MarkTenantsInRenamingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantsInRenamingStateActorState(); static_cast<MarkTenantsInRenamingStateActor*>(this)->destroy(); return 0; }
															#line 527 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<MarkTenantsInRenamingStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkTenantsInRenamingStateActorState();
		static_cast<MarkTenantsInRenamingStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(int64_t && clusterTenantCount,int loopDepth) 
	{
															#line 109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (clusterTenantCount + 1 > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER)
															#line 539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Rename failed due to cluster capacity limit");
															#line 111 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 545 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 114 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		MetaclusterTenantMapEntry updatedEntry = tenantEntry;
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		updatedEntry.tenantState = TenantState::RENAMING;
															#line 116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		updatedEntry.renameDestination = self->newName;
															#line 117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		updatedEntry.configurationSequenceNum = self->configurationSequenceNum;
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		metadata::management::tenantMetadata().tenantMap.set(tr, self->tenantId, updatedEntry);
															#line 120 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		metadata::management::tenantMetadata().tenantNameIndex.set(tr, self->newName, self->tenantId);
															#line 121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		metadata::management::clusterTenantIndex().insert( tr, Tuple::makeTuple(updatedEntry.assignedCluster, self->newName, TenantInfo::INVALID_TENANT));
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<MarkTenantsInRenamingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantsInRenamingStateActorState(); static_cast<MarkTenantsInRenamingStateActor*>(this)->destroy(); return 0; }
															#line 565 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<MarkTenantsInRenamingStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkTenantsInRenamingStateActorState();
		static_cast<MarkTenantsInRenamingStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& clusterTenantCount,int loopDepth) 
	{
		loopDepth = a_body1cont6(clusterTenantCount, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && clusterTenantCount,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(clusterTenantCount), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantsInRenamingStateActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantsInRenamingStateActor*>(this)->ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	RenameTenantImpl* self;
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 57 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	MetaclusterTenantMapEntry tenantEntry;
															#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	Optional<int64_t> newNameId;
															#line 656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
};
// This generated class is to be used only via markTenantsInRenamingState()
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class MarkTenantsInRenamingStateActor final : public Actor<Void>, public ActorCallback< MarkTenantsInRenamingStateActor, 0, Void >, public ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >, public ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >, public FastAllocated<MarkTenantsInRenamingStateActor>, public MarkTenantsInRenamingStateActorState<MarkTenantsInRenamingStateActor> {
															#line 661 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
	using FastAllocated<MarkTenantsInRenamingStateActor>::operator new;
	using FastAllocated<MarkTenantsInRenamingStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8872778700941241088UL, 2615705378057476352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkTenantsInRenamingStateActor, 0, Void >;
friend struct ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >;
friend struct ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >;
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	MarkTenantsInRenamingStateActor(RenameTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 680 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		 : Actor<Void>(),
		   MarkTenantsInRenamingStateActorState<MarkTenantsInRenamingStateActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14238816962617422848UL, 8656935582648702208UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantsInRenamingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markTenantsInRenamingState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markTenantsInRenamingState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkTenantsInRenamingStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MarkTenantsInRenamingStateActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MarkTenantsInRenamingStateActor, 2, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
[[nodiscard]] static Future<Void> markTenantsInRenamingState( RenameTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	return Future<Void>(new MarkTenantsInRenamingStateActor(self, tr));
															#line 714 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
}

#line 129 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"

																#line 719 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
// This generated class is to be used only via updateDataCluster()
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
template <class UpdateDataClusterActor>
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class UpdateDataClusterActorState {
															#line 725 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	UpdateDataClusterActorState(RenameTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		 : self(self),
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		   tr(tr)
															#line 734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
	{
		fdb_probe_actor_create("updateDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDataClusterActorState() 
	{
		fdb_probe_actor_destroy("updateDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			ASSERT(self->tenantId != -1);
															#line 132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			ASSERT(self->configurationSequenceNum != -1);
															#line 133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = TenantAPI::renameTenantTransaction(tr, self->oldName, self->newName, self->tenantId, ClusterType::METACLUSTER_DATA, self->configurationSequenceNum);
															#line 133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (static_cast<UpdateDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 755 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateDataClusterActor*>(this)->actor_wait_state = 1;
															#line 133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDataClusterActor, 0, Void >*>(static_cast<UpdateDataClusterActor*>(this)));
															#line 760 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDataClusterActorState();
		static_cast<UpdateDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<UpdateDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterActorState(); static_cast<UpdateDataClusterActor*>(this)->destroy(); return 0; }
															#line 783 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<UpdateDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateDataClusterActorState();
		static_cast<UpdateDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<UpdateDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterActorState(); static_cast<UpdateDataClusterActor*>(this)->destroy(); return 0; }
															#line 795 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<UpdateDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateDataClusterActorState();
		static_cast<UpdateDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDataClusterActor*>(this)->actor_wait_state > 0) static_cast<UpdateDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDataClusterActor*>(this)->ActorCallback< UpdateDataClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDataClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	RenameTenantImpl* self;
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 882 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
};
// This generated class is to be used only via updateDataCluster()
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class UpdateDataClusterActor final : public Actor<Void>, public ActorCallback< UpdateDataClusterActor, 0, Void >, public FastAllocated<UpdateDataClusterActor>, public UpdateDataClusterActorState<UpdateDataClusterActor> {
															#line 887 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
	using FastAllocated<UpdateDataClusterActor>::operator new;
	using FastAllocated<UpdateDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3651995197972315392UL, 13905651772107710464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDataClusterActor, 0, Void >;
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	UpdateDataClusterActor(RenameTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 904 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		 : Actor<Void>(),
		   UpdateDataClusterActorState<UpdateDataClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2197521157004316928UL, 13725143648043971840UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDataClusterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
[[nodiscard]] static Future<Void> updateDataCluster( RenameTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	return Future<Void>(new UpdateDataClusterActor(self, tr));
															#line 936 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
}

#line 141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"

																#line 941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
// This generated class is to be used only via finishRenameFromManagementCluster()
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
template <class FinishRenameFromManagementClusterActor>
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class FinishRenameFromManagementClusterActorState {
															#line 947 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	FinishRenameFromManagementClusterActorState(RenameTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		 : self(self),
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		   tr(tr)
															#line 956 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
	{
		fdb_probe_actor_create("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~FinishRenameFromManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, self->tenantId);
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (static_cast<FinishRenameFromManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 973 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishRenameFromManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishRenameFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<FinishRenameFromManagementClusterActor*>(this)));
															#line 978 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishRenameFromManagementClusterActorState();
		static_cast<FinishRenameFromManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterTenantMapEntry> const& tenantEntry,int loopDepth) 
	{
															#line 150 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!tenantEntry.present() || tenantEntry.get().tenantName != self->oldName || tenantEntry.get().configurationSequenceNum > self->configurationSequenceNum)
															#line 1001 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster finished rename with missing entries, mismatched id, and/or mismatched " "configuration sequence.");
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (!static_cast<FinishRenameFromManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishRenameFromManagementClusterActorState(); static_cast<FinishRenameFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1007 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			new (&static_cast<FinishRenameFromManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FinishRenameFromManagementClusterActorState();
			static_cast<FinishRenameFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (tenantEntry.get().tenantState == TenantState::REMOVING)
															#line 1015 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Tenant removed during rename");
															#line 159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 1021 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		MetaclusterTenantMapEntry updatedEntry = tenantEntry.get();
															#line 165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (updatedEntry.tenantState == TenantState::RENAMING)
															#line 1027 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			updatedEntry.tenantName = self->newName;
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			updatedEntry.tenantState = TenantState::READY;
															#line 168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			updatedEntry.renameDestination.reset();
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::tenantMetadata().tenantMap.set(tr, self->tenantId, updatedEntry);
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::tenantMetadata().tenantNameIndex.erase(tr, self->oldName);
															#line 175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (updatedEntry.tenantGroup.present())
															#line 1043 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			{
															#line 176 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				metadata::management::tenantMetadata().tenantGroupTenantIndex.erase( tr, Tuple::makeTuple(updatedEntry.tenantGroup.get(), self->oldName, self->tenantId));
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				metadata::management::tenantMetadata().tenantGroupTenantIndex.insert( tr, Tuple::makeTuple(updatedEntry.tenantGroup.get(), self->newName, self->tenantId));
															#line 1049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			}
															#line 183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::clusterTenantIndex().erase( tr, Tuple::makeTuple(updatedEntry.assignedCluster, self->oldName, self->tenantId));
															#line 185 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::clusterTenantIndex().erase( tr, Tuple::makeTuple(updatedEntry.assignedCluster, self->newName, TenantInfo::INVALID_TENANT));
															#line 187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::clusterTenantIndex().insert( tr, Tuple::makeTuple(updatedEntry.assignedCluster, self->newName, self->tenantId));
															#line 1057 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<FinishRenameFromManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishRenameFromManagementClusterActorState(); static_cast<FinishRenameFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1061 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<FinishRenameFromManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishRenameFromManagementClusterActorState();
		static_cast<FinishRenameFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterTenantMapEntry> && tenantEntry,int loopDepth) 
	{
															#line 150 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!tenantEntry.present() || tenantEntry.get().tenantName != self->oldName || tenantEntry.get().configurationSequenceNum > self->configurationSequenceNum)
															#line 1073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Metacluster finished rename with missing entries, mismatched id, and/or mismatched " "configuration sequence.");
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (!static_cast<FinishRenameFromManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishRenameFromManagementClusterActorState(); static_cast<FinishRenameFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1079 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			new (&static_cast<FinishRenameFromManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FinishRenameFromManagementClusterActorState();
			static_cast<FinishRenameFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (tenantEntry.get().tenantState == TenantState::REMOVING)
															#line 1087 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			CODE_PROBE(true, "Tenant removed during rename");
															#line 159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 1093 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		MetaclusterTenantMapEntry updatedEntry = tenantEntry.get();
															#line 165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (updatedEntry.tenantState == TenantState::RENAMING)
															#line 1099 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		{
															#line 166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			updatedEntry.tenantName = self->newName;
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			updatedEntry.tenantState = TenantState::READY;
															#line 168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			updatedEntry.renameDestination.reset();
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::tenantMetadata().tenantMap.set(tr, self->tenantId, updatedEntry);
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::tenantMetadata().tenantNameIndex.erase(tr, self->oldName);
															#line 175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (updatedEntry.tenantGroup.present())
															#line 1115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			{
															#line 176 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				metadata::management::tenantMetadata().tenantGroupTenantIndex.erase( tr, Tuple::makeTuple(updatedEntry.tenantGroup.get(), self->oldName, self->tenantId));
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				metadata::management::tenantMetadata().tenantGroupTenantIndex.insert( tr, Tuple::makeTuple(updatedEntry.tenantGroup.get(), self->newName, self->tenantId));
															#line 1121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			}
															#line 183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::clusterTenantIndex().erase( tr, Tuple::makeTuple(updatedEntry.assignedCluster, self->oldName, self->tenantId));
															#line 185 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::clusterTenantIndex().erase( tr, Tuple::makeTuple(updatedEntry.assignedCluster, self->newName, TenantInfo::INVALID_TENANT));
															#line 187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			metadata::management::clusterTenantIndex().insert( tr, Tuple::makeTuple(updatedEntry.assignedCluster, self->newName, self->tenantId));
															#line 1129 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		}
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<FinishRenameFromManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishRenameFromManagementClusterActorState(); static_cast<FinishRenameFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<FinishRenameFromManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishRenameFromManagementClusterActorState();
		static_cast<FinishRenameFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& tenantEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantEntry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && tenantEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishRenameFromManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<FinishRenameFromManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRenameFromManagementClusterActor*>(this)->ActorCallback< FinishRenameFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRenameFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRenameFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishRenameFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRenameFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishRenameFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRenameFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	RenameTenantImpl* self;
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 1220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
};
// This generated class is to be used only via finishRenameFromManagementCluster()
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class FinishRenameFromManagementClusterActor final : public Actor<Void>, public ActorCallback< FinishRenameFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >, public FastAllocated<FinishRenameFromManagementClusterActor>, public FinishRenameFromManagementClusterActorState<FinishRenameFromManagementClusterActor> {
															#line 1225 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
	using FastAllocated<FinishRenameFromManagementClusterActor>::operator new;
	using FastAllocated<FinishRenameFromManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10999213843742983168UL, 7291952521372554752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishRenameFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >;
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	FinishRenameFromManagementClusterActor(RenameTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1242 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		 : Actor<Void>(),
		   FinishRenameFromManagementClusterActorState<FinishRenameFromManagementClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15874681360522698240UL, 14430032777803778560UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRenameFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishRenameFromManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishRenameFromManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishRenameFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
[[nodiscard]] static Future<Void> finishRenameFromManagementCluster( RenameTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	return Future<Void>(new FinishRenameFromManagementClusterActor(self, tr));
															#line 1274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
}

#line 193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"

																#line 1279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
// This generated class is to be used only via run()
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
template <class RunActor>
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class RunActorState {
															#line 1285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	RunActorState(RenameTenantImpl* const& self) 
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		 : self(self)
															#line 1292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return markTenantsInRenamingState(self, tr); });
															#line 195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1309 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 1314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			StrictFuture<Void> __when_expr_1 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return updateDataCluster(self, tr); });
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1345 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			StrictFuture<Void> __when_expr_1 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return updateDataCluster(self, tr); });
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1363 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		StrictFuture<Void> __when_expr_2 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return finishRenameFromManagementCluster(self, tr); });
															#line 214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1460 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 1465 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 207 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (e.code() == error_code_tenant_not_found || e.code() == error_code_tenant_already_exists)
															#line 1475 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			{
															#line 208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				CODE_PROBE(true, "Metacluster rename ran into commit_unknown_result");
															#line 1479 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			}
			else
			{
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 1485 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 1601 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 1613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	RenameTenantImpl* self;
															#line 1698 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
};
// This generated class is to be used only via run()
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorCallback< RunActor, 1, Void >, public ActorCallback< RunActor, 2, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 1703 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1275329032522325504UL, 5000964120035705344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorCallback< RunActor, 1, Void >;
friend struct ActorCallback< RunActor, 2, Void >;
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	RunActor(RenameTenantImpl* const& self) 
															#line 1722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
[[nodiscard]] static Future<Void> run( RenameTenantImpl* const& self ) {
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	return Future<Void>(new RunActor(self));
															#line 1756 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
}

#line 219 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	Future<Void> run() { return run(this); }
};
} // namespace internal

															#line 1764 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
// This generated class is to be used only via renameTenant()
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
template <class DB, class RenameTenantActor>
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class RenameTenantActorState {
															#line 1770 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	RenameTenantActorState(Reference<DB> const& db,TenantName const& oldName,TenantName const& newName) 
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		 : db(db),
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		   oldName(oldName),
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		   newName(newName),
															#line 225 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		   impl(db, oldName, newName)
															#line 1783 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
	{
		fdb_probe_actor_create("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantActorState() 
	{
		fdb_probe_actor_destroy("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1800 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RenameTenantActor*>(this)->actor_wait_state = 1;
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 0, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 1805 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 1828 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 1840 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	Reference<DB> db;
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	TenantName oldName;
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	TenantName newName;
															#line 225 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	internal::RenameTenantImpl<DB> impl;
															#line 1931 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
};
// This generated class is to be used only via renameTenant()
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
template <class DB>
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
class RenameTenantActor final : public Actor<Void>, public ActorCallback< RenameTenantActor<DB>, 0, Void >, public FastAllocated<RenameTenantActor<DB>>, public RenameTenantActorState<DB, RenameTenantActor<DB>> {
															#line 1938 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
public:
	using FastAllocated<RenameTenantActor<DB>>::operator new;
	using FastAllocated<RenameTenantActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16169628480687890432UL, 9830954773040803328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantActor<DB>, 0, Void >;
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	RenameTenantActor(Reference<DB> const& db,TenantName const& oldName,TenantName const& newName) 
															#line 1955 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
		 : Actor<Void>(),
		   RenameTenantActorState<DB, RenameTenantActor<DB>>(db, oldName, newName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(972264867922354944UL, 1896563828629082368UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
template <class DB>
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
[[nodiscard]] Future<Void> renameTenant( Reference<DB> const& db, TenantName const& oldName, TenantName const& newName ) {
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"
	return Future<Void>(new RenameTenantActor<DB>(db, oldName, newName));
															#line 1989 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RenameTenant.actor.g.h"
}

#line 229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/RenameTenant.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif