#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
/*
 * CreateTenant.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_CREATETENANT_ACTOR_G_H)
#define METACLUSTER_CREATETENANT_ACTOR_G_H
#include "metacluster/CreateTenant.actor.g.h"
#elif !defined(METACLUSTER_CREATETENANT_ACTOR_H)
#define METACLUSTER_CREATETENANT_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterInternal.actor.h"
#include "metacluster/MetaclusterOperationContext.actor.h"
#include "metacluster/MetaclusterTypes.h"
#include "metacluster/MetaclusterUtil.actor.h"
#include "metacluster/UpdateTenantGroups.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

FDB_BOOLEAN_PARAM(AssignClusterAutomatically);

namespace internal {
template <class DB>
struct CreateTenantImpl {
	MetaclusterOperationContext<DB> ctx;
	AssignClusterAutomatically assignClusterAutomatically;
	IgnoreCapacityLimit ignoreCapacityLimit;

	// Initialization parameters
	MetaclusterTenantMapEntry tenantEntry;

	// Parameter set if tenant creation permanently fails on the data cluster
	Optional<int64_t> replaceExistingTenantId;

	CreateTenantImpl(Reference<DB> managementDb,
	                 MetaclusterTenantMapEntry tenantEntry,
	                 AssignClusterAutomatically assignClusterAutomatically,
	                 IgnoreCapacityLimit ignoreCapacityLimit)
	  : ctx(managementDb), tenantEntry(tenantEntry), assignClusterAutomatically(assignClusterAutomatically),
	    ignoreCapacityLimit(ignoreCapacityLimit) {}

																#line 66 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
// This generated class is to be used only via checkClusterAvailability()
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class CheckClusterAvailabilityActor>
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class CheckClusterAvailabilityActorState {
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CheckClusterAvailabilityActorState(Reference<IDatabase> const& dataClusterDb,ClusterName const& clusterName) 
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		 : dataClusterDb(dataClusterDb),
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   clusterName(clusterName),
															#line 66 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   tr(dataClusterDb->createTransaction())
															#line 83 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
	{
		fdb_probe_actor_create("checkClusterAvailability", reinterpret_cast<unsigned long>(this));

	}
	~CheckClusterAvailabilityActorState() 
	{
		fdb_probe_actor_destroy("checkClusterAvailability", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			;
															#line 98 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckClusterAvailabilityActorState();
		static_cast<CheckClusterAvailabilityActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 69 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 70 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			tr->addWriteConflictRange(KeyRangeRef("\xff/metacluster/availability_check"_sr, "\xff/metacluster/availability_check\x00"_sr));
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<CheckClusterAvailabilityActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckClusterAvailabilityActor*>(this)->actor_wait_state = 1;
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckClusterAvailabilityActor, 0, Void >*>(static_cast<CheckClusterAvailabilityActor*>(this)));
															#line 140 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 75 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 75 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<CheckClusterAvailabilityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckClusterAvailabilityActor*>(this)->actor_wait_state = 2;
															#line 75 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckClusterAvailabilityActor, 1, Void >*>(static_cast<CheckClusterAvailabilityActor*>(this)));
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<CheckClusterAvailabilityActor*>(this)->SAV<ClusterName>::futures) { (void)(clusterName); this->~CheckClusterAvailabilityActorState(); static_cast<CheckClusterAvailabilityActor*>(this)->destroy(); return 0; }
															#line 184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<CheckClusterAvailabilityActor*>(this)->SAV< ClusterName >::value()) ClusterName(std::move(clusterName)); // state_var_RVO
		this->~CheckClusterAvailabilityActorState();
		static_cast<CheckClusterAvailabilityActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<CheckClusterAvailabilityActor*>(this)->SAV<ClusterName>::futures) { (void)(clusterName); this->~CheckClusterAvailabilityActorState(); static_cast<CheckClusterAvailabilityActor*>(this)->destroy(); return 0; }
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<CheckClusterAvailabilityActor*>(this)->SAV< ClusterName >::value()) ClusterName(std::move(clusterName)); // state_var_RVO
		this->~CheckClusterAvailabilityActorState();
		static_cast<CheckClusterAvailabilityActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckClusterAvailabilityActor*>(this)->actor_wait_state > 0) static_cast<CheckClusterAvailabilityActor*>(this)->actor_wait_state = 0;
		static_cast<CheckClusterAvailabilityActor*>(this)->ActorCallback< CheckClusterAvailabilityActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckClusterAvailabilityActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckClusterAvailabilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckClusterAvailabilityActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckClusterAvailabilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckClusterAvailabilityActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckClusterAvailabilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckClusterAvailabilityActor*>(this)->actor_wait_state > 0) static_cast<CheckClusterAvailabilityActor*>(this)->actor_wait_state = 0;
		static_cast<CheckClusterAvailabilityActor*>(this)->ActorCallback< CheckClusterAvailabilityActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckClusterAvailabilityActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckClusterAvailabilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckClusterAvailabilityActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckClusterAvailabilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckClusterAvailabilityActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckClusterAvailabilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkClusterAvailability", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Reference<IDatabase> dataClusterDb;
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	ClusterName clusterName;
															#line 66 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Reference<ITransaction> tr;
															#line 372 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
};
// This generated class is to be used only via checkClusterAvailability()
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class CheckClusterAvailabilityActor final : public Actor<ClusterName>, public ActorCallback< CheckClusterAvailabilityActor, 0, Void >, public ActorCallback< CheckClusterAvailabilityActor, 1, Void >, public FastAllocated<CheckClusterAvailabilityActor>, public CheckClusterAvailabilityActorState<CheckClusterAvailabilityActor> {
															#line 377 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
	using FastAllocated<CheckClusterAvailabilityActor>::operator new;
	using FastAllocated<CheckClusterAvailabilityActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6543124400963351296UL, 1350746588343175424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ClusterName>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckClusterAvailabilityActor, 0, Void >;
friend struct ActorCallback< CheckClusterAvailabilityActor, 1, Void >;
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CheckClusterAvailabilityActor(Reference<IDatabase> const& dataClusterDb,ClusterName const& clusterName) 
															#line 395 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		 : Actor<ClusterName>(),
		   CheckClusterAvailabilityActorState<CheckClusterAvailabilityActor>(dataClusterDb, clusterName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkClusterAvailability", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10875060450735981568UL, 95860228246253568UL);
		ActorExecutionContextHelper __helper(static_cast<CheckClusterAvailabilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkClusterAvailability");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkClusterAvailability", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckClusterAvailabilityActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckClusterAvailabilityActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
[[nodiscard]] static Future<ClusterName> checkClusterAvailability( Reference<IDatabase> const& dataClusterDb, ClusterName const& clusterName ) {
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	return Future<ClusterName>(new CheckClusterAvailabilityActor(dataClusterDb, clusterName));
															#line 428 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
}

#line 79 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"

	// Returns true if the tenant is already assigned and can proceed to the next step and false if it needs
	// to be created. Throws an error if the tenant already exists and cannot be created.
																#line 435 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
// This generated class is to be used only via checkForExistingTenant()
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class CheckForExistingTenantActor>
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class CheckForExistingTenantActorState {
															#line 441 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CheckForExistingTenantActorState(CreateTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		 : self(self),
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   tr(tr)
															#line 450 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
	{
		fdb_probe_actor_create("checkForExistingTenant", reinterpret_cast<unsigned long>(this));

	}
	~CheckForExistingTenantActorState() 
	{
		fdb_probe_actor_destroy("checkForExistingTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, self->tenantEntry.tenantName);
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 467 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state = 1;
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckForExistingTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<CheckForExistingTenantActor*>(this)));
															#line 472 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckForExistingTenantActorState();
		static_cast<CheckForExistingTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 87 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (existingEntry.present())
															#line 495 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (!existingEntry.get().matchesConfiguration(self->tenantEntry) || existingEntry.get().tenantState != TenantState::REGISTERING)
															#line 499 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Create tenant that already exists");
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 505 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
			else
			{
															#line 94 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				if (!self->replaceExistingTenantId.present() || self->replaceExistingTenantId.get() != existingEntry.get().id)
															#line 511 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
				{
															#line 97 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					if (!self->assignClusterAutomatically && existingEntry.get().assignedCluster != self->tenantEntry.assignedCluster)
															#line 515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
					{
															#line 99 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
						CODE_PROBE(true, "Resume tenant creation failed due to assigned cluster change");
															#line 100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
						TraceEvent("MetaclusterCreateTenantClusterMismatch") .detail("Preferred", self->tenantEntry.assignedCluster) .detail("Actual", existingEntry.get().assignedCluster);
															#line 103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
						return a_body1Catch1(invalid_tenant_configuration(), loopDepth);
															#line 523 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
					}
															#line 105 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					CODE_PROBE(true, "Resume tenant creation");
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					self->tenantEntry = existingEntry.get();
															#line 107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					StrictFuture<Void> __when_expr_1 = self->ctx.setCluster(tr, existingEntry.get().assignedCluster);
															#line 107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					if (static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 533 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state = 2;
															#line 107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckForExistingTenantActor, 1, Void >*>(static_cast<CheckForExistingTenantActor*>(this)));
															#line 538 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
					loopDepth = 0;
				}
				else
				{
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					CODE_PROBE(true, "Recreate tenant after permanent failure of previous ID", probe::decoration::rare);
															#line 114 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					metadata::management::tenantMetadata().tenantMap.erase(tr, existingEntry.get().id);
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					metadata::management::tenantMetadata().tenantCount.atomicOp(tr, -1, MutationRef::AddValue);
															#line 116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					metadata::management::clusterTenantCount().atomicOp( tr, existingEntry.get().assignedCluster, -1, MutationRef::AddValue);
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					metadata::management::clusterTenantIndex().erase(tr, Tuple::makeTuple(existingEntry.get().assignedCluster, self->tenantEntry.tenantName, existingEntry.get().id));
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					StrictFuture<DataClusterMetadata> __when_expr_2 = getClusterTransaction(tr, existingEntry.get().assignedCluster);
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					if (static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 557 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
					static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state = 3;
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckForExistingTenantActor, 2, DataClusterMetadata >*>(static_cast<CheckForExistingTenantActor*>(this)));
															#line 562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
					loopDepth = 0;
				}
			}
		}
		else
		{
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (self->replaceExistingTenantId.present())
															#line 571 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Tenant removed during creation", probe::decoration::rare);
															#line 132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(tenant_removed(), loopDepth);
															#line 577 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& __existingEntry,int loopDepth) 
	{
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		existingEntry = __existingEntry;
															#line 588 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && __existingEntry,int loopDepth) 
	{
		existingEntry = std::move(__existingEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state > 0) static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExistingTenantActor*>(this)->ActorCallback< CheckForExistingTenantActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExistingTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckForExistingTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckForExistingTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<CheckForExistingTenantActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckForExistingTenantActorState(); static_cast<CheckForExistingTenantActor*>(this)->destroy(); return 0; }
															#line 667 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<CheckForExistingTenantActor*>(this)->SAV< bool >::value()) bool(false);
		this->~CheckForExistingTenantActorState();
		static_cast<CheckForExistingTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<CheckForExistingTenantActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForExistingTenantActorState(); static_cast<CheckForExistingTenantActor*>(this)->destroy(); return 0; }
															#line 691 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<CheckForExistingTenantActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckForExistingTenantActorState();
		static_cast<CheckForExistingTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<CheckForExistingTenantActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckForExistingTenantActorState(); static_cast<CheckForExistingTenantActor*>(this)->destroy(); return 0; }
															#line 703 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<CheckForExistingTenantActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckForExistingTenantActorState();
		static_cast<CheckForExistingTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state > 0) static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExistingTenantActor*>(this)->ActorCallback< CheckForExistingTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExistingTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckForExistingTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckForExistingTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Void> __when_expr_3 = internal::managementClusterRemoveTenantFromGroup( tr, existingEntry.get(), &previousAssignedClusterMetadata);
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state = 4;
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckForExistingTenantActor, 3, Void >*>(static_cast<CheckForExistingTenantActor*>(this)));
															#line 797 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when2(DataClusterMetadata const& __previousAssignedClusterMetadata,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		previousAssignedClusterMetadata = __previousAssignedClusterMetadata;
															#line 806 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(DataClusterMetadata && __previousAssignedClusterMetadata,int loopDepth) 
	{
		previousAssignedClusterMetadata = std::move(__previousAssignedClusterMetadata);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state > 0) static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExistingTenantActor*>(this)->ActorCallback< CheckForExistingTenantActor, 2, DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExistingTenantActor, 2, DataClusterMetadata >*,DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckForExistingTenantActor, 2, DataClusterMetadata >*,DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckForExistingTenantActor, 2, DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state > 0) static_cast<CheckForExistingTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CheckForExistingTenantActor*>(this)->ActorCallback< CheckForExistingTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckForExistingTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckForExistingTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckForExistingTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CreateTenantImpl* self;
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Optional<MetaclusterTenantMapEntry> existingEntry;
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	DataClusterMetadata previousAssignedClusterMetadata;
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
};
// This generated class is to be used only via checkForExistingTenant()
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class CheckForExistingTenantActor final : public Actor<bool>, public ActorCallback< CheckForExistingTenantActor, 0, Optional<MetaclusterTenantMapEntry> >, public ActorCallback< CheckForExistingTenantActor, 1, Void >, public ActorCallback< CheckForExistingTenantActor, 2, DataClusterMetadata >, public ActorCallback< CheckForExistingTenantActor, 3, Void >, public FastAllocated<CheckForExistingTenantActor>, public CheckForExistingTenantActorState<CheckForExistingTenantActor> {
															#line 981 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
	using FastAllocated<CheckForExistingTenantActor>::operator new;
	using FastAllocated<CheckForExistingTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11339266708346176768UL, 9077590560580843776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckForExistingTenantActor, 0, Optional<MetaclusterTenantMapEntry> >;
friend struct ActorCallback< CheckForExistingTenantActor, 1, Void >;
friend struct ActorCallback< CheckForExistingTenantActor, 2, DataClusterMetadata >;
friend struct ActorCallback< CheckForExistingTenantActor, 3, Void >;
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CheckForExistingTenantActor(CreateTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1001 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		 : Actor<bool>(),
		   CheckForExistingTenantActorState<CheckForExistingTenantActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkForExistingTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12048306303578909440UL, 14391164453399529472UL);
		ActorExecutionContextHelper __helper(static_cast<CheckForExistingTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkForExistingTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkForExistingTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckForExistingTenantActor, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckForExistingTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckForExistingTenantActor, 2, DataClusterMetadata >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckForExistingTenantActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
[[nodiscard]] static Future<bool> checkForExistingTenant( CreateTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	return Future<bool>(new CheckForExistingTenantActor(self, tr));
															#line 1036 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
}

#line 137 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"

	// Returns a pair with the name of the assigned cluster and whether the group was already assigned
																#line 1042 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
// This generated class is to be used only via assignTenant()
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class AssignTenantActor>
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class AssignTenantActorState {
															#line 1048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	AssignTenantActorState(CreateTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		 : self(self),
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   tr(tr),
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   groupEntry()
															#line 1059 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
	{
		fdb_probe_actor_create("assignTenant", reinterpret_cast<unsigned long>(this));

	}
	~AssignTenantActorState() 
	{
		fdb_probe_actor_destroy("assignTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (self->tenantEntry.tenantGroup.present())
															#line 1074 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				StrictFuture<Optional<MetaclusterTenantGroupEntry>> __when_expr_0 = metadata::management::tenantMetadata().tenantGroupMap.get(tr, self->tenantEntry.tenantGroup.get());
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				if (static_cast<AssignTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1080 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AssignTenantActor*>(this)->actor_wait_state = 1;
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AssignTenantActor, 0, Optional<MetaclusterTenantGroupEntry> >*>(static_cast<AssignTenantActor*>(this)));
															#line 1085 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AssignTenantActorState();
		static_cast<AssignTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		dataClusterDbs = std::vector<Future<Reference<IDatabase>>>();
															#line 165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		dataClusterNames = std::vector<ClusterName>();
															#line 166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		clusterAvailabilityChecks = std::vector<Future<ClusterName>>();
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!self->assignClusterAutomatically)
															#line 1119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<DataClusterMetadata> __when_expr_1 = getClusterTransaction(tr, self->tenantEntry.assignedCluster);
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<AssignTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1125 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<AssignTenantActor*>(this)->actor_wait_state = 2;
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AssignTenantActor, 1, DataClusterMetadata >*>(static_cast<AssignTenantActor*>(this)));
															#line 1130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<KeyBackedSet<Tuple>::RangeResultType> __when_expr_2 = metadata::management::clusterCapacityIndex().getRange( tr, {}, {}, CLIENT_KNOBS->METACLUSTER_ASSIGNMENT_CLUSTERS_TO_CHECK, Snapshot::False, Reverse::True);
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<AssignTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<AssignTenantActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AssignTenantActor, 2, KeyBackedSet<Tuple>::RangeResultType >*>(static_cast<AssignTenantActor*>(this)));
															#line 1144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Optional<MetaclusterTenantGroupEntry> const& _groupEntry,int loopDepth) 
	{
															#line 146 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		groupEntry = _groupEntry;
															#line 148 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (groupEntry.present())
															#line 1156 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (!self->assignClusterAutomatically && groupEntry.get().assignedCluster != self->tenantEntry.assignedCluster)
															#line 1160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Attempt to create tenant in group on a different cluster");
															#line 152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				TraceEvent("MetaclusterCreateTenantGroupClusterMismatch") .detail("TenantGroupCluster", groupEntry.get().assignedCluster) .detail("SpecifiedCluster", self->tenantEntry.assignedCluster);
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(invalid_tenant_configuration(), loopDepth);
															#line 1168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(self->assignClusterAutomatically, "Create tenant in an existing group with auto-assignment");
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(!self->assignClusterAutomatically, "Create tenant in an existing group with assigned cluster");
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (!static_cast<AssignTenantActor*>(this)->SAV<std::pair<ClusterName, bool>>::futures) { (void)(std::make_pair(groupEntry.get().assignedCluster, true)); this->~AssignTenantActorState(); static_cast<AssignTenantActor*>(this)->destroy(); return 0; }
															#line 1176 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			new (&static_cast<AssignTenantActor*>(this)->SAV< std::pair<ClusterName, bool> >::value()) std::pair<ClusterName, bool>(std::make_pair(groupEntry.get().assignedCluster, true));
			this->~AssignTenantActorState();
			static_cast<AssignTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<MetaclusterTenantGroupEntry> && _groupEntry,int loopDepth) 
	{
															#line 146 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		groupEntry = _groupEntry;
															#line 148 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (groupEntry.present())
															#line 1192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (!self->assignClusterAutomatically && groupEntry.get().assignedCluster != self->tenantEntry.assignedCluster)
															#line 1196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Attempt to create tenant in group on a different cluster");
															#line 152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				TraceEvent("MetaclusterCreateTenantGroupClusterMismatch") .detail("TenantGroupCluster", groupEntry.get().assignedCluster) .detail("SpecifiedCluster", self->tenantEntry.assignedCluster);
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(invalid_tenant_configuration(), loopDepth);
															#line 1204 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(self->assignClusterAutomatically, "Create tenant in an existing group with auto-assignment");
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(!self->assignClusterAutomatically, "Create tenant in an existing group with assigned cluster");
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (!static_cast<AssignTenantActor*>(this)->SAV<std::pair<ClusterName, bool>>::futures) { (void)(std::make_pair(groupEntry.get().assignedCluster, true)); this->~AssignTenantActorState(); static_cast<AssignTenantActor*>(this)->destroy(); return 0; }
															#line 1212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			new (&static_cast<AssignTenantActor*>(this)->SAV< std::pair<ClusterName, bool> >::value()) std::pair<ClusterName, bool>(std::make_pair(groupEntry.get().assignedCluster, true));
			this->~AssignTenantActorState();
			static_cast<AssignTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantGroupEntry> const& _groupEntry,int loopDepth) 
	{
		loopDepth = a_body1cont2(_groupEntry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantGroupEntry> && _groupEntry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_groupEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AssignTenantActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantActor*>(this)->ActorCallback< AssignTenantActor, 0, Optional<MetaclusterTenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 0, Optional<MetaclusterTenantGroupEntry> >*,Optional<MetaclusterTenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 0, Optional<MetaclusterTenantGroupEntry> >*,Optional<MetaclusterTenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AssignTenantActor, 0, Optional<MetaclusterTenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		for( auto const& dataClusterName : dataClusterNames ) {
															#line 195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			dataClusterDbs.push_back(util::getAndOpenDatabase(tr, dataClusterName));
															#line 1303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Void> __when_expr_3 = waitForAll(dataClusterDbs);
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1309 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<AssignTenantActor*>(this)->actor_wait_state = 4;
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AssignTenantActor, 3, Void >*>(static_cast<AssignTenantActor*>(this)));
															#line 1314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(DataClusterMetadata const& dataClusterMetadata,int loopDepth) 
	{
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!dataClusterMetadata.entry.hasCapacity() && !self->ignoreCapacityLimit)
															#line 1323 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Selected cluster has no capacity");
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 1329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 176 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		dataClusterNames.push_back(self->tenantEntry.assignedCluster);
															#line 1333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(DataClusterMetadata && dataClusterMetadata,int loopDepth) 
	{
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!dataClusterMetadata.entry.hasCapacity() && !self->ignoreCapacityLimit)
															#line 1342 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Selected cluster has no capacity");
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 1348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 176 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		dataClusterNames.push_back(self->tenantEntry.assignedCluster);
															#line 1352 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DataClusterMetadata const& dataClusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont7(dataClusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DataClusterMetadata && dataClusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(dataClusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AssignTenantActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantActor*>(this)->ActorCallback< AssignTenantActor, 1, DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 1, DataClusterMetadata >*,DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 1, DataClusterMetadata >*,DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AssignTenantActor, 1, DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (availableClusters.results.empty())
															#line 1436 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Metacluster has no capacity");
															#line 188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(metacluster_no_capacity(), loopDepth);
															#line 1442 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		for( auto const& clusterTuple : availableClusters.results ) {
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			dataClusterNames.push_back(clusterTuple.getString(1));
															#line 1448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(KeyBackedSet<Tuple>::RangeResultType const& __availableClusters,int loopDepth) 
	{
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		availableClusters = __availableClusters;
															#line 1458 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(KeyBackedSet<Tuple>::RangeResultType && __availableClusters,int loopDepth) 
	{
		availableClusters = std::move(__availableClusters);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AssignTenantActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantActor*>(this)->ActorCallback< AssignTenantActor, 2, KeyBackedSet<Tuple>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 2, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 2, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AssignTenantActor, 2, KeyBackedSet<Tuple>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		for(int i = 0;i < dataClusterDbs.size();++i) {
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			clusterAvailabilityChecks.push_back(checkClusterAvailability(dataClusterDbs[i].get(), dataClusterNames[i]));
															#line 1539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Optional<Void>> __when_expr_4 = timeout( success(clusterAvailabilityChecks[0]) || (delay(CLIENT_KNOBS->METACLUSTER_ASSIGNMENT_FIRST_CHOICE_DELAY) && waitForAny(clusterAvailabilityChecks)), CLIENT_KNOBS->METACLUSTER_ASSIGNMENT_AVAILABILITY_TIMEOUT);
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1545 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<AssignTenantActor*>(this)->actor_wait_state = 5;
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AssignTenantActor, 4, Optional<Void> >*>(static_cast<AssignTenantActor*>(this)));
															#line 1550 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		for(int i = 0;i < dataClusterDbs.size();++i) {
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			clusterAvailabilityChecks.push_back(checkClusterAvailability(dataClusterDbs[i].get(), dataClusterNames[i]));
															#line 1561 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Optional<Void>> __when_expr_4 = timeout( success(clusterAvailabilityChecks[0]) || (delay(CLIENT_KNOBS->METACLUSTER_ASSIGNMENT_FIRST_CHOICE_DELAY) && waitForAny(clusterAvailabilityChecks)), CLIENT_KNOBS->METACLUSTER_ASSIGNMENT_AVAILABILITY_TIMEOUT);
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<AssignTenantActor*>(this)->actor_wait_state = 5;
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AssignTenantActor, 4, Optional<Void> >*>(static_cast<AssignTenantActor*>(this)));
															#line 1572 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AssignTenantActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantActor*>(this)->ActorCallback< AssignTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AssignTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont1(Optional<Void> const& clusterAvailabilityCheck,int loopDepth) 
	{
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!clusterAvailabilityCheck.present())
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Data cluster availability check timed out");
															#line 213 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(transaction_too_old(), loopDepth);
															#line 1662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 216 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		CODE_PROBE(clusterAvailabilityChecks[0].isReady(), "Preferred cluster available");
															#line 217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		CODE_PROBE(!clusterAvailabilityChecks[0].isReady(), "Preferred cluster not available");
															#line 220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		chosenCluster = Optional<ClusterName>();
															#line 221 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		for( auto const& f : clusterAvailabilityChecks ) {
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (f.isReady())
															#line 1674 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				chosenCluster = f.get();
															#line 1678 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
				break;
			}
															#line 227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Preferred cluster not available");
															#line 1683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		ASSERT(chosenCluster.present());
															#line 231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<AssignTenantActor*>(this)->SAV<std::pair<ClusterName, bool>>::futures) { (void)(std::make_pair(chosenCluster.get(), false)); this->~AssignTenantActorState(); static_cast<AssignTenantActor*>(this)->destroy(); return 0; }
															#line 1689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<AssignTenantActor*>(this)->SAV< std::pair<ClusterName, bool> >::value()) std::pair<ClusterName, bool>(std::make_pair(chosenCluster.get(), false));
		this->~AssignTenantActorState();
		static_cast<AssignTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont1(Optional<Void> && clusterAvailabilityCheck,int loopDepth) 
	{
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!clusterAvailabilityCheck.present())
															#line 1701 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Data cluster availability check timed out");
															#line 213 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(transaction_too_old(), loopDepth);
															#line 1707 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 216 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		CODE_PROBE(clusterAvailabilityChecks[0].isReady(), "Preferred cluster available");
															#line 217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		CODE_PROBE(!clusterAvailabilityChecks[0].isReady(), "Preferred cluster not available");
															#line 220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		chosenCluster = Optional<ClusterName>();
															#line 221 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		for( auto const& f : clusterAvailabilityChecks ) {
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (f.isReady())
															#line 1719 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				chosenCluster = f.get();
															#line 1723 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
				break;
			}
															#line 227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Preferred cluster not available");
															#line 1728 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		ASSERT(chosenCluster.present());
															#line 231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<AssignTenantActor*>(this)->SAV<std::pair<ClusterName, bool>>::futures) { (void)(std::make_pair(chosenCluster.get(), false)); this->~AssignTenantActorState(); static_cast<AssignTenantActor*>(this)->destroy(); return 0; }
															#line 1734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<AssignTenantActor*>(this)->SAV< std::pair<ClusterName, bool> >::value()) std::pair<ClusterName, bool>(std::make_pair(chosenCluster.get(), false));
		this->~AssignTenantActorState();
		static_cast<AssignTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11when1(Optional<Void> const& clusterAvailabilityCheck,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(clusterAvailabilityCheck, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Optional<Void> && clusterAvailabilityCheck,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(clusterAvailabilityCheck), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<AssignTenantActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantActor*>(this)->ActorCallback< AssignTenantActor, 4, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 4, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< AssignTenantActor, 4, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< AssignTenantActor, 4, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CreateTenantImpl* self;
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Optional<MetaclusterTenantGroupEntry> groupEntry;
															#line 164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	std::vector<Future<Reference<IDatabase>>> dataClusterDbs;
															#line 165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	std::vector<ClusterName> dataClusterNames;
															#line 166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	std::vector<Future<ClusterName>> clusterAvailabilityChecks;
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	KeyBackedSet<Tuple>::RangeResultType availableClusters;
															#line 220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Optional<ClusterName> chosenCluster;
															#line 1833 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
};
// This generated class is to be used only via assignTenant()
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class AssignTenantActor final : public Actor<std::pair<ClusterName, bool>>, public ActorCallback< AssignTenantActor, 0, Optional<MetaclusterTenantGroupEntry> >, public ActorCallback< AssignTenantActor, 1, DataClusterMetadata >, public ActorCallback< AssignTenantActor, 2, KeyBackedSet<Tuple>::RangeResultType >, public ActorCallback< AssignTenantActor, 3, Void >, public ActorCallback< AssignTenantActor, 4, Optional<Void> >, public FastAllocated<AssignTenantActor>, public AssignTenantActorState<AssignTenantActor> {
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
	using FastAllocated<AssignTenantActor>::operator new;
	using FastAllocated<AssignTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1861118557762075392UL, 11431395933842744832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<ClusterName, bool>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AssignTenantActor, 0, Optional<MetaclusterTenantGroupEntry> >;
friend struct ActorCallback< AssignTenantActor, 1, DataClusterMetadata >;
friend struct ActorCallback< AssignTenantActor, 2, KeyBackedSet<Tuple>::RangeResultType >;
friend struct ActorCallback< AssignTenantActor, 3, Void >;
friend struct ActorCallback< AssignTenantActor, 4, Optional<Void> >;
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	AssignTenantActor(CreateTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1859 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		 : Actor<std::pair<ClusterName, bool>>(),
		   AssignTenantActorState<AssignTenantActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("assignTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7770586988439505664UL, 5572835895687720960UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("assignTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("assignTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AssignTenantActor, 0, Optional<MetaclusterTenantGroupEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AssignTenantActor, 1, DataClusterMetadata >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AssignTenantActor, 2, KeyBackedSet<Tuple>::RangeResultType >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AssignTenantActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< AssignTenantActor, 4, Optional<Void> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
[[nodiscard]] static Future<std::pair<ClusterName, bool>> assignTenant( CreateTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	return Future<std::pair<ClusterName, bool>>(new AssignTenantActor(self, tr));
															#line 1895 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
}

#line 233 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"

																#line 1900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
// This generated class is to be used only via assignTenantAndStoreInManagementCluster()
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class AssignTenantAndStoreInManagementClusterActor>
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class AssignTenantAndStoreInManagementClusterActorState {
															#line 1906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	AssignTenantAndStoreInManagementClusterActorState(CreateTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		 : self(self),
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   tr(tr)
															#line 1915 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
	{
		fdb_probe_actor_create("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~AssignTenantAndStoreInManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 237 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<bool> __when_expr_0 = checkForExistingTenant(self, tr);
															#line 237 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1932 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 237 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AssignTenantAndStoreInManagementClusterActor, 0, bool >*>(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)));
															#line 1937 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AssignTenantAndStoreInManagementClusterActorState();
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& tenantExists,int loopDepth) 
	{
															#line 238 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (tenantExists)
															#line 1960 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (!static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssignTenantAndStoreInManagementClusterActorState(); static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1964 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			new (&static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AssignTenantAndStoreInManagementClusterActorState();
			static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<std::pair<ClusterName, bool>> __when_expr_1 = assignTenant(self, tr);
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1974 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >*>(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)));
															#line 1979 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && tenantExists,int loopDepth) 
	{
															#line 238 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (tenantExists)
															#line 1988 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (!static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssignTenantAndStoreInManagementClusterActorState(); static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1992 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			new (&static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AssignTenantAndStoreInManagementClusterActorState();
			static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<std::pair<ClusterName, bool>> __when_expr_1 = assignTenant(self, tr);
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2002 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >*>(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)));
															#line 2007 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& tenantExists,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantExists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && tenantExists,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantExists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->ActorCallback< AssignTenantAndStoreInManagementClusterActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 244 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		self->tenantEntry.assignedCluster = assignment.first;
															#line 247 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		setClusterFuture = self->ctx.setCluster(tr, assignment.first);
															#line 250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Optional<int64_t>> __when_expr_2 = metadata::management::tenantMetadata().lastTenantId.get(tr);
															#line 250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2097 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 3;
															#line 250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AssignTenantAndStoreInManagementClusterActor, 2, Optional<int64_t> >*>(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)));
															#line 2102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::pair<ClusterName, bool> const& __assignment,int loopDepth) 
	{
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		assignment = __assignment;
															#line 2111 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::pair<ClusterName, bool> && __assignment,int loopDepth) 
	{
		assignment = std::move(__assignment);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >*,std::pair<ClusterName, bool> const& value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >*,std::pair<ClusterName, bool> && value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 253 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!lastId.present())
															#line 2190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 254 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Generating first tenant ID");
															#line 255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<Optional<int64_t>> __when_expr_3 = TenantMetadata::tenantIdPrefix().get(tr);
															#line 255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 4;
															#line 255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AssignTenantAndStoreInManagementClusterActor, 3, Optional<int64_t> >*>(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)));
															#line 2203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Optional<int64_t> const& __lastId,int loopDepth) 
	{
															#line 250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		lastId = __lastId;
															#line 2217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<int64_t> && __lastId,int loopDepth) 
	{
		lastId = std::move(__lastId);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->ActorCallback< AssignTenantAndStoreInManagementClusterActor, 2, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 2, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 2, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 2, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 259 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		self->tenantEntry.setId(TenantAPI::computeNextTenantId(lastId.get(), 1));
															#line 260 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		metadata::management::tenantMetadata().lastTenantId.set(tr, self->tenantEntry.id);
															#line 262 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		self->tenantEntry.tenantState = TenantState::REGISTERING;
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		metadata::management::tenantMetadata().tenantMap.set(tr, self->tenantEntry.id, self->tenantEntry);
															#line 264 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		metadata::management::tenantMetadata().tenantNameIndex.set( tr, self->tenantEntry.tenantName, self->tenantEntry.id);
															#line 266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		metadata::management::tenantMetadata().tenantCount.atomicOp(tr, 1, MutationRef::AddValue);
															#line 269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		metadata::management::clusterTenantCount().atomicOp( tr, self->tenantEntry.assignedCluster, 1, MutationRef::AddValue);
															#line 272 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<int64_t> __when_expr_4 = metadata::management::clusterTenantCount().getD(tr, self->tenantEntry.assignedCluster, Snapshot::False, 0);
															#line 272 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 5;
															#line 272 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AssignTenantAndStoreInManagementClusterActor, 4, int64_t >*>(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)));
															#line 2319 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<int64_t> const& tenantIdPrefix,int loopDepth) 
	{
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		ASSERT(tenantIdPrefix.present());
															#line 257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		lastId = tenantIdPrefix.get() << 48;
															#line 2330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Optional<int64_t> && tenantIdPrefix,int loopDepth) 
	{
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		ASSERT(tenantIdPrefix.present());
															#line 257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		lastId = tenantIdPrefix.get() << 48;
															#line 2341 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<int64_t> const& tenantIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont6(tenantIdPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<int64_t> && tenantIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(tenantIdPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->ActorCallback< AssignTenantAndStoreInManagementClusterActor, 3, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 3, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 3, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 3, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int64_t const& clusterTenantCount,int loopDepth) 
	{
															#line 275 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (clusterTenantCount > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER)
															#line 2425 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Cluster tenant capacity exceeded");
															#line 277 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 2431 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		metadata::management::clusterTenantIndex().insert( tr, Tuple::makeTuple(self->tenantEntry.assignedCluster, self->tenantEntry.tenantName, self->tenantEntry.id));
															#line 285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Void> __when_expr_5 = setClusterFuture;
															#line 285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2439 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 6;
															#line 285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >*>(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)));
															#line 2444 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(int64_t && clusterTenantCount,int loopDepth) 
	{
															#line 275 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (clusterTenantCount > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER)
															#line 2453 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Cluster tenant capacity exceeded");
															#line 277 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 2459 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		metadata::management::clusterTenantIndex().insert( tr, Tuple::makeTuple(self->tenantEntry.assignedCluster, self->tenantEntry.tenantName, self->tenantEntry.id));
															#line 285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Void> __when_expr_5 = setClusterFuture;
															#line 285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2467 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 6;
															#line 285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >*>(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)));
															#line 2472 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(int64_t const& clusterTenantCount,int loopDepth) 
	{
		loopDepth = a_body1cont8(clusterTenantCount, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(int64_t && clusterTenantCount,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(clusterTenantCount), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->ActorCallback< AssignTenantAndStoreInManagementClusterActor, 4, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 4, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 4, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 4, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 289 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (self->ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::REMOVING)
															#line 2556 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 290 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Tenant created in cluster being removed", probe::decoration::rare);
															#line 291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(cluster_removed(), loopDepth);
															#line 2562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
		else
		{
															#line 292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (self->ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::RESTORING)
															#line 2568 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 293 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Tenant created in cluster being restored", probe::decoration::rare);
															#line 294 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(cluster_restoring(), loopDepth);
															#line 2574 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
		}
															#line 297 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		ASSERT(self->ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::READY);
															#line 299 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		internal::managementClusterAddTenantToGroup(tr, self->tenantEntry, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists(assignment.second), self->ignoreCapacityLimit);
															#line 305 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssignTenantAndStoreInManagementClusterActorState(); static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->destroy(); return 0; }
															#line 2583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssignTenantAndStoreInManagementClusterActorState();
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 289 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (self->ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::REMOVING)
															#line 2595 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 290 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Tenant created in cluster being removed", probe::decoration::rare);
															#line 291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(cluster_removed(), loopDepth);
															#line 2601 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
		else
		{
															#line 292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (self->ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::RESTORING)
															#line 2607 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 293 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Tenant created in cluster being restored", probe::decoration::rare);
															#line 294 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(cluster_restoring(), loopDepth);
															#line 2613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
		}
															#line 297 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		ASSERT(self->ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::READY);
															#line 299 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		internal::managementClusterAddTenantToGroup(tr, self->tenantEntry, &self->ctx.dataClusterMetadata.get(), GroupAlreadyExists(assignment.second), self->ignoreCapacityLimit);
															#line 305 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AssignTenantAndStoreInManagementClusterActorState(); static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->destroy(); return 0; }
															#line 2622 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AssignTenantAndStoreInManagementClusterActorState();
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CreateTenantImpl* self;
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	std::pair<ClusterName, bool> assignment;
															#line 247 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Future<Void> setClusterFuture;
															#line 250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Optional<int64_t> lastId;
															#line 2715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
};
// This generated class is to be used only via assignTenantAndStoreInManagementCluster()
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class AssignTenantAndStoreInManagementClusterActor final : public Actor<Void>, public ActorCallback< AssignTenantAndStoreInManagementClusterActor, 0, bool >, public ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >, public ActorCallback< AssignTenantAndStoreInManagementClusterActor, 2, Optional<int64_t> >, public ActorCallback< AssignTenantAndStoreInManagementClusterActor, 3, Optional<int64_t> >, public ActorCallback< AssignTenantAndStoreInManagementClusterActor, 4, int64_t >, public ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >, public FastAllocated<AssignTenantAndStoreInManagementClusterActor>, public AssignTenantAndStoreInManagementClusterActorState<AssignTenantAndStoreInManagementClusterActor> {
															#line 2720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
	using FastAllocated<AssignTenantAndStoreInManagementClusterActor>::operator new;
	using FastAllocated<AssignTenantAndStoreInManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13834599038335661824UL, 16745643351054874368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AssignTenantAndStoreInManagementClusterActor, 0, bool >;
friend struct ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >;
friend struct ActorCallback< AssignTenantAndStoreInManagementClusterActor, 2, Optional<int64_t> >;
friend struct ActorCallback< AssignTenantAndStoreInManagementClusterActor, 3, Optional<int64_t> >;
friend struct ActorCallback< AssignTenantAndStoreInManagementClusterActor, 4, int64_t >;
friend struct ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >;
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	AssignTenantAndStoreInManagementClusterActor(CreateTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 2742 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		 : Actor<Void>(),
		   AssignTenantAndStoreInManagementClusterActorState<AssignTenantAndStoreInManagementClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6917263433263350016UL, 10784136206443625728UL);
		ActorExecutionContextHelper __helper(static_cast<AssignTenantAndStoreInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("assignTenantAndStoreInManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("assignTenantAndStoreInManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AssignTenantAndStoreInManagementClusterActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AssignTenantAndStoreInManagementClusterActor, 1, std::pair<ClusterName, bool> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AssignTenantAndStoreInManagementClusterActor, 2, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AssignTenantAndStoreInManagementClusterActor, 3, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< AssignTenantAndStoreInManagementClusterActor, 4, int64_t >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< AssignTenantAndStoreInManagementClusterActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
[[nodiscard]] static Future<Void> assignTenantAndStoreInManagementCluster( CreateTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	return Future<Void>(new AssignTenantAndStoreInManagementClusterActor(self, tr));
															#line 2779 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
}

#line 307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"

																#line 2784 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
// This generated class is to be used only via storeTenantInDataCluster()
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class StoreTenantInDataClusterActor>
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class StoreTenantInDataClusterActorState {
															#line 2790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	StoreTenantInDataClusterActorState(CreateTenantImpl* const& self,Reference<ITransaction> const& tr) 
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		 : self(self),
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   tr(tr),
															#line 309 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   lastTenantIdFuture(TenantMetadata::lastTenantId().getD(tr, Snapshot::False, -1))
															#line 2801 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
	{
		fdb_probe_actor_create("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~StoreTenantInDataClusterActorState() 
	{
		fdb_probe_actor_destroy("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<std::pair<Optional<TenantMapEntry>, bool>> __when_expr_0 = TenantAPI::createTenantTransaction( tr, self->tenantEntry.toTenantMapEntry(), ClusterType::METACLUSTER_DATA);
															#line 310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<StoreTenantInDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2818 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StoreTenantInDataClusterActor*>(this)->actor_wait_state = 1;
															#line 310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StoreTenantInDataClusterActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*>(static_cast<StoreTenantInDataClusterActor*>(this)));
															#line 2823 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StoreTenantInDataClusterActorState();
		static_cast<StoreTenantInDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 313 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<int64_t> __when_expr_1 = lastTenantIdFuture;
															#line 313 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<StoreTenantInDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2848 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StoreTenantInDataClusterActor*>(this)->actor_wait_state = 2;
															#line 313 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StoreTenantInDataClusterActor, 1, int64_t >*>(static_cast<StoreTenantInDataClusterActor*>(this)));
															#line 2853 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::pair<Optional<TenantMapEntry>, bool> const& __dataClusterTenant,int loopDepth) 
	{
															#line 310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		dataClusterTenant = __dataClusterTenant;
															#line 2862 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<Optional<TenantMapEntry>, bool> && __dataClusterTenant,int loopDepth) 
	{
		dataClusterTenant = std::move(__dataClusterTenant);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StoreTenantInDataClusterActor*>(this)->actor_wait_state > 0) static_cast<StoreTenantInDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<StoreTenantInDataClusterActor*>(this)->ActorCallback< StoreTenantInDataClusterActor, 0, std::pair<Optional<TenantMapEntry>, bool> >::remove();

	}
	void a_callback_fire(ActorCallback< StoreTenantInDataClusterActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*,std::pair<Optional<TenantMapEntry>, bool> const& value) 
	{
		fdb_probe_actor_enter("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StoreTenantInDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StoreTenantInDataClusterActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*,std::pair<Optional<TenantMapEntry>, bool> && value) 
	{
		fdb_probe_actor_enter("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StoreTenantInDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StoreTenantInDataClusterActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*,Error err) 
	{
		fdb_probe_actor_enter("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StoreTenantInDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int64_t const& lastTenantId,int loopDepth) 
	{
															#line 314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (lastTenantId < self->tenantEntry.id)
															#line 2941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 315 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			TenantMetadata::lastTenantId().set(tr, self->tenantEntry.id);
															#line 2945 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 320 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!dataClusterTenant.first.present())
															#line 2949 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Tenant creation encountered tombstone");
															#line 322 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 2955 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 325 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<StoreTenantInDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StoreTenantInDataClusterActorState(); static_cast<StoreTenantInDataClusterActor*>(this)->destroy(); return 0; }
															#line 2959 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<StoreTenantInDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StoreTenantInDataClusterActorState();
		static_cast<StoreTenantInDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t && lastTenantId,int loopDepth) 
	{
															#line 314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (lastTenantId < self->tenantEntry.id)
															#line 2971 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 315 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			TenantMetadata::lastTenantId().set(tr, self->tenantEntry.id);
															#line 2975 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 320 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!dataClusterTenant.first.present())
															#line 2979 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Tenant creation encountered tombstone");
															#line 322 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 2985 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 325 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<StoreTenantInDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StoreTenantInDataClusterActorState(); static_cast<StoreTenantInDataClusterActor*>(this)->destroy(); return 0; }
															#line 2989 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<StoreTenantInDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StoreTenantInDataClusterActorState();
		static_cast<StoreTenantInDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& lastTenantId,int loopDepth) 
	{
		loopDepth = a_body1cont2(lastTenantId, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && lastTenantId,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(lastTenantId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StoreTenantInDataClusterActor*>(this)->actor_wait_state > 0) static_cast<StoreTenantInDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<StoreTenantInDataClusterActor*>(this)->ActorCallback< StoreTenantInDataClusterActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< StoreTenantInDataClusterActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StoreTenantInDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StoreTenantInDataClusterActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StoreTenantInDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StoreTenantInDataClusterActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StoreTenantInDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CreateTenantImpl* self;
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Reference<ITransaction> tr;
															#line 309 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Future<int64_t> lastTenantIdFuture;
															#line 310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	std::pair<Optional<TenantMapEntry>, bool> dataClusterTenant;
															#line 3080 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
};
// This generated class is to be used only via storeTenantInDataCluster()
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class StoreTenantInDataClusterActor final : public Actor<Void>, public ActorCallback< StoreTenantInDataClusterActor, 0, std::pair<Optional<TenantMapEntry>, bool> >, public ActorCallback< StoreTenantInDataClusterActor, 1, int64_t >, public FastAllocated<StoreTenantInDataClusterActor>, public StoreTenantInDataClusterActorState<StoreTenantInDataClusterActor> {
															#line 3085 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
	using FastAllocated<StoreTenantInDataClusterActor>::operator new;
	using FastAllocated<StoreTenantInDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17659867266506565632UL, 17110167093664393472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StoreTenantInDataClusterActor, 0, std::pair<Optional<TenantMapEntry>, bool> >;
friend struct ActorCallback< StoreTenantInDataClusterActor, 1, int64_t >;
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	StoreTenantInDataClusterActor(CreateTenantImpl* const& self,Reference<ITransaction> const& tr) 
															#line 3103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		 : Actor<Void>(),
		   StoreTenantInDataClusterActorState<StoreTenantInDataClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3548311887629199872UL, 294102778119770368UL);
		ActorExecutionContextHelper __helper(static_cast<StoreTenantInDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storeTenantInDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storeTenantInDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StoreTenantInDataClusterActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StoreTenantInDataClusterActor, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
[[nodiscard]] static Future<Void> storeTenantInDataCluster( CreateTenantImpl* const& self, Reference<ITransaction> const& tr ) {
															#line 308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	return Future<Void>(new StoreTenantInDataClusterActor(self, tr));
															#line 3136 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
}

#line 327 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"

																#line 3141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
// This generated class is to be used only via markTenantReady()
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class MarkTenantReadyActor>
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class MarkTenantReadyActorState {
															#line 3147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	MarkTenantReadyActorState(CreateTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		 : self(self),
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   tr(tr)
															#line 3156 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
	{
		fdb_probe_actor_create("markTenantReady", reinterpret_cast<unsigned long>(this));

	}
	~MarkTenantReadyActorState() 
	{
		fdb_probe_actor_destroy("markTenantReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, self->tenantEntry.id);
															#line 329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<MarkTenantReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkTenantReadyActor*>(this)->actor_wait_state = 1;
															#line 329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkTenantReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<MarkTenantReadyActor*>(this)));
															#line 3178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkTenantReadyActorState();
		static_cast<MarkTenantReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 331 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!managementEntry.present())
															#line 3201 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 332 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Tenant removed during creation");
															#line 333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			return a_body1Catch1(tenant_removed(), loopDepth);
															#line 3207 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 336 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (managementEntry.get().tenantState == TenantState::REGISTERING)
															#line 3211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		{
															#line 337 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			MetaclusterTenantMapEntry updatedEntry = managementEntry.get();
															#line 338 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			updatedEntry.tenantState = TenantState::READY;
															#line 339 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			metadata::management::tenantMetadata().tenantMap.set(tr, updatedEntry.id, updatedEntry);
															#line 340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 3221 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
		else
		{
															#line 342 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			CODE_PROBE(true, "Tenant creation already completed");
															#line 3227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		}
															#line 345 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<MarkTenantReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantReadyActorState(); static_cast<MarkTenantReadyActor*>(this)->destroy(); return 0; }
															#line 3231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<MarkTenantReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkTenantReadyActorState();
		static_cast<MarkTenantReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& __managementEntry,int loopDepth) 
	{
															#line 329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		managementEntry = __managementEntry;
															#line 3243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && __managementEntry,int loopDepth) 
	{
		managementEntry = std::move(__managementEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkTenantReadyActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantReadyActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantReadyActor*>(this)->ActorCallback< MarkTenantReadyActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("markTenantReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkTenantReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("markTenantReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkTenantReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CreateTenantImpl* self;
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Optional<MetaclusterTenantMapEntry> managementEntry;
															#line 3324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
};
// This generated class is to be used only via markTenantReady()
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class MarkTenantReadyActor final : public Actor<Void>, public ActorCallback< MarkTenantReadyActor, 0, Optional<MetaclusterTenantMapEntry> >, public FastAllocated<MarkTenantReadyActor>, public MarkTenantReadyActorState<MarkTenantReadyActor> {
															#line 3329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
	using FastAllocated<MarkTenantReadyActor>::operator new;
	using FastAllocated<MarkTenantReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7624523119673554688UL, 16248706587634152192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkTenantReadyActor, 0, Optional<MetaclusterTenantMapEntry> >;
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	MarkTenantReadyActor(CreateTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 3346 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		 : Actor<Void>(),
		   MarkTenantReadyActorState<MarkTenantReadyActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markTenantReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10269281981387491072UL, 53231766993555968UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markTenantReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markTenantReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkTenantReadyActor, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
[[nodiscard]] static Future<Void> markTenantReady( CreateTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	return Future<Void>(new MarkTenantReadyActor(self, tr));
															#line 3378 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
}

#line 347 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"

																#line 3383 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
// This generated class is to be used only via run()
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class RunActor>
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class RunActorState {
															#line 3389 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	RunActorState(CreateTenantImpl* const& self) 
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		 : self(self)
															#line 3396 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 349 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (!self->tenantEntry.assignedCluster.empty() && self->assignClusterAutomatically)
															#line 3411 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 350 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Tenant creation invalid assigned cluster configuration", probe::decoration::rare);
															#line 351 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(invalid_tenant_configuration(), loopDepth);
															#line 3417 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
															#line 353 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (self->assignClusterAutomatically && self->ignoreCapacityLimit)
															#line 3421 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 354 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				TraceEvent("MetaclusterCreateTenantIgnoreCapacityAutoAssign").log();
															#line 355 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Tenant creation ignoring capacity limit with auto-assignment on");
															#line 356 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(invalid_tenant_configuration(), loopDepth);
															#line 3429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
															#line 358 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (self->tenantEntry.tenantName.startsWith("\xff"_sr))
															#line 3433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 359 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				CODE_PROBE(true, "Tenant creation with invalid name");
															#line 360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(invalid_tenant_name(), loopDepth);
															#line 3439 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
															#line 363 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			;
															#line 3443 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 364 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Void> __when_expr_0 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return assignTenantAndStoreInManagementCluster(self, tr); });
															#line 364 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3475 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 364 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 3480 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		self->replaceExistingTenantId = {};
															#line 3489 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		try {
															#line 370 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<Void> __when_expr_1 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return storeTenantInDataCluster(self, tr); });
															#line 370 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3495 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 370 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 3500 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		self->replaceExistingTenantId = {};
															#line 3515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		try {
															#line 370 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<Void> __when_expr_1 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return storeTenantInDataCluster(self, tr); });
															#line 370 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3521 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 370 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 3526 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 378 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (e.code() == error_code_tenant_creation_permanently_failed)
															#line 3623 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			{
															#line 381 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				self->replaceExistingTenantId = self->tenantEntry.id;
															#line 382 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				self->ctx.clearCluster();
															#line 3629 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
			else
			{
															#line 384 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3635 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Void> __when_expr_2 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return markTenantReady(self, tr); });
															#line 373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3653 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 3658 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		StrictFuture<Void> __when_expr_2 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return markTenantReady(self, tr); });
															#line 373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3669 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 3674 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 376 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 3758 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 376 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 3770 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CreateTenantImpl* self;
															#line 3855 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
};
// This generated class is to be used only via run()
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorCallback< RunActor, 1, Void >, public ActorCallback< RunActor, 2, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 3860 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8256395892339635968UL, 8287120884186406400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorCallback< RunActor, 1, Void >;
friend struct ActorCallback< RunActor, 2, Void >;
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	RunActor(CreateTenantImpl* const& self) 
															#line 3879 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
[[nodiscard]] static Future<Void> run( CreateTenantImpl* const& self ) {
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	return Future<Void>(new RunActor(self));
															#line 3913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
}

#line 389 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Future<Void> run() { return run(this); }
};
} // namespace internal

															#line 3921 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
// This generated class is to be used only via createTenant()
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class DB, class CreateTenantActor>
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class CreateTenantActorState {
															#line 3927 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CreateTenantActorState(Reference<DB> const& db,MetaclusterTenantMapEntry const& tenantEntry,AssignClusterAutomatically const& assignClusterAutomatically,IgnoreCapacityLimit const& ignoreCapacityLimit) 
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		 : db(db),
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   tenantEntry(tenantEntry),
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   assignClusterAutomatically(assignClusterAutomatically),
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   ignoreCapacityLimit(ignoreCapacityLimit),
															#line 398 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		   impl(db, tenantEntry, assignClusterAutomatically, ignoreCapacityLimit)
															#line 3942 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
	{
		fdb_probe_actor_create("createTenant", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantActorState() 
	{
		fdb_probe_actor_destroy("createTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 399 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 399 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3959 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 1;
															#line 399 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 0, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 3964 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 3987 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
		if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 3999 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	Reference<DB> db;
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	MetaclusterTenantMapEntry tenantEntry;
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	AssignClusterAutomatically assignClusterAutomatically;
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	IgnoreCapacityLimit ignoreCapacityLimit;
															#line 398 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	internal::CreateTenantImpl<DB> impl;
															#line 4092 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
};
// This generated class is to be used only via createTenant()
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class DB>
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
class CreateTenantActor final : public Actor<Void>, public ActorCallback< CreateTenantActor<DB>, 0, Void >, public FastAllocated<CreateTenantActor<DB>>, public CreateTenantActorState<DB, CreateTenantActor<DB>> {
															#line 4099 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
public:
	using FastAllocated<CreateTenantActor<DB>>::operator new;
	using FastAllocated<CreateTenantActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(974892640485496320UL, 14988927469516425216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantActor<DB>, 0, Void >;
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	CreateTenantActor(Reference<DB> const& db,MetaclusterTenantMapEntry const& tenantEntry,AssignClusterAutomatically const& assignClusterAutomatically,IgnoreCapacityLimit const& ignoreCapacityLimit) 
															#line 4116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
		 : Actor<Void>(),
		   CreateTenantActorState<DB, CreateTenantActor<DB>>(db, tenantEntry, assignClusterAutomatically, ignoreCapacityLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2480746510970185984UL, 428737674404862208UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
template <class DB>
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
[[nodiscard]] Future<Void> createTenant( Reference<DB> const& db, MetaclusterTenantMapEntry const& tenantEntry, AssignClusterAutomatically const& assignClusterAutomatically, IgnoreCapacityLimit const& ignoreCapacityLimit ) {
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"
	return Future<Void>(new CreateTenantActor<DB>(db, tenantEntry, assignClusterAutomatically, ignoreCapacityLimit));
															#line 4150 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/CreateTenant.actor.g.h"
}

#line 402 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/metacluster/include/metacluster/CreateTenant.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif