#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
/*
 * PerpetualWiggleStatsWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/DDTeamCollection.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/DDSharedContext.h"
#include "fdbserver/DDTxnProcessor.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/VersionedMap.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// just compare the int part and smoothed duration is enough for the test.
bool storageWiggleStatsEqual(StorageWiggleMetrics const& a, StorageWiggleMetrics const& b) {

	bool res = a.finished_wiggle == b.finished_wiggle && a.finished_round == b.finished_round &&
	           std::abs(a.smoothed_wiggle_duration.getTotal() - b.smoothed_wiggle_duration.getTotal()) < 0.0001 &&
	           std::abs(a.smoothed_round_duration.getTotal() - b.smoothed_round_duration.getTotal()) < 0.0001;
	if (!res) {
		std::cout << a.finished_wiggle << " | " << b.finished_wiggle << "\n";
		std::cout << a.finished_round << " | " << b.finished_round << "\n";
		std::cout << a.smoothed_wiggle_duration.getTotal() << " | " << b.smoothed_wiggle_duration.getTotal() << "\n";
		std::cout << a.smoothed_round_duration.getTotal() << " | " << b.smoothed_round_duration.getTotal() << "\n";
	}
	return res;
}

namespace {
															#line 51 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
// This generated class is to be used only via IssueConfigurationChange()
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
template <class IssueConfigurationChangeActor>
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class IssueConfigurationChangeActorState {
															#line 57 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	IssueConfigurationChangeActorState(Database const& cx,std::string const& config,bool const& force) 
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		 : cx(cx),
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   config(config),
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   force(force)
															#line 68 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("IssueConfigurationChange", reinterpret_cast<unsigned long>(this));

	}
	~IssueConfigurationChangeActorState() 
	{
		fdb_probe_actor_destroy("IssueConfigurationChange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 50 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			printf("Issuing configuration change: %s\n", config.c_str());
															#line 51 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<ConfigurationResult> __when_expr_0 = ManagementAPI::changeConfig(cx.getReference(), config, force);
															#line 51 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 87 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state = 1;
															#line 51 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*>(static_cast<IssueConfigurationChangeActor*>(this)));
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IssueConfigurationChangeActorState();
		static_cast<IssueConfigurationChangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (res != ConfigurationResult::SUCCESS)
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 53 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<IssueConfigurationChangeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IssueConfigurationChangeActorState(); static_cast<IssueConfigurationChangeActor*>(this)->destroy(); return 0; }
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<IssueConfigurationChangeActor*>(this)->SAV< bool >::value()) bool(false);
			this->~IssueConfigurationChangeActorState();
			static_cast<IssueConfigurationChangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 129 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state = 2;
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IssueConfigurationChangeActor, 1, Void >*>(static_cast<IssueConfigurationChangeActor*>(this)));
															#line 134 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ConfigurationResult const& __res,int loopDepth) 
	{
															#line 51 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		res = __res;
															#line 143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ConfigurationResult && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state > 0) static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state = 0;
		static_cast<IssueConfigurationChangeActor*>(this)->ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >::remove();

	}
	void a_callback_fire(ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*,ConfigurationResult const& value) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*,ConfigurationResult && value) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*,Error err) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 56 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<IssueConfigurationChangeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IssueConfigurationChangeActorState(); static_cast<IssueConfigurationChangeActor*>(this)->destroy(); return 0; }
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<IssueConfigurationChangeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IssueConfigurationChangeActorState();
		static_cast<IssueConfigurationChangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 56 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<IssueConfigurationChangeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IssueConfigurationChangeActorState(); static_cast<IssueConfigurationChangeActor*>(this)->destroy(); return 0; }
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<IssueConfigurationChangeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IssueConfigurationChangeActorState();
		static_cast<IssueConfigurationChangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state > 0) static_cast<IssueConfigurationChangeActor*>(this)->actor_wait_state = 0;
		static_cast<IssueConfigurationChangeActor*>(this)->ActorCallback< IssueConfigurationChangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IssueConfigurationChangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IssueConfigurationChangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IssueConfigurationChangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	Database cx;
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	std::string config;
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	bool force;
															#line 51 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	ConfigurationResult res;
															#line 325 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
};
// This generated class is to be used only via IssueConfigurationChange()
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class IssueConfigurationChangeActor final : public Actor<bool>, public ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >, public ActorCallback< IssueConfigurationChangeActor, 1, Void >, public FastAllocated<IssueConfigurationChangeActor>, public IssueConfigurationChangeActorState<IssueConfigurationChangeActor> {
															#line 330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
	using FastAllocated<IssueConfigurationChangeActor>::operator new;
	using FastAllocated<IssueConfigurationChangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13310843238842750208UL, 2094630809025172480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >;
friend struct ActorCallback< IssueConfigurationChangeActor, 1, Void >;
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	IssueConfigurationChangeActor(Database const& cx,std::string const& config,bool const& force) 
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   IssueConfigurationChangeActorState<IssueConfigurationChangeActor>(cx, config, force),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14752238108969034496UL, 12341728471573534720UL);
		ActorExecutionContextHelper __helper(static_cast<IssueConfigurationChangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("IssueConfigurationChange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("IssueConfigurationChange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IssueConfigurationChangeActor, 0, ConfigurationResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IssueConfigurationChangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
[[nodiscard]] Future<bool> IssueConfigurationChange( Database const& cx, std::string const& config, bool const& force ) {
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	return Future<bool>(new IssueConfigurationChangeActor(cx, config, force));
															#line 381 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
}

#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
} // namespace

// a wrapper for test protected method
struct DDTeamCollectionTester : public DDTeamCollection {
	ActorCollection actors;
	void resetStorageWiggleState() {
		wigglingId.reset();
		storageWiggler = makeReference<StorageWiggler>(this);
	}
																#line 394 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
// This generated class is to be used only via testRestoreAndResetStats()
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
template <class TestRestoreAndResetStatsActor>
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class TestRestoreAndResetStatsActorState {
															#line 400 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	TestRestoreAndResetStatsActorState(DDTeamCollectionTester* const& self,StorageWiggleMetrics const& metrics) 
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		 : self(self),
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   metrics(metrics)
															#line 409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this));

	}
	~TestRestoreAndResetStatsActorState() 
	{
		fdb_probe_actor_destroy("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			std::cout << "testRestoreAndResetStats ...\n";
															#line 69 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->storageWiggler->restoreStats();
															#line 69 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 428 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state = 1;
															#line 69 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestRestoreAndResetStatsActor, 0, Void >*>(static_cast<TestRestoreAndResetStatsActor*>(this)));
															#line 433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestRestoreAndResetStatsActorState();
		static_cast<TestRestoreAndResetStatsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 456 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_1 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=0", deterministicRandom()->coinflip());
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 462 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestoreAndResetStatsActor, 1, bool >*>(static_cast<TestRestoreAndResetStatsActor*>(this)));
															#line 467 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 477 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_1 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=0", deterministicRandom()->coinflip());
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 483 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestoreAndResetStatsActor, 1, bool >*>(static_cast<TestRestoreAndResetStatsActor*>(this)));
															#line 488 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state > 0) static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestoreAndResetStatsActor*>(this)->ActorCallback< TestRestoreAndResetStatsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestoreAndResetStatsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestRestoreAndResetStatsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestRestoreAndResetStatsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 80 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		metrics.reset();
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->storageWiggler->restoreStats();
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 577 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state = 3;
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestoreAndResetStatsActor, 2, Void >*>(static_cast<TestRestoreAndResetStatsActor*>(this)));
															#line 582 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& success,int loopDepth) 
	{
															#line 75 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 591 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 76 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<TestRestoreAndResetStatsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestoreAndResetStatsActorState(); static_cast<TestRestoreAndResetStatsActor*>(this)->destroy(); return 0; }
															#line 595 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<TestRestoreAndResetStatsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestRestoreAndResetStatsActorState();
			static_cast<TestRestoreAndResetStatsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && success,int loopDepth) 
	{
															#line 75 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 609 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 76 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<TestRestoreAndResetStatsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestoreAndResetStatsActorState(); static_cast<TestRestoreAndResetStatsActor*>(this)->destroy(); return 0; }
															#line 613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<TestRestoreAndResetStatsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestRestoreAndResetStatsActorState();
			static_cast<TestRestoreAndResetStatsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont3(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state > 0) static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestoreAndResetStatsActor*>(this)->ActorCallback< TestRestoreAndResetStatsActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestoreAndResetStatsActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestRestoreAndResetStatsActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestRestoreAndResetStatsActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 83 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<TestRestoreAndResetStatsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestoreAndResetStatsActorState(); static_cast<TestRestoreAndResetStatsActor*>(this)->destroy(); return 0; }
															#line 704 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<TestRestoreAndResetStatsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestoreAndResetStatsActorState();
		static_cast<TestRestoreAndResetStatsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 83 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<TestRestoreAndResetStatsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestoreAndResetStatsActorState(); static_cast<TestRestoreAndResetStatsActor*>(this)->destroy(); return 0; }
															#line 718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<TestRestoreAndResetStatsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestoreAndResetStatsActorState();
		static_cast<TestRestoreAndResetStatsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state > 0) static_cast<TestRestoreAndResetStatsActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestoreAndResetStatsActor*>(this)->ActorCallback< TestRestoreAndResetStatsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestoreAndResetStatsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestRestoreAndResetStatsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestRestoreAndResetStatsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	DDTeamCollectionTester* self;
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	StorageWiggleMetrics metrics;
															#line 805 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
};
// This generated class is to be used only via testRestoreAndResetStats()
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class TestRestoreAndResetStatsActor final : public Actor<Void>, public ActorCallback< TestRestoreAndResetStatsActor, 0, Void >, public ActorCallback< TestRestoreAndResetStatsActor, 1, bool >, public ActorCallback< TestRestoreAndResetStatsActor, 2, Void >, public FastAllocated<TestRestoreAndResetStatsActor>, public TestRestoreAndResetStatsActorState<TestRestoreAndResetStatsActor> {
															#line 810 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
	using FastAllocated<TestRestoreAndResetStatsActor>::operator new;
	using FastAllocated<TestRestoreAndResetStatsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6200425954016535552UL, 14814837783723200768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestRestoreAndResetStatsActor, 0, Void >;
friend struct ActorCallback< TestRestoreAndResetStatsActor, 1, bool >;
friend struct ActorCallback< TestRestoreAndResetStatsActor, 2, Void >;
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	TestRestoreAndResetStatsActor(DDTeamCollectionTester* const& self,StorageWiggleMetrics const& metrics) 
															#line 829 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TestRestoreAndResetStatsActorState<TestRestoreAndResetStatsActor>(self, metrics),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2361741851648011520UL, 7218257982843946240UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestoreAndResetStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testRestoreAndResetStats");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testRestoreAndResetStats", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestRestoreAndResetStatsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestRestoreAndResetStatsActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestRestoreAndResetStatsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
[[nodiscard]] static Future<Void> testRestoreAndResetStats( DDTeamCollectionTester* const& self, StorageWiggleMetrics const& metrics ) {
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	return Future<Void>(new TestRestoreAndResetStatsActor(self, metrics));
															#line 863 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
}

#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"

																#line 868 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
// This generated class is to be used only via switchPerpetualWiggleWhenDDIsDead()
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
template <class SwitchPerpetualWiggleWhenDDIsDeadActor>
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class SwitchPerpetualWiggleWhenDDIsDeadActorState {
															#line 874 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	SwitchPerpetualWiggleWhenDDIsDeadActorState(DDTeamCollectionTester* const& self,StorageWiggleMetrics const& metrics) 
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		 : self(self),
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   metrics(metrics)
															#line 883 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this));

	}
	~SwitchPerpetualWiggleWhenDDIsDeadActorState() 
	{
		fdb_probe_actor_destroy("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			std::cout << "switchPerpetualWiggleWhenDDIsDead ...\n";
															#line 89 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->storageWiggler->restoreStats();
															#line 89 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 1;
															#line 89 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 0, Void >*>(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)));
															#line 907 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SwitchPerpetualWiggleWhenDDIsDeadActorState();
		static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 90 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 930 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_1 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=0", deterministicRandom()->coinflip());
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 936 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 2;
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >*>(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)));
															#line 941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 90 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 951 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_1 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=0", deterministicRandom()->coinflip());
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 957 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 2;
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >*>(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)));
															#line 962 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state > 0) static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
		{
															#line 100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_2 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=1", deterministicRandom()->coinflip());
															#line 100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1050 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 3;
															#line 100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 2, bool >*>(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)));
															#line 1055 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont3(bool const& success,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 1065 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 96 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchPerpetualWiggleWhenDDIsDeadActorState(); static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->destroy(); return 0; }
															#line 1069 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SwitchPerpetualWiggleWhenDDIsDeadActorState();
			static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && success,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 1083 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 96 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchPerpetualWiggleWhenDDIsDeadActorState(); static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->destroy(); return 0; }
															#line 1087 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SwitchPerpetualWiggleWhenDDIsDeadActorState();
			static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont3(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state > 0) static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->storageWiggler->restoreStats();
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 4;
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 3, Void >*>(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)));
															#line 1183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(bool const& success,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 1192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchPerpetualWiggleWhenDDIsDeadActorState(); static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->destroy(); return 0; }
															#line 1196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SwitchPerpetualWiggleWhenDDIsDeadActorState();
			static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(bool && success,int loopDepth) 
	{
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 1210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchPerpetualWiggleWhenDDIsDeadActorState(); static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->destroy(); return 0; }
															#line 1214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SwitchPerpetualWiggleWhenDDIsDeadActorState();
			static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont7(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state > 0) static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		metrics.reset();
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchPerpetualWiggleWhenDDIsDeadActorState(); static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->destroy(); return 0; }
															#line 1307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchPerpetualWiggleWhenDDIsDeadActorState();
		static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		metrics.reset();
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchPerpetualWiggleWhenDDIsDeadActorState(); static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->destroy(); return 0; }
															#line 1323 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchPerpetualWiggleWhenDDIsDeadActorState();
		static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state > 0) static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	DDTeamCollectionTester* self;
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	StorageWiggleMetrics metrics;
															#line 1410 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
};
// This generated class is to be used only via switchPerpetualWiggleWhenDDIsDead()
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class SwitchPerpetualWiggleWhenDDIsDeadActor final : public Actor<Void>, public ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 0, Void >, public ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >, public ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 2, bool >, public ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 3, Void >, public FastAllocated<SwitchPerpetualWiggleWhenDDIsDeadActor>, public SwitchPerpetualWiggleWhenDDIsDeadActorState<SwitchPerpetualWiggleWhenDDIsDeadActor> {
															#line 1415 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
	using FastAllocated<SwitchPerpetualWiggleWhenDDIsDeadActor>::operator new;
	using FastAllocated<SwitchPerpetualWiggleWhenDDIsDeadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9051253519945210880UL, 2550044427446525952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 0, Void >;
friend struct ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >;
friend struct ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 2, bool >;
friend struct ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 3, Void >;
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	SwitchPerpetualWiggleWhenDDIsDeadActor(DDTeamCollectionTester* const& self,StorageWiggleMetrics const& metrics) 
															#line 1435 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   SwitchPerpetualWiggleWhenDDIsDeadActorState<SwitchPerpetualWiggleWhenDDIsDeadActor>(self, metrics),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13188056072032427520UL, 16503471811738542592UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchPerpetualWiggleWhenDDIsDeadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("switchPerpetualWiggleWhenDDIsDead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("switchPerpetualWiggleWhenDDIsDead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SwitchPerpetualWiggleWhenDDIsDeadActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
[[nodiscard]] static Future<Void> switchPerpetualWiggleWhenDDIsDead( DDTeamCollectionTester* const& self, StorageWiggleMetrics const& metrics ) {
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	return Future<Void>(new SwitchPerpetualWiggleWhenDDIsDeadActor(self, metrics));
															#line 1470 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
}

#line 111 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"

	// reset stats shouldn't be overwritten when PW is disabled
																#line 1476 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
// This generated class is to be used only via finishWiggleAfterPWDisabled()
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
template <class FinishWiggleAfterPWDisabledActor>
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class FinishWiggleAfterPWDisabledActorState {
															#line 1482 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	FinishWiggleAfterPWDisabledActorState(DDTeamCollectionTester* const& self,StorageWiggleMetrics const& metrics) 
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		 : self(self),
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   metrics(metrics)
															#line 1491 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this));

	}
	~FinishWiggleAfterPWDisabledActorState() 
	{
		fdb_probe_actor_destroy("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			std::cout << "finishWiggleAfterPWDisabled ...\n";
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->storageWiggler->restoreStats();
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1510 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 1;
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishWiggleAfterPWDisabledActor, 0, Void >*>(static_cast<FinishWiggleAfterPWDisabledActor*>(this)));
															#line 1515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishWiggleAfterPWDisabledActorState();
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 1538 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_1 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=0", deterministicRandom()->coinflip());
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1544 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 2;
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >*>(static_cast<FinishWiggleAfterPWDisabledActor*>(this)));
															#line 1549 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 1559 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_1 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=0", deterministicRandom()->coinflip());
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1565 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 2;
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >*>(static_cast<FinishWiggleAfterPWDisabledActor*>(this)));
															#line 1570 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state > 0) static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 0;
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->ActorCallback< FinishWiggleAfterPWDisabledActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishWiggleAfterPWDisabledActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->storageWiggler->finishWiggle();
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1657 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 3;
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishWiggleAfterPWDisabledActor, 2, Void >*>(static_cast<FinishWiggleAfterPWDisabledActor*>(this)));
															#line 1662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& success,int loopDepth) 
	{
															#line 121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 1671 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 122 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishWiggleAfterPWDisabledActorState(); static_cast<FinishWiggleAfterPWDisabledActor*>(this)->destroy(); return 0; }
															#line 1675 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FinishWiggleAfterPWDisabledActorState();
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && success,int loopDepth) 
	{
															#line 121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 1689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 122 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishWiggleAfterPWDisabledActorState(); static_cast<FinishWiggleAfterPWDisabledActor*>(this)->destroy(); return 0; }
															#line 1693 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FinishWiggleAfterPWDisabledActorState();
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont3(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state > 0) static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 0;
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		{
															#line 128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_3 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=1", deterministicRandom()->coinflip());
															#line 128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1785 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 4;
															#line 128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >*>(static_cast<FinishWiggleAfterPWDisabledActor*>(this)));
															#line 1790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		{
															#line 128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_3 = IssueConfigurationChange( self->dbContext(), "perpetual_storage_wiggle=1", deterministicRandom()->coinflip());
															#line 128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1803 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 4;
															#line 128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >*>(static_cast<FinishWiggleAfterPWDisabledActor*>(this)));
															#line 1808 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state > 0) static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 0;
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->ActorCallback< FinishWiggleAfterPWDisabledActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishWiggleAfterPWDisabledActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->storageWiggler->restoreStats();
															#line 133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1895 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 5;
															#line 133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishWiggleAfterPWDisabledActor, 4, Void >*>(static_cast<FinishWiggleAfterPWDisabledActor*>(this)));
															#line 1900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(bool const& success,int loopDepth) 
	{
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 1909 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishWiggleAfterPWDisabledActorState(); static_cast<FinishWiggleAfterPWDisabledActor*>(this)->destroy(); return 0; }
															#line 1913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FinishWiggleAfterPWDisabledActorState();
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(bool && success,int loopDepth) 
	{
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!success)
															#line 1927 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		{
															#line 131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (!static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishWiggleAfterPWDisabledActorState(); static_cast<FinishWiggleAfterPWDisabledActor*>(this)->destroy(); return 0; }
															#line 1931 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			new (&static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FinishWiggleAfterPWDisabledActorState();
			static_cast<FinishWiggleAfterPWDisabledActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont8(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state > 0) static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 0;
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		metrics.reset();
															#line 135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 136 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishWiggleAfterPWDisabledActorState(); static_cast<FinishWiggleAfterPWDisabledActor*>(this)->destroy(); return 0; }
															#line 2024 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishWiggleAfterPWDisabledActorState();
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		metrics.reset();
															#line 135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(storageWiggleStatsEqual(self->storageWiggler->metrics, metrics));
															#line 136 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FinishWiggleAfterPWDisabledActorState(); static_cast<FinishWiggleAfterPWDisabledActor*>(this)->destroy(); return 0; }
															#line 2040 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<FinishWiggleAfterPWDisabledActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FinishWiggleAfterPWDisabledActorState();
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state > 0) static_cast<FinishWiggleAfterPWDisabledActor*>(this)->actor_wait_state = 0;
		static_cast<FinishWiggleAfterPWDisabledActor*>(this)->ActorCallback< FinishWiggleAfterPWDisabledActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FinishWiggleAfterPWDisabledActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FinishWiggleAfterPWDisabledActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	DDTeamCollectionTester* self;
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	StorageWiggleMetrics metrics;
															#line 2127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
};
// This generated class is to be used only via finishWiggleAfterPWDisabled()
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class FinishWiggleAfterPWDisabledActor final : public Actor<Void>, public ActorCallback< FinishWiggleAfterPWDisabledActor, 0, Void >, public ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >, public ActorCallback< FinishWiggleAfterPWDisabledActor, 2, Void >, public ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >, public ActorCallback< FinishWiggleAfterPWDisabledActor, 4, Void >, public FastAllocated<FinishWiggleAfterPWDisabledActor>, public FinishWiggleAfterPWDisabledActorState<FinishWiggleAfterPWDisabledActor> {
															#line 2132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
	using FastAllocated<FinishWiggleAfterPWDisabledActor>::operator new;
	using FastAllocated<FinishWiggleAfterPWDisabledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6649610245579120640UL, 1118294244502364416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishWiggleAfterPWDisabledActor, 0, Void >;
friend struct ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >;
friend struct ActorCallback< FinishWiggleAfterPWDisabledActor, 2, Void >;
friend struct ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >;
friend struct ActorCallback< FinishWiggleAfterPWDisabledActor, 4, Void >;
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	FinishWiggleAfterPWDisabledActor(DDTeamCollectionTester* const& self,StorageWiggleMetrics const& metrics) 
															#line 2153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   FinishWiggleAfterPWDisabledActorState<FinishWiggleAfterPWDisabledActor>(self, metrics),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14735674012975722240UL, 5363087942649498880UL);
		ActorExecutionContextHelper __helper(static_cast<FinishWiggleAfterPWDisabledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishWiggleAfterPWDisabled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishWiggleAfterPWDisabled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishWiggleAfterPWDisabledActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishWiggleAfterPWDisabledActor, 1, bool >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishWiggleAfterPWDisabledActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinishWiggleAfterPWDisabledActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FinishWiggleAfterPWDisabledActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
[[nodiscard]] static Future<Void> finishWiggleAfterPWDisabled( DDTeamCollectionTester* const& self, StorageWiggleMetrics const& metrics ) {
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	return Future<Void>(new FinishWiggleAfterPWDisabledActor(self, metrics));
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
}

#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"

	DDTeamCollectionTester(DDTeamCollectionInitParams const& params) : DDTeamCollection(params) {}
};

StorageWiggleMetrics getRandomWiggleMetrics() {
	StorageWiggleMetrics res;
	res.smoothed_round_duration.reset(deterministicRandom()->randomUInt32());
	res.smoothed_wiggle_duration.reset(deterministicRandom()->randomUInt32());
	res.finished_round = deterministicRandom()->randomUInt32();
	res.finished_wiggle = deterministicRandom()->randomUInt32();
	return res;
}

struct PerpetualWiggleStatsWorkload : public TestWorkload {

	static constexpr auto NAME = "PerpetualWiggleStatsWorkload";
	StorageWiggleMetrics lastMetrics;

	PerpetualWiggleStatsWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {}

																#line 2213 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
template <class _setupActor>
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class _setupActorState {
															#line 2219 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	_setupActorState(PerpetualWiggleStatsWorkload* const& self,Database const& cx) 
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		 : self(self),
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   cx(cx)
															#line 2228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(setDDMode(cx, 0));
															#line 159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 2250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(takeMoveKeysLock(cx, UID()));
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2275 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 2280 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(takeMoveKeysLock(cx, UID()));
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 2296 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = IssueConfigurationChange(cx, "storage_migration_type=disabled", true);
															#line 161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2382 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, bool >*>(static_cast<_setupActor*>(this)));
															#line 2387 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_2 = IssueConfigurationChange(cx, "storage_migration_type=disabled", true);
															#line 161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2398 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, bool >*>(static_cast<_setupActor*>(this)));
															#line 2403 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(bool const& success,int loopDepth) 
	{
															#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(success);
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(30.0);
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2491 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 2496 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool && success,int loopDepth) 
	{
															#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(success);
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(30.0);
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2509 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 2514 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont3(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 2598 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 2610 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _setupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	PerpetualWiggleStatsWorkload* self;
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	Database cx;
															#line 2697 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, bool >, public ActorCallback< _setupActor, 3, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 2702 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6309498788341748480UL, 14986629794867604736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, bool >;
friend struct ActorCallback< _setupActor, 3, Void >;
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	_setupActor(PerpetualWiggleStatsWorkload* const& self,Database const& cx) 
															#line 2722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _setupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( PerpetualWiggleStatsWorkload* const& self, Database const& cx ) {
															#line 158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 2757 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
}

#line 166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"

																#line 2762 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
// This generated class is to be used only via prepareTestEnv()
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
template <class PrepareTestEnvActor>
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class PrepareTestEnvActorState {
															#line 2768 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	PrepareTestEnvActorState(PerpetualWiggleStatsWorkload* const& self,Database const& cx) 
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		 : self(self),
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   cx(cx)
															#line 2777 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("prepareTestEnv", reinterpret_cast<unsigned long>(this));

	}
	~PrepareTestEnvActorState() 
	{
		fdb_probe_actor_destroy("prepareTestEnv", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = IssueConfigurationChange(cx, "perpetual_storage_wiggle=1", true);
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<PrepareTestEnvActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2794 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrepareTestEnvActor*>(this)->actor_wait_state = 1;
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrepareTestEnvActor, 0, bool >*>(static_cast<PrepareTestEnvActor*>(this)));
															#line 2799 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrepareTestEnvActorState();
		static_cast<PrepareTestEnvActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& change,int loopDepth) 
	{
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(change);
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		self->lastMetrics = getRandomWiggleMetrics();
															#line 173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		auto& lastMetrics = self->lastMetrics;
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(runRYWTransaction(cx, [&lastMetrics](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { StorageWiggleData wiggleData; return wiggleData.updateStorageWiggleMetrics(tr, lastMetrics, PrimaryRegion(true)); }));
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<PrepareTestEnvActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2830 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrepareTestEnvActor*>(this)->actor_wait_state = 2;
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrepareTestEnvActor, 1, Void >*>(static_cast<PrepareTestEnvActor*>(this)));
															#line 2835 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool && change,int loopDepth) 
	{
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		ASSERT(change);
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		self->lastMetrics = getRandomWiggleMetrics();
															#line 173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		auto& lastMetrics = self->lastMetrics;
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(runRYWTransaction(cx, [&lastMetrics](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { StorageWiggleData wiggleData; return wiggleData.updateStorageWiggleMetrics(tr, lastMetrics, PrimaryRegion(true)); }));
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<PrepareTestEnvActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2852 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrepareTestEnvActor*>(this)->actor_wait_state = 2;
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrepareTestEnvActor, 1, Void >*>(static_cast<PrepareTestEnvActor*>(this)));
															#line 2857 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& change,int loopDepth) 
	{
		loopDepth = a_body1cont1(change, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && change,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(change), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrepareTestEnvActor*>(this)->actor_wait_state > 0) static_cast<PrepareTestEnvActor*>(this)->actor_wait_state = 0;
		static_cast<PrepareTestEnvActor*>(this)->ActorCallback< PrepareTestEnvActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< PrepareTestEnvActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("prepareTestEnv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTestEnvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareTestEnv", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrepareTestEnvActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("prepareTestEnv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTestEnvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareTestEnv", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrepareTestEnvActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("prepareTestEnv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTestEnvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareTestEnv", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<PrepareTestEnvActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrepareTestEnvActorState(); static_cast<PrepareTestEnvActor*>(this)->destroy(); return 0; }
															#line 2941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<PrepareTestEnvActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrepareTestEnvActorState();
		static_cast<PrepareTestEnvActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<PrepareTestEnvActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrepareTestEnvActorState(); static_cast<PrepareTestEnvActor*>(this)->destroy(); return 0; }
															#line 2953 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<PrepareTestEnvActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrepareTestEnvActorState();
		static_cast<PrepareTestEnvActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrepareTestEnvActor*>(this)->actor_wait_state > 0) static_cast<PrepareTestEnvActor*>(this)->actor_wait_state = 0;
		static_cast<PrepareTestEnvActor*>(this)->ActorCallback< PrepareTestEnvActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrepareTestEnvActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("prepareTestEnv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTestEnvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareTestEnv", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrepareTestEnvActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("prepareTestEnv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTestEnvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareTestEnv", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrepareTestEnvActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("prepareTestEnv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTestEnvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareTestEnv", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	PerpetualWiggleStatsWorkload* self;
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	Database cx;
															#line 3040 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
};
// This generated class is to be used only via prepareTestEnv()
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class PrepareTestEnvActor final : public Actor<Void>, public ActorCallback< PrepareTestEnvActor, 0, bool >, public ActorCallback< PrepareTestEnvActor, 1, Void >, public FastAllocated<PrepareTestEnvActor>, public PrepareTestEnvActorState<PrepareTestEnvActor> {
															#line 3045 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
	using FastAllocated<PrepareTestEnvActor>::operator new;
	using FastAllocated<PrepareTestEnvActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14860021675106647808UL, 16598695783078663936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrepareTestEnvActor, 0, bool >;
friend struct ActorCallback< PrepareTestEnvActor, 1, Void >;
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	PrepareTestEnvActor(PerpetualWiggleStatsWorkload* const& self,Database const& cx) 
															#line 3063 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   PrepareTestEnvActorState<PrepareTestEnvActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("prepareTestEnv", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16294498044856548608UL, 15812369669922897920UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareTestEnvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("prepareTestEnv");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("prepareTestEnv", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrepareTestEnvActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrepareTestEnvActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
[[nodiscard]] static Future<Void> prepareTestEnv( PerpetualWiggleStatsWorkload* const& self, Database const& cx ) {
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	return Future<Void>(new PrepareTestEnvActor(self, cx));
															#line 3096 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
}

#line 180 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0) {
			return _setup(this, cx); // force to disable DD
		}
		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			return _start(this, cx);
		}
		return Void();
	};

	Future<bool> check(Database const& cx) override { return true; };

																#line 3117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
template <class _startActor>
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class _startActorState {
															#line 3123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	_startActorState(PerpetualWiggleStatsWorkload* const& self,Database const& cx) 
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		 : self(self),
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   cx(cx),
															#line 198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   db(makeReference<DDTxnProcessor>(cx)),
															#line 199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   conf(),
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		   tester({ db, UID(8, 6), MoveKeysLock(), PromiseStream<RelocateShard>(), makeReference<ShardsAffectedByTeamFailure>(), conf, {}, {}, Future<Void>(Void()), makeReference<AsyncVar<bool>>(true), IsPrimary::True, makeReference<AsyncVar<bool>>(false), makeReference<AsyncVar<bool>>(false), PromiseStream<GetMetricsRequest>(), Promise<UID>(), PromiseStream<Promise<int>>(), PromiseStream<Promise<int64_t>>(), PromiseStream<RebalanceStorageQueueRequest>(), makeReference<BulkLoadTaskCollection>(UID(8, 6)) })
															#line 3138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 219 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			tester.configuration.storageTeamSize = 3;
															#line 220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			tester.configuration.perpetualStorageWiggleSpeed = 1;
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = prepareTestEnv(self, cx);
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		tester.resetStorageWiggleState();
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = DDTeamCollectionTester::testRestoreAndResetStats(&tester, self->lastMetrics);
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		tester.resetStorageWiggleState();
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = DDTeamCollectionTester::testRestoreAndResetStats(&tester, self->lastMetrics);
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3209 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = prepareTestEnv(self, cx);
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3300 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 3305 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = prepareTestEnv(self, cx);
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3316 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 3321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		tester.resetStorageWiggleState();
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = DDTeamCollectionTester::switchPerpetualWiggleWhenDDIsDead(&tester, self->lastMetrics);
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3414 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		tester.resetStorageWiggleState();
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = DDTeamCollectionTester::switchPerpetualWiggleWhenDDIsDead(&tester, self->lastMetrics);
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3432 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = prepareTestEnv(self, cx);
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3518 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3523 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = prepareTestEnv(self, cx);
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3534 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		tester.resetStorageWiggleState();
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = DDTeamCollectionTester::finishWiggleAfterPWDisabled(&tester, self->lastMetrics);
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3627 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 3632 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		tester.resetStorageWiggleState();
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = DDTeamCollectionTester::finishWiggleAfterPWDisabled(&tester, self->lastMetrics);
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3645 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 3650 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(setDDMode(cx, 1));
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3736 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 3741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(setDDMode(cx, 1));
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3752 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 3757 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 235 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 235 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3853 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	PerpetualWiggleStatsWorkload* self;
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	Database cx;
															#line 198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	Reference<IDDTxnProcessor> db;
															#line 199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	DatabaseConfiguration conf;
															#line 200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	DDTeamCollectionTester tester;
															#line 3946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3951 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2905890942216502528UL, 5295094851787497472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	_startActor(PerpetualWiggleStatsWorkload* const& self,Database const& cx) 
															#line 3974 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( PerpetualWiggleStatsWorkload* const& self, Database const& cx ) {
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 4012 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.g.cpp"
}

#line 237 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/PerpetualWiggleStatsWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override { return; }
};

WorkloadFactory<PerpetualWiggleStatsWorkload> PerpetualWiggleStatsWorkload;