#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
/*
 * FailoverWithSSLag.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/StatusClient.h"
#include "flow/actorcompiler.h" // This must be the last include.

// This actor tests failover with remote tlogs being in sync with primary but with remote storage servers lagging
// behind the primary. Failover shouldn't complete until the remote storage servers also get in sync with the primary.
struct FailoverWithSSLagWorkload : TestWorkload {
	static constexpr auto NAME = "FailoverWithSSLagWorkload";
	bool enabled;
	double testDuration;
	bool testSuccess;
	std::vector<IPAddress> tlogs; // remote tlogs
	std::vector<IPAddress> storages; // remote storages

	FailoverWithSSLagWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled =
		    !clientId && g_network->isSimulated(); // only do this on the "first" client, and only when in simulation
		testDuration = getOption(options, "testDuration"_sr, 400.0);
		testSuccess = true;
		g_simulator->usableRegions = 2;
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("all"); }

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (enabled) {
			return timeout(reportErrors(clogClient(this, cx), "FailoverWithSSLagError"), testDuration, Void());
		}
		return Void();
	}

	Future<bool> check(Database const& cx) override { return testSuccess; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Clog or unclog (based on argument "clog") connections between remote tlogs ("tlogs") and
	// remote storages ("storages").
	void clogUnclogRemoteStorages(bool clog, double seconds = 0) {
		for (const auto& tlog : tlogs) {
			for (const auto& storage : storages) {
				if (clog) {
					g_simulator->clogPair(tlog, storage, seconds);
					g_simulator->clogPair(storage, tlog, seconds);
				} else {
					g_simulator->unclogPair(tlog, storage);
					g_simulator->unclogPair(storage, tlog);
				}
			}
		}
	}

	// Find remote tlogs and remote storage servers and clog connections between them.
	bool findAndClogRemoteStorages(double seconds) {
		ASSERT(dbInfo->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION);

		// Find all remote tlogs (including remote satellite tlogs).
		for (const auto& tlogset : dbInfo->get().logSystemConfig.tLogs) {
			if (tlogset.isLocal) {
				continue;
			}
			for (const auto& tlog : tlogset.tLogs) {
				tlogs.push_back(tlog.interf().address().ip);
			}
		}

		if (tlogs.empty()) {
			return false;
		}

		// Find all remote storage servers.
		for (const auto& process : g_simulator->getAllProcesses()) {
			if (process->locality.dcId().present() && process->locality.dcId() == g_simulator->remoteDcId &&
			    g_simulator->hasRole(process->address, "StorageServer")) {
				storages.push_back(process->address.ip);
			}
		}

		if (storages.empty()) {
			return false;
		}

		// Clog connections between remote tlogs and storage servers.
		clogUnclogRemoteStorages(true /* clog */, seconds);

		return true;
	}

	// Fetches details (versions and seconds) of the specified type of lag (tlog/storage server/data center lag) from
	// the given status json document.
	bool fetchLagFromStatusObject(std::string path, StatusObjectReader& statusObj, Version& versions, double& seconds) {
		StatusObjectReader lagObject;
		if (!statusObj.get(path, lagObject)) {
			return false;
		}

		if (!lagObject.get("versions", versions)) {
			return false;
		}

		if (!lagObject.get("seconds", seconds)) {
			return false;
		}

		return true;
	}

																#line 140 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
// This generated class is to be used only via fetchStorageServerLag()
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
template <class FetchStorageServerLagActor>
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class FetchStorageServerLagActorState {
															#line 146 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FetchStorageServerLagActorState(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		 : self(self),
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   cx(cx),
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   startTime(now())
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchStorageServerLag", reinterpret_cast<unsigned long>(this));

	}
	~FetchStorageServerLagActorState() 
	{
		fdb_probe_actor_destroy("fetchStorageServerLag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 140 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			StrictFuture<StatusObject> __when_expr_0 = StatusClient::statusFetcher(cx);
															#line 140 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (static_cast<FetchStorageServerLagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchStorageServerLagActor*>(this)->actor_wait_state = 1;
															#line 140 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchStorageServerLagActor, 0, StatusObject >*>(static_cast<FetchStorageServerLagActor*>(this)));
															#line 179 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchStorageServerLagActorState();
		static_cast<FetchStorageServerLagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject const& result,int loopDepth) 
	{
															#line 141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		double duration = now() - startTime;
															#line 143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StatusObjectReader statusObj(result);
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 145 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 146 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("SSLagNoCluster");
															#line 147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
			this->~FetchStorageServerLagActorState();
			static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		Version tlogLagInVersions = 0;
															#line 152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		double tlogLagInSeconds = 0;
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!self->fetchLagFromStatusObject("logserver_lag", statusObjCluster, tlogLagInVersions, tlogLagInSeconds))
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("NoLogServerLagData");
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
			this->~FetchStorageServerLagActorState();
			static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		Version ssLagInVersions = 0;
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		double ssLagInSeconds = 0;
															#line 161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!self->fetchLagFromStatusObject("storageserver_lag", statusObjCluster, ssLagInVersions, ssLagInSeconds))
															#line 244 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("NoStorageServerLagData");
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
			this->~FetchStorageServerLagActorState();
			static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		Version dcLagInVersions = 0;
															#line 168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		double dcLagInSeconds = 0;
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!self->fetchLagFromStatusObject("datacenter_lag", statusObjCluster, dcLagInVersions, dcLagInSeconds))
															#line 262 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("NoDataCenterLagData");
															#line 171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
			this->~FetchStorageServerLagActorState();
			static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		TraceEvent("LagInfo") .detail("LogServerLagInVersions", tlogLagInVersions) .detail("LogServerLagInSeconds", tlogLagInSeconds) .detail("StorageServerLagInVersions", ssLagInVersions) .detail("StorageServerLagInSeconds", ssLagInSeconds) .detail("DataCenterLagInVersions", dcLagInVersions) .detail("DataCenterLagInSeconds", dcLagInSeconds) .detail("TimeToFetchStatus", duration);
															#line 183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(ssLagInVersions); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 278 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(ssLagInVersions);
		this->~FetchStorageServerLagActorState();
		static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(StatusObject && result,int loopDepth) 
	{
															#line 141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		double duration = now() - startTime;
															#line 143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StatusObjectReader statusObj(result);
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StatusObjectReader statusObjCluster;
															#line 145 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!statusObj.get("cluster", statusObjCluster))
															#line 296 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 146 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("SSLagNoCluster");
															#line 147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
			this->~FetchStorageServerLagActorState();
			static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		Version tlogLagInVersions = 0;
															#line 152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		double tlogLagInSeconds = 0;
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!self->fetchLagFromStatusObject("logserver_lag", statusObjCluster, tlogLagInVersions, tlogLagInSeconds))
															#line 314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("NoLogServerLagData");
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 320 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
			this->~FetchStorageServerLagActorState();
			static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		Version ssLagInVersions = 0;
															#line 160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		double ssLagInSeconds = 0;
															#line 161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!self->fetchLagFromStatusObject("storageserver_lag", statusObjCluster, ssLagInVersions, ssLagInSeconds))
															#line 332 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("NoStorageServerLagData");
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 338 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
			this->~FetchStorageServerLagActorState();
			static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		Version dcLagInVersions = 0;
															#line 168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		double dcLagInSeconds = 0;
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!self->fetchLagFromStatusObject("datacenter_lag", statusObjCluster, dcLagInVersions, dcLagInSeconds))
															#line 350 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("NoDataCenterLagData");
															#line 171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 356 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
			this->~FetchStorageServerLagActorState();
			static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		TraceEvent("LagInfo") .detail("LogServerLagInVersions", tlogLagInVersions) .detail("LogServerLagInSeconds", tlogLagInSeconds) .detail("StorageServerLagInVersions", ssLagInVersions) .detail("StorageServerLagInSeconds", ssLagInSeconds) .detail("DataCenterLagInVersions", dcLagInVersions) .detail("DataCenterLagInSeconds", dcLagInSeconds) .detail("TimeToFetchStatus", duration);
															#line 183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!static_cast<FetchStorageServerLagActor*>(this)->SAV<Optional<Version>>::futures) { (void)(ssLagInVersions); this->~FetchStorageServerLagActorState(); static_cast<FetchStorageServerLagActor*>(this)->destroy(); return 0; }
															#line 366 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		new (&static_cast<FetchStorageServerLagActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(ssLagInVersions);
		this->~FetchStorageServerLagActorState();
		static_cast<FetchStorageServerLagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(StatusObject const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(StatusObject && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchStorageServerLagActor*>(this)->actor_wait_state > 0) static_cast<FetchStorageServerLagActor*>(this)->actor_wait_state = 0;
		static_cast<FetchStorageServerLagActor*>(this)->ActorCallback< FetchStorageServerLagActor, 0, StatusObject >::remove();

	}
	void a_callback_fire(ActorCallback< FetchStorageServerLagActor, 0, StatusObject >*,StatusObject const& value) 
	{
		fdb_probe_actor_enter("fetchStorageServerLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchStorageServerLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchStorageServerLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchStorageServerLagActor, 0, StatusObject >*,StatusObject && value) 
	{
		fdb_probe_actor_enter("fetchStorageServerLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchStorageServerLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchStorageServerLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchStorageServerLagActor, 0, StatusObject >*,Error err) 
	{
		fdb_probe_actor_enter("fetchStorageServerLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchStorageServerLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchStorageServerLag", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FailoverWithSSLagWorkload* self;
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	Database cx;
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	double startTime;
															#line 455 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
};
// This generated class is to be used only via fetchStorageServerLag()
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class FetchStorageServerLagActor final : public Actor<Optional<Version>>, public ActorCallback< FetchStorageServerLagActor, 0, StatusObject >, public FastAllocated<FetchStorageServerLagActor>, public FetchStorageServerLagActorState<FetchStorageServerLagActor> {
															#line 460 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
	using FastAllocated<FetchStorageServerLagActor>::operator new;
	using FastAllocated<FetchStorageServerLagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16842639090174379008UL, 2887886018086107136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Version>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchStorageServerLagActor, 0, StatusObject >;
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FetchStorageServerLagActor(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 477 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		 : Actor<Optional<Version>>(),
		   FetchStorageServerLagActorState<FetchStorageServerLagActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchStorageServerLag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1262069470919979520UL, 8730961851764714496UL);
		ActorExecutionContextHelper __helper(static_cast<FetchStorageServerLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchStorageServerLag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchStorageServerLag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchStorageServerLagActor, 0, StatusObject >*)0, actor_cancelled()); break;
		}

	}
};
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
[[nodiscard]] static Future<Optional<Version>> fetchStorageServerLag( FailoverWithSSLagWorkload* const& self, Database const& cx ) {
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	return Future<Optional<Version>>(new FetchStorageServerLagActor(self, cx));
															#line 509 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
}

#line 185 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"

																#line 514 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
// This generated class is to be used only via waitForRemoteDataCenterToLag()
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
template <class WaitForRemoteDataCenterToLagActor>
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class WaitForRemoteDataCenterToLagActorState {
															#line 520 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	WaitForRemoteDataCenterToLagActorState(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		 : self(self),
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   cx(cx),
															#line 187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   ssLag(Never())
															#line 531 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this));

	}
	~WaitForRemoteDataCenterToLagActorState() 
	{
		fdb_probe_actor_destroy("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			;
															#line 546 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForRemoteDataCenterToLagActorState();
		static_cast<WaitForRemoteDataCenterToLagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(5.0);
															#line 188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<WaitForRemoteDataCenterToLagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 578 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_1 = ssLag;
															#line 582 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForRemoteDataCenterToLagActor*>(this)->actor_wait_state = 1;
															#line 189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForRemoteDataCenterToLagActor, 0, Void >*>(static_cast<WaitForRemoteDataCenterToLagActor*>(this)));
															#line 193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForRemoteDataCenterToLagActor, 1, Optional<Version> >*>(static_cast<WaitForRemoteDataCenterToLagActor*>(this)));
															#line 589 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		ssLag = self->fetchStorageServerLag(self, cx);
															#line 604 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		ssLag = self->fetchStorageServerLag(self, cx);
															#line 613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<Version> const& versionLag,int loopDepth) 
	{
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (versionLag.present() && versionLag.get() >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 622 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("SSLag").detail("Versions", versionLag.get());
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<WaitForRemoteDataCenterToLagActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForRemoteDataCenterToLagActorState(); static_cast<WaitForRemoteDataCenterToLagActor*>(this)->destroy(); return 0; }
															#line 628 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<WaitForRemoteDataCenterToLagActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForRemoteDataCenterToLagActorState();
			static_cast<WaitForRemoteDataCenterToLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		ssLag = Never();
															#line 636 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<Version> && versionLag,int loopDepth) 
	{
															#line 194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (versionLag.present() && versionLag.get() >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 645 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("SSLag").detail("Versions", versionLag.get());
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<WaitForRemoteDataCenterToLagActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForRemoteDataCenterToLagActorState(); static_cast<WaitForRemoteDataCenterToLagActor*>(this)->destroy(); return 0; }
															#line 651 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<WaitForRemoteDataCenterToLagActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WaitForRemoteDataCenterToLagActorState();
			static_cast<WaitForRemoteDataCenterToLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		ssLag = Never();
															#line 659 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForRemoteDataCenterToLagActor*>(this)->actor_wait_state > 0) static_cast<WaitForRemoteDataCenterToLagActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForRemoteDataCenterToLagActor*>(this)->ActorCallback< WaitForRemoteDataCenterToLagActor, 0, Void >::remove();
		static_cast<WaitForRemoteDataCenterToLagActor*>(this)->ActorCallback< WaitForRemoteDataCenterToLagActor, 1, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForRemoteDataCenterToLagActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForRemoteDataCenterToLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForRemoteDataCenterToLagActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForRemoteDataCenterToLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForRemoteDataCenterToLagActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForRemoteDataCenterToLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForRemoteDataCenterToLagActor, 1, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForRemoteDataCenterToLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForRemoteDataCenterToLagActor, 1, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForRemoteDataCenterToLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForRemoteDataCenterToLagActor, 1, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForRemoteDataCenterToLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FailoverWithSSLagWorkload* self;
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	Database cx;
															#line 187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	Future<Optional<Version>> ssLag;
															#line 791 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
};
// This generated class is to be used only via waitForRemoteDataCenterToLag()
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class WaitForRemoteDataCenterToLagActor final : public Actor<Void>, public ActorCallback< WaitForRemoteDataCenterToLagActor, 0, Void >, public ActorCallback< WaitForRemoteDataCenterToLagActor, 1, Optional<Version> >, public FastAllocated<WaitForRemoteDataCenterToLagActor>, public WaitForRemoteDataCenterToLagActorState<WaitForRemoteDataCenterToLagActor> {
															#line 796 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
	using FastAllocated<WaitForRemoteDataCenterToLagActor>::operator new;
	using FastAllocated<WaitForRemoteDataCenterToLagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13105689001095459840UL, 8692457232428319488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForRemoteDataCenterToLagActor, 0, Void >;
friend struct ActorCallback< WaitForRemoteDataCenterToLagActor, 1, Optional<Version> >;
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	WaitForRemoteDataCenterToLagActor(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 814 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForRemoteDataCenterToLagActorState<WaitForRemoteDataCenterToLagActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(728507996136233472UL, 13175885968233385216UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForRemoteDataCenterToLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForRemoteDataCenterToLag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForRemoteDataCenterToLag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForRemoteDataCenterToLagActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
[[nodiscard]] static Future<Void> waitForRemoteDataCenterToLag( FailoverWithSSLagWorkload* const& self, Database const& cx ) {
															#line 186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	return Future<Void>(new WaitForRemoteDataCenterToLagActor(self, cx));
															#line 846 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
}

#line 202 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"

																#line 851 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
// This generated class is to be used only via failover()
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
template <class FailoverActor>
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class FailoverActorState {
															#line 857 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FailoverActorState(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		 : self(self),
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   cx(cx)
															#line 866 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
	{
		fdb_probe_actor_create("failover", reinterpret_cast<unsigned long>(this));

	}
	~FailoverActorState() 
	{
		fdb_probe_actor_destroy("failover", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 204 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("FailoverBegin").log();
															#line 206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ManagementAPI::changeConfig(cx.getReference(), g_simulator->disablePrimary, true));
															#line 206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (static_cast<FailoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 885 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FailoverActor*>(this)->actor_wait_state = 1;
															#line 206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FailoverActor, 0, Void >*>(static_cast<FailoverActor*>(this)));
															#line 890 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FailoverActorState();
		static_cast<FailoverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		TraceEvent("Failover_WaitFor_PrimaryDatacenterKey").log();
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForPrimaryDC(cx, "1"_sr);
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<FailoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 917 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FailoverActor*>(this)->actor_wait_state = 2;
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FailoverActor, 1, Void >*>(static_cast<FailoverActor*>(this)));
															#line 922 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		TraceEvent("Failover_WaitFor_PrimaryDatacenterKey").log();
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForPrimaryDC(cx, "1"_sr);
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<FailoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 935 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FailoverActor*>(this)->actor_wait_state = 2;
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FailoverActor, 1, Void >*>(static_cast<FailoverActor*>(this)));
															#line 940 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FailoverActor*>(this)->actor_wait_state > 0) static_cast<FailoverActor*>(this)->actor_wait_state = 0;
		static_cast<FailoverActor*>(this)->ActorCallback< FailoverActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FailoverActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("failover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("failover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FailoverActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("failover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("failover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FailoverActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("failover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("failover", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		TraceEvent("FailoverComplete").log();
															#line 212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!static_cast<FailoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FailoverActorState(); static_cast<FailoverActor*>(this)->destroy(); return 0; }
															#line 1026 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		new (&static_cast<FailoverActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FailoverActorState();
		static_cast<FailoverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		TraceEvent("FailoverComplete").log();
															#line 212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!static_cast<FailoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FailoverActorState(); static_cast<FailoverActor*>(this)->destroy(); return 0; }
															#line 1040 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		new (&static_cast<FailoverActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FailoverActorState();
		static_cast<FailoverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FailoverActor*>(this)->actor_wait_state > 0) static_cast<FailoverActor*>(this)->actor_wait_state = 0;
		static_cast<FailoverActor*>(this)->ActorCallback< FailoverActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FailoverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("failover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("failover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FailoverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("failover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("failover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FailoverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("failover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("failover", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FailoverWithSSLagWorkload* self;
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	Database cx;
															#line 1127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
};
// This generated class is to be used only via failover()
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class FailoverActor final : public Actor<Void>, public ActorCallback< FailoverActor, 0, Void >, public ActorCallback< FailoverActor, 1, Void >, public FastAllocated<FailoverActor>, public FailoverActorState<FailoverActor> {
															#line 1132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
	using FastAllocated<FailoverActor>::operator new;
	using FastAllocated<FailoverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14488180703084871424UL, 11009290830485646080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FailoverActor, 0, Void >;
friend struct ActorCallback< FailoverActor, 1, Void >;
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FailoverActor(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 1150 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		 : Actor<Void>(),
		   FailoverActorState<FailoverActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("failover", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16574332364192656384UL, 4719120886680851200UL);
		ActorExecutionContextHelper __helper(static_cast<FailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("failover");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("failover", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FailoverActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FailoverActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
[[nodiscard]] static Future<Void> failover( FailoverWithSSLagWorkload* const& self, Database const& cx ) {
															#line 203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	return Future<Void>(new FailoverActor(self, cx));
															#line 1183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
}

#line 214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"

																#line 1188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
// This generated class is to be used only via doFailover()
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
template <class DoFailoverActor>
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class DoFailoverActorState {
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	DoFailoverActorState(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		 : self(self),
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   cx(cx),
															#line 216 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   connectionsClogged(true),
															#line 217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   failoverCompleted(false)
															#line 1207 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
	{
		fdb_probe_actor_create("doFailover", reinterpret_cast<unsigned long>(this));

	}
	~DoFailoverActorState() 
	{
		fdb_probe_actor_destroy("doFailover", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 218 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			;
															#line 1222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoFailoverActorState();
		static_cast<DoFailoverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(100.0);
															#line 218 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<DoFailoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1254 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 235 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->failover(self, cx);
															#line 1258 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<DoFailoverActor*>(this)->actor_wait_state = 1;
															#line 223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoFailoverActor, 0, Void >*>(static_cast<DoFailoverActor*>(this)));
															#line 235 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoFailoverActor, 1, Void >*>(static_cast<DoFailoverActor*>(this)));
															#line 1265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (connectionsClogged)
															#line 1280 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 225 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (failoverCompleted)
															#line 1284 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			{
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
				self->testSuccess = false;
															#line 229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
				if (!static_cast<DoFailoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFailoverActorState(); static_cast<DoFailoverActor*>(this)->destroy(); return 0; }
															#line 1290 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
				new (&static_cast<DoFailoverActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DoFailoverActorState();
				static_cast<DoFailoverActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			self->clogUnclogRemoteStorages(false );
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			connectionsClogged = false;
															#line 1300 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (connectionsClogged)
															#line 1310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 225 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (failoverCompleted)
															#line 1314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			{
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
				self->testSuccess = false;
															#line 229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
				if (!static_cast<DoFailoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFailoverActorState(); static_cast<DoFailoverActor*>(this)->destroy(); return 0; }
															#line 1320 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
				new (&static_cast<DoFailoverActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DoFailoverActorState();
				static_cast<DoFailoverActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			self->clogUnclogRemoteStorages(false );
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			connectionsClogged = false;
															#line 1330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 236 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (connectionsClogged)
															#line 1340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			self->testSuccess = false;
															#line 240 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<DoFailoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFailoverActorState(); static_cast<DoFailoverActor*>(this)->destroy(); return 0; }
															#line 1346 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<DoFailoverActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DoFailoverActorState();
			static_cast<DoFailoverActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 242 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		failoverCompleted = true;
															#line 245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		ssLag = self->fetchStorageServerLag(self, cx);
															#line 246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_2 = ssLag;
															#line 246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<DoFailoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoFailoverActor*>(this)->actor_wait_state = 2;
															#line 246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoFailoverActor, 2, Optional<Version> >*>(static_cast<DoFailoverActor*>(this)));
															#line 1365 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 236 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (connectionsClogged)
															#line 1374 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			self->testSuccess = false;
															#line 240 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<DoFailoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFailoverActorState(); static_cast<DoFailoverActor*>(this)->destroy(); return 0; }
															#line 1380 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<DoFailoverActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DoFailoverActorState();
			static_cast<DoFailoverActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 242 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		failoverCompleted = true;
															#line 245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		ssLag = self->fetchStorageServerLag(self, cx);
															#line 246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_2 = ssLag;
															#line 246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<DoFailoverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1394 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoFailoverActor*>(this)->actor_wait_state = 2;
															#line 246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoFailoverActor, 2, Optional<Version> >*>(static_cast<DoFailoverActor*>(this)));
															#line 1399 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoFailoverActor*>(this)->actor_wait_state > 0) static_cast<DoFailoverActor*>(this)->actor_wait_state = 0;
		static_cast<DoFailoverActor*>(this)->ActorCallback< DoFailoverActor, 0, Void >::remove();
		static_cast<DoFailoverActor*>(this)->ActorCallback< DoFailoverActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFailoverActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoFailoverActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoFailoverActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Optional<Version> const& versionLag,int loopDepth) 
	{
															#line 247 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (versionLag.present() && versionLag.get() >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 1472 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 248 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("SSLag").detail("Versions", versionLag.get());
															#line 249 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			self->testSuccess = false;
															#line 1478 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		}
															#line 251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!static_cast<DoFailoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFailoverActorState(); static_cast<DoFailoverActor*>(this)->destroy(); return 0; }
															#line 1482 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		new (&static_cast<DoFailoverActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoFailoverActorState();
		static_cast<DoFailoverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Optional<Version> && versionLag,int loopDepth) 
	{
															#line 247 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (versionLag.present() && versionLag.get() >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 1494 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 248 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			TraceEvent("SSLag").detail("Versions", versionLag.get());
															#line 249 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			self->testSuccess = false;
															#line 1500 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		}
															#line 251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!static_cast<DoFailoverActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFailoverActorState(); static_cast<DoFailoverActor*>(this)->destroy(); return 0; }
															#line 1504 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		new (&static_cast<DoFailoverActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoFailoverActorState();
		static_cast<DoFailoverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Optional<Version> const& versionLag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(versionLag, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Optional<Version> && versionLag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(versionLag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoFailoverActor*>(this)->actor_wait_state > 0) static_cast<DoFailoverActor*>(this)->actor_wait_state = 0;
		static_cast<DoFailoverActor*>(this)->ActorCallback< DoFailoverActor, 2, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< DoFailoverActor, 2, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoFailoverActor, 2, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoFailoverActor, 2, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoFailoverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoFailoverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoFailoverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FailoverWithSSLagWorkload* self;
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	Database cx;
															#line 216 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	bool connectionsClogged;
															#line 217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	bool failoverCompleted;
															#line 245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	Future<Optional<Version>> ssLag;
															#line 1654 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
};
// This generated class is to be used only via doFailover()
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class DoFailoverActor final : public Actor<Void>, public ActorCallback< DoFailoverActor, 0, Void >, public ActorCallback< DoFailoverActor, 1, Void >, public ActorCallback< DoFailoverActor, 2, Optional<Version> >, public FastAllocated<DoFailoverActor>, public DoFailoverActorState<DoFailoverActor> {
															#line 1659 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
	using FastAllocated<DoFailoverActor>::operator new;
	using FastAllocated<DoFailoverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(650828062443696896UL, 2748553750143319808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoFailoverActor, 0, Void >;
friend struct ActorCallback< DoFailoverActor, 1, Void >;
friend struct ActorCallback< DoFailoverActor, 2, Optional<Version> >;
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	DoFailoverActor(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 1678 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		 : Actor<Void>(),
		   DoFailoverActorState<DoFailoverActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doFailover", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17645531699453690112UL, 8500784752093749504UL);
		ActorExecutionContextHelper __helper(static_cast<DoFailoverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doFailover");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doFailover", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoFailoverActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoFailoverActor, 2, Optional<Version> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
[[nodiscard]] static Future<Void> doFailover( FailoverWithSSLagWorkload* const& self, Database const& cx ) {
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	return Future<Void>(new DoFailoverActor(self, cx));
															#line 1711 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
}

#line 255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"

																#line 1716 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
// This generated class is to be used only via clogClient()
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
template <class ClogClientActor>
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class ClogClientActorState {
															#line 1722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	ClogClientActorState(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		 : self(self),
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		   cx(cx)
															#line 1731 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
	{
		fdb_probe_actor_create("clogClient", reinterpret_cast<unsigned long>(this));

	}
	~ClogClientActorState() 
	{
		fdb_probe_actor_destroy("clogClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			;
															#line 1746 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClogClientActorState();
		static_cast<ClogClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 262 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!self->findAndClogRemoteStorages(self->testDuration))
															#line 1769 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
															#line 265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			self->testSuccess = false;
															#line 266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
			if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 1775 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
			new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClogClientActorState();
			static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 270 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->waitForRemoteDataCenterToLag(self, cx);
															#line 270 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1785 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 2;
															#line 270 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 1, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 1790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!(self->dbInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED))
															#line 1806 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 258 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 258 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1814 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 1;
															#line 258 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 0, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 1819 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->doFailover(self, cx);
															#line 274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1930 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 3;
															#line 274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 2, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 1935 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->doFailover(self, cx);
															#line 274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 3;
															#line 274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 2, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 1951 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 2035 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClogClientActorState();
		static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
		if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 2047 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClogClientActorState();
		static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	FailoverWithSSLagWorkload* self;
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	Database cx;
															#line 2134 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
};
// This generated class is to be used only via clogClient()
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
class ClogClientActor final : public Actor<Void>, public ActorCallback< ClogClientActor, 0, Void >, public ActorCallback< ClogClientActor, 1, Void >, public ActorCallback< ClogClientActor, 2, Void >, public FastAllocated<ClogClientActor>, public ClogClientActorState<ClogClientActor> {
															#line 2139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
public:
	using FastAllocated<ClogClientActor>::operator new;
	using FastAllocated<ClogClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8079256500824047104UL, 4157867948255063040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClogClientActor, 0, Void >;
friend struct ActorCallback< ClogClientActor, 1, Void >;
friend struct ActorCallback< ClogClientActor, 2, Void >;
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	ClogClientActor(FailoverWithSSLagWorkload* const& self,Database const& cx) 
															#line 2158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
		 : Actor<Void>(),
		   ClogClientActorState<ClogClientActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6639068557903887104UL, 1016936592221440256UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clogClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClogClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClogClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClogClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
[[nodiscard]] Future<Void> clogClient( FailoverWithSSLagWorkload* const& self, Database const& cx ) {
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
	return Future<Void>(new ClogClientActor(self, cx));
															#line 2192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FailoverWithSSLag.actor.g.cpp"
}

#line 278 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/FailoverWithSSLag.actor.cpp"
};

WorkloadFactory<FailoverWithSSLagWorkload> FailoverWithSSLagWorkloadFactory;
