#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
/*
 * BlobGranuleVerifier.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <map>
#include <utility>
#include <vector>

#include "fmt/format.h"
#include "fdbclient/BlobGranuleReader.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BlobGranuleValidation.actor.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

#define BGV_DEBUG true

/*
 * This workload is designed to verify the correctness of the blob data produced by the blob workers.
 * As a read-only validation workload, it can piggyback off of other write or read/write workloads.
 * To verify the data outside FDB's 5 second MVCC window, it tests time travel reads by doing an initial comparison at
 * the latest read version, and then waiting a period of time to re-read the data from blob.
 * To catch availability issues with the blob worker, it does a request to each granule at the end of the test.
 */
struct BlobGranuleVerifierWorkload : TestWorkload {
	static constexpr auto NAME = "BlobGranuleVerifier";
	bool doSetup;
	double testDuration;
	double timeTravelLimit;
	uint64_t timeTravelBufferSize;
	int threads;
	int64_t errors = 0;
	int64_t mismatches = 0;
	int64_t initialReads = 0;
	int64_t timeTravelReads = 0;
	int64_t timeTravelTooOld = 0;
	int64_t rowsRead = 0;
	int64_t bytesRead = 0;
	int64_t purges = 0;
	std::vector<Future<Void>> clients;
	bool enablePurging;
	bool initAtEnd;
	bool strictPurgeChecking;
	bool doForcePurge;
	bool purgeAtLatest;
	bool clearAndMergeCheck;
	bool granuleSizeCheck;
	bool doForceFlushing;

	DatabaseConfiguration config;

	Reference<BlobConnectionProvider> bstore;
	AsyncVar<Standalone<VectorRef<KeyRangeRef>>> granuleRanges;

	bool startedForcePurge;
	Optional<Key> forcePurgeKey;
	Version forcePurgeVersion;

	std::vector<std::tuple<KeyRange, Version, UID, Future<GranuleFiles>>> purgedDataToCheck;

	Future<Void> summaryClient;
	Future<Void> forceFlushingClient;
	Promise<Void> triggerSummaryComplete;

	BlobGranuleVerifierWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		doSetup = !clientId; // only do this on the "first" client
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		timeTravelLimit = getOption(options, "timeTravelLimit"_sr, testDuration);
		timeTravelBufferSize = getOption(options, "timeTravelBufferSize"_sr, 100000000);
		threads = getOption(options, "threads"_sr, 1);

		enablePurging = getOption(options, "enablePurging"_sr, sharedRandomNumber % 3 == 0);
		sharedRandomNumber /= 3;
		// FIXME: re-enable this! There exist several bugs with purging active granules where a small amount of state
		// won't be cleaned up.
		strictPurgeChecking = getOption(options, "strictPurgeChecking"_sr, false /*sharedRandomNumber % 2 == 0*/);
		sharedRandomNumber /= 2;

		doForcePurge = getOption(options, "doForcePurge"_sr, sharedRandomNumber % 3 == 0);
		sharedRandomNumber /= 3;

		purgeAtLatest = getOption(options, "purgeAtLatest"_sr, sharedRandomNumber % 3 == 0);
		sharedRandomNumber /= 3;

		// randomly some tests write data first and then turn on blob granules later, to test conversion of existing DB
		initAtEnd = getOption(options, "initAtEnd"_sr, sharedRandomNumber % 10 == 0);
		sharedRandomNumber /= 10;
		// FIXME: enable and fix bugs!
		// granuleSizeCheck = initAtEnd;
		granuleSizeCheck = false;

		clearAndMergeCheck = getOption(options, "clearAndMergeCheck"_sr, sharedRandomNumber % 10 == 0);
		sharedRandomNumber /= 10;

		doForceFlushing = getOption(options, "doForceFlushing"_sr, sharedRandomNumber % 4 == 0);
		sharedRandomNumber /= 4;

		// don't do strictPurgeChecking or forcePurge if !enablePurging
		if (!enablePurging) {
			strictPurgeChecking = false;
			doForcePurge = false;
			purgeAtLatest = false;
		} else {
			// don't do force flushing if purging enabled
			doForceFlushing = false;
		}

		if (initAtEnd) {
			doForceFlushing = false;
		}

		if (doForcePurge) {
			purgeAtLatest = false;
		}

		if (purgeAtLatest) {
			strictPurgeChecking = false;
		}

		startedForcePurge = false;

		if (doSetup && BGV_DEBUG) {
			fmt::print("BlobGranuleVerifier starting\n");
			fmt::print("  enablePurging={0}\n", enablePurging);
			fmt::print("  purgeAtLatest={0}\n", purgeAtLatest);
			fmt::print("  strictPurgeChecking={0}\n", strictPurgeChecking);
			fmt::print("  doForcePurge={0}\n", doForcePurge);
			fmt::print("  initAtEnd={0}\n", initAtEnd);
			fmt::print("  clearAndMergeCheck={0}\n", clearAndMergeCheck);
		}

		ASSERT(threads >= 1);
		try {
			bstore = BlobConnectionProvider::newBlobConnectionProvider(SERVER_KNOBS->BG_URL);
		} catch (Error& e) {
			if (BGV_DEBUG) {
				printf("Blob Granule Verifier got backup container init error %s\n", e.name());
			}
			throw e;
		}
	}

	// Sets the whole user keyspace to be blobified
																#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via setUpBlobRange()
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class SetUpBlobRangeActor>
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class SetUpBlobRangeActorState {
															#line 180 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	SetUpBlobRangeActorState(Database const& cx) 
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx)
															#line 187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("setUpBlobRange", reinterpret_cast<unsigned long>(this));

	}
	~SetUpBlobRangeActorState() 
	{
		fdb_probe_actor_destroy("setUpBlobRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(normalKeys);
															#line 173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 204 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state = 1;
															#line 173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetUpBlobRangeActor, 0, bool >*>(static_cast<SetUpBlobRangeActor*>(this)));
															#line 209 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& success,int loopDepth) 
	{
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(success);
															#line 175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<SetUpBlobRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetUpBlobRangeActorState(); static_cast<SetUpBlobRangeActor*>(this)->destroy(); return 0; }
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<SetUpBlobRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && success,int loopDepth) 
	{
															#line 174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(success);
															#line 175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<SetUpBlobRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetUpBlobRangeActorState(); static_cast<SetUpBlobRangeActor*>(this)->destroy(); return 0; }
															#line 248 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<SetUpBlobRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont1(success, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state > 0) static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetUpBlobRangeActor*>(this)->ActorCallback< SetUpBlobRangeActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SetUpBlobRangeActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetUpBlobRangeActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetUpBlobRangeActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via setUpBlobRange()
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class SetUpBlobRangeActor final : public Actor<Void>, public ActorCallback< SetUpBlobRangeActor, 0, bool >, public FastAllocated<SetUpBlobRangeActor>, public SetUpBlobRangeActorState<SetUpBlobRangeActor> {
															#line 338 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<SetUpBlobRangeActor>::operator new;
	using FastAllocated<SetUpBlobRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16026951075761013760UL, 18276770538130912512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetUpBlobRangeActor, 0, bool >;
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	SetUpBlobRangeActor(Database const& cx) 
															#line 355 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   SetUpBlobRangeActorState<SetUpBlobRangeActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4237211082324110336UL, 6312788034730357504UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setUpBlobRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetUpBlobRangeActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> setUpBlobRange( Database const& cx ) {
															#line 172 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new SetUpBlobRangeActor(cx));
															#line 387 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 177 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.emplace("Attrition"); }

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 396 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class _setupActor>
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class _setupActorState {
															#line 402 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	_setupActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self)
															#line 411 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!self->doSetup)
															#line 426 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(0);
															#line 184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 432 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(ManagementAPI::changeConfig(cx.getReference(), "blob_granules_enabled=1", true));
															#line 188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 467 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 472 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 185 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 481 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 185 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 493 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!self->initAtEnd)
															#line 580 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->setUpBlobRange(cx);
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 586 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 591 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!self->initAtEnd)
															#line 605 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->setUpBlobRange(cx);
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 611 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 616 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 804 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 809 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17902803125277868032UL, 17195001357941034752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, Void >;
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	_setupActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 828 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 862 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 867 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via findGranules()
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class FindGranulesActor>
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class FindGranulesActorState {
															#line 873 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	FindGranulesActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self)
															#line 882 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("findGranules", reinterpret_cast<unsigned long>(this));

	}
	~FindGranulesActorState() 
	{
		fdb_probe_actor_destroy("findGranules", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 897 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FindGranulesActorState();
		static_cast<FindGranulesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr = Transaction(cx);
															#line 199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 929 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(deterministicRandom()->random01() * 10.0);
															#line 208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<FindGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 940 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FindGranulesActor*>(this)->actor_wait_state = 3;
															#line 208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FindGranulesActor, 2, Void >*>(static_cast<FindGranulesActor*>(this)));
															#line 945 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 201 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = tr.getBlobGranuleRanges(normalKeys, 1000000);
															#line 201 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<FindGranulesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 964 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FindGranulesActor*>(this)->actor_wait_state = 1;
															#line 201 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<FindGranulesActor*>(this)));
															#line 969 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<FindGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1006 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FindGranulesActor*>(this)->actor_wait_state = 2;
															#line 205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FindGranulesActor, 1, Void >*>(static_cast<FindGranulesActor*>(this)));
															#line 1011 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> const& allGranules,int loopDepth) 
	{
															#line 202 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->granuleRanges.set(allGranules);
															#line 1026 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> && allGranules,int loopDepth) 
	{
															#line 202 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->granuleRanges.set(allGranules);
															#line 1035 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& allGranules,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(allGranules, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && allGranules,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(allGranules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FindGranulesActor*>(this)->actor_wait_state > 0) static_cast<FindGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<FindGranulesActor*>(this)->ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FindGranulesActor*>(this)->actor_wait_state > 0) static_cast<FindGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<FindGranulesActor*>(this)->ActorCallback< FindGranulesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FindGranulesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FindGranulesActor*>(this)->actor_wait_state > 0) static_cast<FindGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<FindGranulesActor*>(this)->ActorCallback< FindGranulesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FindGranulesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FindGranulesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 1295 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via findGranules()
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class FindGranulesActor final : public Actor<Void>, public ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< FindGranulesActor, 1, Void >, public ActorCallback< FindGranulesActor, 2, Void >, public FastAllocated<FindGranulesActor>, public FindGranulesActorState<FindGranulesActor> {
															#line 1300 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<FindGranulesActor>::operator new;
	using FastAllocated<FindGranulesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13989048878480835328UL, 7113140536045318144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< FindGranulesActor, 1, Void >;
friend struct ActorCallback< FindGranulesActor, 2, Void >;
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	FindGranulesActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 1319 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   FindGranulesActorState<FindGranulesActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("findGranules", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8443776748849721088UL, 6603109939541344768UL);
		ActorExecutionContextHelper __helper(static_cast<FindGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("findGranules");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("findGranules", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FindGranulesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FindGranulesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FindGranulesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> findGranules( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new FindGranulesActor(cx, self));
															#line 1353 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	struct OldRead {
		KeyRange range;
		Version v;
		RangeResult oldResult;

		OldRead() {}
		OldRead(KeyRange range, Version v, RangeResult oldResult) : range(range), v(v), oldResult(oldResult) {}
	};

	// TODO refactor more generally
																#line 1368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via loadGranuleMetadataBeforeForcePurge()
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class LoadGranuleMetadataBeforeForcePurgeActor>
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class LoadGranuleMetadataBeforeForcePurgeActorState {
															#line 1374 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	LoadGranuleMetadataBeforeForcePurgeActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   cur(blobGranuleHistoryKeys),
															#line 225 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   tr(cx)
															#line 1387 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this));

	}
	~LoadGranuleMetadataBeforeForcePurgeActorState() 
	{
		fdb_probe_actor_destroy("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 1402 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadGranuleMetadataBeforeForcePurgeActorState();
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = int();
															#line 251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = 0;
															#line 1427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(cur, 100);
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1446 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 1;
															#line 228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*>(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)));
															#line 1451 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1488 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 2;
															#line 245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*>(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)));
															#line 1493 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& history,int loopDepth) 
	{
															#line 229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : history ) {
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(it.key);
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(it.value);
															#line 236 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Future<GranuleFiles> fileFuture = loadHistoryFiles(cx, historyValue.granuleID);
															#line 237 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->purgedDataToCheck.push_back({ keyRange, version, historyValue.granuleID, fileFuture });
															#line 1520 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!history.empty() && history.more)
															#line 1524 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 240 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(history.back().key), cur.end);
															#line 1528 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && history,int loopDepth) 
	{
															#line 229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : history ) {
															#line 230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(it.key);
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(it.value);
															#line 236 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Future<GranuleFiles> fileFuture = loadHistoryFiles(cx, historyValue.granuleID);
															#line 237 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->purgedDataToCheck.push_back({ keyRange, version, historyValue.granuleID, fileFuture });
															#line 1554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!history.empty() && history.more)
															#line 1558 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 240 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(history.back().key), cur.end);
															#line 1562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& history,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(history, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && history,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(history), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 1751 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV loaded {0} granules metadata before force purge\n", self->purgedDataToCheck.size());
															#line 1755 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 259 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!self->purgedDataToCheck.empty());
															#line 260 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadGranuleMetadataBeforeForcePurgeActorState(); static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->destroy(); return 0; }
															#line 1761 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadGranuleMetadataBeforeForcePurgeActorState();
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(i < self->purgedDataToCheck.size()))
															#line 1780 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 252 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(std::get<3>(self->purgedDataToCheck[i]));
															#line 252 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1788 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 3;
															#line 252 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*>(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)));
															#line 1793 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 1815 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 1824 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange cur;
															#line 225 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int i;
															#line 1914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via loadGranuleMetadataBeforeForcePurge()
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class LoadGranuleMetadataBeforeForcePurgeActor final : public Actor<Void>, public ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >, public ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >, public ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >, public FastAllocated<LoadGranuleMetadataBeforeForcePurgeActor>, public LoadGranuleMetadataBeforeForcePurgeActorState<LoadGranuleMetadataBeforeForcePurgeActor> {
															#line 1919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<LoadGranuleMetadataBeforeForcePurgeActor>::operator new;
	using FastAllocated<LoadGranuleMetadataBeforeForcePurgeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7168300354708347904UL, 5770828301634389248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >;
friend struct ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >;
friend struct ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >;
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	LoadGranuleMetadataBeforeForcePurgeActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 1938 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   LoadGranuleMetadataBeforeForcePurgeActorState<LoadGranuleMetadataBeforeForcePurgeActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2433885181323424512UL, 17814556441535885312UL);
		ActorExecutionContextHelper __helper(static_cast<LoadGranuleMetadataBeforeForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadGranuleMetadataBeforeForcePurge");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadGranuleMetadataBeforeForcePurge", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadGranuleMetadataBeforeForcePurgeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> loadGranuleMetadataBeforeForcePurge( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new LoadGranuleMetadataBeforeForcePurgeActor(cx, self));
															#line 1972 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 262 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 1977 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via verifyGranules()
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class VerifyGranulesActor>
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class VerifyGranulesActorState {
															#line 1983 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	VerifyGranulesActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self,bool const& allowPurging) 
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   allowPurging(allowPurging),
															#line 264 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   last(now()),
															#line 265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   endTime(last + self->testDuration),
															#line 266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   timeTravelChecks(),
															#line 267 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   timeTravelChecksMemory(0),
															#line 268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   prevPurgeVersion(-1),
															#line 269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   newPurgeVersion(0),
															#line 271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   pickGranuleUniform(deterministicRandom()->random01() < 0.1)
															#line 2008 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyGranules", reinterpret_cast<unsigned long>(this));

	}
	~VerifyGranulesActorState() 
	{
		fdb_probe_actor_destroy("verifyGranules", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 273 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			TraceEvent("BlobGranuleVerifierStart");
															#line 274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 2025 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV {0}) thread starting\n", self->clientId);
															#line 2029 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->granuleRanges.onChange();
															#line 279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2035 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 1;
															#line 279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 0, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2040 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyGranulesActorState();
		static_cast<VerifyGranulesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2063 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 282 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) got ranges\n", self->clientId);
															#line 2067 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 2071 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2080 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 282 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) got ranges\n", self->clientId);
															#line 2084 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 2088 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 287 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			currentTime = now();
															#line 288 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			timeTravelIt = timeTravelChecks.begin();
															#line 289 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			newPurgeVersion = 0;
															#line 290 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 2186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 487 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_12 = poisson(&last, 0.1);
															#line 487 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 13;
															#line 487 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 12, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 479 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 2218 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 480 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 482 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() != error_code_blob_granule_transaction_too_old && BGV_DEBUG)
															#line 2226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 483 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGVerifier {0} got unexpected error {1}\n", self->clientId, e.name());
															#line 2230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 485 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->errors++;
															#line 2234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 428 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		size_t granuleCount = self->granuleRanges.get().size();
															#line 429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		size_t rIndex;
															#line 430 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (pickGranuleUniform)
															#line 2253 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 431 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			rIndex = deterministicRandom()->randomInt(0, granuleCount);
															#line 2257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
															#line 433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			rIndex = deterministicRandom()->randomSkewedUInt32(0, granuleCount);
															#line 2263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 435 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		range = self->granuleRanges.get()[rIndex];
															#line 437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<std::pair<RangeResult, Version>> __when_expr_8 = readFromFDB(cx, range);
															#line 437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 9;
															#line 437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 290 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(timeTravelIt != timeTravelChecks.end() && currentTime >= timeTravelIt->first))
															#line 2292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		oldRead = timeTravelIt->second;
															#line 292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		timeTravelChecksMemory -= oldRead.oldResult.expectedSize();
															#line 294 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		timeTravelIt = timeTravelChecks.erase(timeTravelIt);
															#line 295 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (prevPurgeVersion == -1)
															#line 2304 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 296 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			prevPurgeVersion = oldRead.v;
															#line 2308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 300 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		doPurging = allowPurging && !self->purgeAtLatest && deterministicRandom()->random01() < 0.5;
															#line 302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		forcePurge = doPurging && self->doForcePurge && deterministicRandom()->random01() < 0.25;
															#line 303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (doPurging)
															#line 2316 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 304 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			CODE_PROBE(true, "BGV considering purge", probe::decoration::rare);
															#line 305 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version maxPurgeVersion = oldRead.v;
															#line 306 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			for( auto& it : timeTravelChecks ) {
															#line 307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				maxPurgeVersion = std::min(it.second.v, maxPurgeVersion);
															#line 2326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 309 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (prevPurgeVersion < maxPurgeVersion)
															#line 2330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				CODE_PROBE(true, "BGV doing purge", probe::decoration::rare);
															#line 311 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				newPurgeVersion = deterministicRandom()->randomInt64(prevPurgeVersion, maxPurgeVersion);
															#line 312 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				prevPurgeVersion = std::max(prevPurgeVersion, newPurgeVersion);
															#line 313 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 2340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("BGV Purging @ {0}{1}\n", newPurgeVersion, forcePurge ? " (force)" : "");
															#line 2344 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
				try {
															#line 317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (forcePurge)
															#line 2349 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 318 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						StrictFuture<Void> __when_expr_1 = self->loadGranuleMetadataBeforeForcePurge(cx, self);
															#line 318 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2355 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
						static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 2;
															#line 318 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 1, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);
					}
				}
				catch (Error& error) {
					loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 350 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				doPurging = false;
															#line 2378 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = a_body1cont1loopBody1loopBody1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 356 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_4 = readFromBlob(cx, self->bstore, oldRead.range, 0, oldRead.v);
															#line 356 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 5;
															#line 356 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2414 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont6(int loopDepth) 
	{
															#line 344 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		CODE_PROBE(true, "BGV purge complete", probe::decoration::rare);
															#line 345 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 346 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Purge complete @ {0}\n", newPurgeVersion);
															#line 2441 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purges++;
															#line 2445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 335 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 2455 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 336 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 2459 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 339 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 2463 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("Unexpected error {0} purging @ {1}!\n", e.name(), newPurgeVersion);
															#line 2467 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 342 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(false);
															#line 2471 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8(int loopDepth) 
	{
															#line 321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_2 = cx->purgeBlobGranules(normalKeys, newPurgeVersion, {}, forcePurge);
															#line 321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2488 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 3;
															#line 321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 2, Key >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2493 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 319 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->startedForcePurge = true;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 319 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->startedForcePurge = true;
															#line 2511 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont11(Key const& purgeKey,int loopDepth) 
	{
															#line 322 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (forcePurge)
															#line 2595 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 323 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->forcePurgeKey = purgeKey;
															#line 324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->forcePurgeVersion = newPurgeVersion;
															#line 325 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 2603 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV Force purge registered, stopping\n");
															#line 2607 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<VerifyGranulesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyGranulesActorState(); static_cast<VerifyGranulesActor*>(this)->destroy(); return 0; }
															#line 2611 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<VerifyGranulesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~VerifyGranulesActorState();
			static_cast<VerifyGranulesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2619 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Purged @ {0}, waiting\n", newPurgeVersion);
															#line 2623 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2629 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11when1(__when_expr_3.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 4;
															#line 333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 3, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2634 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11(Key && purgeKey,int loopDepth) 
	{
															#line 322 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (forcePurge)
															#line 2643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 323 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->forcePurgeKey = purgeKey;
															#line 324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->forcePurgeVersion = newPurgeVersion;
															#line 325 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 2651 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV Force purge registered, stopping\n");
															#line 2655 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<VerifyGranulesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyGranulesActorState(); static_cast<VerifyGranulesActor*>(this)->destroy(); return 0; }
															#line 2659 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<VerifyGranulesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~VerifyGranulesActorState();
			static_cast<VerifyGranulesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 2667 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Purged @ {0}, waiting\n", newPurgeVersion);
															#line 2671 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2677 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont11when1(__when_expr_3.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 4;
															#line 333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 3, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2682 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont8when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont11cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont11cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15(int loopDepth) 
	{
															#line 379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (doPurging)
															#line 2866 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 380 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->strictPurgeChecking)
															#line 2870 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 381 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_5 = killBlobWorkers(cx);
															#line 381 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2876 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1cont15when1(__when_expr_5.get(), loopDepth); };
				static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 6;
															#line 381 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 5, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 2881 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 363 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2901 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 364 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 2905 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 366 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("Error TT: {0}\n", e.name());
															#line 367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_blob_granule_transaction_too_old)
															#line 2911 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				self->timeTravelTooOld++;
															#line 370 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV ERROR: TTO [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), oldRead.v);
															#line 2917 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont16(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& reReadResult,int loopDepth) 
	{
															#line 358 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!compareFDBAndBlob(oldRead.oldResult, reReadResult, oldRead.range, oldRead.v, BGV_DEBUG))
															#line 2933 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->mismatches++;
															#line 2937 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 361 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->timeTravelReads++;
															#line 2941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont16cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont16(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && reReadResult,int loopDepth) 
	{
															#line 358 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!compareFDBAndBlob(oldRead.oldResult, reReadResult, oldRead.range, oldRead.v, BGV_DEBUG))
															#line 2950 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 359 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->mismatches++;
															#line 2954 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 361 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->timeTravelReads++;
															#line 2958 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont16cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& reReadResult,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont16(reReadResult, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && reReadResult,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont16(std::move(reReadResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont16cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont2(int loopDepth) 
	{
															#line 390 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_6 = readFromBlob(cx, self->bstore, oldRead.range, 0, prevPurgeVersion);
															#line 390 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3063 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1cont15cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 7;
															#line 390 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3068 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont3(Void const& _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3077 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 383 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Reading post-purge [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), prevPurgeVersion);
															#line 3081 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont3(Void && _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3091 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 383 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Reading post-purge [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), prevPurgeVersion);
															#line 3095 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont15cont6(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& versionRead1,int loopDepth) 
	{
															#line 392 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3180 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Post-purge first read:\n");
															#line 394 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			printGranuleChunks(versionRead1.second);
															#line 3186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 396 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->strictPurgeChecking)
															#line 3190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			try {
															#line 399 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				Version minSnapshotVersion = newPurgeVersion;
															#line 400 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				for( auto& it : versionRead1.second ) {
															#line 401 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					minSnapshotVersion = std::min(minSnapshotVersion, it.snapshotVersion);
															#line 3199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 403 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 3203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 404 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("BGV Reading post-purge again [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), minSnapshotVersion - 1);
															#line 3207 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_7 = readFromBlob(cx, self->bstore, oldRead.range, 0, minSnapshotVersion - 1);
															#line 409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1cont15cont6Catch1(actor_cancelled(), loopDepth);
															#line 3213 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1loopBody1cont15cont6Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont15cont6when1(__when_expr_7.get(), loopDepth); };
				static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 8;
															#line 409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3218 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont6(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && versionRead1,int loopDepth) 
	{
															#line 392 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3238 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV Post-purge first read:\n");
															#line 394 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			printGranuleChunks(versionRead1.second);
															#line 3244 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 396 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->strictPurgeChecking)
															#line 3248 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			try {
															#line 399 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				Version minSnapshotVersion = newPurgeVersion;
															#line 400 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				for( auto& it : versionRead1.second ) {
															#line 401 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					minSnapshotVersion = std::min(minSnapshotVersion, it.snapshotVersion);
															#line 3257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 403 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 3261 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 404 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("BGV Reading post-purge again [{0} - {1}) @ {2}\n", oldRead.range.begin.printable(), oldRead.range.end.printable(), minSnapshotVersion - 1);
															#line 3265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_7 = readFromBlob(cx, self->bstore, oldRead.range, 0, minSnapshotVersion - 1);
															#line 409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1cont15cont6Catch1(actor_cancelled(), loopDepth);
															#line 3271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1loopBody1cont15cont6Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont15cont6when1(__when_expr_7.get(), loopDepth); };
				static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 8;
															#line 409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont2when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& versionRead1,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont6(versionRead1, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont2when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && versionRead1,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont6(std::move(versionRead1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont15cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont15cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1cont15cont7(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont9(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 417 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3384 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 418 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 3388 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 420 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(e.code() == error_code_blob_granule_transaction_too_old);
															#line 421 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			CODE_PROBE(true, "BGV verified too old after purge", probe::decoration::rare);
															#line 3394 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont10(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& versionRead2,int loopDepth) 
	{
															#line 411 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 412 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV ERROR: data not purged! Read successful!!\n");
															#line 413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			printGranuleChunks(versionRead2.second);
															#line 3415 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 415 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 3419 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont10(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && versionRead2,int loopDepth) 
	{
															#line 411 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3428 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 412 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV ERROR: data not purged! Read successful!!\n");
															#line 413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			printGranuleChunks(versionRead2.second);
															#line 3434 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 415 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 3438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont6when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& versionRead2,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont10(versionRead2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont15cont6when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && versionRead2,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont15cont10(std::move(versionRead2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont15cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont15cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1cont15cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1loopBody1cont15cont10cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont15cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_9 = readFromBlob(cx, self->bstore, range, 0, fdb.second);
															#line 438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3537 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_9.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 10;
															#line 438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3542 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(std::pair<RangeResult, Version> const& __fdb,int loopDepth) 
	{
															#line 437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fdb = __fdb;
															#line 3551 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(std::pair<RangeResult, Version> && __fdb,int loopDepth) 
	{
		fdb = std::move(__fdb);
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*,std::pair<RangeResult, Version> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*,std::pair<RangeResult, Version> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 440 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->purgeAtLatest && timeTravelChecks.empty() && deterministicRandom()->random01() < 0.25)
															#line 3630 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			try {
															#line 443 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Key> __when_expr_10 = cx->purgeBlobGranules(normalKeys, fdb.second, {}, false);
															#line 443 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3637 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1cont6Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_10.get(), loopDepth); };
				static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 11;
															#line 443 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 10, Key >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3642 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont6Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont6Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& __blob,int loopDepth) 
	{
															#line 438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		blob = __blob;
															#line 3662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && __blob,int loopDepth) 
	{
		blob = std::move(__blob);
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
															#line 460 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (compareFDBAndBlob(fdb.first, blob, range, fdb.second, BGV_DEBUG))
															#line 3741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 461 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			bool rereadImmediately = self->purgeAtLatest || deterministicRandom()->random01() < 0.25;
															#line 462 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			double reReadTime = currentTime + (rereadImmediately ? 0.0 : deterministicRandom()->random01() * self->timeTravelLimit);
															#line 465 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			int memory = fdb.first.expectedSize();
															#line 466 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (reReadTime <= endTime && timeTravelChecksMemory + memory <= (self->timeTravelBufferSize / self->threads))
															#line 3751 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 468 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				timeTravelChecks[reReadTime] = OldRead(range, fdb.second, fdb.first);
															#line 469 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				timeTravelChecksMemory += memory;
															#line 3757 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
		}
		else
		{
															#line 472 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			self->mismatches++;
															#line 3764 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 474 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->rowsRead += fdb.first.size();
															#line 475 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->bytesRead += fdb.first.expectedSize();
															#line 476 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->initialReads++;
															#line 3772 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
															#line 458 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purges++;
															#line 3781 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 449 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 3791 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 450 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1cont1loopBody1Catch1(e, loopDepth);
															#line 3795 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 453 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 3799 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 454 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("Unexpected error {0} purging latest @ {1}!\n", e.name(), newPurgeVersion);
															#line 3803 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 456 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(false);
															#line 3807 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Key const& purgeKey,int loopDepth) 
	{
															#line 444 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3822 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest @ {1}, waiting\n", self->clientId, fdb.second);
															#line 3826 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_11 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3832 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont6Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_11.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 12;
															#line 447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 11, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3837 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Key && purgeKey,int loopDepth) 
	{
															#line 444 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 3846 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest @ {1}, waiting\n", self->clientId, fdb.second);
															#line 3850 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_11 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3856 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont6Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_11.get(), loopDepth); };
		static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 12;
															#line 447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< VerifyGranulesActor, 11, Void >*>(static_cast<VerifyGranulesActor*>(this)));
															#line 3861 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 10, Key >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 10, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 10, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 10, Key >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont18(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont18(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<VerifyGranulesActor*>(this)->actor_wait_state > 0) static_cast<VerifyGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyGranulesActor*>(this)->ActorCallback< VerifyGranulesActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< VerifyGranulesActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< VerifyGranulesActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool allowPurging;
															#line 264 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	double last;
															#line 265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	double endTime;
															#line 266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::map<double, OldRead> timeTravelChecks;
															#line 267 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t timeTravelChecksMemory;
															#line 268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version prevPurgeVersion;
															#line 269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version newPurgeVersion;
															#line 271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool pickGranuleUniform;
															#line 287 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	double currentTime;
															#line 288 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::map<double, OldRead>::iterator timeTravelIt;
															#line 291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	OldRead oldRead;
															#line 300 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool doPurging;
															#line 302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool forcePurge;
															#line 435 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange range;
															#line 437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::pair<RangeResult, Version> fdb;
															#line 438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> blob;
															#line 4177 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via verifyGranules()
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class VerifyGranulesActor final : public Actor<Void>, public ActorCallback< VerifyGranulesActor, 0, Void >, public ActorCallback< VerifyGranulesActor, 1, Void >, public ActorCallback< VerifyGranulesActor, 2, Key >, public ActorCallback< VerifyGranulesActor, 3, Void >, public ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public ActorCallback< VerifyGranulesActor, 5, Void >, public ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >, public ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public ActorCallback< VerifyGranulesActor, 10, Key >, public ActorCallback< VerifyGranulesActor, 11, Void >, public ActorCallback< VerifyGranulesActor, 12, Void >, public FastAllocated<VerifyGranulesActor>, public VerifyGranulesActorState<VerifyGranulesActor> {
															#line 4182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<VerifyGranulesActor>::operator new;
	using FastAllocated<VerifyGranulesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11866377196340958208UL, 722738799619579136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyGranulesActor, 0, Void >;
friend struct ActorCallback< VerifyGranulesActor, 1, Void >;
friend struct ActorCallback< VerifyGranulesActor, 2, Key >;
friend struct ActorCallback< VerifyGranulesActor, 3, Void >;
friend struct ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
friend struct ActorCallback< VerifyGranulesActor, 5, Void >;
friend struct ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
friend struct ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
friend struct ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >;
friend struct ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
friend struct ActorCallback< VerifyGranulesActor, 10, Key >;
friend struct ActorCallback< VerifyGranulesActor, 11, Void >;
friend struct ActorCallback< VerifyGranulesActor, 12, Void >;
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	VerifyGranulesActor(Database const& cx,BlobGranuleVerifierWorkload* const& self,bool const& allowPurging) 
															#line 4211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyGranulesActorState<VerifyGranulesActor>(cx, self, allowPurging),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyGranules", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4757613148507417856UL, 12548808069170726912UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyGranules");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyGranules", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyGranulesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyGranulesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< VerifyGranulesActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< VerifyGranulesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< VerifyGranulesActor, 4, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< VerifyGranulesActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< VerifyGranulesActor, 6, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< VerifyGranulesActor, 7, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< VerifyGranulesActor, 8, std::pair<RangeResult, Version> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< VerifyGranulesActor, 9, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< VerifyGranulesActor, 10, Key >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< VerifyGranulesActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< VerifyGranulesActor, 12, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> verifyGranules( Database const& cx, BlobGranuleVerifierWorkload* const& self, bool const& allowPurging ) {
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new VerifyGranulesActor(cx, self, allowPurging));
															#line 4255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 490 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	Future<Void> start(Database const& cx) override {
		clients.reserve(threads + 1);
		clients.push_back(timeout(findGranules(cx, this), testDuration, Void()));
		if (enablePurging && clientId == 0) {
			clients.push_back(
			    timeout(reportErrors(verifyGranules(cx, this, true), "BlobGranuleVerifier"), testDuration, Void()));
		} else if (!enablePurging) {
			for (int i = 0; i < threads; i++) {
				clients.push_back(timeout(
				    reportErrors(verifyGranules(cx, this, false), "BlobGranuleVerifier"), testDuration, Void()));
			}
		}
		if (!enablePurging) {
			summaryClient = validateGranuleSummaries(cx, normalKeys, {}, triggerSummaryComplete);
		} else {
			summaryClient = Future<Void>(Void());
		}
		if (doForceFlushing) {
			forceFlushingClient = validateForceFlushing(cx, normalKeys, testDuration, triggerSummaryComplete);
		} else {
			forceFlushingClient = Future<Void>(Void());
		}
		return delay(testDuration);
	}

	// handle retries + errors
	// It's ok to reset the transaction here because its read version is only used for reading the granule mapping from
	// the system keyspace
																#line 4288 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via doGrv()
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class DoGrvActor>
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class DoGrvActorState {
															#line 4294 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	DoGrvActorState(Transaction* const& tr) 
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : tr(tr)
															#line 4301 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("doGrv", reinterpret_cast<unsigned long>(this));

	}
	~DoGrvActorState() 
	{
		fdb_probe_actor_destroy("doGrv", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 520 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 4316 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoGrvActorState();
		static_cast<DoGrvActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 522 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr->getReadVersion();
															#line 522 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<DoGrvActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4349 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoGrvActor*>(this)->actor_wait_state = 1;
															#line 522 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoGrvActor, 0, Version >*>(static_cast<DoGrvActor*>(this)));
															#line 4354 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 525 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 525 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<DoGrvActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4378 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoGrvActor*>(this)->actor_wait_state = 2;
															#line 525 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoGrvActor, 1, Void >*>(static_cast<DoGrvActor*>(this)));
															#line 4383 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 523 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<DoGrvActor*>(this)->SAV<Version>::futures) { (void)(readVersion); this->~DoGrvActorState(); static_cast<DoGrvActor*>(this)->destroy(); return 0; }
															#line 4398 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<DoGrvActor*>(this)->SAV< Version >::value()) Version(readVersion);
		this->~DoGrvActorState();
		static_cast<DoGrvActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 523 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<DoGrvActor*>(this)->SAV<Version>::futures) { (void)(readVersion); this->~DoGrvActorState(); static_cast<DoGrvActor*>(this)->destroy(); return 0; }
															#line 4410 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<DoGrvActor*>(this)->SAV< Version >::value()) Version(readVersion);
		this->~DoGrvActorState();
		static_cast<DoGrvActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoGrvActor*>(this)->actor_wait_state > 0) static_cast<DoGrvActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvActor*>(this)->ActorCallback< DoGrvActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoGrvActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoGrvActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoGrvActor*>(this)->actor_wait_state > 0) static_cast<DoGrvActor*>(this)->actor_wait_state = 0;
		static_cast<DoGrvActor*>(this)->ActorCallback< DoGrvActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoGrvActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoGrvActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoGrvActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction* tr;
															#line 4582 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via doGrv()
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class DoGrvActor final : public Actor<Version>, public ActorCallback< DoGrvActor, 0, Version >, public ActorCallback< DoGrvActor, 1, Void >, public FastAllocated<DoGrvActor>, public DoGrvActorState<DoGrvActor> {
															#line 4587 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<DoGrvActor>::operator new;
	using FastAllocated<DoGrvActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7209099058333950464UL, 16060425247188074240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoGrvActor, 0, Version >;
friend struct ActorCallback< DoGrvActor, 1, Void >;
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	DoGrvActor(Transaction* const& tr) 
															#line 4605 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Version>(),
		   DoGrvActorState<DoGrvActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doGrv", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1994116863933768704UL, 13279750342320377088UL);
		ActorExecutionContextHelper __helper(static_cast<DoGrvActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doGrv");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doGrv", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoGrvActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoGrvActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Version> doGrv( Transaction* const& tr ) {
															#line 519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Version>(new DoGrvActor(tr));
															#line 4638 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 529 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 4643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via checkGranuleMetadataPurged()
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class CheckGranuleMetadataPurgedActor>
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckGranuleMetadataPurgedActorState {
															#line 4649 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckGranuleMetadataPurgedActorState(Transaction* const& tr,KeyRange const& granuleRange,Version const& historyVersion,UID const& granuleId,bool const& strictMetadataCheck,bool const& possiblyInFlight) 
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : tr(tr),
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   granuleRange(granuleRange),
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   historyVersion(historyVersion),
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   granuleId(granuleId),
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   strictMetadataCheck(strictMetadataCheck),
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   possiblyInFlight(possiblyInFlight)
															#line 4666 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this));

	}
	~CheckGranuleMetadataPurgedActorState() 
	{
		fdb_probe_actor_destroy("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 537 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(granuleIDToCFKey(granuleId).withPrefix(changeFeedPrefix));
															#line 537 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 1;
															#line 537 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4688 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckGranuleMetadataPurgedActorState();
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& changeFeed,int loopDepth) 
	{
															#line 538 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && changeFeed.present())
															#line 4711 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("WARN: Change Feed for [{0} - {1}): {2} not purged, retrying\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 543 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 4717 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 545 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!changeFeed.present());
															#line 548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(blobGranuleFileKeyRangeFor(granuleId), 1);
															#line 548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4729 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 2;
															#line 548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && changeFeed,int loopDepth) 
	{
															#line 538 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && changeFeed.present())
															#line 4743 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("WARN: Change Feed for [{0} - {1}): {2} not purged, retrying\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 543 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 4749 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 545 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!changeFeed.present());
															#line 548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(blobGranuleFileKeyRangeFor(granuleId), 1);
															#line 548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4761 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 2;
															#line 548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& changeFeed,int loopDepth) 
	{
		loopDepth = a_body1cont1(changeFeed, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && changeFeed,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(changeFeed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(RangeResult const& fileMetadata,int loopDepth) 
	{
															#line 549 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && !fileMetadata.empty())
															#line 4850 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 550 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("WARN: File metadata for [{0} - {1}): {2} not purged, retrying\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 4856 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 556 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(fileMetadata.empty());
															#line 558 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (strictMetadataCheck)
															#line 4866 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = tr->get(blobGranuleLockKeyFor(granuleRange));
															#line 560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4872 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 3;
															#line 560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4877 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult && fileMetadata,int loopDepth) 
	{
															#line 549 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && !fileMetadata.empty())
															#line 4891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 550 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("WARN: File metadata for [{0} - {1}): {2} not purged, retrying\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 4897 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 556 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(fileMetadata.empty());
															#line 558 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (strictMetadataCheck)
															#line 4907 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = tr->get(blobGranuleLockKeyFor(granuleRange));
															#line 560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 3;
															#line 560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 4918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& fileMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(fileMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && fileMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(fileMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 590 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5007 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckGranuleMetadataPurgedActorState();
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> const& lock,int loopDepth) 
	{
															#line 561 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && lock.present())
															#line 5019 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5023 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 564 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!lock.present());
															#line 567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr->get(blobGranuleHistoryKeyFor(granuleRange, historyVersion));
															#line 567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5035 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 4;
															#line 567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5040 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> && lock,int loopDepth) 
	{
															#line 561 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && lock.present())
															#line 5049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5053 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 564 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!lock.present());
															#line 567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_3 = tr->get(blobGranuleHistoryKeyFor(granuleRange, historyVersion));
															#line 567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5065 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 4;
															#line 567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5070 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> const& lock,int loopDepth) 
	{
		loopDepth = a_body1cont6(lock, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> && lock,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(lock), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Optional<Value> const& history,int loopDepth) 
	{
															#line 568 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && history.present())
															#line 5154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 571 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!history.present());
															#line 574 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(blobGranuleSplitKeyRangeFor(granuleId), 1);
															#line 574 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 5;
															#line 574 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Optional<Value> && history,int loopDepth) 
	{
															#line 568 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && history.present())
															#line 5184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 571 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!history.present());
															#line 574 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(blobGranuleSplitKeyRangeFor(granuleId), 1);
															#line 574 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 5;
															#line 574 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Optional<Value> const& history,int loopDepth) 
	{
		loopDepth = a_body1cont7(history, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Optional<Value> && history,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(history), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(RangeResult const& splitData,int loopDepth) 
	{
															#line 575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && !splitData.empty())
															#line 5289 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 576 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5293 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 578 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(splitData.empty());
															#line 581 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(blobGranuleMergeKeyFor(granuleId));
															#line 581 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5305 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 6;
															#line 581 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(RangeResult && splitData,int loopDepth) 
	{
															#line 575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && !splitData.empty())
															#line 5319 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 576 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5323 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 578 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(splitData.empty());
															#line 581 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(blobGranuleMergeKeyFor(granuleId));
															#line 581 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5335 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 6;
															#line 581 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*>(static_cast<CheckGranuleMetadataPurgedActor*>(this)));
															#line 5340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult const& splitData,int loopDepth) 
	{
		loopDepth = a_body1cont9(splitData, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult && splitData,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(splitData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(Optional<Value> const& merge,int loopDepth) 
	{
															#line 582 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && merge.present())
															#line 5424 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5428 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 585 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!merge.present());
															#line 5436 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Optional<Value> && merge,int loopDepth) 
	{
															#line 582 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (possiblyInFlight && merge.present())
															#line 5445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckGranuleMetadataPurgedActorState(); static_cast<CheckGranuleMetadataPurgedActor*>(this)->destroy(); return 0; }
															#line 5449 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckGranuleMetadataPurgedActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckGranuleMetadataPurgedActorState();
			static_cast<CheckGranuleMetadataPurgedActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 585 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(!merge.present());
															#line 5457 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Optional<Value> const& merge,int loopDepth) 
	{
		loopDepth = a_body1cont11(merge, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Optional<Value> && merge,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(merge), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleMetadataPurgedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleMetadataPurgedActor*>(this)->ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction* tr;
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange granuleRange;
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version historyVersion;
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	UID granuleId;
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool strictMetadataCheck;
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool possiblyInFlight;
															#line 5549 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via checkGranuleMetadataPurged()
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckGranuleMetadataPurgedActor final : public Actor<bool>, public ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >, public ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >, public ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >, public ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >, public ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >, public ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >, public FastAllocated<CheckGranuleMetadataPurgedActor>, public CheckGranuleMetadataPurgedActorState<CheckGranuleMetadataPurgedActor> {
															#line 5554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<CheckGranuleMetadataPurgedActor>::operator new;
	using FastAllocated<CheckGranuleMetadataPurgedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10470005630096073984UL, 1209299547628279808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >;
friend struct ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >;
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckGranuleMetadataPurgedActor(Transaction* const& tr,KeyRange const& granuleRange,Version const& historyVersion,UID const& granuleId,bool const& strictMetadataCheck,bool const& possiblyInFlight) 
															#line 5576 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<bool>(),
		   CheckGranuleMetadataPurgedActorState<CheckGranuleMetadataPurgedActor>(tr, granuleRange, historyVersion, granuleId, strictMetadataCheck, possiblyInFlight),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10941498556622655488UL, 7318377067046864640UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleMetadataPurgedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkGranuleMetadataPurged");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkGranuleMetadataPurged", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 3, Optional<Value> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckGranuleMetadataPurgedActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<bool> checkGranuleMetadataPurged( Transaction* const& tr, KeyRange const& granuleRange, Version const& historyVersion, UID const& granuleId, bool const& strictMetadataCheck, bool const& possiblyInFlight ) {
															#line 530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<bool>(new CheckGranuleMetadataPurgedActor(tr, granuleRange, historyVersion, granuleId, strictMetadataCheck, possiblyInFlight));
															#line 5613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 592 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 5618 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via checkPurgedHistoryEntries()
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class CheckPurgedHistoryEntriesActor>
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckPurgedHistoryEntriesActorState {
															#line 5624 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckPurgedHistoryEntriesActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange,bool const& strictMetadataCheck) 
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   purgeRange(purgeRange),
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   strictMetadataCheck(strictMetadataCheck),
															#line 603 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   tr(cx),
															#line 604 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   cur(blobGranuleHistoryKeys),
															#line 605 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   granulesToCheck()
															#line 5643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this));

	}
	~CheckPurgedHistoryEntriesActorState() 
	{
		fdb_probe_actor_destroy("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 606 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 5658 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckPurgedHistoryEntriesActorState();
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 642 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.reset();
															#line 643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = int();
															#line 644 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG && !granulesToCheck.empty())
															#line 5685 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 645 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("Checking metadata for {0} non-purged ranges\n", granulesToCheck.size());
															#line 5689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 647 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = 0;
															#line 5693 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 607 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 5709 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 609 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(cur, 1000);
															#line 609 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 1;
															#line 609 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 5720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 638 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 638 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5757 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 2;
															#line 638 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 5762 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& history,int loopDepth) 
	{
															#line 610 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : history ) {
															#line 611 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 612 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(it.key);
															#line 614 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (purgeRange.intersects(keyRange))
															#line 5785 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 615 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 5789 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 616 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("Found range [{0} - {1}) @ {2} that avoided force purge [{3} - {4}) @ {5}!!\n", keyRange.begin.printable(), keyRange.end.printable(), version, purgeRange.begin.printable(), purgeRange.end.printable(), self->forcePurgeVersion);
															#line 5793 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 624 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (strictMetadataCheck)
															#line 5797 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					ASSERT(!purgeRange.intersects(keyRange));
															#line 5801 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
				else
				{
															#line 627 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(it.value);
															#line 628 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					granulesToCheck.emplace_back(keyRange, version, historyValue.granuleID);
															#line 5809 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
		}
															#line 632 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!history.empty() && history.more)
															#line 5815 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 633 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(history.back().key), cur.end);
															#line 5819 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && history,int loopDepth) 
	{
															#line 610 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : history ) {
															#line 611 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 612 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(it.key);
															#line 614 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (purgeRange.intersects(keyRange))
															#line 5841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 615 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 5845 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 616 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("Found range [{0} - {1}) @ {2} that avoided force purge [{3} - {4}) @ {5}!!\n", keyRange.begin.printable(), keyRange.end.printable(), version, purgeRange.begin.printable(), purgeRange.end.printable(), self->forcePurgeVersion);
															#line 5849 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 624 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (strictMetadataCheck)
															#line 5853 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					ASSERT(!purgeRange.intersects(keyRange));
															#line 5857 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
				else
				{
															#line 627 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(it.value);
															#line 628 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					granulesToCheck.emplace_back(keyRange, version, historyValue.granuleID);
															#line 5865 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
		}
															#line 632 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!history.empty() && history.more)
															#line 5871 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 633 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(history.back().key), cur.end);
															#line 5875 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& history,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(history, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && history,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(history), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 667 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<CheckPurgedHistoryEntriesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckPurgedHistoryEntriesActorState(); static_cast<CheckPurgedHistoryEntriesActor*>(this)->destroy(); return 0; }
															#line 6064 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<CheckPurgedHistoryEntriesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckPurgedHistoryEntriesActorState();
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 647 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(i < granulesToCheck.size()))
															#line 6083 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 648 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 6089 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 647 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 6111 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 649 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 6127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 651 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<bool> __when_expr_2 = self->checkGranuleMetadataPurged(&tr, std::get<0>(granulesToCheck[i]), std::get<1>(granulesToCheck[i]), std::get<2>(granulesToCheck[i]), strictMetadataCheck, true);
															#line 651 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 3;
															#line 651 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 6138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 5;
															#line 662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 6180 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(bool const& success,int loopDepth) 
	{
															#line 657 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (success)
															#line 6195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 4;
															#line 660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 6208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(bool && success,int loopDepth) 
	{
															#line 657 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (success)
															#line 6217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6225 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 4;
															#line 660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*>(static_cast<CheckPurgedHistoryEntriesActor*>(this)));
															#line 6230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedHistoryEntriesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedHistoryEntriesActor*>(this)->ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange purgeRange;
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool strictMetadataCheck;
															#line 603 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 604 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange cur;
															#line 605 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::vector<std::tuple<KeyRange, Version, UID>> granulesToCheck;
															#line 643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int i;
															#line 6513 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via checkPurgedHistoryEntries()
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckPurgedHistoryEntriesActor final : public Actor<Void>, public ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >, public ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >, public ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >, public ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >, public ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >, public FastAllocated<CheckPurgedHistoryEntriesActor>, public CheckPurgedHistoryEntriesActorState<CheckPurgedHistoryEntriesActor> {
															#line 6518 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<CheckPurgedHistoryEntriesActor>::operator new;
	using FastAllocated<CheckPurgedHistoryEntriesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11854971471472814080UL, 14662116873131657216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >;
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >;
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >;
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >;
friend struct ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >;
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckPurgedHistoryEntriesActor(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange,bool const& strictMetadataCheck) 
															#line 6539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   CheckPurgedHistoryEntriesActorState<CheckPurgedHistoryEntriesActor>(cx, self, purgeRange, strictMetadataCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9442908700208833792UL, 8625101335363735296UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedHistoryEntriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkPurgedHistoryEntries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkPurgedHistoryEntries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckPurgedHistoryEntriesActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> checkPurgedHistoryEntries( Database const& cx, BlobGranuleVerifierWorkload* const& self, KeyRange const& purgeRange, bool const& strictMetadataCheck ) {
															#line 593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new CheckPurgedHistoryEntriesActor(cx, self, purgeRange, strictMetadataCheck));
															#line 6575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 669 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 6580 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via checkPurgedChangeFeeds()
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class CheckPurgedChangeFeedsActor>
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckPurgedChangeFeedsActorState {
															#line 6586 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckPurgedChangeFeedsActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange) 
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   purgeRange(purgeRange),
															#line 672 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   tr(cx),
															#line 673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   cur(changeFeedKeys)
															#line 6601 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this));

	}
	~CheckPurgedChangeFeedsActorState() 
	{
		fdb_probe_actor_destroy("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 674 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 6616 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckPurgedChangeFeedsActorState();
		static_cast<CheckPurgedChangeFeedsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 729 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckPurgedChangeFeedsActorState(); static_cast<CheckPurgedChangeFeedsActor*>(this)->destroy(); return 0; }
															#line 6639 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckPurgedChangeFeedsActorState();
		static_cast<CheckPurgedChangeFeedsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 675 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 6658 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 677 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(cur, 1000);
															#line 677 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6664 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state = 1;
															#line 677 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*>(static_cast<CheckPurgedChangeFeedsActor*>(this)));
															#line 6669 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 725 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 725 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6706 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state = 2;
															#line 725 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*>(static_cast<CheckPurgedChangeFeedsActor*>(this)));
															#line 6711 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& feeds,int loopDepth) 
	{
															#line 678 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : feeds ) {
															#line 679 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 680 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 681 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ChangeFeedStatus status;
															#line 682 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version, status) = decodeChangeFeedValue(it.value);
															#line 683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (purgeRange.intersects(keyRange))
															#line 6736 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 684 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				Key feedId = it.key.removePrefix(changeFeedKeys.begin);
															#line 685 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 6742 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 686 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print( "Found Change Feed {0}: [{1} - {2}) that avoided force purge [{3} - {4}) @ {5}!!\n", feedId.printable(), keyRange.begin.printable(), keyRange.end.printable(), purgeRange.begin.printable(), purgeRange.end.printable(), self->forcePurgeVersion);
															#line 6746 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 699 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				bool foundAnyHistoryForRange = false;
															#line 700 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				for( auto& purgedData : self->purgedDataToCheck ) {
															#line 701 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					KeyRange granuleRange = std::get<0>(purgedData);
															#line 702 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (granuleRange.intersects(keyRange))
															#line 6756 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 703 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						foundAnyHistoryForRange = true;
															#line 6760 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						break;
					}
				}
															#line 708 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (!foundAnyHistoryForRange)
															#line 6766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 711 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					CODE_PROBE( true, "not failing test for leaked feed with no history", probe::decoration::rare);
															#line 713 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("Not failing test b/c feed never had history!\n");
															#line 6772 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (!static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV<bool>::futures) { (void)(!foundAnyHistoryForRange); this->~CheckPurgedChangeFeedsActorState(); static_cast<CheckPurgedChangeFeedsActor*>(this)->destroy(); return 0; }
															#line 6776 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				new (&static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV< bool >::value()) bool(!foundAnyHistoryForRange);
				this->~CheckPurgedChangeFeedsActorState();
				static_cast<CheckPurgedChangeFeedsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 719 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!feeds.empty() && feeds.more)
															#line 6785 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(feeds.back().key), cur.end);
															#line 6789 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && feeds,int loopDepth) 
	{
															#line 678 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : feeds ) {
															#line 679 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			KeyRange keyRange;
															#line 680 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			Version version;
															#line 681 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ChangeFeedStatus status;
															#line 682 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			std::tie(keyRange, version, status) = decodeChangeFeedValue(it.value);
															#line 683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (purgeRange.intersects(keyRange))
															#line 6813 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 684 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				Key feedId = it.key.removePrefix(changeFeedKeys.begin);
															#line 685 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (BGV_DEBUG)
															#line 6819 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 686 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print( "Found Change Feed {0}: [{1} - {2}) that avoided force purge [{3} - {4}) @ {5}!!\n", feedId.printable(), keyRange.begin.printable(), keyRange.end.printable(), purgeRange.begin.printable(), purgeRange.end.printable(), self->forcePurgeVersion);
															#line 6823 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 699 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				bool foundAnyHistoryForRange = false;
															#line 700 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				for( auto& purgedData : self->purgedDataToCheck ) {
															#line 701 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					KeyRange granuleRange = std::get<0>(purgedData);
															#line 702 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (granuleRange.intersects(keyRange))
															#line 6833 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 703 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						foundAnyHistoryForRange = true;
															#line 6837 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						break;
					}
				}
															#line 708 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (!foundAnyHistoryForRange)
															#line 6843 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 711 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					CODE_PROBE( true, "not failing test for leaked feed with no history", probe::decoration::rare);
															#line 713 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					fmt::print("Not failing test b/c feed never had history!\n");
															#line 6849 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
															#line 715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (!static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV<bool>::futures) { (void)(!foundAnyHistoryForRange); this->~CheckPurgedChangeFeedsActorState(); static_cast<CheckPurgedChangeFeedsActor*>(this)->destroy(); return 0; }
															#line 6853 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				new (&static_cast<CheckPurgedChangeFeedsActor*>(this)->SAV< bool >::value()) bool(!foundAnyHistoryForRange);
				this->~CheckPurgedChangeFeedsActorState();
				static_cast<CheckPurgedChangeFeedsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 719 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!feeds.empty() && feeds.more)
															#line 6862 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			cur = KeyRangeRef(keyAfter(feeds.back().key), cur.end);
															#line 6866 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& feeds,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(feeds, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && feeds,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(feeds), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedChangeFeedsActor*>(this)->ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state > 0) static_cast<CheckPurgedChangeFeedsActor*>(this)->actor_wait_state = 0;
		static_cast<CheckPurgedChangeFeedsActor*>(this)->ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange purgeRange;
															#line 672 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange cur;
															#line 7061 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via checkPurgedChangeFeeds()
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckPurgedChangeFeedsActor final : public Actor<bool>, public ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >, public ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >, public FastAllocated<CheckPurgedChangeFeedsActor>, public CheckPurgedChangeFeedsActorState<CheckPurgedChangeFeedsActor> {
															#line 7066 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<CheckPurgedChangeFeedsActor>::operator new;
	using FastAllocated<CheckPurgedChangeFeedsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(581538157814359040UL, 17178073282162276096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >;
friend struct ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >;
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckPurgedChangeFeedsActor(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange) 
															#line 7084 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<bool>(),
		   CheckPurgedChangeFeedsActorState<CheckPurgedChangeFeedsActor>(cx, self, purgeRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14245640899879966208UL, 14868150293114112768UL);
		ActorExecutionContextHelper __helper(static_cast<CheckPurgedChangeFeedsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkPurgedChangeFeeds");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkPurgedChangeFeeds", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckPurgedChangeFeedsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckPurgedChangeFeedsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<bool> checkPurgedChangeFeeds( Database const& cx, BlobGranuleVerifierWorkload* const& self, KeyRange const& purgeRange ) {
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<bool>(new CheckPurgedChangeFeedsActor(cx, self, purgeRange));
															#line 7117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 731 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 7122 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via validateForcePurge()
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class ValidateForcePurgeActor>
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class ValidateForcePurgeActorState {
															#line 7128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	ValidateForcePurgeActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange) 
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   purgeRange(purgeRange),
															#line 734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   strictMetadataCheck(false)
															#line 7141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("validateForcePurge", reinterpret_cast<unsigned long>(this));

	}
	~ValidateForcePurgeActorState() 
	{
		fdb_probe_actor_destroy("validateForcePurge", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 736 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 7156 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 737 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV waiting for force purge to complete\n");
															#line 7160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 739 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->waitPurgeGranulesComplete(self->forcePurgeKey.get());
															#line 739 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 1;
															#line 739 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 0, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateForcePurgeActorState();
		static_cast<ValidateForcePurgeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 740 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge completed, checking\n");
															#line 7198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 744 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr = Transaction(cx);
															#line 747 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 7204 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 740 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7213 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge completed, checking\n");
															#line 7217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 744 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr = Transaction(cx);
															#line 747 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 7223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 758 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 759 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked state\n");
															#line 7311 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 763 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.reset();
															#line 764 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 7317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 748 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 7333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<ForcedPurgeState> __when_expr_1 = getForcePurgedState(&tr, purgeRange);
															#line 750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7339 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 2;
															#line 750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7344 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 754 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 754 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7381 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 3;
															#line 754 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 2, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7386 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(ForcedPurgeState const& forcePurgedState,int loopDepth) 
	{
															#line 751 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(forcePurgedState == ForcedPurgeState::AllPurged);
															#line 7401 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(ForcedPurgeState && forcePurgedState,int loopDepth) 
	{
															#line 751 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(forcePurgedState == ForcedPurgeState::AllPurged);
															#line 7410 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ForcedPurgeState const& forcePurgedState,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(forcePurgedState, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ForcedPurgeState && forcePurgedState,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(forcePurgedState), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*,ForcedPurgeState const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*,ForcedPurgeState && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 778 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7581 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 779 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked read\n");
															#line 7585 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 783 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7589 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 784 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV checking metadata deleted\n");
															#line 7593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 786 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = int();
															#line 787 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		filesChecked = 0;
															#line 788 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = 0;
															#line 7601 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
		try {
															#line 766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_3 = self->doGrv(&tr);
															#line 766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7620 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 4;
															#line 766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 3, Version >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 770 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 7660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 771 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7664 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 773 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(e.code() == error_code_blob_granule_transaction_too_old);
															#line 7668 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 767 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(readFromBlob(cx, self->bstore, purgeRange, 0, readVersion));
															#line 767 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7685 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 5;
															#line 767 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 4, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7690 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 767 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(readFromBlob(cx, self->bstore, purgeRange, 0, readVersion));
															#line 767 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7701 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont3loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 5;
															#line 767 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 4, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7706 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 768 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 7790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 768 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 7799 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 829 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 7896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 830 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked {0} old granules and {1} old files cleaned up\n", self->purgedDataToCheck.size(), filesChecked);
															#line 7900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 835 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_9 = self->checkPurgedHistoryEntries(cx, self, purgeRange, strictMetadataCheck);
															#line 835 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont7when1(__when_expr_9.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 10;
															#line 835 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 9, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7911 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 788 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(i < self->purgedDataToCheck.size()))
															#line 7927 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 789 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		granuleRange = std::get<0>(self->purgedDataToCheck[i]);
															#line 790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		historyVersion = std::get<1>(self->purgedDataToCheck[i]);
															#line 791 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		granuleId = std::get<2>(self->purgedDataToCheck[i]);
															#line 792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<GranuleFiles> __when_expr_5 = std::get<3>(self->purgedDataToCheck[i]);
															#line 792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 6;
															#line 792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 7946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(int loopDepth) 
	{
															#line 793 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  Checking [{0} - {1}): {2}\n", granuleRange.begin.printable(), granuleRange.end.printable(), granuleId.toString().substr(0, 6));
															#line 797 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 7970 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(GranuleFiles const& __oldFiles,int loopDepth) 
	{
															#line 792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		oldFiles = __oldFiles;
															#line 7979 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(GranuleFiles && __oldFiles,int loopDepth) 
	{
		oldFiles = std::move(__oldFiles);
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*,GranuleFiles const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*,GranuleFiles && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont5loopBody1cont3(int loopDepth) 
	{
															#line 810 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fileIdx = int();
															#line 811 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fileIdx = 0;
															#line 8060 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 798 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 8076 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 800 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<bool> __when_expr_6 = self->checkGranuleMetadataPurged( &tr, granuleRange, historyVersion, granuleId, strictMetadataCheck, false);
															#line 800 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont5loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8082 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont5loopBody1cont1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont5loopBody1cont1loopBody1when1(__when_expr_6.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 7;
															#line 800 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 6, bool >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8087 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont5loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont5loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 805 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 805 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont5loopBody1cont1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 8;
															#line 805 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 7, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8129 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1cont2(bool const& success,int loopDepth) 
	{
															#line 802 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(success);
															#line 8144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1cont5loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1cont2(bool && success,int loopDepth) 
	{
															#line 802 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(success);
															#line 8153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		return a_body1cont5loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1cont2(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1cont2(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont5loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont5loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont5loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont5loopBody1cont4(int loopDepth) 
	{
															#line 788 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 8324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 811 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(fileIdx < oldFiles.snapshotFiles.size() + oldFiles.deltaFiles.size()))
															#line 8340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont5loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 812 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		std::string fname = (fileIdx >= oldFiles.snapshotFiles.size()) ? oldFiles.deltaFiles[fileIdx - oldFiles.snapshotFiles.size()].filename : oldFiles.snapshotFiles[fileIdx].filename;
															#line 815 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		bstore = self->bstore->getForRead(fname);
															#line 8348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 817 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_8 = success(bstore->readFile(fname));
															#line 817 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1cont5loopBody1cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8354 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont5loopBody1cont3loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont5loopBody1cont3loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 9;
															#line 817 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 8, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8359 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5loopBody1cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5loopBody1cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont5loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 811 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fileIdx++;
															#line 8387 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 820 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 8397 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 821 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 8401 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 823 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(e.code() == error_code_file_not_found);
															#line 824 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			filesChecked++;
															#line 8407 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1cont5loopBody1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 818 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 8422 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 818 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(false);
															#line 8431 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont3loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont5loopBody1cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont5loopBody1cont3loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5loopBody1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 837 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8528 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked for new granule history entries\n");
															#line 8532 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 8536 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 837 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8545 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked for new granule history entries\n");
															#line 8549 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 8553 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 848 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8637 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 849 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checked for leaked change feeds\n");
															#line 8641 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 856 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 8645 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1(int loopDepth) 
	{
															#line 842 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<bool> __when_expr_10 = self->checkPurgedChangeFeeds(cx, self, purgeRange);
															#line 842 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8663 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1when1(__when_expr_10.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 11;
															#line 842 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 10, bool >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8668 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(bool const& success,int loopDepth) 
	{
															#line 843 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (success)
															#line 8690 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(bool && success,int loopDepth) 
	{
															#line 843 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (success)
															#line 8702 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont10loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(success, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 10, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 10, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 10, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 10, bool >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 897 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8789 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 898 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge check complete\n");
															#line 8793 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 901 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<ValidateForcePurgeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateForcePurgeActorState(); static_cast<ValidateForcePurgeActor*>(this)->destroy(); return 0; }
															#line 8797 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<ValidateForcePurgeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateForcePurgeActorState();
		static_cast<ValidateForcePurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1(int loopDepth) 
	{
															#line 857 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		anyRangesLeft = false;
															#line 858 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<std::vector<BlobWorkerInterface>> __when_expr_11 = getBlobWorkers(cx);
															#line 858 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8820 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1when1(__when_expr_11.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 12;
															#line 858 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8825 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(int loopDepth) 
	{
															#line 860 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 8847 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 861 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV force purge checking {0} blob worker mappings\n", blobWorkers.size());
															#line 8851 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 864 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i = 0;
															#line 8855 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(std::vector<BlobWorkerInterface> const& __blobWorkers,int loopDepth) 
	{
															#line 858 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		blobWorkers = __blobWorkers;
															#line 8864 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(std::vector<BlobWorkerInterface> && __blobWorkers,int loopDepth) 
	{
		blobWorkers = std::move(__blobWorkers);
		loopDepth = a_body1cont10cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*,std::vector<BlobWorkerInterface> const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*,std::vector<BlobWorkerInterface> && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont1loopBody1cont2(int loopDepth) 
	{
															#line 890 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (anyRangesLeft)
															#line 8943 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_13 = delay(10.0);
															#line 891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8949 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont2when1(__when_expr_13.get(), loopDepth); };
			static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 14;
															#line 891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 13, Void >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8954 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 864 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(i < blobWorkers.size()))
															#line 8975 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont10cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 865 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		GetGranuleAssignmentsRequest req;
															#line 866 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		req.managerEpoch = -1;
															#line 867 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Optional<GetGranuleAssignmentsReply>> __when_expr_12 = timeout(brokenPromiseToNever(blobWorkers[i].granuleAssignmentsRequest.getReply(req)), SERVER_KNOBS->BLOB_WORKER_TIMEOUT);
															#line 867 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8987 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 2)); else return a_body1cont10cont1loopBody1cont1loopBody1when1(__when_expr_12.get(), loopDepth); };
		static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 13;
															#line 867 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*>(static_cast<ValidateForcePurgeActor*>(this)));
															#line 8992 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1cont1(Optional<GetGranuleAssignmentsReply> const& assignments,int loopDepth) 
	{
															#line 870 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (assignments.present())
															#line 9014 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 871 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			for( auto& it : assignments.get().assignments ) {
															#line 872 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (purgeRange.intersects(it.range))
															#line 9020 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 873 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (BGV_DEBUG)
															#line 9024 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 874 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						fmt::print("BW {0} still has range [{1} - {2})\n", blobWorkers[i].id().toString(), it.range.begin.printable(), it.range.end.printable());
															#line 9028 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					}
															#line 879 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					anyRangesLeft = true;
															#line 9032 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 883 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 9040 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 884 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV mapping check failed to reach BW {0}\n", blobWorkers[i].id().toString());
															#line 9044 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 887 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			anyRangesLeft = true;
															#line 9048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 864 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 9052 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1cont1(Optional<GetGranuleAssignmentsReply> && assignments,int loopDepth) 
	{
															#line 870 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (assignments.present())
															#line 9061 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 871 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			for( auto& it : assignments.get().assignments ) {
															#line 872 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (purgeRange.intersects(it.range))
															#line 9067 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 873 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (BGV_DEBUG)
															#line 9071 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 874 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						fmt::print("BW {0} still has range [{1} - {2})\n", blobWorkers[i].id().toString(), it.range.begin.printable(), it.range.end.printable());
															#line 9075 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					}
															#line 879 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					anyRangesLeft = true;
															#line 9079 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 883 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 9087 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 884 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV mapping check failed to reach BW {0}\n", blobWorkers[i].id().toString());
															#line 9091 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 887 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			anyRangesLeft = true;
															#line 9095 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 864 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		i++;
															#line 9099 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1when1(Optional<GetGranuleAssignmentsReply> const& assignments,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont1loopBody1cont1(assignments, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1loopBody1when1(Optional<GetGranuleAssignmentsReply> && assignments,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont1loopBody1cont1(std::move(assignments), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*,Optional<GetGranuleAssignmentsReply> const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*,Optional<GetGranuleAssignmentsReply> && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state > 0) static_cast<ValidateForcePurgeActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateForcePurgeActor*>(this)->ActorCallback< ValidateForcePurgeActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ValidateForcePurgeActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ValidateForcePurgeActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), 13);

	}
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange purgeRange;
															#line 734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool strictMetadataCheck;
															#line 744 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 786 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int i;
															#line 787 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t filesChecked;
															#line 789 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange granuleRange;
															#line 790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version historyVersion;
															#line 791 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	UID granuleId;
															#line 792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	GranuleFiles oldFiles;
															#line 810 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int fileIdx;
															#line 815 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Reference<BackupContainerFileSystem> bstore;
															#line 857 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool anyRangesLeft;
															#line 858 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	std::vector<BlobWorkerInterface> blobWorkers;
															#line 9302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via validateForcePurge()
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class ValidateForcePurgeActor final : public Actor<Void>, public ActorCallback< ValidateForcePurgeActor, 0, Void >, public ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >, public ActorCallback< ValidateForcePurgeActor, 2, Void >, public ActorCallback< ValidateForcePurgeActor, 3, Version >, public ActorCallback< ValidateForcePurgeActor, 4, Void >, public ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >, public ActorCallback< ValidateForcePurgeActor, 6, bool >, public ActorCallback< ValidateForcePurgeActor, 7, Void >, public ActorCallback< ValidateForcePurgeActor, 8, Void >, public ActorCallback< ValidateForcePurgeActor, 9, Void >, public ActorCallback< ValidateForcePurgeActor, 10, bool >, public ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >, public ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >, public ActorCallback< ValidateForcePurgeActor, 13, Void >, public FastAllocated<ValidateForcePurgeActor>, public ValidateForcePurgeActorState<ValidateForcePurgeActor> {
															#line 9307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<ValidateForcePurgeActor>::operator new;
	using FastAllocated<ValidateForcePurgeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10104775264967073536UL, 7141401435323282688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateForcePurgeActor, 0, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >;
friend struct ActorCallback< ValidateForcePurgeActor, 2, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 3, Version >;
friend struct ActorCallback< ValidateForcePurgeActor, 4, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >;
friend struct ActorCallback< ValidateForcePurgeActor, 6, bool >;
friend struct ActorCallback< ValidateForcePurgeActor, 7, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 8, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 9, Void >;
friend struct ActorCallback< ValidateForcePurgeActor, 10, bool >;
friend struct ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >;
friend struct ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >;
friend struct ActorCallback< ValidateForcePurgeActor, 13, Void >;
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	ValidateForcePurgeActor(Database const& cx,BlobGranuleVerifierWorkload* const& self,KeyRange const& purgeRange) 
															#line 9337 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateForcePurgeActorState<ValidateForcePurgeActor>(cx, self, purgeRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateForcePurge", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12524115166371418368UL, 16492883785153674240UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateForcePurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateForcePurge");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateForcePurge", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 1, ForcedPurgeState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 5, GranuleFiles >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 10, bool >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 11, std::vector<BlobWorkerInterface> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 12, Optional<GetGranuleAssignmentsReply> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ValidateForcePurgeActor, 13, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<Void> validateForcePurge( Database const& cx, BlobGranuleVerifierWorkload* const& self, KeyRange const& purgeRange ) {
															#line 732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<Void>(new ValidateForcePurgeActor(cx, self, purgeRange));
															#line 9382 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 903 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	// Check database against blob granules. This is especially important because during chaos phase this can error, and
	// initAtEnd doesn't get data checked otherwise
																#line 9389 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via checkAllData()
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class CheckAllDataActor>
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckAllDataActorState {
															#line 9395 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckAllDataActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self),
															#line 907 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   tr(cx),
															#line 908 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   keyRange(normalKeys),
															#line 909 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   gotEOS(false),
															#line 910 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   totalRows(0)
															#line 9412 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("checkAllData", reinterpret_cast<unsigned long>(this));

	}
	~CheckAllDataActorState() 
	{
		fdb_probe_actor_destroy("checkAllData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 911 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			;
															#line 9427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAllDataActorState();
		static_cast<CheckAllDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 969 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 9450 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 970 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Final data check complete, checked {1} rows\n", self->clientId, totalRows);
															#line 9454 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 973 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<CheckAllDataActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckAllDataActorState(); static_cast<CheckAllDataActor*>(this)->destroy(); return 0; }
															#line 9458 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<CheckAllDataActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckAllDataActorState();
		static_cast<CheckAllDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 912 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output = RangeResult();
															#line 913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = invalidVersion;
															#line 914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		bufferedBytes = 0;
															#line 9481 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		try {
															#line 916 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 916 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<CheckAllDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9487 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAllDataActor*>(this)->actor_wait_state = 1;
															#line 916 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAllDataActor, 0, Version >*>(static_cast<CheckAllDataActor*>(this)));
															#line 9492 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 943 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!output.empty())
															#line 9520 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 944 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			rangeToCheck = KeyRangeRef(keyRange.begin, keyAfter(output.back().key));
															#line 9524 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			try {
															#line 946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> __when_expr_3 = readFromBlob(cx, self->bstore, rangeToCheck, 0, readVersion);
															#line 946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<CheckAllDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
				static_cast<CheckAllDataActor*>(this)->actor_wait_state = 4;
															#line 946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*>(static_cast<CheckAllDataActor*>(this)));
															#line 9535 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 933 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 9556 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 934 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 936 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 9564 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 937 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				gotEOS = true;
															#line 9568 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
			else
			{
															#line 939 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 939 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<CheckAllDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9577 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<CheckAllDataActor*>(this)->actor_wait_state = 3;
															#line 939 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckAllDataActor, 2, Void >*>(static_cast<CheckAllDataActor*>(this)));
															#line 9582 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& ver,int loopDepth) 
	{
															#line 917 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = ver;
															#line 919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		stream = tr.getRangeStream(results, keyRange, GetRangeLimits());
															#line 922 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 9604 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && ver,int loopDepth) 
	{
															#line 917 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = ver;
															#line 919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		stream = tr.getRangeStream(results, keyRange, GetRangeLimits());
															#line 922 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 9619 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ver, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state > 0) static_cast<CheckAllDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllDataActor*>(this)->ActorCallback< CheckAllDataActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAllDataActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 923 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		auto __when_expr_1 = results.getFuture();
															#line 9716 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<Standalone<RangeResultRef>>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<Standalone<RangeResultRef>>>::value, "invalid type");
															#line 923 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<CheckAllDataActor*>(this)->actor_wait_state = 2;
															#line 923 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*>(static_cast<CheckAllDataActor*>(this)));
															#line 9725 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<RangeResultRef> const& res,int loopDepth) 
	{
															#line 924 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output.arena().dependsOn(res.arena());
															#line 925 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output.append(output.arena(), res.begin(), res.size());
															#line 926 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		bufferedBytes += res.expectedSize();
															#line 928 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (bufferedBytes >= 10 * SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES)
															#line 9753 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<RangeResultRef> && res,int loopDepth) 
	{
															#line 924 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output.arena().dependsOn(res.arena());
															#line 925 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		output.append(output.arena(), res.begin(), res.size());
															#line 926 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		bufferedBytes += res.expectedSize();
															#line 928 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (bufferedBytes >= 10 * SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES)
															#line 9771 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<RangeResultRef> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<RangeResultRef> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state > 0) static_cast<CheckAllDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllDataActor*>(this)->ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state > 0) static_cast<CheckAllDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllDataActor*>(this)->ActorCallback< CheckAllDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckAllDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 964 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (gotEOS)
															#line 9964 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 961 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalRows += output.size();
															#line 962 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		keyRange = KeyRangeRef(rangeToCheck.end, keyRange.end);
															#line 9978 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 952 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG && e.code() == error_code_blob_granule_transaction_too_old)
															#line 9988 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 953 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("CheckAllData got BG_TTO for [{0} - {1}) @ {2}\n", rangeToCheck.begin.printable(), rangeToCheck.end.printable(), readVersion);
															#line 9992 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 958 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(e.code() != error_code_blob_granule_transaction_too_old);
															#line 959 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& blob,int loopDepth) 
	{
															#line 948 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!compareFDBAndBlob(output, blob, rangeToCheck, readVersion, BGV_DEBUG))
															#line 10012 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 949 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckAllDataActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckAllDataActorState(); static_cast<CheckAllDataActor*>(this)->destroy(); return 0; }
															#line 10016 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckAllDataActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckAllDataActorState();
			static_cast<CheckAllDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && blob,int loopDepth) 
	{
															#line 948 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!compareFDBAndBlob(output, blob, rangeToCheck, readVersion, BGV_DEBUG))
															#line 10030 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 949 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (!static_cast<CheckAllDataActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckAllDataActorState(); static_cast<CheckAllDataActor*>(this)->destroy(); return 0; }
															#line 10034 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			new (&static_cast<CheckAllDataActor*>(this)->SAV< bool >::value()) bool(false);
			this->~CheckAllDataActorState();
			static_cast<CheckAllDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& blob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(blob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && blob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(blob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckAllDataActor*>(this)->actor_wait_state > 0) static_cast<CheckAllDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAllDataActor*>(this)->ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> const& value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> && value) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 907 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 908 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange keyRange;
															#line 909 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool gotEOS;
															#line 910 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t totalRows;
															#line 912 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	RangeResult output;
															#line 913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version readVersion;
															#line 914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t bufferedBytes;
															#line 919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	PromiseStream<Standalone<RangeResultRef>> results;
															#line 920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Future<Void> stream;
															#line 944 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange rangeToCheck;
															#line 10156 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via checkAllData()
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class CheckAllDataActor final : public Actor<bool>, public ActorCallback< CheckAllDataActor, 0, Version >, public ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >, public ActorCallback< CheckAllDataActor, 2, Void >, public ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >, public FastAllocated<CheckAllDataActor>, public CheckAllDataActorState<CheckAllDataActor> {
															#line 10161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<CheckAllDataActor>::operator new;
	using FastAllocated<CheckAllDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(133387532682041600UL, 17429959895120770816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAllDataActor, 0, Version >;
friend struct ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >;
friend struct ActorCallback< CheckAllDataActor, 2, Void >;
friend struct ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >;
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	CheckAllDataActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 10181 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<bool>(),
		   CheckAllDataActorState<CheckAllDataActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAllData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18384931372181308416UL, 10676451418926174208UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAllDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAllData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAllData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAllDataActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< CheckAllDataActor, 1, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckAllDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckAllDataActor, 3, std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<bool> checkAllData( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<bool>(new CheckAllDataActor(cx, self));
															#line 10216 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 975 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

																#line 10221 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
template <class _checkActor>
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class _checkActorState {
															#line 10227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	_checkActorState(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		 : cx(cx),
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		   self(self)
															#line 10236 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 977 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->triggerSummaryComplete.canBeSet())
															#line 10251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 978 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				self->triggerSummaryComplete.send(Void());
															#line 10255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 980 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			tr = Transaction(cx);
															#line 981 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->doForcePurge)
															#line 10261 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 982 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (self->startedForcePurge)
															#line 10265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 983 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (self->forcePurgeKey.present())
															#line 10269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					{
															#line 984 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						StrictFuture<Void> __when_expr_0 = self->validateForcePurge(cx, self, normalKeys);
															#line 984 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10275 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 984 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 10280 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont4(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
			else
			{
															#line 990 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 10297 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 991 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					StrictFuture<Version> __when_expr_1 = self->doGrv(&tr);
															#line 991 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 991 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Version >*>(static_cast<_checkActor*>(this)));
															#line 10308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont7(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1007 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->doSetup && self->initAtEnd)
															#line 10337 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1008 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->setUpBlobRange(cx);
															#line 1008 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10343 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 1008 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, Void >*>(static_cast<_checkActor*>(this)));
															#line 10348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 988 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 10368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Version const& latestPurgeVersion,int loopDepth) 
	{
															#line 992 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 10473 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 993 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} before final availability check\n", self->clientId, latestPurgeVersion);
															#line 10477 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 997 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_2 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 997 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10483 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 997 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Key >*>(static_cast<_checkActor*>(this)));
															#line 10488 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Version && latestPurgeVersion,int loopDepth) 
	{
															#line 992 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 10497 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 993 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} before final availability check\n", self->clientId, latestPurgeVersion);
															#line 10501 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 997 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_2 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 997 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10507 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 997 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Key >*>(static_cast<_checkActor*>(this)));
															#line 10512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(Version const& latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont8(latestPurgeVersion, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Version && latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(latestPurgeVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont9(Key const& purgeKey,int loopDepth) 
	{
															#line 998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10598 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 10603 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Key && purgeKey,int loopDepth) 
	{
															#line 998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_3 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10614 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 10619 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont9(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 999 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 10703 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1000 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest before final availability check complete\n", self->clientId);
															#line 10707 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1002 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purges++;
															#line 10711 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 999 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 10720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1000 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest before final availability check complete\n", self->clientId);
															#line 10724 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1002 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purges++;
															#line 10728 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 1011 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Version> __when_expr_5 = self->doGrv(&tr);
															#line 1011 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10814 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 1011 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, Version >*>(static_cast<_checkActor*>(this)));
															#line 10819 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _checkActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1012 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		startReadVersion = readVersion;
															#line 1013 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		checks = 0;
															#line 1015 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		last = KeyRange();
															#line 1016 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		availabilityPassed = true;
															#line 1018 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		allRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 1020 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		rangeFetcher = self->findGranules(cx, self);
															#line 1021 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		;
															#line 10927 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Version const& __readVersion,int loopDepth) 
	{
															#line 1011 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = __readVersion;
															#line 10936 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Version && __readVersion,int loopDepth) 
	{
		readVersion = std::move(__readVersion);
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 5, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _checkActor, 5, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 1044 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		rangeFetcher.cancel();
															#line 1046 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		allRanges = self->granuleRanges.get();
															#line 1047 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalSnapshotSizes = 0;
															#line 1048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalChunks = 0;
															#line 1049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		RangeForbody1cont12cont2Iterator0 = std::begin(allRanges);
															#line 11023 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1(int loopDepth) 
	{
															#line 1023 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!self->granuleRanges.get().empty())
															#line 11039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1024 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			bool haveAll = true;
															#line 1025 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->granuleRanges.get().front().begin != normalKeys.begin || self->granuleRanges.get().back().end != normalKeys.end)
															#line 11045 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1027 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				haveAll = false;
															#line 11049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 1029 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			for(int i = 0;haveAll && i < self->granuleRanges.get().size() - 1;i++) {
															#line 1030 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (self->granuleRanges.get()[i].end != self->granuleRanges.get()[i + 1].begin)
															#line 11055 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				{
															#line 1031 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
					haveAll = false;
															#line 11059 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				}
			}
															#line 1034 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (haveAll)
															#line 11064 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
				return a_body1cont12cont1break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 1038 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 11071 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("Waiting to get granule ranges for check\n");
															#line 11075 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1041 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->granuleRanges.onChange();
															#line 1041 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11081 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont1loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 7;
															#line 1041 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 6, Void >*>(static_cast<_checkActor*>(this)));
															#line 11086 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _checkActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 1113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->granuleSizeCheck && totalSnapshotSizes >= 1000000 && totalChunks > 4)
															#line 11195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1114 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			double ratio = (1.0 * totalSnapshotSizes) / (totalChunks * SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES);
															#line 1115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (0.5 > ratio || ratio > 1.5)
															#line 11201 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("ERROR: Incorrect snapshot file size:\n  Chunks: {0}\n  Ratio: {1}\n  Avg File Size: " "{2}\n  Expected Size: {3}\n", totalChunks, ratio, totalSnapshotSizes / totalChunks, SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES);
															#line 11205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 1123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(0.5 <= ratio && ratio <= 1.5);
															#line 11209 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1126 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG && startReadVersion != readVersion)
															#line 11213 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("Availability check updated read version from {0} to {1}\n", startReadVersion, readVersion);
															#line 11217 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		checkFeedCleanupFuture = Future<Void>();
															#line 1132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->clientId == 0)
															#line 11223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			checkFeedCleanupFuture = checkFeedCleanup(cx, BGV_DEBUG);
															#line 11227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		else
		{
															#line 1135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			checkFeedCleanupFuture = Future<Void>(Void());
															#line 11233 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<bool> __when_expr_11 = self->checkAllData(cx, self);
															#line 1138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 12;
															#line 1138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 11, bool >*>(static_cast<_checkActor*>(this)));
															#line 11244 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1(int loopDepth) 
	{
															#line 1049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!(RangeForbody1cont12cont2Iterator0 != std::end(allRanges)))
															#line 11260 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
			return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		auto& range = *RangeForbody1cont12cont2Iterator0;
															#line 11266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1050 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			r = range;
															#line 1051 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 11272 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1052 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BGV {0}) Final availability check [{1} - {2}) @ {3}\n", self->clientId, r.begin.printable(), r.end.printable(), readVersion);
															#line 11276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
			try {
															#line 1060 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				;
															#line 11281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = a_body1cont12cont2loopBody1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont12cont2loopBody1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont12cont2loopBody1Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont12cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont1(int loopDepth) 
	{
															#line 1049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		++RangeForbody1cont12cont2Iterator0;
															#line 11310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont12cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1090 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 11326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1091 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 11330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 1093 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 11334 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
				return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 1096 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (BGV_DEBUG)
															#line 11340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1097 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				fmt::print("BG Verifier failed final availability check for [{0} - {1}) @ {2} with error {3}. Last " "Success=[{4} - {5})\n", r.begin.printable(), r.end.printable(), readVersion, e.name(), last.begin.printable(), last.end.printable());
															#line 11344 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			}
															#line 1106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			availabilityPassed = false;
															#line 11348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont2loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1062 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Standalone<VectorRef<BlobGranuleChunkRef>>> __when_expr_7 = tr.readBlobGranules(r, 0, readVersion);
															#line 1062 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont12cont2loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont2loopBody1loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 8;
															#line 1062 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*>(static_cast<_checkActor*>(this)));
															#line 11384 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont2loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1079 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (e.code() == error_code_blob_granule_transaction_too_old)
															#line 11419 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1080 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(1.0);
															#line 1080 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11425 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 9;
															#line 1080 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 8, Void >*>(static_cast<_checkActor*>(this)));
															#line 11430 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1085 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Void> __when_expr_10 = tr.onError(e);
															#line 1085 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11439 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1loopBody1Catch1when2(__when_expr_10.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 11;
															#line 1085 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 10, Void >*>(static_cast<_checkActor*>(this)));
															#line 11444 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1cont2(Standalone<VectorRef<BlobGranuleChunkRef>> const& chunks,int loopDepth) 
	{
															#line 1064 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(chunks.size() > 0);
															#line 1065 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		last = chunks.back().keyRange;
															#line 1066 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		checks += chunks.size();
															#line 1068 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalChunks += chunks.size();
															#line 1069 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : chunks ) {
															#line 1070 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(it.snapshotFile.present());
															#line 1071 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			totalSnapshotSizes += it.snapshotFile.get().length;
															#line 11472 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		return a_body1cont12cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1cont2(Standalone<VectorRef<BlobGranuleChunkRef>> && chunks,int loopDepth) 
	{
															#line 1064 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(chunks.size() > 0);
															#line 1065 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		last = chunks.back().keyRange;
															#line 1066 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		checks += chunks.size();
															#line 1068 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		totalChunks += chunks.size();
															#line 1069 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		for( auto& it : chunks ) {
															#line 1070 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(it.snapshotFile.present());
															#line 1071 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			totalSnapshotSizes += it.snapshotFile.get().length;
															#line 11494 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		return a_body1cont12cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> const& chunks,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1cont2(chunks, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> && chunks,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1cont2(std::move(chunks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 1081 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.reset();
															#line 1082 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Version> __when_expr_9 = self->doGrv(&tr);
															#line 1082 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11589 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 10;
															#line 1082 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 9, Version >*>(static_cast<_checkActor*>(this)));
															#line 11594 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 1081 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		tr.reset();
															#line 1082 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Version> __when_expr_9 = self->doGrv(&tr);
															#line 1082 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11607 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 10;
															#line 1082 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 9, Version >*>(static_cast<_checkActor*>(this)));
															#line 11612 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _checkActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _checkActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont3(Version const& rv,int loopDepth) 
	{
															#line 1083 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = rv;
															#line 11696 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont3(Version && rv,int loopDepth) 
	{
															#line 1083 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		readVersion = rv;
															#line 11705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont3(rv, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont3(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 9, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _checkActor, 9, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _checkActor, 9, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _checkActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont2loopBody1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _checkActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont12cont2loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont4(int loopDepth) 
	{
															#line 1139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_12 = checkFeedCleanupFuture;
															#line 1139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont4when1(__when_expr_12.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 13;
															#line 1139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 12, Void >*>(static_cast<_checkActor*>(this)));
															#line 11896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont3when1(bool const& __dataPassed,int loopDepth) 
	{
															#line 1138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		dataPassed = __dataPassed;
															#line 11905 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(bool && __dataPassed,int loopDepth) 
	{
		dataPassed = std::move(__dataPassed);
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 11, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 11, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _checkActor, 11, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _checkActor, 11, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont12cont10(Void const& _,int loopDepth) 
	{
															#line 1141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		result = availabilityPassed && dataPassed && self->mismatches == 0 && (checks > 0) && (self->timeTravelTooOld == 0);
															#line 1143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("Blob Granule Verifier {0} {1}:\n", self->clientId, result ? "passed" : "failed");
															#line 1144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} successful final granule checks\n", checks);
															#line 1145 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} failed final granule checks\n", availabilityPassed ? 0 : 1);
															#line 1146 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} mismatches\n", self->mismatches);
															#line 1147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} time travel too old\n", self->timeTravelTooOld);
															#line 1148 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} errors\n", self->errors);
															#line 1149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} initial reads\n", self->initialReads);
															#line 1150 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} time travel reads\n", self->timeTravelReads);
															#line 1151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} rows\n", self->rowsRead);
															#line 1152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} bytes\n", self->bytesRead);
															#line 1153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} purges\n", self->purges);
															#line 1154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} final data check\n", dataPassed ? "passed" : "failed");
															#line 1157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		TraceEvent("BlobGranuleVerifierChecked").detail("Result", result);
															#line 1160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(result);
															#line 1162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->doForcePurge)
															#line 12014 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(!self->startedForcePurge);
															#line 1165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_13 = self->doGrv(&tr);
															#line 1165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12022 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont10when1(__when_expr_13.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 14;
															#line 1165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 13, Version >*>(static_cast<_checkActor*>(this)));
															#line 12027 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 12034 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Version> __when_expr_17 = self->doGrv(&tr);
															#line 1175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12040 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont12cont10when2(__when_expr_17.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 18;
															#line 1175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 17, Version >*>(static_cast<_checkActor*>(this)));
															#line 12045 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont12cont10cont7(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont12cont10(Void && _,int loopDepth) 
	{
															#line 1141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		result = availabilityPassed && dataPassed && self->mismatches == 0 && (checks > 0) && (self->timeTravelTooOld == 0);
															#line 1143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("Blob Granule Verifier {0} {1}:\n", self->clientId, result ? "passed" : "failed");
															#line 1144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} successful final granule checks\n", checks);
															#line 1145 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} failed final granule checks\n", availabilityPassed ? 0 : 1);
															#line 1146 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} mismatches\n", self->mismatches);
															#line 1147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} time travel too old\n", self->timeTravelTooOld);
															#line 1148 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} errors\n", self->errors);
															#line 1149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} initial reads\n", self->initialReads);
															#line 1150 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} time travel reads\n", self->timeTravelReads);
															#line 1151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} rows\n", self->rowsRead);
															#line 1152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} bytes\n", self->bytesRead);
															#line 1153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} purges\n", self->purges);
															#line 1154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		fmt::print("  {} final data check\n", dataPassed ? "passed" : "failed");
															#line 1157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		TraceEvent("BlobGranuleVerifierChecked").detail("Result", result);
															#line 1160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(result);
															#line 1162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->doForcePurge)
															#line 12090 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			ASSERT(!self->startedForcePurge);
															#line 1165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_13 = self->doGrv(&tr);
															#line 1165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12098 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont10when1(__when_expr_13.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 14;
															#line 1165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 13, Version >*>(static_cast<_checkActor*>(this)));
															#line 12103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 12110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			{
															#line 1175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				StrictFuture<Version> __when_expr_17 = self->doGrv(&tr);
															#line 1175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont12cont10when2(__when_expr_17.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 18;
															#line 1175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
				__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 17, Version >*>(static_cast<_checkActor*>(this)));
															#line 12121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont12cont10cont7(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont12cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _checkActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _checkActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont12cont10cont1(int loopDepth) 
	{
															#line 1188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->clientId == 0 && SERVER_KNOBS->BG_ENABLE_MERGING && self->clearAndMergeCheck)
															#line 12211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			CODE_PROBE(true, "BGV clearing database and awaiting merge", probe::decoration::rare);
															#line 1190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Void> __when_expr_20 = clearAndAwaitMerge(cx, normalKeys);
															#line 1190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12219 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont12cont10cont1when1(__when_expr_20.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 21;
															#line 1190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 20, Void >*>(static_cast<_checkActor*>(this)));
															#line 12224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont10cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont10cont2(Version const& rv,int loopDepth) 
	{
															#line 1166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->forcePurgeVersion = rv;
															#line 1167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purgedDataToCheck.clear();
															#line 1168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_14 = self->loadGranuleMetadataBeforeForcePurge(cx, self);
															#line 1168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12244 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont10cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 15;
															#line 1168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 14, Void >*>(static_cast<_checkActor*>(this)));
															#line 12249 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont2(Version && rv,int loopDepth) 
	{
															#line 1166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->forcePurgeVersion = rv;
															#line 1167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->purgedDataToCheck.clear();
															#line 1168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_14 = self->loadGranuleMetadataBeforeForcePurge(cx, self);
															#line 1168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12264 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont10cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 15;
															#line 1168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 14, Void >*>(static_cast<_checkActor*>(this)));
															#line 12269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 13, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 13, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _checkActor, 13, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _checkActor, 13, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont12cont10cont3(Void const& _,int loopDepth) 
	{
															#line 1169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_15 = cx->purgeBlobGranules(normalKeys, self->forcePurgeVersion, {}, true);
															#line 1169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12355 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont12cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 16;
															#line 1169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 15, Key >*>(static_cast<_checkActor*>(this)));
															#line 12360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont3(Void && _,int loopDepth) 
	{
															#line 1169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_15 = cx->purgeBlobGranules(normalKeys, self->forcePurgeVersion, {}, true);
															#line 1169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12371 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont12cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 16;
															#line 1169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 15, Key >*>(static_cast<_checkActor*>(this)));
															#line 12376 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _checkActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _checkActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont12cont10cont4(Key const& purgeKey,int loopDepth) 
	{
															#line 1170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->forcePurgeKey = purgeKey;
															#line 1171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_16 = self->validateForcePurge(cx, self, normalKeys);
															#line 1171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12464 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont12cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 17;
															#line 1171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 16, Void >*>(static_cast<_checkActor*>(this)));
															#line 12469 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont4(Key && purgeKey,int loopDepth) 
	{
															#line 1170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		self->forcePurgeKey = purgeKey;
															#line 1171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_16 = self->validateForcePurge(cx, self, normalKeys);
															#line 1171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12482 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont12cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 17;
															#line 1171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 16, Void >*>(static_cast<_checkActor*>(this)));
															#line 12487 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont3when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont4(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont3when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont4(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 15, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 15, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont12cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _checkActor, 15, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont12cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _checkActor, 15, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont12cont10cont5(Void const& _,int loopDepth) 
	{
															#line 1173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 12571 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont5(Void && _,int loopDepth) 
	{
															#line 1173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 12583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont12cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _checkActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont12cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _checkActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont12cont10cont7(int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont8(Version const& latestPurgeVersion,int loopDepth) 
	{
															#line 1176 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 12676 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1177 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} after final availability check, waiting\n", self->clientId, latestPurgeVersion);
															#line 12680 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1181 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_18 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 1181 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12686 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont12cont10cont8when1(__when_expr_18.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 19;
															#line 1181 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 18, Key >*>(static_cast<_checkActor*>(this)));
															#line 12691 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont8(Version && latestPurgeVersion,int loopDepth) 
	{
															#line 1176 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 12700 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1177 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} after final availability check, waiting\n", self->clientId, latestPurgeVersion);
															#line 12704 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1181 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_18 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 1181 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12710 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont12cont10cont8when1(__when_expr_18.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 19;
															#line 1181 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 18, Key >*>(static_cast<_checkActor*>(this)));
															#line 12715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10when2(Version const& latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont8(latestPurgeVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10when2(Version && latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont8(std::move(latestPurgeVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 17, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 17, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont12cont10when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _checkActor, 17, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont12cont10when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _checkActor, 17, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont12cont10cont9(Key const& purgeKey,int loopDepth) 
	{
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_19 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12801 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont12cont10cont9when1(__when_expr_19.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 20;
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 19, Void >*>(static_cast<_checkActor*>(this)));
															#line 12806 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont9(Key && purgeKey,int loopDepth) 
	{
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_19 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12817 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont12cont10cont9when1(__when_expr_19.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 20;
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 19, Void >*>(static_cast<_checkActor*>(this)));
															#line 12822 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont8when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont9(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont8when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont9(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 18, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 18, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont12cont10cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _checkActor, 18, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont12cont10cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _checkActor, 18, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont12cont10cont11(Void const& _,int loopDepth) 
	{
															#line 1183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 12906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest after final availability check complete\n", self->clientId);
															#line 12910 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont11(Void && _,int loopDepth) 
	{
															#line 1183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 12920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest after final availability check complete\n", self->clientId);
															#line 12924 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont12cont10cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _checkActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont12cont10cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _checkActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont12cont10cont12(int loopDepth) 
	{
															#line 1219 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13009 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) check waiting on summarizer to complete\n", self->clientId);
															#line 13013 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_25 = self->summaryClient && self->forceFlushingClient;
															#line 1224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13019 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont12cont10cont12when1(__when_expr_25.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 26;
															#line 1224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 25, Void >*>(static_cast<_checkActor*>(this)));
															#line 13024 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13(Void const& _,int loopDepth) 
	{
															#line 1192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 13033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_21 = self->doGrv(&tr);
															#line 1193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont12cont10cont13when1(__when_expr_21.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 22;
															#line 1193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 21, Version >*>(static_cast<_checkActor*>(this)));
															#line 13044 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont10cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont10cont13(Void && _,int loopDepth) 
	{
															#line 1192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (self->enablePurging && self->purgeAtLatest && deterministicRandom()->coinflip())
															#line 13058 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			StrictFuture<Version> __when_expr_21 = self->doGrv(&tr);
															#line 1193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13064 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont12cont10cont13when1(__when_expr_21.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 22;
															#line 1193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 21, Version >*>(static_cast<_checkActor*>(this)));
															#line 13069 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont10cont13cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< _checkActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< _checkActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont12cont10cont13cont1(int loopDepth) 
	{
															#line 1206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1207 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Checking data after merge\n", self->clientId);
															#line 13162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<bool> __when_expr_24 = self->checkAllData(cx, self);
															#line 1211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont12cont10cont13cont1when1(__when_expr_24.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 25;
															#line 1211 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 24, bool >*>(static_cast<_checkActor*>(this)));
															#line 13173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont2(Version const& latestPurgeVersion,int loopDepth) 
	{
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} after clearAndAwaitMerge, waiting\n", self->clientId, latestPurgeVersion);
															#line 13186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_22 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 1199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont12cont10cont13cont2when1(__when_expr_22.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 23;
															#line 1199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 22, Key >*>(static_cast<_checkActor*>(this)));
															#line 13197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont2(Version && latestPurgeVersion,int loopDepth) 
	{
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purging Latest @ {1} after clearAndAwaitMerge, waiting\n", self->clientId, latestPurgeVersion);
															#line 13210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Key> __when_expr_22 = cx->purgeBlobGranules(normalKeys, latestPurgeVersion, {}, false);
															#line 1199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13216 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont12cont10cont13cont2when1(__when_expr_22.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 23;
															#line 1199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 22, Key >*>(static_cast<_checkActor*>(this)));
															#line 13221 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13when1(Version const& latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont2(latestPurgeVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13when1(Version && latestPurgeVersion,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont2(std::move(latestPurgeVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 21, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 21, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont12cont10cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< _checkActor, 21, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont12cont10cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< _checkActor, 21, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont12cont10cont13cont3(Key const& purgeKey,int loopDepth) 
	{
															#line 1200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_23 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 1200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont12cont10cont13cont3when1(__when_expr_23.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 24;
															#line 1200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 23, Void >*>(static_cast<_checkActor*>(this)));
															#line 13312 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont3(Key && purgeKey,int loopDepth) 
	{
															#line 1200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		StrictFuture<Void> __when_expr_23 = cx->waitPurgeGranulesComplete(purgeKey);
															#line 1200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13323 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont12cont10cont13cont3when1(__when_expr_23.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 24;
															#line 1200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 23, Void >*>(static_cast<_checkActor*>(this)));
															#line 13328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont2when1(Key const& purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont3(purgeKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont2when1(Key && purgeKey,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont3(std::move(purgeKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 22, Key >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 22, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont12cont10cont13cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< _checkActor, 22, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont12cont10cont13cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< _checkActor, 22, Key >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont12cont10cont13cont5(Void const& _,int loopDepth) 
	{
															#line 1201 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13412 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1202 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest after clearAndAwaitMerge complete\n", self->clientId);
															#line 13416 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont5(Void && _,int loopDepth) 
	{
															#line 1201 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13426 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1202 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Purged Latest after clearAndAwaitMerge complete\n", self->clientId);
															#line 13430 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 23, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont12cont10cont13cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< _checkActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont12cont10cont13cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< _checkActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont12cont10cont13cont8(bool const& dataCheckAfterMerge,int loopDepth) 
	{
															#line 1212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(dataCheckAfterMerge);
															#line 1214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13517 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Checked data after merge\n", self->clientId);
															#line 13521 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont8(bool && dataCheckAfterMerge,int loopDepth) 
	{
															#line 1212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		ASSERT(dataCheckAfterMerge);
															#line 1214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13533 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) Checked data after merge\n", self->clientId);
															#line 13537 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont10cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont1when1(bool const& dataCheckAfterMerge,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont8(dataCheckAfterMerge, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont13cont1when1(bool && dataCheckAfterMerge,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont13cont8(std::move(dataCheckAfterMerge), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 24, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 24, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont10cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< _checkActor, 24, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont10cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< _checkActor, 24, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont12cont10cont12cont1(Void const& _,int loopDepth) 
	{
															#line 1226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13622 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) check done\n", self->clientId);
															#line 13626 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(result); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 13630 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont12cont1(Void && _,int loopDepth) 
	{
															#line 1226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (BGV_DEBUG)
															#line 13642 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		{
															#line 1227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
			fmt::print("BGV {0}) check done\n", self->clientId);
															#line 13646 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		}
															#line 1230 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(result); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 13650 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 25, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont10cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< _checkActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont10cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< _checkActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 25);

	}
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Database cx;
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	BlobGranuleVerifierWorkload* self;
															#line 980 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Transaction tr;
															#line 1011 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version readVersion;
															#line 1012 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Version startReadVersion;
															#line 1013 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int checks;
															#line 1015 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange last;
															#line 1016 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool availabilityPassed;
															#line 1018 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> allRanges;
															#line 1020 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Future<Void> rangeFetcher;
															#line 1047 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t totalSnapshotSizes;
															#line 1048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	int64_t totalChunks;
															#line 1049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	decltype(std::begin(std::declval<Standalone<VectorRef<KeyRangeRef>>>())) RangeForbody1cont12cont2Iterator0;
															#line 1050 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	KeyRange r;
															#line 1131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	Future<Void> checkFeedCleanupFuture;
															#line 1138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool dataPassed;
															#line 1141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	bool result;
															#line 13767 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Version >, public ActorCallback< _checkActor, 2, Key >, public ActorCallback< _checkActor, 3, Void >, public ActorCallback< _checkActor, 4, Void >, public ActorCallback< _checkActor, 5, Version >, public ActorCallback< _checkActor, 6, Void >, public ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >, public ActorCallback< _checkActor, 8, Void >, public ActorCallback< _checkActor, 9, Version >, public ActorCallback< _checkActor, 10, Void >, public ActorCallback< _checkActor, 11, bool >, public ActorCallback< _checkActor, 12, Void >, public ActorCallback< _checkActor, 13, Version >, public ActorCallback< _checkActor, 14, Void >, public ActorCallback< _checkActor, 15, Key >, public ActorCallback< _checkActor, 16, Void >, public ActorCallback< _checkActor, 17, Version >, public ActorCallback< _checkActor, 18, Key >, public ActorCallback< _checkActor, 19, Void >, public ActorCallback< _checkActor, 20, Void >, public ActorCallback< _checkActor, 21, Version >, public ActorCallback< _checkActor, 22, Key >, public ActorCallback< _checkActor, 23, Void >, public ActorCallback< _checkActor, 24, bool >, public ActorCallback< _checkActor, 25, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 13772 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13990802440805034240UL, 4336330533222404864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Version >;
friend struct ActorCallback< _checkActor, 2, Key >;
friend struct ActorCallback< _checkActor, 3, Void >;
friend struct ActorCallback< _checkActor, 4, Void >;
friend struct ActorCallback< _checkActor, 5, Version >;
friend struct ActorCallback< _checkActor, 6, Void >;
friend struct ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >;
friend struct ActorCallback< _checkActor, 8, Void >;
friend struct ActorCallback< _checkActor, 9, Version >;
friend struct ActorCallback< _checkActor, 10, Void >;
friend struct ActorCallback< _checkActor, 11, bool >;
friend struct ActorCallback< _checkActor, 12, Void >;
friend struct ActorCallback< _checkActor, 13, Version >;
friend struct ActorCallback< _checkActor, 14, Void >;
friend struct ActorCallback< _checkActor, 15, Key >;
friend struct ActorCallback< _checkActor, 16, Void >;
friend struct ActorCallback< _checkActor, 17, Version >;
friend struct ActorCallback< _checkActor, 18, Key >;
friend struct ActorCallback< _checkActor, 19, Void >;
friend struct ActorCallback< _checkActor, 20, Void >;
friend struct ActorCallback< _checkActor, 21, Version >;
friend struct ActorCallback< _checkActor, 22, Key >;
friend struct ActorCallback< _checkActor, 23, Void >;
friend struct ActorCallback< _checkActor, 24, bool >;
friend struct ActorCallback< _checkActor, 25, Void >;
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	_checkActor(Database const& cx,BlobGranuleVerifierWorkload* const& self) 
															#line 13814 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _checkActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _checkActor, 5, Version >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _checkActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _checkActor, 7, Standalone<VectorRef<BlobGranuleChunkRef>> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _checkActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _checkActor, 9, Version >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _checkActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _checkActor, 11, bool >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _checkActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _checkActor, 13, Version >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _checkActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _checkActor, 15, Key >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _checkActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _checkActor, 17, Version >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _checkActor, 18, Key >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _checkActor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< _checkActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< _checkActor, 21, Version >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< _checkActor, 22, Key >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< _checkActor, 23, Void >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< _checkActor, 24, bool >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< _checkActor, 25, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, BlobGranuleVerifierWorkload* const& self ) {
															#line 976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 13871 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleVerifier.actor.g.cpp"
}

#line 1232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleVerifier.actor.cpp"

	Future<bool> check(Database const& cx) override {
		if (clientId == 0 || (!doForcePurge && !purgeAtLatest)) {
			return _check(cx, this);
		}
		return true;
	}
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<BlobGranuleVerifierWorkload> BlobGranuleVerifierWorkloadFactory;
