#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
/*
 * SimpleConfigConsumer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/ConfigBroadcastInterface.h"
#include "fdbserver/SimpleConfigConsumer.h"
#include "flow/actorcompiler.h" // must be last include

class SimpleConfigConsumerImpl {
	ConfigFollowerInterface cfi;
	Version lastSeenVersion{ 0 };
	double pollingInterval;
	Optional<double> compactionInterval;

	UID id;
	CounterCollection cc;
	Counter compactRequest;
	Counter successfulChangeRequest;
	Counter failedChangeRequest;
	Counter snapshotRequest;
	Future<Void> logger;

																#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
// This generated class is to be used only via compactor()
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
template <class CompactorActor>
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
class CompactorActorState {
															#line 47 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
public:
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	CompactorActorState(SimpleConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		 : self(self),
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		   broadcaster(broadcaster)
															#line 56 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
	{
		fdb_probe_actor_create("compactor", reinterpret_cast<unsigned long>(this));

	}
	~CompactorActorState() 
	{
		fdb_probe_actor_destroy("compactor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (!self->compactionInterval.present())
															#line 71 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			{
															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Never();
															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CompactorActor*>(this)->actor_wait_state = 1;
															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 0, Void >*>(static_cast<CompactorActor*>(this)));
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CompactorActorState();
		static_cast<CompactorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 44 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		;
															#line 110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (!static_cast<CompactorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompactorActorState(); static_cast<CompactorActor*>(this)->destroy(); return 0; }
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		new (&static_cast<CompactorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CompactorActorState();
		static_cast<CompactorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (!static_cast<CompactorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CompactorActorState(); static_cast<CompactorActor*>(this)->destroy(); return 0; }
															#line 131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		new (&static_cast<CompactorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CompactorActorState();
		static_cast<CompactorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CompactorActor*>(this)->actor_wait_state > 0) static_cast<CompactorActor*>(this)->actor_wait_state = 0;
		static_cast<CompactorActor*>(this)->ActorCallback< CompactorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CompactorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CompactorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 45 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		compactionVersion = self->lastSeenVersion;
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(self->compactionInterval.get());
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CompactorActor*>(this)->actor_wait_state = 2;
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 1, Void >*>(static_cast<CompactorActor*>(this)));
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (self->cfi.hostname.present())
															#line 243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		{
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = retryGetReplyFromHostname(ConfigFollowerCompactRequest{ compactionVersion }, self->cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_COMPACT);
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 249 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CompactorActor*>(this)->actor_wait_state = 3;
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 2, Void >*>(static_cast<CompactorActor*>(this)));
															#line 254 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->cfi.compact.getReply(ConfigFollowerCompactRequest{ compactionVersion });
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
			static_cast<CompactorActor*>(this)->actor_wait_state = 4;
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 3, Void >*>(static_cast<CompactorActor*>(this)));
															#line 268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (self->cfi.hostname.present())
															#line 278 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		{
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = retryGetReplyFromHostname(ConfigFollowerCompactRequest{ compactionVersion }, self->cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_COMPACT);
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 284 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CompactorActor*>(this)->actor_wait_state = 3;
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 2, Void >*>(static_cast<CompactorActor*>(this)));
															#line 289 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->cfi.compact.getReply(ConfigFollowerCompactRequest{ compactionVersion });
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<CompactorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 298 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
			static_cast<CompactorActor*>(this)->actor_wait_state = 4;
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CompactorActor, 3, Void >*>(static_cast<CompactorActor*>(this)));
															#line 303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CompactorActor*>(this)->actor_wait_state > 0) static_cast<CompactorActor*>(this)->actor_wait_state = 0;
		static_cast<CompactorActor*>(this)->ActorCallback< CompactorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CompactorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CompactorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 54 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		++self->compactRequest;
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		broadcaster->compact(compactionVersion);
															#line 390 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CompactorActor*>(this)->actor_wait_state > 0) static_cast<CompactorActor*>(this)->actor_wait_state = 0;
		static_cast<CompactorActor*>(this)->ActorCallback< CompactorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CompactorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CompactorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CompactorActor*>(this)->actor_wait_state > 0) static_cast<CompactorActor*>(this)->actor_wait_state = 0;
		static_cast<CompactorActor*>(this)->ActorCallback< CompactorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CompactorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CompactorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CompactorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	SimpleConfigConsumerImpl* self;
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	ConfigBroadcaster* broadcaster;
															#line 45 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	Version compactionVersion;
															#line 575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
};
// This generated class is to be used only via compactor()
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
class CompactorActor final : public Actor<Void>, public ActorCallback< CompactorActor, 0, Void >, public ActorCallback< CompactorActor, 1, Void >, public ActorCallback< CompactorActor, 2, Void >, public ActorCallback< CompactorActor, 3, Void >, public FastAllocated<CompactorActor>, public CompactorActorState<CompactorActor> {
															#line 580 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
public:
	using FastAllocated<CompactorActor>::operator new;
	using FastAllocated<CompactorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4335612107935413760UL, 1922321981360809472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CompactorActor, 0, Void >;
friend struct ActorCallback< CompactorActor, 1, Void >;
friend struct ActorCallback< CompactorActor, 2, Void >;
friend struct ActorCallback< CompactorActor, 3, Void >;
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	CompactorActor(SimpleConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 600 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		 : Actor<Void>(),
		   CompactorActorState<CompactorActor>(self, broadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("compactor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18397928151659365120UL, 1246258962531721984UL);
		ActorExecutionContextHelper __helper(static_cast<CompactorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("compactor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("compactor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CompactorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CompactorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CompactorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CompactorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Void> compactor( SimpleConfigConsumerImpl* const& self, ConfigBroadcaster* const& broadcaster ) {
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	return Future<Void>(new CompactorActor(self, broadcaster));
															#line 635 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
}

#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"

																#line 640 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
// This generated class is to be used only via getCommittedVersion()
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
template <class GetCommittedVersionActor>
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
class GetCommittedVersionActorState {
															#line 646 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
public:
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	GetCommittedVersionActorState(SimpleConfigConsumerImpl* const& self) 
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		 : self(self),
															#line 60 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		   committedVersionReply()
															#line 655 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
	{
		fdb_probe_actor_create("getCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("getCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (self->cfi.hostname.present())
															#line 670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			{
															#line 62 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(committedVersionReply, retryGetReplyFromHostname(ConfigFollowerGetCommittedVersionRequest{}, self->cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_GETCOMMITTEDVERSION));
															#line 62 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 676 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 62 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActor, 0, Void >*>(static_cast<GetCommittedVersionActor*>(this)));
															#line 681 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_1 = store(committedVersionReply, self->cfi.getCommittedVersion.getReply(ConfigFollowerGetCommittedVersionRequest{}));
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 690 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCommittedVersionActor, 1, Void >*>(static_cast<GetCommittedVersionActor*>(this)));
															#line 695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommittedVersionActorState();
		static_cast<GetCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (!static_cast<GetCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(committedVersionReply.lastCommitted); this->~GetCommittedVersionActorState(); static_cast<GetCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 719 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		new (&static_cast<GetCommittedVersionActor*>(this)->SAV< Version >::value()) Version(committedVersionReply.lastCommitted);
		this->~GetCommittedVersionActorState();
		static_cast<GetCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActor*>(this)->ActorCallback< GetCommittedVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommittedVersionActor*>(this)->ActorCallback< GetCommittedVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCommittedVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCommittedVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	SimpleConfigConsumerImpl* self;
															#line 60 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	ConfigFollowerGetCommittedVersionReply committedVersionReply;
															#line 905 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
};
// This generated class is to be used only via getCommittedVersion()
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
class GetCommittedVersionActor final : public Actor<Version>, public ActorCallback< GetCommittedVersionActor, 0, Void >, public ActorCallback< GetCommittedVersionActor, 1, Void >, public FastAllocated<GetCommittedVersionActor>, public GetCommittedVersionActorState<GetCommittedVersionActor> {
															#line 910 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
public:
	using FastAllocated<GetCommittedVersionActor>::operator new;
	using FastAllocated<GetCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(733094343693600512UL, 18087523529379235072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommittedVersionActor, 0, Void >;
friend struct ActorCallback< GetCommittedVersionActor, 1, Void >;
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	GetCommittedVersionActor(SimpleConfigConsumerImpl* const& self) 
															#line 928 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		 : Actor<Version>(),
		   GetCommittedVersionActorState<GetCommittedVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8917899261172622336UL, 9522656687011892480UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCommittedVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Version> getCommittedVersion( SimpleConfigConsumerImpl* const& self ) {
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	return Future<Version>(new GetCommittedVersionActor(self));
															#line 961 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
}

#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"

																#line 966 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
// This generated class is to be used only via fetchChanges()
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
template <class FetchChangesActor>
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
class FetchChangesActorState {
															#line 972 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
public:
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	FetchChangesActorState(SimpleConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		 : self(self),
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		   broadcaster(broadcaster)
															#line 981 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchChanges", reinterpret_cast<unsigned long>(this));

	}
	~FetchChangesActorState() 
	{
		fdb_probe_actor_destroy("fetchChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getSnapshotAndChanges(self, broadcaster);
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchChangesActor*>(this)->actor_wait_state = 1;
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 0, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 1003 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchChangesActorState();
		static_cast<FetchChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		;
															#line 1026 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		;
															#line 1035 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Version> __when_expr_1 = getCommittedVersion(self);
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1129 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FetchChangesActor*>(this)->actor_wait_state = 2;
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 1, Version >*>(static_cast<FetchChangesActor*>(this)));
															#line 1134 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			++self->failedChangeRequest;
															#line 111 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (e.code() == error_code_version_already_compacted)
															#line 1158 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			{
															#line 112 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				CODE_PROBE(true, "SimpleConfigConsumer get version_already_compacted error");
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_5 = getSnapshotAndChanges(self, broadcaster);
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<FetchChangesActor*>(this)->actor_wait_state = 6;
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 5, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 1171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 114 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				if (e.code() == error_code_broken_promise)
															#line 1178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				{
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
					CODE_PROBE(true, "SimpleConfigConsumer::fetchChanges retrying on broken promise");
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				}
				else
				{
															#line 117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				}
				loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 78 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		ASSERT_GE(committedVersion, self->lastSeenVersion);
															#line 79 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (committedVersion > self->lastSeenVersion)
															#line 1207 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		{
															#line 80 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			reply = ConfigFollowerGetChangesReply();
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (self->cfi.hostname.present())
															#line 1213 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			{
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_2 = store(reply, retryGetReplyFromHostname( ConfigFollowerGetChangesRequest{ self->lastSeenVersion, committedVersion }, self->cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_GETCHANGES));
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1219 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
				static_cast<FetchChangesActor*>(this)->actor_wait_state = 3;
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 2, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 1224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				StrictFuture<Void> __when_expr_3 = store(reply, self->cfi.getChanges.getReply( ConfigFollowerGetChangesRequest{ self->lastSeenVersion, committedVersion }));
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1233 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
				static_cast<FetchChangesActor*>(this)->actor_wait_state = 4;
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 3, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 1238 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version const& __committedVersion,int loopDepth) 
	{
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		committedVersion = __committedVersion;
															#line 1253 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version && __committedVersion,int loopDepth) 
	{
		committedVersion = std::move(__committedVersion);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delayJittered(self->pollingInterval);
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1334 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FetchChangesActor*>(this)->actor_wait_state = 5;
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FetchChangesActor, 4, Void >*>(static_cast<FetchChangesActor*>(this)));
															#line 1339 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		++self->successfulChangeRequest;
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		for( const auto& versionedMutation : reply.changes ) {
															#line 94 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			TraceEvent te(SevDebug, "ConsumerFetchedMutation", self->id);
															#line 95 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			te.detail("Version", versionedMutation.version) .detail("ConfigClass", versionedMutation.mutation.getConfigClass()) .detail("KnobName", versionedMutation.mutation.getKnobName());
															#line 98 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (versionedMutation.mutation.isSet())
															#line 1356 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			{
															#line 99 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				te.detail("Op", "Set") .detail("KnobValue", versionedMutation.mutation.getValue().toString());
															#line 1360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			}
			else
			{
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
				te.detail("Op", "Clear");
															#line 1366 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			}
		}
															#line 105 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		self->lastSeenVersion = committedVersion;
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		broadcaster->applyChanges(reply.changes, committedVersion, reply.annotations, { self->cfi });
															#line 1373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont11cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FetchChangesActor*>(this)->actor_wait_state > 0) static_cast<FetchChangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchChangesActor*>(this)->ActorCallback< FetchChangesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FetchChangesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FetchChangesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	SimpleConfigConsumerImpl* self;
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	ConfigBroadcaster* broadcaster;
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	Version committedVersion;
															#line 80 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	ConfigFollowerGetChangesReply reply;
															#line 1753 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
};
// This generated class is to be used only via fetchChanges()
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
class FetchChangesActor final : public Actor<Void>, public ActorCallback< FetchChangesActor, 0, Void >, public ActorCallback< FetchChangesActor, 1, Version >, public ActorCallback< FetchChangesActor, 2, Void >, public ActorCallback< FetchChangesActor, 3, Void >, public ActorCallback< FetchChangesActor, 4, Void >, public ActorCallback< FetchChangesActor, 5, Void >, public FastAllocated<FetchChangesActor>, public FetchChangesActorState<FetchChangesActor> {
															#line 1758 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
public:
	using FastAllocated<FetchChangesActor>::operator new;
	using FastAllocated<FetchChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4441617929267799552UL, 1533892596198400768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchChangesActor, 0, Void >;
friend struct ActorCallback< FetchChangesActor, 1, Version >;
friend struct ActorCallback< FetchChangesActor, 2, Void >;
friend struct ActorCallback< FetchChangesActor, 3, Void >;
friend struct ActorCallback< FetchChangesActor, 4, Void >;
friend struct ActorCallback< FetchChangesActor, 5, Void >;
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	FetchChangesActor(SimpleConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 1780 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		 : Actor<Void>(),
		   FetchChangesActorState<FetchChangesActor>(self, broadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(247041911323866368UL, 15046812401233103616UL);
		ActorExecutionContextHelper __helper(static_cast<FetchChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchChangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchChangesActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FetchChangesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FetchChangesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FetchChangesActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FetchChangesActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Void> fetchChanges( SimpleConfigConsumerImpl* const& self, ConfigBroadcaster* const& broadcaster ) {
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	return Future<Void>(new FetchChangesActor(self, broadcaster));
															#line 1817 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
}

#line 122 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"

																#line 1822 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
// This generated class is to be used only via getSnapshotAndChanges()
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
template <class GetSnapshotAndChangesActor>
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
class GetSnapshotAndChangesActorState {
															#line 1828 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
public:
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	GetSnapshotAndChangesActorState(SimpleConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		 : self(self),
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		   broadcaster(broadcaster)
															#line 1837 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
	{
		fdb_probe_actor_create("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this));

	}
	~GetSnapshotAndChangesActorState() 
	{
		fdb_probe_actor_destroy("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getCommittedVersion(self);
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1854 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 1;
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 0, Version >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 1859 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSnapshotAndChangesActorState();
		static_cast<GetSnapshotAndChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 125 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		reply = ConfigFollowerGetSnapshotAndChangesReply();
															#line 126 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (self->cfi.hostname.present())
															#line 1884 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		{
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(reply, retryGetReplyFromHostname(ConfigFollowerGetSnapshotAndChangesRequest{ committedVersion }, self->cfi.hostname.get(), WLTOKEN_CONFIGFOLLOWER_GETSNAPSHOTANDCHANGES));
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1890 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 2;
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 1, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 1895 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(reply, self->cfi.getSnapshotAndChanges.getReply( ConfigFollowerGetSnapshotAndChangesRequest{ committedVersion }));
															#line 132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1904 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 3;
															#line 132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotAndChangesActor, 2, Void >*>(static_cast<GetSnapshotAndChangesActor*>(this)));
															#line 1909 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Version const& __committedVersion,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		committedVersion = __committedVersion;
															#line 1919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __committedVersion,int loopDepth) 
	{
		committedVersion = std::move(__committedVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 136 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		++self->snapshotRequest;
															#line 137 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		TraceEvent(SevDebug, "ConfigConsumerGotSnapshotAndChanges", self->id) .detail("SnapshotVersion", reply.snapshotVersion) .detail("SnapshotSize", reply.snapshot.size()) .detail("ChangesVersion", committedVersion) .detail("ChangesSize", reply.changes.size()) .detail("AnnotationsSize", reply.annotations.size());
															#line 143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		ASSERT_GE(committedVersion, self->lastSeenVersion);
															#line 144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		self->lastSeenVersion = committedVersion;
															#line 145 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		broadcaster->applySnapshotAndChanges(std::move(reply.snapshot), reply.snapshotVersion, reply.changes, committedVersion, reply.annotations, { self->cfi }, committedVersion);
															#line 152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
		if (!static_cast<GetSnapshotAndChangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetSnapshotAndChangesActorState(); static_cast<GetSnapshotAndChangesActor*>(this)->destroy(); return 0; }
															#line 2008 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		new (&static_cast<GetSnapshotAndChangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetSnapshotAndChangesActorState();
		static_cast<GetSnapshotAndChangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotAndChangesActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotAndChangesActor*>(this)->ActorCallback< GetSnapshotAndChangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSnapshotAndChangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSnapshotAndChangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	SimpleConfigConsumerImpl* self;
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	ConfigBroadcaster* broadcaster;
															#line 124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	Version committedVersion;
															#line 125 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	ConfigFollowerGetSnapshotAndChangesReply reply;
															#line 2198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
};
// This generated class is to be used only via getSnapshotAndChanges()
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
class GetSnapshotAndChangesActor final : public Actor<Void>, public ActorCallback< GetSnapshotAndChangesActor, 0, Version >, public ActorCallback< GetSnapshotAndChangesActor, 1, Void >, public ActorCallback< GetSnapshotAndChangesActor, 2, Void >, public FastAllocated<GetSnapshotAndChangesActor>, public GetSnapshotAndChangesActorState<GetSnapshotAndChangesActor> {
															#line 2203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
public:
	using FastAllocated<GetSnapshotAndChangesActor>::operator new;
	using FastAllocated<GetSnapshotAndChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12305560501354794752UL, 18138878512236384512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSnapshotAndChangesActor, 0, Version >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 1, Void >;
friend struct ActorCallback< GetSnapshotAndChangesActor, 2, Void >;
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	GetSnapshotAndChangesActor(SimpleConfigConsumerImpl* const& self,ConfigBroadcaster* const& broadcaster) 
															#line 2222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
		 : Actor<Void>(),
		   GetSnapshotAndChangesActorState<GetSnapshotAndChangesActor>(self, broadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3162109226205960192UL, 17975068368386092544UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotAndChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSnapshotAndChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSnapshotAndChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSnapshotAndChangesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
[[nodiscard]] static Future<Void> getSnapshotAndChanges( SimpleConfigConsumerImpl* const& self, ConfigBroadcaster* const& broadcaster ) {
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"
	return Future<Void>(new GetSnapshotAndChangesActor(self, broadcaster));
															#line 2256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/SimpleConfigConsumer.actor.g.cpp"
}

#line 154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/SimpleConfigConsumer.actor.cpp"

	static ConfigFollowerInterface getConfigFollowerInterface(ConfigFollowerInterface const& cfi) { return cfi; }

	static ConfigFollowerInterface getConfigFollowerInterface(ServerCoordinators const& coordinators) {
		return ConfigFollowerInterface(coordinators.configServers[0]);
	}

public:
	template <class ConfigSource>
	SimpleConfigConsumerImpl(ConfigSource const& configSource,
	                         double const& pollingInterval,
	                         Optional<double> const& compactionInterval)
	  : pollingInterval(pollingInterval), compactionInterval(compactionInterval),
	    id(deterministicRandom()->randomUniqueID()), cc("ConfigConsumer"), compactRequest("CompactRequest", cc),
	    successfulChangeRequest("SuccessfulChangeRequest", cc), failedChangeRequest("FailedChangeRequest", cc),
	    snapshotRequest("SnapshotRequest", cc) {
		cfi = getConfigFollowerInterface(configSource);
		logger = cc.traceCounters(
		    "ConfigConsumerMetrics", id, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "ConfigConsumerMetrics");
	}

	Future<Void> consume(ConfigBroadcaster& broadcaster) {
		return fetchChanges(this, &broadcaster) || compactor(this, &broadcaster);
	}

	UID getID() const { return id; }
};

SimpleConfigConsumer::SimpleConfigConsumer(ConfigFollowerInterface const& cfi,
                                           double pollingInterval,
                                           Optional<double> compactionInterval)
  : impl(PImpl<SimpleConfigConsumerImpl>::create(cfi, pollingInterval, compactionInterval)) {}

SimpleConfigConsumer::SimpleConfigConsumer(ServerCoordinators const& coordinators,
                                           double pollingInterval,
                                           Optional<double> compactionInterval)
  : impl(PImpl<SimpleConfigConsumerImpl>::create(coordinators, pollingInterval, compactionInterval)) {}

Future<Void> SimpleConfigConsumer::readSnapshot(ConfigBroadcaster& broadcaster) {
	ASSERT(false);
	return Void();
}

Future<Void> SimpleConfigConsumer::consume(ConfigBroadcaster& broadcaster) {
	return impl->consume(broadcaster);
}

SimpleConfigConsumer::~SimpleConfigConsumer() = default;

UID SimpleConfigConsumer::getID() const {
	return impl->getID();
}
