#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
/*
 *ServerCheckpoint.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/ServerCheckpoint.actor.h"
#include "fdbserver/RocksDBCheckpointUtils.actor.h"

#include "flow/actorcompiler.h" // has to be last include

ICheckpointReader* newCheckpointReader(const CheckpointMetaData& checkpoint,
                                       const CheckpointAsKeyValues checkpointAsKeyValues,
                                       UID logID) {
	const CheckpointFormat format = checkpoint.getFormat();
	if (format == DataMoveRocksCF || format == RocksDB) {
		return newRocksDBCheckpointReader(checkpoint, checkpointAsKeyValues, logID);
	} else {
		throw not_implemented();
	}

	return nullptr;
}

															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteCheckpoint()
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
template <class DeleteCheckpointActor>
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
class DeleteCheckpointActorState {
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
public:
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	DeleteCheckpointActorState(CheckpointMetaData const& checkpoint) 
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		 : checkpoint(checkpoint)
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	~DeleteCheckpointActorState() 
	{
		fdb_probe_actor_destroy("deleteCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::FetchKeys);
															#line 40 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			if (static_cast<DeleteCheckpointActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteCheckpointActor*>(this)->actor_wait_state = 1;
															#line 40 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointActor, 0, Void >*>(static_cast<DeleteCheckpointActor*>(this)));
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteCheckpointActorState();
		static_cast<DeleteCheckpointActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		const CheckpointFormat format = checkpoint.getFormat();
															#line 42 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		if (format == DataMoveRocksCF || format == RocksDB || format == RocksDBKeyValues)
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		{
															#line 43 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			if (!checkpoint.dir.empty())
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			{
															#line 44 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				platform::eraseDirectoryRecursive(checkpoint.dir);
															#line 110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			}
			else
			{
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				TraceEvent(SevWarn, "CheckpointDirNotFound").detail("Checkpoint", checkpoint.toString());
															#line 116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			}
		}
		else
		{
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			return a_body1Catch1(not_implemented(), loopDepth);
															#line 123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		}
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		if (!static_cast<DeleteCheckpointActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointActorState(); static_cast<DeleteCheckpointActor*>(this)->destroy(); return 0; }
															#line 127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		new (&static_cast<DeleteCheckpointActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteCheckpointActorState();
		static_cast<DeleteCheckpointActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		const CheckpointFormat format = checkpoint.getFormat();
															#line 42 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		if (format == DataMoveRocksCF || format == RocksDB || format == RocksDBKeyValues)
															#line 141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		{
															#line 43 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			if (!checkpoint.dir.empty())
															#line 145 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			{
															#line 44 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				platform::eraseDirectoryRecursive(checkpoint.dir);
															#line 149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			}
			else
			{
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				TraceEvent(SevWarn, "CheckpointDirNotFound").detail("Checkpoint", checkpoint.toString());
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			}
		}
		else
		{
															#line 49 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			return a_body1Catch1(not_implemented(), loopDepth);
															#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		}
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		if (!static_cast<DeleteCheckpointActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointActorState(); static_cast<DeleteCheckpointActor*>(this)->destroy(); return 0; }
															#line 166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		new (&static_cast<DeleteCheckpointActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteCheckpointActorState();
		static_cast<DeleteCheckpointActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteCheckpointActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointActor*>(this)->ActorCallback< DeleteCheckpointActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	CheckpointMetaData checkpoint;
															#line 251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
};
// This generated class is to be used only via deleteCheckpoint()
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
class DeleteCheckpointActor final : public Actor<Void>, public ActorCallback< DeleteCheckpointActor, 0, Void >, public FastAllocated<DeleteCheckpointActor>, public DeleteCheckpointActorState<DeleteCheckpointActor> {
															#line 256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
public:
	using FastAllocated<DeleteCheckpointActor>::operator new;
	using FastAllocated<DeleteCheckpointActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8468499468894892032UL, 9841934809390308864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteCheckpointActor, 0, Void >;
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	DeleteCheckpointActor(CheckpointMetaData const& checkpoint) 
															#line 273 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteCheckpointActorState<DeleteCheckpointActor>(checkpoint),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteCheckpoint", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11841755051909556480UL, 14511688759102073344UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteCheckpoint");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteCheckpoint", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteCheckpointActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
[[nodiscard]] Future<Void> deleteCheckpoint( CheckpointMetaData const& checkpoint ) {
															#line 39 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	return Future<Void>(new DeleteCheckpointActor(checkpoint));
															#line 306 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
}

#line 54 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"

															#line 311 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchCheckpoint()
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
template <class FetchCheckpointActor>
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
class FetchCheckpointActorState {
															#line 318 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
public:
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	FetchCheckpointActorState(Database const& cx,CheckpointMetaData const& initialState,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		 : cx(cx),
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		   initialState(initialState),
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		   dir(dir),
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		   cFun(cFun)
															#line 331 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	~FetchCheckpointActorState() 
	{
		fdb_probe_actor_destroy("fetchCheckpoint", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			TraceEvent("FetchCheckpointBegin", initialState.checkpointID).detail("CheckpointMetaData", initialState.toString());
															#line 61 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			result = CheckpointMetaData();
															#line 62 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			const CheckpointFormat format = initialState.getFormat();
															#line 63 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			ASSERT(format != RocksDBKeyValues);
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			if (format == DataMoveRocksCF || format == RocksDB)
															#line 354 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			{
															#line 65 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(result, fetchRocksDBCheckpoint(cx, initialState, dir, cFun));
															#line 65 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				if (static_cast<FetchCheckpointActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FetchCheckpointActor*>(this)->actor_wait_state = 1;
															#line 65 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointActor, 0, Void >*>(static_cast<FetchCheckpointActor*>(this)));
															#line 365 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				return a_body1Catch1(not_implemented(), loopDepth);
															#line 372 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchCheckpointActorState();
		static_cast<FetchCheckpointActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		TraceEvent("FetchCheckpointEnd", initialState.checkpointID).detail("CheckpointMetaData", result.toString());
															#line 71 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		if (!static_cast<FetchCheckpointActor*>(this)->SAV<CheckpointMetaData>::futures) { (void)(result); this->~FetchCheckpointActorState(); static_cast<FetchCheckpointActor*>(this)->destroy(); return 0; }
															#line 397 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		new (&static_cast<FetchCheckpointActor*>(this)->SAV< CheckpointMetaData >::value()) CheckpointMetaData(std::move(result)); // state_var_RVO
		this->~FetchCheckpointActorState();
		static_cast<FetchCheckpointActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchCheckpointActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointActor*>(this)->ActorCallback< FetchCheckpointActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchCheckpointActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpoint", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpoint", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	Database cx;
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	CheckpointMetaData initialState;
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	std::string dir;
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	std::function<Future<Void>(const CheckpointMetaData&)> cFun;
															#line 61 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	CheckpointMetaData result;
															#line 502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
};
// This generated class is to be used only via fetchCheckpoint()
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
class FetchCheckpointActor final : public Actor<CheckpointMetaData>, public ActorCallback< FetchCheckpointActor, 0, Void >, public FastAllocated<FetchCheckpointActor>, public FetchCheckpointActorState<FetchCheckpointActor> {
															#line 507 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
public:
	using FastAllocated<FetchCheckpointActor>::operator new;
	using FastAllocated<FetchCheckpointActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10862188882528921344UL, 18429615752608145408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<CheckpointMetaData>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchCheckpointActor, 0, Void >;
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	FetchCheckpointActor(Database const& cx,CheckpointMetaData const& initialState,std::string const& dir,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 524 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		 : Actor<CheckpointMetaData>(),
		   FetchCheckpointActorState<FetchCheckpointActor>(cx, initialState, dir, cFun),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchCheckpoint", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13851676885700331520UL, 10932528335754862848UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchCheckpoint");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchCheckpoint", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchCheckpointActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
[[nodiscard]] Future<CheckpointMetaData> fetchCheckpoint( Database const& cx, CheckpointMetaData const& initialState, std::string const& dir, std::function<Future<Void>(const CheckpointMetaData&)> const& cFun ) {
															#line 55 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	return Future<CheckpointMetaData>(new FetchCheckpointActor(cx, initialState, dir, cFun));
															#line 557 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
}

#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"

															#line 562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchCheckpointRanges()
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
template <class FetchCheckpointRangesActor>
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
class FetchCheckpointRangesActorState {
															#line 569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
public:
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	FetchCheckpointRangesActorState(Database const& cx,CheckpointMetaData const& initialState,std::string const& dir,std::vector<KeyRange> const& ranges,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		 : cx(cx),
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		   initialState(initialState),
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		   dir(dir),
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		   ranges(ranges),
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		   cFun(cFun)
															#line 584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this));

	}
	~FetchCheckpointRangesActorState() 
	{
		fdb_probe_actor_destroy("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 79 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			TraceEvent(SevDebug, "FetchCheckpointRangesBegin", initialState.checkpointID) .detail("CheckpointMetaData", initialState.toString()) .detail("Ranges", describe(ranges));
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			ASSERT(!ranges.empty());
															#line 84 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			result = CheckpointMetaData();
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			const CheckpointFormat format = initialState.getFormat();
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			if (format != RocksDBKeyValues)
															#line 607 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			{
															#line 87 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				if (format != DataMoveRocksCF)
															#line 611 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
				{
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
					return a_body1Catch1(not_implemented(), loopDepth);
															#line 615 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
				}
															#line 90 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				initialState.setFormat(RocksDBKeyValues);
															#line 91 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				initialState.ranges = ranges;
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				initialState.dir = dir;
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
				initialState.setSerializedCheckpoint( ObjectWriter::toValue(RocksDBCheckpointKeyValues(ranges), IncludeVersion()));
															#line 625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			}
															#line 97 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(result, fetchRocksDBCheckpoint(cx, initialState, dir, cFun));
															#line 97 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			if (static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 631 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchCheckpointRangesActor, 0, Void >*>(static_cast<FetchCheckpointRangesActor*>(this)));
															#line 636 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchCheckpointRangesActorState();
		static_cast<FetchCheckpointRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		TraceEvent(SevDebug, "FetchCheckpointRangesEnd", initialState.checkpointID) .detail("CheckpointMetaData", result.toString()) .detail("Ranges", describe(ranges));
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		if (!static_cast<FetchCheckpointRangesActor*>(this)->SAV<CheckpointMetaData>::futures) { (void)(result); this->~FetchCheckpointRangesActorState(); static_cast<FetchCheckpointRangesActor*>(this)->destroy(); return 0; }
															#line 661 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		new (&static_cast<FetchCheckpointRangesActor*>(this)->SAV< CheckpointMetaData >::value()) CheckpointMetaData(std::move(result)); // state_var_RVO
		this->~FetchCheckpointRangesActorState();
		static_cast<FetchCheckpointRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		TraceEvent(SevDebug, "FetchCheckpointRangesEnd", initialState.checkpointID) .detail("CheckpointMetaData", result.toString()) .detail("Ranges", describe(ranges));
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
		if (!static_cast<FetchCheckpointRangesActor*>(this)->SAV<CheckpointMetaData>::futures) { (void)(result); this->~FetchCheckpointRangesActorState(); static_cast<FetchCheckpointRangesActor*>(this)->destroy(); return 0; }
															#line 675 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		new (&static_cast<FetchCheckpointRangesActor*>(this)->SAV< CheckpointMetaData >::value()) CheckpointMetaData(std::move(result)); // state_var_RVO
		this->~FetchCheckpointRangesActorState();
		static_cast<FetchCheckpointRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state > 0) static_cast<FetchCheckpointRangesActor*>(this)->actor_wait_state = 0;
		static_cast<FetchCheckpointRangesActor*>(this)->ActorCallback< FetchCheckpointRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchCheckpointRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchCheckpointRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	Database cx;
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	CheckpointMetaData initialState;
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	std::string dir;
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	std::function<Future<Void>(const CheckpointMetaData&)> cFun;
															#line 84 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	CheckpointMetaData result;
															#line 770 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
};
// This generated class is to be used only via fetchCheckpointRanges()
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
class FetchCheckpointRangesActor final : public Actor<CheckpointMetaData>, public ActorCallback< FetchCheckpointRangesActor, 0, Void >, public FastAllocated<FetchCheckpointRangesActor>, public FetchCheckpointRangesActorState<FetchCheckpointRangesActor> {
															#line 775 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
public:
	using FastAllocated<FetchCheckpointRangesActor>::operator new;
	using FastAllocated<FetchCheckpointRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16456584693181774080UL, 1096392877796072192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<CheckpointMetaData>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchCheckpointRangesActor, 0, Void >;
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	FetchCheckpointRangesActor(Database const& cx,CheckpointMetaData const& initialState,std::string const& dir,std::vector<KeyRange> const& ranges,std::function<Future<Void>(const CheckpointMetaData&)> const& cFun) 
															#line 792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
		 : Actor<CheckpointMetaData>(),
		   FetchCheckpointRangesActorState<FetchCheckpointRangesActor>(cx, initialState, dir, ranges, cFun),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12796336108807475200UL, 12433676179912681984UL);
		ActorExecutionContextHelper __helper(static_cast<FetchCheckpointRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchCheckpointRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchCheckpointRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchCheckpointRangesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
[[nodiscard]] Future<CheckpointMetaData> fetchCheckpointRanges( Database const& cx, CheckpointMetaData const& initialState, std::string const& dir, std::vector<KeyRange> const& ranges, std::function<Future<Void>(const CheckpointMetaData&)> const& cFun ) {
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"
	return Future<CheckpointMetaData>(new FetchCheckpointRangesActor(cx, initialState, dir, ranges, cFun));
															#line 825 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbserver/ServerCheckpoint.actor.g.cpp"
}

#line 104 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbserver/ServerCheckpoint.actor.cpp"

std::string serverCheckpointDir(const std::string& baseDir, const UID& checkpointId) {
	return joinPath(baseDir, checkpointId.toString());
}

std::string fetchedCheckpointDir(const std::string& baseDir, const UID& checkpointId) {
	return joinPath(baseDir, UID(checkpointId.first(), deterministicRandom()->randomUInt64()).toString());
}
