#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
/*
 * NativeAPI.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"

#include <algorithm>
#include <cstdio>
#include <iterator>
#include <limits>
#include <memory>
#include <regex>
#include <string>
#include <unordered_set>
#include <tuple>
#include <utility>
#include <vector>

#include "boost/algorithm/string.hpp"

#include "fdbclient/Knobs.h"
#include "flow/CodeProbe.h"
#include "fmt/format.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/MultiInterface.h"
#include "fdbrpc/TenantInfo.h"

#include "fdbclient/ActorLineageProfiler.h"
#include "fdbclient/AnnotateActor.h"
#include "fdbclient/Atomic.h"
#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/BlobGranuleRequest.actor.h"
#include "fdbclient/ClusterInterface.h"
#include "fdbclient/ClusterConnectionFile.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/IKnobCollection.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NameLineage.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/ParallelStream.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantSpecialKeys.actor.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbclient/versions.h"
#include "fdbrpc/WellKnownEndpoints.h"
#include "fdbrpc/LoadBalance.h"
#include "fdbrpc/Net2FileSystem.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/sim_validation.h"
#include "flow/Arena.h"
#include "flow/ActorCollection.h"
#include "flow/DeterministicRandom.h"
#include "flow/Error.h"
#include "flow/FastRef.h"
#include "flow/GetSourceVersion.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/ProtocolVersion.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/Knobs.h"
#include "flow/Platform.h"
#include "flow/SystemMonitor.h"
#include "flow/TLSConfig.actor.h"
#include "fdbclient/Tracing.h"
#include "flow/UnitTest.h"
#include "flow/network.h"
#include "flow/serialize.h"

#ifdef ADDRESS_SANITIZER
#include <sanitizer/lsan_interface.h>
#endif

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#undef min
#undef max
#else
#include <time.h>
#endif
#include "flow/actorcompiler.h" // This must be the last #include.

template class RequestStream<OpenDatabaseRequest, false>;
template struct NetNotifiedQueue<OpenDatabaseRequest, false>;

namespace {

TransactionLineageCollector transactionLineageCollector;
NameLineageCollector nameLineageCollector;

} // namespace

FDB_BOOLEAN_PARAM(TransactionRecordLogInfo);

// Whether or not a request should include the tenant name
FDB_BOOLEAN_PARAM(UseTenant);

// Whether a blob granule request is a request for the mapping to read, or a request to get granule boundaries
FDB_BOOLEAN_PARAM(JustGranules);

NetworkOptions networkOptions;
TLSConfig tlsConfig(TLSEndpointType::CLIENT);

// The default values, TRACE_DEFAULT_ROLL_SIZE and TRACE_DEFAULT_MAX_LOGS_SIZE are located in Trace.h.
NetworkOptions::NetworkOptions()
  : traceRollSize(TRACE_DEFAULT_ROLL_SIZE), traceMaxLogsSize(TRACE_DEFAULT_MAX_LOGS_SIZE), traceLogGroup("default"),
    traceFormat("xml"), traceClockSource("now"), traceInitializeOnSetup(false),
    supportedVersions(new ReferencedObject<Standalone<VectorRef<ClientVersionRef>>>()), runLoopProfilingEnabled(false),
    primaryClient(true) {}

template <>
void addref(DatabaseContext* ptr) {
	ptr->addref();
}
template <>
void delref(DatabaseContext* ptr) {
	ptr->delref();
}

															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via refreshTransaction()
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class RefreshTransactionActor>
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RefreshTransactionActorState {
															#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RefreshTransactionActorState(DatabaseContext* const& self,Transaction* const& tr) 
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : self(self),
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tr(tr)
															#line 171 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("refreshTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RefreshTransactionActorState() 
	{
		fdb_probe_actor_destroy("refreshTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			*tr = Transaction();
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<RefreshTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RefreshTransactionActor*>(this)->actor_wait_state = 1;
															#line 155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshTransactionActor, 0, Void >*>(static_cast<RefreshTransactionActor*>(this)));
															#line 195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		*tr = Transaction(Database(Reference<DatabaseContext>::addRef(self)));
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RefreshTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshTransactionActorState(); static_cast<RefreshTransactionActor*>(this)->destroy(); return 0; }
															#line 220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<RefreshTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		*tr = Transaction(Database(Reference<DatabaseContext>::addRef(self)));
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<RefreshTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RefreshTransactionActorState(); static_cast<RefreshTransactionActor*>(this)->destroy(); return 0; }
															#line 234 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<RefreshTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RefreshTransactionActorState();
		static_cast<RefreshTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshTransactionActor*>(this)->actor_wait_state > 0) static_cast<RefreshTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshTransactionActor*>(this)->ActorCallback< RefreshTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* self;
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction* tr;
															#line 321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via refreshTransaction()
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class RefreshTransactionActor final : public Actor<Void>, public ActorCallback< RefreshTransactionActor, 0, Void >, public FastAllocated<RefreshTransactionActor>, public RefreshTransactionActorState<RefreshTransactionActor> {
															#line 326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<RefreshTransactionActor>::operator new;
	using FastAllocated<RefreshTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6338339697984353792UL, 14336067310306063360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshTransactionActor, 0, Void >;
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RefreshTransactionActor(DatabaseContext* const& self,Transaction* const& tr) 
															#line 343 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   RefreshTransactionActorState<RefreshTransactionActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4345345362439766272UL, 3425069992022049280UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> refreshTransaction( DatabaseContext* const& self, Transaction* const& tr ) {
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new RefreshTransactionActor(self, tr));
															#line 376 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// FIXME: get a prototype in a header file, ugh.
															#line 382 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
[[nodiscard]] Future<RangeResult> getWorkerInterfaces( Reference<IClusterConnectionRecord> const& clusterRecord );

#line 162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Optional<KeyRangeLocationInfo> DatabaseContext::getCachedLocation(const TenantInfo& tenant,
                                                                  const KeyRef& key,
                                                                  Reverse isBackward) {
	Arena arena;
	KeyRef resolvedKey = key;

	if (tenant.hasTenant()) {
		CODE_PROBE(true, "Database context get cached location with tenant");
		resolvedKey = resolvedKey.withPrefix(tenant.prefix.get(), arena);
	}

	auto range =
	    isBackward ? locationCache.rangeContainingKeyBefore(resolvedKey) : locationCache.rangeContaining(resolvedKey);
	if (range->value()) {
		return KeyRangeLocationInfo(toPrefixRelativeRange(range->range(), tenant.prefix), range->value());
	}

	return Optional<KeyRangeLocationInfo>();
}

bool DatabaseContext::getCachedLocations(const TenantInfo& tenant,
                                         const KeyRangeRef& range,
                                         std::vector<KeyRangeLocationInfo>& result,
                                         int limit,
                                         Reverse reverse) {
	result.clear();

	Arena arena;
	KeyRangeRef resolvedRange = range;

	if (tenant.hasTenant()) {
		CODE_PROBE(true, "Database context get cached locations with tenant");
		resolvedRange = resolvedRange.withPrefix(tenant.prefix.get(), arena);
	}

	auto begin = locationCache.rangeContaining(resolvedRange.begin);
	auto end = locationCache.rangeContainingKeyBefore(resolvedRange.end);

	loop {
		auto r = reverse ? end : begin;
		if (!r->value()) {
			CODE_PROBE(result.size(), "had some but not all cached locations");
			result.clear();
			return false;
		}
		result.emplace_back(toPrefixRelativeRange(r->range() & resolvedRange, tenant.prefix), r->value());
		if (result.size() == limit || begin == end) {
			break;
		}

		if (reverse)
			--end;
		else
			++begin;
	}

	return true;
}

Reference<LocationInfo> DatabaseContext::setCachedLocation(const KeyRangeRef& absoluteKeys,
                                                           const std::vector<StorageServerInterface>& servers) {
	std::vector<Reference<ReferencedInterface<StorageServerInterface>>> serverRefs;
	serverRefs.reserve(servers.size());
	for (const auto& interf : servers) {
		serverRefs.push_back(StorageServerInfo::getInterface(this, interf, clientLocality));
	}

	int maxEvictionAttempts = 100, attempts = 0;
	auto loc = makeReference<LocationInfo>(serverRefs);
	while (locationCache.size() > locationCacheSize && attempts < maxEvictionAttempts) {
		CODE_PROBE(true, "NativeAPI storage server locationCache entry evicted");
		attempts++;
		auto r = locationCache.randomRange();
		Key begin = r.begin(), end = r.end(); // insert invalidates r, so can't be passed a mere reference into it
		locationCache.insert(KeyRangeRef(begin, end), Reference<LocationInfo>());
	}
	locationCache.insert(absoluteKeys, loc);
	return loc;
}

void DatabaseContext::invalidateCache(const Optional<KeyRef>& tenantPrefix, const KeyRef& key, Reverse isBackward) {
	Arena arena;
	KeyRef resolvedKey = key;
	if (tenantPrefix.present() && !tenantPrefix.get().empty()) {
		CODE_PROBE(true, "Database context invalidate cache for tenant key");
		resolvedKey = resolvedKey.withPrefix(tenantPrefix.get(), arena);
	}

	if (isBackward) {
		locationCache.rangeContainingKeyBefore(resolvedKey)->value() = Reference<LocationInfo>();
	} else {
		locationCache.rangeContaining(resolvedKey)->value() = Reference<LocationInfo>();
	}
}

void DatabaseContext::invalidateCache(const Optional<KeyRef>& tenantPrefix, const KeyRangeRef& keys) {
	Arena arena;
	KeyRangeRef resolvedKeys = keys;
	if (tenantPrefix.present() && !tenantPrefix.get().empty()) {
		CODE_PROBE(true, "Database context invalidate cache for tenant range");
		resolvedKeys = resolvedKeys.withPrefix(tenantPrefix.get(), arena);
	}

	auto rs = locationCache.intersectingRanges(resolvedKeys);
	Key begin = rs.begin().begin(),
	    end = rs.end().begin(); // insert invalidates rs, so can't be passed a mere reference into it
	locationCache.insert(KeyRangeRef(begin, end), Reference<LocationInfo>());
}

void DatabaseContext::setFailedEndpointOnHealthyServer(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		failedEndpointsOnHealthyServersInfo[endpoint] =
		    EndpointFailureInfo{ .startTime = now(), .lastRefreshTime = now() };
	}
}

void DatabaseContext::updateFailedEndpointRefreshTime(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		// The endpoint is not failed. Nothing to update.
		return;
	}
	failedEndpointsOnHealthyServersInfo[endpoint].lastRefreshTime = now();
}

Optional<EndpointFailureInfo> DatabaseContext::getEndpointFailureInfo(const Endpoint& endpoint) {
	if (failedEndpointsOnHealthyServersInfo.find(endpoint) == failedEndpointsOnHealthyServersInfo.end()) {
		return Optional<EndpointFailureInfo>();
	}
	return failedEndpointsOnHealthyServersInfo[endpoint];
}

void DatabaseContext::clearFailedEndpointOnHealthyServer(const Endpoint& endpoint) {
	failedEndpointsOnHealthyServersInfo.erase(endpoint);
}

Future<Void> DatabaseContext::onProxiesChanged() {
	backoffDelay = 0.0;
	return this->proxiesChangeTrigger.onTrigger();
}

bool DatabaseContext::sampleReadTags() const {
	double sampleRate = globalConfig->get(transactionTagSampleRate, CLIENT_KNOBS->READ_TAG_SAMPLE_RATE);
	return sampleRate > 0 && deterministicRandom()->random01() <= sampleRate;
}

bool DatabaseContext::sampleOnCost(uint64_t cost) const {
	double sampleCost = globalConfig->get<double>(transactionTagSampleCost, CLIENT_KNOBS->COMMIT_SAMPLE_COST);
	if (sampleCost <= 0)
		return false;
	return deterministicRandom()->random01() <= (double)cost / sampleCost;
}

void validateOptionValuePresent(Optional<StringRef> value) {
	if (!value.present()) {
		throw invalid_option_value();
	}
}

void validateOptionValueNotPresent(Optional<StringRef> value) {
	if (value.present() && value.get().size() > 0) {
		throw invalid_option_value();
	}
}

int64_t extractIntOption(Optional<StringRef> value, int64_t minValue, int64_t maxValue) {
	validateOptionValuePresent(value);
	if (value.get().size() != 8) {
		throw invalid_option_value();
	}

	int64_t passed = *((int64_t*)(value.get().begin()));
	if (passed > maxValue || passed < minValue) {
		throw invalid_option_value();
	}

	return passed;
}

uint64_t extractHexOption(StringRef value) {
	char* end;
	uint64_t id = strtoull(value.toString().c_str(), &end, 16);
	if (*end)
		throw invalid_option_value();
	return id;
}

void DatabaseContext::setOption(FDBDatabaseOptions::Option option, Optional<StringRef> value) {
	int defaultFor = FDBDatabaseOptions::optionInfo.getMustExist(option).defaultFor;
	if (defaultFor >= 0) {
		ASSERT(FDBTransactionOptions::optionInfo.find((FDBTransactionOptions::Option)defaultFor) !=
		       FDBTransactionOptions::optionInfo.end());
		TraceEvent(SevDebug, "DatabaseContextSetPersistentOption").detail("Option", option).detail("Value", value);
		transactionDefaults.addOption((FDBTransactionOptions::Option)defaultFor, value.castTo<Standalone<StringRef>>());
	} else {
		switch (option) {
		case FDBDatabaseOptions::LOCATION_CACHE_SIZE:
			locationCacheSize = (int)extractIntOption(value, 0, std::numeric_limits<int>::max());
			break;
		case FDBDatabaseOptions::MACHINE_ID:
			clientLocality =
			    LocalityData(clientLocality.processId(),
			                 value.present() ? Standalone<StringRef>(value.get()) : Optional<Standalone<StringRef>>(),
			                 clientLocality.machineId(),
			                 clientLocality.dcId());
			if (clientInfo->get().commitProxies.size())
				commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
			if (clientInfo->get().grvProxies.size())
				grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
			server_interf.clear();
			locationCache.insert(allKeys, Reference<LocationInfo>());
			break;
		case FDBDatabaseOptions::MAX_WATCHES:
			maxOutstandingWatches = (int)extractIntOption(value, 0, CLIENT_KNOBS->ABSOLUTE_MAX_WATCHES);
			break;
		case FDBDatabaseOptions::DATACENTER_ID:
			clientLocality =
			    LocalityData(clientLocality.processId(),
			                 clientLocality.zoneId(),
			                 clientLocality.machineId(),
			                 value.present() ? Standalone<StringRef>(value.get()) : Optional<Standalone<StringRef>>());
			if (clientInfo->get().commitProxies.size())
				commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
			if (clientInfo->get().grvProxies.size())
				grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
			server_interf.clear();
			locationCache.insert(allKeys, Reference<LocationInfo>());
			break;
		case FDBDatabaseOptions::SNAPSHOT_RYW_ENABLE:
			validateOptionValueNotPresent(value);
			snapshotRywEnabled++;
			break;
		case FDBDatabaseOptions::SNAPSHOT_RYW_DISABLE:
			validateOptionValueNotPresent(value);
			snapshotRywEnabled--;
			break;
		case FDBDatabaseOptions::USE_CONFIG_DATABASE:
			validateOptionValueNotPresent(value);
			useConfigDatabase = true;
			break;
		case FDBDatabaseOptions::TEST_CAUSAL_READ_RISKY:
			verifyCausalReadsProp = double(extractIntOption(value, 0, 100)) / 100.0;
			break;
		default:
			break;
		}
	}
}

void DatabaseContext::increaseWatchCounter() {
	if (outstandingWatches >= maxOutstandingWatches)
		throw too_many_watches();

	++outstandingWatches;
}

void DatabaseContext::decreaseWatchCounter() {
	--outstandingWatches;
	ASSERT(outstandingWatches >= 0);
}

Future<Void> DatabaseContext::onConnected() const {
	return connected;
}

															#line 651 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via switchConnectionRecordImpl()
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class SwitchConnectionRecordImplActor>
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SwitchConnectionRecordImplActorState {
															#line 658 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SwitchConnectionRecordImplActorState(Reference<IClusterConnectionRecord> const& connRecord,DatabaseContext* const& self) 
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : connRecord(connRecord),
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   self(self)
															#line 667 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this));

	}
	~SwitchConnectionRecordImplActorState() 
	{
		fdb_probe_actor_destroy("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "Switch connection file");
															#line 430 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecord") .detail("ClusterFile", connRecord->toString()) .detail("ConnectionString", connRecord->getConnectionString().toString());
															#line 435 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->commitProxies.clear();
															#line 436 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->grvProxies.clear();
															#line 437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->minAcceptableReadVersion = std::numeric_limits<Version>::max();
															#line 438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->invalidateCache({}, allKeys);
															#line 440 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->ssVersionVectorCache.clear();
															#line 442 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto clearedClientInfo = self->clientInfo->get();
															#line 443 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.commitProxies.clear();
															#line 444 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.grvProxies.clear();
															#line 445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			clearedClientInfo.id = deterministicRandom()->randomUniqueID();
															#line 446 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->clientInfo->set(clearedClientInfo);
															#line 447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			self->connectionRecord->set(connRecord);
															#line 449 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			db = Database(Reference<DatabaseContext>::addRef(self));
															#line 450 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(db);
															#line 451 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 712 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 452 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 742 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 454 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecordAttemptingGRV").log();
															#line 455 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 455 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 1;
															#line 455 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*>(static_cast<SwitchConnectionRecordImplActor*>(this)));
															#line 755 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 463 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("SwitchConnectionRecordError").detail("Error", e.what());
															#line 464 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 464 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 781 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 2;
															#line 464 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*>(static_cast<SwitchConnectionRecordImplActor*>(this)));
															#line 786 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 456 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		TraceEvent("SwitchConnectionRecordGotRV") .detail("ReadVersion", v) .detail("MinAcceptableReadVersion", self->minAcceptableReadVersion);
															#line 459 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(self->minAcceptableReadVersion != std::numeric_limits<Version>::max());
															#line 460 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		self->connectionFileChangedTrigger.trigger();
															#line 461 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SwitchConnectionRecordImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchConnectionRecordImplActorState(); static_cast<SwitchConnectionRecordImplActor*>(this)->destroy(); return 0; }
															#line 807 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<SwitchConnectionRecordImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 456 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		TraceEvent("SwitchConnectionRecordGotRV") .detail("ReadVersion", v) .detail("MinAcceptableReadVersion", self->minAcceptableReadVersion);
															#line 459 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(self->minAcceptableReadVersion != std::numeric_limits<Version>::max());
															#line 460 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		self->connectionFileChangedTrigger.trigger();
															#line 461 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SwitchConnectionRecordImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchConnectionRecordImplActorState(); static_cast<SwitchConnectionRecordImplActor*>(this)->destroy(); return 0; }
															#line 825 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<SwitchConnectionRecordImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchConnectionRecordImplActorState();
		static_cast<SwitchConnectionRecordImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state > 0) static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchConnectionRecordImplActor*>(this)->ActorCallback< SwitchConnectionRecordImplActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state > 0) static_cast<SwitchConnectionRecordImplActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchConnectionRecordImplActor*>(this)->ActorCallback< SwitchConnectionRecordImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* self;
															#line 449 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database db;
															#line 450 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction tr;
															#line 1003 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via switchConnectionRecordImpl()
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SwitchConnectionRecordImplActor final : public Actor<Void>, public ActorCallback< SwitchConnectionRecordImplActor, 0, Version >, public ActorCallback< SwitchConnectionRecordImplActor, 1, Void >, public FastAllocated<SwitchConnectionRecordImplActor>, public SwitchConnectionRecordImplActorState<SwitchConnectionRecordImplActor> {
															#line 1008 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<SwitchConnectionRecordImplActor>::operator new;
	using FastAllocated<SwitchConnectionRecordImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6729144406406525696UL, 16448334963137728000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SwitchConnectionRecordImplActor, 0, Version >;
friend struct ActorCallback< SwitchConnectionRecordImplActor, 1, Void >;
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SwitchConnectionRecordImplActor(Reference<IClusterConnectionRecord> const& connRecord,DatabaseContext* const& self) 
															#line 1026 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   SwitchConnectionRecordImplActorState<SwitchConnectionRecordImplActor>(connRecord, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7312653141277564928UL, 2692131377335283456UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchConnectionRecordImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("switchConnectionRecordImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("switchConnectionRecordImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SwitchConnectionRecordImplActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SwitchConnectionRecordImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] static Future<Void> switchConnectionRecordImpl( Reference<IClusterConnectionRecord> const& connRecord, DatabaseContext* const& self ) {
															#line 427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new SwitchConnectionRecordImplActor(connRecord, self));
															#line 1060 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 468 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Reference<IClusterConnectionRecord> DatabaseContext::getConnectionRecord() {
	if (connectionRecord) {
		return connectionRecord->get();
	}
	return Reference<IClusterConnectionRecord>();
}

Future<Void> DatabaseContext::switchConnectionRecord(Reference<IClusterConnectionRecord> standby) {
	ASSERT(switchable);
	return switchConnectionRecordImpl(standby, this);
}

Future<Void> DatabaseContext::connectionFileChanged() {
	return connectionFileChangedTrigger.onTrigger();
}

void DatabaseContext::expireThrottles() {
	for (auto& priorityItr : throttledTags) {
		for (auto tagItr = priorityItr.second.begin(); tagItr != priorityItr.second.end();) {
			if (tagItr->second.expired()) {
				CODE_PROBE(true, "Expiring client throttle");
				tagItr = priorityItr.second.erase(tagItr);
			} else {
				++tagItr;
			}
		}
	}
}

// Initialize tracing for FDB client
//
// connRecord is necessary for determining the local IP, which is then included in the trace
// file name, and also used to annotate all trace events.
//
// If trace_initialize_on_setup is not set, tracing is initialized when opening a database.
// In that case we can immediately determine the IP. Thus, we can use the IP in the
// trace file name and annotate all events with it.
//
// If trace_initialize_on_setup network option is set, tracing is at first initialized without
// connRecord and thus without the local IP. In that case we cannot use the local IP in the
// trace file names. The IP is then provided by a repeated call to initializeClientTracing
// when opening a database. All tracing events from this point are annotated with the local IP
//
// If tracing initialization is completed, further calls to initializeClientTracing are ignored
void initializeClientTracing(Reference<IClusterConnectionRecord> connRecord, Optional<int> apiVersion) {
	if (!networkOptions.traceDirectory.present()) {
		return;
	}

	bool initialized = traceFileIsOpen();
	if (initialized && (isTraceLocalAddressSet() || !connRecord)) {
		// Tracing initialization is completed
		return;
	}

	// Network must be created before initializing tracing
	ASSERT(g_network);

	Optional<NetworkAddress> localAddress;
	if (connRecord) {
		auto publicIP = connRecord->getConnectionString().determineLocalSourceIP();
		localAddress = NetworkAddress(publicIP, ::getpid());
	}
	platform::ImageInfo imageInfo = platform::getImageInfo();

	if (initialized) {
		// Tracing already initialized, just need to update the IP address
		setTraceLocalAddress(localAddress.get());
		TraceEvent("ClientStart")
		    .detail("SourceVersion", getSourceVersion())
		    .detail("Version", FDB_VT_VERSION)
		    .detail("PackageName", FDB_VT_PACKAGE_NAME)
		    .detailf("ActualTime", "%lld", DEBUG_DETERMINISM ? 0 : time(nullptr))
		    .detail("ApiVersion", apiVersion)
		    .detail("ClientLibrary", imageInfo.fileName)
		    .detailf("ImageOffset", "%p", imageInfo.offset)
		    .detail("Primary", networkOptions.primaryClient)
		    .trackLatest("ClientStart");
	} else {
		// Initialize tracing
		selectTraceFormatter(networkOptions.traceFormat);
		selectTraceClockSource(networkOptions.traceClockSource);
		addUniversalTraceField("ClientDescription",
		                       format("%s-%s-%" PRIu64,
		                              networkOptions.primaryClient ? "primary" : "external",
		                              FDB_VT_VERSION,
		                              deterministicRandom()->randomUInt64()));

		std::string identifier = networkOptions.traceFileIdentifier;
		openTraceFile(localAddress,
		              networkOptions.traceRollSize,
		              networkOptions.traceMaxLogsSize,
		              networkOptions.traceDirectory.get(),
		              "trace",
		              networkOptions.traceLogGroup,
		              identifier,
		              networkOptions.tracePartialFileSuffix,
		              InitializeTraceMetrics::True);

		TraceEvent("ClientStart")
		    .detail("SourceVersion", getSourceVersion())
		    .detail("Version", FDB_VT_VERSION)
		    .detail("PackageName", FDB_VT_PACKAGE_NAME)
		    .detailf("ActualTime", "%lld", DEBUG_DETERMINISM ? 0 : time(nullptr))
		    .detail("ApiVersion", apiVersion)
		    .detail("ClientLibrary", imageInfo.fileName)
		    .detailf("ImageOffset", "%p", imageInfo.offset)
		    .detail("Primary", networkOptions.primaryClient)
		    .trackLatest("ClientStart");

		g_network->initMetrics();
		FlowTransport::transport().initMetrics();
	}

	// Initialize system monitoring once the local IP is available
	if (localAddress.present()) {
		initializeSystemMonitorMachineState(SystemMonitorMachineState(IPAddress(localAddress.get().ip)));
		systemMonitor();
		uncancellable(recurring(&systemMonitor, CLIENT_KNOBS->SYSTEM_MONITOR_INTERVAL, TaskPriority::FlushTrace));
	}
}

// Creates a database object that represents a connection to a cluster
// This constructor uses a preallocated DatabaseContext that may have been created
// on another thread
Database Database::createDatabase(Reference<IClusterConnectionRecord> connRecord,
                                  int apiVersion,
                                  IsInternal internal,
                                  LocalityData const& clientLocality,
                                  DatabaseContext* preallocatedDb) {
	if (!g_network)
		throw network_not_setup();

	ASSERT(TraceEvent::isNetworkThread());

	initializeClientTracing(connRecord, apiVersion);

	g_network->initTLS();

	auto clientInfo = makeReference<AsyncVar<ClientDBInfo>>();
	auto coordinator = makeReference<AsyncVar<Optional<ClientLeaderRegInterface>>>();
	auto connectionRecord = makeReference<AsyncVar<Reference<IClusterConnectionRecord>>>();
	connectionRecord->set(connRecord);
	Future<Void> clientInfoMonitor = monitorProxies(connectionRecord,
	                                                clientInfo,
	                                                coordinator,
	                                                networkOptions.supportedVersions,
	                                                StringRef(networkOptions.traceLogGroup),
	                                                internal);

	DatabaseContext* db;
	if (preallocatedDb) {
		db = new (preallocatedDb) DatabaseContext(connectionRecord,
		                                          clientInfo,
		                                          coordinator,
		                                          clientInfoMonitor,
		                                          TaskPriority::DefaultEndpoint,
		                                          clientLocality,
		                                          EnableLocalityLoadBalance::True,
		                                          LockAware::False,
		                                          internal,
		                                          apiVersion,
		                                          IsSwitchable::True);
	} else {
		db = new DatabaseContext(connectionRecord,
		                         clientInfo,
		                         coordinator,
		                         clientInfoMonitor,
		                         TaskPriority::DefaultEndpoint,
		                         clientLocality,
		                         EnableLocalityLoadBalance::True,
		                         LockAware::False,
		                         internal,
		                         apiVersion,
		                         IsSwitchable::True);
	}

	auto database = Database(db);
	database->globalConfig->init(Reference<AsyncVar<ClientDBInfo> const>(clientInfo),
	                             std::addressof(clientInfo->get()));
	database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
	database->globalConfig->trigger(samplingWindow, samplingProfilerUpdateWindow);

	TraceEvent("ConnectToDatabase", database->dbId)
	    .detail("Version", FDB_VT_VERSION)
	    .detail("ClusterFile", connRecord ? connRecord->toString() : "None")
	    .detail("ConnectionString", connRecord ? connRecord->getConnectionString().toString() : "None")
	    .detail("ClientLibrary", platform::getImageInfo().fileName)
	    .detail("Primary", networkOptions.primaryClient)
	    .detail("Internal", internal)
	    .trackLatest(database->connectToDatabaseEventCacheHolder.trackingKey);

	return database;
}

Database Database::createDatabase(std::string connFileName,
                                  int apiVersion,
                                  IsInternal internal,
                                  LocalityData const& clientLocality) {
	Reference<IClusterConnectionRecord> rccr = ClusterConnectionFile::openOrDefault(connFileName);
	return Database::createDatabase(rccr, apiVersion, internal, clientLocality);
}

Database Database::createSimulatedExtraDatabase(std::string connectionString, Optional<TenantName> defaultTenant) {
	auto extraFile = makeReference<ClusterConnectionMemoryRecord>(ClusterConnectionString(connectionString));
	Database db = Database::createDatabase(extraFile, ApiVersion::LATEST_VERSION);
	db->defaultTenant = defaultTenant;
	return db;
}

const UniqueOrderedOptionList<FDBTransactionOptions>& Database::getTransactionDefaults() const {
	ASSERT(db);
	return db->transactionDefaults;
}

void setNetworkOption(FDBNetworkOptions::Option option, Optional<StringRef> value) {
	std::regex identifierRegex("^[a-zA-Z0-9_]*$");
	switch (option) {
	// SOMEDAY: If the network is already started, should these five throw an error?
	case FDBNetworkOptions::TRACE_ENABLE:
		networkOptions.traceDirectory = value.present() ? value.get().toString() : "";
		break;
	case FDBNetworkOptions::TRACE_ROLL_SIZE:
		validateOptionValuePresent(value);
		networkOptions.traceRollSize = extractIntOption(value, 0, std::numeric_limits<int64_t>::max());
		break;
	case FDBNetworkOptions::TRACE_MAX_LOGS_SIZE:
		validateOptionValuePresent(value);
		networkOptions.traceMaxLogsSize = extractIntOption(value, 0, std::numeric_limits<int64_t>::max());
		break;
	case FDBNetworkOptions::TRACE_FORMAT:
		validateOptionValuePresent(value);
		networkOptions.traceFormat = value.get().toString();
		if (!validateTraceFormat(networkOptions.traceFormat)) {
			fprintf(stderr, "Unrecognized trace format: `%s'\n", networkOptions.traceFormat.c_str());
			throw invalid_option_value();
		}
		break;
	case FDBNetworkOptions::TRACE_FILE_IDENTIFIER:
		validateOptionValuePresent(value);
		networkOptions.traceFileIdentifier = value.get().toString();
		if (networkOptions.traceFileIdentifier.length() > CLIENT_KNOBS->TRACE_LOG_FILE_IDENTIFIER_MAX_LENGTH) {
			fprintf(stderr, "Trace file identifier provided is too long.\n");
			throw invalid_option_value();
		} else if (!std::regex_match(networkOptions.traceFileIdentifier, identifierRegex)) {
			fprintf(stderr, "Trace file identifier should only contain alphanumerics and underscores.\n");
			throw invalid_option_value();
		}
		break;

	case FDBNetworkOptions::TRACE_LOG_GROUP:
		if (value.present()) {
			if (traceFileIsOpen()) {
				setTraceLogGroup(value.get().toString());
			} else {
				networkOptions.traceLogGroup = value.get().toString();
			}
		}
		break;
	case FDBNetworkOptions::TRACE_CLOCK_SOURCE:
		validateOptionValuePresent(value);
		networkOptions.traceClockSource = value.get().toString();
		if (!validateTraceClockSource(networkOptions.traceClockSource)) {
			fprintf(stderr, "Unrecognized trace clock source: `%s'\n", networkOptions.traceClockSource.c_str());
			throw invalid_option_value();
		}
		break;
	case FDBNetworkOptions::TRACE_PARTIAL_FILE_SUFFIX:
		validateOptionValuePresent(value);
		networkOptions.tracePartialFileSuffix = value.get().toString();
		break;
	case FDBNetworkOptions::TRACE_INITIALIZE_ON_SETUP:
		networkOptions.traceInitializeOnSetup = true;
		break;
	case FDBNetworkOptions::KNOB: {
		validateOptionValuePresent(value);

		std::string optionValue = value.get().toString();
		TraceEvent("SetKnob").detail("KnobString", optionValue);

		size_t eq = optionValue.find_first_of('=');
		if (eq == optionValue.npos) {
			TraceEvent(SevWarnAlways, "InvalidKnobString").detail("KnobString", optionValue);
			throw invalid_option_value();
		}

		std::string knobName = optionValue.substr(0, eq);
		std::string knobValueString = optionValue.substr(eq + 1);

		try {
			auto knobValue = IKnobCollection::parseKnobValue(knobName, knobValueString, IKnobCollection::Type::CLIENT);
			if (g_network) {
				IKnobCollection::getMutableGlobalKnobCollection().setKnob(knobName, knobValue);
			} else {
				networkOptions.knobs[knobName] = knobValue;
			}
		} catch (Error& e) {
			TraceEvent(SevWarnAlways, "UnrecognizedKnob").detail("Knob", knobName.c_str());
			fprintf(stderr, "FoundationDB client ignoring unrecognized knob option '%s'\n", knobName.c_str());
		}
		break;
	}
	case FDBNetworkOptions::TLS_PLUGIN:
		validateOptionValuePresent(value);
		break;
	case FDBNetworkOptions::TLS_CERT_PATH:
		validateOptionValuePresent(value);
		tlsConfig.setCertificatePath(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_CERT_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setCertificateBytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_CA_PATH: {
		validateOptionValuePresent(value);
		tlsConfig.setCAPath(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_CA_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setCABytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_PASSWORD:
		validateOptionValuePresent(value);
		tlsConfig.setPassword(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_KEY_PATH:
		validateOptionValuePresent(value);
		tlsConfig.setKeyPath(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_KEY_BYTES: {
		validateOptionValuePresent(value);
		tlsConfig.setKeyBytes(value.get().toString());
		break;
	}
	case FDBNetworkOptions::TLS_VERIFY_PEERS:
		validateOptionValuePresent(value);
		tlsConfig.clearVerifyPeers();
		tlsConfig.addVerifyPeers(value.get().toString());
		break;
	case FDBNetworkOptions::TLS_DISABLE_PLAINTEXT_CONNECTION:
		tlsConfig.setDisablePlainTextConnection(true);
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_ENABLE:
		enableClientBuggify();
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_DISABLE:
		disableClientBuggify();
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_SECTION_ACTIVATED_PROBABILITY:
		validateOptionValuePresent(value);
		clearClientBuggifySections();
		P_CLIENT_BUGGIFIED_SECTION_ACTIVATED = double(extractIntOption(value, 0, 100)) / 100.0;
		break;
	case FDBNetworkOptions::CLIENT_BUGGIFY_SECTION_FIRED_PROBABILITY:
		validateOptionValuePresent(value);
		P_CLIENT_BUGGIFIED_SECTION_FIRES = double(extractIntOption(value, 0, 100)) / 100.0;
		break;
	case FDBNetworkOptions::DISABLE_CLIENT_STATISTICS_LOGGING:
		validateOptionValueNotPresent(value);
		networkOptions.logClientInfo = false;
		break;
	case FDBNetworkOptions::SUPPORTED_CLIENT_VERSIONS: {
		// The multi-version API should be providing us these guarantees
		ASSERT(g_network);
		ASSERT(value.present());

		Standalone<VectorRef<ClientVersionRef>> supportedVersions;
		std::vector<StringRef> supportedVersionsStrings = value.get().splitAny(";"_sr);
		for (StringRef versionString : supportedVersionsStrings) {
#ifdef ADDRESS_SANITIZER
			__lsan_disable();
#endif
			// LSAN reports that we leak this allocation in client
			// tests, but I cannot seem to figure out why. AFAICT
			// it's not actually leaking. If it is a leak, it's only a few bytes.
			supportedVersions.push_back_deep(supportedVersions.arena(), ClientVersionRef(versionString));
#ifdef ADDRESS_SANITIZER
			__lsan_enable();
#endif
		}

		ASSERT(supportedVersions.size() > 0);
		networkOptions.supportedVersions->set(supportedVersions);

		break;
	}
	case FDBNetworkOptions::ENABLE_RUN_LOOP_PROFILING: // Same as ENABLE_SLOW_TASK_PROFILING
		validateOptionValueNotPresent(value);
		networkOptions.runLoopProfilingEnabled = true;
		break;
	case FDBNetworkOptions::DISTRIBUTED_CLIENT_TRACER: {
		validateOptionValuePresent(value);
		std::string tracer = value.get().toString();
		if (tracer == "none" || tracer == "disabled") {
			openTracer(TracerType::DISABLED);
		} else if (tracer == "logfile" || tracer == "file" || tracer == "log_file") {
			openTracer(TracerType::LOG_FILE);
		} else if (tracer == "network_lossy") {
			openTracer(TracerType::NETWORK_LOSSY);
		} else {
			fprintf(stderr, "ERROR: Unknown or unsupported tracer: `%s'", tracer.c_str());
			throw invalid_option_value();
		}
		break;
	}
	case FDBNetworkOptions::EXTERNAL_CLIENT:
		networkOptions.primaryClient = false;
		break;
	default:
		break;
	}
}

// update the network busyness on a 1s cadence
															#line 1482 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorNetworkBusyness()
															#line 886 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class MonitorNetworkBusynessActor>
															#line 886 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class MonitorNetworkBusynessActorState {
															#line 1489 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 886 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	MonitorNetworkBusynessActorState() 
															#line 886 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 887 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : prevTime(now())
															#line 1496 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this));

	}
	~MonitorNetworkBusynessActorState() 
	{
		fdb_probe_actor_destroy("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 888 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 1511 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorNetworkBusynessActorState();
		static_cast<MonitorNetworkBusynessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 889 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(CLIENT_KNOBS->NETWORK_BUSYNESS_MONITOR_INTERVAL, TaskPriority::FlushTrace);
															#line 889 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1543 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state = 1;
															#line 889 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorNetworkBusynessActor, 0, Void >*>(static_cast<MonitorNetworkBusynessActor*>(this)));
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 890 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double elapsed = now() - prevTime;
															#line 891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		prevTime = now();
															#line 892 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		struct NetworkMetrics::PriorityStats& tracker = g_network->networkInfo.metrics.starvationTrackerNetworkBusyness;
															#line 894 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tracker.active)
															#line 1563 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 895 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.duration += now() - tracker.windowedTimer;
															#line 896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.maxDuration = std::max(tracker.maxDuration, now() - tracker.timer);
															#line 897 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.windowedTimer = now();
															#line 1571 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double busyFraction = std::min(elapsed, tracker.duration) / elapsed;
															#line 908 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double burstiness = 0;
															#line 909 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD >= 0 && CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD >= CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD)
															#line 1579 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 911 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			burstiness = std::min(1.0, std::max(0.0, tracker.maxDuration - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD) / std::max(1e-6, CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD));
															#line 1583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		g_network->networkInfo.metrics.networkBusyness = std::max(busyFraction, burstiness);
															#line 920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.duration = 0;
															#line 921 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.maxDuration = 0;
															#line 1591 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 890 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double elapsed = now() - prevTime;
															#line 891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		prevTime = now();
															#line 892 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		struct NetworkMetrics::PriorityStats& tracker = g_network->networkInfo.metrics.starvationTrackerNetworkBusyness;
															#line 894 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tracker.active)
															#line 1606 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 895 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.duration += now() - tracker.windowedTimer;
															#line 896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.maxDuration = std::max(tracker.maxDuration, now() - tracker.timer);
															#line 897 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tracker.windowedTimer = now();
															#line 1614 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double busyFraction = std::min(elapsed, tracker.duration) / elapsed;
															#line 908 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double burstiness = 0;
															#line 909 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD >= 0 && CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD >= CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD)
															#line 1622 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 911 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			burstiness = std::min(1.0, std::max(0.0, tracker.maxDuration - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD) / std::max(1e-6, CLIENT_KNOBS->BUSYNESS_SPIKE_SATURATED_THRESHOLD - CLIENT_KNOBS->BUSYNESS_SPIKE_START_THRESHOLD));
															#line 1626 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		g_network->networkInfo.metrics.networkBusyness = std::max(busyFraction, burstiness);
															#line 920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.duration = 0;
															#line 921 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tracker.maxDuration = 0;
															#line 1634 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state > 0) static_cast<MonitorNetworkBusynessActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorNetworkBusynessActor*>(this)->ActorCallback< MonitorNetworkBusynessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorNetworkBusynessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 887 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double prevTime;
															#line 1716 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via monitorNetworkBusyness()
															#line 886 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class MonitorNetworkBusynessActor final : public Actor<Void>, public ActorCallback< MonitorNetworkBusynessActor, 0, Void >, public FastAllocated<MonitorNetworkBusynessActor>, public MonitorNetworkBusynessActorState<MonitorNetworkBusynessActor> {
															#line 1721 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<MonitorNetworkBusynessActor>::operator new;
	using FastAllocated<MonitorNetworkBusynessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1179110094226533376UL, 6134818423345267200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorNetworkBusynessActor, 0, Void >;
															#line 886 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	MonitorNetworkBusynessActor() 
															#line 1738 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorNetworkBusynessActorState<MonitorNetworkBusynessActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9706183877542601984UL, 10068029726573410048UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorNetworkBusynessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorNetworkBusyness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorNetworkBusyness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorNetworkBusynessActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 886 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> monitorNetworkBusyness(  ) {
															#line 886 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new MonitorNetworkBusynessActor());
															#line 1771 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 924 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

static void setupGlobalKnobs() {
	IKnobCollection::setGlobalKnobCollection(IKnobCollection::Type::CLIENT, Randomize::False, IsSimulated::False);
	for (const auto& [knobName, knobValue] : networkOptions.knobs) {
		IKnobCollection::getMutableGlobalKnobCollection().setKnob(knobName, knobValue);
	}
}

// Setup g_network and start monitoring for network busyness
void setupNetwork(uint64_t transportId, UseMetrics useMetrics) {
	if (g_network)
		throw network_already_setup();

	if (!networkOptions.logClientInfo.present())
		networkOptions.logClientInfo = true;

	setupGlobalKnobs();
	g_network = newNet2(tlsConfig, false, useMetrics || networkOptions.traceDirectory.present());
	g_network->addStopCallback(Net2FileSystem::stop);
	FlowTransport::createInstance(true, transportId, WLTOKEN_RESERVED_COUNT);
	Net2FileSystem::newFileSystem();

	if (networkOptions.traceInitializeOnSetup) {
		::initializeClientTracing({}, {});
	}

	uncancellable(monitorNetworkBusyness());
}

void runNetwork() {
	if (!g_network) {
		throw network_not_setup();
	}

	if (!g_network->checkRunnable()) {
		throw network_cannot_be_restarted();
	}

	if (networkOptions.traceDirectory.present() && networkOptions.runLoopProfilingEnabled) {
		setupRunLoopProfiler();
	}

	g_network->run();

	if (networkOptions.traceDirectory.present())
		systemMonitor();
}

void stopNetwork() {
	if (!g_network)
		throw network_not_setup();

	TraceEvent("ClientStopNetwork").log();

	if (networkOptions.traceDirectory.present() && networkOptions.runLoopProfilingEnabled) {
		stopRunLoopProfiler();
	}

	g_network->stop();
}

void DatabaseContext::updateProxies() {
	if (proxiesLastChange == clientInfo->get().id)
		return;
	proxiesLastChange = clientInfo->get().id;
	commitProxies.clear();
	grvProxies.clear();
	bool commitProxyProvisional = false, grvProxyProvisional = false;
	if (clientInfo->get().commitProxies.size()) {
		commitProxies = makeReference<CommitProxyInfo>(clientInfo->get().commitProxies);
		commitProxyProvisional = clientInfo->get().commitProxies[0].provisional;
	}
	if (clientInfo->get().grvProxies.size()) {
		grvProxies = makeReference<GrvProxyInfo>(clientInfo->get().grvProxies, BalanceOnRequests::True);
		grvProxyProvisional = clientInfo->get().grvProxies[0].provisional;
	}
	if (clientInfo->get().commitProxies.size() && clientInfo->get().grvProxies.size()) {
		ASSERT(commitProxyProvisional == grvProxyProvisional);
		proxyProvisional = commitProxyProvisional;
	}
}

Reference<CommitProxyInfo> DatabaseContext::getCommitProxies(UseProvisionalProxies useProvisionalProxies) {
	updateProxies();
	if (proxyProvisional && !useProvisionalProxies) {
		return Reference<CommitProxyInfo>();
	}
	return commitProxies;
}

Reference<GrvProxyInfo> DatabaseContext::getGrvProxies(UseProvisionalProxies useProvisionalProxies) {
	updateProxies();
	if (proxyProvisional && !useProvisionalProxies) {
		return Reference<GrvProxyInfo>();
	}
	return grvProxies;
}

bool DatabaseContext::isCurrentGrvProxy(UID proxyId) const {
	for (const auto& proxy : clientInfo->get().grvProxies) {
		if (proxy.id() == proxyId)
			return true;
	}
	CODE_PROBE(true, "stale GRV proxy detected", probe::decoration::rare);
	return false;
}

// Actor which will wait until the MultiInterface<CommitProxyInterface> returned by the DatabaseContext cx is not
// nullptr
															#line 1884 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getCommitProxiesFuture()
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetCommitProxiesFutureActor>
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetCommitProxiesFutureActorState {
															#line 1891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetCommitProxiesFutureActorState(DatabaseContext* const& cx,UseProvisionalProxies const& useProvisionalProxies) 
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 1900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this));

	}
	~GetCommitProxiesFutureActorState() 
	{
		fdb_probe_actor_destroy("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1035 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 1915 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCommitProxiesFutureActorState();
		static_cast<GetCommitProxiesFutureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1036 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reference<CommitProxyInfo> commitProxies = cx->getCommitProxies(useProvisionalProxies);
															#line 1037 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (commitProxies)
															#line 1947 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1038 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetCommitProxiesFutureActor*>(this)->SAV<Reference<CommitProxyInfo>>::futures) { (void)(commitProxies); this->~GetCommitProxiesFutureActorState(); static_cast<GetCommitProxiesFutureActor*>(this)->destroy(); return 0; }
															#line 1951 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetCommitProxiesFutureActor*>(this)->SAV< Reference<CommitProxyInfo> >::value()) Reference<CommitProxyInfo>(commitProxies);
			this->~GetCommitProxiesFutureActorState();
			static_cast<GetCommitProxiesFutureActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = cx->onProxiesChanged();
															#line 1039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1961 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state = 1;
															#line 1039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCommitProxiesFutureActor, 0, Void >*>(static_cast<GetCommitProxiesFutureActor*>(this)));
															#line 1966 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state > 0) static_cast<GetCommitProxiesFutureActor*>(this)->actor_wait_state = 0;
		static_cast<GetCommitProxiesFutureActor*>(this)->ActorCallback< GetCommitProxiesFutureActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCommitProxiesFutureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* cx;
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 2062 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getCommitProxiesFuture()
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetCommitProxiesFutureActor final : public Actor<Reference<CommitProxyInfo>>, public ActorCallback< GetCommitProxiesFutureActor, 0, Void >, public FastAllocated<GetCommitProxiesFutureActor>, public GetCommitProxiesFutureActorState<GetCommitProxiesFutureActor> {
															#line 2067 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetCommitProxiesFutureActor>::operator new;
	using FastAllocated<GetCommitProxiesFutureActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12008261790945241600UL, 12547790894958668800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<CommitProxyInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCommitProxiesFutureActor, 0, Void >;
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetCommitProxiesFutureActor(DatabaseContext* const& cx,UseProvisionalProxies const& useProvisionalProxies) 
															#line 2084 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Reference<CommitProxyInfo>>(),
		   GetCommitProxiesFutureActorState<GetCommitProxiesFutureActor>(cx, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5140351585656034048UL, 11319334858847052544UL);
		ActorExecutionContextHelper __helper(static_cast<GetCommitProxiesFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCommitProxiesFuture");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCommitProxiesFuture", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCommitProxiesFutureActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Reference<CommitProxyInfo>> getCommitProxiesFuture( DatabaseContext* const& cx, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 1033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Reference<CommitProxyInfo>>(new GetCommitProxiesFutureActor(cx, useProvisionalProxies));
															#line 2117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1042 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Returns a future which will not be set until the CommitProxyInfo of this DatabaseContext is not nullptr
Future<Reference<CommitProxyInfo>> DatabaseContext::getCommitProxiesFuture(
    UseProvisionalProxies useProvisionalProxies) {
	return ::getCommitProxiesFuture(this, useProvisionalProxies);
}

void GetRangeLimits::decrement(VectorRef<KeyValueRef> const& data) {
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED) {
		ASSERT(data.size() <= rows);
		rows -= data.size();
	}

	minRows = std::max(0, minRows - data.size());

	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)data.expectedSize() - (8 - (int)sizeof(KeyValueRef)) * data.size());
}

void GetRangeLimits::decrement(KeyValueRef const& data) {
	minRows = std::max(0, minRows - 1);
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED)
		rows--;
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)8 - (int)data.expectedSize());
}

void GetRangeLimits::decrement(VectorRef<MappedKeyValueRef> const& data) {
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED) {
		ASSERT(data.size() <= rows);
		rows -= data.size();
	}

	minRows = std::max(0, minRows - data.size());

	// TODO: For now, expectedSize only considers the size of the original key values, but not the underlying queries or
	// results. Also, double check it is correct when dealing with sizeof(MappedKeyValueRef).
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)data.expectedSize() - (8 - (int)sizeof(MappedKeyValueRef)) * data.size());
}

void GetRangeLimits::decrement(MappedKeyValueRef const& data) {
	minRows = std::max(0, minRows - 1);
	if (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED)
		rows--;
	// TODO: For now, expectedSize only considers the size of the original key values, but not the underlying queries or
	// results. Also, double check it is correct when dealing with sizeof(MappedKeyValueRef).
	if (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED)
		bytes = std::max(0, bytes - (int)8 - (int)data.expectedSize());
}

// True if either the row or byte limit has been reached
bool GetRangeLimits::isReached() const {
	return rows == 0 || (bytes == 0 && minRows == 0);
}

// True if data would cause the row or byte limit to be reached
bool GetRangeLimits::reachedBy(VectorRef<KeyValueRef> const& data) const {
	return (rows != GetRangeLimits::ROW_LIMIT_UNLIMITED && data.size() >= rows) ||
	       (bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED &&
	        (int)data.expectedSize() + (8 - (int)sizeof(KeyValueRef)) * data.size() >= bytes && data.size() >= minRows);
}

bool GetRangeLimits::hasByteLimit() const {
	return bytes != GetRangeLimits::BYTE_LIMIT_UNLIMITED;
}

bool GetRangeLimits::hasRowLimit() const {
	return rows != GetRangeLimits::ROW_LIMIT_UNLIMITED;
}

bool GetRangeLimits::hasSatisfiedMinRows() const {
	return hasByteLimit() && minRows == 0;
}

AddressExclusion AddressExclusion::parse(StringRef const& key) {
	// Must not change: serialized to the database!
	auto parsedIp = IPAddress::parse(key.toString());
	if (parsedIp.present()) {
		return AddressExclusion(parsedIp.get());
	}

	// Not a whole machine, includes `port'.
	try {
		auto addr = NetworkAddress::parse(key.toString());
		if (addr.isTLS()) {
			TraceEvent(SevWarnAlways, "AddressExclusionParseError")
			    .detail("String", key)
			    .detail("Description", "Address inclusion string should not include `:tls' suffix.");
			return AddressExclusion();
		}
		return AddressExclusion(addr.ip, addr.port);
	} catch (Error&) {
		TraceEvent(SevWarnAlways, "AddressExclusionParseError").detail("String", key);
		return AddressExclusion();
	}
}

Tenant::Tenant(Database cx, TenantName name) : idFuture(cx->lookupTenant(name)), name(name) {}
Tenant::Tenant(int64_t id) : idFuture(id) {}
Tenant::Tenant(Future<int64_t> id, Optional<TenantName> name) : idFuture(id), name(name) {}

int64_t Tenant::id() const {
	ASSERT(idFuture.isReady());
	return idFuture.get();
}

Future<int64_t> Tenant::getIdFuture() const {
	return idFuture;
}

KeyRef Tenant::prefix() const {
	ASSERT(idFuture.isReady());
	if (bigEndianId == -1) {
		bigEndianId = bigEndian64(idFuture.get());
	}
	return StringRef(reinterpret_cast<const uint8_t*>(&bigEndianId), TenantAPI::PREFIX_SIZE);
}

std::string Tenant::description() const {
	StringRef nameStr = name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr);
	if (idFuture.canGet()) {
		return format("%.*s (%lld)", nameStr.size(), nameStr.begin(), idFuture.get());
	} else {
		return format("%.*s", nameStr.size(), nameStr.begin());
	}
}

Future<Optional<Value>> getValue(Reference<TransactionState> const& trState,
                                 Key const& key,
                                 UseTenant const& useTenant = UseTenant::True,
                                 TransactionRecordLogInfo const& recordLogInfo = TransactionRecordLogInfo::True);

Future<RangeResult> getRange(Reference<TransactionState> const& trState,
                             KeySelector const& begin,
                             KeySelector const& end,
                             GetRangeLimits const& limits,
                             Reverse const& reverse,
                             UseTenant const& useTenant);

															#line 2261 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchServerInterface()
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class FetchServerInterfaceActor>
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class FetchServerInterfaceActorState {
															#line 2268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	FetchServerInterfaceActorState(Reference<TransactionState> const& trState,UID const& id) 
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   id(id)
															#line 2277 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchServerInterface", reinterpret_cast<unsigned long>(this));

	}
	~FetchServerInterfaceActorState() 
	{
		fdb_probe_actor_destroy("fetchServerInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = getValue(trState, serverListKeyFor(id), UseTenant::False, TransactionRecordLogInfo::False);
															#line 1183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2294 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state = 1;
															#line 1183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*>(static_cast<FetchServerInterfaceActor*>(this)));
															#line 2299 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 1186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!val.present())
															#line 2322 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(Optional<StorageServerInterface>()); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(Optional<StorageServerInterface>());
			this->~FetchServerInterfaceActorState();
			static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(decodeServerListValue(val.get())); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2334 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(decodeServerListValue(val.get()));
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 1186 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!val.present())
															#line 2346 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(Optional<StorageServerInterface>()); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2350 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(Optional<StorageServerInterface>());
			this->~FetchServerInterfaceActorState();
			static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<FetchServerInterfaceActor*>(this)->SAV<Optional<StorageServerInterface>>::futures) { (void)(decodeServerListValue(val.get())); this->~FetchServerInterfaceActorState(); static_cast<FetchServerInterfaceActor*>(this)->destroy(); return 0; }
															#line 2358 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<FetchServerInterfaceActor*>(this)->SAV< Optional<StorageServerInterface> >::value()) Optional<StorageServerInterface>(decodeServerListValue(val.get()));
		this->~FetchServerInterfaceActorState();
		static_cast<FetchServerInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state > 0) static_cast<FetchServerInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<FetchServerInterfaceActor*>(this)->ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UID id;
															#line 2445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via fetchServerInterface()
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class FetchServerInterfaceActor final : public Actor<Optional<StorageServerInterface>>, public ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >, public FastAllocated<FetchServerInterfaceActor>, public FetchServerInterfaceActorState<FetchServerInterfaceActor> {
															#line 2450 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<FetchServerInterfaceActor>::operator new;
	using FastAllocated<FetchServerInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11915277089750380544UL, 8624826389896080896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >;
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	FetchServerInterfaceActor(Reference<TransactionState> const& trState,UID const& id) 
															#line 2467 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Optional<StorageServerInterface>>(),
		   FetchServerInterfaceActorState<FetchServerInterfaceActor>(trState, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchServerInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14331509920591601920UL, 209697105602724096UL);
		ActorExecutionContextHelper __helper(static_cast<FetchServerInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchServerInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchServerInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchServerInterfaceActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<StorageServerInterface>> fetchServerInterface( Reference<TransactionState> const& trState, UID const& id ) {
															#line 1182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<StorageServerInterface>>(new FetchServerInterfaceActor(trState, id));
															#line 2500 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 2505 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via transactionalGetServerInterfaces()
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class TransactionalGetServerInterfacesActor>
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TransactionalGetServerInterfacesActorState {
															#line 2512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionalGetServerInterfacesActorState(Reference<TransactionState> const& trState,std::vector<UID> const& ids) 
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ids(ids),
															#line 1197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   serverListEntries()
															#line 2523 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	~TransactionalGetServerInterfacesActorState() 
	{
		fdb_probe_actor_destroy("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverListEntries.reserve(ids.size());
															#line 1199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			for(int s = 0;s < ids.size();s++) {
															#line 1200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				serverListEntries.push_back(fetchServerInterface(trState, ids[s]));
															#line 2542 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<std::vector<Optional<StorageServerInterface>>> __when_expr_0 = getAll(serverListEntries);
															#line 1203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state = 1;
															#line 1203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*>(static_cast<TransactionalGetServerInterfacesActor*>(this)));
															#line 2553 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<StorageServerInterface>> const& serverListValues,int loopDepth) 
	{
															#line 1204 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<StorageServerInterface> serverInterfaces;
															#line 1205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!serverListValues[s].present())
															#line 2580 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(Optional<std::vector<StorageServerInterface>>()); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(Optional<std::vector<StorageServerInterface>>());
				this->~TransactionalGetServerInterfacesActorState();
				static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverInterfaces.push_back(serverListValues[s].get());
															#line 2592 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(serverInterfaces); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2596 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(serverInterfaces);
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<Optional<StorageServerInterface>> && serverListValues,int loopDepth) 
	{
															#line 1204 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<StorageServerInterface> serverInterfaces;
															#line 1205 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!serverListValues[s].present())
															#line 2612 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(Optional<std::vector<StorageServerInterface>>()); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2616 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(Optional<std::vector<StorageServerInterface>>());
				this->~TransactionalGetServerInterfacesActorState();
				static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			serverInterfaces.push_back(serverListValues[s].get());
															#line 2624 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV<Optional<std::vector<StorageServerInterface>>>::futures) { (void)(serverInterfaces); this->~TransactionalGetServerInterfacesActorState(); static_cast<TransactionalGetServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 2628 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<TransactionalGetServerInterfacesActor*>(this)->SAV< Optional<std::vector<StorageServerInterface>> >::value()) Optional<std::vector<StorageServerInterface>>(serverInterfaces);
		this->~TransactionalGetServerInterfacesActorState();
		static_cast<TransactionalGetServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<StorageServerInterface>> const& serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(serverListValues, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<Optional<StorageServerInterface>> && serverListValues,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(serverListValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state > 0) static_cast<TransactionalGetServerInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionalGetServerInterfacesActor*>(this)->ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,std::vector<Optional<StorageServerInterface>> const& value) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,std::vector<Optional<StorageServerInterface>> && value) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<UID> ids;
															#line 1197 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<Future<Optional<StorageServerInterface>>> serverListEntries;
															#line 2717 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via transactionalGetServerInterfaces()
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TransactionalGetServerInterfacesActor final : public Actor<Optional<std::vector<StorageServerInterface>>>, public ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >, public FastAllocated<TransactionalGetServerInterfacesActor>, public TransactionalGetServerInterfacesActorState<TransactionalGetServerInterfacesActor> {
															#line 2722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<TransactionalGetServerInterfacesActor>::operator new;
	using FastAllocated<TransactionalGetServerInterfacesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(222827289087715072UL, 13904842440344386816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::vector<StorageServerInterface>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >;
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionalGetServerInterfacesActor(Reference<TransactionState> const& trState,std::vector<UID> const& ids) 
															#line 2739 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Optional<std::vector<StorageServerInterface>>>(),
		   TransactionalGetServerInterfacesActorState<TransactionalGetServerInterfacesActor>(trState, ids),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8960874033469204480UL, 15207940511002765056UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionalGetServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionalGetServerInterfaces");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionalGetServerInterfaces", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionalGetServerInterfacesActor, 0, std::vector<Optional<StorageServerInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<std::vector<StorageServerInterface>>> transactionalGetServerInterfaces( Reference<TransactionState> const& trState, std::vector<UID> const& ids ) {
															#line 1194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<std::vector<StorageServerInterface>>>(new TransactionalGetServerInterfacesActor(trState, ids));
															#line 2772 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

void updateTssMappings(Database cx, const GetKeyServerLocationsReply& reply) {
	// Since a ss -> tss mapping is included in resultsTssMapping iff that SS is in results and has a tss pair,
	// all SS in results that do not have a mapping present must not have a tss pair.
	std::unordered_map<UID, const StorageServerInterface*> ssiById;
	for (const auto& [_, shard] : reply.results) {
		for (auto& ssi : shard) {
			ssiById[ssi.id()] = &ssi;
		}
	}

	for (const auto& mapping : reply.resultsTssMapping) {
		auto ssi = ssiById.find(mapping.first);
		ASSERT(ssi != ssiById.end());
		cx->addTssMapping(*ssi->second, mapping.second);
		ssiById.erase(mapping.first);
	}

	// if SS didn't have a mapping above, it's still in the ssiById map, so remove its tss mapping
	for (const auto& it : ssiById) {
		cx->removeTssMapping(*it.second);
	}
}

void updateTagMappings(Database cx, const GetKeyServerLocationsReply& reply) {
	for (const auto& mapping : reply.resultsTagMapping) {
		cx->addSSIdTagMapping(mapping.first, mapping.second);
	}
}

// If isBackward == true, returns the shard containing the key before 'key' (an infinitely long, inexpressible key).
// Otherwise returns the shard containing key
															#line 2808 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getKeyLocation_internal()
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyLocation_internalActor>
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyLocation_internalActorState {
															#line 2815 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyLocation_internalActorState(Database const& cx,TenantInfo const& tenant,Key const& key,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Reverse const& isBackward,Version const& version) 
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant),
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies),
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   isBackward(isBackward),
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 1255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getKeyLocation"_loc, spanContext)
															#line 2838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getKeyLocation_internal", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyLocation_internalActorState() 
	{
		fdb_probe_actor_destroy("getKeyLocation_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (isBackward)
															#line 2853 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(key != allKeys.begin && key <= allKeys.end);
															#line 2857 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 1259 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(key < allKeys.end);
															#line 2863 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1262 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (debugID.present())
															#line 2867 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.Before");
															#line 2871 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 2875 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1267 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->getBackoff();
															#line 1267 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2908 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 1;
															#line 1267 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 0, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 2913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1293 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_commit_proxy_memory_limit_exceeded)
															#line 2935 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1295 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevWarnAlways, "CommitProxyOverloadedForKeyLocation").suppressFor(5);
															#line 1296 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->updateBackoff(e);
															#line 2941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 1300 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1270 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2964 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, tenant, key, Optional<KeyRef>(), 100, isBackward, version, key.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 2968 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 2;
															#line 1270 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 1, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 1271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 2975 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1270 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2988 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, tenant, key, Optional<KeyRef>(), 100, isBackward, version, key.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 2992 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 2;
															#line 1270 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 1, Void >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 1271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyLocation_internalActor*>(this)));
															#line 2999 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply const& rep,int loopDepth) 
	{
															#line 1277 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1278 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.After");
															#line 3107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size() == 1);
															#line 1283 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		auto locationInfo = cx->setCachedLocation(rep.results[0].first, rep.results[0].second);
															#line 1284 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1287 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1288 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyLocation_internalActor*>(this)->SAV<KeyRangeLocationInfo>::futures) { (void)(KeyRangeLocationInfo( KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena), locationInfo)); this->~GetKeyLocation_internalActorState(); static_cast<GetKeyLocation_internalActor*>(this)->destroy(); return 0; }
															#line 3121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetKeyLocation_internalActor*>(this)->SAV< KeyRangeLocationInfo >::value()) KeyRangeLocationInfo(KeyRangeLocationInfo( KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena), locationInfo));
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply && rep,int loopDepth) 
	{
															#line 1277 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1278 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocation.After");
															#line 3139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size() == 1);
															#line 1283 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		auto locationInfo = cx->setCachedLocation(rep.results[0].first, rep.results[0].second);
															#line 1284 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1287 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1288 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyLocation_internalActor*>(this)->SAV<KeyRangeLocationInfo>::futures) { (void)(KeyRangeLocationInfo( KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena), locationInfo)); this->~GetKeyLocation_internalActorState(); static_cast<GetKeyLocation_internalActor*>(this)->destroy(); return 0; }
															#line 3153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetKeyLocation_internalActor*>(this)->SAV< KeyRangeLocationInfo >::value()) KeyRangeLocationInfo(KeyRangeLocationInfo( KeyRange(toPrefixRelativeRange(rep.results[0].first, tenant.prefix), rep.arena), locationInfo));
		this->~GetKeyLocation_internalActorState();
		static_cast<GetKeyLocation_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocation_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 1, Void >::remove();
		static_cast<GetKeyLocation_internalActor*>(this)->ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply const& value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply && value) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantInfo tenant;
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse isBackward;
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 1255 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 3313 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getKeyLocation_internal()
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyLocation_internalActor final : public Actor<KeyRangeLocationInfo>, public ActorCallback< GetKeyLocation_internalActor, 0, Void >, public ActorCallback< GetKeyLocation_internalActor, 1, Void >, public ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >, public FastAllocated<GetKeyLocation_internalActor>, public GetKeyLocation_internalActorState<GetKeyLocation_internalActor> {
															#line 3318 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetKeyLocation_internalActor>::operator new;
	using FastAllocated<GetKeyLocation_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12402966021642134528UL, 7053365293635271424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<KeyRangeLocationInfo>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyLocation_internalActor, 0, Void >;
friend struct ActorCallback< GetKeyLocation_internalActor, 1, Void >;
friend struct ActorCallback< GetKeyLocation_internalActor, 2, GetKeyServerLocationsReply >;
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyLocation_internalActor(Database const& cx,TenantInfo const& tenant,Key const& key,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Reverse const& isBackward,Version const& version) 
															#line 3337 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<KeyRangeLocationInfo>(),
		   GetKeyLocation_internalActorState<GetKeyLocation_internalActor>(cx, tenant, key, spanContext, debugID, useProvisionalProxies, isBackward, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1277245642794616832UL, 6556686229128886016UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocation_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyLocation_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyLocation_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyLocation_internalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyLocation_internalActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<KeyRangeLocationInfo> getKeyLocation_internal( Database const& cx, TenantInfo const& tenant, Key const& key, SpanContext const& spanContext, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies, Reverse const& isBackward, Version const& version ) {
															#line 1246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<KeyRangeLocationInfo>(new GetKeyLocation_internalActor(cx, tenant, key, spanContext, debugID, useProvisionalProxies, isBackward, version));
															#line 3371 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1304 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Checks if `endpoint` is failed on a healthy server or not. Returns true if we need to refresh the location cache for
// the endpoint.
bool checkOnlyEndpointFailed(const Database& cx, const Endpoint& endpoint) {
	if (IFailureMonitor::failureMonitor().onlyEndpointFailed(endpoint)) {
		// This endpoint is failed, but the server is still healthy. There are two cases this can happen:
		//    - There is a recent bounce in the cluster where the endpoints in SSes get updated.
		//    - The SS is failed and terminated on a server, but the server is kept running.
		// To account for the first case, we invalidate the cache and issue GetKeyLocation requests to the proxy to
		// update the cache with the new SS points. However, if the failure is caused by the second case, the
		// requested key location will continue to be the failed endpoint until the data movement is finished. But
		// every read will generate a GetKeyLocation request to the proxies (and still getting the failed endpoint
		// back), which may overload the proxy and affect data movement speed. Therefore, we only refresh the
		// location cache for short period of time, and after the initial grace period that we keep retrying
		// resolving key location, we will slow it down to resolve it only once every
		// `LOCATION_CACHE_FAILED_ENDPOINT_RETRY_INTERVAL`.
		cx->setFailedEndpointOnHealthyServer(endpoint);
		const auto& failureInfo = cx->getEndpointFailureInfo(endpoint);
		ASSERT(failureInfo.present());
		if (now() - failureInfo.get().startTime < CLIENT_KNOBS->LOCATION_CACHE_ENDPOINT_FAILURE_GRACE_PERIOD ||
		    now() - failureInfo.get().lastRefreshTime > CLIENT_KNOBS->LOCATION_CACHE_FAILED_ENDPOINT_RETRY_INTERVAL) {
			cx->updateFailedEndpointRefreshTime(endpoint);
			return true;
		}
	} else {
		cx->clearFailedEndpointOnHealthyServer(endpoint);
	}
	return false;
}

template <class F>
Future<KeyRangeLocationInfo> getKeyLocation(Database const& cx,
                                            TenantInfo const& tenant,
                                            Key const& key,
                                            F StorageServerInterface::* member,
                                            SpanContext spanContext,
                                            Optional<UID> debugID,
                                            UseProvisionalProxies useProvisionalProxies,
                                            Reverse isBackward,
                                            Version version) {
	// we first check whether this range is cached
	Optional<KeyRangeLocationInfo> locationInfo = cx->getCachedLocation(tenant, key, isBackward);
	if (!locationInfo.present()) {
		return getKeyLocation_internal(
		    cx, tenant, key, spanContext, debugID, useProvisionalProxies, isBackward, version);
	}

	bool onlyEndpointFailedAndNeedRefresh = false;
	for (int i = 0; i < locationInfo.get().locations->size(); i++) {
		if (checkOnlyEndpointFailed(cx, locationInfo.get().locations->get(i, member).getEndpoint())) {
			onlyEndpointFailedAndNeedRefresh = true;
		}
	}

	if (onlyEndpointFailedAndNeedRefresh) {
		cx->invalidateCache(tenant.prefix, key);

		// Refresh the cache with a new getKeyLocations made to proxies.
		return getKeyLocation_internal(
		    cx, tenant, key, spanContext, debugID, useProvisionalProxies, isBackward, version);
	}

	return locationInfo.get();
}

template <class F>
Future<KeyRangeLocationInfo> getKeyLocation(Reference<TransactionState> trState,
                                            Key const& key,
                                            F StorageServerInterface::* member,
                                            Reverse isBackward,
                                            UseTenant useTenant) {
	CODE_PROBE(!useTenant, "Get key location ignoring tenant");
	return getKeyLocation(trState->cx,
	                      useTenant ? trState->getTenantInfo() : TenantInfo(),
	                      key,
	                      member,
	                      trState->spanContext,
	                      trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(),
	                      trState->useProvisionalProxies,
	                      isBackward,
	                      trState->readVersionFuture.isValid() && trState->readVersionFuture.isReady()
	                          ? trState->readVersion()
	                          : latestVersion);
}

void DatabaseContext::updateBackoff(const Error& err) {
	switch (err.code()) {
	case error_code_success:
		backoffDelay = backoffDelay / CLIENT_KNOBS->BACKOFF_GROWTH_RATE;
		if (backoffDelay < CLIENT_KNOBS->DEFAULT_BACKOFF) {
			backoffDelay = 0.0;
		}
		break;

	case error_code_commit_proxy_memory_limit_exceeded:
		++transactionsResourceConstrained;
		if (backoffDelay == 0.0) {
			backoffDelay = CLIENT_KNOBS->DEFAULT_BACKOFF;
		} else {
			backoffDelay = std::min(backoffDelay * CLIENT_KNOBS->BACKOFF_GROWTH_RATE,
			                        CLIENT_KNOBS->RESOURCE_CONSTRAINED_MAX_BACKOFF);
		}
		break;

	default:
		ASSERT_WE_THINK(false);
	}
}

															#line 3484 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getKeyRangeLocations_internal()
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyRangeLocations_internalActor>
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyRangeLocations_internalActorState {
															#line 3491 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyRangeLocations_internalActorState(Database const& cx,TenantInfo const& tenant,KeyRange const& keys,int const& limit,Reverse const& reverse,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Version const& version) 
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant),
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limit(limit),
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies),
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 1423 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getKeyRangeLocations"_loc, spanContext)
															#line 3516 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyRangeLocations_internalActorState() 
	{
		fdb_probe_actor_destroy("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1424 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (debugID.present())
															#line 3531 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1425 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.Before");
															#line 3535 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 3539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyRangeLocations_internalActorState();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->getBackoff();
															#line 1429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3572 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 1;
															#line 1429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3577 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1464 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_commit_proxy_memory_limit_exceeded)
															#line 3599 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1466 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevWarnAlways, "CommitProxyOverloadedForRangeLocation").suppressFor(5);
															#line 1467 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->updateBackoff(e);
															#line 3605 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 1471 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3610 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1430 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1432 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1431 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3628 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, tenant, keys.begin, keys.end, limit, reverse, version, keys.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 3632 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 2;
															#line 1432 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 1433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3639 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1430 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequests;
															#line 1432 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1431 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3652 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetKeyServerLocationsReply> __when_expr_2 = basicLoadBalance( cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getKeyServersLocations, GetKeyServerLocationsRequest( span.context, tenant, keys.begin, keys.end, limit, reverse, version, keys.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 3656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 2;
															#line 1432 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 1433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3663 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply const& _rep,int loopDepth) 
	{
															#line 1439 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1440 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 1441 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3769 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1442 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.After");
															#line 3773 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1444 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size());
															#line 1446 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results = std::vector<KeyRangeLocationInfo>();
															#line 1447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 1448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 3783 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2when2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetKeyServerLocationsReply && _rep,int loopDepth) 
	{
															#line 1439 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionKeyServerLocationRequestsCompleted;
															#line 1440 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 1441 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 3796 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1442 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getKeyLocations.After");
															#line 3800 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1444 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(rep.results.size());
															#line 1446 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results = std::vector<KeyRangeLocationInfo>();
															#line 1447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 1448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 3810 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2when2loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >::remove();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2when2cont1(int loopDepth) 
	{
															#line 1456 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTssMappings(cx, rep);
															#line 1457 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		updateTagMappings(cx, rep);
															#line 1459 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1460 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetKeyRangeLocations_internalActor*>(this)->SAV<std::vector<KeyRangeLocationInfo>>::futures) { (void)(results); this->~GetKeyRangeLocations_internalActorState(); static_cast<GetKeyRangeLocations_internalActor*>(this)->destroy(); return 0; }
															#line 3889 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetKeyRangeLocations_internalActor*>(this)->SAV< std::vector<KeyRangeLocationInfo> >::value()) std::vector<KeyRangeLocationInfo>(std::move(results)); // state_var_RVO
		this->~GetKeyRangeLocations_internalActorState();
		static_cast<GetKeyRangeLocations_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1(int loopDepth) 
	{
															#line 1448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(shard < rep.results.size()))
															#line 3908 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1loopBody1cont2when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1451 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results.emplace_back( (toPrefixRelativeRange(rep.results[shard].first, tenant.prefix) & keys), cx->setCachedLocation(rep.results[shard].first, rep.results[shard].second));
															#line 1454 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1454 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 3;
															#line 1454 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*>(static_cast<GetKeyRangeLocations_internalActor*>(this)));
															#line 3923 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2when2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard++;
															#line 3945 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard++;
															#line 3954 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2when2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2when2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetKeyRangeLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyRangeLocations_internalActor*>(this)->ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply const& value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,GetKeyServerLocationsReply && value) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantInfo tenant;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int limit;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 1423 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1440 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyServerLocationsReply rep;
															#line 1446 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> results;
															#line 1447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 4130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getKeyRangeLocations_internal()
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyRangeLocations_internalActor final : public Actor<std::vector<KeyRangeLocationInfo>>, public ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >, public ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >, public ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >, public ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >, public FastAllocated<GetKeyRangeLocations_internalActor>, public GetKeyRangeLocations_internalActorState<GetKeyRangeLocations_internalActor> {
															#line 4135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetKeyRangeLocations_internalActor>::operator new;
	using FastAllocated<GetKeyRangeLocations_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16377356278491200512UL, 14459257952075957248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRangeLocationInfo>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 2, GetKeyServerLocationsReply >;
friend struct ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >;
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyRangeLocations_internalActor(Database const& cx,TenantInfo const& tenant,KeyRange const& keys,int const& limit,Reverse const& reverse,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Version const& version) 
															#line 4155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<std::vector<KeyRangeLocationInfo>>(),
		   GetKeyRangeLocations_internalActorState<GetKeyRangeLocations_internalActor>(cx, tenant, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7661675249109580544UL, 8773323650101319936UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyRangeLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyRangeLocations_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyRangeLocations_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyRangeLocations_internalActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations_internal( Database const& cx, TenantInfo const& tenant, KeyRange const& keys, int const& limit, Reverse const& reverse, SpanContext const& spanContext, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies, Version const& version ) {
															#line 1413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<std::vector<KeyRangeLocationInfo>>(new GetKeyRangeLocations_internalActor(cx, tenant, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version));
															#line 4190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1475 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Get the SS locations for each shard in the 'keys' key-range;
// Returned vector size is the number of shards in the input keys key-range.
// Returned vector element is <ShardRange, storage server location info> pairs, where
// ShardRange is the whole shard key-range, not a part of the given key range.
// Example: If query the function with  key range (b, d), the returned list of pairs could be something like:
// [([a, b1), locationInfo), ([b1, c), locationInfo), ([c, d1), locationInfo)].
template <class F>
Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations(Database const& cx,
                                                               TenantInfo const& tenant,
                                                               KeyRange const& keys,
                                                               int limit,
                                                               Reverse reverse,
                                                               F StorageServerInterface::* member,
                                                               SpanContext const& spanContext,
                                                               Optional<UID> const& debugID,
                                                               UseProvisionalProxies useProvisionalProxies,
                                                               Version version) {

	ASSERT(!keys.empty());

	std::vector<KeyRangeLocationInfo> locations;
	if (!cx->getCachedLocations(tenant, keys, locations, limit, reverse)) {
		return getKeyRangeLocations_internal(
		    cx, tenant, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version);
	}

	bool foundFailed = false;
	for (const auto& locationInfo : locations) {
		bool onlyEndpointFailedAndNeedRefresh = false;
		for (int i = 0; i < locationInfo.locations->size(); i++) {
			if (checkOnlyEndpointFailed(cx, locationInfo.locations->get(i, member).getEndpoint())) {
				onlyEndpointFailedAndNeedRefresh = true;
			}
		}

		if (onlyEndpointFailedAndNeedRefresh) {
			cx->invalidateCache(tenant.prefix, locationInfo.range.begin);
			foundFailed = true;
		}
	}

	if (foundFailed) {
		// Refresh the cache with a new getKeyRangeLocations made to proxies.
		return getKeyRangeLocations_internal(
		    cx, tenant, keys, limit, reverse, spanContext, debugID, useProvisionalProxies, version);
	}

	return locations;
}

template <class F>
Future<std::vector<KeyRangeLocationInfo>> getKeyRangeLocations(Reference<TransactionState> trState,
                                                               KeyRange const& keys,
                                                               int limit,
                                                               Reverse reverse,
                                                               F StorageServerInterface::* member,
                                                               UseTenant useTenant) {
	CODE_PROBE(!useTenant, "Get key range locations ignoring tenant");
	return getKeyRangeLocations(trState->cx,
	                            useTenant ? trState->getTenantInfo(AllowInvalidTenantID::True) : TenantInfo(),
	                            keys,
	                            limit,
	                            reverse,
	                            member,
	                            trState->spanContext,
	                            trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(),
	                            trState->useProvisionalProxies,
	                            trState->readVersionFuture.isValid() && trState->readVersionFuture.isReady()
	                                ? trState->readVersion()
	                                : latestVersion);
}

															#line 4267 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getBlobGranuleLocations_internal()
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetBlobGranuleLocations_internalActor>
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetBlobGranuleLocations_internalActorState {
															#line 4274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetBlobGranuleLocations_internalActorState(Database const& cx,TenantInfo const& tenant,KeyRange const& keys,int const& limit,Reverse const& reverse,JustGranules const& justGranules,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Version const& version,bool* const& more) 
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limit(limit),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   justGranules(justGranules),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   more(more),
															#line 1560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getBlobGranuleLocations"_loc, spanContext)
															#line 4303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this));

	}
	~GetBlobGranuleLocations_internalActorState() 
	{
		fdb_probe_actor_destroy("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1561 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (debugID.present())
															#line 4318 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "NativeAPI.getBlobGranuleLocations.Before");
															#line 4322 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1564 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(tenant.hasTenant(), "NativeAPI getBlobGranuleLocations has tenant");
															#line 1566 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 4328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBlobGranuleLocations_internalActorState();
		static_cast<GetBlobGranuleLocations_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionBlobGranuleLocationRequests;
															#line 1569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = cx->onProxiesChanged();
															#line 1568 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetBlobGranuleLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4362 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1570 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetBlobGranuleLocationsReply> __when_expr_1 = basicLoadBalance(cx->getCommitProxies(useProvisionalProxies), &CommitProxyInterface::getBlobGranuleLocations, GetBlobGranuleLocationsRequest(span.context, tenant, keys.begin, keys.end, limit, reverse, justGranules, version, keys.arena()), TaskPriority::DefaultPromiseEndpoint);
															#line 4366 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetBlobGranuleLocations_internalActor*>(this)->actor_wait_state = 1;
															#line 1569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBlobGranuleLocations_internalActor, 0, Void >*>(static_cast<GetBlobGranuleLocations_internalActor*>(this)));
															#line 1570 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBlobGranuleLocations_internalActor, 1, GetBlobGranuleLocationsReply >*>(static_cast<GetBlobGranuleLocations_internalActor*>(this)));
															#line 4373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetBlobGranuleLocationsReply const& _rep,int loopDepth) 
	{
															#line 1583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionBlobGranuleLocationRequestsCompleted;
															#line 1584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 1585 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 4404 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1586 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getBlobGranuleLocations.After");
															#line 4408 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1589 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(justGranules || rep.results.size());
															#line 1590 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!rep.more || !rep.results.empty());
															#line 1591 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		*more = rep.more;
															#line 1593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results = std::vector<std::pair<KeyRange, UID>>();
															#line 1594 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		granule = 0;
															#line 1595 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for( auto& bwInterf : rep.bwInterfs ) {
															#line 1596 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->blobWorker_interf.insert({ bwInterf.id(), bwInterf });
															#line 4424 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1598 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 4428 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1when2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetBlobGranuleLocationsReply && _rep,int loopDepth) 
	{
															#line 1583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionBlobGranuleLocationRequestsCompleted;
															#line 1584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 1585 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (debugID.present())
															#line 4441 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1586 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "NativeAPI.getBlobGranuleLocations.After");
															#line 4445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1589 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(justGranules || rep.results.size());
															#line 1590 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!rep.more || !rep.results.empty());
															#line 1591 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		*more = rep.more;
															#line 1593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results = std::vector<std::pair<KeyRange, UID>>();
															#line 1594 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		granule = 0;
															#line 1595 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for( auto& bwInterf : rep.bwInterfs ) {
															#line 1596 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->blobWorker_interf.insert({ bwInterf.id(), bwInterf });
															#line 4461 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1598 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 4465 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1when2loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBlobGranuleLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetBlobGranuleLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlobGranuleLocations_internalActor*>(this)->ActorCallback< GetBlobGranuleLocations_internalActor, 0, Void >::remove();
		static_cast<GetBlobGranuleLocations_internalActor*>(this)->ActorCallback< GetBlobGranuleLocations_internalActor, 1, GetBlobGranuleLocationsReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlobGranuleLocations_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBlobGranuleLocations_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBlobGranuleLocations_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
															#line 1608 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetBlobGranuleLocations_internalActor*>(this)->SAV<std::vector<std::pair<KeyRange, UID>>>::futures) { (void)(results); this->~GetBlobGranuleLocations_internalActorState(); static_cast<GetBlobGranuleLocations_internalActor*>(this)->destroy(); return 0; }
															#line 4538 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetBlobGranuleLocations_internalActor*>(this)->SAV< std::vector<std::pair<KeyRange, UID>> >::value()) std::vector<std::pair<KeyRange, UID>>(std::move(results)); // state_var_RVO
		this->~GetBlobGranuleLocations_internalActorState();
		static_cast<GetBlobGranuleLocations_internalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1(int loopDepth) 
	{
															#line 1598 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(granule < rep.results.size()))
															#line 4557 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1loopBody1when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1600 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		KeyRange range(toPrefixRelativeRange(rep.results[granule].first, tenant.prefix));
															#line 1601 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!justGranules)
															#line 4565 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1602 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			range = range & keys;
															#line 4569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1604 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results.emplace_back(range, rep.results[granule].second);
															#line 1605 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield();
															#line 1605 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetBlobGranuleLocations_internalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4577 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1when2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetBlobGranuleLocations_internalActor*>(this)->actor_wait_state = 2;
															#line 1605 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetBlobGranuleLocations_internalActor, 2, Void >*>(static_cast<GetBlobGranuleLocations_internalActor*>(this)));
															#line 4582 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1598 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		granule++;
															#line 4604 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1598 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		granule++;
															#line 4613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBlobGranuleLocations_internalActor*>(this)->actor_wait_state > 0) static_cast<GetBlobGranuleLocations_internalActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlobGranuleLocations_internalActor*>(this)->ActorCallback< GetBlobGranuleLocations_internalActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlobGranuleLocations_internalActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetBlobGranuleLocations_internalActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetBlobGranuleLocations_internalActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetBlobGranuleLocations_internalActor, 1, GetBlobGranuleLocationsReply >*,GetBlobGranuleLocationsReply const& value) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBlobGranuleLocations_internalActor, 1, GetBlobGranuleLocationsReply >*,GetBlobGranuleLocationsReply && value) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBlobGranuleLocations_internalActor, 1, GetBlobGranuleLocationsReply >*,Error err) 
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantInfo tenant;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int limit;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	JustGranules justGranules;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool* more;
															#line 1560 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetBlobGranuleLocationsReply rep;
															#line 1593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<std::pair<KeyRange, UID>> results;
															#line 1594 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int granule;
															#line 4780 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getBlobGranuleLocations_internal()
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetBlobGranuleLocations_internalActor final : public Actor<std::vector<std::pair<KeyRange, UID>>>, public ActorCallback< GetBlobGranuleLocations_internalActor, 0, Void >, public ActorCallback< GetBlobGranuleLocations_internalActor, 1, GetBlobGranuleLocationsReply >, public ActorCallback< GetBlobGranuleLocations_internalActor, 2, Void >, public FastAllocated<GetBlobGranuleLocations_internalActor>, public GetBlobGranuleLocations_internalActorState<GetBlobGranuleLocations_internalActor> {
															#line 4785 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetBlobGranuleLocations_internalActor>::operator new;
	using FastAllocated<GetBlobGranuleLocations_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5197194664463113216UL, 3720671462941012992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<KeyRange, UID>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBlobGranuleLocations_internalActor, 0, Void >;
friend struct ActorCallback< GetBlobGranuleLocations_internalActor, 1, GetBlobGranuleLocationsReply >;
friend struct ActorCallback< GetBlobGranuleLocations_internalActor, 2, Void >;
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetBlobGranuleLocations_internalActor(Database const& cx,TenantInfo const& tenant,KeyRange const& keys,int const& limit,Reverse const& reverse,JustGranules const& justGranules,SpanContext const& spanContext,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies,Version const& version,bool* const& more) 
															#line 4804 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<std::vector<std::pair<KeyRange, UID>>>(),
		   GetBlobGranuleLocations_internalActorState<GetBlobGranuleLocations_internalActor>(cx, tenant, keys, limit, reverse, justGranules, spanContext, debugID, useProvisionalProxies, version, more),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1026975397208984064UL, 13817401766710445312UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobGranuleLocations_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBlobGranuleLocations_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBlobGranuleLocations_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBlobGranuleLocations_internalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBlobGranuleLocations_internalActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<std::vector<std::pair<KeyRange, UID>>> getBlobGranuleLocations_internal( Database const& cx, TenantInfo const& tenant, KeyRange const& keys, int const& limit, Reverse const& reverse, JustGranules const& justGranules, SpanContext const& spanContext, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies, Version const& version, bool* const& more ) {
															#line 1548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<std::vector<std::pair<KeyRange, UID>>>(new GetBlobGranuleLocations_internalActor(cx, tenant, keys, limit, reverse, justGranules, spanContext, debugID, useProvisionalProxies, version, more));
															#line 4838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Get the Blob Worker locations for each granule in the 'keys' key-range, similar to getKeyRangeLocations
Future<std::vector<std::pair<KeyRange, UID>>> getBlobGranuleLocations(Database const& cx,
                                                                      TenantInfo const& tenant,
                                                                      KeyRange const& keys,
                                                                      int limit,
                                                                      Reverse reverse,
                                                                      JustGranules justGranules,
                                                                      SpanContext const& spanContext,
                                                                      Optional<UID> const& debugID,
                                                                      UseProvisionalProxies useProvisionalProxies,
                                                                      Version version,
                                                                      bool* more) {

	ASSERT(!keys.empty());

	// FIXME: wrap this with location caching for blob workers like getKeyRangeLocations has
	return getBlobGranuleLocations_internal(
	    cx, tenant, keys, limit, reverse, justGranules, spanContext, debugID, useProvisionalProxies, version, more);
}

Future<std::vector<std::pair<KeyRange, UID>>> getBlobGranuleLocations(Reference<TransactionState> trState,
                                                                      KeyRange const& keys,
                                                                      int limit,
                                                                      Reverse reverse,
                                                                      UseTenant useTenant,
                                                                      JustGranules justGranules,
                                                                      bool* more) {
	return getBlobGranuleLocations(
	    trState->cx,
	    useTenant ? trState->getTenantInfo(AllowInvalidTenantID::True) : TenantInfo(),
	    keys,
	    limit,
	    reverse,
	    justGranules,
	    trState->spanContext,
	    trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(),
	    trState->useProvisionalProxies,
	    trState->readVersionFuture.isValid() && trState->readVersionFuture.isReady() ? trState->readVersion()
	                                                                                 : latestVersion,
	    more);
}

															#line 4885 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via warmRange_impl()
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WarmRange_implActor>
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WarmRange_implActorState {
															#line 4892 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WarmRange_implActorState(Reference<TransactionState> const& trState,KeyRange const& keys) 
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 1657 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   totalRanges(0),
															#line 1658 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   totalRequests(0)
															#line 4905 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("warmRange_impl", reinterpret_cast<unsigned long>(this));

	}
	~WarmRange_implActorState() 
	{
		fdb_probe_actor_destroy("warmRange_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 1660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4922 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 1;
															#line 1660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 0, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 4927 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WarmRange_implActorState();
		static_cast<WarmRange_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 4950 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 4959 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1697 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WarmRange_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WarmRange_implActorState(); static_cast<WarmRange_implActor*>(this)->destroy(); return 0; }
															#line 5043 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<WarmRange_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WarmRange_implActorState();
		static_cast<WarmRange_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1663 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_1 = getKeyRangeLocations_internal( trState->cx, trState->getTenantInfo(), keys, CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT, Reverse::False, trState->spanContext, trState->readOptions.present() ? trState->readOptions.get().debugID : Optional<UID>(), trState->useProvisionalProxies, trState->readVersion());
															#line 1663 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5064 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WarmRange_implActor*>(this)->actor_wait_state = 2;
															#line 1663 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*>(static_cast<WarmRange_implActor*>(this)));
															#line 5069 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::vector<KeyRangeLocationInfo> const& locations,int loopDepth) 
	{
															#line 1673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRanges += CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT;
															#line 1674 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRequests++;
															#line 1675 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations.size() == 0 || totalRanges >= trState->cx->locationCacheSize || locations[locations.size() - 1].range.end >= keys.end)
															#line 5095 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1679 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		keys = KeyRangeRef(locations[locations.size() - 1].range.end, keys.end);
															#line 1681 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (totalRequests % 20 == 0)
															#line 5103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(trState->cx, trState->tenant());
															#line 1684 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 5109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(std::vector<KeyRangeLocationInfo> && locations,int loopDepth) 
	{
															#line 1673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRanges += CLIENT_KNOBS->WARM_RANGE_SHARD_LIMIT;
															#line 1674 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		totalRequests++;
															#line 1675 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations.size() == 0 || totalRanges >= trState->cx->locationCacheSize || locations[locations.size() - 1].range.end >= keys.end)
															#line 5127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1679 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		keys = KeyRangeRef(locations[locations.size() - 1].range.end, keys.end);
															#line 1681 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (totalRequests % 20 == 0)
															#line 5135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr = Transaction(trState->cx, trState->tenant());
															#line 1684 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 5141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<KeyRangeLocationInfo> const& locations,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(locations, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(std::vector<KeyRangeLocationInfo> && locations,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(locations), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1686 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1687 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tr.setOption(FDBTransactionOptions::CAUSAL_READ_RISKY);
															#line 1688 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(tr.getReadVersion());
															#line 1688 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 3;
															#line 1688 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 2, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 5261 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1691 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1691 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WarmRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5298 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<WarmRange_implActor*>(this)->actor_wait_state = 4;
															#line 1691 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WarmRange_implActor, 3, Void >*>(static_cast<WarmRange_implActor*>(this)));
															#line 5303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WarmRange_implActor*>(this)->actor_wait_state > 0) static_cast<WarmRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<WarmRange_implActor*>(this)->ActorCallback< WarmRange_implActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WarmRange_implActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WarmRange_implActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 1657 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int totalRanges;
															#line 1658 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int totalRequests;
															#line 1683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Transaction tr;
															#line 5498 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via warmRange_impl()
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WarmRange_implActor final : public Actor<Void>, public ActorCallback< WarmRange_implActor, 0, Void >, public ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >, public ActorCallback< WarmRange_implActor, 2, Void >, public ActorCallback< WarmRange_implActor, 3, Void >, public FastAllocated<WarmRange_implActor>, public WarmRange_implActorState<WarmRange_implActor> {
															#line 5503 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WarmRange_implActor>::operator new;
	using FastAllocated<WarmRange_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14795085460409510656UL, 12214768946601142272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WarmRange_implActor, 0, Void >;
friend struct ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< WarmRange_implActor, 2, Void >;
friend struct ActorCallback< WarmRange_implActor, 3, Void >;
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WarmRange_implActor(Reference<TransactionState> const& trState,KeyRange const& keys) 
															#line 5523 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   WarmRange_implActorState<WarmRange_implActor>(trState, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("warmRange_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8548379736654756608UL, 17106069152090307840UL);
		ActorExecutionContextHelper __helper(static_cast<WarmRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("warmRange_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("warmRange_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WarmRange_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WarmRange_implActor, 1, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WarmRange_implActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WarmRange_implActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> warmRange_impl( Reference<TransactionState> const& trState, KeyRange const& keys ) {
															#line 1656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WarmRange_implActor(trState, keys));
															#line 5559 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1699 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

SpanContext generateSpanID(bool transactionTracingSample, SpanContext parentContext = SpanContext()) {
	if (parentContext.isValid()) {
		return SpanContext(parentContext.traceID, deterministicRandom()->randomUInt64(), parentContext.m_Flags);
	}
	if (transactionTracingSample) {
		return SpanContext(deterministicRandom()->randomUniqueID(),
		                   deterministicRandom()->randomUInt64(),
		                   deterministicRandom()->random01() <= FLOW_KNOBS->TRACING_SAMPLE_RATE
		                       ? TraceFlags::sampled
		                       : TraceFlags::unsampled);
	}
	return SpanContext(
	    deterministicRandom()->randomUniqueID(), deterministicRandom()->randomUInt64(), TraceFlags::unsampled);
}

															#line 5579 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via lookupTenantImpl()
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class LookupTenantImplActor>
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class LookupTenantImplActorState {
															#line 5586 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	LookupTenantImplActorState(DatabaseContext* const& cx,TenantName const& tenant) 
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant)
															#line 5595 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("lookupTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	~LookupTenantImplActorState() 
	{
		fdb_probe_actor_destroy("lookupTenantImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1716 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 5610 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LookupTenantImplActorState();
		static_cast<LookupTenantImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->getBackoff();
															#line 1718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 1;
															#line 1718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 0, Void >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 5648 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1733 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_commit_proxy_memory_limit_exceeded)
															#line 5670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				CODE_PROBE(true, "Lookup tenant memory limit exceeded");
															#line 1735 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevWarnAlways, "CommitProxyOverloadedForTenant").suppressFor(5);
															#line 1737 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->updateBackoff(e);
															#line 5678 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 1741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionTenantLookupRequests;
															#line 1722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1721 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5701 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1723 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetTenantIdReply> __when_expr_2 = basicLoadBalance(cx->getCommitProxies(UseProvisionalProxies::False), &CommitProxyInterface::getTenantId, GetTenantIdRequest(tenant, latestVersion), TaskPriority::DefaultPromiseEndpoint);
															#line 5705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 2;
															#line 1722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 1, Void >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 1723 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 5712 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionTenantLookupRequests;
															#line 1722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cx->onProxiesChanged();
															#line 1721 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5725 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 1723 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetTenantIdReply> __when_expr_2 = basicLoadBalance(cx->getCommitProxies(UseProvisionalProxies::False), &CommitProxyInterface::getTenantId, GetTenantIdRequest(tenant, latestVersion), TaskPriority::DefaultPromiseEndpoint);
															#line 5729 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
		static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 2;
															#line 1722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 1, Void >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 1723 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*>(static_cast<LookupTenantImplActor*>(this)));
															#line 5736 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state > 0) static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<LookupTenantImplActor*>(this)->ActorCallback< LookupTenantImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LookupTenantImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetTenantIdReply const& rep,int loopDepth) 
	{
															#line 1727 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionTenantLookupRequestsCompleted;
															#line 1728 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1729 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<LookupTenantImplActor*>(this)->SAV<int64_t>::futures) { (void)(rep.tenantId); this->~LookupTenantImplActorState(); static_cast<LookupTenantImplActor*>(this)->destroy(); return 0; }
															#line 5842 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<LookupTenantImplActor*>(this)->SAV< int64_t >::value()) int64_t(rep.tenantId);
		this->~LookupTenantImplActorState();
		static_cast<LookupTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(GetTenantIdReply && rep,int loopDepth) 
	{
															#line 1727 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++cx->transactionTenantLookupRequestsCompleted;
															#line 1728 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->updateBackoff(success());
															#line 1729 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<LookupTenantImplActor*>(this)->SAV<int64_t>::futures) { (void)(rep.tenantId); this->~LookupTenantImplActorState(); static_cast<LookupTenantImplActor*>(this)->destroy(); return 0; }
															#line 5858 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<LookupTenantImplActor*>(this)->SAV< int64_t >::value()) int64_t(rep.tenantId);
		this->~LookupTenantImplActorState();
		static_cast<LookupTenantImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LookupTenantImplActor*>(this)->actor_wait_state > 0) static_cast<LookupTenantImplActor*>(this)->actor_wait_state = 0;
		static_cast<LookupTenantImplActor*>(this)->ActorCallback< LookupTenantImplActor, 1, Void >::remove();
		static_cast<LookupTenantImplActor*>(this)->ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >::remove();

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LookupTenantImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*,GetTenantIdReply const& value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*,GetTenantIdReply && value) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >*,Error err) 
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	DatabaseContext* cx;
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantName tenant;
															#line 6004 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via lookupTenantImpl()
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class LookupTenantImplActor final : public Actor<int64_t>, public ActorCallback< LookupTenantImplActor, 0, Void >, public ActorCallback< LookupTenantImplActor, 1, Void >, public ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >, public FastAllocated<LookupTenantImplActor>, public LookupTenantImplActorState<LookupTenantImplActor> {
															#line 6009 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<LookupTenantImplActor>::operator new;
	using FastAllocated<LookupTenantImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9397275339658157568UL, 10899994950037443584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LookupTenantImplActor, 0, Void >;
friend struct ActorCallback< LookupTenantImplActor, 1, Void >;
friend struct ActorCallback< LookupTenantImplActor, 2, GetTenantIdReply >;
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	LookupTenantImplActor(DatabaseContext* const& cx,TenantName const& tenant) 
															#line 6028 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<int64_t>(),
		   LookupTenantImplActorState<LookupTenantImplActor>(cx, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lookupTenantImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11585582208618864384UL, 12455856959616988672UL);
		ActorExecutionContextHelper __helper(static_cast<LookupTenantImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lookupTenantImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lookupTenantImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LookupTenantImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LookupTenantImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<int64_t> lookupTenantImpl( DatabaseContext* const& cx, TenantName const& tenant ) {
															#line 1715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<int64_t>(new LookupTenantImplActor(cx, tenant));
															#line 6062 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1745 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<int64_t> DatabaseContext::lookupTenant(TenantName tenant) {
	return lookupTenantImpl(this, tenant);
}

TransactionState::TransactionState(Database cx,
                                   Optional<Reference<Tenant>> tenant,
                                   TaskPriority taskID,
                                   SpanContext spanContext,
                                   Reference<TransactionLogInfo> trLogInfo)
  : cx(cx), trLogInfo(trLogInfo), options(cx), taskID(taskID), spanContext(spanContext),
    readVersionObtainedFromGrvProxy(true), tenant_(tenant), tenantSet(tenant.present()) {}

Reference<TransactionState> TransactionState::cloneAndReset(Reference<TransactionLogInfo> newTrLogInfo,
                                                            bool generateNewSpan) const {

	SpanContext newSpanContext = generateNewSpan ? generateSpanID(cx->transactionTracingSample) : spanContext;
	Reference<TransactionState> newState =
	    makeReference<TransactionState>(cx, tenant_, cx->taskID, newSpanContext, newTrLogInfo);

	if (!cx->apiVersionAtLeast(16)) {
		newState->options = options;
	}

	newState->readVersionFuture = Future<Version>();
	newState->metadataVersion = Promise<Optional<Key>>();
	newState->numErrors = numErrors;
	newState->startTime = startTime;
	newState->committedVersion = committedVersion;
	newState->conflictingKeys = conflictingKeys;
	newState->tenantSet = tenantSet;

	return newState;
}

TenantInfo TransactionState::getTenantInfo(AllowInvalidTenantID allowInvalidTenantId /* = false */) {
	Optional<Reference<Tenant>> const& t = tenant();

	if (options.rawAccess) {
		CODE_PROBE(true, "Get tenant info raw access transaction");
		return TenantInfo();
	} else if (!cx->internal && cx->clientInfo->get().clusterType == ClusterType::METACLUSTER_MANAGEMENT) {
		CODE_PROBE(true, "Get tenant info invalid management cluster access", probe::decoration::rare);
		throw management_cluster_invalid_access();
	} else if (!cx->internal && cx->clientInfo->get().tenantMode == TenantMode::REQUIRED && !t.present()) {
		CODE_PROBE(true, "Get tenant info tenant name required", probe::decoration::rare);
		throw tenant_name_required();
	} else if (!t.present()) {
		CODE_PROBE(true, "Get tenant info without tenant");
		return TenantInfo();
	} else if (cx->clientInfo->get().tenantMode == TenantMode::DISABLED && t.present()) {
		// If we are running provisional proxies, we allow a tenant request to go through since we don't know the tenant
		// mode. Such a transaction would not be allowed to commit without enabling provisional commits because either
		// the commit proxies will be provisional or the read version will be too old.
		if (!cx->clientInfo->get().grvProxies.empty() && !cx->clientInfo->get().grvProxies[0].provisional) {
			CODE_PROBE(true, "Get tenant info use tenant in disabled tenant mode", probe::decoration::rare);
			throw tenants_disabled();
		} else {
			CODE_PROBE(true, "Get tenant info provisional proxies");
			ASSERT(!useProvisionalProxies);
		}
	}

	ASSERT(t.present() && (allowInvalidTenantId || t.get()->id() != TenantInfo::INVALID_TENANT));
	return TenantInfo(
	    (allowInvalidTenantId && !t.get()->ready().isReady()) ? TenantInfo::INVALID_TENANT : t.get()->id(), authToken);
}

// Returns the tenant used in this transaction. If the tenant is unset and raw access isn't specified, then the default
// tenant from DatabaseContext is applied to this transaction (note: the default tenant is typically unset, but in
// simulation could be something different).
//
// This function should not be called in the transaction constructor or in the setOption function to allow a user the
// opportunity to set raw access.
Optional<Reference<Tenant>> const& TransactionState::tenant() {
	hasTenant(ResolveDefaultTenant::True);
	return tenant_;
}

// Returns true if the tenant has been set, but does not cause default tenant resolution. This is useful in setOption
// (where we do not want to call tenant()) if we want to enforce that an option not be set on a Tenant transaction (e.g.
// for raw access).
bool TransactionState::hasTenant(ResolveDefaultTenant resolveDefaultTenant) {
	if (!tenantSet && resolveDefaultTenant) {
		if (!options.rawAccess && cx->defaultTenant.present()) {
			tenant_ = makeReference<Tenant>(cx->lookupTenant(cx->defaultTenant.get()), cx->defaultTenant);
		}
		tenantSet = true;
	}

	return tenant_.present();
}

															#line 6159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via startTransaction()
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class StartTransactionActor>
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class StartTransactionActorState {
															#line 6166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	StartTransactionActorState(Reference<TransactionState> const& trState) 
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState)
															#line 6173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("startTransaction", reinterpret_cast<unsigned long>(this));

	}
	~StartTransactionActorState() 
	{
		fdb_probe_actor_destroy("startTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1839 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(trState->readVersionFuture);
															#line 1839 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<StartTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartTransactionActor*>(this)->actor_wait_state = 1;
															#line 1839 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartTransactionActor, 0, Void >*>(static_cast<StartTransactionActor*>(this)));
															#line 6195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartTransactionActorState();
		static_cast<StartTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1840 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->hasTenant())
															#line 6218 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_1 = trState->tenant().get()->ready();
															#line 1841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<StartTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StartTransactionActor*>(this)->actor_wait_state = 2;
															#line 1841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartTransactionActor, 1, Void >*>(static_cast<StartTransactionActor*>(this)));
															#line 6229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1840 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->hasTenant())
															#line 6243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_1 = trState->tenant().get()->ready();
															#line 1841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<StartTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6249 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StartTransactionActor*>(this)->actor_wait_state = 2;
															#line 1841 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartTransactionActor, 1, Void >*>(static_cast<StartTransactionActor*>(this)));
															#line 6254 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartTransactionActor*>(this)->actor_wait_state > 0) static_cast<StartTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<StartTransactionActor*>(this)->ActorCallback< StartTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1844 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<StartTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTransactionActorState(); static_cast<StartTransactionActor*>(this)->destroy(); return 0; }
															#line 6343 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<StartTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartTransactionActorState();
		static_cast<StartTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartTransactionActor*>(this)->actor_wait_state > 0) static_cast<StartTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<StartTransactionActor*>(this)->ActorCallback< StartTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 6440 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via startTransaction()
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class StartTransactionActor final : public Actor<Void>, public ActorCallback< StartTransactionActor, 0, Void >, public ActorCallback< StartTransactionActor, 1, Void >, public FastAllocated<StartTransactionActor>, public StartTransactionActorState<StartTransactionActor> {
															#line 6445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<StartTransactionActor>::operator new;
	using FastAllocated<StartTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14219154835634395392UL, 9311787484739576576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartTransactionActor, 0, Void >;
friend struct ActorCallback< StartTransactionActor, 1, Void >;
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	StartTransactionActor(Reference<TransactionState> const& trState) 
															#line 6463 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   StartTransactionActorState<StartTransactionActor>(trState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7927092769933293824UL, 16612754116029991424UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> startTransaction( Reference<TransactionState> const& trState ) {
															#line 1838 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new StartTransactionActor(trState));
															#line 6497 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 1846 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Void> TransactionState::startTransaction(uint32_t readVersionFlags) {
	if (!startFuture.isValid()) {
		if (!readVersionFuture.isValid()) {
			readVersionFuture = getReadVersion(readVersionFlags);
		}
		if (readVersionFuture.isReady() && (!hasTenant() || tenant().get()->ready().isReady())) {
			startFuture = Void();
		} else {
			startFuture = ::startTransaction(Reference<TransactionState>::addRef(this));
		}
	}

	return startFuture;
}

Future<Void> Transaction::warmRange(KeyRange keys) {
	return warmRange_impl(trState, keys);
}

namespace {

template <class Interface, class Request, bool P>
Future<REPLY_TYPE(Request)> loadBalance(
    DatabaseContext* ctx,
    const Reference<LocationInfo> alternatives,
    RequestStream<Request, P> Interface::* channel,
    const Request& request = Request(),
    TaskPriority taskID = TaskPriority::DefaultPromiseEndpoint,
    AtMostOnce atMostOnce =
        AtMostOnce::False, // if true, throws request_maybe_delivered() instead of retrying automatically
    QueueModel* model = nullptr,
    bool compareReplicas = false,
    int requiredReplicas = 0) {
	if (alternatives->hasCaches) {
		return loadBalance(
		    alternatives->locations(), channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas);
	}
	return fmap(
	    [ctx](auto const& res) {
		    if (res.cached) {
			    ctx->updateCache.trigger();
		    }
		    return res;
	    },
	    loadBalance(
	        alternatives->locations(), channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas));
}
} // namespace

															#line 6551 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getValue()
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetValueActor>
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetValueActorState {
															#line 6558 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueActorState(Reference<TransactionState> const& trState,Key const& key,UseTenant const& useTenant,TransactionRecordLogInfo const& recordLogInfo) 
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant),
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   recordLogInfo(recordLogInfo)
															#line 6571 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getValue", reinterpret_cast<unsigned long>(this));

	}
	~GetValueActorState() 
	{
		fdb_probe_actor_destroy("getValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 1900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6588 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetValueActor*>(this)->actor_wait_state = 1;
															#line 1900 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 0, Void >*>(static_cast<GetValueActor*>(this)));
															#line 6593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetValueActorState();
		static_cast<GetValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getValue has tenant");
															#line 1904 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getValue"_loc, trState->spanContext);
															#line 1905 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (useTenant && trState->hasTenant())
															#line 6620 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			span.addAttribute("tenant"_sr, trState->tenant().get()->name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr));
															#line 6624 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1910 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 1912 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 6630 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getValue has tenant");
															#line 1904 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getValue"_loc, trState->spanContext);
															#line 1905 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (useTenant && trState->hasTenant())
															#line 6643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			span.addAttribute("tenant"_sr, trState->tenant().get()->name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr));
															#line 6647 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1910 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 1912 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 6653 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetValueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation(trState, key, &StorageServerInterface::getValue, Reverse::False, useTenant);
															#line 1913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6746 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetValueActor*>(this)->actor_wait_state = 2;
															#line 1913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*>(static_cast<GetValueActor*>(this)));
															#line 6751 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1916 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getValueID = Optional<UID>();
															#line 1917 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = uint64_t();
															#line 1918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTimeD = double();
															#line 1919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssLatestCommitVersions = VersionVector();
															#line 1920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 1922 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locationInfo.locations, trState, ssLatestCommitVersions);
															#line 6770 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 1924 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 6774 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 1925 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				getValueID = nondeterministicRandom()->randomUniqueID();
															#line 1926 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				readOptions.get().debugID = getValueID;
															#line 1928 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addAttach( "GetValueAttachID", trState->readOptions.get().debugID.get().first(), getValueID.get().first());
															#line 1930 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.Before");
															#line 6784 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 1939 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->getValueSubmitted;
															#line 1940 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			startTime = timer_int();
															#line 1941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			startTimeD = now();
															#line 1942 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 1944 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			reply = GetValueReply();
															#line 6796 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			try {
															#line 1946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (CLIENT_BUGGIFY_WITH_PROB(.01))
															#line 6800 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 1947 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					return a_body1cont1loopBody1cont1Catch2(deterministicRandom()->randomChoice( std::vector<Error>{ transaction_too_old(), future_version() }), loopDepth);
															#line 6804 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 1951 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_2 = trState->cx->connectionFileChanged();
															#line 1950 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 6810 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 1954 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetValueReply> __when_expr_3 = loadBalance(trState->cx.getPtr(), locationInfo.locations, &StorageServerInterface::getValue, GetValueRequest(span.context, useTenant ? trState->getTenantInfo() : TenantInfo(), key, trState->readVersion(), trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>(), readOptions, ssLatestCommitVersions), TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 6814 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
				static_cast<GetValueActor*>(this)->actor_wait_state = 3;
															#line 1951 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 2, Void >*>(static_cast<GetValueActor*>(this)));
															#line 1954 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 3, GetValueReply >*>(static_cast<GetValueActor*>(this)));
															#line 6821 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 1913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 6842 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2010 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->cx->getValueCompleted->latency = timer_int() - startTime;
															#line 2011 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->cx->getValueCompleted->log();
															#line 2012 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getValueID.present())
															#line 6932 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2013 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.Error");
															#line 6936 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2021 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 6940 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2022 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(useTenant ? trState->tenant().mapRef(&Tenant::prefix) : Optional<KeyRef>(), key);
															#line 2024 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 2024 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6948 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<GetValueActor*>(this)->actor_wait_state = 4;
															#line 2024 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetValueActor, 4, Void >*>(static_cast<GetValueActor*>(this)));
															#line 6953 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2026 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (trState->trLogInfo && recordLogInfo)
															#line 6960 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2027 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					trState->trLogInfo->addLog( FdbClientLogEvents::EventGetError(startTimeD, trState->cx->clientLocality.dcId(), static_cast<int>(e.code()), key, trState->tenant().flatMapRef(&Tenant::name)));
															#line 6964 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 2033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6968 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 1980 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		double latency = now() - startTimeD;
															#line 1981 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->readLatencies.addSample(latency);
															#line 1982 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->trLogInfo && recordLogInfo)
															#line 6987 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1983 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			int valueSize = reply.value.present() ? reply.value.get().size() : 0;
															#line 1984 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			trState->trLogInfo->addLog(FdbClientLogEvents::EventGet(startTimeD, trState->cx->clientLocality.dcId(), latency, valueSize, key, trState->tenant().flatMapRef(&Tenant::name)));
															#line 6993 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 1991 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getValueCompleted->latency = timer_int() - startTime;
															#line 1992 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getValueCompleted->log();
															#line 1993 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->totalCost += getReadOperationCost(key.size() + (reply.value.present() ? reply.value.get().size() : 0));
															#line 1996 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getValueID.present())
															#line 7003 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 1997 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("GetValueDebug", getValueID.get().first(), "NativeAPI.getValue.After");
															#line 7007 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2006 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionBytesRead += reply.value.present() ? reply.value.get().size() : 0;
															#line 2007 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionKeysRead;
															#line 2008 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetValueActor*>(this)->SAV<Optional<Value>>::futures) { (void)(reply.value); this->~GetValueActorState(); static_cast<GetValueActor*>(this)->destroy(); return 0; }
															#line 7015 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetValueActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(reply.value);
		this->~GetValueActorState();
		static_cast<GetValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1976 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 1977 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont1loopBody1cont1Catch1(__current_error, loopDepth);
															#line 7030 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 1974 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 7044 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1952 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 7053 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 1952 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 7061 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetValueReply const& _reply,int loopDepth) 
	{
															#line 1971 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 7069 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetValueReply && _reply,int loopDepth) 
	{
															#line 1971 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 7078 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 2, Void >::remove();
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 3, GetValueReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 3, GetValueReply >*,GetValueReply const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 3, GetValueReply >*,GetValueReply && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetValueActor, 3, GetValueReply >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetValueActor*>(this)->actor_wait_state > 0) static_cast<GetValueActor*>(this)->actor_wait_state = 0;
		static_cast<GetValueActor*>(this)->ActorCallback< GetValueActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetValueActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetValueActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetValueActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TransactionRecordLogInfo recordLogInfo;
															#line 1904 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 1913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 1916 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getValueID;
															#line 1917 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	uint64_t startTime;
															#line 1918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTimeD;
															#line 1919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	VersionVector ssLatestCommitVersions;
															#line 1920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<ReadOptions> readOptions;
															#line 1944 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueReply reply;
															#line 7334 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getValue()
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetValueActor final : public Actor<Optional<Value>>, public ActorCallback< GetValueActor, 0, Void >, public ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >, public ActorCallback< GetValueActor, 2, Void >, public ActorCallback< GetValueActor, 3, GetValueReply >, public ActorCallback< GetValueActor, 4, Void >, public FastAllocated<GetValueActor>, public GetValueActorState<GetValueActor> {
															#line 7339 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetValueActor>::operator new;
	using FastAllocated<GetValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1868098901741725184UL, 11551776886878962176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetValueActor, 0, Void >;
friend struct ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetValueActor, 2, Void >;
friend struct ActorCallback< GetValueActor, 3, GetValueReply >;
friend struct ActorCallback< GetValueActor, 4, Void >;
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetValueActor(Reference<TransactionState> const& trState,Key const& key,UseTenant const& useTenant,TransactionRecordLogInfo const& recordLogInfo) 
															#line 7360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   GetValueActorState<GetValueActor>(trState, key, useTenant, recordLogInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4269006456623515904UL, 18410873568439542016UL);
		ActorExecutionContextHelper __helper(static_cast<GetValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetValueActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetValueActor, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetValueActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetValueActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getValue( Reference<TransactionState> const& trState, Key const& key, UseTenant const& useTenant, TransactionRecordLogInfo const& recordLogInfo ) {
															#line 1896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Optional<Value>>(new GetValueActor(trState, key, useTenant, recordLogInfo));
															#line 7396 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2038 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 7401 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getKey()
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyActor>
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyActorState {
															#line 7408 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyActorState(Reference<TransactionState> const& trState,KeySelector const& k,UseTenant const& useTenant = UseTenant::True) 
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   k(k),
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant)
															#line 7419 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getKey", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyActorState() 
	{
		fdb_probe_actor_destroy("getKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2040 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(!useTenant, "Get key ignoring tenant");
															#line 2041 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 2041 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyActor*>(this)->actor_wait_state = 1;
															#line 2041 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 0, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 7443 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyActorState();
		static_cast<GetKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2043 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getKey has tenant");
															#line 2045 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getKeyID = Optional<UID>();
															#line 2046 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 2048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getKey"_loc, trState->spanContext);
															#line 2049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 7474 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2050 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getKeyID = nondeterministicRandom()->randomUniqueID();
															#line 2051 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			readOptions.get().debugID = getKeyID;
															#line 2053 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "GetKeyAttachID", trState->readOptions.get().debugID.get().first(), getKeyID.get().first());
															#line 2055 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.AfterVersion");
															#line 7484 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2062 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 7488 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2043 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getKey has tenant");
															#line 2045 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getKeyID = Optional<UID>();
															#line 2046 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		readOptions = trState->readOptions;
															#line 2048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		span = Span("NAPI:getKey"_loc, trState->spanContext);
															#line 2049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 7505 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2050 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getKeyID = nondeterministicRandom()->randomUniqueID();
															#line 2051 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			readOptions.get().debugID = getKeyID;
															#line 2053 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "GetKeyAttachID", trState->readOptions.get().debugID.get().first(), getKeyID.get().first());
															#line 2055 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.AfterVersion");
															#line 7515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2062 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 7519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2063 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (k.getKey() == allKeys.end)
															#line 7610 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2064 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (k.offset > 0)
															#line 7614 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2065 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(allKeys.end); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 7618 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(allKeys.end);
				this->~GetKeyActorState();
				static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2067 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			k.orEqual = false;
															#line 7626 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 2068 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (k.getKey() == allKeys.begin && k.offset <= 0)
															#line 7632 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2069 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(Key()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 7636 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(Key());
				this->~GetKeyActorState();
				static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 2072 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Key locationKey(k.getKey(), k.arena());
															#line 2073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation( trState, locationKey, &StorageServerInterface::getKey, Reverse{ k.isBackward() }, useTenant);
															#line 2073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7649 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyActor*>(this)->actor_wait_state = 2;
															#line 2073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*>(static_cast<GetKeyActor*>(this)));
															#line 7654 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2076 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssLatestCommitVersions = VersionVector();
															#line 2077 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locationInfo.locations, trState, ssLatestCommitVersions);
															#line 7665 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 2080 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getKeyID.present())
															#line 7669 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2081 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent( "GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.Before");
															#line 7673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2086 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 2088 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			GetKeyRequest req(span.context, useTenant ? trState->getTenantInfo() : TenantInfo(), k, trState->readVersion(), trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>(), readOptions, ssLatestCommitVersions);
															#line 2095 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(k.arena());
															#line 2097 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			reply = GetKeyReply();
															#line 7683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			try {
															#line 2100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_2 = trState->cx->connectionFileChanged();
															#line 2099 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 7689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 2103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyReply> __when_expr_3 = loadBalance(trState->cx.getPtr(), locationInfo.locations, &StorageServerInterface::getKey, req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 7693 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont1when2(__when_expr_3.get(), loopDepth); };
				static_cast<GetKeyActor*>(this)->actor_wait_state = 3;
															#line 2100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 2, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 2103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 3, GetKeyReply >*>(static_cast<GetKeyActor*>(this)));
															#line 7700 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 2073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 7721 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getKeyID.present())
															#line 7807 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.Error");
															#line 7811 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 7815 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2134 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(useTenant ? trState->tenant().mapRef(&Tenant::prefix) : Optional<KeyRef>(), k.getKey(), Reverse{ k.isBackward() });
															#line 2138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 2138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7823 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<GetKeyActor*>(this)->actor_wait_state = 4;
															#line 2138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetKeyActor, 4, Void >*>(static_cast<GetKeyActor*>(this)));
															#line 7828 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2140 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevInfo, "GetKeyError").error(e).detail("AtKey", k.getKey()).detail("Offset", k.offset);
															#line 2141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7837 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
															#line 2121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getKeyID.present())
															#line 7852 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2122 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("GetKeyDebug", getKeyID.get().first(), "NativeAPI.getKey.After");
															#line 7856 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2126 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		k = reply.sel;
															#line 2127 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!k.offset && k.orEqual)
															#line 7862 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetKeyActor*>(this)->SAV<Key>::futures) { (void)(k.getKey()); this->~GetKeyActorState(); static_cast<GetKeyActor*>(this)->destroy(); return 0; }
															#line 7866 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetKeyActor*>(this)->SAV< Key >::value()) Key(k.getKey());
			this->~GetKeyActorState();
			static_cast<GetKeyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 2118 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 2119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont1loopBody1cont1Catch1(__current_error, loopDepth);
															#line 7883 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(int loopDepth) 
	{
															#line 2116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 7897 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 2101 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 7906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 2101 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1cont1loopBody1cont1Catch2(transaction_too_old(), loopDepth);
															#line 7914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetKeyReply const& _reply,int loopDepth) 
	{
															#line 2113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 7922 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when2(GetKeyReply && _reply,int loopDepth) 
	{
															#line 2113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		reply = _reply;
															#line 7931 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 2, Void >::remove();
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 3, GetKeyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 3, GetKeyReply >*,GetKeyReply const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 3, GetKeyReply >*,GetKeyReply && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 3, GetKeyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont15(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetKeyActor*>(this)->actor_wait_state > 0) static_cast<GetKeyActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyActor*>(this)->ActorCallback< GetKeyActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetKeyActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetKeyActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector k;
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 2045 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getKeyID;
															#line 2046 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<ReadOptions> readOptions;
															#line 2048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 2076 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	VersionVector ssLatestCommitVersions;
															#line 2097 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyReply reply;
															#line 8194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getKey()
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetKeyActor final : public Actor<Key>, public ActorCallback< GetKeyActor, 0, Void >, public ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >, public ActorCallback< GetKeyActor, 2, Void >, public ActorCallback< GetKeyActor, 3, GetKeyReply >, public ActorCallback< GetKeyActor, 4, Void >, public FastAllocated<GetKeyActor>, public GetKeyActorState<GetKeyActor> {
															#line 8199 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetKeyActor>::operator new;
	using FastAllocated<GetKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17392163130406216192UL, 8942206416385532928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyActor, 0, Void >;
friend struct ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetKeyActor, 2, Void >;
friend struct ActorCallback< GetKeyActor, 3, GetKeyReply >;
friend struct ActorCallback< GetKeyActor, 4, Void >;
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyActor(Reference<TransactionState> const& trState,KeySelector const& k,UseTenant const& useTenant = UseTenant::True) 
															#line 8220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Key>(),
		   GetKeyActorState<GetKeyActor>(trState, k, useTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3161838746568296704UL, 16159820804706226432UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyActor, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetKeyActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Key> getKey( Reference<TransactionState> const& trState, KeySelector const& k, UseTenant const& useTenant = UseTenant::True ) {
															#line 2039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Key>(new GetKeyActor(trState, k, useTenant));
															#line 8256 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2146 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 8261 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForCommittedVersion()
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WaitForCommittedVersionActor>
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WaitForCommittedVersionActorState {
															#line 8268 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WaitForCommittedVersionActorState(Database const& cx,Version const& version,SpanContext const& spanContext) 
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   version(version),
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 2148 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:waitForCommittedVersion"_loc, spanContext)
															#line 8281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~WaitForCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("waitForCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 8296 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForCommittedVersionActorState();
		static_cast<WaitForCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cx->onProxiesChanged();
															#line 2151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<GetReadVersionReply> __when_expr_1 = basicLoadBalance( cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::getConsistentReadVersion, GetReadVersionRequest( span.context, 0, TransactionPriority::IMMEDIATE, cx->ssVersionVectorCache.getMaxVersion()), cx->taskID);
															#line 8333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 2152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 0, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 2153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 8340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2177 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_batch_transaction_throttled || e.code() == error_code_grv_proxy_memory_limit_exceeded)
															#line 8362 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2180 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delayJittered(CLIENT_KNOBS->GRV_ERROR_RETRY_DELAY);
															#line 2180 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 3;
															#line 2180 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 3, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 8373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "WaitForCommittedVersionError").error(e);
															#line 2183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 8382 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply const& v,int loopDepth) 
	{
															#line 2159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->minAcceptableReadVersion = std::min(cx->minAcceptableReadVersion, v.version);
															#line 2160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.midShardSize > 0)
															#line 8417 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->smoothMidShardSize.setTotal(v.midShardSize);
															#line 8421 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 8425 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (cx->isCurrentGrvProxy(v.proxyId))
															#line 8429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 8433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.clear();
															#line 8439 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.version >= version)
															#line 8444 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WaitForCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~WaitForCommittedVersionActorState(); static_cast<WaitForCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 8448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WaitForCommittedVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
			this->~WaitForCommittedVersionActorState();
			static_cast<WaitForCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, cx->taskID);
															#line 2173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8458 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 2173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 2, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 8463 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply && v,int loopDepth) 
	{
															#line 2159 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		cx->minAcceptableReadVersion = std::min(cx->minAcceptableReadVersion, v.version);
															#line 2160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.midShardSize > 0)
															#line 8474 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->smoothMidShardSize.setTotal(v.midShardSize);
															#line 8478 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2162 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 8482 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (cx->isCurrentGrvProxy(v.proxyId))
															#line 8486 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 8490 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->ssVersionVectorCache.clear();
															#line 8496 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v.version >= version)
															#line 8501 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WaitForCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~WaitForCommittedVersionActorState(); static_cast<WaitForCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 8505 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WaitForCommittedVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
			this->~WaitForCommittedVersionActorState();
			static_cast<WaitForCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, cx->taskID);
															#line 2173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 2173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForCommittedVersionActor, 2, Void >*>(static_cast<WaitForCommittedVersionActor*>(this)));
															#line 8520 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 0, Void >::remove();
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<WaitForCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForCommittedVersionActor*>(this)->ActorCallback< WaitForCommittedVersionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitForCommittedVersionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version version;
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 2148 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 8847 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via waitForCommittedVersion()
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WaitForCommittedVersionActor final : public Actor<Version>, public ActorCallback< WaitForCommittedVersionActor, 0, Void >, public ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >, public ActorCallback< WaitForCommittedVersionActor, 2, Void >, public ActorCallback< WaitForCommittedVersionActor, 3, Void >, public FastAllocated<WaitForCommittedVersionActor>, public WaitForCommittedVersionActorState<WaitForCommittedVersionActor> {
															#line 8852 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WaitForCommittedVersionActor>::operator new;
	using FastAllocated<WaitForCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2538716726210486016UL, 12963675567204385024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForCommittedVersionActor, 0, Void >;
friend struct ActorCallback< WaitForCommittedVersionActor, 1, GetReadVersionReply >;
friend struct ActorCallback< WaitForCommittedVersionActor, 2, Void >;
friend struct ActorCallback< WaitForCommittedVersionActor, 3, Void >;
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WaitForCommittedVersionActor(Database const& cx,Version const& version,SpanContext const& spanContext) 
															#line 8872 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Version>(),
		   WaitForCommittedVersionActorState<WaitForCommittedVersionActor>(cx, version, spanContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9303840678792357376UL, 476365445843715840UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForCommittedVersionActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> waitForCommittedVersion( Database const& cx, Version const& version, SpanContext const& spanContext ) {
															#line 2147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new WaitForCommittedVersionActor(cx, version, spanContext));
															#line 8907 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2188 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 8912 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRawVersion()
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRawVersionActor>
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRawVersionActorState {
															#line 8919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRawVersionActorState(Reference<TransactionState> const& trState) 
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getRawVersion"_loc, trState->spanContext)
															#line 8928 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRawVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetRawVersionActorState() 
	{
		fdb_probe_actor_destroy("getRawVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 8943 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_0 = trState->cx->onProxiesChanged();
															#line 2192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRawVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8975 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<GetReadVersionReply> __when_expr_1 = basicLoadBalance(trState->cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::getConsistentReadVersion, GetReadVersionRequest(trState->spanContext, 0, TransactionPriority::IMMEDIATE, trState->cx->ssVersionVectorCache.getMaxVersion()), trState->cx->taskID);
															#line 8979 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetRawVersionActor*>(this)->actor_wait_state = 1;
															#line 2193 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRawVersionActor, 0, Void >*>(static_cast<GetRawVersionActor*>(this)));
															#line 2194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*>(static_cast<GetRawVersionActor*>(this)));
															#line 8986 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply const& v,int loopDepth) 
	{
															#line 2202 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 9013 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->cx->isCurrentGrvProxy(v.proxyId))
															#line 9017 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2204 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 9021 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.clear();
															#line 9027 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2209 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRawVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~GetRawVersionActorState(); static_cast<GetRawVersionActor*>(this)->destroy(); return 0; }
															#line 9032 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRawVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply && v,int loopDepth) 
	{
															#line 2202 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->cx->versionVectorCacheActive(v.ssVersionVectorDelta))
															#line 9044 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->cx->isCurrentGrvProxy(v.proxyId))
															#line 9048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2204 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.applyDelta(v.ssVersionVectorDelta);
															#line 9052 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2206 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->ssVersionVectorCache.clear();
															#line 9058 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2209 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRawVersionActor*>(this)->SAV<Version>::futures) { (void)(v.version); this->~GetRawVersionActorState(); static_cast<GetRawVersionActor*>(this)->destroy(); return 0; }
															#line 9063 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRawVersionActor*>(this)->SAV< Version >::value()) Version(v.version);
		this->~GetRawVersionActorState();
		static_cast<GetRawVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRawVersionActor*>(this)->actor_wait_state > 0) static_cast<GetRawVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetRawVersionActor*>(this)->ActorCallback< GetRawVersionActor, 0, Void >::remove();
		static_cast<GetRawVersionActor*>(this)->ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRawVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 9196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRawVersion()
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRawVersionActor final : public Actor<Version>, public ActorCallback< GetRawVersionActor, 0, Void >, public ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >, public FastAllocated<GetRawVersionActor>, public GetRawVersionActorState<GetRawVersionActor> {
															#line 9201 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRawVersionActor>::operator new;
	using FastAllocated<GetRawVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1552891744644120064UL, 11577360458759807744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRawVersionActor, 0, Void >;
friend struct ActorCallback< GetRawVersionActor, 1, GetReadVersionReply >;
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRawVersionActor(Reference<TransactionState> const& trState) 
															#line 9219 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Version>(),
		   GetRawVersionActorState<GetRawVersionActor>(trState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRawVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6451071362418865408UL, 866680570832095232UL);
		ActorExecutionContextHelper __helper(static_cast<GetRawVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRawVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRawVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRawVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> getRawVersion( Reference<TransactionState> const& trState ) {
															#line 2189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new GetRawVersionActor(trState));
															#line 9252 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2214 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 9257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
[[nodiscard]] Future<Void> readVersionBatcher( DatabaseContext* const& cx, FutureStream<std::pair<Promise<GetReadVersionReply>, Optional<UID>>> const& versionStream, uint32_t const& flags );

#line 2219 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 9262 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via watchValue()
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchValueActor>
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueActorState {
															#line 9269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueActorState(Database const& cx,Reference<const WatchParameters> const& parameters) 
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   parameters(parameters),
															#line 2221 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:watchValue"_loc, parameters->spanContext),
															#line 2222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ver(parameters->version)
															#line 9282 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("watchValue", reinterpret_cast<unsigned long>(this));

	}
	~WatchValueActorState() 
	{
		fdb_probe_actor_destroy("watchValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2223 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->validateVersion(parameters->version);
															#line 2224 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(parameters->version != latestVersion);
															#line 2226 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(parameters->tenant.hasTenant(), "NativeAPI watchValue has tenant");
															#line 2228 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 9303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchValueActorState();
		static_cast<WatchValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_0 = getKeyLocation(cx, parameters->tenant, parameters->key, &StorageServerInterface::watchValue, parameters->spanContext, parameters->debugID, parameters->useProvisionalProxies, Reverse::False, parameters->version);
															#line 2229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9335 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 1;
															#line 2229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*>(static_cast<WatchValueActor*>(this)));
															#line 9340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 2239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			watchValueID = Optional<UID>();
															#line 2240 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (parameters->debugID.present())
															#line 9352 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2241 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				watchValueID = nondeterministicRandom()->randomUniqueID();
															#line 2243 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addAttach( "WatchValueAttachID", parameters->debugID.get().first(), watchValueID.get().first());
															#line 2245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Before");
															#line 9360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2249 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			resp = WatchValueReply();
															#line 2251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<WatchValueReply> __when_expr_1 = loadBalance(cx.getPtr(), locationInfo.locations, &StorageServerInterface::watchValue, WatchValueRequest(span.context, parameters->tenant, parameters->key, parameters->value, ver, cx->sampleReadTags() ? parameters->tags : Optional<TagSet>(), watchValueID), TaskPriority::DefaultPromiseEndpoint);
															#line 2250 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 2265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = cx->connectionRecord ? cx->connectionRecord->onChange() : Never();
															#line 9372 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<WatchValueActor*>(this)->actor_wait_state = 2;
															#line 2251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 1, WatchValueReply >*>(static_cast<WatchValueActor*>(this)));
															#line 2265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 2, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 2229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 9394 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2295 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 9480 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2296 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->invalidateCache(parameters->tenant.prefix, parameters->key);
															#line 2297 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_5 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, parameters->taskID);
															#line 2297 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9488 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<WatchValueActor*>(this)->actor_wait_state = 5;
															#line 2297 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 5, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9493 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2298 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (e.code() == error_code_watch_cancelled || e.code() == error_code_process_behind)
															#line 9500 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2300 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(e.code() == error_code_watch_cancelled, "Too many watches on the storage server, poll for changes instead");
															#line 2301 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(e.code() == error_code_process_behind, "The storage servers are all behind", probe::decoration::rare);
															#line 2303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					StrictFuture<Void> __when_expr_6 = delay(CLIENT_KNOBS->WATCH_POLLING_TIME, parameters->taskID);
															#line 2303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9510 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when2(__when_expr_6.get(), loopDepth); };
					static_cast<WatchValueActor*>(this)->actor_wait_state = 6;
															#line 2303 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 6, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 2304 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (e.code() == error_code_timed_out)
															#line 9522 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 2306 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						CODE_PROBE(true, "A watch timed out");
															#line 2307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						StrictFuture<Void> __when_expr_7 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, parameters->taskID);
															#line 2307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
						if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when3(__when_expr_7.get(), loopDepth); };
						static_cast<WatchValueActor*>(this)->actor_wait_state = 7;
															#line 2307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 7, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9535 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 2309 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						err = e;
															#line 2310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						StrictFuture<Void> __when_expr_8 = delay(CLIENT_KNOBS->FUTURE_VERSION_RETRY_DELAY, parameters->taskID);
															#line 2310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9546 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
						if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when4(__when_expr_8.get(), loopDepth); };
						static_cast<WatchValueActor*>(this)->actor_wait_state = 8;
															#line 2310 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 8, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9551 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
						loopDepth = 0;
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 9569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2270 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.After");
															#line 9573 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Version> __when_expr_4 = waitForCommittedVersion(cx, resp.version, span.context);
															#line 2276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9579 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 4;
															#line 2276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 4, Version >*>(static_cast<WatchValueActor*>(this)));
															#line 9584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(WatchValueReply const& r,int loopDepth) 
	{
															#line 2263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		resp = r;
															#line 9593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(WatchValueReply && r,int loopDepth) 
	{
															#line 2263 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		resp = r;
															#line 9602 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
															#line 2266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 2266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1when2when1(__when_expr_3.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 3;
															#line 2266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 3, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9618 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
															#line 2266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = Never();
															#line 2266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9629 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1when2when1(__when_expr_3.get(), loopDepth); };
		static_cast<WatchValueActor*>(this)->actor_wait_state = 3;
															#line 2266 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WatchValueActor, 3, Void >*>(static_cast<WatchValueActor*>(this)));
															#line 9634 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 1, WatchValueReply >::remove();
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 1, WatchValueReply >*,WatchValueReply const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 1, WatchValueReply >*,WatchValueReply && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 1, WatchValueReply >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1when2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Version const& v,int loopDepth) 
	{
															#line 2284 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool buggifyRetry = g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.1);
															#line 2285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(buggifyRetry, "Watch buggifying version gap retry");
															#line 2286 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v - resp.version < 50'000'000 && !buggifyRetry)
															#line 9855 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2287 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchValueActor*>(this)->SAV<Version>::futures) { (void)(resp.version); this->~WatchValueActorState(); static_cast<WatchValueActor*>(this)->destroy(); return 0; }
															#line 9859 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WatchValueActor*>(this)->SAV< Version >::value()) Version(resp.version);
			this->~WatchValueActorState();
			static_cast<WatchValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2289 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = v;
															#line 2291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 9869 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Retry");
															#line 9873 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Version && v,int loopDepth) 
	{
															#line 2284 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool buggifyRetry = g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.1);
															#line 2285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(buggifyRetry, "Watch buggifying version gap retry");
															#line 2286 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (v - resp.version < 50'000'000 && !buggifyRetry)
															#line 9887 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2287 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchValueActor*>(this)->SAV<Version>::futures) { (void)(resp.version); this->~WatchValueActorState(); static_cast<WatchValueActor*>(this)->destroy(); return 0; }
															#line 9891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WatchValueActor*>(this)->SAV< Version >::value()) Version(resp.version);
			this->~WatchValueActorState();
			static_cast<WatchValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2289 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = v;
															#line 2291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchValueID.present())
															#line 9901 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("WatchValueDebug", watchValueID.get().first(), "NativeAPI.watchValue.Retry");
															#line 9905 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 4, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 4, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 4, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 4, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1Catch1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1Catch1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont1Catch1cont7(Void const& _,int loopDepth) 
	{
															#line 2311 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 10282 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont7(Void && _,int loopDepth) 
	{
															#line 2311 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 10290 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<WatchValueActor*>(this)->actor_wait_state > 0) static_cast<WatchValueActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueActor*>(this)->ActorCallback< WatchValueActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1Catch1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< WatchValueActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont1Catch1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< WatchValueActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<const WatchParameters> parameters;
															#line 2221 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2222 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version ver;
															#line 2229 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 2239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> watchValueID;
															#line 2249 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueReply resp;
															#line 2309 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Error err;
															#line 10385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via watchValue()
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueActor final : public Actor<Version>, public ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >, public ActorCallback< WatchValueActor, 1, WatchValueReply >, public ActorCallback< WatchValueActor, 2, Void >, public ActorCallback< WatchValueActor, 3, Void >, public ActorCallback< WatchValueActor, 4, Version >, public ActorCallback< WatchValueActor, 5, Void >, public ActorCallback< WatchValueActor, 6, Void >, public ActorCallback< WatchValueActor, 7, Void >, public ActorCallback< WatchValueActor, 8, Void >, public FastAllocated<WatchValueActor>, public WatchValueActorState<WatchValueActor> {
															#line 10390 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WatchValueActor>::operator new;
	using FastAllocated<WatchValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13625710064835209984UL, 1018531911817129216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >;
friend struct ActorCallback< WatchValueActor, 1, WatchValueReply >;
friend struct ActorCallback< WatchValueActor, 2, Void >;
friend struct ActorCallback< WatchValueActor, 3, Void >;
friend struct ActorCallback< WatchValueActor, 4, Version >;
friend struct ActorCallback< WatchValueActor, 5, Void >;
friend struct ActorCallback< WatchValueActor, 6, Void >;
friend struct ActorCallback< WatchValueActor, 7, Void >;
friend struct ActorCallback< WatchValueActor, 8, Void >;
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueActor(Database const& cx,Reference<const WatchParameters> const& parameters) 
															#line 10415 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Version>(),
		   WatchValueActorState<WatchValueActor>(cx, parameters),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2460336902643348224UL, 8395577603832240640UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchValueActor, 0, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchValueActor, 1, WatchValueReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WatchValueActor, 3, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WatchValueActor, 4, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WatchValueActor, 5, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WatchValueActor, 6, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WatchValueActor, 7, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< WatchValueActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Version> watchValue( Database const& cx, Reference<const WatchParameters> const& parameters ) {
															#line 2220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Version>(new WatchValueActor(cx, parameters));
															#line 10455 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2316 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 10460 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via watchStorageServerResp()
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchStorageServerRespActor>
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchStorageServerRespActorState {
															#line 10467 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchStorageServerRespActorState(int64_t const& tenantId,Key const& key,Database const& cx) 
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : tenantId(tenantId),
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   cx(cx)
															#line 10478 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("watchStorageServerResp", reinterpret_cast<unsigned long>(this));

	}
	~WatchStorageServerRespActorState() 
	{
		fdb_probe_actor_destroy("watchStorageServerResp", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2318 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 10493 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchStorageServerRespActorState();
		static_cast<WatchStorageServerRespActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2320 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata = cx->getWatchMetadata(tenantId, key);
															#line 2321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!metadata.isValid())
															#line 10526 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2322 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 10530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchStorageServerRespActorState();
				static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = watchValue(cx, metadata->parameters);
															#line 2324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10540 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state = 1;
															#line 2324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchStorageServerRespActor, 0, Version >*>(static_cast<WatchStorageServerRespActor*>(this)));
															#line 10545 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2347 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 10567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 10571 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2351 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			Reference<WatchMetadata> metadata = cx->getWatchMetadata(tenantId, key);
															#line 2352 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!metadata.isValid())
															#line 10577 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2353 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 10581 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchStorageServerRespActorState();
				static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 2354 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 10591 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2355 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					cx->deleteWatchMetadata(tenantId, key);
															#line 2356 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 10597 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~WatchStorageServerRespActorState();
					static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 2357 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (e.code() == error_code_future_version)
															#line 10607 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
						return a_body1loopHead1(loopDepth); // continue
					}
				}
			}
															#line 2360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(tenantId, key);
															#line 2361 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchPromise.sendError(e);
															#line 2362 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 10619 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& watchVersion,int loopDepth) 
	{
															#line 2326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		metadata = cx->getWatchMetadata(tenantId, key);
															#line 2327 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!metadata.isValid())
															#line 10635 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 10639 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WatchStorageServerRespActorState();
			static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2331 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchVersion >= metadata->parameters->version)
															#line 10647 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2332 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(tenantId, key);
															#line 2333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.canBeSet())
															#line 10653 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2334 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				metadata->watchPromise.send(watchVersion);
															#line 10657 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		else
		{
															#line 2338 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "ABA issue where the version returned from the server is less than the version in the map");
															#line 2342 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 10666 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2343 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->deleteWatchMetadata(tenantId, key);
															#line 10670 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && watchVersion,int loopDepth) 
	{
															#line 2326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		metadata = cx->getWatchMetadata(tenantId, key);
															#line 2327 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!metadata.isValid())
															#line 10683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2328 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<WatchStorageServerRespActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchStorageServerRespActorState(); static_cast<WatchStorageServerRespActor*>(this)->destroy(); return 0; }
															#line 10687 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<WatchStorageServerRespActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WatchStorageServerRespActorState();
			static_cast<WatchStorageServerRespActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2331 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (watchVersion >= metadata->parameters->version)
															#line 10695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2332 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(tenantId, key);
															#line 2333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.canBeSet())
															#line 10701 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2334 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				metadata->watchPromise.send(watchVersion);
															#line 10705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		else
		{
															#line 2338 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "ABA issue where the version returned from the server is less than the version in the map");
															#line 2342 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (metadata->watchPromise.getFutureReferenceCount() == 1)
															#line 10714 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2343 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				cx->deleteWatchMetadata(tenantId, key);
															#line 10718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& watchVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(watchVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && watchVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(watchVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state > 0) static_cast<WatchStorageServerRespActor*>(this)->actor_wait_state = 0;
		static_cast<WatchStorageServerRespActor*>(this)->ActorCallback< WatchStorageServerRespActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchStorageServerRespActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int64_t tenantId;
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2320 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<WatchMetadata> metadata;
															#line 10821 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via watchStorageServerResp()
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchStorageServerRespActor final : public Actor<Void>, public ActorCallback< WatchStorageServerRespActor, 0, Version >, public FastAllocated<WatchStorageServerRespActor>, public WatchStorageServerRespActorState<WatchStorageServerRespActor> {
															#line 10826 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WatchStorageServerRespActor>::operator new;
	using FastAllocated<WatchStorageServerRespActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16434783200509710848UL, 9081420513738989568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchStorageServerRespActor, 0, Version >;
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchStorageServerRespActor(int64_t const& tenantId,Key const& key,Database const& cx) 
															#line 10843 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   WatchStorageServerRespActorState<WatchStorageServerRespActor>(tenantId, key, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchStorageServerResp", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5937245291561340160UL, 16097796804231101184UL);
		ActorExecutionContextHelper __helper(static_cast<WatchStorageServerRespActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchStorageServerResp");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchStorageServerResp", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchStorageServerRespActor, 0, Version >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> watchStorageServerResp( int64_t const& tenantId, Key const& key, Database const& cx ) {
															#line 2317 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WatchStorageServerRespActor(tenantId, key, cx));
															#line 10876 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2366 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 10881 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via sameVersionDiffValue()
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class SameVersionDiffValueActor>
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SameVersionDiffValueActorState {
															#line 10888 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SameVersionDiffValueActorState(Database const& cx,Reference<WatchParameters> const& parameters) 
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : cx(cx),
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   parameters(parameters),
															#line 2368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tr(cx, parameters->tenant.hasTenant() ? makeReference<Tenant>(parameters->tenant.tenantId) : Optional<Reference<Tenant>>())
															#line 10899 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("sameVersionDiffValue", reinterpret_cast<unsigned long>(this));

	}
	~SameVersionDiffValueActorState() 
	{
		fdb_probe_actor_destroy("sameVersionDiffValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 10914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SameVersionDiffValueActorState();
		static_cast<SameVersionDiffValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2375 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!parameters->tenant.hasTenant())
															#line 10945 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2376 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 10949 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(parameters->key);
															#line 2379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10955 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 1;
															#line 2379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 10960 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2407 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 2407 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10984 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 3;
															#line 2407 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 2, Void >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 10989 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2380 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reference<WatchMetadata> metadata = cx->getWatchMetadata(parameters->tenant.tenantId, parameters->key);
															#line 2383 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (metadata.isValid() && valSS != metadata->parameters->value)
															#line 11006 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2384 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->deleteWatchMetadata(parameters->tenant.tenantId, parameters->key);
															#line 2386 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchPromise.send(parameters->version);
															#line 2387 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchFutureSS.cancel();
															#line 11014 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2391 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (valSS == parameters->value && tr.getTransactionState()->tenantId() == parameters->tenant.tenantId)
															#line 11018 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2392 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata = makeReference<WatchMetadata>(parameters);
															#line 2393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			cx->setWatchMetadata(metadata);
															#line 2395 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			metadata->watchFutureSS = watchStorageServerResp(parameters->tenant.tenantId, parameters->key, cx);
															#line 11026 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2399 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (valSS != parameters->value)
															#line 11030 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2400 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<SameVersionDiffValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SameVersionDiffValueActorState(); static_cast<SameVersionDiffValueActor*>(this)->destroy(); return 0; }
															#line 11034 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<SameVersionDiffValueActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SameVersionDiffValueActorState();
			static_cast<SameVersionDiffValueActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2403 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(metadata->watchPromise.getFuture());
															#line 2403 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11044 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 2;
															#line 2403 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SameVersionDiffValueActor, 1, Void >*>(static_cast<SameVersionDiffValueActor*>(this)));
															#line 11049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __valSS,int loopDepth) 
	{
															#line 2379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		valSS = __valSS;
															#line 11058 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __valSS,int loopDepth) 
	{
		valSS = std::move(__valSS);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 2405 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SameVersionDiffValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SameVersionDiffValueActorState(); static_cast<SameVersionDiffValueActor*>(this)->destroy(); return 0; }
															#line 11137 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<SameVersionDiffValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SameVersionDiffValueActorState();
		static_cast<SameVersionDiffValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 2405 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<SameVersionDiffValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SameVersionDiffValueActorState(); static_cast<SameVersionDiffValueActor*>(this)->destroy(); return 0; }
															#line 11149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<SameVersionDiffValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SameVersionDiffValueActorState();
		static_cast<SameVersionDiffValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state > 0) static_cast<SameVersionDiffValueActor*>(this)->actor_wait_state = 0;
		static_cast<SameVersionDiffValueActor*>(this)->ActorCallback< SameVersionDiffValueActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SameVersionDiffValueActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<WatchParameters> parameters;
															#line 2368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<Value> valSS;
															#line 11327 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via sameVersionDiffValue()
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class SameVersionDiffValueActor final : public Actor<Void>, public ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >, public ActorCallback< SameVersionDiffValueActor, 1, Void >, public ActorCallback< SameVersionDiffValueActor, 2, Void >, public FastAllocated<SameVersionDiffValueActor>, public SameVersionDiffValueActorState<SameVersionDiffValueActor> {
															#line 11332 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<SameVersionDiffValueActor>::operator new;
	using FastAllocated<SameVersionDiffValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14403982513682257408UL, 123059752630676480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >;
friend struct ActorCallback< SameVersionDiffValueActor, 1, Void >;
friend struct ActorCallback< SameVersionDiffValueActor, 2, Void >;
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SameVersionDiffValueActor(Database const& cx,Reference<WatchParameters> const& parameters) 
															#line 11351 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   SameVersionDiffValueActorState<SameVersionDiffValueActor>(cx, parameters),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1345293727184951296UL, 14775766526751535104UL);
		ActorExecutionContextHelper __helper(static_cast<SameVersionDiffValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sameVersionDiffValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sameVersionDiffValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SameVersionDiffValueActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> sameVersionDiffValue( Database const& cx, Reference<WatchParameters> const& parameters ) {
															#line 2367 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new SameVersionDiffValueActor(cx, parameters));
															#line 11386 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2411 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Void> getWatchFuture(Database cx, Reference<WatchParameters> parameters) {
	Reference<WatchMetadata> metadata = cx->getWatchMetadata(parameters->tenant.tenantId, parameters->key);

	// case 1: key not in map
	if (!metadata.isValid()) {
		metadata = makeReference<WatchMetadata>(parameters);
		cx->setWatchMetadata(metadata);

		metadata->watchFutureSS = watchStorageServerResp(parameters->tenant.tenantId, parameters->key, cx);
		return success(metadata->watchPromise.getFuture());
	}
	// case 2: val_1 == val_2 (received watch with same value as key already in the map so just update)
	else if (metadata->parameters->value == parameters->value) {
		if (parameters->version > metadata->parameters->version) {
			metadata->parameters = parameters;
		}

		return success(metadata->watchPromise.getFuture());
	}
	// case 3: val_1 != val_2 && version_2 > version_1 (received watch with different value and a higher version so
	// recreate in SS)
	else if (parameters->version > metadata->parameters->version) {
		CODE_PROBE(true,
		           "Setting a watch that has a different value than the one in the map but a higher version (newer)");
		cx->deleteWatchMetadata(parameters->tenant.tenantId, parameters->key);

		metadata->watchPromise.send(parameters->version);
		metadata->watchFutureSS.cancel();

		metadata = makeReference<WatchMetadata>(parameters);
		cx->setWatchMetadata(metadata);

		metadata->watchFutureSS = watchStorageServerResp(parameters->tenant.tenantId, parameters->key, cx);

		return success(metadata->watchPromise.getFuture());
	}
	// case 5: val_1 != val_2 && version_1 == version_2 (received watch with different value but same version)
	else if (metadata->parameters->version == parameters->version) {
		CODE_PROBE(true, "Setting a watch which has a different value than the one in the map but the same version");
		return sameVersionDiffValue(cx, parameters);
	}
	CODE_PROBE(true, "Setting a watch which has a different value than the one in the map but a lower version (older)");

	// case 4: val_1 != val_2 && version_2 < version_1
	return Void();
}

namespace {

// NOTE: Since an ACTOR could receive multiple exceptions for a single catch clause, e.g. broken promise together with
// operation cancelled, If the decreaseWatchRefCount is placed at the catch clause, it might be triggered for multiple
// times. One could check if the SAV isSet, but seems a more intuitive way is to use RAII-style constructor/destructor
// pair. Yet the object has to be constructed after a wait statement, so it must be trivially-constructible. This
// requires move-assignment operator implemented.
class WatchRefCountUpdater {
	Database cx;
	int64_t tenantID;
	KeyRef key;
	Version version;

public:
	WatchRefCountUpdater() = default;

	WatchRefCountUpdater(const Database& cx_, const int64_t tenantID_, KeyRef key_, const Version& ver)
	  : cx(cx_), tenantID(tenantID_), key(key_), version(ver) {}

	WatchRefCountUpdater& operator=(WatchRefCountUpdater&& other) {
		if (cx.getReference()) {
			cx->decreaseWatchRefCount(tenantID, key, version);
		}

		cx = std::move(other.cx);
		tenantID = std::move(other.tenantID);
		key = std::move(other.key);
		version = std::move(other.version);

		cx->increaseWatchRefCount(tenantID, key, version);

		return *this;
	}

	~WatchRefCountUpdater() {
		if (cx.getReference()) {
			cx->decreaseWatchRefCount(tenantID, key, version);
		}
	}
};

} // namespace

															#line 11481 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via watchValueMap()
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class WatchValueMapActor>
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueMapActorState {
															#line 11488 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueMapActorState(Future<Version> const& version,TenantInfo const& tenant,Key const& key,Optional<Value> const& value,Database const& cx,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : version(version),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tenant(tenant),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   key(key),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   value(value),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   cx(cx),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tags(tags),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   taskID(taskID),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   debugID(debugID),
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useProvisionalProxies(useProvisionalProxies)
															#line 11513 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("watchValueMap", reinterpret_cast<unsigned long>(this));

	}
	~WatchValueMapActorState() 
	{
		fdb_probe_actor_destroy("watchValueMap", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Version> __when_expr_0 = version;
															#line 2512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<WatchValueMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchValueMapActor*>(this)->actor_wait_state = 1;
															#line 2512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchValueMapActor, 0, Version >*>(static_cast<WatchValueMapActor*>(this)));
															#line 11535 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2513 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		watchRefCountUpdater = WatchRefCountUpdater(cx, tenant.tenantId, key, ver);
															#line 2515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_1 = getWatchFuture(cx, makeReference<WatchParameters>( tenant, key, value, ver, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 2515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WatchValueMapActor*>(this)->actor_wait_state = 2;
															#line 2515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchValueMapActor, 1, Void >*>(static_cast<WatchValueMapActor*>(this)));
															#line 11567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __ver,int loopDepth) 
	{
															#line 2512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ver = __ver;
															#line 11576 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __ver,int loopDepth) 
	{
		ver = std::move(__ver);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state > 0) static_cast<WatchValueMapActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueMapActor*>(this)->ActorCallback< WatchValueMapActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchValueMapActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WatchValueMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueMapActorState(); static_cast<WatchValueMapActor*>(this)->destroy(); return 0; }
															#line 11655 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<WatchValueMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<WatchValueMapActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchValueMapActorState(); static_cast<WatchValueMapActor*>(this)->destroy(); return 0; }
															#line 11667 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<WatchValueMapActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchValueMapActorState();
		static_cast<WatchValueMapActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchValueMapActor*>(this)->actor_wait_state > 0) static_cast<WatchValueMapActor*>(this)->actor_wait_state = 0;
		static_cast<WatchValueMapActor*>(this)->ActorCallback< WatchValueMapActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchValueMapActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchValueMapActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Version> version;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TenantInfo tenant;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key key;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<Value> value;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Database cx;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TagSet tags;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TaskPriority taskID;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> debugID;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseProvisionalProxies useProvisionalProxies;
															#line 2512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Version ver;
															#line 2513 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchRefCountUpdater watchRefCountUpdater;
															#line 11774 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via watchValueMap()
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class WatchValueMapActor final : public Actor<Void>, public ActorCallback< WatchValueMapActor, 0, Version >, public ActorCallback< WatchValueMapActor, 1, Void >, public FastAllocated<WatchValueMapActor>, public WatchValueMapActorState<WatchValueMapActor> {
															#line 11779 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<WatchValueMapActor>::operator new;
	using FastAllocated<WatchValueMapActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6683790747947378944UL, 3239116993986854912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchValueMapActor, 0, Version >;
friend struct ActorCallback< WatchValueMapActor, 1, Void >;
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	WatchValueMapActor(Future<Version> const& version,TenantInfo const& tenant,Key const& key,Optional<Value> const& value,Database const& cx,TagSet const& tags,SpanContext const& spanContext,TaskPriority const& taskID,Optional<UID> const& debugID,UseProvisionalProxies const& useProvisionalProxies) 
															#line 11797 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   WatchValueMapActorState<WatchValueMapActor>(version, tenant, key, value, cx, tags, spanContext, taskID, debugID, useProvisionalProxies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchValueMap", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15055311216113119744UL, 3063023898867388672UL);
		ActorExecutionContextHelper __helper(static_cast<WatchValueMapActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchValueMap");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchValueMap", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchValueMapActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchValueMapActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> watchValueMap( Future<Version> const& version, TenantInfo const& tenant, Key const& key, Optional<Value> const& value, Database const& cx, TagSet const& tags, SpanContext const& spanContext, TaskPriority const& taskID, Optional<UID> const& debugID, UseProvisionalProxies const& useProvisionalProxies ) {
															#line 2502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new WatchValueMapActor(version, tenant, key, value, cx, tags, spanContext, taskID, debugID, useProvisionalProxies));
															#line 11831 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2521 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

template <class GetKeyValuesFamilyRequest>
void transformRangeLimits(GetRangeLimits limits, Reverse reverse, GetKeyValuesFamilyRequest& req) {
	if (limits.bytes != 0) {
		if (!limits.hasRowLimit())
			req.limit = CLIENT_KNOBS->REPLY_BYTE_LIMIT; // Can't get more than this many rows anyway
		else
			req.limit = std::min(CLIENT_KNOBS->REPLY_BYTE_LIMIT, limits.rows);

		if (reverse)
			req.limit *= -1;

		if (!limits.hasByteLimit())
			req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
		else
			req.limitBytes = std::min(CLIENT_KNOBS->REPLY_BYTE_LIMIT, limits.bytes);
	} else {
		req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
		req.limit = reverse ? -limits.minRows : limits.minRows;
	}
}

template <class GetKeyValuesFamilyRequest>
PublicRequestStream<GetKeyValuesFamilyRequest> StorageServerInterface::* getRangeRequestStream() {
	if constexpr (std::is_same<GetKeyValuesFamilyRequest, GetKeyValuesRequest>::value) {
		return &StorageServerInterface::getKeyValues;
	} else if (std::is_same<GetKeyValuesFamilyRequest, GetMappedKeyValuesRequest>::value) {
		return &StorageServerInterface::getMappedKeyValues;
	} else {
		UNREACHABLE();
	}
}

															#line 11868 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getExactRange()
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetExactRangeActor>
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetExactRangeActorState {
															#line 11875 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetExactRangeActorState(Reference<TransactionState> const& trState,KeyRange const& keys,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse,UseTenant const& useTenant) 
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant),
															#line 2561 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   output(),
															#line 2563 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getExactRange"_loc, trState->spanContext)
															#line 11896 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getExactRange", reinterpret_cast<unsigned long>(this));

	}
	~GetExactRangeActorState() 
	{
		fdb_probe_actor_destroy("getExactRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2565 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(trState->hasTenant() && useTenant, "NativeAPI getExactRange has tenant");
															#line 2566 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(!useTenant, "NativeAPI getExactRange ignoring tenant");
															#line 2568 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (useTenant && trState->hasTenant())
															#line 11915 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				span.addAttribute("tenant"_sr, trState->tenant().get()->name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr));
															#line 11919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2574 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 11923 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetExactRangeActorState();
		static_cast<GetExactRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_0 = getKeyRangeLocations(trState, keys, CLIENT_KNOBS->GET_RANGE_SHARD_LIMIT, reverse, getRangeRequestStream<GetKeyValuesFamilyRequest>(), useTenant);
															#line 2575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11955 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetExactRangeActor*>(this)->actor_wait_state = 1;
															#line 2575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*>(static_cast<GetExactRangeActor*>(this)));
															#line 11960 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2582 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(locations.size());
															#line 2583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 2584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 11973 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> const& __locations,int loopDepth) 
	{
															#line 2575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locations = __locations;
															#line 11982 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> && __locations,int loopDepth) 
	{
		locations = std::move(__locations);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 0, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2585 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		const KeyRangeRef& range = locations[shard].range;
															#line 2587 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		GetKeyValuesFamilyRequest req;
															#line 2588 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.mapper = mapper;
															#line 2589 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(mapper.arena());
															#line 2591 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tenantInfo = useTenant ? trState->getTenantInfo() : TenantInfo();
															#line 2592 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 2593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.begin = firstGreaterOrEqual(range.begin);
															#line 2594 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.end = firstGreaterOrEqual(range.end);
															#line 2596 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = span.context;
															#line 2597 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locations[shard].locations, trState, req.ssLatestCommitVersions);
															#line 2600 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(locations[shard].range.arena());
															#line 2602 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		transformRangeLimits(limits, reverse, req);
															#line 2603 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 2606 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 2608 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 12102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 2611 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 12106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2612 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.Before");
															#line 12110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2624 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 2625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesFamilyReply();
															#line 12116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			try {
															#line 2628 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_1 = trState->cx->connectionFileChanged();
															#line 2627 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 12122 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2631 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyValuesFamilyReply> __when_expr_2 = loadBalance( trState->cx.getPtr(), locations[shard].locations, getRangeRequestStream<GetKeyValuesFamilyRequest>(), req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 12126 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
				static_cast<GetExactRangeActor*>(this)->actor_wait_state = 2;
															#line 2628 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 1, Void >*>(static_cast<GetExactRangeActor*>(this)));
															#line 2631 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*>(static_cast<GetExactRangeActor*>(this)));
															#line 12133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1loopBody1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1loopBody1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2730 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 12174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2731 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 2733 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (reverse)
															#line 12180 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(keys.begin, range.end);
															#line 12184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
				else
				{
															#line 2736 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(range.begin, keys.end);
															#line 12190 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 2738 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache( useTenant ? trState->tenant().mapRef(&Tenant::prefix) : Optional<KeyRef>(), keys);
															#line 2741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 2741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetExactRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12198 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<GetExactRangeActor*>(this)->actor_wait_state = 3;
															#line 2741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetExactRangeActor, 3, Void >*>(static_cast<GetExactRangeActor*>(this)));
															#line 12203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 2744 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevInfo, "GetExactRangeError") .error(e) .detail("Tenant", trState->tenant()) .detail("ShardBegin", locations[shard].range.begin) .detail("ShardEnd", locations[shard].range.end);
															#line 2749 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 12212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2649 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 12227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2650 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.After");
															#line 12231 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2653 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.arena().dependsOn(rep.arena);
															#line 2654 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.append(output.arena(), rep.data.begin(), rep.data.size());
															#line 2656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasRowLimit() && rep.data.size() > limits.rows)
															#line 12239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2657 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevError, "GetExactRangeTooManyRows") .detail("RowLimit", limits.rows) .detail("DeliveredRows", output.size());
															#line 2660 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(false);
															#line 12245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		limits.decrement(rep.data);
															#line 2664 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.isReached())
															#line 12251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2665 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 2666 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 12257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetExactRangeActorState();
			static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2669 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool more = rep.more;
															#line 2671 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && more && rep.data.size() > 0 && output[output.size() - 1].key == locations[shard].range.begin)
															#line 12267 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			more = false;
															#line 12271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2675 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (more)
															#line 12275 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2676 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 12279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2677 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "GetExactRangeError") .detail("Reason", "More data indicated but no rows present") .detail("LimitBytes", limits.bytes) .detail("LimitRows", limits.rows) .detail("OutputSize", output.size()) .detail("OutputBytes", output.expectedSize()) .detail("BlockSize", rep.data.size()) .detail("BlockBytes", rep.data.expectedSize());
															#line 2685 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(false);
															#line 12285 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2687 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesFamilyReply.more in getExactRange");
															#line 2689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 12291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2690 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(locations[shard].range.begin, output[output.size() - 1].key);
															#line 12295 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 2693 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(keyAfter(output[output.size() - 1].key), locations[shard].range.end);
															#line 12301 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 2697 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool redoKeyLocationRequest = false;
															#line 2698 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!more || locations[shard].range.empty())
															#line 12308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2699 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "getExactrange (!more || locations[shard].first.empty())");
															#line 2700 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (shard == locations.size() - 1)
															#line 12314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2701 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 2702 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef begin = reverse ? keys.begin : range.end;
															#line 2703 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef end = reverse ? range.begin : keys.end;
															#line 2705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (begin >= end)
															#line 12324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 2706 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.more = false;
															#line 2707 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 12330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
					this->~GetExactRangeActorState();
					static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2710 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				keys = KeyRangeRef(begin, end);
															#line 2711 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				redoKeyLocationRequest = true;
															#line 12340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 2714 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++shard;
															#line 12344 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasSatisfiedMinRows() && output.size() > 0)
															#line 12348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2721 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 2722 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetExactRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetExactRangeActorState(); static_cast<GetExactRangeActor*>(this)->destroy(); return 0; }
															#line 12354 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetExactRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetExactRangeActorState();
			static_cast<GetExactRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2725 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (redoKeyLocationRequest)
															#line 12362 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2726 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "Multiple requests of key locations");
															#line 12366 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 2646 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 2647 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1loopBody1cont1loopBody1Catch1(__current_error, loopDepth);
															#line 12380 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(int loopDepth) 
	{
															#line 2644 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 12394 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2629 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1loopBody1cont1loopBody1Catch2(transaction_too_old(), loopDepth);
															#line 12403 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2629 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		return a_body1loopBody1cont1loopBody1Catch2(transaction_too_old(), loopDepth);
															#line 12411 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
															#line 2641 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 12419 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
															#line 2641 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 12428 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 1, Void >::remove();
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 2, GetKeyValuesFamilyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont21(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetExactRangeActor*>(this)->actor_wait_state > 0) static_cast<GetExactRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetExactRangeActor*>(this)->ActorCallback< GetExactRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetExactRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetExactRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 2561 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RangeResultFamily output;
															#line 2563 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> locations;
															#line 2583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 2625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyReply rep;
															#line 12689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getExactRange()
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetExactRangeActor final : public Actor<RangeResultFamily>, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >, public ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >, public FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetExactRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 12696 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7265382352878392832UL, 11648758672056036352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >;
friend struct ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >;
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetExactRangeActor(Reference<TransactionState> const& trState,KeyRange const& keys,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse,UseTenant const& useTenant) 
															#line 12716 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<RangeResultFamily>(),
		   GetExactRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, keys, mapper, limits, reverse, useTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getExactRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3520479274471320064UL, 12983301301951641856UL);
		ActorExecutionContextHelper __helper(static_cast<GetExactRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getExactRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getExactRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getExactRange( Reference<TransactionState> const& trState, KeyRange const& keys, Key const& mapper, GetRangeLimits const& limits, Reverse const& reverse, UseTenant const& useTenant ) {
															#line 2554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetExactRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, keys, mapper, limits, reverse, useTenant));
															#line 12753 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2755 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<Key> resolveKey(Reference<TransactionState> trState, KeySelector const& key, UseTenant useTenant) {
	if (key.isFirstGreaterOrEqual())
		return Future<Key>(key.getKey());

	if (key.isFirstGreaterThan())
		return Future<Key>(keyAfter(key.getKey()));

	return getKey(trState, key, useTenant);
}

															#line 12768 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRangeFallback()
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetRangeFallbackActor>
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeFallbackActorState {
															#line 12775 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeFallbackActorState(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse,UseTenant const& useTenant) 
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant)
															#line 12794 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeFallback", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeFallbackActorState() 
	{
		fdb_probe_actor_destroy("getRangeFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2774 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(trState->hasTenant() && useTenant, "NativeAPI getRangeFallback has tenant");
															#line 2775 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(!useTenant, "NativeAPI getRangeFallback ignoring tenant");
															#line 2777 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			Future<Key> fb = resolveKey(trState, begin, useTenant);
															#line 2778 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			fe = resolveKey(trState, end, useTenant);
															#line 2780 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Key> __when_expr_0 = fb;
															#line 2780 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12819 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 1;
															#line 2780 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 0, Key >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 12824 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2781 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fe;
															#line 2781 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12849 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 2;
															#line 2781 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 1, Key >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 12854 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& __b,int loopDepth) 
	{
															#line 2780 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		b = __b;
															#line 12863 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && __b,int loopDepth) 
	{
		b = std::move(__b);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2782 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b >= e)
															#line 12942 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2783 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(RangeResultFamily()); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 12946 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(RangeResultFamily());
			this->~GetRangeFallbackActorState();
			static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<RangeResultFamily> __when_expr_2 = getExactRange<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, KeyRangeRef(b, e), mapper, limits, reverse, useTenant);
															#line 2790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12956 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 3;
															#line 2790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*>(static_cast<GetRangeFallbackActor*>(this)));
															#line 12961 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Key const& __e,int loopDepth) 
	{
															#line 2781 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		e = __e;
															#line 12970 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Key && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(RangeResultFamily const& _r,int loopDepth) 
	{
															#line 2792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResultFamily r = _r;
															#line 2794 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b == allKeys.begin && ((reverse && !r.more) || !reverse))
															#line 13051 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2795 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readToBegin = true;
															#line 13055 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2802 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (e == allKeys.end && ((!reverse && !r.more) || reverse))
															#line 13059 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2803 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readThroughEnd = true;
															#line 13063 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2805 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || r.size() <= limits.rows);
															#line 2808 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasByteLimit() && r.expectedSize() > size_t(limits.bytes + CLIENT_KNOBS->SYSTEM_KEY_SIZE_LIMIT + CLIENT_KNOBS->VALUE_SIZE_LIMIT + 1) && limits.minRows == 0)
															#line 13069 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2812 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevWarnAlways, "GetRangeFallbackTooMuchData") .detail("LimitBytes", limits.bytes) .detail("DeliveredBytes", r.expectedSize()) .detail("LimitRows", limits.rows) .detail("DeliveredRows", r.size());
															#line 13073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2819 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(r); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 13077 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(r);
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(RangeResultFamily && _r,int loopDepth) 
	{
															#line 2792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResultFamily r = _r;
															#line 2794 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b == allKeys.begin && ((reverse && !r.more) || !reverse))
															#line 13091 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2795 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readToBegin = true;
															#line 13095 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2802 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (e == allKeys.end && ((!reverse && !r.more) || reverse))
															#line 13099 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2803 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			r.readThroughEnd = true;
															#line 13103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2805 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || r.size() <= limits.rows);
															#line 2808 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (limits.hasByteLimit() && r.expectedSize() > size_t(limits.bytes + CLIENT_KNOBS->SYSTEM_KEY_SIZE_LIMIT + CLIENT_KNOBS->VALUE_SIZE_LIMIT + 1) && limits.minRows == 0)
															#line 13109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2812 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent(SevWarnAlways, "GetRangeFallbackTooMuchData") .detail("LimitBytes", limits.bytes) .detail("DeliveredBytes", r.expectedSize()) .detail("LimitRows", limits.rows) .detail("DeliveredRows", r.size());
															#line 13113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2819 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeFallbackActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(r); this->~GetRangeFallbackActorState(); static_cast<GetRangeFallbackActor*>(this)->destroy(); return 0; }
															#line 13117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeFallbackActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(r);
		this->~GetRangeFallbackActorState();
		static_cast<GetRangeFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(RangeResultFamily const& _r,int loopDepth) 
	{
		loopDepth = a_body1cont3(_r, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResultFamily && _r,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeFallbackActor*>(this)->actor_wait_state > 0) static_cast<GetRangeFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeFallbackActor*>(this)->ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeFallbackActor, 2, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 2778 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Key> fe;
															#line 2780 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key b;
															#line 2781 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key e;
															#line 13220 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRangeFallback()
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeFallbackActor final : public Actor<RangeResultFamily>, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >, public ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >, public FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetRangeFallbackActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 13227 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8864743327108508160UL, 14402890597002100224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >;
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >;
friend struct ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >;
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeFallbackActor(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Reverse const& reverse,UseTenant const& useTenant) 
															#line 13246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<RangeResultFamily>(),
		   GetRangeFallbackActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, begin, end, mapper, limits, reverse, useTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3517076735759144704UL, 3895872481659177216UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, RangeResultFamily >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getRangeFallback( Reference<TransactionState> const& trState, KeySelector const& begin, KeySelector const& end, Key const& mapper, GetRangeLimits const& limits, Reverse const& reverse, UseTenant const& useTenant ) {
															#line 2766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetRangeFallbackActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, begin, end, mapper, limits, reverse, useTenant));
															#line 13283 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 2821 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

int64_t inline getRangeResultFamilyBytes(RangeResultRef result) {
	return result.expectedSize();
}

int64_t inline getRangeResultFamilyBytes(MappedRangeResultRef result) {
	int64_t bytes = 0;
	for (const MappedKeyValueRef& mappedKeyValue : result) {
		bytes += mappedKeyValue.key.size() + mappedKeyValue.value.size();
		auto& reqAndResult = mappedKeyValue.reqAndResult;
		if (std::holds_alternative<GetValueReqAndResultRef>(reqAndResult)) {
			auto getValue = std::get<GetValueReqAndResultRef>(reqAndResult);
			bytes += getValue.expectedSize();
		} else if (std::holds_alternative<GetRangeReqAndResultRef>(reqAndResult)) {
			auto getRange = std::get<GetRangeReqAndResultRef>(reqAndResult);
			bytes += getRange.result.expectedSize();
		} else {
			throw internal_error();
		}
	}
	return bytes;
}

// TODO: Client should add mapped keys to conflict ranges.
template <class RangeResultFamily> // RangeResult or MappedRangeResult
void getRangeFinished(Reference<TransactionState> trState,
                      double startTime,
                      KeySelector begin,
                      KeySelector end,
                      Snapshot snapshot,
                      Promise<std::pair<Key, Key>> conflictRange,
                      Reverse reverse,
                      RangeResultFamily result) {
	int64_t bytes = getRangeResultFamilyBytes(result);

	trState->totalCost += getReadOperationCost(bytes);
	trState->cx->transactionBytesRead += bytes;
	trState->cx->transactionKeysRead += result.size();

	if (trState->trLogInfo) {
		trState->trLogInfo->addLog(FdbClientLogEvents::EventGetRange(startTime,
		                                                             trState->cx->clientLocality.dcId(),
		                                                             now() - startTime,
		                                                             bytes,
		                                                             begin.getKey(),
		                                                             end.getKey(),
		                                                             trState->tenant().flatMapRef(&Tenant::name)));
	}

	if (!snapshot) {
		Key rangeBegin;
		Key rangeEnd;

		if (result.readToBegin) {
			rangeBegin = allKeys.begin;
		} else if (((!reverse || !result.more || begin.offset > 1) && begin.offset > 0) || result.size() == 0) {
			rangeBegin = Key(begin.getKey(), begin.arena());
		} else {
			rangeBegin = reverse ? result.end()[-1].key : result[0].key;
		}

		if (end.offset > begin.offset && end.getKey() < rangeBegin) {
			rangeBegin = Key(end.getKey(), end.arena());
		}

		if (result.readThroughEnd) {
			rangeEnd = allKeys.end;
		} else if (((reverse || !result.more || end.offset <= 0) && end.offset <= 1) || result.size() == 0) {
			rangeEnd = Key(end.getKey(), end.arena());
		} else {
			rangeEnd = keyAfter(reverse ? result[0].key : result.end()[-1].key);
		}

		if (begin.offset < end.offset && begin.getKey() > rangeEnd) {
			rangeEnd = Key(begin.getKey(), begin.arena());
		}

		conflictRange.send(std::make_pair(rangeBegin, rangeEnd));
	}
}

															#line 13368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRange()
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily, class GetRangeActor>
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeActorState {
															#line 13375 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeActorState(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse,UseTenant const& useTenant = UseTenant::True) 
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   mapper(mapper),
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   conflictRange(conflictRange),
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   useTenant(useTenant),
															#line 2918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalLimits(limits),
															#line 2919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalBegin(begin),
															#line 2920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   originalEnd(end),
															#line 2921 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   output(),
															#line 2922 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   span("NAPI:getRange"_loc, trState->spanContext),
															#line 2923 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   getRangeID(Optional<UID>())
															#line 13410 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRange", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeActorState() 
	{
		fdb_probe_actor_destroy("getRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2925 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(trState->hasTenant() && useTenant, "NativeAPI getExactRange has tenant");
															#line 2926 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(!useTenant, "Get range ignoring tenant");
															#line 2928 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (useTenant && trState->hasTenant())
															#line 13429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2929 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				span.addAttribute("tenant"_sr, trState->tenant().get()->name.castTo<TenantNameRef>().orDefault("<unspecified>"_sr));
															#line 13433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			try {
															#line 2934 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 2934 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13440 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 1;
															#line 2934 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 0, Void >*>(static_cast<GetRangeActor*>(this)));
															#line 13445 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (conflictRange.canBeSet())
															#line 13475 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3209 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				conflictRange.send(std::make_pair(Key(), Key()));
															#line 13479 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3212 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 13483 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2935 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 2937 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 2939 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (begin.getKey() == allKeys.begin && begin.offset < 1)
															#line 13501 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2940 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 2941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = KeySelector(firstGreaterOrEqual(begin.getKey()), begin.arena());
															#line 13507 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2944 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.isReached());
															#line 2945 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT((!limits.hasRowLimit() || limits.rows >= limits.minRows) && limits.minRows >= 0);
															#line 2947 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 13515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2935 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 2937 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 2939 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (begin.getKey() == allKeys.begin && begin.offset < 1)
															#line 13528 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2940 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 2941 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = KeySelector(firstGreaterOrEqual(begin.getKey()), begin.arena());
															#line 13534 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2944 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.isReached());
															#line 2945 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT((!limits.hasRowLimit() || limits.rows >= limits.minRows) && limits.minRows >= 0);
															#line 2947 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 13542 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 2948 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (end.getKey() == allKeys.begin && (end.offset < 1 || end.isFirstGreaterOrEqual()))
															#line 13633 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2949 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 2951 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 13639 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2954 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Key locationKey = reverse ? Key(end.getKey(), end.arena()) : Key(begin.getKey(), begin.arena());
															#line 2955 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Reverse locationBackward{ reverse ? (end - 1).isBackward() : begin.isBackward() };
															#line 2956 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_1 = getKeyLocation( trState, locationKey, getRangeRequestStream<GetKeyValuesFamilyRequest>(), locationBackward, useTenant);
															#line 2956 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13653 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeActor*>(this)->actor_wait_state = 2;
															#line 2956 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*>(static_cast<GetRangeActor*>(this)));
															#line 13658 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 2958 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = beginServer.range;
															#line 2959 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		modifiedSelectors = false;
															#line 2960 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req = GetKeyValuesFamilyRequest();
															#line 2961 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.mapper = mapper;
															#line 2962 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(mapper.arena());
															#line 2963 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tenantInfo = useTenant ? trState->getTenantInfo() : TenantInfo();
															#line 2964 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 2965 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 2966 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.taskID = trState->taskID;
															#line 2968 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(beginServer.locations, trState, req.ssLatestCommitVersions);
															#line 2972 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool dependOnShard = false;
															#line 2973 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && (begin - 1).isDefinitelyLess(shard.begin) && (!begin.isFirstGreaterOrEqual() || begin.getKey() != shard.begin))
															#line 13689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2978 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.begin = firstGreaterOrEqual(shard.begin);
															#line 2979 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = true;
															#line 2980 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(shard.arena());
															#line 2981 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			dependOnShard = true;
															#line 13699 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 2983 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.begin = begin;
															#line 2984 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(begin.arena());
															#line 13707 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2987 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!reverse && end.isDefinitelyGreater(shard.end))
															#line 13711 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 2988 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.end = firstGreaterOrEqual(shard.end);
															#line 2989 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = true;
															#line 2990 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!dependOnShard)
															#line 13719 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 2991 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				req.arena.dependsOn(shard.arena());
															#line 13723 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		else
		{
															#line 2994 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.end = end;
															#line 2995 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			req.arena.dependsOn(end.arena());
															#line 13732 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 2998 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		transformRangeLimits(limits, reverse, req);
															#line 2999 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 3001 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 3002 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = span.context;
															#line 3003 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 13744 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3004 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeID = nondeterministicRandom()->randomUniqueID();
															#line 3005 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addAttach( "TransactionAttachID", trState->readOptions.get().debugID.get().first(), getRangeID.get().first());
															#line 13750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		try {
															#line 3009 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getRangeID.present())
															#line 13755 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3010 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.Before");
															#line 13759 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3030 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 3031 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesFamilyReply();
															#line 13765 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			try {
															#line 3033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (CLIENT_BUGGIFY_WITH_PROB(.01))
															#line 13769 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3034 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					return a_body1cont3loopBody1cont1Catch2(deterministicRandom()->randomChoice( std::vector<Error>{ transaction_too_old(), future_version() }), loopDepth);
															#line 13773 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3038 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<GetKeyValuesFamilyReply> __when_expr_2 = loadBalance(trState->cx.getPtr(), beginServer.locations, getRangeRequestStream<GetKeyValuesFamilyRequest>(), req, TaskPriority::DefaultPromiseEndpoint, AtMostOnce::False, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, trState->options.enableReplicaConsistencyCheck, trState->options.requiredReplicas);
															#line 3038 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1cont1Catch2(actor_cancelled(), loopDepth);
															#line 13779 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont3loopBody1cont1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 3;
															#line 3038 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*>(static_cast<GetRangeActor*>(this)));
															#line 13784 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont3loopBody1cont1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont3loopBody1cont1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(KeyRangeLocationInfo const& __beginServer,int loopDepth) 
	{
															#line 2956 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		beginServer = __beginServer;
															#line 13805 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(KeyRangeLocationInfo && __beginServer,int loopDepth) 
	{
		beginServer = std::move(__beginServer);
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 1, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (getRangeID.present())
															#line 13891 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3174 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.Error");
															#line 3175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent("TransactionDebugError", getRangeID.get()).error(e);
															#line 13897 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3177 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed)
															#line 13901 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(useTenant ? trState->tenant().mapRef(&Tenant::prefix) : Optional<KeyRef>(), reverse ? end.getKey() : begin.getKey(), Reverse{ reverse ? (end - 1).isBackward() : begin.isBackward() });
															#line 3183 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (e.code() == error_code_wrong_shard_server)
															#line 13907 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					StrictFuture<RangeResultFamily> __when_expr_4 = getRangeFallback<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, originalBegin, originalEnd, mapper, originalLimits, reverse, useTenant);
															#line 3184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1Catch1when1(__when_expr_4.get(), loopDepth); };
					static_cast<GetRangeActor*>(this)->actor_wait_state = 5;
															#line 3184 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 4, RangeResultFamily >*>(static_cast<GetRangeActor*>(this)));
															#line 13918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont3loopBody1cont1Catch1cont3(loopDepth);
				}
			}
			else
			{
															#line 3194 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (trState->trLogInfo)
															#line 13930 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3195 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					trState->trLogInfo->addLog( FdbClientLogEvents::EventGetRangeError(startTime, trState->cx->clientLocality.dcId(), static_cast<int>(e.code()), begin.getKey(), end.getKey(), trState->tenant().flatMapRef(&Tenant::name)));
															#line 13934 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3203 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 13938 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10(int loopDepth) 
	{
															#line 3055 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (getRangeID.present())
															#line 13953 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3056 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", getRangeID.get().first(), "NativeAPI.getRange.After");
															#line 13957 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3070 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!rep.more || rep.data.size());
															#line 3071 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(!limits.hasRowLimit() || rep.data.size() <= limits.rows);
															#line 3073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		limits.decrement(rep.data);
															#line 3075 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && begin.isLastLessOrEqual() && rep.data.size() && rep.data.end()[-1].key == begin.getKey())
															#line 13967 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3077 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			modifiedSelectors = false;
															#line 13971 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3080 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool finished = limits.isReached() || (!modifiedSelectors && !rep.more) || limits.hasSatisfiedMinRows();
															#line 3081 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		bool readThrough = modifiedSelectors && !rep.more;
															#line 3084 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (finished && !output.size())
															#line 13979 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3085 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bool readToBegin = output.readToBegin;
															#line 3086 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bool readThroughEnd = output.readThroughEnd;
															#line 3088 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			using RangeResultRefFamily = typename RangeResultFamily::RefType;
															#line 3089 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output = RangeResultFamily( RangeResultRefFamily(rep.data, modifiedSelectors || limits.isReached() || rep.more), rep.arena);
															#line 3091 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = readToBegin;
															#line 3092 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readThroughEnd = readThroughEnd;
															#line 3094 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (BUGGIFY && limits.hasByteLimit() && output.size() > std::max(1, originalLimits.minRows) && (!std::is_same<GetKeyValuesFamilyRequest, GetMappedKeyValuesRequest>::value))
															#line 13995 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3099 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				RangeResultFamily copy;
															#line 3100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				int newSize = deterministicRandom()->randomInt(std::max(1, originalLimits.minRows), output.size());
															#line 3102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				for(int i = 0;i < newSize;i++) {
															#line 3103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					copy.push_back_deep(copy.arena(), output[i]);
															#line 14005 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3105 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output = copy;
															#line 3106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.more = true;
															#line 3108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 3110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 14015 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
				this->~GetRangeActorState();
				static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 3113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (readThrough)
															#line 14023 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3114 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.arena().dependsOn(shard.arena());
															#line 3116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(modifiedSelectors);
															#line 3117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.more = true;
															#line 3118 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.setReadThrough(reverse ? shard.begin : shard.end);
															#line 14033 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 3123 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!output.more)
															#line 14039 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3124 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(!output.readThrough.present());
															#line 14043 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3126 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 14047 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3129 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.arena().dependsOn(rep.arena);
															#line 3130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		output.append(output.arena(), rep.data.begin(), rep.data.size());
															#line 3132 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (finished)
															#line 14059 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = modifiedSelectors || limits.isReached() || rep.more;
															#line 3134 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (readThrough)
															#line 14065 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.arena().dependsOn(shard.arena());
															#line 3136 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				output.setReadThrough(reverse ? shard.begin : shard.end);
															#line 14071 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, output);
															#line 3141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!output.more)
															#line 14077 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(!output.readThrough.present());
															#line 14081 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3144 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(output); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 14085 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(std::move(output)); // state_var_RVO
			this->~GetRangeActorState();
			static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 3147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!rep.more)
															#line 14093 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3148 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(modifiedSelectors);
															#line 3149 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "!GetKeyValuesFamilyReply.more and modifiedSelectors in getRange");
															#line 3151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 14101 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<RangeResultFamily> __when_expr_3 = getRangeFallback<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>( trState, originalBegin, originalEnd, mapper, originalLimits, reverse, useTenant);
															#line 3152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 14107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3loopBody1cont10when1(__when_expr_3.get(), loopDepth); };
				static_cast<GetRangeActor*>(this)->actor_wait_state = 4;
															#line 3152 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 3, RangeResultFamily >*>(static_cast<GetRangeActor*>(this)));
															#line 14112 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont3loopBody1cont10cont12(loopDepth);
			}
		}
		else
		{
															#line 3165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesFamilyReply.more in getRange");
															#line 3166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 14126 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				end = firstGreaterOrEqual(output[output.size() - 1].key);
															#line 14130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				begin = firstGreaterThan(output[output.size() - 1].key);
															#line 14136 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			loopDepth = a_body1cont3loopBody1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 3051 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 3052 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			return a_body1cont3loopBody1cont1Catch1(__current_error, loopDepth);
															#line 14150 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont12(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
															#line 3048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 3049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 14166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont12(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
															#line 3048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 3049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 14177 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(GetKeyValuesFamilyReply const& _rep,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont12(_rep, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(GetKeyValuesFamilyReply && _rep,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont12(std::move(_rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,GetKeyValuesFamilyReply && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 2, GetKeyValuesFamilyReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1cont1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch2(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3loopBody1cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10cont1(int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont10cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10cont12(int loopDepth) 
	{
															#line 3160 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse)
															#line 14280 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			end = firstGreaterOrEqual(shard.begin);
															#line 14284 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 3163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			begin = firstGreaterOrEqual(shard.end);
															#line 14290 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		loopDepth = a_body1cont3loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10cont13(RangeResultFamily const& result,int loopDepth) 
	{
															#line 3155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 3157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 14302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10cont13(RangeResultFamily && result,int loopDepth) 
	{
															#line 3155 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 3157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 14316 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10when1(RangeResultFamily const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont10cont13(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont10when1(RangeResultFamily && result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont10cont13(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 3, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 3, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3loopBody1cont10cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont3(int loopDepth) 
	{
															#line 3192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 3192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14424 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1Catch1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetRangeActor*>(this)->actor_wait_state = 6;
															#line 3192 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetRangeActor, 5, Void >*>(static_cast<GetRangeActor*>(this)));
															#line 14429 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont4(RangeResultFamily const& result,int loopDepth) 
	{
															#line 3187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 3189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 14440 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont4(RangeResultFamily && result,int loopDepth) 
	{
															#line 3187 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		getRangeFinished( trState, startTime, originalBegin, originalEnd, snapshot, conflictRange, reverse, result);
															#line 3189 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeActor*>(this)->SAV<RangeResultFamily>::futures) { (void)(result); this->~GetRangeActorState(); static_cast<GetRangeActor*>(this)->destroy(); return 0; }
															#line 14454 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeActor*>(this)->SAV< RangeResultFamily >::value()) RangeResultFamily(result);
		this->~GetRangeActorState();
		static_cast<GetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1when1(RangeResultFamily const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont4(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1when1(RangeResultFamily && result,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont4(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 4, RangeResultFamily >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,RangeResultFamily const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,RangeResultFamily && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 4, RangeResultFamily >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopBody1cont1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeActor*>(this)->actor_wait_state > 0) static_cast<GetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeActor*>(this)->ActorCallback< GetRangeActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetRangeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1cont1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetRangeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key mapper;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Promise<std::pair<Key, Key>> conflictRange;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	UseTenant useTenant;
															#line 2918 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits originalLimits;
															#line 2919 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector originalBegin;
															#line 2920 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector originalEnd;
															#line 2921 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	RangeResultFamily output;
															#line 2922 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 2923 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<UID> getRangeID;
															#line 2937 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTime;
															#line 2956 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo beginServer;
															#line 2958 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange shard;
															#line 2959 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool modifiedSelectors;
															#line 2960 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyRequest req;
															#line 3031 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesFamilyReply rep;
															#line 14666 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRange()
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeActor final : public Actor<RangeResultFamily>, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >, public ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >, public FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>, public GetRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>> {
															#line 14673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator new;
	using FastAllocated<GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16858328145466737408UL, 6537145729653358592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResultFamily>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >;
friend struct ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >;
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeActor(Reference<TransactionState> const& trState,KeySelector const& begin,KeySelector const& end,Key const& mapper,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse,UseTenant const& useTenant = UseTenant::True) 
															#line 14695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<RangeResultFamily>(),
		   GetRangeActorState<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily, GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>>(trState, begin, end, mapper, limits, conflictRange, snapshot, reverse, useTenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2910272544121951744UL, 708275608187718144UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 1, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 2, GetKeyValuesFamilyReply >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 3, RangeResultFamily >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 4, RangeResultFamily >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetKeyValuesFamilyRequest, class GetKeyValuesFamilyReply, class RangeResultFamily>
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<RangeResultFamily> getRange( Reference<TransactionState> const& trState, KeySelector const& begin, KeySelector const& end, Key const& mapper, GetRangeLimits const& limits, Promise<std::pair<Key, Key>> const& conflictRange, Snapshot const& snapshot, Reverse const& reverse, UseTenant const& useTenant = UseTenant::True ) {
															#line 2902 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<RangeResultFamily>(new GetRangeActor<GetKeyValuesFamilyRequest, GetKeyValuesFamilyReply, RangeResultFamily>(trState, begin, end, mapper, limits, conflictRange, snapshot, reverse, useTenant));
															#line 14735 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

template <class StreamReply>
struct TSSDuplicateStreamData {
	PromiseStream<StreamReply> stream;
	Promise<Void> tssComparisonDone;

	// empty constructor for optional?
	TSSDuplicateStreamData() {}

	TSSDuplicateStreamData(PromiseStream<StreamReply> stream) : stream(stream) {}

	bool done() { return tssComparisonDone.getFuture().isReady(); }

	void setDone() {
		if (tssComparisonDone.canBeSet()) {
			tssComparisonDone.send(Void());
		}
	}

	~TSSDuplicateStreamData() {}
};

// Error tracking here is weird, and latency doesn't really mean the same thing here as it does with normal tss
// comparisons, so this is pretty much just counting mismatches
															#line 14763 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via tssStreamComparison()
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request, class TssStreamComparisonActor>
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TssStreamComparisonActorState {
															#line 14770 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TssStreamComparisonActorState(Request const& request,TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData,ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream,TSSEndpointData const& tssData) 
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : request(request),
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   streamData(streamData),
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssReplyStream(tssReplyStream),
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssData(tssData),
															#line 3244 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ssEndOfStream(false),
															#line 3245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssEndOfStream(false),
															#line 3246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   ssReply(Optional<REPLYSTREAM_TYPE(Request)>()),
															#line 3247 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   tssReply(Optional<REPLYSTREAM_TYPE(Request)>())
															#line 14791 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("tssStreamComparison", reinterpret_cast<unsigned long>(this));

	}
	~TssStreamComparisonActorState() 
	{
		fdb_probe_actor_destroy("tssStreamComparison", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3249 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 14806 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TssStreamComparisonActorState();
		static_cast<TssStreamComparisonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3251 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = Optional<REPLYSTREAM_TYPE(Request)>();
															#line 3252 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = Optional<REPLYSTREAM_TYPE(Request)>();
															#line 3254 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		startTime = now();
															#line 14840 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 3257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_0 = streamData.stream.getFuture();
															#line 14844 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<REPLYSTREAM_TYPE(Request)>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<REPLYSTREAM_TYPE(Request)>>::value, "invalid type");
															#line 3257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14848 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 1;
															#line 3257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 14853 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 3274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		sleepTime = std::max(startTime + FLOW_KNOBS->LOAD_BALANCE_TSS_TIMEOUT - now(), 0.0);
															#line 14868 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 3278 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_1 = tssReplyStream.getFuture();
															#line 14872 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<REPLYSTREAM_TYPE(Request)>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<REPLYSTREAM_TYPE(Request)>>::value, "invalid type");
															#line 3277 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 14876 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.pop(), loopDepth); };
															#line 3281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(sleepTime);
															#line 14880 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 2;
															#line 3278 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 3281 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TssStreamComparisonActor, 2, Void >*>(static_cast<TssStreamComparisonActor*>(this)));
															#line 14887 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3260 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14903 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3261 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 3262 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 14909 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3264 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 14913 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3267 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ssEndOfStream = true;
															#line 14917 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssData.metrics->ssError(e.code());
															#line 14923 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(e.code() != error_code_end_of_stream, "SS got error in TSS stream comparison");
															#line 14927 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLYSTREAM_TYPE(Request) const& _ssReply,int loopDepth) 
	{
															#line 3258 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = _ssReply;
															#line 14942 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(REPLYSTREAM_TYPE(Request) && _ssReply,int loopDepth) 
	{
															#line 3258 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ssReply = _ssReply;
															#line 14951 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLYSTREAM_TYPE(Request) const& _ssReply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_ssReply, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(REPLYSTREAM_TYPE(Request) && _ssReply,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_ssReply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssStreamComparisonActor*>(this)->ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TssStreamComparisonActor, 0, REPLYSTREAM_TYPE(Request) >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 3301 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!ssEndOfStream || !tssEndOfStream)
															#line 15048 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++tssData.metrics->streamComparisons;
															#line 15052 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3306 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (ssReply.present() && tssReply.present())
															#line 15056 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3313 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if ((!ssEndOfStream || !tssEndOfStream) && !TSS_doCompare(ssReply.get(), tssReply.get()))
															#line 15060 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				CODE_PROBE(true, "TSS mismatch in stream comparison");
															#line 3315 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent mismatchEvent( (g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(request, TSS_COMPARISON));
															#line 3320 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				mismatchEvent.setMaxEventLength(FLOW_KNOBS->TSS_LARGE_TRACE_SIZE);
															#line 3321 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				mismatchEvent.detail("TSSID", tssData.tssId);
															#line 3323 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssData.metrics->shouldRecordDetailedMismatch())
															#line 15072 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					TSS_traceMismatch(mismatchEvent, request, ssReply.get(), tssReply.get(), TSS_COMPARISON);
															#line 3326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Full TSS Mismatch in stream comparison", probe::decoration::rare);
															#line 3329 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					CODE_PROBE(!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Partial TSS Mismatch in stream comparison and storing the rest in FDB");
															#line 3332 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL)
															#line 15082 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 3333 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						mismatchEvent.disable();
															#line 3334 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						UID mismatchUID = deterministicRandom()->randomUniqueID();
															#line 3335 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						tssData.metrics->recordDetailedMismatchData(mismatchUID, mismatchEvent.getFields().toString());
															#line 3338 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						TraceEvent summaryEvent((g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(request, TSS_COMPARISON));
															#line 3343 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						summaryEvent.detail("TSSID", tssData.tssId).detail("MismatchId", mismatchUID);
															#line 15094 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					}
				}
				else
				{
															#line 3347 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					mismatchEvent.disable();
															#line 15101 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3349 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 3350 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<TssStreamComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssStreamComparisonActorState(); static_cast<TssStreamComparisonActor*>(this)->destroy(); return 0; }
															#line 15107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<TssStreamComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TssStreamComparisonActorState();
				static_cast<TssStreamComparisonActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 3353 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!ssReply.present() || !tssReply.present() || ssEndOfStream || tssEndOfStream)
															#line 15116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3355 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			streamData.setDone();
															#line 3356 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!static_cast<TssStreamComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssStreamComparisonActorState(); static_cast<TssStreamComparisonActor*>(this)->destroy(); return 0; }
															#line 15122 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			new (&static_cast<TssStreamComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TssStreamComparisonActorState();
			static_cast<TssStreamComparisonActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3287 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 15137 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3288 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				streamData.setDone();
															#line 3289 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 15143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3291 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 15147 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3294 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssEndOfStream = true;
															#line 15151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3296 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssData.metrics->tssError(e.code());
															#line 15157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3298 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(e.code() != error_code_end_of_stream, "TSS got error in TSS stream comparison");
															#line 15161 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(REPLYSTREAM_TYPE(Request) const& _tssReply,int loopDepth) 
	{
															#line 3279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = _tssReply;
															#line 15182 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(REPLYSTREAM_TYPE(Request) && _tssReply,int loopDepth) 
	{
															#line 3279 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssReply = _tssReply;
															#line 15191 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
															#line 3282 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++tssData.metrics->tssTimeouts;
															#line 3283 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(true, "Got TSS timeout in stream comparison", probe::decoration::rare);
															#line 15202 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
															#line 3282 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++tssData.metrics->tssTimeouts;
															#line 3283 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(true, "Got TSS timeout in stream comparison", probe::decoration::rare);
															#line 15213 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TssStreamComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssStreamComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssStreamComparisonActor*>(this)->ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >::remove();
		static_cast<TssStreamComparisonActor*>(this)->ActorCallback< TssStreamComparisonActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,REPLYSTREAM_TYPE(Request) && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< TssStreamComparisonActor, 1, REPLYSTREAM_TYPE(Request) >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TssStreamComparisonActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TssStreamComparisonActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TssStreamComparisonActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Request request;
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> streamData;
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> tssReplyStream;
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TSSEndpointData tssData;
															#line 3244 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool ssEndOfStream;
															#line 3245 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool tssEndOfStream;
															#line 3246 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<REPLYSTREAM_TYPE(Request)> ssReply;
															#line 3247 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<REPLYSTREAM_TYPE(Request)> tssReply;
															#line 3254 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double startTime;
															#line 3274 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	double sleepTime;
															#line 15372 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via tssStreamComparison()
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request>
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class TssStreamComparisonActor final : public Actor<Void>, public ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >, public ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >, public ActorCallback< TssStreamComparisonActor<Request>, 2, Void >, public FastAllocated<TssStreamComparisonActor<Request>>, public TssStreamComparisonActorState<Request, TssStreamComparisonActor<Request>> {
															#line 15379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<TssStreamComparisonActor<Request>>::operator new;
	using FastAllocated<TssStreamComparisonActor<Request>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17361675768598844160UL, 13881437327361233408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >;
friend struct ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >;
friend struct ActorCallback< TssStreamComparisonActor<Request>, 2, Void >;
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	TssStreamComparisonActor(Request const& request,TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData,ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream,TSSEndpointData const& tssData) 
															#line 15398 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   TssStreamComparisonActorState<Request, TssStreamComparisonActor<Request>>(request, streamData, tssReplyStream, tssData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tssStreamComparison", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12049828901958652672UL, 1449468964280732928UL);
		ActorExecutionContextHelper __helper(static_cast<TssStreamComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tssStreamComparison");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tssStreamComparison", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< TssStreamComparisonActor<Request>, 0, REPLYSTREAM_TYPE(Request) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< TssStreamComparisonActor<Request>, 1, REPLYSTREAM_TYPE(Request) >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class Request>
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] static Future<Void> tssStreamComparison( Request const& request, TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> const& streamData, ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> const& tssReplyStream, TSSEndpointData const& tssData ) {
															#line 3239 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new TssStreamComparisonActor<Request>(request, streamData, tssReplyStream, tssData));
															#line 15434 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3360 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

// Currently only used for GetKeyValuesStream but could easily be plugged for other stream types
// User of the stream has to forward the SS's responses to the returned promise stream, if it is set
template <class Request, bool P>
Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>
maybeDuplicateTSSStreamFragment(Request& req, QueueModel* model, RequestStream<Request, P> const* ssStream) {
	if (model) {
		Optional<TSSEndpointData> tssData = model->getTssData(ssStream->getEndpoint().token.first());

		if (tssData.present()) {
			CODE_PROBE(true, "duplicating stream to TSS");
			resetReply(req);
			// FIXME: optimize to avoid creating new netNotifiedQueueWithAcknowledgements for each stream duplication
			RequestStream<Request> tssRequestStream(tssData.get().endpoint);
			ReplyPromiseStream<REPLYSTREAM_TYPE(Request)> tssReplyStream = tssRequestStream.getReplyStream(req);
			PromiseStream<REPLYSTREAM_TYPE(Request)> ssDuplicateReplyStream;
			TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)> streamData(ssDuplicateReplyStream);
			model->addActor.send(tssStreamComparison(req, streamData, tssReplyStream, tssData.get()));
			return Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>(streamData);
		}
	}
	return Optional<TSSDuplicateStreamData<REPLYSTREAM_TYPE(Request)>>();
}

// Streams all of the KV pairs in a target key range into a ParallelStream fragment
															#line 15463 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRangeStreamFragment()
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRangeStreamFragmentActor>
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamFragmentActorState {
															#line 15470 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamFragmentActorState(Reference<TransactionState> const& trState,ParallelStream<RangeResult>::Fragment* const& results,KeyRange const& keys,GetRangeLimits const& limits,Snapshot const& snapshot,Reverse const& reverse,SpanContext const& spanContext) 
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   results(results),
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   keys(keys),
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   spanContext(spanContext)
															#line 15489 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeStreamFragment", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeStreamFragmentActorState() 
	{
		fdb_probe_actor_destroy("getRangeStreamFragment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3392 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			;
															#line 15504 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<std::vector<KeyRangeLocationInfo>> __when_expr_0 = getKeyRangeLocations(trState, keys, CLIENT_KNOBS->GET_RANGE_SHARD_LIMIT, reverse, &StorageServerInterface::getKeyValuesStream, UseTenant::True);
															#line 3393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15536 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 1;
															#line 3393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15541 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 3400 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(locations.size());
															#line 3401 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shard = 0;
															#line 3402 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 15554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> const& __locations,int loopDepth) 
	{
															#line 3393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locations = __locations;
															#line 15563 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyRangeLocationInfo> && __locations,int loopDepth) 
	{
		locations = std::move(__locations);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,std::vector<KeyRangeLocationInfo> && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 3403 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		const KeyRange& range = locations[shard].range;
															#line 3405 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssDuplicateStream = Optional<TSSDuplicateStreamData<GetKeyValuesStreamReply>>();
															#line 3406 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req = GetKeyValuesStreamRequest();
															#line 3407 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tenantInfo = trState->getTenantInfo();
															#line 3408 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.version = trState->readVersion();
															#line 3409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.begin = firstGreaterOrEqual(range.begin);
															#line 3410 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.end = firstGreaterOrEqual(range.end);
															#line 3411 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.spanContext = spanContext;
															#line 3412 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.limit = reverse ? -CLIENT_KNOBS->REPLY_BYTE_LIMIT : CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 3413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.limitBytes = std::numeric_limits<int>::max();
															#line 3414 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.options = trState->readOptions;
															#line 3416 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->getLatestCommitVersions(locations[shard].locations, trState, req.ssLatestCommitVersions);
															#line 3419 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.arena.dependsOn(range.arena());
															#line 3421 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(req.limitBytes > 0 && req.limit != 0 && req.limit < 0 == reverse);
															#line 3424 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		req.tags = trState->cx->sampleReadTags() ? trState->options.readTags : Optional<TagSet>();
															#line 15683 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		try {
															#line 3427 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 15687 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3428 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.RangeStream.Before");
															#line 15691 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3432 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReads;
															#line 3433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesStreamReply();
															#line 3435 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (locations[shard].locations->size() == 0)
															#line 15699 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3436 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_1 = trState->cx->connectionFileChanged();
															#line 3436 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 15705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 2;
															#line 3436 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 1, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15710 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3635 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 15750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3636 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				tssDuplicateStream.get().stream.sendError(e);
															#line 15754 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3638 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 15758 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3639 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 15762 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3641 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed || e.code() == error_code_connection_failed || e.code() == error_code_request_maybe_delivered)
															#line 15766 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				const KeyRangeRef& range = locations[shard].range;
															#line 3645 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (reverse)
															#line 15772 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3646 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(keys.begin, range.end);
															#line 15776 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
				else
				{
															#line 3648 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					keys = KeyRangeRef(range.begin, keys.end);
															#line 15782 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3650 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				trState->cx->invalidateCache(trState->tenant().mapRef(&Tenant::prefix), keys);
															#line 3652 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				StrictFuture<Void> __when_expr_6 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY, trState->taskID);
															#line 3652 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15790 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 6;
															#line 3652 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 6, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 15795 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 3655 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				results->sendError(e);
															#line 3656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15804 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeStreamFragmentActorState();
				static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 3441 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = -1;
															#line 3443 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 15825 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 3437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15836 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 3437 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3438 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 15850 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
															#line 3482 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		replyStream = locations[shard] .locations->get(useIdx, &StorageServerInterface::getKeyValuesStream) .getReplyStream(req);
															#line 3487 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		tssDuplicateStream = maybeDuplicateTSSStreamFragment( req, trState->cx->enableLocalityLoadBalance ? &trState->cx->queueModel : nullptr, &locations[shard].locations->get(useIdx, &StorageServerInterface::getKeyValuesStream));
															#line 3492 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		breakAgain = false;
															#line 3493 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 15943 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 3446 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		int count = 0;
															#line 3447 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int i = 0;i < locations[shard].locations->size();i++) {
															#line 3448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!IFailureMonitor::failureMonitor() .getState(locations[shard] .locations->get(i, &StorageServerInterface::getKeyValuesStream) .getEndpoint()) .failed)
															#line 15963 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3453 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (deterministicRandom()->random01() <= 1.0 / ++count)
															#line 15967 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3454 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					useIdx = i;
															#line 15971 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
			}
		}
															#line 3459 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (useIdx >= 0)
															#line 15977 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1loopBody1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3463 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		std::vector<Future<Void>> ok(locations[shard].locations->size());
															#line 3464 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for(int i = 0;i < ok.size();i++) {
															#line 3465 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ok[i] = IFailureMonitor::failureMonitor().onStateEqual( locations[shard] .locations->get(i, &StorageServerInterface::getKeyValuesStream) .getEndpoint(), FailureStatus(false));
															#line 15987 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3473 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (now() - g_network->networkInfo.newestAlternativesFailure > 1 || deterministicRandom()->random01() < 0.01)
															#line 15991 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3475 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			TraceEvent("AllAlternativesFailed") .detail("Alternatives", locations[shard].locations->description());
															#line 15995 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3479 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_2 = allAlternativesFailedDelay(quorum(ok, 1));
															#line 3479 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16001 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 3;
															#line 3479 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 2, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 16006 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont7(int loopDepth) 
	{
															#line 3630 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (breakAgain)
															#line 16115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1(int loopDepth) 
	{
															#line 3494 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_3 = results->onEmpty();
															#line 3494 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16136 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1cont6loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 4;
															#line 3494 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 3, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 16141 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 3497 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_4 = trState->cx->connectionFileChanged();
															#line 3496 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 16166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
															#line 3505 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_5 = replyStream.getFuture();
															#line 16170 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetKeyValuesStreamReply>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetKeyValuesStreamReply>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(__when_expr_5.pop(), loopDepth); };
			static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 5;
															#line 3497 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 4, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 3505 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 16178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 3497 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_4 = trState->cx->connectionFileChanged();
															#line 3496 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 16196 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
															#line 3505 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			auto __when_expr_5 = replyStream.getFuture();
															#line 16200 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetKeyValuesStreamReply>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetKeyValuesStreamReply>>::value, "invalid type");
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(__when_expr_5.pop(), loopDepth); };
			static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 5;
															#line 3497 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamFragmentActor, 4, Void >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 3505 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*>(static_cast<GetRangeStreamFragmentActor*>(this)));
															#line 16208 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont2(int loopDepth) 
	{
															#line 3526 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (trState->readOptions.present() && trState->readOptions.get().debugID.present())
															#line 16298 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3527 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", trState->readOptions.get().debugID.get().first(), "NativeAPI.getExactRange.After");
															#line 16302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3530 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		RangeResult output(RangeResultRef(rep.data, rep.more), rep.arena);
															#line 3532 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 16308 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3534 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			GetKeyValuesStreamReply replyCopy;
															#line 3535 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.version = rep.version;
															#line 3536 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.more = rep.more;
															#line 3537 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.cached = rep.cached;
															#line 3538 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.arena.dependsOn(rep.arena);
															#line 3539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			replyCopy.data.append(replyCopy.arena, rep.data.begin(), rep.data.size());
															#line 3540 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.send(replyCopy);
															#line 16324 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3543 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		int64_t bytes = 0;
															#line 3544 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		for( const KeyValueRef& kv : output ) {
															#line 3545 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			bytes += kv.key.size() + kv.value.size();
															#line 16332 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3548 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionBytesRead += bytes;
															#line 3549 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->transactionKeysRead += output.size();
															#line 3552 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse && output.more && rep.data.size() > 0 && output[output.size() - 1].key == locations[shard].range.begin)
															#line 16340 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3554 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = false;
															#line 16344 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3557 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (output.more)
															#line 16348 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3558 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (!rep.data.size())
															#line 16352 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3559 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				TraceEvent(SevError, "GetRangeStreamError") .detail("Reason", "More data indicated but no rows present") .detail("LimitBytes", limits.bytes) .detail("LimitRows", limits.rows) .detail("OutputSize", output.size()) .detail("OutputBytes", output.expectedSize()) .detail("BlockSize", rep.data.size()) .detail("BlockBytes", rep.data.expectedSize());
															#line 3567 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				ASSERT(false);
															#line 16358 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3569 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			CODE_PROBE(true, "GetKeyValuesStreamReply.more in getRangeStream");
															#line 3571 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (reverse)
															#line 16364 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3572 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(locations[shard].range.begin, output[output.size() - 1].key);
															#line 16368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3575 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				locations[shard].range = KeyRangeRef(keyAfter(output[output.size() - 1].key), locations[shard].range.end);
															#line 16374 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
		}
															#line 3579 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (locations[shard].range.empty())
															#line 16379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3580 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = false;
															#line 16383 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!output.more)
															#line 16387 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			const KeyRange& range = locations[shard].range;
															#line 3585 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (shard == locations.size() - 1)
															#line 16393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3586 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef begin = reverse ? keys.begin : range.end;
															#line 3587 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				KeyRef end = reverse ? range.begin : keys.end;
															#line 3589 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (begin >= end)
															#line 16401 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3590 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (range.begin == allKeys.begin)
															#line 16405 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 3591 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						output.readToBegin = true;
															#line 16409 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					}
															#line 3593 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (range.end == allKeys.end)
															#line 16413 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 3594 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						output.readThroughEnd = true;
															#line 16417 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					}
															#line 3596 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.arena().dependsOn(keys.arena());
															#line 3599 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.more = true;
															#line 3600 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					output.setReadThrough(reverse ? keys.begin : keys.end);
															#line 3601 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					results->send(std::move(output));
															#line 3602 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					results->finish();
															#line 3603 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 16431 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					{
															#line 3604 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
						tssDuplicateStream.get().stream.sendError(end_of_stream());
															#line 16435 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					}
															#line 3606 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 16439 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
					new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeStreamFragmentActorState();
					static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 3608 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				keys = KeyRangeRef(begin, end);
															#line 3609 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				breakAgain = true;
															#line 16449 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
			else
			{
															#line 3611 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				++shard;
															#line 16455 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3613 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.arena().dependsOn(range.arena());
															#line 3615 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.more = true;
															#line 3616 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.setReadThrough(reverse ? range.begin : range.end);
															#line 3617 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			results->send(std::move(output));
															#line 16465 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			return a_body1loopBody1cont1loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3621 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		ASSERT(output.size());
															#line 3622 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (keys.begin == allKeys.begin && !reverse)
															#line 16472 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3623 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readToBegin = true;
															#line 16476 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (keys.end == allKeys.end && reverse)
															#line 16480 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3626 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			output.readThroughEnd = true;
															#line 16484 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3628 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->send(std::move(output));
															#line 16488 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3511 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			++trState->cx->transactionPhysicalReadsCompleted;
															#line 3512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() == error_code_broken_promise)
															#line 16500 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3513 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 16504 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3514 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					tssDuplicateStream.get().stream.sendError(connection_failed());
															#line 16508 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3516 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1loopBody1cont1loopBody1Catch1(connection_failed(), std::max(0, loopDepth - 1));
															#line 16512 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3518 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 16516 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			{
															#line 3519 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 16520 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				{
															#line 3520 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
					tssDuplicateStream.get().stream.sendError(e);
															#line 16524 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
				}
															#line 3522 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				return a_body1loopBody1cont1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 16528 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3524 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			rep = GetKeyValuesStreamReply();
															#line 16532 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont3(int loopDepth) 
	{
															#line 3509 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++trState->cx->transactionPhysicalReadsCompleted;
															#line 16547 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 3498 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3499 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 16558 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3500 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.sendError(transaction_too_old());
															#line 16562 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 16566 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 3498 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		results->sendError(transaction_too_old());
															#line 3499 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (tssDuplicateStream.present() && !tssDuplicateStream.get().done())
															#line 16580 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3500 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			tssDuplicateStream.get().stream.sendError(transaction_too_old());
															#line 16584 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamFragmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamFragmentActorState(); static_cast<GetRangeStreamFragmentActor*>(this)->destroy(); return 0; }
															#line 16588 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamFragmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamFragmentActorState();
		static_cast<GetRangeStreamFragmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(GetKeyValuesStreamReply const& _rep,int loopDepth) 
	{
															#line 3506 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 16600 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(GetKeyValuesStreamReply && _rep,int loopDepth) 
	{
															#line 3506 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		rep = _rep;
															#line 16609 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 4, Void >::remove();
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,GetKeyValuesStreamReply const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,GetKeyValuesStreamReply && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont6loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont1loopBody1cont6loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont6loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamFragmentActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamFragmentActor*>(this)->ActorCallback< GetRangeStreamFragmentActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetRangeStreamFragmentActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ParallelStream<RangeResult>::Fragment* results;
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange keys;
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	SpanContext spanContext;
															#line 3393 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRangeLocationInfo> locations;
															#line 3401 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int shard;
															#line 3405 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Optional<TSSDuplicateStreamData<GetKeyValuesStreamReply>> tssDuplicateStream;
															#line 3406 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesStreamRequest req;
															#line 3433 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetKeyValuesStreamReply rep;
															#line 3441 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int useIdx;
															#line 3482 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ReplyPromiseStream<GetKeyValuesStreamReply> replyStream;
															#line 3492 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	bool breakAgain;
															#line 16878 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRangeStreamFragment()
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamFragmentActor final : public Actor<Void>, public ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >, public ActorCallback< GetRangeStreamFragmentActor, 1, Void >, public ActorCallback< GetRangeStreamFragmentActor, 2, Void >, public ActorCallback< GetRangeStreamFragmentActor, 3, Void >, public ActorCallback< GetRangeStreamFragmentActor, 4, Void >, public ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >, public ActorCallback< GetRangeStreamFragmentActor, 6, Void >, public FastAllocated<GetRangeStreamFragmentActor>, public GetRangeStreamFragmentActorState<GetRangeStreamFragmentActor> {
															#line 16883 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRangeStreamFragmentActor>::operator new;
	using FastAllocated<GetRangeStreamFragmentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13853649455805911040UL, 10526198232459808000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 1, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 2, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 3, Void >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 4, Void >;
friend struct ActorSingleCallback< GetRangeStreamFragmentActor, 5, GetKeyValuesStreamReply >;
friend struct ActorCallback< GetRangeStreamFragmentActor, 6, Void >;
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamFragmentActor(Reference<TransactionState> const& trState,ParallelStream<RangeResult>::Fragment* const& results,KeyRange const& keys,GetRangeLimits const& limits,Snapshot const& snapshot,Reverse const& reverse,SpanContext const& spanContext) 
															#line 16906 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   GetRangeStreamFragmentActorState<GetRangeStreamFragmentActor>(trState, results, keys, limits, snapshot, reverse, spanContext),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5899419315066500352UL, 5523941769855860224UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamFragmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeStreamFragment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeStreamFragment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 0, std::vector<KeyRangeLocationInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeStreamFragmentActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> getRangeStreamFragment( Reference<TransactionState> const& trState, ParallelStream<RangeResult>::Fragment* const& results, KeyRange const& keys, GetRangeLimits const& limits, Snapshot const& snapshot, Reverse const& reverse, SpanContext const& spanContext ) {
															#line 3385 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new GetRangeStreamFragmentActor(trState, results, keys, limits, snapshot, reverse, spanContext));
															#line 16944 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

															#line 16949 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyRef>>> getRangeSplitPoints( Reference<TransactionState> const& trState, KeyRange const& keys, int64_t const& chunkSize );

#line 3666 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

static KeyRange intersect(KeyRangeRef lhs, KeyRangeRef rhs) {
	return KeyRange(KeyRangeRef(std::max(lhs.begin, rhs.begin), std::min(lhs.end, rhs.end)));
}

// Divides the requested key range into 1MB fragments, create range streams for each fragment, and merges the results so
// the client get them in order
															#line 16960 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getRangeStream()
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetRangeStreamActor>
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamActorState {
															#line 16967 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamActorState(Reference<TransactionState> const& trState,PromiseStream<RangeResult> const& _results,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse) 
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState),
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   _results(_results),
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   begin(begin),
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   end(end),
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   limits(limits),
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   conflictRange(conflictRange),
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   snapshot(snapshot),
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   reverse(reverse),
															#line 3681 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		   results(_results, CLIENT_KNOBS->RANGESTREAM_BUFFERED_FRAGMENTS_LIMIT)
															#line 16990 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeStream", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeStreamActorState() 
	{
		fdb_probe_actor_destroy("getRangeStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3684 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			ASSERT(!limits.hasRowLimit());
															#line 3685 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			span = Span("NAPI:getRangeStream"_loc, trState->spanContext);
															#line 3687 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 3687 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17011 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 1;
															#line 3687 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 0, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17016 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getRangeStream has tenant");
															#line 3690 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 3692 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Future<Key> fb = resolveKey(trState, begin, UseTenant::True);
															#line 3693 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		fe = resolveKey(trState, end, UseTenant::True);
															#line 3695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fb;
															#line 3695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17049 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 2;
															#line 3695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 1, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17054 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3689 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		CODE_PROBE(trState->hasTenant(), "NativeAPI getRangeStream has tenant");
															#line 3690 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		trState->cx->validateVersion(trState->readVersion());
															#line 3692 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		Future<Key> fb = resolveKey(trState, begin, UseTenant::True);
															#line 3693 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		fe = resolveKey(trState, end, UseTenant::True);
															#line 3695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_1 = fb;
															#line 3695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17073 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 2;
															#line 3695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 1, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17078 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 3696 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Key> __when_expr_2 = fe;
															#line 3696 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 3;
															#line 3696 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 2, Key >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Key const& __b,int loopDepth) 
	{
															#line 3695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		b = __b;
															#line 17178 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Key && __b,int loopDepth) 
	{
		b = std::move(__b);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 3698 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!snapshot)
															#line 17257 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3700 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			conflictRange.send(std::make_pair(std::min(b, Key(begin.getKey(), begin.arena())), std::max(e, Key(end.getKey(), end.arena()))));
															#line 17261 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3704 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (b >= e)
															#line 17265 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_3 = results.finish();
															#line 3705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17271 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 4;
															#line 3705 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 3, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17276 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Key const& __e,int loopDepth) 
	{
															#line 3696 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		e = __e;
															#line 17290 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Key && __e,int loopDepth) 
	{
		e = std::move(__e);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 2, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 2, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 2, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 2, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 3713 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests = std::vector<Future<Void>>();
															#line 3714 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 17371 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 3706 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 17380 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 3706 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 17392 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 3750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Void> __when_expr_7 = waitForAll(outstandingRequests) && results.finish();
															#line 3750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17481 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 8;
															#line 3750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 7, Void >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17486 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 3714 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(b < e))
															#line 17502 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<KeyRangeLocationInfo> __when_expr_4 = getKeyLocation( trState, reverse ? e : b, &StorageServerInterface::getKeyValuesStream, reverse, UseTenant::True);
															#line 3715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17510 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 5;
															#line 3715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17515 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 3717 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		shardIntersection = intersect(locationInfo.range, KeyRangeRef(b, e));
															#line 3718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_5 = getRangeSplitPoints(trState, shardIntersection, CLIENT_KNOBS->RANGESTREAM_FRAGMENT_SIZE);
															#line 3718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17541 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 6;
															#line 3718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17546 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(KeyRangeLocationInfo const& __locationInfo,int loopDepth) 
	{
															#line 3715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		locationInfo = __locationInfo;
															#line 17555 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(KeyRangeLocationInfo && __locationInfo,int loopDepth) 
	{
		locationInfo = std::move(__locationInfo);
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,KeyRangeLocationInfo const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,KeyRangeLocationInfo && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4loopBody1cont3(int loopDepth) 
	{
															#line 3720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		toSend = std::vector<KeyRange>();
															#line 3723 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!splitPoints.empty())
															#line 17636 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3724 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(shardIntersection.begin, splitPoints.front()), splitPoints.arena()));
															#line 3725 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			for(int i = 0;i < splitPoints.size() - 1;++i) {
															#line 3726 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
				toSend.push_back(KeyRange(KeyRangeRef(splitPoints[i], splitPoints[i + 1]), splitPoints.arena()));
															#line 17644 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			}
															#line 3728 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(splitPoints.back(), shardIntersection.end), splitPoints.arena()));
															#line 17648 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 3730 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			toSend.push_back(KeyRange(KeyRangeRef(shardIntersection.begin, shardIntersection.end)));
															#line 17654 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
															#line 3733 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		idx = 0;
															#line 3734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = 0;
															#line 3735 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		;
															#line 17662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Standalone<VectorRef<KeyRef>> const& __splitPoints,int loopDepth) 
	{
															#line 3718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		splitPoints = __splitPoints;
															#line 17671 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1when1(Standalone<VectorRef<KeyRef>> && __splitPoints,int loopDepth) 
	{
		splitPoints = std::move(__splitPoints);
		loopDepth = a_body1cont4loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont4loopBody1cont4(int loopDepth) 
	{
															#line 3744 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (reverse)
															#line 17750 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
															#line 3745 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			e = shardIntersection.begin;
															#line 17754 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		else
		{
															#line 3747 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			b = shardIntersection.end;
															#line 17760 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 3735 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!(idx < toSend.size()))
															#line 17777 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont4loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3736 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		useIdx = reverse ? toSend.size() - idx - 1 : idx;
															#line 3737 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (toSend[useIdx].empty())
															#line 17785 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		{
			return a_body1cont4loopBody1cont3continue1(loopDepth); // continue
		}
															#line 3740 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		StrictFuture<ParallelStream<RangeResult>::Fragment*> __when_expr_6 = results.createFragment();
															#line 3740 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 17793 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1cont3loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 7;
															#line 3740 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*>(static_cast<GetRangeStreamActor*>(this)));
															#line 17798 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3continue1(int loopDepth) 
	{
															#line 3735 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 17820 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1cont1(ParallelStream<RangeResult>::Fragment* const& fragment,int loopDepth) 
	{
															#line 3741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests.push_back( getRangeStreamFragment(trState, fragment, toSend[useIdx], limits, snapshot, reverse, span.context));
															#line 3735 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 17831 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1cont1(ParallelStream<RangeResult>::Fragment* && fragment,int loopDepth) 
	{
															#line 3741 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		outstandingRequests.push_back( getRangeStreamFragment(trState, fragment, toSend[useIdx], limits, snapshot, reverse, span.context));
															#line 3735 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		++idx;
															#line 17842 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1when1(ParallelStream<RangeResult>::Fragment* const& fragment,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3loopBody1cont1(fragment, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3loopBody1when1(ParallelStream<RangeResult>::Fragment* && fragment,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3loopBody1cont1(std::move(fragment), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,ParallelStream<RangeResult>::Fragment* const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,ParallelStream<RangeResult>::Fragment* && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 3751 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 17926 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 3751 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetRangeStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeStreamActorState(); static_cast<GetRangeStreamActor*>(this)->destroy(); return 0; }
															#line 17938 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetRangeStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeStreamActorState();
		static_cast<GetRangeStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<GetRangeStreamActor*>(this)->actor_wait_state > 0) static_cast<GetRangeStreamActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeStreamActor*>(this)->ActorCallback< GetRangeStreamActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< GetRangeStreamActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< GetRangeStreamActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reference<TransactionState> trState;
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	PromiseStream<RangeResult> _results;
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector begin;
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeySelector end;
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeLimits limits;
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Promise<std::pair<Key, Key>> conflictRange;
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Snapshot snapshot;
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Reverse reverse;
															#line 3681 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	ParallelStream<RangeResult> results;
															#line 3685 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Span span;
															#line 3693 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Future<Key> fe;
															#line 3695 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key b;
															#line 3696 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Key e;
															#line 3713 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<Future<Void>> outstandingRequests;
															#line 3715 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRangeLocationInfo locationInfo;
															#line 3717 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	KeyRange shardIntersection;
															#line 3718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	Standalone<VectorRef<KeyRef>> splitPoints;
															#line 3720 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	std::vector<KeyRange> toSend;
															#line 3733 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int idx;
															#line 3734 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	int useIdx;
															#line 18061 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
};
// This generated class is to be used only via getRangeStream()
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetRangeStreamActor final : public Actor<Void>, public ActorCallback< GetRangeStreamActor, 0, Void >, public ActorCallback< GetRangeStreamActor, 1, Key >, public ActorCallback< GetRangeStreamActor, 2, Key >, public ActorCallback< GetRangeStreamActor, 3, Void >, public ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >, public ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >, public ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >, public ActorCallback< GetRangeStreamActor, 7, Void >, public FastAllocated<GetRangeStreamActor>, public GetRangeStreamActorState<GetRangeStreamActor> {
															#line 18066 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
	using FastAllocated<GetRangeStreamActor>::operator new;
	using FastAllocated<GetRangeStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1415592559537623808UL, 3625456178788362496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeStreamActor, 0, Void >;
friend struct ActorCallback< GetRangeStreamActor, 1, Key >;
friend struct ActorCallback< GetRangeStreamActor, 2, Key >;
friend struct ActorCallback< GetRangeStreamActor, 3, Void >;
friend struct ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >;
friend struct ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >;
friend struct ActorCallback< GetRangeStreamActor, 7, Void >;
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetRangeStreamActor(Reference<TransactionState> const& trState,PromiseStream<RangeResult> const& _results,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limits,Promise<std::pair<Key, Key>> const& conflictRange,Snapshot const& snapshot,Reverse const& reverse) 
															#line 18090 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		 : Actor<Void>(),
		   GetRangeStreamActorState<GetRangeStreamActor>(trState, _results, begin, end, limits, conflictRange, snapshot, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10544369634926336512UL, 15814804397175604224UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeStreamActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRangeStreamActor, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRangeStreamActor, 2, Key >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRangeStreamActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetRangeStreamActor, 4, KeyRangeLocationInfo >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetRangeStreamActor, 5, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< GetRangeStreamActor, 6, ParallelStream<RangeResult>::Fragment* >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< GetRangeStreamActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
[[nodiscard]] Future<Void> getRangeStream( Reference<TransactionState> const& trState, PromiseStream<RangeResult> const& _results, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limits, Promise<std::pair<Key, Key>> const& conflictRange, Snapshot const& snapshot, Reverse const& reverse ) {
															#line 3673 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	return Future<Void>(new GetRangeStreamActor(trState, _results, begin, end, limits, conflictRange, snapshot, reverse));
															#line 18130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
}

#line 3753 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"

Future<RangeResult> getRange(Reference<TransactionState> const& trState,
                             KeySelector const& begin,
                             KeySelector const& end,
                             GetRangeLimits const& limits,
                             Reverse const& reverse,
                             UseTenant const& useTenant) {
	return getRange<GetKeyValuesRequest, GetKeyValuesReply, RangeResult>(
	    trState, begin, end, ""_sr, limits, Promise<std::pair<Key, Key>>(), Snapshot::True, reverse, useTenant);
}

bool DatabaseContext::debugUseTags = false;
const std::vector<std::string> DatabaseContext::debugTransactionTagChoices = { "a", "b", "c", "d", "e", "f", "g",
	                                                                           "h", "i", "j", "k", "l", "m", "n",
	                                                                           "o", "p", "q", "r", "s", "t" };

void debugAddTags(Reference<TransactionState> trState) {
	int numTags = deterministicRandom()->randomInt(0, CLIENT_KNOBS->MAX_TAGS_PER_TRANSACTION + 1);
	for (int i = 0; i < numTags; ++i) {
		TransactionTag tag;
		if (deterministicRandom()->random01() < 0.7) {
			tag = TransactionTagRef(deterministicRandom()->randomChoice(DatabaseContext::debugTransactionTagChoices));
		} else {
			int length = deterministicRandom()->randomInt(1, CLIENT_KNOBS->MAX_TRANSACTION_TAG_LENGTH + 1);
			uint8_t* s = new (tag.arena()) uint8_t[length];
			for (int j = 0; j < length; ++j) {
				s[j] = (uint8_t)deterministicRandom()->randomInt(0, 256);
			}

			tag.contents() = TransactionTagRef(s, length);
		}

		if (deterministicRandom()->coinflip()) {
			trState->options.readTags.addTag(tag);
		}
		trState->options.tags.addTag(tag);
	}
}

Transaction::Transaction()
  : trState(makeReference<TransactionState>(TaskPriority::DefaultEndpoint, generateSpanID(false))) {}

Transaction::Transaction(Database const& cx, Optional<Reference<Tenant>> const& tenant)
  : trState(makeReference<TransactionState>(cx,
                                            tenant,
                                            cx->taskID,
                                            generateSpanID(cx->transactionTracingSample),
                                            createTrLogInfoProbabilistically(cx))),
    span(trState->spanContext, "Transaction"_loc), backoff(CLIENT_KNOBS->DEFAULT_BACKOFF), tr(trState->spanContext) {
	if (DatabaseContext::debugUseTags) {
		debugAddTags(trState);
	}
}

Transaction::~Transaction() {
	flushTrLogsIfEnabled();
	cancelWatches();
}

void Transaction::operator=(Transaction&& r) noexcept {
	flushTrLogsIfEnabled();
	tr = std::move(r.tr);
	trState = std::move(r.trState);
	extraConflictRanges = std::move(r.extraConflictRanges);
	commitResult = std::move(r.commitResult);
	committing = std::move(r.committing);
	backoff = r.backoff;
	watches = r.watches;
}

void Transaction::flushTrLogsIfEnabled() {
	if (trState && trState->trLogInfo && trState->trLogInfo->logsAdded && trState->trLogInfo->trLogWriter.getData()) {
		ASSERT(trState->trLogInfo->flushed == false);
		trState->cx->clientStatusUpdater.inStatusQ.push_back(
		    { trState->trLogInfo->identifier, std::move(trState->trLogInfo->trLogWriter) });
		trState->trLogInfo->flushed = true;
	}
}

VersionVector Transaction::getVersionVector() const {
	return trState->cx->ssVersionVectorCache;
}

void Transaction::setVersion(Version v) {
	trState->startTime = now();
	if (trState->readVersionFuture.isValid())
		throw read_version_already_set();
	if (v <= 0)
		throw version_invalid();

	trState->readVersionFuture = v;
	trState->readVersionObtainedFromGrvProxy = false;
}

Future<Optional<Value>> Transaction::get(const Key& key, Snapshot snapshot) {
	++trState->cx->transactionLogicalReads;
	++trState->cx->transactionGetValueRequests;
	// ASSERT (key < allKeys.end);

	// There are no keys in the database with size greater than the max key size
	if (key.size() > getMaxReadKeySize(key)) {
		return Optional<Value>();
	}

	auto ver = getReadVersion();

	/*	if (!systemKeys.contains(key))
	        return Optional<Value>(Value()); */

	if (!snapshot)
		tr.transaction.read_conflict_ranges.push_back(tr.arena, singleKeyRange(key, tr.arena));

	UseTenant useTenant = UseTenant::True;
	if (key == metadataVersionKey) {
		// It is legal to read the metadata version key inside of a tenant.
		// This will return the global metadata version key.
		useTenant = UseTenant::False;
		++trState->cx->transactionMetadataVersionReads;
		if (!ver.isReady() || trState->metadataVersion.isSet()) {
			return trState->metadataVersion.getFuture();
		} else {
			if (ver.isError()) {
				return ver.getError();
			}
			if (ver.get() == trState->cx->metadataVersionCache[trState->cx->mvCacheInsertLocation].first) {
				return trState->cx->metadataVersionCache[trState->cx->mvCacheInsertLocation].second;
			}

			Version v = ver.get();
			int hi = trState->cx->mvCacheInsertLocation;
			int lo = (trState->cx->mvCacheInsertLocation + 1) % trState->cx->metadataVersionCache.size();

			while (hi != lo) {
				int cu = hi > lo ? (hi + lo) / 2
				                 : ((hi + trState->cx->metadataVersionCache.size() + lo) / 2) %
				                       trState->cx->metadataVersionCache.size();
				if (v == trState->cx->metadataVersionCache[cu].first) {
					return trState->cx->metadataVersionCache[cu].second;
				}
				if (cu == lo) {
					break;
				}
				if (v < trState->cx->metadataVersionCache[cu].first) {
					hi = cu;
				} else {
					lo = (cu + 1) % trState->cx->metadataVersionCache.size();
				}
			}
		}
	}

	return getValue(trState, key, useTenant);
}

void Watch::setWatch(Future<Void> watchFuture) {
	this->watchFuture = watchFuture;

	// Cause the watch loop to go around and start waiting on watchFuture
	onSetWatchTrigger.send(Void());
}

															#line 18295 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
namespace {
// This generated class is to be used only via getTenantMetadata()
															#line 3914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
template <class GetTenantMetadataActor>
															#line 3914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
class GetTenantMetadataActorState {
															#line 18302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
public:
															#line 3914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
	GetTenantMetadataActorState(Reference<TransactionState> const& trState) 
															#line 3914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
															#line 3914 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		 : trState(trState)
															#line 18309 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
	{
		fdb_probe_actor_create("getTenantMetadata", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantMetadataActorState() 
	{
		fdb_probe_actor_destroy("getTenantMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3915 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			StrictFuture<Void> __when_expr_0 = trState->startTransaction();
															#line 3915 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			if (static_cast<GetTenantMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18326 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantMetadataActor*>(this)->actor_wait_state = 1;
															#line 3915 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantMetadataActor, 0, Void >*>(static_cast<GetTenantMetadataActor*>(this)));
															#line 18331 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantMetadataActorState();
		static_cast<GetTenantMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3916 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetTenantMetadataActor*>(this)->SAV<TenantInfo>::futures) { (void)(trState->getTenantInfo()); this->~GetTenantMetadataActorState(); static_cast<GetTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 18354 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetTenantMetadataActor*>(this)->SAV< TenantInfo >::value()) TenantInfo(trState->getTenantInfo());
		this->~GetTenantMetadataActorState();
		static_cast<GetTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3916 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbclient/NativeAPI.actor.cpp"
		if (!static_cast<GetTenantMetadataActor*>(this)->SAV<TenantInfo>::futures) { (void)(trState->getTenantInfo()); this->~GetTenantMetadataActorState(); static_cast<GetTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 18366 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbclient/NativeAPI.actor.g.cpp"
		new (&static_cast<GetTenantMetadataActor*>(this)->SAV< TenantInfo >::value()) TenantInfo(trState->getTenantInfo());
		this->~GetTenantMetadataActorState();
		static_cast<GetTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantMetadataActor*>(this)->actor_wait_state > 0) static_cast<GetTenantMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantMetadataActor*>(this)->ActorCallback< GetTenantMetadataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantMetadataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantMetadataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantMetadataActor