#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
/*
 * ConsistencyScanCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>
#include <list>
#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunTransaction.actor.h"
#include "fdbclient/ConsistencyScanInterface.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 35 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
// This generated class is to be used only via dumpStats()
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
template <class DumpStatsActor>
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
class DumpStatsActorState {
															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
public:
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	DumpStatsActorState(ConsistencyScanState* const& cs,Reference<ReadYourWritesTransaction> const& tr) 
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		 : cs(cs),
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		   tr(tr),
															#line 34 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		   statsLifetime(),
															#line 35 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		   statsCurrentRound()
															#line 54 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpStats", reinterpret_cast<unsigned long>(this));

	}
	~DumpStatsActorState() 
	{
		fdb_probe_actor_destroy("dumpStats", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 36 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(statsLifetime, cs->lifetimeStats().getD(tr)) && store(statsCurrentRound, cs->currentRoundStats().getD(tr));
															#line 36 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			if (static_cast<DumpStatsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 71 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DumpStatsActor*>(this)->actor_wait_state = 1;
															#line 36 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpStatsActor, 0, Void >*>(static_cast<DumpStatsActor*>(this)));
															#line 76 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpStatsActorState();
		static_cast<DumpStatsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 38 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		printf( "Current Round:\n%s\n", json_spirit::write_string(json_spirit::mValue(statsCurrentRound.toJSON()), json_spirit::pretty_print).c_str());
															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		printf("Lifetime:\n%s\n", json_spirit::write_string(json_spirit::mValue(statsLifetime.toJSON()), json_spirit::pretty_print).c_str());
															#line 43 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (!static_cast<DumpStatsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpStatsActorState(); static_cast<DumpStatsActor*>(this)->destroy(); return 0; }
															#line 103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		new (&static_cast<DumpStatsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DumpStatsActorState();
		static_cast<DumpStatsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 38 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		printf( "Current Round:\n%s\n", json_spirit::write_string(json_spirit::mValue(statsCurrentRound.toJSON()), json_spirit::pretty_print).c_str());
															#line 41 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		printf("Lifetime:\n%s\n", json_spirit::write_string(json_spirit::mValue(statsLifetime.toJSON()), json_spirit::pretty_print).c_str());
															#line 43 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (!static_cast<DumpStatsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpStatsActorState(); static_cast<DumpStatsActor*>(this)->destroy(); return 0; }
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		new (&static_cast<DumpStatsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DumpStatsActorState();
		static_cast<DumpStatsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpStatsActor*>(this)->actor_wait_state > 0) static_cast<DumpStatsActor*>(this)->actor_wait_state = 0;
		static_cast<DumpStatsActor*>(this)->ActorCallback< DumpStatsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpStatsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpStats", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpStats", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpStatsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpStats", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpStats", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpStatsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpStats", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpStats", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	ConsistencyScanState* cs;
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 34 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	ConsistencyScanState::LifetimeStats statsLifetime;
															#line 35 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	ConsistencyScanState::RoundStats statsCurrentRound;
															#line 210 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
};
// This generated class is to be used only via dumpStats()
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
class DumpStatsActor final : public Actor<Void>, public ActorCallback< DumpStatsActor, 0, Void >, public FastAllocated<DumpStatsActor>, public DumpStatsActorState<DumpStatsActor> {
															#line 215 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
public:
	using FastAllocated<DumpStatsActor>::operator new;
	using FastAllocated<DumpStatsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15485260011921044480UL, 7907064697849841408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpStatsActor, 0, Void >;
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	DumpStatsActor(ConsistencyScanState* const& cs,Reference<ReadYourWritesTransaction> const& tr) 
															#line 232 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		 : Actor<Void>(),
		   DumpStatsActorState<DumpStatsActor>(cs, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpStats", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12957340965808443136UL, 3788418204436759808UL);
		ActorExecutionContextHelper __helper(static_cast<DumpStatsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpStats");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpStats", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpStatsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
[[nodiscard]] Future<Void> dumpStats( ConsistencyScanState* const& cs, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 33 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	return Future<Void>(new DumpStatsActor(cs, tr));
															#line 264 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
}

#line 45 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"

															#line 269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
// This generated class is to be used only via consistencyScanCommandActor()
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
template <class ConsistencyScanCommandActorActor>
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
class ConsistencyScanCommandActorActorState {
															#line 275 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
public:
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	ConsistencyScanCommandActorActorState(Database const& db,std::vector<StringRef> const& tokens) 
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		 : db(db),
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		   tokens(tokens),
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		   args(tokens.begin() + 1, tokens.end()),
															#line 50 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		   cs(ConsistencyScanState()),
															#line 51 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(db)),
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		   error(false)
															#line 292 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyScanCommandActorActorState() 
	{
		fdb_probe_actor_destroy("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 54 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			;
															#line 307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyScanCommandActorActorState();
		static_cast<ConsistencyScanCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (error)
															#line 330 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		{
															#line 109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			printUsage(tokens[0]);
															#line 110 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			if (!static_cast<ConsistencyScanCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ConsistencyScanCommandActorActorState(); static_cast<ConsistencyScanCommandActorActor*>(this)->destroy(); return 0; }
															#line 336 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			new (&static_cast<ConsistencyScanCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ConsistencyScanCommandActorActorState();
			static_cast<ConsistencyScanCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (!static_cast<ConsistencyScanCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ConsistencyScanCommandActorActorState(); static_cast<ConsistencyScanCommandActorActor*>(this)->destroy(); return 0; }
															#line 344 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		new (&static_cast<ConsistencyScanCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ConsistencyScanCommandActorActorState();
		static_cast<ConsistencyScanCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 56 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			SystemDBWriteLockedNow(db.getReference())->setOptions(tr);
															#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			StrictFuture<ConsistencyScanState::Config> __when_expr_0 = ConsistencyScanState().config().getD(tr);
															#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 368 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 1;
															#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCommandActorActor, 0, ConsistencyScanState::Config >*>(static_cast<ConsistencyScanCommandActorActor*>(this)));
															#line 373 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 104 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 410 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 5;
															#line 104 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCommandActorActor, 4, Void >*>(static_cast<ConsistencyScanCommandActorActor*>(this)));
															#line 415 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 60 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (args.empty())
															#line 430 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		{
															#line 61 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			printf( "%s\n", json_spirit::write_string(json_spirit::mValue(config.toJSON()), json_spirit::pretty_print).c_str());
															#line 434 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 69 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		;
															#line 439 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config const& __config,int loopDepth) 
	{
															#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		config = __config;
															#line 448 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCommandActorActor*>(this)->ActorCallback< ConsistencyScanCommandActorActor, 0, ConsistencyScanState::Config >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config && value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCommandActorActor, 0, ConsistencyScanState::Config >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 97 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (error)
															#line 527 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 100 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		cs.config().set(tr, config);
															#line 101 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 101 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 537 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 4;
															#line 101 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCommandActorActor, 3, Void >*>(static_cast<ConsistencyScanCommandActorActor*>(this)));
															#line 542 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 69 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (!(!error && !args.empty()))
															#line 558 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 70 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		auto next = args.front();
															#line 71 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		args.pop_front();
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
		if (next == "on")
															#line 568 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		{
															#line 73 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			config.enabled = true;
															#line 572 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);
		}
		else
		{
															#line 74 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
			if (next == "off")
															#line 579 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
			{
															#line 75 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
				config.enabled = false;
															#line 583 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
				loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);
			}
			else
			{
															#line 76 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
				if (next == "restart")
															#line 590 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
				{
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
					config.minStartVersion = tr->getReadVersion().get();
															#line 594 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
					loopDepth = a_body1loopBody1cont2loopBody1cont6(loopDepth);
				}
				else
				{
															#line 78 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
					if (next == "stats")
															#line 601 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
					{
															#line 79 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
						StrictFuture<Void> __when_expr_1 = dumpStats(&cs, tr);
															#line 79 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
						if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 607 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
						static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 2;
															#line 79 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCommandActorActor, 1, Void >*>(static_cast<ConsistencyScanCommandActorActor*>(this)));
															#line 612 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 80 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
						if (next == "clearstats")
															#line 619 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
						{
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
							StrictFuture<Void> __when_expr_2 = cs.clearStats(tr);
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
							if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
							if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
							static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 3;
															#line 81 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
							__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCommandActorActor, 2, Void >*>(static_cast<ConsistencyScanCommandActorActor*>(this)));
															#line 630 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
							if (next == "maxRate")
															#line 637 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
							{
															#line 83 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
								error = args.empty();
															#line 84 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
								if (!error)
															#line 643 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
								{
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
									config.maxReadByteRate = boost::lexical_cast<int>(args.front().toString());
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
									args.pop_front();
															#line 649 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
								}
							}
							else
							{
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
								if (next == "targetInterval")
															#line 656 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
								{
															#line 89 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
									error = args.empty();
															#line 90 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
									if (!error)
															#line 662 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
									{
															#line 91 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
										config.targetRoundTimeSeconds = boost::lexical_cast<int>(args.front().toString());
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
										args.pop_front();
															#line 668 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
									}
								}
							}
							loopDepth = a_body1loopBody1cont2loopBody1cont10(loopDepth);
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCommandActorActor*>(this)->ActorCallback< ConsistencyScanCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCommandActorActor*>(this)->ActorCallback< ConsistencyScanCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCommandActorActor*>(this)->ActorCallback< ConsistencyScanCommandActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCommandActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCommandActorActor*>(this)->ActorCallback< ConsistencyScanCommandActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCommandActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCommandActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	Database db;
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 48 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	std::list<StringRef> args;
															#line 50 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	ConsistencyScanState cs;
															#line 51 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 52 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	bool error;
															#line 58 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	ConsistencyScanState::Config config;
															#line 1086 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
};
// This generated class is to be used only via consistencyScanCommandActor()
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
class ConsistencyScanCommandActorActor final : public Actor<bool>, public ActorCallback< ConsistencyScanCommandActorActor, 0, ConsistencyScanState::Config >, public ActorCallback< ConsistencyScanCommandActorActor, 1, Void >, public ActorCallback< ConsistencyScanCommandActorActor, 2, Void >, public ActorCallback< ConsistencyScanCommandActorActor, 3, Void >, public ActorCallback< ConsistencyScanCommandActorActor, 4, Void >, public FastAllocated<ConsistencyScanCommandActorActor>, public ConsistencyScanCommandActorActorState<ConsistencyScanCommandActorActor> {
															#line 1091 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
public:
	using FastAllocated<ConsistencyScanCommandActorActor>::operator new;
	using FastAllocated<ConsistencyScanCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9840920919320785920UL, 15179636988148975872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyScanCommandActorActor, 0, ConsistencyScanState::Config >;
friend struct ActorCallback< ConsistencyScanCommandActorActor, 1, Void >;
friend struct ActorCallback< ConsistencyScanCommandActorActor, 2, Void >;
friend struct ActorCallback< ConsistencyScanCommandActorActor, 3, Void >;
friend struct ActorCallback< ConsistencyScanCommandActorActor, 4, Void >;
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	ConsistencyScanCommandActorActor(Database const& db,std::vector<StringRef> const& tokens) 
															#line 1112 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
		 : Actor<bool>(),
		   ConsistencyScanCommandActorActorState<ConsistencyScanCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(412071116051756800UL, 9473943639126718208UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyScanCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyScanCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyScanCommandActorActor, 0, ConsistencyScanState::Config >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConsistencyScanCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConsistencyScanCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConsistencyScanCommandActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ConsistencyScanCommandActorActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
[[nodiscard]] Future<bool> consistencyScanCommandActor( Database const& db, std::vector<StringRef> const& tokens ) {
															#line 46 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"
	return Future<bool>(new ConsistencyScanCommandActorActor(db, tokens));
															#line 1148 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/fdbcli/ConsistencyScanCommand.actor.g.cpp"
}

#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/fdbcli/ConsistencyScanCommand.actor.cpp"

CommandFactory consistencyScanFactory(
    "consistencyscan",
    CommandHelp(
        // TODO:  Expose/document additional configuration options
        "consistencyscan [on|off] [restart] [stats] [clearstats] [maxRate <BYTES_PER_SECOND>] [targetInterval "
        "<SECONDS>]",
        "Enables, disables, or sets options for the Consistency Scan role which repeatedly scans "
        "shard replicas for consistency.",
        "`on' enables the scan.\n\n"
        "`off' disables the scan but keeps the current cycle's progress so it will resume later if enabled again.\n\n"
        "`restart' will end the current scan cycle.  A new cycle will start if the scan is enabled, or later when "
        "it is enabled.\n\n"
        "`maxRate <BYTES_PER_SECOND>' sets the maximum scan read speed rate to BYTES_PER_SECOND, post-replication.\n\n"
        "`targetInterval <SECONDS>' sets the target interval for the scan to SECONDS.  The scan will adjust speed "
        "to attempt to complete in that amount of time but it will not exceed BYTES_PER_SECOND\n\n"
        "`stats` dumps the current round and lifetime stats of the consistency scan. It is a convenience method to "
        "expose the stats which are also in status json.\n\n"
        "`clearstats` will clear all of the stats for the consistency scan but otherwise leave the configuration as "
        "is. This can be used to clear errors or reset stat counts, for example.\n\n"
        "The consistency scan role publishes its configuration and metrics in Status JSON under the path "
        "`.cluster.consistency_scan'\n"
        // TODO:  Syntax hint generator
        ));

} // namespace fdb_cli