#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
/*
 * make_h2o.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2025 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fmt/format.h"
#include "flow/flow.h"
#include "flow/Platform.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/TLSConfig.actor.h"
#include "flow/actorcompiler.h"

#include <functional>
#include <iostream>
#include <memory>
#include <unordered_map>
#include <vector>

// Flow solution to https://leetcode.com/problems/building-h2o/
//
// The description of this problem calls for threads running as
// hydrogen and oxygen.  To do this yourself, delete the code from
// this file other than main(), read the problem description above,
// and implement something in the spirit of what is requested.
//
// Caveat: this version was written on like day 2 of programming with
// Flow.  This seems to work but may have bugs, non-idiomatic code, or
// generally do naive stuff.
//
// Notes on this solution: we model these as actors and we start a lot
// of them simultaneously in batches from orchestrate() below.  Bonded
// sets of 2 H's and 1 O are supposed to complete together.  We
// arrange this by having the H's store off a Promise<int>, then block
// on the future.  The O's pass their ID and the H's simply log it.
// An O finishes when it has seen two H's.

static int h_seqno;
static int o_seqno;
std::queue<int> h_queue;
std::map<int, Promise<int>*> wakeup;

															#line 61 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
namespace {
// This generated class is to be used only via hydrogen()
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
template <class HydrogenActor>
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
class HydrogenActorState {
															#line 68 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
public:
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	HydrogenActorState(AsyncTrigger* const& h_ready_trigger) 
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		 : h_ready_trigger(h_ready_trigger),
															#line 60 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   h_id(h_seqno++)
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
	{
		fdb_probe_actor_create("hydrogen", reinterpret_cast<unsigned long>(this));

	}
	~HydrogenActorState() 
	{
		fdb_probe_actor_destroy("hydrogen", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			std::cout << format("Hydrogen %d starting\n", h_id);
															#line 62 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			promise = Promise<int>();
															#line 63 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			future = promise.getFuture();
															#line 64 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			ASSERT(wakeup.find(h_id) == wakeup.end());
															#line 65 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			wakeup[h_id] = &promise;
															#line 66 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h_queue.push(h_id);
															#line 67 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h_ready_trigger->trigger();
															#line 69 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			;
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HydrogenActorState();
		static_cast<HydrogenActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		StrictFuture<int> __when_expr_0 = future;
															#line 69 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (static_cast<HydrogenActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<HydrogenActor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HydrogenActor, 0, int >*>(static_cast<HydrogenActor*>(this)));
															#line 143 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& o,int loopDepth) 
	{
															#line 71 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		std::cout << format("Hydrogen %d bound to Oxygen %d, returning\n", h_id, o);
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (!static_cast<HydrogenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HydrogenActorState(); static_cast<HydrogenActor*>(this)->destroy(); return 0; }
															#line 154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		new (&static_cast<HydrogenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HydrogenActorState();
		static_cast<HydrogenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int && o,int loopDepth) 
	{
															#line 71 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		std::cout << format("Hydrogen %d bound to Oxygen %d, returning\n", h_id, o);
															#line 72 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (!static_cast<HydrogenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HydrogenActorState(); static_cast<HydrogenActor*>(this)->destroy(); return 0; }
															#line 168 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		new (&static_cast<HydrogenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HydrogenActorState();
		static_cast<HydrogenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HydrogenActor*>(this)->actor_wait_state > 0) static_cast<HydrogenActor*>(this)->actor_wait_state = 0;
		static_cast<HydrogenActor*>(this)->ActorCallback< HydrogenActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< HydrogenActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("hydrogen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HydrogenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hydrogen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HydrogenActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("hydrogen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HydrogenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hydrogen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HydrogenActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("hydrogen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HydrogenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("hydrogen", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	AsyncTrigger* h_ready_trigger;
															#line 60 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int h_id;
															#line 62 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	Promise<int> promise;
															#line 63 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	Future<int> future;
															#line 247 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
};
// This generated class is to be used only via hydrogen()
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
class HydrogenActor final : public Actor<Void>, public ActorCallback< HydrogenActor, 0, int >, public FastAllocated<HydrogenActor>, public HydrogenActorState<HydrogenActor> {
															#line 252 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
public:
	using FastAllocated<HydrogenActor>::operator new;
	using FastAllocated<HydrogenActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3795572945949006336UL, 10730338321682805248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HydrogenActor, 0, int >;
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	HydrogenActor(AsyncTrigger* const& h_ready_trigger) 
															#line 269 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		 : Actor<Void>(),
		   HydrogenActorState<HydrogenActor>(h_ready_trigger),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("hydrogen", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18175411809154454528UL, 12188204000544527872UL);
		ActorExecutionContextHelper __helper(static_cast<HydrogenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("hydrogen");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("hydrogen", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HydrogenActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
[[nodiscard]] Future<Void> hydrogen( AsyncTrigger* const& h_ready_trigger ) {
															#line 59 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	return Future<Void>(new HydrogenActor(h_ready_trigger));
															#line 302 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
}

#line 76 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"

															#line 307 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
namespace {
// This generated class is to be used only via oxygen()
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
template <class OxygenActor>
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
class OxygenActorState {
															#line 314 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	OxygenActorState(AsyncTrigger* const& h_ready_trigger) 
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		 : h_ready_trigger(h_ready_trigger),
															#line 78 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   h_bound(0),
															#line 79 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   o_id(o_seqno++)
															#line 325 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
	{
		fdb_probe_actor_create("oxygen", reinterpret_cast<unsigned long>(this));

	}
	~OxygenActorState() 
	{
		fdb_probe_actor_destroy("oxygen", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			std::cout << format("Oxygen %d starting\n", o_id);
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			;
															#line 342 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OxygenActorState();
		static_cast<OxygenActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 83 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		StrictFuture<Void> __when_expr_0 = h_ready_trigger->onTrigger();
															#line 82 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (static_cast<OxygenActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 374 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<OxygenActor*>(this)->actor_wait_state = 1;
															#line 83 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OxygenActor, 0, Void >*>(static_cast<OxygenActor*>(this)));
															#line 379 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 84 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		for(;h_queue.size() > 0;) {
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h = h_queue.front();
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h_queue.pop();
															#line 87 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			auto it = wakeup.find(h);
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			ASSERT(it != wakeup.end());
															#line 89 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			std::cout << format("Oxygen %d bound to Hydrogen %d\n", o_id, h);
															#line 90 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			wakeup.erase(it);
															#line 91 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			it->second->send(o_id);
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h_bound++;
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			if (h_bound == 2)
															#line 412 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			{
															#line 94 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				std::cout << format("  Oxygen %d returning\n", o_id);
															#line 95 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				if (!static_cast<OxygenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OxygenActorState(); static_cast<OxygenActor*>(this)->destroy(); return 0; }
															#line 418 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
				new (&static_cast<OxygenActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~OxygenActorState();
				static_cast<OxygenActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 84 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		for(;h_queue.size() > 0;) {
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h = h_queue.front();
															#line 86 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h_queue.pop();
															#line 87 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			auto it = wakeup.find(h);
															#line 88 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			ASSERT(it != wakeup.end());
															#line 89 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			std::cout << format("Oxygen %d bound to Hydrogen %d\n", o_id, h);
															#line 90 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			wakeup.erase(it);
															#line 91 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			it->second->send(o_id);
															#line 92 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h_bound++;
															#line 93 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			if (h_bound == 2)
															#line 451 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			{
															#line 94 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				std::cout << format("  Oxygen %d returning\n", o_id);
															#line 95 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				if (!static_cast<OxygenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OxygenActorState(); static_cast<OxygenActor*>(this)->destroy(); return 0; }
															#line 457 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
				new (&static_cast<OxygenActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~OxygenActorState();
				static_cast<OxygenActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OxygenActor*>(this)->actor_wait_state > 0) static_cast<OxygenActor*>(this)->actor_wait_state = 0;
		static_cast<OxygenActor*>(this)->ActorCallback< OxygenActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OxygenActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("oxygen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OxygenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oxygen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OxygenActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("oxygen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OxygenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oxygen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OxygenActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("oxygen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OxygenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oxygen", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	AsyncTrigger* h_ready_trigger;
															#line 78 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int h_bound;
															#line 79 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int o_id;
															#line 85 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int h;
															#line 539 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
};
// This generated class is to be used only via oxygen()
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
class OxygenActor final : public Actor<Void>, public ActorCallback< OxygenActor, 0, Void >, public FastAllocated<OxygenActor>, public OxygenActorState<OxygenActor> {
															#line 544 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
public:
	using FastAllocated<OxygenActor>::operator new;
	using FastAllocated<OxygenActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6606488582390408448UL, 17244592163438457088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OxygenActor, 0, Void >;
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	OxygenActor(AsyncTrigger* const& h_ready_trigger) 
															#line 561 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		 : Actor<Void>(),
		   OxygenActorState<OxygenActor>(h_ready_trigger),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("oxygen", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8985686440025918976UL, 10554296316536938240UL);
		ActorExecutionContextHelper __helper(static_cast<OxygenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("oxygen");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("oxygen", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OxygenActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
[[nodiscard]] Future<Void> oxygen( AsyncTrigger* const& h_ready_trigger ) {
															#line 77 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	return Future<Void>(new OxygenActor(h_ready_trigger));
															#line 594 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
}

#line 101 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"

															#line 599 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
namespace {
// This generated class is to be used only via orchestrate()
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
template <class OrchestrateActor>
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
class OrchestrateActorState {
															#line 606 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
public:
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	OrchestrateActorState() 
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
															#line 103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		 : h_threads(0),
															#line 104 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   o_threads(0),
															#line 105 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   total_h_threads(0),
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   total_o_threads(0),
															#line 107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   bigloops(0),
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   all(),
															#line 109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		   h_ready_trigger()
															#line 625 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
	{
		fdb_probe_actor_create("orchestrate", reinterpret_cast<unsigned long>(this));

	}
	~OrchestrateActorState() 
	{
		fdb_probe_actor_destroy("orchestrate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			;
															#line 640 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OrchestrateActorState();
		static_cast<OrchestrateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 173 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (!static_cast<OrchestrateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OrchestrateActorState(); static_cast<OrchestrateActor*>(this)->destroy(); return 0; }
															#line 663 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		new (&static_cast<OrchestrateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OrchestrateActorState();
		static_cast<OrchestrateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (!(bigloops < 1000))
															#line 682 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 114 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		int n = deterministicRandom()->randomInt(0, 3);
															#line 115 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (n < 2)
															#line 690 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		{
															#line 116 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			all.emplace_back(hydrogen(&h_ready_trigger));
															#line 117 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h_threads++;
															#line 696 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		}
		else
		{
															#line 119 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			ASSERT(n < 3);
															#line 120 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			all.emplace_back(oxygen(&h_ready_trigger));
															#line 121 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			o_threads++;
															#line 706 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		}
															#line 128 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (h_threads + o_threads >= 1000)
															#line 710 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			for(;2 * o_threads < h_threads;) {
															#line 130 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				all.emplace_back(oxygen(&h_ready_trigger));
															#line 131 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				o_threads++;
															#line 718 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			}
															#line 133 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			for(;h_threads < 2 * o_threads;) {
															#line 134 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				all.emplace_back(hydrogen(&h_ready_trigger));
															#line 135 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				h_threads++;
															#line 726 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			}
															#line 137 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			if (h_threads != 2 * o_threads)
															#line 730 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			{
															#line 138 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				std::cout << format("WEIRDNESS: h_threads [%d] != 2*o_threads [%d]\n", h_threads, o_threads);
															#line 139 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				ASSERT(false);
															#line 736 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			}
															#line 142 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			std::cout << format( "orchestrate: blocking with %d H threads, %d O threads; %d bigloops\n", h_threads, o_threads, bigloops);
															#line 150 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			h_ready_trigger.trigger();
															#line 151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(all);
															#line 151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			if (static_cast<OrchestrateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 746 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OrchestrateActor*>(this)->actor_wait_state = 1;
															#line 151 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OrchestrateActor, 0, Void >*>(static_cast<OrchestrateActor*>(this)));
															#line 751 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (wakeup.size() != 0)
															#line 784 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			std::cout << format("WEIRDNESS: wakeup.size() != 0 [%d]\n", wakeup.size());
															#line 156 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			for(auto it = wakeup.begin();it != wakeup.end();it++) {
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				std::cout << format("  %d -> %p\n", it->first, it->second);
															#line 792 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			}
		}
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		all.clear();
															#line 164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		total_h_threads += h_threads;
															#line 165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		total_o_threads += o_threads;
															#line 166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		h_threads = 0;
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		o_threads = 0;
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		bigloops++;
															#line 807 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		if (wakeup.size() != 0)
															#line 816 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			std::cout << format("WEIRDNESS: wakeup.size() != 0 [%d]\n", wakeup.size());
															#line 156 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
			for(auto it = wakeup.begin();it != wakeup.end();it++) {
															#line 157 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
				std::cout << format("  %d -> %p\n", it->first, it->second);
															#line 824 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
			}
		}
															#line 163 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		all.clear();
															#line 164 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		total_h_threads += h_threads;
															#line 165 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		total_o_threads += o_threads;
															#line 166 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		h_threads = 0;
															#line 167 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		o_threads = 0;
															#line 169 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
		bigloops++;
															#line 839 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OrchestrateActor*>(this)->actor_wait_state > 0) static_cast<OrchestrateActor*>(this)->actor_wait_state = 0;
		static_cast<OrchestrateActor*>(this)->ActorCallback< OrchestrateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrchestrateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OrchestrateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OrchestrateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 103 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int h_threads;
															#line 104 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int o_threads;
															#line 105 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int total_h_threads;
															#line 106 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int total_o_threads;
															#line 107 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	int bigloops;
															#line 108 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	std::vector<Future<Void>> all;
															#line 109 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	AsyncTrigger h_ready_trigger;
															#line 933 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
};
// This generated class is to be used only via orchestrate()
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
class OrchestrateActor final : public Actor<Void>, public ActorCallback< OrchestrateActor, 0, Void >, public FastAllocated<OrchestrateActor>, public OrchestrateActorState<OrchestrateActor> {
															#line 938 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
public:
	using FastAllocated<OrchestrateActor>::operator new;
	using FastAllocated<OrchestrateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11675207414461774848UL, 5153488881529069568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OrchestrateActor, 0, Void >;
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	OrchestrateActor() 
															#line 955 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
		 : Actor<Void>(),
		   OrchestrateActorState<OrchestrateActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("orchestrate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5914937709223385600UL, 2065269787122121216UL);
		ActorExecutionContextHelper __helper(static_cast<OrchestrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("orchestrate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("orchestrate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OrchestrateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
[[nodiscard]] Future<Void> orchestrate(  ) {
															#line 102 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"
	return Future<Void>(new OrchestrateActor());
															#line 988 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/build_output/documentation/tutorial/make_h2o.actor.g.cpp"
}

#line 175 "/codebuild/output/src1051786411/src/github.com/apple/foundationdb/documentation/tutorial/make_h2o.actor.cpp"

int main(int argc, char** argv) {
	// Cargo-culted from tutorial.actor.cpp.
	platformInit();
	g_network = newNet2(TLSConfig(), false, true);

	std::vector<Future<Void>> all;

	all.emplace_back(orchestrate());

	auto f = stopAfter(waitForAll(all));
	g_network->run();

	return 0;
}
