#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
/*
 * TxnTimeout.actor.cpp
 *
 * This workload validates that FoundationDB's transaction timeout mechanisms work correctly
 * by creating long-running transactions that intentionally approach (but don't exceed) the
 * configured transaction lifetime limits.
 *
 * Test Strategy:
 * 1. Configures transaction lifetime via MAX_READ/WRITE_TRANSACTION_LIFE_VERSIONS knobs
 * 2. Creates transactions that perform read-modify-write operations with artificial delays
 * 3. Ensures transactions complete successfully when staying within timeout bounds
 * 4. Detects and reports any errors
 *
 * The workload runs with failure injection disabled to ensure consistent timeout behavior
 * and verify that the timeout enforcement is working as designed without interference from
 * other failure modes.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbrpc/PerfMetric.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Buggify.h"
#include "flow/Error.h"
#include "flow/Optional.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct TxnTimeout : TestWorkload {
	static constexpr auto NAME = "TxnTimeout";

	// Configuration parameters
	double testDuration{ 0.0 }; // Total duration of the test in seconds
	int actorsPerClient{ 0 }; // Number of concurrent transaction actors per test client
	int nodeCountPerClientPerActor{ 0 }; // Number of unique keys each actor operates on
	double txnMinDuration{ 0.0 }; // Target minimum duration for each transaction (seconds)

	// Metrics tracked during test execution
	int txnsTotal{ 0 }; // Total number of transactions attempted
	int txnsSucceeded{ 0 }; // Number of transactions that completed successfully
	int txnsFailed{ 0 }; // Number of transactions that failed with unexpected errors

	TxnTimeout(const WorkloadContext& wctx) : TestWorkload(wctx) {
		// Parse workload configuration from TOML test definition
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		actorsPerClient = getOption(options, "actorsPerClient"_sr, 1);
		nodeCountPerClientPerActor = getOption(options, "nodeCountPerClientPerActor"_sr, 100);
		txnMinDuration = getOption(options, "txnMinDuration"_sr, 5.0);
	}

	Future<Void> setup(const Database& db) override {
		TraceEvent("TxnTimeoutSetup")
		    .detail("TestDuration", testDuration)
		    .detail("ActorsPerClient", actorsPerClient)
		    .detail("NodeCountPerClientPerActor", nodeCountPerClientPerActor)
		    .detail("TxnMinDuration", txnMinDuration)
		    .detail("MaxReadTxnLifeVersions", SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS)
		    .detail("MaxWriteTxnLifeVersions", SERVER_KNOBS->MAX_WRITE_TRANSACTION_LIFE_VERSIONS);
		return Void();
	}

	static bool runTest() { return g_network->isSimulated() && !isGeneralBuggifyEnabled(); }

	Future<Void> start(const Database& db) override {
		if (!runTest()) {
			return Void();
		}

		return timeout(reportErrors(workload(this, db), "TxnTimeoutError"), testDuration, Void());
	}

	Future<bool> check(const Database& db) override {
		if (!runTest()) {
			return true;
		}

		// Test succeeds if all transactions completed without unexpected timeout failures
		if (txnsFailed > 0 || txnsSucceeded == 0 || txnsSucceeded != txnsTotal) {
			TraceEvent(SevError, "TxnTimeoutCheckFailure")
			    .detail("TxnsSucceeded", txnsSucceeded)
			    .detail("TxnsFailed", txnsFailed)
			    .detail("TxnsTotal", txnsTotal)
			    .detail("Reason",
			            txnsFailed > 0 ? "UnexpectedTimeoutErrors"
			                           : (txnsSucceeded == 0 ? "NoSuccessfulTransactions" : "CountMismatch"));
			return false;
		}

		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Disable all failure injection to ensure clean timeout behavior testing
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("all"); }

	// Generates a consistent key format for the workload
	// Format: "txntimeout_c{clientId}_a{actorIdx}_n{nodeIdx}"
	// This ensures the same key is used during populate and transaction phases
	static Key makeKey(int clientId, int actorIdx, int nodeIdx) {
		return Key(format("txntimeout_c%d_a%d_n%d", clientId, actorIdx, nodeIdx));
	}

	// Initializes the database with test data for each actor to operate on
	// Each actor creates nodeCountPerClientPerActor keys initialized to value "0"
	// Keys are batched into transactions for efficiency
																#line 113 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
// This generated class is to be used only via populateDatabase()
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
template <class PopulateDatabaseActor>
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
class PopulateDatabaseActorState {
															#line 119 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
public:
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	PopulateDatabaseActorState(TxnTimeout* const& self,Database const& db,int const& actorIdx) 
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		 : self(self),
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   db(db),
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   actorIdx(actorIdx),
															#line 112 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   nodeIdx(0),
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   batchSize(std::max(1, self->nodeCountPerClientPerActor / 4))
															#line 134 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("populateDatabase", reinterpret_cast<unsigned long>(this));

	}
	~PopulateDatabaseActorState() 
	{
		fdb_probe_actor_destroy("populateDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			;
															#line 149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopulateDatabaseActorState();
		static_cast<PopulateDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 135 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		TraceEvent("TxnTimeoutPopulateComplete") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("KeysCreated", nodeIdx);
															#line 139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!static_cast<PopulateDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PopulateDatabaseActorState(); static_cast<PopulateDatabaseActor*>(this)->destroy(); return 0; }
															#line 174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		new (&static_cast<PopulateDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PopulateDatabaseActorState();
		static_cast<PopulateDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!(nodeIdx < self->nodeCountPerClientPerActor))
															#line 193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		tr = Transaction(db);
															#line 118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		;
															#line 201 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 121 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			batchEnd = std::min(nodeIdx + batchSize, self->nodeCountPerClientPerActor);
															#line 122 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			for(int i = nodeIdx;i < batchEnd;i++) {
															#line 123 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
				Key key = makeKey(self->clientId, actorIdx, i);
															#line 124 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
				tr.set(key, "0"_sr);
															#line 243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			}
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			if (static_cast<PopulateDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PopulateDatabaseActor*>(this)->actor_wait_state = 1;
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopulateDatabaseActor, 0, Void >*>(static_cast<PopulateDatabaseActor*>(this)));
															#line 254 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 130 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 130 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			if (static_cast<PopulateDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 291 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PopulateDatabaseActor*>(this)->actor_wait_state = 2;
															#line 130 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PopulateDatabaseActor, 1, Void >*>(static_cast<PopulateDatabaseActor*>(this)));
															#line 296 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		nodeIdx = batchEnd;
															#line 311 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 127 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		nodeIdx = batchEnd;
															#line 320 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopulateDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PopulateDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PopulateDatabaseActor*>(this)->ActorCallback< PopulateDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PopulateDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("populateDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopulateDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("populateDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopulateDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("populateDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PopulateDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PopulateDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PopulateDatabaseActor*>(this)->ActorCallback< PopulateDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PopulateDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("populateDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PopulateDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("populateDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PopulateDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("populateDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	TxnTimeout* self;
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Database db;
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	int actorIdx;
															#line 112 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	int nodeIdx;
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	int batchSize;
															#line 117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Transaction tr;
															#line 121 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	int batchEnd;
															#line 501 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
};
// This generated class is to be used only via populateDatabase()
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
class PopulateDatabaseActor final : public Actor<Void>, public ActorCallback< PopulateDatabaseActor, 0, Void >, public ActorCallback< PopulateDatabaseActor, 1, Void >, public FastAllocated<PopulateDatabaseActor>, public PopulateDatabaseActorState<PopulateDatabaseActor> {
															#line 506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
public:
	using FastAllocated<PopulateDatabaseActor>::operator new;
	using FastAllocated<PopulateDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11594469699184720896UL, 2250702972233216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopulateDatabaseActor, 0, Void >;
friend struct ActorCallback< PopulateDatabaseActor, 1, Void >;
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	PopulateDatabaseActor(TxnTimeout* const& self,Database const& db,int const& actorIdx) 
															#line 524 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PopulateDatabaseActorState<PopulateDatabaseActor>(self, db, actorIdx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("populateDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(444182410633863168UL, 10799654820167345920UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("populateDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("populateDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopulateDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PopulateDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
[[nodiscard]] static Future<Void> populateDatabase( TxnTimeout* const& self, Database const& db, int const& actorIdx ) {
															#line 111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	return Future<Void>(new PopulateDatabaseActor(self, db, actorIdx));
															#line 557 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
}

#line 141 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"

	// Runs database population concurrently across actors and clients
																#line 563 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
// This generated class is to be used only via populateDatabaseAllActors()
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
template <class PopulateDatabaseAllActorsActor>
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
class PopulateDatabaseAllActorsActorState {
															#line 569 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
public:
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	PopulateDatabaseAllActorsActorState(TxnTimeout* const& self,Database const& db) 
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		 : self(self),
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   db(db),
															#line 144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   populationActors()
															#line 580 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this));

	}
	~PopulateDatabaseAllActorsActorState() 
	{
		fdb_probe_actor_destroy("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			for(int actorIdx = 0;actorIdx < self->actorsPerClient;++actorIdx) {
															#line 146 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
				populationActors.push_back(populateDatabase(self, db, actorIdx));
															#line 597 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			}
															#line 148 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(populationActors);
															#line 148 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			if (static_cast<PopulateDatabaseAllActorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 603 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PopulateDatabaseAllActorsActor*>(this)->actor_wait_state = 1;
															#line 148 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopulateDatabaseAllActorsActor, 0, Void >*>(static_cast<PopulateDatabaseAllActorsActor*>(this)));
															#line 608 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopulateDatabaseAllActorsActorState();
		static_cast<PopulateDatabaseAllActorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		TraceEvent("TxnTimeoutPopulateAllComplete").detail("ClientId", self->clientId);
															#line 150 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!static_cast<PopulateDatabaseAllActorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PopulateDatabaseAllActorsActorState(); static_cast<PopulateDatabaseAllActorsActor*>(this)->destroy(); return 0; }
															#line 633 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		new (&static_cast<PopulateDatabaseAllActorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PopulateDatabaseAllActorsActorState();
		static_cast<PopulateDatabaseAllActorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		TraceEvent("TxnTimeoutPopulateAllComplete").detail("ClientId", self->clientId);
															#line 150 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!static_cast<PopulateDatabaseAllActorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PopulateDatabaseAllActorsActorState(); static_cast<PopulateDatabaseAllActorsActor*>(this)->destroy(); return 0; }
															#line 647 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		new (&static_cast<PopulateDatabaseAllActorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PopulateDatabaseAllActorsActorState();
		static_cast<PopulateDatabaseAllActorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopulateDatabaseAllActorsActor*>(this)->actor_wait_state > 0) static_cast<PopulateDatabaseAllActorsActor*>(this)->actor_wait_state = 0;
		static_cast<PopulateDatabaseAllActorsActor*>(this)->ActorCallback< PopulateDatabaseAllActorsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PopulateDatabaseAllActorsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseAllActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopulateDatabaseAllActorsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseAllActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopulateDatabaseAllActorsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseAllActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	TxnTimeout* self;
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Database db;
															#line 144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	std::vector<Future<Void>> populationActors;
															#line 736 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
};
// This generated class is to be used only via populateDatabaseAllActors()
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
class PopulateDatabaseAllActorsActor final : public Actor<Void>, public ActorCallback< PopulateDatabaseAllActorsActor, 0, Void >, public FastAllocated<PopulateDatabaseAllActorsActor>, public PopulateDatabaseAllActorsActorState<PopulateDatabaseAllActorsActor> {
															#line 741 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
public:
	using FastAllocated<PopulateDatabaseAllActorsActor>::operator new;
	using FastAllocated<PopulateDatabaseAllActorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12229803970000346624UL, 17080023080665750528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopulateDatabaseAllActorsActor, 0, Void >;
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	PopulateDatabaseAllActorsActor(TxnTimeout* const& self,Database const& db) 
															#line 758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PopulateDatabaseAllActorsActorState<PopulateDatabaseAllActorsActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16501897479561260288UL, 16215633646590767104UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDatabaseAllActorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("populateDatabaseAllActors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("populateDatabaseAllActors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopulateDatabaseAllActorsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
[[nodiscard]] static Future<Void> populateDatabaseAllActors( TxnTimeout* const& self, Database const& db ) {
															#line 143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	return Future<Void>(new PopulateDatabaseAllActorsActor(self, db));
															#line 790 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
}

#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"

	/*
	 * Transaction client actor that performs read-modify-write operations with intentional delays.
	 *
	 * Each transaction:
	 * 1. Gets a read version and reads a value from the database
	 * 2. Waits until txnMinDuration seconds have elapsed (artificially extending the transaction)
	 * 3. Writes an incremented value back
	 * 4. Commits the transaction
	 *
	 * The goal is to test that transactions can stay open for txnMinDuration seconds
	 * without hitting transaction_too_old errors, as long as that duration is within
	 * the configured MAX_*_TRANSACTION_LIFE_VERSIONS bounds.
	 *
	 * Error Handling:
	 * - Expected errors during recovery (future_version, commit_unknown_result, process_behind) are tolerated
	 * - Version jumps due to recovery (>MAX_WRITE_TRANSACTION_LIFE_VERSIONS) are tolerated
	 * - Any other transaction_too_old or similar timeout errors are counted as failures
	 */
																#line 813 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
// This generated class is to be used only via txnClient()
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
template <class TxnClientActor>
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
class TxnClientActorState {
															#line 819 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
public:
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	TxnClientActorState(TxnTimeout* const& self,Database const& db,int const& actorIdx) 
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		 : self(self),
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   db(db),
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   actorIdx(actorIdx),
															#line 172 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   nodeIdx(0),
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   workloadStartTime(now()),
															#line 176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   runDuration(self->testDuration * 0.8)
															#line 836 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("txnClient", reinterpret_cast<unsigned long>(this));

	}
	~TxnClientActorState() 
	{
		fdb_probe_actor_destroy("txnClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			;
															#line 851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TxnClientActorState();
		static_cast<TxnClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 290 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!static_cast<TxnClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TxnClientActorState(); static_cast<TxnClientActor*>(this)->destroy(); return 0; }
															#line 874 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		new (&static_cast<TxnClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TxnClientActorState();
		static_cast<TxnClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (nodeIdx == self->nodeCountPerClientPerActor)
															#line 893 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		{
															#line 181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			nodeIdx = 0;
															#line 897 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		}
															#line 185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (now() - workloadStartTime > runDuration)
															#line 901 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		{
															#line 186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			TraceEvent("TxnTimeoutClientComplete") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("Duration", now() - workloadStartTime);
															#line 905 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		tr = Transaction(db);
															#line 194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		readVersion = 0;
															#line 195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		txnStartTime = now();
															#line 196 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		self->txnsTotal++;
															#line 198 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		;
															#line 918 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 201 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			key = makeKey(self->clientId, actorIdx, nodeIdx);
															#line 204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			readStartTime = now();
															#line 205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			if (static_cast<TxnClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TxnClientActor*>(this)->actor_wait_state = 1;
															#line 205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TxnClientActor, 0, Version >*>(static_cast<TxnClientActor*>(this)));
															#line 965 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 239 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			err = e;
															#line 240 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			isExpectedError = err.code() == error_code_future_version || err.code() == error_code_commit_unknown_result || err.code() == error_code_process_behind;
															#line 244 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			TraceEvent(isExpectedError ? SevInfo : SevWarn, "TxnTimeoutTxnError") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("RecoveryState", self->dbInfo->get().recoveryState) .detail("ReadVersion", readVersion) .errorUnsuppressed(err);
															#line 251 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(err);
															#line 251 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			if (static_cast<TxnClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<TxnClientActor*>(this)->actor_wait_state = 5;
															#line 251 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TxnClientActor, 4, Void >*>(static_cast<TxnClientActor*>(this)));
															#line 1013 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Version const& rv,int loopDepth) 
	{
															#line 206 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		readVersion = rv;
															#line 208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(key);
															#line 208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (static_cast<TxnClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1032 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TxnClientActor*>(this)->actor_wait_state = 2;
															#line 208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TxnClientActor, 1, Optional<Value> >*>(static_cast<TxnClientActor*>(this)));
															#line 1037 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Version && rv,int loopDepth) 
	{
															#line 206 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		readVersion = rv;
															#line 208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(key);
															#line 208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (static_cast<TxnClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1050 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TxnClientActor*>(this)->actor_wait_state = 2;
															#line 208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TxnClientActor, 1, Optional<Value> >*>(static_cast<TxnClientActor*>(this)));
															#line 1055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TxnClientActor*>(this)->actor_wait_state > 0) static_cast<TxnClientActor*>(this)->actor_wait_state = 0;
		static_cast<TxnClientActor*>(this)->ActorCallback< TxnClientActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TxnClientActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		readDuration = now() - readStartTime;
															#line 213 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (self->txnMinDuration > readDuration)
															#line 1141 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		{
															#line 214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(self->txnMinDuration - readDuration);
															#line 214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			if (static_cast<TxnClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1147 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<TxnClientActor*>(this)->actor_wait_state = 3;
															#line 214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TxnClientActor, 2, Void >*>(static_cast<TxnClientActor*>(this)));
															#line 1152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Optional<Value> const& __val,int loopDepth) 
	{
															#line 208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		val = __val;
															#line 1166 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Optional<Value> && __val,int loopDepth) 
	{
		val = std::move(__val);
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TxnClientActor*>(this)->actor_wait_state > 0) static_cast<TxnClientActor*>(this)->actor_wait_state = 0;
		static_cast<TxnClientActor*>(this)->ActorCallback< TxnClientActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TxnClientActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		currentVal = std::stoi(val.get().toString());
															#line 219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		newVal = std::to_string(currentVal + 1);
															#line 220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		tr.set(key, StringRef(newVal));
															#line 223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (static_cast<TxnClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<TxnClientActor*>(this)->actor_wait_state = 4;
															#line 223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TxnClientActor, 3, Void >*>(static_cast<TxnClientActor*>(this)));
															#line 1258 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TxnClientActor*>(this)->actor_wait_state > 0) static_cast<TxnClientActor*>(this)->actor_wait_state = 0;
		static_cast<TxnClientActor*>(this)->ActorCallback< TxnClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TxnClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		txnLatency = now() - txnStartTime;
															#line 226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		self->txnsSucceeded++;
															#line 227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		TraceEvent("TxnTimeoutTxnSuccess") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("Key", key) .detail("OldValue", currentVal) .detail("TxnLatency", txnLatency) .detail("ReadVersion", readVersion);
															#line 235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		nodeIdx++;
															#line 1360 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		txnLatency = now() - txnStartTime;
															#line 226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		self->txnsSucceeded++;
															#line 227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		TraceEvent("TxnTimeoutTxnSuccess") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("Key", key) .detail("OldValue", currentVal) .detail("TxnLatency", txnLatency) .detail("ReadVersion", readVersion);
															#line 235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		nodeIdx++;
															#line 1375 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TxnClientActor*>(this)->actor_wait_state > 0) static_cast<TxnClientActor*>(this)->actor_wait_state = 0;
		static_cast<TxnClientActor*>(this)->ActorCallback< TxnClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TxnClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 254 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		rvTr = Transaction(db);
															#line 255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		StrictFuture<Version> __when_expr_5 = rvTr.getReadVersion();
															#line 255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (static_cast<TxnClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<TxnClientActor*>(this)->actor_wait_state = 6;
															#line 255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TxnClientActor, 5, Version >*>(static_cast<TxnClientActor*>(this)));
															#line 1468 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 254 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		rvTr = Transaction(db);
															#line 255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		StrictFuture<Version> __when_expr_5 = rvTr.getReadVersion();
															#line 255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (static_cast<TxnClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1481 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<TxnClientActor*>(this)->actor_wait_state = 6;
															#line 255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TxnClientActor, 5, Version >*>(static_cast<TxnClientActor*>(this)));
															#line 1486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TxnClientActor*>(this)->actor_wait_state > 0) static_cast<TxnClientActor*>(this)->actor_wait_state = 0;
		static_cast<TxnClientActor*>(this)->ActorCallback< TxnClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TxnClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1loopBody1Catch1cont2(Version const& newReadVersion,int loopDepth) 
	{
															#line 258 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		Version versionDelta = newReadVersion - readVersion;
															#line 259 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		const bool isHighVersionJump = versionDelta > SERVER_KNOBS->MAX_WRITE_TRANSACTION_LIFE_VERSIONS;
															#line 260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		const double txnDuration = now() - txnStartTime;
															#line 261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		const bool tooMuchTimeHasPassed = txnDuration > ((double)SERVER_KNOBS->MAX_WRITE_TRANSACTION_LIFE_VERSIONS / SERVER_KNOBS->VERSIONS_PER_SECOND);
															#line 265 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!isExpectedError && !isHighVersionJump && !tooMuchTimeHasPassed)
															#line 1578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		{
															#line 266 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			self->txnsFailed++;
															#line 267 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			TraceEvent(SevError, "TxnTimeoutUnexpectedFailure") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("OldReadVersion", readVersion) .detail("NewReadVersion", newReadVersion) .detail("VersionDelta", versionDelta) .detail("TxnDuration", txnDuration) .errorUnsuppressed(err);
															#line 1584 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		}
		else
		{
															#line 276 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			TraceEvent("TxnTimeoutExpectedFailure") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("OldReadVersion", readVersion) .detail("NewReadVersion", newReadVersion) .detail("VersionDelta", versionDelta) .detail("IsExpectedError", isExpectedError) .detail("IsHighVersionJump", isHighVersionJump);
															#line 1590 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		}
															#line 286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		txnStartTime = now();
															#line 1594 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont2(Version && newReadVersion,int loopDepth) 
	{
															#line 258 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		Version versionDelta = newReadVersion - readVersion;
															#line 259 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		const bool isHighVersionJump = versionDelta > SERVER_KNOBS->MAX_WRITE_TRANSACTION_LIFE_VERSIONS;
															#line 260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		const double txnDuration = now() - txnStartTime;
															#line 261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		const bool tooMuchTimeHasPassed = txnDuration > ((double)SERVER_KNOBS->MAX_WRITE_TRANSACTION_LIFE_VERSIONS / SERVER_KNOBS->VERSIONS_PER_SECOND);
															#line 265 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!isExpectedError && !isHighVersionJump && !tooMuchTimeHasPassed)
															#line 1611 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		{
															#line 266 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			self->txnsFailed++;
															#line 267 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			TraceEvent(SevError, "TxnTimeoutUnexpectedFailure") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("OldReadVersion", readVersion) .detail("NewReadVersion", newReadVersion) .detail("VersionDelta", versionDelta) .detail("TxnDuration", txnDuration) .errorUnsuppressed(err);
															#line 1617 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		}
		else
		{
															#line 276 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			TraceEvent("TxnTimeoutExpectedFailure") .detail("ClientId", self->clientId) .detail("ActorIdx", actorIdx) .detail("OldReadVersion", readVersion) .detail("NewReadVersion", newReadVersion) .detail("VersionDelta", versionDelta) .detail("IsExpectedError", isExpectedError) .detail("IsHighVersionJump", isHighVersionJump);
															#line 1623 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		}
															#line 286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		txnStartTime = now();
															#line 1627 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1when1(Version const& newReadVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont2(newReadVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1when1(Version && newReadVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont2(std::move(newReadVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TxnClientActor*>(this)->actor_wait_state > 0) static_cast<TxnClientActor*>(this)->actor_wait_state = 0;
		static_cast<TxnClientActor*>(this)->ActorCallback< TxnClientActor, 5, Version >::remove();

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 5, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TxnClientActor, 5, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TxnClientActor, 5, Version >*,Error err) 
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	TxnTimeout* self;
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Database db;
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	int actorIdx;
															#line 172 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	int nodeIdx;
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	double workloadStartTime;
															#line 176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	double runDuration;
															#line 193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Transaction tr;
															#line 194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Version readVersion;
															#line 195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	double txnStartTime;
															#line 201 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Key key;
															#line 204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	double readStartTime;
															#line 208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Optional<Value> val;
															#line 209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	double readDuration;
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	int currentVal;
															#line 219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	std::string newVal;
															#line 224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	double txnLatency;
															#line 239 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Error err;
															#line 240 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	bool isExpectedError;
															#line 254 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Transaction rvTr;
															#line 1745 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
};
// This generated class is to be used only via txnClient()
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
class TxnClientActor final : public Actor<Void>, public ActorCallback< TxnClientActor, 0, Version >, public ActorCallback< TxnClientActor, 1, Optional<Value> >, public ActorCallback< TxnClientActor, 2, Void >, public ActorCallback< TxnClientActor, 3, Void >, public ActorCallback< TxnClientActor, 4, Void >, public ActorCallback< TxnClientActor, 5, Version >, public FastAllocated<TxnClientActor>, public TxnClientActorState<TxnClientActor> {
															#line 1750 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
public:
	using FastAllocated<TxnClientActor>::operator new;
	using FastAllocated<TxnClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18271690189967188224UL, 14063068536852390400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TxnClientActor, 0, Version >;
friend struct ActorCallback< TxnClientActor, 1, Optional<Value> >;
friend struct ActorCallback< TxnClientActor, 2, Void >;
friend struct ActorCallback< TxnClientActor, 3, Void >;
friend struct ActorCallback< TxnClientActor, 4, Void >;
friend struct ActorCallback< TxnClientActor, 5, Version >;
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	TxnClientActor(TxnTimeout* const& self,Database const& db,int const& actorIdx) 
															#line 1772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TxnClientActorState<TxnClientActor>(self, db, actorIdx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("txnClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7351956705660406528UL, 13357215966502415360UL);
		ActorExecutionContextHelper __helper(static_cast<TxnClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("txnClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("txnClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TxnClientActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TxnClientActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TxnClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TxnClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TxnClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TxnClientActor, 5, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
[[nodiscard]] static Future<Void> txnClient( TxnTimeout* const& self, Database const& db, int const& actorIdx ) {
															#line 171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	return Future<Void>(new TxnClientActor(self, db, actorIdx));
															#line 1809 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
}

#line 292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"

	/*
	 * Main workload orchestration.
	 *
	 * Phase 1: Populate the database with initial test data
	 * Phase 2: Run concurrent transaction clients that test timeout behavior
	 * Phase 3: Report final metrics
	 */
																#line 1821 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
// This generated class is to be used only via workload()
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
template <class WorkloadActor>
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
class WorkloadActorState {
															#line 1827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
public:
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	WorkloadActorState(TxnTimeout* const& self,Database const& db) 
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		 : self(self),
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		   db(db)
															#line 1836 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("workload", reinterpret_cast<unsigned long>(this));

	}
	~WorkloadActorState() 
	{
		fdb_probe_actor_destroy("workload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 301 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			TraceEvent("TxnTimeoutWorkloadStart") .detail("ClientId", self->clientId) .detail("TestDuration", self->testDuration) .detail("ActorsPerClient", self->actorsPerClient);
															#line 307 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			StrictFuture<Void> __when_expr_0 = populateDatabaseAllActors(self, db);
															#line 307 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			if (static_cast<WorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1855 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkloadActor*>(this)->actor_wait_state = 1;
															#line 307 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkloadActor, 0, Void >*>(static_cast<WorkloadActor*>(this)));
															#line 1860 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkloadActorState();
		static_cast<WorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 310 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		txnClients = std::vector<Future<Void>>();
															#line 311 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		for(int actorIdx = 0;actorIdx < self->actorsPerClient;++actorIdx) {
															#line 312 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			txnClients.emplace_back(txnClient(self, db, actorIdx));
															#line 1887 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		}
															#line 314 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(txnClients);
															#line 314 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (static_cast<WorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1893 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadActor*>(this)->actor_wait_state = 2;
															#line 314 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadActor, 1, Void >*>(static_cast<WorkloadActor*>(this)));
															#line 1898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 310 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		txnClients = std::vector<Future<Void>>();
															#line 311 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		for(int actorIdx = 0;actorIdx < self->actorsPerClient;++actorIdx) {
															#line 312 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
			txnClients.emplace_back(txnClient(self, db, actorIdx));
															#line 1911 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		}
															#line 314 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(txnClients);
															#line 314 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (static_cast<WorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1917 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WorkloadActor*>(this)->actor_wait_state = 2;
															#line 314 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkloadActor, 1, Void >*>(static_cast<WorkloadActor*>(this)));
															#line 1922 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkloadActor*>(this)->actor_wait_state > 0) static_cast<WorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadActor*>(this)->ActorCallback< WorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		TraceEvent("TxnTimeoutWorkloadComplete") .detail("ClientId", self->clientId) .detail("TxnsSucceeded", self->txnsSucceeded) .detail("TxnsFailed", self->txnsFailed) .detail("TxnsTotal", self->txnsTotal) .detail("SuccessRate", self->txnsTotal > 0 ? (double)self->txnsSucceeded / self->txnsTotal : 0.0);
															#line 324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!static_cast<WorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkloadActorState(); static_cast<WorkloadActor*>(this)->destroy(); return 0; }
															#line 2008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		new (&static_cast<WorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkloadActorState();
		static_cast<WorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		TraceEvent("TxnTimeoutWorkloadComplete") .detail("ClientId", self->clientId) .detail("TxnsSucceeded", self->txnsSucceeded) .detail("TxnsFailed", self->txnsFailed) .detail("TxnsTotal", self->txnsTotal) .detail("SuccessRate", self->txnsTotal > 0 ? (double)self->txnsSucceeded / self->txnsTotal : 0.0);
															#line 324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
		if (!static_cast<WorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkloadActorState(); static_cast<WorkloadActor*>(this)->destroy(); return 0; }
															#line 2022 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		new (&static_cast<WorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkloadActorState();
		static_cast<WorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkloadActor*>(this)->actor_wait_state > 0) static_cast<WorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<WorkloadActor*>(this)->ActorCallback< WorkloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	TxnTimeout* self;
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	Database db;
															#line 310 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	std::vector<Future<Void>> txnClients;
															#line 2111 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
};
// This generated class is to be used only via workload()
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
class WorkloadActor final : public Actor<Void>, public ActorCallback< WorkloadActor, 0, Void >, public ActorCallback< WorkloadActor, 1, Void >, public FastAllocated<WorkloadActor>, public WorkloadActorState<WorkloadActor> {
															#line 2116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
public:
	using FastAllocated<WorkloadActor>::operator new;
	using FastAllocated<WorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2414290785412092416UL, 12540768969043311360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkloadActor, 0, Void >;
friend struct ActorCallback< WorkloadActor, 1, Void >;
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	WorkloadActor(TxnTimeout* const& self,Database const& db) 
															#line 2134 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WorkloadActorState<WorkloadActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6662893632963641600UL, 18424590834130018048UL);
		ActorExecutionContextHelper __helper(static_cast<WorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkloadActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
[[nodiscard]] Future<Void> workload( TxnTimeout* const& self, Database const& db ) {
															#line 300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
	return Future<Void>(new WorkloadActor(self, db));
															#line 2167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TxnTimeout.actor.g.cpp.py_gen"
}

#line 326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/TxnTimeout.actor.cpp"
};

WorkloadFactory<TxnTimeout> TxnTimeoutWorkloadFactory;
