#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
/*
 * MockDDTrackerShardEvaluator.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/MockDDTest.h"
#include "flow/actorcompiler.h" // This must be the last #include.

class MockDDTrackerShardEvaluatorWorkload : public MockDDTestWorkload {
public:
	static constexpr auto NAME = "MockDDTrackerShardEvaluator";
	DDSharedContext ddcx;
	Reference<DDMockTxnProcessor> mock;

	PromiseStream<RelocateShard> output;
	PromiseStream<GetMetricsRequest> getShardMetrics;
	PromiseStream<GetTopKMetricsRequest> getTopKMetrics;
	PromiseStream<GetMetricsListRequest> getShardMetricsList;
	PromiseStream<Promise<int64_t>> getAverageShardBytes;
	PromiseStream<RebalanceStorageQueueRequest> triggerStorageQueueRebalance;
	PromiseStream<BulkLoadShardRequest> triggerShardBulkLoading;

	KeyRangeMap<ShardTrackedData> shards;

	ActorCollection actors;

	std::map<RelocateReason, int> rsReasonCounts;

	Reference<DataDistributionTracker> shardTracker;

	// --- test configs ---

	// check threshold
	int checkMinShardCount = 1;
	int checkMinSizeSplit = 0;
	int checkMinWriteSplit = 0;

	MockDDTrackerShardEvaluatorWorkload(WorkloadContext const& wcx)
	  : MockDDTestWorkload(wcx), ddcx(deterministicRandom()->randomUniqueID()) {
		checkMinShardCount = getOption(options, "checkMinShardCount"_sr, checkMinShardCount);
		checkMinSizeSplit = getOption(options, "checkMinSizeSplit"_sr, checkMinSizeSplit);
		checkMinWriteSplit = getOption(options, "checkMinWriteSplit"_sr, checkMinWriteSplit);
	}

	Future<Void> setup(Database const& cx) override {
		if (!enabled)
			return Void();
		MockDDTestWorkload::setup(cx);
		// populate sharedMgs before run tracker
		populateMgs();
		mock = makeReference<DDMockTxnProcessor>(sharedMgs);
		return Void();
	}

																#line 72 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
// This generated class is to be used only via relocateShardReporter()
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
template <class RelocateShardReporterActor>
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
class RelocateShardReporterActorState {
															#line 78 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
public:
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
	RelocateShardReporterActorState(MockDDTrackerShardEvaluatorWorkload* const& self,FutureStream<RelocateShard> const& input) 
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
		 : self(self),
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
		   input(input)
															#line 87 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("relocateShardReporter", reinterpret_cast<unsigned long>(this));

	}
	~RelocateShardReporterActorState() 
	{
		fdb_probe_actor_destroy("relocateShardReporter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
			;
															#line 102 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RelocateShardReporterActorState();
		static_cast<RelocateShardReporterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 75 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
			auto __when_expr_0 = input;
															#line 133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<RelocateShard>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<RelocateShard>>::value, "invalid type");
															#line 74 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
			if (static_cast<RelocateShardReporterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 137 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<RelocateShardReporterActor*>(this)->actor_wait_state = 1;
															#line 75 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RelocateShardReporterActor, 0, RelocateShard >*>(static_cast<RelocateShardReporterActor*>(this)));
															#line 142 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
			if (e.code() != error_code_wrong_shard_server)
															#line 164 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
			{
															#line 81 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
			}
															#line 82 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(CLIENT_KNOBS->WRONG_SHARD_SERVER_DELAY);
															#line 82 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
			if (static_cast<RelocateShardReporterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RelocateShardReporterActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RelocateShardReporterActor, 1, Void >*>(static_cast<RelocateShardReporterActor*>(this)));
															#line 179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RelocateShard const& rs,int loopDepth) 
	{
															#line 76 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
		++self->rsReasonCounts[rs.reason];
															#line 200 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RelocateShard && rs,int loopDepth) 
	{
															#line 76 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
		++self->rsReasonCounts[rs.reason];
															#line 209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RelocateShardReporterActor*>(this)->actor_wait_state > 0) static_cast<RelocateShardReporterActor*>(this)->actor_wait_state = 0;
		static_cast<RelocateShardReporterActor*>(this)->ActorSingleCallback< RelocateShardReporterActor, 0, RelocateShard >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RelocateShardReporterActor, 0, RelocateShard >*,RelocateShard const& value) 
	{
		fdb_probe_actor_enter("relocateShardReporter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RelocateShardReporterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("relocateShardReporter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RelocateShardReporterActor, 0, RelocateShard >*,RelocateShard && value) 
	{
		fdb_probe_actor_enter("relocateShardReporter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RelocateShardReporterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("relocateShardReporter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RelocateShardReporterActor, 0, RelocateShard >*,Error err) 
	{
		fdb_probe_actor_enter("relocateShardReporter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RelocateShardReporterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("relocateShardReporter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RelocateShardReporterActor*>(this)->actor_wait_state > 0) static_cast<RelocateShardReporterActor*>(this)->actor_wait_state = 0;
		static_cast<RelocateShardReporterActor*>(this)->ActorCallback< RelocateShardReporterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RelocateShardReporterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("relocateShardReporter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RelocateShardReporterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("relocateShardReporter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RelocateShardReporterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("relocateShardReporter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RelocateShardReporterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("relocateShardReporter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RelocateShardReporterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("relocateShardReporter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RelocateShardReporterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("relocateShardReporter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
	MockDDTrackerShardEvaluatorWorkload* self;
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
	FutureStream<RelocateShard> input;
															#line 381 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
};
// This generated class is to be used only via relocateShardReporter()
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
class RelocateShardReporterActor final : public Actor<Void>, public ActorSingleCallback< RelocateShardReporterActor, 0, RelocateShard >, public ActorCallback< RelocateShardReporterActor, 1, Void >, public FastAllocated<RelocateShardReporterActor>, public RelocateShardReporterActorState<RelocateShardReporterActor> {
															#line 386 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
public:
	using FastAllocated<RelocateShardReporterActor>::operator new;
	using FastAllocated<RelocateShardReporterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(60233091060809728UL, 10880840576135574528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RelocateShardReporterActor, 0, RelocateShard >;
friend struct ActorCallback< RelocateShardReporterActor, 1, Void >;
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
	RelocateShardReporterActor(MockDDTrackerShardEvaluatorWorkload* const& self,FutureStream<RelocateShard> const& input) 
															#line 404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RelocateShardReporterActorState<RelocateShardReporterActor>(self, input),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("relocateShardReporter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5876387757417084416UL, 5911743547511264512UL);
		ActorExecutionContextHelper __helper(static_cast<RelocateShardReporterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("relocateShardReporter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("relocateShardReporter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RelocateShardReporterActor, 0, RelocateShard >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RelocateShardReporterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
[[nodiscard]] static Future<Void> relocateShardReporter( MockDDTrackerShardEvaluatorWorkload* const& self, FutureStream<RelocateShard> const& input ) {
															#line 70 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"
	return Future<Void>(new RelocateShardReporterActor(self, input));
															#line 437 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.g.cpp.py_gen"
}

#line 86 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/MockDDTrackerShardEvaluator.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (!enabled)
			return Void();

		// start mock servers
		actors.add(waitForAll(sharedMgs->runAllMockServers()));

		// start tracker
		Reference<InitialDataDistribution> initData =
		    mock->getInitialDataDistribution(ddcx.id(), ddcx.lock, {}, ddcx.ddEnabledState.get(), SkipDDModeCheck::True)
		        .get();
		Reference<PhysicalShardCollection> physicalShardCollection = makeReference<PhysicalShardCollection>();
		Reference<BulkLoadTaskCollection> bulkLoadTaskCollection = makeReference<BulkLoadTaskCollection>(ddcx.id());
		Reference<AsyncVar<bool>> zeroHealthyTeams = makeReference<AsyncVar<bool>>(false);

		shardTracker = makeReference<DataDistributionTracker>(
		    DataDistributionTrackerInitParams{ .db = mock,
		                                       .distributorId = ddcx.id(),
		                                       .readyToStart = Promise<Void>(),
		                                       .output = output,
		                                       .shardsAffectedByTeamFailure = ddcx.shardsAffectedByTeamFailure,
		                                       .physicalShardCollection = physicalShardCollection,
		                                       .bulkLoadTaskCollection = bulkLoadTaskCollection,
		                                       .anyZeroHealthyTeams = zeroHealthyTeams,
		                                       .shards = &shards,
		                                       .trackerCancelled = &ddcx.trackerCancelled,
		                                       .usableRegions = -1 });
		actors.add(DataDistributionTracker::run(shardTracker,
		                                        initData,
		                                        getShardMetrics.getFuture(),
		                                        getTopKMetrics.getFuture(),
		                                        getShardMetricsList.getFuture(),
		                                        getAverageShardBytes.getFuture(),
		                                        triggerStorageQueueRebalance.getFuture(),
		                                        triggerShardBulkLoading.getFuture()));

		actors.add(relocateShardReporter(this, output.getFuture()));

		return timeout(reportErrors(actors.getResult(), "MockDDTrackerShardEvaluatorWorkload"), testDuration, Void());
	}

	Future<bool> check(Database const& cx) override {
		if (!enabled)
			return true;

		fmt::print("Check phase shards count: {}\n", shards.size());
		ASSERT_GE(shards.size(), checkMinShardCount);
		for (auto& [r, c] : rsReasonCounts) {
			fmt::print("{}: {}\n", r.toString(), c);
		}
		ASSERT_GE(rsReasonCounts[RelocateReason::SIZE_SPLIT], checkMinSizeSplit);
		ASSERT_GE(rsReasonCounts[RelocateReason::WRITE_SPLIT], checkMinWriteSplit);

		actors.clear(true);
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		for (const auto& [reason, count] : rsReasonCounts) {
			m.push_back(PerfMetric(RelocateReason(reason).toString(), count, Averaged::False));
		}
	}
};

WorkloadFactory<MockDDTrackerShardEvaluatorWorkload> MockDDTrackerShardEvaluatorWorkload;
