#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
/*
 * DifferentClustersSameRV.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ApiVersion.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

void traceError(const char* filename, int line, Error const& e) {
	TraceEvent("DifferentClustersSameRVWorkload_Error").error(e).detail("File", filename).detail("Line", line);
}

#define TRACE_ERROR(e) traceError(__FILE__, __LINE__, e)

// A workload attempts to read from two different clusters with the same read version.
struct DifferentClustersSameRVWorkload : TestWorkload {
	static constexpr auto NAME = "DifferentClustersSameRV";
	Database originalDB;
	Database extraDB;
	double testDuration;
	double switchAfter;
	Value keyToRead;
	Value keyToWatch;
	bool switchComplete = false;

	DifferentClustersSameRVWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		ASSERT(g_simulator->extraDatabases.size() == 1);
		extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0]);
		testDuration = getOption(options, "testDuration"_sr, 100.0);
		switchAfter = getOption(options, "switchAfter"_sr, 50.0);
		keyToRead = getOption(options, "keyToRead"_sr, "someKey"_sr);
		keyToWatch = getOption(options, "keyToWatch"_sr, "anotherKey"_sr);
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId != 0) {
			return Void();
		}
		return _setup(cx, this);
	}

																#line 65 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
// This generated class is to be used only via _setup()
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
template <class _setupActor>
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class _setupActorState {
															#line 71 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	_setupActorState(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		 : cx(cx),
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   self(self),
															#line 64 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   rv1(),
															#line 65 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   rv2(),
															#line 66 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   newClusterVersion(),
															#line 67 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr1(cx),
															#line 68 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr2(self->extraDB)
															#line 90 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TraceEvent("DifferentClustersSameRVWorkload");
															#line 73 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			;
															#line 107 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 81 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		newClusterVersion = std::max(rv1, rv2) + 10e6;
															#line 82 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_2 = ::advanceVersion(cx, newClusterVersion) && ::advanceVersion(self->extraDB, newClusterVersion);
															#line 82 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 134 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 82 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 75 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(rv1, tr1.getReadVersion()) && store(rv2, tr2.getReadVersion());
															#line 75 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 158 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 75 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr1.onError(e) && tr2.onError(e);
															#line 78 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 200 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 78 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClustersSameRVWorkload_AdvancedVersion").detail("Version", newClusterVersion);
															#line 84 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClustersSameRVWorkload_AdvancedVersion").detail("Version", newClusterVersion);
															#line 84 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Database cx;
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DifferentClustersSameRVWorkload* self;
															#line 64 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version rv1;
															#line 65 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version rv2;
															#line 66 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version newClusterVersion;
															#line 67 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr1;
															#line 68 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr2;
															#line 507 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _setup()
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 512 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11153607104839634688UL, 2871756234698451200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, Void >;
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	_setupActor(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 531 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, DifferentClustersSameRVWorkload* const& self ) {
															#line 63 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 565 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
}

#line 86 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0) {
			return Void();
		}
		auto switchConnFileDb = Database::createDatabase(cx->getConnectionRecord(), -1);
		originalDB = cx;
		std::vector<Future<Void>> clients = { readerClientSeparateDBs(cx, this),
			                                  doSwitch(switchConnFileDb, this),
			                                  writerClient(cx, this),
			                                  writerClient(extraDB, this) };
		return success(timeout(waitForAll(clients), testDuration));
	}

	Future<bool> check(Database const& cx) override {
		if (clientId == 0 && !switchComplete) {
			TraceEvent(SevError, "DifferentClustersSwitchNotComplete").log();
			return false;
		}
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 593 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
// This generated class is to be used only via doRead()
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
template <class DoReadActor>
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class DoReadActorState {
															#line 599 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DoReadActorState(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		 : cx(cx),
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   self(self),
															#line 112 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr(cx)
															#line 610 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doRead", reinterpret_cast<unsigned long>(this));

	}
	~DoReadActorState() 
	{
		fdb_probe_actor_destroy("doRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			;
															#line 625 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoReadActorState();
		static_cast<DoReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 655 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		try {
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoReadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 661 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoReadActor*>(this)->actor_wait_state = 1;
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoReadActor, 0, Version >*>(static_cast<DoReadActor*>(this)));
															#line 666 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 120 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TRACE_ERROR(e);
															#line 121 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 121 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 692 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoReadActor*>(this)->actor_wait_state = 3;
															#line 121 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoReadActor, 2, Void >*>(static_cast<DoReadActor*>(this)));
															#line 697 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(self->keyToRead);
															#line 117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoReadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 714 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoReadActor*>(this)->actor_wait_state = 2;
															#line 117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoReadActor, 1, Optional<Value> >*>(static_cast<DoReadActor*>(this)));
															#line 719 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __rv,int loopDepth) 
	{
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		rv = __rv;
															#line 728 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __rv,int loopDepth) 
	{
		rv = std::move(__rv);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoReadActor*>(this)->actor_wait_state > 0) static_cast<DoReadActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadActor*>(this)->ActorCallback< DoReadActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoReadActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoReadActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& val1,int loopDepth) 
	{
															#line 118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<DoReadActor*>(this)->SAV<std::pair<Version, Optional<Value>>>::futures) { (void)(std::make_pair(rv, val1)); this->~DoReadActorState(); static_cast<DoReadActor*>(this)->destroy(); return 0; }
															#line 807 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<DoReadActor*>(this)->SAV< std::pair<Version, Optional<Value>> >::value()) std::pair<Version, Optional<Value>>(std::make_pair(rv, val1));
		this->~DoReadActorState();
		static_cast<DoReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && val1,int loopDepth) 
	{
															#line 118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<DoReadActor*>(this)->SAV<std::pair<Version, Optional<Value>>>::futures) { (void)(std::make_pair(rv, val1)); this->~DoReadActorState(); static_cast<DoReadActor*>(this)->destroy(); return 0; }
															#line 819 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<DoReadActor*>(this)->SAV< std::pair<Version, Optional<Value>> >::value()) std::pair<Version, Optional<Value>>(std::make_pair(rv, val1));
		this->~DoReadActorState();
		static_cast<DoReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& val1,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(val1, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && val1,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(val1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoReadActor*>(this)->actor_wait_state > 0) static_cast<DoReadActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadActor*>(this)->ActorCallback< DoReadActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoReadActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoReadActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoReadActor*>(this)->actor_wait_state > 0) static_cast<DoReadActor*>(this)->actor_wait_state = 0;
		static_cast<DoReadActor*>(this)->ActorCallback< DoReadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoReadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoReadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoReadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Database cx;
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DifferentClustersSameRVWorkload* self;
															#line 112 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr;
															#line 116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version rv;
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doRead()
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class DoReadActor final : public Actor<std::pair<Version, Optional<Value>>>, public ActorCallback< DoReadActor, 0, Version >, public ActorCallback< DoReadActor, 1, Optional<Value> >, public ActorCallback< DoReadActor, 2, Void >, public FastAllocated<DoReadActor>, public DoReadActorState<DoReadActor> {
															#line 1002 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoReadActor>::operator new;
	using FastAllocated<DoReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14652470945472591616UL, 10436285029132708352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Version, Optional<Value>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoReadActor, 0, Version >;
friend struct ActorCallback< DoReadActor, 1, Optional<Value> >;
friend struct ActorCallback< DoReadActor, 2, Void >;
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DoReadActor(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 1021 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		 : Actor<std::pair<Version, Optional<Value>>>(),
		   DoReadActorState<DoReadActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12313637287084170496UL, 16087923704333355776UL);
		ActorExecutionContextHelper __helper(static_cast<DoReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoReadActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoReadActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoReadActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
[[nodiscard]] static Future<std::pair<Version, Optional<Value>>> doRead( Database const& cx, DifferentClustersSameRVWorkload* const& self ) {
															#line 110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	return Future<std::pair<Version, Optional<Value>>>(new DoReadActor(cx, self));
															#line 1055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
}

#line 125 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"

																#line 1060 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
// This generated class is to be used only via doWrite()
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
template <class DoWriteActor>
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class DoWriteActorState {
															#line 1066 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DoWriteActorState(Database const& cx,Value const& key,Optional<Value> const& val) 
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		 : cx(cx),
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   key(key),
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   val(val),
															#line 127 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr(cx)
															#line 1079 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doWrite", reinterpret_cast<unsigned long>(this));

	}
	~DoWriteActorState() 
	{
		fdb_probe_actor_destroy("doWrite", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 128 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			;
															#line 1094 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoWriteActorState();
		static_cast<DoWriteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1124 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		try {
															#line 131 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (val.present())
															#line 1128 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			{
															#line 132 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
				tr.set(key, val.get());
															#line 1132 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			}
			else
			{
															#line 134 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
				tr.clear(key);
															#line 1138 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			}
															#line 136 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 136 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoWriteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoWriteActor*>(this)->actor_wait_state = 1;
															#line 136 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoWriteActor, 0, Void >*>(static_cast<DoWriteActor*>(this)));
															#line 1149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TRACE_ERROR(e);
															#line 140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoWriteActor*>(this)->actor_wait_state = 2;
															#line 140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoWriteActor, 1, Void >*>(static_cast<DoWriteActor*>(this)));
															#line 1180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 137 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<DoWriteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoWriteActorState(); static_cast<DoWriteActor*>(this)->destroy(); return 0; }
															#line 1195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<DoWriteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoWriteActorState();
		static_cast<DoWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 137 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<DoWriteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoWriteActorState(); static_cast<DoWriteActor*>(this)->destroy(); return 0; }
															#line 1207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<DoWriteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoWriteActorState();
		static_cast<DoWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoWriteActor*>(this)->actor_wait_state > 0) static_cast<DoWriteActor*>(this)->actor_wait_state = 0;
		static_cast<DoWriteActor*>(this)->ActorCallback< DoWriteActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoWriteActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoWriteActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoWriteActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoWriteActor*>(this)->actor_wait_state > 0) static_cast<DoWriteActor*>(this)->actor_wait_state = 0;
		static_cast<DoWriteActor*>(this)->ActorCallback< DoWriteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoWriteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doWrite", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoWriteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doWrite", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoWriteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doWrite", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Database cx;
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Value key;
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Optional<Value> val;
															#line 127 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr;
															#line 1385 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doWrite()
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class DoWriteActor final : public Actor<Void>, public ActorCallback< DoWriteActor, 0, Void >, public ActorCallback< DoWriteActor, 1, Void >, public FastAllocated<DoWriteActor>, public DoWriteActorState<DoWriteActor> {
															#line 1390 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoWriteActor>::operator new;
	using FastAllocated<DoWriteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2276982405787201792UL, 6250338449529630720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoWriteActor, 0, Void >;
friend struct ActorCallback< DoWriteActor, 1, Void >;
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DoWriteActor(Database const& cx,Value const& key,Optional<Value> const& val) 
															#line 1408 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoWriteActorState<DoWriteActor>(cx, key, val),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doWrite", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14073560622080848128UL, 14637323520501177856UL);
		ActorExecutionContextHelper __helper(static_cast<DoWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doWrite");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doWrite", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoWriteActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoWriteActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
[[nodiscard]] static Future<Void> doWrite( Database const& cx, Value const& key, Optional<Value> const& val ) {
															#line 126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	return Future<Void>(new DoWriteActor(cx, key, val));
															#line 1441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
}

#line 144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"

																#line 1446 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
// This generated class is to be used only via advanceVersion()
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
template <class AdvanceVersionActor>
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class AdvanceVersionActorState {
															#line 1452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	AdvanceVersionActorState(Database const& cx,Version const& v) 
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		 : cx(cx),
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   v(v),
															#line 146 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr(cx)
															#line 1463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("advanceVersion", reinterpret_cast<unsigned long>(this));

	}
	~AdvanceVersionActorState() 
	{
		fdb_probe_actor_destroy("advanceVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			;
															#line 1478 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AdvanceVersionActorState();
		static_cast<AdvanceVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 148 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1510 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		try {
															#line 151 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 151 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1516 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 1;
															#line 151 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionActor, 0, Version >*>(static_cast<AdvanceVersionActor*>(this)));
															#line 1521 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TRACE_ERROR(e);
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1547 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 3;
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionActor, 2, Void >*>(static_cast<AdvanceVersionActor*>(this)));
															#line 1552 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& extraDBVersion,int loopDepth) 
	{
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (extraDBVersion <= v)
															#line 1567 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		{
															#line 153 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			tr.set(minRequiredCommitVersionKey, BinaryWriter::toValue(v + 1, Unversioned()));
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1575 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 2;
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionActor, 1, Void >*>(static_cast<AdvanceVersionActor*>(this)));
															#line 1580 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (!static_cast<AdvanceVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AdvanceVersionActorState(); static_cast<AdvanceVersionActor*>(this)->destroy(); return 0; }
															#line 1587 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			new (&static_cast<AdvanceVersionActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AdvanceVersionActorState();
			static_cast<AdvanceVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && extraDBVersion,int loopDepth) 
	{
															#line 152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (extraDBVersion <= v)
															#line 1600 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		{
															#line 153 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			tr.set(minRequiredCommitVersionKey, BinaryWriter::toValue(v + 1, Unversioned()));
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1608 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 2;
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionActor, 1, Void >*>(static_cast<AdvanceVersionActor*>(this)));
															#line 1613 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (!static_cast<AdvanceVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AdvanceVersionActorState(); static_cast<AdvanceVersionActor*>(this)->destroy(); return 0; }
															#line 1620 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			new (&static_cast<AdvanceVersionActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AdvanceVersionActorState();
			static_cast<AdvanceVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& extraDBVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(extraDBVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && extraDBVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(extraDBVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionActor*>(this)->ActorCallback< AdvanceVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AdvanceVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionActor*>(this)->ActorCallback< AdvanceVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AdvanceVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AdvanceVersionActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionActor*>(this)->ActorCallback< AdvanceVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AdvanceVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Database cx;
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version v;
															#line 146 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr;
															#line 1903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
};
// This generated class is to be used only via advanceVersion()
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class AdvanceVersionActor final : public Actor<Void>, public ActorCallback< AdvanceVersionActor, 0, Version >, public ActorCallback< AdvanceVersionActor, 1, Void >, public ActorCallback< AdvanceVersionActor, 2, Void >, public FastAllocated<AdvanceVersionActor>, public AdvanceVersionActorState<AdvanceVersionActor> {
															#line 1908 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
	using FastAllocated<AdvanceVersionActor>::operator new;
	using FastAllocated<AdvanceVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11014066959944551424UL, 5284315849113574912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AdvanceVersionActor, 0, Version >;
friend struct ActorCallback< AdvanceVersionActor, 1, Void >;
friend struct ActorCallback< AdvanceVersionActor, 2, Void >;
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	AdvanceVersionActor(Database const& cx,Version const& v) 
															#line 1927 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AdvanceVersionActorState<AdvanceVersionActor>(cx, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("advanceVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4410712548360414720UL, 13930588585600599040UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("advanceVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("advanceVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AdvanceVersionActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AdvanceVersionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AdvanceVersionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
[[nodiscard]] static Future<Void> advanceVersion( Database const& cx, Version const& v ) {
															#line 145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	return Future<Void>(new AdvanceVersionActor(cx, v));
															#line 1961 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
}

#line 164 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"

																#line 1966 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
// This generated class is to be used only via doSwitch()
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
template <class DoSwitchActor>
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class DoSwitchActorState {
															#line 1972 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DoSwitchActorState(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		 : cx(cx),
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   self(self),
															#line 166 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   lockUid(deterministicRandom()->randomUniqueID())
															#line 1983 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("doSwitch", reinterpret_cast<unsigned long>(this));

	}
	~DoSwitchActorState() 
	{
		fdb_probe_actor_destroy("doSwitch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->switchAfter);
															#line 167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2000 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoSwitchActor*>(this)->actor_wait_state = 1;
															#line 167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 0, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoSwitchActorState();
		static_cast<DoSwitchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		watchFuture = Future<Void>();
															#line 169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) mutable -> Future<Void> { watchFuture = tr->watch(self->keyToWatch); return Void(); });
															#line 169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2032 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 2;
															#line 169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 1, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2037 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		watchFuture = Future<Void>();
															#line 169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) mutable -> Future<Void> { watchFuture = tr->watch(self->keyToWatch); return Void(); });
															#line 169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2050 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 2;
															#line 169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 1, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lockDatabase(self->originalDB, lockUid) && lockDatabase(self->extraDB, lockUid);
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2141 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 3;
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 2, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2146 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lockDatabase(self->originalDB, lockUid) && lockDatabase(self->extraDB, lockUid);
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2157 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 3;
															#line 173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 2, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_LockedDatabases").log();
															#line 175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<std::pair<Version, Optional<Value>>> __when_expr_3 = doRead(self->originalDB, self);
															#line 175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2250 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 4;
															#line 175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >*>(static_cast<DoSwitchActor*>(this)));
															#line 2255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_LockedDatabases").log();
															#line 175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<std::pair<Version, Optional<Value>>> __when_expr_3 = doRead(self->originalDB, self);
															#line 175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2268 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 4;
															#line 175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >*>(static_cast<DoSwitchActor*>(this)));
															#line 2273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(std::pair<Version, Optional<Value>> const& read1,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		rv = read1.first;
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		val1 = read1.second;
															#line 178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_4 = doWrite(self->extraDB, self->keyToRead, val1);
															#line 178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2363 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 5;
															#line 178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 4, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2368 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(std::pair<Version, Optional<Value>> && read1,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		rv = read1.first;
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		val1 = read1.second;
															#line 178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_4 = doWrite(self->extraDB, self->keyToRead, val1);
															#line 178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2383 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 5;
															#line 178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 4, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2388 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(std::pair<Version, Optional<Value>> const& read1,int loopDepth) 
	{
		loopDepth = a_body1cont4(read1, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(std::pair<Version, Optional<Value>> && read1,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(read1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >*,std::pair<Version, Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >*,std::pair<Version, Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_CopiedDatabase").log();
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_5 = advanceVersion(self->extraDB, rv);
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 6;
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 5, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2481 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_CopiedDatabase").log();
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_5 = advanceVersion(self->extraDB, rv);
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2494 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 6;
															#line 180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 5, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_AdvancedVersion").log();
															#line 182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cx->switchConnectionRecord( makeReference<ClusterConnectionMemoryRecord>(self->extraDB->getConnectionRecord()->getConnectionString()));
															#line 182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2587 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 7;
															#line 182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 6, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2592 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_AdvancedVersion").log();
															#line 182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cx->switchConnectionRecord( makeReference<ClusterConnectionMemoryRecord>(self->extraDB->getConnectionRecord()->getConnectionString()));
															#line 182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2605 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 7;
															#line 182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 6, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2610 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_SwitchedConnectionFile").log();
															#line 185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr = Transaction(cx);
															#line 186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.setVersion(rv);
															#line 187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 2700 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		try {
															#line 189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_7 = tr.get(self->keyToRead);
															#line 189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 2706 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont7Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
			static_cast<DoSwitchActor*>(this)->actor_wait_state = 8;
															#line 189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 7, Optional<Value> >*>(static_cast<DoSwitchActor*>(this)));
															#line 2711 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_SwitchedConnectionFile").log();
															#line 185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr = Transaction(cx);
															#line 186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.setVersion(rv);
															#line 187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 2732 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		try {
															#line 189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_7 = tr.get(self->keyToRead);
															#line 189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 2738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont7Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
			static_cast<DoSwitchActor*>(this)->actor_wait_state = 8;
															#line 189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 7, Optional<Value> >*>(static_cast<DoSwitchActor*>(this)));
															#line 2743 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 201 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_9 = unlockDatabase(self->extraDB, lockUid);
															#line 201 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2835 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont8when1(__when_expr_9.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 10;
															#line 201 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 9, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2840 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TraceEvent("DifferentClusters_ReadError").error(e);
															#line 195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TRACE_ERROR(e);
															#line 196 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr.onError(e);
															#line 196 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2856 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont7Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<DoSwitchActor*>(this)->actor_wait_state = 9;
															#line 196 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 8, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 2861 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Optional<Value> const& val2,int loopDepth) 
	{
															#line 192 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		ASSERT(val1 == val2);
															#line 2876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Optional<Value> && val2,int loopDepth) 
	{
															#line 192 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		ASSERT(val1 == val2);
															#line 2885 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Optional<Value> const& val2,int loopDepth) 
	{
		loopDepth = a_body1cont9(val2, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Optional<Value> && val2,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(val2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 7, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 7, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 7, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 7, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_UnlockedExtraDB").log();
															#line 203 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		ASSERT(!watchFuture.isReady() || watchFuture.isError());
															#line 204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_10 = doWrite(self->extraDB, self->keyToWatch, Optional<Value>{ ""_sr });
															#line 204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont12when1(__when_expr_10.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 11;
															#line 204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 10, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 3080 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_UnlockedExtraDB").log();
															#line 203 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		ASSERT(!watchFuture.isReady() || watchFuture.isError());
															#line 204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_10 = doWrite(self->extraDB, self->keyToWatch, Optional<Value>{ ""_sr });
															#line 204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3095 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont12when1(__when_expr_10.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 11;
															#line 204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 10, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 3100 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_WaitingForWatch").log();
															#line 3184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		try {
															#line 207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_11 = timeoutError(watchFuture, (self->testDuration - self->switchAfter) / 2);
															#line 207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1cont12cont1Catch1(actor_cancelled(), loopDepth);
															#line 3190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont12cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_11.get(), loopDepth); };
			static_cast<DoSwitchActor*>(this)->actor_wait_state = 12;
															#line 207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 11, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 3195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_WaitingForWatch").log();
															#line 3210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		try {
															#line 207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_11 = timeoutError(watchFuture, (self->testDuration - self->switchAfter) / 2);
															#line 207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1cont12cont1Catch1(actor_cancelled(), loopDepth);
															#line 3216 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont12cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_11.get(), loopDepth); };
			static_cast<DoSwitchActor*>(this)->actor_wait_state = 12;
															#line 207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 11, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 3221 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 212 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClusters_Done").log();
															#line 213 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		self->switchComplete = true;
															#line 214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_13 = unlockDatabase(self->originalDB, lockUid);
															#line 214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3317 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_13.get(), loopDepth); };
		static_cast<DoSwitchActor*>(this)->actor_wait_state = 14;
															#line 214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 13, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 3322 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TraceEvent("DifferentClusters_WatchError").error(e);
															#line 210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_12 = tr.onError(e);
															#line 210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<DoSwitchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3336 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont1Catch1when1(__when_expr_12.get(), loopDepth); };
			static_cast<DoSwitchActor*>(this)->actor_wait_state = 13;
															#line 210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< DoSwitchActor, 12, Void >*>(static_cast<DoSwitchActor*>(this)));
															#line 3341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont12cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont12cont5(Void const& _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<DoSwitchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoSwitchActorState(); static_cast<DoSwitchActor*>(this)->destroy(); return 0; }
															#line 3543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<DoSwitchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoSwitchActorState();
		static_cast<DoSwitchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont5(Void && _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<DoSwitchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoSwitchActorState(); static_cast<DoSwitchActor*>(this)->destroy(); return 0; }
															#line 3555 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<DoSwitchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoSwitchActorState();
		static_cast<DoSwitchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<DoSwitchActor*>(this)->actor_wait_state > 0) static_cast<DoSwitchActor*>(this)->actor_wait_state = 0;
		static_cast<DoSwitchActor*>(this)->ActorCallback< DoSwitchActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< DoSwitchActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< DoSwitchActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), 13);

	}
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Database cx;
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DifferentClustersSameRVWorkload* self;
															#line 166 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	UID lockUid;
															#line 168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Future<Void> watchFuture;
															#line 176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version rv;
															#line 177 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Optional<Value> val1;
															#line 185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr;
															#line 3652 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
};
// This generated class is to be used only via doSwitch()
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class DoSwitchActor final : public Actor<Void>, public ActorCallback< DoSwitchActor, 0, Void >, public ActorCallback< DoSwitchActor, 1, Void >, public ActorCallback< DoSwitchActor, 2, Void >, public ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >, public ActorCallback< DoSwitchActor, 4, Void >, public ActorCallback< DoSwitchActor, 5, Void >, public ActorCallback< DoSwitchActor, 6, Void >, public ActorCallback< DoSwitchActor, 7, Optional<Value> >, public ActorCallback< DoSwitchActor, 8, Void >, public ActorCallback< DoSwitchActor, 9, Void >, public ActorCallback< DoSwitchActor, 10, Void >, public ActorCallback< DoSwitchActor, 11, Void >, public ActorCallback< DoSwitchActor, 12, Void >, public ActorCallback< DoSwitchActor, 13, Void >, public FastAllocated<DoSwitchActor>, public DoSwitchActorState<DoSwitchActor> {
															#line 3657 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
	using FastAllocated<DoSwitchActor>::operator new;
	using FastAllocated<DoSwitchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9812558197615809536UL, 243614383883624704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoSwitchActor, 0, Void >;
friend struct ActorCallback< DoSwitchActor, 1, Void >;
friend struct ActorCallback< DoSwitchActor, 2, Void >;
friend struct ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >;
friend struct ActorCallback< DoSwitchActor, 4, Void >;
friend struct ActorCallback< DoSwitchActor, 5, Void >;
friend struct ActorCallback< DoSwitchActor, 6, Void >;
friend struct ActorCallback< DoSwitchActor, 7, Optional<Value> >;
friend struct ActorCallback< DoSwitchActor, 8, Void >;
friend struct ActorCallback< DoSwitchActor, 9, Void >;
friend struct ActorCallback< DoSwitchActor, 10, Void >;
friend struct ActorCallback< DoSwitchActor, 11, Void >;
friend struct ActorCallback< DoSwitchActor, 12, Void >;
friend struct ActorCallback< DoSwitchActor, 13, Void >;
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DoSwitchActor(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 3687 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DoSwitchActorState<DoSwitchActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doSwitch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1692983183145415680UL, 5520552997860425984UL);
		ActorExecutionContextHelper __helper(static_cast<DoSwitchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doSwitch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doSwitch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoSwitchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoSwitchActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoSwitchActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoSwitchActor, 3, std::pair<Version, Optional<Value>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoSwitchActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoSwitchActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoSwitchActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoSwitchActor, 7, Optional<Value> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoSwitchActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DoSwitchActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DoSwitchActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< DoSwitchActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< DoSwitchActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< DoSwitchActor, 13, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
[[nodiscard]] static Future<Void> doSwitch( Database const& cx, DifferentClustersSameRVWorkload* const& self ) {
															#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	return Future<Void>(new DoSwitchActor(cx, self));
															#line 3732 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
}

#line 217 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"

																#line 3737 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
// This generated class is to be used only via writerClient()
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
template <class WriterClientActor>
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class WriterClientActorState {
															#line 3743 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	WriterClientActorState(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		 : cx(cx),
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   self(self),
															#line 219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr(cx)
															#line 3754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writerClient", reinterpret_cast<unsigned long>(this));

	}
	~WriterClientActorState() 
	{
		fdb_probe_actor_destroy("writerClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			;
															#line 3769 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriterClientActorState();
		static_cast<WriterClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 222 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(self->keyToRead);
															#line 222 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<WriterClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3802 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriterClientActor*>(this)->actor_wait_state = 1;
															#line 222 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriterClientActor, 0, Optional<Value> >*>(static_cast<WriterClientActor*>(this)));
															#line 3807 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TRACE_ERROR(e);
															#line 236 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 236 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<WriterClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3833 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WriterClientActor*>(this)->actor_wait_state = 3;
															#line 236 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriterClientActor, 2, Void >*>(static_cast<WriterClientActor*>(this)));
															#line 3838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		int x = 0;
															#line 224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (value.present())
															#line 3855 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		{
															#line 225 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			BinaryReader r(value.get(), Unversioned());
															#line 226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			serializer(r, x);
															#line 3861 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		}
															#line 228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		x += 1;
															#line 229 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		BinaryWriter w(Unversioned());
															#line 230 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		serializer(w, x);
															#line 231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.set(self->keyToRead, w.toValue());
															#line 232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<WriterClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3875 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriterClientActor*>(this)->actor_wait_state = 2;
															#line 232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriterClientActor, 1, Void >*>(static_cast<WriterClientActor*>(this)));
															#line 3880 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		int x = 0;
															#line 224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (value.present())
															#line 3891 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		{
															#line 225 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			BinaryReader r(value.get(), Unversioned());
															#line 226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			serializer(r, x);
															#line 3897 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		}
															#line 228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		x += 1;
															#line 229 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		BinaryWriter w(Unversioned());
															#line 230 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		serializer(w, x);
															#line 231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.set(self->keyToRead, w.toValue());
															#line 232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<WriterClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3911 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriterClientActor*>(this)->actor_wait_state = 2;
															#line 232 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriterClientActor, 1, Void >*>(static_cast<WriterClientActor*>(this)));
															#line 3916 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriterClientActor*>(this)->actor_wait_state > 0) static_cast<WriterClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriterClientActor*>(this)->ActorCallback< WriterClientActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< WriterClientActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriterClientActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriterClientActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.reset();
															#line 4000 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr.reset();
															#line 4009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriterClientActor*>(this)->actor_wait_state > 0) static_cast<WriterClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriterClientActor*>(this)->ActorCallback< WriterClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriterClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriterClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriterClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriterClientActor*>(this)->actor_wait_state > 0) static_cast<WriterClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriterClientActor*>(this)->ActorCallback< WriterClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriterClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriterClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriterClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Database cx;
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DifferentClustersSameRVWorkload* self;
															#line 219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr;
															#line 4195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writerClient()
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class WriterClientActor final : public Actor<Void>, public ActorCallback< WriterClientActor, 0, Optional<Value> >, public ActorCallback< WriterClientActor, 1, Void >, public ActorCallback< WriterClientActor, 2, Void >, public FastAllocated<WriterClientActor>, public WriterClientActorState<WriterClientActor> {
															#line 4200 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriterClientActor>::operator new;
	using FastAllocated<WriterClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11935972868234250496UL, 14550424108706519296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriterClientActor, 0, Optional<Value> >;
friend struct ActorCallback< WriterClientActor, 1, Void >;
friend struct ActorCallback< WriterClientActor, 2, Void >;
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	WriterClientActor(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 4219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriterClientActorState<WriterClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writerClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13498056712127469568UL, 5459873088671141888UL);
		ActorExecutionContextHelper __helper(static_cast<WriterClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writerClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writerClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriterClientActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriterClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriterClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
[[nodiscard]] static Future<Void> writerClient( Database const& cx, DifferentClustersSameRVWorkload* const& self ) {
															#line 218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	return Future<Void>(new WriterClientActor(cx, self));
															#line 4253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
}

#line 240 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"

																#line 4258 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
// This generated class is to be used only via readAtVersion()
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
template <class ReadAtVersionActor>
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class ReadAtVersionActorState {
															#line 4264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	ReadAtVersionActorState(DifferentClustersSameRVWorkload* const& self,const char* const& name,Transaction* const& tr,Version const& version) 
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		 : self(self),
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   name(name),
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr(tr),
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   version(version),
															#line 245 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   res()
															#line 4279 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readAtVersion", reinterpret_cast<unsigned long>(this));

	}
	~ReadAtVersionActorState() 
	{
		fdb_probe_actor_destroy("readAtVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
				tr->reset();
															#line 248 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
				tr->setVersion(version);
															#line 249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(res, tr->get(self->keyToRead));
															#line 249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
				if (static_cast<ReadAtVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4301 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadAtVersionActor*>(this)->actor_wait_state = 1;
															#line 249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadAtVersionActor, 0, Void >*>(static_cast<ReadAtVersionActor*>(this)));
															#line 4306 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadAtVersionActorState();
		static_cast<ReadAtVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 252 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TraceEvent(name).error(e);
															#line 253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4338 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 250 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<ReadAtVersionActor*>(this)->SAV<Optional<Value>>::futures) { (void)(res); this->~ReadAtVersionActorState(); static_cast<ReadAtVersionActor*>(this)->destroy(); return 0; }
															#line 4352 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<ReadAtVersionActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(std::move(res)); // state_var_RVO
		this->~ReadAtVersionActorState();
		static_cast<ReadAtVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 250 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (!static_cast<ReadAtVersionActor*>(this)->SAV<Optional<Value>>::futures) { (void)(res); this->~ReadAtVersionActorState(); static_cast<ReadAtVersionActor*>(this)->destroy(); return 0; }
															#line 4364 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		new (&static_cast<ReadAtVersionActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(std::move(res)); // state_var_RVO
		this->~ReadAtVersionActorState();
		static_cast<ReadAtVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadAtVersionActor*>(this)->actor_wait_state > 0) static_cast<ReadAtVersionActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAtVersionActor*>(this)->ActorCallback< ReadAtVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAtVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readAtVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAtVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAtVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadAtVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readAtVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAtVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAtVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadAtVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readAtVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAtVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAtVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DifferentClustersSameRVWorkload* self;
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	const char* name;
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction* tr;
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version version;
															#line 245 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Optional<Value> res;
															#line 4457 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readAtVersion()
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class ReadAtVersionActor final : public Actor<Optional<Value>>, public ActorCallback< ReadAtVersionActor, 0, Void >, public FastAllocated<ReadAtVersionActor>, public ReadAtVersionActorState<ReadAtVersionActor> {
															#line 4462 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadAtVersionActor>::operator new;
	using FastAllocated<ReadAtVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12632395017119602432UL, 12646960952289357312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadAtVersionActor, 0, Void >;
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	ReadAtVersionActor(DifferentClustersSameRVWorkload* const& self,const char* const& name,Transaction* const& tr,Version const& version) 
															#line 4479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		 : Actor<Optional<Value>>(),
		   ReadAtVersionActorState<ReadAtVersionActor>(self, name, tr, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readAtVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5522674037785786368UL, 12376479782789796608UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAtVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readAtVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readAtVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadAtVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
[[nodiscard]] static Future<Optional<Value>> readAtVersion( DifferentClustersSameRVWorkload* const& self, const char* const& name, Transaction* const& tr, Version const& version ) {
															#line 241 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	return Future<Optional<Value>>(new ReadAtVersionActor(self, name, tr, version));
															#line 4511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
}

#line 256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"

																#line 4516 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
// This generated class is to be used only via readerClientSeparateDBs()
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
template <class ReaderClientSeparateDBsActor>
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class ReaderClientSeparateDBsActorState {
															#line 4522 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	ReaderClientSeparateDBsActorState(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		 : cx(cx),
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   self(self),
															#line 258 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr1(cx),
															#line 259 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   tr2(self->extraDB),
															#line 260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   rv1(),
															#line 261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   rv2(),
															#line 262 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   val1(),
															#line 263 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		   val2()
															#line 4543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this));

	}
	~ReaderClientSeparateDBsActorState() 
	{
		fdb_probe_actor_destroy("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			;
															#line 4558 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReaderClientSeparateDBsActorState();
		static_cast<ReaderClientSeparateDBsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 265 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr1.reset();
															#line 266 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr2.reset();
															#line 267 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr1.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 268 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		tr2.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 4594 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		try {
															#line 270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(rv1, tr1.getReadVersion()) && store(rv2, tr2.getReadVersion());
															#line 270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4600 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state = 1;
															#line 270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReaderClientSeparateDBsActor, 0, Void >*>(static_cast<ReaderClientSeparateDBsActor*>(this)));
															#line 4605 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			TRACE_ERROR(e);
															#line 280 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr1.onError(e) && tr2.onError(e);
															#line 280 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			if (static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4631 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state = 3;
															#line 280 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReaderClientSeparateDBsActor, 2, Void >*>(static_cast<ReaderClientSeparateDBsActor*>(this)));
															#line 4636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 271 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClustersSameRVWorkload_GotReadVersion").detail("RV1", rv1).detail("RV2", rv2);
															#line 272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		rv = std::min(rv1, rv2);
															#line 273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(val1, readAtVersion(self, "DifferentClustersSameRVWorkload_Transaction1_Error", &tr1, rv)) && store(val2, readAtVersion(self, "DifferentClustersSameRVWorkload_Transaction2_Error", &tr2, rv));
															#line 273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4657 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state = 2;
															#line 273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReaderClientSeparateDBsActor, 1, Void >*>(static_cast<ReaderClientSeparateDBsActor*>(this)));
															#line 4662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 271 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		TraceEvent("DifferentClustersSameRVWorkload_GotReadVersion").detail("RV1", rv1).detail("RV2", rv2);
															#line 272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		rv = std::min(rv1, rv2);
															#line 273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(val1, readAtVersion(self, "DifferentClustersSameRVWorkload_Transaction1_Error", &tr1, rv)) && store(val2, readAtVersion(self, "DifferentClustersSameRVWorkload_Transaction2_Error", &tr2, rv));
															#line 273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		if (static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4677 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state = 2;
															#line 273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReaderClientSeparateDBsActor, 1, Void >*>(static_cast<ReaderClientSeparateDBsActor*>(this)));
															#line 4682 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state > 0) static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state = 0;
		static_cast<ReaderClientSeparateDBsActor*>(this)->ActorCallback< ReaderClientSeparateDBsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReaderClientSeparateDBsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReaderClientSeparateDBsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReaderClientSeparateDBsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		CODE_PROBE(val1.present() != val2.present() || !val1.present() || val1.get() != val2.get(), "reading from different dbs with the same version");
															#line 4766 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
		CODE_PROBE(val1.present() != val2.present() || !val1.present() || val1.get() != val2.get(), "reading from different dbs with the same version");
															#line 4775 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state > 0) static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state = 0;
		static_cast<ReaderClientSeparateDBsActor*>(this)->ActorCallback< ReaderClientSeparateDBsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReaderClientSeparateDBsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReaderClientSeparateDBsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReaderClientSeparateDBsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state > 0) static_cast<ReaderClientSeparateDBsActor*>(this)->actor_wait_state = 0;
		static_cast<ReaderClientSeparateDBsActor*>(this)->ActorCallback< ReaderClientSeparateDBsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReaderClientSeparateDBsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReaderClientSeparateDBsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReaderClientSeparateDBsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Database cx;
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	DifferentClustersSameRVWorkload* self;
															#line 258 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr1;
															#line 259 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Transaction tr2;
															#line 260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version rv1;
															#line 261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version rv2;
															#line 262 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Optional<Value> val1;
															#line 263 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Optional<Value> val2;
															#line 272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	Version rv;
															#line 4973 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readerClientSeparateDBs()
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
class ReaderClientSeparateDBsActor final : public Actor<Void>, public ActorCallback< ReaderClientSeparateDBsActor, 0, Void >, public ActorCallback< ReaderClientSeparateDBsActor, 1, Void >, public ActorCallback< ReaderClientSeparateDBsActor, 2, Void >, public FastAllocated<ReaderClientSeparateDBsActor>, public ReaderClientSeparateDBsActorState<ReaderClientSeparateDBsActor> {
															#line 4978 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReaderClientSeparateDBsActor>::operator new;
	using FastAllocated<ReaderClientSeparateDBsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7238203168517505792UL, 7328471781668811008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReaderClientSeparateDBsActor, 0, Void >;
friend struct ActorCallback< ReaderClientSeparateDBsActor, 1, Void >;
friend struct ActorCallback< ReaderClientSeparateDBsActor, 2, Void >;
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	ReaderClientSeparateDBsActor(Database const& cx,DifferentClustersSameRVWorkload* const& self) 
															#line 4997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ReaderClientSeparateDBsActorState<ReaderClientSeparateDBsActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2304990173801296896UL, 7507221951543585536UL);
		ActorExecutionContextHelper __helper(static_cast<ReaderClientSeparateDBsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readerClientSeparateDBs");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readerClientSeparateDBs", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReaderClientSeparateDBsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReaderClientSeparateDBsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReaderClientSeparateDBsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
[[nodiscard]] static Future<Void> readerClientSeparateDBs( Database const& cx, DifferentClustersSameRVWorkload* const& self ) {
															#line 257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
	return Future<Void>(new ReaderClientSeparateDBsActor(cx, self));
															#line 5031 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DifferentClustersSameRV.actor.g.cpp.py_gen"
}

#line 284 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/workloads/DifferentClustersSameRV.actor.cpp"
};

WorkloadFactory<DifferentClustersSameRVWorkload> DifferentClustersSameRVWorkloadFactory;
