#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
/*
 * tester.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include <filesystem>
#include <fstream>
#include <functional>
#include <istream>
#include <iterator>
#include <map>
#include <streambuf>
#include <numeric>

#include <fmt/ranges.h>
#include <toml.hpp>

#include "flow/ActorCollection.h"
#include "flow/DeterministicRandom.h"
#include "flow/Histogram.h"
#include "flow/ProcessEvents.h"
#include "fdbrpc/Locality.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbrpc/sim_validation.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/Audit.h"
#include "fdbclient/AuditUtils.actor.h"
#include "fdbclient/ClusterInterface.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/DataDistributionConfig.actor.h"
#include "fdbserver/KnobProtectiveGroups.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/MoveKeys.actor.h"
#include "flow/Platform.h"

#include "flow/Trace.h"
#include "flow/actorcompiler.h" // This must be the last #include.

WorkloadContext::WorkloadContext() {}

WorkloadContext::WorkloadContext(const WorkloadContext& r)
  : options(r.options), clientId(r.clientId), clientCount(r.clientCount), sharedRandomNumber(r.sharedRandomNumber),
    dbInfo(r.dbInfo), ccr(r.ccr), rangesToCheck(r.rangesToCheck) {}

WorkloadContext::~WorkloadContext() {}

const char HEX_CHAR_LOOKUP[16] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

void emplaceIndex(uint8_t* data, int offset, int64_t index) {
	for (int i = 0; i < 16; i++) {
		data[(15 - i) + offset] = HEX_CHAR_LOOKUP[index & 0xf];
		index = index >> 4;
	}
}

Key doubleToTestKey(double p) {
	return StringRef(format("%016llx", *(uint64_t*)&p));
}

double testKeyToDouble(const KeyRef& p) {
	uint64_t x = 0;
	sscanf(p.toString().c_str(), "%" SCNx64, &x);
	return *(double*)&x;
}

Key doubleToTestKey(double p, const KeyRef& prefix) {
	return doubleToTestKey(p).withPrefix(prefix);
}

Key KVWorkload::getRandomKey() const {
	return getRandomKey(absentFrac);
}

Key KVWorkload::getRandomKey(double absentFrac) const {
	if (absentFrac > 0.0000001) {
		return getRandomKey(deterministicRandom()->random01() < absentFrac);
	} else {
		return getRandomKey(false);
	}
}

Key KVWorkload::getRandomKey(bool absent) const {
	return keyForIndex(deterministicRandom()->randomInt(0, nodeCount), absent);
}

Key KVWorkload::keyForIndex(uint64_t index) const {
	if (absentFrac > 0.0000001) {
		return keyForIndex(index, deterministicRandom()->random01() < absentFrac);
	} else {
		return keyForIndex(index, false);
	}
}

int64_t KVWorkload::indexForKey(const KeyRef& key, bool absent) const {
	int idx = 0;
	if (nodePrefix > 0) {
		ASSERT(keyBytes >= 32);
		idx += 16;
	}
	ASSERT(keyBytes >= 16);
	// extract int64_t index, the reverse process of emplaceIndex()
	auto end = key.size() - idx - (absent ? 1 : 0);
	std::string str((char*)key.begin() + idx, end);
	int64_t res = std::stoll(str, nullptr, 16);
	return res;
}

Key KVWorkload::keyForIndex(uint64_t index, bool absent) const {
	int adjustedKeyBytes = (absent) ? (keyBytes + 1) : keyBytes;
	Key result = makeString(adjustedKeyBytes);
	uint8_t* data = mutateString(result);
	memset(data, '.', adjustedKeyBytes);

	int idx = 0;
	if (nodePrefix > 0) {
		ASSERT(keyBytes >= 32);
		emplaceIndex(data, 0, nodePrefix);
		idx += 16;
	}
	ASSERT(keyBytes >= 16);
	emplaceIndex(data, idx, (int64_t)index);
	// ASSERT(indexForKey(result) == (int64_t)index); // debug assert

	return result;
}

double testKeyToDouble(const KeyRef& p, const KeyRef& prefix) {
	return testKeyToDouble(p.removePrefix(prefix));
}

															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via poisson()
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class PoissonActor>
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class PoissonActorState {
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PoissonActorState(double* const& last,double const& meanInterval) 
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : last(last),
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   meanInterval(meanInterval)
															#line 172 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("poisson", reinterpret_cast<unsigned long>(this));

	}
	~PoissonActorState() 
	{
		fdb_probe_actor_destroy("poisson", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 155 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			*last += meanInterval * -log(deterministicRandom()->random01());
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayUntil(*last);
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<PoissonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 191 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PoissonActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PoissonActor, 0, Void >*>(static_cast<PoissonActor*>(this)));
															#line 196 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PoissonActorState();
		static_cast<PoissonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<PoissonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PoissonActorState(); static_cast<PoissonActor*>(this)->destroy(); return 0; }
															#line 219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<PoissonActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PoissonActorState();
		static_cast<PoissonActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 157 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<PoissonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PoissonActorState(); static_cast<PoissonActor*>(this)->destroy(); return 0; }
															#line 231 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<PoissonActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PoissonActorState();
		static_cast<PoissonActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PoissonActor*>(this)->actor_wait_state > 0) static_cast<PoissonActor*>(this)->actor_wait_state = 0;
		static_cast<PoissonActor*>(this)->ActorCallback< PoissonActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PoissonActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("poisson", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PoissonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("poisson", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PoissonActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("poisson", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PoissonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("poisson", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PoissonActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("poisson", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PoissonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("poisson", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double* last;
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double meanInterval;
															#line 318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via poisson()
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class PoissonActor final : public Actor<Void>, public ActorCallback< PoissonActor, 0, Void >, public FastAllocated<PoissonActor>, public PoissonActorState<PoissonActor> {
															#line 323 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<PoissonActor>::operator new;
	using FastAllocated<PoissonActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15049592084484460288UL, 14318765589328896256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PoissonActor, 0, Void >;
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PoissonActor(double* const& last,double const& meanInterval) 
															#line 340 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PoissonActorState<PoissonActor>(last, meanInterval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("poisson", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(372770731710592768UL, 4255548564490349312UL);
		ActorExecutionContextHelper __helper(static_cast<PoissonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("poisson");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("poisson", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PoissonActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> poisson( double* const& last, double const& meanInterval ) {
															#line 154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new PoissonActor(last, meanInterval));
															#line 373 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via uniform()
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class UniformActor>
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class UniformActorState {
															#line 385 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	UniformActorState(double* const& last,double const& meanInterval) 
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : last(last),
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   meanInterval(meanInterval)
															#line 394 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("uniform", reinterpret_cast<unsigned long>(this));

	}
	~UniformActorState() 
	{
		fdb_probe_actor_destroy("uniform", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 161 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			*last += meanInterval;
															#line 162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayUntil(*last);
															#line 162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<UniformActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UniformActor*>(this)->actor_wait_state = 1;
															#line 162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UniformActor, 0, Void >*>(static_cast<UniformActor*>(this)));
															#line 418 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UniformActorState();
		static_cast<UniformActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<UniformActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UniformActorState(); static_cast<UniformActor*>(this)->destroy(); return 0; }
															#line 441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<UniformActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UniformActorState();
		static_cast<UniformActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<UniformActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UniformActorState(); static_cast<UniformActor*>(this)->destroy(); return 0; }
															#line 453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<UniformActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UniformActorState();
		static_cast<UniformActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UniformActor*>(this)->actor_wait_state > 0) static_cast<UniformActor*>(this)->actor_wait_state = 0;
		static_cast<UniformActor*>(this)->ActorCallback< UniformActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UniformActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uniform", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UniformActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uniform", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UniformActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uniform", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UniformActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uniform", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UniformActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uniform", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UniformActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uniform", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double* last;
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double meanInterval;
															#line 540 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via uniform()
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class UniformActor final : public Actor<Void>, public ActorCallback< UniformActor, 0, Void >, public FastAllocated<UniformActor>, public UniformActorState<UniformActor> {
															#line 545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<UniformActor>::operator new;
	using FastAllocated<UniformActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16403174652123726080UL, 17550362402407712000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UniformActor, 0, Void >;
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	UniformActor(double* const& last,double const& meanInterval) 
															#line 562 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UniformActorState<UniformActor>(last, meanInterval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uniform", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4516370186399252992UL, 2038132372127671808UL);
		ActorExecutionContextHelper __helper(static_cast<UniformActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uniform");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uniform", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UniformActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> uniform( double* const& last, double const& meanInterval ) {
															#line 160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new UniformActor(last, meanInterval));
															#line 595 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

Value getOption(VectorRef<KeyValueRef> options, Key key, Value defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			Value value = options[i].value;
			options[i].value = ""_sr;
			return value;
		}

	return defaultValue;
}

int getOption(VectorRef<KeyValueRef> options, Key key, int defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			int r;
			if (sscanf(options[i].value.toString().c_str(), "%d", &r)) {
				options[i].value = ""_sr;
				return r;
			} else {
				TraceEvent(SevError, "InvalidTestOption").detail("OptionName", key);
				throw test_specification_invalid();
			}
		}

	return defaultValue;
}

uint64_t getOption(VectorRef<KeyValueRef> options, Key key, uint64_t defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			uint64_t r;
			if (sscanf(options[i].value.toString().c_str(), "%" SCNd64, &r)) {
				options[i].value = ""_sr;
				return r;
			} else {
				TraceEvent(SevError, "InvalidTestOption").detail("OptionName", key);
				throw test_specification_invalid();
			}
		}

	return defaultValue;
}

int64_t getOption(VectorRef<KeyValueRef> options, Key key, int64_t defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			int64_t r;
			if (sscanf(options[i].value.toString().c_str(), "%" SCNd64, &r)) {
				options[i].value = ""_sr;
				return r;
			} else {
				TraceEvent(SevError, "InvalidTestOption").detail("OptionName", key);
				throw test_specification_invalid();
			}
		}

	return defaultValue;
}

double getOption(VectorRef<KeyValueRef> options, Key key, double defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			float r;
			if (sscanf(options[i].value.toString().c_str(), "%f", &r)) {
				options[i].value = ""_sr;
				return r;
			}
		}

	return defaultValue;
}

bool getOption(VectorRef<KeyValueRef> options, Key key, bool defaultValue) {
	Value p = getOption(options, key, defaultValue ? "true"_sr : "false"_sr);
	if (p == "true"_sr)
		return true;
	if (p == "false"_sr)
		return false;
	ASSERT(false);
	return false; // Assure that compiler is fine with the function
}

std::vector<std::string> getOption(VectorRef<KeyValueRef> options, Key key, std::vector<std::string> defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			std::vector<std::string> v;
			int begin = 0;
			for (int c = 0; c < options[i].value.size(); c++)
				if (options[i].value[c] == ',') {
					v.push_back(options[i].value.substr(begin, c - begin).toString());
					begin = c + 1;
				}
			v.push_back(options[i].value.substr(begin).toString());
			options[i].value = ""_sr;
			return v;
		}
	return defaultValue;
}

std::vector<int> getOption(VectorRef<KeyValueRef> options, Key key, std::vector<int> defaultValue) {
	for (int i = 0; i < options.size(); i++)
		if (options[i].key == key) {
			std::vector<int> v;
			int begin = 0;
			for (int c = 0; c < options[i].value.size(); c++)
				if (options[i].value[c] == ',') {
					v.push_back(atoi((char*)options[i].value.begin() + begin));
					begin = c + 1;
				}
			v.push_back(atoi((char*)options[i].value.begin() + begin));
			options[i].value = ""_sr;
			return v;
		}
	return defaultValue;
}

bool hasOption(VectorRef<KeyValueRef> options, Key key) {
	for (const auto& option : options) {
		if (option.key == key) {
			return true;
		}
	}
	return false;
}

// returns unconsumed options
Standalone<VectorRef<KeyValueRef>> checkAllOptionsConsumed(VectorRef<KeyValueRef> options) {
	static StringRef nothing = ""_sr;
	Standalone<VectorRef<KeyValueRef>> unconsumed;
	for (int i = 0; i < options.size(); i++)
		if (!(options[i].value == nothing)) {
			TraceEvent(SevError, "OptionNotConsumed")
			    .detail("Key", options[i].key.toString().c_str())
			    .detail("Value", options[i].value.toString().c_str());
			unconsumed.push_back_deep(unconsumed.arena(), options[i]);
		}
	return unconsumed;
}

CompoundWorkload::CompoundWorkload(WorkloadContext& wcx) : TestWorkload(wcx) {}

CompoundWorkload* CompoundWorkload::add(Reference<TestWorkload>&& w) {
	workloads.push_back(std::move(w));
	return this;
}

std::string CompoundWorkload::description() const {
	std::vector<std::string> names;
	names.reserve(workloads.size());
	for (auto const& w : workloads) {
		names.push_back(w->description());
	}
	return fmt::format("{}", fmt::join(std::move(names), ";"));
}
Future<Void> CompoundWorkload::setup(Database const& cx) {
	std::vector<Future<Void>> all;
	all.reserve(workloads.size());
	for (int w = 0; w < workloads.size(); w++)
		all.push_back(workloads[w]->setup(cx));
	auto done = waitForAll(all);
	if (failureInjection.empty()) {
		return done;
	}
	std::vector<Future<Void>> res;
	res.reserve(failureInjection.size());
	for (auto& f : failureInjection) {
		res.push_back(f->setupInjectionWorkload(cx, done));
	}
	return waitForAll(res);
}

Future<Void> CompoundWorkload::start(Database const& cx) {
	std::vector<Future<Void>> all;
	all.reserve(workloads.size() + failureInjection.size());
	auto wCount = std::make_shared<unsigned>(0);
	auto startWorkload = [&](TestWorkload& workload) -> Future<Void> {
		auto workloadName = workload.description();
		++(*wCount);
		TraceEvent("WorkloadRunStatus").detail("Name", workloadName).detail("Count", *wCount).detail("Phase", "Start");
		return fmap(
		    [workloadName, wCount](Void value) {
			    --(*wCount);
			    TraceEvent("WorkloadRunStatus")
			        .detail("Name", workloadName)
			        .detail("Remaining", *wCount)
			        .detail("Phase", "End");
			    return Void();
		    },
		    workload.start(cx));
	};
	for (auto& workload : workloads) {
		all.push_back(startWorkload(*workload));
	}
	for (auto& workload : failureInjection) {
		all.push_back(startWorkload(*workload));
	}
	return waitForAll(all);
}

Future<bool> CompoundWorkload::check(Database const& cx) {
	std::vector<Future<bool>> all;
	all.reserve(workloads.size() + failureInjection.size());
	auto wCount = std::make_shared<unsigned>(0);
	auto starter = [&](TestWorkload& workload) -> Future<bool> {
		++(*wCount);
		std::string workloadName = workload.description();
		TraceEvent("WorkloadCheckStatus")
		    .detail("Name", workloadName)
		    .detail("Count", *wCount)
		    .detail("Phase", "Start");
		return fmap(
		    [workloadName, wCount](bool ret) {
			    --(*wCount);
			    TraceEvent("WorkloadCheckStatus")
			        .detail("Name", workloadName)
			        .detail("Remaining", *wCount)
			        .detail("Phase", "End");
			    return ret;
		    },
		    workload.check(cx));
	};
	for (auto& workload : workloads) {
		all.push_back(starter(*workload));
	}
	for (auto& workload : failureInjection) {
		all.push_back(starter(*workload));
	}
	return allTrue(all);
}

															#line 830 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getMetricsCompoundWorkload()
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetMetricsCompoundWorkloadActor>
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetMetricsCompoundWorkloadActorState {
															#line 837 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetMetricsCompoundWorkloadActorState(CompoundWorkload* const& self) 
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : self(self),
															#line 397 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   results()
															#line 846 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this));

	}
	~GetMetricsCompoundWorkloadActorState() 
	{
		fdb_probe_actor_destroy("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 398 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int w = 0;w < self->workloads.size();w++) {
															#line 399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				std::vector<PerfMetric> p;
															#line 400 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				results.push_back(self->workloads[w]->getMetrics());
															#line 865 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 402 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(results);
															#line 402 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetMetricsCompoundWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 871 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMetricsCompoundWorkloadActor*>(this)->actor_wait_state = 1;
															#line 402 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*>(static_cast<GetMetricsCompoundWorkloadActor*>(this)));
															#line 876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMetricsCompoundWorkloadActorState();
		static_cast<GetMetricsCompoundWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 403 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::vector<PerfMetric> res;
															#line 404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auto const& p = results[i].get();
															#line 406 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto const& m : p ) {
															#line 407 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				res.push_back(m.withPrefix(self->workloads[i]->description() + "."));
															#line 907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetMetricsCompoundWorkloadActor*>(this)->SAV<std::vector<PerfMetric>>::futures) { (void)(res); this->~GetMetricsCompoundWorkloadActorState(); static_cast<GetMetricsCompoundWorkloadActor*>(this)->destroy(); return 0; }
															#line 912 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetMetricsCompoundWorkloadActor*>(this)->SAV< std::vector<PerfMetric> >::value()) std::vector<PerfMetric>(res);
		this->~GetMetricsCompoundWorkloadActorState();
		static_cast<GetMetricsCompoundWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 403 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::vector<PerfMetric> res;
															#line 404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < results.size();++i) {
															#line 405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auto const& p = results[i].get();
															#line 406 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto const& m : p ) {
															#line 407 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				res.push_back(m.withPrefix(self->workloads[i]->description() + "."));
															#line 932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetMetricsCompoundWorkloadActor*>(this)->SAV<std::vector<PerfMetric>>::futures) { (void)(res); this->~GetMetricsCompoundWorkloadActorState(); static_cast<GetMetricsCompoundWorkloadActor*>(this)->destroy(); return 0; }
															#line 937 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetMetricsCompoundWorkloadActor*>(this)->SAV< std::vector<PerfMetric> >::value()) std::vector<PerfMetric>(res);
		this->~GetMetricsCompoundWorkloadActorState();
		static_cast<GetMetricsCompoundWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMetricsCompoundWorkloadActor*>(this)->actor_wait_state > 0) static_cast<GetMetricsCompoundWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<GetMetricsCompoundWorkloadActor*>(this)->ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetricsCompoundWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetricsCompoundWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetricsCompoundWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CompoundWorkload* self;
															#line 397 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<std::vector<PerfMetric>>> results;
															#line 1024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getMetricsCompoundWorkload()
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetMetricsCompoundWorkloadActor final : public Actor<std::vector<PerfMetric>>, public ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >, public FastAllocated<GetMetricsCompoundWorkloadActor>, public GetMetricsCompoundWorkloadActorState<GetMetricsCompoundWorkloadActor> {
															#line 1029 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetMetricsCompoundWorkloadActor>::operator new;
	using FastAllocated<GetMetricsCompoundWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4519293708652509696UL, 11603857956520168704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<PerfMetric>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >;
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetMetricsCompoundWorkloadActor(CompoundWorkload* const& self) 
															#line 1046 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<std::vector<PerfMetric>>(),
		   GetMetricsCompoundWorkloadActorState<GetMetricsCompoundWorkloadActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3322871087501164032UL, 10981941028814264320UL);
		ActorExecutionContextHelper __helper(static_cast<GetMetricsCompoundWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMetricsCompoundWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMetricsCompoundWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMetricsCompoundWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<std::vector<PerfMetric>> getMetricsCompoundWorkload( CompoundWorkload* const& self ) {
															#line 396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<std::vector<PerfMetric>>(new GetMetricsCompoundWorkloadActor(self));
															#line 1079 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 412 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

void CompoundWorkload::addFailureInjection(WorkloadRequest& work) {
	if (!work.runFailureWorkloads) {
		return;
	}
	// Some workloads won't work with some failure injection workloads
	std::set<std::string> disabledWorkloads;
	for (auto const& w : workloads) {
		w->disableFailureInjectionWorkloads(disabledWorkloads);
	}
	if (disabledWorkloads.contains("all")) {
		return;
	}
	auto& factories = IFailureInjectorFactory::factories();
	DeterministicRandom random(sharedRandomNumber);
	for (auto& factory : factories) {
		auto workload = factory->create(*this);
		if (disabledWorkloads.contains(workload->description())) {
			continue;
		}
		if (std::find(work.disabledFailureInjectionWorkloads.begin(),
		              work.disabledFailureInjectionWorkloads.end(),
		              workload->description()) != work.disabledFailureInjectionWorkloads.end()) {
			continue;
		}
		while (shouldInjectFailure(random, work, workload)) {
			workload->initFailureInjectionMode(random);
			TraceEvent("AddFailureInjectionWorkload")
			    .detail("Name", workload->description())
			    .detail("ClientID", work.clientId)
			    .detail("ClientCount", clientCount)
			    .detail("Title", work.title);
			failureInjection.push_back(workload);
			workload = factory->create(*this);
		}
	}
}

bool CompoundWorkload::shouldInjectFailure(DeterministicRandom& random,
                                           const WorkloadRequest& work,
                                           Reference<FailureInjectionWorkload> failure) const {
	auto desc = failure->description();
	unsigned alreadyAdded =
	    std::count_if(workloads.begin(), workloads.end(), [&desc](auto const& w) { return w->description() == desc; });
	alreadyAdded += std::count_if(
	    failureInjection.begin(), failureInjection.end(), [&desc](auto const& w) { return w->description() == desc; });
	return failure->shouldInject(random, work, alreadyAdded);
}

Future<std::vector<PerfMetric>> CompoundWorkload::getMetrics() {
	return getMetricsCompoundWorkload(this);
}

double CompoundWorkload::getCheckTimeout() const {
	double m = 0;
	for (int w = 0; w < workloads.size(); w++)
		m = std::max(workloads[w]->getCheckTimeout(), m);
	return m;
}

void CompoundWorkload::getMetrics(std::vector<PerfMetric>&) {
	ASSERT(false);
}

void TestWorkload::disableFailureInjectionWorkloads(std::set<std::string>& out) const {}

FailureInjectionWorkload::FailureInjectionWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {}

void FailureInjectionWorkload::initFailureInjectionMode(DeterministicRandom& random) {}

bool FailureInjectionWorkload::shouldInject(DeterministicRandom& random,
                                            const WorkloadRequest& work,
                                            const unsigned alreadyAdded) const {
	return alreadyAdded < 3 && work.useDatabase && 0.1 / (1 + alreadyAdded) > random.random01();
}

Future<Void> FailureInjectionWorkload::setupInjectionWorkload(const Database& cx, Future<Void> done) {
	return holdWhile(this->setup(cx), done);
}

Future<Void> FailureInjectionWorkload::startInjectionWorkload(const Database& cx, Future<Void> done) {
	return holdWhile(this->start(cx), done);
}

Future<bool> FailureInjectionWorkload::checkInjectionWorkload(const Database& cx, Future<bool> done) {
	return holdWhile(this->check(cx), done);
}

															#line 1171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getWorkloadIface()
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetWorkloadIfaceActor>
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetWorkloadIfaceActorState {
															#line 1178 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetWorkloadIfaceActorState(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,VectorRef<KeyValueRef> const& options,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   options(options),
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 504 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workload(),
															#line 505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testName(getOption(options, "testName"_sr, "no-test-specified"_sr))
															#line 1195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkloadIfaceActorState() 
	{
		fdb_probe_actor_destroy("getWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			WorkloadContext wcx;
															#line 507 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientId = work.clientId;
															#line 508 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientCount = work.clientCount;
															#line 509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.ccr = ccr;
															#line 510 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.dbInfo = dbInfo;
															#line 511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.options = options;
															#line 512 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.sharedRandomNumber = work.sharedRandomNumber;
															#line 513 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.rangesToCheck = work.rangesToCheck;
															#line 515 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workload = IWorkloadFactory::create(testName.toString(), wcx);
															#line 516 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (workload)
															#line 1228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 517 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = workload->initialized();
															#line 517 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<GetWorkloadIfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1234 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetWorkloadIfaceActor*>(this)->actor_wait_state = 1;
															#line 517 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkloadIfaceActor, 0, Void >*>(static_cast<GetWorkloadIfaceActor*>(this)));
															#line 1239 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkloadIfaceActorState();
		static_cast<GetWorkloadIfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 520 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto unconsumedOptions = checkAllOptionsConsumed(workload ? workload->options : VectorRef<KeyValueRef>());
															#line 521 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!workload || unconsumedOptions.size())
															#line 1269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 522 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent evt(SevError, "TestCreationError");
															#line 523 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			evt.detail("TestName", testName);
															#line 524 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!workload)
															#line 1277 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 525 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				evt.detail("Reason", "Null workload");
															#line 526 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				fprintf(stderr, "ERROR: Workload could not be created, perhaps testName (%s) is not a valid workload\n", printable(testName).c_str());
															#line 1283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 530 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				evt.detail("Reason", "Not all options consumed");
															#line 531 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				fprintf(stderr, "ERROR: Workload had invalid options. The following were unrecognized:\n");
															#line 532 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				for(int i = 0;i < unconsumedOptions.size();i++) {
															#line 533 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					fprintf(stderr, " '%s' = '%s'\n", unconsumedOptions[i].key.toString().c_str(), unconsumedOptions[i].value.toString().c_str());
															#line 1295 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
			}
															#line 538 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch1(test_specification_invalid(), loopDepth);
															#line 1300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 540 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetWorkloadIfaceActor*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(workload); this->~GetWorkloadIfaceActorState(); static_cast<GetWorkloadIfaceActor*>(this)->destroy(); return 0; }
															#line 1304 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetWorkloadIfaceActor*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(std::move(workload)); // state_var_RVO
		this->~GetWorkloadIfaceActorState();
		static_cast<GetWorkloadIfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkloadIfaceActor*>(this)->actor_wait_state > 0) static_cast<GetWorkloadIfaceActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkloadIfaceActor*>(this)->ActorCallback< GetWorkloadIfaceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkloadIfaceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkloadIfaceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkloadIfaceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	VectorRef<KeyValueRef> options;
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 504 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<TestWorkload> workload;
															#line 505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Value testName;
															#line 1411 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getWorkloadIface()
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetWorkloadIfaceActor final : public Actor<Reference<TestWorkload>>, public ActorCallback< GetWorkloadIfaceActor, 0, Void >, public FastAllocated<GetWorkloadIfaceActor>, public GetWorkloadIfaceActorState<GetWorkloadIfaceActor> {
															#line 1416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetWorkloadIfaceActor>::operator new;
	using FastAllocated<GetWorkloadIfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3839926455180794624UL, 1753888368734904832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<TestWorkload>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkloadIfaceActor, 0, Void >;
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetWorkloadIfaceActor(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,VectorRef<KeyValueRef> const& options,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1433 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Reference<TestWorkload>>(),
		   GetWorkloadIfaceActorState<GetWorkloadIfaceActor>(work, ccr, options, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11963719953278435840UL, 7704475868573170176UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkloadIface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkloadIfaceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Reference<TestWorkload>> getWorkloadIface( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, VectorRef<KeyValueRef> const& options, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Reference<TestWorkload>>(new GetWorkloadIfaceActor(work, ccr, options, dbInfo));
															#line 1466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 542 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 1471 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getWorkloadIface()
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetWorkloadIfaceActor1>
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetWorkloadIfaceActor1State {
															#line 1478 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetWorkloadIfaceActor1State(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 546 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   wcx(),
															#line 547 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ifaces()
															#line 1493 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkloadIfaceActor1State() 
	{
		fdb_probe_actor_destroy("getWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (work.options.size() < 1)
															#line 1508 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 549 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevError, "TestCreationError").detail("Reason", "No options provided");
															#line 550 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				fprintf(stderr, "ERROR: No options were provided for workload.\n");
															#line 551 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(test_specification_invalid(), loopDepth);
															#line 1516 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 554 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientId = work.clientId;
															#line 555 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientCount = work.clientCount;
															#line 556 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.sharedRandomNumber = work.sharedRandomNumber;
															#line 557 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.ccr = ccr;
															#line 558 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.dbInfo = dbInfo;
															#line 559 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.rangesToCheck = work.rangesToCheck;
															#line 562 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < work.options.size();i++) {
															#line 563 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				ifaces.push_back(getWorkloadIface(work, ccr, work.options[i], dbInfo));
															#line 1534 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 565 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(ifaces);
															#line 565 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetWorkloadIfaceActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1540 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetWorkloadIfaceActor1*>(this)->actor_wait_state = 1;
															#line 565 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkloadIfaceActor1, 0, Void >*>(static_cast<GetWorkloadIfaceActor1*>(this)));
															#line 1545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkloadIfaceActor1State();
		static_cast<GetWorkloadIfaceActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 566 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto compound = makeReference<CompoundWorkload>(wcx);
															#line 567 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < work.options.size();i++) {
															#line 568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			compound->add(ifaces[i].getValue());
															#line 1572 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 570 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		compound->addFailureInjection(work);
															#line 571 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetWorkloadIfaceActor1*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(compound); this->~GetWorkloadIfaceActor1State(); static_cast<GetWorkloadIfaceActor1*>(this)->destroy(); return 0; }
															#line 1578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetWorkloadIfaceActor1*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(compound);
		this->~GetWorkloadIfaceActor1State();
		static_cast<GetWorkloadIfaceActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 566 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto compound = makeReference<CompoundWorkload>(wcx);
															#line 567 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < work.options.size();i++) {
															#line 568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			compound->add(ifaces[i].getValue());
															#line 1594 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 570 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		compound->addFailureInjection(work);
															#line 571 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetWorkloadIfaceActor1*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(compound); this->~GetWorkloadIfaceActor1State(); static_cast<GetWorkloadIfaceActor1*>(this)->destroy(); return 0; }
															#line 1600 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetWorkloadIfaceActor1*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(compound);
		this->~GetWorkloadIfaceActor1State();
		static_cast<GetWorkloadIfaceActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkloadIfaceActor1*>(this)->actor_wait_state > 0) static_cast<GetWorkloadIfaceActor1*>(this)->actor_wait_state = 0;
		static_cast<GetWorkloadIfaceActor1*>(this)->ActorCallback< GetWorkloadIfaceActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkloadIfaceActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkloadIfaceActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkloadIfaceActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 546 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadContext wcx;
															#line 547 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<Reference<TestWorkload>>> ifaces;
															#line 1693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getWorkloadIface()
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetWorkloadIfaceActor1 final : public Actor<Reference<TestWorkload>>, public ActorCallback< GetWorkloadIfaceActor1, 0, Void >, public FastAllocated<GetWorkloadIfaceActor1>, public GetWorkloadIfaceActor1State<GetWorkloadIfaceActor1> {
															#line 1698 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetWorkloadIfaceActor1>::operator new;
	using FastAllocated<GetWorkloadIfaceActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3839926455180794624UL, 1753888368734904832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<TestWorkload>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkloadIfaceActor1, 0, Void >;
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetWorkloadIfaceActor1(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1715 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Reference<TestWorkload>>(),
		   GetWorkloadIfaceActor1State<GetWorkloadIfaceActor1>(work, ccr, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkloadIface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5911781519368835840UL, 7249850539022595328UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkloadIfaceActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkloadIface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkloadIface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkloadIfaceActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Reference<TestWorkload>> getWorkloadIface( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Reference<TestWorkload>>(new GetWorkloadIfaceActor1(work, ccr, dbInfo));
															#line 1748 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 573 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

/**
 * Only works in simulation. This method prints all simulated processes in a human readable form to stdout. It groups
 * processes by data center, data hall, zone, and machine (in this order).
 */
void printSimulatedTopology() {
	if (!g_network->isSimulated()) {
		return;
	}
	auto processes = g_simulator->getAllProcesses();
	std::sort(processes.begin(), processes.end(), [](ISimulator::ProcessInfo* lhs, ISimulator::ProcessInfo* rhs) {
		auto l = lhs->locality;
		auto r = rhs->locality;
		if (l.dcId() != r.dcId()) {
			return l.dcId() < r.dcId();
		}
		if (l.dataHallId() != r.dataHallId()) {
			return l.dataHallId() < r.dataHallId();
		}
		if (l.zoneId() != r.zoneId()) {
			return l.zoneId() < r.zoneId();
		}
		if (l.machineId() != r.zoneId()) {
			return l.machineId() < r.machineId();
		}
		return lhs->address < rhs->address;
	});
	printf("Simulated Cluster Topology:\n");
	printf("===========================\n");
	Optional<Standalone<StringRef>> dcId, dataHallId, zoneId, machineId;
	for (auto p : processes) {
		std::string indent = "";
		if (dcId != p->locality.dcId()) {
			dcId = p->locality.dcId();
			printf("%sdcId: %s\n", indent.c_str(), p->locality.describeDcId().c_str());
		}
		indent += "  ";
		if (dataHallId != p->locality.dataHallId()) {
			dataHallId = p->locality.dataHallId();
			printf("%sdataHallId: %s\n", indent.c_str(), p->locality.describeDataHall().c_str());
		}
		indent += "  ";
		if (zoneId != p->locality.zoneId()) {
			zoneId = p->locality.zoneId();
			printf("%szoneId: %s\n", indent.c_str(), p->locality.describeZone().c_str());
		}
		indent += "  ";
		if (machineId != p->locality.machineId()) {
			machineId = p->locality.machineId();
			printf("%smachineId: %s\n", indent.c_str(), p->locality.describeMachineId().c_str());
		}
		indent += "  ";
		printf("%sAddress: %s\n", indent.c_str(), p->address.toString().c_str());
		indent += "  ";
		printf("%sClass: %s\n", indent.c_str(), p->startingClass.toString().c_str());
		printf("%sName: %s\n", indent.c_str(), p->name.c_str());
	}
}

															#line 1811 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via databaseWarmer()
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class DatabaseWarmerActor>
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class DatabaseWarmerActorState {
															#line 1818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DatabaseWarmerActorState(Database const& cx) 
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx)
															#line 1825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("databaseWarmer", reinterpret_cast<unsigned long>(this));

	}
	~DatabaseWarmerActorState() 
	{
		fdb_probe_actor_destroy("databaseWarmer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 633 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 1840 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DatabaseWarmerActorState();
		static_cast<DatabaseWarmerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 634 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr = Transaction(cx);
															#line 635 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(tr.getReadVersion());
															#line 635 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1874 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 1;
															#line 635 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DatabaseWarmerActor, 0, Void >*>(static_cast<DatabaseWarmerActor*>(this)));
															#line 1879 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.25);
															#line 636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1890 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 2;
															#line 636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DatabaseWarmerActor, 1, Void >*>(static_cast<DatabaseWarmerActor*>(this)));
															#line 1895 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.25);
															#line 636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 2;
															#line 636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DatabaseWarmerActor, 1, Void >*>(static_cast<DatabaseWarmerActor*>(this)));
															#line 1911 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state > 0) static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 0;
		static_cast<DatabaseWarmerActor*>(this)->ActorCallback< DatabaseWarmerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DatabaseWarmerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DatabaseWarmerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DatabaseWarmerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DatabaseWarmerActor*>(this)->actor_wait_state > 0) static_cast<DatabaseWarmerActor*>(this)->actor_wait_state = 0;
		static_cast<DatabaseWarmerActor*>(this)->ActorCallback< DatabaseWarmerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DatabaseWarmerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DatabaseWarmerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DatabaseWarmerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 634 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 2082 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via databaseWarmer()
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class DatabaseWarmerActor final : public Actor<Void>, public ActorCallback< DatabaseWarmerActor, 0, Void >, public ActorCallback< DatabaseWarmerActor, 1, Void >, public FastAllocated<DatabaseWarmerActor>, public DatabaseWarmerActorState<DatabaseWarmerActor> {
															#line 2087 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<DatabaseWarmerActor>::operator new;
	using FastAllocated<DatabaseWarmerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10985372936438730240UL, 5250659906236396800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DatabaseWarmerActor, 0, Void >;
friend struct ActorCallback< DatabaseWarmerActor, 1, Void >;
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DatabaseWarmerActor(Database const& cx) 
															#line 2105 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DatabaseWarmerActorState<DatabaseWarmerActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("databaseWarmer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7353933346527739648UL, 7270446683880026624UL);
		ActorExecutionContextHelper __helper(static_cast<DatabaseWarmerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("databaseWarmer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("databaseWarmer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DatabaseWarmerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DatabaseWarmerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> databaseWarmer( Database const& cx ) {
															#line 632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new DatabaseWarmerActor(cx));
															#line 2139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 639 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

// Tries indefinitely to commit a simple, self conflicting transaction
															#line 2145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via pingDatabase()
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class PingDatabaseActor>
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class PingDatabaseActorState {
															#line 2152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PingDatabaseActorState(Database const& cx) 
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 642 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tr(cx)
															#line 2161 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("pingDatabase", reinterpret_cast<unsigned long>(this));

	}
	~PingDatabaseActorState() 
	{
		fdb_probe_actor_destroy("pingDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 643 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 2176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PingDatabaseActorState();
		static_cast<PingDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 645 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 646 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 647 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(StringRef("/Liveness/" + deterministicRandom()->randomUniqueID().toString()));
															#line 647 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<PingDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2213 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PingDatabaseActor*>(this)->actor_wait_state = 1;
															#line 647 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PingDatabaseActor, 0, Optional<Value> >*>(static_cast<PingDatabaseActor*>(this)));
															#line 2218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 653 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("PingingDatabaseTransactionError").error(e);
															#line 654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<PingDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2244 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PingDatabaseActor*>(this)->actor_wait_state = 3;
															#line 654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PingDatabaseActor, 2, Void >*>(static_cast<PingDatabaseActor*>(this)));
															#line 2249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& v,int loopDepth) 
	{
															#line 649 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr.makeSelfConflicting();
															#line 650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2268 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PingDatabaseActor*>(this)->actor_wait_state = 2;
															#line 650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PingDatabaseActor, 1, Void >*>(static_cast<PingDatabaseActor*>(this)));
															#line 2273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && v,int loopDepth) 
	{
															#line 649 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr.makeSelfConflicting();
															#line 650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PingDatabaseActor*>(this)->actor_wait_state = 2;
															#line 650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PingDatabaseActor, 1, Void >*>(static_cast<PingDatabaseActor*>(this)));
															#line 2291 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PingDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PingDatabaseActor*>(this)->ActorCallback< PingDatabaseActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PingDatabaseActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 651 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<PingDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PingDatabaseActorState(); static_cast<PingDatabaseActor*>(this)->destroy(); return 0; }
															#line 2375 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<PingDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PingDatabaseActorState();
		static_cast<PingDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 651 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<PingDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PingDatabaseActorState(); static_cast<PingDatabaseActor*>(this)->destroy(); return 0; }
															#line 2387 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<PingDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PingDatabaseActorState();
		static_cast<PingDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PingDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PingDatabaseActor*>(this)->ActorCallback< PingDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PingDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PingDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PingDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PingDatabaseActor*>(this)->ActorCallback< PingDatabaseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PingDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PingDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 642 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 2561 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via pingDatabase()
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class PingDatabaseActor final : public Actor<Void>, public ActorCallback< PingDatabaseActor, 0, Optional<Value> >, public ActorCallback< PingDatabaseActor, 1, Void >, public ActorCallback< PingDatabaseActor, 2, Void >, public FastAllocated<PingDatabaseActor>, public PingDatabaseActorState<PingDatabaseActor> {
															#line 2566 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<PingDatabaseActor>::operator new;
	using FastAllocated<PingDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9751664496369213440UL, 863434617519019008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PingDatabaseActor, 0, Optional<Value> >;
friend struct ActorCallback< PingDatabaseActor, 1, Void >;
friend struct ActorCallback< PingDatabaseActor, 2, Void >;
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PingDatabaseActor(Database const& cx) 
															#line 2585 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PingDatabaseActorState<PingDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pingDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11933478825624451072UL, 18326457518002748416UL);
		ActorExecutionContextHelper __helper(static_cast<PingDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pingDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pingDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PingDatabaseActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PingDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PingDatabaseActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> pingDatabase( Database const& cx ) {
															#line 641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new PingDatabaseActor(cx));
															#line 2620 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 658 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 2625 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testDatabaseLiveness()
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class TestDatabaseLivenessActor>
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TestDatabaseLivenessActorState {
															#line 2632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestDatabaseLivenessActorState(Database const& cx,double const& databasePingDelay,std::string const& context,double const& startDelay = 0.0) 
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   databasePingDelay(databasePingDelay),
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   context(context),
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startDelay(startDelay)
															#line 2645 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testDatabaseLiveness", reinterpret_cast<unsigned long>(this));

	}
	~TestDatabaseLivenessActorState() 
	{
		fdb_probe_actor_destroy("testDatabaseLiveness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 663 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(startDelay);
															#line 663 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 1;
															#line 663 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestDatabaseLivenessActor, 0, Void >*>(static_cast<TestDatabaseLivenessActor*>(this)));
															#line 2667 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestDatabaseLivenessActorState();
		static_cast<TestDatabaseLivenessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 664 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 2690 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 664 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 2699 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state > 0) static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<TestDatabaseLivenessActor*>(this)->ActorCallback< TestDatabaseLivenessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestDatabaseLivenessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 666 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			start = now();
															#line 667 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auto traceMsg = "PingingDatabaseLiveness_" + context;
															#line 668 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(traceMsg.c_str()).log();
															#line 669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingDatabase(cx), databasePingDelay);
															#line 669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2799 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 2;
															#line 669 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestDatabaseLivenessActor, 1, Void >*>(static_cast<TestDatabaseLivenessActor*>(this)));
															#line 2804 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 675 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 2826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 676 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevError, ("PingingDatabaseLivenessError_" + context).c_str()) .error(e) .detail("PingDelay", databasePingDelay);
															#line 2830 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 679 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2834 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 670 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		double pingTime = now() - start;
															#line 671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(pingTime > 0);
															#line 672 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(("PingingDatabaseLivenessDone_" + context).c_str()).detail("TimeTaken", pingTime);
															#line 673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(databasePingDelay - pingTime);
															#line 673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2856 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 3;
															#line 673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestDatabaseLivenessActor, 2, Void >*>(static_cast<TestDatabaseLivenessActor*>(this)));
															#line 2861 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 670 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		double pingTime = now() - start;
															#line 671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(pingTime > 0);
															#line 672 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(("PingingDatabaseLivenessDone_" + context).c_str()).detail("TimeTaken", pingTime);
															#line 673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(databasePingDelay - pingTime);
															#line 673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2878 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 3;
															#line 673 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestDatabaseLivenessActor, 2, Void >*>(static_cast<TestDatabaseLivenessActor*>(this)));
															#line 2883 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state > 0) static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<TestDatabaseLivenessActor*>(this)->ActorCallback< TestDatabaseLivenessActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestDatabaseLivenessActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state > 0) static_cast<TestDatabaseLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<TestDatabaseLivenessActor*>(this)->ActorCallback< TestDatabaseLivenessActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestDatabaseLivenessActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestDatabaseLivenessActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double databasePingDelay;
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::string context;
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double startDelay;
															#line 666 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double start;
															#line 3073 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testDatabaseLiveness()
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TestDatabaseLivenessActor final : public Actor<Void>, public ActorCallback< TestDatabaseLivenessActor, 0, Void >, public ActorCallback< TestDatabaseLivenessActor, 1, Void >, public ActorCallback< TestDatabaseLivenessActor, 2, Void >, public FastAllocated<TestDatabaseLivenessActor>, public TestDatabaseLivenessActorState<TestDatabaseLivenessActor> {
															#line 3078 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<TestDatabaseLivenessActor>::operator new;
	using FastAllocated<TestDatabaseLivenessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5726991228578195968UL, 18026213992856220928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestDatabaseLivenessActor, 0, Void >;
friend struct ActorCallback< TestDatabaseLivenessActor, 1, Void >;
friend struct ActorCallback< TestDatabaseLivenessActor, 2, Void >;
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestDatabaseLivenessActor(Database const& cx,double const& databasePingDelay,std::string const& context,double const& startDelay = 0.0) 
															#line 3097 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TestDatabaseLivenessActorState<TestDatabaseLivenessActor>(cx, databasePingDelay, context, startDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17809113238497153536UL, 12303323411469534464UL);
		ActorExecutionContextHelper __helper(static_cast<TestDatabaseLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testDatabaseLiveness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testDatabaseLiveness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestDatabaseLivenessActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestDatabaseLivenessActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestDatabaseLivenessActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> testDatabaseLiveness( Database const& cx, double const& databasePingDelay, std::string const& context, double const& startDelay = 0.0 ) {
															#line 659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new TestDatabaseLivenessActor(cx, databasePingDelay, context, startDelay));
															#line 3132 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 683 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

template <class T>
void sendResult(ReplyPromise<T>& reply, Optional<ErrorOr<T>> const& result) {
	auto& res = result.get();
	if (res.isError())
		reply.sendError(res.getError());
	else
		reply.send(res.get());
}

															#line 3146 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getConsistencyCheckUrgentWorkloadIface()
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetConsistencyCheckUrgentWorkloadIfaceActor>
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetConsistencyCheckUrgentWorkloadIfaceActorState {
															#line 3153 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetConsistencyCheckUrgentWorkloadIfaceActorState(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 697 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   wcx()
															#line 3166 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	~GetConsistencyCheckUrgentWorkloadIfaceActorState() 
	{
		fdb_probe_actor_destroy("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 698 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientId = work.clientId;
															#line 699 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.clientCount = work.clientCount;
															#line 700 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.sharedRandomNumber = work.sharedRandomNumber;
															#line 701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.ccr = ccr;
															#line 702 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.dbInfo = dbInfo;
															#line 703 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			wcx.rangesToCheck = work.rangesToCheck;
															#line 704 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Reference<TestWorkload>> __when_expr_0 = getWorkloadIface(work, ccr, work.options[0], dbInfo);
															#line 704 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->actor_wait_state = 1;
															#line 704 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*>(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)));
															#line 3200 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConsistencyCheckUrgentWorkloadIfaceActorState();
		static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<TestWorkload> const& iface,int loopDepth) 
	{
															#line 705 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(iface); this->~GetConsistencyCheckUrgentWorkloadIfaceActorState(); static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->destroy(); return 0; }
															#line 3223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(iface);
		this->~GetConsistencyCheckUrgentWorkloadIfaceActorState();
		static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<TestWorkload> && iface,int loopDepth) 
	{
															#line 705 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->SAV<Reference<TestWorkload>>::futures) { (void)(iface); this->~GetConsistencyCheckUrgentWorkloadIfaceActorState(); static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->destroy(); return 0; }
															#line 3235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->SAV< Reference<TestWorkload> >::value()) Reference<TestWorkload>(iface);
		this->~GetConsistencyCheckUrgentWorkloadIfaceActorState();
		static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<TestWorkload> const& iface,int loopDepth) 
	{
		loopDepth = a_body1cont1(iface, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<TestWorkload> && iface,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(iface), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->actor_wait_state > 0) static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->actor_wait_state = 0;
		static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >::remove();

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*,Reference<TestWorkload> const& value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*,Reference<TestWorkload> && value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*,Error err) 
	{
		fdb_probe_actor_enter("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 697 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadContext wcx;
															#line 3326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getConsistencyCheckUrgentWorkloadIface()
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetConsistencyCheckUrgentWorkloadIfaceActor final : public Actor<Reference<TestWorkload>>, public ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >, public FastAllocated<GetConsistencyCheckUrgentWorkloadIfaceActor>, public GetConsistencyCheckUrgentWorkloadIfaceActorState<GetConsistencyCheckUrgentWorkloadIfaceActor> {
															#line 3331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetConsistencyCheckUrgentWorkloadIfaceActor>::operator new;
	using FastAllocated<GetConsistencyCheckUrgentWorkloadIfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14161628335642315776UL, 15913291477774015744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<TestWorkload>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >;
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetConsistencyCheckUrgentWorkloadIfaceActor(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 3348 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Reference<TestWorkload>>(),
		   GetConsistencyCheckUrgentWorkloadIfaceActorState<GetConsistencyCheckUrgentWorkloadIfaceActor>(work, ccr, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12728771481979822592UL, 4317977112143097856UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckUrgentWorkloadIfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConsistencyCheckUrgentWorkloadIface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConsistencyCheckUrgentWorkloadIface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConsistencyCheckUrgentWorkloadIfaceActor, 0, Reference<TestWorkload> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Reference<TestWorkload>> getConsistencyCheckUrgentWorkloadIface( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Reference<TestWorkload>>(new GetConsistencyCheckUrgentWorkloadIfaceActor(work, ccr, dbInfo));
															#line 3381 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 707 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 3386 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runConsistencyCheckUrgentWorkloadAsync()
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunConsistencyCheckUrgentWorkloadAsyncActor>
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckUrgentWorkloadAsyncActorState {
															#line 3393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckUrgentWorkloadAsyncActorState(Database const& cx,WorkloadInterface const& workIface,Reference<TestWorkload> const& workload) 
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workIface(workIface),
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workload(workload),
															#line 711 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   jobReq()
															#line 3406 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this));

	}
	~RunConsistencyCheckUrgentWorkloadAsyncActorState() 
	{
		fdb_probe_actor_destroy("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 712 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 3421 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunConsistencyCheckUrgentWorkloadAsyncActorState();
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 736 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunConsistencyCheckUrgentWorkloadAsyncActorState(); static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->destroy(); return 0; }
															#line 3444 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunConsistencyCheckUrgentWorkloadAsyncActorState();
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 713 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_0 = workIface.start.getFuture();
															#line 3463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
															#line 712 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 1;
															#line 713 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*>(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)));
															#line 3472 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> const& req,int loopDepth) 
	{
															#line 714 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobReq = req;
															#line 3494 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		try {
															#line 716 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadReceived", workIface.id()) .detail("WorkloadName", workload->description()) .detail("ClientCount", workload->clientCount) .detail("ClientId", workload->clientId);
															#line 720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = workload->start(cx);
															#line 720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when1Catch1(actor_cancelled(), loopDepth);
															#line 3502 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1when1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 2;
															#line 720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*>(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)));
															#line 3507 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> && req,int loopDepth) 
	{
															#line 714 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobReq = req;
															#line 3522 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		try {
															#line 716 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadReceived", workIface.id()) .detail("WorkloadName", workload->description()) .detail("ClientCount", workload->clientCount) .detail("ClientId", workload->clientId);
															#line 720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = workload->start(cx);
															#line 720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when1Catch1(actor_cancelled(), loopDepth);
															#line 3530 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1when1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 2;
															#line 720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*>(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)));
															#line 3535 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >::remove();

	}
	int a_body1loopBody1when1cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 723 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3563 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3567 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 726 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadError", workIface.id()) .errorUnsuppressed(e) .detail("WorkloadName", workload->description()) .detail("ClientCount", workload->clientCount) .detail("ClientId", workload->clientId);
															#line 731 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			jobReq.sendError(consistency_check_urgent_task_failed());
															#line 3573 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when1cont2(Void const& _,int loopDepth) 
	{
															#line 721 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobReq.send(Void());
															#line 3588 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont2(Void && _,int loopDepth) 
	{
															#line 721 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobReq.send(Void());
															#line 3597 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadInterface workIface;
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<TestWorkload> workload;
															#line 711 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<Void> jobReq;
															#line 3755 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runConsistencyCheckUrgentWorkloadAsync()
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckUrgentWorkloadAsyncActor final : public Actor<Void>, public ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >, public ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >, public FastAllocated<RunConsistencyCheckUrgentWorkloadAsyncActor>, public RunConsistencyCheckUrgentWorkloadAsyncActorState<RunConsistencyCheckUrgentWorkloadAsyncActor> {
															#line 3760 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunConsistencyCheckUrgentWorkloadAsyncActor>::operator new;
	using FastAllocated<RunConsistencyCheckUrgentWorkloadAsyncActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17125647873070087168UL, 11907698461042976000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >;
friend struct ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >;
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckUrgentWorkloadAsyncActor(Database const& cx,WorkloadInterface const& workIface,Reference<TestWorkload> const& workload) 
															#line 3778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunConsistencyCheckUrgentWorkloadAsyncActorState<RunConsistencyCheckUrgentWorkloadAsyncActor>(cx, workIface, workload),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9698761713318437888UL, 14742129748971403776UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckUrgentWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runConsistencyCheckUrgentWorkloadAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runConsistencyCheckUrgentWorkloadAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 0, ReplyPromise<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunConsistencyCheckUrgentWorkloadAsyncActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> runConsistencyCheckUrgentWorkloadAsync( Database const& cx, WorkloadInterface const& workIface, Reference<TestWorkload> const& workload ) {
															#line 708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new RunConsistencyCheckUrgentWorkloadAsyncActor(cx, workIface, workload));
															#line 3812 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 3817 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testerServerConsistencyCheckerUrgentWorkload()
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class TesterServerConsistencyCheckerUrgentWorkloadActor>
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerConsistencyCheckerUrgentWorkloadActorState {
															#line 3824 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerConsistencyCheckerUrgentWorkloadActorState(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo) 
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 742 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workIface(),
															#line 743 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   replied(false)
															#line 3839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this));

	}
	~TesterServerConsistencyCheckerUrgentWorkloadActorState() 
	{
		fdb_probe_actor_destroy("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 745 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				cx = openDBOnServer(dbInfo);
															#line 746 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 746 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3859 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 1;
															#line 746 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 3864 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TesterServerConsistencyCheckerUrgentWorkloadActorState();
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 761 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TesterServerConsistencyCheckerUrgentWorkloadActorState(); static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->destroy(); return 0; }
															#line 3893 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TesterServerConsistencyCheckerUrgentWorkloadActorState();
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 753 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3910 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 756 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterRunWorkloadFailed").errorUnsuppressed(e);
															#line 757 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!replied)
															#line 3916 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				work.reply.sendError(e);
															#line 3920 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Reference<TestWorkload>> __when_expr_1 = getConsistencyCheckUrgentWorkloadIface(work, ccr, dbInfo);
															#line 747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3938 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 2;
															#line 747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 3943 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Reference<TestWorkload>> __when_expr_1 = getConsistencyCheckUrgentWorkloadIface(work, ccr, dbInfo);
															#line 747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3954 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 2;
															#line 747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 3959 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Reference<TestWorkload> const& workload,int loopDepth) 
	{
															#line 748 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		Future<Void> test = runConsistencyCheckUrgentWorkloadAsync(cx, workIface, workload);
															#line 749 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		work.reply.send(workIface);
															#line 750 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		replied = true;
															#line 751 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = test;
															#line 751 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4051 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 3;
															#line 751 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 4056 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Reference<TestWorkload> && workload,int loopDepth) 
	{
															#line 748 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		Future<Void> test = runConsistencyCheckUrgentWorkloadAsync(cx, workIface, workload);
															#line 749 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		work.reply.send(workIface);
															#line 750 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		replied = true;
															#line 751 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = test;
															#line 751 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4073 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 3;
															#line 751 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*>(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)));
															#line 4078 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<TestWorkload> const& workload,int loopDepth) 
	{
		loopDepth = a_body1cont3(workload, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<TestWorkload> && workload,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(workload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*,Reference<TestWorkload> const& value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*,Reference<TestWorkload> && value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<struct ServerDBInfo> const> dbInfo;
															#line 742 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadInterface workIface;
															#line 743 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool replied;
															#line 745 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 4270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testerServerConsistencyCheckerUrgentWorkload()
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerConsistencyCheckerUrgentWorkloadActor final : public Actor<Void>, public ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >, public ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >, public ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >, public FastAllocated<TesterServerConsistencyCheckerUrgentWorkloadActor>, public TesterServerConsistencyCheckerUrgentWorkloadActorState<TesterServerConsistencyCheckerUrgentWorkloadActor> {
															#line 4275 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<TesterServerConsistencyCheckerUrgentWorkloadActor>::operator new;
	using FastAllocated<TesterServerConsistencyCheckerUrgentWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15090064557941249280UL, 15511505543933058048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >;
friend struct ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >;
friend struct ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >;
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerConsistencyCheckerUrgentWorkloadActor(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo) 
															#line 4294 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TesterServerConsistencyCheckerUrgentWorkloadActorState<TesterServerConsistencyCheckerUrgentWorkloadActor>(work, ccr, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8596843326291973632UL, 1793775326075062016UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerConsistencyCheckerUrgentWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testerServerConsistencyCheckerUrgentWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testerServerConsistencyCheckerUrgentWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 1, Reference<TestWorkload> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TesterServerConsistencyCheckerUrgentWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> testerServerConsistencyCheckerUrgentWorkload( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo ) {
															#line 739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new TesterServerConsistencyCheckerUrgentWorkloadActor(work, ccr, dbInfo));
															#line 4329 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 763 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 4334 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runWorkloadAsync()
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunWorkloadAsyncActor>
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunWorkloadAsyncActorState {
															#line 4341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunWorkloadAsyncActorState(Database const& cx,WorkloadInterface const& workIface,Reference<TestWorkload> const& workload,double const& databasePingDelay) 
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workIface(workIface),
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workload(workload),
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   databasePingDelay(databasePingDelay),
															#line 768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   setupResult(),
															#line 769 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startResult(),
															#line 770 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   checkResult(),
															#line 771 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   setupReq(),
															#line 772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startReq(),
															#line 773 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   checkReq()
															#line 4366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runWorkloadAsync", reinterpret_cast<unsigned long>(this));

	}
	~RunWorkloadAsyncActorState() 
	{
		fdb_probe_actor_destroy("runWorkloadAsync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 775 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestBeginAsync", workIface.id()) .detail("Workload", workload->description()) .detail("DatabasePingDelay", databasePingDelay);
															#line 779 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databaseError = databasePingDelay == 0.0 ? Never() : testDatabaseLiveness(cx, databasePingDelay, "RunWorkloadAsync");
															#line 782 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 4385 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunWorkloadAsyncActorState();
		static_cast<RunWorkloadAsyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 867 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunWorkloadAsyncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunWorkloadAsyncActorState(); static_cast<RunWorkloadAsyncActor*>(this)->destroy(); return 0; }
															#line 4408 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<RunWorkloadAsyncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunWorkloadAsyncActorState();
		static_cast<RunWorkloadAsyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 783 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_0 = workIface.setup.getFuture();
															#line 4427 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
															#line 782 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4431 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 803 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_1 = workIface.start.getFuture();
															#line 4435 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_2 = workIface.check.getFuture();
															#line 4440 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<ReplyPromise<CheckReply>>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<ReplyPromise<CheckReply>>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 849 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_3 = workIface.metrics.getFuture();
															#line 4445 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<ReplyPromise<std::vector<PerfMetric>>>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<ReplyPromise<std::vector<PerfMetric>>>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
															#line 862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_4 = workIface.stop.getFuture();
															#line 4450 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<ReplyPromise<Void>>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<ReplyPromise<Void>>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.pop(), loopDepth); };
		static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 1;
															#line 783 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 803 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 849 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4464 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> const& req,int loopDepth) 
	{
															#line 784 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Test received trigger for setup...\n");
															#line 785 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupBeginning", workIface.id()).detail("Workload", workload->description());
															#line 786 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		setupReq = req;
															#line 787 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!setupResult.present())
															#line 4498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_5 = workload->setup(cx) || databaseError;
															#line 789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when1Catch1(actor_cancelled(), loopDepth);
															#line 4505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1when1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1when1when1(__when_expr_5.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 2;
															#line 789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 5, Void >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4510 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ReplyPromise<Void> && req,int loopDepth) 
	{
															#line 784 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Test received trigger for setup...\n");
															#line 785 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupBeginning", workIface.id()).detail("Workload", workload->description());
															#line 786 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		setupReq = req;
															#line 787 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!setupResult.present())
															#line 4536 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_5 = workload->setup(cx) || databaseError;
															#line 789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when1Catch1(actor_cancelled(), loopDepth);
															#line 4543 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1when1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1when1when1(__when_expr_5.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 2;
															#line 789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 5, Void >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(ReplyPromise<Void> const& req,int loopDepth) 
	{
															#line 804 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		startReq = req;
															#line 805 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!startResult.present())
															#line 4570 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 807 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TestStarting", workIface.id()).detail("Workload", workload->description());
															#line 808 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_6 = workload->start(cx) || databaseError;
															#line 808 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when2Catch1(actor_cancelled(), loopDepth);
															#line 4579 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1when2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_6.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 3;
															#line 808 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 6, Void >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4584 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(ReplyPromise<Void> && req,int loopDepth) 
	{
															#line 804 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		startReq = req;
															#line 805 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!startResult.present())
															#line 4606 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 807 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TestStarting", workIface.id()).detail("Workload", workload->description());
															#line 808 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_6 = workload->start(cx) || databaseError;
															#line 808 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when2Catch1(actor_cancelled(), loopDepth);
															#line 4615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1when2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1when2when1(__when_expr_6.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 3;
															#line 808 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 6, Void >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4620 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when3(ReplyPromise<CheckReply> const& req,int loopDepth) 
	{
															#line 828 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checkReq = req;
															#line 829 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!checkResult.present())
															#line 4642 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 831 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TestChecking", workIface.id()).detail("Workload", workload->description());
															#line 832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<bool> __when_expr_7 = timeoutError(workload->check(cx), workload->getCheckTimeout());
															#line 832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when3Catch1(actor_cancelled(), loopDepth);
															#line 4651 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1when3Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1when3when1(__when_expr_7.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 4;
															#line 832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 7, bool >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4656 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when3Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when3(ReplyPromise<CheckReply> && req,int loopDepth) 
	{
															#line 828 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checkReq = req;
															#line 829 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!checkResult.present())
															#line 4678 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 831 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TestChecking", workIface.id()).detail("Workload", workload->description());
															#line 832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<bool> __when_expr_7 = timeoutError(workload->check(cx), workload->getCheckTimeout());
															#line 832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when3Catch1(actor_cancelled(), loopDepth);
															#line 4687 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1when3Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1when3when1(__when_expr_7.get(), loopDepth); };
				static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 4;
															#line 832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 7, bool >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4692 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1when3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1when3Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when3cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when4(ReplyPromise<std::vector<PerfMetric>> const& req,int loopDepth) 
	{
															#line 850 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		s_req = req;
															#line 4712 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		try {
															#line 852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<std::vector<PerfMetric>> __when_expr_8 = workload->getMetrics();
															#line 852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when4Catch1(actor_cancelled(), loopDepth);
															#line 4718 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1when4Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1when4when1(__when_expr_8.get(), loopDepth); };
			static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 5;
															#line 852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4723 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when4(ReplyPromise<std::vector<PerfMetric>> && req,int loopDepth) 
	{
															#line 850 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		s_req = req;
															#line 4738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		try {
															#line 852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<std::vector<PerfMetric>> __when_expr_8 = workload->getMetrics();
															#line 852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state < 0) return a_body1loopBody1when4Catch1(actor_cancelled(), loopDepth);
															#line 4744 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1when4Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1when4when1(__when_expr_8.get(), loopDepth); };
			static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 5;
															#line 852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*>(static_cast<RunWorkloadAsyncActor*>(this)));
															#line 4749 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when5(ReplyPromise<Void> const& r,int loopDepth) 
	{
															#line 863 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		r.send(Void());
															#line 4764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when5(ReplyPromise<Void> && r,int loopDepth) 
	{
															#line 863 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		r.send(Void());
															#line 4773 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >::remove();
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >::remove();
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >::remove();
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >::remove();
		static_cast<RunWorkloadAsyncActor*>(this)->ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >::remove();

	}
	int a_body1loopBody1when1cont1(int loopDepth) 
	{
															#line 801 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		sendResult(setupReq, setupResult);
															#line 4792 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 793 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			setupResult = operation_failed();
															#line 794 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestSetupError", workIface.id()) .error(e) .detail("Workload", workload->description());
															#line 797 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete)
															#line 4812 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 798 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4816 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1loopBody1when1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when1cont3(Void const& _,int loopDepth) 
	{
															#line 790 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupComplete", workIface.id()).detail("Workload", workload->description());
															#line 791 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		setupResult = Void();
															#line 4834 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont3(Void && _,int loopDepth) 
	{
															#line 790 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupComplete", workIface.id()).detail("Workload", workload->description());
															#line 791 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		setupResult = Void();
															#line 4845 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorCallback< RunWorkloadAsyncActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunWorkloadAsyncActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1when1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
															#line 825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		sendResult(startReq, startResult);
															#line 4999 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(int loopDepth) 
	{
															#line 820 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestComplete", workIface.id()) .detail("Workload", workload->description()) .detail("OK", !startResult.get().isError());
															#line 823 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("%s complete\n", workload->description().c_str());
															#line 5010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 811 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			startResult = operation_failed();
															#line 812 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete)
															#line 5022 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 813 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure", workIface.id()) .errorUnsuppressed(e) .detail("Reason", "Error starting workload") .detail("Workload", workload->description());
															#line 5030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1when2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when2cont3(Void const& _,int loopDepth) 
	{
															#line 809 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		startResult = Void();
															#line 5045 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when2cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont3(Void && _,int loopDepth) 
	{
															#line 809 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		startResult = Void();
															#line 5054 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when2cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorCallback< RunWorkloadAsyncActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunWorkloadAsyncActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1when2cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when3cont1(int loopDepth) 
	{
															#line 847 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		sendResult(checkReq, checkResult);
															#line 5208 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3cont2(int loopDepth) 
	{
															#line 844 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestCheckComplete", workIface.id()).detail("Workload", workload->description());
															#line 5217 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when3cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 835 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			checkResult = operation_failed();
															#line 836 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete)
															#line 5229 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 837 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5233 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure", workIface.id()) .error(e) .detail("Reason", "Error checking workload") .detail("Workload", workload->description());
															#line 5237 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1when3cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when3cont3(bool const& check,int loopDepth) 
	{
															#line 833 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checkResult = CheckReply{ (!startResult.present() || !startResult.get().isError()) && check };
															#line 5252 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when3cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3cont3(bool && check,int loopDepth) 
	{
															#line 833 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checkResult = CheckReply{ (!startResult.present() || !startResult.get().isError()) && check };
															#line 5261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when3cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(bool const& check,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont3(check, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(bool && check,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont3(std::move(check), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorCallback< RunWorkloadAsyncActor, 7, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 7, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 7, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunWorkloadAsyncActor, 7, bool >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when3Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1when3cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when3cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >*,ReplyPromise<CheckReply> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >*,ReplyPromise<CheckReply> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when4cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 856 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete)
															#line 5422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 857 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 858 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "WorkloadSendMetrics", workIface.id()).error(e);
															#line 859 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			s_req.sendError(operation_failed());
															#line 5432 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when4cont2(std::vector<PerfMetric> const& m,int loopDepth) 
	{
															#line 853 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("WorkloadSendMetrics", workIface.id()).detail("Count", m.size());
															#line 854 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		s_req.send(m);
															#line 5449 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when4cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4cont2(std::vector<PerfMetric> && m,int loopDepth) 
	{
															#line 853 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("WorkloadSendMetrics", workIface.id()).detail("Count", m.size());
															#line 854 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		s_req.send(m);
															#line 5460 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1when4cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4when1(std::vector<PerfMetric> const& m,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4cont2(m, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4when1(std::vector<PerfMetric> && m,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4cont2(std::move(m), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadAsyncActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadAsyncActor*>(this)->ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*,std::vector<PerfMetric> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*,std::vector<PerfMetric> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1when4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1when4Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1when4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1when4cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >*,ReplyPromise<std::vector<PerfMetric>> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >*,ReplyPromise<std::vector<PerfMetric>> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >*,ReplyPromise<Void> const& value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >*,ReplyPromise<Void> && value) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadInterface workIface;
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<TestWorkload> workload;
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double databasePingDelay;
															#line 768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<ErrorOr<Void>> setupResult;
															#line 769 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<ErrorOr<Void>> startResult;
															#line 770 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<ErrorOr<CheckReply>> checkResult;
															#line 771 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<Void> setupReq;
															#line 772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<Void> startReq;
															#line 773 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<CheckReply> checkReq;
															#line 779 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Future<Void> databaseError;
															#line 850 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ReplyPromise<std::vector<PerfMetric>> s_req;
															#line 5691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runWorkloadAsync()
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunWorkloadAsyncActor final : public Actor<Void>, public ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >, public ActorCallback< RunWorkloadAsyncActor, 5, Void >, public ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >, public ActorCallback< RunWorkloadAsyncActor, 6, Void >, public ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >, public ActorCallback< RunWorkloadAsyncActor, 7, bool >, public ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >, public ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >, public ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >, public FastAllocated<RunWorkloadAsyncActor>, public RunWorkloadAsyncActorState<RunWorkloadAsyncActor> {
															#line 5696 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunWorkloadAsyncActor>::operator new;
	using FastAllocated<RunWorkloadAsyncActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1603263293487708160UL, 3538552752198384640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >;
friend struct ActorCallback< RunWorkloadAsyncActor, 5, Void >;
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 1, ReplyPromise<Void> >;
friend struct ActorCallback< RunWorkloadAsyncActor, 6, Void >;
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 2, ReplyPromise<CheckReply> >;
friend struct ActorCallback< RunWorkloadAsyncActor, 7, bool >;
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 3, ReplyPromise<std::vector<PerfMetric>> >;
friend struct ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >;
friend struct ActorSingleCallback< RunWorkloadAsyncActor, 4, ReplyPromise<Void> >;
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunWorkloadAsyncActor(Database const& cx,WorkloadInterface const& workIface,Reference<TestWorkload> const& workload,double const& databasePingDelay) 
															#line 5721 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunWorkloadAsyncActorState<RunWorkloadAsyncActor>(cx, workIface, workload, databasePingDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runWorkloadAsync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17968685797001769216UL, 9430172446286135040UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadAsyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runWorkloadAsync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runWorkloadAsync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< RunWorkloadAsyncActor, 0, ReplyPromise<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunWorkloadAsyncActor, 5, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunWorkloadAsyncActor, 6, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunWorkloadAsyncActor, 7, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunWorkloadAsyncActor, 8, std::vector<PerfMetric> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> runWorkloadAsync( Database const& cx, WorkloadInterface const& workIface, Reference<TestWorkload> const& workload, double const& databasePingDelay ) {
															#line 764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new RunWorkloadAsyncActor(cx, workIface, workload, databasePingDelay));
															#line 5758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 5763 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testerServerWorkload()
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class TesterServerWorkloadActor>
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerWorkloadActorState {
															#line 5770 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerWorkloadActorState(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo,LocalityData const& locality) 
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : work(work),
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   locality(locality),
															#line 874 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workIface(),
															#line 875 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   replied(false),
															#line 876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   cx()
															#line 5789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testerServerWorkload", reinterpret_cast<unsigned long>(this));

	}
	~TesterServerWorkloadActorState() 
	{
		fdb_probe_actor_destroy("testerServerWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 878 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				std::map<std::string, std::string> details;
															#line 879 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				details["WorkloadTitle"] = printable(work.title);
															#line 880 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				details["ClientId"] = format("%d", work.clientId);
															#line 881 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				details["ClientCount"] = format("%d", work.clientCount);
															#line 882 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				details["WorkloadTimeout"] = format("%d", work.timeout);
															#line 883 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				startRole(Role::TESTER, workIface.id(), UID(), details);
															#line 885 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (work.useDatabase)
															#line 5817 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 886 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					cx = Database::createDatabase(ccr, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 887 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 887 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 1;
															#line 887 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TesterServerWorkloadActor, 0, Void >*>(static_cast<TesterServerWorkloadActor*>(this)));
															#line 5830 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TesterServerWorkloadActorState();
		static_cast<TesterServerWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 927 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<TesterServerWorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TesterServerWorkloadActorState(); static_cast<TesterServerWorkloadActor*>(this)->destroy(); return 0; }
															#line 5864 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<TesterServerWorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TesterServerWorkloadActorState();
		static_cast<TesterServerWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 911 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevDebug, "TesterWorkloadFailed").errorUnsuppressed(e);
															#line 912 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!replied)
															#line 5879 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 913 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (e.code() == error_code_test_specification_invalid)
															#line 5883 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 914 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					work.reply.sendError(e);
															#line 5887 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
				else
				{
															#line 916 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					work.reply.sendError(operation_failed());
															#line 5893 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
			}
															#line 919 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			bool ok = e.code() == error_code_please_reboot || e.code() == error_code_please_reboot_delete || e.code() == error_code_actor_cancelled;
															#line 921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			endRole(Role::TESTER, workIface.id(), "Error", ok, e);
															#line 923 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() != error_code_test_specification_invalid && e.code() != error_code_timed_out)
															#line 5902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 924 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 891 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("WorkloadReceived", workIface.id()).detail("Title", work.title);
															#line 892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Reference<TestWorkload>> __when_expr_1 = getWorkloadIface(work, ccr, dbInfo);
															#line 892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5926 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 2;
															#line 892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*>(static_cast<TesterServerWorkloadActor*>(this)));
															#line 5931 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerWorkloadActor*>(this)->ActorCallback< TesterServerWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TesterServerWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Reference<TestWorkload> const& workload,int loopDepth) 
	{
															#line 893 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!workload)
															#line 6027 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 894 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestCreationError").detail("Reason", "Workload could not be created");
															#line 895 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			fprintf(stderr, "ERROR: The workload could not be created.\n");
															#line 896 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch2(test_specification_invalid(), loopDepth);
															#line 6035 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		Future<Void> test = runWorkloadAsync(cx, workIface, workload, work.databasePingDelay) || traceRole(Role::TESTER, workIface.id());
															#line 900 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		work.reply.send(workIface);
															#line 901 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		replied = true;
															#line 903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (work.timeout > 0)
															#line 6045 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 904 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			test = timeoutError(test, work.timeout);
															#line 6049 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = test;
															#line 907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 3;
															#line 907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TesterServerWorkloadActor, 2, Void >*>(static_cast<TesterServerWorkloadActor*>(this)));
															#line 6060 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Reference<TestWorkload> && workload,int loopDepth) 
	{
															#line 893 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!workload)
															#line 6069 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 894 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestCreationError").detail("Reason", "Workload could not be created");
															#line 895 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			fprintf(stderr, "ERROR: The workload could not be created.\n");
															#line 896 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch2(test_specification_invalid(), loopDepth);
															#line 6077 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		Future<Void> test = runWorkloadAsync(cx, workIface, workload, work.databasePingDelay) || traceRole(Role::TESTER, workIface.id());
															#line 900 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		work.reply.send(workIface);
															#line 901 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		replied = true;
															#line 903 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (work.timeout > 0)
															#line 6087 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 904 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			test = timeoutError(test, work.timeout);
															#line 6091 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = test;
															#line 907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6097 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 3;
															#line 907 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TesterServerWorkloadActor, 2, Void >*>(static_cast<TesterServerWorkloadActor*>(this)));
															#line 6102 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<TestWorkload> const& workload,int loopDepth) 
	{
		loopDepth = a_body1cont4(workload, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<TestWorkload> && workload,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(workload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerWorkloadActor*>(this)->ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*,Reference<TestWorkload> const& value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*,Reference<TestWorkload> && value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 909 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		endRole(Role::TESTER, workIface.id(), "Complete");
															#line 6186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 909 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		endRole(Role::TESTER, workIface.id(), "Complete");
															#line 6195 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TesterServerWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerWorkloadActor*>(this)->ActorCallback< TesterServerWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TesterServerWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TesterServerWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadRequest work;
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<struct ServerDBInfo> const> dbInfo;
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	LocalityData locality;
															#line 874 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	WorkloadInterface workIface;
															#line 875 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool replied;
															#line 876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 6302 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testerServerWorkload()
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerWorkloadActor final : public Actor<Void>, public ActorCallback< TesterServerWorkloadActor, 0, Void >, public ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >, public ActorCallback< TesterServerWorkloadActor, 2, Void >, public FastAllocated<TesterServerWorkloadActor>, public TesterServerWorkloadActorState<TesterServerWorkloadActor> {
															#line 6307 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<TesterServerWorkloadActor>::operator new;
	using FastAllocated<TesterServerWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7873618176568999680UL, 17962976047581145344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TesterServerWorkloadActor, 0, Void >;
friend struct ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >;
friend struct ActorCallback< TesterServerWorkloadActor, 2, Void >;
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerWorkloadActor(WorkloadRequest const& work,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo,LocalityData const& locality) 
															#line 6326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TesterServerWorkloadActorState<TesterServerWorkloadActor>(work, ccr, dbInfo, locality),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testerServerWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15163297854158783232UL, 16242971039806691584UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testerServerWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testerServerWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TesterServerWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TesterServerWorkloadActor, 1, Reference<TestWorkload> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TesterServerWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> testerServerWorkload( WorkloadRequest const& work, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo, LocalityData const& locality ) {
															#line 870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new TesterServerWorkloadActor(work, ccr, dbInfo, locality));
															#line 6361 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 929 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 6366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via testerServerCore()
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class TesterServerCoreActor>
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerCoreActorState {
															#line 6373 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerCoreActorState(TesterInterface const& interf,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo,LocalityData const& locality,Optional<std::string> const& expectedWorkLoad) 
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : interf(interf),
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccr(ccr),
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   locality(locality),
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   expectedWorkLoad(expectedWorkLoad),
															#line 935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   addWorkload(),
															#line 936 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workerFatalError(actorCollection(addWorkload.getFuture())),
															#line 940 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   consistencyCheckerUrgentTester(std::make_pair(0, Future<Void>()))
															#line 6394 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("testerServerCore", reinterpret_cast<unsigned long>(this));

	}
	~TesterServerCoreActorState() 
	{
		fdb_probe_actor_destroy("testerServerCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 942 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("StartingTesterServerCore", interf.id()) .detail("ExpectedWorkload", expectedWorkLoad.present() ? expectedWorkLoad.get() : "[Unset]");
															#line 944 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 6411 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TesterServerCoreActorState();
		static_cast<TesterServerCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 945 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_0 = workerFatalError;
															#line 944 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<TesterServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 946 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = consistencyCheckerUrgentTester.second.isValid() ? consistencyCheckerUrgentTester.second : Never();
															#line 6447 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 952 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto __when_expr_2 = interf.recruitments.getFuture();
															#line 6451 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<WorkloadRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<WorkloadRequest>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
		static_cast<TesterServerCoreActor*>(this)->actor_wait_state = 1;
															#line 945 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TesterServerCoreActor, 0, Void >*>(static_cast<TesterServerCoreActor*>(this)));
															#line 946 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TesterServerCoreActor, 1, Void >*>(static_cast<TesterServerCoreActor*>(this)));
															#line 952 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >*>(static_cast<TesterServerCoreActor*>(this)));
															#line 6461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 947 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(consistencyCheckerUrgentTester.first != 0);
															#line 948 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadEnd", interf.id()) .detail("ConsistencyCheckerId", consistencyCheckerUrgentTester.first);
															#line 950 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyCheckerUrgentTester = std::make_pair(0, Future<Void>());
															#line 6492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 947 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(consistencyCheckerUrgentTester.first != 0);
															#line 948 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadEnd", interf.id()) .detail("ConsistencyCheckerId", consistencyCheckerUrgentTester.first);
															#line 950 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyCheckerUrgentTester = std::make_pair(0, Future<Void>());
															#line 6505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(WorkloadRequest const& work,int loopDepth) 
	{
															#line 953 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (expectedWorkLoad.present() && expectedWorkLoad.get() != work.title)
															#line 6514 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 954 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "StartingTesterServerCoreUnexpectedWorkload", interf.id()) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount) .detail("ExpectedWorkLoad", expectedWorkLoad.get()) .detail("WorkLoad", work.title);
															#line 6518 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		else
		{
															#line 960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (work.title == "ConsistencyCheckUrgent")
															#line 6524 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 962 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (work.sharedRandomNumber == consistencyCheckerUrgentTester.first)
															#line 6528 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 965 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterDuplicatedRequest", interf.id()) .detail("ConsistencyCheckerId", work.sharedRandomNumber) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 969 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					work.reply.sendError(consistency_check_urgent_duplicate_request());
															#line 6534 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
				else
				{
															#line 975 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (consistencyCheckerUrgentTester.second.isValid() && !consistencyCheckerUrgentTester.second.isReady())
															#line 6540 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					{
															#line 977 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						TraceEvent(SevWarnAlways, "ConsistencyCheckUrgent_TesterWorkloadConflict", interf.id()) .detail("ExistingConsistencyCheckerId", consistencyCheckerUrgentTester.first) .detail("ArrivingConsistencyCheckerId", work.sharedRandomNumber) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 6544 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					}
															#line 983 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					consistencyCheckerUrgentTester = std::make_pair( work.sharedRandomNumber, testerServerConsistencyCheckerUrgentWorkload(work, ccr, dbInfo));
															#line 985 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadInitialized", interf.id()) .detail("ConsistencyCheckerId", consistencyCheckerUrgentTester.first) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 6550 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 991 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				addWorkload.send(testerServerWorkload(work, ccr, dbInfo, locality));
															#line 6557 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(WorkloadRequest && work,int loopDepth) 
	{
															#line 953 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (expectedWorkLoad.present() && expectedWorkLoad.get() != work.title)
															#line 6568 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 954 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "StartingTesterServerCoreUnexpectedWorkload", interf.id()) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount) .detail("ExpectedWorkLoad", expectedWorkLoad.get()) .detail("WorkLoad", work.title);
															#line 6572 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		else
		{
															#line 960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (work.title == "ConsistencyCheckUrgent")
															#line 6578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 962 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (work.sharedRandomNumber == consistencyCheckerUrgentTester.first)
															#line 6582 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 965 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevWarn, "ConsistencyCheckUrgent_TesterDuplicatedRequest", interf.id()) .detail("ConsistencyCheckerId", work.sharedRandomNumber) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 969 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					work.reply.sendError(consistency_check_urgent_duplicate_request());
															#line 6588 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
				else
				{
															#line 975 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (consistencyCheckerUrgentTester.second.isValid() && !consistencyCheckerUrgentTester.second.isReady())
															#line 6594 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					{
															#line 977 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						TraceEvent(SevWarnAlways, "ConsistencyCheckUrgent_TesterWorkloadConflict", interf.id()) .detail("ExistingConsistencyCheckerId", consistencyCheckerUrgentTester.first) .detail("ArrivingConsistencyCheckerId", work.sharedRandomNumber) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 6598 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					}
															#line 983 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					consistencyCheckerUrgentTester = std::make_pair( work.sharedRandomNumber, testerServerConsistencyCheckerUrgentWorkload(work, ccr, dbInfo));
															#line 985 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_TesterWorkloadInitialized", interf.id()) .detail("ConsistencyCheckerId", consistencyCheckerUrgentTester.first) .detail("ClientId", work.clientId) .detail("ClientCount", work.clientCount);
															#line 6604 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 991 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				addWorkload.send(testerServerWorkload(work, ccr, dbInfo, locality));
															#line 6611 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TesterServerCoreActor*>(this)->actor_wait_state > 0) static_cast<TesterServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<TesterServerCoreActor*>(this)->ActorCallback< TesterServerCoreActor, 0, Void >::remove();
		static_cast<TesterServerCoreActor*>(this)->ActorCallback< TesterServerCoreActor, 1, Void >::remove();
		static_cast<TesterServerCoreActor*>(this)->ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >::remove();

	}
	void a_callback_fire(ActorCallback< TesterServerCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TesterServerCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TesterServerCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TesterServerCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TesterServerCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TesterServerCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >*,WorkloadRequest const& value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >*,WorkloadRequest && value) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >*,Error err) 
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterInterface interf;
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<struct ServerDBInfo> const> dbInfo;
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	LocalityData locality;
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<std::string> expectedWorkLoad;
															#line 935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	PromiseStream<Future<Void>> addWorkload;
															#line 936 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Future<Void> workerFatalError;
															#line 940 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::pair<int64_t, Future<Void>> consistencyCheckerUrgentTester;
															#line 6813 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via testerServerCore()
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class TesterServerCoreActor final : public Actor<Void>, public ActorCallback< TesterServerCoreActor, 0, Void >, public ActorCallback< TesterServerCoreActor, 1, Void >, public ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >, public FastAllocated<TesterServerCoreActor>, public TesterServerCoreActorState<TesterServerCoreActor> {
															#line 6818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<TesterServerCoreActor>::operator new;
	using FastAllocated<TesterServerCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(320968115926279680UL, 11051060136445166848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TesterServerCoreActor, 0, Void >;
friend struct ActorCallback< TesterServerCoreActor, 1, Void >;
friend struct ActorSingleCallback< TesterServerCoreActor, 2, WorkloadRequest >;
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterServerCoreActor(TesterInterface const& interf,Reference<IClusterConnectionRecord> const& ccr,Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo,LocalityData const& locality,Optional<std::string> const& expectedWorkLoad) 
															#line 6837 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TesterServerCoreActorState<TesterServerCoreActor>(interf, ccr, dbInfo, locality, expectedWorkLoad),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testerServerCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4251760122969733632UL, 1427709497491200768UL);
		ActorExecutionContextHelper __helper(static_cast<TesterServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testerServerCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testerServerCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TesterServerCoreActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> testerServerCore( TesterInterface const& interf, Reference<IClusterConnectionRecord> const& ccr, Reference<AsyncVar<struct ServerDBInfo> const> const& dbInfo, LocalityData const& locality, Optional<std::string> const& expectedWorkLoad ) {
															#line 930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new TesterServerCoreActor(interf, ccr, dbInfo, locality, expectedWorkLoad));
															#line 6870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 996 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 6875 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clearData()
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class ClearDataActor>
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class ClearDataActorState {
															#line 6882 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ClearDataActorState(Database const& cx) 
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 998 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tr(cx)
															#line 6891 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearData", reinterpret_cast<unsigned long>(this));

	}
	~ClearDataActorState() 
	{
		fdb_probe_actor_destroy("clearData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1000 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 6906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearDataActorState();
		static_cast<ClearDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1021 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		tr = Transaction(cx);
															#line 1023 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 6931 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1002 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.debugTransaction(debugRandom()->randomUniqueID());
															#line 1003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(tr.trState->readOptions.present() && tr.trState->readOptions.get().debugID.present());
															#line 1004 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TesterClearingDatabaseStart", tr.trState->readOptions.get().debugID.get()).log();
															#line 1007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.clear(normalKeys);
															#line 1008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.makeSelfConflicting();
															#line 1009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 1009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 1;
															#line 1009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 0, Version >*>(static_cast<ClearDataActor*>(this)));
															#line 6965 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1016 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "TesterClearingDatabaseError", tr.trState->readOptions.get().debugID.get()).error(e);
															#line 1017 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 1017 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7004 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 3;
															#line 1017 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 2, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& rv,int loopDepth) 
	{
															#line 1010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingDatabaseRV", tr.trState->readOptions.get().debugID.get()).detail("RV", rv);
															#line 1011 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1011 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7028 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearDataActor*>(this)->actor_wait_state = 2;
															#line 1011 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 1, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7033 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && rv,int loopDepth) 
	{
															#line 1010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingDatabaseRV", tr.trState->readOptions.get().debugID.get()).detail("RV", rv);
															#line 1011 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1011 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7046 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearDataActor*>(this)->actor_wait_state = 2;
															#line 1011 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 1, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7051 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1012 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingDatabase", tr.trState->readOptions.get().debugID.get()) .detail("AtVersion", tr.getCommittedVersion());
															#line 7135 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1012 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterClearingDatabase", tr.trState->readOptions.get().debugID.get()) .detail("AtVersion", tr.getCommittedVersion());
															#line 7144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1046 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<ClearDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDataActorState(); static_cast<ClearDataActor*>(this)->destroy(); return 0; }
															#line 7315 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<ClearDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDataActorState();
		static_cast<ClearDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1025 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.debugTransaction(debugRandom()->randomUniqueID());
															#line 1026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1027 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<RangeResult> __when_expr_3 = tr.getRange(normalKeys, 1);
															#line 1027 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 4;
															#line 1027 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 3, RangeResult >*>(static_cast<ClearDataActor*>(this)));
															#line 7346 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1041 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "TesterCheckDatabaseClearedError", tr.trState->readOptions.get().debugID.get()) .error(e);
															#line 1043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ClearDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7385 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<ClearDataActor*>(this)->actor_wait_state = 5;
															#line 1043 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ClearDataActor, 4, Void >*>(static_cast<ClearDataActor*>(this)));
															#line 7390 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 1030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!rangeResult.empty())
															#line 7405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1031 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TesterClearFailure").detail("FirstKey", rangeResult[0].key);
															#line 1033 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(false);
															#line 7411 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1037 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(tr.trState->readOptions.present() && tr.trState->readOptions.get().debugID.present());
															#line 1038 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TesterCheckDatabaseClearedDone", tr.trState->readOptions.get().debugID.get());
															#line 7417 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& __rangeResult,int loopDepth) 
	{
															#line 1027 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		rangeResult = __rangeResult;
															#line 7426 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && __rangeResult,int loopDepth) 
	{
		rangeResult = std::move(__rangeResult);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClearDataActor*>(this)->actor_wait_state > 0) static_cast<ClearDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDataActor*>(this)->ActorCallback< ClearDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClearDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ClearDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 998 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 1027 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RangeResult rangeResult;
															#line 7594 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearData()
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class ClearDataActor final : public Actor<Void>, public ActorCallback< ClearDataActor, 0, Version >, public ActorCallback< ClearDataActor, 1, Void >, public ActorCallback< ClearDataActor, 2, Void >, public ActorCallback< ClearDataActor, 3, RangeResult >, public ActorCallback< ClearDataActor, 4, Void >, public FastAllocated<ClearDataActor>, public ClearDataActorState<ClearDataActor> {
															#line 7599 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearDataActor>::operator new;
	using FastAllocated<ClearDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(686410617461853440UL, 5521517750361572864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearDataActor, 0, Version >;
friend struct ActorCallback< ClearDataActor, 1, Void >;
friend struct ActorCallback< ClearDataActor, 2, Void >;
friend struct ActorCallback< ClearDataActor, 3, RangeResult >;
friend struct ActorCallback< ClearDataActor, 4, Void >;
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ClearDataActor(Database const& cx) 
															#line 7620 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearDataActorState<ClearDataActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5520910524537141504UL, 13876443903069959424UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearDataActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClearDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClearDataActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClearDataActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> clearData( Database const& cx ) {
															#line 997 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new ClearDataActor(cx));
															#line 7657 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

Future<Void> dumpDatabase(Database const& cx, std::string const& outputFilename, KeyRange const& range);

int passCount = 0;
int failCount = 0;

std::vector<PerfMetric> aggregateMetrics(std::vector<std::vector<PerfMetric>> metrics) {
	std::map<std::string, std::vector<PerfMetric>> metricMap;
	for (int i = 0; i < metrics.size(); i++) {
		std::vector<PerfMetric> workloadMetrics = metrics[i];
		TraceEvent("MetricsReturned").detail("Count", workloadMetrics.size());
		for (int m = 0; m < workloadMetrics.size(); m++) {
			printf("Metric (%d, %d): %s, %f, %s\n",
			       i,
			       m,
			       workloadMetrics[m].name().c_str(),
			       workloadMetrics[m].value(),
			       workloadMetrics[m].formatted().c_str());
			metricMap[workloadMetrics[m].name()].push_back(workloadMetrics[m]);
		}
	}
	TraceEvent("Metric")
	    .detail("Name", "Reporting Clients")
	    .detail("Value", (double)metrics.size())
	    .detail("Formatted", format("%d", metrics.size()).c_str());

	std::vector<PerfMetric> result;
	std::map<std::string, std::vector<PerfMetric>>::iterator it;
	for (it = metricMap.begin(); it != metricMap.end(); it++) {
		auto& vec = it->second;
		if (!vec.size())
			continue;
		double sum = 0;
		for (int i = 0; i < vec.size(); i++)
			sum += vec[i].value();
		if (vec[0].averaged() && vec.size())
			sum /= vec.size();
		result.emplace_back(vec[0].name(), sum, Averaged::False, vec[0].format_code());
	}
	return result;
}

void logMetrics(std::vector<PerfMetric> metrics) {
	for (int idx = 0; idx < metrics.size(); idx++)
		TraceEvent("Metric")
		    .detail("Name", metrics[idx].name())
		    .detail("Value", metrics[idx].value())
		    .detail("Formatted", format(metrics[idx].format_code().c_str(), metrics[idx].value()));
}

template <class T>
void throwIfError(const std::vector<Future<ErrorOr<T>>>& futures, std::string errorMsg) {
	for (auto& future : futures) {
		if (future.get().isError()) {
			TraceEvent(SevError, errorMsg.c_str()).error(future.get().getError());
			throw future.get().getError();
		}
	}
}

struct TesterConsistencyScanState {
	bool enabled = false;
	bool enableAfter = false;
	bool waitForComplete = false;
};

															#line 7727 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkConsistencyScanAfterTest()
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class CheckConsistencyScanAfterTestActor>
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class CheckConsistencyScanAfterTestActorState {
															#line 7734 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CheckConsistencyScanAfterTestActorState(Database const& cx,TesterConsistencyScanState* const& csState) 
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   csState(csState)
															#line 7743 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this));

	}
	~CheckConsistencyScanAfterTestActorState() 
	{
		fdb_probe_actor_destroy("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1115 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!csState->enabled)
															#line 7758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1116 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyScanAfterTestActorState(); static_cast<CheckConsistencyScanAfterTestActor*>(this)->destroy(); return 0; }
															#line 7762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				new (&static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckConsistencyScanAfterTestActorState();
				static_cast<CheckConsistencyScanAfterTestActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1120 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			csState->enabled = false;
															#line 1122 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (csState->enableAfter || csState->waitForComplete)
															#line 7772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1123 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				printf("Enabling consistency scan after test ...\n");
															#line 1124 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = enableConsistencyScanInSim(cx);
															#line 1124 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7780 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state = 1;
															#line 1124 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*>(static_cast<CheckConsistencyScanAfterTestActor*>(this)));
															#line 7785 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckConsistencyScanAfterTestActorState();
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1128 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = disableConsistencyScanInSim(cx, csState->waitForComplete);
															#line 1128 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7815 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state = 2;
															#line 1128 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*>(static_cast<CheckConsistencyScanAfterTestActor*>(this)));
															#line 7820 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1125 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Enabled consistency scan after test.\n");
															#line 7829 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1125 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Enabled consistency scan after test.\n");
															#line 7838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1130 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyScanAfterTestActorState(); static_cast<CheckConsistencyScanAfterTestActor*>(this)->destroy(); return 0; }
															#line 7922 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckConsistencyScanAfterTestActorState();
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1130 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyScanAfterTestActorState(); static_cast<CheckConsistencyScanAfterTestActor*>(this)->destroy(); return 0; }
															#line 7934 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<CheckConsistencyScanAfterTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckConsistencyScanAfterTestActorState();
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyScanAfterTestActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyScanAfterTestActor*>(this)->ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterConsistencyScanState* csState;
															#line 8021 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkConsistencyScanAfterTest()
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class CheckConsistencyScanAfterTestActor final : public Actor<Void>, public ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >, public ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >, public FastAllocated<CheckConsistencyScanAfterTestActor>, public CheckConsistencyScanAfterTestActorState<CheckConsistencyScanAfterTestActor> {
															#line 8026 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckConsistencyScanAfterTestActor>::operator new;
	using FastAllocated<CheckConsistencyScanAfterTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8964474476540557568UL, 17158572312912042240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >;
friend struct ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >;
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CheckConsistencyScanAfterTestActor(Database const& cx,TesterConsistencyScanState* const& csState) 
															#line 8044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckConsistencyScanAfterTestActorState<CheckConsistencyScanAfterTestActor>(cx, csState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2578644973355073280UL, 10560269047676019712UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyScanAfterTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkConsistencyScanAfterTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkConsistencyScanAfterTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckConsistencyScanAfterTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckConsistencyScanAfterTestActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> checkConsistencyScanAfterTest( Database const& cx, TesterConsistencyScanState* const& csState ) {
															#line 1114 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new CheckConsistencyScanAfterTestActor(cx, csState));
															#line 8078 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1132 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 8083 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runWorkload()
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunWorkloadActor>
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunWorkloadActorState {
															#line 8090 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunWorkloadActorState(Database const& cx,std::vector<TesterInterface> const& testers,TestSpec const& spec) 
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   spec(spec)
															#line 8101 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runWorkload", reinterpret_cast<unsigned long>(this));

	}
	~RunWorkloadActorState() 
	{
		fdb_probe_actor_destroy("runWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1134 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestRunning") .detail("WorkloadTitle", spec.title) .detail("TesterCount", testers.size()) .detail("Phases", spec.phases) .detail("TestTimeout", spec.timeout);
															#line 1140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workRequests = std::vector<Future<WorkloadInterface>>();
															#line 1141 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricsResults = std::vector<std::vector<PerfMetric>>();
															#line 1143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			i = 0;
															#line 1144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			success = 0;
															#line 1145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			failure = 0;
															#line 1146 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			int64_t sharedRandom = deterministicRandom()->randomInt64(0, 10000000);
															#line 1147 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(;i < testers.size();i++) {
															#line 1148 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				WorkloadRequest req;
															#line 1149 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.title = spec.title;
															#line 1150 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.useDatabase = spec.useDB;
															#line 1151 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.runFailureWorkloads = spec.runFailureWorkloads;
															#line 1152 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.timeout = spec.timeout;
															#line 1153 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.databasePingDelay = spec.useDB ? spec.databasePingDelay : 0.0;
															#line 1154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.options = spec.options;
															#line 1155 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.clientId = i;
															#line 1156 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.clientCount = testers.size();
															#line 1157 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.sharedRandomNumber = sharedRandom;
															#line 1158 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.disabledFailureInjectionWorkloads = spec.disabledFailureInjectionWorkloads;
															#line 1159 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				workRequests.push_back(testers[i].recruitments.getReply(req));
															#line 8154 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<std::vector<WorkloadInterface>> __when_expr_0 = getAll(workRequests);
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8160 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunWorkloadActor*>(this)->actor_wait_state = 1;
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*>(static_cast<RunWorkloadActor*>(this)));
															#line 8165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunWorkloadActorState();
		static_cast<RunWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		waitForFailureTime = g_network->isSimulated() ? 24 * 60 * 60 : 60;
															#line 1164 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && spec.simCheckRelocationDuration)
															#line 8190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			debug_setCheckRelocationDuration(true);
															#line 8194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.phases & TestWorkload::SETUP)
															#line 8198 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			setups = std::vector<Future<ErrorOr<Void>>>();
															#line 1169 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("setting up test (%s)...\n", printable(spec.title).c_str());
															#line 1170 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestSetupStart").detail("WorkloadTitle", spec.title);
															#line 1171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			setups.reserve(workloads.size());
															#line 1172 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < workloads.size();i++) {
															#line 1173 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				setups.push_back(workloads[i].setup.template getReplyUnlessFailedFor<Void>(waitForFailureTime, 0));
															#line 8212 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAll(setups);
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunWorkloadActor*>(this)->actor_wait_state = 2;
															#line 1174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 1, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 8223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkloadInterface> const& __workloads,int loopDepth) 
	{
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		workloads = __workloads;
															#line 8237 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkloadInterface> && __workloads,int loopDepth) 
	{
		workloads = std::move(__workloads);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*,std::vector<WorkloadInterface> const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*,std::vector<WorkloadInterface> && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.phases & TestWorkload::EXECUTION)
															#line 8316 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestStarting").detail("WorkloadTitle", spec.title);
															#line 1181 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("running test (%s)...\n", printable(spec.title).c_str());
															#line 1182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			starts = std::vector<Future<ErrorOr<Void>>>();
															#line 1183 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			starts.reserve(workloads.size());
															#line 1184 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < workloads.size();i++) {
															#line 1185 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				starts.push_back(workloads[i].start.template getReplyUnlessFailedFor<Void>(waitForFailureTime, 0));
															#line 8330 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = waitForAll(starts);
															#line 1186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8336 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunWorkloadActor*>(this)->actor_wait_state = 3;
															#line 1186 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 2, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 8341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(setups, "SetupFailedForWorkload" + printable(spec.title));
															#line 1176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupComplete").detail("WorkloadTitle", spec.title);
															#line 8357 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(setups, "SetupFailedForWorkload" + printable(spec.title));
															#line 1176 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestSetupComplete").detail("WorkloadTitle", spec.title);
															#line 8368 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 1192 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.phases & TestWorkload::CHECK)
															#line 8452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1193 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (spec.useDB && (spec.phases & TestWorkload::EXECUTION))
															#line 8456 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(3.0);
															#line 1194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8462 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
				static_cast<RunWorkloadActor*>(this)->actor_wait_state = 4;
															#line 1194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 3, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 8467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont13(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 1187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(starts, "StartFailedForWorkload" + printable(spec.title));
															#line 1188 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("%s complete\n", printable(spec.title).c_str());
															#line 1189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestComplete").detail("WorkloadTitle", spec.title);
															#line 8490 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 1187 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(starts, "StartFailedForWorkload" + printable(spec.title));
															#line 1188 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("%s complete\n", printable(spec.title).c_str());
															#line 1189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestComplete").detail("WorkloadTitle", spec.title);
															#line 8503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 1218 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.phases & TestWorkload::METRICS)
															#line 8587 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricTasks = std::vector<Future<ErrorOr<std::vector<PerfMetric>>>>();
															#line 1220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("fetching metrics (%s)...\n", printable(spec.title).c_str());
															#line 1221 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TestFetchingMetrics").detail("WorkloadTitle", spec.title);
															#line 1222 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricTasks.reserve(workloads.size());
															#line 1223 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < workloads.size();i++) {
															#line 1224 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				metricTasks.push_back( workloads[i].metrics.template getReplyUnlessFailedFor<std::vector<PerfMetric>>(waitForFailureTime, 0));
															#line 8601 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_5 = waitForAll(metricTasks);
															#line 1226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8607 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
			static_cast<RunWorkloadActor*>(this)->actor_wait_state = 6;
															#line 1226 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 5, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 8612 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 1197 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checks = std::vector<Future<ErrorOr<CheckReply>>>();
															#line 1198 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestCheckingResults").detail("WorkloadTitle", spec.title);
															#line 1200 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("checking test (%s)...\n", printable(spec.title).c_str());
															#line 1202 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		checks.reserve(workloads.size());
															#line 1203 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workloads.size();i++) {
															#line 1204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			checks.push_back(workloads[i].check.template getReplyUnlessFailedFor<CheckReply>(waitForFailureTime, 0));
															#line 8636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(checks);
															#line 1205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8642 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont13when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunWorkloadActor*>(this)->actor_wait_state = 5;
															#line 1205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunWorkloadActor, 4, Void >*>(static_cast<RunWorkloadActor*>(this)));
															#line 8647 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13cont1(Void const& _,int loopDepth) 
	{
															#line 1207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(checks, "CheckFailedForWorkload" + printable(spec.title));
															#line 1209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < checks.size();i++) {
															#line 1210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (checks[i].get().get().value)
															#line 8747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1211 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				success++;
															#line 8751 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1213 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				failure++;
															#line 8757 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 1215 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestCheckComplete").detail("WorkloadTitle", spec.title);
															#line 8762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1(Void && _,int loopDepth) 
	{
															#line 1207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(checks, "CheckFailedForWorkload" + printable(spec.title));
															#line 1209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < checks.size();i++) {
															#line 1210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (checks[i].get().get().value)
															#line 8775 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1211 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				success++;
															#line 8779 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1213 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				failure++;
															#line 8785 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 1215 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestCheckComplete").detail("WorkloadTitle", spec.title);
															#line 8790 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workloads.size();i++) {
															#line 1236 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workloads[i].stop.send(ReplyPromise<Void>());
															#line 8876 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1238 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunWorkloadActor*>(this)->SAV<DistributedTestResults>::futures) { (void)(DistributedTestResults(aggregateMetrics(metricsResults), success, failure)); this->~RunWorkloadActorState(); static_cast<RunWorkloadActor*>(this)->destroy(); return 0; }
															#line 8880 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<RunWorkloadActor*>(this)->SAV< DistributedTestResults >::value()) DistributedTestResults(DistributedTestResults(aggregateMetrics(metricsResults), success, failure));
		this->~RunWorkloadActorState();
		static_cast<RunWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 1227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(metricTasks, "MetricFailedForWorkload" + printable(spec.title));
															#line 1228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < metricTasks.size();i++) {
															#line 1229 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricsResults.push_back(metricTasks[i].get().get());
															#line 8896 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 1227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		throwIfError(metricTasks, "MetricFailedForWorkload" + printable(spec.title));
															#line 1228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < metricTasks.size();i++) {
															#line 1229 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			metricsResults.push_back(metricTasks[i].get().get());
															#line 8910 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunWorkloadActor*>(this)->ActorCallback< RunWorkloadActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunWorkloadActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunWorkloadActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestSpec spec;
															#line 1140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<WorkloadInterface>> workRequests;
															#line 1141 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<std::vector<PerfMetric>> metricsResults;
															#line 1143 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int i;
															#line 1144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int success;
															#line 1145 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int failure;
															#line 1162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<WorkloadInterface> workloads;
															#line 1163 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double waitForFailureTime;
															#line 1168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> setups;
															#line 1182 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> starts;
															#line 1197 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<CheckReply>>> checks;
															#line 1219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<std::vector<PerfMetric>>>> metricTasks;
															#line 9019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runWorkload()
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunWorkloadActor final : public Actor<DistributedTestResults>, public ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >, public ActorCallback< RunWorkloadActor, 1, Void >, public ActorCallback< RunWorkloadActor, 2, Void >, public ActorCallback< RunWorkloadActor, 3, Void >, public ActorCallback< RunWorkloadActor, 4, Void >, public ActorCallback< RunWorkloadActor, 5, Void >, public FastAllocated<RunWorkloadActor>, public RunWorkloadActorState<RunWorkloadActor> {
															#line 9024 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunWorkloadActor>::operator new;
	using FastAllocated<RunWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12239763372735018752UL, 3784580918639820544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<DistributedTestResults>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >;
friend struct ActorCallback< RunWorkloadActor, 1, Void >;
friend struct ActorCallback< RunWorkloadActor, 2, Void >;
friend struct ActorCallback< RunWorkloadActor, 3, Void >;
friend struct ActorCallback< RunWorkloadActor, 4, Void >;
friend struct ActorCallback< RunWorkloadActor, 5, Void >;
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunWorkloadActor(Database const& cx,std::vector<TesterInterface> const& testers,TestSpec const& spec) 
															#line 9046 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<DistributedTestResults>(),
		   RunWorkloadActorState<RunWorkloadActor>(cx, testers, spec),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1693389394735498752UL, 3664295469201664512UL);
		ActorExecutionContextHelper __helper(static_cast<RunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunWorkloadActor, 0, std::vector<WorkloadInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunWorkloadActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunWorkloadActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunWorkloadActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunWorkloadActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunWorkloadActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<DistributedTestResults> runWorkload( Database const& cx, std::vector<TesterInterface> const& testers, TestSpec const& spec ) {
															#line 1133 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<DistributedTestResults>(new RunWorkloadActor(cx, testers, spec));
															#line 9084 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1240 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

// Sets the database configuration by running the ChangeConfig workload
															#line 9090 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via changeConfiguration()
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class ChangeConfigurationActor>
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class ChangeConfigurationActorState {
															#line 9097 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ChangeConfigurationActorState(Database const& cx,std::vector<TesterInterface> const& testers,StringRef const& configMode) 
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   configMode(configMode),
															#line 1243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   spec()
															#line 9110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("changeConfiguration", reinterpret_cast<unsigned long>(this));

	}
	~ChangeConfigurationActorState() 
	{
		fdb_probe_actor_destroy("changeConfiguration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1244 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Standalone<VectorRef<KeyValueRef>> options;
															#line 1245 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.title = "ChangeConfig"_sr;
															#line 1246 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.runFailureWorkloads = false;
															#line 1247 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("testName"_sr, "ChangeConfig"_sr));
															#line 1248 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("configMode"_sr, configMode));
															#line 1249 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.options.push_back_deep(spec.options.arena(), options);
															#line 1251 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<DistributedTestResults> __when_expr_0 = runWorkload(cx, testers, spec);
															#line 1251 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<ChangeConfigurationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9139 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeConfigurationActor*>(this)->actor_wait_state = 1;
															#line 1251 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*>(static_cast<ChangeConfigurationActor*>(this)));
															#line 9144 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeConfigurationActorState();
		static_cast<ChangeConfigurationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DistributedTestResults const& testResults,int loopDepth) 
	{
															#line 1253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<ChangeConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeConfigurationActorState(); static_cast<ChangeConfigurationActor*>(this)->destroy(); return 0; }
															#line 9167 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<ChangeConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeConfigurationActorState();
		static_cast<ChangeConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(DistributedTestResults && testResults,int loopDepth) 
	{
															#line 1253 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<ChangeConfigurationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeConfigurationActorState(); static_cast<ChangeConfigurationActor*>(this)->destroy(); return 0; }
															#line 9179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<ChangeConfigurationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeConfigurationActorState();
		static_cast<ChangeConfigurationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(DistributedTestResults const& testResults,int loopDepth) 
	{
		loopDepth = a_body1cont1(testResults, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributedTestResults && testResults,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(testResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeConfigurationActor*>(this)->actor_wait_state > 0) static_cast<ChangeConfigurationActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeConfigurationActor*>(this)->ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*,DistributedTestResults const& value) 
	{
		fdb_probe_actor_enter("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*,DistributedTestResults && value) 
	{
		fdb_probe_actor_enter("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*,Error err) 
	{
		fdb_probe_actor_enter("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeConfiguration", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	StringRef configMode;
															#line 1243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestSpec spec;
															#line 9270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via changeConfiguration()
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class ChangeConfigurationActor final : public Actor<Void>, public ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >, public FastAllocated<ChangeConfigurationActor>, public ChangeConfigurationActorState<ChangeConfigurationActor> {
															#line 9275 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<ChangeConfigurationActor>::operator new;
	using FastAllocated<ChangeConfigurationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16885760372393571584UL, 10385623263533945344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >;
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	ChangeConfigurationActor(Database const& cx,std::vector<TesterInterface> const& testers,StringRef const& configMode) 
															#line 9292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ChangeConfigurationActorState<ChangeConfigurationActor>(cx, testers, configMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeConfiguration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10067441070874341888UL, 15153484123940199936UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeConfigurationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeConfiguration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeConfiguration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeConfigurationActor, 0, DistributedTestResults >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> changeConfiguration( Database const& cx, std::vector<TesterInterface> const& testers, StringRef const& configMode ) {
															#line 1242 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new ChangeConfigurationActor(cx, testers, configMode));
															#line 9325 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1255 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 9330 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via auditStorageCorrectness()
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class AuditStorageCorrectnessActor>
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class AuditStorageCorrectnessActorState {
															#line 9337 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	AuditStorageCorrectnessActorState(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,AuditType const& auditType) 
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : dbInfo(dbInfo),
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   auditType(auditType)
															#line 9346 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("auditStorageCorrectness", reinterpret_cast<unsigned long>(this));

	}
	~AuditStorageCorrectnessActorState() 
	{
		fdb_probe_actor_destroy("auditStorageCorrectness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1257 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (SERVER_KNOBS->DISABLE_AUDIT_STORAGE_FINAL_REPLICA_CHECK_IN_SIM && (auditType == AuditType::ValidateHA || auditType == AuditType::ValidateReplica))
															#line 9361 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1259 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!static_cast<AuditStorageCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageCorrectnessActorState(); static_cast<AuditStorageCorrectnessActor*>(this)->destroy(); return 0; }
															#line 9365 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				new (&static_cast<AuditStorageCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~AuditStorageCorrectnessActorState();
				static_cast<AuditStorageCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1261 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevDebug, "AuditStorageCorrectnessBegin").detail("AuditType", auditType);
															#line 1262 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx = Database();
															#line 1263 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auditId = UID();
															#line 1264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auditState = AuditStorageState();
															#line 1265 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 9381 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditStorageCorrectnessActorState();
		static_cast<AuditStorageCorrectnessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryCount = 0;
															#line 1287 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 9406 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1267 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 9423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1279 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevWarn, "AuditStorageCorrectnessTriggerError") .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 1283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1);
															#line 1283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9462 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 3;
															#line 1283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 2, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 9467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1271 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TriggerAuditRequest req(auditType, allKeys, KeyValueStoreType::END);
															#line 1272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<UID> __when_expr_1 = timeoutError(dbInfo->get().distributor.get().triggerAudit.getReply(req), 300);
															#line 1272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 2;
															#line 1272 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 1, UID >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 9491 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1267 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!(dbInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !dbInfo->get().distributor.present()))
															#line 9507 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_0 = dbInfo->onChange();
															#line 1269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9515 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 1;
															#line 1269 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 0, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 9520 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(UID const& auditId_,int loopDepth) 
	{
															#line 1273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auditId = auditId_;
															#line 1274 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevDebug, "AuditStorageCorrectnessTriggered") .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 9631 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(UID && auditId_,int loopDepth) 
	{
															#line 1273 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auditId = auditId_;
															#line 1274 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevDebug, "AuditStorageCorrectnessTriggered") .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 9642 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(UID const& auditId_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(auditId_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(UID && auditId_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(auditId_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessWaitEnd") .detail("AuditID", auditId) .detail("AuditType", auditType) .detail("AuditState", auditState.toString());
															#line 1329 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<AuditStorageCorrectnessActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AuditStorageCorrectnessActorState(); static_cast<AuditStorageCorrectnessActor*>(this)->destroy(); return 0; }
															#line 9815 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<AuditStorageCorrectnessActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AuditStorageCorrectnessActorState();
		static_cast<AuditStorageCorrectnessActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1289 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx = openDBOnServer(dbInfo);
															#line 1290 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<AuditStorageState> __when_expr_3 = getAuditState(cx, auditType, auditId);
															#line 1290 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 4;
															#line 1290 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 9844 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1316 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("AuditStorageCorrectnessWaitError") .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("AuditType", auditType) .detail("AuditState", auditState.toString());
															#line 1321 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_5 = delay(1);
															#line 1321 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9883 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 6;
															#line 1321 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 5, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 9888 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(AuditStorageState const& auditState_,int loopDepth) 
	{
															#line 1291 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auditState = auditState_;
															#line 1292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (auditState.getPhase() == AuditPhase::Complete)
															#line 9905 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1294 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 9913 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1295 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("AuditStorageCorrectnessWait") .detail("AuditID", auditId) .detail("AuditType", auditType) .detail("RetryCount", retryCount);
															#line 1299 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(25);
															#line 1299 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
				static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 5;
															#line 1299 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 4, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 9926 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1308 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Error)
															#line 9933 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
					return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 1310 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Failed)
															#line 9941 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					{
						return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
					}
					else
					{
															#line 1313 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						UNREACHABLE();
															#line 9949 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(AuditStorageState && auditState_,int loopDepth) 
	{
															#line 1291 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auditState = auditState_;
															#line 1292 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (auditState.getPhase() == AuditPhase::Complete)
															#line 9964 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1294 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 9972 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1295 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("AuditStorageCorrectnessWait") .detail("AuditID", auditId) .detail("AuditType", auditType) .detail("RetryCount", retryCount);
															#line 1299 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(25);
															#line 1299 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
				static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 5;
															#line 1299 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCorrectnessActor, 4, Void >*>(static_cast<AuditStorageCorrectnessActor*>(this)));
															#line 9985 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 1308 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Error)
															#line 9992 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
					return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 1310 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Failed)
															#line 10000 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					{
						return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
					}
					else
					{
															#line 1313 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						UNREACHABLE();
															#line 10008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					}
				}
				loopDepth = a_body1cont1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(AuditStorageState const& auditState_,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(auditState_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(AuditStorageState && auditState_,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(auditState_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*,AuditStorageState const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*,AuditStorageState && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (retryCount > 20)
															#line 10108 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1301 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("AuditStorageCorrectnessWaitFailed") .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 10112 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1306 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryCount++;
															#line 10117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1300 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (retryCount > 20)
															#line 10126 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1301 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("AuditStorageCorrectnessWaitFailed") .detail("AuditID", auditId) .detail("AuditType", auditType);
															#line 10130 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1306 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryCount++;
															#line 10135 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCorrectnessActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCorrectnessActor*>(this)->ActorCallback< AuditStorageCorrectnessActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< AuditStorageCorrectnessActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< AuditStorageCorrectnessActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	AuditType auditType;
															#line 1262 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1263 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	UID auditId;
															#line 1264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	AuditStorageState auditState;
															#line 1286 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int retryCount;
															#line 10327 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via auditStorageCorrectness()
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class AuditStorageCorrectnessActor final : public Actor<Void>, public ActorCallback< AuditStorageCorrectnessActor, 0, Void >, public ActorCallback< AuditStorageCorrectnessActor, 1, UID >, public ActorCallback< AuditStorageCorrectnessActor, 2, Void >, public ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >, public ActorCallback< AuditStorageCorrectnessActor, 4, Void >, public ActorCallback< AuditStorageCorrectnessActor, 5, Void >, public FastAllocated<AuditStorageCorrectnessActor>, public AuditStorageCorrectnessActorState<AuditStorageCorrectnessActor> {
															#line 10332 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<AuditStorageCorrectnessActor>::operator new;
	using FastAllocated<AuditStorageCorrectnessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17843071658993978880UL, 11119433406192311040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditStorageCorrectnessActor, 0, Void >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 1, UID >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 2, Void >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 4, Void >;
friend struct ActorCallback< AuditStorageCorrectnessActor, 5, Void >;
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	AuditStorageCorrectnessActor(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,AuditType const& auditType) 
															#line 10354 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AuditStorageCorrectnessActorState<AuditStorageCorrectnessActor>(dbInfo, auditType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9031458630016760320UL, 3311672436545492736UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCorrectnessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditStorageCorrectness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditStorageCorrectness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 1, UID >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 3, AuditStorageState >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< AuditStorageCorrectnessActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> auditStorageCorrectness( Reference<AsyncVar<ServerDBInfo>> const& dbInfo, AuditType const& auditType ) {
															#line 1256 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new AuditStorageCorrectnessActor(dbInfo, auditType));
															#line 10392 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1331 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

// Runs the consistency check workload, which verifies that the database is in a consistent state
															#line 10398 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkConsistency()
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class CheckConsistencyActor>
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class CheckConsistencyActorState {
															#line 10405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CheckConsistencyActorState(Database const& cx,std::vector<TesterInterface> const& testers,bool const& doQuiescentCheck,bool const& doTSSCheck,double const& maxDDRunTime,double const& softTimeLimit,double const& databasePingDelay,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   doQuiescentCheck(doQuiescentCheck),
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   doTSSCheck(doTSSCheck),
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   maxDDRunTime(maxDDRunTime),
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   softTimeLimit(softTimeLimit),
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   databasePingDelay(databasePingDelay),
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 1341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   spec(),
															#line 1343 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   connectionFailures()
															#line 10430 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkConsistency", reinterpret_cast<unsigned long>(this));

	}
	~CheckConsistencyActorState() 
	{
		fdb_probe_actor_destroy("checkConsistency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1344 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 10445 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1346 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				connectionFailures = g_simulator->connectionFailuresDisableDuration;
															#line 1347 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				disableConnectionFailures("ConsistencyCheck");
															#line 1348 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->isConsistencyChecked = true;
															#line 10453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1351 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Standalone<VectorRef<KeyValueRef>> options;
															#line 1352 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StringRef performQuiescent = "false"_sr;
															#line 1353 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StringRef performTSSCheck = "false"_sr;
															#line 1354 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (doQuiescentCheck)
															#line 10463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1355 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				performQuiescent = "true"_sr;
															#line 1356 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				spec.restorePerpetualWiggleSetting = false;
															#line 10469 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1358 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (doTSSCheck)
															#line 10473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1359 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				performTSSCheck = "true"_sr;
															#line 10477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1361 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.title = "ConsistencyCheck"_sr;
															#line 1362 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.databasePingDelay = databasePingDelay;
															#line 1363 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.runFailureWorkloads = false;
															#line 1364 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.timeout = 32000;
															#line 1365 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("testName"_sr, "ConsistencyCheck"_sr));
															#line 1366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("performQuiescentChecks"_sr, performQuiescent));
															#line 1367 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("performTSSCheck"_sr, performTSSCheck));
															#line 1368 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("maxDDRunTime"_sr, ValueRef(options.arena(), format("%f", maxDDRunTime))));
															#line 1370 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), KeyValueRef("distributed"_sr, "false"_sr));
															#line 1371 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.options.push_back_deep(spec.options.arena(), options);
															#line 1373 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			start = now();
															#line 1374 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			lastRun = false;
															#line 1375 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 10505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckConsistencyActorState();
		static_cast<CheckConsistencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1376 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<DistributedTestResults> __when_expr_0 = runWorkload(cx, testers, spec);
															#line 1376 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10537 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 1;
															#line 1376 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*>(static_cast<CheckConsistencyActor*>(this)));
															#line 10542 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(DistributedTestResults const& testResults,int loopDepth) 
	{
															#line 1377 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (testResults.ok() || lastRun)
															#line 10551 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 10555 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1379 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->connectionFailuresDisableDuration = connectionFailures;
															#line 1380 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->isConsistencyChecked = false;
															#line 10561 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!static_cast<CheckConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyActorState(); static_cast<CheckConsistencyActor*>(this)->destroy(); return 0; }
															#line 10565 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			new (&static_cast<CheckConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckConsistencyActorState();
			static_cast<CheckConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (now() - start > softTimeLimit)
															#line 10573 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1385 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.options[0].push_back_deep(spec.options.arena(), KeyValueRef("failureIsError"_sr, "true"_sr));
															#line 1386 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			lastRun = true;
															#line 10579 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1389 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = repairDeadDatacenter(cx, dbInfo, "ConsistencyCheck");
															#line 1389 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10585 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 2;
															#line 1389 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyActor, 1, Void >*>(static_cast<CheckConsistencyActor*>(this)));
															#line 10590 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(DistributedTestResults && testResults,int loopDepth) 
	{
															#line 1377 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (testResults.ok() || lastRun)
															#line 10599 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1378 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 10603 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1379 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->connectionFailuresDisableDuration = connectionFailures;
															#line 1380 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->isConsistencyChecked = false;
															#line 10609 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!static_cast<CheckConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckConsistencyActorState(); static_cast<CheckConsistencyActor*>(this)->destroy(); return 0; }
															#line 10613 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			new (&static_cast<CheckConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckConsistencyActorState();
			static_cast<CheckConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1384 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (now() - start > softTimeLimit)
															#line 10621 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1385 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			spec.options[0].push_back_deep(spec.options.arena(), KeyValueRef("failureIsError"_sr, "true"_sr));
															#line 1386 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			lastRun = true;
															#line 10627 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1389 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = repairDeadDatacenter(cx, dbInfo, "ConsistencyCheck");
															#line 1389 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10633 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 2;
															#line 1389 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckConsistencyActor, 1, Void >*>(static_cast<CheckConsistencyActor*>(this)));
															#line 10638 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(DistributedTestResults const& testResults,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(testResults, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(DistributedTestResults && testResults,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(testResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyActor*>(this)->ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*,DistributedTestResults const& value) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*,DistributedTestResults && value) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckConsistencyActor*>(this)->ActorCallback< CheckConsistencyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckConsistencyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckConsistencyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckConsistencyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool doQuiescentCheck;
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool doTSSCheck;
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double maxDDRunTime;
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double softTimeLimit;
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double databasePingDelay;
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 1341 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestSpec spec;
															#line 1343 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double connectionFailures;
															#line 1373 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double start;
															#line 1374 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool lastRun;
															#line 10829 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkConsistency()
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class CheckConsistencyActor final : public Actor<Void>, public ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >, public ActorCallback< CheckConsistencyActor, 1, Void >, public FastAllocated<CheckConsistencyActor>, public CheckConsistencyActorState<CheckConsistencyActor> {
															#line 10834 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckConsistencyActor>::operator new;
	using FastAllocated<CheckConsistencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16890688065616090880UL, 9708699499666655744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >;
friend struct ActorCallback< CheckConsistencyActor, 1, Void >;
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	CheckConsistencyActor(Database const& cx,std::vector<TesterInterface> const& testers,bool const& doQuiescentCheck,bool const& doTSSCheck,double const& maxDDRunTime,double const& softTimeLimit,double const& databasePingDelay,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 10852 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckConsistencyActorState<CheckConsistencyActor>(cx, testers, doQuiescentCheck, doTSSCheck, maxDDRunTime, softTimeLimit, databasePingDelay, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkConsistency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5013688168915807232UL, 8279475379598191872UL);
		ActorExecutionContextHelper __helper(static_cast<CheckConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkConsistency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkConsistency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckConsistencyActor, 0, DistributedTestResults >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckConsistencyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> checkConsistency( Database const& cx, std::vector<TesterInterface> const& testers, bool const& doQuiescentCheck, bool const& doTSSCheck, double const& maxDDRunTime, double const& softTimeLimit, double const& databasePingDelay, Reference<AsyncVar<ServerDBInfo>> const& dbInfo ) {
															#line 1333 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new CheckConsistencyActor(cx, testers, doQuiescentCheck, doTSSCheck, maxDDRunTime, softTimeLimit, databasePingDelay, dbInfo));
															#line 10886 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1392 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 10891 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runUrgentConsistencyCheckWorkload()
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunUrgentConsistencyCheckWorkloadActor>
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunUrgentConsistencyCheckWorkloadActorState {
															#line 10898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunUrgentConsistencyCheckWorkloadActorState(Database const& cx,std::vector<TesterInterface> const& testers,int64_t const& consistencyCheckerId,std::unordered_map<int, std::vector<KeyRange>> const& assignment) 
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   consistencyCheckerId(consistencyCheckerId),
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   assignment(assignment)
															#line 10911 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this));

	}
	~RunUrgentConsistencyCheckWorkloadActorState() 
	{
		fdb_probe_actor_destroy("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1398 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_DispatchWorkloads") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1403 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workRequests = std::vector<Future<ErrorOr<WorkloadInterface>>>();
															#line 1404 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Standalone<VectorRef<KeyValueRef>> option;
															#line 1405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			option.push_back_deep(option.arena(), KeyValueRef("testName"_sr, "ConsistencyCheckUrgent"_sr));
															#line 1406 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Standalone<VectorRef<VectorRef<KeyValueRef>>> options;
															#line 1407 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			options.push_back_deep(options.arena(), option);
															#line 1408 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < testers.size();i++) {
															#line 1409 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				WorkloadRequest req;
															#line 1410 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.title = "ConsistencyCheckUrgent"_sr;
															#line 1411 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.useDatabase = true;
															#line 1412 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.timeout = 0.0;
															#line 1413 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.databasePingDelay = 0.0;
															#line 1414 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.options = options;
															#line 1415 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.clientId = i;
															#line 1416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.clientCount = testers.size();
															#line 1417 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.sharedRandomNumber = consistencyCheckerId;
															#line 1418 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				req.rangesToCheck = assignment[i];
															#line 1419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				workRequests.push_back(testers[i].recruitments.getReplyUnlessFailedFor(req, 10, 0));
															#line 10960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(workRequests);
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10966 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 1;
															#line 1422 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*>(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)));
															#line 10971 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunUrgentConsistencyCheckWorkloadActorState();
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1425 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TriggerWorkloads") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1428 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		completeClientIds = std::unordered_set<int>();
															#line 1429 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		clientIds = std::vector<int>();
															#line 1430 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobs = std::vector<Future<ErrorOr<Void>>>();
															#line 1431 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workRequests.size();i++) {
															#line 1432 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(workRequests[i].isReady());
															#line 1433 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (workRequests[i].get().isError())
															#line 11006 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1434 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_FailedToContactTester") .error(workRequests[i].get().getError()) .detail("TesterCount", testers.size()) .detail("TesterId", i) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1440 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				jobs.push_back(workRequests[i].get().get().start.template getReplyUnlessFailedFor<Void>(10, 0));
															#line 1441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				clientIds.push_back(i);
															#line 11018 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 1444 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(jobs);
															#line 1444 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11025 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 2;
															#line 1444 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*>(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)));
															#line 11030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1425 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_TriggerWorkloads") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1428 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		completeClientIds = std::unordered_set<int>();
															#line 1429 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		clientIds = std::vector<int>();
															#line 1430 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		jobs = std::vector<Future<ErrorOr<Void>>>();
															#line 1431 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workRequests.size();i++) {
															#line 1432 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(workRequests[i].isReady());
															#line 1433 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (workRequests[i].get().isError())
															#line 11051 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1434 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_FailedToContactTester") .error(workRequests[i].get().getError()) .detail("TesterCount", testers.size()) .detail("TesterId", i) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1440 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				jobs.push_back(workRequests[i].get().get().start.template getReplyUnlessFailedFor<Void>(10, 0));
															#line 1441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				clientIds.push_back(i);
															#line 11063 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 1444 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(jobs);
															#line 1444 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11070 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 2;
															#line 1444 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*>(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)));
															#line 11075 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1445 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < jobs.size();i++) {
															#line 1446 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (jobs[i].isError())
															#line 11161 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1447 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadError1") .errorUnsuppressed(jobs[i].getError()) .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11165 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (jobs[i].get().isError())
															#line 11171 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadError2") .errorUnsuppressed(jobs[i].get().getError()) .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11175 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1459 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadComplete") .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					completeClientIds.insert(clientIds[i]);
															#line 11183 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_DispatchWorkloadEnd") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1471 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->SAV<std::unordered_set<int>>::futures) { (void)(completeClientIds); this->~RunUrgentConsistencyCheckWorkloadActorState(); static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->destroy(); return 0; }
															#line 11191 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->SAV< std::unordered_set<int> >::value()) std::unordered_set<int>(std::move(completeClientIds)); // state_var_RVO
		this->~RunUrgentConsistencyCheckWorkloadActorState();
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1445 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < jobs.size();i++) {
															#line 1446 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (jobs[i].isError())
															#line 11205 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1447 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadError1") .errorUnsuppressed(jobs[i].getError()) .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11209 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (jobs[i].get().isError())
															#line 11215 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadError2") .errorUnsuppressed(jobs[i].get().getError()) .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 11219 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1459 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					TraceEvent(SevInfo, "ConsistencyCheckUrgent_RunWorkloadComplete") .detail("ClientId", clientIds[i]) .detail("ClientCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					completeClientIds.insert(clientIds[i]);
															#line 11227 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_DispatchWorkloadEnd") .detail("TesterCount", testers.size()) .detail("ConsistencyCheckerId", consistencyCheckerId);
															#line 1471 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->SAV<std::unordered_set<int>>::futures) { (void)(completeClientIds); this->~RunUrgentConsistencyCheckWorkloadActorState(); static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->destroy(); return 0; }
															#line 11235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->SAV< std::unordered_set<int> >::value()) std::unordered_set<int>(std::move(completeClientIds)); // state_var_RVO
		this->~RunUrgentConsistencyCheckWorkloadActorState();
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state > 0) static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int64_t consistencyCheckerId;
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::unordered_map<int, std::vector<KeyRange>> assignment;
															#line 1403 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<WorkloadInterface>>> workRequests;
															#line 1428 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::unordered_set<int> completeClientIds;
															#line 1429 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<int> clientIds;
															#line 1430 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> jobs;
															#line 11334 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runUrgentConsistencyCheckWorkload()
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunUrgentConsistencyCheckWorkloadActor final : public Actor<std::unordered_set<int>>, public ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >, public ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >, public FastAllocated<RunUrgentConsistencyCheckWorkloadActor>, public RunUrgentConsistencyCheckWorkloadActorState<RunUrgentConsistencyCheckWorkloadActor> {
															#line 11339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunUrgentConsistencyCheckWorkloadActor>::operator new;
	using FastAllocated<RunUrgentConsistencyCheckWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5624675508214435328UL, 13677381900562608128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::unordered_set<int>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >;
friend struct ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >;
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunUrgentConsistencyCheckWorkloadActor(Database const& cx,std::vector<TesterInterface> const& testers,int64_t const& consistencyCheckerId,std::unordered_map<int, std::vector<KeyRange>> const& assignment) 
															#line 11357 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<std::unordered_set<int>>(),
		   RunUrgentConsistencyCheckWorkloadActorState<RunUrgentConsistencyCheckWorkloadActor>(cx, testers, consistencyCheckerId, assignment),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10978757743012301568UL, 6078238994598819584UL);
		ActorExecutionContextHelper __helper(static_cast<RunUrgentConsistencyCheckWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runUrgentConsistencyCheckWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runUrgentConsistencyCheckWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunUrgentConsistencyCheckWorkloadActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<std::unordered_set<int>> runUrgentConsistencyCheckWorkload( Database const& cx, std::vector<TesterInterface> const& testers, int64_t const& consistencyCheckerId, std::unordered_map<int, std::vector<KeyRange>> const& assignment ) {
															#line 1393 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<std::unordered_set<int>>(new RunUrgentConsistencyCheckWorkloadActor(cx, testers, consistencyCheckerId, assignment));
															#line 11391 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1473 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 11396 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getConsistencyCheckShards()
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetConsistencyCheckShardsActor>
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetConsistencyCheckShardsActorState {
															#line 11403 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetConsistencyCheckShardsActorState(Database const& cx,std::vector<KeyRange> const& ranges) 
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ranges(ranges),
															#line 1476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   beginKeyToReadKeyServer(),
															#line 1477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   endKeyToReadKeyServer()
															#line 11416 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this));

	}
	~GetConsistencyCheckShardsActorState() 
	{
		fdb_probe_actor_destroy("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1478 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for(int i = 0;i < ranges.size();i++) {
															#line 1479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (i == 0 || ranges[i].begin < beginKeyToReadKeyServer)
															#line 11433 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1480 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					beginKeyToReadKeyServer = ranges[i].begin;
															#line 11437 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
															#line 1482 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (i == 0 || ranges[i].end > endKeyToReadKeyServer)
															#line 11441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1483 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					endKeyToReadKeyServer = ranges[i].end;
															#line 11445 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
			}
															#line 1486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_GetConsistencyCheckShards") .detail("RangeBegin", beginKeyToReadKeyServer) .detail("RangeEnd", endKeyToReadKeyServer);
															#line 1490 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			res = std::vector<KeyRange>();
															#line 1491 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr = Transaction(cx);
															#line 1492 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 11456 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConsistencyCheckShardsActorState();
		static_cast<GetConsistencyCheckShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1526 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetConsistencyCheckShardsActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(res); this->~GetConsistencyCheckShardsActorState(); static_cast<GetConsistencyCheckShardsActor*>(this)->destroy(); return 0; }
															#line 11479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetConsistencyCheckShardsActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(std::move(res)); // state_var_RVO
		this->~GetConsistencyCheckShardsActorState();
		static_cast<GetConsistencyCheckShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1494 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1495 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1496 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1497 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			KeyRange rangeToRead = Standalone(KeyRangeRef(beginKeyToReadKeyServer, endKeyToReadKeyServer));
															#line 1498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, keyServersPrefix, rangeToRead, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT, SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES);
															#line 1498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state = 1;
															#line 1498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*>(static_cast<GetConsistencyCheckShardsActor*>(this)));
															#line 11514 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1522 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_GetConsistencyCheckShardsRetry").error(e);
															#line 1523 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1523 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11553 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state = 2;
															#line 1523 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*>(static_cast<GetConsistencyCheckShardsActor*>(this)));
															#line 11558 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& readResult,int loopDepth) 
	{
															#line 1503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1504 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			KeyRange rangeToCheck = Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key));
															#line 1505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Value valueToCheck = Standalone(readResult[i].value);
															#line 1506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			bool toAdd = false;
															#line 1507 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( const auto& range : ranges ) {
															#line 1508 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (rangeToCheck.intersects(range) == true)
															#line 11583 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					toAdd = true;
															#line 11587 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 1513 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (toAdd == true)
															#line 11593 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1514 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				res.push_back(rangeToCheck);
															#line 11597 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1516 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			beginKeyToReadKeyServer = readResult[i + 1].key;
															#line 11601 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1518 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (beginKeyToReadKeyServer >= endKeyToReadKeyServer)
															#line 11605 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && readResult,int loopDepth) 
	{
															#line 1503 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1504 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			KeyRange rangeToCheck = Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key));
															#line 1505 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Value valueToCheck = Standalone(readResult[i].value);
															#line 1506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			bool toAdd = false;
															#line 1507 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( const auto& range : ranges ) {
															#line 1508 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (rangeToCheck.intersects(range) == true)
															#line 11627 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					toAdd = true;
															#line 11631 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 1513 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (toAdd == true)
															#line 11637 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1514 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				res.push_back(rangeToCheck);
															#line 11641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1516 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			beginKeyToReadKeyServer = readResult[i + 1].key;
															#line 11645 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1518 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (beginKeyToReadKeyServer >= endKeyToReadKeyServer)
															#line 11649 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && readResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state > 0) static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetConsistencyCheckShardsActor*>(this)->ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state > 0) static_cast<GetConsistencyCheckShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetConsistencyCheckShardsActor*>(this)->ActorCallback< GetConsistencyCheckShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 1476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Key beginKeyToReadKeyServer;
															#line 1477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Key endKeyToReadKeyServer;
															#line 1490 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<KeyRange> res;
															#line 1491 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 11844 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getConsistencyCheckShards()
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetConsistencyCheckShardsActor final : public Actor<std::vector<KeyRange>>, public ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >, public ActorCallback< GetConsistencyCheckShardsActor, 1, Void >, public FastAllocated<GetConsistencyCheckShardsActor>, public GetConsistencyCheckShardsActorState<GetConsistencyCheckShardsActor> {
															#line 11849 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetConsistencyCheckShardsActor>::operator new;
	using FastAllocated<GetConsistencyCheckShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13126891941810637056UL, 16178577985548235776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRange>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >;
friend struct ActorCallback< GetConsistencyCheckShardsActor, 1, Void >;
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetConsistencyCheckShardsActor(Database const& cx,std::vector<KeyRange> const& ranges) 
															#line 11867 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyRange>>(),
		   GetConsistencyCheckShardsActorState<GetConsistencyCheckShardsActor>(cx, ranges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16459118065812089344UL, 9734862755223687168UL);
		ActorExecutionContextHelper __helper(static_cast<GetConsistencyCheckShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConsistencyCheckShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConsistencyCheckShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConsistencyCheckShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetConsistencyCheckShardsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<std::vector<KeyRange>> getConsistencyCheckShards( Database const& cx, std::vector<KeyRange> const& ranges ) {
															#line 1474 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<std::vector<KeyRange>>(new GetConsistencyCheckShardsActor(cx, ranges));
															#line 11901 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1528 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 11906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getTesters()
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class GetTestersActor>
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetTestersActorState {
															#line 11913 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetTestersActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,int const& minTestersExpected) 
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cc(cc),
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   minTestersExpected(minTestersExpected),
															#line 1532 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   flags(GetWorkersRequest::TESTER_CLASS_ONLY | GetWorkersRequest::NON_EXCLUDED_PROCESSES_ONLY),
															#line 1533 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testerTimeout(delay(600.0)),
															#line 1534 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   workers()
															#line 11928 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getTesters", reinterpret_cast<unsigned long>(this));

	}
	~GetTestersActorState() 
	{
		fdb_probe_actor_destroy("getTesters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1535 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 11943 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTestersActorState();
		static_cast<GetTestersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1554 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ts = std::vector<TesterInterface>();
															#line 1555 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ts.reserve(workers.size());
															#line 1556 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 1557 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ts.push_back(workers[i].interf.testerInterface);
															#line 11972 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1558 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		deterministicRandom()->randomShuffle(ts);
															#line 1559 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<GetTestersActor*>(this)->SAV<std::vector<TesterInterface>>::futures) { (void)(ts); this->~GetTestersActorState(); static_cast<GetTestersActor*>(this)->destroy(); return 0; }
															#line 11978 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<GetTestersActor*>(this)->SAV< std::vector<TesterInterface> >::value()) std::vector<TesterInterface>(std::move(ts)); // state_var_RVO
		this->~GetTestersActorState();
		static_cast<GetTestersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1537 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = cc->get().present() ? brokenPromiseToNever(cc->get().get().getWorkers.getReply(GetWorkersRequest(flags))) : Never();
															#line 1536 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<GetTestersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11999 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1547 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cc->onChange();
															#line 12003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 1548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = testerTimeout;
															#line 12007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<GetTestersActor*>(this)->actor_wait_state = 1;
															#line 1537 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetTestersActor*>(this)));
															#line 1547 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 1, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 1548 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 2, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 12016 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& w,int loopDepth) 
	{
															#line 1541 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (w.size() >= minTestersExpected)
															#line 12044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1542 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workers = w;
															#line 12048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->WORKER_POLL_DELAY);
															#line 1545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<GetTestersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12055 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetTestersActor*>(this)->actor_wait_state = 2;
															#line 1545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 3, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 12060 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && w,int loopDepth) 
	{
															#line 1541 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (w.size() >= minTestersExpected)
															#line 12069 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1542 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			workers = w;
															#line 12073 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->WORKER_POLL_DELAY);
															#line 1545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<GetTestersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12080 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetTestersActor*>(this)->actor_wait_state = 2;
															#line 1545 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetTestersActor, 3, Void >*>(static_cast<GetTestersActor*>(this)));
															#line 12085 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 1549 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevWarnAlways, "TesterRecruitmentTimeout");
															#line 1550 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 12108 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 1549 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevWarnAlways, "TesterRecruitmentTimeout");
															#line 1550 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 12118 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTestersActor*>(this)->actor_wait_state > 0) static_cast<GetTestersActor*>(this)->actor_wait_state = 0;
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >::remove();
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 1, Void >::remove();
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 2, Void >::remove();

	}
	int a_body1loopBody1when1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTestersActor*>(this)->actor_wait_state > 0) static_cast<GetTestersActor*>(this)->actor_wait_state = 0;
		static_cast<GetTestersActor*>(this)->ActorCallback< GetTestersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTestersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTestersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> cc;
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int minTestersExpected;
															#line 1532 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int flags;
															#line 1533 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Future<Void> testerTimeout;
															#line 1534 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1554 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> ts;
															#line 12400 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getTesters()
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class GetTestersActor final : public Actor<std::vector<TesterInterface>>, public ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetTestersActor, 3, Void >, public ActorCallback< GetTestersActor, 1, Void >, public ActorCallback< GetTestersActor, 2, Void >, public FastAllocated<GetTestersActor>, public GetTestersActorState<GetTestersActor> {
															#line 12405 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetTestersActor>::operator new;
	using FastAllocated<GetTestersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7432858893343037440UL, 7302604529222638080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TesterInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetTestersActor, 3, Void >;
friend struct ActorCallback< GetTestersActor, 1, Void >;
friend struct ActorCallback< GetTestersActor, 2, Void >;
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	GetTestersActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,int const& minTestersExpected) 
															#line 12425 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<std::vector<TesterInterface>>(),
		   GetTestersActorState<GetTestersActor>(cc, minTestersExpected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTesters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12020919305826439936UL, 12275217311193987072UL);
		ActorExecutionContextHelper __helper(static_cast<GetTestersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTesters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTesters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTestersActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTestersActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<std::vector<TesterInterface>> getTesters( Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc, int const& minTestersExpected ) {
															#line 1529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<std::vector<TesterInterface>>(new GetTestersActor(cc, minTestersExpected));
															#line 12459 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1561 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

const std::unordered_map<char, uint8_t> parseCharMap{
	{ '0', 0 },  { '1', 1 },  { '2', 2 },  { '3', 3 },  { '4', 4 },  { '5', 5 },  { '6', 6 },  { '7', 7 },
	{ '8', 8 },  { '9', 9 },  { 'a', 10 }, { 'b', 11 }, { 'c', 12 }, { 'd', 13 }, { 'e', 14 }, { 'f', 15 },
	{ 'A', 10 }, { 'B', 11 }, { 'C', 12 }, { 'D', 13 }, { 'E', 14 }, { 'F', 15 },
};

Optional<Key> getKeyFromString(const std::string& str) {
	Key emptyKey;
	if (str.size() == 0) {
		return emptyKey;
	}
	if (str.size() % 4 != 0) {
		TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "ConsistencyCheckUrgent_GetKeyFromStringError")
		    .setMaxEventLength(-1)
		    .setMaxFieldLength(-1)
		    .detail("Reason", "WrongLength")
		    .detail("InputStr", str);
		return Optional<Key>();
	}
	std::vector<uint8_t> byteList;
	for (int i = 0; i < str.size(); i += 4) {
		if (str.at(i + 0) != '\\' || str.at(i + 1) != 'x') {
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways,
			           "ConsistencyCheckUrgent_GetKeyFromStringError")
			    .setMaxEventLength(-1)
			    .setMaxFieldLength(-1)
			    .detail("Reason", "WrongBytePrefix")
			    .detail("InputStr", str);
			return Optional<Key>();
		}
		const char first = str.at(i + 2);
		const char second = str.at(i + 3);
		if (!parseCharMap.contains(first) || !parseCharMap.contains(second)) {
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways,
			           "ConsistencyCheckUrgent_GetKeyFromStringError")
			    .setMaxEventLength(-1)
			    .setMaxFieldLength(-1)
			    .detail("Reason", "WrongByteContent")
			    .detail("InputStr", str);
			return Optional<Key>();
		}
		uint8_t parsedValue = parseCharMap.at(first) * 16 + parseCharMap.at(second);
		byteList.push_back(parsedValue);
	}
	return Standalone(StringRef(byteList.data(), byteList.size()));
}

Optional<std::vector<KeyRange>> loadRangesToCheckFromKnob() {
	// Load string from knob
	std::vector<std::string> beginKeyStrs = {
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_BEGIN_0,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_BEGIN_1,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_BEGIN_2,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_BEGIN_3,
	};
	std::vector<std::string> endKeyStrs = {
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_END_0,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_END_1,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_END_2,
		CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_RANGE_END_3,
	};

	// Get keys from strings
	std::vector<Key> beginKeys;
	for (const auto& beginKeyStr : beginKeyStrs) {
		Optional<Key> key = getKeyFromString(beginKeyStr);
		if (key.present()) {
			beginKeys.push_back(key.get());
		} else {
			return Optional<std::vector<KeyRange>>();
		}
	}
	std::vector<Key> endKeys;
	for (const auto& endKeyStr : endKeyStrs) {
		Optional<Key> key = getKeyFromString(endKeyStr);
		if (key.present()) {
			endKeys.push_back(key.get());
		} else {
			return Optional<std::vector<KeyRange>>();
		}
	}
	if (beginKeys.size() != endKeys.size()) {
		TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "ConsistencyCheckUrgent_GetKeyFromStringError")
		    .detail("Reason", "MismatchBeginKeysAndEndKeys");
		return Optional<std::vector<KeyRange>>();
	}

	// Get ranges
	KeyRangeMap<bool> rangeToCheckMap;
	for (int i = 0; i < beginKeys.size(); i++) {
		Key rangeBegin = beginKeys[i];
		Key rangeEnd = endKeys[i];
		if (rangeBegin.empty() && rangeEnd.empty()) {
			continue;
		}
		if (rangeBegin > allKeys.end) {
			rangeBegin = allKeys.end;
		}
		if (rangeEnd > allKeys.end) {
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_ReverseInputRange")
			    .setMaxEventLength(-1)
			    .setMaxFieldLength(-1)
			    .detail("Index", i)
			    .detail("RangeBegin", rangeBegin)
			    .detail("RangeEnd", rangeEnd);
			rangeEnd = allKeys.end;
		}

		KeyRange rangeToCheck;
		if (rangeBegin < rangeEnd) {
			rangeToCheck = Standalone(KeyRangeRef(rangeBegin, rangeEnd));
		} else if (rangeBegin > rangeEnd) {
			rangeToCheck = Standalone(KeyRangeRef(rangeEnd, rangeBegin));
		} else {
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_EmptyInputRange")
			    .setMaxEventLength(-1)
			    .setMaxFieldLength(-1)
			    .detail("Index", i)
			    .detail("RangeBegin", rangeBegin)
			    .detail("RangeEnd", rangeEnd);
			continue;
		}
		rangeToCheckMap.insert(rangeToCheck, true);
	}

	rangeToCheckMap.coalesce(allKeys);

	std::vector<KeyRange> res;
	for (auto rangeToCheck : rangeToCheckMap.ranges()) {
		if (rangeToCheck.value() == true) {
			res.push_back(rangeToCheck.range());
		}
	}
	TraceEvent e(SevInfo, "ConsistencyCheckUrgent_LoadedInputRange");
	e.setMaxEventLength(-1);
	e.setMaxFieldLength(-1);
	for (int i = 0; i < res.size(); i++) {
		e.detail("RangeBegin" + std::to_string(i), res[i].begin);
		e.detail("RangeEnd" + std::to_string(i), res[i].end);
	}
	return res;
}

std::unordered_map<int, std::vector<KeyRange>> makeTaskAssignment(Database cx,
                                                                  int64_t consistencyCheckerId,
                                                                  std::vector<KeyRange> shardsToCheck,
                                                                  int testersCount,
                                                                  int round) {
	ASSERT(testersCount >= 1);
	std::unordered_map<int, std::vector<KeyRange>> assignment;

	std::vector<size_t> shuffledIndices(testersCount);
	std::iota(shuffledIndices.begin(), shuffledIndices.end(), 0); // creates [0, 1, ..., testersCount - 1]
	deterministicRandom()->randomShuffle(shuffledIndices);

	int batchSize = CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_BATCH_SHARD_COUNT;
	int startingPoint = 0;
	if (shardsToCheck.size() > batchSize * testersCount) {
		startingPoint = deterministicRandom()->randomInt(0, shardsToCheck.size() - batchSize * testersCount);
		// We randomly pick a set of successive shards:
		// (1) We want to retry for different shards to avoid repeated failure on the same shards
		// (2) We want to check successive shards to avoid inefficiency incurred by fragments
	}
	assignment.clear();
	for (int i = startingPoint; i < shardsToCheck.size(); i++) {
		int testerIdx = (i - startingPoint) / batchSize;
		if (testerIdx > testersCount - 1) {
			break; // Have filled up all testers
		}
		// When assigning a shards/batch to a tester idx, there are certain edge cases which can result in urgent
		// consistency checker being infinetely stuck in a loop. Examples:
		//      1. if there is 1 remaining shard, and tester 0 consistently fails, we will still always pick tester 0
		//      2. if there are 10 remaining shards, and batch size is 10, and tester 0 consistently fails, we will
		//      still always pick tester 0
		//      3. if there are 20 remaining shards, and batch size is 10, and testers {0, 1} consistently fail, we will
		//      keep picking testers {0, 1}
		// To avoid repeatedly picking the same testers even though they could be failing, shuffledIndices provides an
		// indirection to a random tester idx. That way, each invocation of makeTaskAssignment won't
		// result in the same task assignment for the class of edge cases mentioned above.
		assignment[shuffledIndices[testerIdx]].push_back(shardsToCheck[i]);
	}
	std::unordered_map<int, std::vector<KeyRange>>::iterator assignIt;
	for (assignIt = assignment.begin(); assignIt != assignment.end(); assignIt++) {
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_AssignTaskToTesters")
		    .detail("ConsistencyCheckerId", consistencyCheckerId)
		    .detail("Round", round)
		    .detail("ClientId", assignIt->first)
		    .detail("ShardsCount", assignIt->second.size());
	}
	return assignment;
}

															#line 12656 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runConsistencyCheckerUrgentCore()
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunConsistencyCheckerUrgentCoreActor>
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckerUrgentCoreActorState {
															#line 12663 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckerUrgentCoreActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,Database const& cx,Optional<std::vector<TesterInterface>> const& testers,int const& minTestersExpected) 
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cc(cc),
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   cx(cx),
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   minTestersExpected(minTestersExpected),
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   globalProgressMap(),
															#line 1759 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   assignment(),
															#line 1760 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ts(),
															#line 1761 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   rangesToCheck(),
															#line 1762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   shardsToCheck(),
															#line 1763 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   whenFailedToGetTesterStart()
															#line 12688 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this));

	}
	~RunConsistencyCheckerUrgentCoreActorState() 
	{
		fdb_probe_actor_destroy("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1766 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Optional<std::vector<KeyRange>> rangesToCheck_ = loadRangesToCheckFromKnob();
															#line 1767 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (rangesToCheck_.present())
															#line 12705 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.insert(allKeys, true);
															#line 1769 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				for( const auto& rangeToCheck : rangesToCheck_.get() ) {
															#line 1772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					globalProgressMap.insert(rangeToCheck, false);
															#line 12713 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
															#line 1774 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.coalesce(allKeys);
															#line 12717 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1776 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_FailedToLoadRangeFromKnob");
															#line 1777 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.insert(allKeys, false);
															#line 12725 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 1780 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			consistencyCheckerId = deterministicRandom()->randomInt64(1, 10000000);
															#line 1781 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			retryTimes = 0;
															#line 1782 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			round = 0;
															#line 1785 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 12735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunConsistencyCheckerUrgentCoreActorState();
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1788 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheckUrgent_RoundBegin") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("TesterCount", ts.size()) .detail("Round", round);
															#line 1793 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			rangesToCheck.clear();
															#line 1794 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto& range : globalProgressMap.ranges() ) {
															#line 1795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!range.value())
															#line 12772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1796 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					rangesToCheck.push_back(range.range());
															#line 12776 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
			}
															#line 1799 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (rangesToCheck.size() == 0)
															#line 12781 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_Complete") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("Round", round);
															#line 1804 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunConsistencyCheckerUrgentCoreActorState(); static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->destroy(); return 0; }
															#line 12787 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				new (&static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunConsistencyCheckerUrgentCoreActorState();
				static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1808 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ts.clear();
															#line 1809 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!testers.present())
															#line 12797 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
				try {
															#line 1811 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					StrictFuture<Void> __when_expr_0 = store(ts, getTesters(cc, minTestersExpected));
															#line 1811 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 12804 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
					static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 1;
															#line 1811 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 12809 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1loopBody1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1loopBody1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 1827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				ts = testers.get();
															#line 12822 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1885 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(10.0);
															#line 1885 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12840 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 5;
															#line 1885 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 12845 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1872 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12855 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1873 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 12859 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1875 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheckUrgent_CoreWithRetriableFailure") .errorUnsuppressed(e) .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("Round", round);
															#line 1880 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_3 = delay(10.0);
															#line 1880 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 4;
															#line 1880 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 12874 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1829 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_GotTesters") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("Round", round) .detail("RetryTimes", retryTimes) .detail("TesterCount", ts.size());
															#line 1837 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		shardsToCheck.clear();
															#line 1838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(shardsToCheck, getConsistencyCheckShards(cx, rangesToCheck));
															#line 1838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12896 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 2;
															#line 1838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 12901 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 1823 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && deterministicRandom()->random01() < 0.05)
															#line 12910 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1824 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 12914 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 12925 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1815 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (!whenFailedToGetTesterStart.present())
															#line 12929 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1816 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					whenFailedToGetTesterStart = now();
															#line 12933 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1817 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (now() - whenFailedToGetTesterStart.get() > 3600 * 24)
															#line 12939 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					{
															#line 1818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						TraceEvent(SevError, "TesterRecruitmentTimeout");
															#line 12943 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					}
				}
			}
															#line 1821 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1loopBody1Catch1(e, loopDepth);
															#line 12949 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 1812 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		whenFailedToGetTesterStart.reset();
															#line 12963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 1812 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		whenFailedToGetTesterStart.reset();
															#line 12972 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
															#line 1839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_GotShardsToCheck") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("Round", round) .detail("RetryTimes", retryTimes) .detail("TesterCount", ts.size()) .detail("ShardCount", shardsToCheck.size());
															#line 1847 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		assignment.clear();
															#line 1848 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		assignment = makeTaskAssignment(cx, consistencyCheckerId, shardsToCheck, ts.size(), round);
															#line 1851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<std::unordered_set<int>> __when_expr_2 = runUrgentConsistencyCheckWorkload(cx, ts, consistencyCheckerId, assignment);
															#line 1851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13077 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont13when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 3;
															#line 1851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 13082 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
															#line 1839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_GotShardsToCheck") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("Round", round) .detail("RetryTimes", retryTimes) .detail("TesterCount", ts.size()) .detail("ShardCount", shardsToCheck.size());
															#line 1847 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		assignment.clear();
															#line 1848 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		assignment = makeTaskAssignment(cx, consistencyCheckerId, shardsToCheck, ts.size(), round);
															#line 1851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<std::unordered_set<int>> __when_expr_2 = runUrgentConsistencyCheckWorkload(cx, ts, consistencyCheckerId, assignment);
															#line 1851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13099 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont13when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 3;
															#line 1851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*>(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)));
															#line 13104 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont13cont1(std::unordered_set<int> const& completeClients,int loopDepth) 
	{
															#line 1853 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && deterministicRandom()->random01() < 0.05)
															#line 13188 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1854 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 13192 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1857 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( const auto& clientId : completeClients ) {
															#line 1858 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( const auto& range : assignment[clientId] ) {
															#line 1859 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.insert(range, true);
															#line 13200 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 1862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_RoundEnd") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("SucceedTesterCount", completeClients.size()) .detail("SucceedTesters", describe(completeClients)) .detail("TesterCount", ts.size()) .detail("Round", round);
															#line 1869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		round++;
															#line 13207 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1(std::unordered_set<int> && completeClients,int loopDepth) 
	{
															#line 1853 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && deterministicRandom()->random01() < 0.05)
															#line 13216 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1854 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 13220 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 1857 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( const auto& clientId : completeClients ) {
															#line 1858 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( const auto& range : assignment[clientId] ) {
															#line 1859 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				globalProgressMap.insert(range, true);
															#line 13228 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 1862 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(SevInfo, "ConsistencyCheckUrgent_RoundEnd") .detail("ConsistencyCheckerId", consistencyCheckerId) .detail("RetryTimes", retryTimes) .detail("SucceedTesterCount", completeClients.size()) .detail("SucceedTesters", describe(completeClients)) .detail("TesterCount", ts.size()) .detail("Round", round);
															#line 1869 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		round++;
															#line 13235 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont13cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(std::unordered_set<int> const& completeClients,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(completeClients, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(std::unordered_set<int> && completeClients,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(std::move(completeClients), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*,std::unordered_set<int> const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*,std::unordered_set<int> && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 1881 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryTimes++;
															#line 13338 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 1881 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		retryTimes++;
															#line 13347 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 1888 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyCheckerId = deterministicRandom()->randomInt64(1, 10000000);
															#line 13431 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 1888 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyCheckerId = deterministicRandom()->randomInt64(1, 10000000);
															#line 13440 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> cc;
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<std::vector<TesterInterface>> testers;
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int minTestersExpected;
															#line 1758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	KeyRangeMap<bool> globalProgressMap;
															#line 1759 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::unordered_map<int, std::vector<KeyRange>> assignment;
															#line 1760 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> ts;
															#line 1761 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<KeyRange> rangesToCheck;
															#line 1762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<KeyRange> shardsToCheck;
															#line 1763 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<double> whenFailedToGetTesterStart;
															#line 1780 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int64_t consistencyCheckerId;
															#line 1781 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int retryTimes;
															#line 1782 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int round;
															#line 13546 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runConsistencyCheckerUrgentCore()
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckerUrgentCoreActor final : public Actor<Void>, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >, public ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >, public FastAllocated<RunConsistencyCheckerUrgentCoreActor>, public RunConsistencyCheckerUrgentCoreActorState<RunConsistencyCheckerUrgentCoreActor> {
															#line 13551 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunConsistencyCheckerUrgentCoreActor>::operator new;
	using FastAllocated<RunConsistencyCheckerUrgentCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8408373493263086848UL, 17162159066779490304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >;
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >;
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >;
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >;
friend struct ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >;
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckerUrgentCoreActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,Database const& cx,Optional<std::vector<TesterInterface>> const& testers,int const& minTestersExpected) 
															#line 13572 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunConsistencyCheckerUrgentCoreActorState<RunConsistencyCheckerUrgentCoreActor>(cc, cx, testers, minTestersExpected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10940115967878822656UL, 1660588988548103680UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runConsistencyCheckerUrgentCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runConsistencyCheckerUrgentCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 2, std::unordered_set<int> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentCoreActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> runConsistencyCheckerUrgentCore( Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc, Database const& cx, Optional<std::vector<TesterInterface>> const& testers, int const& minTestersExpected ) {
															#line 1754 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new RunConsistencyCheckerUrgentCoreActor(cc, cx, testers, minTestersExpected));
															#line 13609 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1891 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 13614 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runConsistencyCheckerUrgentHolder()
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunConsistencyCheckerUrgentHolderActor>
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckerUrgentHolderActorState {
															#line 13621 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckerUrgentHolderActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,Database const& cx,Optional<std::vector<TesterInterface>> const& testers,int const& minTestersExpected,bool const& repeatRun) 
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cc(cc),
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   cx(cx),
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   minTestersExpected(minTestersExpected),
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   repeatRun(repeatRun)
															#line 13636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this));

	}
	~RunConsistencyCheckerUrgentHolderActorState() 
	{
		fdb_probe_actor_destroy("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1897 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 13651 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunConsistencyCheckerUrgentHolderActorState();
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1904 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunConsistencyCheckerUrgentHolderActorState(); static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->destroy(); return 0; }
															#line 13674 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunConsistencyCheckerUrgentHolderActorState();
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_0 = runConsistencyCheckerUrgentCore(cc, cx, testers, minTestersExpected);
															#line 1898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13695 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 1;
															#line 1898 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*>(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)));
															#line 13700 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1899 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!repeatRun)
															#line 13722 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_NEXT_WAIT_TIME);
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13730 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 2;
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*>(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)));
															#line 13735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1899 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!repeatRun)
															#line 13744 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(CLIENT_KNOBS->CONSISTENCY_CHECK_URGENT_NEXT_WAIT_TIME);
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13752 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 2;
															#line 1902 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*>(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)));
															#line 13757 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state > 0) static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->actor_wait_state = 0;
		static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> cc;
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Optional<std::vector<TesterInterface>> testers;
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	int minTestersExpected;
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool repeatRun;
															#line 13934 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runConsistencyCheckerUrgentHolder()
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunConsistencyCheckerUrgentHolderActor final : public Actor<Void>, public ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >, public ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >, public FastAllocated<RunConsistencyCheckerUrgentHolderActor>, public RunConsistencyCheckerUrgentHolderActorState<RunConsistencyCheckerUrgentHolderActor> {
															#line 13939 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunConsistencyCheckerUrgentHolderActor>::operator new;
	using FastAllocated<RunConsistencyCheckerUrgentHolderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15550961736750747392UL, 7243694190077625344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >;
friend struct ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >;
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunConsistencyCheckerUrgentHolderActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc,Database const& cx,Optional<std::vector<TesterInterface>> const& testers,int const& minTestersExpected,bool const& repeatRun) 
															#line 13957 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RunConsistencyCheckerUrgentHolderActorState<RunConsistencyCheckerUrgentHolderActor>(cc, cx, testers, minTestersExpected, repeatRun),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2071602810193994496UL, 16357947033855925504UL);
		ActorExecutionContextHelper __helper(static_cast<RunConsistencyCheckerUrgentHolderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runConsistencyCheckerUrgentHolder");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runConsistencyCheckerUrgentHolder", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentHolderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunConsistencyCheckerUrgentHolderActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> runConsistencyCheckerUrgentHolder( Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& cc, Database const& cx, Optional<std::vector<TesterInterface>> const& testers, int const& minTestersExpected, bool const& repeatRun ) {
															#line 1892 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new RunConsistencyCheckerUrgentHolderActor(cc, cx, testers, minTestersExpected, repeatRun));
															#line 13991 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 1906 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

Future<Void> checkConsistencyUrgentSim(Database cx, std::vector<TesterInterface> testers) {
	if (SERVER_KNOBS->DISABLE_AUDIT_STORAGE_FINAL_REPLICA_CHECK_IN_SIM) {
		return Void();
	}
	return runConsistencyCheckerUrgentHolder(
	    Reference<AsyncVar<Optional<ClusterControllerFullInterface>>>(), cx, testers, 1, /*repeatRun=*/false);
}

															#line 14004 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runTest()
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunTestActor>
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunTestActorState {
															#line 14011 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunTestActorState(Database const& cx,std::vector<TesterInterface> const& testers,TestSpec const& spec,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,TesterConsistencyScanState* const& consistencyScanState) 
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cx(cx),
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   spec(spec),
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo),
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   consistencyScanState(consistencyScanState),
															#line 1920 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testResults(),
															#line 1921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   savedDisableDuration(0)
															#line 14030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runTest", reinterpret_cast<unsigned long>(this));

	}
	~RunTestActorState() 
	{
		fdb_probe_actor_destroy("runTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1924 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				Future<DistributedTestResults> fTestResults = runWorkload(cx, testers, spec);
															#line 1925 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (g_network->isSimulated() && spec.simConnectionFailuresDisableDuration > 0)
															#line 14048 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1926 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					savedDisableDuration = g_simulator->connectionFailuresDisableDuration;
															#line 1927 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					g_simulator->connectionFailuresDisableDuration = spec.simConnectionFailuresDisableDuration;
															#line 14054 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
															#line 1929 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (spec.timeout > 0)
															#line 14058 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				{
															#line 1930 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					fTestResults = timeoutError(fTestResults, spec.timeout);
															#line 14062 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				}
															#line 1932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<DistributedTestResults> __when_expr_0 = fTestResults;
															#line 1932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 14068 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 1;
															#line 1932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 0, DistributedTestResults >*>(static_cast<RunTestActor*>(this)));
															#line 14073 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1954 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ok = testResults.ok();
															#line 1956 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.useDB)
															#line 14104 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1957 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("%d test clients passed; %d test clients failed\n", testResults.successes, testResults.failures);
															#line 1958 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (spec.dumpAfterTest)
															#line 14110 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
				try {
															#line 1960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					StrictFuture<Void> __when_expr_1 = timeoutError(dumpDatabase(cx, "dump after " + printable(spec.title) + ".html", allKeys), 30.0);
															#line 1960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 14117 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<RunTestActor*>(this)->actor_wait_state = 2;
															#line 1960 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 1, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14122 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont9(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1940 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 14148 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 1941 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				auto msg = fmt::format("Process timed out after {} seconds", spec.timeout);
															#line 1942 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				ProcessEvents::trigger("Timeout"_sr, StringRef(msg), e);
															#line 1943 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevError, "TestFailure") .error(e) .detail("Reason", "Test timed out") .detail("Timeout", spec.timeout);
															#line 1947 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				fprintf(stderr, "ERROR: Test timed out after %d seconds.\n", spec.timeout);
															#line 1948 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				testResults.failures = testers.size();
															#line 1949 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				testResults.successes = 0;
															#line 14162 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1951 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 14168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(DistributedTestResults const& _testResults,int loopDepth) 
	{
															#line 1933 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Test complete\n");
															#line 1934 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		testResults = _testResults;
															#line 1935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		logMetrics(testResults.metrics);
															#line 1936 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && savedDisableDuration > 0)
															#line 14190 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1937 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->connectionFailuresDisableDuration = savedDisableDuration;
															#line 14194 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(DistributedTestResults && _testResults,int loopDepth) 
	{
															#line 1933 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Test complete\n");
															#line 1934 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		testResults = _testResults;
															#line 1935 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		logMetrics(testResults.metrics);
															#line 1936 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && savedDisableDuration > 0)
															#line 14210 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1937 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->connectionFailuresDisableDuration = savedDisableDuration;
															#line 14214 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributedTestResults const& _testResults,int loopDepth) 
	{
		loopDepth = a_body1cont2(_testResults, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DistributedTestResults && _testResults,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_testResults), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 0, DistributedTestResults >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 0, DistributedTestResults >*,DistributedTestResults const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 0, DistributedTestResults >*,DistributedTestResults && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunTestActor, 0, DistributedTestResults >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
															#line 2019 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent(ok ? SevInfo : SevWarnAlways, "TestResults").detail("Workload", spec.title).detail("Passed", (int)ok);
															#line 2022 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (ok)
															#line 14314 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2023 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			passCount++;
															#line 14318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2025 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			failCount++;
															#line 14324 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2028 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("%d test clients passed; %d test clients failed\n", testResults.successes, testResults.failures);
															#line 2030 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.useDB && spec.clearAfterTest)
															#line 14330 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 2032 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("TesterClearingDatabase").log();
															#line 2033 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_10 = timeoutError(clearData(cx), 1000.0);
															#line 2033 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 14339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont8Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont8when1(__when_expr_10.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 11;
															#line 2033 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 10, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14344 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 1971 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_3 = checkConsistencyScanAfterTest(cx, consistencyScanState);
															#line 1971 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14366 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 4;
															#line 1971 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 3, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14371 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 1966 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 1966 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 3;
															#line 1966 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 2, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14387 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1962 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure").error(e).detail("Reason", "Unable to dump database");
															#line 1963 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ok = false;
															#line 14399 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunTestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 1972 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Consistency scan done\n");
															#line 1975 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.runConsistencyCheck)
															#line 14603 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1976 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			quiescent = g_network->isSimulated() ? !BUGGIFY : spec.waitForQuiescenceEnd;
															#line 14607 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			try {
															#line 1978 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				printf("Running urgent consistency check...\n");
															#line 1980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_4 = timeoutError(checkConsistencyUrgentSim(cx, testers), 20000.0);
															#line 1980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12Catch1(actor_cancelled(), loopDepth);
															#line 14615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont12Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont12when1(__when_expr_4.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 5;
															#line 1980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 4, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14620 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont12Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont12Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 1972 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Consistency scan done\n");
															#line 1975 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (spec.runConsistencyCheck)
															#line 14642 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 1976 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			quiescent = g_network->isSimulated() ? !BUGGIFY : spec.waitForQuiescenceEnd;
															#line 14646 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			try {
															#line 1978 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				printf("Running urgent consistency check...\n");
															#line 1980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_4 = timeoutError(checkConsistencyUrgentSim(cx, testers), 20000.0);
															#line 1980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12Catch1(actor_cancelled(), loopDepth);
															#line 14654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont12Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont12when1(__when_expr_4.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 5;
															#line 1980 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 4, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont12Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont12Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunTestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 1998 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (quiescent && g_network->isSimulated())
															#line 14760 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 2000 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent("AuditStorageStart");
															#line 2001 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_6 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateHA), 1500.0);
															#line 2001 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 14769 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont12cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_6.get(), loopDepth); };
				static_cast<RunTestActor*>(this)->actor_wait_state = 7;
															#line 2001 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 6, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14774 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont12cont2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont12cont2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1993 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure").error(e).detail("Reason", "Unable to perform consistency check");
															#line 1994 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ok = false;
															#line 14797 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont3(Void const& _,int loopDepth) 
	{
															#line 1981 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Urgent consistency check done\nRunning consistency check...\n");
															#line 1982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_5 = timeoutError(checkConsistency(cx, testers, quiescent, spec.runConsistencyCheckOnTSS, spec.maxDDRunTime > 0 ? spec.maxDDRunTime : 10000.0, 5000, spec.databasePingDelay, dbInfo), 20000.0);
															#line 1982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12Catch1(actor_cancelled(), loopDepth);
															#line 14816 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont12Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 6;
															#line 1982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 5, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14821 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont3(Void && _,int loopDepth) 
	{
															#line 1981 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Urgent consistency check done\nRunning consistency check...\n");
															#line 1982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_5 = timeoutError(checkConsistency(cx, testers, quiescent, spec.runConsistencyCheckOnTSS, spec.maxDDRunTime > 0 ? spec.maxDDRunTime : 10000.0, 5000, spec.databasePingDelay, dbInfo), 20000.0);
															#line 1982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12Catch1(actor_cancelled(), loopDepth);
															#line 14834 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont12Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 6;
															#line 1982 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 5, Void >*>(static_cast<RunTestActor*>(this)));
															#line 14839 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunTestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont4(Void const& _,int loopDepth) 
	{
															#line 1991 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Consistency check done\n");
															#line 14923 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4(Void && _,int loopDepth) 
	{
															#line 1991 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("Consistency check done\n");
															#line 14932 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunTestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12Catch1(error, 0);
		} catch (...) {
			a_body1cont12Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont7(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8(int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2010 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ok = false;
															#line 2011 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure") .error(e) .detail("Reason", "Unable to perform auditStorage check.");
															#line 15044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont9(Void const& _,int loopDepth) 
	{
															#line 2002 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessHADone");
															#line 2003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_7 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateReplica), 1500.0);
															#line 2003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15063 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont12cont2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 8;
															#line 2003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 7, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15068 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont9(Void && _,int loopDepth) 
	{
															#line 2002 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessHADone");
															#line 2003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_7 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateReplica), 1500.0);
															#line 2003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15081 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont12cont2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 8;
															#line 2003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 7, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15086 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunTestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont10(Void const& _,int loopDepth) 
	{
															#line 2004 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessReplicaDone");
															#line 2005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_8 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateLocationMetadata), 1500.0);
															#line 2005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15174 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont12cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont12cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 9;
															#line 2005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 8, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15179 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10(Void && _,int loopDepth) 
	{
															#line 2004 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessReplicaDone");
															#line 2005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_8 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateLocationMetadata), 1500.0);
															#line 2005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15192 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont12cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont12cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 9;
															#line 2005 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 8, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15197 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RunTestActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12cont10cont1(Void const& _,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessLocationMetadataDone");
															#line 2007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_9 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateStorageServerShard), 1500.0);
															#line 2007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15285 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 10;
															#line 2007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 9, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15290 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10cont1(Void && _,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessLocationMetadataDone");
															#line 2007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_9 = timeoutError(auditStorageCorrectness(dbInfo, AuditType::ValidateStorageServerShard), 1500.0);
															#line 2007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 15303 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 10;
															#line 2007 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 9, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15308 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunTestActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont10cont2(Void const& _,int loopDepth) 
	{
															#line 2008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessStorageServerShardDone");
															#line 15392 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont2(Void && _,int loopDepth) 
	{
															#line 2008 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("AuditStorageCorrectnessStorageServerShardDone");
															#line 15401 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont12cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RunTestActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont10cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 2042 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<RunTestActor*>(this)->SAV<bool>::futures) { (void)(ok); this->~RunTestActorState(); static_cast<RunTestActor*>(this)->destroy(); return 0; }
															#line 15498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<RunTestActor*>(this)->SAV< bool >::value()) bool(std::move(ok)); // state_var_RVO
		this->~RunTestActorState();
		static_cast<RunTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16(int loopDepth) 
	{
															#line 2039 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_11 = delay(1.0);
															#line 2039 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<RunTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15512 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont16when1(__when_expr_11.get(), loopDepth); };
		static_cast<RunTestActor*>(this)->actor_wait_state = 12;
															#line 2039 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RunTestActor, 11, Void >*>(static_cast<RunTestActor*>(this)));
															#line 15517 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2035 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "ErrorClearingDatabaseAfterTest").error(e);
															#line 2036 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 15529 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont17(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont17(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RunTestActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont17cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont16(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<RunTestActor*>(this)->actor_wait_state > 0) static_cast<RunTestActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestActor*>(this)->ActorCallback< RunTestActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RunTestActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RunTestActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database cx;
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::vector<TesterInterface> testers;
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TestSpec spec;
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	TesterConsistencyScanState* consistencyScanState;
															#line 1920 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DistributedTestResults testResults;
															#line 1921 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double savedDisableDuration;
															#line 1954 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool ok;
															#line 1976 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	bool quiescent;
															#line 15744 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via runTest()
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunTestActor final : public Actor<bool>, public ActorCallback< RunTestActor, 0, DistributedTestResults >, public ActorCallback< RunTestActor, 1, Void >, public ActorCallback< RunTestActor, 2, Void >, public ActorCallback< RunTestActor, 3, Void >, public ActorCallback< RunTestActor, 4, Void >, public ActorCallback< RunTestActor, 5, Void >, public ActorCallback< RunTestActor, 6, Void >, public ActorCallback< RunTestActor, 7, Void >, public ActorCallback< RunTestActor, 8, Void >, public ActorCallback< RunTestActor, 9, Void >, public ActorCallback< RunTestActor, 10, Void >, public ActorCallback< RunTestActor, 11, Void >, public FastAllocated<RunTestActor>, public RunTestActorState<RunTestActor> {
															#line 15749 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<RunTestActor>::operator new;
	using FastAllocated<RunTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5180642748533950208UL, 14226849705824926464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunTestActor, 0, DistributedTestResults >;
friend struct ActorCallback< RunTestActor, 1, Void >;
friend struct ActorCallback< RunTestActor, 2, Void >;
friend struct ActorCallback< RunTestActor, 3, Void >;
friend struct ActorCallback< RunTestActor, 4, Void >;
friend struct ActorCallback< RunTestActor, 5, Void >;
friend struct ActorCallback< RunTestActor, 6, Void >;
friend struct ActorCallback< RunTestActor, 7, Void >;
friend struct ActorCallback< RunTestActor, 8, Void >;
friend struct ActorCallback< RunTestActor, 9, Void >;
friend struct ActorCallback< RunTestActor, 10, Void >;
friend struct ActorCallback< RunTestActor, 11, Void >;
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunTestActor(Database const& cx,std::vector<TesterInterface> const& testers,TestSpec const& spec,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,TesterConsistencyScanState* const& consistencyScanState) 
															#line 15777 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   RunTestActorState<RunTestActor>(cx, testers, spec, dbInfo, consistencyScanState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12013671372596341504UL, 10273208522725205248UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunTestActor, 0, DistributedTestResults >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunTestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunTestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunTestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunTestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunTestActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RunTestActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< RunTestActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< RunTestActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< RunTestActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< RunTestActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< RunTestActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<bool> runTest( Database const& cx, std::vector<TesterInterface> const& testers, TestSpec const& spec, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, TesterConsistencyScanState* const& consistencyScanState ) {
															#line 1915 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<bool>(new RunTestActor(cx, testers, spec, dbInfo, consistencyScanState));
															#line 15821 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 2044 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

std::map<std::string, std::function<void(const std::string&)>> testSpecGlobalKeys = {
	// These are read by SimulatedCluster and used before testers exist.  Thus, they must
	// be recognized and accepted, but there's no point in placing them into a testSpec.
	// testClass and testPriority are only used for TestHarness, we'll ignore those here
	{ "testClass", [](std::string const&) {} },
	{ "testPriority", [](std::string const&) {} },
	{ "extraDatabaseMode",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedExtraDatabaseMode", ""); } },
	{ "extraDatabaseCount",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedExtraDatabaseCount", ""); } },
	{ "configureLocked",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedConfigureLocked", ""); } },
	{ "minimumReplication",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedMinimumReplication", ""); } },
	{ "minimumRegions",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedMinimumRegions", ""); } },
	{ "logAntiQuorum",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedLogAntiQuorum", ""); } },
	{ "buggify", [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedBuggify", value); } },
	// The test harness handles NewSeverity events specially.
	{ "StderrSeverity", [](const std::string& value) { TraceEvent("StderrSeverity").detail("NewSeverity", value); } },
	{ "ClientInfoLogging",
	  [](const std::string& value) {
	      if (value == "false") {
		      setNetworkOption(FDBNetworkOptions::DISABLE_CLIENT_STATISTICS_LOGGING);
	      }
	      // else { } It is enable by default for tester
	      TraceEvent("TestParserTest").detail("ClientInfoLogging", value);
	  } },
	{ "startIncompatibleProcess",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedStartIncompatibleProcess", value); } },
	{ "storageEngineExcludeTypes",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedStorageEngineExcludeTypes", ""); } },
	{ "maxTLogVersion",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedMaxTLogVersion", ""); } },
	{ "disableTss", [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedDisableTSS", ""); } },
	{ "disableHostname",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedDisableHostname", ""); } },
	{ "disableRemoteKVS",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedRemoteKVS", ""); } },
	// TODO(gglass): remove this when it's no longer used.  For now it's a useful signal in a toml file
	// for tests against functionality that might not actually be tenant related and hence need to keep.
	{ "allowDefaultTenant",
	  [](const std::string& value) { TraceEvent("TestParserTest").detail("ParsedDefaultTenant", ""); } }
};

std::map<std::string, std::function<void(const std::string& value, TestSpec* spec)>> testSpecTestKeys = {
	{ "testTitle",
	  [](const std::string& value, TestSpec* spec) {
	      spec->title = value;
	      TraceEvent("TestParserTest").detail("ParsedTest", spec->title);
	  } },
	{ "timeout",
	  [](const std::string& value, TestSpec* spec) {
	      sscanf(value.c_str(), "%d", &(spec->timeout));
	      ASSERT(spec->timeout > 0);
	      TraceEvent("TestParserTest").detail("ParsedTimeout", spec->timeout);
	  } },
	{ "databasePingDelay",
	  [](const std::string& value, TestSpec* spec) {
	      double databasePingDelay;
	      sscanf(value.c_str(), "%lf", &databasePingDelay);
	      ASSERT(databasePingDelay >= 0);
	      if (!spec->useDB && databasePingDelay > 0) {
		      TraceEvent(SevError, "TestParserError")
		          .detail("Reason", "Cannot have non-zero ping delay on test that does not use database")
		          .detail("PingDelay", databasePingDelay)
		          .detail("UseDB", spec->useDB);
		      ASSERT(false);
	      }
	      spec->databasePingDelay = databasePingDelay;
	      TraceEvent("TestParserTest").detail("ParsedPingDelay", spec->databasePingDelay);
	  } },
	{ "runSetup",
	  [](const std::string& value, TestSpec* spec) {
	      spec->phases = TestWorkload::EXECUTION | TestWorkload::CHECK | TestWorkload::METRICS;
	      if (value == "true")
		      spec->phases |= TestWorkload::SETUP;
	      TraceEvent("TestParserTest").detail("ParsedSetupFlag", (spec->phases & TestWorkload::SETUP) != 0);
	  } },
	{ "dumpAfterTest",
	  [](const std::string& value, TestSpec* spec) {
	      spec->dumpAfterTest = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedDumpAfter", spec->dumpAfterTest);
	  } },
	{ "clearAfterTest",
	  [](const std::string& value, TestSpec* spec) {
	      spec->clearAfterTest = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedClearAfter", spec->clearAfterTest);
	  } },
	{ "useDB",
	  [](const std::string& value, TestSpec* spec) {
	      spec->useDB = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedUseDB", spec->useDB);
	      if (!spec->useDB)
		      spec->databasePingDelay = 0.0;
	  } },
	{ "startDelay",
	  [](const std::string& value, TestSpec* spec) {
	      sscanf(value.c_str(), "%lf", &spec->startDelay);
	      TraceEvent("TestParserTest").detail("ParsedStartDelay", spec->startDelay);
	  } },
	{ "runConsistencyCheck",
	  [](const std::string& value, TestSpec* spec) {
	      spec->runConsistencyCheck = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedRunConsistencyCheck", spec->runConsistencyCheck);
	  } },
	{ "runConsistencyCheckOnTSS",
	  [](const std::string& value, TestSpec* spec) {
	      spec->runConsistencyCheckOnTSS = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedRunConsistencyCheckOnTSS", spec->runConsistencyCheckOnTSS);
	  } },
	{ "maxDDRunTime",
	  [](const std::string& value, TestSpec* spec) {
	      sscanf(value.c_str(), "%lf", &(spec->maxDDRunTime));
	      ASSERT(spec->maxDDRunTime >= 0);
	      TraceEvent("TestParserTest").detail("ParsedMaxDDRunTime", spec->maxDDRunTime);
	  } },
	{ "waitForQuiescence",
	  [](const std::string& value, TestSpec* spec) {
	      bool toWait = value == "true";
	      spec->waitForQuiescenceBegin = toWait;
	      spec->waitForQuiescenceEnd = toWait;
	      TraceEvent("TestParserTest").detail("ParsedWaitForQuiescence", toWait);
	  } },
	{ "waitForQuiescenceBegin",
	  [](const std::string& value, TestSpec* spec) {
	      bool toWait = value == "true";
	      spec->waitForQuiescenceBegin = toWait;
	      TraceEvent("TestParserTest").detail("ParsedWaitForQuiescenceBegin", toWait);
	  } },
	{ "waitForQuiescenceEnd",
	  [](const std::string& value, TestSpec* spec) {
	      bool toWait = value == "true";
	      spec->waitForQuiescenceEnd = toWait;
	      TraceEvent("TestParserTest").detail("ParsedWaitForQuiescenceEnd", toWait);
	  } },
	{ "simCheckRelocationDuration",
	  [](const std::string& value, TestSpec* spec) {
	      spec->simCheckRelocationDuration = (value == "true");
	      TraceEvent("TestParserTest").detail("ParsedSimCheckRelocationDuration", spec->simCheckRelocationDuration);
	  } },
	{ "connectionFailuresDisableDuration",
	  [](const std::string& value, TestSpec* spec) {
	      double connectionFailuresDisableDuration;
	      sscanf(value.c_str(), "%lf", &connectionFailuresDisableDuration);
	      ASSERT(connectionFailuresDisableDuration >= 0);
	      spec->simConnectionFailuresDisableDuration = connectionFailuresDisableDuration;
	      TraceEvent("TestParserTest")
	          .detail("ParsedSimConnectionFailuresDisableDuration", spec->simConnectionFailuresDisableDuration);
	  } },
	{ "simBackupAgents",
	  [](const std::string& value, TestSpec* spec) {
	      if (value == "BackupToFile" || value == "BackupToFileAndDB")
		      spec->simBackupAgents = ISimulator::BackupAgentType::BackupToFile;
	      else
		      spec->simBackupAgents = ISimulator::BackupAgentType::NoBackupAgents;
	      TraceEvent("TestParserTest").detail("ParsedSimBackupAgents", spec->simBackupAgents);

	      if (value == "BackupToDB" || value == "BackupToFileAndDB")
		      spec->simDrAgents = ISimulator::BackupAgentType::BackupToDB;
	      else
		      spec->simDrAgents = ISimulator::BackupAgentType::NoBackupAgents;
	      TraceEvent("TestParserTest").detail("ParsedSimDrAgents", spec->simDrAgents);
	  } },
	{ "checkOnly",
	  [](const std::string& value, TestSpec* spec) {
	      if (value == "true")
		      spec->phases = TestWorkload::CHECK;
	  } },
	{ "restorePerpetualWiggleSetting",
	  [](const std::string& value, TestSpec* spec) {
	      if (value == "false")
		      spec->restorePerpetualWiggleSetting = false;
	  } },
	{ "runFailureWorkloads",
	  [](const std::string& value, TestSpec* spec) { spec->runFailureWorkloads = (value == "true"); } },
	{ "disabledFailureInjectionWorkloads",
	  [](const std::string& value, TestSpec* spec) {
	      // Expects a comma separated list of workload names in "value".
	      // This custom encoding is needed because both text and toml files need to be supported
	      // and "value" is passed in as a string.
	      std::stringstream ss(value);
	      while (ss.good()) {
		      std::string substr;
		      getline(ss, substr, ',');
		      substr = removeWhitespace(substr);
		      if (!substr.empty()) {
			      spec->disabledFailureInjectionWorkloads.push_back(substr);
		      }
	      }
	  } },
};

std::vector<TestSpec> readTests(std::ifstream& ifs) {
	TestSpec spec;
	std::vector<TestSpec> result;
	Standalone<VectorRef<KeyValueRef>> workloadOptions;
	std::string cline;
	bool beforeFirstTest = true;
	bool parsingWorkloads = false;

	while (ifs.good()) {
		getline(ifs, cline);
		std::string line = removeWhitespace(cline);
		if (!line.size() || line.find(';') == 0)
			continue;

		size_t found = line.find('=');
		if (found == std::string::npos)
			// hmmm, not good
			continue;
		std::string attrib = removeWhitespace(line.substr(0, found));
		std::string value = removeWhitespace(line.substr(found + 1));

		if (attrib == "testTitle") {
			beforeFirstTest = false;
			parsingWorkloads = false;
			if (workloadOptions.size()) {
				spec.options.push_back_deep(spec.options.arena(), workloadOptions);
				workloadOptions = Standalone<VectorRef<KeyValueRef>>();
			}
			if (spec.options.size() && spec.title.size()) {
				result.push_back(spec);
				spec = TestSpec();
			}

			testSpecTestKeys[attrib](value, &spec);
		} else if (testSpecTestKeys.find(attrib) != testSpecTestKeys.end()) {
			if (parsingWorkloads)
				TraceEvent(SevError, "TestSpecTestParamInWorkload").detail("Attrib", attrib).detail("Value", value);
			testSpecTestKeys[attrib](value, &spec);
		} else if (testSpecGlobalKeys.find(attrib) != testSpecGlobalKeys.end()) {
			if (!beforeFirstTest)
				TraceEvent(SevError, "TestSpecGlobalParamInTest").detail("Attrib", attrib).detail("Value", value);
			testSpecGlobalKeys[attrib](value);
		} else {
			if (attrib == "testName") {
				parsingWorkloads = true;
				if (workloadOptions.size()) {
					TraceEvent("TestParserFlush").detail("Reason", "new (compound) test");
					spec.options.push_back_deep(spec.options.arena(), workloadOptions);
					workloadOptions = Standalone<VectorRef<KeyValueRef>>();
				}
			}

			workloadOptions.push_back_deep(workloadOptions.arena(), KeyValueRef(StringRef(attrib), StringRef(value)));
			TraceEvent("TestParserOption").detail("ParsedKey", attrib).detail("ParsedValue", value);
		}
	}
	if (workloadOptions.size())
		spec.options.push_back_deep(spec.options.arena(), workloadOptions);
	if (spec.options.size() && spec.title.size()) {
		result.push_back(spec);
	}

	return result;
}

template <typename T>
std::string toml_to_string(const T& value) {
	// TOML formatting converts numbers to strings exactly how they're in the file
	// and thus, is equivalent to testspec.  However, strings are quoted, so we
	// must remove the quotes.
	if (value.type() == toml::value_t::string) {
		const std::string& formatted = toml::format(value);
		return formatted.substr(1, formatted.size() - 2);
	} else {
		return toml::format(value);
	}
}

struct TestSet {
	KnobKeyValuePairs overrideKnobs;
	std::vector<TestSpec> testSpecs;
};

namespace {

// In the current TOML scope, look for "knobs" field. If exists, translate all
// key value pairs into KnobKeyValuePairs
KnobKeyValuePairs getOverriddenKnobKeyValues(const toml::value& context) {
	KnobKeyValuePairs result;

	try {
		const toml::array& overrideKnobs = toml::find(context, "knobs").as_array();
		for (const toml::value& knob : overrideKnobs) {
			for (const auto& [key, value_] : knob.as_table()) {
				const std::string& value = toml_to_string(value_);
				ParsedKnobValue parsedValue = CLIENT_KNOBS->parseKnobValue(key, value);
				if (std::get_if<NoKnobFound>(&parsedValue)) {
					parsedValue = SERVER_KNOBS->parseKnobValue(key, value);
				}
				if (std::get_if<NoKnobFound>(&parsedValue)) {
					parsedValue = FLOW_KNOBS->parseKnobValue(key, value);
				}
				if (std::get_if<NoKnobFound>(&parsedValue)) {
					TraceEvent(SevError, "TestSpecUnrecognizedKnob")
					    .detail("KnobName", key)
					    .detail("OverrideValue", value);
					continue;
				}
				result.set(key, parsedValue);
			}
		}
	} catch (const std::out_of_range&) {
		// No knobs field in this scope, this is not an error
	}

	return result;
}

} // namespace

TestSet readTOMLTests_(std::string fileName) {
	Standalone<VectorRef<KeyValueRef>> workloadOptions;
	TestSet result;

	const toml::value& conf = toml::parse(fileName);

	// Parse the global knob changes
	result.overrideKnobs = getOverriddenKnobKeyValues(conf);

	// Then parse each test
	const toml::array& tests = toml::find(conf, "test").as_array();
	for (const toml::value& test : tests) {
		TestSpec spec;

		// First handle all test-level settings
		for (const auto& [k, v] : test.as_table()) {
			if (k == "workload" || k == "knobs") {
				continue;
			}
			if (testSpecTestKeys.find(k) != testSpecTestKeys.end()) {
				testSpecTestKeys[k](toml_to_string(v), &spec);
			} else {
				TraceEvent(SevError, "TestSpecUnrecognizedTestParam")
				    .detail("Attrib", k)
				    .detail("Value", toml_to_string(v));
			}
		}

		// And then copy the workload attributes to spec.options
		const toml::array& workloads = toml::find(test, "workload").as_array();
		for (const toml::value& workload : workloads) {
			workloadOptions = Standalone<VectorRef<KeyValueRef>>();
			TraceEvent("TestParserFlush").detail("Reason", "new (compound) test");
			for (const auto& [attrib, v] : workload.as_table()) {
				const std::string& value = toml_to_string(v);
				workloadOptions.push_back_deep(workloadOptions.arena(),
				                               KeyValueRef(StringRef(attrib), StringRef(value)));
				TraceEvent("TestParserOption").detail("ParsedKey", attrib).detail("ParsedValue", value);
			}
			spec.options.push_back_deep(spec.options.arena(), workloadOptions);
		}

		// And then copy the knob attributes to spec.overrideKnobs
		spec.overrideKnobs = getOverriddenKnobKeyValues(test);

		result.testSpecs.push_back(spec);
	}

	return result;
}

// A hack to catch and log std::exception, because TOML11 has very useful
// error messages, but the actor framework can't handle std::exception.
TestSet readTOMLTests(std::string fileName) {
	try {
		return readTOMLTests_(fileName);
	} catch (std::exception& e) {
		std::cerr << e.what() << std::endl;
		TraceEvent("TOMLParseError").detail("Error", printable(e.what()));
		// TODO: replace with toml_parse_error();
		throw unknown_error();
	}
}

															#line 16204 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorServerDBInfo()
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class MonitorServerDBInfoActor>
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class MonitorServerDBInfoActorState {
															#line 16211 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	MonitorServerDBInfoActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : ccInterface(ccInterface),
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   locality(locality),
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(dbInfo)
															#line 16222 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorServerDBInfo", reinterpret_cast<unsigned long>(this));

	}
	~MonitorServerDBInfoActorState() 
	{
		fdb_probe_actor_destroy("monitorServerDBInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2427 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ServerDBInfo localInfo;
															#line 2428 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			localInfo.myLocality = locality;
															#line 2429 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			dbInfo->set(localInfo);
															#line 2431 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 16243 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorServerDBInfoActorState();
		static_cast<MonitorServerDBInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2432 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		GetServerDBInfoRequest req;
															#line 2433 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		req.knownServerInfoID = dbInfo->get().id;
															#line 2436 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<ServerDBInfo> __when_expr_0 = ccInterface->get().present() ? brokenPromiseToNever(ccInterface->get().get().getServerDBInfo.getReply(req)) : Never();
															#line 2435 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (static_cast<MonitorServerDBInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16279 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2451 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ccInterface->onChange();
															#line 16283 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerDBInfoActor*>(this)->actor_wait_state = 1;
															#line 2436 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*>(static_cast<MonitorServerDBInfoActor*>(this)));
															#line 2451 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerDBInfoActor, 1, Void >*>(static_cast<MonitorServerDBInfoActor*>(this)));
															#line 16290 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ServerDBInfo const& _localInfo,int loopDepth) 
	{
															#line 2440 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ServerDBInfo localInfo = _localInfo;
															#line 2441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID());
															#line 2448 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		localInfo.myLocality = locality;
															#line 2449 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		dbInfo->set(localInfo);
															#line 16311 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ServerDBInfo && _localInfo,int loopDepth) 
	{
															#line 2440 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ServerDBInfo localInfo = _localInfo;
															#line 2441 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID());
															#line 2448 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		localInfo.myLocality = locality;
															#line 2449 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		dbInfo->set(localInfo);
															#line 16326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (ccInterface->get().present())
															#line 16335 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("GotCCInterfaceChange") .detail("CCID", ccInterface->get().get().id()) .detail("CCMachine", ccInterface->get().get().getWorkers.getEndpoint().getPrimaryAddress());
															#line 16339 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (ccInterface->get().present())
															#line 16349 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2453 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("GotCCInterfaceChange") .detail("CCID", ccInterface->get().get().id()) .detail("CCMachine", ccInterface->get().get().getWorkers.getEndpoint().getPrimaryAddress());
															#line 16353 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorServerDBInfoActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerDBInfoActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerDBInfoActor*>(this)->ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >::remove();
		static_cast<MonitorServerDBInfoActor*>(this)->ActorCallback< MonitorServerDBInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*,ServerDBInfo const& value) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*,ServerDBInfo && value) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerDBInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorServerDBInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorServerDBInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> ccInterface;
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	LocalityData locality;
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 16486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorServerDBInfo()
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class MonitorServerDBInfoActor final : public Actor<Void>, public ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >, public ActorCallback< MonitorServerDBInfoActor, 1, Void >, public FastAllocated<MonitorServerDBInfoActor>, public MonitorServerDBInfoActorState<MonitorServerDBInfoActor> {
															#line 16491 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorServerDBInfoActor>::operator new;
	using FastAllocated<MonitorServerDBInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13223783879868554752UL, 10616286436464893696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >;
friend struct ActorCallback< MonitorServerDBInfoActor, 1, Void >;
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	MonitorServerDBInfoActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 16509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorServerDBInfoActorState<MonitorServerDBInfoActor>(ccInterface, locality, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13073893316168406016UL, 9873335748166095872UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerDBInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorServerDBInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorServerDBInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorServerDBInfoActor, 0, ServerDBInfo >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> monitorServerDBInfo( Reference<AsyncVar<Optional<ClusterControllerFullInterface>>> const& ccInterface, LocalityData const& locality, Reference<AsyncVar<ServerDBInfo>> const& dbInfo ) {
															#line 2423 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new MonitorServerDBInfoActor(ccInterface, locality, dbInfo));
															#line 16542 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 2460 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

															#line 16547 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via initializeSimConfig()
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class InitializeSimConfigActor>
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class InitializeSimConfigActorState {
															#line 16554 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	InitializeSimConfigActorState(Database const& db) 
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : db(db),
															#line 2462 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tr(db)
															#line 16563 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("initializeSimConfig", reinterpret_cast<unsigned long>(this));

	}
	~InitializeSimConfigActorState() 
	{
		fdb_probe_actor_destroy("initializeSimConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2463 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 2464 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			;
															#line 16580 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitializeSimConfigActorState();
		static_cast<InitializeSimConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(&tr);
															#line 2466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<InitializeSimConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16613 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitializeSimConfigActor*>(this)->actor_wait_state = 1;
															#line 2466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*>(static_cast<InitializeSimConfigActor*>(this)));
															#line 16618 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 2511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<InitializeSimConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16642 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<InitializeSimConfigActor*>(this)->actor_wait_state = 2;
															#line 2511 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializeSimConfigActor, 1, Void >*>(static_cast<InitializeSimConfigActor*>(this)));
															#line 16647 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(DatabaseConfiguration const& dbConfig,int loopDepth) 
	{
															#line 2467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->storagePolicy = dbConfig.storagePolicy;
															#line 2468 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogPolicy = dbConfig.tLogPolicy;
															#line 2469 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogWriteAntiQuorum = dbConfig.tLogWriteAntiQuorum;
															#line 2470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->usableRegions = dbConfig.usableRegions;
															#line 2476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		bool foundSharedDcId = false;
															#line 2477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::set<Key> dcIds;
															#line 2478 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		int maxSatelliteReplication = 0;
															#line 2479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( auto const& r : dbConfig.regions ) {
															#line 2480 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!dcIds.insert(r.dcId).second)
															#line 16678 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2481 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				foundSharedDcId = true;
															#line 16682 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2483 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!r.satellites.empty() && r.satelliteTLogReplicationFactor > 0 && r.satelliteTLogUsableDcs > 0)
															#line 16686 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2484 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				for( auto const& s : r.satellites ) {
															#line 2485 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (!dcIds.insert(s.dcId).second)
															#line 16692 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					{
															#line 2486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						foundSharedDcId = true;
															#line 16696 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					}
				}
															#line 2490 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				maxSatelliteReplication = std::max(maxSatelliteReplication, r.satelliteTLogReplicationFactor / r.satelliteTLogUsableDcs);
															#line 16701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 2495 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (foundSharedDcId)
															#line 16706 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2496 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			int totalRequired = std::max(dbConfig.tLogReplicationFactor, dbConfig.remoteTLogReplicationFactor) + maxSatelliteReplication;
															#line 2498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteTLogPolicy = Reference<IReplicationPolicy>( new PolicyAcross(totalRequired, "zoneid", Reference<IReplicationPolicy>(new PolicyOne())));
															#line 2500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("ChangingSimTLogPolicyForSharedRemote") .detail("TotalRequired", totalRequired) .detail("MaxSatelliteReplication", maxSatelliteReplication) .detail("ActualPolicy", dbConfig.getRemoteTLogPolicy()->info()) .detail("SimulatorPolicy", g_simulator->remoteTLogPolicy->info());
															#line 16714 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteTLogPolicy = dbConfig.getRemoteTLogPolicy();
															#line 16720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<InitializeSimConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeSimConfigActorState(); static_cast<InitializeSimConfigActor*>(this)->destroy(); return 0; }
															#line 16724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<InitializeSimConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeSimConfigActorState();
		static_cast<InitializeSimConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(DatabaseConfiguration && dbConfig,int loopDepth) 
	{
															#line 2467 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->storagePolicy = dbConfig.storagePolicy;
															#line 2468 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogPolicy = dbConfig.tLogPolicy;
															#line 2469 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogWriteAntiQuorum = dbConfig.tLogWriteAntiQuorum;
															#line 2470 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->usableRegions = dbConfig.usableRegions;
															#line 2476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		bool foundSharedDcId = false;
															#line 2477 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::set<Key> dcIds;
															#line 2478 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		int maxSatelliteReplication = 0;
															#line 2479 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for( auto const& r : dbConfig.regions ) {
															#line 2480 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!dcIds.insert(r.dcId).second)
															#line 16752 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2481 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				foundSharedDcId = true;
															#line 16756 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2483 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (!r.satellites.empty() && r.satelliteTLogReplicationFactor > 0 && r.satelliteTLogUsableDcs > 0)
															#line 16760 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2484 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				for( auto const& s : r.satellites ) {
															#line 2485 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
					if (!dcIds.insert(s.dcId).second)
															#line 16766 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					{
															#line 2486 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
						foundSharedDcId = true;
															#line 16770 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
					}
				}
															#line 2490 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				maxSatelliteReplication = std::max(maxSatelliteReplication, r.satelliteTLogReplicationFactor / r.satelliteTLogUsableDcs);
															#line 16775 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 2495 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (foundSharedDcId)
															#line 16780 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2496 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			int totalRequired = std::max(dbConfig.tLogReplicationFactor, dbConfig.remoteTLogReplicationFactor) + maxSatelliteReplication;
															#line 2498 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteTLogPolicy = Reference<IReplicationPolicy>( new PolicyAcross(totalRequired, "zoneid", Reference<IReplicationPolicy>(new PolicyOne())));
															#line 2500 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("ChangingSimTLogPolicyForSharedRemote") .detail("TotalRequired", totalRequired) .detail("MaxSatelliteReplication", maxSatelliteReplication) .detail("ActualPolicy", dbConfig.getRemoteTLogPolicy()->info()) .detail("SimulatorPolicy", g_simulator->remoteTLogPolicy->info());
															#line 16788 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteTLogPolicy = dbConfig.getRemoteTLogPolicy();
															#line 16794 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2509 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<InitializeSimConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeSimConfigActorState(); static_cast<InitializeSimConfigActor*>(this)->destroy(); return 0; }
															#line 16798 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<InitializeSimConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeSimConfigActorState();
		static_cast<InitializeSimConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(DatabaseConfiguration const& dbConfig,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(dbConfig, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(DatabaseConfiguration && dbConfig,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(dbConfig), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitializeSimConfigActor*>(this)->actor_wait_state > 0) static_cast<InitializeSimConfigActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeSimConfigActor*>(this)->ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitializeSimConfigActor*>(this)->actor_wait_state > 0) static_cast<InitializeSimConfigActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeSimConfigActor*>(this)->ActorCallback< InitializeSimConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeSimConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitializeSimConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitializeSimConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Database db;
															#line 2462 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	Transaction tr;
															#line 16972 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via initializeSimConfig()
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class InitializeSimConfigActor final : public Actor<Void>, public ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >, public ActorCallback< InitializeSimConfigActor, 1, Void >, public FastAllocated<InitializeSimConfigActor>, public InitializeSimConfigActorState<InitializeSimConfigActor> {
															#line 16977 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<InitializeSimConfigActor>::operator new;
	using FastAllocated<InitializeSimConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1565517202502201344UL, 16952556678092208128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< InitializeSimConfigActor, 1, Void >;
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	InitializeSimConfigActor(Database const& db) 
															#line 16995 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   InitializeSimConfigActorState<InitializeSimConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initializeSimConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5496461681839818496UL, 4488760119134195712UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeSimConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initializeSimConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initializeSimConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitializeSimConfigActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitializeSimConfigActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> initializeSimConfig( Database const& db ) {
															#line 2461 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new InitializeSimConfigActor(db));
															#line 17029 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 2515 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

void encryptionAtRestPlaintextMarkerCheck() {
	if (!g_network->isSimulated() || !g_simulator->dataAtRestPlaintextMarker.present()) {
		// Encryption at-rest was not enabled, do nothing
		return;
	}

	namespace fs = std::filesystem;

	printf("EncryptionAtRestPlaintextMarkerCheckStart\n");
	TraceEvent("EncryptionAtRestPlaintextMarkerCheckStart");
	fs::path p("simfdb/");
	fs::recursive_directory_iterator end;
	int scanned = 0;
	bool success = true;
	// Enumerate all files in the "simfdb/" folder and look for "marker" string
	for (fs::recursive_directory_iterator itr(p); itr != end; ++itr) {
		if (fs::is_regular_file(itr->path())) {
			std::ifstream f(itr->path());
			if (f) {
				std::string buf;
				int count = 0;
				while (std::getline(f, buf)) {
					// SOMEDAY: using 'std::boyer_moore_horspool_searcher' would significantly improve search
					// time
					if (!g_network->isSimulated() || !ENABLE_MUTATION_TRACKING_WITH_BLOB_CIPHER) {
						if (buf.find(g_simulator->dataAtRestPlaintextMarker.get()) != std::string::npos) {
							TraceEvent(SevError, "EncryptionAtRestPlaintextMarkerCheckPanic")
							    .detail("Filename", itr->path().string())
							    .detail("LineBuf", buf)
							    .detail("Marker", g_simulator->dataAtRestPlaintextMarker.get());
							success = false;
						}
					}
					count++;
				}
				TraceEvent("EncryptionAtRestPlaintextMarkerCheckScanned")
				    .detail("Filename", itr->path().string())
				    .detail("NumLines", count);
				scanned++;
				if (itr->path().string().find("storage") != std::string::npos) {
					CODE_PROBE(true,
					           "EncryptionAtRestPlaintextMarkerCheckScanned storage file scanned",
					           probe::decoration::rare);
				} else if (itr->path().string().find("logqueue") != std::string::npos) {
					CODE_PROBE(
					    true, "EncryptionAtRestPlaintextMarkerCheckScanned TLog file scanned", probe::decoration::rare);
				} else if (itr->path().string().find("backup") != std::string::npos) {
					CODE_PROBE(true,
					           "EncryptionAtRestPlaintextMarkerCheckScanned KVBackup file scanned",
					           probe::decoration::rare);
				}
			} else {
				TraceEvent(SevError, "FileOpenError").detail("Filename", itr->path().string());
			}
		}
		ASSERT(success);
	}
	printf("EncryptionAtRestPlaintextMarkerCheckEnd NumFiles: %d\n", scanned);
	TraceEvent("EncryptionAtRestPlaintextMarkerCheckEnd").detail("NumFiles", scanned);
}

// Disables connection failures after the given time seconds
															#line 17096 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via disableConnectionFailuresAfter()
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class DisableConnectionFailuresAfterActor>
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class DisableConnectionFailuresAfterActorState {
															#line 17103 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DisableConnectionFailuresAfterActorState(double const& seconds,std::string const& context) 
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : seconds(seconds),
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   context(context)
															#line 17112 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this));

	}
	~DisableConnectionFailuresAfterActorState() 
	{
		fdb_probe_actor_destroy("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2579 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 17127 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2580 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				TraceEvent(SevWarnAlways, ("ScheduleDisableConnectionFailures_" + context).c_str()) .detail("At", now() + seconds);
															#line 2582 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(seconds);
															#line 2582 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17135 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state = 1;
															#line 2582 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*>(static_cast<DisableConnectionFailuresAfterActor*>(this)));
															#line 17140 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DisableConnectionFailuresAfterActorState();
		static_cast<DisableConnectionFailuresAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2594 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!static_cast<DisableConnectionFailuresAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DisableConnectionFailuresAfterActorState(); static_cast<DisableConnectionFailuresAfterActor*>(this)->destroy(); return 0; }
															#line 17168 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		new (&static_cast<DisableConnectionFailuresAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DisableConnectionFailuresAfterActorState();
		static_cast<DisableConnectionFailuresAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2583 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 17180 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2583 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 17189 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state > 0) static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConnectionFailuresAfterActor*>(this)->ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 2584 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		double delaySeconds = disableConnectionFailures(context, ForceDisable::False);
															#line 2585 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (delaySeconds > DISABLE_CONNECTION_FAILURE_MIN_INTERVAL)
															#line 17288 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2586 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(delaySeconds);
															#line 2586 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17294 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state = 2;
															#line 2586 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*>(static_cast<DisableConnectionFailuresAfterActor*>(this)));
															#line 17299 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state > 0) static_cast<DisableConnectionFailuresAfterActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConnectionFailuresAfterActor*>(this)->ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	double seconds;
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	std::string context;
															#line 17419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
};
// This generated class is to be used only via disableConnectionFailuresAfter()
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class DisableConnectionFailuresAfterActor final : public Actor<Void>, public ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >, public ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >, public FastAllocated<DisableConnectionFailuresAfterActor>, public DisableConnectionFailuresAfterActorState<DisableConnectionFailuresAfterActor> {
															#line 17424 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
	using FastAllocated<DisableConnectionFailuresAfterActor>::operator new;
	using FastAllocated<DisableConnectionFailuresAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2239840859640002816UL, 11417685721918632192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >;
friend struct ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >;
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	DisableConnectionFailuresAfterActor(double const& seconds,std::string const& context) 
															#line 17442 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DisableConnectionFailuresAfterActorState<DisableConnectionFailuresAfterActor>(seconds, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13243507383148206080UL, 6263835815856420864UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConnectionFailuresAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("disableConnectionFailuresAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("disableConnectionFailuresAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DisableConnectionFailuresAfterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DisableConnectionFailuresAfterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
[[nodiscard]] Future<Void> disableConnectionFailuresAfter( double const& seconds, std::string const& context ) {
															#line 2578 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	return Future<Void>(new DisableConnectionFailuresAfterActor(seconds, context));
															#line 17476 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
}

#line 2596 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"

/**
 * \brief Test orchestrator: sends test specification to testers in the right order and collects the results.
 *
 * There are multiple actors in this file with similar names (runTest, runTests) and slightly different signatures.
 *
 * This is the actual orchestrator. It reads the test specifications (from tests), prepares the cluster (by running the
 * configure command given in startingConfiguration) and then runs the workload.
 *
 * \param cc The cluster controller interface
 * \param ci Same as cc.clientInterface
 * \param testers The interfaces of the testers that should run the actual workloads
 * \param tests The test specifications to run
 * \param startingConfiguration If non-empty, the orchestrator will attempt to set this configuration before starting
 * the tests.
 * \param locality client locality (it seems this is unused?)
 *
 * \returns A future which will be set after all tests finished.
 */
															#line 17499 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via runTests()
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
template <class RunTestsActor>
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
class RunTestsActorState {
															#line 17506 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
public:
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
	RunTestsActorState(Reference<AsyncVar<Optional<struct ClusterControllerFullInterface>>> const& cc,Reference<AsyncVar<Optional<struct ClusterInterface>>> const& ci,std::vector<TesterInterface> const& testers,std::vector<TestSpec> const& tests,StringRef const& startingConfiguration,LocalityData const& locality,bool const& restartingTest) 
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		 : cc(cc),
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ci(ci),
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   testers(testers),
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   tests(tests),
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startingConfiguration(startingConfiguration),
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   locality(locality),
															#line 2615 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   restartingTest(restartingTest),
															#line 2622 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   cx(),
															#line 2623 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   dbInfo(new AsyncVar<ServerDBInfo>),
															#line 2624 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   ccMonitor(monitorServerDBInfo(cc, LocalityData(), dbInfo)),
															#line 2626 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   useDB(false),
															#line 2627 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   waitForQuiescenceBegin(false),
															#line 2628 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   waitForQuiescenceEnd(false),
															#line 2629 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   restorePerpetualWiggleSetting(false),
															#line 2630 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   perpetualWiggleEnabled(false),
															#line 2631 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   backupWorkerEnabled(false),
															#line 2632 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   startDelay(0.0),
															#line 2633 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   databasePingDelay(1e9),
															#line 2634 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   simBackupAgents(ISimulator::BackupAgentType::NoBackupAgents),
															#line 2635 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   simDrAgents(ISimulator::BackupAgentType::NoBackupAgents),
															#line 2636 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   enableDD(false),
															#line 2637 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		   consistencyScanState()
															#line 17555 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("runTests", reinterpret_cast<unsigned long>(this));

	}
	~RunTestsActorState() 
	{
		fdb_probe_actor_destroy("runTests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yield();
															#line 2641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17572 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 1;
															#line 2641 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 0, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 17577 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunTestsActorState();
		static_cast<RunTestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2643 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (tests.empty())
															#line 17600 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2644 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			useDB = true;
															#line 17604 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2645 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(auto iter = tests.begin();iter != tests.end();++iter) {
															#line 2646 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->useDB)
															#line 17610 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2647 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				useDB = true;
															#line 17614 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2648 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->waitForQuiescenceBegin)
															#line 17618 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2649 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				waitForQuiescenceBegin = true;
															#line 17622 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->waitForQuiescenceEnd)
															#line 17626 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2651 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				waitForQuiescenceEnd = true;
															#line 17630 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2652 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->restorePerpetualWiggleSetting)
															#line 17634 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2653 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				restorePerpetualWiggleSetting = true;
															#line 17638 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			startDelay = std::max(startDelay, iter->startDelay);
															#line 2655 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databasePingDelay = std::min(databasePingDelay, iter->databasePingDelay);
															#line 2656 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->simBackupAgents != ISimulator::BackupAgentType::NoBackupAgents)
															#line 17646 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2657 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				simBackupAgents = iter->simBackupAgents;
															#line 17650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->simDrAgents != ISimulator::BackupAgentType::NoBackupAgents)
															#line 17654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2660 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				simDrAgents = iter->simDrAgents;
															#line 17658 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			enableDD = enableDD || getOption(iter->options[0], "enableDD"_sr, false);
															#line 17662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2665 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated())
															#line 17666 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2666 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->backupAgents = simBackupAgents;
															#line 2667 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->drAgents = simDrAgents;
															#line 17672 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!useDB)
															#line 17676 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2672 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databasePingDelay = 0.0;
															#line 17680 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2674 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB)
															#line 17684 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2675 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx = openDBOnServer(dbInfo);
															#line 17688 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2678 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.enabled = g_network->isSimulated() && deterministicRandom()->coinflip();
															#line 2679 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.waitForComplete = consistencyScanState.enabled && waitForQuiescenceEnd && deterministicRandom()->coinflip();
															#line 2681 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.enableAfter = consistencyScanState.waitForComplete && deterministicRandom()->random01() < 0.1;
															#line 2683 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		disableConnectionFailures("Tester");
															#line 2686 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("startingConfiguration:%s start\n", startingConfiguration.toString().c_str());
															#line 2687 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		fmt::print("useDB: {}\n", useDB);
															#line 2688 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printSimulatedTopology();
															#line 2689 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB && startingConfiguration != StringRef())
															#line 17706 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 2691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_1 = timeoutError(changeConfiguration(cx, testers, startingConfiguration), 2000.0);
															#line 2691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 17713 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RunTestsActor*>(this)->actor_wait_state = 2;
															#line 2691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 1, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 17718 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2643 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (tests.empty())
															#line 17738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2644 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			useDB = true;
															#line 17742 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2645 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		for(auto iter = tests.begin();iter != tests.end();++iter) {
															#line 2646 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->useDB)
															#line 17748 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2647 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				useDB = true;
															#line 17752 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2648 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->waitForQuiescenceBegin)
															#line 17756 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2649 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				waitForQuiescenceBegin = true;
															#line 17760 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2650 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->waitForQuiescenceEnd)
															#line 17764 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2651 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				waitForQuiescenceEnd = true;
															#line 17768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2652 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->restorePerpetualWiggleSetting)
															#line 17772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2653 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				restorePerpetualWiggleSetting = true;
															#line 17776 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2654 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			startDelay = std::max(startDelay, iter->startDelay);
															#line 2655 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databasePingDelay = std::min(databasePingDelay, iter->databasePingDelay);
															#line 2656 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->simBackupAgents != ISimulator::BackupAgentType::NoBackupAgents)
															#line 17784 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2657 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				simBackupAgents = iter->simBackupAgents;
															#line 17788 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2659 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (iter->simDrAgents != ISimulator::BackupAgentType::NoBackupAgents)
															#line 17792 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2660 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				simDrAgents = iter->simDrAgents;
															#line 17796 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2662 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			enableDD = enableDD || getOption(iter->options[0], "enableDD"_sr, false);
															#line 17800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2665 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated())
															#line 17804 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2666 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->backupAgents = simBackupAgents;
															#line 2667 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->drAgents = simDrAgents;
															#line 17810 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2671 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!useDB)
															#line 17814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2672 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			databasePingDelay = 0.0;
															#line 17818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2674 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB)
															#line 17822 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2675 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			cx = openDBOnServer(dbInfo);
															#line 17826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2678 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.enabled = g_network->isSimulated() && deterministicRandom()->coinflip();
															#line 2679 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.waitForComplete = consistencyScanState.enabled && waitForQuiescenceEnd && deterministicRandom()->coinflip();
															#line 2681 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		consistencyScanState.enableAfter = consistencyScanState.waitForComplete && deterministicRandom()->random01() < 0.1;
															#line 2683 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		disableConnectionFailures("Tester");
															#line 2686 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printf("startingConfiguration:%s start\n", startingConfiguration.toString().c_str());
															#line 2687 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		fmt::print("useDB: {}\n", useDB);
															#line 2688 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		printSimulatedTopology();
															#line 2689 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB && startingConfiguration != StringRef())
															#line 17844 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
			try {
															#line 2691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_1 = timeoutError(changeConfiguration(cx, testers, startingConfiguration), 2000.0);
															#line 2691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 17851 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RunTestsActor*>(this)->actor_wait_state = 2;
															#line 2691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 1, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 17856 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2715 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB && g_network->isSimulated())
															#line 17951 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2716 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_3 = getDatabaseConfiguration(cx);
															#line 2716 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17957 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 4;
															#line 2716 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 3, DatabaseConfiguration >*>(static_cast<RunTestsActor*>(this)));
															#line 17962 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont16(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
															#line 2698 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		std::string_view confView(reinterpret_cast<const char*>(startingConfiguration.begin()), startingConfiguration.size());
															#line 2700 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (restorePerpetualWiggleSetting)
															#line 17978 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2701 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			const std::string setting = "perpetual_storage_wiggle:=";
															#line 2702 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			auto pos = confView.find(setting);
															#line 2703 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (pos != confView.npos && confView.at(pos + setting.size()) == '1')
															#line 17986 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2704 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				perpetualWiggleEnabled = true;
															#line 17990 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 2707 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		const std::string bwSetting = "backup_worker_enabled:=";
															#line 2708 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		auto pos = confView.find(bwSetting);
															#line 2709 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (pos != confView.npos && confView.at(pos + bwSetting.size()) == '1')
															#line 17999 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2710 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			backupWorkerEnabled = true;
															#line 18003 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2696 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent(SevError, "TestFailure").error(e).detail("Reason", "Unable to set starting configuration");
															#line 18014 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = a_body1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15(Void const& _,int loopDepth) 
	{
															#line 2692 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && enableDD)
															#line 18029 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(setDDMode(cx, 1));
															#line 2693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 18035 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont15when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 3;
															#line 2693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 2, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18040 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont15(Void && _,int loopDepth) 
	{
															#line 2692 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (g_network->isSimulated() && enableDD)
															#line 18054 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(setDDMode(cx, 1));
															#line 2693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 18060 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont15when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 3;
															#line 2693 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 2, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18065 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont15cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont15cont1(int loopDepth) 
	{
		loopDepth = a_body1cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont15cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16(int loopDepth) 
	{
															#line 2772 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB)
															#line 18260 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2773 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (g_network->isSimulated())
															#line 18264 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2774 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_5 = initializeSimConfig(cx);
															#line 2774 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18270 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont16when1(__when_expr_5.get(), loopDepth); };
				static_cast<RunTestsActor*>(this)->actor_wait_state = 6;
															#line 2774 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 5, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18275 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont16cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont16cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont17(DatabaseConfiguration const& configuration,int loopDepth) 
	{
															#line 2718 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->storagePolicy = configuration.storagePolicy;
															#line 2719 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogPolicy = configuration.tLogPolicy;
															#line 2720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogWriteAntiQuorum = configuration.tLogWriteAntiQuorum;
															#line 2721 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->remoteTLogPolicy = configuration.remoteTLogPolicy;
															#line 2722 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->usableRegions = configuration.usableRegions;
															#line 2723 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (configuration.regions.size() > 0)
															#line 18304 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->primaryDcId = configuration.regions[0].dcId;
															#line 2725 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->hasSatelliteReplication = configuration.regions[0].satelliteTLogReplicationFactor > 0;
															#line 2726 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (configuration.regions[0].satelliteTLogUsableDcsFallback > 0)
															#line 18312 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2727 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogPolicyFallback = configuration.regions[0].satelliteTLogPolicyFallback;
															#line 2728 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogWriteAntiQuorumFallback = configuration.regions[0].satelliteTLogWriteAntiQuorumFallback;
															#line 18318 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2731 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogPolicyFallback = configuration.regions[0].satelliteTLogPolicy;
															#line 2732 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogWriteAntiQuorumFallback = configuration.regions[0].satelliteTLogWriteAntiQuorum;
															#line 18326 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogPolicy = configuration.regions[0].satelliteTLogPolicy;
															#line 2736 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogWriteAntiQuorum = configuration.regions[0].satelliteTLogWriteAntiQuorum;
															#line 2738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto s : configuration.regions[0].satellites ) {
															#line 2739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->primarySatelliteDcIds.push_back(s.dcId);
															#line 18336 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 2742 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->hasSatelliteReplication = false;
															#line 2743 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogWriteAntiQuorum = 0;
															#line 18345 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2746 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (configuration.regions.size() == 2)
															#line 18349 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteDcId = configuration.regions[1].dcId;
															#line 2748 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT((!configuration.regions[0].satelliteTLogPolicy && !configuration.regions[1].satelliteTLogPolicy) || configuration.regions[0].satelliteTLogPolicy->info() == configuration.regions[1].satelliteTLogPolicy->info());
															#line 2752 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto s : configuration.regions[1].satellites ) {
															#line 2753 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->remoteSatelliteDcIds.push_back(s.dcId);
															#line 18359 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 2757 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (restartingTest || g_simulator->usableRegions < 2 || !g_simulator->hasSatelliteReplication)
															#line 18364 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->allowLogSetKills = false;
															#line 18368 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2761 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(g_simulator->storagePolicy && g_simulator->tLogPolicy);
															#line 2762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(!g_simulator->hasSatelliteReplication || g_simulator->satelliteTLogPolicy);
															#line 2767 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (deterministicRandom()->random01() < 0.25)
															#line 18376 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_4 = customShardConfigWorkload(cx);
															#line 2768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18382 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont17when1(__when_expr_4.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 5;
															#line 2768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 4, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18387 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont17cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont17(DatabaseConfiguration && configuration,int loopDepth) 
	{
															#line 2718 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->storagePolicy = configuration.storagePolicy;
															#line 2719 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogPolicy = configuration.tLogPolicy;
															#line 2720 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->tLogWriteAntiQuorum = configuration.tLogWriteAntiQuorum;
															#line 2721 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->remoteTLogPolicy = configuration.remoteTLogPolicy;
															#line 2722 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		g_simulator->usableRegions = configuration.usableRegions;
															#line 2723 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (configuration.regions.size() > 0)
															#line 18411 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2724 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->primaryDcId = configuration.regions[0].dcId;
															#line 2725 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->hasSatelliteReplication = configuration.regions[0].satelliteTLogReplicationFactor > 0;
															#line 2726 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (configuration.regions[0].satelliteTLogUsableDcsFallback > 0)
															#line 18419 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			{
															#line 2727 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogPolicyFallback = configuration.regions[0].satelliteTLogPolicyFallback;
															#line 2728 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogWriteAntiQuorumFallback = configuration.regions[0].satelliteTLogWriteAntiQuorumFallback;
															#line 18425 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2731 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogPolicyFallback = configuration.regions[0].satelliteTLogPolicy;
															#line 2732 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->satelliteTLogWriteAntiQuorumFallback = configuration.regions[0].satelliteTLogWriteAntiQuorum;
															#line 18433 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
															#line 2735 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogPolicy = configuration.regions[0].satelliteTLogPolicy;
															#line 2736 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogWriteAntiQuorum = configuration.regions[0].satelliteTLogWriteAntiQuorum;
															#line 2738 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto s : configuration.regions[0].satellites ) {
															#line 2739 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->primarySatelliteDcIds.push_back(s.dcId);
															#line 18443 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 2742 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->hasSatelliteReplication = false;
															#line 2743 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->satelliteTLogWriteAntiQuorum = 0;
															#line 18452 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2746 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (configuration.regions.size() == 2)
															#line 18456 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2747 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->remoteDcId = configuration.regions[1].dcId;
															#line 2748 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			ASSERT((!configuration.regions[0].satelliteTLogPolicy && !configuration.regions[1].satelliteTLogPolicy) || configuration.regions[0].satelliteTLogPolicy->info() == configuration.regions[1].satelliteTLogPolicy->info());
															#line 2752 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			for( auto s : configuration.regions[1].satellites ) {
															#line 2753 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				g_simulator->remoteSatelliteDcIds.push_back(s.dcId);
															#line 18466 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			}
		}
															#line 2757 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (restartingTest || g_simulator->usableRegions < 2 || !g_simulator->hasSatelliteReplication)
															#line 18471 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2758 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			g_simulator->allowLogSetKills = false;
															#line 18475 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2761 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(g_simulator->storagePolicy && g_simulator->tLogPolicy);
															#line 2762 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		ASSERT(!g_simulator->hasSatelliteReplication || g_simulator->satelliteTLogPolicy);
															#line 2767 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (deterministicRandom()->random01() < 0.25)
															#line 18483 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_4 = customShardConfigWorkload(cx);
															#line 2768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18489 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont17when1(__when_expr_4.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 5;
															#line 2768 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 4, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18494 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont17cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(DatabaseConfiguration const& configuration,int loopDepth) 
	{
		loopDepth = a_body1cont17(configuration, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(DatabaseConfiguration && configuration,int loopDepth) 
	{
		loopDepth = a_body1cont17(std::move(configuration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 3, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 3, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 3, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 3, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont17cont1(int loopDepth) 
	{
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont17cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont17cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont17when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont17cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont17when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont17cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont17when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont17when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont16cont1(int loopDepth) 
	{
															#line 2778 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB && waitForQuiescenceBegin)
															#line 18676 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2779 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("TesterStartingPreTestChecks") .detail("DatabasePingDelay", databasePingDelay) .detail("StartDelay", startDelay);
															#line 18680 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			try {
															#line 2784 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				StrictFuture<Void> __when_expr_6 = quietDatabase(cx, dbInfo, "Start") || (databasePingDelay == 0.0 ? Never() : testDatabaseLiveness(cx, databasePingDelay, "QuietDatabaseStart", startDelay));
															#line 2784 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1cont16cont1Catch1(actor_cancelled(), loopDepth);
															#line 18686 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont16cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont16cont1when1(__when_expr_6.get(), loopDepth); };
				static_cast<RunTestsActor*>(this)->actor_wait_state = 7;
															#line 2784 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 6, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 18691 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont16cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont16cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont16cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont2(int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont16cont4(int loopDepth) 
	{
															#line 2815 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		connectionFailuresDisableDuration = 0.0;
															#line 2816 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (!tests.empty() && tests[0].simConnectionFailuresDisableDuration > 0)
															#line 18806 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2817 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			connectionFailuresDisableDuration = tests[0].simConnectionFailuresDisableDuration;
															#line 18810 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2820 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (connectionFailuresDisableDuration > 0)
															#line 18814 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2822 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			disableConnectionFailures("Tester", ForceDisable::True, connectionFailuresDisableDuration);
															#line 18818 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2824 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			enableConnectionFailures("Tester", FLOW_KNOBS->SIM_SPEEDUP_AFTER_SECONDS);
															#line 2825 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			disabler = disableConnectionFailuresAfter(FLOW_KNOBS->SIM_SPEEDUP_AFTER_SECONDS, "Tester");
															#line 18826 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2827 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		repairDataCenter = Future<Void>();
															#line 2828 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (useDB)
															#line 18832 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2830 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			Future<Void> reconfigure = reconfigureAfter(cx, FLOW_KNOBS->SIM_SPEEDUP_AFTER_SECONDS, dbInfo, "Tester");
															#line 2831 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			repairDataCenter = reconfigure;
															#line 18838 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
															#line 2834 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		TraceEvent("TestsExpectedToPass").detail("Count", tests.size());
															#line 2835 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		idx = 0;
															#line 2836 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		knobProtectiveGroup = std::unique_ptr<KnobProtectiveGroup>();
															#line 2837 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		;
															#line 18848 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		loopDepth = a_body1cont16cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont5(int loopDepth) 
	{
															#line 2793 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (perpetualWiggleEnabled)
															#line 18857 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2794 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("Set perpetual_storage_wiggle=1 ...\n");
															#line 2795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Version> __when_expr_7 = setPerpetualStorageWiggle(cx, true, LockAware::True);
															#line 2795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18865 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont16cont5when1(__when_expr_7.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 8;
															#line 2795 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 7, Version >*>(static_cast<RunTestsActor*>(this)));
															#line 18870 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont16cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2789 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			TraceEvent("QuietDatabaseStartExternalError").error(e);
															#line 2790 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 18887 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RunTestsActor*>(this)->actor_wait_state > 0) static_cast<RunTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunTestsActor*>(this)->ActorCallback< RunTestsActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont16cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont16cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont16cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RunTestsActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont16cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont16cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont16cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RunTestsActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTests", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont16cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont16cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont16cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTests", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont16cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont16cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont8(int loopDepth) 
	{
															#line 2800 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
		if (backupWorkerEnabled)
															#line 19001 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
		{
															#line 2801 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			printf("Enabling backup worker ...\n");
															#line 2802 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			StrictFuture<Void> __when_expr_8 = enableBackupWorker(cx);
															#line 2802 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			if (static_cast<RunTestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19009 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont16cont8when1(__when_expr_8.get(), loopDepth); };
			static_cast<RunTestsActor*>(this)->actor_wait_state = 9;
															#line 2802 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/fdbserver/tester.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunTestsActor, 8, Void >*>(static_cast<RunTestsActor*>(this)));
															#line 19014 "/codebuild/output/src3091928138/src/github.com/apple/foundationdb/build_output/fdbserver/tester.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont16cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont16cont9(Version const& cVer,int loopDep